package netfu;

import netfu.selectors.*;
import netfu.types.*;
import netfu.*;
import java.applet.*;
import java.awt.*;
import java.net.*;
import java.io.*;
import java.util.*;

public class ScriptFu extends Applet implements Selector
{
public boolean launched = false;
public Image imageOfBeavis;

public ScriptFu ()
  {
  }

  /** Get information about available scripts from the server. */
public void loadScriptInfo ()
  {
  }

public void start ()
  {
    if (!launched)
      {
	this.setBackground (Color.white);
	selectValue (getParameter("script_name"));
	launched=true;
      }
  }

public void stop ()
  {
  }

public Object selectedValue ()
  {
    return new Object ();
  }

public void selectValue (Object o)
  {
    ParametersList param_list = new ParametersList ();
    Script script;
    String num_args;
    int i, num_params;

    System.out.println ("Creating script: " + (String) o + " from applet arguments.");

    if ((num_args = getParameter ("num_args")) == null)
      {
	System.out.println ("Incorrect arguments specified to applet.");
	System.out.println ("Need: script_name, script_desc, num_args, " +
			    "name<i>, type<i>, default<i>");
	return;
      }

    num_params = Integer.parseInt (num_args);
    System.out.println ("Got " + num_params + " arguments");

    for (i = 0; i < num_params; i++)
      {
	String name_param = "name" + i;
	String field_name = getParameter (name_param);

	String type_param = "type" + i;
	String field_type = getParameter (type_param);

	String default_param = "default" + i;
	String field_default = getParameter (default_param);

	if (field_name == null || field_type == null || field_default == null)
	  {
	    System.out.println ("Incorrect specification of arguments to applet!");
	    System.out.println ("Foreach argument, name, type & default must be specified.");
	    return;
	  }

	System.out.println ("name: " + field_name + ", type: " + field_type +
			    ", default: " + field_default);
	param_list.addParam (new Parameter (field_name, field_type, field_default));
      }
    script = new Script ((String) o, getParameter ("script_desc"), param_list);

    this.add(new ArgumentsListSelector(script, this));
    this.show ();
  }

public Component component ()
  {
    return this;
  }

}
