;  CHROME-LOGOS (For Net-Fu)

(define (net-fu-chrome-logo text size font text-color bg-color)
  (let* ((img (car (gimp-image-new 256 256 RGB)))
	 (b-size (* size 0.2))
	 (offx1 (* size 0.04))
	 (offy1 (* size 0.03))
	 (offx2 (* size (- 0.04)))
	 (offy2 (* size (- 0.03)))
	 (feather (* size 0.05))
	 (text-layer (car (gimp-text img -1 0 0 text b-size TRUE size PIXELS "*" font "*" "*" "*" "*")))
	 (width (car (gimp-drawable-width text-layer)))
	 (height (car (gimp-drawable-height text-layer)))
	 (layer1 (car (gimp-layer-new img width height RGBA_IMAGE "Layer 1" 100 DIFFERENCE)))
	 (layer2 (car (gimp-layer-new img width height RGBA_IMAGE "Layer 2" 100 DIFFERENCE)))
	 (layer3 (car (gimp-layer-new img width height RGBA_IMAGE "Layer 3" 100 NORMAL)))
	 (shadow (car (gimp-layer-new img width height RGBA_IMAGE "Drop Shadow" 100 NORMAL)))
	 (background (car (gimp-layer-new img width height RGB_IMAGE "Background" 100 NORMAL)))
	 (layer-mask (car (gimp-layer-create-mask layer1 BLACK-MASK)))
	 (final-layer 0)
	 (filename "")
	 (old-fg (car (gimp-palette-get-foreground)))
	 (old-bg (car (gimp-palette-get-background))))
    (gimp-image-disable-undo img)
    (gimp-image-resize img width height 0 0)
    (gimp-image-add-layer img background 1)
    (gimp-image-add-layer img shadow 1)
    (gimp-image-add-layer img layer3 1)
    (gimp-image-add-layer img layer2 1)
    (gimp-image-add-layer img layer1 1)
    (gimp-palette-set-background '(255 255 255))
    (gimp-selection-none img)
    (gimp-edit-fill img layer1)
    (gimp-edit-fill img layer2)
    (gimp-edit-fill img layer3)
    (gimp-edit-clear img shadow)
    (gimp-selection-layer-alpha img text-layer)
    (gimp-layer-set-visible text-layer FALSE)
    (gimp-layer-set-visible shadow FALSE)
    (gimp-layer-set-visible background FALSE)
    (gimp-palette-set-background '(0 0 0))
    (gimp-edit-fill img layer1)
    (gimp-selection-translate img offx1 offy1)
    (gimp-selection-feather img feather)
    (gimp-edit-fill img layer2)
    (gimp-selection-translate img (* 2 offx2) (* 2 offy2))
    (gimp-edit-fill img layer3)
    (gimp-selection-none img)
    (set! layer1 (car (gimp-image-merge-visible-layers img CLIP-TO-IMAGE)))
    (gimp-invert img layer1)
    (gimp-selection-all img)
    (gimp-palette-set-background text-color)
    (gimp-bucket-fill img layer1 BG-BUCKET-FILL COLOR 100 0 FALSE 0 0)
    (gimp-image-add-layer-mask img layer1 layer-mask)
    (gimp-selection-layer-alpha img text-layer)
    (gimp-palette-set-background '(255 255 255))
    (gimp-selection-feather img feather)
    (gimp-edit-fill img layer-mask)
    (gimp-palette-set-background '(0 0 0))
    (gimp-selection-translate img offx1 offy1)
    (gimp-edit-fill img shadow)
    (gimp-selection-none img)
    (gimp-palette-set-background bg-color)
    (gimp-edit-fill img background)
    (gimp-image-remove-layer img text-layer)
    (gimp-layer-set-visible shadow TRUE)
    (gimp-layer-set-visible background TRUE)
    (gimp-layer-set-name layer1 text)
    (gimp-palette-set-foreground old-fg)
    (gimp-palette-set-background old-bg)

    (set! final-layer (car (gimp-image-flatten img)))
    (gimp-levels img final-layer 0 0 255 1.6 0 255)
    (set! filename (car (gimp-temp-name "jpg")))
    (file-jpeg-save 1 img final-layer filename filename 0.7 0 TRUE)

    (gimp-image-enable-undo img)
    (gimp-image-delete img)
    filename))
