/****************************************************************************/
/*                                                                          */
/*  The FreeType project -- a free and portable quality TrueType renderer.  */
/*                                                                          */
/*  E. Dieterich                                                            */
/*                                                                          */
/*  fterrtest: test errstr functionality.                                   */
/*                                                                          */
/****************************************************************************/


#include "freetype.h"
#include "errstr18.h"
#include "ft_conf.h"

#include <stdio.h>

#ifdef HAVE_LOCALE_H
#include <locale.h>
#endif
 
#ifdef HAVE_LIBINTL_H
#include <libintl.h>
#endif

#ifndef HAVE_LIBINTL
#define gettext( x )  ( x )
#endif


  void  main( void )
  {
    int    i;
    char*  domain;


#ifdef HAVE_LIBINTL
    setlocale( LC_ALL, "" );
    bindtextdomain( "freetype", LOCALEDIR );
    domain = textdomain( "freetype" );
#endif

#if 0
    printf( "domain: %s\n", domain = textdomain( "" ) );
#endif
    printf( gettext("Start of fterrtest.\n" ) );

    for ( i = 0; i < 10; i++ )
      printf( "Code: %i, %s\n", i, TT_ErrToString18( i ) );

#if 0
    printf( "domain: %s\n", domain = textdomain( "" ) );
#endif
    printf( gettext( "End of fterrtest.\n" ) );

    exit( 0 );
  }


/* End */
