# This file is part of the FreeType project
#
# This builds the test programs with the Watcom compiler
#
# You'll need Watcom's wmake
#
# Invoke by "wmake -f arch\os2\Makefile.wat" when in the "test" directory

.EXTENSIONS:
.EXTENSIONS: .exe .obj .c .h
.obj:.
.c:.
.h:.;..\lib

ARCH = arch\os2

CC = wcl386

LIBDIR  = ..\lib
INCDIRS = -I$(LIBDIR) -I$(LIBDIR)\arch\os2 -I$(LIBDIR)\extend
LIBFILE = $(LIBDIR)\libttf.lib

LINK_OPTS = 

OBJ_CFLAGS = /c /otexanl+ /s /w4 /zq $(INCDIRS)

CCFLAGS = /otexanl+ /s /w4 /zq $(INCDIRS)

GFSDRIVER = $(ARCH)\gfs_os2.obj
GFSDRIVER_SRC = $(ARCH)\gfs_os2.c

GPMDRIVER = $(ARCH)\gpm_os2.obj
GPMDRIVER_SRC = $(ARCH)\gpm_os2.c
GPMDRIVER_DEF = gpm_os2.def

DISPLAYSRC = display.c

SRC = gmain.c display.c &
      fttimer.c  ftview.c  ftlint.c  ftzoom.c  ftdump.c  ftstring.c &
      $(GPMDRIVER_SRC) $(GFSDRIVER_SRC)

# graphics utility and test driver

all : ftview.exe ftviewfs.exe fttimer.exe fttimefs.exe   &
      ftlint.exe  ftdump.exe  ftstring.exe  ftstrfs.exe  &
      ftzoom.exe  ftzoomfs.exe

fs:   ftviewfs.exe  fttimefs.exe  ftlint.exe  ftzoomfs.exe ftstrfs.exe

pm:   ftview.exe  fttimer.exe  ftlint.exe  ftzoom.exe  ftstring.exe

$(LIBFILE):
  cd ..\lib
  wmake -h -f arch\os2\makefile.wat    
  cd ..\test

# implicit rules
#
.c.obj :
  $(CC) $(OBJ_CFLAGS) $[* /fo=$[*.obj


# the full-screen graphics driver
#
$(GFSDRIVER): $(GFSDRIVER_SRC)
    $(CC) $(OBJ_CFLAGS) $[*.c /fo=$[*.obj

# the pm graphics driver
#
$(GPMDRIVER): $(GPMDRIVER_SRC)
    $(CC) $(OBJ_CFLAGS) $[*.c /fo=$[*.obj

GFSOBJS = gmain.obj $(GFSDRIVER)
GPMOBJS = gmain.obj $(GPMDRIVER)

PM = $(LIBFILE) $(GPMOBJS) common.obj
FS = $(LIBFILE) $(GFSOBJS) common.obj

DISP = display.obj

ftzoom.exe : ftzoom.obj $(LIBFILE) $(PM) $(ARCH)\$(GPMDRIVER_DEF)
    $(CC) $(CCFLAGS) -l=os2v2_pm $(PM) $[*.c /fe=$[*.exe

ftzoomfs.exe : ftzoom.obj $(LIBFILE) $(FS)
    $(CC) $(CCFLAGS) $(FS) $[@ /fe=$^*.exe

ftview.exe : ftview.obj $(LIBFILE) $(PM) $(DISP) $(ARCH)\$(GPMDRIVER_DEF)
    $(CC) $(CCFLAGS) -l=os2v2_pm $(PM) $(DISP) $[*.c /fe=$[*.exe

ftviewfs.exe : ftview.obj $(LIBFILE) $(FS) $(DISP)
    $(CC) $(CCFLAGS) $(FS) $(DISP) $[*.c /fe=ftviewfs.exe

ftstring.exe : ftstring.obj $(LIBFILE) $(PM) $(ARCH)\$(GPMDRIVER_DEF)
    $(CC) $(CCFLAGS) -l=os2v2_pm $(PM) $(DISP) $[*.c /fe=$[*.exe 

ftstrfs.exe : ftstring.obj $(LIBFILE) $(FS) $(DISP)
    $(CC) $(CCFLAGS) $(FS) $(DISP) $[*.c /fe=ftstrfs.exe

fttimer.exe: fttimer.obj $(LIBFILE) $(PM) $(ARCH)\$(GPMDRIVER_DEF)
    $(CC) $(CCFLAGS) -l=os2v2_pm $(PM) $[*.c /fe=$[*.exe

fttimefs.exe: fttimer.obj $(LIBFILE) $(FS)
    $(CC) $(CCFLAGS) $(FS) $[*.c /fe=fttimefs.exe

ftlint.exe: ftlint.obj $(LIBFILE)
    $(CC) $(CCFLAGS) $(LIBFILE) common.obj $[*.c /fe=$[*.exe

ftdump.exe: ftdump.obj $(LIBFILE)
    $(CC) $(CCFLAGS) $(LIBFILE) common.obj -I..\lib\arch\os2 $[*.c /fe=$[*.exe

clean: .symbolic
         @-erase *.obj
         @-erase arch\os2\*.obj

distclean: .symbolic  clean
         @-erase *.exe
         @-erase *.err
         cd ..\lib
         wmake -h -f arch\os2\makefile.wat distclean
         cd ..\test

new: .symbolic
        @-wtouch *.c

# end of Makefile.wat
