/*
 *   errormsg.c
 *
 *   This file is part of the ttf2pk package.
 *
 * Copyright 1997-1998 by
 *      Frederic Loyer <loyer@ensta.fr>
 *      Werner Lemberg <a7971428@unet.univie.ac.at>
 */

#include <stdio.h>
#include <stdarg.h>


extern char progname[];         /* the origin of the error/warning message */


/*
 *   Print error message and quit.
 */

void
oops(const char *message, ...)
{
  va_list args;


  va_start(args, message);
  fprintf(stderr, "%s: ERROR: ", progname);
  vfprintf(stderr, message, args);
  va_end(args);
  putc('\n', stderr);

  exit(1);
}


/*
 *   Print warning message and continue.
 */

void
warning(const char *message, ...)
{
  va_list args;


  va_start(args, message);
  fprintf(stderr, "%s: WARNING: ", progname);
  vfprintf(stderr, message, args);
  va_end(args);
  putc('\n', stderr);
}


/* end */
