/* ttf.h -- header file that defines the top level abstraction of a True Type font, as 
 * well as the usual typedefs in TTF spec.
 * Copyright (C) 1996 Li-Da Lho, All right reserved.
 */
#ifndef __TTF_H
#define __TTF_H

#include <stdio.h>
#include "config.h"

/* 	$Id: ttf.h,v 1.2 1996/12/28 12:31:50 ollie Exp ollie $	 */

typedef unsigned char BYTE;
typedef signed char CHAR;
typedef unsigned short USHORT;
typedef signed short SHORT;


#if SIZEOF_INT==4
typedef unsigned int ULONG;
typedef signed int LONG;
typedef ULONG Fixed;    /* 16.16 fixed point number used for version information */
#elif SIZEOF_LONG==4
typedef unsigned long ULONG;
typedef signed long LONG;
typedef ULONG Fixed;    /* 16.16 fixed point number used for version information */
#endif

typedef USHORT FUnit;
typedef SHORT FWord;    /* pixel position in the unit of FUnit */
typedef USHORT uFWord;
typedef SHORT F2Dot14;  /* 2.14 fixed point number used for unit vectors */
typedef LONG F26Dot6;   /* 26.6 fixed point number to specify pixel position */

#ifndef inline
extern inline BYTE ttfGetBYTE(FILE *fp)
{
    int cc;
    if ((cc = fgetc(fp)) == EOF)
	{
	    /*if (feof(fp) != 0)
		ttfError("Unexpected EOF \n");
	    else
		ttfError("Error Getting BYTE\n");*/
	}
    return (BYTE) cc;
}
#endif

CHAR ttfGetCHAR(FILE *fp);
USHORT ttfGetUSHORT(FILE *fp);
USHORT ttfGetSHORT(FILE *fp);
ULONG ttfGetULONG(FILE *fp);
LONG ttfGetLONG(FILE *fp);
Fixed ttfGetFixed(FILE *fp);
FUnit ttfGetFUnit(FILE *fp);
FWord ttfGetFWord(FILE *fp);
uFWord ttfGetuFWord(FILE *fp);
F2Dot14 ttfGetF2Dot14(FILE *fp);

short ttfGetLSB16(FILE *fp);
int ttfGetLSB32(FILE *fp);

#include "tables.h"
#include "gcache.h"
#include "gstate.h"

typedef struct {
    BYTE opcode;
    BYTE * iStream;
} InstructionDef;

typedef struct {
    BYTE fun;
    BYTE * iStream;
} FunctionDef;

typedef struct {
    /* data for instructions */
    BYTE * iStream;            /* instruction stream */
    USHORT ip;                 /* instruction pointer */
    USHORT insLength;          /* instruction length */
    LONG *StorageArea;         /* storage area */
    LONG *Stack;               /* stack */
    USHORT sp;                 /* stack pointer */
    USHORT stklimit;           /* stack limit */
    /* data about point size and resolution */
    ULONG ppem;                /* pixel per em */
    ULONG xres;                /* x resolution in dpi */
    ULONG yres;                /* y resolution in dpi */
    F26Dot6 pointsize;         /* the point size of the font */
    /* data for grahpics stat and cvt */
    F26Dot6 * cvt;             /* Control value table, scaled form cvt in 
				* TTFont */
    GraphicsState gstate;      /* graphics state used for instructions */
    GraphicsState gstate_init; /* initial graphics state after fpgm and cvt 
				* program are executed */
    /* user definded instructions and functions */
    /* InstructionDef iDef;  instruction definitions */
    /* FunctionDef    fDef;  function definitions */
    int Error_State;           /* error state indicate the error */
} VirtualMachine;

typedef struct {
    /* misc informations */
    FILE *fp;
    char *ttfname;
    int *refcount;           /* how many instances of this font */ 
    Fixed version;
    USHORT numTables;        /* it seems not necessary to hold all the 
			      * OffsetTable */
    ULONG glyphOffset;       /* where the glyph table starts */
    TableDirPtr dir;         /* Pointer to Table Directories */
    SubTablePtr encoding;    /* encoding is the currently used encoding 
			      * table */ 
    USHORT numCacheElements; /* number of glyph cache elements */

    VirtualMachine vm;       /* the virtual machine */

    GlyphCachePtr gcache;    /* pointer to glyph cache */

    /* required tables below */
    CMAPPtr cmap;
    HEADPtr head;
    HHEAPtr hhea;
    HMTXPtr hmtx;
    LOCAPtr loca;
    MAXPPtr maxp;
    NAMEPtr name;
    POSTPtr post;
    OS_2Ptr os2;

    /* optional tables below */
    FWord * cvt;             /* control value table, not scaled yet */
    USHORT cvtLength;        /* number of FWords of CVT */
    BYTE * fpgm;             /* font program */
    USHORT fpgmLength;       /* number of bytes of fpgm */
    BYTE * prep;             /* cvt program */
    USHORT prepLength;       /* number of bytes of prep */

    /* those optional tables seem to be not necessary for True Type font
     * server */
    GASPPtr gasp;
    HDMXPtr hdmx;
    KERNPtr kern;
    LTSHPtr ltsh;
    PCLTPtr pclt;
    VDMXPtr vdmx;
    VHEAPtr vhea;
    VMTXPtr vmtx;
} TTFont, *TTFontPtr;

TTFontPtr ttfInitFont(char *filename);
void ttfLoadFont(TTFontPtr font, ULONG offset);
void ttfFreeFont(TTFontPtr font);

#include "loadtable.h"

#endif
