#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <magick/ImageMagick.h>
#include <ch.h>

/* Structures taken from splay-tree.c */

typedef struct _NodeInfo
{
  void
    *key;

  void
    *value;

  struct _NodeInfo
    *left,
    *right;
} NodeInfo;

struct _SplayTreeInfo
{
  NodeInfo
    *root;

  int
    (*compare)(const void *,const void *);

  void
    *(*relinquish_key)(void *),
    *(*relinquish_value)(void *);

  unsigned long
    depth;

  MagickBooleanType
    balance;

  void
    *key,
    *next;

  unsigned long
    nodes;

  MagickBooleanType
    debug;

  SemaphoreInfo
    *semaphore;

  unsigned long
    signature;
};

typedef int (*compare)(const void *,const void *);
typedef void *(*relinquish_key)(void *);
typedef void *(*relinquish_value)(void *);

static ChInterp_t interp;
static void *compare_funptr;
static void *relinquish_key_funptr;
static void *relinquish_value_funptr;

static int compare_funarg(const void *arg1, const void *arg2);
static void *relinquish_key_funarg(void *arg);
static void *relinquish_value_funarg(void *arg);

EXPORTCH SplayTreeInfo *NewSplayTree_chdl(void *varg) {
    compare compare_func;
    relinquish_key relinquish_key_func;
    relinquish_value relinquish_value_func;
    ChVaList_t ap;
    SplayTreeInfo *retval;

    Ch_VaStart(interp, ap, varg);

    compare_func = Ch_VaArg(interp, ap, compare);
    if(compare_func != NULL)
    {
       compare_funptr = (void *)compare_func; 
       compare_func = (compare)compare_funarg;
    }

    relinquish_key_func = Ch_VaArg(interp, ap, relinquish_key);
    if(relinquish_key_func != NULL)
    {
       relinquish_key_funptr = (void *)relinquish_key_func; 
       relinquish_key_func = (relinquish_key)relinquish_key_funarg;
    }

    relinquish_value_func = Ch_VaArg(interp, ap, relinquish_value);
    if(relinquish_value_func != NULL)
    {
       relinquish_value_funptr = (void *)relinquish_value_func; 
       relinquish_value_func = (relinquish_value)relinquish_value_funarg;
    }

    retval = NewSplayTree(compare_func, 
			  relinquish_key_func,
		          relinquish_value_func);
    Ch_VaEnd(interp, ap);
    return retval;
}

static int compare_funarg(const void *arg1, const void *arg2)
{
	int retval;
	Ch_CallFuncByAddr(interp, &retval, compare_funptr, arg1, arg2);
	return retval;
}

static void *relinquish_key_funarg(void *arg)
{
	void *retval;
	Ch_CallFuncByAddr(interp, &retval, relinquish_key_funptr, arg);
	return retval;
}

static void *relinquish_value_funarg(void *arg)
{
	void *retval;
	Ch_CallFuncByAddr(interp, &retval, relinquish_value_funptr, arg);
	return retval;
}
