#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <magick/ImageMagick.h>
#include <ch.h>

/* Structures taken from hashmap.h */
 
typedef struct _ElementInfo
{
  void
    *value;

  struct _ElementInfo
    *next;
} ElementInfo;

struct _LinkedListInfo
{
  unsigned long
    capacity,
    elements;

  ElementInfo
    *head,
    *tail,
    *next;

  MagickBooleanType
    debug;

  SemaphoreInfo
    *semaphore;

  unsigned long
    signature;
};

typedef int (*compare)(const void *,const void *);

static ChInterp_t interp;
static void *compare_funptr;
static int compare_funarg(const void *arg1, const void *arg2);

EXPORTCH MagickBooleanType InsertValueInSortedLinkedList_chdl(void *varg) {
    LinkedListInfo *list_info;
    compare compare_func;
    void **replace;
    void *value;
    ChVaList_t ap;
    MagickBooleanType retval;

    Ch_VaStart(interp, ap, varg);

    list_info = Ch_VaArg(interp, ap, LinkedListInfo *);

    compare_func = Ch_VaArg(interp, ap, compare);
    if(compare_func != NULL)
    {
       compare_funptr = (void *)compare_func; 
       compare_func = (compare)compare_funarg;
    }

    replace = Ch_VaArg(interp, ap, void **);

    value = Ch_VaArg(interp, ap, void *);

    retval = InsertValueInSortedLinkedList(list_info, 
		                           compare_func,
					   replace,
					   value);
    Ch_VaEnd(interp, ap);
    return retval;
}

static int compare_funarg(const void *arg1, const void *arg2)
{
	int retval;
	Ch_CallFuncByAddr(interp, &retval, compare_funptr, arg1, arg2);
	return retval;
}
