/* # skkinput (Simple Kana-Kanji Input)
 * skkmbuf.c --- mini-buffer
 * This file is part of skkinput.
 * Copyright (C) 1997
 * Takashi SAKAMOTO (sakamoto@yajima.kuis.kyoto-u.ac.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with skkinput; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#include "skkel.h"

/* skkmarker.c */
static void markers_init( struct SKKInputNode *node ) ;
static int make_marker
( struct SKKInputNode *node, int *marker, int flag ) ;
/* skkwin.c */
static void skkinput_ClearMinibuffer( Widget gw ) ;

/*
 * skkinput $B$N2>L>4A;zJQ49$K4X$9$kItJ,$K$D$$$F$N=i4|2=$r9T$&4X?t!#(B
 *-----
 * $B%+!<%=%k0LCV$N=i4|2=$H$+$=$NB>!#(B
 */
static void skkinput_SkkInputNodeInit( struct SKKInputNode *node )
{
  /* $B%^!<%+!<(B($B!)(B)$B$r=i4|2=$9$k!#%^!<%+!<$O(B emacs-lisp $B$N%^!<%+!<$N<BAu(B *
   * $B$G$"$k!#Hs>o$K2x$7$$<BAu$G$"$k$,!D!#(B*/
  markers_init( node ) ;

  /* $B2>L>4A;zJQ492s$j$G$N%0%m!<%P%kJQ?t$N=i4|2=!#(B*/
  node->cur_pos            = 0 ;
  node->cur_pos2           = 0 ;
  node->cur_pos3           = 0 ;
  node->cur_pos_backup     = 0 ;
  node->cur_pos_top        = 0 ;
  make_marker( node, &( node->cur_pos ), 1 ) ;
  make_marker( node, &( node->cur_pos2 ), 1 ) ;
  make_marker( node, &( node->cur_pos3 ), 1 ) ;
  make_marker( node, &( node->cur_pos_backup ), 1 ) ;
  node->j_henkan_mode      = False ;
  node->j_henkan_on        = False ;
  node->j_okurigana_mode   = False ;
  node->j_kana_mode        = False ;
  node->j_katakana_mode    = False ;
  node->j_mode             = True ;
  node->j_abbrev           = False ;
  node->j_zenkaku          = False ;
  node->j_henkan_show_candidate_mode = False ;
  node->j_input_by_code_or_menu_mode = False ;
  node->j_minibuff_usage   = J_MINIBUFF_NOT_USING ;

  node->textbuffer[ 0 ]   = '\0' ;
  node->mtextbuffer[ 0 ]  = '\0' ;
  node->j_num_list[ 0 ]   = '\0' ;
  node->j_prefix[ 0 ]     = '\0' ;

  node->j_okurigana_start_point = -1 ;
  make_marker( node, &( node->j_okurigana_start_point ), 0 ) ;
  node->j_kana_start_point      = -1 ;
  make_marker( node, &( node->j_kana_start_point ), 0 ) ;
  node->j_henkan_start_point    = -1 ;
  make_marker( node, &( node->j_henkan_start_point ), 0 ) ;
  node->j_henkan_end_point      = -1 ;
  make_marker( node, &( node->j_henkan_end_point ), 0 ) ;
  node->j_input_by_code_or_menu_point = -1 ;
  make_marker( node, &( node->j_input_by_code_or_menu_point ), 0 ) ;

  /* $B%f!<%6$,<+M3$K@_Dj$G$-$k%^!<%+$N=i4|2=!#(B*/
  node->mark_pos           = -1 ;
  make_marker( node, &( node->mark_pos ), 0 ) ;

  node->j_henkan_vector_top               = NULL ;
  node->j_henkan_vector_index_top         = NULL ;
  node->j_current_henkan_vector_index     = NULL ;
  node->j_henkan_vector_index_length      = 0 ;

  node->j_completion_vector_top           = NULL ;
  node->j_completion_vector_index_top     = NULL ;
  node->j_current_completion_vector_index = NULL ;
  node->j_completion_mode                 = False ;

  node->prev_cx = node->prev_cy = -1 ;
  node->prev_start_pos     = 0 ;

  return ;
}

/*
 * minibuffer $BMQ$N%N!<%I$r?7$7$/3NJ]$9$k4X?t!#(B
 */
static struct SKKInputNode *skkinput_AllocateMinibuffer( void )
{
  struct SKKInputNode *node ;

  node = ( struct SKKInputNode *)malloc( sizeof( struct SKKInputNode ) ) ;
  if( node == NULL ){
    fprintf( stderr, "Fatal error .... Memory exhausted.\n" ) ;
    exit( 1 ) ;
  }
  node->parentbuffer = NULL ;
  node->minibuffer   = NULL ;
  skkinput_SkkInputNodeInit( node ) ;
  return node ;
}

/*
 * mini-buffer $B$r2rJ|$9$k4X?t!#(B
 */
static void free_Minibuffer
( Widget gw, struct SKKInputNode *node )
{
  SkkInputWidget w = ( SkkInputWidget )gw ;

  if( node->parentbuffer != NULL ){
    /* $B?F$N;R6!$O<+J,$N;R6!!#(B*/
    ( node->parentbuffer )->minibuffer = node->minibuffer ;
  } else {
    /* $B0lHV:G=i$r>o$K;X$9$h$&$K$7$J$1$l$P$J$i$J$$$N$G!"@hF,$,2rJ|$5(B *
     * $B$l$?$i=$@5!#(B*/
    w->skkinput.topbuffer = node->minibuffer ;
  }
  /* $B$"$j$($J$$$H;W$&$1$I!"<+J,$K;R6!$,$"$C$?$i!"$=$N;R6!$N?F$O<+J,(B *
   * $B$N?F!#(B*/
  if( node->minibuffer != NULL ){
    ( node->minibuffer )->parentbuffer = node->parentbuffer ;
    /* $B$3$N%N!<%I$,0lHV;R6!$8$c$J$$$N$@$+$i!"(Bw->skkinput.lastbuffer $B$r=$(B *
     * $B@5$9$kI,MW$O$J$$!#(B*/
  } else {
    /* $B0lHV:G8e$r>o$K;X$9$h$&$K$7$F$*$/!#(B*/
    w->skkinput.lastbuffer = node->parentbuffer ;
  }
  /* $BJQ49=*N;=hM}$r8F=P$9!#(B*/
  XtCallCallbacks( gw, XtNjhenkanendNotify, node ) ;
  /* $B%3%s%W%j!<%7%g%s$NESCf$G$"$C$?$J$i!"$=$N%a%b%j$r2rJ|$9$k!#(B*/
  XtCallCallbacks( gw, XtNjcompletioncloseNotify, node ) ;
  /* $B<+J,$r2rJ|$9$k!#(B*/
  free( node ) ;
}

/*
 * $B%_%K%P%C%U%!L5$$$G$N2>L>4A;zJQ49$r9T$&$?$a$N=i4|2=$r9T$&4X?t!#(B
 */
static int skkinput_j_henkan_in_minibuff_init
( Widget gw, struct SKKInputNode *node )
{
  SkkInputWidget w = ( SkkInputWidget )gw ;
  struct SKKInputNode *mNode ;
#if 0
  int ret ;
#endif

#ifdef DEBUG
  /* $BEO$5$l$?%P%C%U%!Fb$K%+!<%=%k$,L5$$!"$b$7$/$O!"$=$3$K4{$KJQ49MQ$N(B *
   * $B%_%K%P%C%U%!$,$"$k!D$N$OJQ$G$"$k!#$"$C$F$O$J$i$J$$;vBV$G$"$m$&!#(B */
  if( !node->cur_exist || node->minibuffer != NULL ){
    fprintf( stderr, "*** Warning *** : I miss your cursor.\n" ) ;
    return ;
  }
#endif
  /* $B?7$7$/%P%C%U%!$r3NJ]$9$k!#(B*/
  mNode = skkinput_AllocateMinibuffer() ;
  mNode->parentbuffer = node ;
  node->minibuffer = w->skkinput.lastbuffer = mNode ;

  /* $B%P%C%U%!$,$"$U$l$J$$$h$&$K%-!<$r%3%T!<$9$k!#(B*/
  if( node->j_num_list[ 0 ] != '\0' ){
    strncpy( mNode->textbuffer, node->j_search_key,  TEXTMAXLEN - 1 ) ;
  } else {
    strncpy( mNode->textbuffer, node->j_henkan_key2, TEXTMAXLEN - 1 ) ;
  }
  mNode->textbuffer[ TEXTMAXLEN - 1 ] = '\0' ;
  strcat ( mNode->textbuffer, " " ) ;
  mNode->textbuffer[ TEXTMAXLEN ] = '\0' ;

  /* $B=i4|%+!<%=%k0LCV5Z$S%+!<%=%k$N:G>.0LCV$N@_Dj!#(B*/
  mNode->cur_pos_top = mNode->cur_pos = strlen( mNode->textbuffer ) ;

  /* $B%P%C%U%!4V$G$N%+!<%=%k0\F0!#(B*/
  node->cur_exist  = False ;
  mNode->cur_exist = True ;
  /* $B2<$N(B j-read-string $B$H6hJL$9$k$N$KI,MW!#?F$KBP$9$k(B action $B$,0c$&!#(B*/
  mNode->j_minibuff_usage = J_HENKAN_IN_MINIBUFF_MODE ;

  /* $B%_%K%P%C%U%!Fb$K0JA0I=<($5$l$F$$$?$b$N$r>C5n$9$k!#(B*/
  skkinput_ClearMinibuffer( gw ) ; 

  return 0 ;
}

/*
 * minibuffer $B$+$iJ8;zNs$rF~NO$5$;$k4X?t!#(B
 *---------
 * $BJ8;zNs$NF~NO$,=*N;$9$k$H!"$3$N4X?t$X(B longjmp $B$GLa$C$F$/$k$N$G$=$N;~(B
 * $B$K(B True $B$,JV$k$+$i8F=P$7B&$,J8;zNs$NF~NO$,40N;$7$?$N$@$HJ,$+$k!#(B
 * $BF~NO$5$l$?J8;zNs$O(B temporary_buffer $B$K0l;~E*$KJ]B8$5$l$k$N$G!"La$C(B
 * $B$F$-$?$i2D5ZE*B.$d$+$K;H$C$F$7$^$&$+JL$N$H$3$m$KJ]B8$7$^$7$g$&!#(B
 */
static int j_read_string
( Widget gw, struct SKKInputNode *node, char *string, int minibuff_usage )
{
  SkkInputWidget w = ( SkkInputWidget )gw ;
  struct SKKInputNode *mNode ;
#if 0
  int ret ;
#endif

#ifdef DEBUG
  /* $BEO$5$l$?%P%C%U%!Fb$K%+!<%=%k$,L5$$!"$b$7$/$O!"$=$3$K4{$KJQ49MQ$N(B *
   * $B%_%K%P%C%U%!$,$"$k!D$N$OJQ$G$"$k!#$"$C$F$O$J$i$J$$;vBV$G$"$m$&!#(B */
  if( !node->cur_exist || node->minibuffer != NULL ){
    fprintf( stderr, "*** Warning *** : I miss your cursor.\n" ) ;
    return ;
  }
#endif
  /* $B?7$7$/%P%C%U%!$r3NJ]$9$k!#(B*/
  mNode = skkinput_AllocateMinibuffer() ;
  mNode->parentbuffer = node ;
  node->minibuffer = w->skkinput.lastbuffer = mNode ;

  /* $B%P%C%U%!$,$"$U$l$J$$$h$&$K%-!<$r%3%T!<$9$k!#(B*/
  strncpy( mNode->textbuffer, string, TEXTMAXLEN ) ;
  mNode->textbuffer[ TEXTMAXLEN ] = '\0' ;

  /* $B=i4|%+!<%=%k0LCV5Z$S%+!<%=%k$N:G>.0LCV$N@_Dj!#(B*/
  mNode->cur_pos_top = mNode->cur_pos = strlen( mNode->textbuffer ) ;

  /* $B%P%C%U%!4V$G$N%+!<%=%k0\F0!#(B*/
  node->cur_exist  = False ;
  mNode->cur_exist = True ;
  mNode->j_minibuff_usage = minibuff_usage ;

  /* $B$3$N%b!<%I$G$O!"2>L>F~NO%b!<%I$O%G%U%)%k%H$G%*%U!#(B*/
  mNode->j_mode = False ;

  /* $B%_%K%P%C%U%!Fb$K0JA0I=<($5$l$F$$$?$b$N$r>C5n$9$k!#(B*/
  skkinput_ClearMinibuffer( gw ) ; 

  return 0 ;
}					
