/* SKK JISYO TOOLS (SKK dictionary handling tools)
version 1.0 of May 23, 1994
Copyright (C) 1994 Hironobu Takahashi, Masahiko Sato
This file is part of SKK

SKK JISYO TOOLS are free software; you can redistribute them and/or modify
them under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

SKK JISYO TOOLS are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with SKK; see the file COPYING.  If not, write to
the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */

/* skkjisyo-expr.c
   Υץ SKK μΥޡԤޤ
 */

#include <stdio.h>
#include <ndbm.h>
#include <errno.h>
#include <fcntl.h>

/* ΰեξ˽ʬʶʤСѹǤ礦 */
/*  #define TMPDIR "." */

#define TMPDIR "/tmp"

/* 1994 ǯǤ SKK ǤϺĹιԤǤ 656 ʸǤΤ
   ʲͤȤƤޤ*/

#define BUFLEN 4096

/* ѥե̾ */
char file_name[256];
/* ѥǡ١ */
DBM *db;

static void rm_file(fname)
     char *fname;
/* ե
   Υե뤬ʤƤ⤫ޤʤʳ꤬Хץ */
{
    if (unlink(fname) == -1)
	if (errno != ENOENT) {
	    perror(fname);
	    exit(1);
	}
}

static void rm_dbmfiles()
/* ѥǡ١ե
   file_name ϴطޤ󤬤ޤ路ΤǾäޤ
   */
{
    char pag_name[256];
    char dir_name[256];

    rm_file(file_name);
    sprintf(pag_name, "%s.pag", file_name);
    rm_file(pag_name);
    sprintf(dir_name, "%s.dir", file_name);
    rm_file(dir_name);
}

static void make_dbmfiles()
/* ǡ١ե */
{
    sprintf(file_name, "/tmp/skkjisyo.%d", getpid());
    rm_dbmfiles();
    if ((db = dbm_open(file_name, O_RDWR|O_CREAT, 0600)) == NULL){
	perror(file_name);
	exit(1);
    }
}

static int match_item(base, s, e)
     unsigned char *base;
     unsigned char *s;
     unsigned char *e;
/* base ʸ *s  *e ˶ޤ줿ʸ󤬤뤫ɤĴ٤
   0- ʤ  1-  */
{
    unsigned char *p, *q1, *q2;

    for (p = base; *p != '\0'; ++ p) {
	if (*p == *s) {
	    for(q1 = p+1, q2 = s+1; q2 <= e; ++ q1, ++ q2)
		if (*q1 != *q2) goto next;
	    return 1; /* matched */
	}
      next:;
    }
    return 0;
}

static void append_item(base, s, e)
     unsigned char *base;
     unsigned char *s;
     unsigned char *e;
/* base ʸ *s  *e ˶ޤ줿ʸɲ */
{
    unsigned char *p, *q;

    for (p = base; *p >= 0x20; ++ p);
    for (q = s+1; q <= e; ++ q, ++ p)
	*p = *q;
    *p = '\0';
}

static void add_content_line(base, new)
     unsigned char *base;
     unsigned char *new;
{
    unsigned char *s, *e;

    for(s = new; (0x20 <= *s); ++ s) {
	if (*s == '/') {
	    if (s[1] == '[') {
		for(; *s != ']'; ++ s)
		    if (*s < 0x20) return;
		goto next;
	    }
	    for(e = s+1; (0x20 <= *e); ++ e) {
		if (*e == '/') {
		    if (!match_item(base, s, e))
			append_item(base, s, e);
		    s = e-1;
		    goto next;
		}
	    }
	    return;
	}
      next:;
    }
}

static int item_number(p)
     unsigned char *p;
/* ĤΡֽפ뤫 */
{
    int n = 0;
    for (p++ ; *p >= 0x20; ++ p)
	if (*p == '/') ++ n;
    return n;
}

static int line_process(buffer, key, content)
     unsigned char *buffer;
     datum *key;
     datum *content;
{
    int key_len;
    static unsigned char content_buffer[BUFLEN];

    if ((buffer[0] == ';') || (buffer[0] == '\0')) return 0;
    for (key_len = 1;
	(buffer[key_len] != ' ') || (buffer[key_len+1] != '/');
	++ key_len)
	if (buffer[key_len] == '\0') return 0;
    key->dptr = buffer;
    key->dsize = key_len;

    content_buffer[0] = '/';
    content_buffer[1] = '\0';
    add_content_line(content_buffer, buffer+key_len+1);
    content->dptr = content_buffer;
    content->dsize = strlen(content_buffer);
    return item_number(content_buffer);
}

static void ustrncpy(tar, src, len)
     unsigned char *tar;
     unsigned char *src;
     int len;
{
    int i;

    for (i = 0; i < len; ++ i)
	tar[i] = src[i];
    tar[i] = '\0';
}

static void add_content(new, old, content)
     datum *new;
     datum old;
     datum content;
{
    static unsigned char add_buffer[BUFLEN];

    ustrncpy(add_buffer, old.dptr, old.dsize);
    (content.dptr)[content.dsize] = '\0';
    add_content_line(add_buffer, content.dptr);
    new->dptr = add_buffer;
    new->dsize = strlen(add_buffer);
}

static void add_file(srcname)
     char *srcname;
{
    static unsigned char buffer[BUFLEN];
    datum key, content, old, new;
    FILE *fp;

    if ((fp = fopen(srcname, "r")) == NULL) {
	perror(srcname);
	return;
    }
    while(fgets(buffer, BUFLEN, fp) != NULL) {
	if (line_process(buffer, &key, &content) > 0) {
	    old = dbm_fetch(db, key);
	    if (old.dptr == NULL) {
		dbm_store(db, key, content, DBM_REPLACE);
	    } else {
		add_content(&new, old, content);
		dbm_store(db, key, new, DBM_REPLACE);
	    }
	}
    }
    fclose(fp);
}

static void
delete_item(base, s, e)
     unsigned char *base;
     unsigned char *s;
     unsigned char *e;
/* base ʸ *s  *e ˶ޤ줿ʸ󤬤к */
{
    unsigned char *p, *q1, *q2;

    for (p = base; *p != '\0'; ++ p) {
	if (*p == *s) {
	    for(q1 = p+1, q2 = s+1; q2 <= e; ++ q1, ++ q2)
		if (*q1 != *q2) goto next;
	    /* matched */
	    for(q2 = p+1; *q1 != '\0'; ++ q1, ++ q2)
		*q2 = *q1;
	    *q2 = '\0';
	    return;
	}
      next:;
    }
}

static void
subtract_content_line(base, new)
     unsigned char *base;
     unsigned char *new;
/* base ʸ椫 new ʸ */
{
    unsigned char *s, *e;

    for(s = new; (0x20 <= *s); ++ s) {
	if (*s == '/') {
	    if (s[1] == '[') {
		for(; *s != ']'; ++ s)
		    if (*s < 0x20) return;
		goto next;
	    }
	    for(e = s+1; (0x20 <= *e); ++ e) {
		if (*e == '/') {
		    delete_item(base, s, e);
		    s = e-1;
		    goto next;
		}
	    }
	    return;
	}
      next:;
    }
}

static void subtract_content(new, old, content)
     datum *new;
     datum old;
     datum content;
/* ֽפӤƱΤк */
{
    static unsigned char subtract_buffer[BUFLEN];

    ustrncpy(subtract_buffer, old.dptr, old.dsize);
    (content.dptr)[content.dsize] = '\0';
    subtract_content_line(subtract_buffer, content.dptr);
    new->dptr = subtract_buffer;
    new->dsize = strlen(subtract_buffer);
}

static void subtract_file(srcname)
     char *srcname;
/* Ϳ̾μƤ򸽺ߤμ񤫤 */
{
    static unsigned char buffer[BUFLEN];
    datum key, content, old, new;
    FILE *fp;

    if ((fp = fopen(srcname, "r")) == NULL) {
	perror(srcname);
	return;
    }
    while(fgets(buffer, BUFLEN, fp) != NULL) {
	/* Ԥɤ(key)פȡֽ(content)פФ
	   ⤷⥳ȹǤФ */
	if (line_process(buffer, &key, &content) > 0) {
	    /* ˤǤˤФ줫롣ʤв⤷ʤ */
	    old = dbm_fetch(db, key);
	    if (old.dptr != NULL) {
		subtract_content(&new, old, content);
		if (new.dsize >= 3)
		    dbm_store(db, key, new, DBM_REPLACE);
		else
		    dbm_delete(db, key);
	    }
	}
    }
    fclose(fp);
}

static void type_out(output)
     FILE *output;
/* ̤
   ϤޤäΤǤˤʤΤǡǽŪʷ̤ˤ
   skkjisyo-sort Ѥ
   */
{
    datum key, content;
    int i;

    for (key = dbm_firstkey(db); key.dptr !=  NULL;  key = dbm_nextkey(db)) {
	content = dbm_fetch(db, key);
	for(i = 0; i < key.dsize; ++ i)
	    putc((key.dptr)[i], output);
	putc(' ', output);
	for(i = 0; i < content.dsize; ++ i)
	    putc((content.dptr)[i], output);
	putc('\n', output);
    }
}

static void print_usage(argc, argv)
     int argc;
     char **argv;
/* ˡɽ */
{
    fprintf(stderr,
	    "Usage: %s [-d workdir] [-o output] jisyo1 [[+-] jisyo2]...\n",
	    argv[0]);
}

int main(argc, argv)
     int argc;
     char **argv;
/* ᥤץ  νԤ */
{
    int negate, i;
    FILE *output;
    char *tmpdir;

    output = stdout;
    tmpdir = TMPDIR;

    /* ν */
    for (i = 1; i < argc; ++ i) {
	if (argv[i][0] == '-') {
	    if (argv[i][1] == 'd') { /* -d ȥǥ쥯ȥ */
		tmpdir=argv[i+1];
		i ++;
	    } else if (argv[i][1] == 'o') { /* -o ϥե */
		if ((output = fopen(argv[i+1], "w")) == NULL) {
		    perror(argv[i+1]);
		    exit(1);
		}
		i ++;
	    } else {
		print_usage(argc, argv);
		exit(1);
	    }
	} else {
	    break;
	}
    }

    if (i >= argc) { /* 񤬻ꤵƤʤ */
	print_usage(argc, argv);
	exit(1);
    }

    sprintf(file_name, "%s/skkjisyo.%d", tmpdir, getpid());
    make_dbmfiles();
    
    negate = 0;
    for (; i < argc; ++ i) {
	if (argv[i][0] == '+') {
	    negate = 0;
	    if (strlen(argv[i]) > 1)
		add_file(argv[i]+1);
	} else if (argv[i][0] == '-') {
	    negate = 1;
	    if (strlen(argv[i]) > 1) {
		subtract_file(argv[i]+1);
		negate = 0;
	    }
	} else {
	    if (negate == 0)
		add_file(argv[i]);
	    else
		subtract_file(argv[i]);
	}
    }
    type_out(output);
    rm_dbmfiles();
    return 0;
}
