;; install SKK system
;; Copyright (C) 1989 Masahiko Sato
;; This program is provided for unrestricted use, provided that this
;; copyright message is preserved. There is no warranty, and no author
;; or distributer accepts responsibility for any damage caused by this
;; program. 

;; change the values of the following variables if necessary.

(setq ETC exec-directory)
(setq LISP (concat exec-directory "../lisp"))
(setq UUDECODE "/usr/bin/uudecode")
(setq CAT "/bin/cat")
(setq CP "/bin/cp")

(defun skk-install ()
  "Install SKK system."
  (skk-unpack)
  (mapcar 'skk-copy-file1
	  '("SKK-roma-kana.tex" "SKK.man" "SKK.tut" "SKK-JISYO"))
  (mapcar 'skk-copy-file2
	  '("skk.el" "skk.elc" "skk-isearch.el" "skk-isearch.elc"
	    "skk-merge.el" "skk-merge.elc" "skk-tut.el"))
  (message "Installed SKK successfully."))

(defun skk-unpack ()
  "Unpack SKK package and create necessary files."
  (let ((kanji-fileio-code 0) (max-lisp-eval-depth 300))
    (mapcar 'skk-decode
	    '("SKK.tut.enc" "skk-isearch.el.enc" "SKK-JISYO1.enc"
	      "SKK-JISYO2.enc" "SKK-JISYO3.enc" "SKK-JISYO4.enc"
	      "skk-merge.el.enc" "skk-tut.el.enc" "skk.el1.enc" "skk.el2.enc"))
    (erase-buffer)
    (call-process CAT nil t nil
		  "SKK-JISYO1" "SKK-JISYO2" "SKK-JISYO3" "SKK-JISYO4")
    (write-region (point-min) (point-max) "SKK-JISYO" nil 'nomsg)
    (message "Created SKK-JISYO.")
    (erase-buffer)
    (call-process CAT nil t nil "skk.el1" "skk.el2")
    (message "Created skk.el")
    (write-region (point-min) (point-max) "skk.el" nil 'nomsg)
    (mapcar 'skk-compile '("skk.el" "skk-isearch.el" "skk-merge.el"))
    (message "Unpacked SKK successfully.")))

(defun skk-decode (file)
  (if (file-exists-p file)
      (progn
	(call-process UUDECODE nil nil nil file)
	(message "uudecoded %s." file))
    (error "%s does not exist." file)))
      
(defun skk-compile (file)
  (if (file-exists-p file)
      (progn
	(message "Compiling %s." file)
	(byte-compile-file file)
	(message "Compiled %s." file))
    (error "%s does not exist." file)))

(defun skk-copy-file (file dir)
  (if (file-exists-p file)
      (progn
	(erase-buffer)
	(call-process CP nil t nil file dir)
	(if (= (point-min) (point-max))
	    (message "Copied %s to %s." file dir)
	  (error "Failed to copy %s. Write permission denied." file)))
    (error "%s does not exist." file)))

(defun skk-copy-file1 (file)
  (skk-copy-file file ETC))

(defun skk-copy-file2 (file)
  (skk-copy-file file LISP))
