;;; rail-vars.el --- Replace Agent-string Internal Library

;; Copyright (C) 1999 by Free Software Foundation, Inc.

;; Author: SHIMADA Mitsunobu <simm-emacs@fan.gr.jp>
;; Keywords: i18n, internal, rail

;; This file is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; This file is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with GNU Emacs; see the file COPYING.  If not, write to
;; the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
;; Boston, MA 02111-1307, USA.

;;; Commentary:

;; 

;;; Code:

(require 'rail-table-semi)
(require 'rail-table-flim)
(require 'rail-table-mule)
(require 'rail-table-meadow)
(require 'rail-table-utf2000)
(require 'rail-table-xmas)

(defvar rail-version "1.1.4"
  "Version number of rail.el")

(defvar rail-temporary-buffer-name " *Rail*"
  "Temporary buffer to replace codename string")

;; replace candidates for replacement
(defvar rail-product-name-alist
  '(("SEMI"          . semi)
    ("WEMI"          . semi)
    ("REMI"          . semi)
    ("WREMI"         . semi)
    ("FLIM"          . flim)
    ("CHAO"          . flim)
    ("LIMIT"         . flim)
    ("MULE"          . mule)
    ("Meadow"        . meadow)
    ("UTF-2000-MULE" . utf2000)
    ("XEmacs"        . xmas))
  "Association-list of product name.
Each pair is '(\"Name\" . kind)")

;; Mule / Meadow / UTF-2000-MULE version format
(defvar rail-mule-version-header-format
  "\\([.0-9]+\\|[.0-9]+ Beta[0-9]*\\) (\\([^()]+\\))"
  "Format of mule-version, (Meadow-version), utf-2000-version string.")

;; Meadow beta version format
(defvar rail-meadow-beta-version-header-format
  "\\([.0-9]+\\|[.0-9]+ Beta[0-9]*\\) (\\([^()]+\\)\\(:[0-9]+\\))"
  "Format of (Meadow-version) string for Meadow-beta.")

;; MIME-Version: header format
(defvar rail-mime-version-header-short-format
  "\\([.0-9]+\\) - \"\\([^()]*\\)\""
  "MIME-Version: header pattern.")
(defvar rail-mime-version-header-format
  (format "[.0-9]+ (generated by \\([A-Za-z]+\\) %s)" rail-mime-version-header-short-format)
  "MIME-Version: header pattern.")

;; User-Agent: header format
(defvar rail-user-agent-header-format
  "\\([-0-9A-Za-z]+\\)/\\([.0-9]+\\|[.0-9]+ Beta[0-9]*\\)[ \t\r\n]+(\\([^()]+\\))"
  "User-Agent: header pattern. Each products are written like below.
ex. LIMIT/1.13.4 (Harinakano)

match-data 1: interface product name
match-data 2: codename")

;; User-Agent: header format (for XEmacs beta)
(defvar rail-user-agent-header-xmas-format
  "\\(XEmacs\\)/\\([.0-9]+\\)[ \t\r\n]+(\\([^()]+\\))[ \t\r\n]+(\\([^()]+\\))"
  "User-Agent: header pattern for XEmacs. Each products are written like below.
ex1. XEmacs/21.1 (20 Minutes to Nikko)
ex2. XEmacs/21.2 (beta19) (Shinjuku)

match-data 1: interface product name
match-data 2: codename or beta-number
match-data 3: architecture or codename

It use only when match-data 3 is codename.")

;; User-Agent: header
(defvar rail-user-agent-header-item-list
  '("User-Agent" "X-Mailer" "X-Newsreader")
  "Headers in which codename replaces.
Each codename should be aligned like rail-user-agent-header-format.")

;; CTCP VERSION format
(defvar rail-pj-mule-format "[.0-9]+ (\\([^()]+\\))"
  "CTCP VERSION format for Mule version")
(defvar rail-pj-meadow-format "[.0-9]+ (\\([^()]+\\))"
  "CTCP VERSION format for Meadow version")
(defvar rail-pj-xmas-format "[-.0-9A-Za-z]+ \"\\([^\"]+\\)\""
  "CTCP VERSION format for XEmacs version")
(defvar rail-pj-utf-2000-format "[/ ][.0-9]+"
  "CTCP VERSION format for UTF-2000-MULE version")
(defvar rail-pj-utf-2000-retry-format "[.0-9]+ (\\([^\"]+\\))"
  "CTCP VERSION format for UTF-2000-MULE version (Retry)")

;; customizable variables
(defvar rail-additional-semi-codename-alist nil
  "Additional codename for SEMI.")
(defvar rail-additional-flim-codename-alist nil
  "Additional codename for FLIM.")
(defvar rail-additional-mule-codename-alist nil
  "Additional codename for Mule.")
(defvar rail-additional-meadow-codename-alist nil
  "Additional codename for Meadow.")
(defvar rail-additional-utf2000-codename-alist nil
  "Additional codename for UTF-2000 Mule.")
(defvar rail-additional-xmas-codename-alist nil
  "Additional codename for XEmacs.")

;; replace original codename or not
(defvar rail-user-agent-replace-mime-library-product t
  "If non-nil, replace FLIM codename.")
(defvar rail-user-agent-replace-mime-user-interface-product t
  "If non-nil, replace SEMI codename.")
(defvar rail-emulate-genjis t
  "If non-nil, replace MULE version.")
(defvar rail-mule-replace-meadow-version t
  "If non-nil, replace (Meadow-version).")
(defvar rail-xmas-replace-xemacs-codename t
  "If non-nil, replace xemacs-codename.")
(defvar rail-xmas-replace-utf-2000-version t
  "If non-nil, replace utf-2000-version.")

;; for rail-pj
(defvar rail-pj-convert t
  "Convert codename in CTCP VERSION string.")

;; for rail-user-agent
(defvar rail-user-agent-convert-statically t
  "Convert codename statically.
If non-nil, rail replaces mime-edit-user-agent-value and mime-edit-mime-version-value.")
(defvar rail-user-agent-convert-dynamically t
  "Convert codename dynamically.
If non-nli, rail replaces User-Agent: and MIME-Version: header
after mime-edit-translate-body.")
(defvar rail-user-agent-replace-into-iso8859-4 t
  "Convert ISO-8859-1 codename into ISO-8859-4.
If nil, stop to convert via (rail-user-agent-replace-into-iso8859-4)")

;; conversion direction
(defvar rail-convert-direction t
  "Define convert direction.
If non-nil, rail replaces ISO-8859-4 into Japanese.
If nil, rail replaces Japanese into ISO-8859-4.")

(provide 'rail-vars)

;;; rail-vars.el ends here
