;;; rail.el --- convert codename into Japanese

;; Copyright (C) 1999 by Free Software Foundation, Inc.

;; Author: SHIMADA Mitsunobu <simm-emacs@fan.gr.jp>
;; Keywords: MULE, XEmacs, Meadow, UTF-2000, Genji, FLIM, SEMI, Rail

;; This file is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; This file is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with GNU Emacs; see the file COPYING.  If not, write to
;; the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
;; Boston, MA 02111-1307, USA.

;;; Commentary:

;; Current version supports only MULE, FLIM, and SEMI.

;;; Code:

(defvar rail-version "1.0.1"
  "Version number of rail.el")

(load "rail-table-utf2000")
(load "rail-table-xemacs")
(load "rail-table-meadow")
(load "rail-table-mule")
(defvar rail-additional-utf2000-codename-alist nil
  "Additional codename for UTF-2000 Mule.")
(defvar rail-additional-xemacs-codename-alist nil
  "Additional codename for XEmacs.")
(defvar rail-additional-meadow-codename-alist nil
  "Additional codename for Meadow.")

(cond ((featurep 'xemacs)
       (defvar rail-replace-xemacs-codename nil
         "If non-nil, xemacs-codename is Japanese. If not, xemacs-codename is Roman string.")
       (defvar rail-en-xemacs-codename xemacs-codename
         "English xemacs-codename.")
       (defvar rail-ja-xemacs-codename
         (or (cdr (assoc xemacs-codename
                         (append rail-additional-xemacs-codename-alist rail-xemacs-codename-alist)))
             rail-en-xemacs-codename)
         "Japanese xemacs-codename.")
       (and rail-replace-xemacs-codename
            (setq xemacs-codename rail-ja-xemacs-codename))
       (if (featurep 'utf-2000)
           (progn
             (defvar rail-replace-utf-2000-version nil
               "If non-nil, utf-2000-version is Japanese. If not, utf-2000-version is Roman string.")
             (defvar rail-en-utf-2000-version utf-2000-version
               "English utf-2000-version.")
             (defvar rail-ja-utf-2000-version
               (let* ((string utf-2000-version)
                      (codename-b (string-match "(" string))
                      (codename-e (string-match ")" string))
                      (codename nil))
                 (and codename-b codename-e
                      (setq codename-b (1+ codename-b)
                            codename   (substring string codename-b codename-e)))
                 (if codename
                     (format "%s%s%s"
                             (substring string 0 codename-b)
                             (or (cdr (assoc codename
                                             (append rail-additional-utf2000-codename-alist
                                                     rail-utf2000-codename-alist)))
                                 codename)
                             (substring string codename-e))
                   rail-en-utf-2000-version)))
             (and rail-replace-utf-2000-version
                  (setq rail-replace-utf-2000-version rail-ja-utf-2000-version)))))
      ((boundp 'mule-version)
       (defvar rail-emulate-genjis nil
         "If non-nil, mule-version is Japanese. If not, mule-version is Roman string.")
       (defvar rail-en-mule-version mule-version
         "English mule-version.")
       (defvar rail-ja-mule-version
         (let* ((whitespace (string-match " " mule-version))
                (mule-vernum (substring mule-version 0 whitespace))
                (mule-codename (substring mule-version
                                          (+ 2 whitespace)
                                          (1- (length mule-version)))))
           (format "%s (%s)"
                   mule-vernum
                   (or (cdr (assoc mule-codename rail-mule-codename-alist))
                       rail-en-mule-version)))
         "Japanese mule-version.")
       (and rail-emulate-genjis
            (setq mule-version rail-ja-mule-version))
       (if (featurep 'meadow)
           (progn
             (defvar rail-en-meadow-version (Meadow-version)
               "English (Meadow-version).")
             (defvar rail-ja-meadow-version
               (let* ((string (Meadow-version))
                      (codename-b (string-match "(" string))
                      (codename-e (string-match ")" string))
                      (codename nil))
                 (and codename-b codename-e
                      (setq codename-b (1+ codename-b)
                            codename   (substring string codename-b codename-e)))
                 (if codename
                     (format "%s%s%s"
                             (substring string 0 codename-b)
                             (or (cdr (assoc codename
                                             (append rail-additional-meadow-codename-alist
                                                     rail-meadow-codename-alist)))
                                 codename)
                             (substring string codename-e))
                   rail-en-meadow-version)))))))

(if (featurep 'semi-def)
    (load "rail-user-agent")
  (add-hook 'mime-setup-load-hook
	    '(lambda () (load "rail-user-agent"))))

(load "rail-pj")
(provide 'rail)

;;; rail.el ends here
