;;; rail-pj.el --- convert codename into Japanese

;; Copyright (C) 1999 by Free Software Foundation, Inc.

;; Author: SHIMADA Mitsunobu <simm@irc.fan.gr.jp>
;; Keywords: irchat-pj, Rail

;; This file is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; This file is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with GNU Emacs; see the file COPYING.  If not, write to
;; the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
;; Boston, MA 02111-1307, USA.

;;; Commentary:

;; compatible with irchat-pj 2.4.24.11 or later

;;; Code:

(defvar rail-translate-pj t
  "If non-nil, translate CTCP VERSION string into Japanese.")

(defun rail-replace-string (string lchr rchr &rest alist)
  "Replace string."
  (let ((pt nil)
        (key "")
        (ret ""))
    (catch 'loop-exit
      (while (< 0 (length string))
        (setq pt (string-match lchr string))
        (if (null pt)
            (throw 'loop-exit nil))
        (setq ret    (concat ret (substring string 0 pt))
              string (substring string pt))
        (setq pt     (string-match rchr string))
        (if (null pt)
            (throw 'loop-exit nil))
        (if (not (= 0 pt))
            (setq pt     (1- pt)
                  key    (substring string 0 pt)
                  string (substring string pt)
                  ret    (concat ret (or (cdr (assoc key (apply 'append alist)))
                                         key))))))
    (setq ret (concat ret string))))

(defun rail-replace-pj-version ()
  "Replace irchat-pj-version-string."
  (let* ((pt   (string-match " :" irchat-pj-version-string))
         (head (substring irchat-pj-version-string 0 pt))
         (tail (substring irchat-pj-version-string pt)))
    (setq irchat-pj-version-string
          (concat (rail-replace-string head "(" ")"
                                       rail-additional-xemacs-codename-alist
                                       rail-additional-meadow-codename-alist
                                       rail-xemacs-codename-alist
                                       rail-meadow-codename-alist
                                       rail-mule-codename-alist)
                  (if (string-match "rail" head)
                      ""
                    (concat " powered by rail-" rail-version))
                  tail))))

(and rail-translate-pj
     (if (featurep 'irchat-pj-version-string)
         (rail-replace-pj-version)
       (add-hook 'irchat-pj-version-string-hook 'rail-replace-pj-version)))

(provide 'rail-pj)

;;; rail-pj.el ends here
