;;; rail.el --- convert codename into Japanese

;; Copyright (C) 1999 by Free Software Foundation, Inc.

;; Author: SHIMADA Mitsunobu <simm-emacs@fan.gr.jp>
;; Keywords: MULE, Genji, FLIM, SEMI, Rail

;; This file is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; This file is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with GNU Emacs; see the file COPYING.  If not, write to
;; the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
;; Boston, MA 02111-1307, USA.

;;; Commentary:

;; Current version supports only MULE, FLIM, and SEMI.

;;; Code:

(defvar rail-version "0.2"
  "Version number of rail.el")

(if (boundp 'mule-version)
    (progn
      (load "rail-table-mule")
      (defvar rail-emulate-genjis nil
        "If non-nil, mule-version is Japanese. If not, mule-version is Roman string.")
      (defvar rail-en-mule-version mule-version
        "English mule-version.")
      (defvar rail-ja-mule-version
        (let* ((whitespace (string-match " " mule-version))
               (mule-vernum (substring mule-version 0 whitespace))
               (mule-codename (substring mule-version
					 (+ 2 whitespace)
					 (1- (length mule-version)))))
          (format "%s (%s)"
                  mule-vernum
                  (or (cdr (assoc mule-codename rail-mule-version-alist))
                      rail-en-mule-version)))
        "Japanese mule-version.")
      (and rail-emulate-genjis
           (setq mule-version rail-ja-mule-version))))

(if (featurep 'semi-def)
    (load "rail-user-agent")
  (add-hook 'mime-setup-load-hook
	    '(lambda () (load "rail-user-agent"))))

(provide 'rail)

;;; rail.el ends here
