;;; emh-e21.el --- EMH modules for Emacs 21.

;; Copyright (C) 2002 TSUMURA Tomoaki <tsumura@tomo.gr.jp>

;; Author: TSUMURA Tomoaki <tsumura@tomo.gr.jp>

;; This file is part of emh.

;; This program is free software; you can redistribute it and/or
;; modify it under the terms of the GNU General Public License as
;; published by the Free Software Foundation; either version 2, or (at
;; your option) any later version.

;; This program is distributed in the hope that it will be useful, but
;; WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
;; General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with GNU Emacs; see the file COPYING.  If not, write to the
;; Free Software Foundation, Inc., 59 Temple Place - Suite 330,
;; Boston, MA 02111-1307, USA.

;;; Code:

;; All code is stolen from wl-e21.el
(eval-when-compile
  (defvar-maybe mh-folder-mode-map (make-sparse-keymap))
)

(defvar emh-folder-toolbar
  '([mh-show
     mh-show t "Show Mail"]
    [mh-next-undeleted-msg
     mh-next-undeleted-msg t "Next Message"]
    [mh-previous-undeleted-msg
     mh-previous-undeleted-msg t "Previous Message"]
    [mh-inc-folder
     mh-inc-folder t "Incorporate New Mails"]
    [mh-delete-msg
     mh-delete-msg t "Delete Message"]
    [mh-send
     mh-send t "New Message"]
    [mh-reply
     mh-reply t "Reply Message"]
    [emh-forward
     emh-forward t "Forward Message"]
    [mh-rescan-folder
     mh-rescan-folder t "Rescan Folder"]
    [mh-quit
     mh-quit t "Exit MH-E"]
    )
  "Folder buffer toolbar.")

(defvar emh-draft-toolbar
  '([mh-send-letter
     mh-send-letter t "Send Letter"]
    [mh-yank-cur-msg
     mh-yank-cur-msg t "Yank and Cite Message"]
    [mh-insert-signature
     mh-insert-signature t "Insert Signature"]
    [mime-edit-set-encrypt
     mime-edit-set-encrypt t "PGP Encrypt"]
    [mime-edit-set-sign
     mime-edit-set-sign t "PGP Signature"]
    [mh-fully-kill-draft
     mh-fully-kill-draft t "Delete Draft"]
    )
  )

(defun emh-e21-setup-toolbar (bar)
  (when (and (display-images-p)
	     (image-type-available-p 'xpm))
    (let ((load-path (cons emh-icon-directory load-path))
	  (props '(:type xpm :ascent center
			 :color-symbols (("backgroundToolBarColor" . "None"))
			 :file))
	  (success t)
	  icon up down disabled name)
      (while bar
	(setq icon (aref (pop bar) 0))
	(unless (boundp icon)
	  (setq name (symbol-name icon)
		up (find-image `((,@props ,(concat name "-up.xpm")))))
	  (if up
	      (set icon (vector up up up up))
	    (setq bar nil success nil))
	  )
	)
      success)))

(defun emh-e21-make-toolbar-buttons (keymap defs)
  (let ((configs '((auto-resize-tool-bars . t)
		   (auto-raise-tool-bar-buttons . t)
		   (tool-bar-button-margin . 0)
		   (tool-bar-button-relief . 2)))
	config)
    (while (setq config (pop configs))
      (set (make-local-variable (car config)) (cdr config))))
  (let ((keys (cdr (key-binding [tool-bar] t)))
	item)
    (while (setq item (pop keys))
      (when (setq item (car-safe item))
	(define-key keymap (vector 'tool-bar item) 'undefined))))
  (let ((n (length defs))
	def)
    (while (>= n 0)
      (setq n (1- n)
	    def (nth n defs))
      (define-key keymap (vector 'tool-bar (aref def 1))
	(list 'menu-item (aref def 3) (aref def 1)
	      :enable (aref def 2)
	      :image (symbol-value (aref def 0)))))))

(defun emh-e21-setup-folder-toolbar ()
  (when (emh-e21-setup-toolbar emh-folder-toolbar)
    (emh-e21-make-toolbar-buttons mh-folder-mode-map emh-folder-toolbar)))
(add-hook 'mh-folder-mode-hook 'emh-e21-setup-folder-toolbar)

(defun emh-e21-setup-draft-toolbar ()
  (when (emh-e21-setup-toolbar emh-draft-toolbar)
    (emh-e21-make-toolbar-buttons mime-edit-mode-map emh-draft-toolbar)))
(add-hook 'mime-edit-mode-hook 'emh-e21-setup-draft-toolbar)

;;; @ end
;;;

(provide 'emh-e21)

;;; emh-e21.el ends here
