;;; un-sample.el --- sample configuration for UTF.

;; Copyright (C) 1997 Miyashita Hisashi

;; Keywords: mule, multilingual, 
;;           character set, coding-system, ISO10646, Unicode

;; This file is part of MULE-UCS

;; MULE-UCS is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; MULE-UCS is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with this program; see the file COPYING.  If not, write to the
;; Free Software Foundation, Inc., 59 Temple Place - Suite 330,
;; Boston, MA 02111-1307, USA.

;; Comment:
;;  This module supports useful functions for unicode.
;;  If you want to use auto detecting utf? .etc, 
;;  add (require 'un-tools) to your .emacs.

;
; This is a sample program for generating unicode coding system.
; You can customize these configuration, and byte-compile it,
; then you get your expected coding-system with only its result.
; You need only un-sample.elc after compile this.
;

;;; This sentense is needed.
;;; You can define any data to generate
;;; new coding systems or ccl.
(eval-when-compile
  (require 'unicode)
  (defvar unicode-basic-translation-rule
    '(ascii
      latin-iso8859-1
      latin-iso8859-2
      latin-iso8859-3
      latin-iso8859-4
      cyrillic-iso8859-5
      greek-iso8859-7
      hebrew-iso8859-8
      latin-iso8859-9
      japanese-jisx0208
      japanese-jisx0212
      chinese-cns11643-1
      chinese-cns11643-2
      chinese-cns11643-3
      chinese-gb2312
      katakana-jisx0201
      latin-jisx0201))

  (defvar unicode-line-separator-translation-rule
    (cons '(ascii . lf-vs-unicode-line-separator)
	  unicode-basic-translation-rule))

  (defvar unicode-mac-translation-rule
    (cons '(ascii . lf-vs-cr)
	  unicode-basic-translation-rule)))

;--------------------------------------------------------
; Coding system definition.
;--------------------------------------------------------

(mucs-define-package  ;;; Define package.
 un-sample            ;;; This and feature name(the argument of require)
                      ;;; should be same.
 
 (mucs-define-simple-coding-system
  utf8-unix ?u
  "UTF8 Coding system whose line separator is lf"
  (utf8-decode-buffer-magnification
   ((mucs-ccl-utf8-check-signature-read)
    (mucs-ccl-stream-form
     (mucs-ccl-translate-decode-simple-unicode
      unicode-basic-translation-rule
      nil)
     (mucs-ccl-write-generic)
     (mucs-ccl-read-utf8))))
  (utf8-encode-buffer-magnification
   ((mucs-ccl-write-utf8-signature)
    (mucs-ccl-stream-form
     (mucs-ccl-read-generic)
     (mucs-ccl-translate-encode-simple-unicode
      unicode-basic-translation-rule
      nil)
     (mucs-ccl-write-utf8)))))

 (mucs-define-simple-coding-system
  utf8-dos ?u
  "UTF8 Coding system whose line separator is cr+lf"
  (utf8-decode-buffer-magnification
   ((mucs-ccl-utf8-check-signature-read)
    (mucs-ccl-stream-form
     (mucs-ccl-translate-decode-simple-unicode
      unicode-basic-translation-rule
      nil)
     (mucs-ccl-write-generic-dos)
     (mucs-ccl-read-utf8))))
  (utf8-encode-buffer-magnification
   ((mucs-ccl-write-utf8-signature)
    (mucs-ccl-stream-form
     (mucs-ccl-read-generic)
     (mucs-ccl-translate-encode-simple-unicode
      unicode-basic-translation-rule
      nil)
     (mucs-ccl-write-utf8-dos)))))

 (mucs-define-simple-coding-system
  utf8-mac ?u
  "UTF8 Coding system whose line separator is cr"
  (utf8-decode-buffer-magnification
   ((mucs-ccl-utf8-check-signature-read)
    (mucs-ccl-stream-form
     (mucs-ccl-translate-decode-simple-unicode
      unicode-mac-translation-rule
      nil)
     (mucs-ccl-write-generic)
     (mucs-ccl-read-utf8))))
  (utf8-encode-buffer-magnification
   ((mucs-ccl-write-utf8-signature)
    (mucs-ccl-stream-form
     (mucs-ccl-read-generic)
     (mucs-ccl-translate-encode-simple-unicode
      unicode-mac-translation-rule
      nil)
     (mucs-ccl-write-utf8)))))

 (mucs-define-simple-coding-system
  utf8 ?u
  "UTF8 Coding system"
  (utf8-decode-buffer-magnification
   ((mucs-ccl-utf8-check-signature-read)
    (mucs-ccl-stream-form
     (mucs-ccl-translate-decode-simple-unicode
      unicode-line-separator-translation-rule
      nil)
     (mucs-ccl-write-generic)
     (mucs-ccl-read-utf8))))
  (utf8-encode-buffer-magnification
   ((mucs-ccl-write-utf8-signature)
    (mucs-ccl-stream-form
     (mucs-ccl-read-generic)
     (mucs-ccl-translate-encode-simple-unicode
      unicode-line-separator-translation-rule
      nil)
     (mucs-ccl-write-utf8)))))

 (mucs-define-simple-coding-system
  utf16-le-unix ?U
  "UTF16 Little Endian Coding system whose line separator is lf"
  (utf16-decode-buffer-magnification
   ((mucs-ccl-set-utf16-endian nil)
    (mucs-ccl-utf16-check-signature-read)
    (mucs-ccl-stream-form
     (mucs-ccl-translate-decode-simple-unicode
      unicode-basic-translation-rule
      nil)
     (mucs-ccl-write-generic)
     (mucs-ccl-read-utf16-le))))
  (utf16-encode-buffer-magnification
   ((mucs-ccl-write-utf16-le-signature)
    (mucs-ccl-stream-form
     (mucs-ccl-read-generic)
     (mucs-ccl-translate-encode-simple-unicode
      unicode-basic-translation-rule
      nil)
     (mucs-ccl-write-utf16-le)))))

 (mucs-define-simple-coding-system
  utf16-le-dos ?U
  "UTF16 Little Endian Coding system whose line separator is cr+lf"
  (utf16-decode-buffer-magnification
   ((mucs-ccl-set-utf16-endian nil)
    (mucs-ccl-utf16-check-signature-read)
    (mucs-ccl-stream-form
     (mucs-ccl-translate-decode-simple-unicode
      unicode-basic-translation-rule
      nil)
     (mucs-ccl-write-generic-dos)
     (mucs-ccl-read-utf16-le))))
  (utf16-encode-buffer-magnification
   ((mucs-ccl-write-utf16-le-signature)
    (mucs-ccl-stream-form
     (mucs-ccl-read-generic)
     (mucs-ccl-translate-encode-simple-unicode
      unicode-basic-translation-rule
      nil)
     (mucs-ccl-write-utf16-le-dos)))))

 (mucs-define-simple-coding-system
  utf16-le-mac ?U
  "UTF16 Little Endian Coding system whose line separator is cr"
  (utf16-decode-buffer-magnification
   ((mucs-ccl-set-utf16-endian nil)
    (mucs-ccl-utf16-check-signature-read)
    (mucs-ccl-stream-form
     (mucs-ccl-translate-decode-simple-unicode
      unicode-mac-translation-rule
      nil)
     (mucs-ccl-write-generic)
     (mucs-ccl-read-utf16-le))))
  (utf16-encode-buffer-magnification
   ((mucs-ccl-write-utf16-le-signature)
    (mucs-ccl-stream-form
     (mucs-ccl-read-generic)
     (mucs-ccl-translate-encode-simple-unicode
      unicode-mac-translation-rule
      nil)
     (mucs-ccl-write-utf16-le)))))

 (mucs-define-simple-coding-system
  utf16-le ?U
  "UTF16 Little Endian Coding system"
  (utf16-decode-buffer-magnification
   ((mucs-ccl-set-utf16-endian nil)
    (mucs-ccl-utf16-check-signature-read)
    (mucs-ccl-stream-form
     (mucs-ccl-translate-decode-simple-unicode
      unicode-line-separator-translation-rule
      nil)
     (mucs-ccl-write-generic)
     (mucs-ccl-read-utf16-le))))
  (utf16-encode-buffer-magnification
   ((mucs-ccl-write-utf16-le-signature)
    (mucs-ccl-stream-form
     (mucs-ccl-read-generic)
     (mucs-ccl-translate-encode-simple-unicode
      unicode-line-separator-translation-rule
      nil)
     (mucs-ccl-write-utf16-le)))))

 (mucs-define-simple-coding-system
  utf16-be-unix ?U
  "UTF16 Big Endian Coding system whose line separator is lf"
  (utf16-decode-buffer-magnification
   ((mucs-ccl-set-utf16-endian nil)
    (mucs-ccl-utf16-check-signature-read)
    (mucs-ccl-stream-form
     (mucs-ccl-translate-decode-simple-unicode
      unicode-basic-translation-rule
      nil)
     (mucs-ccl-write-generic)
     (mucs-ccl-read-utf16-be))))
  (utf16-encode-buffer-magnification
   ((mucs-ccl-write-utf16-be-signature)
    (mucs-ccl-stream-form
     (mucs-ccl-read-generic)
     (mucs-ccl-translate-encode-simple-unicode
      unicode-basic-translation-rule
      nil)
     (mucs-ccl-write-utf16-be)))))

 (mucs-define-simple-coding-system
  utf16-be-dos ?U
  "UTF16 Big Endian Coding system whose line separator is cr+lf"
  (utf16-decode-buffer-magnification
   ((mucs-ccl-set-utf16-endian nil)
    (mucs-ccl-utf16-check-signature-read)
    (mucs-ccl-stream-form
     (mucs-ccl-translate-decode-simple-unicode
      unicode-basic-translation-rule
      nil)
     (mucs-ccl-write-generic-dos)
     (mucs-ccl-read-utf16-be))))
  (utf16-encode-buffer-magnification
   ((mucs-ccl-write-utf16-be-signature)
    (mucs-ccl-stream-form
     (mucs-ccl-read-generic)
     (mucs-ccl-translate-encode-simple-unicode
      unicode-basic-translation-rule
      nil)
     (mucs-ccl-write-utf16-be-dos)))))

 (mucs-define-simple-coding-system
  utf16-be-mac ?U
  "UTF16 Big Endian Coding system whose line separator is cr"
  (utf16-decode-buffer-magnification
   ((mucs-ccl-set-utf16-endian nil)
    (mucs-ccl-utf16-check-signature-read)
    (mucs-ccl-stream-form
     (mucs-ccl-translate-decode-simple-unicode
      unicode-mac-translation-rule
      nil)
     (mucs-ccl-write-generic)
     (mucs-ccl-read-utf16-be))))
  (utf16-encode-buffer-magnification
   ((mucs-ccl-write-utf16-be-signature)
    (mucs-ccl-stream-form
     (mucs-ccl-read-generic)
     (mucs-ccl-translate-encode-simple-unicode
      unicode-mac-translation-rule
      nil)
     (mucs-ccl-write-utf16-be)))))

 (mucs-define-simple-coding-system
  utf16-be ?U
  "UTF16 Big Endian Coding system"
  (utf16-decode-buffer-magnification
   ((mucs-ccl-set-utf16-endian nil)
    (mucs-ccl-utf16-check-signature-read)
    (mucs-ccl-stream-form
     (mucs-ccl-translate-decode-simple-unicode
      unicode-line-separator-translation-rule
      nil)
     (mucs-ccl-write-generic)
     (mucs-ccl-read-utf16-be))))
  (utf16-encode-buffer-magnification
   ((mucs-ccl-write-utf16-be-signature)
    (mucs-ccl-stream-form
     (mucs-ccl-read-generic)
     (mucs-ccl-translate-encode-simple-unicode
      unicode-line-separator-translation-rule
      nil)
     (mucs-ccl-write-utf16-be)))))
)

(provide 'un-sample)