; -*- coding: iso-2022-7bit  -*-
;;; ugb2312.el --- tables between UCS and GB2312-80

;; Copyright (C) 1997 Miyashita Hisashi

;; Keywords: CCL, mule, multilingual, 
;;           character set, coding-system, ISO10646, Unicode, JIS X 0208

;; This file is part of MULE-UCS

;; MULE-UCS is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; MULE-UCS is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with this program; see the file COPYING.  If not, write to the
;; Free Software Foundation, Inc., 59 Temple Place - Suite 330,
;; Boston, MA 02111-1307, USA.

(put 'chinese-gb2312 'unicode 'gb2312-80-vs-unicode-alist)

(defvar
  gb2312-80-vs-unicode-alist 
  '((?$A!!(B . 12288)
    (?$A!"(B . 12289)
    (?$A!#(B . 12290)
    (?$A!$(B . 12539)
    (?$A!%(B . 713)
    (?$A!&(B . 711)
    (?$A!'(B . 168)
    (?$A!((B . 12291)
    (?$A!)(B . 12293)
    (?$A!*(B . 8213)
    (?$A!+(B . 65374)
    (?$A!,(B . 8741)
    (?$A!-(B . 8230)
    (?$A!.(B . 8216)
    (?$A!/(B . 8217)
    (?$A!0(B . 8220)
    (?$A!1(B . 8221)
    (?$A!2(B . 12308)
      (?$A!3(B . 12309)
    (?$A!4(B . 12296)
      (?$A!5(B . 12297)
    (?$A!6(B . 12298)
      (?$A!7(B . 12299)
    (?$A!8(B . 12300)
      (?$A!9(B . 12301)
    (?$A!:(B . 12302)
      (?$A!;(B . 12303)
    (?$A!<(B . 12310)
      (?$A!=(B . 12311)
    (?$A!>(B . 12304)
      (?$A!?(B . 12305)
    (?$A!@(B . 177)
    (?$A!A(B . 215)
    (?$A!B(B . 247)
    (?$A!C(B . 8758)
    (?$A!D(B . 8743)
    (?$A!E(B . 8744)
    (?$A!F(B . 8721)
    (?$A!G(B . 8719)
    (?$A!H(B . 8746)
    (?$A!I(B . 8745)
    (?$A!J(B . 8712)
    (?$A!K(B . 8759)
    (?$A!L(B . 8730)
    (?$A!M(B . 8869)
    (?$A!N(B . 8741)
    (?$A!O(B . 8736)
    (?$A!P(B . 8978)
    (?$A!Q(B . 8857)
    (?$A!R(B . 8747)
    (?$A!S(B . 8750)
    (?$A!T(B . 8801)
    (?$A!U(B . 8780)
    (?$A!V(B . 8776)
    (?$A!W(B . 8765)
    (?$A!X(B . 8733)
    (?$A!Y(B . 8800)
    (?$A!Z(B . 8814)
    (?$A![(B . 8815)
    (?$A!\(B . 8804)
    (?$A!](B . 8805)
    (?$A!^(B . 8734)
    (?$A!_(B . 8757)
    (?$A!`(B . 8756)
    (?$A!a(B . 9794)
    (?$A!b(B . 9792)
    (?$A!c(B . 176)
    (?$A!d(B . 8242)
    (?$A!e(B . 8243)
    (?$A!f(B . 8451)
    (?$A!g(B . 65284)
    (?$A!h(B . 164)
    (?$A!i(B . 65504)
    (?$A!j(B . 65505)
    (?$A!k(B . 8240)
    (?$A!l(B . 167)
    (?$A!m(B . 8470)
    (?$A!n(B . 9734)
    (?$A!o(B . 9733)
    (?$A!p(B . 9675)
    (?$A!q(B . 9679)
    (?$A!r(B . 9678)
    (?$A!s(B . 9671)
    (?$A!t(B . 9670)
    (?$A!u(B . 9633)
    (?$A!v(B . 9632)
    (?$A!w(B . 9651)
    (?$A!x(B . 9650)
    (?$A!y(B . 8251)
    (?$A!z(B . 8594)
    (?$A!{(B . 8592)
    (?$A!|(B . 8593)
    (?$A!}(B . 8595)
    (?$A!~(B . 12307)
    (?$A"1(B . 9352)
    (?$A"2(B . 9353)
    (?$A"3(B . 9354)
    (?$A"4(B . 9355)
    (?$A"5(B . 9356)
    (?$A"6(B . 9357)
    (?$A"7(B . 9358)
    (?$A"8(B . 9359)
    (?$A"9(B . 9360)
    (?$A":(B . 9361)
    (?$A";(B . 9362)
    (?$A"<(B . 9363)
    (?$A"=(B . 9364)
    (?$A">(B . 9365)
    (?$A"?(B . 9366)
    (?$A"@(B . 9367)
    (?$A"A(B . 9368)
    (?$A"B(B . 9369)
    (?$A"C(B . 9370)
    (?$A"D(B . 9371)
    (?$A"E(B . 9332)
    (?$A"F(B . 9333)
    (?$A"G(B . 9334)
    (?$A"H(B . 9335)
    (?$A"I(B . 9336)
    (?$A"J(B . 9337)
    (?$A"K(B . 9338)
    (?$A"L(B . 9339)
    (?$A"M(B . 9340)
    (?$A"N(B . 9341)
    (?$A"O(B . 9342)
    (?$A"P(B . 9343)
    (?$A"Q(B . 9344)
    (?$A"R(B . 9345)
    (?$A"S(B . 9346)
    (?$A"T(B . 9347)
    (?$A"U(B . 9348)
    (?$A"V(B . 9349)
    (?$A"W(B . 9350)
    (?$A"X(B . 9351)
    (?$A"Y(B . 9312)
    (?$A"Z(B . 9313)
    (?$A"[(B . 9314)
    (?$A"\(B . 9315)
    (?$A"](B . 9316)
    (?$A"^(B . 9317)
    (?$A"_(B . 9318)
    (?$A"`(B . 9319)
    (?$A"a(B . 9320)
    (?$A"b(B . 9321)
    (?$A"e(B . 12832)
    (?$A"f(B . 12833)
    (?$A"g(B . 12834)
    (?$A"h(B . 12835)
    (?$A"i(B . 12836)
    (?$A"j(B . 12837)
    (?$A"k(B . 12838)
    (?$A"l(B . 12839)
    (?$A"m(B . 12840)
    (?$A"n(B . 12841)
    (?$A"q(B . 8544)
    (?$A"r(B . 8545)
    (?$A"s(B . 8546)
    (?$A"t(B . 8547)
    (?$A"u(B . 8548)
    (?$A"v(B . 8549)
    (?$A"w(B . 8550)
    (?$A"x(B . 8551)
    (?$A"y(B . 8552)
    (?$A"z(B . 8553)
    (?$A"{(B . 8554)
    (?$A"|(B . 8555)
    (?$A#!(B . 65281)
    (?$A#"(B . 65282)
    (?$A##(B . 65283)
    (?$A#$(B . 65509)
    (?$A#%(B . 65285)
    (?$A#&(B . 65286)
    (?$A#'(B . 65287)
    (?$A#((B . 65288)
    (?$A#)(B . 65289)
    (?$A#*(B . 65290)
    (?$A#+(B . 65291)
    (?$A#,(B . 65292)
    (?$A#-(B . 65293)
    (?$A#.(B . 65294)
    (?$A#/(B . 65295)
    (?$A#0(B . 65296)
    (?$A#1(B . 65297)
    (?$A#2(B . 65298)
    (?$A#3(B . 65299)
    (?$A#4(B . 65300)
    (?$A#5(B . 65301)
    (?$A#6(B . 65302)
    (?$A#7(B . 65303)
    (?$A#8(B . 65304)
    (?$A#9(B . 65305)
    (?$A#:(B . 65306)
    (?$A#;(B . 65307)
    (?$A#<(B . 65308)
    (?$A#=(B . 65309)
    (?$A#>(B . 65310)
    (?$A#?(B . 65311)
    (?$A#@(B . 65312)
    (?$A#A(B . 65313)
    (?$A#B(B . 65314)
    (?$A#C(B . 65315)
    (?$A#D(B . 65316)
    (?$A#E(B . 65317)
    (?$A#F(B . 65318)
    (?$A#G(B . 65319)
    (?$A#H(B . 65320)
    (?$A#I(B . 65321)
    (?$A#J(B . 65322)
    (?$A#K(B . 65323)
    (?$A#L(B . 65324)
    (?$A#M(B . 65325)
    (?$A#N(B . 65326)
    (?$A#O(B . 65327)
    (?$A#P(B . 65328)
    (?$A#Q(B . 65329)
    (?$A#R(B . 65330)
    (?$A#S(B . 65331)
    (?$A#T(B . 65332)
    (?$A#U(B . 65333)
    (?$A#V(B . 65334)
    (?$A#W(B . 65335)
    (?$A#X(B . 65336)
    (?$A#Y(B . 65337)
    (?$A#Z(B . 65338)
    (?$A#[(B . 65339)
    (?$A#\(B . 65340)
    (?$A#](B . 65341)
    (?$A#^(B . 65342)
    (?$A#_(B . 65343)
    (?$A#`(B . 65344)
    (?$A#a(B . 65345)
    (?$A#b(B . 65346)
    (?$A#c(B . 65347)
    (?$A#d(B . 65348)
    (?$A#e(B . 65349)
    (?$A#f(B . 65350)
    (?$A#g(B . 65351)
    (?$A#h(B . 65352)
    (?$A#i(B . 65353)
    (?$A#j(B . 65354)
    (?$A#k(B . 65355)
    (?$A#l(B . 65356)
    (?$A#m(B . 65357)
    (?$A#n(B . 65358)
    (?$A#o(B . 65359)
    (?$A#p(B . 65360)
    (?$A#q(B . 65361)
    (?$A#r(B . 65362)
    (?$A#s(B . 65363)
    (?$A#t(B . 65364)
    (?$A#u(B . 65365)
    (?$A#v(B . 65366)
    (?$A#w(B . 65367)
    (?$A#x(B . 65368)
    (?$A#y(B . 65369)
    (?$A#z(B . 65370)
    (?$A#{(B . 65371)
    (?$A#|(B . 65372)
    (?$A#}(B . 65373)
    (?$A#~(B . 65507)
    (?$A$!(B . 12353)
    (?$A$"(B . 12354)
    (?$A$#(B . 12355)
    (?$A$$(B . 12356)
    (?$A$%(B . 12357)
    (?$A$&(B . 12358)
    (?$A$'(B . 12359)
    (?$A$((B . 12360)
    (?$A$)(B . 12361)
    (?$A$*(B . 12362)
    (?$A$+(B . 12363)
    (?$A$,(B . 12364)
    (?$A$-(B . 12365)
    (?$A$.(B . 12366)
    (?$A$/(B . 12367)
    (?$A$0(B . 12368)
    (?$A$1(B . 12369)
    (?$A$2(B . 12370)
    (?$A$3(B . 12371)
    (?$A$4(B . 12372)
    (?$A$5(B . 12373)
    (?$A$6(B . 12374)
    (?$A$7(B . 12375)
    (?$A$8(B . 12376)
    (?$A$9(B . 12377)
    (?$A$:(B . 12378)
    (?$A$;(B . 12379)
    (?$A$<(B . 12380)
    (?$A$=(B . 12381)
    (?$A$>(B . 12382)
    (?$A$?(B . 12383)
    (?$A$@(B . 12384)
    (?$A$A(B . 12385)
    (?$A$B(B . 12386)
    (?$A$C(B . 12387)
    (?$A$D(B . 12388)
    (?$A$E(B . 12389)
    (?$A$F(B . 12390)
    (?$A$G(B . 12391)
    (?$A$H(B . 12392)
    (?$A$I(B . 12393)
    (?$A$J(B . 12394)
    (?$A$K(B . 12395)
    (?$A$L(B . 12396)
    (?$A$M(B . 12397)
    (?$A$N(B . 12398)
    (?$A$O(B . 12399)
    (?$A$P(B . 12400)
    (?$A$Q(B . 12401)
    (?$A$R(B . 12402)
    (?$A$S(B . 12403)
    (?$A$T(B . 12404)
    (?$A$U(B . 12405)
    (?$A$V(B . 12406)
    (?$A$W(B . 12407)
    (?$A$X(B . 12408)
    (?$A$Y(B . 12409)
    (?$A$Z(B . 12410)
    (?$A$[(B . 12411)
    (?$A$\(B . 12412)
    (?$A$](B . 12413)
    (?$A$^(B . 12414)
    (?$A$_(B . 12415)
    (?$A$`(B . 12416)
    (?$A$a(B . 12417)
    (?$A$b(B . 12418)
    (?$A$c(B . 12419)
    (?$A$d(B . 12420)
    (?$A$e(B . 12421)
    (?$A$f(B . 12422)
    (?$A$g(B . 12423)
    (?$A$h(B . 12424)
    (?$A$i(B . 12425)
    (?$A$j(B . 12426)
    (?$A$k(B . 12427)
    (?$A$l(B . 12428)
    (?$A$m(B . 12429)
    (?$A$n(B . 12430)
    (?$A$o(B . 12431)
    (?$A$p(B . 12432)
    (?$A$q(B . 12433)
    (?$A$r(B . 12434)
    (?$A$s(B . 12435)
    (?$A%!(B . 12449)
    (?$A%"(B . 12450)
    (?$A%#(B . 12451)
    (?$A%$(B . 12452)
    (?$A%%(B . 12453)
    (?$A%&(B . 12454)
    (?$A%'(B . 12455)
    (?$A%((B . 12456)
    (?$A%)(B . 12457)
    (?$A%*(B . 12458)
    (?$A%+(B . 12459)
    (?$A%,(B . 12460)
    (?$A%-(B . 12461)
    (?$A%.(B . 12462)
    (?$A%/(B . 12463)
    (?$A%0(B . 12464)
    (?$A%1(B . 12465)
    (?$A%2(B . 12466)
    (?$A%3(B . 12467)
    (?$A%4(B . 12468)
    (?$A%5(B . 12469)
    (?$A%6(B . 12470)
    (?$A%7(B . 12471)
    (?$A%8(B . 12472)
    (?$A%9(B . 12473)
    (?$A%:(B . 12474)
    (?$A%;(B . 12475)
    (?$A%<(B . 12476)
    (?$A%=(B . 12477)
    (?$A%>(B . 12478)
    (?$A%?(B . 12479)
    (?$A%@(B . 12480)
    (?$A%A(B . 12481)
    (?$A%B(B . 12482)
    (?$A%C(B . 12483)
    (?$A%D(B . 12484)
    (?$A%E(B . 12485)
    (?$A%F(B . 12486)
    (?$A%G(B . 12487)
    (?$A%H(B . 12488)
    (?$A%I(B . 12489)
    (?$A%J(B . 12490)
    (?$A%K(B . 12491)
    (?$A%L(B . 12492)
    (?$A%M(B . 12493)
    (?$A%N(B . 12494)
    (?$A%O(B . 12495)
    (?$A%P(B . 12496)
    (?$A%Q(B . 12497)
    (?$A%R(B . 12498)
    (?$A%S(B . 12499)
    (?$A%T(B . 12500)
    (?$A%U(B . 12501)
    (?$A%V(B . 12502)
    (?$A%W(B . 12503)
    (?$A%X(B . 12504)
    (?$A%Y(B . 12505)
    (?$A%Z(B . 12506)
    (?$A%[(B . 12507)
    (?$A%\(B . 12508)
    (?$A%](B . 12509)
    (?$A%^(B . 12510)
    (?$A%_(B . 12511)
    (?$A%`(B . 12512)
    (?$A%a(B . 12513)
    (?$A%b(B . 12514)
    (?$A%c(B . 12515)
    (?$A%d(B . 12516)
    (?$A%e(B . 12517)
    (?$A%f(B . 12518)
    (?$A%g(B . 12519)
    (?$A%h(B . 12520)
    (?$A%i(B . 12521)
    (?$A%j(B . 12522)
    (?$A%k(B . 12523)
    (?$A%l(B . 12524)
    (?$A%m(B . 12525)
    (?$A%n(B . 12526)
    (?$A%o(B . 12527)
    (?$A%p(B . 12528)
    (?$A%q(B . 12529)
    (?$A%r(B . 12530)
    (?$A%s(B . 12531)
    (?$A%t(B . 12532)
    (?$A%u(B . 12533)
    (?$A%v(B . 12534)
    (?$A&!(B . 913)
    (?$A&"(B . 914)
    (?$A&#(B . 915)
    (?$A&$(B . 916)
    (?$A&%(B . 917)
    (?$A&&(B . 918)
    (?$A&'(B . 919)
    (?$A&((B . 920)
    (?$A&)(B . 921)
    (?$A&*(B . 922)
    (?$A&+(B . 923)
    (?$A&,(B . 924)
    (?$A&-(B . 925)
    (?$A&.(B . 926)
    (?$A&/(B . 927)
    (?$A&0(B . 928)
    (?$A&1(B . 929)
    (?$A&2(B . 931)
    (?$A&3(B . 932)
    (?$A&4(B . 933)
    (?$A&5(B . 934)
    (?$A&6(B . 935)
    (?$A&7(B . 936)
    (?$A&8(B . 937)
    (?$A&A(B . 945)
    (?$A&B(B . 946)
    (?$A&C(B . 947)
    (?$A&D(B . 948)
    (?$A&E(B . 949)
    (?$A&F(B . 950)
    (?$A&G(B . 951)
    (?$A&H(B . 952)
    (?$A&I(B . 953)
    (?$A&J(B . 954)
    (?$A&K(B . 955)
    (?$A&L(B . 956)
    (?$A&M(B . 957)
    (?$A&N(B . 958)
    (?$A&O(B . 959)
    (?$A&P(B . 960)
    (?$A&Q(B . 961)
    (?$A&R(B . 963)
    (?$A&S(B . 964)
    (?$A&T(B . 965)
    (?$A&U(B . 966)
    (?$A&V(B . 967)
    (?$A&W(B . 968)
    (?$A&X(B . 969)
    (?$A'!(B . 1040)
    (?$A'"(B . 1041)
    (?$A'#(B . 1042)
    (?$A'$(B . 1043)
    (?$A'%(B . 1044)
    (?$A'&(B . 1045)
    (?$A''(B . 1025)
    (?$A'((B . 1046)
    (?$A')(B . 1047)
    (?$A'*(B . 1048)
    (?$A'+(B . 1049)
    (?$A',(B . 1050)
    (?$A'-(B . 1051)
    (?$A'.(B . 1052)
    (?$A'/(B . 1053)
    (?$A'0(B . 1054)
    (?$A'1(B . 1055)
    (?$A'2(B . 1056)
    (?$A'3(B . 1057)
    (?$A'4(B . 1058)
    (?$A'5(B . 1059)
    (?$A'6(B . 1060)
    (?$A'7(B . 1061)
    (?$A'8(B . 1062)
    (?$A'9(B . 1063)
    (?$A':(B . 1064)
    (?$A';(B . 1065)
    (?$A'<(B . 1066)
    (?$A'=(B . 1067)
    (?$A'>(B . 1068)
    (?$A'?(B . 1069)
    (?$A'@(B . 1070)
    (?$A'A(B . 1071)
    (?$A'Q(B . 1072)
    (?$A'R(B . 1073)
    (?$A'S(B . 1074)
    (?$A'T(B . 1075)
    (?$A'U(B . 1076)
    (?$A'V(B . 1077)
    (?$A'W(B . 1105)
    (?$A'X(B . 1078)
    (?$A'Y(B . 1079)
    (?$A'Z(B . 1080)
    (?$A'[(B . 1081)
    (?$A'\(B . 1082)
    (?$A'](B . 1083)
    (?$A'^(B . 1084)
    (?$A'_(B . 1085)
    (?$A'`(B . 1086)
    (?$A'a(B . 1087)
    (?$A'b(B . 1088)
    (?$A'c(B . 1089)
    (?$A'd(B . 1090)
    (?$A'e(B . 1091)
    (?$A'f(B . 1092)
    (?$A'g(B . 1093)
    (?$A'h(B . 1094)
    (?$A'i(B . 1095)
    (?$A'j(B . 1096)
    (?$A'k(B . 1097)
    (?$A'l(B . 1098)
    (?$A'm(B . 1099)
    (?$A'n(B . 1100)
    (?$A'o(B . 1101)
    (?$A'p(B . 1102)
    (?$A'q(B . 1103)
    (?$A(!(B . 257)
    (?$A("(B . 225)
    (?$A(#(B . 462)
    (?$A($(B . 224)
    (?$A(%(B . 275)
    (?$A(&(B . 233)
    (?$A('(B . 283)
    (?$A(((B . 232)
    (?$A()(B . 299)
    (?$A(*(B . 237)
    (?$A(+(B . 464)
    (?$A(,(B . 236)
    (?$A(-(B . 333)
    (?$A(.(B . 243)
    (?$A(/(B . 466)
    (?$A(0(B . 242)
    (?$A(1(B . 363)
    (?$A(2(B . 250)
    (?$A(3(B . 468)
    (?$A(4(B . 249)
    (?$A(5(B . 470)
    (?$A(6(B . 472)
    (?$A(7(B . 474)
    (?$A(8(B . 476)
    (?$A(9(B . 252)
    (?$A(:(B . 234)
    (?$A(E(B . 12549)
    (?$A(F(B . 12550)
    (?$A(G(B . 12551)
    (?$A(H(B . 12552)
    (?$A(I(B . 12553)
    (?$A(J(B . 12554)
    (?$A(K(B . 12555)
    (?$A(L(B . 12556)
    (?$A(M(B . 12557)
    (?$A(N(B . 12558)
    (?$A(O(B . 12559)
    (?$A(P(B . 12560)
    (?$A(Q(B . 12561)
    (?$A(R(B . 12562)
    (?$A(S(B . 12563)
    (?$A(T(B . 12564)
    (?$A(U(B . 12565)
    (?$A(V(B . 12566)
    (?$A(W(B . 12567)
    (?$A(X(B . 12568)
    (?$A(Y(B . 12569)
    (?$A(Z(B . 12570)
    (?$A([(B . 12571)
    (?$A(\(B . 12572)
    (?$A(](B . 12573)
    (?$A(^(B . 12574)
    (?$A(_(B . 12575)
    (?$A(`(B . 12576)
    (?$A(a(B . 12577)
    (?$A(b(B . 12578)
    (?$A(c(B . 12579)
    (?$A(d(B . 12580)
    (?$A(e(B . 12581)
    (?$A(f(B . 12582)
    (?$A(g(B . 12583)
    (?$A(h(B . 12584)
    (?$A(i(B . 12585)
    (?$A)$(B . 9472)
    (?$A)%(B . 9473)
    (?$A)&(B . 9474)
    (?$A)'(B . 9475)
    (?$A)((B . 9476)
    (?$A))(B . 9477)
    (?$A)*(B . 9478)
    (?$A)+(B . 9479)
    (?$A),(B . 9480)
    (?$A)-(B . 9481)
    (?$A).(B . 9482)
    (?$A)/(B . 9483)
    (?$A)0(B . 9484)
    (?$A)1(B . 9485)
    (?$A)2(B . 9486)
    (?$A)3(B . 9487)
    (?$A)4(B . 9488)
    (?$A)5(B . 9489)
    (?$A)6(B . 9490)
    (?$A)7(B . 9491)
    (?$A)8(B . 9492)
    (?$A)9(B . 9493)
    (?$A):(B . 9494)
    (?$A);(B . 9495)
    (?$A)<(B . 9496)
    (?$A)=(B . 9497)
    (?$A)>(B . 9498)
    (?$A)?(B . 9499)
    (?$A)@(B . 9500)
    (?$A)A(B . 9501)
    (?$A)B(B . 9502)
    (?$A)C(B . 9503)
    (?$A)D(B . 9504)
    (?$A)E(B . 9505)
    (?$A)F(B . 9506)
    (?$A)G(B . 9507)
    (?$A)H(B . 9508)
    (?$A)I(B . 9509)
    (?$A)J(B . 9510)
    (?$A)K(B . 9511)
    (?$A)L(B . 9512)
    (?$A)M(B . 9513)
    (?$A)N(B . 9514)
    (?$A)O(B . 9515)
    (?$A)P(B . 9516)
    (?$A)Q(B . 9517)
    (?$A)R(B . 9518)
    (?$A)S(B . 9519)
    (?$A)T(B . 9520)
    (?$A)U(B . 9521)
    (?$A)V(B . 9522)
    (?$A)W(B . 9523)
    (?$A)X(B . 9524)
    (?$A)Y(B . 9525)
    (?$A)Z(B . 9526)
    (?$A)[(B . 9527)
    (?$A)\(B . 9528)
    (?$A)](B . 9529)
    (?$A)^(B . 9530)
    (?$A)_(B . 9531)
    (?$A)`(B . 9532)
    (?$A)a(B . 9533)
    (?$A)b(B . 9534)
    (?$A)c(B . 9535)
    (?$A)d(B . 9536)
    (?$A)e(B . 9537)
    (?$A)f(B . 9538)
    (?$A)g(B . 9539)
    (?$A)h(B . 9540)
    (?$A)i(B . 9541)
    (?$A)j(B . 9542)
    (?$A)k(B . 9543)
    (?$A)l(B . 9544)
    (?$A)m(B . 9545)
    (?$A)n(B . 9546)
    (?$A)o(B . 9547)
    (?$A0!(B . 21834)
    (?$A0"(B . 38463)
    (?$A0#(B . 22467)
    (?$A0$(B . 25384)
    (?$A0%(B . 21710)
    (?$A0&(B . 21769)
    (?$A0'(B . 21696)
    (?$A0((B . 30353)
    (?$A0)(B . 30284)
    (?$A0*(B . 34108)
    (?$A0+(B . 30702)
    (?$A0,(B . 33406)
    (?$A0-(B . 30861)
    (?$A0.(B . 29233)
    (?$A0/(B . 38552)
    (?$A00(B . 38797)
    (?$A01(B . 27688)
    (?$A02(B . 23433)
    (?$A03(B . 20474)
    (?$A04(B . 25353)
    (?$A05(B . 26263)
    (?$A06(B . 23736)
    (?$A07(B . 33018)
    (?$A08(B . 26696)
    (?$A09(B . 32942)
    (?$A0:(B . 26114)
    (?$A0;(B . 30414)
    (?$A0<(B . 20985)
    (?$A0=(B . 25942)
    (?$A0>(B . 29100)
    (?$A0?(B . 32753)
    (?$A0@(B . 34948)
    (?$A0A(B . 20658)
    (?$A0B(B . 22885)
    (?$A0C(B . 25034)
    (?$A0D(B . 28595)
    (?$A0E(B . 33453)
    (?$A0F(B . 25420)
    (?$A0G(B . 25170)
    (?$A0H(B . 21485)
    (?$A0I(B . 21543)
    (?$A0J(B . 31494)
    (?$A0K(B . 20843)
    (?$A0L(B . 30116)
    (?$A0M(B . 24052)
    (?$A0N(B . 25300)
    (?$A0O(B . 36299)
    (?$A0P(B . 38774)
    (?$A0Q(B . 25226)
    (?$A0R(B . 32793)
    (?$A0S(B . 22365)
    (?$A0T(B . 38712)
    (?$A0U(B . 32610)
    (?$A0V(B . 29240)
    (?$A0W(B . 30333)
    (?$A0X(B . 26575)
    (?$A0Y(B . 30334)
    (?$A0Z(B . 25670)
    (?$A0[(B . 20336)
    (?$A0\(B . 36133)
    (?$A0](B . 25308)
    (?$A0^(B . 31255)
    (?$A0_(B . 26001)
    (?$A0`(B . 29677)
    (?$A0a(B . 25644)
    (?$A0b(B . 25203)
    (?$A0c(B . 33324)
    (?$A0d(B . 39041)
    (?$A0e(B . 26495)
    (?$A0f(B . 29256)
    (?$A0g(B . 25198)
    (?$A0h(B . 25292)
    (?$A0i(B . 20276)
    (?$A0j(B . 29923)
    (?$A0k(B . 21322)
    (?$A0l(B . 21150)
    (?$A0m(B . 32458)
    (?$A0n(B . 37030)
    (?$A0o(B . 24110)
    (?$A0p(B . 26758)
    (?$A0q(B . 27036)
    (?$A0r(B . 33152)
    (?$A0s(B . 32465)
    (?$A0t(B . 26834)
    (?$A0u(B . 30917)
    (?$A0v(B . 34444)
    (?$A0w(B . 38225)
    (?$A0x(B . 20621)
    (?$A0y(B . 35876)
    (?$A0z(B . 33502)
    (?$A0{(B . 32990)
    (?$A0|(B . 21253)
    (?$A0}(B . 35090)
    (?$A0~(B . 21093)
    (?$A1!(B . 34180)
    (?$A1"(B . 38649)
    (?$A1#(B . 20445)
    (?$A1$(B . 22561)
    (?$A1%(B . 39281)
    (?$A1&(B . 23453)
    (?$A1'(B . 25265)
    (?$A1((B . 25253)
    (?$A1)(B . 26292)
    (?$A1*(B . 35961)
    (?$A1+(B . 40077)
    (?$A1,(B . 29190)
    (?$A1-(B . 26479)
    (?$A1.(B . 30865)
    (?$A1/(B . 24754)
    (?$A10(B . 21329)
    (?$A11(B . 21271)
    (?$A12(B . 36744)
    (?$A13(B . 32972)
    (?$A14(B . 36125)
    (?$A15(B . 38049)
    (?$A16(B . 20493)
    (?$A17(B . 29384)
    (?$A18(B . 22791)
    (?$A19(B . 24811)
    (?$A1:(B . 28953)
    (?$A1;(B . 34987)
    (?$A1<(B . 22868)
    (?$A1=(B . 33519)
    (?$A1>(B . 26412)
    (?$A1?(B . 31528)
    (?$A1@(B . 23849)
    (?$A1A(B . 32503)
    (?$A1B(B . 29997)
    (?$A1C(B . 27893)
    (?$A1D(B . 36454)
    (?$A1E(B . 36856)
    (?$A1F(B . 36924)
    (?$A1G(B . 40763)
    (?$A1H(B . 27604)
    (?$A1I(B . 37145)
    (?$A1J(B . 31508)
    (?$A1K(B . 24444)
    (?$A1L(B . 30887)
    (?$A1M(B . 34006)
    (?$A1N(B . 34109)
    (?$A1O(B . 27605)
    (?$A1P(B . 27609)
    (?$A1Q(B . 27606)
    (?$A1R(B . 24065)
    (?$A1S(B . 24199)
    (?$A1T(B . 30201)
    (?$A1U(B . 38381)
    (?$A1V(B . 25949)
    (?$A1W(B . 24330)
    (?$A1X(B . 24517)
    (?$A1Y(B . 36767)
    (?$A1Z(B . 22721)
    (?$A1[(B . 33218)
    (?$A1\(B . 36991)
    (?$A1](B . 38491)
    (?$A1^(B . 38829)
    (?$A1_(B . 36793)
    (?$A1`(B . 32534)
    (?$A1a(B . 36140)
    (?$A1b(B . 25153)
    (?$A1c(B . 20415)
    (?$A1d(B . 21464)
    (?$A1e(B . 21342)
    (?$A1f(B . 36776)
    (?$A1g(B . 36777)
    (?$A1h(B . 36779)
    (?$A1i(B . 36941)
    (?$A1j(B . 26631)
    (?$A1k(B . 24426)
    (?$A1l(B . 33176)
    (?$A1m(B . 34920)
    (?$A1n(B . 40150)
    (?$A1o(B . 24971)
    (?$A1p(B . 21035)
    (?$A1q(B . 30250)
    (?$A1r(B . 24428)
    (?$A1s(B . 25996)
    (?$A1t(B . 28626)
    (?$A1u(B . 28392)
    (?$A1v(B . 23486)
    (?$A1w(B . 25672)
    (?$A1x(B . 20853)
    (?$A1y(B . 20912)
    (?$A1z(B . 26564)
    (?$A1{(B . 19993)
    (?$A1|(B . 31177)
    (?$A1}(B . 39292)
    (?$A1~(B . 28851)
    (?$A2!(B . 30149)
    (?$A2"(B . 24182)
    (?$A2#(B . 29627)
    (?$A2$(B . 33760)
    (?$A2%(B . 25773)
    (?$A2&(B . 25320)
    (?$A2'(B . 38069)
    (?$A2((B . 27874)
    (?$A2)(B . 21338)
    (?$A2*(B . 21187)
    (?$A2+(B . 25615)
    (?$A2,(B . 38082)
    (?$A2-(B . 31636)
    (?$A2.(B . 20271)
    (?$A2/(B . 24091)
    (?$A20(B . 33334)
    (?$A21(B . 33046)
    (?$A22(B . 33162)
    (?$A23(B . 28196)
    (?$A24(B . 27850)
    (?$A25(B . 39539)
    (?$A26(B . 25429)
    (?$A27(B . 21340)
    (?$A28(B . 21754)
    (?$A29(B . 34917)
    (?$A2:(B . 22496)
    (?$A2;(B . 19981)
    (?$A2<(B . 24067)
    (?$A2=(B . 27493)
    (?$A2>(B . 31807)
    (?$A2?(B . 37096)
    (?$A2@(B . 24598)
    (?$A2A(B . 25830)
    (?$A2B(B . 29468)
    (?$A2C(B . 35009)
    (?$A2D(B . 26448)
    (?$A2E(B . 25165)
    (?$A2F(B . 36130)
    (?$A2G(B . 30572)
    (?$A2H(B . 36393)
    (?$A2I(B . 37319)
    (?$A2J(B . 24425)
    (?$A2K(B . 33756)
    (?$A2L(B . 34081)
    (?$A2M(B . 39184)
    (?$A2N(B . 21442)
    (?$A2O(B . 34453)
    (?$A2P(B . 27531)
    (?$A2Q(B . 24813)
    (?$A2R(B . 24808)
    (?$A2S(B . 28799)
    (?$A2T(B . 33485)
    (?$A2U(B . 33329)
    (?$A2V(B . 20179)
    (?$A2W(B . 27815)
    (?$A2X(B . 34255)
    (?$A2Y(B . 25805)
    (?$A2Z(B . 31961)
    (?$A2[(B . 27133)
    (?$A2\(B . 26361)
    (?$A2](B . 33609)
    (?$A2^(B . 21397)
    (?$A2_(B . 31574)
    (?$A2`(B . 20391)
    (?$A2a(B . 20876)
    (?$A2b(B . 27979)
    (?$A2c(B . 23618)
    (?$A2d(B . 36461)
    (?$A2e(B . 25554)
    (?$A2f(B . 21449)
    (?$A2g(B . 33580)
    (?$A2h(B . 33590)
    (?$A2i(B . 26597)
    (?$A2j(B . 30900)
    (?$A2k(B . 25661)
    (?$A2l(B . 23519)
    (?$A2m(B . 23700)
    (?$A2n(B . 24046)
    (?$A2o(B . 35815)
    (?$A2p(B . 25286)
    (?$A2q(B . 26612)
    (?$A2r(B . 35962)
    (?$A2s(B . 25600)
    (?$A2t(B . 25530)
    (?$A2u(B . 34633)
    (?$A2v(B . 39307)
    (?$A2w(B . 35863)
    (?$A2x(B . 32544)
    (?$A2y(B . 38130)
    (?$A2z(B . 20135)
    (?$A2{(B . 38416)
    (?$A2|(B . 39076)
    (?$A2}(B . 26124)
    (?$A2~(B . 29462)
    (?$A3!(B . 22330)
    (?$A3"(B . 23581)
    (?$A3#(B . 24120)
    (?$A3$(B . 38271)
    (?$A3%(B . 20607)
    (?$A3&(B . 32928)
    (?$A3'(B . 21378)
    (?$A3((B . 25950)
    (?$A3)(B . 30021)
    (?$A3*(B . 21809)
    (?$A3+(B . 20513)
    (?$A3,(B . 36229)
    (?$A3-(B . 25220)
    (?$A3.(B . 38046)
    (?$A3/(B . 26397)
    (?$A30(B . 22066)
    (?$A31(B . 28526)
    (?$A32(B . 24034)
    (?$A33(B . 21557)
    (?$A34(B . 28818)
    (?$A35(B . 36710)
    (?$A36(B . 25199)
    (?$A37(B . 25764)
    (?$A38(B . 25507)
    (?$A39(B . 24443)
    (?$A3:(B . 28552)
    (?$A3;(B . 37108)
    (?$A3<(B . 33251)
    (?$A3=(B . 36784)
    (?$A3>(B . 23576)
    (?$A3?(B . 26216)
    (?$A3@(B . 24561)
    (?$A3A(B . 27785)
    (?$A3B(B . 38472)
    (?$A3C(B . 36225)
    (?$A3D(B . 34924)
    (?$A3E(B . 25745)
    (?$A3F(B . 31216)
    (?$A3G(B . 22478)
    (?$A3H(B . 27225)
    (?$A3I(B . 25104)
    (?$A3J(B . 21576)
    (?$A3K(B . 20056)
    (?$A3L(B . 31243)
    (?$A3M(B . 24809)
    (?$A3N(B . 28548)
    (?$A3O(B . 35802)
    (?$A3P(B . 25215)
    (?$A3Q(B . 36894)
    (?$A3R(B . 39563)
    (?$A3S(B . 31204)
    (?$A3T(B . 21507)
    (?$A3U(B . 30196)
    (?$A3V(B . 25345)
    (?$A3W(B . 21273)
    (?$A3X(B . 27744)
    (?$A3Y(B . 36831)
    (?$A3Z(B . 24347)
    (?$A3[(B . 39536)
    (?$A3\(B . 32827)
    (?$A3](B . 40831)
    (?$A3^(B . 20360)
    (?$A3_(B . 23610)
    (?$A3`(B . 36196)
    (?$A3a(B . 32709)
    (?$A3b(B . 26021)
    (?$A3c(B . 28861)
    (?$A3d(B . 20805)
    (?$A3e(B . 20914)
    (?$A3f(B . 34411)
    (?$A3g(B . 23815)
    (?$A3h(B . 23456)
    (?$A3i(B . 25277)
    (?$A3j(B . 37228)
    (?$A3k(B . 30068)
    (?$A3l(B . 36364)
    (?$A3m(B . 31264)
    (?$A3n(B . 24833)
    (?$A3o(B . 31609)
    (?$A3p(B . 20167)
    (?$A3q(B . 32504)
    (?$A3r(B . 30597)
    (?$A3s(B . 19985)
    (?$A3t(B . 33261)
    (?$A3u(B . 21021)
    (?$A3v(B . 20986)
    (?$A3w(B . 27249)
    (?$A3x(B . 21416)
    (?$A3y(B . 36487)
    (?$A3z(B . 38148)
    (?$A3{(B . 38607)
    (?$A3|(B . 28353)
    (?$A3}(B . 38500)
    (?$A3~(B . 26970)
    (?$A4!(B . 30784)
    (?$A4"(B . 20648)
    (?$A4#(B . 30679)
    (?$A4$(B . 25616)
    (?$A4%(B . 35302)
    (?$A4&(B . 22788)
    (?$A4'(B . 25571)
    (?$A4((B . 24029)
    (?$A4)(B . 31359)
    (?$A4*(B . 26941)
    (?$A4+(B . 20256)
    (?$A4,(B . 33337)
    (?$A4-(B . 21912)
    (?$A4.(B . 20018)
    (?$A4/(B . 30126)
    (?$A40(B . 31383)
    (?$A41(B . 24162)
    (?$A42(B . 24202)
    (?$A43(B . 38383)
    (?$A44(B . 21019)
    (?$A45(B . 21561)
    (?$A46(B . 28810)
    (?$A47(B . 25462)
    (?$A48(B . 38180)
    (?$A49(B . 22402)
    (?$A4:(B . 26149)
    (?$A4;(B . 26943)
    (?$A4<(B . 37255)
    (?$A4=(B . 21767)
    (?$A4>(B . 28147)
    (?$A4?(B . 32431)
    (?$A4@(B . 34850)
    (?$A4A(B . 25139)
    (?$A4B(B . 32496)
    (?$A4C(B . 30133)
    (?$A4D(B . 33576)
    (?$A4E(B . 30913)
    (?$A4F(B . 38604)
    (?$A4G(B . 36766)
    (?$A4H(B . 24904)
    (?$A4I(B . 29943)
    (?$A4J(B . 35789)
    (?$A4K(B . 27492)
    (?$A4L(B . 21050)
    (?$A4M(B . 36176)
    (?$A4N(B . 27425)
    (?$A4O(B . 32874)
    (?$A4P(B . 33905)
    (?$A4Q(B . 22257)
    (?$A4R(B . 21254)
    (?$A4S(B . 20174)
    (?$A4T(B . 19995)
    (?$A4U(B . 20945)
    (?$A4V(B . 31895)
    (?$A4W(B . 37259)
    (?$A4X(B . 31751)
    (?$A4Y(B . 20419)
    (?$A4Z(B . 36479)
    (?$A4[(B . 31713)
    (?$A4\(B . 31388)
    (?$A4](B . 25703)
    (?$A4^(B . 23828)
    (?$A4_(B . 20652)
    (?$A4`(B . 33030)
    (?$A4a(B . 30209)
    (?$A4b(B . 31929)
    (?$A4c(B . 28140)
    (?$A4d(B . 32736)
    (?$A4e(B . 26449)
    (?$A4f(B . 23384)
    (?$A4g(B . 23544)
    (?$A4h(B . 30923)
    (?$A4i(B . 25774)
    (?$A4j(B . 25619)
    (?$A4k(B . 25514)
    (?$A4l(B . 25387)
    (?$A4m(B . 38169)
    (?$A4n(B . 25645)
    (?$A4o(B . 36798)
    (?$A4p(B . 31572)
    (?$A4q(B . 30249)
    (?$A4r(B . 25171)
    (?$A4s(B . 22823)
    (?$A4t(B . 21574)
    (?$A4u(B . 27513)
    (?$A4v(B . 20643)
    (?$A4w(B . 25140)
    (?$A4x(B . 24102)
    (?$A4y(B . 27526)
    (?$A4z(B . 20195)
    (?$A4{(B . 36151)
    (?$A4|(B . 34955)
    (?$A4}(B . 24453)
    (?$A4~(B . 36910)
    (?$A5!(B . 24608)
    (?$A5"(B . 32829)
    (?$A5#(B . 25285)
    (?$A5$(B . 20025)
    (?$A5%(B . 21333)
    (?$A5&(B . 37112)
    (?$A5'(B . 25528)
    (?$A5((B . 32966)
    (?$A5)(B . 26086)
    (?$A5*(B . 27694)
    (?$A5+(B . 20294)
    (?$A5,(B . 24814)
    (?$A5-(B . 28129)
    (?$A5.(B . 35806)
    (?$A5/(B . 24377)
    (?$A50(B . 34507)
    (?$A51(B . 24403)
    (?$A52(B . 25377)
    (?$A53(B . 20826)
    (?$A54(B . 33633)
    (?$A55(B . 26723)
    (?$A56(B . 20992)
    (?$A57(B . 25443)
    (?$A58(B . 36424)
    (?$A59(B . 20498)
    (?$A5:(B . 23707)
    (?$A5;(B . 31095)
    (?$A5<(B . 23548)
    (?$A5=(B . 21040)
    (?$A5>(B . 31291)
    (?$A5?(B . 24764)
    (?$A5@(B . 36947)
    (?$A5A(B . 30423)
    (?$A5B(B . 24503)
    (?$A5C(B . 24471)
    (?$A5D(B . 30340)
    (?$A5E(B . 36460)
    (?$A5F(B . 28783)
    (?$A5G(B . 30331)
    (?$A5H(B . 31561)
    (?$A5I(B . 30634)
    (?$A5J(B . 20979)
    (?$A5K(B . 37011)
    (?$A5L(B . 22564)
    (?$A5M(B . 20302)
    (?$A5N(B . 28404)
    (?$A5O(B . 36842)
    (?$A5P(B . 25932)
    (?$A5Q(B . 31515)
    (?$A5R(B . 29380)
    (?$A5S(B . 28068)
    (?$A5T(B . 32735)
    (?$A5U(B . 23265)
    (?$A5V(B . 25269)
    (?$A5W(B . 24213)
    (?$A5X(B . 22320)
    (?$A5Y(B . 33922)
    (?$A5Z(B . 31532)
    (?$A5[(B . 24093)
    (?$A5\(B . 24351)
    (?$A5](B . 36882)
    (?$A5^(B . 32532)
    (?$A5_(B . 39072)
    (?$A5`(B . 25474)
    (?$A5a(B . 28359)
    (?$A5b(B . 30872)
    (?$A5c(B . 28857)
    (?$A5d(B . 20856)
    (?$A5e(B . 38747)
    (?$A5f(B . 22443)
    (?$A5g(B . 30005)
    (?$A5h(B . 20291)
    (?$A5i(B . 30008)
    (?$A5j(B . 24215)
    (?$A5k(B . 24806)
    (?$A5l(B . 22880)
    (?$A5m(B . 28096)
    (?$A5n(B . 27583)
    (?$A5o(B . 30857)
    (?$A5p(B . 21500)
    (?$A5q(B . 38613)
    (?$A5r(B . 20939)
    (?$A5s(B . 20993)
    (?$A5t(B . 25481)
    (?$A5u(B . 21514)
    (?$A5v(B . 38035)
    (?$A5w(B . 35843)
    (?$A5x(B . 36300)
    (?$A5y(B . 29241)
    (?$A5z(B . 30879)
    (?$A5{(B . 34678)
    (?$A5|(B . 36845)
    (?$A5}(B . 35853)
    (?$A5~(B . 21472)
    (?$A6!(B . 19969)
    (?$A6"(B . 30447)
    (?$A6#(B . 21486)
    (?$A6$(B . 38025)
    (?$A6%(B . 39030)
    (?$A6&(B . 40718)
    (?$A6'(B . 38189)
    (?$A6((B . 23450)
    (?$A6)(B . 35746)
    (?$A6*(B . 20002)
    (?$A6+(B . 19996)
    (?$A6,(B . 20908)
    (?$A6-(B . 33891)
    (?$A6.(B . 25026)
    (?$A6/(B . 21160)
    (?$A60(B . 26635)
    (?$A61(B . 20375)
    (?$A62(B . 24683)
    (?$A63(B . 20923)
    (?$A64(B . 27934)
    (?$A65(B . 20828)
    (?$A66(B . 25238)
    (?$A67(B . 26007)
    (?$A68(B . 38497)
    (?$A69(B . 35910)
    (?$A6:(B . 36887)
    (?$A6;(B . 30168)
    (?$A6<(B . 37117)
    (?$A6=(B . 30563)
    (?$A6>(B . 27602)
    (?$A6?(B . 29322)
    (?$A6@(B . 29420)
    (?$A6A(B . 35835)
    (?$A6B(B . 22581)
    (?$A6C(B . 30585)
    (?$A6D(B . 36172)
    (?$A6E(B . 26460)
    (?$A6F(B . 38208)
    (?$A6G(B . 32922)
    (?$A6H(B . 24230)
    (?$A6I(B . 28193)
    (?$A6J(B . 22930)
    (?$A6K(B . 31471)
    (?$A6L(B . 30701)
    (?$A6M(B . 38203)
    (?$A6N(B . 27573)
    (?$A6O(B . 26029)
    (?$A6P(B . 32526)
    (?$A6Q(B . 22534)
    (?$A6R(B . 20817)
    (?$A6S(B . 38431)
    (?$A6T(B . 23545)
    (?$A6U(B . 22697)
    (?$A6V(B . 21544)
    (?$A6W(B . 36466)
    (?$A6X(B . 25958)
    (?$A6Y(B . 39039)
    (?$A6Z(B . 22244)
    (?$A6[(B . 38045)
    (?$A6\(B . 30462)
    (?$A6](B . 36929)
    (?$A6^(B . 25479)
    (?$A6_(B . 21702)
    (?$A6`(B . 22810)
    (?$A6a(B . 22842)
    (?$A6b(B . 22427)
    (?$A6c(B . 36530)
    (?$A6d(B . 26421)
    (?$A6e(B . 36346)
    (?$A6f(B . 33333)
    (?$A6g(B . 21057)
    (?$A6h(B . 24816)
    (?$A6i(B . 22549)
    (?$A6j(B . 34558)
    (?$A6k(B . 23784)
    (?$A6l(B . 40517)
    (?$A6m(B . 20420)
    (?$A6n(B . 39069)
    (?$A6o(B . 35769)
    (?$A6p(B . 23077)
    (?$A6q(B . 24694)
    (?$A6r(B . 21380)
    (?$A6s(B . 25212)
    (?$A6t(B . 36943)
    (?$A6u(B . 37122)
    (?$A6v(B . 39295)
    (?$A6w(B . 24681)
    (?$A6x(B . 32780)
    (?$A6y(B . 20799)
    (?$A6z(B . 32819)
    (?$A6{(B . 23572)
    (?$A6|(B . 39285)
    (?$A6}(B . 27953)
    (?$A6~(B . 20108)
    (?$A7!(B . 36144)
    (?$A7"(B . 21457)
    (?$A7#(B . 32602)
    (?$A7$(B . 31567)
    (?$A7%(B . 20240)
    (?$A7&(B . 20047)
    (?$A7'(B . 38400)
    (?$A7((B . 27861)
    (?$A7)(B . 29648)
    (?$A7*(B . 34281)
    (?$A7+(B . 24070)
    (?$A7,(B . 30058)
    (?$A7-(B . 32763)
    (?$A7.(B . 27146)
    (?$A7/(B . 30718)
    (?$A70(B . 38034)
    (?$A71(B . 32321)
    (?$A72(B . 20961)
    (?$A73(B . 28902)
    (?$A74(B . 21453)
    (?$A75(B . 36820)
    (?$A76(B . 33539)
    (?$A77(B . 36137)
    (?$A78(B . 29359)
    (?$A79(B . 39277)
    (?$A7:(B . 27867)
    (?$A7;(B . 22346)
    (?$A7<(B . 33459)
    (?$A7=(B . 26041)
    (?$A7>(B . 32938)
    (?$A7?(B . 25151)
    (?$A7@(B . 38450)
    (?$A7A(B . 22952)
    (?$A7B(B . 20223)
    (?$A7C(B . 35775)
    (?$A7D(B . 32442)
    (?$A7E(B . 25918)
    (?$A7F(B . 33778)
    (?$A7G(B . 38750)
    (?$A7H(B . 21857)
    (?$A7I(B . 39134)
    (?$A7J(B . 32933)
    (?$A7K(B . 21290)
    (?$A7L(B . 35837)
    (?$A7M(B . 21536)
    (?$A7N(B . 32954)
    (?$A7O(B . 24223)
    (?$A7P(B . 27832)
    (?$A7Q(B . 36153)
    (?$A7R(B . 33452)
    (?$A7S(B . 37210)
    (?$A7T(B . 21545)
    (?$A7U(B . 27675)
    (?$A7V(B . 20998)
    (?$A7W(B . 32439)
    (?$A7X(B . 22367)
    (?$A7Y(B . 28954)
    (?$A7Z(B . 27774)
    (?$A7[(B . 31881)
    (?$A7\(B . 22859)
    (?$A7](B . 20221)
    (?$A7^(B . 24575)
    (?$A7_(B . 24868)
    (?$A7`(B . 31914)
    (?$A7a(B . 20016)
    (?$A7b(B . 23553)
    (?$A7c(B . 26539)
    (?$A7d(B . 34562)
    (?$A7e(B . 23792)
    (?$A7f(B . 38155)
    (?$A7g(B . 39118)
    (?$A7h(B . 30127)
    (?$A7i(B . 28925)
    (?$A7j(B . 36898)
    (?$A7k(B . 20911)
    (?$A7l(B . 32541)
    (?$A7m(B . 35773)
    (?$A7n(B . 22857)
    (?$A7o(B . 20964)
    (?$A7p(B . 20315)
    (?$A7q(B . 21542)
    (?$A7r(B . 22827)
    (?$A7s(B . 25975)
    (?$A7t(B . 32932)
    (?$A7u(B . 23413)
    (?$A7v(B . 25206)
    (?$A7w(B . 25282)
    (?$A7x(B . 36752)
    (?$A7y(B . 24133)
    (?$A7z(B . 27679)
    (?$A7{(B . 31526)
    (?$A7|(B . 20239)
    (?$A7}(B . 20440)
    (?$A7~(B . 26381)
    (?$A8!(B . 28014)
    (?$A8"(B . 28074)
    (?$A8#(B . 31119)
    (?$A8$(B . 34993)
    (?$A8%(B . 24343)
    (?$A8&(B . 29995)
    (?$A8'(B . 25242)
    (?$A8((B . 36741)
    (?$A8)(B . 20463)
    (?$A8*(B . 37340)
    (?$A8+(B . 26023)
    (?$A8,(B . 33071)
    (?$A8-(B . 33105)
    (?$A8.(B . 24220)
    (?$A8/(B . 33104)
    (?$A80(B . 36212)
    (?$A81(B . 21103)
    (?$A82(B . 35206)
    (?$A83(B . 36171)
    (?$A84(B . 22797)
    (?$A85(B . 20613)
    (?$A86(B . 20184)
    (?$A87(B . 38428)
    (?$A88(B . 29238)
    (?$A89(B . 33145)
    (?$A8:(B . 36127)
    (?$A8;(B . 23500)
    (?$A8<(B . 35747)
    (?$A8=(B . 38468)
    (?$A8>(B . 22919)
    (?$A8?(B . 32538)
    (?$A8@(B . 21648)
    (?$A8A(B . 22134)
    (?$A8B(B . 22030)
    (?$A8C(B . 35813)
    (?$A8D(B . 25913)
    (?$A8E(B . 27010)
    (?$A8F(B . 38041)
    (?$A8G(B . 30422)
    (?$A8H(B . 28297)
    (?$A8I(B . 24178)
    (?$A8J(B . 29976)
    (?$A8K(B . 26438)
    (?$A8L(B . 26577)
    (?$A8M(B . 31487)
    (?$A8N(B . 32925)
    (?$A8O(B . 36214)
    (?$A8P(B . 24863)
    (?$A8Q(B . 31174)
    (?$A8R(B . 25954)
    (?$A8S(B . 36195)
    (?$A8T(B . 20872)
    (?$A8U(B . 21018)
    (?$A8V(B . 38050)
    (?$A8W(B . 32568)
    (?$A8X(B . 32923)
    (?$A8Y(B . 32434)
    (?$A8Z(B . 23703)
    (?$A8[(B . 28207)
    (?$A8\(B . 26464)
    (?$A8](B . 31705)
    (?$A8^(B . 30347)
    (?$A8_(B . 39640)
    (?$A8`(B . 33167)
    (?$A8a(B . 32660)
    (?$A8b(B . 31957)
    (?$A8c(B . 25630)
    (?$A8d(B . 38224)
    (?$A8e(B . 31295)
    (?$A8f(B . 21578)
    (?$A8g(B . 21733)
    (?$A8h(B . 27468)
    (?$A8i(B . 25601)
    (?$A8j(B . 25096)
    (?$A8k(B . 40509)
    (?$A8l(B . 33011)
    (?$A8m(B . 30105)
    (?$A8n(B . 21106)
    (?$A8o(B . 38761)
    (?$A8p(B . 33883)
    (?$A8q(B . 26684)
    (?$A8r(B . 34532)
    (?$A8s(B . 38401)
    (?$A8t(B . 38548)
    (?$A8u(B . 38124)
    (?$A8v(B . 20010)
    (?$A8w(B . 21508)
    (?$A8x(B . 32473)
    (?$A8y(B . 26681)
    (?$A8z(B . 36319)
    (?$A8{(B . 32789)
    (?$A8|(B . 26356)
    (?$A8}(B . 24218)
    (?$A8~(B . 32697)
    (?$A9!(B . 22466)
    (?$A9"(B . 32831)
    (?$A9#(B . 26775)
    (?$A9$(B . 24037)
    (?$A9%(B . 25915)
    (?$A9&(B . 21151)
    (?$A9'(B . 24685)
    (?$A9((B . 40858)
    (?$A9)(B . 20379)
    (?$A9*(B . 36524)
    (?$A9+(B . 20844)
    (?$A9,(B . 23467)
    (?$A9-(B . 24339)
    (?$A9.(B . 24041)
    (?$A9/(B . 27742)
    (?$A90(B . 25329)
    (?$A91(B . 36129)
    (?$A92(B . 20849)
    (?$A93(B . 38057)
    (?$A94(B . 21246)
    (?$A95(B . 27807)
    (?$A96(B . 33503)
    (?$A97(B . 29399)
    (?$A98(B . 22434)
    (?$A99(B . 26500)
    (?$A9:(B . 36141)
    (?$A9;(B . 22815)
    (?$A9<(B . 36764)
    (?$A9=(B . 33735)
    (?$A9>(B . 21653)
    (?$A9?(B . 31629)
    (?$A9@(B . 20272)
    (?$A9A(B . 27837)
    (?$A9B(B . 23396)
    (?$A9C(B . 22993)
    (?$A9D(B . 40723)
    (?$A9E(B . 21476)
    (?$A9F(B . 34506)
    (?$A9G(B . 39592)
    (?$A9H(B . 35895)
    (?$A9I(B . 32929)
    (?$A9J(B . 25925)
    (?$A9K(B . 39038)
    (?$A9L(B . 22266)
    (?$A9M(B . 38599)
    (?$A9N(B . 21038)
    (?$A9O(B . 29916)
    (?$A9P(B . 21072)
    (?$A9Q(B . 23521)
    (?$A9R(B . 25346)
    (?$A9S(B . 35074)
    (?$A9T(B . 20054)
    (?$A9U(B . 25296)
    (?$A9V(B . 24618)
    (?$A9W(B . 26874)
    (?$A9X(B . 20851)
    (?$A9Y(B . 23448)
    (?$A9Z(B . 20896)
    (?$A9[(B . 35266)
    (?$A9\(B . 31649)
    (?$A9](B . 39302)
    (?$A9^(B . 32592)
    (?$A9_(B . 24815)
    (?$A9`(B . 28748)
    (?$A9a(B . 36143)
    (?$A9b(B . 20809)
    (?$A9c(B . 24191)
    (?$A9d(B . 36891)
    (?$A9e(B . 29808)
    (?$A9f(B . 35268)
    (?$A9g(B . 22317)
    (?$A9h(B . 30789)
    (?$A9i(B . 24402)
    (?$A9j(B . 40863)
    (?$A9k(B . 38394)
    (?$A9l(B . 36712)
    (?$A9m(B . 39740)
    (?$A9n(B . 35809)
    (?$A9o(B . 30328)
    (?$A9p(B . 26690)
    (?$A9q(B . 26588)
    (?$A9r(B . 36330)
    (?$A9s(B . 36149)
    (?$A9t(B . 21053)
    (?$A9u(B . 36746)
    (?$A9v(B . 28378)
    (?$A9w(B . 26829)
    (?$A9x(B . 38149)
    (?$A9y(B . 37101)
    (?$A9z(B . 22269)
    (?$A9{(B . 26524)
    (?$A9|(B . 35065)
    (?$A9}(B . 36807)
    (?$A9~(B . 21704)
    (?$A:!(B . 39608)
    (?$A:"(B . 23401)
    (?$A:#(B . 28023)
    (?$A:$(B . 27686)
    (?$A:%(B . 20133)
    (?$A:&(B . 23475)
    (?$A:'(B . 39559)
    (?$A:((B . 37219)
    (?$A:)(B . 25000)
    (?$A:*(B . 37039)
    (?$A:+(B . 38889)
    (?$A:,(B . 21547)
    (?$A:-(B . 28085)
    (?$A:.(B . 23506)
    (?$A:/(B . 20989)
    (?$A:0(B . 21898)
    (?$A:1(B . 32597)
    (?$A:2(B . 32752)
    (?$A:3(B . 25788)
    (?$A:4(B . 25421)
    (?$A:5(B . 26097)
    (?$A:6(B . 25022)
    (?$A:7(B . 24717)
    (?$A:8(B . 28938)
    (?$A:9(B . 27735)
    (?$A::(B . 27721)
    (?$A:;(B . 22831)
    (?$A:<(B . 26477)
    (?$A:=(B . 33322)
    (?$A:>(B . 22741)
    (?$A:?(B . 22158)
    (?$A:@(B . 35946)
    (?$A:A(B . 27627)
    (?$A:B(B . 37085)
    (?$A:C(B . 22909)
    (?$A:D(B . 32791)
    (?$A:E(B . 21495)
    (?$A:F(B . 28009)
    (?$A:G(B . 21621)
    (?$A:H(B . 21917)
    (?$A:I(B . 33655)
    (?$A:J(B . 33743)
    (?$A:K(B . 26680)
    (?$A:L(B . 31166)
    (?$A:M(B . 21644)
    (?$A:N(B . 20309)
    (?$A:O(B . 21512)
    (?$A:P(B . 30418)
    (?$A:Q(B . 35977)
    (?$A:R(B . 38402)
    (?$A:S(B . 27827)
    (?$A:T(B . 28088)
    (?$A:U(B . 36203)
    (?$A:V(B . 35088)
    (?$A:W(B . 40548)
    (?$A:X(B . 36154)
    (?$A:Y(B . 22079)
    (?$A:Z(B . 40657)
    (?$A:[(B . 30165)
    (?$A:\(B . 24456)
    (?$A:](B . 29408)
    (?$A:^(B . 24680)
    (?$A:_(B . 21756)
    (?$A:`(B . 20136)
    (?$A:a(B . 27178)
    (?$A:b(B . 34913)
    (?$A:c(B . 24658)
    (?$A:d(B . 36720)
    (?$A:e(B . 21700)
    (?$A:f(B . 28888)
    (?$A:g(B . 34425)
    (?$A:h(B . 40511)
    (?$A:i(B . 27946)
    (?$A:j(B . 23439)
    (?$A:k(B . 24344)
    (?$A:l(B . 32418)
    (?$A:m(B . 21897)
    (?$A:n(B . 20399)
    (?$A:o(B . 29492)
    (?$A:p(B . 21564)
    (?$A:q(B . 21402)
    (?$A:r(B . 20505)
    (?$A:s(B . 21518)
    (?$A:t(B . 21628)
    (?$A:u(B . 20046)
    (?$A:v(B . 24573)
    (?$A:w(B . 29786)
    (?$A:x(B . 22774)
    (?$A:y(B . 33899)
    (?$A:z(B . 32993)
    (?$A:{(B . 34676)
    (?$A:|(B . 29392)
    (?$A:}(B . 31946)
    (?$A:~(B . 28246)
    (?$A;!(B . 24359)
    (?$A;"(B . 34382)
    (?$A;#(B . 21804)
    (?$A;$(B . 25252)
    (?$A;%(B . 20114)
    (?$A;&(B . 27818)
    (?$A;'(B . 25143)
    (?$A;((B . 33457)
    (?$A;)(B . 21719)
    (?$A;*(B . 21326)
    (?$A;+(B . 29502)
    (?$A;,(B . 28369)
    (?$A;-(B . 30011)
    (?$A;.(B . 21010)
    (?$A;/(B . 21270)
    (?$A;0(B . 35805)
    (?$A;1(B . 27088)
    (?$A;2(B . 24458)
    (?$A;3(B . 24576)
    (?$A;4(B . 28142)
    (?$A;5(B . 22351)
    (?$A;6(B . 27426)
    (?$A;7(B . 29615)
    (?$A;8(B . 26707)
    (?$A;9(B . 36824)
    (?$A;:(B . 32531)
    (?$A;;(B . 25442)
    (?$A;<(B . 24739)
    (?$A;=(B . 21796)
    (?$A;>(B . 30186)
    (?$A;?(B . 35938)
    (?$A;@(B . 28949)
    (?$A;A(B . 28067)
    (?$A;B(B . 23462)
    (?$A;C(B . 24187)
    (?$A;D(B . 33618)
    (?$A;E(B . 24908)
    (?$A;F(B . 40644)
    (?$A;G(B . 30970)
    (?$A;H(B . 34647)
    (?$A;I(B . 31783)
    (?$A;J(B . 30343)
    (?$A;K(B . 20976)
    (?$A;L(B . 24822)
    (?$A;M(B . 29004)
    (?$A;N(B . 26179)
    (?$A;O(B . 24140)
    (?$A;P(B . 24653)
    (?$A;Q(B . 35854)
    (?$A;R(B . 28784)
    (?$A;S(B . 25381)
    (?$A;T(B . 36745)
    (?$A;U(B . 24509)
    (?$A;V(B . 24674)
    (?$A;W(B . 34516)
    (?$A;X(B . 22238)
    (?$A;Y(B . 27585)
    (?$A;Z(B . 24724)
    (?$A;[(B . 24935)
    (?$A;\(B . 21321)
    (?$A;](B . 24800)
    (?$A;^(B . 26214)
    (?$A;_(B . 36159)
    (?$A;`(B . 31229)
    (?$A;a(B . 20250)
    (?$A;b(B . 28905)
    (?$A;c(B . 27719)
    (?$A;d(B . 35763)
    (?$A;e(B . 35826)
    (?$A;f(B . 32472)
    (?$A;g(B . 33636)
    (?$A;h(B . 26127)
    (?$A;i(B . 23130)
    (?$A;j(B . 39746)
    (?$A;k(B . 27985)
    (?$A;l(B . 28151)
    (?$A;m(B . 35905)
    (?$A;n(B . 27963)
    (?$A;o(B . 20249)
    (?$A;p(B . 28779)
    (?$A;q(B . 33719)
    (?$A;r(B . 25110)
    (?$A;s(B . 24785)
    (?$A;t(B . 38669)
    (?$A;u(B . 36135)
    (?$A;v(B . 31096)
    (?$A;w(B . 20987)
    (?$A;x(B . 22334)
    (?$A;y(B . 22522)
    (?$A;z(B . 26426)
    (?$A;{(B . 30072)
    (?$A;|(B . 31293)
    (?$A;}(B . 31215)
    (?$A;~(B . 31637)
    (?$A<!(B . 32908)
    (?$A<"(B . 39269)
    (?$A<#(B . 36857)
    (?$A<$(B . 28608)
    (?$A<%(B . 35749)
    (?$A<&(B . 40481)
    (?$A<'(B . 23020)
    (?$A<((B . 32489)
    (?$A<)(B . 32521)
    (?$A<*(B . 21513)
    (?$A<+(B . 26497)
    (?$A<,(B . 26840)
    (?$A<-(B . 36753)
    (?$A<.(B . 31821)
    (?$A</(B . 38598)
    (?$A<0(B . 21450)
    (?$A<1(B . 24613)
    (?$A<2(B . 30142)
    (?$A<3(B . 27762)
    (?$A<4(B . 21363)
    (?$A<5(B . 23241)
    (?$A<6(B . 32423)
    (?$A<7(B . 25380)
    (?$A<8(B . 20960)
    (?$A<9(B . 33034)
    (?$A<:(B . 24049)
    (?$A<;(B . 34015)
    (?$A<<(B . 25216)
    (?$A<=(B . 20864)
    (?$A<>(B . 23395)
    (?$A<?(B . 20238)
    (?$A<@(B . 31085)
    (?$A<A(B . 21058)
    (?$A<B(B . 24760)
    (?$A<C(B . 27982)
    (?$A<D(B . 23492)
    (?$A<E(B . 23490)
    (?$A<F(B . 35745)
    (?$A<G(B . 35760)
    (?$A<H(B . 26082)
    (?$A<I(B . 24524)
    (?$A<J(B . 38469)
    (?$A<K(B . 22931)
    (?$A<L(B . 32487)
    (?$A<M(B . 32426)
    (?$A<N(B . 22025)
    (?$A<O(B . 26551)
    (?$A<P(B . 22841)
    (?$A<Q(B . 20339)
    (?$A<R(B . 23478)
    (?$A<S(B . 21152)
    (?$A<T(B . 33626)
    (?$A<U(B . 39050)
    (?$A<V(B . 36158)
    (?$A<W(B . 30002)
    (?$A<X(B . 38078)
    (?$A<Y(B . 20551)
    (?$A<Z(B . 31292)
    (?$A<[(B . 20215)
    (?$A<\(B . 26550)
    (?$A<](B . 39550)
    (?$A<^(B . 23233)
    (?$A<_(B . 27516)
    (?$A<`(B . 30417)
    (?$A<a(B . 22362)
    (?$A<b(B . 23574)
    (?$A<c(B . 31546)
    (?$A<d(B . 38388)
    (?$A<e(B . 29006)
    (?$A<f(B . 20860)
    (?$A<g(B . 32937)
    (?$A<h(B . 33392)
    (?$A<i(B . 22904)
    (?$A<j(B . 32516)
    (?$A<k(B . 33575)
    (?$A<l(B . 26816)
    (?$A<m(B . 26604)
    (?$A<n(B . 30897)
    (?$A<o(B . 30839)
    (?$A<p(B . 25315)
    (?$A<q(B . 25441)
    (?$A<r(B . 31616)
    (?$A<s(B . 20461)
    (?$A<t(B . 21098)
    (?$A<u(B . 20943)
    (?$A<v(B . 33616)
    (?$A<w(B . 27099)
    (?$A<x(B . 37492)
    (?$A<y(B . 36341)
    (?$A<z(B . 36145)
    (?$A<{(B . 35265)
    (?$A<|(B . 38190)
    (?$A<}(B . 31661)
    (?$A<~(B . 20214)
    (?$A=!(B . 20581)
    (?$A="(B . 33328)
    (?$A=#(B . 21073)
    (?$A=$(B . 39279)
    (?$A=%(B . 28176)
    (?$A=&(B . 28293)
    (?$A='(B . 28071)
    (?$A=((B . 24314)
    (?$A=)(B . 20725)
    (?$A=*(B . 23004)
    (?$A=+(B . 23558)
    (?$A=,(B . 27974)
    (?$A=-(B . 27743)
    (?$A=.(B . 30086)
    (?$A=/(B . 33931)
    (?$A=0(B . 26728)
    (?$A=1(B . 22870)
    (?$A=2(B . 35762)
    (?$A=3(B . 21280)
    (?$A=4(B . 37233)
    (?$A=5(B . 38477)
    (?$A=6(B . 34121)
    (?$A=7(B . 26898)
    (?$A=8(B . 30977)
    (?$A=9(B . 28966)
    (?$A=:(B . 33014)
    (?$A=;(B . 20132)
    (?$A=<(B . 37066)
    (?$A==(B . 27975)
    (?$A=>(B . 39556)
    (?$A=?(B . 23047)
    (?$A=@(B . 22204)
    (?$A=A(B . 25605)
    (?$A=B(B . 38128)
    (?$A=C(B . 30699)
    (?$A=D(B . 20389)
    (?$A=E(B . 33050)
    (?$A=F(B . 29409)
    (?$A=G(B . 35282)
    (?$A=H(B . 39290)
    (?$A=I(B . 32564)
    (?$A=J(B . 32478)
    (?$A=K(B . 21119)
    (?$A=L(B . 25945)
    (?$A=M(B . 37237)
    (?$A=N(B . 36735)
    (?$A=O(B . 36739)
    (?$A=P(B . 21483)
    (?$A=Q(B . 31382)
    (?$A=R(B . 25581)
    (?$A=S(B . 25509)
    (?$A=T(B . 30342)
    (?$A=U(B . 31224)
    (?$A=V(B . 34903)
    (?$A=W(B . 38454)
    (?$A=X(B . 25130)
    (?$A=Y(B . 21163)
    (?$A=Z(B . 33410)
    (?$A=[(B . 26708)
    (?$A=\(B . 26480)
    (?$A=](B . 25463)
    (?$A=^(B . 30571)
    (?$A=_(B . 31469)
    (?$A=`(B . 27905)
    (?$A=a(B . 32467)
    (?$A=b(B . 35299)
    (?$A=c(B . 22992)
    (?$A=d(B . 25106)
    (?$A=e(B . 34249)
    (?$A=f(B . 33445)
    (?$A=g(B . 30028)
    (?$A=h(B . 20511)
    (?$A=i(B . 20171)
    (?$A=j(B . 30117)
    (?$A=k(B . 35819)
    (?$A=l(B . 23626)
    (?$A=m(B . 24062)
    (?$A=n(B . 31563)
    (?$A=o(B . 26020)
    (?$A=p(B . 37329)
    (?$A=q(B . 20170)
    (?$A=r(B . 27941)
    (?$A=s(B . 35167)
    (?$A=t(B . 32039)
    (?$A=u(B . 38182)
    (?$A=v(B . 20165)
    (?$A=w(B . 35880)
    (?$A=x(B . 36827)
    (?$A=y(B . 38771)
    (?$A=z(B . 26187)
    (?$A={(B . 31105)
    (?$A=|(B . 36817)
    (?$A=}(B . 28908)
    (?$A=~(B . 28024)
    (?$A>!(B . 23613)
    (?$A>"(B . 21170)
    (?$A>#(B . 33606)
    (?$A>$(B . 20834)
    (?$A>%(B . 33550)
    (?$A>&(B . 30555)
    (?$A>'(B . 26230)
    (?$A>((B . 40120)
    (?$A>)(B . 20140)
    (?$A>*(B . 24778)
    (?$A>+(B . 31934)
    (?$A>,(B . 31923)
    (?$A>-(B . 32463)
    (?$A>.(B . 20117)
    (?$A>/(B . 35686)
    (?$A>0(B . 26223)
    (?$A>1(B . 39048)
    (?$A>2(B . 38745)
    (?$A>3(B . 22659)
    (?$A>4(B . 25964)
    (?$A>5(B . 38236)
    (?$A>6(B . 24452)
    (?$A>7(B . 30153)
    (?$A>8(B . 38742)
    (?$A>9(B . 31455)
    (?$A>:(B . 31454)
    (?$A>;(B . 20928)
    (?$A><(B . 28847)
    (?$A>=(B . 31384)
    (?$A>>(B . 25578)
    (?$A>?(B . 31350)
    (?$A>@(B . 32416)
    (?$A>A(B . 29590)
    (?$A>B(B . 38893)
    (?$A>C(B . 20037)
    (?$A>D(B . 28792)
    (?$A>E(B . 20061)
    (?$A>F(B . 37202)
    (?$A>G(B . 21417)
    (?$A>H(B . 25937)
    (?$A>I(B . 26087)
    (?$A>J(B . 33276)
    (?$A>K(B . 33285)
    (?$A>L(B . 21646)
    (?$A>M(B . 23601)
    (?$A>N(B . 30106)
    (?$A>O(B . 38816)
    (?$A>P(B . 25304)
    (?$A>Q(B . 29401)
    (?$A>R(B . 30141)
    (?$A>S(B . 23621)
    (?$A>T(B . 39545)
    (?$A>U(B . 33738)
    (?$A>V(B . 23616)
    (?$A>W(B . 21632)
    (?$A>X(B . 30697)
    (?$A>Y(B . 20030)
    (?$A>Z(B . 27822)
    (?$A>[(B . 32858)
    (?$A>\(B . 25298)
    (?$A>](B . 25454)
    (?$A>^(B . 24040)
    (?$A>_(B . 20855)
    (?$A>`(B . 36317)
    (?$A>a(B . 36382)
    (?$A>b(B . 38191)
    (?$A>c(B . 20465)
    (?$A>d(B . 21477)
    (?$A>e(B . 24807)
    (?$A>f(B . 28844)
    (?$A>g(B . 21095)
    (?$A>h(B . 25424)
    (?$A>i(B . 40515)
    (?$A>j(B . 23071)
    (?$A>k(B . 20518)
    (?$A>l(B . 30519)
    (?$A>m(B . 21367)
    (?$A>n(B . 32482)
    (?$A>o(B . 25733)
    (?$A>p(B . 25899)
    (?$A>q(B . 25225)
    (?$A>r(B . 25496)
    (?$A>s(B . 20500)
    (?$A>t(B . 29237)
    (?$A>u(B . 35273)
    (?$A>v(B . 20915)
    (?$A>w(B . 35776)
    (?$A>x(B . 32477)
    (?$A>y(B . 22343)
    (?$A>z(B . 33740)
    (?$A>{(B . 38055)
    (?$A>|(B . 20891)
    (?$A>}(B . 21531)
    (?$A>~(B . 23803)
    (?$A?!(B . 20426)
    (?$A?"(B . 31459)
    (?$A?#(B . 27994)
    (?$A?$(B . 37089)
    (?$A?%(B . 39567)
    (?$A?&(B . 21888)
    (?$A?'(B . 21654)
    (?$A?((B . 21345)
    (?$A?)(B . 21679)
    (?$A?*(B . 24320)
    (?$A?+(B . 25577)
    (?$A?,(B . 26999)
    (?$A?-(B . 20975)
    (?$A?.(B . 24936)
    (?$A?/(B . 21002)
    (?$A?0(B . 22570)
    (?$A?1(B . 21208)
    (?$A?2(B . 22350)
    (?$A?3(B . 30733)
    (?$A?4(B . 30475)
    (?$A?5(B . 24247)
    (?$A?6(B . 24951)
    (?$A?7(B . 31968)
    (?$A?8(B . 25179)
    (?$A?9(B . 25239)
    (?$A?:(B . 20130)
    (?$A?;(B . 28821)
    (?$A?<(B . 32771)
    (?$A?=(B . 25335)
    (?$A?>(B . 28900)
    (?$A??(B . 38752)
    (?$A?@(B . 22391)
    (?$A?A(B . 33499)
    (?$A?B(B . 26607)
    (?$A?C(B . 26869)
    (?$A?D(B . 30933)
    (?$A?E(B . 39063)
    (?$A?F(B . 31185)
    (?$A?G(B . 22771)
    (?$A?H(B . 21683)
    (?$A?I(B . 21487)
    (?$A?J(B . 28212)
    (?$A?K(B . 20811)
    (?$A?L(B . 21051)
    (?$A?M(B . 23458)
    (?$A?N(B . 35838)
    (?$A?O(B . 32943)
    (?$A?P(B . 21827)
    (?$A?Q(B . 22438)
    (?$A?R(B . 24691)
    (?$A?S(B . 22353)
    (?$A?T(B . 21549)
    (?$A?U(B . 31354)
    (?$A?V(B . 24656)
    (?$A?W(B . 23380)
    (?$A?X(B . 25511)
    (?$A?Y(B . 25248)
    (?$A?Z(B . 21475)
    (?$A?[(B . 25187)
    (?$A?\(B . 23495)
    (?$A?](B . 26543)
    (?$A?^(B . 21741)
    (?$A?_(B . 31391)
    (?$A?`(B . 33510)
    (?$A?a(B . 37239)
    (?$A?b(B . 24211)
    (?$A?c(B . 35044)
    (?$A?d(B . 22840)
    (?$A?e(B . 22446)
    (?$A?f(B . 25358)
    (?$A?g(B . 36328)
    (?$A?h(B . 33007)
    (?$A?i(B . 22359)
    (?$A?j(B . 31607)
    (?$A?k(B . 20393)
    (?$A?l(B . 24555)
    (?$A?m(B . 23485)
    (?$A?n(B . 27454)
    (?$A?o(B . 21281)
    (?$A?p(B . 31568)
    (?$A?q(B . 29378)
    (?$A?r(B . 26694)
    (?$A?s(B . 30719)
    (?$A?t(B . 30518)
    (?$A?u(B . 26103)
    (?$A?v(B . 20917)
    (?$A?w(B . 20111)
    (?$A?x(B . 30420)
    (?$A?y(B . 23743)
    (?$A?z(B . 31397)
    (?$A?{(B . 33909)
    (?$A?|(B . 22862)
    (?$A?}(B . 39745)
    (?$A?~(B . 20608)
    (?$A@!(B . 39304)
    (?$A@"(B . 24871)
    (?$A@#(B . 28291)
    (?$A@$(B . 22372)
    (?$A@%(B . 26118)
    (?$A@&(B . 25414)
    (?$A@'(B . 22256)
    (?$A@((B . 25324)
    (?$A@)(B . 25193)
    (?$A@*(B . 24275)
    (?$A@+(B . 38420)
    (?$A@,(B . 22403)
    (?$A@-(B . 25289)
    (?$A@.(B . 21895)
    (?$A@/(B . 34593)
    (?$A@0(B . 33098)
    (?$A@1(B . 36771)
    (?$A@2(B . 21862)
    (?$A@3(B . 33713)
    (?$A@4(B . 26469)
    (?$A@5(B . 36182)
    (?$A@6(B . 34013)
    (?$A@7(B . 23146)
    (?$A@8(B . 26639)
    (?$A@9(B . 25318)
    (?$A@:(B . 31726)
    (?$A@;(B . 38417)
    (?$A@<(B . 20848)
    (?$A@=(B . 28572)
    (?$A@>(B . 35888)
    (?$A@?(B . 25597)
    (?$A@@(B . 35272)
    (?$A@A(B . 25042)
    (?$A@B(B . 32518)
    (?$A@C(B . 28866)
    (?$A@D(B . 28389)
    (?$A@E(B . 29701)
    (?$A@F(B . 27028)
    (?$A@G(B . 29436)
    (?$A@H(B . 24266)
    (?$A@I(B . 37070)
    (?$A@J(B . 26391)
    (?$A@K(B . 28010)
    (?$A@L(B . 25438)
    (?$A@M(B . 21171)
    (?$A@N(B . 29282)
    (?$A@O(B . 32769)
    (?$A@P(B . 20332)
    (?$A@Q(B . 23013)
    (?$A@R(B . 37226)
    (?$A@S(B . 28889)
    (?$A@T(B . 28061)
    (?$A@U(B . 21202)
    (?$A@V(B . 20048)
    (?$A@W(B . 38647)
    (?$A@X(B . 38253)
    (?$A@Y(B . 34174)
    (?$A@Z(B . 30922)
    (?$A@[(B . 32047)
    (?$A@\(B . 20769)
    (?$A@](B . 22418)
    (?$A@^(B . 25794)
    (?$A@_(B . 32907)
    (?$A@`(B . 31867)
    (?$A@a(B . 27882)
    (?$A@b(B . 26865)
    (?$A@c(B . 26974)
    (?$A@d(B . 20919)
    (?$A@e(B . 21400)
    (?$A@f(B . 26792)
    (?$A@g(B . 29313)
    (?$A@h(B . 40654)
    (?$A@i(B . 31729)
    (?$A@j(B . 29432)
    (?$A@k(B . 31163)
    (?$A@l(B . 28435)
    (?$A@m(B . 29702)
    (?$A@n(B . 26446)
    (?$A@o(B . 37324)
    (?$A@p(B . 40100)
    (?$A@q(B . 31036)
    (?$A@r(B . 33673)
    (?$A@s(B . 33620)
    (?$A@t(B . 21519)
    (?$A@u(B . 26647)
    (?$A@v(B . 20029)
    (?$A@w(B . 21385)
    (?$A@x(B . 21169)
    (?$A@y(B . 30782)
    (?$A@z(B . 21382)
    (?$A@{(B . 21033)
    (?$A@|(B . 20616)
    (?$A@}(B . 20363)
    (?$A@~(B . 20432)
    (?$AA!(B . 30178)
    (?$AA"(B . 31435)
    (?$AA#(B . 31890)
    (?$AA$(B . 27813)
    (?$AA%(B . 38582)
    (?$AA&(B . 21147)
    (?$AA'(B . 29827)
    (?$AA((B . 21737)
    (?$AA)(B . 20457)
    (?$AA*(B . 32852)
    (?$AA+(B . 33714)
    (?$AA,(B . 36830)
    (?$AA-(B . 38256)
    (?$AA.(B . 24265)
    (?$AA/(B . 24604)
    (?$AA0(B . 28063)
    (?$AA1(B . 24088)
    (?$AA2(B . 25947)
    (?$AA3(B . 33080)
    (?$AA4(B . 38142)
    (?$AA5(B . 24651)
    (?$AA6(B . 28860)
    (?$AA7(B . 32451)
    (?$AA8(B . 31918)
    (?$AA9(B . 20937)
    (?$AA:(B . 26753)
    (?$AA;(B . 31921)
    (?$AA<(B . 33391)
    (?$AA=(B . 20004)
    (?$AA>(B . 36742)
    (?$AA?(B . 37327)
    (?$AA@(B . 26238)
    (?$AAA(B . 20142)
    (?$AAB(B . 35845)
    (?$AAC(B . 25769)
    (?$AAD(B . 32842)
    (?$AAE(B . 20698)
    (?$AAF(B . 30103)
    (?$AAG(B . 29134)
    (?$AAH(B . 23525)
    (?$AAI(B . 36797)
    (?$AAJ(B . 28518)
    (?$AAK(B . 20102)
    (?$AAL(B . 25730)
    (?$AAM(B . 38243)
    (?$AAN(B . 24278)
    (?$AAO(B . 26009)
    (?$AAP(B . 21015)
    (?$AAQ(B . 35010)
    (?$AAR(B . 28872)
    (?$AAS(B . 21155)
    (?$AAT(B . 29454)
    (?$AAU(B . 29747)
    (?$AAV(B . 26519)
    (?$AAW(B . 30967)
    (?$AAX(B . 38678)
    (?$AAY(B . 20020)
    (?$AAZ(B . 37051)
    (?$AA[(B . 40158)
    (?$AA\(B . 28107)
    (?$AA](B . 20955)
    (?$AA^(B . 36161)
    (?$AA_(B . 21533)
    (?$AA`(B . 25294)
    (?$AAa(B . 29618)
    (?$AAb(B . 33777)
    (?$AAc(B . 38646)
    (?$AAd(B . 40836)
    (?$AAe(B . 38083)
    (?$AAf(B . 20278)
    (?$AAg(B . 32666)
    (?$AAh(B . 20940)
    (?$AAi(B . 28789)
    (?$AAj(B . 38517)
    (?$AAk(B . 23725)
    (?$AAl(B . 39046)
    (?$AAm(B . 21478)
    (?$AAn(B . 20196)
    (?$AAo(B . 28316)
    (?$AAp(B . 29705)
    (?$AAq(B . 27060)
    (?$AAr(B . 30827)
    (?$AAs(B . 39311)
    (?$AAt(B . 30041)
    (?$AAu(B . 21016)
    (?$AAv(B . 30244)
    (?$AAw(B . 27969)
    (?$AAx(B . 26611)
    (?$AAy(B . 20845)
    (?$AAz(B . 40857)
    (?$AA{(B . 32843)
    (?$AA|(B . 21657)
    (?$AA}(B . 31548)
    (?$AA~(B . 31423)
    (?$AB!(B . 38534)
    (?$AB"(B . 22404)
    (?$AB#(B . 25314)
    (?$AB$(B . 38471)
    (?$AB%(B . 27004)
    (?$AB&(B . 23044)
    (?$AB'(B . 25602)
    (?$AB((B . 31699)
    (?$AB)(B . 28431)
    (?$AB*(B . 38475)
    (?$AB+(B . 33446)
    (?$AB,(B . 21346)
    (?$AB-(B . 39045)
    (?$AB.(B . 24208)
    (?$AB/(B . 28809)
    (?$AB0(B . 25523)
    (?$AB1(B . 21348)
    (?$AB2(B . 34383)
    (?$AB3(B . 40065)
    (?$AB4(B . 40595)
    (?$AB5(B . 30860)
    (?$AB6(B . 38706)
    (?$AB7(B . 36335)
    (?$AB8(B . 36162)
    (?$AB9(B . 40575)
    (?$AB:(B . 28510)
    (?$AB;(B . 31108)
    (?$AB<(B . 24405)
    (?$AB=(B . 38470)
    (?$AB>(B . 25134)
    (?$AB?(B . 39540)
    (?$AB@(B . 21525)
    (?$ABA(B . 38109)
    (?$ABB(B . 20387)
    (?$ABC(B . 26053)
    (?$ABD(B . 23653)
    (?$ABE(B . 23649)
    (?$ABF(B . 32533)
    (?$ABG(B . 34385)
    (?$ABH(B . 27695)
    (?$ABI(B . 24459)
    (?$ABJ(B . 29575)
    (?$ABK(B . 28388)
    (?$ABL(B . 32511)
    (?$ABM(B . 23782)
    (?$ABN(B . 25371)
    (?$ABO(B . 23402)
    (?$ABP(B . 28390)
    (?$ABQ(B . 21365)
    (?$ABR(B . 20081)
    (?$ABS(B . 25504)
    (?$ABT(B . 30053)
    (?$ABU(B . 25249)
    (?$ABV(B . 36718)
    (?$ABW(B . 20262)
    (?$ABX(B . 20177)
    (?$ABY(B . 27814)
    (?$ABZ(B . 32438)
    (?$AB[(B . 35770)
    (?$AB\(B . 33821)
    (?$AB](B . 34746)
    (?$AB^(B . 32599)
    (?$AB_(B . 36923)
    (?$AB`(B . 38179)
    (?$ABa(B . 31657)
    (?$ABb(B . 39585)
    (?$ABc(B . 35064)
    (?$ABd(B . 33853)
    (?$ABe(B . 27931)
    (?$ABf(B . 39558)
    (?$ABg(B . 32476)
    (?$ABh(B . 22920)
    (?$ABi(B . 40635)
    (?$ABj(B . 29595)
    (?$ABk(B . 30721)
    (?$ABl(B . 34434)
    (?$ABm(B . 39532)
    (?$ABn(B . 39554)
    (?$ABo(B . 22043)
    (?$ABp(B . 21527)
    (?$ABq(B . 22475)
    (?$ABr(B . 20080)
    (?$ABs(B . 40614)
    (?$ABt(B . 21334)
    (?$ABu(B . 36808)
    (?$ABv(B . 33033)
    (?$ABw(B . 30610)
    (?$ABx(B . 39314)
    (?$ABy(B . 34542)
    (?$ABz(B . 28385)
    (?$AB{(B . 34067)
    (?$AB|(B . 26364)
    (?$AB}(B . 24930)
    (?$AB~(B . 28459)
    (?$AC!(B . 35881)
    (?$AC"(B . 33426)
    (?$AC#(B . 33579)
    (?$AC$(B . 30450)
    (?$AC%(B . 27667)
    (?$AC&(B . 24537)
    (?$AC'(B . 33725)
    (?$AC((B . 29483)
    (?$AC)(B . 33541)
    (?$AC*(B . 38170)
    (?$AC+(B . 27611)
    (?$AC,(B . 30683)
    (?$AC-(B . 38086)
    (?$AC.(B . 21359)
    (?$AC/(B . 33538)
    (?$AC0(B . 20882)
    (?$AC1(B . 24125)
    (?$AC2(B . 35980)
    (?$AC3(B . 36152)
    (?$AC4(B . 20040)
    (?$AC5(B . 29611)
    (?$AC6(B . 26522)
    (?$AC7(B . 26757)
    (?$AC8(B . 37238)
    (?$AC9(B . 38665)
    (?$AC:(B . 29028)
    (?$AC;(B . 27809)
    (?$AC<(B . 30473)
    (?$AC=(B . 23186)
    (?$AC>(B . 38209)
    (?$AC?(B . 27599)
    (?$AC@(B . 32654)
    (?$ACA(B . 26151)
    (?$ACB(B . 23504)
    (?$ACC(B . 22969)
    (?$ACD(B . 23194)
    (?$ACE(B . 38376)
    (?$ACF(B . 38391)
    (?$ACG(B . 20204)
    (?$ACH(B . 33804)
    (?$ACI(B . 33945)
    (?$ACJ(B . 27308)
    (?$ACK(B . 30431)
    (?$ACL(B . 38192)
    (?$ACM(B . 29467)
    (?$ACN(B . 26790)
    (?$ACO(B . 23391)
    (?$ACP(B . 30511)
    (?$ACQ(B . 37274)
    (?$ACR(B . 38753)
    (?$ACS(B . 31964)
    (?$ACT(B . 36855)
    (?$ACU(B . 35868)
    (?$ACV(B . 24357)
    (?$ACW(B . 31859)
    (?$ACX(B . 31192)
    (?$ACY(B . 35269)
    (?$ACZ(B . 27852)
    (?$AC[(B . 34588)
    (?$AC\(B . 23494)
    (?$AC](B . 24130)
    (?$AC^(B . 26825)
    (?$AC_(B . 30496)
    (?$AC`(B . 32501)
    (?$ACa(B . 20885)
    (?$ACb(B . 20813)
    (?$ACc(B . 21193)
    (?$ACd(B . 23081)
    (?$ACe(B . 32517)
    (?$ACf(B . 38754)
    (?$ACg(B . 33495)
    (?$ACh(B . 25551)
    (?$ACi(B . 30596)
    (?$ACj(B . 34256)
    (?$ACk(B . 31186)
    (?$ACl(B . 28218)
    (?$ACm(B . 24217)
    (?$ACn(B . 22937)
    (?$ACo(B . 34065)
    (?$ACp(B . 28781)
    (?$ACq(B . 27665)
    (?$ACr(B . 25279)
    (?$ACs(B . 30399)
    (?$ACt(B . 25935)
    (?$ACu(B . 24751)
    (?$ACv(B . 38397)
    (?$ACw(B . 26126)
    (?$ACx(B . 34719)
    (?$ACy(B . 40483)
    (?$ACz(B . 38125)
    (?$AC{(B . 21517)
    (?$AC|(B . 21629)
    (?$AC}(B . 35884)
    (?$AC~(B . 25720)
    (?$AD!(B . 25721)
    (?$AD"(B . 34321)
    (?$AD#(B . 27169)
    (?$AD$(B . 33180)
    (?$AD%(B . 30952)
    (?$AD&(B . 25705)
    (?$AD'(B . 39764)
    (?$AD((B . 25273)
    (?$AD)(B . 26411)
    (?$AD*(B . 33707)
    (?$AD+(B . 22696)
    (?$AD,(B . 40664)
    (?$AD-(B . 27819)
    (?$AD.(B . 28448)
    (?$AD/(B . 23518)
    (?$AD0(B . 38476)
    (?$AD1(B . 35851)
    (?$AD2(B . 29279)
    (?$AD3(B . 26576)
    (?$AD4(B . 25287)
    (?$AD5(B . 29281)
    (?$AD6(B . 20137)
    (?$AD7(B . 22982)
    (?$AD8(B . 27597)
    (?$AD9(B . 22675)
    (?$AD:(B . 26286)
    (?$AD;(B . 24149)
    (?$AD<(B . 21215)
    (?$AD=(B . 24917)
    (?$AD>(B . 26408)
    (?$AD?(B . 30446)
    (?$AD@(B . 30566)
    (?$ADA(B . 29287)
    (?$ADB(B . 31302)
    (?$ADC(B . 25343)
    (?$ADD(B . 21738)
    (?$ADE(B . 21584)
    (?$ADF(B . 38048)
    (?$ADG(B . 37027)
    (?$ADH(B . 23068)
    (?$ADI(B . 32435)
    (?$ADJ(B . 27670)
    (?$ADK(B . 20035)
    (?$ADL(B . 22902)
    (?$ADM(B . 32784)
    (?$ADN(B . 22856)
    (?$ADO(B . 21335)
    (?$ADP(B . 30007)
    (?$ADQ(B . 38590)
    (?$ADR(B . 22218)
    (?$ADS(B . 25376)
    (?$ADT(B . 33041)
    (?$ADU(B . 24700)
    (?$ADV(B . 38393)
    (?$ADW(B . 28118)
    (?$ADX(B . 21602)
    (?$ADY(B . 39297)
    (?$ADZ(B . 20869)
    (?$AD[(B . 23273)
    (?$AD\(B . 33021)
    (?$AD](B . 22958)
    (?$AD^(B . 38675)
    (?$AD_(B . 20522)
    (?$AD`(B . 27877)
    (?$ADa(B . 23612)
    (?$ADb(B . 25311)
    (?$ADc(B . 20320)
    (?$ADd(B . 21311)
    (?$ADe(B . 33147)
    (?$ADf(B . 36870)
    (?$ADg(B . 28346)
    (?$ADh(B . 34091)
    (?$ADi(B . 25288)
    (?$ADj(B . 24180)
    (?$ADk(B . 30910)
    (?$ADl(B . 25781)
    (?$ADm(B . 25467)
    (?$ADn(B . 24565)
    (?$ADo(B . 23064)
    (?$ADp(B . 37247)
    (?$ADq(B . 40479)
    (?$ADr(B . 23615)
    (?$ADs(B . 25423)
    (?$ADt(B . 32834)
    (?$ADu(B . 23421)
    (?$ADv(B . 21870)
    (?$ADw(B . 38218)
    (?$ADx(B . 38221)
    (?$ADy(B . 28037)
    (?$ADz(B . 24744)
    (?$AD{(B . 26592)
    (?$AD|(B . 29406)
    (?$AD}(B . 20957)
    (?$AD~(B . 23425)
    (?$AE!(B . 25319)
    (?$AE"(B . 27870)
    (?$AE#(B . 29275)
    (?$AE$(B . 25197)
    (?$AE%(B . 38062)
    (?$AE&(B . 32445)
    (?$AE'(B . 33043)
    (?$AE((B . 27987)
    (?$AE)(B . 20892)
    (?$AE*(B . 24324)
    (?$AE+(B . 22900)
    (?$AE,(B . 21162)
    (?$AE-(B . 24594)
    (?$AE.(B . 22899)
    (?$AE/(B . 26262)
    (?$AE0(B . 34384)
    (?$AE1(B . 30111)
    (?$AE2(B . 25386)
    (?$AE3(B . 25062)
    (?$AE4(B . 31983)
    (?$AE5(B . 35834)
    (?$AE6(B . 21734)
    (?$AE7(B . 27431)
    (?$AE8(B . 40485)
    (?$AE9(B . 27572)
    (?$AE:(B . 34261)
    (?$AE;(B . 21589)
    (?$AE<(B . 20598)
    (?$AE=(B . 27812)
    (?$AE>(B . 21866)
    (?$AE?(B . 36276)
    (?$AE@(B . 29228)
    (?$AEA(B . 24085)
    (?$AEB(B . 24597)
    (?$AEC(B . 29750)
    (?$AED(B . 25293)
    (?$AEE(B . 25490)
    (?$AEF(B . 29260)
    (?$AEG(B . 24472)
    (?$AEH(B . 28227)
    (?$AEI(B . 27966)
    (?$AEJ(B . 25856)
    (?$AEK(B . 28504)
    (?$AEL(B . 30424)
    (?$AEM(B . 30928)
    (?$AEN(B . 30460)
    (?$AEO(B . 30036)
    (?$AEP(B . 21028)
    (?$AEQ(B . 21467)
    (?$AER(B . 20051)
    (?$AES(B . 24222)
    (?$AET(B . 26049)
    (?$AEU(B . 32810)
    (?$AEV(B . 32982)
    (?$AEW(B . 25243)
    (?$AEX(B . 21638)
    (?$AEY(B . 21032)
    (?$AEZ(B . 28846)
    (?$AE[(B . 34957)
    (?$AE\(B . 36305)
    (?$AE](B . 27873)
    (?$AE^(B . 21624)
    (?$AE_(B . 32986)
    (?$AE`(B . 22521)
    (?$AEa(B . 35060)
    (?$AEb(B . 36180)
    (?$AEc(B . 38506)
    (?$AEd(B . 37197)
    (?$AEe(B . 20329)
    (?$AEf(B . 27803)
    (?$AEg(B . 21943)
    (?$AEh(B . 30406)
    (?$AEi(B . 30768)
    (?$AEj(B . 25256)
    (?$AEk(B . 28921)
    (?$AEl(B . 28558)
    (?$AEm(B . 24429)
    (?$AEn(B . 34028)
    (?$AEo(B . 26842)
    (?$AEp(B . 30844)
    (?$AEq(B . 31735)
    (?$AEr(B . 33192)
    (?$AEs(B . 26379)
    (?$AEt(B . 40527)
    (?$AEu(B . 25447)
    (?$AEv(B . 30896)
    (?$AEw(B . 22383)
    (?$AEx(B . 30738)
    (?$AEy(B . 38713)
    (?$AEz(B . 25209)
    (?$AE{(B . 25259)
    (?$AE|(B . 21128)
    (?$AE}(B . 29749)
    (?$AE~(B . 27607)
    (?$AF!(B . 21860)
    (?$AF"(B . 33086)
    (?$AF#(B . 30130)
    (?$AF$(B . 30382)
    (?$AF%(B . 21305)
    (?$AF&(B . 30174)
    (?$AF'(B . 20731)
    (?$AF((B . 23617)
    (?$AF)(B . 35692)
    (?$AF*(B . 31687)
    (?$AF+(B . 20559)
    (?$AF,(B . 29255)
    (?$AF-(B . 39575)
    (?$AF.(B . 39128)
    (?$AF/(B . 28418)
    (?$AF0(B . 29922)
    (?$AF1(B . 31080)
    (?$AF2(B . 25735)
    (?$AF3(B . 30629)
    (?$AF4(B . 25340)
    (?$AF5(B . 39057)
    (?$AF6(B . 36139)
    (?$AF7(B . 21697)
    (?$AF8(B . 32856)
    (?$AF9(B . 20050)
    (?$AF:(B . 22378)
    (?$AF;(B . 33529)
    (?$AF<(B . 33805)
    (?$AF=(B . 24179)
    (?$AF>(B . 20973)
    (?$AF?(B . 29942)
    (?$AF@(B . 35780)
    (?$AFA(B . 23631)
    (?$AFB(B . 22369)
    (?$AFC(B . 27900)
    (?$AFD(B . 39047)
    (?$AFE(B . 23110)
    (?$AFF(B . 30772)
    (?$AFG(B . 39748)
    (?$AFH(B . 36843)
    (?$AFI(B . 31893)
    (?$AFJ(B . 21078)
    (?$AFK(B . 25169)
    (?$AFL(B . 38138)
    (?$AFM(B . 20166)
    (?$AFN(B . 33670)
    (?$AFO(B . 33889)
    (?$AFP(B . 33769)
    (?$AFQ(B . 33970)
    (?$AFR(B . 22484)
    (?$AFS(B . 26420)
    (?$AFT(B . 22275)
    (?$AFU(B . 26222)
    (?$AFV(B . 28006)
    (?$AFW(B . 35889)
    (?$AFX(B . 26333)
    (?$AFY(B . 28689)
    (?$AFZ(B . 26399)
    (?$AF[(B . 27450)
    (?$AF\(B . 26646)
    (?$AF](B . 25114)
    (?$AF^(B . 22971)
    (?$AF_(B . 19971)
    (?$AF`(B . 20932)
    (?$AFa(B . 28422)
    (?$AFb(B . 26578)
    (?$AFc(B . 27791)
    (?$AFd(B . 20854)
    (?$AFe(B . 26827)
    (?$AFf(B . 22855)
    (?$AFg(B . 27495)
    (?$AFh(B . 30054)
    (?$AFi(B . 23822)
    (?$AFj(B . 33040)
    (?$AFk(B . 40784)
    (?$AFl(B . 26071)
    (?$AFm(B . 31048)
    (?$AFn(B . 31041)
    (?$AFo(B . 39569)
    (?$AFp(B . 36215)
    (?$AFq(B . 23682)
    (?$AFr(B . 20062)
    (?$AFs(B . 20225)
    (?$AFt(B . 21551)
    (?$AFu(B . 22865)
    (?$AFv(B . 30732)
    (?$AFw(B . 22120)
    (?$AFx(B . 27668)
    (?$AFy(B . 36804)
    (?$AFz(B . 24323)
    (?$AF{(B . 27773)
    (?$AF|(B . 27875)
    (?$AF}(B . 35755)
    (?$AF~(B . 25488)
    (?$AG!(B . 24688)
    (?$AG"(B . 27965)
    (?$AG#(B . 29301)
    (?$AG$(B . 25190)
    (?$AG%(B . 38030)
    (?$AG&(B . 38085)
    (?$AG'(B . 21315)
    (?$AG((B . 36801)
    (?$AG)(B . 31614)
    (?$AG*(B . 20191)
    (?$AG+(B . 35878)
    (?$AG,(B . 20094)
    (?$AG-(B . 40660)
    (?$AG.(B . 38065)
    (?$AG/(B . 38067)
    (?$AG0(B . 21069)
    (?$AG1(B . 28508)
    (?$AG2(B . 36963)
    (?$AG3(B . 27973)
    (?$AG4(B . 35892)
    (?$AG5(B . 22545)
    (?$AG6(B . 23884)
    (?$AG7(B . 27424)
    (?$AG8(B . 27465)
    (?$AG9(B . 26538)
    (?$AG:(B . 21595)
    (?$AG;(B . 33108)
    (?$AG<(B . 32652)
    (?$AG=(B . 22681)
    (?$AG>(B . 34103)
    (?$AG?(B . 24378)
    (?$AG@(B . 25250)
    (?$AGA(B . 27207)
    (?$AGB(B . 38201)
    (?$AGC(B . 25970)
    (?$AGD(B . 24708)
    (?$AGE(B . 26725)
    (?$AGF(B . 30631)
    (?$AGG(B . 20052)
    (?$AGH(B . 20392)
    (?$AGI(B . 24039)
    (?$AGJ(B . 38808)
    (?$AGK(B . 25772)
    (?$AGL(B . 32728)
    (?$AGM(B . 23789)
    (?$AGN(B . 20431)
    (?$AGO(B . 31373)
    (?$AGP(B . 20999)
    (?$AGQ(B . 33540)
    (?$AGR(B . 19988)
    (?$AGS(B . 24623)
    (?$AGT(B . 31363)
    (?$AGU(B . 38054)
    (?$AGV(B . 20405)
    (?$AGW(B . 20146)
    (?$AGX(B . 31206)
    (?$AGY(B . 29748)
    (?$AGZ(B . 21220)
    (?$AG[(B . 33465)
    (?$AG\(B . 25810)
    (?$AG](B . 31165)
    (?$AG^(B . 23517)
    (?$AG_(B . 27777)
    (?$AG`(B . 38738)
    (?$AGa(B . 36731)
    (?$AGb(B . 27682)
    (?$AGc(B . 20542)
    (?$AGd(B . 21375)
    (?$AGe(B . 28165)
    (?$AGf(B . 25806)
    (?$AGg(B . 26228)
    (?$AGh(B . 27696)
    (?$AGi(B . 24773)
    (?$AGj(B . 39031)
    (?$AGk(B . 35831)
    (?$AGl(B . 24198)
    (?$AGm(B . 29756)
    (?$AGn(B . 31351)
    (?$AGo(B . 31179)
    (?$AGp(B . 19992)
    (?$AGq(B . 37041)
    (?$AGr(B . 29699)
    (?$AGs(B . 27714)
    (?$AGt(B . 22234)
    (?$AGu(B . 37195)
    (?$AGv(B . 27845)
    (?$AGw(B . 36235)
    (?$AGx(B . 21306)
    (?$AGy(B . 34502)
    (?$AGz(B . 26354)
    (?$AG{(B . 36527)
    (?$AG|(B . 23624)
    (?$AG}(B . 39537)
    (?$AG~(B . 28192)
    (?$AH!(B . 21462)
    (?$AH"(B . 23094)
    (?$AH#(B . 40843)
    (?$AH$(B . 36259)
    (?$AH%(B . 21435)
    (?$AH&(B . 22280)
    (?$AH'(B . 39079)
    (?$AH((B . 26435)
    (?$AH)(B . 37275)
    (?$AH*(B . 27849)
    (?$AH+(B . 20840)
    (?$AH,(B . 30154)
    (?$AH-(B . 25331)
    (?$AH.(B . 29356)
    (?$AH/(B . 21048)
    (?$AH0(B . 21149)
    (?$AH1(B . 32570)
    (?$AH2(B . 28820)
    (?$AH3(B . 30264)
    (?$AH4(B . 21364)
    (?$AH5(B . 40522)
    (?$AH6(B . 27063)
    (?$AH7(B . 30830)
    (?$AH8(B . 38592)
    (?$AH9(B . 35033)
    (?$AH:(B . 32676)
    (?$AH;(B . 28982)
    (?$AH<(B . 29123)
    (?$AH=(B . 20873)
    (?$AH>(B . 26579)
    (?$AH?(B . 29924)
    (?$AH@(B . 22756)
    (?$AHA(B . 25880)
    (?$AHB(B . 22199)
    (?$AHC(B . 35753)
    (?$AHD(B . 39286)
    (?$AHE(B . 25200)
    (?$AHF(B . 32469)
    (?$AHG(B . 24825)
    (?$AHH(B . 28909)
    (?$AHI(B . 22764)
    (?$AHJ(B . 20161)
    (?$AHK(B . 20154)
    (?$AHL(B . 24525)
    (?$AHM(B . 38887)
    (?$AHN(B . 20219)
    (?$AHO(B . 35748)
    (?$AHP(B . 20995)
    (?$AHQ(B . 22922)
    (?$AHR(B . 32427)
    (?$AHS(B . 25172)
    (?$AHT(B . 20173)
    (?$AHU(B . 26085)
    (?$AHV(B . 25102)
    (?$AHW(B . 33592)
    (?$AHX(B . 33993)
    (?$AHY(B . 33635)
    (?$AHZ(B . 34701)
    (?$AH[(B . 29076)
    (?$AH\(B . 28342)
    (?$AH](B . 23481)
    (?$AH^(B . 32466)
    (?$AH_(B . 20887)
    (?$AH`(B . 25545)
    (?$AHa(B . 26580)
    (?$AHb(B . 32905)
    (?$AHc(B . 33593)
    (?$AHd(B . 34837)
    (?$AHe(B . 20754)
    (?$AHf(B . 23418)
    (?$AHg(B . 22914)
    (?$AHh(B . 36785)
    (?$AHi(B . 20083)
    (?$AHj(B . 27741)
    (?$AHk(B . 20837)
    (?$AHl(B . 35109)
    (?$AHm(B . 36719)
    (?$AHn(B . 38446)
    (?$AHo(B . 34122)
    (?$AHp(B . 29790)
    (?$AHq(B . 38160)
    (?$AHr(B . 38384)
    (?$AHs(B . 28070)
    (?$AHt(B . 33509)
    (?$AHu(B . 24369)
    (?$AHv(B . 25746)
    (?$AHw(B . 27922)
    (?$AHx(B . 33832)
    (?$AHy(B . 33134)
    (?$AHz(B . 40131)
    (?$AH{(B . 22622)
    (?$AH|(B . 36187)
    (?$AH}(B . 19977)
    (?$AH~(B . 21441)
    (?$AI!(B . 20254)
    (?$AI"(B . 25955)
    (?$AI#(B . 26705)
    (?$AI$(B . 21971)
    (?$AI%(B . 20007)
    (?$AI&(B . 25620)
    (?$AI'(B . 39578)
    (?$AI((B . 25195)
    (?$AI)(B . 23234)
    (?$AI*(B . 29791)
    (?$AI+(B . 33394)
    (?$AI,(B . 28073)
    (?$AI-(B . 26862)
    (?$AI.(B . 20711)
    (?$AI/(B . 33678)
    (?$AI0(B . 30722)
    (?$AI1(B . 26432)
    (?$AI2(B . 21049)
    (?$AI3(B . 27801)
    (?$AI4(B . 32433)
    (?$AI5(B . 20667)
    (?$AI6(B . 21861)
    (?$AI7(B . 29022)
    (?$AI8(B . 31579)
    (?$AI9(B . 26194)
    (?$AI:(B . 29642)
    (?$AI;(B . 33515)
    (?$AI<(B . 26441)
    (?$AI=(B . 23665)
    (?$AI>(B . 21024)
    (?$AI?(B . 29053)
    (?$AI@(B . 34923)
    (?$AIA(B . 38378)
    (?$AIB(B . 38485)
    (?$AIC(B . 25797)
    (?$AID(B . 36193)
    (?$AIE(B . 33203)
    (?$AIF(B . 21892)
    (?$AIG(B . 27733)
    (?$AIH(B . 25159)
    (?$AII(B . 32558)
    (?$AIJ(B . 22674)
    (?$AIK(B . 20260)
    (?$AIL(B . 21830)
    (?$AIM(B . 36175)
    (?$AIN(B . 26188)
    (?$AIO(B . 19978)
    (?$AIP(B . 23578)
    (?$AIQ(B . 35059)
    (?$AIR(B . 26786)
    (?$AIS(B . 25422)
    (?$AIT(B . 31245)
    (?$AIU(B . 28903)
    (?$AIV(B . 33421)
    (?$AIW(B . 21242)
    (?$AIX(B . 38902)
    (?$AIY(B . 23569)
    (?$AIZ(B . 21736)
    (?$AI[(B . 37045)
    (?$AI\(B . 32461)
    (?$AI](B . 22882)
    (?$AI^(B . 36170)
    (?$AI_(B . 34503)
    (?$AI`(B . 33292)
    (?$AIa(B . 33293)
    (?$AIb(B . 36198)
    (?$AIc(B . 25668)
    (?$AId(B . 23556)
    (?$AIe(B . 24913)
    (?$AIf(B . 28041)
    (?$AIg(B . 31038)
    (?$AIh(B . 35774)
    (?$AIi(B . 30775)
    (?$AIj(B . 30003)
    (?$AIk(B . 21627)
    (?$AIl(B . 20280)
    (?$AIm(B . 36523)
    (?$AIn(B . 28145)
    (?$AIo(B . 23072)
    (?$AIp(B . 32453)
    (?$AIq(B . 31070)
    (?$AIr(B . 27784)
    (?$AIs(B . 23457)
    (?$AIt(B . 23158)
    (?$AIu(B . 29978)
    (?$AIv(B . 32958)
    (?$AIw(B . 24910)
    (?$AIx(B . 28183)
    (?$AIy(B . 22768)
    (?$AIz(B . 29983)
    (?$AI{(B . 29989)
    (?$AI|(B . 29298)
    (?$AI}(B . 21319)
    (?$AI~(B . 32499)
    (?$AJ!(B . 30465)
    (?$AJ"(B . 30427)
    (?$AJ#(B . 21097)
    (?$AJ$(B . 32988)
    (?$AJ%(B . 22307)
    (?$AJ&(B . 24072)
    (?$AJ'(B . 22833)
    (?$AJ((B . 29422)
    (?$AJ)(B . 26045)
    (?$AJ*(B . 28287)
    (?$AJ+(B . 35799)
    (?$AJ,(B . 23608)
    (?$AJ-(B . 34417)
    (?$AJ.(B . 21313)
    (?$AJ/(B . 30707)
    (?$AJ0(B . 25342)
    (?$AJ1(B . 26102)
    (?$AJ2(B . 20160)
    (?$AJ3(B . 39135)
    (?$AJ4(B . 34432)
    (?$AJ5(B . 23454)
    (?$AJ6(B . 35782)
    (?$AJ7(B . 21490)
    (?$AJ8(B . 30690)
    (?$AJ9(B . 20351)
    (?$AJ:(B . 23630)
    (?$AJ;(B . 39542)
    (?$AJ<(B . 22987)
    (?$AJ=(B . 24335)
    (?$AJ>(B . 31034)
    (?$AJ?(B . 22763)
    (?$AJ@(B . 19990)
    (?$AJA(B . 26623)
    (?$AJB(B . 20107)
    (?$AJC(B . 25325)
    (?$AJD(B . 35475)
    (?$AJE(B . 36893)
    (?$AJF(B . 21183)
    (?$AJG(B . 26159)
    (?$AJH(B . 21980)
    (?$AJI(B . 22124)
    (?$AJJ(B . 36866)
    (?$AJK(B . 20181)
    (?$AJL(B . 20365)
    (?$AJM(B . 37322)
    (?$AJN(B . 39280)
    (?$AJO(B . 27663)
    (?$AJP(B . 24066)
    (?$AJQ(B . 24643)
    (?$AJR(B . 23460)
    (?$AJS(B . 35270)
    (?$AJT(B . 35797)
    (?$AJU(B . 25910)
    (?$AJV(B . 25163)
    (?$AJW(B . 39318)
    (?$AJX(B . 23432)
    (?$AJY(B . 23551)
    (?$AJZ(B . 25480)
    (?$AJ[(B . 21806)
    (?$AJ\(B . 21463)
    (?$AJ](B . 30246)
    (?$AJ^(B . 20861)
    (?$AJ_(B . 34092)
    (?$AJ`(B . 26530)
    (?$AJa(B . 26803)
    (?$AJb(B . 27530)
    (?$AJc(B . 25234)
    (?$AJd(B . 36755)
    (?$AJe(B . 21460)
    (?$AJf(B . 33298)
    (?$AJg(B . 28113)
    (?$AJh(B . 30095)
    (?$AJi(B . 20070)
    (?$AJj(B . 36174)
    (?$AJk(B . 23408)
    (?$AJl(B . 29087)
    (?$AJm(B . 34223)
    (?$AJn(B . 26257)
    (?$AJo(B . 26329)
    (?$AJp(B . 32626)
    (?$AJq(B . 34560)
    (?$AJr(B . 40653)
    (?$AJs(B . 40736)
    (?$AJt(B . 23646)
    (?$AJu(B . 26415)
    (?$AJv(B . 36848)
    (?$AJw(B . 26641)
    (?$AJx(B . 26463)
    (?$AJy(B . 25101)
    (?$AJz(B . 31446)
    (?$AJ{(B . 22661)
    (?$AJ|(B . 24246)
    (?$AJ}(B . 25968)
    (?$AJ~(B . 28465)
    (?$AK!(B . 24661)
    (?$AK"(B . 21047)
    (?$AK#(B . 32781)
    (?$AK$(B . 25684)
    (?$AK%(B . 34928)
    (?$AK&(B . 29993)
    (?$AK'(B . 24069)
    (?$AK((B . 26643)
    (?$AK)(B . 25332)
    (?$AK*(B . 38684)
    (?$AK+(B . 21452)
    (?$AK,(B . 29245)
    (?$AK-(B . 35841)
    (?$AK.(B . 27700)
    (?$AK/(B . 30561)
    (?$AK0(B . 31246)
    (?$AK1(B . 21550)
    (?$AK2(B . 30636)
    (?$AK3(B . 39034)
    (?$AK4(B . 33308)
    (?$AK5(B . 35828)
    (?$AK6(B . 30805)
    (?$AK7(B . 26388)
    (?$AK8(B . 28865)
    (?$AK9(B . 26031)
    (?$AK:(B . 25749)
    (?$AK;(B . 22070)
    (?$AK<(B . 24605)
    (?$AK=(B . 31169)
    (?$AK>(B . 21496)
    (?$AK?(B . 19997)
    (?$AK@(B . 27515)
    (?$AKA(B . 32902)
    (?$AKB(B . 23546)
    (?$AKC(B . 21987)
    (?$AKD(B . 22235)
    (?$AKE(B . 20282)
    (?$AKF(B . 20284)
    (?$AKG(B . 39282)
    (?$AKH(B . 24051)
    (?$AKI(B . 26494)
    (?$AKJ(B . 32824)
    (?$AKK(B . 24578)
    (?$AKL(B . 39042)
    (?$AKM(B . 36865)
    (?$AKN(B . 23435)
    (?$AKO(B . 35772)
    (?$AKP(B . 35829)
    (?$AKQ(B . 25628)
    (?$AKR(B . 33368)
    (?$AKS(B . 25822)
    (?$AKT(B . 22013)
    (?$AKU(B . 33487)
    (?$AKV(B . 37221)
    (?$AKW(B . 20439)
    (?$AKX(B . 32032)
    (?$AKY(B . 36895)
    (?$AKZ(B . 31903)
    (?$AK[(B . 20723)
    (?$AK\(B . 22609)
    (?$AK](B . 28335)
    (?$AK^(B . 23487)
    (?$AK_(B . 35785)
    (?$AK`(B . 32899)
    (?$AKa(B . 37240)
    (?$AKb(B . 33948)
    (?$AKc(B . 31639)
    (?$AKd(B . 34429)
    (?$AKe(B . 38539)
    (?$AKf(B . 38543)
    (?$AKg(B . 32485)
    (?$AKh(B . 39635)
    (?$AKi(B . 30862)
    (?$AKj(B . 23681)
    (?$AKk(B . 31319)
    (?$AKl(B . 36930)
    (?$AKm(B . 38567)
    (?$AKn(B . 31071)
    (?$AKo(B . 23385)
    (?$AKp(B . 25439)
    (?$AKq(B . 31499)
    (?$AKr(B . 34001)
    (?$AKs(B . 26797)
    (?$AKt(B . 21766)
    (?$AKu(B . 32553)
    (?$AKv(B . 29712)
    (?$AKw(B . 32034)
    (?$AKx(B . 38145)
    (?$AKy(B . 25152)
    (?$AKz(B . 22604)
    (?$AK{(B . 20182)
    (?$AK|(B . 23427)
    (?$AK}(B . 22905)
    (?$AK~(B . 22612)
    (?$AL!(B . 29549)
    (?$AL"(B . 25374)
    (?$AL#(B . 36427)
    (?$AL$(B . 36367)
    (?$AL%(B . 32974)
    (?$AL&(B . 33492)
    (?$AL'(B . 25260)
    (?$AL((B . 21488)
    (?$AL)(B . 27888)
    (?$AL*(B . 37214)
    (?$AL+(B . 22826)
    (?$AL,(B . 24577)
    (?$AL-(B . 27760)
    (?$AL.(B . 22349)
    (?$AL/(B . 25674)
    (?$AL0(B . 36138)
    (?$AL1(B . 30251)
    (?$AL2(B . 28393)
    (?$AL3(B . 22363)
    (?$AL4(B . 27264)
    (?$AL5(B . 30192)
    (?$AL6(B . 28525)
    (?$AL7(B . 35885)
    (?$AL8(B . 35848)
    (?$AL9(B . 22374)
    (?$AL:(B . 27631)
    (?$AL;(B . 34962)
    (?$AL<(B . 30899)
    (?$AL=(B . 25506)
    (?$AL>(B . 21497)
    (?$AL?(B . 28845)
    (?$AL@(B . 27748)
    (?$ALA(B . 22616)
    (?$ALB(B . 25642)
    (?$ALC(B . 22530)
    (?$ALD(B . 26848)
    (?$ALE(B . 33179)
    (?$ALF(B . 21776)
    (?$ALG(B . 31958)
    (?$ALH(B . 20504)
    (?$ALI(B . 36538)
    (?$ALJ(B . 28108)
    (?$ALK(B . 36255)
    (?$ALL(B . 28907)
    (?$ALM(B . 25487)
    (?$ALN(B . 28059)
    (?$ALO(B . 28372)
    (?$ALP(B . 32486)
    (?$ALQ(B . 33796)
    (?$ALR(B . 26691)
    (?$ALS(B . 36867)
    (?$ALT(B . 28120)
    (?$ALU(B . 38518)
    (?$ALV(B . 35752)
    (?$ALW(B . 22871)
    (?$ALX(B . 29305)
    (?$ALY(B . 34276)
    (?$ALZ(B . 33150)
    (?$AL[(B . 30140)
    (?$AL\(B . 35466)
    (?$AL](B . 26799)
    (?$AL^(B . 21076)
    (?$AL_(B . 36386)
    (?$AL`(B . 38161)
    (?$ALa(B . 25552)
    (?$ALb(B . 39064)
    (?$ALc(B . 36420)
    (?$ALd(B . 21884)
    (?$ALe(B . 20307)
    (?$ALf(B . 26367)
    (?$ALg(B . 22159)
    (?$ALh(B . 24789)
    (?$ALi(B . 28053)
    (?$ALj(B . 21059)
    (?$ALk(B . 23625)
    (?$ALl(B . 22825)
    (?$ALm(B . 28155)
    (?$ALn(B . 22635)
    (?$ALo(B . 30000)
    (?$ALp(B . 29980)
    (?$ALq(B . 24684)
    (?$ALr(B . 33300)
    (?$ALs(B . 33094)
    (?$ALt(B . 25361)
    (?$ALu(B . 26465)
    (?$ALv(B . 36834)
    (?$ALw(B . 30522)
    (?$ALx(B . 36339)
    (?$ALy(B . 36148)
    (?$ALz(B . 38081)
    (?$AL{(B . 24086)
    (?$AL|(B . 21381)
    (?$AL}(B . 21548)
    (?$AL~(B . 28867)
    (?$AM!(B . 27712)
    (?$AM"(B . 24311)
    (?$AM#(B . 20572)
    (?$AM$(B . 20141)
    (?$AM%(B . 24237)
    (?$AM&(B . 25402)
    (?$AM'(B . 33351)
    (?$AM((B . 36890)
    (?$AM)(B . 26704)
    (?$AM*(B . 37230)
    (?$AM+(B . 30643)
    (?$AM,(B . 21516)
    (?$AM-(B . 38108)
    (?$AM.(B . 24420)
    (?$AM/(B . 31461)
    (?$AM0(B . 26742)
    (?$AM1(B . 25413)
    (?$AM2(B . 31570)
    (?$AM3(B . 32479)
    (?$AM4(B . 30171)
    (?$AM5(B . 20599)
    (?$AM6(B . 25237)
    (?$AM7(B . 22836)
    (?$AM8(B . 36879)
    (?$AM9(B . 20984)
    (?$AM:(B . 31171)
    (?$AM;(B . 31361)
    (?$AM<(B . 22270)
    (?$AM=(B . 24466)
    (?$AM>(B . 36884)
    (?$AM?(B . 28034)
    (?$AM@(B . 23648)
    (?$AMA(B . 22303)
    (?$AMB(B . 21520)
    (?$AMC(B . 20820)
    (?$AMD(B . 28237)
    (?$AME(B . 22242)
    (?$AMF(B . 25512)
    (?$AMG(B . 39059)
    (?$AMH(B . 33151)
    (?$AMI(B . 34581)
    (?$AMJ(B . 35114)
    (?$AMK(B . 36864)
    (?$AML(B . 21534)
    (?$AMM(B . 23663)
    (?$AMN(B . 33216)
    (?$AMO(B . 25302)
    (?$AMP(B . 25176)
    (?$AMQ(B . 33073)
    (?$AMR(B . 40501)
    (?$AMS(B . 38464)
    (?$AMT(B . 39534)
    (?$AMU(B . 39548)
    (?$AMV(B . 26925)
    (?$AMW(B . 22949)
    (?$AMX(B . 25299)
    (?$AMY(B . 21822)
    (?$AMZ(B . 25366)
    (?$AM[(B . 21703)
    (?$AM\(B . 34521)
    (?$AM](B . 27964)
    (?$AM^(B . 23043)
    (?$AM_(B . 29926)
    (?$AM`(B . 34972)
    (?$AMa(B . 27498)
    (?$AMb(B . 22806)
    (?$AMc(B . 35916)
    (?$AMd(B . 24367)
    (?$AMe(B . 28286)
    (?$AMf(B . 29609)
    (?$AMg(B . 39037)
    (?$AMh(B . 20024)
    (?$AMi(B . 28919)
    (?$AMj(B . 23436)
    (?$AMk(B . 30871)
    (?$AMl(B . 25405)
    (?$AMm(B . 26202)
    (?$AMn(B . 30358)
    (?$AMo(B . 24779)
    (?$AMp(B . 23451)
    (?$AMq(B . 23113)
    (?$AMr(B . 19975)
    (?$AMs(B . 33109)
    (?$AMt(B . 27754)
    (?$AMu(B . 29579)
    (?$AMv(B . 20129)
    (?$AMw(B . 26505)
    (?$AMx(B . 32593)
    (?$AMy(B . 24448)
    (?$AMz(B . 26106)
    (?$AM{(B . 26395)
    (?$AM|(B . 24536)
    (?$AM}(B . 22916)
    (?$AM~(B . 23041)
    (?$AN!(B . 24013)
    (?$AN"(B . 24494)
    (?$AN#(B . 21361)
    (?$AN$(B . 38886)
    (?$AN%(B . 36829)
    (?$AN&(B . 26693)
    (?$AN'(B . 22260)
    (?$AN((B . 21807)
    (?$AN)(B . 24799)
    (?$AN*(B . 20026)
    (?$AN+(B . 28493)
    (?$AN,(B . 32500)
    (?$AN-(B . 33479)
    (?$AN.(B . 33806)
    (?$AN/(B . 22996)
    (?$AN0(B . 20255)
    (?$AN1(B . 20266)
    (?$AN2(B . 23614)
    (?$AN3(B . 32428)
    (?$AN4(B . 26410)
    (?$AN5(B . 34074)
    (?$AN6(B . 21619)
    (?$AN7(B . 30031)
    (?$AN8(B . 32963)
    (?$AN9(B . 21890)
    (?$AN:(B . 39759)
    (?$AN;(B . 20301)
    (?$AN<(B . 28205)
    (?$AN=(B . 35859)
    (?$AN>(B . 23561)
    (?$AN?(B . 24944)
    (?$AN@(B . 21355)
    (?$ANA(B . 30239)
    (?$ANB(B . 28201)
    (?$ANC(B . 34442)
    (?$AND(B . 25991)
    (?$ANE(B . 38395)
    (?$ANF(B . 32441)
    (?$ANG(B . 21563)
    (?$ANH(B . 31283)
    (?$ANI(B . 32010)
    (?$ANJ(B . 38382)
    (?$ANK(B . 21985)
    (?$ANL(B . 32705)
    (?$ANM(B . 29934)
    (?$ANN(B . 25373)
    (?$ANO(B . 34583)
    (?$ANP(B . 28065)
    (?$ANQ(B . 31389)
    (?$ANR(B . 25105)
    (?$ANS(B . 26017)
    (?$ANT(B . 21351)
    (?$ANU(B . 25569)
    (?$ANV(B . 27779)
    (?$ANW(B . 24043)
    (?$ANX(B . 21596)
    (?$ANY(B . 38056)
    (?$ANZ(B . 20044)
    (?$AN[(B . 27745)
    (?$AN\(B . 35820)
    (?$AN](B . 23627)
    (?$AN^(B . 26080)
    (?$AN_(B . 33436)
    (?$AN`(B . 26791)
    (?$ANa(B . 21566)
    (?$ANb(B . 21556)
    (?$ANc(B . 27595)
    (?$ANd(B . 27494)
    (?$ANe(B . 20116)
    (?$ANf(B . 25410)
    (?$ANg(B . 21320)
    (?$ANh(B . 33310)
    (?$ANi(B . 20237)
    (?$ANj(B . 20398)
    (?$ANk(B . 22366)
    (?$ANl(B . 25098)
    (?$ANm(B . 38654)
    (?$ANn(B . 26212)
    (?$ANo(B . 29289)
    (?$ANp(B . 21247)
    (?$ANq(B . 21153)
    (?$ANr(B . 24735)
    (?$ANs(B . 35823)
    (?$ANt(B . 26132)
    (?$ANu(B . 29081)
    (?$ANv(B . 26512)
    (?$ANw(B . 35199)
    (?$ANx(B . 30802)
    (?$ANy(B . 30717)
    (?$ANz(B . 26224)
    (?$AN{(B . 22075)
    (?$AN|(B . 21560)
    (?$AN}(B . 38177)
    (?$AN~(B . 29306)
    (?$AO!(B . 31232)
    (?$AO"(B . 24687)
    (?$AO#(B . 24076)
    (?$AO$(B . 24713)
    (?$AO%(B . 33181)
    (?$AO&(B . 22805)
    (?$AO'(B . 24796)
    (?$AO((B . 29060)
    (?$AO)(B . 28911)
    (?$AO*(B . 28330)
    (?$AO+(B . 27728)
    (?$AO,(B . 29312)
    (?$AO-(B . 27268)
    (?$AO.(B . 34989)
    (?$AO/(B . 24109)
    (?$AO0(B . 20064)
    (?$AO1(B . 23219)
    (?$AO2(B . 21916)
    (?$AO3(B . 38115)
    (?$AO4(B . 27927)
    (?$AO5(B . 31995)
    (?$AO6(B . 38553)
    (?$AO7(B . 25103)
    (?$AO8(B . 32454)
    (?$AO9(B . 30606)
    (?$AO:(B . 34430)
    (?$AO;(B . 21283)
    (?$AO<(B . 38686)
    (?$AO=(B . 36758)
    (?$AO>(B . 26247)
    (?$AO?(B . 23777)
    (?$AO@(B . 20384)
    (?$AOA(B . 29421)
    (?$AOB(B . 19979)
    (?$AOC(B . 21414)
    (?$AOD(B . 22799)
    (?$AOE(B . 21523)
    (?$AOF(B . 25472)
    (?$AOG(B . 38184)
    (?$AOH(B . 20808)
    (?$AOI(B . 20185)
    (?$AOJ(B . 40092)
    (?$AOK(B . 32420)
    (?$AOL(B . 21688)
    (?$AOM(B . 36132)
    (?$AON(B . 34900)
    (?$AOO(B . 33335)
    (?$AOP(B . 38386)
    (?$AOQ(B . 28046)
    (?$AOR(B . 24358)
    (?$AOS(B . 23244)
    (?$AOT(B . 26174)
    (?$AOU(B . 38505)
    (?$AOV(B . 29616)
    (?$AOW(B . 29486)
    (?$AOX(B . 21439)
    (?$AOY(B . 33146)
    (?$AOZ(B . 39301)
    (?$AO[(B . 32673)
    (?$AO\(B . 23466)
    (?$AO](B . 38519)
    (?$AO^(B . 38480)
    (?$AO_(B . 32447)
    (?$AO`(B . 30456)
    (?$AOa(B . 21410)
    (?$AOb(B . 38262)
    (?$AOc(B . 39321)
    (?$AOd(B . 31665)
    (?$AOe(B . 35140)
    (?$AOf(B . 28248)
    (?$AOg(B . 20065)
    (?$AOh(B . 32724)
    (?$AOi(B . 31077)
    (?$AOj(B . 35814)
    (?$AOk(B . 24819)
    (?$AOl(B . 21709)
    (?$AOm(B . 20139)
    (?$AOn(B . 39033)
    (?$AOo(B . 24055)
    (?$AOp(B . 27233)
    (?$AOq(B . 20687)
    (?$AOr(B . 21521)
    (?$AOs(B . 35937)
    (?$AOt(B . 33831)
    (?$AOu(B . 30813)
    (?$AOv(B . 38660)
    (?$AOw(B . 21066)
    (?$AOx(B . 21742)
    (?$AOy(B . 22179)
    (?$AOz(B . 38144)
    (?$AO{(B . 28040)
    (?$AO|(B . 23477)
    (?$AO}(B . 28102)
    (?$AO~(B . 26195)
    (?$AP!(B . 23567)
    (?$AP"(B . 23389)
    (?$AP#(B . 26657)
    (?$AP$(B . 32918)
    (?$AP%(B . 21880)
    (?$AP&(B . 31505)
    (?$AP'(B . 25928)
    (?$AP((B . 26964)
    (?$AP)(B . 20123)
    (?$AP*(B . 27463)
    (?$AP+(B . 34638)
    (?$AP,(B . 38795)
    (?$AP-(B . 21327)
    (?$AP.(B . 25375)
    (?$AP/(B . 25658)
    (?$AP0(B . 37034)
    (?$AP1(B . 26012)
    (?$AP2(B . 32961)
    (?$AP3(B . 35856)
    (?$AP4(B . 20889)
    (?$AP5(B . 26800)
    (?$AP6(B . 21368)
    (?$AP7(B . 34809)
    (?$AP8(B . 25032)
    (?$AP9(B . 27844)
    (?$AP:(B . 27899)
    (?$AP;(B . 35874)
    (?$AP<(B . 23633)
    (?$AP=(B . 34218)
    (?$AP>(B . 33455)
    (?$AP?(B . 38156)
    (?$AP@(B . 27427)
    (?$APA(B . 36763)
    (?$APB(B . 26032)
    (?$APC(B . 24571)
    (?$APD(B . 24515)
    (?$APE(B . 20449)
    (?$APF(B . 34885)
    (?$APG(B . 26143)
    (?$APH(B . 33125)
    (?$API(B . 29481)
    (?$APJ(B . 24826)
    (?$APK(B . 20852)
    (?$APL(B . 21009)
    (?$APM(B . 22411)
    (?$APN(B . 24418)
    (?$APO(B . 37026)
    (?$APP(B . 34892)
    (?$APQ(B . 37266)
    (?$APR(B . 24184)
    (?$APS(B . 26447)
    (?$APT(B . 24615)
    (?$APU(B . 22995)
    (?$APV(B . 20804)
    (?$APW(B . 20982)
    (?$APX(B . 33016)
    (?$APY(B . 21256)
    (?$APZ(B . 27769)
    (?$AP[(B . 38596)
    (?$AP\(B . 29066)
    (?$AP](B . 20241)
    (?$AP^(B . 20462)
    (?$AP_(B . 32670)
    (?$AP`(B . 26429)
    (?$APa(B . 21957)
    (?$APb(B . 38152)
    (?$APc(B . 31168)
    (?$APd(B . 34966)
    (?$APe(B . 32483)
    (?$APf(B . 22687)
    (?$APg(B . 25100)
    (?$APh(B . 38656)
    (?$APi(B . 34394)
    (?$APj(B . 22040)
    (?$APk(B . 39035)
    (?$APl(B . 24464)
    (?$APm(B . 35768)
    (?$APn(B . 33988)
    (?$APo(B . 37207)
    (?$APp(B . 21465)
    (?$APq(B . 26093)
    (?$APr(B . 24207)
    (?$APs(B . 30044)
    (?$APt(B . 24676)
    (?$APu(B . 32110)
    (?$APv(B . 23167)
    (?$APw(B . 32490)
    (?$APx(B . 32493)
    (?$APy(B . 36713)
    (?$APz(B . 21927)
    (?$AP{(B . 23459)
    (?$AP|(B . 24748)
    (?$AP}(B . 26059)
    (?$AP~(B . 29572)
    (?$AQ!(B . 36873)
    (?$AQ"(B . 30307)
    (?$AQ#(B . 30505)
    (?$AQ$(B . 32474)
    (?$AQ%(B . 38772)
    (?$AQ&(B . 34203)
    (?$AQ'(B . 23398)
    (?$AQ((B . 31348)
    (?$AQ)(B . 38634)
    (?$AQ*(B . 34880)
    (?$AQ+(B . 21195)
    (?$AQ,(B . 29071)
    (?$AQ-(B . 24490)
    (?$AQ.(B . 26092)
    (?$AQ/(B . 35810)
    (?$AQ0(B . 23547)
    (?$AQ1(B . 39535)
    (?$AQ2(B . 24033)
    (?$AQ3(B . 27529)
    (?$AQ4(B . 27739)
    (?$AQ5(B . 35757)
    (?$AQ6(B . 35759)
    (?$AQ7(B . 36874)
    (?$AQ8(B . 36805)
    (?$AQ9(B . 21387)
    (?$AQ:(B . 25276)
    (?$AQ;(B . 40486)
    (?$AQ<(B . 40493)
    (?$AQ=(B . 21568)
    (?$AQ>(B . 20011)
    (?$AQ?(B . 33469)
    (?$AQ@(B . 29273)
    (?$AQA(B . 34460)
    (?$AQB(B . 23830)
    (?$AQC(B . 34905)
    (?$AQD(B . 28079)
    (?$AQE(B . 38597)
    (?$AQF(B . 21713)
    (?$AQG(B . 20122)
    (?$AQH(B . 35766)
    (?$AQI(B . 28937)
    (?$AQJ(B . 21693)
    (?$AQK(B . 38409)
    (?$AQL(B . 28895)
    (?$AQM(B . 28153)
    (?$AQN(B . 30416)
    (?$AQO(B . 20005)
    (?$AQP(B . 30740)
    (?$AQQ(B . 34578)
    (?$AQR(B . 23721)
    (?$AQS(B . 24310)
    (?$AQT(B . 35328)
    (?$AQU(B . 39068)
    (?$AQV(B . 38414)
    (?$AQW(B . 28814)
    (?$AQX(B . 27839)
    (?$AQY(B . 22852)
    (?$AQZ(B . 25513)
    (?$AQ[(B . 30524)
    (?$AQ\(B . 34893)
    (?$AQ](B . 28436)
    (?$AQ^(B . 33395)
    (?$AQ_(B . 22576)
    (?$AQ`(B . 29141)
    (?$AQa(B . 21388)
    (?$AQb(B . 30746)
    (?$AQc(B . 38593)
    (?$AQd(B . 21761)
    (?$AQe(B . 24422)
    (?$AQf(B . 28976)
    (?$AQg(B . 23476)
    (?$AQh(B . 35866)
    (?$AQi(B . 39564)
    (?$AQj(B . 27523)
    (?$AQk(B . 22830)
    (?$AQl(B . 40495)
    (?$AQm(B . 31207)
    (?$AQn(B . 26472)
    (?$AQo(B . 25196)
    (?$AQp(B . 20335)
    (?$AQq(B . 30113)
    (?$AQr(B . 32650)
    (?$AQs(B . 27915)
    (?$AQt(B . 38451)
    (?$AQu(B . 27687)
    (?$AQv(B . 20208)
    (?$AQw(B . 30162)
    (?$AQx(B . 20859)
    (?$AQy(B . 26679)
    (?$AQz(B . 28478)
    (?$AQ{(B . 36992)
    (?$AQ|(B . 33136)
    (?$AQ}(B . 22934)
    (?$AQ~(B . 29814)
    (?$AR!(B . 25671)
    (?$AR"(B . 23591)
    (?$AR#(B . 36965)
    (?$AR$(B . 31377)
    (?$AR%(B . 35875)
    (?$AR&(B . 23002)
    (?$AR'(B . 21676)
    (?$AR((B . 33280)
    (?$AR)(B . 33647)
    (?$AR*(B . 35201)
    (?$AR+(B . 32768)
    (?$AR,(B . 26928)
    (?$AR-(B . 22094)
    (?$AR.(B . 32822)
    (?$AR/(B . 29239)
    (?$AR0(B . 37326)
    (?$AR1(B . 20918)
    (?$AR2(B . 20063)
    (?$AR3(B . 39029)
    (?$AR4(B . 25494)
    (?$AR5(B . 19994)
    (?$AR6(B . 21494)
    (?$AR7(B . 26355)
    (?$AR8(B . 33099)
    (?$AR9(B . 22812)
    (?$AR:(B . 28082)
    (?$AR;(B . 19968)
    (?$AR<(B . 22777)
    (?$AR=(B . 21307)
    (?$AR>(B . 25558)
    (?$AR?(B . 38129)
    (?$AR@(B . 20381)
    (?$ARA(B . 20234)
    (?$ARB(B . 34915)
    (?$ARC(B . 39056)
    (?$ARD(B . 22839)
    (?$ARE(B . 36951)
    (?$ARF(B . 31227)
    (?$ARG(B . 20202)
    (?$ARH(B . 33008)
    (?$ARI(B . 30097)
    (?$ARJ(B . 27778)
    (?$ARK(B . 23452)
    (?$ARL(B . 23016)
    (?$ARM(B . 24413)
    (?$ARN(B . 26885)
    (?$ARO(B . 34433)
    (?$ARP(B . 20506)
    (?$ARQ(B . 24050)
    (?$ARR(B . 20057)
    (?$ARS(B . 30691)
    (?$ART(B . 20197)
    (?$ARU(B . 33402)
    (?$ARV(B . 25233)
    (?$ARW(B . 26131)
    (?$ARX(B . 37009)
    (?$ARY(B . 23673)
    (?$ARZ(B . 20159)
    (?$AR[(B . 24441)
    (?$AR\(B . 33222)
    (?$AR](B . 36920)
    (?$AR^(B . 32900)
    (?$AR_(B . 30123)
    (?$AR`(B . 20134)
    (?$ARa(B . 35028)
    (?$ARb(B . 24847)
    (?$ARc(B . 27589)
    (?$ARd(B . 24518)
    (?$ARe(B . 20041)
    (?$ARf(B . 30410)
    (?$ARg(B . 28322)
    (?$ARh(B . 35811)
    (?$ARi(B . 35758)
    (?$ARj(B . 35850)
    (?$ARk(B . 35793)
    (?$ARl(B . 24322)
    (?$ARm(B . 32764)
    (?$ARn(B . 32716)
    (?$ARo(B . 32462)
    (?$ARp(B . 33589)
    (?$ARq(B . 33643)
    (?$ARr(B . 22240)
    (?$ARs(B . 27575)
    (?$ARt(B . 38899)
    (?$ARu(B . 38452)
    (?$ARv(B . 23035)
    (?$ARw(B . 21535)
    (?$ARx(B . 38134)
    (?$ARy(B . 28139)
    (?$ARz(B . 23493)
    (?$AR{(B . 39278)
    (?$AR|(B . 23609)
    (?$AR}(B . 24341)
    (?$AR~(B . 38544)
    (?$AS!(B . 21360)
    (?$AS"(B . 33521)
    (?$AS#(B . 27185)
    (?$AS$(B . 23156)
    (?$AS%(B . 40560)
    (?$AS&(B . 24212)
    (?$AS'(B . 32552)
    (?$AS((B . 33721)
    (?$AS)(B . 33828)
    (?$AS*(B . 33829)
    (?$AS+(B . 33639)
    (?$AS,(B . 34631)
    (?$AS-(B . 36814)
    (?$AS.(B . 36194)
    (?$AS/(B . 30408)
    (?$AS0(B . 24433)
    (?$AS1(B . 39062)
    (?$AS2(B . 30828)
    (?$AS3(B . 26144)
    (?$AS4(B . 21727)
    (?$AS5(B . 25317)
    (?$AS6(B . 20323)
    (?$AS7(B . 33219)
    (?$AS8(B . 30152)
    (?$AS9(B . 24248)
    (?$AS:(B . 38605)
    (?$AS;(B . 36362)
    (?$AS<(B . 34553)
    (?$AS=(B . 21647)
    (?$AS>(B . 27891)
    (?$AS?(B . 28044)
    (?$AS@(B . 27704)
    (?$ASA(B . 24703)
    (?$ASB(B . 21191)
    (?$ASC(B . 29992)
    (?$ASD(B . 24189)
    (?$ASE(B . 20248)
    (?$ASF(B . 24736)
    (?$ASG(B . 24551)
    (?$ASH(B . 23588)
    (?$ASI(B . 30001)
    (?$ASJ(B . 37038)
    (?$ASK(B . 38080)
    (?$ASL(B . 29369)
    (?$ASM(B . 27833)
    (?$ASN(B . 28216)
    (?$ASO(B . 37193)
    (?$ASP(B . 26377)
    (?$ASQ(B . 21451)
    (?$ASR(B . 21491)
    (?$ASS(B . 20305)
    (?$AST(B . 37321)
    (?$ASU(B . 35825)
    (?$ASV(B . 21448)
    (?$ASW(B . 24188)
    (?$ASX(B . 36802)
    (?$ASY(B . 28132)
    (?$ASZ(B . 20110)
    (?$AS[(B . 30402)
    (?$AS\(B . 27014)
    (?$AS](B . 34398)
    (?$AS^(B . 24858)
    (?$AS_(B . 33286)
    (?$AS`(B . 20313)
    (?$ASa(B . 20446)
    (?$ASb(B . 36926)
    (?$ASc(B . 40060)
    (?$ASd(B . 24841)
    (?$ASe(B . 28189)
    (?$ASf(B . 28180)
    (?$ASg(B . 38533)
    (?$ASh(B . 20104)
    (?$ASi(B . 23089)
    (?$ASj(B . 38632)
    (?$ASk(B . 19982)
    (?$ASl(B . 23679)
    (?$ASm(B . 31161)
    (?$ASn(B . 23431)
    (?$ASo(B . 35821)
    (?$ASp(B . 32701)
    (?$ASq(B . 29577)
    (?$ASr(B . 22495)
    (?$ASs(B . 33419)
    (?$ASt(B . 37057)
    (?$ASu(B . 21505)
    (?$ASv(B . 36935)
    (?$ASw(B . 21947)
    (?$ASx(B . 23786)
    (?$ASy(B . 24481)
    (?$ASz(B . 24840)
    (?$AS{(B . 27442)
    (?$AS|(B . 29425)
    (?$AS}(B . 32946)
    (?$AS~(B . 35465)
    (?$AT!(B . 28020)
    (?$AT"(B . 23507)
    (?$AT#(B . 35029)
    (?$AT$(B . 39044)
    (?$AT%(B . 35947)
    (?$AT&(B . 39533)
    (?$AT'(B . 40499)
    (?$AT((B . 28170)
    (?$AT)(B . 20900)
    (?$AT*(B . 20803)
    (?$AT+(B . 22435)
    (?$AT,(B . 34945)
    (?$AT-(B . 21407)
    (?$AT.(B . 25588)
    (?$AT/(B . 36757)
    (?$AT0(B . 22253)
    (?$AT1(B . 21592)
    (?$AT2(B . 22278)
    (?$AT3(B . 29503)
    (?$AT4(B . 28304)
    (?$AT5(B . 32536)
    (?$AT6(B . 36828)
    (?$AT7(B . 33489)
    (?$AT8(B . 24895)
    (?$AT9(B . 24616)
    (?$AT:(B . 38498)
    (?$AT;(B . 26352)
    (?$AT<(B . 32422)
    (?$AT=(B . 36234)
    (?$AT>(B . 36291)
    (?$AT?(B . 38053)
    (?$AT@(B . 23731)
    (?$ATA(B . 31908)
    (?$ATB(B . 26376)
    (?$ATC(B . 24742)
    (?$ATD(B . 38405)
    (?$ATE(B . 32792)
    (?$ATF(B . 20113)
    (?$ATG(B . 37095)
    (?$ATH(B . 21248)
    (?$ATI(B . 38504)
    (?$ATJ(B . 20801)
    (?$ATK(B . 36816)
    (?$ATL(B . 34164)
    (?$ATM(B . 37213)
    (?$ATN(B . 26197)
    (?$ATO(B . 38901)
    (?$ATP(B . 23381)
    (?$ATQ(B . 21277)
    (?$ATR(B . 30776)
    (?$ATS(B . 26434)
    (?$ATT(B . 26685)
    (?$ATU(B . 21705)
    (?$ATV(B . 28798)
    (?$ATW(B . 23472)
    (?$ATX(B . 36733)
    (?$ATY(B . 20877)
    (?$ATZ(B . 22312)
    (?$AT[(B . 21681)
    (?$AT\(B . 25874)
    (?$AT](B . 26242)
    (?$AT^(B . 36190)
    (?$AT_(B . 36163)
    (?$AT`(B . 33039)
    (?$ATa(B . 33900)
    (?$ATb(B . 36973)
    (?$ATc(B . 31967)
    (?$ATd(B . 20991)
    (?$ATe(B . 34299)
    (?$ATf(B . 26531)
    (?$ATg(B . 26089)
    (?$ATh(B . 28577)
    (?$ATi(B . 34468)
    (?$ATj(B . 36481)
    (?$ATk(B . 22122)
    (?$ATl(B . 36896)
    (?$ATm(B . 30338)
    (?$ATn(B . 28790)
    (?$ATo(B . 29157)
    (?$ATp(B . 36131)
    (?$ATq(B . 25321)
    (?$ATr(B . 21017)
    (?$ATs(B . 27901)
    (?$ATt(B . 36156)
    (?$ATu(B . 24590)
    (?$ATv(B . 22686)
    (?$ATw(B . 24974)
    (?$ATx(B . 26366)
    (?$ATy(B . 36192)
    (?$ATz(B . 25166)
    (?$AT{(B . 21939)
    (?$AT|(B . 28195)
    (?$AT}(B . 26413)
    (?$AT~(B . 36711)
    (?$AU!(B . 38113)
    (?$AU"(B . 38392)
    (?$AU#(B . 30504)
    (?$AU$(B . 26629)
    (?$AU%(B . 27048)
    (?$AU&(B . 21643)
    (?$AU'(B . 20045)
    (?$AU((B . 28856)
    (?$AU)(B . 35784)
    (?$AU*(B . 25688)
    (?$AU+(B . 25995)
    (?$AU,(B . 23429)
    (?$AU-(B . 31364)
    (?$AU.(B . 20538)
    (?$AU/(B . 23528)
    (?$AU0(B . 30651)
    (?$AU1(B . 27617)
    (?$AU2(B . 35449)
    (?$AU3(B . 31896)
    (?$AU4(B . 27838)
    (?$AU5(B . 30415)
    (?$AU6(B . 26025)
    (?$AU7(B . 36759)
    (?$AU8(B . 23853)
    (?$AU9(B . 23637)
    (?$AU:(B . 34360)
    (?$AU;(B . 26632)
    (?$AU<(B . 21344)
    (?$AU=(B . 25112)
    (?$AU>(B . 31449)
    (?$AU?(B . 28251)
    (?$AU@(B . 32509)
    (?$AUA(B . 27167)
    (?$AUB(B . 31456)
    (?$AUC(B . 24432)
    (?$AUD(B . 28467)
    (?$AUE(B . 24352)
    (?$AUF(B . 25484)
    (?$AUG(B . 28072)
    (?$AUH(B . 26454)
    (?$AUI(B . 19976)
    (?$AUJ(B . 24080)
    (?$AUK(B . 36134)
    (?$AUL(B . 20183)
    (?$AUM(B . 32960)
    (?$AUN(B . 30260)
    (?$AUO(B . 38556)
    (?$AUP(B . 25307)
    (?$AUQ(B . 26157)
    (?$AUR(B . 25214)
    (?$AUS(B . 27836)
    (?$AUT(B . 36213)
    (?$AUU(B . 29031)
    (?$AUV(B . 32617)
    (?$AUW(B . 20806)
    (?$AUX(B . 32903)
    (?$AUY(B . 21484)
    (?$AUZ(B . 36974)
    (?$AU[(B . 25240)
    (?$AU\(B . 21746)
    (?$AU](B . 34544)
    (?$AU^(B . 36761)
    (?$AU_(B . 32773)
    (?$AU`(B . 38167)
    (?$AUa(B . 34071)
    (?$AUb(B . 36825)
    (?$AUc(B . 27993)
    (?$AUd(B . 29645)
    (?$AUe(B . 26015)
    (?$AUf(B . 30495)
    (?$AUg(B . 29956)
    (?$AUh(B . 30759)
    (?$AUi(B . 33275)
    (?$AUj(B . 36126)
    (?$AUk(B . 38024)
    (?$AUl(B . 20390)
    (?$AUm(B . 26517)
    (?$AUn(B . 30137)
    (?$AUo(B . 35786)
    (?$AUp(B . 38663)
    (?$AUq(B . 25391)
    (?$AUr(B . 38215)
    (?$AUs(B . 38453)
    (?$AUt(B . 33976)
    (?$AUu(B . 25379)
    (?$AUv(B . 30529)
    (?$AUw(B . 24449)
    (?$AUx(B . 29424)
    (?$AUy(B . 20105)
    (?$AUz(B . 24596)
    (?$AU{(B . 25972)
    (?$AU|(B . 25327)
    (?$AU}(B . 27491)
    (?$AU~(B . 25919)
    (?$AV!(B . 24103)
    (?$AV"(B . 30151)
    (?$AV#(B . 37073)
    (?$AV$(B . 35777)
    (?$AV%(B . 33437)
    (?$AV&(B . 26525)
    (?$AV'(B . 25903)
    (?$AV((B . 21553)
    (?$AV)(B . 34584)
    (?$AV*(B . 30693)
    (?$AV+(B . 32930)
    (?$AV,(B . 33026)
    (?$AV-(B . 27713)
    (?$AV.(B . 20043)
    (?$AV/(B . 32455)
    (?$AV0(B . 32844)
    (?$AV1(B . 30452)
    (?$AV2(B . 26893)
    (?$AV3(B . 27542)
    (?$AV4(B . 25191)
    (?$AV5(B . 20540)
    (?$AV6(B . 20356)
    (?$AV7(B . 22336)
    (?$AV8(B . 25351)
    (?$AV9(B . 27490)
    (?$AV:(B . 36286)
    (?$AV;(B . 21482)
    (?$AV<(B . 26088)
    (?$AV=(B . 32440)
    (?$AV>(B . 24535)
    (?$AV?(B . 25370)
    (?$AV@(B . 25527)
    (?$AVA(B . 33267)
    (?$AVB(B . 33268)
    (?$AVC(B . 32622)
    (?$AVD(B . 24092)
    (?$AVE(B . 23769)
    (?$AVF(B . 21046)
    (?$AVG(B . 26234)
    (?$AVH(B . 31209)
    (?$AVI(B . 31258)
    (?$AVJ(B . 36136)
    (?$AVK(B . 28825)
    (?$AVL(B . 30164)
    (?$AVM(B . 28382)
    (?$AVN(B . 27835)
    (?$AVO(B . 31378)
    (?$AVP(B . 20013)
    (?$AVQ(B . 30405)
    (?$AVR(B . 24544)
    (?$AVS(B . 38047)
    (?$AVT(B . 34935)
    (?$AVU(B . 32456)
    (?$AVV(B . 31181)
    (?$AVW(B . 32959)
    (?$AVX(B . 37325)
    (?$AVY(B . 20210)
    (?$AVZ(B . 20247)
    (?$AV[(B . 33311)
    (?$AV\(B . 21608)
    (?$AV](B . 24030)
    (?$AV^(B . 27954)
    (?$AV_(B . 35788)
    (?$AV`(B . 31909)
    (?$AVa(B . 36724)
    (?$AVb(B . 32920)
    (?$AVc(B . 24090)
    (?$AVd(B . 21650)
    (?$AVe(B . 30385)
    (?$AVf(B . 23449)
    (?$AVg(B . 26172)
    (?$AVh(B . 39588)
    (?$AVi(B . 29664)
    (?$AVj(B . 26666)
    (?$AVk(B . 34523)
    (?$AVl(B . 26417)
    (?$AVm(B . 29482)
    (?$AVn(B . 35832)
    (?$AVo(B . 35803)
    (?$AVp(B . 36880)
    (?$AVq(B . 31481)
    (?$AVr(B . 28891)
    (?$AVs(B . 29038)
    (?$AVt(B . 25284)
    (?$AVu(B . 30633)
    (?$AVv(B . 22065)
    (?$AVw(B . 20027)
    (?$AVx(B . 33879)
    (?$AVy(B . 26609)
    (?$AVz(B . 21161)
    (?$AV{(B . 34496)
    (?$AV|(B . 36142)
    (?$AV}(B . 38136)
    (?$AV~(B . 31569)
    (?$AW!(B . 20303)
    (?$AW"(B . 27880)
    (?$AW#(B . 31069)
    (?$AW$(B . 39547)
    (?$AW%(B . 25235)
    (?$AW&(B . 29226)
    (?$AW'(B . 25341)
    (?$AW((B . 19987)
    (?$AW)(B . 30742)
    (?$AW*(B . 36716)
    (?$AW+(B . 25776)
    (?$AW,(B . 36186)
    (?$AW-(B . 31686)
    (?$AW.(B . 26729)
    (?$AW/(B . 24196)
    (?$AW0(B . 35013)
    (?$AW1(B . 22918)
    (?$AW2(B . 25758)
    (?$AW3(B . 22766)
    (?$AW4(B . 29366)
    (?$AW5(B . 26894)
    (?$AW6(B . 38181)
    (?$AW7(B . 36861)
    (?$AW8(B . 36184)
    (?$AW9(B . 22368)
    (?$AW:(B . 32512)
    (?$AW;(B . 35846)
    (?$AW<(B . 20934)
    (?$AW=(B . 25417)
    (?$AW>(B . 25305)
    (?$AW?(B . 21331)
    (?$AW@(B . 26700)
    (?$AWA(B . 29730)
    (?$AWB(B . 33537)
    (?$AWC(B . 37196)
    (?$AWD(B . 21828)
    (?$AWE(B . 30528)
    (?$AWF(B . 28796)
    (?$AWG(B . 27978)
    (?$AWH(B . 20857)
    (?$AWI(B . 21672)
    (?$AWJ(B . 36164)
    (?$AWK(B . 23039)
    (?$AWL(B . 28363)
    (?$AWM(B . 28100)
    (?$AWN(B . 23388)
    (?$AWO(B . 32043)
    (?$AWP(B . 20180)
    (?$AWQ(B . 31869)
    (?$AWR(B . 28371)
    (?$AWS(B . 23376)
    (?$AWT(B . 33258)
    (?$AWU(B . 28173)
    (?$AWV(B . 23383)
    (?$AWW(B . 39683)
    (?$AWX(B . 26837)
    (?$AWY(B . 36394)
    (?$AWZ(B . 23447)
    (?$AW[(B . 32508)
    (?$AW\(B . 24635)
    (?$AW](B . 32437)
    (?$AW^(B . 37049)
    (?$AW_(B . 36208)
    (?$AW`(B . 22863)
    (?$AWa(B . 25549)
    (?$AWb(B . 31199)
    (?$AWc(B . 36275)
    (?$AWd(B . 21330)
    (?$AWe(B . 26063)
    (?$AWf(B . 31062)
    (?$AWg(B . 35781)
    (?$AWh(B . 38459)
    (?$AWi(B . 32452)
    (?$AWj(B . 38075)
    (?$AWk(B . 32386)
    (?$AWl(B . 22068)
    (?$AWm(B . 37257)
    (?$AWn(B . 26368)
    (?$AWo(B . 32618)
    (?$AWp(B . 23562)
    (?$AWq(B . 36981)
    (?$AWr(B . 26152)
    (?$AWs(B . 24038)
    (?$AWt(B . 20304)
    (?$AWu(B . 26590)
    (?$AWv(B . 20570)
    (?$AWw(B . 20316)
    (?$AWx(B . 22352)
    (?$AWy(B . 24231)
    (?$AX!(B . 20109)
    (?$AX"(B . 19980)
    (?$AX#(B . 20800)
    (?$AX$(B . 19984)
    (?$AX%(B . 24319)
    (?$AX&(B . 21317)
    (?$AX'(B . 19989)
    (?$AX((B . 20120)
    (?$AX)(B . 19998)
    (?$AX*(B . 39730)
    (?$AX+(B . 23404)
    (?$AX,(B . 22121)
    (?$AX-(B . 20008)
    (?$AX.(B . 31162)
    (?$AX/(B . 20031)
    (?$AX0(B . 21269)
    (?$AX1(B . 20039)
    (?$AX2(B . 22829)
    (?$AX3(B . 29243)
    (?$AX4(B . 21358)
    (?$AX5(B . 27664)
    (?$AX6(B . 22239)
    (?$AX7(B . 32996)
    (?$AX8(B . 39319)
    (?$AX9(B . 27603)
    (?$AX:(B . 30590)
    (?$AX;(B . 40727)
    (?$AX<(B . 20022)
    (?$AX=(B . 20127)
    (?$AX>(B . 40720)
    (?$AX?(B . 20060)
    (?$AX@(B . 20073)
    (?$AXA(B . 20115)
    (?$AXB(B . 33416)
    (?$AXC(B . 23387)
    (?$AXD(B . 21868)
    (?$AXE(B . 22031)
    (?$AXF(B . 20164)
    (?$AXG(B . 21389)
    (?$AXH(B . 21405)
    (?$AXI(B . 21411)
    (?$AXJ(B . 21413)
    (?$AXK(B . 21422)
    (?$AXL(B . 38757)
    (?$AXM(B . 36189)
    (?$AXN(B . 21274)
    (?$AXO(B . 21493)
    (?$AXP(B . 21286)
    (?$AXQ(B . 21294)
    (?$AXR(B . 21310)
    (?$AXS(B . 36188)
    (?$AXT(B . 21350)
    (?$AXU(B . 21347)
    (?$AXV(B . 20994)
    (?$AXW(B . 21000)
    (?$AXX(B . 21006)
    (?$AXY(B . 21037)
    (?$AXZ(B . 21043)
    (?$AX[(B . 21055)
    (?$AX\(B . 21056)
    (?$AX](B . 21068)
    (?$AX^(B . 21086)
    (?$AX_(B . 21089)
    (?$AX`(B . 21084)
    (?$AXa(B . 33967)
    (?$AXb(B . 21117)
    (?$AXc(B . 21122)
    (?$AXd(B . 21121)
    (?$AXe(B . 21136)
    (?$AXf(B . 21139)
    (?$AXg(B . 20866)
    (?$AXh(B . 32596)
    (?$AXi(B . 20155)
    (?$AXj(B . 20163)
    (?$AXk(B . 20169)
    (?$AXl(B . 20162)
    (?$AXm(B . 20200)
    (?$AXn(B . 20193)
    (?$AXo(B . 20203)
    (?$AXp(B . 20190)
    (?$AXq(B . 20251)
    (?$AXr(B . 20211)
    (?$AXs(B . 20258)
    (?$AXt(B . 20324)
    (?$AXu(B . 20213)
    (?$AXv(B . 20261)
    (?$AXw(B . 20263)
    (?$AXx(B . 20233)
    (?$AXy(B . 20267)
    (?$AXz(B . 20318)
    (?$AX{(B . 20327)
    (?$AX|(B . 25912)
    (?$AX}(B . 20314)
    (?$AX~(B . 20317)
    (?$AY!(B . 20319)
    (?$AY"(B . 20311)
    (?$AY#(B . 20274)
    (?$AY$(B . 20285)
    (?$AY%(B . 20342)
    (?$AY&(B . 20340)
    (?$AY'(B . 20369)
    (?$AY((B . 20361)
    (?$AY)(B . 20355)
    (?$AY*(B . 20367)
    (?$AY+(B . 20350)
    (?$AY,(B . 20347)
    (?$AY-(B . 20394)
    (?$AY.(B . 20348)
    (?$AY/(B . 20396)
    (?$AY0(B . 20372)
    (?$AY1(B . 20454)
    (?$AY2(B . 20456)
    (?$AY3(B . 20458)
    (?$AY4(B . 20421)
    (?$AY5(B . 20442)
    (?$AY6(B . 20451)
    (?$AY7(B . 20444)
    (?$AY8(B . 20433)
    (?$AY9(B . 20447)
    (?$AY:(B . 20472)
    (?$AY;(B . 20521)
    (?$AY<(B . 20556)
    (?$AY=(B . 20467)
    (?$AY>(B . 20524)
    (?$AY?(B . 20495)
    (?$AY@(B . 20526)
    (?$AYA(B . 20525)
    (?$AYB(B . 20478)
    (?$AYC(B . 20508)
    (?$AYD(B . 20492)
    (?$AYE(B . 20517)
    (?$AYF(B . 20520)
    (?$AYG(B . 20606)
    (?$AYH(B . 20547)
    (?$AYI(B . 20565)
    (?$AYJ(B . 20552)
    (?$AYK(B . 20558)
    (?$AYL(B . 20588)
    (?$AYM(B . 20603)
    (?$AYN(B . 20645)
    (?$AYO(B . 20647)
    (?$AYP(B . 20649)
    (?$AYQ(B . 20666)
    (?$AYR(B . 20694)
    (?$AYS(B . 20742)
    (?$AYT(B . 20717)
    (?$AYU(B . 20716)
    (?$AYV(B . 20710)
    (?$AYW(B . 20718)
    (?$AYX(B . 20743)
    (?$AYY(B . 20747)
    (?$AYZ(B . 20189)
    (?$AY[(B . 27709)
    (?$AY\(B . 20312)
    (?$AY](B . 20325)
    (?$AY^(B . 20430)
    (?$AY_(B . 40864)
    (?$AY`(B . 27718)
    (?$AYa(B . 31860)
    (?$AYb(B . 20846)
    (?$AYc(B . 24061)
    (?$AYd(B . 40649)
    (?$AYe(B . 39320)
    (?$AYf(B . 20865)
    (?$AYg(B . 22804)
    (?$AYh(B . 21241)
    (?$AYi(B . 21261)
    (?$AYj(B . 35335)
    (?$AYk(B . 21264)
    (?$AYl(B . 20971)
    (?$AYm(B . 22809)
    (?$AYn(B . 20821)
    (?$AYo(B . 20128)
    (?$AYp(B . 20822)
    (?$AYq(B . 20147)
    (?$AYr(B . 34926)
    (?$AYs(B . 34980)
    (?$AYt(B . 20149)
    (?$AYu(B . 33044)
    (?$AYv(B . 35026)
    (?$AYw(B . 31104)
    (?$AYx(B . 23348)
    (?$AYy(B . 34819)
    (?$AYz(B . 32696)
    (?$AY{(B . 20907)
    (?$AY|(B . 20913)
    (?$AY}(B . 20925)
    (?$AY~(B . 20924)
    (?$AZ!(B . 20935)
    (?$AZ"(B . 20886)
    (?$AZ#(B . 20898)
    (?$AZ$(B . 20901)
    (?$AZ%(B . 35744)
    (?$AZ&(B . 35750)
    (?$AZ'(B . 35751)
    (?$AZ((B . 35754)
    (?$AZ)(B . 35764)
    (?$AZ*(B . 35765)
    (?$AZ+(B . 35767)
    (?$AZ,(B . 35778)
    (?$AZ-(B . 35779)
    (?$AZ.(B . 35787)
    (?$AZ/(B . 35791)
    (?$AZ0(B . 35790)
    (?$AZ1(B . 35794)
    (?$AZ2(B . 35795)
    (?$AZ3(B . 35796)
    (?$AZ4(B . 35798)
    (?$AZ5(B . 35800)
    (?$AZ6(B . 35801)
    (?$AZ7(B . 35804)
    (?$AZ8(B . 35807)
    (?$AZ9(B . 35808)
    (?$AZ:(B . 35812)
    (?$AZ;(B . 35816)
    (?$AZ<(B . 35817)
    (?$AZ=(B . 35822)
    (?$AZ>(B . 35824)
    (?$AZ?(B . 35827)
    (?$AZ@(B . 35830)
    (?$AZA(B . 35833)
    (?$AZB(B . 35836)
    (?$AZC(B . 35839)
    (?$AZD(B . 35840)
    (?$AZE(B . 35842)
    (?$AZF(B . 35844)
    (?$AZG(B . 35847)
    (?$AZH(B . 35852)
    (?$AZI(B . 35855)
    (?$AZJ(B . 35857)
    (?$AZK(B . 35858)
    (?$AZL(B . 35860)
    (?$AZM(B . 35861)
    (?$AZN(B . 35862)
    (?$AZO(B . 35865)
    (?$AZP(B . 35867)
    (?$AZQ(B . 35864)
    (?$AZR(B . 35869)
    (?$AZS(B . 35871)
    (?$AZT(B . 35872)
    (?$AZU(B . 35873)
    (?$AZV(B . 35877)
    (?$AZW(B . 35879)
    (?$AZX(B . 35882)
    (?$AZY(B . 35883)
    (?$AZZ(B . 35886)
    (?$AZ[(B . 35887)
    (?$AZ\(B . 35890)
    (?$AZ](B . 35891)
    (?$AZ^(B . 35893)
    (?$AZ_(B . 35894)
    (?$AZ`(B . 21353)
    (?$AZa(B . 21370)
    (?$AZb(B . 38429)
    (?$AZc(B . 38434)
    (?$AZd(B . 38433)
    (?$AZe(B . 38449)
    (?$AZf(B . 38442)
    (?$AZg(B . 38461)
    (?$AZh(B . 38460)
    (?$AZi(B . 38466)
    (?$AZj(B . 38473)
    (?$AZk(B . 38484)
    (?$AZl(B . 38495)
    (?$AZm(B . 38503)
    (?$AZn(B . 38508)
    (?$AZo(B . 38514)
    (?$AZp(B . 38516)
    (?$AZq(B . 38536)
    (?$AZr(B . 38541)
    (?$AZs(B . 38551)
    (?$AZt(B . 38576)
    (?$AZu(B . 37015)
    (?$AZv(B . 37019)
    (?$AZw(B . 37021)
    (?$AZx(B . 37017)
    (?$AZy(B . 37036)
    (?$AZz(B . 37025)
    (?$AZ{(B . 37044)
    (?$AZ|(B . 37043)
    (?$AZ}(B . 37046)
    (?$AZ~(B . 37050)
    (?$A[!(B . 37048)
    (?$A["(B . 37040)
    (?$A[#(B . 37071)
    (?$A[$(B . 37061)
    (?$A[%(B . 37054)
    (?$A[&(B . 37072)
    (?$A['(B . 37060)
    (?$A[((B . 37063)
    (?$A[)(B . 37075)
    (?$A[*(B . 37094)
    (?$A[+(B . 37090)
    (?$A[,(B . 37084)
    (?$A[-(B . 37079)
    (?$A[.(B . 37083)
    (?$A[/(B . 37099)
    (?$A[0(B . 37103)
    (?$A[1(B . 37118)
    (?$A[2(B . 37124)
    (?$A[3(B . 37154)
    (?$A[4(B . 37150)
    (?$A[5(B . 37155)
    (?$A[6(B . 37169)
    (?$A[7(B . 37167)
    (?$A[8(B . 37177)
    (?$A[9(B . 37187)
    (?$A[:(B . 37190)
    (?$A[;(B . 21005)
    (?$A[<(B . 22850)
    (?$A[=(B . 21154)
    (?$A[>(B . 21164)
    (?$A[?(B . 21165)
    (?$A[@(B . 21182)
    (?$A[A(B . 21759)
    (?$A[B(B . 21200)
    (?$A[C(B . 21206)
    (?$A[D(B . 21232)
    (?$A[E(B . 21471)
    (?$A[F(B . 29166)
    (?$A[G(B . 30669)
    (?$A[H(B . 24308)
    (?$A[I(B . 20981)
    (?$A[J(B . 20988)
    (?$A[K(B . 39727)
    (?$A[L(B . 21430)
    (?$A[M(B . 24321)
    (?$A[N(B . 30042)
    (?$A[O(B . 24047)
    (?$A[P(B . 22348)
    (?$A[Q(B . 22441)
    (?$A[R(B . 22433)
    (?$A[S(B . 22654)
    (?$A[T(B . 22716)
    (?$A[U(B . 22725)
    (?$A[V(B . 22737)
    (?$A[W(B . 22313)
    (?$A[X(B . 22316)
    (?$A[Y(B . 22314)
    (?$A[Z(B . 22323)
    (?$A[[(B . 22329)
    (?$A[\(B . 22318)
    (?$A[](B . 22319)
    (?$A[^(B . 22364)
    (?$A[_(B . 22331)
    (?$A[`(B . 22338)
    (?$A[a(B . 22377)
    (?$A[b(B . 22405)
    (?$A[c(B . 22379)
    (?$A[d(B . 22406)
    (?$A[e(B . 22396)
    (?$A[f(B . 22395)
    (?$A[g(B . 22376)
    (?$A[h(B . 22381)
    (?$A[i(B . 22390)
    (?$A[j(B . 22387)
    (?$A[k(B . 22445)
    (?$A[l(B . 22436)
    (?$A[m(B . 22412)
    (?$A[n(B . 22450)
    (?$A[o(B . 22479)
    (?$A[p(B . 22439)
    (?$A[q(B . 22452)
    (?$A[r(B . 22419)
    (?$A[s(B . 22432)
    (?$A[t(B . 22485)
    (?$A[u(B . 22488)
    (?$A[v(B . 22490)
    (?$A[w(B . 22489)
    (?$A[x(B . 22482)
    (?$A[y(B . 22456)
    (?$A[z(B . 22516)
    (?$A[{(B . 22511)
    (?$A[|(B . 22520)
    (?$A[}(B . 22500)
    (?$A[~(B . 22493)
    (?$A\!(B . 22539)
    (?$A\"(B . 22541)
    (?$A\#(B . 22525)
    (?$A\$(B . 22509)
    (?$A\%(B . 22528)
    (?$A\&(B . 22558)
    (?$A\'(B . 22553)
    (?$A\((B . 22596)
    (?$A\)(B . 22560)
    (?$A\*(B . 22629)
    (?$A\+(B . 22636)
    (?$A\,(B . 22657)
    (?$A\-(B . 22665)
    (?$A\.(B . 22682)
    (?$A\/(B . 22656)
    (?$A\0(B . 39336)
    (?$A\1(B . 40729)
    (?$A\2(B . 25087)
    (?$A\3(B . 33401)
    (?$A\4(B . 33405)
    (?$A\5(B . 33407)
    (?$A\6(B . 33423)
    (?$A\7(B . 33418)
    (?$A\8(B . 33448)
    (?$A\9(B . 33412)
    (?$A\:(B . 33422)
    (?$A\;(B . 33425)
    (?$A\<(B . 33431)
    (?$A\=(B . 33433)
    (?$A\>(B . 33451)
    (?$A\?(B . 33464)
    (?$A\@(B . 33470)
    (?$A\A(B . 33456)
    (?$A\B(B . 33480)
    (?$A\C(B . 33482)
    (?$A\D(B . 33507)
    (?$A\E(B . 33432)
    (?$A\F(B . 33463)
    (?$A\G(B . 33454)
    (?$A\H(B . 33483)
    (?$A\I(B . 33484)
    (?$A\J(B . 33473)
    (?$A\K(B . 33449)
    (?$A\L(B . 33460)
    (?$A\M(B . 33441)
    (?$A\N(B . 33450)
    (?$A\O(B . 33439)
    (?$A\P(B . 33476)
    (?$A\Q(B . 33486)
    (?$A\R(B . 33444)
    (?$A\S(B . 33505)
    (?$A\T(B . 33545)
    (?$A\U(B . 33527)
    (?$A\V(B . 33508)
    (?$A\W(B . 33551)
    (?$A\X(B . 33543)
    (?$A\Y(B . 33500)
    (?$A\Z(B . 33524)
    (?$A\[(B . 33490)
    (?$A\\(B . 33496)
    (?$A\](B . 33548)
    (?$A\^(B . 33531)
    (?$A\_(B . 33491)
    (?$A\`(B . 33553)
    (?$A\a(B . 33562)
    (?$A\b(B . 33542)
    (?$A\c(B . 33556)
    (?$A\d(B . 33557)
    (?$A\e(B . 33504)
    (?$A\f(B . 33493)
    (?$A\g(B . 33564)
    (?$A\h(B . 33617)
    (?$A\i(B . 33627)
    (?$A\j(B . 33628)
    (?$A\k(B . 33544)
    (?$A\l(B . 33682)
    (?$A\m(B . 33596)
    (?$A\n(B . 33588)
    (?$A\o(B . 33585)
    (?$A\p(B . 33691)
    (?$A\q(B . 33630)
    (?$A\r(B . 33583)
    (?$A\s(B . 33615)
    (?$A\t(B . 33607)
    (?$A\u(B . 33603)
    (?$A\v(B . 33631)
    (?$A\w(B . 33600)
    (?$A\x(B . 33559)
    (?$A\y(B . 33632)
    (?$A\z(B . 33581)
    (?$A\{(B . 33594)
    (?$A\|(B . 33587)
    (?$A\}(B . 33638)
    (?$A\~(B . 33637)
    (?$A]!(B . 33640)
    (?$A]"(B . 33563)
    (?$A]#(B . 33641)
    (?$A]$(B . 33644)
    (?$A]%(B . 33642)
    (?$A]&(B . 33645)
    (?$A]'(B . 33646)
    (?$A]((B . 33712)
    (?$A])(B . 33656)
    (?$A]*(B . 33715)
    (?$A]+(B . 33716)
    (?$A],(B . 33696)
    (?$A]-(B . 33706)
    (?$A].(B . 33683)
    (?$A]/(B . 33692)
    (?$A]0(B . 33669)
    (?$A]1(B . 33660)
    (?$A]2(B . 33718)
    (?$A]3(B . 33705)
    (?$A]4(B . 33661)
    (?$A]5(B . 33720)
    (?$A]6(B . 33659)
    (?$A]7(B . 33688)
    (?$A]8(B . 33694)
    (?$A]9(B . 33704)
    (?$A]:(B . 33722)
    (?$A];(B . 33724)
    (?$A]<(B . 33729)
    (?$A]=(B . 33793)
    (?$A]>(B . 33765)
    (?$A]?(B . 33752)
    (?$A]@(B . 22535)
    (?$A]A(B . 33816)
    (?$A]B(B . 33803)
    (?$A]C(B . 33757)
    (?$A]D(B . 33789)
    (?$A]E(B . 33750)
    (?$A]F(B . 33820)
    (?$A]G(B . 33848)
    (?$A]H(B . 33809)
    (?$A]I(B . 33798)
    (?$A]J(B . 33748)
    (?$A]K(B . 33759)
    (?$A]L(B . 33807)
    (?$A]M(B . 33795)
    (?$A]N(B . 33784)
    (?$A]O(B . 33785)
    (?$A]P(B . 33770)
    (?$A]Q(B . 33733)
    (?$A]R(B . 33728)
    (?$A]S(B . 33830)
    (?$A]T(B . 33776)
    (?$A]U(B . 33761)
    (?$A]V(B . 33884)
    (?$A]W(B . 33873)
    (?$A]X(B . 33882)
    (?$A]Y(B . 33881)
    (?$A]Z(B . 33907)
    (?$A][(B . 33927)
    (?$A]\(B . 33928)
    (?$A]](B . 33914)
    (?$A]^(B . 33929)
    (?$A]_(B . 33912)
    (?$A]`(B . 33852)
    (?$A]a(B . 33862)
    (?$A]b(B . 33897)
    (?$A]c(B . 33910)
    (?$A]d(B . 33932)
    (?$A]e(B . 33934)
    (?$A]f(B . 33841)
    (?$A]g(B . 33901)
    (?$A]h(B . 33985)
    (?$A]i(B . 33997)
    (?$A]j(B . 34000)
    (?$A]k(B . 34022)
    (?$A]l(B . 33981)
    (?$A]m(B . 34003)
    (?$A]n(B . 33994)
    (?$A]o(B . 33983)
    (?$A]p(B . 33978)
    (?$A]q(B . 34016)
    (?$A]r(B . 33953)
    (?$A]s(B . 33977)
    (?$A]t(B . 33972)
    (?$A]u(B . 33943)
    (?$A]v(B . 34021)
    (?$A]w(B . 34019)
    (?$A]x(B . 34060)
    (?$A]y(B . 29965)
    (?$A]z(B . 34104)
    (?$A]{(B . 34032)
    (?$A]|(B . 34105)
    (?$A]}(B . 34079)
    (?$A]~(B . 34106)
    (?$A^!(B . 34134)
    (?$A^"(B . 34107)
    (?$A^#(B . 34047)
    (?$A^$(B . 34044)
    (?$A^%(B . 34137)
    (?$A^&(B . 34120)
    (?$A^'(B . 34152)
    (?$A^((B . 34148)
    (?$A^)(B . 34142)
    (?$A^*(B . 34170)
    (?$A^+(B . 30626)
    (?$A^,(B . 34115)
    (?$A^-(B . 34162)
    (?$A^.(B . 34171)
    (?$A^/(B . 34212)
    (?$A^0(B . 34216)
    (?$A^1(B . 34183)
    (?$A^2(B . 34191)
    (?$A^3(B . 34169)
    (?$A^4(B . 34222)
    (?$A^5(B . 34204)
    (?$A^6(B . 34181)
    (?$A^7(B . 34233)
    (?$A^8(B . 34231)
    (?$A^9(B . 34224)
    (?$A^:(B . 34259)
    (?$A^;(B . 34241)
    (?$A^<(B . 34268)
    (?$A^=(B . 34303)
    (?$A^>(B . 34343)
    (?$A^?(B . 34309)
    (?$A^@(B . 34345)
    (?$A^A(B . 34326)
    (?$A^B(B . 34364)
    (?$A^C(B . 24318)
    (?$A^D(B . 24328)
    (?$A^E(B . 22844)
    (?$A^F(B . 22849)
    (?$A^G(B . 32823)
    (?$A^H(B . 22869)
    (?$A^I(B . 22874)
    (?$A^J(B . 22872)
    (?$A^K(B . 21263)
    (?$A^L(B . 23586)
    (?$A^M(B . 23589)
    (?$A^N(B . 23596)
    (?$A^O(B . 23604)
    (?$A^P(B . 25164)
    (?$A^Q(B . 25194)
    (?$A^R(B . 25247)
    (?$A^S(B . 25275)
    (?$A^T(B . 25290)
    (?$A^U(B . 25306)
    (?$A^V(B . 25303)
    (?$A^W(B . 25326)
    (?$A^X(B . 25378)
    (?$A^Y(B . 25334)
    (?$A^Z(B . 25401)
    (?$A^[(B . 25419)
    (?$A^\(B . 25411)
    (?$A^](B . 25517)
    (?$A^^(B . 25590)
    (?$A^_(B . 25457)
    (?$A^`(B . 25466)
    (?$A^a(B . 25486)
    (?$A^b(B . 25524)
    (?$A^c(B . 25453)
    (?$A^d(B . 25516)
    (?$A^e(B . 25482)
    (?$A^f(B . 25449)
    (?$A^g(B . 25518)
    (?$A^h(B . 25532)
    (?$A^i(B . 25586)
    (?$A^j(B . 25592)
    (?$A^k(B . 25568)
    (?$A^l(B . 25599)
    (?$A^m(B . 25540)
    (?$A^n(B . 25566)
    (?$A^o(B . 25550)
    (?$A^p(B . 25682)
    (?$A^q(B . 25542)
    (?$A^r(B . 25534)
    (?$A^s(B . 25669)
    (?$A^t(B . 25665)
    (?$A^u(B . 25611)
    (?$A^v(B . 25627)
    (?$A^w(B . 25632)
    (?$A^x(B . 25612)
    (?$A^y(B . 25638)
    (?$A^z(B . 25633)
    (?$A^{(B . 25694)
    (?$A^|(B . 25732)
    (?$A^}(B . 25709)
    (?$A^~(B . 25750)
    (?$A_!(B . 25722)
    (?$A_"(B . 25783)
    (?$A_#(B . 25784)
    (?$A_$(B . 25753)
    (?$A_%(B . 25786)
    (?$A_&(B . 25792)
    (?$A_'(B . 25808)
    (?$A_((B . 25815)
    (?$A_)(B . 25828)
    (?$A_*(B . 25826)
    (?$A_+(B . 25865)
    (?$A_,(B . 25893)
    (?$A_-(B . 25902)
    (?$A_.(B . 24331)
    (?$A_/(B . 24530)
    (?$A_0(B . 29977)
    (?$A_1(B . 24337)
    (?$A_2(B . 21343)
    (?$A_3(B . 21489)
    (?$A_4(B . 21501)
    (?$A_5(B . 21481)
    (?$A_6(B . 21480)
    (?$A_7(B . 21499)
    (?$A_8(B . 21522)
    (?$A_9(B . 21526)
    (?$A_:(B . 21510)
    (?$A_;(B . 21579)
    (?$A_<(B . 21586)
    (?$A_=(B . 21587)
    (?$A_>(B . 21588)
    (?$A_?(B . 21590)
    (?$A_@(B . 21571)
    (?$A_A(B . 21537)
    (?$A_B(B . 21591)
    (?$A_C(B . 21593)
    (?$A_D(B . 21539)
    (?$A_E(B . 21554)
    (?$A_F(B . 21634)
    (?$A_G(B . 21652)
    (?$A_H(B . 21623)
    (?$A_I(B . 21617)
    (?$A_J(B . 21604)
    (?$A_K(B . 21658)
    (?$A_L(B . 21659)
    (?$A_M(B . 21636)
    (?$A_N(B . 21622)
    (?$A_O(B . 21606)
    (?$A_P(B . 21661)
    (?$A_Q(B . 21712)
    (?$A_R(B . 21677)
    (?$A_S(B . 21698)
    (?$A_T(B . 21684)
    (?$A_U(B . 21714)
    (?$A_V(B . 21671)
    (?$A_W(B . 21670)
    (?$A_X(B . 21715)
    (?$A_Y(B . 21716)
    (?$A_Z(B . 21618)
    (?$A_[(B . 21667)
    (?$A_\(B . 21717)
    (?$A_](B . 21691)
    (?$A_^(B . 21695)
    (?$A__(B . 21708)
    (?$A_`(B . 21721)
    (?$A_a(B . 21722)
    (?$A_b(B . 21724)
    (?$A_c(B . 21673)
    (?$A_d(B . 21674)
    (?$A_e(B . 21668)
    (?$A_f(B . 21725)
    (?$A_g(B . 21711)
    (?$A_h(B . 21726)
    (?$A_i(B . 21787)
    (?$A_j(B . 21735)
    (?$A_k(B . 21792)
    (?$A_l(B . 21757)
    (?$A_m(B . 21780)
    (?$A_n(B . 21747)
    (?$A_o(B . 21794)
    (?$A_p(B . 21795)
    (?$A_q(B . 21775)
    (?$A_r(B . 21777)
    (?$A_s(B . 21799)
    (?$A_t(B . 21802)
    (?$A_u(B . 21863)
    (?$A_v(B . 21903)
    (?$A_w(B . 21941)
    (?$A_x(B . 21833)
    (?$A_y(B . 21869)
    (?$A_z(B . 21825)
    (?$A_{(B . 21845)
    (?$A_|(B . 21823)
    (?$A_}(B . 21840)
    (?$A_~(B . 21820)
    (?$A`!(B . 21815)
    (?$A`"(B . 21846)
    (?$A`#(B . 21877)
    (?$A`$(B . 21878)
    (?$A`%(B . 21879)
    (?$A`&(B . 21811)
    (?$A`'(B . 21808)
    (?$A`((B . 21852)
    (?$A`)(B . 21899)
    (?$A`*(B . 21970)
    (?$A`+(B . 21891)
    (?$A`,(B . 21937)
    (?$A`-(B . 21945)
    (?$A`.(B . 21896)
    (?$A`/(B . 21889)
    (?$A`0(B . 21919)
    (?$A`1(B . 21886)
    (?$A`2(B . 21974)
    (?$A`3(B . 21905)
    (?$A`4(B . 21883)
    (?$A`5(B . 21983)
    (?$A`6(B . 21949)
    (?$A`7(B . 21950)
    (?$A`8(B . 21908)
    (?$A`9(B . 21913)
    (?$A`:(B . 21994)
    (?$A`;(B . 22007)
    (?$A`<(B . 21961)
    (?$A`=(B . 22047)
    (?$A`>(B . 21969)
    (?$A`?(B . 21995)
    (?$A`@(B . 21996)
    (?$A`A(B . 21972)
    (?$A`B(B . 21990)
    (?$A`C(B . 21981)
    (?$A`D(B . 21956)
    (?$A`E(B . 21999)
    (?$A`F(B . 21989)
    (?$A`G(B . 22002)
    (?$A`H(B . 22003)
    (?$A`I(B . 21964)
    (?$A`J(B . 21965)
    (?$A`K(B . 21992)
    (?$A`L(B . 22005)
    (?$A`M(B . 21988)
    (?$A`N(B . 36756)
    (?$A`O(B . 22046)
    (?$A`P(B . 22024)
    (?$A`Q(B . 22028)
    (?$A`R(B . 22017)
    (?$A`S(B . 22052)
    (?$A`T(B . 22051)
    (?$A`U(B . 22014)
    (?$A`V(B . 22016)
    (?$A`W(B . 22055)
    (?$A`X(B . 22061)
    (?$A`Y(B . 22104)
    (?$A`Z(B . 22073)
    (?$A`[(B . 22103)
    (?$A`\(B . 22060)
    (?$A`](B . 22093)
    (?$A`^(B . 22114)
    (?$A`_(B . 22105)
    (?$A``(B . 22108)
    (?$A`a(B . 22092)
    (?$A`b(B . 22100)
    (?$A`c(B . 22150)
    (?$A`d(B . 22116)
    (?$A`e(B . 22129)
    (?$A`f(B . 22123)
    (?$A`g(B . 22139)
    (?$A`h(B . 22140)
    (?$A`i(B . 22149)
    (?$A`j(B . 22163)
    (?$A`k(B . 22191)
    (?$A`l(B . 22228)
    (?$A`m(B . 22231)
    (?$A`n(B . 22237)
    (?$A`o(B . 22241)
    (?$A`p(B . 22261)
    (?$A`q(B . 22251)
    (?$A`r(B . 22265)
    (?$A`s(B . 22271)
    (?$A`t(B . 22276)
    (?$A`u(B . 22282)
    (?$A`v(B . 22281)
    (?$A`w(B . 22300)
    (?$A`x(B . 24079)
    (?$A`y(B . 24089)
    (?$A`z(B . 24084)
    (?$A`{(B . 24081)
    (?$A`|(B . 24113)
    (?$A`}(B . 24123)
    (?$A`~(B . 24124)
    (?$Aa!(B . 24119)
    (?$Aa"(B . 24132)
    (?$Aa#(B . 24148)
    (?$Aa$(B . 24155)
    (?$Aa%(B . 24158)
    (?$Aa&(B . 24161)
    (?$Aa'(B . 23692)
    (?$Aa((B . 23674)
    (?$Aa)(B . 23693)
    (?$Aa*(B . 23696)
    (?$Aa+(B . 23702)
    (?$Aa,(B . 23688)
    (?$Aa-(B . 23704)
    (?$Aa.(B . 23705)
    (?$Aa/(B . 23697)
    (?$Aa0(B . 23706)
    (?$Aa1(B . 23708)
    (?$Aa2(B . 23733)
    (?$Aa3(B . 23714)
    (?$Aa4(B . 23741)
    (?$Aa5(B . 23724)
    (?$Aa6(B . 23723)
    (?$Aa7(B . 23729)
    (?$Aa8(B . 23715)
    (?$Aa9(B . 23745)
    (?$Aa:(B . 23735)
    (?$Aa;(B . 23748)
    (?$Aa<(B . 23762)
    (?$Aa=(B . 23780)
    (?$Aa>(B . 23755)
    (?$Aa?(B . 23781)
    (?$Aa@(B . 23810)
    (?$AaA(B . 23811)
    (?$AaB(B . 23847)
    (?$AaC(B . 23846)
    (?$AaD(B . 23854)
    (?$AaE(B . 23844)
    (?$AaF(B . 23838)
    (?$AaG(B . 23814)
    (?$AaH(B . 23835)
    (?$AaI(B . 23896)
    (?$AaJ(B . 23870)
    (?$AaK(B . 23860)
    (?$AaL(B . 23869)
    (?$AaM(B . 23916)
    (?$AaN(B . 23899)
    (?$AaO(B . 23919)
    (?$AaP(B . 23901)
    (?$AaQ(B . 23915)
    (?$AaR(B . 23883)
    (?$AaS(B . 23882)
    (?$AaT(B . 23913)
    (?$AaU(B . 23924)
    (?$AaV(B . 23938)
    (?$AaW(B . 23961)
    (?$AaX(B . 23965)
    (?$AaY(B . 35955)
    (?$AaZ(B . 23991)
    (?$Aa[(B . 24005)
    (?$Aa\(B . 24435)
    (?$Aa](B . 24439)
    (?$Aa^(B . 24450)
    (?$Aa_(B . 24455)
    (?$Aa`(B . 24457)
    (?$Aaa(B . 24460)
    (?$Aab(B . 24469)
    (?$Aac(B . 24473)
    (?$Aad(B . 24476)
    (?$Aae(B . 24488)
    (?$Aaf(B . 24493)
    (?$Aag(B . 24501)
    (?$Aah(B . 24508)
    (?$Aai(B . 34914)
    (?$Aaj(B . 24417)
    (?$Aak(B . 29357)
    (?$Aal(B . 29360)
    (?$Aam(B . 29364)
    (?$Aan(B . 29367)
    (?$Aao(B . 29368)
    (?$Aap(B . 29379)
    (?$Aaq(B . 29377)
    (?$Aar(B . 29390)
    (?$Aas(B . 29389)
    (?$Aat(B . 29394)
    (?$Aau(B . 29416)
    (?$Aav(B . 29423)
    (?$Aaw(B . 29417)
    (?$Aax(B . 29426)
    (?$Aay(B . 29428)
    (?$Aaz(B . 29431)
    (?$Aa{(B . 29441)
    (?$Aa|(B . 29427)
    (?$Aa}(B . 29443)
    (?$Aa~(B . 29434)
    (?$Ab!(B . 29435)
    (?$Ab"(B . 29463)
    (?$Ab#(B . 29459)
    (?$Ab$(B . 29473)
    (?$Ab%(B . 29450)
    (?$Ab&(B . 29470)
    (?$Ab'(B . 29469)
    (?$Ab((B . 29461)
    (?$Ab)(B . 29474)
    (?$Ab*(B . 29497)
    (?$Ab+(B . 29477)
    (?$Ab,(B . 29484)
    (?$Ab-(B . 29496)
    (?$Ab.(B . 29489)
    (?$Ab/(B . 29520)
    (?$Ab0(B . 29517)
    (?$Ab1(B . 29527)
    (?$Ab2(B . 29536)
    (?$Ab3(B . 29548)
    (?$Ab4(B . 29551)
    (?$Ab5(B . 29566)
    (?$Ab6(B . 33307)
    (?$Ab7(B . 22821)
    (?$Ab8(B . 39143)
    (?$Ab9(B . 22820)
    (?$Ab:(B . 22786)
    (?$Ab;(B . 39267)
    (?$Ab<(B . 39271)
    (?$Ab=(B . 39272)
    (?$Ab>(B . 39273)
    (?$Ab?(B . 39274)
    (?$Ab@(B . 39275)
    (?$AbA(B . 39276)
    (?$AbB(B . 39284)
    (?$AbC(B . 39287)
    (?$AbD(B . 39293)
    (?$AbE(B . 39296)
    (?$AbF(B . 39300)
    (?$AbG(B . 39303)
    (?$AbH(B . 39306)
    (?$AbI(B . 39309)
    (?$AbJ(B . 39312)
    (?$AbK(B . 39313)
    (?$AbL(B . 39315)
    (?$AbM(B . 39316)
    (?$AbN(B . 39317)
    (?$AbO(B . 24192)
    (?$AbP(B . 24209)
    (?$AbQ(B . 24203)
    (?$AbR(B . 24214)
    (?$AbS(B . 24229)
    (?$AbT(B . 24224)
    (?$AbU(B . 24249)
    (?$AbV(B . 24245)
    (?$AbW(B . 24254)
    (?$AbX(B . 24243)
    (?$AbY(B . 36179)
    (?$AbZ(B . 24274)
    (?$Ab[(B . 24273)
    (?$Ab\(B . 24283)
    (?$Ab](B . 24296)
    (?$Ab^(B . 24298)
    (?$Ab_(B . 33210)
    (?$Ab`(B . 24516)
    (?$Aba(B . 24521)
    (?$Abb(B . 24534)
    (?$Abc(B . 24527)
    (?$Abd(B . 24579)
    (?$Abe(B . 24558)
    (?$Abf(B . 24580)
    (?$Abg(B . 24545)
    (?$Abh(B . 24548)
    (?$Abi(B . 24574)
    (?$Abj(B . 24581)
    (?$Abk(B . 24582)
    (?$Abl(B . 24554)
    (?$Abm(B . 24557)
    (?$Abn(B . 24568)
    (?$Abo(B . 24601)
    (?$Abp(B . 24629)
    (?$Abq(B . 24614)
    (?$Abr(B . 24603)
    (?$Abs(B . 24591)
    (?$Abt(B . 24589)
    (?$Abu(B . 24617)
    (?$Abv(B . 24619)
    (?$Abw(B . 24586)
    (?$Abx(B . 24639)
    (?$Aby(B . 24609)
    (?$Abz(B . 24696)
    (?$Ab{(B . 24697)
    (?$Ab|(B . 24699)
    (?$Ab}(B . 24698)
    (?$Ab~(B . 24642)
    (?$Ac!(B . 24682)
    (?$Ac"(B . 24701)
    (?$Ac#(B . 24726)
    (?$Ac$(B . 24730)
    (?$Ac%(B . 24749)
    (?$Ac&(B . 24733)
    (?$Ac'(B . 24707)
    (?$Ac((B . 24722)
    (?$Ac)(B . 24716)
    (?$Ac*(B . 24731)
    (?$Ac+(B . 24812)
    (?$Ac,(B . 24763)
    (?$Ac-(B . 24753)
    (?$Ac.(B . 24797)
    (?$Ac/(B . 24792)
    (?$Ac0(B . 24774)
    (?$Ac1(B . 24794)
    (?$Ac2(B . 24756)
    (?$Ac3(B . 24864)
    (?$Ac4(B . 24870)
    (?$Ac5(B . 24853)
    (?$Ac6(B . 24867)
    (?$Ac7(B . 24820)
    (?$Ac8(B . 24832)
    (?$Ac9(B . 24846)
    (?$Ac:(B . 24875)
    (?$Ac;(B . 24906)
    (?$Ac<(B . 24949)
    (?$Ac=(B . 25004)
    (?$Ac>(B . 24980)
    (?$Ac?(B . 24999)
    (?$Ac@(B . 25015)
    (?$AcA(B . 25044)
    (?$AcB(B . 25077)
    (?$AcC(B . 24541)
    (?$AcD(B . 38579)
    (?$AcE(B . 38377)
    (?$AcF(B . 38379)
    (?$AcG(B . 38385)
    (?$AcH(B . 38387)
    (?$AcI(B . 38389)
    (?$AcJ(B . 38390)
    (?$AcK(B . 38396)
    (?$AcL(B . 38398)
    (?$AcM(B . 38403)
    (?$AcN(B . 38404)
    (?$AcO(B . 38406)
    (?$AcP(B . 38408)
    (?$AcQ(B . 38410)
    (?$AcR(B . 38411)
    (?$AcS(B . 38412)
    (?$AcT(B . 38413)
    (?$AcU(B . 38415)
    (?$AcV(B . 38418)
    (?$AcW(B . 38421)
    (?$AcX(B . 38422)
    (?$AcY(B . 38423)
    (?$AcZ(B . 38425)
    (?$Ac[(B . 38426)
    (?$Ac\(B . 20012)
    (?$Ac](B . 29247)
    (?$Ac^(B . 25109)
    (?$Ac_(B . 27701)
    (?$Ac`(B . 27732)
    (?$Aca(B . 27740)
    (?$Acb(B . 27722)
    (?$Acc(B . 27811)
    (?$Acd(B . 27781)
    (?$Ace(B . 27792)
    (?$Acf(B . 27796)
    (?$Acg(B . 27788)
    (?$Ach(B . 27752)
    (?$Aci(B . 27753)
    (?$Acj(B . 27764)
    (?$Ack(B . 27766)
    (?$Acl(B . 27782)
    (?$Acm(B . 27817)
    (?$Acn(B . 27856)
    (?$Aco(B . 27860)
    (?$Acp(B . 27821)
    (?$Acq(B . 27895)
    (?$Acr(B . 27896)
    (?$Acs(B . 27889)
    (?$Act(B . 27863)
    (?$Acu(B . 27826)
    (?$Acv(B . 27872)
    (?$Acw(B . 27862)
    (?$Acx(B . 27898)
    (?$Acy(B . 27883)
    (?$Acz(B . 27886)
    (?$Ac{(B . 27825)
    (?$Ac|(B . 27859)
    (?$Ac}(B . 27887)
    (?$Ac~(B . 27902)
    (?$Ad!(B . 27961)
    (?$Ad"(B . 27943)
    (?$Ad#(B . 27916)
    (?$Ad$(B . 27971)
    (?$Ad%(B . 27976)
    (?$Ad&(B . 27911)
    (?$Ad'(B . 27908)
    (?$Ad((B . 27929)
    (?$Ad)(B . 27918)
    (?$Ad*(B . 27947)
    (?$Ad+(B . 27981)
    (?$Ad,(B . 27950)
    (?$Ad-(B . 27957)
    (?$Ad.(B . 27930)
    (?$Ad/(B . 27983)
    (?$Ad0(B . 27986)
    (?$Ad1(B . 27988)
    (?$Ad2(B . 27955)
    (?$Ad3(B . 28049)
    (?$Ad4(B . 28015)
    (?$Ad5(B . 28062)
    (?$Ad6(B . 28064)
    (?$Ad7(B . 27998)
    (?$Ad8(B . 28051)
    (?$Ad9(B . 28052)
    (?$Ad:(B . 27996)
    (?$Ad;(B . 28000)
    (?$Ad<(B . 28028)
    (?$Ad=(B . 28003)
    (?$Ad>(B . 28186)
    (?$Ad?(B . 28103)
    (?$Ad@(B . 28101)
    (?$AdA(B . 28126)
    (?$AdB(B . 28174)
    (?$AdC(B . 28095)
    (?$AdD(B . 28128)
    (?$AdE(B . 28177)
    (?$AdF(B . 28134)
    (?$AdG(B . 28125)
    (?$AdH(B . 28121)
    (?$AdI(B . 28182)
    (?$AdJ(B . 28075)
    (?$AdK(B . 28172)
    (?$AdL(B . 28078)
    (?$AdM(B . 28203)
    (?$AdN(B . 28270)
    (?$AdO(B . 28238)
    (?$AdP(B . 28267)
    (?$AdQ(B . 28338)
    (?$AdR(B . 28255)
    (?$AdS(B . 28294)
    (?$AdT(B . 28243)
    (?$AdU(B . 28244)
    (?$AdV(B . 28210)
    (?$AdW(B . 28197)
    (?$AdX(B . 28228)
    (?$AdY(B . 28383)
    (?$AdZ(B . 28337)
    (?$Ad[(B . 28312)
    (?$Ad\(B . 28384)
    (?$Ad](B . 28461)
    (?$Ad^(B . 28386)
    (?$Ad_(B . 28325)
    (?$Ad`(B . 28327)
    (?$Ada(B . 28349)
    (?$Adb(B . 28347)
    (?$Adc(B . 28343)
    (?$Add(B . 28375)
    (?$Ade(B . 28340)
    (?$Adf(B . 28367)
    (?$Adg(B . 28303)
    (?$Adh(B . 28354)
    (?$Adi(B . 28319)
    (?$Adj(B . 28514)
    (?$Adk(B . 28486)
    (?$Adl(B . 28487)
    (?$Adm(B . 28452)
    (?$Adn(B . 28437)
    (?$Ado(B . 28409)
    (?$Adp(B . 28463)
    (?$Adq(B . 28470)
    (?$Adr(B . 28491)
    (?$Ads(B . 28532)
    (?$Adt(B . 28458)
    (?$Adu(B . 28425)
    (?$Adv(B . 28457)
    (?$Adw(B . 28553)
    (?$Adx(B . 28557)
    (?$Ady(B . 28556)
    (?$Adz(B . 28536)
    (?$Ad{(B . 28530)
    (?$Ad|(B . 28540)
    (?$Ad}(B . 28538)
    (?$Ad~(B . 28625)
    (?$Ae!(B . 28617)
    (?$Ae"(B . 28583)
    (?$Ae#(B . 28601)
    (?$Ae$(B . 28598)
    (?$Ae%(B . 28610)
    (?$Ae&(B . 28641)
    (?$Ae'(B . 28654)
    (?$Ae((B . 28638)
    (?$Ae)(B . 28640)
    (?$Ae*(B . 28655)
    (?$Ae+(B . 28698)
    (?$Ae,(B . 28707)
    (?$Ae-(B . 28699)
    (?$Ae.(B . 28729)
    (?$Ae/(B . 28725)
    (?$Ae0(B . 28751)
    (?$Ae1(B . 28766)
    (?$Ae2(B . 23424)
    (?$Ae3(B . 23428)
    (?$Ae4(B . 23445)
    (?$Ae5(B . 23443)
    (?$Ae6(B . 23461)
    (?$Ae7(B . 23480)
    (?$Ae8(B . 29999)
    (?$Ae9(B . 39582)
    (?$Ae:(B . 25652)
    (?$Ae;(B . 23524)
    (?$Ae<(B . 23534)
    (?$Ae=(B . 35120)
    (?$Ae>(B . 23536)
    (?$Ae?(B . 36423)
    (?$Ae@(B . 35591)
    (?$AeA(B . 36790)
    (?$AeB(B . 36819)
    (?$AeC(B . 36821)
    (?$AeD(B . 36837)
    (?$AeE(B . 36846)
    (?$AeF(B . 36836)
    (?$AeG(B . 36841)
    (?$AeH(B . 36838)
    (?$AeI(B . 36851)
    (?$AeJ(B . 36840)
    (?$AeK(B . 36869)
    (?$AeL(B . 36868)
    (?$AeM(B . 36875)
    (?$AeN(B . 36902)
    (?$AeO(B . 36881)
    (?$AeP(B . 36877)
    (?$AeQ(B . 36886)
    (?$AeR(B . 36897)
    (?$AeS(B . 36917)
    (?$AeT(B . 36918)
    (?$AeU(B . 36909)
    (?$AeV(B . 36911)
    (?$AeW(B . 36932)
    (?$AeX(B . 36945)
    (?$AeY(B . 36946)
    (?$AeZ(B . 36944)
    (?$Ae[(B . 36968)
    (?$Ae\(B . 36952)
    (?$Ae](B . 36962)
    (?$Ae^(B . 36955)
    (?$Ae_(B . 26297)
    (?$Ae`(B . 36980)
    (?$Aea(B . 36989)
    (?$Aeb(B . 36994)
    (?$Aec(B . 37000)
    (?$Aed(B . 36995)
    (?$Aee(B . 37003)
    (?$Aef(B . 24400)
    (?$Aeg(B . 24407)
    (?$Aeh(B . 24406)
    (?$Aei(B . 24408)
    (?$Aej(B . 23611)
    (?$Aek(B . 21675)
    (?$Ael(B . 23632)
    (?$Aem(B . 23641)
    (?$Aen(B . 23409)
    (?$Aeo(B . 23651)
    (?$Aep(B . 23654)
    (?$Aeq(B . 32700)
    (?$Aer(B . 24362)
    (?$Aes(B . 24361)
    (?$Aet(B . 24365)
    (?$Aeu(B . 33396)
    (?$Aev(B . 24380)
    (?$Aew(B . 39739)
    (?$Aex(B . 23662)
    (?$Aey(B . 22913)
    (?$Aez(B . 22915)
    (?$Ae{(B . 22925)
    (?$Ae|(B . 22953)
    (?$Ae}(B . 22954)
    (?$Ae~(B . 22947)
    (?$Af!(B . 22935)
    (?$Af"(B . 22986)
    (?$Af#(B . 22955)
    (?$Af$(B . 22942)
    (?$Af%(B . 22948)
    (?$Af&(B . 22994)
    (?$Af'(B . 22962)
    (?$Af((B . 22959)
    (?$Af)(B . 22999)
    (?$Af*(B . 22974)
    (?$Af+(B . 23045)
    (?$Af,(B . 23046)
    (?$Af-(B . 23005)
    (?$Af.(B . 23048)
    (?$Af/(B . 23011)
    (?$Af0(B . 23000)
    (?$Af1(B . 23033)
    (?$Af2(B . 23052)
    (?$Af3(B . 23049)
    (?$Af4(B . 23090)
    (?$Af5(B . 23092)
    (?$Af6(B . 23057)
    (?$Af7(B . 23075)
    (?$Af8(B . 23059)
    (?$Af9(B . 23104)
    (?$Af:(B . 23143)
    (?$Af;(B . 23114)
    (?$Af<(B . 23125)
    (?$Af=(B . 23100)
    (?$Af>(B . 23138)
    (?$Af?(B . 23157)
    (?$Af@(B . 33004)
    (?$AfA(B . 23210)
    (?$AfB(B . 23195)
    (?$AfC(B . 23159)
    (?$AfD(B . 23162)
    (?$AfE(B . 23230)
    (?$AfF(B . 23275)
    (?$AfG(B . 23218)
    (?$AfH(B . 23250)
    (?$AfI(B . 23252)
    (?$AfJ(B . 23224)
    (?$AfK(B . 23264)
    (?$AfL(B . 23267)
    (?$AfM(B . 23281)
    (?$AfN(B . 23254)
    (?$AfO(B . 23270)
    (?$AfP(B . 23256)
    (?$AfQ(B . 23260)
    (?$AfR(B . 23305)
    (?$AfS(B . 23319)
    (?$AfT(B . 23318)
    (?$AfU(B . 23346)
    (?$AfV(B . 23351)
    (?$AfW(B . 23360)
    (?$AfX(B . 23573)
    (?$AfY(B . 23580)
    (?$AfZ(B . 23386)
    (?$Af[(B . 23397)
    (?$Af\(B . 23411)
    (?$Af](B . 23377)
    (?$Af^(B . 23379)
    (?$Af_(B . 23394)
    (?$Af`(B . 39541)
    (?$Afa(B . 39543)
    (?$Afb(B . 39544)
    (?$Afc(B . 39546)
    (?$Afd(B . 39551)
    (?$Afe(B . 39549)
    (?$Aff(B . 39552)
    (?$Afg(B . 39553)
    (?$Afh(B . 39557)
    (?$Afi(B . 39560)
    (?$Afj(B . 39562)
    (?$Afk(B . 39568)
    (?$Afl(B . 39570)
    (?$Afm(B . 39571)
    (?$Afn(B . 39574)
    (?$Afo(B . 39576)
    (?$Afp(B . 39579)
    (?$Afq(B . 39580)
    (?$Afr(B . 39581)
    (?$Afs(B . 39583)
    (?$Aft(B . 39584)
    (?$Afu(B . 39586)
    (?$Afv(B . 39587)
    (?$Afw(B . 39589)
    (?$Afx(B . 39591)
    (?$Afy(B . 32415)
    (?$Afz(B . 32417)
    (?$Af{(B . 32419)
    (?$Af|(B . 32421)
    (?$Af}(B . 32424)
    (?$Af~(B . 32425)
    (?$Ag!(B . 32429)
    (?$Ag"(B . 32432)
    (?$Ag#(B . 32446)
    (?$Ag$(B . 32448)
    (?$Ag%(B . 32449)
    (?$Ag&(B . 32450)
    (?$Ag'(B . 32457)
    (?$Ag((B . 32459)
    (?$Ag)(B . 32460)
    (?$Ag*(B . 32464)
    (?$Ag+(B . 32468)
    (?$Ag,(B . 32471)
    (?$Ag-(B . 32475)
    (?$Ag.(B . 32480)
    (?$Ag/(B . 32481)
    (?$Ag0(B . 32488)
    (?$Ag1(B . 32491)
    (?$Ag2(B . 32494)
    (?$Ag3(B . 32495)
    (?$Ag4(B . 32497)
    (?$Ag5(B . 32498)
    (?$Ag6(B . 32525)
    (?$Ag7(B . 32502)
    (?$Ag8(B . 32506)
    (?$Ag9(B . 32507)
    (?$Ag:(B . 32510)
    (?$Ag;(B . 32513)
    (?$Ag<(B . 32514)
    (?$Ag=(B . 32515)
    (?$Ag>(B . 32519)
    (?$Ag?(B . 32520)
    (?$Ag@(B . 32523)
    (?$AgA(B . 32524)
    (?$AgB(B . 32527)
    (?$AgC(B . 32529)
    (?$AgD(B . 32530)
    (?$AgE(B . 32535)
    (?$AgF(B . 32537)
    (?$AgG(B . 32540)
    (?$AgH(B . 32539)
    (?$AgI(B . 32543)
    (?$AgJ(B . 32545)
    (?$AgK(B . 32546)
    (?$AgL(B . 32547)
    (?$AgM(B . 32548)
    (?$AgN(B . 32549)
    (?$AgO(B . 32550)
    (?$AgP(B . 32551)
    (?$AgQ(B . 32554)
    (?$AgR(B . 32555)
    (?$AgS(B . 32556)
    (?$AgT(B . 32557)
    (?$AgU(B . 32559)
    (?$AgV(B . 32560)
    (?$AgW(B . 32561)
    (?$AgX(B . 32562)
    (?$AgY(B . 32563)
    (?$AgZ(B . 32565)
    (?$Ag[(B . 24186)
    (?$Ag\(B . 30079)
    (?$Ag](B . 24027)
    (?$Ag^(B . 30014)
    (?$Ag_(B . 37013)
    (?$Ag`(B . 29582)
    (?$Aga(B . 29585)
    (?$Agb(B . 29614)
    (?$Agc(B . 29602)
    (?$Agd(B . 29599)
    (?$Age(B . 29647)
    (?$Agf(B . 29634)
    (?$Agg(B . 29649)
    (?$Agh(B . 29623)
    (?$Agi(B . 29619)
    (?$Agj(B . 29632)
    (?$Agk(B . 29641)
    (?$Agl(B . 29640)
    (?$Agm(B . 29669)
    (?$Agn(B . 29657)
    (?$Ago(B . 39036)
    (?$Agp(B . 29706)
    (?$Agq(B . 29673)
    (?$Agr(B . 29671)
    (?$Ags(B . 29662)
    (?$Agt(B . 29626)
    (?$Agu(B . 29682)
    (?$Agv(B . 29711)
    (?$Agw(B . 29738)
    (?$Agx(B . 29787)
    (?$Agy(B . 29734)
    (?$Agz(B . 29733)
    (?$Ag{(B . 29736)
    (?$Ag|(B . 29744)
    (?$Ag}(B . 29742)
    (?$Ag~(B . 29740)
    (?$Ah!(B . 29723)
    (?$Ah"(B . 29722)
    (?$Ah#(B . 29761)
    (?$Ah$(B . 29788)
    (?$Ah%(B . 29783)
    (?$Ah&(B . 29781)
    (?$Ah'(B . 29785)
    (?$Ah((B . 29815)
    (?$Ah)(B . 29805)
    (?$Ah*(B . 29822)
    (?$Ah+(B . 29852)
    (?$Ah,(B . 29838)
    (?$Ah-(B . 29824)
    (?$Ah.(B . 29825)
    (?$Ah/(B . 29831)
    (?$Ah0(B . 29835)
    (?$Ah1(B . 29854)
    (?$Ah2(B . 29864)
    (?$Ah3(B . 29865)
    (?$Ah4(B . 29840)
    (?$Ah5(B . 29863)
    (?$Ah6(B . 29906)
    (?$Ah7(B . 29882)
    (?$Ah8(B . 38890)
    (?$Ah9(B . 38891)
    (?$Ah:(B . 38892)
    (?$Ah;(B . 26444)
    (?$Ah<(B . 26451)
    (?$Ah=(B . 26462)
    (?$Ah>(B . 26440)
    (?$Ah?(B . 26473)
    (?$Ah@(B . 26533)
    (?$AhA(B . 26503)
    (?$AhB(B . 26474)
    (?$AhC(B . 26483)
    (?$AhD(B . 26520)
    (?$AhE(B . 26535)
    (?$AhF(B . 26485)
    (?$AhG(B . 26536)
    (?$AhH(B . 26526)
    (?$AhI(B . 26541)
    (?$AhJ(B . 26507)
    (?$AhK(B . 26487)
    (?$AhL(B . 26492)
    (?$AhM(B . 26608)
    (?$AhN(B . 26633)
    (?$AhO(B . 26584)
    (?$AhP(B . 26634)
    (?$AhQ(B . 26601)
    (?$AhR(B . 26544)
    (?$AhS(B . 26636)
    (?$AhT(B . 26585)
    (?$AhU(B . 26549)
    (?$AhV(B . 26586)
    (?$AhW(B . 26547)
    (?$AhX(B . 26589)
    (?$AhY(B . 26624)
    (?$AhZ(B . 26563)
    (?$Ah[(B . 26552)
    (?$Ah\(B . 26594)
    (?$Ah](B . 26638)
    (?$Ah^(B . 26561)
    (?$Ah_(B . 26621)
    (?$Ah`(B . 26674)
    (?$Aha(B . 26675)
    (?$Ahb(B . 26720)
    (?$Ahc(B . 26721)
    (?$Ahd(B . 26702)
    (?$Ahe(B . 26722)
    (?$Ahf(B . 26692)
    (?$Ahg(B . 26724)
    (?$Ahh(B . 26755)
    (?$Ahi(B . 26653)
    (?$Ahj(B . 26709)
    (?$Ahk(B . 26726)
    (?$Ahl(B . 26689)
    (?$Ahm(B . 26727)
    (?$Ahn(B . 26688)
    (?$Aho(B . 26686)
    (?$Ahp(B . 26698)
    (?$Ahq(B . 26697)
    (?$Ahr(B . 26665)
    (?$Ahs(B . 26805)
    (?$Aht(B . 26767)
    (?$Ahu(B . 26740)
    (?$Ahv(B . 26743)
    (?$Ahw(B . 26771)
    (?$Ahx(B . 26731)
    (?$Ahy(B . 26818)
    (?$Ahz(B . 26990)
    (?$Ah{(B . 26876)
    (?$Ah|(B . 26911)
    (?$Ah}(B . 26912)
    (?$Ah~(B . 26873)
    (?$Ai!(B . 26916)
    (?$Ai"(B . 26864)
    (?$Ai#(B . 26891)
    (?$Ai$(B . 26881)
    (?$Ai%(B . 26967)
    (?$Ai&(B . 26851)
    (?$Ai'(B . 26896)
    (?$Ai((B . 26993)
    (?$Ai)(B . 26937)
    (?$Ai*(B . 26976)
    (?$Ai+(B . 26946)
    (?$Ai,(B . 26973)
    (?$Ai-(B . 27012)
    (?$Ai.(B . 26987)
    (?$Ai/(B . 27008)
    (?$Ai0(B . 27032)
    (?$Ai1(B . 27000)
    (?$Ai2(B . 26932)
    (?$Ai3(B . 27084)
    (?$Ai4(B . 27015)
    (?$Ai5(B . 27016)
    (?$Ai6(B . 27086)
    (?$Ai7(B . 27017)
    (?$Ai8(B . 26982)
    (?$Ai9(B . 26979)
    (?$Ai:(B . 27001)
    (?$Ai;(B . 27035)
    (?$Ai<(B . 27047)
    (?$Ai=(B . 27067)
    (?$Ai>(B . 27051)
    (?$Ai?(B . 27053)
    (?$Ai@(B . 27092)
    (?$AiA(B . 27057)
    (?$AiB(B . 27073)
    (?$AiC(B . 27082)
    (?$AiD(B . 27103)
    (?$AiE(B . 27029)
    (?$AiF(B . 27104)
    (?$AiG(B . 27021)
    (?$AiH(B . 27135)
    (?$AiI(B . 27183)
    (?$AiJ(B . 27117)
    (?$AiK(B . 27159)
    (?$AiL(B . 27160)
    (?$AiM(B . 27237)
    (?$AiN(B . 27122)
    (?$AiO(B . 27204)
    (?$AiP(B . 27198)
    (?$AiQ(B . 27296)
    (?$AiR(B . 27216)
    (?$AiS(B . 27227)
    (?$AiT(B . 27189)
    (?$AiU(B . 27278)
    (?$AiV(B . 27257)
    (?$AiW(B . 27197)
    (?$AiX(B . 27176)
    (?$AiY(B . 27224)
    (?$AiZ(B . 27260)
    (?$Ai[(B . 27281)
    (?$Ai\(B . 27280)
    (?$Ai](B . 27305)
    (?$Ai^(B . 27287)
    (?$Ai_(B . 27307)
    (?$Ai`(B . 29495)
    (?$Aia(B . 29522)
    (?$Aib(B . 27521)
    (?$Aic(B . 27522)
    (?$Aid(B . 27527)
    (?$Aie(B . 27524)
    (?$Aif(B . 27538)
    (?$Aig(B . 27539)
    (?$Aih(B . 27533)
    (?$Aii(B . 27546)
    (?$Aij(B . 27547)
    (?$Aik(B . 27553)
    (?$Ail(B . 27562)
    (?$Aim(B . 36715)
    (?$Ain(B . 36717)
    (?$Aio(B . 36721)
    (?$Aip(B . 36722)
    (?$Aiq(B . 36723)
    (?$Air(B . 36725)
    (?$Ais(B . 36726)
    (?$Ait(B . 36728)
    (?$Aiu(B . 36727)
    (?$Aiv(B . 36729)
    (?$Aiw(B . 36730)
    (?$Aix(B . 36732)
    (?$Aiy(B . 36734)
    (?$Aiz(B . 36737)
    (?$Ai{(B . 36738)
    (?$Ai|(B . 36740)
    (?$Ai}(B . 36743)
    (?$Ai~(B . 36747)
    (?$Aj!(B . 36749)
    (?$Aj"(B . 36750)
    (?$Aj#(B . 36751)
    (?$Aj$(B . 36760)
    (?$Aj%(B . 36762)
    (?$Aj&(B . 36558)
    (?$Aj'(B . 25099)
    (?$Aj((B . 25111)
    (?$Aj)(B . 25115)
    (?$Aj*(B . 25119)
    (?$Aj+(B . 25122)
    (?$Aj,(B . 25121)
    (?$Aj-(B . 25125)
    (?$Aj.(B . 25124)
    (?$Aj/(B . 25132)
    (?$Aj0(B . 33255)
    (?$Aj1(B . 29935)
    (?$Aj2(B . 29940)
    (?$Aj3(B . 29951)
    (?$Aj4(B . 29967)
    (?$Aj5(B . 29969)
    (?$Aj6(B . 29971)
    (?$Aj7(B . 25908)
    (?$Aj8(B . 26094)
    (?$Aj9(B . 26095)
    (?$Aj:(B . 26096)
    (?$Aj;(B . 26122)
    (?$Aj<(B . 26137)
    (?$Aj=(B . 26482)
    (?$Aj>(B . 26115)
    (?$Aj?(B . 26133)
    (?$Aj@(B . 26112)
    (?$AjA(B . 28805)
    (?$AjB(B . 26359)
    (?$AjC(B . 26141)
    (?$AjD(B . 26164)
    (?$AjE(B . 26161)
    (?$AjF(B . 26166)
    (?$AjG(B . 26165)
    (?$AjH(B . 32774)
    (?$AjI(B . 26207)
    (?$AjJ(B . 26196)
    (?$AjK(B . 26177)
    (?$AjL(B . 26191)
    (?$AjM(B . 26198)
    (?$AjN(B . 26209)
    (?$AjO(B . 26199)
    (?$AjP(B . 26231)
    (?$AjQ(B . 26244)
    (?$AjR(B . 26252)
    (?$AjS(B . 26279)
    (?$AjT(B . 26269)
    (?$AjU(B . 26302)
    (?$AjV(B . 26331)
    (?$AjW(B . 26332)
    (?$AjX(B . 26342)
    (?$AjY(B . 26345)
    (?$AjZ(B . 36146)
    (?$Aj[(B . 36147)
    (?$Aj\(B . 36150)
    (?$Aj](B . 36155)
    (?$Aj^(B . 36157)
    (?$Aj_(B . 36160)
    (?$Aj`(B . 36165)
    (?$Aja(B . 36166)
    (?$Ajb(B . 36168)
    (?$Ajc(B . 36169)
    (?$Ajd(B . 36167)
    (?$Aje(B . 36173)
    (?$Ajf(B . 36181)
    (?$Ajg(B . 36185)
    (?$Ajh(B . 35271)
    (?$Aji(B . 35274)
    (?$Ajj(B . 35275)
    (?$Ajk(B . 35276)
    (?$Ajl(B . 35278)
    (?$Ajm(B . 35279)
    (?$Ajn(B . 35280)
    (?$Ajo(B . 35281)
    (?$Ajp(B . 29294)
    (?$Ajq(B . 29343)
    (?$Ajr(B . 29277)
    (?$Ajs(B . 29286)
    (?$Ajt(B . 29295)
    (?$Aju(B . 29310)
    (?$Ajv(B . 29311)
    (?$Ajw(B . 29316)
    (?$Ajx(B . 29323)
    (?$Ajy(B . 29325)
    (?$Ajz(B . 29327)
    (?$Aj{(B . 29330)
    (?$Aj|(B . 25352)
    (?$Aj}(B . 25394)
    (?$Aj~(B . 25520)
    (?$Ak!(B . 25663)
    (?$Ak"(B . 25816)
    (?$Ak#(B . 32772)
    (?$Ak$(B . 27626)
    (?$Ak%(B . 27635)
    (?$Ak&(B . 27645)
    (?$Ak'(B . 27637)
    (?$Ak((B . 27641)
    (?$Ak)(B . 27653)
    (?$Ak*(B . 27655)
    (?$Ak+(B . 27654)
    (?$Ak,(B . 27661)
    (?$Ak-(B . 27669)
    (?$Ak.(B . 27672)
    (?$Ak/(B . 27673)
    (?$Ak0(B . 27674)
    (?$Ak1(B . 27681)
    (?$Ak2(B . 27689)
    (?$Ak3(B . 27684)
    (?$Ak4(B . 27690)
    (?$Ak5(B . 27698)
    (?$Ak6(B . 25909)
    (?$Ak7(B . 25941)
    (?$Ak8(B . 25963)
    (?$Ak9(B . 29261)
    (?$Ak:(B . 29266)
    (?$Ak;(B . 29270)
    (?$Ak<(B . 29232)
    (?$Ak=(B . 34402)
    (?$Ak>(B . 21014)
    (?$Ak?(B . 32927)
    (?$Ak@(B . 32924)
    (?$AkA(B . 32915)
    (?$AkB(B . 32956)
    (?$AkC(B . 26378)
    (?$AkD(B . 32957)
    (?$AkE(B . 32945)
    (?$AkF(B . 32939)
    (?$AkG(B . 32941)
    (?$AkH(B . 32948)
    (?$AkI(B . 32951)
    (?$AkJ(B . 32999)
    (?$AkK(B . 33000)
    (?$AkL(B . 33001)
    (?$AkM(B . 33002)
    (?$AkN(B . 32987)
    (?$AkO(B . 32962)
    (?$AkP(B . 32964)
    (?$AkQ(B . 32985)
    (?$AkR(B . 32973)
    (?$AkS(B . 32983)
    (?$AkT(B . 26384)
    (?$AkU(B . 32989)
    (?$AkV(B . 33003)
    (?$AkW(B . 33009)
    (?$AkX(B . 33012)
    (?$AkY(B . 33005)
    (?$AkZ(B . 33037)
    (?$Ak[(B . 33038)
    (?$Ak\(B . 33010)
    (?$Ak](B . 33020)
    (?$Ak^(B . 26389)
    (?$Ak_(B . 33042)
    (?$Ak`(B . 35930)
    (?$Aka(B . 33078)
    (?$Akb(B . 33054)
    (?$Akc(B . 33068)
    (?$Akd(B . 33048)
    (?$Ake(B . 33074)
    (?$Akf(B . 33096)
    (?$Akg(B . 33100)
    (?$Akh(B . 33107)
    (?$Aki(B . 33140)
    (?$Akj(B . 33113)
    (?$Akk(B . 33114)
    (?$Akl(B . 33137)
    (?$Akm(B . 33120)
    (?$Akn(B . 33129)
    (?$Ako(B . 33148)
    (?$Akp(B . 33149)
    (?$Akq(B . 33133)
    (?$Akr(B . 33127)
    (?$Aks(B . 22605)
    (?$Akt(B . 23221)
    (?$Aku(B . 33160)
    (?$Akv(B . 33154)
    (?$Akw(B . 33169)
    (?$Akx(B . 28373)
    (?$Aky(B . 33187)
    (?$Akz(B . 33194)
    (?$Ak{(B . 33228)
    (?$Ak|(B . 26406)
    (?$Ak}(B . 33226)
    (?$Ak~(B . 33211)
    (?$Al!(B . 33217)
    (?$Al"(B . 33190)
    (?$Al#(B . 27428)
    (?$Al$(B . 27447)
    (?$Al%(B . 27449)
    (?$Al&(B . 27459)
    (?$Al'(B . 27462)
    (?$Al((B . 27481)
    (?$Al)(B . 39121)
    (?$Al*(B . 39122)
    (?$Al+(B . 39123)
    (?$Al,(B . 39125)
    (?$Al-(B . 39129)
    (?$Al.(B . 39130)
    (?$Al/(B . 27571)
    (?$Al0(B . 24384)
    (?$Al1(B . 27586)
    (?$Al2(B . 35315)
    (?$Al3(B . 26000)
    (?$Al4(B . 40785)
    (?$Al5(B . 26003)
    (?$Al6(B . 26044)
    (?$Al7(B . 26054)
    (?$Al8(B . 26052)
    (?$Al9(B . 26051)
    (?$Al:(B . 26060)
    (?$Al;(B . 26062)
    (?$Al<(B . 26066)
    (?$Al=(B . 26070)
    (?$Al>(B . 28800)
    (?$Al?(B . 28828)
    (?$Al@(B . 28822)
    (?$AlA(B . 28829)
    (?$AlB(B . 28859)
    (?$AlC(B . 28864)
    (?$AlD(B . 28855)
    (?$AlE(B . 28843)
    (?$AlF(B . 28849)
    (?$AlG(B . 28904)
    (?$AlH(B . 28874)
    (?$AlI(B . 28944)
    (?$AlJ(B . 28947)
    (?$AlK(B . 28950)
    (?$AlL(B . 28975)
    (?$AlM(B . 28977)
    (?$AlN(B . 29043)
    (?$AlO(B . 29020)
    (?$AlP(B . 29032)
    (?$AlQ(B . 28997)
    (?$AlR(B . 29042)
    (?$AlS(B . 29002)
    (?$AlT(B . 29048)
    (?$AlU(B . 29050)
    (?$AlV(B . 29080)
    (?$AlW(B . 29107)
    (?$AlX(B . 29109)
    (?$AlY(B . 29096)
    (?$AlZ(B . 29088)
    (?$Al[(B . 29152)
    (?$Al\(B . 29140)
    (?$Al](B . 29159)
    (?$Al^(B . 29177)
    (?$Al_(B . 29213)
    (?$Al`(B . 29224)
    (?$Ala(B . 28780)
    (?$Alb(B . 28952)
    (?$Alc(B . 29030)
    (?$Ald(B . 29113)
    (?$Ale(B . 25150)
    (?$Alf(B . 25149)
    (?$Alg(B . 25155)
    (?$Alh(B . 25160)
    (?$Ali(B . 25161)
    (?$Alj(B . 31035)
    (?$Alk(B . 31040)
    (?$All(B . 31046)
    (?$Alm(B . 31049)
    (?$Aln(B . 31067)
    (?$Alo(B . 31068)
    (?$Alp(B . 31059)
    (?$Alq(B . 31066)
    (?$Alr(B . 31074)
    (?$Als(B . 31063)
    (?$Alt(B . 31072)
    (?$Alu(B . 31087)
    (?$Alv(B . 31079)
    (?$Alw(B . 31098)
    (?$Alx(B . 31109)
    (?$Aly(B . 31114)
    (?$Alz(B . 31130)
    (?$Al{(B . 31143)
    (?$Al|(B . 31155)
    (?$Al}(B . 24529)
    (?$Al~(B . 24528)
    (?$Am!(B . 24636)
    (?$Am"(B . 24669)
    (?$Am#(B . 24666)
    (?$Am$(B . 24679)
    (?$Am%(B . 24641)
    (?$Am&(B . 24665)
    (?$Am'(B . 24675)
    (?$Am((B . 24747)
    (?$Am)(B . 24838)
    (?$Am*(B . 24845)
    (?$Am+(B . 24925)
    (?$Am,(B . 25001)
    (?$Am-(B . 24989)
    (?$Am.(B . 25035)
    (?$Am/(B . 25041)
    (?$Am0(B . 25094)
    (?$Am1(B . 32896)
    (?$Am2(B . 32895)
    (?$Am3(B . 27795)
    (?$Am4(B . 27894)
    (?$Am5(B . 28156)
    (?$Am6(B . 30710)
    (?$Am7(B . 30712)
    (?$Am8(B . 30720)
    (?$Am9(B . 30729)
    (?$Am:(B . 30743)
    (?$Am;(B . 30744)
    (?$Am<(B . 30737)
    (?$Am=(B . 26027)
    (?$Am>(B . 30765)
    (?$Am?(B . 30748)
    (?$Am@(B . 30749)
    (?$AmA(B . 30777)
    (?$AmB(B . 30778)
    (?$AmC(B . 30779)
    (?$AmD(B . 30751)
    (?$AmE(B . 30780)
    (?$AmF(B . 30757)
    (?$AmG(B . 30764)
    (?$AmH(B . 30755)
    (?$AmI(B . 30761)
    (?$AmJ(B . 30798)
    (?$AmK(B . 30829)
    (?$AmL(B . 30806)
    (?$AmM(B . 30807)
    (?$AmN(B . 30758)
    (?$AmO(B . 30800)
    (?$AmP(B . 30791)
    (?$AmQ(B . 30796)
    (?$AmR(B . 30826)
    (?$AmS(B . 30875)
    (?$AmT(B . 30867)
    (?$AmU(B . 30874)
    (?$AmV(B . 30855)
    (?$AmW(B . 30876)
    (?$AmX(B . 30881)
    (?$AmY(B . 30883)
    (?$AmZ(B . 30898)
    (?$Am[(B . 30905)
    (?$Am\(B . 30885)
    (?$Am](B . 30932)
    (?$Am^(B . 30937)
    (?$Am_(B . 30921)
    (?$Am`(B . 30956)
    (?$Ama(B . 30962)
    (?$Amb(B . 30981)
    (?$Amc(B . 30964)
    (?$Amd(B . 30995)
    (?$Ame(B . 31012)
    (?$Amf(B . 31006)
    (?$Amg(B . 31028)
    (?$Amh(B . 40859)
    (?$Ami(B . 40697)
    (?$Amj(B . 40699)
    (?$Amk(B . 40700)
    (?$Aml(B . 30449)
    (?$Amm(B . 30468)
    (?$Amn(B . 30477)
    (?$Amo(B . 30457)
    (?$Amp(B . 30471)
    (?$Amq(B . 30472)
    (?$Amr(B . 30490)
    (?$Ams(B . 30498)
    (?$Amt(B . 30489)
    (?$Amu(B . 30509)
    (?$Amv(B . 30502)
    (?$Amw(B . 30517)
    (?$Amx(B . 30520)
    (?$Amy(B . 30544)
    (?$Amz(B . 30545)
    (?$Am{(B . 30535)
    (?$Am|(B . 30531)
    (?$Am}(B . 30554)
    (?$Am~(B . 30568)
    (?$An!(B . 30562)
    (?$An"(B . 30565)
    (?$An#(B . 30591)
    (?$An$(B . 30605)
    (?$An%(B . 30589)
    (?$An&(B . 30592)
    (?$An'(B . 30604)
    (?$An((B . 30609)
    (?$An)(B . 30623)
    (?$An*(B . 30624)
    (?$An+(B . 30640)
    (?$An,(B . 30645)
    (?$An-(B . 30653)
    (?$An.(B . 30010)
    (?$An/(B . 30016)
    (?$An0(B . 30030)
    (?$An1(B . 30027)
    (?$An2(B . 30024)
    (?$An3(B . 30043)
    (?$An4(B . 30066)
    (?$An5(B . 30073)
    (?$An6(B . 30083)
    (?$An7(B . 32600)
    (?$An8(B . 32609)
    (?$An9(B . 32607)
    (?$An:(B . 35400)
    (?$An;(B . 32616)
    (?$An<(B . 32628)
    (?$An=(B . 32625)
    (?$An>(B . 32633)
    (?$An?(B . 32641)
    (?$An@(B . 32638)
    (?$AnA(B . 30413)
    (?$AnB(B . 30437)
    (?$AnC(B . 34866)
    (?$AnD(B . 38021)
    (?$AnE(B . 38022)
    (?$AnF(B . 38023)
    (?$AnG(B . 38027)
    (?$AnH(B . 38026)
    (?$AnI(B . 38028)
    (?$AnJ(B . 38029)
    (?$AnK(B . 38031)
    (?$AnL(B . 38032)
    (?$AnM(B . 38036)
    (?$AnN(B . 38039)
    (?$AnO(B . 38037)
    (?$AnP(B . 38042)
    (?$AnQ(B . 38043)
    (?$AnR(B . 38044)
    (?$AnS(B . 38051)
    (?$AnT(B . 38052)
    (?$AnU(B . 38059)
    (?$AnV(B . 38058)
    (?$AnW(B . 38061)
    (?$AnX(B . 38060)
    (?$AnY(B . 38063)
    (?$AnZ(B . 38064)
    (?$An[(B . 38066)
    (?$An\(B . 38068)
    (?$An](B . 38070)
    (?$An^(B . 38071)
    (?$An_(B . 38072)
    (?$An`(B . 38073)
    (?$Ana(B . 38074)
    (?$Anb(B . 38076)
    (?$Anc(B . 38077)
    (?$And(B . 38079)
    (?$Ane(B . 38084)
    (?$Anf(B . 38088)
    (?$Ang(B . 38089)
    (?$Anh(B . 38090)
    (?$Ani(B . 38091)
    (?$Anj(B . 38092)
    (?$Ank(B . 38093)
    (?$Anl(B . 38094)
    (?$Anm(B . 38096)
    (?$Ann(B . 38097)
    (?$Ano(B . 38098)
    (?$Anp(B . 38101)
    (?$Anq(B . 38102)
    (?$Anr(B . 38103)
    (?$Ans(B . 38105)
    (?$Ant(B . 38104)
    (?$Anu(B . 38107)
    (?$Anv(B . 38110)
    (?$Anw(B . 38111)
    (?$Anx(B . 38112)
    (?$Any(B . 38114)
    (?$Anz(B . 38116)
    (?$An{(B . 38117)
    (?$An|(B . 38119)
    (?$An}(B . 38120)
    (?$An~(B . 38122)
    (?$Ao!(B . 38121)
    (?$Ao"(B . 38123)
    (?$Ao#(B . 38126)
    (?$Ao$(B . 38127)
    (?$Ao%(B . 38131)
    (?$Ao&(B . 38132)
    (?$Ao'(B . 38133)
    (?$Ao((B . 38135)
    (?$Ao)(B . 38137)
    (?$Ao*(B . 38140)
    (?$Ao+(B . 38141)
    (?$Ao,(B . 38143)
    (?$Ao-(B . 38147)
    (?$Ao.(B . 38146)
    (?$Ao/(B . 38150)
    (?$Ao0(B . 38151)
    (?$Ao1(B . 38153)
    (?$Ao2(B . 38154)
    (?$Ao3(B . 38157)
    (?$Ao4(B . 38158)
    (?$Ao5(B . 38159)
    (?$Ao6(B . 38162)
    (?$Ao7(B . 38163)
    (?$Ao8(B . 38164)
    (?$Ao9(B . 38165)
    (?$Ao:(B . 38166)
    (?$Ao;(B . 38168)
    (?$Ao<(B . 38171)
    (?$Ao=(B . 38173)
    (?$Ao>(B . 38174)
    (?$Ao?(B . 38175)
    (?$Ao@(B . 38178)
    (?$AoA(B . 38186)
    (?$AoB(B . 38187)
    (?$AoC(B . 38185)
    (?$AoD(B . 38188)
    (?$AoE(B . 38193)
    (?$AoF(B . 38194)
    (?$AoG(B . 38196)
    (?$AoH(B . 38198)
    (?$AoI(B . 38199)
    (?$AoJ(B . 38200)
    (?$AoK(B . 38204)
    (?$AoL(B . 38206)
    (?$AoM(B . 38207)
    (?$AoN(B . 38210)
    (?$AoO(B . 38197)
    (?$AoP(B . 38212)
    (?$AoQ(B . 38213)
    (?$AoR(B . 38214)
    (?$AoS(B . 38217)
    (?$AoT(B . 38220)
    (?$AoU(B . 38222)
    (?$AoV(B . 38223)
    (?$AoW(B . 38226)
    (?$AoX(B . 38227)
    (?$AoY(B . 38228)
    (?$AoZ(B . 38230)
    (?$Ao[(B . 38231)
    (?$Ao\(B . 38232)
    (?$Ao](B . 38233)
    (?$Ao^(B . 38235)
    (?$Ao_(B . 38238)
    (?$Ao`(B . 38239)
    (?$Aoa(B . 38237)
    (?$Aob(B . 38241)
    (?$Aoc(B . 38242)
    (?$Aod(B . 38244)
    (?$Aoe(B . 38245)
    (?$Aof(B . 38246)
    (?$Aog(B . 38247)
    (?$Aoh(B . 38248)
    (?$Aoi(B . 38249)
    (?$Aoj(B . 38250)
    (?$Aok(B . 38251)
    (?$Aol(B . 38252)
    (?$Aom(B . 38255)
    (?$Aon(B . 38257)
    (?$Aoo(B . 38258)
    (?$Aop(B . 38259)
    (?$Aoq(B . 38202)
    (?$Aor(B . 30695)
    (?$Aos(B . 30700)
    (?$Aot(B . 38601)
    (?$Aou(B . 31189)
    (?$Aov(B . 31213)
    (?$Aow(B . 31203)
    (?$Aox(B . 31211)
    (?$Aoy(B . 31238)
    (?$Aoz(B . 23879)
    (?$Ao{(B . 31235)
    (?$Ao|(B . 31234)
    (?$Ao}(B . 31262)
    (?$Ao~(B . 31252)
    (?$Ap!(B . 31289)
    (?$Ap"(B . 31287)
    (?$Ap#(B . 31313)
    (?$Ap$(B . 40655)
    (?$Ap%(B . 39333)
    (?$Ap&(B . 31344)
    (?$Ap'(B . 30344)
    (?$Ap((B . 30350)
    (?$Ap)(B . 30355)
    (?$Ap*(B . 30361)
    (?$Ap+(B . 30372)
    (?$Ap,(B . 29918)
    (?$Ap-(B . 29920)
    (?$Ap.(B . 29996)
    (?$Ap/(B . 40480)
    (?$Ap0(B . 40482)
    (?$Ap1(B . 40488)
    (?$Ap2(B . 40489)
    (?$Ap3(B . 40490)
    (?$Ap4(B . 40491)
    (?$Ap5(B . 40492)
    (?$Ap6(B . 40498)
    (?$Ap7(B . 40497)
    (?$Ap8(B . 40502)
    (?$Ap9(B . 40504)
    (?$Ap:(B . 40503)
    (?$Ap;(B . 40505)
    (?$Ap<(B . 40506)
    (?$Ap=(B . 40510)
    (?$Ap>(B . 40513)
    (?$Ap?(B . 40514)
    (?$Ap@(B . 40516)
    (?$ApA(B . 40518)
    (?$ApB(B . 40519)
    (?$ApC(B . 40520)
    (?$ApD(B . 40521)
    (?$ApE(B . 40523)
    (?$ApF(B . 40524)
    (?$ApG(B . 40526)
    (?$ApH(B . 40529)
    (?$ApI(B . 40533)
    (?$ApJ(B . 40535)
    (?$ApK(B . 40538)
    (?$ApL(B . 40539)
    (?$ApM(B . 40540)
    (?$ApN(B . 40542)
    (?$ApO(B . 40547)
    (?$ApP(B . 40550)
    (?$ApQ(B . 40551)
    (?$ApR(B . 40552)
    (?$ApS(B . 40553)
    (?$ApT(B . 40554)
    (?$ApU(B . 40555)
    (?$ApV(B . 40556)
    (?$ApW(B . 40561)
    (?$ApX(B . 40557)
    (?$ApY(B . 40563)
    (?$ApZ(B . 30098)
    (?$Ap[(B . 30100)
    (?$Ap\(B . 30102)
    (?$Ap](B . 30112)
    (?$Ap^(B . 30109)
    (?$Ap_(B . 30124)
    (?$Ap`(B . 30115)
    (?$Apa(B . 30131)
    (?$Apb(B . 30132)
    (?$Apc(B . 30136)
    (?$Apd(B . 30148)
    (?$Ape(B . 30129)
    (?$Apf(B . 30128)
    (?$Apg(B . 30147)
    (?$Aph(B . 30146)
    (?$Api(B . 30166)
    (?$Apj(B . 30157)
    (?$Apk(B . 30179)
    (?$Apl(B . 30184)
    (?$Apm(B . 30182)
    (?$Apn(B . 30180)
    (?$Apo(B . 30187)
    (?$App(B . 30183)
    (?$Apq(B . 30211)
    (?$Apr(B . 30193)
    (?$Aps(B . 30204)
    (?$Apt(B . 30207)
    (?$Apu(B . 30224)
    (?$Apv(B . 30208)
    (?$Apw(B . 30213)
    (?$Apx(B . 30220)
    (?$Apy(B . 30231)
    (?$Apz(B . 30218)
    (?$Ap{(B . 30245)
    (?$Ap|(B . 30232)
    (?$Ap}(B . 30229)
    (?$Ap~(B . 30233)
    (?$Aq!(B . 30235)
    (?$Aq"(B . 30268)
    (?$Aq#(B . 30242)
    (?$Aq$(B . 30240)
    (?$Aq%(B . 30272)
    (?$Aq&(B . 30253)
    (?$Aq'(B . 30256)
    (?$Aq((B . 30271)
    (?$Aq)(B . 30261)
    (?$Aq*(B . 30275)
    (?$Aq+(B . 30270)
    (?$Aq,(B . 30259)
    (?$Aq-(B . 30285)
    (?$Aq.(B . 30302)
    (?$Aq/(B . 30292)
    (?$Aq0(B . 30300)
    (?$Aq1(B . 30294)
    (?$Aq2(B . 30315)
    (?$Aq3(B . 30319)
    (?$Aq4(B . 32714)
    (?$Aq5(B . 31462)
    (?$Aq6(B . 31352)
    (?$Aq7(B . 31353)
    (?$Aq8(B . 31360)
    (?$Aq9(B . 31366)
    (?$Aq:(B . 31368)
    (?$Aq;(B . 31381)
    (?$Aq<(B . 31398)
    (?$Aq=(B . 31392)
    (?$Aq>(B . 31404)
    (?$Aq?(B . 31400)
    (?$Aq@(B . 31405)
    (?$AqA(B . 31411)
    (?$AqB(B . 34916)
    (?$AqC(B . 34921)
    (?$AqD(B . 34930)
    (?$AqE(B . 34941)
    (?$AqF(B . 34943)
    (?$AqG(B . 34946)
    (?$AqH(B . 34978)
    (?$AqI(B . 35014)
    (?$AqJ(B . 34999)
    (?$AqK(B . 35004)
    (?$AqL(B . 35017)
    (?$AqM(B . 35042)
    (?$AqN(B . 35022)
    (?$AqO(B . 35043)
    (?$AqP(B . 35045)
    (?$AqQ(B . 35057)
    (?$AqR(B . 35098)
    (?$AqS(B . 35068)
    (?$AqT(B . 35048)
    (?$AqU(B . 35070)
    (?$AqV(B . 35056)
    (?$AqW(B . 35105)
    (?$AqX(B . 35097)
    (?$AqY(B . 35091)
    (?$AqZ(B . 35099)
    (?$Aq[(B . 35082)
    (?$Aq\(B . 35124)
    (?$Aq](B . 35115)
    (?$Aq^(B . 35126)
    (?$Aq_(B . 35137)
    (?$Aq`(B . 35174)
    (?$Aqa(B . 35195)
    (?$Aqb(B . 30091)
    (?$Aqc(B . 32997)
    (?$Aqd(B . 30386)
    (?$Aqe(B . 30388)
    (?$Aqf(B . 30684)
    (?$Aqg(B . 32786)
    (?$Aqh(B . 32788)
    (?$Aqi(B . 32790)
    (?$Aqj(B . 32796)
    (?$Aqk(B . 32800)
    (?$Aql(B . 32802)
    (?$Aqm(B . 32805)
    (?$Aqn(B . 32806)
    (?$Aqo(B . 32807)
    (?$Aqp(B . 32809)
    (?$Aqq(B . 32808)
    (?$Aqr(B . 32817)
    (?$Aqs(B . 32779)
    (?$Aqt(B . 32821)
    (?$Aqu(B . 32835)
    (?$Aqv(B . 32838)
    (?$Aqw(B . 32845)
    (?$Aqx(B . 32850)
    (?$Aqy(B . 32873)
    (?$Aqz(B . 32881)
    (?$Aq{(B . 35203)
    (?$Aq|(B . 39032)
    (?$Aq}(B . 39040)
    (?$Aq~(B . 39043)
    (?$Ar!(B . 39049)
    (?$Ar"(B . 39052)
    (?$Ar#(B . 39053)
    (?$Ar$(B . 39055)
    (?$Ar%(B . 39060)
    (?$Ar&(B . 39066)
    (?$Ar'(B . 39067)
    (?$Ar((B . 39070)
    (?$Ar)(B . 39071)
    (?$Ar*(B . 39073)
    (?$Ar+(B . 39074)
    (?$Ar,(B . 39077)
    (?$Ar-(B . 39078)
    (?$Ar.(B . 34381)
    (?$Ar/(B . 34388)
    (?$Ar0(B . 34412)
    (?$Ar1(B . 34414)
    (?$Ar2(B . 34431)
    (?$Ar3(B . 34426)
    (?$Ar4(B . 34428)
    (?$Ar5(B . 34427)
    (?$Ar6(B . 34472)
    (?$Ar7(B . 34445)
    (?$Ar8(B . 34443)
    (?$Ar9(B . 34476)
    (?$Ar:(B . 34461)
    (?$Ar;(B . 34471)
    (?$Ar<(B . 34467)
    (?$Ar=(B . 34474)
    (?$Ar>(B . 34451)
    (?$Ar?(B . 34473)
    (?$Ar@(B . 34486)
    (?$ArA(B . 34500)
    (?$ArB(B . 34485)
    (?$ArC(B . 34510)
    (?$ArD(B . 34480)
    (?$ArE(B . 34490)
    (?$ArF(B . 34481)
    (?$ArG(B . 34479)
    (?$ArH(B . 34505)
    (?$ArI(B . 34511)
    (?$ArJ(B . 34484)
    (?$ArK(B . 34537)
    (?$ArL(B . 34545)
    (?$ArM(B . 34546)
    (?$ArN(B . 34541)
    (?$ArO(B . 34547)
    (?$ArP(B . 34512)
    (?$ArQ(B . 34579)
    (?$ArR(B . 34526)
    (?$ArS(B . 34548)
    (?$ArT(B . 34527)
    (?$ArU(B . 34520)
    (?$ArV(B . 34513)
    (?$ArW(B . 34563)
    (?$ArX(B . 34567)
    (?$ArY(B . 34552)
    (?$ArZ(B . 34568)
    (?$Ar[(B . 34570)
    (?$Ar\(B . 34573)
    (?$Ar](B . 34569)
    (?$Ar^(B . 34595)
    (?$Ar_(B . 34619)
    (?$Ar`(B . 34590)
    (?$Ara(B . 34597)
    (?$Arb(B . 34606)
    (?$Arc(B . 34586)
    (?$Ard(B . 34622)
    (?$Are(B . 34632)
    (?$Arf(B . 34612)
    (?$Arg(B . 34609)
    (?$Arh(B . 34601)
    (?$Ari(B . 34615)
    (?$Arj(B . 34623)
    (?$Ark(B . 34690)
    (?$Arl(B . 34594)
    (?$Arm(B . 34685)
    (?$Arn(B . 34686)
    (?$Aro(B . 34683)
    (?$Arp(B . 34656)
    (?$Arq(B . 34672)
    (?$Arr(B . 34636)
    (?$Ars(B . 34670)
    (?$Art(B . 34699)
    (?$Aru(B . 34643)
    (?$Arv(B . 34659)
    (?$Arw(B . 34684)
    (?$Arx(B . 34660)
    (?$Ary(B . 34649)
    (?$Arz(B . 34661)
    (?$Ar{(B . 34707)
    (?$Ar|(B . 34735)
    (?$Ar}(B . 34728)
    (?$Ar~(B . 34770)
    (?$As!(B . 34758)
    (?$As"(B . 34696)
    (?$As#(B . 34693)
    (?$As$(B . 34733)
    (?$As%(B . 34711)
    (?$As&(B . 34691)
    (?$As'(B . 34731)
    (?$As((B . 34789)
    (?$As)(B . 34732)
    (?$As*(B . 34741)
    (?$As+(B . 34739)
    (?$As,(B . 34763)
    (?$As-(B . 34771)
    (?$As.(B . 34749)
    (?$As/(B . 34769)
    (?$As0(B . 34752)
    (?$As1(B . 34762)
    (?$As2(B . 34779)
    (?$As3(B . 34794)
    (?$As4(B . 34784)
    (?$As5(B . 34798)
    (?$As6(B . 34838)
    (?$As7(B . 34835)
    (?$As8(B . 34814)
    (?$As9(B . 34826)
    (?$As:(B . 34843)
    (?$As;(B . 34849)
    (?$As<(B . 34873)
    (?$As=(B . 34876)
    (?$As>(B . 32566)
    (?$As?(B . 32578)
    (?$As@(B . 32580)
    (?$AsA(B . 32581)
    (?$AsB(B . 33296)
    (?$AsC(B . 31482)
    (?$AsD(B . 31485)
    (?$AsE(B . 31496)
    (?$AsF(B . 31491)
    (?$AsG(B . 31492)
    (?$AsH(B . 31509)
    (?$AsI(B . 31498)
    (?$AsJ(B . 31531)
    (?$AsK(B . 31503)
    (?$AsL(B . 31559)
    (?$AsM(B . 31544)
    (?$AsN(B . 31530)
    (?$AsO(B . 31513)
    (?$AsP(B . 31534)
    (?$AsQ(B . 31537)
    (?$AsR(B . 31520)
    (?$AsS(B . 31525)
    (?$AsT(B . 31524)
    (?$AsU(B . 31539)
    (?$AsV(B . 31550)
    (?$AsW(B . 31518)
    (?$AsX(B . 31576)
    (?$AsY(B . 31578)
    (?$AsZ(B . 31557)
    (?$As[(B . 31605)
    (?$As\(B . 31564)
    (?$As](B . 31581)
    (?$As^(B . 31584)
    (?$As_(B . 31598)
    (?$As`(B . 31611)
    (?$Asa(B . 31586)
    (?$Asb(B . 31602)
    (?$Asc(B . 31601)
    (?$Asd(B . 31632)
    (?$Ase(B . 31654)
    (?$Asf(B . 31655)
    (?$Asg(B . 31672)
    (?$Ash(B . 31660)
    (?$Asi(B . 31645)
    (?$Asj(B . 31656)
    (?$Ask(B . 31621)
    (?$Asl(B . 31658)
    (?$Asm(B . 31644)
    (?$Asn(B . 31650)
    (?$Aso(B . 31659)
    (?$Asp(B . 31668)
    (?$Asq(B . 31697)
    (?$Asr(B . 31681)
    (?$Ass(B . 31692)
    (?$Ast(B . 31709)
    (?$Asu(B . 31706)
    (?$Asv(B . 31717)
    (?$Asw(B . 31718)
    (?$Asx(B . 31722)
    (?$Asy(B . 31756)
    (?$Asz(B . 31742)
    (?$As{(B . 31740)
    (?$As|(B . 31759)
    (?$As}(B . 31766)
    (?$As~(B . 31755)
    (?$At!(B . 31775)
    (?$At"(B . 31786)
    (?$At#(B . 31782)
    (?$At$(B . 31800)
    (?$At%(B . 31809)
    (?$At&(B . 31808)
    (?$At'(B . 33278)
    (?$At((B . 33281)
    (?$At)(B . 33282)
    (?$At*(B . 33284)
    (?$At+(B . 33260)
    (?$At,(B . 34884)
    (?$At-(B . 33313)
    (?$At.(B . 33314)
    (?$At/(B . 33315)
    (?$At0(B . 33325)
    (?$At1(B . 33327)
    (?$At2(B . 33320)
    (?$At3(B . 33323)
    (?$At4(B . 33336)
    (?$At5(B . 33339)
    (?$At6(B . 33331)
    (?$At7(B . 33332)
    (?$At8(B . 33342)
    (?$At9(B . 33348)
    (?$At:(B . 33353)
    (?$At;(B . 33355)
    (?$At<(B . 33359)
    (?$At=(B . 33370)
    (?$At>(B . 33375)
    (?$At?(B . 33384)
    (?$At@(B . 34942)
    (?$AtA(B . 34949)
    (?$AtB(B . 34952)
    (?$AtC(B . 35032)
    (?$AtD(B . 35039)
    (?$AtE(B . 35166)
    (?$AtF(B . 32669)
    (?$AtG(B . 32671)
    (?$AtH(B . 32679)
    (?$AtI(B . 32687)
    (?$AtJ(B . 32688)
    (?$AtK(B . 32690)
    (?$AtL(B . 31868)
    (?$AtM(B . 25929)
    (?$AtN(B . 31889)
    (?$AtO(B . 31901)
    (?$AtP(B . 31900)
    (?$AtQ(B . 31902)
    (?$AtR(B . 31906)
    (?$AtS(B . 31922)
    (?$AtT(B . 31932)
    (?$AtU(B . 31933)
    (?$AtV(B . 31937)
    (?$AtW(B . 31943)
    (?$AtX(B . 31948)
    (?$AtY(B . 31949)
    (?$AtZ(B . 31944)
    (?$At[(B . 31941)
    (?$At\(B . 31959)
    (?$At](B . 31976)
    (?$At^(B . 33390)
    (?$At_(B . 26280)
    (?$At`(B . 32703)
    (?$Ata(B . 32718)
    (?$Atb(B . 32725)
    (?$Atc(B . 32741)
    (?$Atd(B . 32737)
    (?$Ate(B . 32742)
    (?$Atf(B . 32745)
    (?$Atg(B . 32750)
    (?$Ath(B . 32755)
    (?$Ati(B . 31992)
    (?$Atj(B . 32119)
    (?$Atk(B . 32166)
    (?$Atl(B . 32174)
    (?$Atm(B . 32327)
    (?$Atn(B . 32411)
    (?$Ato(B . 40632)
    (?$Atp(B . 40628)
    (?$Atq(B . 36211)
    (?$Atr(B . 36228)
    (?$Ats(B . 36244)
    (?$Att(B . 36241)
    (?$Atu(B . 36273)
    (?$Atv(B . 36199)
    (?$Atw(B . 36205)
    (?$Atx(B . 35911)
    (?$Aty(B . 35913)
    (?$Atz(B . 37194)
    (?$At{(B . 37200)
    (?$At|(B . 37198)
    (?$At}(B . 37199)
    (?$At~(B . 37220)
    (?$Au!(B . 37218)
    (?$Au"(B . 37217)
    (?$Au#(B . 37232)
    (?$Au$(B . 37225)
    (?$Au%(B . 37231)
    (?$Au&(B . 37245)
    (?$Au'(B . 37246)
    (?$Au((B . 37234)
    (?$Au)(B . 37236)
    (?$Au*(B . 37241)
    (?$Au+(B . 37260)
    (?$Au,(B . 37253)
    (?$Au-(B . 37264)
    (?$Au.(B . 37261)
    (?$Au/(B . 37265)
    (?$Au0(B . 37282)
    (?$Au1(B . 37283)
    (?$Au2(B . 37290)
    (?$Au3(B . 37293)
    (?$Au4(B . 37294)
    (?$Au5(B . 37295)
    (?$Au6(B . 37301)
    (?$Au7(B . 37300)
    (?$Au8(B . 37306)
    (?$Au9(B . 35925)
    (?$Au:(B . 40574)
    (?$Au;(B . 36280)
    (?$Au<(B . 36331)
    (?$Au=(B . 36357)
    (?$Au>(B . 36441)
    (?$Au?(B . 36457)
    (?$Au@(B . 36277)
    (?$AuA(B . 36287)
    (?$AuB(B . 36284)
    (?$AuC(B . 36282)
    (?$AuD(B . 36292)
    (?$AuE(B . 36310)
    (?$AuF(B . 36311)
    (?$AuG(B . 36314)
    (?$AuH(B . 36318)
    (?$AuI(B . 36302)
    (?$AuJ(B . 36303)
    (?$AuK(B . 36315)
    (?$AuL(B . 36294)
    (?$AuM(B . 36332)
    (?$AuN(B . 36343)
    (?$AuO(B . 36344)
    (?$AuP(B . 36323)
    (?$AuQ(B . 36345)
    (?$AuR(B . 36347)
    (?$AuS(B . 36324)
    (?$AuT(B . 36361)
    (?$AuU(B . 36349)
    (?$AuV(B . 36372)
    (?$AuW(B . 36381)
    (?$AuX(B . 36383)
    (?$AuY(B . 36396)
    (?$AuZ(B . 36398)
    (?$Au[(B . 36387)
    (?$Au\(B . 36399)
    (?$Au](B . 36410)
    (?$Au^(B . 36416)
    (?$Au_(B . 36409)
    (?$Au`(B . 36405)
    (?$Aua(B . 36413)
    (?$Aub(B . 36401)
    (?$Auc(B . 36425)
    (?$Aud(B . 36417)
    (?$Aue(B . 36418)
    (?$Auf(B . 36433)
    (?$Aug(B . 36434)
    (?$Auh(B . 36426)
    (?$Aui(B . 36464)
    (?$Auj(B . 36470)
    (?$Auk(B . 36476)
    (?$Aul(B . 36463)
    (?$Aum(B . 36468)
    (?$Aun(B . 36485)
    (?$Auo(B . 36495)
    (?$Aup(B . 36500)
    (?$Auq(B . 36496)
    (?$Aur(B . 36508)
    (?$Aus(B . 36510)
    (?$Aut(B . 35960)
    (?$Auu(B . 35970)
    (?$Auv(B . 35978)
    (?$Auw(B . 35973)
    (?$Aux(B . 35992)
    (?$Auy(B . 35988)
    (?$Auz(B . 26011)
    (?$Au{(B . 35286)
    (?$Au|(B . 35294)
    (?$Au}(B . 35290)
    (?$Au~(B . 35292)
    (?$Av!(B . 35301)
    (?$Av"(B . 35307)
    (?$Av#(B . 35311)
    (?$Av$(B . 35390)
    (?$Av%(B . 35622)
    (?$Av&(B . 38739)
    (?$Av'(B . 38633)
    (?$Av((B . 38643)
    (?$Av)(B . 38639)
    (?$Av*(B . 38662)
    (?$Av+(B . 38657)
    (?$Av,(B . 38664)
    (?$Av-(B . 38671)
    (?$Av.(B . 38670)
    (?$Av/(B . 38698)
    (?$Av0(B . 38701)
    (?$Av1(B . 38704)
    (?$Av2(B . 38718)
    (?$Av3(B . 40832)
    (?$Av4(B . 40835)
    (?$Av5(B . 40837)
    (?$Av6(B . 40838)
    (?$Av7(B . 40839)
    (?$Av8(B . 40840)
    (?$Av9(B . 40841)
    (?$Av:(B . 40842)
    (?$Av;(B . 40844)
    (?$Av<(B . 40702)
    (?$Av=(B . 40715)
    (?$Av>(B . 40717)
    (?$Av?(B . 38585)
    (?$Av@(B . 38588)
    (?$AvA(B . 38589)
    (?$AvB(B . 38606)
    (?$AvC(B . 38610)
    (?$AvD(B . 30655)
    (?$AvE(B . 38624)
    (?$AvF(B . 37518)
    (?$AvG(B . 37550)
    (?$AvH(B . 37576)
    (?$AvI(B . 37694)
    (?$AvJ(B . 37738)
    (?$AvK(B . 37834)
    (?$AvL(B . 37775)
    (?$AvM(B . 37950)
    (?$AvN(B . 37995)
    (?$AvO(B . 40063)
    (?$AvP(B . 40066)
    (?$AvQ(B . 40069)
    (?$AvR(B . 40070)
    (?$AvS(B . 40071)
    (?$AvT(B . 40072)
    (?$AvU(B . 31267)
    (?$AvV(B . 40075)
    (?$AvW(B . 40078)
    (?$AvX(B . 40080)
    (?$AvY(B . 40081)
    (?$AvZ(B . 40082)
    (?$Av[(B . 40084)
    (?$Av\(B . 40085)
    (?$Av](B . 40090)
    (?$Av^(B . 40091)
    (?$Av_(B . 40094)
    (?$Av`(B . 40095)
    (?$Ava(B . 40096)
    (?$Avb(B . 40097)
    (?$Avc(B . 40098)
    (?$Avd(B . 40099)
    (?$Ave(B . 40101)
    (?$Avf(B . 40102)
    (?$Avg(B . 40103)
    (?$Avh(B . 40104)
    (?$Avi(B . 40105)
    (?$Avj(B . 40107)
    (?$Avk(B . 40109)
    (?$Avl(B . 40110)
    (?$Avm(B . 40112)
    (?$Avn(B . 40113)
    (?$Avo(B . 40114)
    (?$Avp(B . 40115)
    (?$Avq(B . 40116)
    (?$Avr(B . 40117)
    (?$Avs(B . 40118)
    (?$Avt(B . 40119)
    (?$Avu(B . 40122)
    (?$Avv(B . 40123)
    (?$Avw(B . 40124)
    (?$Avx(B . 40125)
    (?$Avy(B . 40132)
    (?$Avz(B . 40133)
    (?$Av{(B . 40134)
    (?$Av|(B . 40135)
    (?$Av}(B . 40138)
    (?$Av~(B . 40139)
    (?$Aw!(B . 40140)
    (?$Aw"(B . 40141)
    (?$Aw#(B . 40142)
    (?$Aw$(B . 40143)
    (?$Aw%(B . 40144)
    (?$Aw&(B . 40147)
    (?$Aw'(B . 40148)
    (?$Aw((B . 40149)
    (?$Aw)(B . 40151)
    (?$Aw*(B . 40152)
    (?$Aw+(B . 40153)
    (?$Aw,(B . 40156)
    (?$Aw-(B . 40157)
    (?$Aw.(B . 40159)
    (?$Aw/(B . 40162)
    (?$Aw0(B . 38780)
    (?$Aw1(B . 38789)
    (?$Aw2(B . 38801)
    (?$Aw3(B . 38802)
    (?$Aw4(B . 38804)
    (?$Aw5(B . 38831)
    (?$Aw6(B . 38827)
    (?$Aw7(B . 38819)
    (?$Aw8(B . 38834)
    (?$Aw9(B . 38836)
    (?$Aw:(B . 39601)
    (?$Aw;(B . 39600)
    (?$Aw<(B . 39607)
    (?$Aw=(B . 40536)
    (?$Aw>(B . 39606)
    (?$Aw?(B . 39610)
    (?$Aw@(B . 39612)
    (?$AwA(B . 39617)
    (?$AwB(B . 39616)
    (?$AwC(B . 39621)
    (?$AwD(B . 39618)
    (?$AwE(B . 39627)
    (?$AwF(B . 39628)
    (?$AwG(B . 39633)
    (?$AwH(B . 39749)
    (?$AwI(B . 39747)
    (?$AwJ(B . 39751)
    (?$AwK(B . 39753)
    (?$AwL(B . 39752)
    (?$AwM(B . 39757)
    (?$AwN(B . 39761)
    (?$AwO(B . 39144)
    (?$AwP(B . 39181)
    (?$AwQ(B . 39214)
    (?$AwR(B . 39253)
    (?$AwS(B . 39252)
    (?$AwT(B . 39647)
    (?$AwU(B . 39649)
    (?$AwV(B . 39654)
    (?$AwW(B . 39663)
    (?$AwX(B . 39659)
    (?$AwY(B . 39675)
    (?$AwZ(B . 39661)
    (?$Aw[(B . 39673)
    (?$Aw\(B . 39688)
    (?$Aw](B . 39695)
    (?$Aw^(B . 39699)
    (?$Aw_(B . 39711)
    (?$Aw`(B . 39715)
    (?$Awa(B . 40637)
    (?$Awb(B . 40638)
    (?$Awc(B . 32315)
    (?$Awd(B . 40578)
    (?$Awe(B . 40583)
    (?$Awf(B . 40584)
    (?$Awg(B . 40587)
    (?$Awh(B . 40594)
    (?$Awi(B . 37846)
    (?$Awj(B . 40605)
    (?$Awk(B . 40607)
    (?$Awl(B . 40667)
    (?$Awm(B . 40668)
    (?$Awn(B . 40669)
    (?$Awo(B . 40672)
    (?$Awp(B . 40671)
    (?$Awq(B . 40674)
    (?$Awr(B . 40681)
    (?$Aws(B . 40679)
    (?$Awt(B . 40677)
    (?$Awu(B . 40682)
    (?$Awv(B . 40687)
    (?$Aww(B . 40738)
    (?$Awx(B . 40748)
    (?$Awy(B . 40751)
    (?$Awz(B . 40761)
    (?$Aw{(B . 40759)
    (?$Aw|(B . 40765)
    (?$Aw}(B . 40766)
    (?$Aw~(B . 40772)))

(provide 'ugb2312)

