;;; mucs-ccl.el --- for MULE-UCS basic ccl configurations

;; Copyright (C) 1997 Miyashita Hisashi

;; Keywords: mule, multilingual, 
;;           character set, coding-system, ISO10646, Unicode

;; This file is part of MULE-UCS

;; MULE-UCS is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; MULE-UCS is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with this program; see the file COPYING.  If not, write to the
;; Free Software Foundation, Inc., 59 Temple Place - Suite 330,
;; Boston, MA 02111-1307, USA.

;; Comment:

(require 'tbl-mg)
(require 'ccl)

(defvar mucs-ccl-represent-2-form t
  "MUCS-UCS CCL code generator's variable.
When nil, CCL code generator regards that r1 is not used to store charset.")

;;;
;;; Table package registration manager.
;;;

(defun mucs-ccl-registered-p (table)
  (memq table (get mucs-current-package
		   'mucs-registered-ccls)))

(defun mucs-ccl-add-registration (table)
  (if (and mucs-current-package
	   (symbolp mucs-current-package))
      (or
       (mucs-ccl-registered-p table)
       (put mucs-current-package
	    'mucs-registered-ccls
	    (cons table
		  (get mucs-current-package
		       'mucs-registered-ccls))))))

(defun mucs-ccl-delete-registration (table)
  (if (and mucs-current-package
	   (symbolp mucs-current-package))
      (put mucs-current-package
	   'mucs-registered-ccls
	   (delq
	    (get mucs-current-package
		 'mucs-registered-ccls)))))

;;;
;;;
;;;
;;;

(defvar mucs-ccl-read-ex-1-octet
  `((read r0)))

(defvar mucs-ccl-read-ex-be-2-octet
  `((read r0 r6)
    (r0 = (r0 <8 r6))))

(defvar mucs-ccl-read-ex-le-2-octet
  `((read r0 r6)
    (r0 = (r6 <8 r0))))

(defvar mucs-ccl-read-ex-be-4-octet
  `((read r0 r6)
    (r0 = (r0 <8 r6))
    (read r4 r6)
    (r0 |= (r4 << 16))))

(defvar mucs-ccl-read-ex-le-4-octet
  `((read r0 r6)
    (r0 |= (r6 << 16))
    (read r4 r6)
    (r0 |= (r4 <8 r6))))

(defvar mucs-ccl-write-ex-1-octet
  `((write r0)))

(defvar mucs-ccl-write-ex-be-2-octet
  `((r6 = (r0 >> 8))
    (r4 = (r0 & ?\xff))
    (write r6 r4)))

(defvar mucs-ccl-write-ex-le-2-octet
  `((r6 = (r0 >> 8))
    (r4 = (r0 & ?\xff))
    (write r4 r6)))

(defvar mucs-ccl-write-ex-be-4-octet
  `((r4 = ((r0 >> 16) & ?\xff))
    (r6 = 0)
    (write r6 r4)
    (r6 = ((r0 >> 8) & ?\xff))
    (r4 = (r0 & ?\xff))    
    (write r6 r4)))

(defvar mucs-ccl-write-ex-le-4-octet
  `((r4 = (r0 & ?\xff))
    (r6 = ((r0 >> 8) & ?\xff))
    (write r4 r6)
    (r4 = ((r0 >> 16) & ?\xff))
    (r6 = 0)
    (write r4 r6)))

(defun mucs-ccl-read-generic ()
  (if mucs-ccl-represent-2-form
      '((read-multibyte-character r1 r0))
    '((read-multibyte-character r0))))

(defun mucs-ccl-write-generic ()
  (if mucs-ccl-represent-2-form
      '((write-multibyte-character r1 r0))
    '((write r0))))

;;
;; Dealing with line separator problem.
;;

(defconst mucs-ccl-previous-cr-p-bit 16)

(defun mucs-ccl-previous-cr-p ()
  '(r5 & ?\x2))

(defun mucs-ccl-set-eol-state (eol)
  (if (eq eol 'cr)
      '((r5 |= ?\x2))
    `((r5 &= ,(logxor (mucs-number-mask) ?\x2)))))

(defun mucs-ccl-write-generic-dos ()
  `((if (r0 == ?\x0d)
	((if ,(mucs-ccl-previous-cr-p)
	     ((write ?\x0d))
	   ,(mucs-ccl-set-eol-state 'cr)))
      ((r6 = (r0 != ?\x0a))
       (if (,(mucs-ccl-previous-cr-p) & r6)
	   ((write ?\x0d)))
       ,@(mucs-ccl-set-eol-state nil)
       ,@(mucs-ccl-write-generic)))))


(defun mucs-ccl-bind-program (progs)
  (let (ccl prep-prog ret)
    (while progs
      (setq ret (car progs)
	    progs (cdr progs))
      (if (and
	   (consp ret)
	   (eq (car ret) 'mucs-preparation))
	  (setq ccl (append ccl (nth 2 ret))
		prep-prog (nconc prep-prog (nth 1 ret)))
	(setq ccl (append ccl ret))))
    (list 'mucs-preparation prep-prog ccl)))

(defun mucs-ccl-stream-form (&rest args)
  (let ((ret (mucs-ccl-bind-program args)))
    (list 'mucs-preparation
	  (nth 1 ret)
	  (list
	   (append '(loop)
		   (nth 2 ret)
		   '((repeat)))))))

(defun mucs-ccl-setup-ccl-program (mucs-ccl-prog)
  (let ((mag (eval (car mucs-ccl-prog)))
	(config1 (nth 1 mucs-ccl-prog))
	(config2 (nth 2 mucs-ccl-prog))
	(mucs-ccl-represent-2-form t)
	main-ccl eof-ccl ccl prep-prog ret
	func)
    (setq func 
	  (lambda (config)
	    (while config
	      (setq ret (eval (car config))
		    config (cdr config))
	      (if (and
		   (consp ret)
		   (eq (car ret) 'mucs-preparation))
		  (setq ccl (append ccl (nth 2 ret))
			prep-prog (nconc prep-prog (nth 1 ret)))
		(setq ccl (append ccl ret))))))
    (funcall func config1)
    (setq main-ccl ccl
	  ccl nil)
    (funcall func config2)
    (setq eof-ccl ccl)
    (cons prep-prog (ccl-compile (list mag main-ccl eof-ccl)))))

(provide 'mucs-ccl)
