;;; -*- coding: iso-2022-7bit  -*-
;;; ubig5.el --- tables between UCS and BIG5

;; Keywords: CCL, mule, multilingual, 
;;           character set, coding-system, ISO10646, Unicode, BIG5

;; This file is part of Mule-UCS

;; Mule-UCS is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; Mule-UCS is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with this program; see the file COPYING.  If not, write to the
;; Free Software Foundation, Inc., 59 Temple Place - Suite 330,
;; Boston, MA 02111-1307, USA.

;;; This file is converted from BIG5.TXT of Unicode consortium
;;; by Miyashita Hisashi <himi@bird.scphys.kyoto-u.ac.jp>.

(put 'chinese-big5-1 'unicode-assoc
     'chinese-big5-1-vs-unicode-assoc)

(put 'chinese-big5-2 'unicode-assoc
     'chinese-big5-2-vs-unicode-assoc)

(defvar
  chinese-big5-1-vs-unicode-assoc
  '(assoc
    (char-1 . ucs-generic)
    ((?$(0!!(B . ?\x3000) ;; IDEOGRAPHIC SPACE
     (?$(0!"(B . ?\xFF0C) ;; FULLWIDTH COMMA
     (?$(0!#(B . ?\x3001) ;; IDEOGRAPHIC COMMA
     (?$(0!$(B . ?\x3002) ;; IDEOGRAPHIC FULL STOP
     (?$(0!%(B . ?\xFF0E) ;; FULLWIDTH FULL STOP
     (?$(0!&(B . ?\x2022) ;; BULLET
     (?$(0!'(B . ?\xFF1B) ;; FULLWIDTH SEMICOLON
     (?$(0!((B . ?\xFF1A) ;; FULLWIDTH COLON
     (?$(0!)(B . ?\xFF1F) ;; FULLWIDTH QUESTION MARK
     (?$(0!*(B . ?\xFF01) ;; FULLWIDTH EXCLAMATION MARK
     (?$(0!+(B . ?\xFE30) ;; PRESENTATION FORM FOR VERTICAL TWO DOT LEADER
     (?$(0!,(B . ?\x2026) ;; HORIZONTAL ELLIPSIS
     (?$(0!-(B . ?\x2025) ;; TWO DOT LEADER
     (?$(0!.(B . ?\xFE50) ;; SMALL COMMA
     (?$(0!/(B . ?\xFF64) ;; HALFWIDTH IDEOGRAPHIC COMMA
     (?$(0!0(B . ?\xFE52) ;; SMALL FULL STOP
     (?$(0!1(B . ?\x00B7) ;; MIDDLE DOT
     (?$(0!2(B . ?\xFE54) ;; SMALL SEMICOLON
     (?$(0!3(B . ?\xFE55) ;; SMALL COLON
     (?$(0!4(B . ?\xFE56) ;; SMALL QUESTION MARK
     (?$(0!5(B . ?\xFE57) ;; SMALL EXCLAMATION MARK
     (?$(0!6(B . ?\xFF5C) ;; FULLWIDTH VERTICAL BAR
     (?$(0!7(B . ?\x2013) ;; EN DASH
     (?$(0!8(B . ?\xFE31) ;; PRESENTATION FORM FOR VERTICAL EM DASH
     (?$(0!9(B . ?\x2014) ;; EM DASH
     (?$(0!:(B . ?\xFE33) ;; PRESENTATION FORM FOR VERTICAL LOW LINE
     (?$(0!;(B . ?\xFFFD) ;; *** NO MAPPING ***
     (?$(0!<(B . ?\xFE34) ;; PRESENTATION FORM FOR VERTICAL WAVY LOW LINE
     (?$(0!=(B . ?\xFE4F) ;; WAVY LOW LINE
     (?$(0!>(B . ?\xFF08) ;; FULLWIDTH LEFT PARENTHESIS
     (?$(0!?(B . ?\xFF09) ;; FULLWIDTH RIGHT PARENTHESIS
     (?$(0!@(B . ?\xFE35) ;; PRESENTATION FORM FOR VERTICAL LEFT PARENTHESIS
     (?$(0!A(B . ?\xFE36) ;; PRESENTATION FORM FOR VERTICAL RIGHT PARENTHESIS
     (?$(0!B(B . ?\xFF5B) ;; FULLWIDTH LEFT CURLY BRACKET
     (?$(0!C(B . ?\xFF5D) ;; FULLWIDTH RIGHT CURLY BRACKET
     (?$(0!D(B . ?\xFE37) ;; PRESENTATION FORM FOR VERTICAL LEFT CURLY BRACKET
     (?$(0!E(B . ?\xFE38) ;; PRESENTATION FORM FOR VERTICAL RIGHT CURLY BRACKET
     (?$(0!F(B . ?\x3014) ;; LEFT TORTOISE SHELL BRACKET
     (?$(0!G(B . ?\x3015) ;; RIGHT TORTOISE SHELL BRACKET
     (?$(0!H(B . ?\xFE39) ;; PRESENTATION FORM FOR VERTICAL LEFT TORTOISE SHELL BRACKET
     (?$(0!I(B . ?\xFE3A) ;; PRESENTATION FORM FOR VERTICAL RIGHT TORTOISE SHELL BRACKET
     (?$(0!J(B . ?\x3010) ;; LEFT BLACK LENTICULAR BRACKET
     (?$(0!K(B . ?\x3011) ;; RIGHT BLACK LENTICULAR BRACKET
     (?$(0!L(B . ?\xFE3B) ;; PRESENTATION FORM FOR VERTICAL LEFT BLACK LENTICULAR BRACKET
     (?$(0!M(B . ?\xFE3C) ;; PRESENTATION FORM FOR VERTICAL RIGHT BLACK LENTICULAR BRACKET
     (?$(0!N(B . ?\x300A) ;; LEFT DOUBLE ANGLE BRACKET
     (?$(0!O(B . ?\x300B) ;; RIGHT DOUBLE ANGLE BRACKET
     (?$(0!P(B . ?\xFE3D) ;; PRESENTATION FORM FOR VERTICAL LEFT DOUBLE ANGLE BRACKET
     (?$(0!Q(B . ?\xFE3E) ;; PRESENTATION FORM FOR VERTICAL RIGHT DOUBLE ANGLE BRACKET
     (?$(0!R(B . ?\x3008) ;; LEFT ANGLE BRACKET
     (?$(0!S(B . ?\x3009) ;; RIGHT ANGLE BRACKET
     (?$(0!T(B . ?\xFE3F) ;; PRESENTATION FORM FOR VERTICAL LEFT ANGLE BRACKET
     (?$(0!U(B . ?\xFE40) ;; PRESENTATION FORM FOR VERTICAL RIGHT ANGLE BRACKET
     (?$(0!V(B . ?\x300C) ;; LEFT CORNER BRACKET
     (?$(0!W(B . ?\x300D) ;; RIGHT CORNER BRACKET
     (?$(0!X(B . ?\xFE41) ;; PRESENTATION FORM FOR VERTICAL LEFT CORNER BRACKET
     (?$(0!Y(B . ?\xFE42) ;; PRESENTATION FORM FOR VERTICAL RIGHT CORNER BRACKET
     (?$(0!Z(B . ?\x300E) ;; LEFT WHITE CORNER BRACKET
     (?$(0![(B . ?\x300F) ;; RIGHT WHITE CORNER BRACKET
     (?$(0!\(B . ?\xFE43) ;; PRESENTATION FORM FOR VERTICAL LEFT WHITE CORNER BRACKET
     (?$(0!](B . ?\xFE44) ;; PRESENTATION FORM FOR VERTICAL RIGHT WHITE CORNER BRACKET
     (?$(0!^(B . ?\xFE59) ;; SMALL LEFT PARENTHESIS
     (?$(0!_(B . ?\xFE5A) ;; SMALL RIGHT PARENTHESIS
     (?$(0!`(B . ?\xFE5B) ;; SMALL LEFT CURLY BRACKET
     (?$(0!a(B . ?\xFE5C) ;; SMALL RIGHT CURLY BRACKET
     (?$(0!b(B . ?\xFE5D) ;; SMALL LEFT TORTOISE SHELL BRACKET
     (?$(0!c(B . ?\xFE5E) ;; SMALL RIGHT TORTOISE SHELL BRACKET
     (?$(0!d(B . ?\x2018) ;; LEFT SINGLE QUOTATION MARK
     (?$(0!e(B . ?\x2019) ;; RIGHT SINGLE QUOTATION MARK
     (?$(0!f(B . ?\x201C) ;; LEFT DOUBLE QUOTATION MARK
     (?$(0!g(B . ?\x201D) ;; RIGHT DOUBLE QUOTATION MARK
     (?$(0!h(B . ?\x301D) ;; REVERSED DOUBLE PRIME QUOTATION MARK
     (?$(0!i(B . ?\x301E) ;; DOUBLE PRIME QUOTATION MARK
     (?$(0!j(B . ?\x2035) ;; REVERSED PRIME
     (?$(0!k(B . ?\x2032) ;; PRIME
     (?$(0!l(B . ?\xFF03) ;; FULLWIDTH NUMBER SIGN
     (?$(0!m(B . ?\xFF06) ;; FULLWIDTH AMPERSAND
     (?$(0!n(B . ?\xFF0A) ;; FULLWIDTH ASTERISK
     (?$(0!o(B . ?\x203B) ;; REFERENCE MARK
     (?$(0!p(B . ?\x00A7) ;; SECTION SIGN
     (?$(0!q(B . ?\x3003) ;; DITTO MARK
     (?$(0!r(B . ?\x25CB) ;; WHITE CIRCLE
     (?$(0!s(B . ?\x25CF) ;; BLACK CIRCLE
     (?$(0!t(B . ?\x25B3) ;; WHITE UP-POINTING TRIANGLE
     (?$(0!u(B . ?\x25B2) ;; BLACK UP-POINTING TRIANGLE
     (?$(0!v(B . ?\x25CE) ;; BULLSEYE
     (?$(0!w(B . ?\x2606) ;; WHITE STAR
     (?$(0!x(B . ?\x2605) ;; BLACK STAR
     (?$(0!y(B . ?\x25C7) ;; WHITE DIAMOND
     (?$(0!z(B . ?\x25C6) ;; BLACK DIAMOND
     (?$(0!{(B . ?\x25A1) ;; WHITE SQUARE
     (?$(0!|(B . ?\x25A0) ;; BLACK SQUARE
     (?$(0!}(B . ?\x25BD) ;; WHITE DOWN-POINTING TRIANGLE
     (?$(0!~(B . ?\x25BC) ;; BLACK DOWN-POINTING TRIANGLE
     (?$(0"!(B . ?\x32A3) ;; CIRCLED IDEOGRAPH CORRECT
     (?$(0""(B . ?\x2105) ;; CARE OF
     (?$(0"#(B . ?\x203E) ;; OVERLINE
     (?$(0"$(B . ?\xFFFD) ;; *** NO MAPPING ***
     (?$(0"%(B . ?\xFF3F) ;; FULLWIDTH LOW LINE
     (?$(0"&(B . ?\xFFFD) ;; *** NO MAPPING ***
     (?$(0"'(B . ?\xFE49) ;; DASHED OVERLINE
     (?$(0"((B . ?\xFE4A) ;; CENTRELINE OVERLINE
     (?$(0")(B . ?\xFE4D) ;; DASHED LOW LINE
     (?$(0"*(B . ?\xFE4E) ;; CENTRELINE LOW LINE
     (?$(0"+(B . ?\xFE4B) ;; WAVY OVERLINE
     (?$(0",(B . ?\xFE4C) ;; DOUBLE WAVY OVERLINE
     (?$(0"-(B . ?\xFE5F) ;; SMALL NUMBER SIGN
     (?$(0".(B . ?\xFE60) ;; SMALL AMPERSAND
     (?$(0"/(B . ?\xFE61) ;; SMALL ASTERISK
     (?$(0"0(B . ?\xFF0B) ;; FULLWIDTH PLUS SIGN
     (?$(0"1(B . ?\xFF0D) ;; FULLWIDTH HYPHEN-MINUS
     (?$(0"2(B . ?\x00D7) ;; MULTIPLICATION SIGN
     (?$(0"3(B . ?\x00F7) ;; DIVISION SIGN
     (?$(0"4(B . ?\x00B1) ;; PLUS-MINUS SIGN
     (?$(0"5(B . ?\x221A) ;; SQUARE ROOT
     (?$(0"6(B . ?\xFF1C) ;; FULLWIDTH LESS-THAN SIGN
     (?$(0"7(B . ?\xFF1E) ;; FULLWIDTH GREATER-THAN SIGN
     (?$(0"8(B . ?\xFF1D) ;; FULLWIDTH EQUALS SIGN
     (?$(0"9(B . ?\x2266) ;; LESS THAN OVER EQUAL TO
     (?$(0":(B . ?\x2267) ;; GREATER THAN OVER EQUAL TO
     (?$(0";(B . ?\x2260) ;; NOT EQUAL TO
     (?$(0"<(B . ?\x221E) ;; INFINITY
     (?$(0"=(B . ?\x2252) ;; APPROXIMATELY EQUAL TO OR THE IMAGE OF
     (?$(0">(B . ?\x2261) ;; IDENTICAL TO
     (?$(0"?(B . ?\xFE62) ;; SMALL PLUS SIGN
     (?$(0"@(B . ?\xFE63) ;; SMALL HYPHEN-MINUS
     (?$(0"A(B . ?\xFE64) ;; SMALL LESS-THAN SIGN
     (?$(0"B(B . ?\xFE65) ;; SMALL GREATER-THAN SIGN
     (?$(0"C(B . ?\xFE66) ;; SMALL EQUALS SIGN
     (?$(0"D(B . ?\x223C) ;; TILDE OPERATOR
     (?$(0"E(B . ?\x2229) ;; INTERSECTION
     (?$(0"F(B . ?\x222A) ;; UNION
     (?$(0"G(B . ?\x22A5) ;; UP TACK
     (?$(0"H(B . ?\x2220) ;; ANGLE
     (?$(0"I(B . ?\x221F) ;; RIGHT ANGLE
     (?$(0"J(B . ?\x22BF) ;; RIGHT TRIANGLE
     (?$(0"K(B . ?\x33D2) ;; SQUARE LOG
     (?$(0"L(B . ?\x33D1) ;; SQUARE LN
     (?$(0"M(B . ?\x222B) ;; INTEGRAL
     (?$(0"N(B . ?\x222E) ;; CONTOUR INTEGRAL
     (?$(0"O(B . ?\x2235) ;; BECAUSE
     (?$(0"P(B . ?\x2234) ;; THEREFORE
     (?$(0"Q(B . ?\x2640) ;; FEMALE SIGN
     (?$(0"R(B . ?\x2642) ;; MALE SIGN
     (?$(0"S(B . ?\x2641) ;; EARTH
     (?$(0"T(B . ?\x2609) ;; SUN
     (?$(0"U(B . ?\x2191) ;; UPWARDS ARROW
     (?$(0"V(B . ?\x2193) ;; DOWNWARDS ARROW
     (?$(0"W(B . ?\x2190) ;; LEFTWARDS ARROW
     (?$(0"X(B . ?\x2192) ;; RIGHTWARDS ARROW
     (?$(0"Y(B . ?\x2196) ;; NORTH WEST ARROW
     (?$(0"Z(B . ?\x2197) ;; NORTH EAST ARROW
     (?$(0"[(B . ?\x2199) ;; SOUTH WEST ARROW
     (?$(0"\(B . ?\x2198) ;; SOUTH EAST ARROW
     (?$(0"](B . ?\x2225) ;; PARALLEL TO
     (?$(0"^(B . ?\x2223) ;; DIVIDES
     (?$(0"_(B . ?\xFFFD) ;; *** NO MAPPING ***
     (?$(0"`(B . ?\xFFFD) ;; *** NO MAPPING ***
     (?$(0"a(B . ?\xFF0F) ;; FULLWIDTH SOLIDUS
     (?$(0"b(B . ?\xFF3C) ;; FULLWIDTH REVERSE SOLIDUS
     (?$(0"c(B . ?\xFF04) ;; FULLWIDTH DOLLAR SIGN
     (?$(0"d(B . ?\x00A5) ;; YEN SIGN
     (?$(0"e(B . ?\x3012) ;; POSTAL MARK
     (?$(0"f(B . ?\x00A2) ;; CENT SIGN
     (?$(0"g(B . ?\x00A3) ;; POUND SIGN
     (?$(0"h(B . ?\xFF05) ;; FULLWIDTH PERCENT SIGN
     (?$(0"i(B . ?\xFF20) ;; FULLWIDTH COMMERCIAL AT
     (?$(0"j(B . ?\x2103) ;; DEGREE CELSIUS
     (?$(0"k(B . ?\x2109) ;; DEGREE FAHRENHEIT
     (?$(0"l(B . ?\xFE69) ;; SMALL DOLLAR SIGN
     (?$(0"m(B . ?\xFE6A) ;; SMALL PERCENT SIGN
     (?$(0"n(B . ?\xFE6B) ;; SMALL COMMERCIAL AT
     (?$(0"o(B . ?\x33D5) ;; SQUARE MIL
     (?$(0"p(B . ?\x339C) ;; SQUARE MM
     (?$(0"q(B . ?\x339D) ;; SQUARE CM
     (?$(0"r(B . ?\x339E) ;; SQUARE KM
     (?$(0"s(B . ?\x33CE) ;; SQUARE KM CAPITAL
     (?$(0"t(B . ?\x33A1) ;; SQUARE M SQUARED
     (?$(0"u(B . ?\x338E) ;; SQUARE MG
     (?$(0"v(B . ?\x338F) ;; SQUARE KG
     (?$(0"w(B . ?\x33C4) ;; SQUARE CC
     (?$(0"x(B . ?\x00B0) ;; DEGREE SIGN
     (?$(0"y(B . ?\x5159) ;; <CJK>
     (?$(0"z(B . ?\x515B) ;; <CJK>
     (?$(0"{(B . ?\x515E) ;; <CJK>
     (?$(0"|(B . ?\x515D) ;; <CJK>
     (?$(0"}(B . ?\x5161) ;; <CJK>
     (?$(0"~(B . ?\x5163) ;; <CJK>
     (?$(0#!(B . ?\x55E7) ;; <CJK>
     (?$(0#"(B . ?\x74E9) ;; <CJK>
     (?$(0##(B . ?\x7CCE) ;; <CJK>
     (?$(0#$(B . ?\x2581) ;; LOWER ONE EIGHTH BLOCK
     (?$(0#%(B . ?\x2582) ;; LOWER ONE QUARTER BLOCK
     (?$(0#&(B . ?\x2583) ;; LOWER THREE EIGHTHS BLOCK
     (?$(0#'(B . ?\x2584) ;; LOWER HALF BLOCK
     (?$(0#((B . ?\x2585) ;; LOWER FIVE EIGHTHS BLOCK
     (?$(0#)(B . ?\x2586) ;; LOWER THREE QUARTERS BLOCK
     (?$(0#*(B . ?\x2587) ;; LOWER SEVEN EIGHTHS BLOCK
     (?$(0#+(B . ?\x2588) ;; FULL BLOCK
     (?$(0#,(B . ?\x258F) ;; LEFT ONE EIGHTH BLOCK
     (?$(0#-(B . ?\x258E) ;; LEFT ONE QUARTER BLOCK
     (?$(0#.(B . ?\x258D) ;; LEFT THREE EIGHTHS BLOCK
     (?$(0#/(B . ?\x258C) ;; LEFT HALF BLOCK
     (?$(0#0(B . ?\x258B) ;; LEFT FIVE EIGHTHS BLOCK
     (?$(0#1(B . ?\x258A) ;; LEFT THREE QUARTERS BLOCK
     (?$(0#2(B . ?\x2589) ;; LEFT SEVEN EIGHTHS BLOCK
     (?$(0#3(B . ?\x253C) ;; BOX DRAWINGS LIGHT VERTICAL AND HORIZONTAL
     (?$(0#4(B . ?\x2534) ;; BOX DRAWINGS LIGHT UP AND HORIZONTAL
     (?$(0#5(B . ?\x252C) ;; BOX DRAWINGS LIGHT DOWN AND HORIZONTAL
     (?$(0#6(B . ?\x2524) ;; BOX DRAWINGS LIGHT VERTICAL AND LEFT
     (?$(0#7(B . ?\x251C) ;; BOX DRAWINGS LIGHT VERTICAL AND RIGHT
     (?$(0#8(B . ?\x2594) ;; UPPER ONE EIGHTH BLOCK
     (?$(0#9(B . ?\x2500) ;; BOX DRAWINGS LIGHT HORIZONTAL
     (?$(0#:(B . ?\x2502) ;; BOX DRAWINGS LIGHT VERTICAL
     (?$(0#;(B . ?\x2595) ;; RIGHT ONE EIGHTH BLOCK
     (?$(0#<(B . ?\x250C) ;; BOX DRAWINGS LIGHT DOWN AND RIGHT
     (?$(0#=(B . ?\x2510) ;; BOX DRAWINGS LIGHT DOWN AND LEFT
     (?$(0#>(B . ?\x2514) ;; BOX DRAWINGS LIGHT UP AND RIGHT
     (?$(0#?(B . ?\x2518) ;; BOX DRAWINGS LIGHT UP AND LEFT
     (?$(0#@(B . ?\x256D) ;; BOX DRAWINGS LIGHT ARC DOWN AND RIGHT
     (?$(0#A(B . ?\x256E) ;; BOX DRAWINGS LIGHT ARC DOWN AND LEFT
     (?$(0#B(B . ?\x2570) ;; BOX DRAWINGS LIGHT ARC UP AND RIGHT
     (?$(0#C(B . ?\x256F) ;; BOX DRAWINGS LIGHT ARC UP AND LEFT
     (?$(0#D(B . ?\x2550) ;; BOX DRAWINGS DOUBLE HORIZONTAL
     (?$(0#E(B . ?\x255E) ;; BOX DRAWINGS VERTICAL SINGLE AND RIGHT DOUBLE
     (?$(0#F(B . ?\x256A) ;; BOX DRAWINGS VERTICAL SINGLE AND HORIZONTAL DOUBLE
     (?$(0#G(B . ?\x2561) ;; BOX DRAWINGS VERTICAL SINGLE AND LEFT DOUBLE
     (?$(0#H(B . ?\x25E2) ;; BLACK LOWER RIGHT TRIANGLE
     (?$(0#I(B . ?\x25E3) ;; BLACK LOWER LEFT TRIANGLE
     (?$(0#J(B . ?\x25E5) ;; BLACK UPPER RIGHT TRIANGLE
     (?$(0#K(B . ?\x25E4) ;; BLACK UPPER LEFT TRIANGLE
     (?$(0#L(B . ?\x2571) ;; BOX DRAWINGS LIGHT DIAGONAL UPPER RIGHT TO LOWER LEFT
     (?$(0#M(B . ?\x2572) ;; BOX DRAWINGS LIGHT DIAGONAL UPPER LEFT TO LOWER RIGHT
     (?$(0#N(B . ?\x2573) ;; BOX DRAWINGS LIGHT DIAGONAL CROSS
     (?$(0#O(B . ?\xFF10) ;; FULLWIDTH DIGIT ZERO
     (?$(0#P(B . ?\xFF11) ;; FULLWIDTH DIGIT ONE
     (?$(0#Q(B . ?\xFF12) ;; FULLWIDTH DIGIT TWO
     (?$(0#R(B . ?\xFF13) ;; FULLWIDTH DIGIT THREE
     (?$(0#S(B . ?\xFF14) ;; FULLWIDTH DIGIT FOUR
     (?$(0#T(B . ?\xFF15) ;; FULLWIDTH DIGIT FIVE
     (?$(0#U(B . ?\xFF16) ;; FULLWIDTH DIGIT SIX
     (?$(0#V(B . ?\xFF17) ;; FULLWIDTH DIGIT SEVEN
     (?$(0#W(B . ?\xFF18) ;; FULLWIDTH DIGIT EIGHT
     (?$(0#X(B . ?\xFF19) ;; FULLWIDTH DIGIT NINE
     (?$(0#Y(B . ?\x2160) ;; ROMAN NUMERAL ONE
     (?$(0#Z(B . ?\x2161) ;; ROMAN NUMERAL TWO
     (?$(0#[(B . ?\x2162) ;; ROMAN NUMERAL THREE
     (?$(0#\(B . ?\x2163) ;; ROMAN NUMERAL FOUR
     (?$(0#](B . ?\x2164) ;; ROMAN NUMERAL FIVE
     (?$(0#^(B . ?\x2165) ;; ROMAN NUMERAL SIX
     (?$(0#_(B . ?\x2166) ;; ROMAN NUMERAL SEVEN
     (?$(0#`(B . ?\x2167) ;; ROMAN NUMERAL EIGHT
     (?$(0#a(B . ?\x2168) ;; ROMAN NUMERAL NINE
     (?$(0#b(B . ?\x2169) ;; ROMAN NUMERAL TEN
     (?$(0#c(B . ?\x3021) ;; HANGZHOU NUMERAL ONE
     (?$(0#d(B . ?\x3022) ;; HANGZHOU NUMERAL TWO
     (?$(0#e(B . ?\x3023) ;; HANGZHOU NUMERAL THREE
     (?$(0#f(B . ?\x3024) ;; HANGZHOU NUMERAL FOUR
     (?$(0#g(B . ?\x3025) ;; HANGZHOU NUMERAL FIVE
     (?$(0#h(B . ?\x3026) ;; HANGZHOU NUMERAL SIX
     (?$(0#i(B . ?\x3027) ;; HANGZHOU NUMERAL SEVEN
     (?$(0#j(B . ?\x3028) ;; HANGZHOU NUMERAL EIGHT
     (?$(0#k(B . ?\x3029) ;; HANGZHOU NUMERAL NINE
     (?$(0#l(B . ?\xFFFD) ;; *** NO MAPPING ***
     (?$(0#m(B . ?\x5344) ;; <CJK>
     (?$(0#n(B . ?\xFFFD) ;; *** NO MAPPING ***
     (?$(0#o(B . ?\xFF21) ;; FULLWIDTH LATIN CAPITAL LETTER A
     (?$(0#p(B . ?\xFF22) ;; FULLWIDTH LATIN CAPITAL LETTER B
     (?$(0#q(B . ?\xFF23) ;; FULLWIDTH LATIN CAPITAL LETTER C
     (?$(0#r(B . ?\xFF24) ;; FULLWIDTH LATIN CAPITAL LETTER D
     (?$(0#s(B . ?\xFF25) ;; FULLWIDTH LATIN CAPITAL LETTER E
     (?$(0#t(B . ?\xFF26) ;; FULLWIDTH LATIN CAPITAL LETTER F
     (?$(0#u(B . ?\xFF27) ;; FULLWIDTH LATIN CAPITAL LETTER G
     (?$(0#v(B . ?\xFF28) ;; FULLWIDTH LATIN CAPITAL LETTER H
     (?$(0#w(B . ?\xFF29) ;; FULLWIDTH LATIN CAPITAL LETTER I
     (?$(0#x(B . ?\xFF2A) ;; FULLWIDTH LATIN CAPITAL LETTER J
     (?$(0#y(B . ?\xFF2B) ;; FULLWIDTH LATIN CAPITAL LETTER K
     (?$(0#z(B . ?\xFF2C) ;; FULLWIDTH LATIN CAPITAL LETTER L
     (?$(0#{(B . ?\xFF2D) ;; FULLWIDTH LATIN CAPITAL LETTER M
     (?$(0#|(B . ?\xFF2E) ;; FULLWIDTH LATIN CAPITAL LETTER N
     (?$(0#}(B . ?\xFF2F) ;; FULLWIDTH LATIN CAPITAL LETTER O
     (?$(0#~(B . ?\xFF30) ;; FULLWIDTH LATIN CAPITAL LETTER P
     (?$(0$!(B . ?\xFF31) ;; FULLWIDTH LATIN CAPITAL LETTER Q
     (?$(0$"(B . ?\xFF32) ;; FULLWIDTH LATIN CAPITAL LETTER R
     (?$(0$#(B . ?\xFF33) ;; FULLWIDTH LATIN CAPITAL LETTER S
     (?$(0$$(B . ?\xFF34) ;; FULLWIDTH LATIN CAPITAL LETTER T
     (?$(0$%(B . ?\xFF35) ;; FULLWIDTH LATIN CAPITAL LETTER U
     (?$(0$&(B . ?\xFF36) ;; FULLWIDTH LATIN CAPITAL LETTER V
     (?$(0$'(B . ?\xFF37) ;; FULLWIDTH LATIN CAPITAL LETTER W
     (?$(0$((B . ?\xFF38) ;; FULLWIDTH LATIN CAPITAL LETTER X
     (?$(0$)(B . ?\xFF39) ;; FULLWIDTH LATIN CAPITAL LETTER Y
     (?$(0$*(B . ?\xFF3A) ;; FULLWIDTH LATIN CAPITAL LETTER Z
     (?$(0$+(B . ?\xFF41) ;; FULLWIDTH LATIN SMALL LETTER A
     (?$(0$,(B . ?\xFF42) ;; FULLWIDTH LATIN SMALL LETTER B
     (?$(0$-(B . ?\xFF43) ;; FULLWIDTH LATIN SMALL LETTER C
     (?$(0$.(B . ?\xFF44) ;; FULLWIDTH LATIN SMALL LETTER D
     (?$(0$/(B . ?\xFF45) ;; FULLWIDTH LATIN SMALL LETTER E
     (?$(0$0(B . ?\xFF46) ;; FULLWIDTH LATIN SMALL LETTER F
     (?$(0$1(B . ?\xFF47) ;; FULLWIDTH LATIN SMALL LETTER G
     (?$(0$2(B . ?\xFF48) ;; FULLWIDTH LATIN SMALL LETTER H
     (?$(0$3(B . ?\xFF49) ;; FULLWIDTH LATIN SMALL LETTER I
     (?$(0$4(B . ?\xFF4A) ;; FULLWIDTH LATIN SMALL LETTER J
     (?$(0$5(B . ?\xFF4B) ;; FULLWIDTH LATIN SMALL LETTER K
     (?$(0$6(B . ?\xFF4C) ;; FULLWIDTH LATIN SMALL LETTER L
     (?$(0$7(B . ?\xFF4D) ;; FULLWIDTH LATIN SMALL LETTER M
     (?$(0$8(B . ?\xFF4E) ;; FULLWIDTH LATIN SMALL LETTER N
     (?$(0$9(B . ?\xFF4F) ;; FULLWIDTH LATIN SMALL LETTER O
     (?$(0$:(B . ?\xFF50) ;; FULLWIDTH LATIN SMALL LETTER P
     (?$(0$;(B . ?\xFF51) ;; FULLWIDTH LATIN SMALL LETTER Q
     (?$(0$<(B . ?\xFF52) ;; FULLWIDTH LATIN SMALL LETTER R
     (?$(0$=(B . ?\xFF53) ;; FULLWIDTH LATIN SMALL LETTER S
     (?$(0$>(B . ?\xFF54) ;; FULLWIDTH LATIN SMALL LETTER T
     (?$(0$?(B . ?\xFF55) ;; FULLWIDTH LATIN SMALL LETTER U
     (?$(0$@(B . ?\xFF56) ;; FULLWIDTH LATIN SMALL LETTER V
     (?$(0$A(B . ?\xFF57) ;; FULLWIDTH LATIN SMALL LETTER W
     (?$(0$B(B . ?\xFF58) ;; FULLWIDTH LATIN SMALL LETTER X
     (?$(0$C(B . ?\xFF59) ;; FULLWIDTH LATIN SMALL LETTER Y
     (?$(0$D(B . ?\xFF5A) ;; FULLWIDTH LATIN SMALL LETTER Z
     (?$(0$E(B . ?\x0391) ;; GREEK CAPITAL LETTER ALPHA
     (?$(0$F(B . ?\x0392) ;; GREEK CAPITAL LETTER BETA
     (?$(0$G(B . ?\x0393) ;; GREEK CAPITAL LETTER GAMMA
     (?$(0$H(B . ?\x0394) ;; GREEK CAPITAL LETTER DELTA
     (?$(0$I(B . ?\x0395) ;; GREEK CAPITAL LETTER EPSILON
     (?$(0$J(B . ?\x0396) ;; GREEK CAPITAL LETTER ZETA
     (?$(0$K(B . ?\x0397) ;; GREEK CAPITAL LETTER ETA
     (?$(0$L(B . ?\x0398) ;; GREEK CAPITAL LETTER THETA
     (?$(0$M(B . ?\x0399) ;; GREEK CAPITAL LETTER IOTA
     (?$(0$N(B . ?\x039A) ;; GREEK CAPITAL LETTER KAPPA
     (?$(0$O(B . ?\x039B) ;; GREEK CAPITAL LETTER LAMDA
     (?$(0$P(B . ?\x039C) ;; GREEK CAPITAL LETTER MU
     (?$(0$Q(B . ?\x039D) ;; GREEK CAPITAL LETTER NU
     (?$(0$R(B . ?\x039E) ;; GREEK CAPITAL LETTER XI
     (?$(0$S(B . ?\x039F) ;; GREEK CAPITAL LETTER OMICRON
     (?$(0$T(B . ?\x03A0) ;; GREEK CAPITAL LETTER PI
     (?$(0$U(B . ?\x03A1) ;; GREEK CAPITAL LETTER RHO
     (?$(0$V(B . ?\x03A3) ;; GREEK CAPITAL LETTER SIGMA
     (?$(0$W(B . ?\x03A4) ;; GREEK CAPITAL LETTER TAU
     (?$(0$X(B . ?\x03A5) ;; GREEK CAPITAL LETTER UPSILON
     (?$(0$Y(B . ?\x03A6) ;; GREEK CAPITAL LETTER PHI
     (?$(0$Z(B . ?\x03A7) ;; GREEK CAPITAL LETTER CHI
     (?$(0$[(B . ?\x03A8) ;; GREEK CAPITAL LETTER PSI
     (?$(0$\(B . ?\x03A9) ;; GREEK CAPITAL LETTER OMEGA
     (?$(0$](B . ?\x03B1) ;; GREEK SMALL LETTER ALPHA
     (?$(0$^(B . ?\x03B2) ;; GREEK SMALL LETTER BETA
     (?$(0$_(B . ?\x03B3) ;; GREEK SMALL LETTER GAMMA
     (?$(0$`(B . ?\x03B4) ;; GREEK SMALL LETTER DELTA
     (?$(0$a(B . ?\x03B5) ;; GREEK SMALL LETTER EPSILON
     (?$(0$b(B . ?\x03B6) ;; GREEK SMALL LETTER ZETA
     (?$(0$c(B . ?\x03B7) ;; GREEK SMALL LETTER ETA
     (?$(0$d(B . ?\x03B8) ;; GREEK SMALL LETTER THETA
     (?$(0$e(B . ?\x03B9) ;; GREEK SMALL LETTER IOTA
     (?$(0$f(B . ?\x03BA) ;; GREEK SMALL LETTER KAPPA
     (?$(0$g(B . ?\x03BB) ;; GREEK SMALL LETTER LAMDA
     (?$(0$h(B . ?\x03BC) ;; GREEK SMALL LETTER MU
     (?$(0$i(B . ?\x03BD) ;; GREEK SMALL LETTER NU
     (?$(0$j(B . ?\x03BE) ;; GREEK SMALL LETTER XI
     (?$(0$k(B . ?\x03BF) ;; GREEK SMALL LETTER OMICRON
     (?$(0$l(B . ?\x03C0) ;; GREEK SMALL LETTER PI
     (?$(0$m(B . ?\x03C1) ;; GREEK SMALL LETTER RHO
     (?$(0$n(B . ?\x03C3) ;; GREEK SMALL LETTER SIGMA
     (?$(0$o(B . ?\x03C4) ;; GREEK SMALL LETTER TAU
     (?$(0$p(B . ?\x03C5) ;; GREEK SMALL LETTER UPSILON
     (?$(0$q(B . ?\x03C6) ;; GREEK SMALL LETTER PHI
     (?$(0$r(B . ?\x03C7) ;; GREEK SMALL LETTER CHI
     (?$(0$s(B . ?\x03C8) ;; GREEK SMALL LETTER PSI
     (?$(0$t(B . ?\x03C9) ;; GREEK SMALL LETTER OMEGA
     (?$(0$u(B . ?\x3105) ;; BOPOMOFO LETTER B
     (?$(0$v(B . ?\x3106) ;; BOPOMOFO LETTER P
     (?$(0$w(B . ?\x3107) ;; BOPOMOFO LETTER M
     (?$(0$x(B . ?\x3108) ;; BOPOMOFO LETTER F
     (?$(0$y(B . ?\x3109) ;; BOPOMOFO LETTER D
     (?$(0$z(B . ?\x310A) ;; BOPOMOFO LETTER T
     (?$(0${(B . ?\x310B) ;; BOPOMOFO LETTER N
     (?$(0$|(B . ?\x310C) ;; BOPOMOFO LETTER L
     (?$(0$}(B . ?\x310D) ;; BOPOMOFO LETTER G
     (?$(0$~(B . ?\x310E) ;; BOPOMOFO LETTER K
     (?$(0%!(B . ?\x310F) ;; BOPOMOFO LETTER H
     (?$(0%"(B . ?\x3110) ;; BOPOMOFO LETTER J
     (?$(0%#(B . ?\x3111) ;; BOPOMOFO LETTER Q
     (?$(0%$(B . ?\x3112) ;; BOPOMOFO LETTER X
     (?$(0%%(B . ?\x3113) ;; BOPOMOFO LETTER ZH
     (?$(0%&(B . ?\x3114) ;; BOPOMOFO LETTER CH
     (?$(0%'(B . ?\x3115) ;; BOPOMOFO LETTER SH
     (?$(0%((B . ?\x3116) ;; BOPOMOFO LETTER R
     (?$(0%)(B . ?\x3117) ;; BOPOMOFO LETTER Z
     (?$(0%*(B . ?\x3118) ;; BOPOMOFO LETTER C
     (?$(0%+(B . ?\x3119) ;; BOPOMOFO LETTER S
     (?$(0%,(B . ?\x311A) ;; BOPOMOFO LETTER A
     (?$(0%-(B . ?\x311B) ;; BOPOMOFO LETTER O
     (?$(0%.(B . ?\x311C) ;; BOPOMOFO LETTER E
     (?$(0%/(B . ?\x311D) ;; BOPOMOFO LETTER EH
     (?$(0%0(B . ?\x311E) ;; BOPOMOFO LETTER AI
     (?$(0%1(B . ?\x311F) ;; BOPOMOFO LETTER EI
     (?$(0%2(B . ?\x3120) ;; BOPOMOFO LETTER AU
     (?$(0%3(B . ?\x3121) ;; BOPOMOFO LETTER OU
     (?$(0%4(B . ?\x3122) ;; BOPOMOFO LETTER AN
     (?$(0%5(B . ?\x3123) ;; BOPOMOFO LETTER EN
     (?$(0%6(B . ?\x3124) ;; BOPOMOFO LETTER ANG
     (?$(0%7(B . ?\x3125) ;; BOPOMOFO LETTER ENG
     (?$(0%8(B . ?\x3126) ;; BOPOMOFO LETTER ER
     (?$(0%9(B . ?\x3127) ;; BOPOMOFO LETTER I
     (?$(0%:(B . ?\x3128) ;; BOPOMOFO LETTER U
     (?$(0%;(B . ?\x3129) ;; BOPOMOFO LETTER IU
     (?$(0%<(B . ?\x02D9) ;; DOT ABOVE (Mandarin Chinese light tone)
     (?$(0%=(B . ?\x02C9) ;; MODIFIER LETTER MACRON (Mandarin Chinese first tone)
     (?$(0%>(B . ?\x02CA) ;; MODIFIER LETTER ACUTE ACCENT (Mandarin Chinese second tone)
     (?$(0%?(B . ?\x02C7) ;; CARON (Mandarin Chinese third tone)
     (?$(0%@(B . ?\x02CB) ;; MODIFIER LETTER GRAVE ACCENT (Mandarin Chinese fourth tone)
     (?$(0&"(B . ?\x4E00) ;; <CJK>
     (?$(0&#(B . ?\x4E59) ;; <CJK>
     (?$(0&$(B . ?\x4E01) ;; <CJK>
     (?$(0&%(B . ?\x4E03) ;; <CJK>
     (?$(0&&(B . ?\x4E43) ;; <CJK>
     (?$(0&'(B . ?\x4E5D) ;; <CJK>
     (?$(0&((B . ?\x4E86) ;; <CJK>
     (?$(0&)(B . ?\x4E8C) ;; <CJK>
     (?$(0&*(B . ?\x4EBA) ;; <CJK>
     (?$(0&+(B . ?\x513F) ;; <CJK>
     (?$(0&,(B . ?\x5165) ;; <CJK>
     (?$(0&-(B . ?\x516B) ;; <CJK>
     (?$(0&.(B . ?\x51E0) ;; <CJK>
     (?$(0&/(B . ?\x5200) ;; <CJK>
     (?$(0&0(B . ?\x5201) ;; <CJK>
     (?$(0&1(B . ?\x529B) ;; <CJK>
     (?$(0&2(B . ?\x5315) ;; <CJK>
     (?$(0&3(B . ?\x5341) ;; <CJK>
     (?$(0&4(B . ?\x535C) ;; <CJK>
     (?$(0&5(B . ?\x53C8) ;; <CJK>
     (?$(0&6(B . ?\x4E09) ;; <CJK>
     (?$(0&7(B . ?\x4E0B) ;; <CJK>
     (?$(0&8(B . ?\x4E08) ;; <CJK>
     (?$(0&9(B . ?\x4E0A) ;; <CJK>
     (?$(0&:(B . ?\x4E2B) ;; <CJK>
     (?$(0&;(B . ?\x4E38) ;; <CJK>
     (?$(0&<(B . ?\x51E1) ;; <CJK>
     (?$(0&=(B . ?\x4E45) ;; <CJK>
     (?$(0&>(B . ?\x4E48) ;; <CJK>
     (?$(0&?(B . ?\x4E5F) ;; <CJK>
     (?$(0&@(B . ?\x4E5E) ;; <CJK>
     (?$(0&A(B . ?\x4E8E) ;; <CJK>
     (?$(0&B(B . ?\x4EA1) ;; <CJK>
     (?$(0&C(B . ?\x5140) ;; <CJK>
     (?$(0&D(B . ?\x5203) ;; <CJK>
     (?$(0&E(B . ?\x52FA) ;; <CJK>
     (?$(0&F(B . ?\x5343) ;; <CJK>
     (?$(0&G(B . ?\x53C9) ;; <CJK>
     (?$(0&H(B . ?\x53E3) ;; <CJK>
     (?$(0&I(B . ?\x571F) ;; <CJK>
     (?$(0&J(B . ?\x58EB) ;; <CJK>
     (?$(0&K(B . ?\x5915) ;; <CJK>
     (?$(0&L(B . ?\x5927) ;; <CJK>
     (?$(0&M(B . ?\x5973) ;; <CJK>
     (?$(0&N(B . ?\x5B50) ;; <CJK>
     (?$(0&O(B . ?\x5B51) ;; <CJK>
     (?$(0&P(B . ?\x5B53) ;; <CJK>
     (?$(0&Q(B . ?\x5BF8) ;; <CJK>
     (?$(0&R(B . ?\x5C0F) ;; <CJK>
     (?$(0&S(B . ?\x5C22) ;; <CJK>
     (?$(0&T(B . ?\x5C38) ;; <CJK>
     (?$(0&U(B . ?\x5C71) ;; <CJK>
     (?$(0&V(B . ?\x5DDD) ;; <CJK>
     (?$(0&W(B . ?\x5DE5) ;; <CJK>
     (?$(0&X(B . ?\x5DF1) ;; <CJK>
     (?$(0&Y(B . ?\x5DF2) ;; <CJK>
     (?$(0&Z(B . ?\x5DF3) ;; <CJK>
     (?$(0&[(B . ?\x5DFE) ;; <CJK>
     (?$(0&\(B . ?\x5E72) ;; <CJK>
     (?$(0&](B . ?\x5EFE) ;; <CJK>
     (?$(0&^(B . ?\x5F0B) ;; <CJK>
     (?$(0&_(B . ?\x5F13) ;; <CJK>
     (?$(0&`(B . ?\x624D) ;; <CJK>
     (?$(0&a(B . ?\x4E11) ;; <CJK>
     (?$(0&b(B . ?\x4E10) ;; <CJK>
     (?$(0&c(B . ?\x4E0D) ;; <CJK>
     (?$(0&d(B . ?\x4E2D) ;; <CJK>
     (?$(0&e(B . ?\x4E30) ;; <CJK>
     (?$(0&f(B . ?\x4E39) ;; <CJK>
     (?$(0&g(B . ?\x4E4B) ;; <CJK>
     (?$(0&h(B . ?\x5C39) ;; <CJK>
     (?$(0&i(B . ?\x4E88) ;; <CJK>
     (?$(0&j(B . ?\x4E91) ;; <CJK>
     (?$(0&k(B . ?\x4E95) ;; <CJK>
     (?$(0&l(B . ?\x4E92) ;; <CJK>
     (?$(0&m(B . ?\x4E94) ;; <CJK>
     (?$(0&n(B . ?\x4EA2) ;; <CJK>
     (?$(0&o(B . ?\x4EC1) ;; <CJK>
     (?$(0&p(B . ?\x4EC0) ;; <CJK>
     (?$(0&q(B . ?\x4EC3) ;; <CJK>
     (?$(0&r(B . ?\x4EC6) ;; <CJK>
     (?$(0&s(B . ?\x4EC7) ;; <CJK>
     (?$(0&t(B . ?\x4ECD) ;; <CJK>
     (?$(0&u(B . ?\x4ECA) ;; <CJK>
     (?$(0&v(B . ?\x4ECB) ;; <CJK>
     (?$(0&w(B . ?\x4EC4) ;; <CJK>
     (?$(0&x(B . ?\x5143) ;; <CJK>
     (?$(0&y(B . ?\x5141) ;; <CJK>
     (?$(0&z(B . ?\x5167) ;; <CJK>
     (?$(0&{(B . ?\x516D) ;; <CJK>
     (?$(0&|(B . ?\x516E) ;; <CJK>
     (?$(0&}(B . ?\x516C) ;; <CJK>
     (?$(0&~(B . ?\x5197) ;; <CJK>
     (?$(0'!(B . ?\x51F6) ;; <CJK>
     (?$(0'"(B . ?\x5206) ;; <CJK>
     (?$(0'#(B . ?\x5207) ;; <CJK>
     (?$(0'$(B . ?\x5208) ;; <CJK>
     (?$(0'%(B . ?\x52FB) ;; <CJK>
     (?$(0'&(B . ?\x52FE) ;; <CJK>
     (?$(0''(B . ?\x52FF) ;; <CJK>
     (?$(0'((B . ?\x5316) ;; <CJK>
     (?$(0')(B . ?\x5339) ;; <CJK>
     (?$(0'*(B . ?\x5348) ;; <CJK>
     (?$(0'+(B . ?\x5347) ;; <CJK>
     (?$(0',(B . ?\x5345) ;; <CJK>
     (?$(0'-(B . ?\x535E) ;; <CJK>
     (?$(0'.(B . ?\x5384) ;; <CJK>
     (?$(0'/(B . ?\x53CB) ;; <CJK>
     (?$(0'0(B . ?\x53CA) ;; <CJK>
     (?$(0'1(B . ?\x53CD) ;; <CJK>
     (?$(0'2(B . ?\x58EC) ;; <CJK>
     (?$(0'3(B . ?\x5929) ;; <CJK>
     (?$(0'4(B . ?\x592B) ;; <CJK>
     (?$(0'5(B . ?\x592A) ;; <CJK>
     (?$(0'6(B . ?\x592D) ;; <CJK>
     (?$(0'7(B . ?\x5B54) ;; <CJK>
     (?$(0'8(B . ?\x5C11) ;; <CJK>
     (?$(0'9(B . ?\x5C24) ;; <CJK>
     (?$(0':(B . ?\x5C3A) ;; <CJK>
     (?$(0';(B . ?\x5C6F) ;; <CJK>
     (?$(0'<(B . ?\x5DF4) ;; <CJK>
     (?$(0'=(B . ?\x5E7B) ;; <CJK>
     (?$(0'>(B . ?\x5EFF) ;; <CJK>
     (?$(0'?(B . ?\x5F14) ;; <CJK>
     (?$(0'@(B . ?\x5F15) ;; <CJK>
     (?$(0'A(B . ?\x5FC3) ;; <CJK>
     (?$(0'B(B . ?\x6208) ;; <CJK>
     (?$(0'C(B . ?\x6236) ;; <CJK>
     (?$(0'D(B . ?\x624B) ;; <CJK>
     (?$(0'E(B . ?\x624E) ;; <CJK>
     (?$(0'F(B . ?\x652F) ;; <CJK>
     (?$(0'G(B . ?\x6587) ;; <CJK>
     (?$(0'H(B . ?\x6597) ;; <CJK>
     (?$(0'I(B . ?\x65A4) ;; <CJK>
     (?$(0'J(B . ?\x65B9) ;; <CJK>
     (?$(0'K(B . ?\x65E5) ;; <CJK>
     (?$(0'L(B . ?\x66F0) ;; <CJK>
     (?$(0'M(B . ?\x6708) ;; <CJK>
     (?$(0'N(B . ?\x6728) ;; <CJK>
     (?$(0'O(B . ?\x6B20) ;; <CJK>
     (?$(0'P(B . ?\x6B62) ;; <CJK>
     (?$(0'Q(B . ?\x6B79) ;; <CJK>
     (?$(0'R(B . ?\x6BCB) ;; <CJK>
     (?$(0'S(B . ?\x6BD4) ;; <CJK>
     (?$(0'T(B . ?\x6BDB) ;; <CJK>
     (?$(0'U(B . ?\x6C0F) ;; <CJK>
     (?$(0'V(B . ?\x6C34) ;; <CJK>
     (?$(0'W(B . ?\x706B) ;; <CJK>
     (?$(0'X(B . ?\x722A) ;; <CJK>
     (?$(0'Y(B . ?\x7236) ;; <CJK>
     (?$(0'Z(B . ?\x723B) ;; <CJK>
     (?$(0'[(B . ?\x7247) ;; <CJK>
     (?$(0'\(B . ?\x7259) ;; <CJK>
     (?$(0'](B . ?\x725B) ;; <CJK>
     (?$(0'^(B . ?\x72AC) ;; <CJK>
     (?$(0'_(B . ?\x738B) ;; <CJK>
     (?$(0'`(B . ?\x4E19) ;; <CJK>
     (?$(0'a(B . ?\x4E16) ;; <CJK>
     (?$(0'b(B . ?\x4E15) ;; <CJK>
     (?$(0'c(B . ?\x4E14) ;; <CJK>
     (?$(0'd(B . ?\x4E18) ;; <CJK>
     (?$(0'e(B . ?\x4E3B) ;; <CJK>
     (?$(0'f(B . ?\x4E4D) ;; <CJK>
     (?$(0'g(B . ?\x4E4F) ;; <CJK>
     (?$(0'h(B . ?\x4E4E) ;; <CJK>
     (?$(0'i(B . ?\x4EE5) ;; <CJK>
     (?$(0'j(B . ?\x4ED8) ;; <CJK>
     (?$(0'k(B . ?\x4ED4) ;; <CJK>
     (?$(0'l(B . ?\x4ED5) ;; <CJK>
     (?$(0'm(B . ?\x4ED6) ;; <CJK>
     (?$(0'n(B . ?\x4ED7) ;; <CJK>
     (?$(0'o(B . ?\x4EE3) ;; <CJK>
     (?$(0'p(B . ?\x4EE4) ;; <CJK>
     (?$(0'q(B . ?\x4ED9) ;; <CJK>
     (?$(0'r(B . ?\x4EDE) ;; <CJK>
     (?$(0's(B . ?\x5145) ;; <CJK>
     (?$(0't(B . ?\x5144) ;; <CJK>
     (?$(0'u(B . ?\x5189) ;; <CJK>
     (?$(0'v(B . ?\x518A) ;; <CJK>
     (?$(0'w(B . ?\x51AC) ;; <CJK>
     (?$(0'x(B . ?\x51F9) ;; <CJK>
     (?$(0'y(B . ?\x51FA) ;; <CJK>
     (?$(0'z(B . ?\x51F8) ;; <CJK>
     (?$(0'{(B . ?\x520A) ;; <CJK>
     (?$(0'|(B . ?\x52A0) ;; <CJK>
     (?$(0'}(B . ?\x529F) ;; <CJK>
     (?$(0'~(B . ?\x5305) ;; <CJK>
     (?$(0(!(B . ?\x5306) ;; <CJK>
     (?$(0("(B . ?\x5317) ;; <CJK>
     (?$(0(#(B . ?\x531D) ;; <CJK>
     (?$(0($(B . ?\x4EDF) ;; <CJK>
     (?$(0(%(B . ?\x534A) ;; <CJK>
     (?$(0(&(B . ?\x5349) ;; <CJK>
     (?$(0('(B . ?\x5361) ;; <CJK>
     (?$(0(((B . ?\x5360) ;; <CJK>
     (?$(0()(B . ?\x536F) ;; <CJK>
     (?$(0(*(B . ?\x536E) ;; <CJK>
     (?$(0(+(B . ?\x53BB) ;; <CJK>
     (?$(0(,(B . ?\x53EF) ;; <CJK>
     (?$(0(-(B . ?\x53E4) ;; <CJK>
     (?$(0(.(B . ?\x53F3) ;; <CJK>
     (?$(0(/(B . ?\x53EC) ;; <CJK>
     (?$(0(0(B . ?\x53EE) ;; <CJK>
     (?$(0(1(B . ?\x53E9) ;; <CJK>
     (?$(0(2(B . ?\x53E8) ;; <CJK>
     (?$(0(3(B . ?\x53FC) ;; <CJK>
     (?$(0(4(B . ?\x53F8) ;; <CJK>
     (?$(0(5(B . ?\x53F5) ;; <CJK>
     (?$(0(6(B . ?\x53EB) ;; <CJK>
     (?$(0(7(B . ?\x53E6) ;; <CJK>
     (?$(0(8(B . ?\x53EA) ;; <CJK>
     (?$(0(9(B . ?\x53F2) ;; <CJK>
     (?$(0(:(B . ?\x53F1) ;; <CJK>
     (?$(0(;(B . ?\x53F0) ;; <CJK>
     (?$(0(<(B . ?\x53E5) ;; <CJK>
     (?$(0(=(B . ?\x53ED) ;; <CJK>
     (?$(0(>(B . ?\x53FB) ;; <CJK>
     (?$(0(?(B . ?\x56DB) ;; <CJK>
     (?$(0(@(B . ?\x56DA) ;; <CJK>
     (?$(0(A(B . ?\x5916) ;; <CJK>
     (?$(0(B(B . ?\x592E) ;; <CJK>
     (?$(0(C(B . ?\x5931) ;; <CJK>
     (?$(0(D(B . ?\x5974) ;; <CJK>
     (?$(0(E(B . ?\x5976) ;; <CJK>
     (?$(0(F(B . ?\x5B55) ;; <CJK>
     (?$(0(G(B . ?\x5B83) ;; <CJK>
     (?$(0(H(B . ?\x5C3C) ;; <CJK>
     (?$(0(I(B . ?\x5DE8) ;; <CJK>
     (?$(0(J(B . ?\x5DE7) ;; <CJK>
     (?$(0(K(B . ?\x5DE6) ;; <CJK>
     (?$(0(L(B . ?\x5E02) ;; <CJK>
     (?$(0(M(B . ?\x5E03) ;; <CJK>
     (?$(0(N(B . ?\x5E73) ;; <CJK>
     (?$(0(O(B . ?\x5E7C) ;; <CJK>
     (?$(0(P(B . ?\x5F01) ;; <CJK>
     (?$(0(Q(B . ?\x5F18) ;; <CJK>
     (?$(0(R(B . ?\x5F17) ;; <CJK>
     (?$(0(S(B . ?\x5FC5) ;; <CJK>
     (?$(0(T(B . ?\x620A) ;; <CJK>
     (?$(0(U(B . ?\x6253) ;; <CJK>
     (?$(0(V(B . ?\x6254) ;; <CJK>
     (?$(0(W(B . ?\x6252) ;; <CJK>
     (?$(0(X(B . ?\x6251) ;; <CJK>
     (?$(0(Y(B . ?\x65A5) ;; <CJK>
     (?$(0(Z(B . ?\x65E6) ;; <CJK>
     (?$(0([(B . ?\x672E) ;; <CJK>
     (?$(0(\(B . ?\x672C) ;; <CJK>
     (?$(0(](B . ?\x672A) ;; <CJK>
     (?$(0(^(B . ?\x672B) ;; <CJK>
     (?$(0(_(B . ?\x672D) ;; <CJK>
     (?$(0(`(B . ?\x6B63) ;; <CJK>
     (?$(0(a(B . ?\x6BCD) ;; <CJK>
     (?$(0(b(B . ?\x6C11) ;; <CJK>
     (?$(0(c(B . ?\x6C10) ;; <CJK>
     (?$(0(d(B . ?\x6C38) ;; <CJK>
     (?$(0(e(B . ?\x6C41) ;; <CJK>
     (?$(0(f(B . ?\x6C40) ;; <CJK>
     (?$(0(g(B . ?\x6C3E) ;; <CJK>
     (?$(0(h(B . ?\x72AF) ;; <CJK>
     (?$(0(i(B . ?\x7384) ;; <CJK>
     (?$(0(j(B . ?\x7389) ;; <CJK>
     (?$(0(k(B . ?\x74DC) ;; <CJK>
     (?$(0(l(B . ?\x74E6) ;; <CJK>
     (?$(0(m(B . ?\x7518) ;; <CJK>
     (?$(0(n(B . ?\x751F) ;; <CJK>
     (?$(0(o(B . ?\x7528) ;; <CJK>
     (?$(0(p(B . ?\x7529) ;; <CJK>
     (?$(0(q(B . ?\x7530) ;; <CJK>
     (?$(0(r(B . ?\x7531) ;; <CJK>
     (?$(0(s(B . ?\x7532) ;; <CJK>
     (?$(0(t(B . ?\x7533) ;; <CJK>
     (?$(0(u(B . ?\x758B) ;; <CJK>
     (?$(0(v(B . ?\x767D) ;; <CJK>
     (?$(0(w(B . ?\x76AE) ;; <CJK>
     (?$(0(x(B . ?\x76BF) ;; <CJK>
     (?$(0(y(B . ?\x76EE) ;; <CJK>
     (?$(0(z(B . ?\x77DB) ;; <CJK>
     (?$(0({(B . ?\x77E2) ;; <CJK>
     (?$(0(|(B . ?\x77F3) ;; <CJK>
     (?$(0(}(B . ?\x793A) ;; <CJK>
     (?$(0(~(B . ?\x79BE) ;; <CJK>
     (?$(0)!(B . ?\x7A74) ;; <CJK>
     (?$(0)"(B . ?\x7ACB) ;; <CJK>
     (?$(0)#(B . ?\x4E1E) ;; <CJK>
     (?$(0)$(B . ?\x4E1F) ;; <CJK>
     (?$(0)%(B . ?\x4E52) ;; <CJK>
     (?$(0)&(B . ?\x4E53) ;; <CJK>
     (?$(0)'(B . ?\x4E69) ;; <CJK>
     (?$(0)((B . ?\x4E99) ;; <CJK>
     (?$(0))(B . ?\x4EA4) ;; <CJK>
     (?$(0)*(B . ?\x4EA6) ;; <CJK>
     (?$(0)+(B . ?\x4EA5) ;; <CJK>
     (?$(0),(B . ?\x4EFF) ;; <CJK>
     (?$(0)-(B . ?\x4F09) ;; <CJK>
     (?$(0).(B . ?\x4F19) ;; <CJK>
     (?$(0)/(B . ?\x4F0A) ;; <CJK>
     (?$(0)0(B . ?\x4F15) ;; <CJK>
     (?$(0)1(B . ?\x4F0D) ;; <CJK>
     (?$(0)2(B . ?\x4F10) ;; <CJK>
     (?$(0)3(B . ?\x4F11) ;; <CJK>
     (?$(0)4(B . ?\x4F0F) ;; <CJK>
     (?$(0)5(B . ?\x4EF2) ;; <CJK>
     (?$(0)6(B . ?\x4EF6) ;; <CJK>
     (?$(0)7(B . ?\x4EFB) ;; <CJK>
     (?$(0)8(B . ?\x4EF0) ;; <CJK>
     (?$(0)9(B . ?\x4EF3) ;; <CJK>
     (?$(0):(B . ?\x4EFD) ;; <CJK>
     (?$(0);(B . ?\x4F01) ;; <CJK>
     (?$(0)<(B . ?\x4F0B) ;; <CJK>
     (?$(0)=(B . ?\x5149) ;; <CJK>
     (?$(0)>(B . ?\x5147) ;; <CJK>
     (?$(0)?(B . ?\x5146) ;; <CJK>
     (?$(0)@(B . ?\x5148) ;; <CJK>
     (?$(0)A(B . ?\x5168) ;; <CJK>
     (?$(0)B(B . ?\x5171) ;; <CJK>
     (?$(0)C(B . ?\x518D) ;; <CJK>
     (?$(0)D(B . ?\x51B0) ;; <CJK>
     (?$(0)E(B . ?\x5217) ;; <CJK>
     (?$(0)F(B . ?\x5211) ;; <CJK>
     (?$(0)G(B . ?\x5212) ;; <CJK>
     (?$(0)H(B . ?\x520E) ;; <CJK>
     (?$(0)I(B . ?\x5216) ;; <CJK>
     (?$(0)J(B . ?\x52A3) ;; <CJK>
     (?$(0)K(B . ?\x5308) ;; <CJK>
     (?$(0)L(B . ?\x5321) ;; <CJK>
     (?$(0)M(B . ?\x5320) ;; <CJK>
     (?$(0)N(B . ?\x5370) ;; <CJK>
     (?$(0)O(B . ?\x5371) ;; <CJK>
     (?$(0)P(B . ?\x5409) ;; <CJK>
     (?$(0)Q(B . ?\x540F) ;; <CJK>
     (?$(0)R(B . ?\x540C) ;; <CJK>
     (?$(0)S(B . ?\x540A) ;; <CJK>
     (?$(0)T(B . ?\x5410) ;; <CJK>
     (?$(0)U(B . ?\x5401) ;; <CJK>
     (?$(0)V(B . ?\x540B) ;; <CJK>
     (?$(0)W(B . ?\x5404) ;; <CJK>
     (?$(0)X(B . ?\x5411) ;; <CJK>
     (?$(0)Y(B . ?\x540D) ;; <CJK>
     (?$(0)Z(B . ?\x5408) ;; <CJK>
     (?$(0)[(B . ?\x5403) ;; <CJK>
     (?$(0)\(B . ?\x540E) ;; <CJK>
     (?$(0)](B . ?\x5406) ;; <CJK>
     (?$(0)^(B . ?\x5412) ;; <CJK>
     (?$(0)_(B . ?\x56E0) ;; <CJK>
     (?$(0)`(B . ?\x56DE) ;; <CJK>
     (?$(0)a(B . ?\x56DD) ;; <CJK>
     (?$(0)b(B . ?\x5733) ;; <CJK>
     (?$(0)c(B . ?\x5730) ;; <CJK>
     (?$(0)d(B . ?\x5728) ;; <CJK>
     (?$(0)e(B . ?\x572D) ;; <CJK>
     (?$(0)f(B . ?\x572C) ;; <CJK>
     (?$(0)g(B . ?\x572F) ;; <CJK>
     (?$(0)h(B . ?\x5729) ;; <CJK>
     (?$(0)i(B . ?\x5919) ;; <CJK>
     (?$(0)j(B . ?\x591A) ;; <CJK>
     (?$(0)k(B . ?\x5937) ;; <CJK>
     (?$(0)l(B . ?\x5938) ;; <CJK>
     (?$(0)m(B . ?\x5984) ;; <CJK>
     (?$(0)n(B . ?\x5978) ;; <CJK>
     (?$(0)o(B . ?\x5983) ;; <CJK>
     (?$(0)p(B . ?\x597D) ;; <CJK>
     (?$(0)q(B . ?\x5979) ;; <CJK>
     (?$(0)r(B . ?\x5982) ;; <CJK>
     (?$(0)s(B . ?\x5981) ;; <CJK>
     (?$(0)t(B . ?\x5B57) ;; <CJK>
     (?$(0)u(B . ?\x5B58) ;; <CJK>
     (?$(0)v(B . ?\x5B87) ;; <CJK>
     (?$(0)w(B . ?\x5B88) ;; <CJK>
     (?$(0)x(B . ?\x5B85) ;; <CJK>
     (?$(0)y(B . ?\x5B89) ;; <CJK>
     (?$(0)z(B . ?\x5BFA) ;; <CJK>
     (?$(0){(B . ?\x5C16) ;; <CJK>
     (?$(0)|(B . ?\x5C79) ;; <CJK>
     (?$(0)}(B . ?\x5DDE) ;; <CJK>
     (?$(0)~(B . ?\x5E06) ;; <CJK>
     (?$(0*!(B . ?\x5E76) ;; <CJK>
     (?$(0*"(B . ?\x5E74) ;; <CJK>
     (?$(0*#(B . ?\x5F0F) ;; <CJK>
     (?$(0*$(B . ?\x5F1B) ;; <CJK>
     (?$(0*%(B . ?\x5FD9) ;; <CJK>
     (?$(0*&(B . ?\x5FD6) ;; <CJK>
     (?$(0*'(B . ?\x620E) ;; <CJK>
     (?$(0*((B . ?\x620C) ;; <CJK>
     (?$(0*)(B . ?\x620D) ;; <CJK>
     (?$(0**(B . ?\x6210) ;; <CJK>
     (?$(0*+(B . ?\x6263) ;; <CJK>
     (?$(0*,(B . ?\x625B) ;; <CJK>
     (?$(0*-(B . ?\x6258) ;; <CJK>
     (?$(0*.(B . ?\x6536) ;; <CJK>
     (?$(0*/(B . ?\x65E9) ;; <CJK>
     (?$(0*0(B . ?\x65E8) ;; <CJK>
     (?$(0*1(B . ?\x65EC) ;; <CJK>
     (?$(0*2(B . ?\x65ED) ;; <CJK>
     (?$(0*3(B . ?\x66F2) ;; <CJK>
     (?$(0*4(B . ?\x66F3) ;; <CJK>
     (?$(0*5(B . ?\x6709) ;; <CJK>
     (?$(0*6(B . ?\x673D) ;; <CJK>
     (?$(0*7(B . ?\x6734) ;; <CJK>
     (?$(0*8(B . ?\x6731) ;; <CJK>
     (?$(0*9(B . ?\x6735) ;; <CJK>
     (?$(0*:(B . ?\x6B21) ;; <CJK>
     (?$(0*;(B . ?\x6B64) ;; <CJK>
     (?$(0*<(B . ?\x6B7B) ;; <CJK>
     (?$(0*=(B . ?\x6C16) ;; <CJK>
     (?$(0*>(B . ?\x6C5D) ;; <CJK>
     (?$(0*?(B . ?\x6C57) ;; <CJK>
     (?$(0*@(B . ?\x6C59) ;; <CJK>
     (?$(0*A(B . ?\x6C5F) ;; <CJK>
     (?$(0*B(B . ?\x6C60) ;; <CJK>
     (?$(0*C(B . ?\x6C50) ;; <CJK>
     (?$(0*D(B . ?\x6C55) ;; <CJK>
     (?$(0*E(B . ?\x6C61) ;; <CJK>
     (?$(0*F(B . ?\x6C5B) ;; <CJK>
     (?$(0*G(B . ?\x6C4D) ;; <CJK>
     (?$(0*H(B . ?\x6C4E) ;; <CJK>
     (?$(0*I(B . ?\x7070) ;; <CJK>
     (?$(0*J(B . ?\x725F) ;; <CJK>
     (?$(0*K(B . ?\x725D) ;; <CJK>
     (?$(0*L(B . ?\x767E) ;; <CJK>
     (?$(0*M(B . ?\x7AF9) ;; <CJK>
     (?$(0*N(B . ?\x7C73) ;; <CJK>
     (?$(0*O(B . ?\x7CF8) ;; <CJK>
     (?$(0*P(B . ?\x7F36) ;; <CJK>
     (?$(0*Q(B . ?\x7F8A) ;; <CJK>
     (?$(0*R(B . ?\x7FBD) ;; <CJK>
     (?$(0*S(B . ?\x8001) ;; <CJK>
     (?$(0*T(B . ?\x8003) ;; <CJK>
     (?$(0*U(B . ?\x800C) ;; <CJK>
     (?$(0*V(B . ?\x8012) ;; <CJK>
     (?$(0*W(B . ?\x8033) ;; <CJK>
     (?$(0*X(B . ?\x807F) ;; <CJK>
     (?$(0*Y(B . ?\x8089) ;; <CJK>
     (?$(0*Z(B . ?\x808B) ;; <CJK>
     (?$(0*[(B . ?\x808C) ;; <CJK>
     (?$(0*\(B . ?\x81E3) ;; <CJK>
     (?$(0*](B . ?\x81EA) ;; <CJK>
     (?$(0*^(B . ?\x81F3) ;; <CJK>
     (?$(0*_(B . ?\x81FC) ;; <CJK>
     (?$(0*`(B . ?\x820C) ;; <CJK>
     (?$(0*a(B . ?\x821B) ;; <CJK>
     (?$(0*b(B . ?\x821F) ;; <CJK>
     (?$(0*c(B . ?\x826E) ;; <CJK>
     (?$(0*d(B . ?\x8272) ;; <CJK>
     (?$(0*e(B . ?\x827E) ;; <CJK>
     (?$(0*f(B . ?\x866B) ;; <CJK>
     (?$(0*g(B . ?\x8840) ;; <CJK>
     (?$(0*h(B . ?\x884C) ;; <CJK>
     (?$(0*i(B . ?\x8863) ;; <CJK>
     (?$(0*j(B . ?\x897F) ;; <CJK>
     (?$(0*k(B . ?\x9621) ;; <CJK>
     (?$(0*l(B . ?\x4E32) ;; <CJK>
     (?$(0*m(B . ?\x4EA8) ;; <CJK>
     (?$(0*n(B . ?\x4F4D) ;; <CJK>
     (?$(0*o(B . ?\x4F4F) ;; <CJK>
     (?$(0*p(B . ?\x4F47) ;; <CJK>
     (?$(0*q(B . ?\x4F57) ;; <CJK>
     (?$(0*r(B . ?\x4F5E) ;; <CJK>
     (?$(0*s(B . ?\x4F34) ;; <CJK>
     (?$(0*t(B . ?\x4F5B) ;; <CJK>
     (?$(0*u(B . ?\x4F55) ;; <CJK>
     (?$(0*v(B . ?\x4F30) ;; <CJK>
     (?$(0*w(B . ?\x4F50) ;; <CJK>
     (?$(0*x(B . ?\x4F51) ;; <CJK>
     (?$(0*y(B . ?\x4F3D) ;; <CJK>
     (?$(0*z(B . ?\x4F3A) ;; <CJK>
     (?$(0*{(B . ?\x4F38) ;; <CJK>
     (?$(0*|(B . ?\x4F43) ;; <CJK>
     (?$(0*}(B . ?\x4F54) ;; <CJK>
     (?$(0*~(B . ?\x4F3C) ;; <CJK>
     (?$(0+!(B . ?\x4F46) ;; <CJK>
     (?$(0+"(B . ?\x4F63) ;; <CJK>
     (?$(0+#(B . ?\x4F5C) ;; <CJK>
     (?$(0+$(B . ?\x4F60) ;; <CJK>
     (?$(0+%(B . ?\x4F2F) ;; <CJK>
     (?$(0+&(B . ?\x4F4E) ;; <CJK>
     (?$(0+'(B . ?\x4F36) ;; <CJK>
     (?$(0+((B . ?\x4F59) ;; <CJK>
     (?$(0+)(B . ?\x4F5D) ;; <CJK>
     (?$(0+*(B . ?\x4F48) ;; <CJK>
     (?$(0++(B . ?\x4F5A) ;; <CJK>
     (?$(0+,(B . ?\x514C) ;; <CJK>
     (?$(0+-(B . ?\x514B) ;; <CJK>
     (?$(0+.(B . ?\x514D) ;; <CJK>
     (?$(0+/(B . ?\x5175) ;; <CJK>
     (?$(0+0(B . ?\x51B6) ;; <CJK>
     (?$(0+1(B . ?\x51B7) ;; <CJK>
     (?$(0+2(B . ?\x5225) ;; <CJK>
     (?$(0+3(B . ?\x5224) ;; <CJK>
     (?$(0+4(B . ?\x5229) ;; <CJK>
     (?$(0+5(B . ?\x522A) ;; <CJK>
     (?$(0+6(B . ?\x5228) ;; <CJK>
     (?$(0+7(B . ?\x52AB) ;; <CJK>
     (?$(0+8(B . ?\x52A9) ;; <CJK>
     (?$(0+9(B . ?\x52AA) ;; <CJK>
     (?$(0+:(B . ?\x52AC) ;; <CJK>
     (?$(0+;(B . ?\x5323) ;; <CJK>
     (?$(0+<(B . ?\x5373) ;; <CJK>
     (?$(0+=(B . ?\x5375) ;; <CJK>
     (?$(0+>(B . ?\x541D) ;; <CJK>
     (?$(0+?(B . ?\x542D) ;; <CJK>
     (?$(0+@(B . ?\x541E) ;; <CJK>
     (?$(0+A(B . ?\x543E) ;; <CJK>
     (?$(0+B(B . ?\x5426) ;; <CJK>
     (?$(0+C(B . ?\x544E) ;; <CJK>
     (?$(0+D(B . ?\x5427) ;; <CJK>
     (?$(0+E(B . ?\x5446) ;; <CJK>
     (?$(0+F(B . ?\x5443) ;; <CJK>
     (?$(0+G(B . ?\x5433) ;; <CJK>
     (?$(0+H(B . ?\x5448) ;; <CJK>
     (?$(0+I(B . ?\x5442) ;; <CJK>
     (?$(0+J(B . ?\x541B) ;; <CJK>
     (?$(0+K(B . ?\x5429) ;; <CJK>
     (?$(0+L(B . ?\x544A) ;; <CJK>
     (?$(0+M(B . ?\x5439) ;; <CJK>
     (?$(0+N(B . ?\x543B) ;; <CJK>
     (?$(0+O(B . ?\x5438) ;; <CJK>
     (?$(0+P(B . ?\x542E) ;; <CJK>
     (?$(0+Q(B . ?\x5435) ;; <CJK>
     (?$(0+R(B . ?\x5436) ;; <CJK>
     (?$(0+S(B . ?\x5420) ;; <CJK>
     (?$(0+T(B . ?\x543C) ;; <CJK>
     (?$(0+U(B . ?\x5440) ;; <CJK>
     (?$(0+V(B . ?\x5431) ;; <CJK>
     (?$(0+W(B . ?\x542B) ;; <CJK>
     (?$(0+X(B . ?\x541F) ;; <CJK>
     (?$(0+Y(B . ?\x542C) ;; <CJK>
     (?$(0+Z(B . ?\x56EA) ;; <CJK>
     (?$(0+[(B . ?\x56F0) ;; <CJK>
     (?$(0+\(B . ?\x56E4) ;; <CJK>
     (?$(0+](B . ?\x56EB) ;; <CJK>
     (?$(0+^(B . ?\x574A) ;; <CJK>
     (?$(0+_(B . ?\x5751) ;; <CJK>
     (?$(0+`(B . ?\x5740) ;; <CJK>
     (?$(0+a(B . ?\x574D) ;; <CJK>
     (?$(0+b(B . ?\x5747) ;; <CJK>
     (?$(0+c(B . ?\x574E) ;; <CJK>
     (?$(0+d(B . ?\x573E) ;; <CJK>
     (?$(0+e(B . ?\x5750) ;; <CJK>
     (?$(0+f(B . ?\x574F) ;; <CJK>
     (?$(0+g(B . ?\x573B) ;; <CJK>
     (?$(0+h(B . ?\x58EF) ;; <CJK>
     (?$(0+i(B . ?\x593E) ;; <CJK>
     (?$(0+j(B . ?\x599D) ;; <CJK>
     (?$(0+k(B . ?\x5992) ;; <CJK>
     (?$(0+l(B . ?\x59A8) ;; <CJK>
     (?$(0+m(B . ?\x599E) ;; <CJK>
     (?$(0+n(B . ?\x59A3) ;; <CJK>
     (?$(0+o(B . ?\x5999) ;; <CJK>
     (?$(0+p(B . ?\x5996) ;; <CJK>
     (?$(0+q(B . ?\x598D) ;; <CJK>
     (?$(0+r(B . ?\x59A4) ;; <CJK>
     (?$(0+s(B . ?\x5993) ;; <CJK>
     (?$(0+t(B . ?\x598A) ;; <CJK>
     (?$(0+u(B . ?\x59A5) ;; <CJK>
     (?$(0+v(B . ?\x5B5D) ;; <CJK>
     (?$(0+w(B . ?\x5B5C) ;; <CJK>
     (?$(0+x(B . ?\x5B5A) ;; <CJK>
     (?$(0+y(B . ?\x5B5B) ;; <CJK>
     (?$(0+z(B . ?\x5B8C) ;; <CJK>
     (?$(0+{(B . ?\x5B8B) ;; <CJK>
     (?$(0+|(B . ?\x5B8F) ;; <CJK>
     (?$(0+}(B . ?\x5C2C) ;; <CJK>
     (?$(0+~(B . ?\x5C40) ;; <CJK>
     (?$(0,!(B . ?\x5C41) ;; <CJK>
     (?$(0,"(B . ?\x5C3F) ;; <CJK>
     (?$(0,#(B . ?\x5C3E) ;; <CJK>
     (?$(0,$(B . ?\x5C90) ;; <CJK>
     (?$(0,%(B . ?\x5C91) ;; <CJK>
     (?$(0,&(B . ?\x5C94) ;; <CJK>
     (?$(0,'(B . ?\x5C8C) ;; <CJK>
     (?$(0,((B . ?\x5DEB) ;; <CJK>
     (?$(0,)(B . ?\x5E0C) ;; <CJK>
     (?$(0,*(B . ?\x5E8F) ;; <CJK>
     (?$(0,+(B . ?\x5E87) ;; <CJK>
     (?$(0,,(B . ?\x5E8A) ;; <CJK>
     (?$(0,-(B . ?\x5EF7) ;; <CJK>
     (?$(0,.(B . ?\x5F04) ;; <CJK>
     (?$(0,/(B . ?\x5F1F) ;; <CJK>
     (?$(0,0(B . ?\x5F64) ;; <CJK>
     (?$(0,1(B . ?\x5F62) ;; <CJK>
     (?$(0,2(B . ?\x5F77) ;; <CJK>
     (?$(0,3(B . ?\x5F79) ;; <CJK>
     (?$(0,4(B . ?\x5FD8) ;; <CJK>
     (?$(0,5(B . ?\x5FCC) ;; <CJK>
     (?$(0,6(B . ?\x5FD7) ;; <CJK>
     (?$(0,7(B . ?\x5FCD) ;; <CJK>
     (?$(0,8(B . ?\x5FF1) ;; <CJK>
     (?$(0,9(B . ?\x5FEB) ;; <CJK>
     (?$(0,:(B . ?\x5FF8) ;; <CJK>
     (?$(0,;(B . ?\x5FEA) ;; <CJK>
     (?$(0,<(B . ?\x6212) ;; <CJK>
     (?$(0,=(B . ?\x6211) ;; <CJK>
     (?$(0,>(B . ?\x6284) ;; <CJK>
     (?$(0,?(B . ?\x6297) ;; <CJK>
     (?$(0,@(B . ?\x6296) ;; <CJK>
     (?$(0,A(B . ?\x6280) ;; <CJK>
     (?$(0,B(B . ?\x6276) ;; <CJK>
     (?$(0,C(B . ?\x6289) ;; <CJK>
     (?$(0,D(B . ?\x626D) ;; <CJK>
     (?$(0,E(B . ?\x628A) ;; <CJK>
     (?$(0,F(B . ?\x627C) ;; <CJK>
     (?$(0,G(B . ?\x627E) ;; <CJK>
     (?$(0,H(B . ?\x6279) ;; <CJK>
     (?$(0,I(B . ?\x6273) ;; <CJK>
     (?$(0,J(B . ?\x6292) ;; <CJK>
     (?$(0,K(B . ?\x626F) ;; <CJK>
     (?$(0,L(B . ?\x6298) ;; <CJK>
     (?$(0,M(B . ?\x626E) ;; <CJK>
     (?$(0,N(B . ?\x6295) ;; <CJK>
     (?$(0,O(B . ?\x6293) ;; <CJK>
     (?$(0,P(B . ?\x6291) ;; <CJK>
     (?$(0,Q(B . ?\x6286) ;; <CJK>
     (?$(0,R(B . ?\x6539) ;; <CJK>
     (?$(0,S(B . ?\x653B) ;; <CJK>
     (?$(0,T(B . ?\x6538) ;; <CJK>
     (?$(0,U(B . ?\x65F1) ;; <CJK>
     (?$(0,V(B . ?\x66F4) ;; <CJK>
     (?$(0,W(B . ?\x675F) ;; <CJK>
     (?$(0,X(B . ?\x674E) ;; <CJK>
     (?$(0,Y(B . ?\x674F) ;; <CJK>
     (?$(0,Z(B . ?\x6750) ;; <CJK>
     (?$(0,[(B . ?\x6751) ;; <CJK>
     (?$(0,\(B . ?\x675C) ;; <CJK>
     (?$(0,](B . ?\x6756) ;; <CJK>
     (?$(0,^(B . ?\x675E) ;; <CJK>
     (?$(0,_(B . ?\x6749) ;; <CJK>
     (?$(0,`(B . ?\x6746) ;; <CJK>
     (?$(0,a(B . ?\x6760) ;; <CJK>
     (?$(0,b(B . ?\x6753) ;; <CJK>
     (?$(0,c(B . ?\x6757) ;; <CJK>
     (?$(0,d(B . ?\x6B65) ;; <CJK>
     (?$(0,e(B . ?\x6BCF) ;; <CJK>
     (?$(0,f(B . ?\x6C42) ;; <CJK>
     (?$(0,g(B . ?\x6C5E) ;; <CJK>
     (?$(0,h(B . ?\x6C99) ;; <CJK>
     (?$(0,i(B . ?\x6C81) ;; <CJK>
     (?$(0,j(B . ?\x6C88) ;; <CJK>
     (?$(0,k(B . ?\x6C89) ;; <CJK>
     (?$(0,l(B . ?\x6C85) ;; <CJK>
     (?$(0,m(B . ?\x6C9B) ;; <CJK>
     (?$(0,n(B . ?\x6C6A) ;; <CJK>
     (?$(0,o(B . ?\x6C7A) ;; <CJK>
     (?$(0,p(B . ?\x6C90) ;; <CJK>
     (?$(0,q(B . ?\x6C70) ;; <CJK>
     (?$(0,r(B . ?\x6C8C) ;; <CJK>
     (?$(0,s(B . ?\x6C68) ;; <CJK>
     (?$(0,t(B . ?\x6C96) ;; <CJK>
     (?$(0,u(B . ?\x6C92) ;; <CJK>
     (?$(0,v(B . ?\x6C7D) ;; <CJK>
     (?$(0,w(B . ?\x6C83) ;; <CJK>
     (?$(0,x(B . ?\x6C72) ;; <CJK>
     (?$(0,y(B . ?\x6C7E) ;; <CJK>
     (?$(0,z(B . ?\x6C74) ;; <CJK>
     (?$(0,{(B . ?\x6C86) ;; <CJK>
     (?$(0,|(B . ?\x6C76) ;; <CJK>
     (?$(0,}(B . ?\x6C8D) ;; <CJK>
     (?$(0,~(B . ?\x6C94) ;; <CJK>
     (?$(0-!(B . ?\x6C98) ;; <CJK>
     (?$(0-"(B . ?\x6C82) ;; <CJK>
     (?$(0-#(B . ?\x7076) ;; <CJK>
     (?$(0-$(B . ?\x707C) ;; <CJK>
     (?$(0-%(B . ?\x707D) ;; <CJK>
     (?$(0-&(B . ?\x7078) ;; <CJK>
     (?$(0-'(B . ?\x7262) ;; <CJK>
     (?$(0-((B . ?\x7261) ;; <CJK>
     (?$(0-)(B . ?\x7260) ;; <CJK>
     (?$(0-*(B . ?\x72C4) ;; <CJK>
     (?$(0-+(B . ?\x72C2) ;; <CJK>
     (?$(0-,(B . ?\x7396) ;; <CJK>
     (?$(0--(B . ?\x752C) ;; <CJK>
     (?$(0-.(B . ?\x752B) ;; <CJK>
     (?$(0-/(B . ?\x7537) ;; <CJK>
     (?$(0-0(B . ?\x7538) ;; <CJK>
     (?$(0-1(B . ?\x7682) ;; <CJK>
     (?$(0-2(B . ?\x76EF) ;; <CJK>
     (?$(0-3(B . ?\x77E3) ;; <CJK>
     (?$(0-4(B . ?\x79C1) ;; <CJK>
     (?$(0-5(B . ?\x79C0) ;; <CJK>
     (?$(0-6(B . ?\x79BF) ;; <CJK>
     (?$(0-7(B . ?\x7A76) ;; <CJK>
     (?$(0-8(B . ?\x7CFB) ;; <CJK>
     (?$(0-9(B . ?\x7F55) ;; <CJK>
     (?$(0-:(B . ?\x8096) ;; <CJK>
     (?$(0-;(B . ?\x8093) ;; <CJK>
     (?$(0-<(B . ?\x809D) ;; <CJK>
     (?$(0-=(B . ?\x8098) ;; <CJK>
     (?$(0->(B . ?\x809B) ;; <CJK>
     (?$(0-?(B . ?\x809A) ;; <CJK>
     (?$(0-@(B . ?\x80B2) ;; <CJK>
     (?$(0-A(B . ?\x826F) ;; <CJK>
     (?$(0-B(B . ?\x8292) ;; <CJK>
     (?$(0-C(B . ?\x828B) ;; <CJK>
     (?$(0-D(B . ?\x828D) ;; <CJK>
     (?$(0-E(B . ?\x898B) ;; <CJK>
     (?$(0-F(B . ?\x89D2) ;; <CJK>
     (?$(0-G(B . ?\x8A00) ;; <CJK>
     (?$(0-H(B . ?\x8C37) ;; <CJK>
     (?$(0-I(B . ?\x8C46) ;; <CJK>
     (?$(0-J(B . ?\x8C55) ;; <CJK>
     (?$(0-K(B . ?\x8C9D) ;; <CJK>
     (?$(0-L(B . ?\x8D64) ;; <CJK>
     (?$(0-M(B . ?\x8D70) ;; <CJK>
     (?$(0-N(B . ?\x8DB3) ;; <CJK>
     (?$(0-O(B . ?\x8EAB) ;; <CJK>
     (?$(0-P(B . ?\x8ECA) ;; <CJK>
     (?$(0-Q(B . ?\x8F9B) ;; <CJK>
     (?$(0-R(B . ?\x8FB0) ;; <CJK>
     (?$(0-S(B . ?\x8FC2) ;; <CJK>
     (?$(0-T(B . ?\x8FC6) ;; <CJK>
     (?$(0-U(B . ?\x8FC5) ;; <CJK>
     (?$(0-V(B . ?\x8FC4) ;; <CJK>
     (?$(0-W(B . ?\x5DE1) ;; <CJK>
     (?$(0-X(B . ?\x9091) ;; <CJK>
     (?$(0-Y(B . ?\x90A2) ;; <CJK>
     (?$(0-Z(B . ?\x90AA) ;; <CJK>
     (?$(0-[(B . ?\x90A6) ;; <CJK>
     (?$(0-\(B . ?\x90A3) ;; <CJK>
     (?$(0-](B . ?\x9149) ;; <CJK>
     (?$(0-^(B . ?\x91C6) ;; <CJK>
     (?$(0-_(B . ?\x91CC) ;; <CJK>
     (?$(0-`(B . ?\x9632) ;; <CJK>
     (?$(0-a(B . ?\x962E) ;; <CJK>
     (?$(0-b(B . ?\x9631) ;; <CJK>
     (?$(0-c(B . ?\x962A) ;; <CJK>
     (?$(0-d(B . ?\x962C) ;; <CJK>
     (?$(0-e(B . ?\x4E26) ;; <CJK>
     (?$(0-f(B . ?\x4E56) ;; <CJK>
     (?$(0-g(B . ?\x4E73) ;; <CJK>
     (?$(0-h(B . ?\x4E8B) ;; <CJK>
     (?$(0-i(B . ?\x4E9B) ;; <CJK>
     (?$(0-j(B . ?\x4E9E) ;; <CJK>
     (?$(0-k(B . ?\x4EAB) ;; <CJK>
     (?$(0-l(B . ?\x4EAC) ;; <CJK>
     (?$(0-m(B . ?\x4F6F) ;; <CJK>
     (?$(0-n(B . ?\x4F9D) ;; <CJK>
     (?$(0-o(B . ?\x4F8D) ;; <CJK>
     (?$(0-p(B . ?\x4F73) ;; <CJK>
     (?$(0-q(B . ?\x4F7F) ;; <CJK>
     (?$(0-r(B . ?\x4F6C) ;; <CJK>
     (?$(0-s(B . ?\x4F9B) ;; <CJK>
     (?$(0-t(B . ?\x4F8B) ;; <CJK>
     (?$(0-u(B . ?\x4F86) ;; <CJK>
     (?$(0-v(B . ?\x4F83) ;; <CJK>
     (?$(0-w(B . ?\x4F70) ;; <CJK>
     (?$(0-x(B . ?\x4F75) ;; <CJK>
     (?$(0-y(B . ?\x4F88) ;; <CJK>
     (?$(0-z(B . ?\x4F69) ;; <CJK>
     (?$(0-{(B . ?\x4F7B) ;; <CJK>
     (?$(0-|(B . ?\x4F96) ;; <CJK>
     (?$(0-}(B . ?\x4F7E) ;; <CJK>
     (?$(0-~(B . ?\x4F8F) ;; <CJK>
     (?$(0.!(B . ?\x4F91) ;; <CJK>
     (?$(0."(B . ?\x4F7A) ;; <CJK>
     (?$(0.#(B . ?\x5154) ;; <CJK>
     (?$(0.$(B . ?\x5152) ;; <CJK>
     (?$(0.%(B . ?\x5155) ;; <CJK>
     (?$(0.&(B . ?\x5169) ;; <CJK>
     (?$(0.'(B . ?\x5177) ;; <CJK>
     (?$(0.((B . ?\x5176) ;; <CJK>
     (?$(0.)(B . ?\x5178) ;; <CJK>
     (?$(0.*(B . ?\x51BD) ;; <CJK>
     (?$(0.+(B . ?\x51FD) ;; <CJK>
     (?$(0.,(B . ?\x523B) ;; <CJK>
     (?$(0.-(B . ?\x5238) ;; <CJK>
     (?$(0..(B . ?\x5237) ;; <CJK>
     (?$(0./(B . ?\x523A) ;; <CJK>
     (?$(0.0(B . ?\x5230) ;; <CJK>
     (?$(0.1(B . ?\x522E) ;; <CJK>
     (?$(0.2(B . ?\x5236) ;; <CJK>
     (?$(0.3(B . ?\x5241) ;; <CJK>
     (?$(0.4(B . ?\x52BE) ;; <CJK>
     (?$(0.5(B . ?\x52BB) ;; <CJK>
     (?$(0.6(B . ?\x5352) ;; <CJK>
     (?$(0.7(B . ?\x5354) ;; <CJK>
     (?$(0.8(B . ?\x5353) ;; <CJK>
     (?$(0.9(B . ?\x5351) ;; <CJK>
     (?$(0.:(B . ?\x5366) ;; <CJK>
     (?$(0.;(B . ?\x5377) ;; <CJK>
     (?$(0.<(B . ?\x5378) ;; <CJK>
     (?$(0.=(B . ?\x5379) ;; <CJK>
     (?$(0.>(B . ?\x53D6) ;; <CJK>
     (?$(0.?(B . ?\x53D4) ;; <CJK>
     (?$(0.@(B . ?\x53D7) ;; <CJK>
     (?$(0.A(B . ?\x5473) ;; <CJK>
     (?$(0.B(B . ?\x5475) ;; <CJK>
     (?$(0.C(B . ?\x5496) ;; <CJK>
     (?$(0.D(B . ?\x5478) ;; <CJK>
     (?$(0.E(B . ?\x5495) ;; <CJK>
     (?$(0.F(B . ?\x5480) ;; <CJK>
     (?$(0.G(B . ?\x547B) ;; <CJK>
     (?$(0.H(B . ?\x5477) ;; <CJK>
     (?$(0.I(B . ?\x5484) ;; <CJK>
     (?$(0.J(B . ?\x5492) ;; <CJK>
     (?$(0.K(B . ?\x5486) ;; <CJK>
     (?$(0.L(B . ?\x547C) ;; <CJK>
     (?$(0.M(B . ?\x5490) ;; <CJK>
     (?$(0.N(B . ?\x5471) ;; <CJK>
     (?$(0.O(B . ?\x5476) ;; <CJK>
     (?$(0.P(B . ?\x548C) ;; <CJK>
     (?$(0.Q(B . ?\x549A) ;; <CJK>
     (?$(0.R(B . ?\x5462) ;; <CJK>
     (?$(0.S(B . ?\x5468) ;; <CJK>
     (?$(0.T(B . ?\x548B) ;; <CJK>
     (?$(0.U(B . ?\x547D) ;; <CJK>
     (?$(0.V(B . ?\x548E) ;; <CJK>
     (?$(0.W(B . ?\x56FA) ;; <CJK>
     (?$(0.X(B . ?\x5783) ;; <CJK>
     (?$(0.Y(B . ?\x5777) ;; <CJK>
     (?$(0.Z(B . ?\x576A) ;; <CJK>
     (?$(0.[(B . ?\x5769) ;; <CJK>
     (?$(0.\(B . ?\x5761) ;; <CJK>
     (?$(0.](B . ?\x5766) ;; <CJK>
     (?$(0.^(B . ?\x5764) ;; <CJK>
     (?$(0._(B . ?\x577C) ;; <CJK>
     (?$(0.`(B . ?\x591C) ;; <CJK>
     (?$(0.a(B . ?\x5949) ;; <CJK>
     (?$(0.b(B . ?\x5947) ;; <CJK>
     (?$(0.c(B . ?\x5948) ;; <CJK>
     (?$(0.d(B . ?\x5944) ;; <CJK>
     (?$(0.e(B . ?\x5954) ;; <CJK>
     (?$(0.f(B . ?\x59BE) ;; <CJK>
     (?$(0.g(B . ?\x59BB) ;; <CJK>
     (?$(0.h(B . ?\x59D4) ;; <CJK>
     (?$(0.i(B . ?\x59B9) ;; <CJK>
     (?$(0.j(B . ?\x59AE) ;; <CJK>
     (?$(0.k(B . ?\x59D1) ;; <CJK>
     (?$(0.l(B . ?\x59C6) ;; <CJK>
     (?$(0.m(B . ?\x59D0) ;; <CJK>
     (?$(0.n(B . ?\x59CD) ;; <CJK>
     (?$(0.o(B . ?\x59CB) ;; <CJK>
     (?$(0.p(B . ?\x59D3) ;; <CJK>
     (?$(0.q(B . ?\x59CA) ;; <CJK>
     (?$(0.r(B . ?\x59AF) ;; <CJK>
     (?$(0.s(B . ?\x59B3) ;; <CJK>
     (?$(0.t(B . ?\x59D2) ;; <CJK>
     (?$(0.u(B . ?\x59C5) ;; <CJK>
     (?$(0.v(B . ?\x5B5F) ;; <CJK>
     (?$(0.w(B . ?\x5B64) ;; <CJK>
     (?$(0.x(B . ?\x5B63) ;; <CJK>
     (?$(0.y(B . ?\x5B97) ;; <CJK>
     (?$(0.z(B . ?\x5B9A) ;; <CJK>
     (?$(0.{(B . ?\x5B98) ;; <CJK>
     (?$(0.|(B . ?\x5B9C) ;; <CJK>
     (?$(0.}(B . ?\x5B99) ;; <CJK>
     (?$(0.~(B . ?\x5B9B) ;; <CJK>
     (?$(0/!(B . ?\x5C1A) ;; <CJK>
     (?$(0/"(B . ?\x5C48) ;; <CJK>
     (?$(0/#(B . ?\x5C45) ;; <CJK>
     (?$(0/$(B . ?\x5C46) ;; <CJK>
     (?$(0/%(B . ?\x5CB7) ;; <CJK>
     (?$(0/&(B . ?\x5CA1) ;; <CJK>
     (?$(0/'(B . ?\x5CB8) ;; <CJK>
     (?$(0/((B . ?\x5CA9) ;; <CJK>
     (?$(0/)(B . ?\x5CAB) ;; <CJK>
     (?$(0/*(B . ?\x5CB1) ;; <CJK>
     (?$(0/+(B . ?\x5CB3) ;; <CJK>
     (?$(0/,(B . ?\x5E18) ;; <CJK>
     (?$(0/-(B . ?\x5E1A) ;; <CJK>
     (?$(0/.(B . ?\x5E16) ;; <CJK>
     (?$(0//(B . ?\x5E15) ;; <CJK>
     (?$(0/0(B . ?\x5E1B) ;; <CJK>
     (?$(0/1(B . ?\x5E11) ;; <CJK>
     (?$(0/2(B . ?\x5E78) ;; <CJK>
     (?$(0/3(B . ?\x5E9A) ;; <CJK>
     (?$(0/4(B . ?\x5E97) ;; <CJK>
     (?$(0/5(B . ?\x5E9C) ;; <CJK>
     (?$(0/6(B . ?\x5E95) ;; <CJK>
     (?$(0/7(B . ?\x5E96) ;; <CJK>
     (?$(0/8(B . ?\x5EF6) ;; <CJK>
     (?$(0/9(B . ?\x5F26) ;; <CJK>
     (?$(0/:(B . ?\x5F27) ;; <CJK>
     (?$(0/;(B . ?\x5F29) ;; <CJK>
     (?$(0/<(B . ?\x5F80) ;; <CJK>
     (?$(0/=(B . ?\x5F81) ;; <CJK>
     (?$(0/>(B . ?\x5F7F) ;; <CJK>
     (?$(0/?(B . ?\x5F7C) ;; <CJK>
     (?$(0/@(B . ?\x5FDD) ;; <CJK>
     (?$(0/A(B . ?\x5FE0) ;; <CJK>
     (?$(0/B(B . ?\x5FFD) ;; <CJK>
     (?$(0/C(B . ?\x5FF5) ;; <CJK>
     (?$(0/D(B . ?\x5FFF) ;; <CJK>
     (?$(0/E(B . ?\x600F) ;; <CJK>
     (?$(0/F(B . ?\x6014) ;; <CJK>
     (?$(0/G(B . ?\x602F) ;; <CJK>
     (?$(0/H(B . ?\x6035) ;; <CJK>
     (?$(0/I(B . ?\x6016) ;; <CJK>
     (?$(0/J(B . ?\x602A) ;; <CJK>
     (?$(0/K(B . ?\x6015) ;; <CJK>
     (?$(0/L(B . ?\x6021) ;; <CJK>
     (?$(0/M(B . ?\x6027) ;; <CJK>
     (?$(0/N(B . ?\x6029) ;; <CJK>
     (?$(0/O(B . ?\x602B) ;; <CJK>
     (?$(0/P(B . ?\x601B) ;; <CJK>
     (?$(0/Q(B . ?\x6216) ;; <CJK>
     (?$(0/R(B . ?\x6215) ;; <CJK>
     (?$(0/S(B . ?\x623F) ;; <CJK>
     (?$(0/T(B . ?\x623E) ;; <CJK>
     (?$(0/U(B . ?\x6240) ;; <CJK>
     (?$(0/V(B . ?\x627F) ;; <CJK>
     (?$(0/W(B . ?\x62C9) ;; <CJK>
     (?$(0/X(B . ?\x62CC) ;; <CJK>
     (?$(0/Y(B . ?\x62C4) ;; <CJK>
     (?$(0/Z(B . ?\x62BF) ;; <CJK>
     (?$(0/[(B . ?\x62C2) ;; <CJK>
     (?$(0/\(B . ?\x62B9) ;; <CJK>
     (?$(0/](B . ?\x62D2) ;; <CJK>
     (?$(0/^(B . ?\x62DB) ;; <CJK>
     (?$(0/_(B . ?\x62AB) ;; <CJK>
     (?$(0/`(B . ?\x62D3) ;; <CJK>
     (?$(0/a(B . ?\x62D4) ;; <CJK>
     (?$(0/b(B . ?\x62CB) ;; <CJK>
     (?$(0/c(B . ?\x62C8) ;; <CJK>
     (?$(0/d(B . ?\x62A8) ;; <CJK>
     (?$(0/e(B . ?\x62BD) ;; <CJK>
     (?$(0/f(B . ?\x62BC) ;; <CJK>
     (?$(0/g(B . ?\x62D0) ;; <CJK>
     (?$(0/h(B . ?\x62D9) ;; <CJK>
     (?$(0/i(B . ?\x62C7) ;; <CJK>
     (?$(0/j(B . ?\x62CD) ;; <CJK>
     (?$(0/k(B . ?\x62B5) ;; <CJK>
     (?$(0/l(B . ?\x62DA) ;; <CJK>
     (?$(0/m(B . ?\x62B1) ;; <CJK>
     (?$(0/n(B . ?\x62D8) ;; <CJK>
     (?$(0/o(B . ?\x62D6) ;; <CJK>
     (?$(0/p(B . ?\x62D7) ;; <CJK>
     (?$(0/q(B . ?\x62C6) ;; <CJK>
     (?$(0/r(B . ?\x62AC) ;; <CJK>
     (?$(0/s(B . ?\x62CE) ;; <CJK>
     (?$(0/t(B . ?\x653E) ;; <CJK>
     (?$(0/u(B . ?\x65A7) ;; <CJK>
     (?$(0/v(B . ?\x65BC) ;; <CJK>
     (?$(0/w(B . ?\x65FA) ;; <CJK>
     (?$(0/x(B . ?\x6614) ;; <CJK>
     (?$(0/y(B . ?\x6613) ;; <CJK>
     (?$(0/z(B . ?\x660C) ;; <CJK>
     (?$(0/{(B . ?\x6606) ;; <CJK>
     (?$(0/|(B . ?\x6602) ;; <CJK>
     (?$(0/}(B . ?\x660E) ;; <CJK>
     (?$(0/~(B . ?\x6600) ;; <CJK>
     (?$(00!(B . ?\x660F) ;; <CJK>
     (?$(00"(B . ?\x6615) ;; <CJK>
     (?$(00#(B . ?\x660A) ;; <CJK>
     (?$(00$(B . ?\x6607) ;; <CJK>
     (?$(00%(B . ?\x670D) ;; <CJK>
     (?$(00&(B . ?\x670B) ;; <CJK>
     (?$(00'(B . ?\x676D) ;; <CJK>
     (?$(00((B . ?\x678B) ;; <CJK>
     (?$(00)(B . ?\x6795) ;; <CJK>
     (?$(00*(B . ?\x6771) ;; <CJK>
     (?$(00+(B . ?\x679C) ;; <CJK>
     (?$(00,(B . ?\x6773) ;; <CJK>
     (?$(00-(B . ?\x6777) ;; <CJK>
     (?$(00.(B . ?\x6787) ;; <CJK>
     (?$(00/(B . ?\x679D) ;; <CJK>
     (?$(000(B . ?\x6797) ;; <CJK>
     (?$(001(B . ?\x676F) ;; <CJK>
     (?$(002(B . ?\x6770) ;; <CJK>
     (?$(003(B . ?\x677F) ;; <CJK>
     (?$(004(B . ?\x6789) ;; <CJK>
     (?$(005(B . ?\x677E) ;; <CJK>
     (?$(006(B . ?\x6790) ;; <CJK>
     (?$(007(B . ?\x6775) ;; <CJK>
     (?$(008(B . ?\x679A) ;; <CJK>
     (?$(009(B . ?\x6793) ;; <CJK>
     (?$(00:(B . ?\x677C) ;; <CJK>
     (?$(00;(B . ?\x676A) ;; <CJK>
     (?$(00<(B . ?\x6772) ;; <CJK>
     (?$(00=(B . ?\x6B23) ;; <CJK>
     (?$(00>(B . ?\x6B66) ;; <CJK>
     (?$(00?(B . ?\x6B67) ;; <CJK>
     (?$(00@(B . ?\x6B7F) ;; <CJK>
     (?$(00A(B . ?\x6C13) ;; <CJK>
     (?$(00B(B . ?\x6C1B) ;; <CJK>
     (?$(00C(B . ?\x6CE3) ;; <CJK>
     (?$(00D(B . ?\x6CE8) ;; <CJK>
     (?$(00E(B . ?\x6CF3) ;; <CJK>
     (?$(00F(B . ?\x6CB1) ;; <CJK>
     (?$(00G(B . ?\x6CCC) ;; <CJK>
     (?$(00H(B . ?\x6CE5) ;; <CJK>
     (?$(00I(B . ?\x6CB3) ;; <CJK>
     (?$(00J(B . ?\x6CBD) ;; <CJK>
     (?$(00K(B . ?\x6CBE) ;; <CJK>
     (?$(00L(B . ?\x6CBC) ;; <CJK>
     (?$(00M(B . ?\x6CE2) ;; <CJK>
     (?$(00N(B . ?\x6CAB) ;; <CJK>
     (?$(00O(B . ?\x6CD5) ;; <CJK>
     (?$(00P(B . ?\x6CD3) ;; <CJK>
     (?$(00Q(B . ?\x6CB8) ;; <CJK>
     (?$(00R(B . ?\x6CC4) ;; <CJK>
     (?$(00S(B . ?\x6CB9) ;; <CJK>
     (?$(00T(B . ?\x6CC1) ;; <CJK>
     (?$(00U(B . ?\x6CAE) ;; <CJK>
     (?$(00V(B . ?\x6CD7) ;; <CJK>
     (?$(00W(B . ?\x6CC5) ;; <CJK>
     (?$(00X(B . ?\x6CF1) ;; <CJK>
     (?$(00Y(B . ?\x6CBF) ;; <CJK>
     (?$(00Z(B . ?\x6CBB) ;; <CJK>
     (?$(00[(B . ?\x6CE1) ;; <CJK>
     (?$(00\(B . ?\x6CDB) ;; <CJK>
     (?$(00](B . ?\x6CCA) ;; <CJK>
     (?$(00^(B . ?\x6CAC) ;; <CJK>
     (?$(00_(B . ?\x6CEF) ;; <CJK>
     (?$(00`(B . ?\x6CDC) ;; <CJK>
     (?$(00a(B . ?\x6CD6) ;; <CJK>
     (?$(00b(B . ?\x6CE0) ;; <CJK>
     (?$(00c(B . ?\x7095) ;; <CJK>
     (?$(00d(B . ?\x708E) ;; <CJK>
     (?$(00e(B . ?\x7092) ;; <CJK>
     (?$(00f(B . ?\x708A) ;; <CJK>
     (?$(00g(B . ?\x7099) ;; <CJK>
     (?$(00h(B . ?\x722C) ;; <CJK>
     (?$(00i(B . ?\x722D) ;; <CJK>
     (?$(00j(B . ?\x7238) ;; <CJK>
     (?$(00k(B . ?\x7248) ;; <CJK>
     (?$(00l(B . ?\x7267) ;; <CJK>
     (?$(00m(B . ?\x7269) ;; <CJK>
     (?$(00n(B . ?\x72C0) ;; <CJK>
     (?$(00o(B . ?\x72CE) ;; <CJK>
     (?$(00p(B . ?\x72D9) ;; <CJK>
     (?$(00q(B . ?\x72D7) ;; <CJK>
     (?$(00r(B . ?\x72D0) ;; <CJK>
     (?$(00s(B . ?\x73A9) ;; <CJK>
     (?$(00t(B . ?\x73A8) ;; <CJK>
     (?$(00u(B . ?\x739F) ;; <CJK>
     (?$(00v(B . ?\x73AB) ;; <CJK>
     (?$(00w(B . ?\x73A5) ;; <CJK>
     (?$(00x(B . ?\x753D) ;; <CJK>
     (?$(00y(B . ?\x759D) ;; <CJK>
     (?$(00z(B . ?\x7599) ;; <CJK>
     (?$(00{(B . ?\x759A) ;; <CJK>
     (?$(00|(B . ?\x7684) ;; <CJK>
     (?$(00}(B . ?\x76C2) ;; <CJK>
     (?$(00~(B . ?\x76F2) ;; <CJK>
     (?$(01!(B . ?\x76F4) ;; <CJK>
     (?$(01"(B . ?\x77E5) ;; <CJK>
     (?$(01#(B . ?\x77FD) ;; <CJK>
     (?$(01$(B . ?\x793E) ;; <CJK>
     (?$(01%(B . ?\x7940) ;; <CJK>
     (?$(01&(B . ?\x7941) ;; <CJK>
     (?$(01'(B . ?\x79C9) ;; <CJK>
     (?$(01((B . ?\x79C8) ;; <CJK>
     (?$(01)(B . ?\x7A7A) ;; <CJK>
     (?$(01*(B . ?\x7A79) ;; <CJK>
     (?$(01+(B . ?\x7AFA) ;; <CJK>
     (?$(01,(B . ?\x7CFE) ;; <CJK>
     (?$(01-(B . ?\x7F54) ;; <CJK>
     (?$(01.(B . ?\x7F8C) ;; <CJK>
     (?$(01/(B . ?\x7F8B) ;; <CJK>
     (?$(010(B . ?\x8005) ;; <CJK>
     (?$(011(B . ?\x80BA) ;; <CJK>
     (?$(012(B . ?\x80A5) ;; <CJK>
     (?$(013(B . ?\x80A2) ;; <CJK>
     (?$(014(B . ?\x80B1) ;; <CJK>
     (?$(015(B . ?\x80A1) ;; <CJK>
     (?$(016(B . ?\x80AB) ;; <CJK>
     (?$(017(B . ?\x80A9) ;; <CJK>
     (?$(018(B . ?\x80B4) ;; <CJK>
     (?$(019(B . ?\x80AA) ;; <CJK>
     (?$(01:(B . ?\x80AF) ;; <CJK>
     (?$(01;(B . ?\x81E5) ;; <CJK>
     (?$(01<(B . ?\x81FE) ;; <CJK>
     (?$(01=(B . ?\x820D) ;; <CJK>
     (?$(01>(B . ?\x82B3) ;; <CJK>
     (?$(01?(B . ?\x829D) ;; <CJK>
     (?$(01@(B . ?\x8299) ;; <CJK>
     (?$(01A(B . ?\x82AD) ;; <CJK>
     (?$(01B(B . ?\x82BD) ;; <CJK>
     (?$(01C(B . ?\x829F) ;; <CJK>
     (?$(01D(B . ?\x82B9) ;; <CJK>
     (?$(01E(B . ?\x82B1) ;; <CJK>
     (?$(01F(B . ?\x82AC) ;; <CJK>
     (?$(01G(B . ?\x82A5) ;; <CJK>
     (?$(01H(B . ?\x82AF) ;; <CJK>
     (?$(01I(B . ?\x82B8) ;; <CJK>
     (?$(01J(B . ?\x82A3) ;; <CJK>
     (?$(01K(B . ?\x82B0) ;; <CJK>
     (?$(01L(B . ?\x82BE) ;; <CJK>
     (?$(01M(B . ?\x82B7) ;; <CJK>
     (?$(01N(B . ?\x864E) ;; <CJK>
     (?$(01O(B . ?\x8671) ;; <CJK>
     (?$(01P(B . ?\x521D) ;; <CJK>
     (?$(01Q(B . ?\x8868) ;; <CJK>
     (?$(01R(B . ?\x8ECB) ;; <CJK>
     (?$(01S(B . ?\x8FCE) ;; <CJK>
     (?$(01T(B . ?\x8FD4) ;; <CJK>
     (?$(01U(B . ?\x8FD1) ;; <CJK>
     (?$(01V(B . ?\x90B5) ;; <CJK>
     (?$(01W(B . ?\x90B8) ;; <CJK>
     (?$(01X(B . ?\x90B1) ;; <CJK>
     (?$(01Y(B . ?\x90B6) ;; <CJK>
     (?$(01Z(B . ?\x91C7) ;; <CJK>
     (?$(01[(B . ?\x91D1) ;; <CJK>
     (?$(01\(B . ?\x9577) ;; <CJK>
     (?$(01](B . ?\x9580) ;; <CJK>
     (?$(01^(B . ?\x961C) ;; <CJK>
     (?$(01_(B . ?\x9640) ;; <CJK>
     (?$(01`(B . ?\x963F) ;; <CJK>
     (?$(01a(B . ?\x963B) ;; <CJK>
     (?$(01b(B . ?\x9644) ;; <CJK>
     (?$(01c(B . ?\x9642) ;; <CJK>
     (?$(01d(B . ?\x96B9) ;; <CJK>
     (?$(01e(B . ?\x96E8) ;; <CJK>
     (?$(01f(B . ?\x9752) ;; <CJK>
     (?$(01g(B . ?\x975E) ;; <CJK>
     (?$(01h(B . ?\x4E9F) ;; <CJK>
     (?$(01i(B . ?\x4EAD) ;; <CJK>
     (?$(01j(B . ?\x4EAE) ;; <CJK>
     (?$(01k(B . ?\x4FE1) ;; <CJK>
     (?$(01l(B . ?\x4FB5) ;; <CJK>
     (?$(01m(B . ?\x4FAF) ;; <CJK>
     (?$(01n(B . ?\x4FBF) ;; <CJK>
     (?$(01o(B . ?\x4FE0) ;; <CJK>
     (?$(01p(B . ?\x4FD1) ;; <CJK>
     (?$(01q(B . ?\x4FCF) ;; <CJK>
     (?$(01r(B . ?\x4FDD) ;; <CJK>
     (?$(01s(B . ?\x4FC3) ;; <CJK>
     (?$(01t(B . ?\x4FB6) ;; <CJK>
     (?$(01u(B . ?\x4FD8) ;; <CJK>
     (?$(01v(B . ?\x4FDF) ;; <CJK>
     (?$(01w(B . ?\x4FCA) ;; <CJK>
     (?$(01x(B . ?\x4FD7) ;; <CJK>
     (?$(01y(B . ?\x4FAE) ;; <CJK>
     (?$(01z(B . ?\x4FD0) ;; <CJK>
     (?$(01{(B . ?\x4FC4) ;; <CJK>
     (?$(01|(B . ?\x4FC2) ;; <CJK>
     (?$(01}(B . ?\x4FDA) ;; <CJK>
     (?$(01~(B . ?\x4FCE) ;; <CJK>
     (?$(02!(B . ?\x4FDE) ;; <CJK>
     (?$(02"(B . ?\x4FB7) ;; <CJK>
     (?$(02#(B . ?\x5157) ;; <CJK>
     (?$(02$(B . ?\x5192) ;; <CJK>
     (?$(02%(B . ?\x5191) ;; <CJK>
     (?$(02&(B . ?\x51A0) ;; <CJK>
     (?$(02'(B . ?\x524E) ;; <CJK>
     (?$(02((B . ?\x5243) ;; <CJK>
     (?$(02)(B . ?\x524A) ;; <CJK>
     (?$(02*(B . ?\x524D) ;; <CJK>
     (?$(02+(B . ?\x524C) ;; <CJK>
     (?$(02,(B . ?\x524B) ;; <CJK>
     (?$(02-(B . ?\x5247) ;; <CJK>
     (?$(02.(B . ?\x52C7) ;; <CJK>
     (?$(02/(B . ?\x52C9) ;; <CJK>
     (?$(020(B . ?\x52C3) ;; <CJK>
     (?$(021(B . ?\x52C1) ;; <CJK>
     (?$(022(B . ?\x530D) ;; <CJK>
     (?$(023(B . ?\x5357) ;; <CJK>
     (?$(024(B . ?\x537B) ;; <CJK>
     (?$(025(B . ?\x539A) ;; <CJK>
     (?$(026(B . ?\x53DB) ;; <CJK>
     (?$(027(B . ?\x54AC) ;; <CJK>
     (?$(028(B . ?\x54C0) ;; <CJK>
     (?$(029(B . ?\x54A8) ;; <CJK>
     (?$(02:(B . ?\x54CE) ;; <CJK>
     (?$(02;(B . ?\x54C9) ;; <CJK>
     (?$(02<(B . ?\x54B8) ;; <CJK>
     (?$(02=(B . ?\x54A6) ;; <CJK>
     (?$(02>(B . ?\x54B3) ;; <CJK>
     (?$(02?(B . ?\x54C7) ;; <CJK>
     (?$(02@(B . ?\x54C2) ;; <CJK>
     (?$(02A(B . ?\x54BD) ;; <CJK>
     (?$(02B(B . ?\x54AA) ;; <CJK>
     (?$(02C(B . ?\x54C1) ;; <CJK>
     (?$(02D(B . ?\x54C4) ;; <CJK>
     (?$(02E(B . ?\x54C8) ;; <CJK>
     (?$(02F(B . ?\x54AF) ;; <CJK>
     (?$(02G(B . ?\x54AB) ;; <CJK>
     (?$(02H(B . ?\x54B1) ;; <CJK>
     (?$(02I(B . ?\x54BB) ;; <CJK>
     (?$(02J(B . ?\x54A9) ;; <CJK>
     (?$(02K(B . ?\x54A7) ;; <CJK>
     (?$(02L(B . ?\x54BF) ;; <CJK>
     (?$(02M(B . ?\x56FF) ;; <CJK>
     (?$(02N(B . ?\x5782) ;; <CJK>
     (?$(02O(B . ?\x578B) ;; <CJK>
     (?$(02P(B . ?\x57A0) ;; <CJK>
     (?$(02Q(B . ?\x57A3) ;; <CJK>
     (?$(02R(B . ?\x57A2) ;; <CJK>
     (?$(02S(B . ?\x57CE) ;; <CJK>
     (?$(02T(B . ?\x57AE) ;; <CJK>
     (?$(02U(B . ?\x5793) ;; <CJK>
     (?$(02V(B . ?\x5955) ;; <CJK>
     (?$(02W(B . ?\x5951) ;; <CJK>
     (?$(02X(B . ?\x594F) ;; <CJK>
     (?$(02Y(B . ?\x594E) ;; <CJK>
     (?$(02Z(B . ?\x5950) ;; <CJK>
     (?$(02[(B . ?\x59DC) ;; <CJK>
     (?$(02\(B . ?\x59D8) ;; <CJK>
     (?$(02](B . ?\x59FF) ;; <CJK>
     (?$(02^(B . ?\x59E3) ;; <CJK>
     (?$(02_(B . ?\x59E8) ;; <CJK>
     (?$(02`(B . ?\x5A03) ;; <CJK>
     (?$(02a(B . ?\x59E5) ;; <CJK>
     (?$(02b(B . ?\x59EA) ;; <CJK>
     (?$(02c(B . ?\x59DA) ;; <CJK>
     (?$(02d(B . ?\x59E6) ;; <CJK>
     (?$(02e(B . ?\x5A01) ;; <CJK>
     (?$(02f(B . ?\x59FB) ;; <CJK>
     (?$(02g(B . ?\x5B69) ;; <CJK>
     (?$(02h(B . ?\x5BA3) ;; <CJK>
     (?$(02i(B . ?\x5BA6) ;; <CJK>
     (?$(02j(B . ?\x5BA4) ;; <CJK>
     (?$(02k(B . ?\x5BA2) ;; <CJK>
     (?$(02l(B . ?\x5BA5) ;; <CJK>
     (?$(02m(B . ?\x5C01) ;; <CJK>
     (?$(02n(B . ?\x5C4E) ;; <CJK>
     (?$(02o(B . ?\x5C4F) ;; <CJK>
     (?$(02p(B . ?\x5C4D) ;; <CJK>
     (?$(02q(B . ?\x5C4B) ;; <CJK>
     (?$(02r(B . ?\x5CD9) ;; <CJK>
     (?$(02s(B . ?\x5CD2) ;; <CJK>
     (?$(02t(B . ?\x5DF7) ;; <CJK>
     (?$(02u(B . ?\x5E1D) ;; <CJK>
     (?$(02v(B . ?\x5E25) ;; <CJK>
     (?$(02w(B . ?\x5E1F) ;; <CJK>
     (?$(02x(B . ?\x5E7D) ;; <CJK>
     (?$(02y(B . ?\x5EA0) ;; <CJK>
     (?$(02z(B . ?\x5EA6) ;; <CJK>
     (?$(02{(B . ?\x5EFA) ;; <CJK>
     (?$(02|(B . ?\x5F08) ;; <CJK>
     (?$(02}(B . ?\x5F2D) ;; <CJK>
     (?$(02~(B . ?\x5F65) ;; <CJK>
     (?$(03!(B . ?\x5F88) ;; <CJK>
     (?$(03"(B . ?\x5F85) ;; <CJK>
     (?$(03#(B . ?\x5F8A) ;; <CJK>
     (?$(03$(B . ?\x5F8B) ;; <CJK>
     (?$(03%(B . ?\x5F87) ;; <CJK>
     (?$(03&(B . ?\x5F8C) ;; <CJK>
     (?$(03'(B . ?\x5F89) ;; <CJK>
     (?$(03((B . ?\x6012) ;; <CJK>
     (?$(03)(B . ?\x601D) ;; <CJK>
     (?$(03*(B . ?\x6020) ;; <CJK>
     (?$(03+(B . ?\x6025) ;; <CJK>
     (?$(03,(B . ?\x600E) ;; <CJK>
     (?$(03-(B . ?\x6028) ;; <CJK>
     (?$(03.(B . ?\x604D) ;; <CJK>
     (?$(03/(B . ?\x6070) ;; <CJK>
     (?$(030(B . ?\x6068) ;; <CJK>
     (?$(031(B . ?\x6062) ;; <CJK>
     (?$(032(B . ?\x6046) ;; <CJK>
     (?$(033(B . ?\x6043) ;; <CJK>
     (?$(034(B . ?\x606C) ;; <CJK>
     (?$(035(B . ?\x606B) ;; <CJK>
     (?$(036(B . ?\x606A) ;; <CJK>
     (?$(037(B . ?\x6064) ;; <CJK>
     (?$(038(B . ?\x6241) ;; <CJK>
     (?$(039(B . ?\x62DC) ;; <CJK>
     (?$(03:(B . ?\x6316) ;; <CJK>
     (?$(03;(B . ?\x6309) ;; <CJK>
     (?$(03<(B . ?\x62FC) ;; <CJK>
     (?$(03=(B . ?\x62ED) ;; <CJK>
     (?$(03>(B . ?\x6301) ;; <CJK>
     (?$(03?(B . ?\x62EE) ;; <CJK>
     (?$(03@(B . ?\x62FD) ;; <CJK>
     (?$(03A(B . ?\x6307) ;; <CJK>
     (?$(03B(B . ?\x62F1) ;; <CJK>
     (?$(03C(B . ?\x62F7) ;; <CJK>
     (?$(03D(B . ?\x62EF) ;; <CJK>
     (?$(03E(B . ?\x62EC) ;; <CJK>
     (?$(03F(B . ?\x62FE) ;; <CJK>
     (?$(03G(B . ?\x62F4) ;; <CJK>
     (?$(03H(B . ?\x6311) ;; <CJK>
     (?$(03I(B . ?\x6302) ;; <CJK>
     (?$(03J(B . ?\x653F) ;; <CJK>
     (?$(03K(B . ?\x6545) ;; <CJK>
     (?$(03L(B . ?\x65AB) ;; <CJK>
     (?$(03M(B . ?\x65BD) ;; <CJK>
     (?$(03N(B . ?\x65E2) ;; <CJK>
     (?$(03O(B . ?\x6625) ;; <CJK>
     (?$(03P(B . ?\x662D) ;; <CJK>
     (?$(03Q(B . ?\x6620) ;; <CJK>
     (?$(03R(B . ?\x6627) ;; <CJK>
     (?$(03S(B . ?\x662F) ;; <CJK>
     (?$(03T(B . ?\x661F) ;; <CJK>
     (?$(03U(B . ?\x6628) ;; <CJK>
     (?$(03V(B . ?\x6631) ;; <CJK>
     (?$(03W(B . ?\x6624) ;; <CJK>
     (?$(03X(B . ?\x66F7) ;; <CJK>
     (?$(03Y(B . ?\x67FF) ;; <CJK>
     (?$(03Z(B . ?\x67D3) ;; <CJK>
     (?$(03[(B . ?\x67F1) ;; <CJK>
     (?$(03\(B . ?\x67D4) ;; <CJK>
     (?$(03](B . ?\x67D0) ;; <CJK>
     (?$(03^(B . ?\x67EC) ;; <CJK>
     (?$(03_(B . ?\x67B6) ;; <CJK>
     (?$(03`(B . ?\x67AF) ;; <CJK>
     (?$(03a(B . ?\x67F5) ;; <CJK>
     (?$(03b(B . ?\x67E9) ;; <CJK>
     (?$(03c(B . ?\x67EF) ;; <CJK>
     (?$(03d(B . ?\x67C4) ;; <CJK>
     (?$(03e(B . ?\x67D1) ;; <CJK>
     (?$(03f(B . ?\x67B4) ;; <CJK>
     (?$(03g(B . ?\x67DA) ;; <CJK>
     (?$(03h(B . ?\x67E5) ;; <CJK>
     (?$(03i(B . ?\x67B8) ;; <CJK>
     (?$(03j(B . ?\x67CF) ;; <CJK>
     (?$(03k(B . ?\x67DE) ;; <CJK>
     (?$(03l(B . ?\x67F3) ;; <CJK>
     (?$(03m(B . ?\x67B0) ;; <CJK>
     (?$(03n(B . ?\x67D9) ;; <CJK>
     (?$(03o(B . ?\x67E2) ;; <CJK>
     (?$(03p(B . ?\x67DD) ;; <CJK>
     (?$(03q(B . ?\x67D2) ;; <CJK>
     (?$(03r(B . ?\x6B6A) ;; <CJK>
     (?$(03s(B . ?\x6B83) ;; <CJK>
     (?$(03t(B . ?\x6B86) ;; <CJK>
     (?$(03u(B . ?\x6BB5) ;; <CJK>
     (?$(03v(B . ?\x6BD2) ;; <CJK>
     (?$(03w(B . ?\x6BD7) ;; <CJK>
     (?$(03x(B . ?\x6C1F) ;; <CJK>
     (?$(03y(B . ?\x6CC9) ;; <CJK>
     (?$(03z(B . ?\x6D0B) ;; <CJK>
     (?$(03{(B . ?\x6D32) ;; <CJK>
     (?$(03|(B . ?\x6D2A) ;; <CJK>
     (?$(03}(B . ?\x6D41) ;; <CJK>
     (?$(03~(B . ?\x6D25) ;; <CJK>
     (?$(04!(B . ?\x6D0C) ;; <CJK>
     (?$(04"(B . ?\x6D31) ;; <CJK>
     (?$(04#(B . ?\x6D1E) ;; <CJK>
     (?$(04$(B . ?\x6D17) ;; <CJK>
     (?$(04%(B . ?\x6D3B) ;; <CJK>
     (?$(04&(B . ?\x6D3D) ;; <CJK>
     (?$(04'(B . ?\x6D3E) ;; <CJK>
     (?$(04((B . ?\x6D36) ;; <CJK>
     (?$(04)(B . ?\x6D1B) ;; <CJK>
     (?$(04*(B . ?\x6CF5) ;; <CJK>
     (?$(04+(B . ?\x6D39) ;; <CJK>
     (?$(04,(B . ?\x6D27) ;; <CJK>
     (?$(04-(B . ?\x6D38) ;; <CJK>
     (?$(04.(B . ?\x6D29) ;; <CJK>
     (?$(04/(B . ?\x6D2E) ;; <CJK>
     (?$(040(B . ?\x6D35) ;; <CJK>
     (?$(041(B . ?\x6D0E) ;; <CJK>
     (?$(042(B . ?\x6D2B) ;; <CJK>
     (?$(043(B . ?\x70AB) ;; <CJK>
     (?$(044(B . ?\x70BA) ;; <CJK>
     (?$(045(B . ?\x70B3) ;; <CJK>
     (?$(046(B . ?\x70AC) ;; <CJK>
     (?$(047(B . ?\x70AF) ;; <CJK>
     (?$(048(B . ?\x70AD) ;; <CJK>
     (?$(049(B . ?\x70B8) ;; <CJK>
     (?$(04:(B . ?\x70AE) ;; <CJK>
     (?$(04;(B . ?\x70A4) ;; <CJK>
     (?$(04<(B . ?\x7230) ;; <CJK>
     (?$(04=(B . ?\x7272) ;; <CJK>
     (?$(04>(B . ?\x726F) ;; <CJK>
     (?$(04?(B . ?\x7274) ;; <CJK>
     (?$(04@(B . ?\x72E9) ;; <CJK>
     (?$(04A(B . ?\x72E0) ;; <CJK>
     (?$(04B(B . ?\x72E1) ;; <CJK>
     (?$(04C(B . ?\x73B7) ;; <CJK>
     (?$(04D(B . ?\x73CA) ;; <CJK>
     (?$(04E(B . ?\x73BB) ;; <CJK>
     (?$(04F(B . ?\x73B2) ;; <CJK>
     (?$(04G(B . ?\x73CD) ;; <CJK>
     (?$(04H(B . ?\x73C0) ;; <CJK>
     (?$(04I(B . ?\x73B3) ;; <CJK>
     (?$(04J(B . ?\x751A) ;; <CJK>
     (?$(04K(B . ?\x752D) ;; <CJK>
     (?$(04L(B . ?\x754F) ;; <CJK>
     (?$(04M(B . ?\x754C) ;; <CJK>
     (?$(04N(B . ?\x754E) ;; <CJK>
     (?$(04O(B . ?\x754B) ;; <CJK>
     (?$(04P(B . ?\x75AB) ;; <CJK>
     (?$(04Q(B . ?\x75A4) ;; <CJK>
     (?$(04R(B . ?\x75A5) ;; <CJK>
     (?$(04S(B . ?\x75A2) ;; <CJK>
     (?$(04T(B . ?\x75A3) ;; <CJK>
     (?$(04U(B . ?\x7678) ;; <CJK>
     (?$(04V(B . ?\x7686) ;; <CJK>
     (?$(04W(B . ?\x7687) ;; <CJK>
     (?$(04X(B . ?\x7688) ;; <CJK>
     (?$(04Y(B . ?\x76C8) ;; <CJK>
     (?$(04Z(B . ?\x76C6) ;; <CJK>
     (?$(04[(B . ?\x76C3) ;; <CJK>
     (?$(04\(B . ?\x76C5) ;; <CJK>
     (?$(04](B . ?\x7701) ;; <CJK>
     (?$(04^(B . ?\x76F9) ;; <CJK>
     (?$(04_(B . ?\x76F8) ;; <CJK>
     (?$(04`(B . ?\x7709) ;; <CJK>
     (?$(04a(B . ?\x770B) ;; <CJK>
     (?$(04b(B . ?\x76FE) ;; <CJK>
     (?$(04c(B . ?\x76FC) ;; <CJK>
     (?$(04d(B . ?\x7707) ;; <CJK>
     (?$(04e(B . ?\x77DC) ;; <CJK>
     (?$(04f(B . ?\x7802) ;; <CJK>
     (?$(04g(B . ?\x7814) ;; <CJK>
     (?$(04h(B . ?\x780C) ;; <CJK>
     (?$(04i(B . ?\x780D) ;; <CJK>
     (?$(04j(B . ?\x7946) ;; <CJK>
     (?$(04k(B . ?\x7949) ;; <CJK>
     (?$(04l(B . ?\x7948) ;; <CJK>
     (?$(04m(B . ?\x7947) ;; <CJK>
     (?$(04n(B . ?\x79B9) ;; <CJK>
     (?$(04o(B . ?\x79BA) ;; <CJK>
     (?$(04p(B . ?\x79D1) ;; <CJK>
     (?$(04q(B . ?\x79D2) ;; <CJK>
     (?$(04r(B . ?\x79CB) ;; <CJK>
     (?$(04s(B . ?\x7A7F) ;; <CJK>
     (?$(04t(B . ?\x7A81) ;; <CJK>
     (?$(04u(B . ?\x7AFF) ;; <CJK>
     (?$(04v(B . ?\x7AFD) ;; <CJK>
     (?$(04w(B . ?\x7C7D) ;; <CJK>
     (?$(04x(B . ?\x7D02) ;; <CJK>
     (?$(04y(B . ?\x7D05) ;; <CJK>
     (?$(04z(B . ?\x7D00) ;; <CJK>
     (?$(04{(B . ?\x7D09) ;; <CJK>
     (?$(04|(B . ?\x7D07) ;; <CJK>
     (?$(04}(B . ?\x7D04) ;; <CJK>
     (?$(04~(B . ?\x7D06) ;; <CJK>
     (?$(05!(B . ?\x7F38) ;; <CJK>
     (?$(05"(B . ?\x7F8E) ;; <CJK>
     (?$(05#(B . ?\x7FBF) ;; <CJK>
     (?$(05$(B . ?\x8004) ;; <CJK>
     (?$(05%(B . ?\x8010) ;; <CJK>
     (?$(05&(B . ?\x800D) ;; <CJK>
     (?$(05'(B . ?\x8011) ;; <CJK>
     (?$(05((B . ?\x8036) ;; <CJK>
     (?$(05)(B . ?\x80D6) ;; <CJK>
     (?$(05*(B . ?\x80E5) ;; <CJK>
     (?$(05+(B . ?\x80DA) ;; <CJK>
     (?$(05,(B . ?\x80C3) ;; <CJK>
     (?$(05-(B . ?\x80C4) ;; <CJK>
     (?$(05.(B . ?\x80CC) ;; <CJK>
     (?$(05/(B . ?\x80E1) ;; <CJK>
     (?$(050(B . ?\x80DB) ;; <CJK>
     (?$(051(B . ?\x80CE) ;; <CJK>
     (?$(052(B . ?\x80DE) ;; <CJK>
     (?$(053(B . ?\x80E4) ;; <CJK>
     (?$(054(B . ?\x80DD) ;; <CJK>
     (?$(055(B . ?\x81F4) ;; <CJK>
     (?$(056(B . ?\x8222) ;; <CJK>
     (?$(057(B . ?\x82E7) ;; <CJK>
     (?$(058(B . ?\x8303) ;; <CJK>
     (?$(059(B . ?\x8305) ;; <CJK>
     (?$(05:(B . ?\x82E3) ;; <CJK>
     (?$(05;(B . ?\x82DB) ;; <CJK>
     (?$(05<(B . ?\x82E6) ;; <CJK>
     (?$(05=(B . ?\x8304) ;; <CJK>
     (?$(05>(B . ?\x82E5) ;; <CJK>
     (?$(05?(B . ?\x8302) ;; <CJK>
     (?$(05@(B . ?\x8309) ;; <CJK>
     (?$(05A(B . ?\x82D2) ;; <CJK>
     (?$(05B(B . ?\x82D7) ;; <CJK>
     (?$(05C(B . ?\x82F1) ;; <CJK>
     (?$(05D(B . ?\x8301) ;; <CJK>
     (?$(05E(B . ?\x82DC) ;; <CJK>
     (?$(05F(B . ?\x82D4) ;; <CJK>
     (?$(05G(B . ?\x82D1) ;; <CJK>
     (?$(05H(B . ?\x82DE) ;; <CJK>
     (?$(05I(B . ?\x82D3) ;; <CJK>
     (?$(05J(B . ?\x82DF) ;; <CJK>
     (?$(05K(B . ?\x82EF) ;; <CJK>
     (?$(05L(B . ?\x8306) ;; <CJK>
     (?$(05M(B . ?\x8650) ;; <CJK>
     (?$(05N(B . ?\x8679) ;; <CJK>
     (?$(05O(B . ?\x867B) ;; <CJK>
     (?$(05P(B . ?\x867A) ;; <CJK>
     (?$(05Q(B . ?\x884D) ;; <CJK>
     (?$(05R(B . ?\x886B) ;; <CJK>
     (?$(05S(B . ?\x8981) ;; <CJK>
     (?$(05T(B . ?\x89D4) ;; <CJK>
     (?$(05U(B . ?\x8A08) ;; <CJK>
     (?$(05V(B . ?\x8A02) ;; <CJK>
     (?$(05W(B . ?\x8A03) ;; <CJK>
     (?$(05X(B . ?\x8C9E) ;; <CJK>
     (?$(05Y(B . ?\x8CA0) ;; <CJK>
     (?$(05Z(B . ?\x8D74) ;; <CJK>
     (?$(05[(B . ?\x8D73) ;; <CJK>
     (?$(05\(B . ?\x8DB4) ;; <CJK>
     (?$(05](B . ?\x8ECD) ;; <CJK>
     (?$(05^(B . ?\x8ECC) ;; <CJK>
     (?$(05_(B . ?\x8FF0) ;; <CJK>
     (?$(05`(B . ?\x8FE6) ;; <CJK>
     (?$(05a(B . ?\x8FE2) ;; <CJK>
     (?$(05b(B . ?\x8FEA) ;; <CJK>
     (?$(05c(B . ?\x8FE5) ;; <CJK>
     (?$(05d(B . ?\x8FED) ;; <CJK>
     (?$(05e(B . ?\x8FEB) ;; <CJK>
     (?$(05f(B . ?\x8FE4) ;; <CJK>
     (?$(05g(B . ?\x8FE8) ;; <CJK>
     (?$(05h(B . ?\x90CA) ;; <CJK>
     (?$(05i(B . ?\x90CE) ;; <CJK>
     (?$(05j(B . ?\x90C1) ;; <CJK>
     (?$(05k(B . ?\x90C3) ;; <CJK>
     (?$(05l(B . ?\x914B) ;; <CJK>
     (?$(05m(B . ?\x914A) ;; <CJK>
     (?$(05n(B . ?\x91CD) ;; <CJK>
     (?$(05o(B . ?\x9582) ;; <CJK>
     (?$(05p(B . ?\x9650) ;; <CJK>
     (?$(05q(B . ?\x964B) ;; <CJK>
     (?$(05r(B . ?\x964C) ;; <CJK>
     (?$(05s(B . ?\x964D) ;; <CJK>
     (?$(05t(B . ?\x9762) ;; <CJK>
     (?$(05u(B . ?\x9769) ;; <CJK>
     (?$(05v(B . ?\x97CB) ;; <CJK>
     (?$(05w(B . ?\x97ED) ;; <CJK>
     (?$(05x(B . ?\x97F3) ;; <CJK>
     (?$(05y(B . ?\x9801) ;; <CJK>
     (?$(05z(B . ?\x98A8) ;; <CJK>
     (?$(05{(B . ?\x98DB) ;; <CJK>
     (?$(05|(B . ?\x98DF) ;; <CJK>
     (?$(05}(B . ?\x9996) ;; <CJK>
     (?$(05~(B . ?\x9999) ;; <CJK>
     (?$(06!(B . ?\x4E58) ;; <CJK>
     (?$(06"(B . ?\x4EB3) ;; <CJK>
     (?$(06#(B . ?\x500C) ;; <CJK>
     (?$(06$(B . ?\x500D) ;; <CJK>
     (?$(06%(B . ?\x5023) ;; <CJK>
     (?$(06&(B . ?\x4FEF) ;; <CJK>
     (?$(06'(B . ?\x5026) ;; <CJK>
     (?$(06((B . ?\x5025) ;; <CJK>
     (?$(06)(B . ?\x4FF8) ;; <CJK>
     (?$(06*(B . ?\x5029) ;; <CJK>
     (?$(06+(B . ?\x5016) ;; <CJK>
     (?$(06,(B . ?\x5006) ;; <CJK>
     (?$(06-(B . ?\x503C) ;; <CJK>
     (?$(06.(B . ?\x501F) ;; <CJK>
     (?$(06/(B . ?\x501A) ;; <CJK>
     (?$(060(B . ?\x5012) ;; <CJK>
     (?$(061(B . ?\x5011) ;; <CJK>
     (?$(062(B . ?\x4FFA) ;; <CJK>
     (?$(063(B . ?\x5000) ;; <CJK>
     (?$(064(B . ?\x5014) ;; <CJK>
     (?$(065(B . ?\x5028) ;; <CJK>
     (?$(066(B . ?\x4FF1) ;; <CJK>
     (?$(067(B . ?\x5021) ;; <CJK>
     (?$(068(B . ?\x500B) ;; <CJK>
     (?$(069(B . ?\x5019) ;; <CJK>
     (?$(06:(B . ?\x5018) ;; <CJK>
     (?$(06;(B . ?\x4FF3) ;; <CJK>
     (?$(06<(B . ?\x4FEE) ;; <CJK>
     (?$(06=(B . ?\x502D) ;; <CJK>
     (?$(06>(B . ?\x502A) ;; <CJK>
     (?$(06?(B . ?\x4FFE) ;; <CJK>
     (?$(06@(B . ?\x502B) ;; <CJK>
     (?$(06A(B . ?\x5009) ;; <CJK>
     (?$(06B(B . ?\x517C) ;; <CJK>
     (?$(06C(B . ?\x51A4) ;; <CJK>
     (?$(06D(B . ?\x51A5) ;; <CJK>
     (?$(06E(B . ?\x51A2) ;; <CJK>
     (?$(06F(B . ?\x51CD) ;; <CJK>
     (?$(06G(B . ?\x51CC) ;; <CJK>
     (?$(06H(B . ?\x51C6) ;; <CJK>
     (?$(06I(B . ?\x51CB) ;; <CJK>
     (?$(06J(B . ?\x5256) ;; <CJK>
     (?$(06K(B . ?\x525C) ;; <CJK>
     (?$(06L(B . ?\x5254) ;; <CJK>
     (?$(06M(B . ?\x525B) ;; <CJK>
     (?$(06N(B . ?\x525D) ;; <CJK>
     (?$(06O(B . ?\x532A) ;; <CJK>
     (?$(06P(B . ?\x537F) ;; <CJK>
     (?$(06Q(B . ?\x539F) ;; <CJK>
     (?$(06R(B . ?\x539D) ;; <CJK>
     (?$(06S(B . ?\x53DF) ;; <CJK>
     (?$(06T(B . ?\x54E8) ;; <CJK>
     (?$(06U(B . ?\x5510) ;; <CJK>
     (?$(06V(B . ?\x5501) ;; <CJK>
     (?$(06W(B . ?\x5537) ;; <CJK>
     (?$(06X(B . ?\x54FC) ;; <CJK>
     (?$(06Y(B . ?\x54E5) ;; <CJK>
     (?$(06Z(B . ?\x54F2) ;; <CJK>
     (?$(06[(B . ?\x5506) ;; <CJK>
     (?$(06\(B . ?\x54FA) ;; <CJK>
     (?$(06](B . ?\x5514) ;; <CJK>
     (?$(06^(B . ?\x54E9) ;; <CJK>
     (?$(06_(B . ?\x54ED) ;; <CJK>
     (?$(06`(B . ?\x54E1) ;; <CJK>
     (?$(06a(B . ?\x5509) ;; <CJK>
     (?$(06b(B . ?\x54EE) ;; <CJK>
     (?$(06c(B . ?\x54EA) ;; <CJK>
     (?$(06d(B . ?\x54E6) ;; <CJK>
     (?$(06e(B . ?\x5527) ;; <CJK>
     (?$(06f(B . ?\x5507) ;; <CJK>
     (?$(06g(B . ?\x54FD) ;; <CJK>
     (?$(06h(B . ?\x550F) ;; <CJK>
     (?$(06i(B . ?\x5703) ;; <CJK>
     (?$(06j(B . ?\x5704) ;; <CJK>
     (?$(06k(B . ?\x57C2) ;; <CJK>
     (?$(06l(B . ?\x57D4) ;; <CJK>
     (?$(06m(B . ?\x57CB) ;; <CJK>
     (?$(06n(B . ?\x57C3) ;; <CJK>
     (?$(06o(B . ?\x5809) ;; <CJK>
     (?$(06p(B . ?\x590F) ;; <CJK>
     (?$(06q(B . ?\x5957) ;; <CJK>
     (?$(06r(B . ?\x5958) ;; <CJK>
     (?$(06s(B . ?\x595A) ;; <CJK>
     (?$(06t(B . ?\x5A11) ;; <CJK>
     (?$(06u(B . ?\x5A18) ;; <CJK>
     (?$(06v(B . ?\x5A1C) ;; <CJK>
     (?$(06w(B . ?\x5A1F) ;; <CJK>
     (?$(06x(B . ?\x5A1B) ;; <CJK>
     (?$(06y(B . ?\x5A13) ;; <CJK>
     (?$(06z(B . ?\x59EC) ;; <CJK>
     (?$(06{(B . ?\x5A20) ;; <CJK>
     (?$(06|(B . ?\x5A23) ;; <CJK>
     (?$(06}(B . ?\x5A29) ;; <CJK>
     (?$(06~(B . ?\x5A25) ;; <CJK>
     (?$(07!(B . ?\x5A0C) ;; <CJK>
     (?$(07"(B . ?\x5A09) ;; <CJK>
     (?$(07#(B . ?\x5B6B) ;; <CJK>
     (?$(07$(B . ?\x5C58) ;; <CJK>
     (?$(07%(B . ?\x5BB0) ;; <CJK>
     (?$(07&(B . ?\x5BB3) ;; <CJK>
     (?$(07'(B . ?\x5BB6) ;; <CJK>
     (?$(07((B . ?\x5BB4) ;; <CJK>
     (?$(07)(B . ?\x5BAE) ;; <CJK>
     (?$(07*(B . ?\x5BB5) ;; <CJK>
     (?$(07+(B . ?\x5BB9) ;; <CJK>
     (?$(07,(B . ?\x5BB8) ;; <CJK>
     (?$(07-(B . ?\x5C04) ;; <CJK>
     (?$(07.(B . ?\x5C51) ;; <CJK>
     (?$(07/(B . ?\x5C55) ;; <CJK>
     (?$(070(B . ?\x5C50) ;; <CJK>
     (?$(071(B . ?\x5CED) ;; <CJK>
     (?$(072(B . ?\x5CFD) ;; <CJK>
     (?$(073(B . ?\x5CFB) ;; <CJK>
     (?$(074(B . ?\x5CEA) ;; <CJK>
     (?$(075(B . ?\x5CE8) ;; <CJK>
     (?$(076(B . ?\x5CF0) ;; <CJK>
     (?$(077(B . ?\x5CF6) ;; <CJK>
     (?$(078(B . ?\x5D01) ;; <CJK>
     (?$(079(B . ?\x5CF4) ;; <CJK>
     (?$(07:(B . ?\x5DEE) ;; <CJK>
     (?$(07;(B . ?\x5E2D) ;; <CJK>
     (?$(07<(B . ?\x5E2B) ;; <CJK>
     (?$(07=(B . ?\x5EAB) ;; <CJK>
     (?$(07>(B . ?\x5EAD) ;; <CJK>
     (?$(07?(B . ?\x5EA7) ;; <CJK>
     (?$(07@(B . ?\x5F31) ;; <CJK>
     (?$(07A(B . ?\x5F92) ;; <CJK>
     (?$(07B(B . ?\x5F91) ;; <CJK>
     (?$(07C(B . ?\x5F90) ;; <CJK>
     (?$(07D(B . ?\x6059) ;; <CJK>
     (?$(07E(B . ?\x6063) ;; <CJK>
     (?$(07F(B . ?\x6065) ;; <CJK>
     (?$(07G(B . ?\x6050) ;; <CJK>
     (?$(07H(B . ?\x6055) ;; <CJK>
     (?$(07I(B . ?\x606D) ;; <CJK>
     (?$(07J(B . ?\x6069) ;; <CJK>
     (?$(07K(B . ?\x606F) ;; <CJK>
     (?$(07L(B . ?\x6084) ;; <CJK>
     (?$(07M(B . ?\x609F) ;; <CJK>
     (?$(07N(B . ?\x609A) ;; <CJK>
     (?$(07O(B . ?\x608D) ;; <CJK>
     (?$(07P(B . ?\x6094) ;; <CJK>
     (?$(07Q(B . ?\x608C) ;; <CJK>
     (?$(07R(B . ?\x6085) ;; <CJK>
     (?$(07S(B . ?\x6096) ;; <CJK>
     (?$(07T(B . ?\x6247) ;; <CJK>
     (?$(07U(B . ?\x62F3) ;; <CJK>
     (?$(07V(B . ?\x6308) ;; <CJK>
     (?$(07W(B . ?\x62FF) ;; <CJK>
     (?$(07X(B . ?\x634E) ;; <CJK>
     (?$(07Y(B . ?\x633E) ;; <CJK>
     (?$(07Z(B . ?\x632F) ;; <CJK>
     (?$(07[(B . ?\x6355) ;; <CJK>
     (?$(07\(B . ?\x6342) ;; <CJK>
     (?$(07](B . ?\x6346) ;; <CJK>
     (?$(07^(B . ?\x634F) ;; <CJK>
     (?$(07_(B . ?\x6349) ;; <CJK>
     (?$(07`(B . ?\x633A) ;; <CJK>
     (?$(07a(B . ?\x6350) ;; <CJK>
     (?$(07b(B . ?\x633D) ;; <CJK>
     (?$(07c(B . ?\x632A) ;; <CJK>
     (?$(07d(B . ?\x632B) ;; <CJK>
     (?$(07e(B . ?\x6328) ;; <CJK>
     (?$(07f(B . ?\x634D) ;; <CJK>
     (?$(07g(B . ?\x634C) ;; <CJK>
     (?$(07h(B . ?\x6548) ;; <CJK>
     (?$(07i(B . ?\x6549) ;; <CJK>
     (?$(07j(B . ?\x6599) ;; <CJK>
     (?$(07k(B . ?\x65C1) ;; <CJK>
     (?$(07l(B . ?\x65C5) ;; <CJK>
     (?$(07m(B . ?\x6642) ;; <CJK>
     (?$(07n(B . ?\x6649) ;; <CJK>
     (?$(07o(B . ?\x664F) ;; <CJK>
     (?$(07p(B . ?\x6643) ;; <CJK>
     (?$(07q(B . ?\x6652) ;; <CJK>
     (?$(07r(B . ?\x664C) ;; <CJK>
     (?$(07s(B . ?\x6645) ;; <CJK>
     (?$(07t(B . ?\x6641) ;; <CJK>
     (?$(07u(B . ?\x66F8) ;; <CJK>
     (?$(07v(B . ?\x6714) ;; <CJK>
     (?$(07w(B . ?\x6715) ;; <CJK>
     (?$(07x(B . ?\x6717) ;; <CJK>
     (?$(07y(B . ?\x6821) ;; <CJK>
     (?$(07z(B . ?\x6838) ;; <CJK>
     (?$(07{(B . ?\x6848) ;; <CJK>
     (?$(07|(B . ?\x6846) ;; <CJK>
     (?$(07}(B . ?\x6853) ;; <CJK>
     (?$(07~(B . ?\x6839) ;; <CJK>
     (?$(08!(B . ?\x6842) ;; <CJK>
     (?$(08"(B . ?\x6854) ;; <CJK>
     (?$(08#(B . ?\x6829) ;; <CJK>
     (?$(08$(B . ?\x68B3) ;; <CJK>
     (?$(08%(B . ?\x6817) ;; <CJK>
     (?$(08&(B . ?\x684C) ;; <CJK>
     (?$(08'(B . ?\x6851) ;; <CJK>
     (?$(08((B . ?\x683D) ;; <CJK>
     (?$(08)(B . ?\x67F4) ;; <CJK>
     (?$(08*(B . ?\x6850) ;; <CJK>
     (?$(08+(B . ?\x6840) ;; <CJK>
     (?$(08,(B . ?\x683C) ;; <CJK>
     (?$(08-(B . ?\x6843) ;; <CJK>
     (?$(08.(B . ?\x682A) ;; <CJK>
     (?$(08/(B . ?\x6845) ;; <CJK>
     (?$(080(B . ?\x6813) ;; <CJK>
     (?$(081(B . ?\x6818) ;; <CJK>
     (?$(082(B . ?\x6841) ;; <CJK>
     (?$(083(B . ?\x6B8A) ;; <CJK>
     (?$(084(B . ?\x6B89) ;; <CJK>
     (?$(085(B . ?\x6BB7) ;; <CJK>
     (?$(086(B . ?\x6C23) ;; <CJK>
     (?$(087(B . ?\x6C27) ;; <CJK>
     (?$(088(B . ?\x6C28) ;; <CJK>
     (?$(089(B . ?\x6C26) ;; <CJK>
     (?$(08:(B . ?\x6C24) ;; <CJK>
     (?$(08;(B . ?\x6CF0) ;; <CJK>
     (?$(08<(B . ?\x6D6A) ;; <CJK>
     (?$(08=(B . ?\x6D95) ;; <CJK>
     (?$(08>(B . ?\x6D88) ;; <CJK>
     (?$(08?(B . ?\x6D87) ;; <CJK>
     (?$(08@(B . ?\x6D66) ;; <CJK>
     (?$(08A(B . ?\x6D78) ;; <CJK>
     (?$(08B(B . ?\x6D77) ;; <CJK>
     (?$(08C(B . ?\x6D59) ;; <CJK>
     (?$(08D(B . ?\x6D93) ;; <CJK>
     (?$(08E(B . ?\x6D6C) ;; <CJK>
     (?$(08F(B . ?\x6D89) ;; <CJK>
     (?$(08G(B . ?\x6D6E) ;; <CJK>
     (?$(08H(B . ?\x6D5A) ;; <CJK>
     (?$(08I(B . ?\x6D74) ;; <CJK>
     (?$(08J(B . ?\x6D69) ;; <CJK>
     (?$(08K(B . ?\x6D8C) ;; <CJK>
     (?$(08L(B . ?\x6D8A) ;; <CJK>
     (?$(08M(B . ?\x6D79) ;; <CJK>
     (?$(08N(B . ?\x6D85) ;; <CJK>
     (?$(08O(B . ?\x6D65) ;; <CJK>
     (?$(08P(B . ?\x6D94) ;; <CJK>
     (?$(08Q(B . ?\x70CA) ;; <CJK>
     (?$(08R(B . ?\x70D8) ;; <CJK>
     (?$(08S(B . ?\x70E4) ;; <CJK>
     (?$(08T(B . ?\x70D9) ;; <CJK>
     (?$(08U(B . ?\x70C8) ;; <CJK>
     (?$(08V(B . ?\x70CF) ;; <CJK>
     (?$(08W(B . ?\x7239) ;; <CJK>
     (?$(08X(B . ?\x7279) ;; <CJK>
     (?$(08Y(B . ?\x72FC) ;; <CJK>
     (?$(08Z(B . ?\x72F9) ;; <CJK>
     (?$(08[(B . ?\x72FD) ;; <CJK>
     (?$(08\(B . ?\x72F8) ;; <CJK>
     (?$(08](B . ?\x72F7) ;; <CJK>
     (?$(08^(B . ?\x7386) ;; <CJK>
     (?$(08_(B . ?\x73ED) ;; <CJK>
     (?$(08`(B . ?\x7409) ;; <CJK>
     (?$(08a(B . ?\x73EE) ;; <CJK>
     (?$(08b(B . ?\x73E0) ;; <CJK>
     (?$(08c(B . ?\x73EA) ;; <CJK>
     (?$(08d(B . ?\x73DE) ;; <CJK>
     (?$(08e(B . ?\x7554) ;; <CJK>
     (?$(08f(B . ?\x755D) ;; <CJK>
     (?$(08g(B . ?\x755C) ;; <CJK>
     (?$(08h(B . ?\x755A) ;; <CJK>
     (?$(08i(B . ?\x7559) ;; <CJK>
     (?$(08j(B . ?\x75BE) ;; <CJK>
     (?$(08k(B . ?\x75C5) ;; <CJK>
     (?$(08l(B . ?\x75C7) ;; <CJK>
     (?$(08m(B . ?\x75B2) ;; <CJK>
     (?$(08n(B . ?\x75B3) ;; <CJK>
     (?$(08o(B . ?\x75BD) ;; <CJK>
     (?$(08p(B . ?\x75BC) ;; <CJK>
     (?$(08q(B . ?\x75B9) ;; <CJK>
     (?$(08r(B . ?\x75C2) ;; <CJK>
     (?$(08s(B . ?\x75B8) ;; <CJK>
     (?$(08t(B . ?\x768B) ;; <CJK>
     (?$(08u(B . ?\x76B0) ;; <CJK>
     (?$(08v(B . ?\x76CA) ;; <CJK>
     (?$(08w(B . ?\x76CD) ;; <CJK>
     (?$(08x(B . ?\x76CE) ;; <CJK>
     (?$(08y(B . ?\x7729) ;; <CJK>
     (?$(08z(B . ?\x771F) ;; <CJK>
     (?$(08{(B . ?\x7720) ;; <CJK>
     (?$(08|(B . ?\x7728) ;; <CJK>
     (?$(08}(B . ?\x77E9) ;; <CJK>
     (?$(08~(B . ?\x7830) ;; <CJK>
     (?$(09!(B . ?\x7827) ;; <CJK>
     (?$(09"(B . ?\x7838) ;; <CJK>
     (?$(09#(B . ?\x781D) ;; <CJK>
     (?$(09$(B . ?\x7834) ;; <CJK>
     (?$(09%(B . ?\x7837) ;; <CJK>
     (?$(09&(B . ?\x7825) ;; <CJK>
     (?$(09'(B . ?\x782D) ;; <CJK>
     (?$(09((B . ?\x7820) ;; <CJK>
     (?$(09)(B . ?\x781F) ;; <CJK>
     (?$(09*(B . ?\x7832) ;; <CJK>
     (?$(09+(B . ?\x7955) ;; <CJK>
     (?$(09,(B . ?\x7950) ;; <CJK>
     (?$(09-(B . ?\x7960) ;; <CJK>
     (?$(09.(B . ?\x795F) ;; <CJK>
     (?$(09/(B . ?\x7956) ;; <CJK>
     (?$(090(B . ?\x795E) ;; <CJK>
     (?$(091(B . ?\x795D) ;; <CJK>
     (?$(092(B . ?\x7957) ;; <CJK>
     (?$(093(B . ?\x795A) ;; <CJK>
     (?$(094(B . ?\x79E4) ;; <CJK>
     (?$(095(B . ?\x79E3) ;; <CJK>
     (?$(096(B . ?\x79E7) ;; <CJK>
     (?$(097(B . ?\x79DF) ;; <CJK>
     (?$(098(B . ?\x79E6) ;; <CJK>
     (?$(099(B . ?\x79E9) ;; <CJK>
     (?$(09:(B . ?\x79D8) ;; <CJK>
     (?$(09;(B . ?\x7A84) ;; <CJK>
     (?$(09<(B . ?\x7A88) ;; <CJK>
     (?$(09=(B . ?\x7AD9) ;; <CJK>
     (?$(09>(B . ?\x7B06) ;; <CJK>
     (?$(09?(B . ?\x7B11) ;; <CJK>
     (?$(09@(B . ?\x7C89) ;; <CJK>
     (?$(09A(B . ?\x7D21) ;; <CJK>
     (?$(09B(B . ?\x7D17) ;; <CJK>
     (?$(09C(B . ?\x7D0B) ;; <CJK>
     (?$(09D(B . ?\x7D0A) ;; <CJK>
     (?$(09E(B . ?\x7D20) ;; <CJK>
     (?$(09F(B . ?\x7D22) ;; <CJK>
     (?$(09G(B . ?\x7D14) ;; <CJK>
     (?$(09H(B . ?\x7D10) ;; <CJK>
     (?$(09I(B . ?\x7D15) ;; <CJK>
     (?$(09J(B . ?\x7D1A) ;; <CJK>
     (?$(09K(B . ?\x7D1C) ;; <CJK>
     (?$(09L(B . ?\x7D0D) ;; <CJK>
     (?$(09M(B . ?\x7D19) ;; <CJK>
     (?$(09N(B . ?\x7D1B) ;; <CJK>
     (?$(09O(B . ?\x7F3A) ;; <CJK>
     (?$(09P(B . ?\x7F5F) ;; <CJK>
     (?$(09Q(B . ?\x7F94) ;; <CJK>
     (?$(09R(B . ?\x7FC5) ;; <CJK>
     (?$(09S(B . ?\x7FC1) ;; <CJK>
     (?$(09T(B . ?\x8006) ;; <CJK>
     (?$(09U(B . ?\x8018) ;; <CJK>
     (?$(09V(B . ?\x8015) ;; <CJK>
     (?$(09W(B . ?\x8019) ;; <CJK>
     (?$(09X(B . ?\x8017) ;; <CJK>
     (?$(09Y(B . ?\x803D) ;; <CJK>
     (?$(09Z(B . ?\x803F) ;; <CJK>
     (?$(09[(B . ?\x80F1) ;; <CJK>
     (?$(09\(B . ?\x8102) ;; <CJK>
     (?$(09](B . ?\x80F0) ;; <CJK>
     (?$(09^(B . ?\x8105) ;; <CJK>
     (?$(09_(B . ?\x80ED) ;; <CJK>
     (?$(09`(B . ?\x80F4) ;; <CJK>
     (?$(09a(B . ?\x8106) ;; <CJK>
     (?$(09b(B . ?\x80F8) ;; <CJK>
     (?$(09c(B . ?\x80F3) ;; <CJK>
     (?$(09d(B . ?\x8108) ;; <CJK>
     (?$(09e(B . ?\x80FD) ;; <CJK>
     (?$(09f(B . ?\x810A) ;; <CJK>
     (?$(09g(B . ?\x80FC) ;; <CJK>
     (?$(09h(B . ?\x80EF) ;; <CJK>
     (?$(09i(B . ?\x81ED) ;; <CJK>
     (?$(09j(B . ?\x81EC) ;; <CJK>
     (?$(09k(B . ?\x8200) ;; <CJK>
     (?$(09l(B . ?\x8210) ;; <CJK>
     (?$(09m(B . ?\x822A) ;; <CJK>
     (?$(09n(B . ?\x822B) ;; <CJK>
     (?$(09o(B . ?\x8228) ;; <CJK>
     (?$(09p(B . ?\x822C) ;; <CJK>
     (?$(09q(B . ?\x82BB) ;; <CJK>
     (?$(09r(B . ?\x832B) ;; <CJK>
     (?$(09s(B . ?\x8352) ;; <CJK>
     (?$(09t(B . ?\x8354) ;; <CJK>
     (?$(09u(B . ?\x834A) ;; <CJK>
     (?$(09v(B . ?\x8338) ;; <CJK>
     (?$(09w(B . ?\x8350) ;; <CJK>
     (?$(09x(B . ?\x8349) ;; <CJK>
     (?$(09y(B . ?\x8335) ;; <CJK>
     (?$(09z(B . ?\x8334) ;; <CJK>
     (?$(09{(B . ?\x834F) ;; <CJK>
     (?$(09|(B . ?\x8332) ;; <CJK>
     (?$(09}(B . ?\x8339) ;; <CJK>
     (?$(09~(B . ?\x8336) ;; <CJK>
     (?$(0:!(B . ?\x8317) ;; <CJK>
     (?$(0:"(B . ?\x8340) ;; <CJK>
     (?$(0:#(B . ?\x8331) ;; <CJK>
     (?$(0:$(B . ?\x8328) ;; <CJK>
     (?$(0:%(B . ?\x8343) ;; <CJK>
     (?$(0:&(B . ?\x8654) ;; <CJK>
     (?$(0:'(B . ?\x868A) ;; <CJK>
     (?$(0:((B . ?\x86AA) ;; <CJK>
     (?$(0:)(B . ?\x8693) ;; <CJK>
     (?$(0:*(B . ?\x86A4) ;; <CJK>
     (?$(0:+(B . ?\x86A9) ;; <CJK>
     (?$(0:,(B . ?\x868C) ;; <CJK>
     (?$(0:-(B . ?\x86A3) ;; <CJK>
     (?$(0:.(B . ?\x869C) ;; <CJK>
     (?$(0:/(B . ?\x8870) ;; <CJK>
     (?$(0:0(B . ?\x8877) ;; <CJK>
     (?$(0:1(B . ?\x8881) ;; <CJK>
     (?$(0:2(B . ?\x8882) ;; <CJK>
     (?$(0:3(B . ?\x887D) ;; <CJK>
     (?$(0:4(B . ?\x8879) ;; <CJK>
     (?$(0:5(B . ?\x8A18) ;; <CJK>
     (?$(0:6(B . ?\x8A10) ;; <CJK>
     (?$(0:7(B . ?\x8A0E) ;; <CJK>
     (?$(0:8(B . ?\x8A0C) ;; <CJK>
     (?$(0:9(B . ?\x8A15) ;; <CJK>
     (?$(0::(B . ?\x8A0A) ;; <CJK>
     (?$(0:;(B . ?\x8A17) ;; <CJK>
     (?$(0:<(B . ?\x8A13) ;; <CJK>
     (?$(0:=(B . ?\x8A16) ;; <CJK>
     (?$(0:>(B . ?\x8A0F) ;; <CJK>
     (?$(0:?(B . ?\x8A11) ;; <CJK>
     (?$(0:@(B . ?\x8C48) ;; <CJK>
     (?$(0:A(B . ?\x8C7A) ;; <CJK>
     (?$(0:B(B . ?\x8C79) ;; <CJK>
     (?$(0:C(B . ?\x8CA1) ;; <CJK>
     (?$(0:D(B . ?\x8CA2) ;; <CJK>
     (?$(0:E(B . ?\x8D77) ;; <CJK>
     (?$(0:F(B . ?\x8EAC) ;; <CJK>
     (?$(0:G(B . ?\x8ED2) ;; <CJK>
     (?$(0:H(B . ?\x8ED4) ;; <CJK>
     (?$(0:I(B . ?\x8ECF) ;; <CJK>
     (?$(0:J(B . ?\x8FB1) ;; <CJK>
     (?$(0:K(B . ?\x9001) ;; <CJK>
     (?$(0:L(B . ?\x9006) ;; <CJK>
     (?$(0:M(B . ?\x8FF7) ;; <CJK>
     (?$(0:N(B . ?\x9000) ;; <CJK>
     (?$(0:O(B . ?\x8FFA) ;; <CJK>
     (?$(0:P(B . ?\x8FF4) ;; <CJK>
     (?$(0:Q(B . ?\x9003) ;; <CJK>
     (?$(0:R(B . ?\x8FFD) ;; <CJK>
     (?$(0:S(B . ?\x9005) ;; <CJK>
     (?$(0:T(B . ?\x8FF8) ;; <CJK>
     (?$(0:U(B . ?\x9095) ;; <CJK>
     (?$(0:V(B . ?\x90E1) ;; <CJK>
     (?$(0:W(B . ?\x90DD) ;; <CJK>
     (?$(0:X(B . ?\x90E2) ;; <CJK>
     (?$(0:Y(B . ?\x9152) ;; <CJK>
     (?$(0:Z(B . ?\x914D) ;; <CJK>
     (?$(0:[(B . ?\x914C) ;; <CJK>
     (?$(0:\(B . ?\x91D8) ;; <CJK>
     (?$(0:](B . ?\x91DD) ;; <CJK>
     (?$(0:^(B . ?\x91D7) ;; <CJK>
     (?$(0:_(B . ?\x91DC) ;; <CJK>
     (?$(0:`(B . ?\x91D9) ;; <CJK>
     (?$(0:a(B . ?\x9583) ;; <CJK>
     (?$(0:b(B . ?\x9662) ;; <CJK>
     (?$(0:c(B . ?\x9663) ;; <CJK>
     (?$(0:d(B . ?\x9661) ;; <CJK>
     (?$(0:e(B . ?\x965B) ;; <CJK>
     (?$(0:f(B . ?\x965D) ;; <CJK>
     (?$(0:g(B . ?\x9664) ;; <CJK>
     (?$(0:h(B . ?\x9658) ;; <CJK>
     (?$(0:i(B . ?\x965E) ;; <CJK>
     (?$(0:j(B . ?\x96BB) ;; <CJK>
     (?$(0:k(B . ?\x98E2) ;; <CJK>
     (?$(0:l(B . ?\x99AC) ;; <CJK>
     (?$(0:m(B . ?\x9AA8) ;; <CJK>
     (?$(0:n(B . ?\x9AD8) ;; <CJK>
     (?$(0:o(B . ?\x9B25) ;; <CJK>
     (?$(0:p(B . ?\x9B32) ;; <CJK>
     (?$(0:q(B . ?\x9B3C) ;; <CJK>
     (?$(0:r(B . ?\x4E7E) ;; <CJK>
     (?$(0:s(B . ?\x507A) ;; <CJK>
     (?$(0:t(B . ?\x507D) ;; <CJK>
     (?$(0:u(B . ?\x505C) ;; <CJK>
     (?$(0:v(B . ?\x5047) ;; <CJK>
     (?$(0:w(B . ?\x5043) ;; <CJK>
     (?$(0:x(B . ?\x504C) ;; <CJK>
     (?$(0:y(B . ?\x505A) ;; <CJK>
     (?$(0:z(B . ?\x5049) ;; <CJK>
     (?$(0:{(B . ?\x5065) ;; <CJK>
     (?$(0:|(B . ?\x5076) ;; <CJK>
     (?$(0:}(B . ?\x504E) ;; <CJK>
     (?$(0:~(B . ?\x5055) ;; <CJK>
     (?$(0;!(B . ?\x5075) ;; <CJK>
     (?$(0;"(B . ?\x5074) ;; <CJK>
     (?$(0;#(B . ?\x5077) ;; <CJK>
     (?$(0;$(B . ?\x504F) ;; <CJK>
     (?$(0;%(B . ?\x500F) ;; <CJK>
     (?$(0;&(B . ?\x506F) ;; <CJK>
     (?$(0;'(B . ?\x506D) ;; <CJK>
     (?$(0;((B . ?\x515C) ;; <CJK>
     (?$(0;)(B . ?\x5195) ;; <CJK>
     (?$(0;*(B . ?\x51F0) ;; <CJK>
     (?$(0;+(B . ?\x526A) ;; <CJK>
     (?$(0;,(B . ?\x526F) ;; <CJK>
     (?$(0;-(B . ?\x52D2) ;; <CJK>
     (?$(0;.(B . ?\x52D9) ;; <CJK>
     (?$(0;/(B . ?\x52D8) ;; <CJK>
     (?$(0;0(B . ?\x52D5) ;; <CJK>
     (?$(0;1(B . ?\x5310) ;; <CJK>
     (?$(0;2(B . ?\x530F) ;; <CJK>
     (?$(0;3(B . ?\x5319) ;; <CJK>
     (?$(0;4(B . ?\x533F) ;; <CJK>
     (?$(0;5(B . ?\x5340) ;; <CJK>
     (?$(0;6(B . ?\x533E) ;; <CJK>
     (?$(0;7(B . ?\x53C3) ;; <CJK>
     (?$(0;8(B . ?\x66FC) ;; <CJK>
     (?$(0;9(B . ?\x5546) ;; <CJK>
     (?$(0;:(B . ?\x556A) ;; <CJK>
     (?$(0;;(B . ?\x5566) ;; <CJK>
     (?$(0;<(B . ?\x5544) ;; <CJK>
     (?$(0;=(B . ?\x555E) ;; <CJK>
     (?$(0;>(B . ?\x5561) ;; <CJK>
     (?$(0;?(B . ?\x5543) ;; <CJK>
     (?$(0;@(B . ?\x554A) ;; <CJK>
     (?$(0;A(B . ?\x5531) ;; <CJK>
     (?$(0;B(B . ?\x5556) ;; <CJK>
     (?$(0;C(B . ?\x554F) ;; <CJK>
     (?$(0;D(B . ?\x5555) ;; <CJK>
     (?$(0;E(B . ?\x552F) ;; <CJK>
     (?$(0;F(B . ?\x5564) ;; <CJK>
     (?$(0;G(B . ?\x5538) ;; <CJK>
     (?$(0;H(B . ?\x552E) ;; <CJK>
     (?$(0;I(B . ?\x555C) ;; <CJK>
     (?$(0;J(B . ?\x552C) ;; <CJK>
     (?$(0;K(B . ?\x5563) ;; <CJK>
     (?$(0;L(B . ?\x5533) ;; <CJK>
     (?$(0;M(B . ?\x5541) ;; <CJK>
     (?$(0;N(B . ?\x5557) ;; <CJK>
     (?$(0;O(B . ?\x5708) ;; <CJK>
     (?$(0;P(B . ?\x570B) ;; <CJK>
     (?$(0;Q(B . ?\x5709) ;; <CJK>
     (?$(0;R(B . ?\x57DF) ;; <CJK>
     (?$(0;S(B . ?\x5805) ;; <CJK>
     (?$(0;T(B . ?\x580A) ;; <CJK>
     (?$(0;U(B . ?\x5806) ;; <CJK>
     (?$(0;V(B . ?\x57E0) ;; <CJK>
     (?$(0;W(B . ?\x57E4) ;; <CJK>
     (?$(0;X(B . ?\x57FA) ;; <CJK>
     (?$(0;Y(B . ?\x5802) ;; <CJK>
     (?$(0;Z(B . ?\x5835) ;; <CJK>
     (?$(0;[(B . ?\x57F7) ;; <CJK>
     (?$(0;\(B . ?\x57F9) ;; <CJK>
     (?$(0;](B . ?\x5920) ;; <CJK>
     (?$(0;^(B . ?\x5962) ;; <CJK>
     (?$(0;_(B . ?\x5A36) ;; <CJK>
     (?$(0;`(B . ?\x5A41) ;; <CJK>
     (?$(0;a(B . ?\x5A49) ;; <CJK>
     (?$(0;b(B . ?\x5A66) ;; <CJK>
     (?$(0;c(B . ?\x5A6A) ;; <CJK>
     (?$(0;d(B . ?\x5A40) ;; <CJK>
     (?$(0;e(B . ?\x5A3C) ;; <CJK>
     (?$(0;f(B . ?\x5A62) ;; <CJK>
     (?$(0;g(B . ?\x5A5A) ;; <CJK>
     (?$(0;h(B . ?\x5A46) ;; <CJK>
     (?$(0;i(B . ?\x5A4A) ;; <CJK>
     (?$(0;j(B . ?\x5B70) ;; <CJK>
     (?$(0;k(B . ?\x5BC7) ;; <CJK>
     (?$(0;l(B . ?\x5BC5) ;; <CJK>
     (?$(0;m(B . ?\x5BC4) ;; <CJK>
     (?$(0;n(B . ?\x5BC2) ;; <CJK>
     (?$(0;o(B . ?\x5BBF) ;; <CJK>
     (?$(0;p(B . ?\x5BC6) ;; <CJK>
     (?$(0;q(B . ?\x5C09) ;; <CJK>
     (?$(0;r(B . ?\x5C08) ;; <CJK>
     (?$(0;s(B . ?\x5C07) ;; <CJK>
     (?$(0;t(B . ?\x5C60) ;; <CJK>
     (?$(0;u(B . ?\x5C5C) ;; <CJK>
     (?$(0;v(B . ?\x5C5D) ;; <CJK>
     (?$(0;w(B . ?\x5D07) ;; <CJK>
     (?$(0;x(B . ?\x5D06) ;; <CJK>
     (?$(0;y(B . ?\x5D0E) ;; <CJK>
     (?$(0;z(B . ?\x5D1B) ;; <CJK>
     (?$(0;{(B . ?\x5D16) ;; <CJK>
     (?$(0;|(B . ?\x5D22) ;; <CJK>
     (?$(0;}(B . ?\x5D11) ;; <CJK>
     (?$(0;~(B . ?\x5D29) ;; <CJK>
     (?$(0<!(B . ?\x5D14) ;; <CJK>
     (?$(0<"(B . ?\x5D19) ;; <CJK>
     (?$(0<#(B . ?\x5D24) ;; <CJK>
     (?$(0<$(B . ?\x5D27) ;; <CJK>
     (?$(0<%(B . ?\x5D17) ;; <CJK>
     (?$(0<&(B . ?\x5DE2) ;; <CJK>
     (?$(0<'(B . ?\x5E38) ;; <CJK>
     (?$(0<((B . ?\x5E36) ;; <CJK>
     (?$(0<)(B . ?\x5E33) ;; <CJK>
     (?$(0<*(B . ?\x5E37) ;; <CJK>
     (?$(0<+(B . ?\x5EB7) ;; <CJK>
     (?$(0<,(B . ?\x5EB8) ;; <CJK>
     (?$(0<-(B . ?\x5EB6) ;; <CJK>
     (?$(0<.(B . ?\x5EB5) ;; <CJK>
     (?$(0</(B . ?\x5EBE) ;; <CJK>
     (?$(0<0(B . ?\x5F35) ;; <CJK>
     (?$(0<1(B . ?\x5F37) ;; <CJK>
     (?$(0<2(B . ?\x5F57) ;; <CJK>
     (?$(0<3(B . ?\x5F6C) ;; <CJK>
     (?$(0<4(B . ?\x5F69) ;; <CJK>
     (?$(0<5(B . ?\x5F6B) ;; <CJK>
     (?$(0<6(B . ?\x5F97) ;; <CJK>
     (?$(0<7(B . ?\x5F99) ;; <CJK>
     (?$(0<8(B . ?\x5F9E) ;; <CJK>
     (?$(0<9(B . ?\x5F98) ;; <CJK>
     (?$(0<:(B . ?\x5FA1) ;; <CJK>
     (?$(0<;(B . ?\x5FA0) ;; <CJK>
     (?$(0<<(B . ?\x5F9C) ;; <CJK>
     (?$(0<=(B . ?\x607F) ;; <CJK>
     (?$(0<>(B . ?\x60A3) ;; <CJK>
     (?$(0<?(B . ?\x6089) ;; <CJK>
     (?$(0<@(B . ?\x60A0) ;; <CJK>
     (?$(0<A(B . ?\x60A8) ;; <CJK>
     (?$(0<B(B . ?\x60CB) ;; <CJK>
     (?$(0<C(B . ?\x60B4) ;; <CJK>
     (?$(0<D(B . ?\x60E6) ;; <CJK>
     (?$(0<E(B . ?\x60BD) ;; <CJK>
     (?$(0<F(B . ?\x60C5) ;; <CJK>
     (?$(0<G(B . ?\x60BB) ;; <CJK>
     (?$(0<H(B . ?\x60B5) ;; <CJK>
     (?$(0<I(B . ?\x60DC) ;; <CJK>
     (?$(0<J(B . ?\x60BC) ;; <CJK>
     (?$(0<K(B . ?\x60D8) ;; <CJK>
     (?$(0<L(B . ?\x60D5) ;; <CJK>
     (?$(0<M(B . ?\x60C6) ;; <CJK>
     (?$(0<N(B . ?\x60DF) ;; <CJK>
     (?$(0<O(B . ?\x60B8) ;; <CJK>
     (?$(0<P(B . ?\x60DA) ;; <CJK>
     (?$(0<Q(B . ?\x60C7) ;; <CJK>
     (?$(0<R(B . ?\x621A) ;; <CJK>
     (?$(0<S(B . ?\x621B) ;; <CJK>
     (?$(0<T(B . ?\x6248) ;; <CJK>
     (?$(0<U(B . ?\x63A0) ;; <CJK>
     (?$(0<V(B . ?\x63A7) ;; <CJK>
     (?$(0<W(B . ?\x6372) ;; <CJK>
     (?$(0<X(B . ?\x6396) ;; <CJK>
     (?$(0<Y(B . ?\x63A2) ;; <CJK>
     (?$(0<Z(B . ?\x63A5) ;; <CJK>
     (?$(0<[(B . ?\x6377) ;; <CJK>
     (?$(0<\(B . ?\x6367) ;; <CJK>
     (?$(0<](B . ?\x6398) ;; <CJK>
     (?$(0<^(B . ?\x63AA) ;; <CJK>
     (?$(0<_(B . ?\x6371) ;; <CJK>
     (?$(0<`(B . ?\x63A9) ;; <CJK>
     (?$(0<a(B . ?\x6389) ;; <CJK>
     (?$(0<b(B . ?\x6383) ;; <CJK>
     (?$(0<c(B . ?\x639B) ;; <CJK>
     (?$(0<d(B . ?\x636B) ;; <CJK>
     (?$(0<e(B . ?\x63A8) ;; <CJK>
     (?$(0<f(B . ?\x6384) ;; <CJK>
     (?$(0<g(B . ?\x6388) ;; <CJK>
     (?$(0<h(B . ?\x6399) ;; <CJK>
     (?$(0<i(B . ?\x63A1) ;; <CJK>
     (?$(0<j(B . ?\x63AC) ;; <CJK>
     (?$(0<k(B . ?\x6392) ;; <CJK>
     (?$(0<l(B . ?\x638F) ;; <CJK>
     (?$(0<m(B . ?\x6380) ;; <CJK>
     (?$(0<n(B . ?\x637B) ;; <CJK>
     (?$(0<o(B . ?\x6369) ;; <CJK>
     (?$(0<p(B . ?\x6368) ;; <CJK>
     (?$(0<q(B . ?\x637A) ;; <CJK>
     (?$(0<r(B . ?\x655D) ;; <CJK>
     (?$(0<s(B . ?\x6556) ;; <CJK>
     (?$(0<t(B . ?\x6551) ;; <CJK>
     (?$(0<u(B . ?\x6559) ;; <CJK>
     (?$(0<v(B . ?\x6557) ;; <CJK>
     (?$(0<w(B . ?\x555F) ;; <CJK>
     (?$(0<x(B . ?\x654F) ;; <CJK>
     (?$(0<y(B . ?\x6558) ;; <CJK>
     (?$(0<z(B . ?\x6555) ;; <CJK>
     (?$(0<{(B . ?\x6554) ;; <CJK>
     (?$(0<|(B . ?\x659C) ;; <CJK>
     (?$(0<}(B . ?\x659B) ;; <CJK>
     (?$(0<~(B . ?\x65AC) ;; <CJK>
     (?$(0=!(B . ?\x65CF) ;; <CJK>
     (?$(0="(B . ?\x65CB) ;; <CJK>
     (?$(0=#(B . ?\x65CC) ;; <CJK>
     (?$(0=$(B . ?\x65CE) ;; <CJK>
     (?$(0=%(B . ?\x665D) ;; <CJK>
     (?$(0=&(B . ?\x665A) ;; <CJK>
     (?$(0='(B . ?\x6664) ;; <CJK>
     (?$(0=((B . ?\x6668) ;; <CJK>
     (?$(0=)(B . ?\x6666) ;; <CJK>
     (?$(0=*(B . ?\x665E) ;; <CJK>
     (?$(0=+(B . ?\x66F9) ;; <CJK>
     (?$(0=,(B . ?\x52D7) ;; <CJK>
     (?$(0=-(B . ?\x671B) ;; <CJK>
     (?$(0=.(B . ?\x6881) ;; <CJK>
     (?$(0=/(B . ?\x68AF) ;; <CJK>
     (?$(0=0(B . ?\x68A2) ;; <CJK>
     (?$(0=1(B . ?\x6893) ;; <CJK>
     (?$(0=2(B . ?\x68B5) ;; <CJK>
     (?$(0=3(B . ?\x687F) ;; <CJK>
     (?$(0=4(B . ?\x6876) ;; <CJK>
     (?$(0=5(B . ?\x68B1) ;; <CJK>
     (?$(0=6(B . ?\x68A7) ;; <CJK>
     (?$(0=7(B . ?\x6897) ;; <CJK>
     (?$(0=8(B . ?\x68B0) ;; <CJK>
     (?$(0=9(B . ?\x6883) ;; <CJK>
     (?$(0=:(B . ?\x68C4) ;; <CJK>
     (?$(0=;(B . ?\x68AD) ;; <CJK>
     (?$(0=<(B . ?\x6886) ;; <CJK>
     (?$(0==(B . ?\x6885) ;; <CJK>
     (?$(0=>(B . ?\x6894) ;; <CJK>
     (?$(0=?(B . ?\x689D) ;; <CJK>
     (?$(0=@(B . ?\x68A8) ;; <CJK>
     (?$(0=A(B . ?\x689F) ;; <CJK>
     (?$(0=B(B . ?\x68A1) ;; <CJK>
     (?$(0=C(B . ?\x6882) ;; <CJK>
     (?$(0=D(B . ?\x6B32) ;; <CJK>
     (?$(0=E(B . ?\x6BBA) ;; <CJK>
     (?$(0=F(B . ?\x6BEB) ;; <CJK>
     (?$(0=G(B . ?\x6BEC) ;; <CJK>
     (?$(0=H(B . ?\x6C2B) ;; <CJK>
     (?$(0=I(B . ?\x6D8E) ;; <CJK>
     (?$(0=J(B . ?\x6DBC) ;; <CJK>
     (?$(0=K(B . ?\x6DF3) ;; <CJK>
     (?$(0=L(B . ?\x6DD9) ;; <CJK>
     (?$(0=M(B . ?\x6DB2) ;; <CJK>
     (?$(0=N(B . ?\x6DE1) ;; <CJK>
     (?$(0=O(B . ?\x6DCC) ;; <CJK>
     (?$(0=P(B . ?\x6DE4) ;; <CJK>
     (?$(0=Q(B . ?\x6DFB) ;; <CJK>
     (?$(0=R(B . ?\x6DFA) ;; <CJK>
     (?$(0=S(B . ?\x6E05) ;; <CJK>
     (?$(0=T(B . ?\x6DC7) ;; <CJK>
     (?$(0=U(B . ?\x6DCB) ;; <CJK>
     (?$(0=V(B . ?\x6DAF) ;; <CJK>
     (?$(0=W(B . ?\x6DD1) ;; <CJK>
     (?$(0=X(B . ?\x6DAE) ;; <CJK>
     (?$(0=Y(B . ?\x6DDE) ;; <CJK>
     (?$(0=Z(B . ?\x6DF9) ;; <CJK>
     (?$(0=[(B . ?\x6DB8) ;; <CJK>
     (?$(0=\(B . ?\x6DF7) ;; <CJK>
     (?$(0=](B . ?\x6DF5) ;; <CJK>
     (?$(0=^(B . ?\x6DC5) ;; <CJK>
     (?$(0=_(B . ?\x6DD2) ;; <CJK>
     (?$(0=`(B . ?\x6E1A) ;; <CJK>
     (?$(0=a(B . ?\x6DB5) ;; <CJK>
     (?$(0=b(B . ?\x6DDA) ;; <CJK>
     (?$(0=c(B . ?\x6DEB) ;; <CJK>
     (?$(0=d(B . ?\x6DD8) ;; <CJK>
     (?$(0=e(B . ?\x6DEA) ;; <CJK>
     (?$(0=f(B . ?\x6DF1) ;; <CJK>
     (?$(0=g(B . ?\x6DEE) ;; <CJK>
     (?$(0=h(B . ?\x6DE8) ;; <CJK>
     (?$(0=i(B . ?\x6DC6) ;; <CJK>
     (?$(0=j(B . ?\x6DC4) ;; <CJK>
     (?$(0=k(B . ?\x6DAA) ;; <CJK>
     (?$(0=l(B . ?\x6DEC) ;; <CJK>
     (?$(0=m(B . ?\x6DBF) ;; <CJK>
     (?$(0=n(B . ?\x6DE6) ;; <CJK>
     (?$(0=o(B . ?\x70F9) ;; <CJK>
     (?$(0=p(B . ?\x7109) ;; <CJK>
     (?$(0=q(B . ?\x710A) ;; <CJK>
     (?$(0=r(B . ?\x70FD) ;; <CJK>
     (?$(0=s(B . ?\x70EF) ;; <CJK>
     (?$(0=t(B . ?\x723D) ;; <CJK>
     (?$(0=u(B . ?\x727D) ;; <CJK>
     (?$(0=v(B . ?\x7281) ;; <CJK>
     (?$(0=w(B . ?\x731C) ;; <CJK>
     (?$(0=x(B . ?\x731B) ;; <CJK>
     (?$(0=y(B . ?\x7316) ;; <CJK>
     (?$(0=z(B . ?\x7313) ;; <CJK>
     (?$(0={(B . ?\x7319) ;; <CJK>
     (?$(0=|(B . ?\x7387) ;; <CJK>
     (?$(0=}(B . ?\x7405) ;; <CJK>
     (?$(0=~(B . ?\x740A) ;; <CJK>
     (?$(0>!(B . ?\x7403) ;; <CJK>
     (?$(0>"(B . ?\x7406) ;; <CJK>
     (?$(0>#(B . ?\x73FE) ;; <CJK>
     (?$(0>$(B . ?\x740D) ;; <CJK>
     (?$(0>%(B . ?\x74E0) ;; <CJK>
     (?$(0>&(B . ?\x74F6) ;; <CJK>
     (?$(0>'(B . ?\x74F7) ;; <CJK>
     (?$(0>((B . ?\x751C) ;; <CJK>
     (?$(0>)(B . ?\x7522) ;; <CJK>
     (?$(0>*(B . ?\x7565) ;; <CJK>
     (?$(0>+(B . ?\x7566) ;; <CJK>
     (?$(0>,(B . ?\x7562) ;; <CJK>
     (?$(0>-(B . ?\x7570) ;; <CJK>
     (?$(0>.(B . ?\x758F) ;; <CJK>
     (?$(0>/(B . ?\x75D4) ;; <CJK>
     (?$(0>0(B . ?\x75D5) ;; <CJK>
     (?$(0>1(B . ?\x75B5) ;; <CJK>
     (?$(0>2(B . ?\x75CA) ;; <CJK>
     (?$(0>3(B . ?\x75CD) ;; <CJK>
     (?$(0>4(B . ?\x768E) ;; <CJK>
     (?$(0>5(B . ?\x76D4) ;; <CJK>
     (?$(0>6(B . ?\x76D2) ;; <CJK>
     (?$(0>7(B . ?\x76DB) ;; <CJK>
     (?$(0>8(B . ?\x7737) ;; <CJK>
     (?$(0>9(B . ?\x773E) ;; <CJK>
     (?$(0>:(B . ?\x773C) ;; <CJK>
     (?$(0>;(B . ?\x7736) ;; <CJK>
     (?$(0><(B . ?\x7738) ;; <CJK>
     (?$(0>=(B . ?\x773A) ;; <CJK>
     (?$(0>>(B . ?\x786B) ;; <CJK>
     (?$(0>?(B . ?\x7843) ;; <CJK>
     (?$(0>@(B . ?\x784E) ;; <CJK>
     (?$(0>A(B . ?\x7965) ;; <CJK>
     (?$(0>B(B . ?\x7968) ;; <CJK>
     (?$(0>C(B . ?\x796D) ;; <CJK>
     (?$(0>D(B . ?\x79FB) ;; <CJK>
     (?$(0>E(B . ?\x7A92) ;; <CJK>
     (?$(0>F(B . ?\x7A95) ;; <CJK>
     (?$(0>G(B . ?\x7B20) ;; <CJK>
     (?$(0>H(B . ?\x7B28) ;; <CJK>
     (?$(0>I(B . ?\x7B1B) ;; <CJK>
     (?$(0>J(B . ?\x7B2C) ;; <CJK>
     (?$(0>K(B . ?\x7B26) ;; <CJK>
     (?$(0>L(B . ?\x7B19) ;; <CJK>
     (?$(0>M(B . ?\x7B1E) ;; <CJK>
     (?$(0>N(B . ?\x7B2E) ;; <CJK>
     (?$(0>O(B . ?\x7C92) ;; <CJK>
     (?$(0>P(B . ?\x7C97) ;; <CJK>
     (?$(0>Q(B . ?\x7C95) ;; <CJK>
     (?$(0>R(B . ?\x7D46) ;; <CJK>
     (?$(0>S(B . ?\x7D43) ;; <CJK>
     (?$(0>T(B . ?\x7D71) ;; <CJK>
     (?$(0>U(B . ?\x7D2E) ;; <CJK>
     (?$(0>V(B . ?\x7D39) ;; <CJK>
     (?$(0>W(B . ?\x7D3C) ;; <CJK>
     (?$(0>X(B . ?\x7D40) ;; <CJK>
     (?$(0>Y(B . ?\x7D30) ;; <CJK>
     (?$(0>Z(B . ?\x7D33) ;; <CJK>
     (?$(0>[(B . ?\x7D44) ;; <CJK>
     (?$(0>\(B . ?\x7D2F) ;; <CJK>
     (?$(0>](B . ?\x7D42) ;; <CJK>
     (?$(0>^(B . ?\x7D32) ;; <CJK>
     (?$(0>_(B . ?\x7D31) ;; <CJK>
     (?$(0>`(B . ?\x7F3D) ;; <CJK>
     (?$(0>a(B . ?\x7F9E) ;; <CJK>
     (?$(0>b(B . ?\x7F9A) ;; <CJK>
     (?$(0>c(B . ?\x7FCC) ;; <CJK>
     (?$(0>d(B . ?\x7FCE) ;; <CJK>
     (?$(0>e(B . ?\x7FD2) ;; <CJK>
     (?$(0>f(B . ?\x801C) ;; <CJK>
     (?$(0>g(B . ?\x804A) ;; <CJK>
     (?$(0>h(B . ?\x8046) ;; <CJK>
     (?$(0>i(B . ?\x812F) ;; <CJK>
     (?$(0>j(B . ?\x8116) ;; <CJK>
     (?$(0>k(B . ?\x8123) ;; <CJK>
     (?$(0>l(B . ?\x812B) ;; <CJK>
     (?$(0>m(B . ?\x8129) ;; <CJK>
     (?$(0>n(B . ?\x8130) ;; <CJK>
     (?$(0>o(B . ?\x8124) ;; <CJK>
     (?$(0>p(B . ?\x8202) ;; <CJK>
     (?$(0>q(B . ?\x8235) ;; <CJK>
     (?$(0>r(B . ?\x8237) ;; <CJK>
     (?$(0>s(B . ?\x8236) ;; <CJK>
     (?$(0>t(B . ?\x8239) ;; <CJK>
     (?$(0>u(B . ?\x838E) ;; <CJK>
     (?$(0>v(B . ?\x839E) ;; <CJK>
     (?$(0>w(B . ?\x8398) ;; <CJK>
     (?$(0>x(B . ?\x8378) ;; <CJK>
     (?$(0>y(B . ?\x83A2) ;; <CJK>
     (?$(0>z(B . ?\x8396) ;; <CJK>
     (?$(0>{(B . ?\x83BD) ;; <CJK>
     (?$(0>|(B . ?\x83AB) ;; <CJK>
     (?$(0>}(B . ?\x8392) ;; <CJK>
     (?$(0>~(B . ?\x838A) ;; <CJK>
     (?$(0?!(B . ?\x8393) ;; <CJK>
     (?$(0?"(B . ?\x8389) ;; <CJK>
     (?$(0?#(B . ?\x83A0) ;; <CJK>
     (?$(0?$(B . ?\x8377) ;; <CJK>
     (?$(0?%(B . ?\x837B) ;; <CJK>
     (?$(0?&(B . ?\x837C) ;; <CJK>
     (?$(0?'(B . ?\x8386) ;; <CJK>
     (?$(0?((B . ?\x83A7) ;; <CJK>
     (?$(0?)(B . ?\x8655) ;; <CJK>
     (?$(0?*(B . ?\x5F6A) ;; <CJK>
     (?$(0?+(B . ?\x86C7) ;; <CJK>
     (?$(0?,(B . ?\x86C0) ;; <CJK>
     (?$(0?-(B . ?\x86B6) ;; <CJK>
     (?$(0?.(B . ?\x86C4) ;; <CJK>
     (?$(0?/(B . ?\x86B5) ;; <CJK>
     (?$(0?0(B . ?\x86C6) ;; <CJK>
     (?$(0?1(B . ?\x86CB) ;; <CJK>
     (?$(0?2(B . ?\x86B1) ;; <CJK>
     (?$(0?3(B . ?\x86AF) ;; <CJK>
     (?$(0?4(B . ?\x86C9) ;; <CJK>
     (?$(0?5(B . ?\x8853) ;; <CJK>
     (?$(0?6(B . ?\x889E) ;; <CJK>
     (?$(0?7(B . ?\x8888) ;; <CJK>
     (?$(0?8(B . ?\x88AB) ;; <CJK>
     (?$(0?9(B . ?\x8892) ;; <CJK>
     (?$(0?:(B . ?\x8896) ;; <CJK>
     (?$(0?;(B . ?\x888D) ;; <CJK>
     (?$(0?<(B . ?\x888B) ;; <CJK>
     (?$(0?=(B . ?\x8993) ;; <CJK>
     (?$(0?>(B . ?\x898F) ;; <CJK>
     (?$(0??(B . ?\x8A2A) ;; <CJK>
     (?$(0?@(B . ?\x8A1D) ;; <CJK>
     (?$(0?A(B . ?\x8A23) ;; <CJK>
     (?$(0?B(B . ?\x8A25) ;; <CJK>
     (?$(0?C(B . ?\x8A31) ;; <CJK>
     (?$(0?D(B . ?\x8A2D) ;; <CJK>
     (?$(0?E(B . ?\x8A1F) ;; <CJK>
     (?$(0?F(B . ?\x8A1B) ;; <CJK>
     (?$(0?G(B . ?\x8A22) ;; <CJK>
     (?$(0?H(B . ?\x8C49) ;; <CJK>
     (?$(0?I(B . ?\x8C5A) ;; <CJK>
     (?$(0?J(B . ?\x8CA9) ;; <CJK>
     (?$(0?K(B . ?\x8CAC) ;; <CJK>
     (?$(0?L(B . ?\x8CAB) ;; <CJK>
     (?$(0?M(B . ?\x8CA8) ;; <CJK>
     (?$(0?N(B . ?\x8CAA) ;; <CJK>
     (?$(0?O(B . ?\x8CA7) ;; <CJK>
     (?$(0?P(B . ?\x8D67) ;; <CJK>
     (?$(0?Q(B . ?\x8D66) ;; <CJK>
     (?$(0?R(B . ?\x8DBE) ;; <CJK>
     (?$(0?S(B . ?\x8DBA) ;; <CJK>
     (?$(0?T(B . ?\x8EDB) ;; <CJK>
     (?$(0?U(B . ?\x8EDF) ;; <CJK>
     (?$(0?V(B . ?\x9019) ;; <CJK>
     (?$(0?W(B . ?\x900D) ;; <CJK>
     (?$(0?X(B . ?\x901A) ;; <CJK>
     (?$(0?Y(B . ?\x9017) ;; <CJK>
     (?$(0?Z(B . ?\x9023) ;; <CJK>
     (?$(0?[(B . ?\x901F) ;; <CJK>
     (?$(0?\(B . ?\x901D) ;; <CJK>
     (?$(0?](B . ?\x9010) ;; <CJK>
     (?$(0?^(B . ?\x9015) ;; <CJK>
     (?$(0?_(B . ?\x901E) ;; <CJK>
     (?$(0?`(B . ?\x9020) ;; <CJK>
     (?$(0?a(B . ?\x900F) ;; <CJK>
     (?$(0?b(B . ?\x9022) ;; <CJK>
     (?$(0?c(B . ?\x9016) ;; <CJK>
     (?$(0?d(B . ?\x901B) ;; <CJK>
     (?$(0?e(B . ?\x9014) ;; <CJK>
     (?$(0?f(B . ?\x90E8) ;; <CJK>
     (?$(0?g(B . ?\x90ED) ;; <CJK>
     (?$(0?h(B . ?\x90FD) ;; <CJK>
     (?$(0?i(B . ?\x9157) ;; <CJK>
     (?$(0?j(B . ?\x91CE) ;; <CJK>
     (?$(0?k(B . ?\x91F5) ;; <CJK>
     (?$(0?l(B . ?\x91E6) ;; <CJK>
     (?$(0?m(B . ?\x91E3) ;; <CJK>
     (?$(0?n(B . ?\x91E7) ;; <CJK>
     (?$(0?o(B . ?\x91ED) ;; <CJK>
     (?$(0?p(B . ?\x91E9) ;; <CJK>
     (?$(0?q(B . ?\x9589) ;; <CJK>
     (?$(0?r(B . ?\x966A) ;; <CJK>
     (?$(0?s(B . ?\x9675) ;; <CJK>
     (?$(0?t(B . ?\x9673) ;; <CJK>
     (?$(0?u(B . ?\x9678) ;; <CJK>
     (?$(0?v(B . ?\x9670) ;; <CJK>
     (?$(0?w(B . ?\x9674) ;; <CJK>
     (?$(0?x(B . ?\x9676) ;; <CJK>
     (?$(0?y(B . ?\x9677) ;; <CJK>
     (?$(0?z(B . ?\x966C) ;; <CJK>
     (?$(0?{(B . ?\x96C0) ;; <CJK>
     (?$(0?|(B . ?\x96EA) ;; <CJK>
     (?$(0?}(B . ?\x96E9) ;; <CJK>
     (?$(0?~(B . ?\x7AE0) ;; <CJK>
     (?$(0@!(B . ?\x7ADF) ;; <CJK>
     (?$(0@"(B . ?\x9802) ;; <CJK>
     (?$(0@#(B . ?\x9803) ;; <CJK>
     (?$(0@$(B . ?\x9B5A) ;; <CJK>
     (?$(0@%(B . ?\x9CE5) ;; <CJK>
     (?$(0@&(B . ?\x9E75) ;; <CJK>
     (?$(0@'(B . ?\x9E7F) ;; <CJK>
     (?$(0@((B . ?\x9EA5) ;; <CJK>
     (?$(0@)(B . ?\x9EBB) ;; <CJK>
     (?$(0@*(B . ?\x50A2) ;; <CJK>
     (?$(0@+(B . ?\x508D) ;; <CJK>
     (?$(0@,(B . ?\x5085) ;; <CJK>
     (?$(0@-(B . ?\x5099) ;; <CJK>
     (?$(0@.(B . ?\x5091) ;; <CJK>
     (?$(0@/(B . ?\x5080) ;; <CJK>
     (?$(0@0(B . ?\x5096) ;; <CJK>
     (?$(0@1(B . ?\x5098) ;; <CJK>
     (?$(0@2(B . ?\x509A) ;; <CJK>
     (?$(0@3(B . ?\x6700) ;; <CJK>
     (?$(0@4(B . ?\x51F1) ;; <CJK>
     (?$(0@5(B . ?\x5272) ;; <CJK>
     (?$(0@6(B . ?\x5274) ;; <CJK>
     (?$(0@7(B . ?\x5275) ;; <CJK>
     (?$(0@8(B . ?\x5269) ;; <CJK>
     (?$(0@9(B . ?\x52DE) ;; <CJK>
     (?$(0@:(B . ?\x52DD) ;; <CJK>
     (?$(0@;(B . ?\x52DB) ;; <CJK>
     (?$(0@<(B . ?\x535A) ;; <CJK>
     (?$(0@=(B . ?\x53A5) ;; <CJK>
     (?$(0@>(B . ?\x557B) ;; <CJK>
     (?$(0@?(B . ?\x5580) ;; <CJK>
     (?$(0@@(B . ?\x55A7) ;; <CJK>
     (?$(0@A(B . ?\x557C) ;; <CJK>
     (?$(0@B(B . ?\x558A) ;; <CJK>
     (?$(0@C(B . ?\x559D) ;; <CJK>
     (?$(0@D(B . ?\x5598) ;; <CJK>
     (?$(0@E(B . ?\x5582) ;; <CJK>
     (?$(0@F(B . ?\x559C) ;; <CJK>
     (?$(0@G(B . ?\x55AA) ;; <CJK>
     (?$(0@H(B . ?\x5594) ;; <CJK>
     (?$(0@I(B . ?\x5587) ;; <CJK>
     (?$(0@J(B . ?\x558B) ;; <CJK>
     (?$(0@K(B . ?\x5583) ;; <CJK>
     (?$(0@L(B . ?\x55B3) ;; <CJK>
     (?$(0@M(B . ?\x55AE) ;; <CJK>
     (?$(0@N(B . ?\x559F) ;; <CJK>
     (?$(0@O(B . ?\x553E) ;; <CJK>
     (?$(0@P(B . ?\x55B2) ;; <CJK>
     (?$(0@Q(B . ?\x559A) ;; <CJK>
     (?$(0@R(B . ?\x55BB) ;; <CJK>
     (?$(0@S(B . ?\x55AC) ;; <CJK>
     (?$(0@T(B . ?\x55B1) ;; <CJK>
     (?$(0@U(B . ?\x557E) ;; <CJK>
     (?$(0@V(B . ?\x5589) ;; <CJK>
     (?$(0@W(B . ?\x55AB) ;; <CJK>
     (?$(0@X(B . ?\x5599) ;; <CJK>
     (?$(0@Y(B . ?\x570D) ;; <CJK>
     (?$(0@Z(B . ?\x582F) ;; <CJK>
     (?$(0@[(B . ?\x582A) ;; <CJK>
     (?$(0@\(B . ?\x5834) ;; <CJK>
     (?$(0@](B . ?\x5824) ;; <CJK>
     (?$(0@^(B . ?\x5830) ;; <CJK>
     (?$(0@_(B . ?\x5831) ;; <CJK>
     (?$(0@`(B . ?\x5821) ;; <CJK>
     (?$(0@a(B . ?\x581D) ;; <CJK>
     (?$(0@b(B . ?\x5820) ;; <CJK>
     (?$(0@c(B . ?\x58F9) ;; <CJK>
     (?$(0@d(B . ?\x58FA) ;; <CJK>
     (?$(0@e(B . ?\x5960) ;; <CJK>
     (?$(0@f(B . ?\x5A77) ;; <CJK>
     (?$(0@g(B . ?\x5A9A) ;; <CJK>
     (?$(0@h(B . ?\x5A7F) ;; <CJK>
     (?$(0@i(B . ?\x5A92) ;; <CJK>
     (?$(0@j(B . ?\x5A9B) ;; <CJK>
     (?$(0@k(B . ?\x5AA7) ;; <CJK>
     (?$(0@l(B . ?\x5B73) ;; <CJK>
     (?$(0@m(B . ?\x5B71) ;; <CJK>
     (?$(0@n(B . ?\x5BD2) ;; <CJK>
     (?$(0@o(B . ?\x5BCC) ;; <CJK>
     (?$(0@p(B . ?\x5BD3) ;; <CJK>
     (?$(0@q(B . ?\x5BD0) ;; <CJK>
     (?$(0@r(B . ?\x5C0A) ;; <CJK>
     (?$(0@s(B . ?\x5C0B) ;; <CJK>
     (?$(0@t(B . ?\x5C31) ;; <CJK>
     (?$(0@u(B . ?\x5D4C) ;; <CJK>
     (?$(0@v(B . ?\x5D50) ;; <CJK>
     (?$(0@w(B . ?\x5D34) ;; <CJK>
     (?$(0@x(B . ?\x5D47) ;; <CJK>
     (?$(0@y(B . ?\x5DFD) ;; <CJK>
     (?$(0@z(B . ?\x5E45) ;; <CJK>
     (?$(0@{(B . ?\x5E3D) ;; <CJK>
     (?$(0@|(B . ?\x5E40) ;; <CJK>
     (?$(0@}(B . ?\x5E43) ;; <CJK>
     (?$(0@~(B . ?\x5E7E) ;; <CJK>
     (?$(0A!(B . ?\x5ECA) ;; <CJK>
     (?$(0A"(B . ?\x5EC1) ;; <CJK>
     (?$(0A#(B . ?\x5EC2) ;; <CJK>
     (?$(0A$(B . ?\x5EC4) ;; <CJK>
     (?$(0A%(B . ?\x5F3C) ;; <CJK>
     (?$(0A&(B . ?\x5F6D) ;; <CJK>
     (?$(0A'(B . ?\x5FA9) ;; <CJK>
     (?$(0A((B . ?\x5FAA) ;; <CJK>
     (?$(0A)(B . ?\x5FA8) ;; <CJK>
     (?$(0A*(B . ?\x60D1) ;; <CJK>
     (?$(0A+(B . ?\x60E1) ;; <CJK>
     (?$(0A,(B . ?\x60B2) ;; <CJK>
     (?$(0A-(B . ?\x60B6) ;; <CJK>
     (?$(0A.(B . ?\x60E0) ;; <CJK>
     (?$(0A/(B . ?\x611C) ;; <CJK>
     (?$(0A0(B . ?\x6123) ;; <CJK>
     (?$(0A1(B . ?\x60FA) ;; <CJK>
     (?$(0A2(B . ?\x6115) ;; <CJK>
     (?$(0A3(B . ?\x60F0) ;; <CJK>
     (?$(0A4(B . ?\x60FB) ;; <CJK>
     (?$(0A5(B . ?\x60F4) ;; <CJK>
     (?$(0A6(B . ?\x6168) ;; <CJK>
     (?$(0A7(B . ?\x60F1) ;; <CJK>
     (?$(0A8(B . ?\x610E) ;; <CJK>
     (?$(0A9(B . ?\x60F6) ;; <CJK>
     (?$(0A:(B . ?\x6109) ;; <CJK>
     (?$(0A;(B . ?\x6100) ;; <CJK>
     (?$(0A<(B . ?\x6112) ;; <CJK>
     (?$(0A=(B . ?\x621F) ;; <CJK>
     (?$(0A>(B . ?\x6249) ;; <CJK>
     (?$(0A?(B . ?\x63A3) ;; <CJK>
     (?$(0A@(B . ?\x638C) ;; <CJK>
     (?$(0AA(B . ?\x63CF) ;; <CJK>
     (?$(0AB(B . ?\x63C0) ;; <CJK>
     (?$(0AC(B . ?\x63E9) ;; <CJK>
     (?$(0AD(B . ?\x63C9) ;; <CJK>
     (?$(0AE(B . ?\x63C6) ;; <CJK>
     (?$(0AF(B . ?\x63CD) ;; <CJK>
     (?$(0AG(B . ?\x63D2) ;; <CJK>
     (?$(0AH(B . ?\x63E3) ;; <CJK>
     (?$(0AI(B . ?\x63D0) ;; <CJK>
     (?$(0AJ(B . ?\x63E1) ;; <CJK>
     (?$(0AK(B . ?\x63D6) ;; <CJK>
     (?$(0AL(B . ?\x63ED) ;; <CJK>
     (?$(0AM(B . ?\x63EE) ;; <CJK>
     (?$(0AN(B . ?\x6376) ;; <CJK>
     (?$(0AO(B . ?\x63F4) ;; <CJK>
     (?$(0AP(B . ?\x63EA) ;; <CJK>
     (?$(0AQ(B . ?\x63DB) ;; <CJK>
     (?$(0AR(B . ?\x6452) ;; <CJK>
     (?$(0AS(B . ?\x63DA) ;; <CJK>
     (?$(0AT(B . ?\x63F9) ;; <CJK>
     (?$(0AU(B . ?\x655E) ;; <CJK>
     (?$(0AV(B . ?\x6566) ;; <CJK>
     (?$(0AW(B . ?\x6562) ;; <CJK>
     (?$(0AX(B . ?\x6563) ;; <CJK>
     (?$(0AY(B . ?\x6591) ;; <CJK>
     (?$(0AZ(B . ?\x6590) ;; <CJK>
     (?$(0A[(B . ?\x65AF) ;; <CJK>
     (?$(0A\(B . ?\x666E) ;; <CJK>
     (?$(0A](B . ?\x6670) ;; <CJK>
     (?$(0A^(B . ?\x6674) ;; <CJK>
     (?$(0A_(B . ?\x6676) ;; <CJK>
     (?$(0A`(B . ?\x666F) ;; <CJK>
     (?$(0Aa(B . ?\x6691) ;; <CJK>
     (?$(0Ab(B . ?\x667A) ;; <CJK>
     (?$(0Ac(B . ?\x667E) ;; <CJK>
     (?$(0Ad(B . ?\x6677) ;; <CJK>
     (?$(0Ae(B . ?\x66FE) ;; <CJK>
     (?$(0Af(B . ?\x66FF) ;; <CJK>
     (?$(0Ag(B . ?\x671F) ;; <CJK>
     (?$(0Ah(B . ?\x671D) ;; <CJK>
     (?$(0Ai(B . ?\x68FA) ;; <CJK>
     (?$(0Aj(B . ?\x68D5) ;; <CJK>
     (?$(0Ak(B . ?\x68E0) ;; <CJK>
     (?$(0Al(B . ?\x68D8) ;; <CJK>
     (?$(0Am(B . ?\x68D7) ;; <CJK>
     (?$(0An(B . ?\x6905) ;; <CJK>
     (?$(0Ao(B . ?\x68DF) ;; <CJK>
     (?$(0Ap(B . ?\x68F5) ;; <CJK>
     (?$(0Aq(B . ?\x68EE) ;; <CJK>
     (?$(0Ar(B . ?\x68E7) ;; <CJK>
     (?$(0As(B . ?\x68F9) ;; <CJK>
     (?$(0At(B . ?\x68D2) ;; <CJK>
     (?$(0Au(B . ?\x68F2) ;; <CJK>
     (?$(0Av(B . ?\x68E3) ;; <CJK>
     (?$(0Aw(B . ?\x68CB) ;; <CJK>
     (?$(0Ax(B . ?\x68CD) ;; <CJK>
     (?$(0Ay(B . ?\x690D) ;; <CJK>
     (?$(0Az(B . ?\x6912) ;; <CJK>
     (?$(0A{(B . ?\x690E) ;; <CJK>
     (?$(0A|(B . ?\x68C9) ;; <CJK>
     (?$(0A}(B . ?\x68DA) ;; <CJK>
     (?$(0A~(B . ?\x696E) ;; <CJK>
     (?$(0B!(B . ?\x68FB) ;; <CJK>
     (?$(0B"(B . ?\x6B3E) ;; <CJK>
     (?$(0B#(B . ?\x6B3A) ;; <CJK>
     (?$(0B$(B . ?\x6B3D) ;; <CJK>
     (?$(0B%(B . ?\x6B98) ;; <CJK>
     (?$(0B&(B . ?\x6B96) ;; <CJK>
     (?$(0B'(B . ?\x6BBC) ;; <CJK>
     (?$(0B((B . ?\x6BEF) ;; <CJK>
     (?$(0B)(B . ?\x6C2E) ;; <CJK>
     (?$(0B*(B . ?\x6C2F) ;; <CJK>
     (?$(0B+(B . ?\x6C2C) ;; <CJK>
     (?$(0B,(B . ?\x6E2F) ;; <CJK>
     (?$(0B-(B . ?\x6E38) ;; <CJK>
     (?$(0B.(B . ?\x6E54) ;; <CJK>
     (?$(0B/(B . ?\x6E21) ;; <CJK>
     (?$(0B0(B . ?\x6E32) ;; <CJK>
     (?$(0B1(B . ?\x6E67) ;; <CJK>
     (?$(0B2(B . ?\x6E4A) ;; <CJK>
     (?$(0B3(B . ?\x6E20) ;; <CJK>
     (?$(0B4(B . ?\x6E25) ;; <CJK>
     (?$(0B5(B . ?\x6E23) ;; <CJK>
     (?$(0B6(B . ?\x6E1B) ;; <CJK>
     (?$(0B7(B . ?\x6E5B) ;; <CJK>
     (?$(0B8(B . ?\x6E58) ;; <CJK>
     (?$(0B9(B . ?\x6E24) ;; <CJK>
     (?$(0B:(B . ?\x6E56) ;; <CJK>
     (?$(0B;(B . ?\x6E6E) ;; <CJK>
     (?$(0B<(B . ?\x6E2D) ;; <CJK>
     (?$(0B=(B . ?\x6E26) ;; <CJK>
     (?$(0B>(B . ?\x6E6F) ;; <CJK>
     (?$(0B?(B . ?\x6E34) ;; <CJK>
     (?$(0B@(B . ?\x6E4D) ;; <CJK>
     (?$(0BA(B . ?\x6E3A) ;; <CJK>
     (?$(0BB(B . ?\x6E2C) ;; <CJK>
     (?$(0BC(B . ?\x6E43) ;; <CJK>
     (?$(0BD(B . ?\x6E1D) ;; <CJK>
     (?$(0BE(B . ?\x6E3E) ;; <CJK>
     (?$(0BF(B . ?\x6ECB) ;; <CJK>
     (?$(0BG(B . ?\x6E89) ;; <CJK>
     (?$(0BH(B . ?\x6E19) ;; <CJK>
     (?$(0BI(B . ?\x6E4E) ;; <CJK>
     (?$(0BJ(B . ?\x6E63) ;; <CJK>
     (?$(0BK(B . ?\x6E44) ;; <CJK>
     (?$(0BL(B . ?\x6E72) ;; <CJK>
     (?$(0BM(B . ?\x6E69) ;; <CJK>
     (?$(0BN(B . ?\x6E5F) ;; <CJK>
     (?$(0BO(B . ?\x7119) ;; <CJK>
     (?$(0BP(B . ?\x711A) ;; <CJK>
     (?$(0BQ(B . ?\x7126) ;; <CJK>
     (?$(0BR(B . ?\x7130) ;; <CJK>
     (?$(0BS(B . ?\x7121) ;; <CJK>
     (?$(0BT(B . ?\x7136) ;; <CJK>
     (?$(0BU(B . ?\x716E) ;; <CJK>
     (?$(0BV(B . ?\x711C) ;; <CJK>
     (?$(0BW(B . ?\x724C) ;; <CJK>
     (?$(0BX(B . ?\x7284) ;; <CJK>
     (?$(0BY(B . ?\x7280) ;; <CJK>
     (?$(0BZ(B . ?\x7336) ;; <CJK>
     (?$(0B[(B . ?\x7325) ;; <CJK>
     (?$(0B\(B . ?\x7334) ;; <CJK>
     (?$(0B](B . ?\x7329) ;; <CJK>
     (?$(0B^(B . ?\x743A) ;; <CJK>
     (?$(0B_(B . ?\x742A) ;; <CJK>
     (?$(0B`(B . ?\x7433) ;; <CJK>
     (?$(0Ba(B . ?\x7422) ;; <CJK>
     (?$(0Bb(B . ?\x7425) ;; <CJK>
     (?$(0Bc(B . ?\x7435) ;; <CJK>
     (?$(0Bd(B . ?\x7436) ;; <CJK>
     (?$(0Be(B . ?\x7434) ;; <CJK>
     (?$(0Bf(B . ?\x742F) ;; <CJK>
     (?$(0Bg(B . ?\x741B) ;; <CJK>
     (?$(0Bh(B . ?\x7426) ;; <CJK>
     (?$(0Bi(B . ?\x7428) ;; <CJK>
     (?$(0Bj(B . ?\x7525) ;; <CJK>
     (?$(0Bk(B . ?\x7526) ;; <CJK>
     (?$(0Bl(B . ?\x756B) ;; <CJK>
     (?$(0Bm(B . ?\x756A) ;; <CJK>
     (?$(0Bn(B . ?\x75E2) ;; <CJK>
     (?$(0Bo(B . ?\x75DB) ;; <CJK>
     (?$(0Bp(B . ?\x75E3) ;; <CJK>
     (?$(0Bq(B . ?\x75D9) ;; <CJK>
     (?$(0Br(B . ?\x75D8) ;; <CJK>
     (?$(0Bs(B . ?\x75DE) ;; <CJK>
     (?$(0Bt(B . ?\x75E0) ;; <CJK>
     (?$(0Bu(B . ?\x767B) ;; <CJK>
     (?$(0Bv(B . ?\x767C) ;; <CJK>
     (?$(0Bw(B . ?\x7696) ;; <CJK>
     (?$(0Bx(B . ?\x7693) ;; <CJK>
     (?$(0By(B . ?\x76B4) ;; <CJK>
     (?$(0Bz(B . ?\x76DC) ;; <CJK>
     (?$(0B{(B . ?\x774F) ;; <CJK>
     (?$(0B|(B . ?\x77ED) ;; <CJK>
     (?$(0B}(B . ?\x785D) ;; <CJK>
     (?$(0B~(B . ?\x786C) ;; <CJK>
     (?$(0C!(B . ?\x786F) ;; <CJK>
     (?$(0C"(B . ?\x7A0D) ;; <CJK>
     (?$(0C#(B . ?\x7A08) ;; <CJK>
     (?$(0C$(B . ?\x7A0B) ;; <CJK>
     (?$(0C%(B . ?\x7A05) ;; <CJK>
     (?$(0C&(B . ?\x7A00) ;; <CJK>
     (?$(0C'(B . ?\x7A98) ;; <CJK>
     (?$(0C((B . ?\x7A97) ;; <CJK>
     (?$(0C)(B . ?\x7A96) ;; <CJK>
     (?$(0C*(B . ?\x7AE5) ;; <CJK>
     (?$(0C+(B . ?\x7AE3) ;; <CJK>
     (?$(0C,(B . ?\x7B49) ;; <CJK>
     (?$(0C-(B . ?\x7B56) ;; <CJK>
     (?$(0C.(B . ?\x7B46) ;; <CJK>
     (?$(0C/(B . ?\x7B50) ;; <CJK>
     (?$(0C0(B . ?\x7B52) ;; <CJK>
     (?$(0C1(B . ?\x7B54) ;; <CJK>
     (?$(0C2(B . ?\x7B4D) ;; <CJK>
     (?$(0C3(B . ?\x7B4B) ;; <CJK>
     (?$(0C4(B . ?\x7B4F) ;; <CJK>
     (?$(0C5(B . ?\x7B51) ;; <CJK>
     (?$(0C6(B . ?\x7C9F) ;; <CJK>
     (?$(0C7(B . ?\x7CA5) ;; <CJK>
     (?$(0C8(B . ?\x7D5E) ;; <CJK>
     (?$(0C9(B . ?\x7D50) ;; <CJK>
     (?$(0C:(B . ?\x7D68) ;; <CJK>
     (?$(0C;(B . ?\x7D55) ;; <CJK>
     (?$(0C<(B . ?\x7D2B) ;; <CJK>
     (?$(0C=(B . ?\x7D6E) ;; <CJK>
     (?$(0C>(B . ?\x7D72) ;; <CJK>
     (?$(0C?(B . ?\x7D61) ;; <CJK>
     (?$(0C@(B . ?\x7D66) ;; <CJK>
     (?$(0CA(B . ?\x7D62) ;; <CJK>
     (?$(0CB(B . ?\x7D70) ;; <CJK>
     (?$(0CC(B . ?\x7D73) ;; <CJK>
     (?$(0CD(B . ?\x5584) ;; <CJK>
     (?$(0CE(B . ?\x7FD4) ;; <CJK>
     (?$(0CF(B . ?\x7FD5) ;; <CJK>
     (?$(0CG(B . ?\x800B) ;; <CJK>
     (?$(0CH(B . ?\x8052) ;; <CJK>
     (?$(0CI(B . ?\x8085) ;; <CJK>
     (?$(0CJ(B . ?\x8155) ;; <CJK>
     (?$(0CK(B . ?\x8154) ;; <CJK>
     (?$(0CL(B . ?\x814B) ;; <CJK>
     (?$(0CM(B . ?\x8151) ;; <CJK>
     (?$(0CN(B . ?\x814E) ;; <CJK>
     (?$(0CO(B . ?\x8139) ;; <CJK>
     (?$(0CP(B . ?\x8146) ;; <CJK>
     (?$(0CQ(B . ?\x813E) ;; <CJK>
     (?$(0CR(B . ?\x814C) ;; <CJK>
     (?$(0CS(B . ?\x8153) ;; <CJK>
     (?$(0CT(B . ?\x8174) ;; <CJK>
     (?$(0CU(B . ?\x8212) ;; <CJK>
     (?$(0CV(B . ?\x821C) ;; <CJK>
     (?$(0CW(B . ?\x83E9) ;; <CJK>
     (?$(0CX(B . ?\x8403) ;; <CJK>
     (?$(0CY(B . ?\x83F8) ;; <CJK>
     (?$(0CZ(B . ?\x840D) ;; <CJK>
     (?$(0C[(B . ?\x83E0) ;; <CJK>
     (?$(0C\(B . ?\x83C5) ;; <CJK>
     (?$(0C](B . ?\x840B) ;; <CJK>
     (?$(0C^(B . ?\x83C1) ;; <CJK>
     (?$(0C_(B . ?\x83EF) ;; <CJK>
     (?$(0C`(B . ?\x83F1) ;; <CJK>
     (?$(0Ca(B . ?\x83F4) ;; <CJK>
     (?$(0Cb(B . ?\x8457) ;; <CJK>
     (?$(0Cc(B . ?\x840A) ;; <CJK>
     (?$(0Cd(B . ?\x83F0) ;; <CJK>
     (?$(0Ce(B . ?\x840C) ;; <CJK>
     (?$(0Cf(B . ?\x83CC) ;; <CJK>
     (?$(0Cg(B . ?\x83FD) ;; <CJK>
     (?$(0Ch(B . ?\x83F2) ;; <CJK>
     (?$(0Ci(B . ?\x83CA) ;; <CJK>
     (?$(0Cj(B . ?\x8438) ;; <CJK>
     (?$(0Ck(B . ?\x840E) ;; <CJK>
     (?$(0Cl(B . ?\x8404) ;; <CJK>
     (?$(0Cm(B . ?\x83DC) ;; <CJK>
     (?$(0Cn(B . ?\x8407) ;; <CJK>
     (?$(0Co(B . ?\x83D4) ;; <CJK>
     (?$(0Cp(B . ?\x83DF) ;; <CJK>
     (?$(0Cq(B . ?\x865B) ;; <CJK>
     (?$(0Cr(B . ?\x86DF) ;; <CJK>
     (?$(0Cs(B . ?\x86D9) ;; <CJK>
     (?$(0Ct(B . ?\x86ED) ;; <CJK>
     (?$(0Cu(B . ?\x86D4) ;; <CJK>
     (?$(0Cv(B . ?\x86DB) ;; <CJK>
     (?$(0Cw(B . ?\x86E4) ;; <CJK>
     (?$(0Cx(B . ?\x86D0) ;; <CJK>
     (?$(0Cy(B . ?\x86DE) ;; <CJK>
     (?$(0Cz(B . ?\x8857) ;; <CJK>
     (?$(0C{(B . ?\x88C1) ;; <CJK>
     (?$(0C|(B . ?\x88C2) ;; <CJK>
     (?$(0C}(B . ?\x88B1) ;; <CJK>
     (?$(0C~(B . ?\x8983) ;; <CJK>
     (?$(0D!(B . ?\x8996) ;; <CJK>
     (?$(0D"(B . ?\x8A3B) ;; <CJK>
     (?$(0D#(B . ?\x8A60) ;; <CJK>
     (?$(0D$(B . ?\x8A55) ;; <CJK>
     (?$(0D%(B . ?\x8A5E) ;; <CJK>
     (?$(0D&(B . ?\x8A3C) ;; <CJK>
     (?$(0D'(B . ?\x8A41) ;; <CJK>
     (?$(0D((B . ?\x8A54) ;; <CJK>
     (?$(0D)(B . ?\x8A5B) ;; <CJK>
     (?$(0D*(B . ?\x8A50) ;; <CJK>
     (?$(0D+(B . ?\x8A46) ;; <CJK>
     (?$(0D,(B . ?\x8A34) ;; <CJK>
     (?$(0D-(B . ?\x8A3A) ;; <CJK>
     (?$(0D.(B . ?\x8A36) ;; <CJK>
     (?$(0D/(B . ?\x8A56) ;; <CJK>
     (?$(0D0(B . ?\x8C61) ;; <CJK>
     (?$(0D1(B . ?\x8C82) ;; <CJK>
     (?$(0D2(B . ?\x8CAF) ;; <CJK>
     (?$(0D3(B . ?\x8CBC) ;; <CJK>
     (?$(0D4(B . ?\x8CB3) ;; <CJK>
     (?$(0D5(B . ?\x8CBD) ;; <CJK>
     (?$(0D6(B . ?\x8CC1) ;; <CJK>
     (?$(0D7(B . ?\x8CBB) ;; <CJK>
     (?$(0D8(B . ?\x8CC0) ;; <CJK>
     (?$(0D9(B . ?\x8CB4) ;; <CJK>
     (?$(0D:(B . ?\x8CB7) ;; <CJK>
     (?$(0D;(B . ?\x8CB6) ;; <CJK>
     (?$(0D<(B . ?\x8CBF) ;; <CJK>
     (?$(0D=(B . ?\x8CB8) ;; <CJK>
     (?$(0D>(B . ?\x8D8A) ;; <CJK>
     (?$(0D?(B . ?\x8D85) ;; <CJK>
     (?$(0D@(B . ?\x8D81) ;; <CJK>
     (?$(0DA(B . ?\x8DCE) ;; <CJK>
     (?$(0DB(B . ?\x8DDD) ;; <CJK>
     (?$(0DC(B . ?\x8DCB) ;; <CJK>
     (?$(0DD(B . ?\x8DDA) ;; <CJK>
     (?$(0DE(B . ?\x8DD1) ;; <CJK>
     (?$(0DF(B . ?\x8DCC) ;; <CJK>
     (?$(0DG(B . ?\x8DDB) ;; <CJK>
     (?$(0DH(B . ?\x8DC6) ;; <CJK>
     (?$(0DI(B . ?\x8EFB) ;; <CJK>
     (?$(0DJ(B . ?\x8EF8) ;; <CJK>
     (?$(0DK(B . ?\x8EFC) ;; <CJK>
     (?$(0DL(B . ?\x8F9C) ;; <CJK>
     (?$(0DM(B . ?\x902E) ;; <CJK>
     (?$(0DN(B . ?\x9035) ;; <CJK>
     (?$(0DO(B . ?\x9031) ;; <CJK>
     (?$(0DP(B . ?\x9038) ;; <CJK>
     (?$(0DQ(B . ?\x9032) ;; <CJK>
     (?$(0DR(B . ?\x9036) ;; <CJK>
     (?$(0DS(B . ?\x9102) ;; <CJK>
     (?$(0DT(B . ?\x90F5) ;; <CJK>
     (?$(0DU(B . ?\x9109) ;; <CJK>
     (?$(0DV(B . ?\x90FE) ;; <CJK>
     (?$(0DW(B . ?\x9163) ;; <CJK>
     (?$(0DX(B . ?\x9165) ;; <CJK>
     (?$(0DY(B . ?\x91CF) ;; <CJK>
     (?$(0DZ(B . ?\x9214) ;; <CJK>
     (?$(0D[(B . ?\x9215) ;; <CJK>
     (?$(0D\(B . ?\x9223) ;; <CJK>
     (?$(0D](B . ?\x9209) ;; <CJK>
     (?$(0D^(B . ?\x921E) ;; <CJK>
     (?$(0D_(B . ?\x920D) ;; <CJK>
     (?$(0D`(B . ?\x9210) ;; <CJK>
     (?$(0Da(B . ?\x9207) ;; <CJK>
     (?$(0Db(B . ?\x9211) ;; <CJK>
     (?$(0Dc(B . ?\x9594) ;; <CJK>
     (?$(0Dd(B . ?\x958F) ;; <CJK>
     (?$(0De(B . ?\x958B) ;; <CJK>
     (?$(0Df(B . ?\x9591) ;; <CJK>
     (?$(0Dg(B . ?\x9593) ;; <CJK>
     (?$(0Dh(B . ?\x9592) ;; <CJK>
     (?$(0Di(B . ?\x958E) ;; <CJK>
     (?$(0Dj(B . ?\x968A) ;; <CJK>
     (?$(0Dk(B . ?\x968E) ;; <CJK>
     (?$(0Dl(B . ?\x968B) ;; <CJK>
     (?$(0Dm(B . ?\x967D) ;; <CJK>
     (?$(0Dn(B . ?\x9685) ;; <CJK>
     (?$(0Do(B . ?\x9686) ;; <CJK>
     (?$(0Dp(B . ?\x968D) ;; <CJK>
     (?$(0Dq(B . ?\x9672) ;; <CJK>
     (?$(0Dr(B . ?\x9684) ;; <CJK>
     (?$(0Ds(B . ?\x96C1) ;; <CJK>
     (?$(0Dt(B . ?\x96C5) ;; <CJK>
     (?$(0Du(B . ?\x96C4) ;; <CJK>
     (?$(0Dv(B . ?\x96C6) ;; <CJK>
     (?$(0Dw(B . ?\x96C7) ;; <CJK>
     (?$(0Dx(B . ?\x96EF) ;; <CJK>
     (?$(0Dy(B . ?\x96F2) ;; <CJK>
     (?$(0Dz(B . ?\x97CC) ;; <CJK>
     (?$(0D{(B . ?\x9805) ;; <CJK>
     (?$(0D|(B . ?\x9806) ;; <CJK>
     (?$(0D}(B . ?\x9808) ;; <CJK>
     (?$(0D~(B . ?\x98E7) ;; <CJK>
     (?$(0E!(B . ?\x98EA) ;; <CJK>
     (?$(0E"(B . ?\x98EF) ;; <CJK>
     (?$(0E#(B . ?\x98E9) ;; <CJK>
     (?$(0E$(B . ?\x98F2) ;; <CJK>
     (?$(0E%(B . ?\x98ED) ;; <CJK>
     (?$(0E&(B . ?\x99AE) ;; <CJK>
     (?$(0E'(B . ?\x99AD) ;; <CJK>
     (?$(0E((B . ?\x9EC3) ;; <CJK>
     (?$(0E)(B . ?\x9ECD) ;; <CJK>
     (?$(0E*(B . ?\x9ED1) ;; <CJK>
     (?$(0E+(B . ?\x4E82) ;; <CJK>
     (?$(0E,(B . ?\x50AD) ;; <CJK>
     (?$(0E-(B . ?\x50B5) ;; <CJK>
     (?$(0E.(B . ?\x50B2) ;; <CJK>
     (?$(0E/(B . ?\x50B3) ;; <CJK>
     (?$(0E0(B . ?\x50C5) ;; <CJK>
     (?$(0E1(B . ?\x50BE) ;; <CJK>
     (?$(0E2(B . ?\x50AC) ;; <CJK>
     (?$(0E3(B . ?\x50B7) ;; <CJK>
     (?$(0E4(B . ?\x50BB) ;; <CJK>
     (?$(0E5(B . ?\x50AF) ;; <CJK>
     (?$(0E6(B . ?\x50C7) ;; <CJK>
     (?$(0E7(B . ?\x527F) ;; <CJK>
     (?$(0E8(B . ?\x5277) ;; <CJK>
     (?$(0E9(B . ?\x527D) ;; <CJK>
     (?$(0E:(B . ?\x52DF) ;; <CJK>
     (?$(0E;(B . ?\x52E6) ;; <CJK>
     (?$(0E<(B . ?\x52E4) ;; <CJK>
     (?$(0E=(B . ?\x52E2) ;; <CJK>
     (?$(0E>(B . ?\x52E3) ;; <CJK>
     (?$(0E?(B . ?\x532F) ;; <CJK>
     (?$(0E@(B . ?\x55DF) ;; <CJK>
     (?$(0EA(B . ?\x55E8) ;; <CJK>
     (?$(0EB(B . ?\x55D3) ;; <CJK>
     (?$(0EC(B . ?\x55E6) ;; <CJK>
     (?$(0ED(B . ?\x55CE) ;; <CJK>
     (?$(0EE(B . ?\x55DC) ;; <CJK>
     (?$(0EF(B . ?\x55C7) ;; <CJK>
     (?$(0EG(B . ?\x55D1) ;; <CJK>
     (?$(0EH(B . ?\x55E3) ;; <CJK>
     (?$(0EI(B . ?\x55E4) ;; <CJK>
     (?$(0EJ(B . ?\x55EF) ;; <CJK>
     (?$(0EK(B . ?\x55DA) ;; <CJK>
     (?$(0EL(B . ?\x55E1) ;; <CJK>
     (?$(0EM(B . ?\x55C5) ;; <CJK>
     (?$(0EN(B . ?\x55C6) ;; <CJK>
     (?$(0EO(B . ?\x55E5) ;; <CJK>
     (?$(0EP(B . ?\x55C9) ;; <CJK>
     (?$(0EQ(B . ?\x5712) ;; <CJK>
     (?$(0ER(B . ?\x5713) ;; <CJK>
     (?$(0ES(B . ?\x585E) ;; <CJK>
     (?$(0ET(B . ?\x5851) ;; <CJK>
     (?$(0EU(B . ?\x5858) ;; <CJK>
     (?$(0EV(B . ?\x5857) ;; <CJK>
     (?$(0EW(B . ?\x585A) ;; <CJK>
     (?$(0EX(B . ?\x5854) ;; <CJK>
     (?$(0EY(B . ?\x586B) ;; <CJK>
     (?$(0EZ(B . ?\x584C) ;; <CJK>
     (?$(0E[(B . ?\x586D) ;; <CJK>
     (?$(0E\(B . ?\x584A) ;; <CJK>
     (?$(0E](B . ?\x5862) ;; <CJK>
     (?$(0E^(B . ?\x5852) ;; <CJK>
     (?$(0E_(B . ?\x584B) ;; <CJK>
     (?$(0E`(B . ?\x5967) ;; <CJK>
     (?$(0Ea(B . ?\x5AC1) ;; <CJK>
     (?$(0Eb(B . ?\x5AC9) ;; <CJK>
     (?$(0Ec(B . ?\x5ACC) ;; <CJK>
     (?$(0Ed(B . ?\x5ABE) ;; <CJK>
     (?$(0Ee(B . ?\x5ABD) ;; <CJK>
     (?$(0Ef(B . ?\x5ABC) ;; <CJK>
     (?$(0Eg(B . ?\x5AB3) ;; <CJK>
     (?$(0Eh(B . ?\x5AC2) ;; <CJK>
     (?$(0Ei(B . ?\x5AB2) ;; <CJK>
     (?$(0Ej(B . ?\x5D69) ;; <CJK>
     (?$(0Ek(B . ?\x5D6F) ;; <CJK>
     (?$(0El(B . ?\x5E4C) ;; <CJK>
     (?$(0Em(B . ?\x5E79) ;; <CJK>
     (?$(0En(B . ?\x5EC9) ;; <CJK>
     (?$(0Eo(B . ?\x5EC8) ;; <CJK>
     (?$(0Ep(B . ?\x5F12) ;; <CJK>
     (?$(0Eq(B . ?\x5F59) ;; <CJK>
     (?$(0Er(B . ?\x5FAC) ;; <CJK>
     (?$(0Es(B . ?\x5FAE) ;; <CJK>
     (?$(0Et(B . ?\x611A) ;; <CJK>
     (?$(0Eu(B . ?\x610F) ;; <CJK>
     (?$(0Ev(B . ?\x6148) ;; <CJK>
     (?$(0Ew(B . ?\x611F) ;; <CJK>
     (?$(0Ex(B . ?\x60F3) ;; <CJK>
     (?$(0Ey(B . ?\x611B) ;; <CJK>
     (?$(0Ez(B . ?\x60F9) ;; <CJK>
     (?$(0E{(B . ?\x6101) ;; <CJK>
     (?$(0E|(B . ?\x6108) ;; <CJK>
     (?$(0E}(B . ?\x614E) ;; <CJK>
     (?$(0E~(B . ?\x614C) ;; <CJK>
     (?$(0F!(B . ?\x6144) ;; <CJK>
     (?$(0F"(B . ?\x614D) ;; <CJK>
     (?$(0F#(B . ?\x613E) ;; <CJK>
     (?$(0F$(B . ?\x6134) ;; <CJK>
     (?$(0F%(B . ?\x6127) ;; <CJK>
     (?$(0F&(B . ?\x610D) ;; <CJK>
     (?$(0F'(B . ?\x6106) ;; <CJK>
     (?$(0F((B . ?\x6137) ;; <CJK>
     (?$(0F)(B . ?\x6221) ;; <CJK>
     (?$(0F*(B . ?\x6222) ;; <CJK>
     (?$(0F+(B . ?\x6413) ;; <CJK>
     (?$(0F,(B . ?\x643E) ;; <CJK>
     (?$(0F-(B . ?\x641E) ;; <CJK>
     (?$(0F.(B . ?\x642A) ;; <CJK>
     (?$(0F/(B . ?\x642D) ;; <CJK>
     (?$(0F0(B . ?\x643D) ;; <CJK>
     (?$(0F1(B . ?\x642C) ;; <CJK>
     (?$(0F2(B . ?\x640F) ;; <CJK>
     (?$(0F3(B . ?\x641C) ;; <CJK>
     (?$(0F4(B . ?\x6414) ;; <CJK>
     (?$(0F5(B . ?\x640D) ;; <CJK>
     (?$(0F6(B . ?\x6436) ;; <CJK>
     (?$(0F7(B . ?\x6416) ;; <CJK>
     (?$(0F8(B . ?\x6417) ;; <CJK>
     (?$(0F9(B . ?\x6406) ;; <CJK>
     (?$(0F:(B . ?\x656C) ;; <CJK>
     (?$(0F;(B . ?\x659F) ;; <CJK>
     (?$(0F<(B . ?\x65B0) ;; <CJK>
     (?$(0F=(B . ?\x6697) ;; <CJK>
     (?$(0F>(B . ?\x6689) ;; <CJK>
     (?$(0F?(B . ?\x6687) ;; <CJK>
     (?$(0F@(B . ?\x6688) ;; <CJK>
     (?$(0FA(B . ?\x6696) ;; <CJK>
     (?$(0FB(B . ?\x6684) ;; <CJK>
     (?$(0FC(B . ?\x6698) ;; <CJK>
     (?$(0FD(B . ?\x668D) ;; <CJK>
     (?$(0FE(B . ?\x6703) ;; <CJK>
     (?$(0FF(B . ?\x6994) ;; <CJK>
     (?$(0FG(B . ?\x696D) ;; <CJK>
     (?$(0FH(B . ?\x695A) ;; <CJK>
     (?$(0FI(B . ?\x6977) ;; <CJK>
     (?$(0FJ(B . ?\x6960) ;; <CJK>
     (?$(0FK(B . ?\x6954) ;; <CJK>
     (?$(0FL(B . ?\x6975) ;; <CJK>
     (?$(0FM(B . ?\x6930) ;; <CJK>
     (?$(0FN(B . ?\x6982) ;; <CJK>
     (?$(0FO(B . ?\x694A) ;; <CJK>
     (?$(0FP(B . ?\x6968) ;; <CJK>
     (?$(0FQ(B . ?\x696B) ;; <CJK>
     (?$(0FR(B . ?\x695E) ;; <CJK>
     (?$(0FS(B . ?\x6953) ;; <CJK>
     (?$(0FT(B . ?\x6979) ;; <CJK>
     (?$(0FU(B . ?\x6986) ;; <CJK>
     (?$(0FV(B . ?\x695D) ;; <CJK>
     (?$(0FW(B . ?\x6963) ;; <CJK>
     (?$(0FX(B . ?\x695B) ;; <CJK>
     (?$(0FY(B . ?\x6B47) ;; <CJK>
     (?$(0FZ(B . ?\x6B72) ;; <CJK>
     (?$(0F[(B . ?\x6BC0) ;; <CJK>
     (?$(0F\(B . ?\x6BBF) ;; <CJK>
     (?$(0F](B . ?\x6BD3) ;; <CJK>
     (?$(0F^(B . ?\x6BFD) ;; <CJK>
     (?$(0F_(B . ?\x6EA2) ;; <CJK>
     (?$(0F`(B . ?\x6EAF) ;; <CJK>
     (?$(0Fa(B . ?\x6ED3) ;; <CJK>
     (?$(0Fb(B . ?\x6EB6) ;; <CJK>
     (?$(0Fc(B . ?\x6EC2) ;; <CJK>
     (?$(0Fd(B . ?\x6E90) ;; <CJK>
     (?$(0Fe(B . ?\x6E9D) ;; <CJK>
     (?$(0Ff(B . ?\x6EC7) ;; <CJK>
     (?$(0Fg(B . ?\x6EC5) ;; <CJK>
     (?$(0Fh(B . ?\x6EA5) ;; <CJK>
     (?$(0Fi(B . ?\x6E98) ;; <CJK>
     (?$(0Fj(B . ?\x6EBC) ;; <CJK>
     (?$(0Fk(B . ?\x6EBA) ;; <CJK>
     (?$(0Fl(B . ?\x6EAB) ;; <CJK>
     (?$(0Fm(B . ?\x6ED1) ;; <CJK>
     (?$(0Fn(B . ?\x6E96) ;; <CJK>
     (?$(0Fo(B . ?\x6E9C) ;; <CJK>
     (?$(0Fp(B . ?\x6EC4) ;; <CJK>
     (?$(0Fq(B . ?\x6ED4) ;; <CJK>
     (?$(0Fr(B . ?\x6EAA) ;; <CJK>
     (?$(0Fs(B . ?\x6EA7) ;; <CJK>
     (?$(0Ft(B . ?\x6EB4) ;; <CJK>
     (?$(0Fu(B . ?\x714E) ;; <CJK>
     (?$(0Fv(B . ?\x7159) ;; <CJK>
     (?$(0Fw(B . ?\x7169) ;; <CJK>
     (?$(0Fx(B . ?\x7164) ;; <CJK>
     (?$(0Fy(B . ?\x7149) ;; <CJK>
     (?$(0Fz(B . ?\x7167) ;; <CJK>
     (?$(0F{(B . ?\x715C) ;; <CJK>
     (?$(0F|(B . ?\x716C) ;; <CJK>
     (?$(0F}(B . ?\x7166) ;; <CJK>
     (?$(0F~(B . ?\x714C) ;; <CJK>
     (?$(0G!(B . ?\x7165) ;; <CJK>
     (?$(0G"(B . ?\x715E) ;; <CJK>
     (?$(0G#(B . ?\x7146) ;; <CJK>
     (?$(0G$(B . ?\x7168) ;; <CJK>
     (?$(0G%(B . ?\x7156) ;; <CJK>
     (?$(0G&(B . ?\x723A) ;; <CJK>
     (?$(0G'(B . ?\x7252) ;; <CJK>
     (?$(0G((B . ?\x7337) ;; <CJK>
     (?$(0G)(B . ?\x7345) ;; <CJK>
     (?$(0G*(B . ?\x733F) ;; <CJK>
     (?$(0G+(B . ?\x733E) ;; <CJK>
     (?$(0G,(B . ?\x746F) ;; <CJK>
     (?$(0G-(B . ?\x745A) ;; <CJK>
     (?$(0G.(B . ?\x7455) ;; <CJK>
     (?$(0G/(B . ?\x745F) ;; <CJK>
     (?$(0G0(B . ?\x745E) ;; <CJK>
     (?$(0G1(B . ?\x7441) ;; <CJK>
     (?$(0G2(B . ?\x743F) ;; <CJK>
     (?$(0G3(B . ?\x7459) ;; <CJK>
     (?$(0G4(B . ?\x745B) ;; <CJK>
     (?$(0G5(B . ?\x745C) ;; <CJK>
     (?$(0G6(B . ?\x7576) ;; <CJK>
     (?$(0G7(B . ?\x7578) ;; <CJK>
     (?$(0G8(B . ?\x7600) ;; <CJK>
     (?$(0G9(B . ?\x75F0) ;; <CJK>
     (?$(0G:(B . ?\x7601) ;; <CJK>
     (?$(0G;(B . ?\x75F2) ;; <CJK>
     (?$(0G<(B . ?\x75F1) ;; <CJK>
     (?$(0G=(B . ?\x75FA) ;; <CJK>
     (?$(0G>(B . ?\x75FF) ;; <CJK>
     (?$(0G?(B . ?\x75F4) ;; <CJK>
     (?$(0G@(B . ?\x75F3) ;; <CJK>
     (?$(0GA(B . ?\x76DE) ;; <CJK>
     (?$(0GB(B . ?\x76DF) ;; <CJK>
     (?$(0GC(B . ?\x775B) ;; <CJK>
     (?$(0GD(B . ?\x776B) ;; <CJK>
     (?$(0GE(B . ?\x7766) ;; <CJK>
     (?$(0GF(B . ?\x775E) ;; <CJK>
     (?$(0GG(B . ?\x7763) ;; <CJK>
     (?$(0GH(B . ?\x7779) ;; <CJK>
     (?$(0GI(B . ?\x776A) ;; <CJK>
     (?$(0GJ(B . ?\x776C) ;; <CJK>
     (?$(0GK(B . ?\x775C) ;; <CJK>
     (?$(0GL(B . ?\x7765) ;; <CJK>
     (?$(0GM(B . ?\x7768) ;; <CJK>
     (?$(0GN(B . ?\x7762) ;; <CJK>
     (?$(0GO(B . ?\x77EE) ;; <CJK>
     (?$(0GP(B . ?\x788E) ;; <CJK>
     (?$(0GQ(B . ?\x78B0) ;; <CJK>
     (?$(0GR(B . ?\x7897) ;; <CJK>
     (?$(0GS(B . ?\x7898) ;; <CJK>
     (?$(0GT(B . ?\x788C) ;; <CJK>
     (?$(0GU(B . ?\x7889) ;; <CJK>
     (?$(0GV(B . ?\x787C) ;; <CJK>
     (?$(0GW(B . ?\x7891) ;; <CJK>
     (?$(0GX(B . ?\x7893) ;; <CJK>
     (?$(0GY(B . ?\x787F) ;; <CJK>
     (?$(0GZ(B . ?\x797A) ;; <CJK>
     (?$(0G[(B . ?\x797F) ;; <CJK>
     (?$(0G\(B . ?\x7981) ;; <CJK>
     (?$(0G](B . ?\x842C) ;; <CJK>
     (?$(0G^(B . ?\x79BD) ;; <CJK>
     (?$(0G_(B . ?\x7A1C) ;; <CJK>
     (?$(0G`(B . ?\x7A1A) ;; <CJK>
     (?$(0Ga(B . ?\x7A20) ;; <CJK>
     (?$(0Gb(B . ?\x7A14) ;; <CJK>
     (?$(0Gc(B . ?\x7A1F) ;; <CJK>
     (?$(0Gd(B . ?\x7A1E) ;; <CJK>
     (?$(0Ge(B . ?\x7A9F) ;; <CJK>
     (?$(0Gf(B . ?\x7AA0) ;; <CJK>
     (?$(0Gg(B . ?\x7B77) ;; <CJK>
     (?$(0Gh(B . ?\x7BC0) ;; <CJK>
     (?$(0Gi(B . ?\x7B60) ;; <CJK>
     (?$(0Gj(B . ?\x7B6E) ;; <CJK>
     (?$(0Gk(B . ?\x7B67) ;; <CJK>
     (?$(0Gl(B . ?\x7CB1) ;; <CJK>
     (?$(0Gm(B . ?\x7CB3) ;; <CJK>
     (?$(0Gn(B . ?\x7CB5) ;; <CJK>
     (?$(0Go(B . ?\x7D93) ;; <CJK>
     (?$(0Gp(B . ?\x7D79) ;; <CJK>
     (?$(0Gq(B . ?\x7D91) ;; <CJK>
     (?$(0Gr(B . ?\x7D81) ;; <CJK>
     (?$(0Gs(B . ?\x7D8F) ;; <CJK>
     (?$(0Gt(B . ?\x7D5B) ;; <CJK>
     (?$(0Gu(B . ?\x7F6E) ;; <CJK>
     (?$(0Gv(B . ?\x7F69) ;; <CJK>
     (?$(0Gw(B . ?\x7F6A) ;; <CJK>
     (?$(0Gx(B . ?\x7F72) ;; <CJK>
     (?$(0Gy(B . ?\x7FA9) ;; <CJK>
     (?$(0Gz(B . ?\x7FA8) ;; <CJK>
     (?$(0G{(B . ?\x7FA4) ;; <CJK>
     (?$(0G|(B . ?\x8056) ;; <CJK>
     (?$(0G}(B . ?\x8058) ;; <CJK>
     (?$(0G~(B . ?\x8086) ;; <CJK>
     (?$(0H!(B . ?\x8084) ;; <CJK>
     (?$(0H"(B . ?\x8171) ;; <CJK>
     (?$(0H#(B . ?\x8170) ;; <CJK>
     (?$(0H$(B . ?\x8178) ;; <CJK>
     (?$(0H%(B . ?\x8165) ;; <CJK>
     (?$(0H&(B . ?\x816E) ;; <CJK>
     (?$(0H'(B . ?\x8173) ;; <CJK>
     (?$(0H((B . ?\x816B) ;; <CJK>
     (?$(0H)(B . ?\x8179) ;; <CJK>
     (?$(0H*(B . ?\x817A) ;; <CJK>
     (?$(0H+(B . ?\x8166) ;; <CJK>
     (?$(0H,(B . ?\x8205) ;; <CJK>
     (?$(0H-(B . ?\x8247) ;; <CJK>
     (?$(0H.(B . ?\x8482) ;; <CJK>
     (?$(0H/(B . ?\x8477) ;; <CJK>
     (?$(0H0(B . ?\x843D) ;; <CJK>
     (?$(0H1(B . ?\x8431) ;; <CJK>
     (?$(0H2(B . ?\x8475) ;; <CJK>
     (?$(0H3(B . ?\x8466) ;; <CJK>
     (?$(0H4(B . ?\x846B) ;; <CJK>
     (?$(0H5(B . ?\x8449) ;; <CJK>
     (?$(0H6(B . ?\x846C) ;; <CJK>
     (?$(0H7(B . ?\x845B) ;; <CJK>
     (?$(0H8(B . ?\x843C) ;; <CJK>
     (?$(0H9(B . ?\x8435) ;; <CJK>
     (?$(0H:(B . ?\x8461) ;; <CJK>
     (?$(0H;(B . ?\x8463) ;; <CJK>
     (?$(0H<(B . ?\x8469) ;; <CJK>
     (?$(0H=(B . ?\x846D) ;; <CJK>
     (?$(0H>(B . ?\x8446) ;; <CJK>
     (?$(0H?(B . ?\x865E) ;; <CJK>
     (?$(0H@(B . ?\x865C) ;; <CJK>
     (?$(0HA(B . ?\x865F) ;; <CJK>
     (?$(0HB(B . ?\x86F9) ;; <CJK>
     (?$(0HC(B . ?\x8713) ;; <CJK>
     (?$(0HD(B . ?\x8708) ;; <CJK>
     (?$(0HE(B . ?\x8707) ;; <CJK>
     (?$(0HF(B . ?\x8700) ;; <CJK>
     (?$(0HG(B . ?\x86FE) ;; <CJK>
     (?$(0HH(B . ?\x86FB) ;; <CJK>
     (?$(0HI(B . ?\x8702) ;; <CJK>
     (?$(0HJ(B . ?\x8703) ;; <CJK>
     (?$(0HK(B . ?\x8706) ;; <CJK>
     (?$(0HL(B . ?\x870A) ;; <CJK>
     (?$(0HM(B . ?\x8859) ;; <CJK>
     (?$(0HN(B . ?\x88DF) ;; <CJK>
     (?$(0HO(B . ?\x88D4) ;; <CJK>
     (?$(0HP(B . ?\x88D9) ;; <CJK>
     (?$(0HQ(B . ?\x88DC) ;; <CJK>
     (?$(0HR(B . ?\x88D8) ;; <CJK>
     (?$(0HS(B . ?\x88DD) ;; <CJK>
     (?$(0HT(B . ?\x88E1) ;; <CJK>
     (?$(0HU(B . ?\x88CA) ;; <CJK>
     (?$(0HV(B . ?\x88D5) ;; <CJK>
     (?$(0HW(B . ?\x88D2) ;; <CJK>
     (?$(0HX(B . ?\x899C) ;; <CJK>
     (?$(0HY(B . ?\x89E3) ;; <CJK>
     (?$(0HZ(B . ?\x8A6B) ;; <CJK>
     (?$(0H[(B . ?\x8A72) ;; <CJK>
     (?$(0H\(B . ?\x8A73) ;; <CJK>
     (?$(0H](B . ?\x8A66) ;; <CJK>
     (?$(0H^(B . ?\x8A69) ;; <CJK>
     (?$(0H_(B . ?\x8A70) ;; <CJK>
     (?$(0H`(B . ?\x8A87) ;; <CJK>
     (?$(0Ha(B . ?\x8A7C) ;; <CJK>
     (?$(0Hb(B . ?\x8A63) ;; <CJK>
     (?$(0Hc(B . ?\x8AA0) ;; <CJK>
     (?$(0Hd(B . ?\x8A71) ;; <CJK>
     (?$(0He(B . ?\x8A85) ;; <CJK>
     (?$(0Hf(B . ?\x8A6D) ;; <CJK>
     (?$(0Hg(B . ?\x8A62) ;; <CJK>
     (?$(0Hh(B . ?\x8A6E) ;; <CJK>
     (?$(0Hi(B . ?\x8A6C) ;; <CJK>
     (?$(0Hj(B . ?\x8A79) ;; <CJK>
     (?$(0Hk(B . ?\x8A7B) ;; <CJK>
     (?$(0Hl(B . ?\x8A3E) ;; <CJK>
     (?$(0Hm(B . ?\x8A68) ;; <CJK>
     (?$(0Hn(B . ?\x8C62) ;; <CJK>
     (?$(0Ho(B . ?\x8C8A) ;; <CJK>
     (?$(0Hp(B . ?\x8C89) ;; <CJK>
     (?$(0Hq(B . ?\x8CCA) ;; <CJK>
     (?$(0Hr(B . ?\x8CC7) ;; <CJK>
     (?$(0Hs(B . ?\x8CC8) ;; <CJK>
     (?$(0Ht(B . ?\x8CC4) ;; <CJK>
     (?$(0Hu(B . ?\x8CB2) ;; <CJK>
     (?$(0Hv(B . ?\x8CC3) ;; <CJK>
     (?$(0Hw(B . ?\x8CC2) ;; <CJK>
     (?$(0Hx(B . ?\x8CC5) ;; <CJK>
     (?$(0Hy(B . ?\x8DE1) ;; <CJK>
     (?$(0Hz(B . ?\x8DDF) ;; <CJK>
     (?$(0H{(B . ?\x8DE8) ;; <CJK>
     (?$(0H|(B . ?\x8DEF) ;; <CJK>
     (?$(0H}(B . ?\x8DF3) ;; <CJK>
     (?$(0H~(B . ?\x8DFA) ;; <CJK>
     (?$(0I!(B . ?\x8DEA) ;; <CJK>
     (?$(0I"(B . ?\x8DE4) ;; <CJK>
     (?$(0I#(B . ?\x8DE6) ;; <CJK>
     (?$(0I$(B . ?\x8EB2) ;; <CJK>
     (?$(0I%(B . ?\x8F03) ;; <CJK>
     (?$(0I&(B . ?\x8F09) ;; <CJK>
     (?$(0I'(B . ?\x8EFE) ;; <CJK>
     (?$(0I((B . ?\x8F0A) ;; <CJK>
     (?$(0I)(B . ?\x8F9F) ;; <CJK>
     (?$(0I*(B . ?\x8FB2) ;; <CJK>
     (?$(0I+(B . ?\x904B) ;; <CJK>
     (?$(0I,(B . ?\x904A) ;; <CJK>
     (?$(0I-(B . ?\x9053) ;; <CJK>
     (?$(0I.(B . ?\x9042) ;; <CJK>
     (?$(0I/(B . ?\x9054) ;; <CJK>
     (?$(0I0(B . ?\x903C) ;; <CJK>
     (?$(0I1(B . ?\x9055) ;; <CJK>
     (?$(0I2(B . ?\x9050) ;; <CJK>
     (?$(0I3(B . ?\x9047) ;; <CJK>
     (?$(0I4(B . ?\x904F) ;; <CJK>
     (?$(0I5(B . ?\x904E) ;; <CJK>
     (?$(0I6(B . ?\x904D) ;; <CJK>
     (?$(0I7(B . ?\x9051) ;; <CJK>
     (?$(0I8(B . ?\x903E) ;; <CJK>
     (?$(0I9(B . ?\x9041) ;; <CJK>
     (?$(0I:(B . ?\x9112) ;; <CJK>
     (?$(0I;(B . ?\x9117) ;; <CJK>
     (?$(0I<(B . ?\x916C) ;; <CJK>
     (?$(0I=(B . ?\x916A) ;; <CJK>
     (?$(0I>(B . ?\x9169) ;; <CJK>
     (?$(0I?(B . ?\x91C9) ;; <CJK>
     (?$(0I@(B . ?\x9237) ;; <CJK>
     (?$(0IA(B . ?\x9257) ;; <CJK>
     (?$(0IB(B . ?\x9238) ;; <CJK>
     (?$(0IC(B . ?\x923D) ;; <CJK>
     (?$(0ID(B . ?\x9240) ;; <CJK>
     (?$(0IE(B . ?\x923E) ;; <CJK>
     (?$(0IF(B . ?\x925B) ;; <CJK>
     (?$(0IG(B . ?\x924B) ;; <CJK>
     (?$(0IH(B . ?\x9264) ;; <CJK>
     (?$(0II(B . ?\x9251) ;; <CJK>
     (?$(0IJ(B . ?\x9234) ;; <CJK>
     (?$(0IK(B . ?\x9249) ;; <CJK>
     (?$(0IL(B . ?\x924D) ;; <CJK>
     (?$(0IM(B . ?\x9245) ;; <CJK>
     (?$(0IN(B . ?\x9239) ;; <CJK>
     (?$(0IO(B . ?\x923F) ;; <CJK>
     (?$(0IP(B . ?\x925A) ;; <CJK>
     (?$(0IQ(B . ?\x9598) ;; <CJK>
     (?$(0IR(B . ?\x9698) ;; <CJK>
     (?$(0IS(B . ?\x9694) ;; <CJK>
     (?$(0IT(B . ?\x9695) ;; <CJK>
     (?$(0IU(B . ?\x96CD) ;; <CJK>
     (?$(0IV(B . ?\x96CB) ;; <CJK>
     (?$(0IW(B . ?\x96C9) ;; <CJK>
     (?$(0IX(B . ?\x96CA) ;; <CJK>
     (?$(0IY(B . ?\x96F7) ;; <CJK>
     (?$(0IZ(B . ?\x96FB) ;; <CJK>
     (?$(0I[(B . ?\x96F9) ;; <CJK>
     (?$(0I\(B . ?\x96F6) ;; <CJK>
     (?$(0I](B . ?\x9756) ;; <CJK>
     (?$(0I^(B . ?\x9774) ;; <CJK>
     (?$(0I_(B . ?\x9776) ;; <CJK>
     (?$(0I`(B . ?\x9810) ;; <CJK>
     (?$(0Ia(B . ?\x9811) ;; <CJK>
     (?$(0Ib(B . ?\x9813) ;; <CJK>
     (?$(0Ic(B . ?\x980A) ;; <CJK>
     (?$(0Id(B . ?\x9812) ;; <CJK>
     (?$(0Ie(B . ?\x980C) ;; <CJK>
     (?$(0If(B . ?\x98FC) ;; <CJK>
     (?$(0Ig(B . ?\x98F4) ;; <CJK>
     (?$(0Ih(B . ?\x98FD) ;; <CJK>
     (?$(0Ii(B . ?\x98FE) ;; <CJK>
     (?$(0Ij(B . ?\x99B3) ;; <CJK>
     (?$(0Ik(B . ?\x99B1) ;; <CJK>
     (?$(0Il(B . ?\x99B4) ;; <CJK>
     (?$(0Im(B . ?\x9AE1) ;; <CJK>
     (?$(0In(B . ?\x9CE9) ;; <CJK>
     (?$(0Io(B . ?\x9E82) ;; <CJK>
     (?$(0Ip(B . ?\x9F0E) ;; <CJK>
     (?$(0Iq(B . ?\x9F13) ;; <CJK>
     (?$(0Ir(B . ?\x9F20) ;; <CJK>
     (?$(0Is(B . ?\x50E7) ;; <CJK>
     (?$(0It(B . ?\x50EE) ;; <CJK>
     (?$(0Iu(B . ?\x50E5) ;; <CJK>
     (?$(0Iv(B . ?\x50D6) ;; <CJK>
     (?$(0Iw(B . ?\x50ED) ;; <CJK>
     (?$(0Ix(B . ?\x50DA) ;; <CJK>
     (?$(0Iy(B . ?\x50D5) ;; <CJK>
     (?$(0Iz(B . ?\x50CF) ;; <CJK>
     (?$(0I{(B . ?\x50D1) ;; <CJK>
     (?$(0I|(B . ?\x50F1) ;; <CJK>
     (?$(0I}(B . ?\x50CE) ;; <CJK>
     (?$(0I~(B . ?\x50E9) ;; <CJK>
     (?$(0J!(B . ?\x5162) ;; <CJK>
     (?$(0J"(B . ?\x51F3) ;; <CJK>
     (?$(0J#(B . ?\x5283) ;; <CJK>
     (?$(0J$(B . ?\x5282) ;; <CJK>
     (?$(0J%(B . ?\x5331) ;; <CJK>
     (?$(0J&(B . ?\x53AD) ;; <CJK>
     (?$(0J'(B . ?\x55FE) ;; <CJK>
     (?$(0J((B . ?\x5600) ;; <CJK>
     (?$(0J)(B . ?\x561B) ;; <CJK>
     (?$(0J*(B . ?\x5617) ;; <CJK>
     (?$(0J+(B . ?\x55FD) ;; <CJK>
     (?$(0J,(B . ?\x5614) ;; <CJK>
     (?$(0J-(B . ?\x5606) ;; <CJK>
     (?$(0J.(B . ?\x5609) ;; <CJK>
     (?$(0J/(B . ?\x560D) ;; <CJK>
     (?$(0J0(B . ?\x560E) ;; <CJK>
     (?$(0J1(B . ?\x55F7) ;; <CJK>
     (?$(0J2(B . ?\x5616) ;; <CJK>
     (?$(0J3(B . ?\x561F) ;; <CJK>
     (?$(0J4(B . ?\x5608) ;; <CJK>
     (?$(0J5(B . ?\x5610) ;; <CJK>
     (?$(0J6(B . ?\x55F6) ;; <CJK>
     (?$(0J7(B . ?\x5718) ;; <CJK>
     (?$(0J8(B . ?\x5716) ;; <CJK>
     (?$(0J9(B . ?\x5875) ;; <CJK>
     (?$(0J:(B . ?\x587E) ;; <CJK>
     (?$(0J;(B . ?\x5883) ;; <CJK>
     (?$(0J<(B . ?\x5893) ;; <CJK>
     (?$(0J=(B . ?\x588A) ;; <CJK>
     (?$(0J>(B . ?\x5879) ;; <CJK>
     (?$(0J?(B . ?\x5885) ;; <CJK>
     (?$(0J@(B . ?\x587D) ;; <CJK>
     (?$(0JA(B . ?\x58FD) ;; <CJK>
     (?$(0JB(B . ?\x5925) ;; <CJK>
     (?$(0JC(B . ?\x5922) ;; <CJK>
     (?$(0JD(B . ?\x5924) ;; <CJK>
     (?$(0JE(B . ?\x596A) ;; <CJK>
     (?$(0JF(B . ?\x5969) ;; <CJK>
     (?$(0JG(B . ?\x5AE1) ;; <CJK>
     (?$(0JH(B . ?\x5AE6) ;; <CJK>
     (?$(0JI(B . ?\x5AE9) ;; <CJK>
     (?$(0JJ(B . ?\x5AD7) ;; <CJK>
     (?$(0JK(B . ?\x5AD6) ;; <CJK>
     (?$(0JL(B . ?\x5AD8) ;; <CJK>
     (?$(0JM(B . ?\x5AE3) ;; <CJK>
     (?$(0JN(B . ?\x5B75) ;; <CJK>
     (?$(0JO(B . ?\x5BDE) ;; <CJK>
     (?$(0JP(B . ?\x5BE7) ;; <CJK>
     (?$(0JQ(B . ?\x5BE1) ;; <CJK>
     (?$(0JR(B . ?\x5BE5) ;; <CJK>
     (?$(0JS(B . ?\x5BE6) ;; <CJK>
     (?$(0JT(B . ?\x5BE8) ;; <CJK>
     (?$(0JU(B . ?\x5BE2) ;; <CJK>
     (?$(0JV(B . ?\x5BE4) ;; <CJK>
     (?$(0JW(B . ?\x5BDF) ;; <CJK>
     (?$(0JX(B . ?\x5C0D) ;; <CJK>
     (?$(0JY(B . ?\x5C62) ;; <CJK>
     (?$(0JZ(B . ?\x5D84) ;; <CJK>
     (?$(0J[(B . ?\x5D87) ;; <CJK>
     (?$(0J\(B . ?\x5E5B) ;; <CJK>
     (?$(0J](B . ?\x5E63) ;; <CJK>
     (?$(0J^(B . ?\x5E55) ;; <CJK>
     (?$(0J_(B . ?\x5E57) ;; <CJK>
     (?$(0J`(B . ?\x5E54) ;; <CJK>
     (?$(0Ja(B . ?\x5ED3) ;; <CJK>
     (?$(0Jb(B . ?\x5ED6) ;; <CJK>
     (?$(0Jc(B . ?\x5F0A) ;; <CJK>
     (?$(0Jd(B . ?\x5F46) ;; <CJK>
     (?$(0Je(B . ?\x5F70) ;; <CJK>
     (?$(0Jf(B . ?\x5FB9) ;; <CJK>
     (?$(0Jg(B . ?\x6147) ;; <CJK>
     (?$(0Jh(B . ?\x613F) ;; <CJK>
     (?$(0Ji(B . ?\x614B) ;; <CJK>
     (?$(0Jj(B . ?\x6177) ;; <CJK>
     (?$(0Jk(B . ?\x6162) ;; <CJK>
     (?$(0Jl(B . ?\x6163) ;; <CJK>
     (?$(0Jm(B . ?\x615F) ;; <CJK>
     (?$(0Jn(B . ?\x615A) ;; <CJK>
     (?$(0Jo(B . ?\x6158) ;; <CJK>
     (?$(0Jp(B . ?\x6175) ;; <CJK>
     (?$(0Jq(B . ?\x622A) ;; <CJK>
     (?$(0Jr(B . ?\x6487) ;; <CJK>
     (?$(0Js(B . ?\x6458) ;; <CJK>
     (?$(0Jt(B . ?\x6454) ;; <CJK>
     (?$(0Ju(B . ?\x64A4) ;; <CJK>
     (?$(0Jv(B . ?\x6478) ;; <CJK>
     (?$(0Jw(B . ?\x645F) ;; <CJK>
     (?$(0Jx(B . ?\x647A) ;; <CJK>
     (?$(0Jy(B . ?\x6451) ;; <CJK>
     (?$(0Jz(B . ?\x6467) ;; <CJK>
     (?$(0J{(B . ?\x6434) ;; <CJK>
     (?$(0J|(B . ?\x646D) ;; <CJK>
     (?$(0J}(B . ?\x647B) ;; <CJK>
     (?$(0J~(B . ?\x6572) ;; <CJK>
     (?$(0K!(B . ?\x65A1) ;; <CJK>
     (?$(0K"(B . ?\x65D7) ;; <CJK>
     (?$(0K#(B . ?\x65D6) ;; <CJK>
     (?$(0K$(B . ?\x66A2) ;; <CJK>
     (?$(0K%(B . ?\x66A8) ;; <CJK>
     (?$(0K&(B . ?\x669D) ;; <CJK>
     (?$(0K'(B . ?\x699C) ;; <CJK>
     (?$(0K((B . ?\x69A8) ;; <CJK>
     (?$(0K)(B . ?\x6995) ;; <CJK>
     (?$(0K*(B . ?\x69C1) ;; <CJK>
     (?$(0K+(B . ?\x69AE) ;; <CJK>
     (?$(0K,(B . ?\x69D3) ;; <CJK>
     (?$(0K-(B . ?\x69CB) ;; <CJK>
     (?$(0K.(B . ?\x699B) ;; <CJK>
     (?$(0K/(B . ?\x69B7) ;; <CJK>
     (?$(0K0(B . ?\x69BB) ;; <CJK>
     (?$(0K1(B . ?\x69AB) ;; <CJK>
     (?$(0K2(B . ?\x69B4) ;; <CJK>
     (?$(0K3(B . ?\x69D0) ;; <CJK>
     (?$(0K4(B . ?\x69CD) ;; <CJK>
     (?$(0K5(B . ?\x69AD) ;; <CJK>
     (?$(0K6(B . ?\x69CC) ;; <CJK>
     (?$(0K7(B . ?\x69A6) ;; <CJK>
     (?$(0K8(B . ?\x69C3) ;; <CJK>
     (?$(0K9(B . ?\x69A3) ;; <CJK>
     (?$(0K:(B . ?\x6B49) ;; <CJK>
     (?$(0K;(B . ?\x6B4C) ;; <CJK>
     (?$(0K<(B . ?\x6C33) ;; <CJK>
     (?$(0K=(B . ?\x6F33) ;; <CJK>
     (?$(0K>(B . ?\x6F14) ;; <CJK>
     (?$(0K?(B . ?\x6EFE) ;; <CJK>
     (?$(0K@(B . ?\x6F13) ;; <CJK>
     (?$(0KA(B . ?\x6EF4) ;; <CJK>
     (?$(0KB(B . ?\x6F29) ;; <CJK>
     (?$(0KC(B . ?\x6F3E) ;; <CJK>
     (?$(0KD(B . ?\x6F20) ;; <CJK>
     (?$(0KE(B . ?\x6F2C) ;; <CJK>
     (?$(0KF(B . ?\x6F0F) ;; <CJK>
     (?$(0KG(B . ?\x6F02) ;; <CJK>
     (?$(0KH(B . ?\x6F22) ;; <CJK>
     (?$(0KI(B . ?\x6EFF) ;; <CJK>
     (?$(0KJ(B . ?\x6EEF) ;; <CJK>
     (?$(0KK(B . ?\x6F06) ;; <CJK>
     (?$(0KL(B . ?\x6F31) ;; <CJK>
     (?$(0KM(B . ?\x6F38) ;; <CJK>
     (?$(0KN(B . ?\x6F32) ;; <CJK>
     (?$(0KO(B . ?\x6F23) ;; <CJK>
     (?$(0KP(B . ?\x6F15) ;; <CJK>
     (?$(0KQ(B . ?\x6F2B) ;; <CJK>
     (?$(0KR(B . ?\x6F2F) ;; <CJK>
     (?$(0KS(B . ?\x6F88) ;; <CJK>
     (?$(0KT(B . ?\x6F2A) ;; <CJK>
     (?$(0KU(B . ?\x6EEC) ;; <CJK>
     (?$(0KV(B . ?\x6F01) ;; <CJK>
     (?$(0KW(B . ?\x6EF2) ;; <CJK>
     (?$(0KX(B . ?\x6ECC) ;; <CJK>
     (?$(0KY(B . ?\x6EF7) ;; <CJK>
     (?$(0KZ(B . ?\x7194) ;; <CJK>
     (?$(0K[(B . ?\x7199) ;; <CJK>
     (?$(0K\(B . ?\x717D) ;; <CJK>
     (?$(0K](B . ?\x718A) ;; <CJK>
     (?$(0K^(B . ?\x7184) ;; <CJK>
     (?$(0K_(B . ?\x7192) ;; <CJK>
     (?$(0K`(B . ?\x723E) ;; <CJK>
     (?$(0Ka(B . ?\x7292) ;; <CJK>
     (?$(0Kb(B . ?\x7296) ;; <CJK>
     (?$(0Kc(B . ?\x7344) ;; <CJK>
     (?$(0Kd(B . ?\x7350) ;; <CJK>
     (?$(0Ke(B . ?\x7464) ;; <CJK>
     (?$(0Kf(B . ?\x7463) ;; <CJK>
     (?$(0Kg(B . ?\x746A) ;; <CJK>
     (?$(0Kh(B . ?\x7470) ;; <CJK>
     (?$(0Ki(B . ?\x746D) ;; <CJK>
     (?$(0Kj(B . ?\x7504) ;; <CJK>
     (?$(0Kk(B . ?\x7591) ;; <CJK>
     (?$(0Kl(B . ?\x7627) ;; <CJK>
     (?$(0Km(B . ?\x760D) ;; <CJK>
     (?$(0Kn(B . ?\x760B) ;; <CJK>
     (?$(0Ko(B . ?\x7609) ;; <CJK>
     (?$(0Kp(B . ?\x7613) ;; <CJK>
     (?$(0Kq(B . ?\x76E1) ;; <CJK>
     (?$(0Kr(B . ?\x76E3) ;; <CJK>
     (?$(0Ks(B . ?\x7784) ;; <CJK>
     (?$(0Kt(B . ?\x777D) ;; <CJK>
     (?$(0Ku(B . ?\x777F) ;; <CJK>
     (?$(0Kv(B . ?\x7761) ;; <CJK>
     (?$(0Kw(B . ?\x78C1) ;; <CJK>
     (?$(0Kx(B . ?\x789F) ;; <CJK>
     (?$(0Ky(B . ?\x78A7) ;; <CJK>
     (?$(0Kz(B . ?\x78B3) ;; <CJK>
     (?$(0K{(B . ?\x78A9) ;; <CJK>
     (?$(0K|(B . ?\x78A3) ;; <CJK>
     (?$(0K}(B . ?\x798E) ;; <CJK>
     (?$(0K~(B . ?\x798F) ;; <CJK>
     (?$(0L!(B . ?\x798D) ;; <CJK>
     (?$(0L"(B . ?\x7A2E) ;; <CJK>
     (?$(0L#(B . ?\x7A31) ;; <CJK>
     (?$(0L$(B . ?\x7AAA) ;; <CJK>
     (?$(0L%(B . ?\x7AA9) ;; <CJK>
     (?$(0L&(B . ?\x7AED) ;; <CJK>
     (?$(0L'(B . ?\x7AEF) ;; <CJK>
     (?$(0L((B . ?\x7BA1) ;; <CJK>
     (?$(0L)(B . ?\x7B95) ;; <CJK>
     (?$(0L*(B . ?\x7B8B) ;; <CJK>
     (?$(0L+(B . ?\x7B75) ;; <CJK>
     (?$(0L,(B . ?\x7B97) ;; <CJK>
     (?$(0L-(B . ?\x7B9D) ;; <CJK>
     (?$(0L.(B . ?\x7B94) ;; <CJK>
     (?$(0L/(B . ?\x7B8F) ;; <CJK>
     (?$(0L0(B . ?\x7BB8) ;; <CJK>
     (?$(0L1(B . ?\x7B87) ;; <CJK>
     (?$(0L2(B . ?\x7B84) ;; <CJK>
     (?$(0L3(B . ?\x7CB9) ;; <CJK>
     (?$(0L4(B . ?\x7CBD) ;; <CJK>
     (?$(0L5(B . ?\x7CBE) ;; <CJK>
     (?$(0L6(B . ?\x7DBB) ;; <CJK>
     (?$(0L7(B . ?\x7DB0) ;; <CJK>
     (?$(0L8(B . ?\x7D9C) ;; <CJK>
     (?$(0L9(B . ?\x7DBD) ;; <CJK>
     (?$(0L:(B . ?\x7DBE) ;; <CJK>
     (?$(0L;(B . ?\x7DA0) ;; <CJK>
     (?$(0L<(B . ?\x7DCA) ;; <CJK>
     (?$(0L=(B . ?\x7DB4) ;; <CJK>
     (?$(0L>(B . ?\x7DB2) ;; <CJK>
     (?$(0L?(B . ?\x7DB1) ;; <CJK>
     (?$(0L@(B . ?\x7DBA) ;; <CJK>
     (?$(0LA(B . ?\x7DA2) ;; <CJK>
     (?$(0LB(B . ?\x7DBF) ;; <CJK>
     (?$(0LC(B . ?\x7DB5) ;; <CJK>
     (?$(0LD(B . ?\x7DB8) ;; <CJK>
     (?$(0LE(B . ?\x7DAD) ;; <CJK>
     (?$(0LF(B . ?\x7DD2) ;; <CJK>
     (?$(0LG(B . ?\x7DC7) ;; <CJK>
     (?$(0LH(B . ?\x7DAC) ;; <CJK>
     (?$(0LI(B . ?\x7F70) ;; <CJK>
     (?$(0LJ(B . ?\x7FE0) ;; <CJK>
     (?$(0LK(B . ?\x7FE1) ;; <CJK>
     (?$(0LL(B . ?\x7FDF) ;; <CJK>
     (?$(0LM(B . ?\x805E) ;; <CJK>
     (?$(0LN(B . ?\x805A) ;; <CJK>
     (?$(0LO(B . ?\x8087) ;; <CJK>
     (?$(0LP(B . ?\x8150) ;; <CJK>
     (?$(0LQ(B . ?\x8180) ;; <CJK>
     (?$(0LR(B . ?\x818F) ;; <CJK>
     (?$(0LS(B . ?\x8188) ;; <CJK>
     (?$(0LT(B . ?\x818A) ;; <CJK>
     (?$(0LU(B . ?\x817F) ;; <CJK>
     (?$(0LV(B . ?\x8182) ;; <CJK>
     (?$(0LW(B . ?\x81E7) ;; <CJK>
     (?$(0LX(B . ?\x81FA) ;; <CJK>
     (?$(0LY(B . ?\x8207) ;; <CJK>
     (?$(0LZ(B . ?\x8214) ;; <CJK>
     (?$(0L[(B . ?\x821E) ;; <CJK>
     (?$(0L\(B . ?\x824B) ;; <CJK>
     (?$(0L](B . ?\x84C9) ;; <CJK>
     (?$(0L^(B . ?\x84BF) ;; <CJK>
     (?$(0L_(B . ?\x84C6) ;; <CJK>
     (?$(0L`(B . ?\x84C4) ;; <CJK>
     (?$(0La(B . ?\x8499) ;; <CJK>
     (?$(0Lb(B . ?\x849E) ;; <CJK>
     (?$(0Lc(B . ?\x84B2) ;; <CJK>
     (?$(0Ld(B . ?\x849C) ;; <CJK>
     (?$(0Le(B . ?\x84CB) ;; <CJK>
     (?$(0Lf(B . ?\x84B8) ;; <CJK>
     (?$(0Lg(B . ?\x84C0) ;; <CJK>
     (?$(0Lh(B . ?\x84D3) ;; <CJK>
     (?$(0Li(B . ?\x8490) ;; <CJK>
     (?$(0Lj(B . ?\x84BC) ;; <CJK>
     (?$(0Lk(B . ?\x84D1) ;; <CJK>
     (?$(0Ll(B . ?\x84CA) ;; <CJK>
     (?$(0Lm(B . ?\x873F) ;; <CJK>
     (?$(0Ln(B . ?\x871C) ;; <CJK>
     (?$(0Lo(B . ?\x873B) ;; <CJK>
     (?$(0Lp(B . ?\x8722) ;; <CJK>
     (?$(0Lq(B . ?\x8725) ;; <CJK>
     (?$(0Lr(B . ?\x8734) ;; <CJK>
     (?$(0Ls(B . ?\x8718) ;; <CJK>
     (?$(0Lt(B . ?\x8755) ;; <CJK>
     (?$(0Lu(B . ?\x8737) ;; <CJK>
     (?$(0Lv(B . ?\x8729) ;; <CJK>
     (?$(0Lw(B . ?\x88F3) ;; <CJK>
     (?$(0Lx(B . ?\x8902) ;; <CJK>
     (?$(0Ly(B . ?\x88F4) ;; <CJK>
     (?$(0Lz(B . ?\x88F9) ;; <CJK>
     (?$(0L{(B . ?\x88F8) ;; <CJK>
     (?$(0L|(B . ?\x88FD) ;; <CJK>
     (?$(0L}(B . ?\x88E8) ;; <CJK>
     (?$(0L~(B . ?\x891A) ;; <CJK>
     (?$(0M!(B . ?\x88EF) ;; <CJK>
     (?$(0M"(B . ?\x8AA6) ;; <CJK>
     (?$(0M#(B . ?\x8A8C) ;; <CJK>
     (?$(0M$(B . ?\x8A9E) ;; <CJK>
     (?$(0M%(B . ?\x8AA3) ;; <CJK>
     (?$(0M&(B . ?\x8A8D) ;; <CJK>
     (?$(0M'(B . ?\x8AA1) ;; <CJK>
     (?$(0M((B . ?\x8A93) ;; <CJK>
     (?$(0M)(B . ?\x8AA4) ;; <CJK>
     (?$(0M*(B . ?\x8AAA) ;; <CJK>
     (?$(0M+(B . ?\x8AA5) ;; <CJK>
     (?$(0M,(B . ?\x8AA8) ;; <CJK>
     (?$(0M-(B . ?\x8A98) ;; <CJK>
     (?$(0M.(B . ?\x8A91) ;; <CJK>
     (?$(0M/(B . ?\x8A9A) ;; <CJK>
     (?$(0M0(B . ?\x8AA7) ;; <CJK>
     (?$(0M1(B . ?\x8C6A) ;; <CJK>
     (?$(0M2(B . ?\x8C8D) ;; <CJK>
     (?$(0M3(B . ?\x8C8C) ;; <CJK>
     (?$(0M4(B . ?\x8CD3) ;; <CJK>
     (?$(0M5(B . ?\x8CD1) ;; <CJK>
     (?$(0M6(B . ?\x8CD2) ;; <CJK>
     (?$(0M7(B . ?\x8D6B) ;; <CJK>
     (?$(0M8(B . ?\x8D99) ;; <CJK>
     (?$(0M9(B . ?\x8D95) ;; <CJK>
     (?$(0M:(B . ?\x8DFC) ;; <CJK>
     (?$(0M;(B . ?\x8F14) ;; <CJK>
     (?$(0M<(B . ?\x8F12) ;; <CJK>
     (?$(0M=(B . ?\x8F15) ;; <CJK>
     (?$(0M>(B . ?\x8F13) ;; <CJK>
     (?$(0M?(B . ?\x8FA3) ;; <CJK>
     (?$(0M@(B . ?\x9060) ;; <CJK>
     (?$(0MA(B . ?\x9058) ;; <CJK>
     (?$(0MB(B . ?\x905C) ;; <CJK>
     (?$(0MC(B . ?\x9063) ;; <CJK>
     (?$(0MD(B . ?\x9059) ;; <CJK>
     (?$(0ME(B . ?\x905E) ;; <CJK>
     (?$(0MF(B . ?\x9062) ;; <CJK>
     (?$(0MG(B . ?\x905D) ;; <CJK>
     (?$(0MH(B . ?\x905B) ;; <CJK>
     (?$(0MI(B . ?\x9119) ;; <CJK>
     (?$(0MJ(B . ?\x9118) ;; <CJK>
     (?$(0MK(B . ?\x911E) ;; <CJK>
     (?$(0ML(B . ?\x9175) ;; <CJK>
     (?$(0MM(B . ?\x9178) ;; <CJK>
     (?$(0MN(B . ?\x9177) ;; <CJK>
     (?$(0MO(B . ?\x9174) ;; <CJK>
     (?$(0MP(B . ?\x9278) ;; <CJK>
     (?$(0MQ(B . ?\x9280) ;; <CJK>
     (?$(0MR(B . ?\x9285) ;; <CJK>
     (?$(0MS(B . ?\x9298) ;; <CJK>
     (?$(0MT(B . ?\x9296) ;; <CJK>
     (?$(0MU(B . ?\x927B) ;; <CJK>
     (?$(0MV(B . ?\x9293) ;; <CJK>
     (?$(0MW(B . ?\x929C) ;; <CJK>
     (?$(0MX(B . ?\x92A8) ;; <CJK>
     (?$(0MY(B . ?\x927C) ;; <CJK>
     (?$(0MZ(B . ?\x9291) ;; <CJK>
     (?$(0M[(B . ?\x95A1) ;; <CJK>
     (?$(0M\(B . ?\x95A8) ;; <CJK>
     (?$(0M](B . ?\x95A9) ;; <CJK>
     (?$(0M^(B . ?\x95A3) ;; <CJK>
     (?$(0M_(B . ?\x95A5) ;; <CJK>
     (?$(0M`(B . ?\x95A4) ;; <CJK>
     (?$(0Ma(B . ?\x9699) ;; <CJK>
     (?$(0Mb(B . ?\x969C) ;; <CJK>
     (?$(0Mc(B . ?\x969B) ;; <CJK>
     (?$(0Md(B . ?\x96CC) ;; <CJK>
     (?$(0Me(B . ?\x96D2) ;; <CJK>
     (?$(0Mf(B . ?\x9700) ;; <CJK>
     (?$(0Mg(B . ?\x977C) ;; <CJK>
     (?$(0Mh(B . ?\x9785) ;; <CJK>
     (?$(0Mi(B . ?\x97F6) ;; <CJK>
     (?$(0Mj(B . ?\x9817) ;; <CJK>
     (?$(0Mk(B . ?\x9818) ;; <CJK>
     (?$(0Ml(B . ?\x98AF) ;; <CJK>
     (?$(0Mm(B . ?\x98B1) ;; <CJK>
     (?$(0Mn(B . ?\x9903) ;; <CJK>
     (?$(0Mo(B . ?\x9905) ;; <CJK>
     (?$(0Mp(B . ?\x990C) ;; <CJK>
     (?$(0Mq(B . ?\x9909) ;; <CJK>
     (?$(0Mr(B . ?\x99C1) ;; <CJK>
     (?$(0Ms(B . ?\x9AAF) ;; <CJK>
     (?$(0Mt(B . ?\x9AB0) ;; <CJK>
     (?$(0Mu(B . ?\x9AE6) ;; <CJK>
     (?$(0Mv(B . ?\x9B41) ;; <CJK>
     (?$(0Mw(B . ?\x9B42) ;; <CJK>
     (?$(0Mx(B . ?\x9CF4) ;; <CJK>
     (?$(0My(B . ?\x9CF6) ;; <CJK>
     (?$(0Mz(B . ?\x9CF3) ;; <CJK>
     (?$(0M{(B . ?\x9EBC) ;; <CJK>
     (?$(0M|(B . ?\x9F3B) ;; <CJK>
     (?$(0M}(B . ?\x9F4A) ;; <CJK>
     (?$(0M~(B . ?\x5104) ;; <CJK>
     (?$(0N!(B . ?\x5100) ;; <CJK>
     (?$(0N"(B . ?\x50FB) ;; <CJK>
     (?$(0N#(B . ?\x50F5) ;; <CJK>
     (?$(0N$(B . ?\x50F9) ;; <CJK>
     (?$(0N%(B . ?\x5102) ;; <CJK>
     (?$(0N&(B . ?\x5108) ;; <CJK>
     (?$(0N'(B . ?\x5109) ;; <CJK>
     (?$(0N((B . ?\x5105) ;; <CJK>
     (?$(0N)(B . ?\x51DC) ;; <CJK>
     (?$(0N*(B . ?\x5287) ;; <CJK>
     (?$(0N+(B . ?\x5288) ;; <CJK>
     (?$(0N,(B . ?\x5289) ;; <CJK>
     (?$(0N-(B . ?\x528D) ;; <CJK>
     (?$(0N.(B . ?\x528A) ;; <CJK>
     (?$(0N/(B . ?\x52F0) ;; <CJK>
     (?$(0N0(B . ?\x53B2) ;; <CJK>
     (?$(0N1(B . ?\x562E) ;; <CJK>
     (?$(0N2(B . ?\x563B) ;; <CJK>
     (?$(0N3(B . ?\x5639) ;; <CJK>
     (?$(0N4(B . ?\x5632) ;; <CJK>
     (?$(0N5(B . ?\x563F) ;; <CJK>
     (?$(0N6(B . ?\x5634) ;; <CJK>
     (?$(0N7(B . ?\x5629) ;; <CJK>
     (?$(0N8(B . ?\x5653) ;; <CJK>
     (?$(0N9(B . ?\x564E) ;; <CJK>
     (?$(0N:(B . ?\x5657) ;; <CJK>
     (?$(0N;(B . ?\x5674) ;; <CJK>
     (?$(0N<(B . ?\x5636) ;; <CJK>
     (?$(0N=(B . ?\x562F) ;; <CJK>
     (?$(0N>(B . ?\x5630) ;; <CJK>
     (?$(0N?(B . ?\x5880) ;; <CJK>
     (?$(0N@(B . ?\x589F) ;; <CJK>
     (?$(0NA(B . ?\x589E) ;; <CJK>
     (?$(0NB(B . ?\x58B3) ;; <CJK>
     (?$(0NC(B . ?\x589C) ;; <CJK>
     (?$(0ND(B . ?\x58AE) ;; <CJK>
     (?$(0NE(B . ?\x58A9) ;; <CJK>
     (?$(0NF(B . ?\x58A6) ;; <CJK>
     (?$(0NG(B . ?\x596D) ;; <CJK>
     (?$(0NH(B . ?\x5B09) ;; <CJK>
     (?$(0NI(B . ?\x5AFB) ;; <CJK>
     (?$(0NJ(B . ?\x5B0B) ;; <CJK>
     (?$(0NK(B . ?\x5AF5) ;; <CJK>
     (?$(0NL(B . ?\x5B0C) ;; <CJK>
     (?$(0NM(B . ?\x5B08) ;; <CJK>
     (?$(0NN(B . ?\x5BEE) ;; <CJK>
     (?$(0NO(B . ?\x5BEC) ;; <CJK>
     (?$(0NP(B . ?\x5BE9) ;; <CJK>
     (?$(0NQ(B . ?\x5BEB) ;; <CJK>
     (?$(0NR(B . ?\x5C64) ;; <CJK>
     (?$(0NS(B . ?\x5C65) ;; <CJK>
     (?$(0NT(B . ?\x5D9D) ;; <CJK>
     (?$(0NU(B . ?\x5D94) ;; <CJK>
     (?$(0NV(B . ?\x5E62) ;; <CJK>
     (?$(0NW(B . ?\x5E5F) ;; <CJK>
     (?$(0NX(B . ?\x5E61) ;; <CJK>
     (?$(0NY(B . ?\x5EE2) ;; <CJK>
     (?$(0NZ(B . ?\x5EDA) ;; <CJK>
     (?$(0N[(B . ?\x5EDF) ;; <CJK>
     (?$(0N\(B . ?\x5EDD) ;; <CJK>
     (?$(0N](B . ?\x5EE3) ;; <CJK>
     (?$(0N^(B . ?\x5EE0) ;; <CJK>
     (?$(0N_(B . ?\x5F48) ;; <CJK>
     (?$(0N`(B . ?\x5F71) ;; <CJK>
     (?$(0Na(B . ?\x5FB7) ;; <CJK>
     (?$(0Nb(B . ?\x5FB5) ;; <CJK>
     (?$(0Nc(B . ?\x6176) ;; <CJK>
     (?$(0Nd(B . ?\x6167) ;; <CJK>
     (?$(0Ne(B . ?\x616E) ;; <CJK>
     (?$(0Nf(B . ?\x615D) ;; <CJK>
     (?$(0Ng(B . ?\x6155) ;; <CJK>
     (?$(0Nh(B . ?\x6182) ;; <CJK>
     (?$(0Ni(B . ?\x617C) ;; <CJK>
     (?$(0Nj(B . ?\x6170) ;; <CJK>
     (?$(0Nk(B . ?\x616B) ;; <CJK>
     (?$(0Nl(B . ?\x617E) ;; <CJK>
     (?$(0Nm(B . ?\x61A7) ;; <CJK>
     (?$(0Nn(B . ?\x6190) ;; <CJK>
     (?$(0No(B . ?\x61AB) ;; <CJK>
     (?$(0Np(B . ?\x618E) ;; <CJK>
     (?$(0Nq(B . ?\x61AC) ;; <CJK>
     (?$(0Nr(B . ?\x619A) ;; <CJK>
     (?$(0Ns(B . ?\x61A4) ;; <CJK>
     (?$(0Nt(B . ?\x6194) ;; <CJK>
     (?$(0Nu(B . ?\x61AE) ;; <CJK>
     (?$(0Nv(B . ?\x622E) ;; <CJK>
     (?$(0Nw(B . ?\x6469) ;; <CJK>
     (?$(0Nx(B . ?\x646F) ;; <CJK>
     (?$(0Ny(B . ?\x6479) ;; <CJK>
     (?$(0Nz(B . ?\x649E) ;; <CJK>
     (?$(0N{(B . ?\x64B2) ;; <CJK>
     (?$(0N|(B . ?\x6488) ;; <CJK>
     (?$(0N}(B . ?\x6490) ;; <CJK>
     (?$(0N~(B . ?\x64B0) ;; <CJK>
     (?$(0O!(B . ?\x64A5) ;; <CJK>
     (?$(0O"(B . ?\x6493) ;; <CJK>
     (?$(0O#(B . ?\x6495) ;; <CJK>
     (?$(0O$(B . ?\x64A9) ;; <CJK>
     (?$(0O%(B . ?\x6492) ;; <CJK>
     (?$(0O&(B . ?\x64AE) ;; <CJK>
     (?$(0O'(B . ?\x64AD) ;; <CJK>
     (?$(0O((B . ?\x64AB) ;; <CJK>
     (?$(0O)(B . ?\x649A) ;; <CJK>
     (?$(0O*(B . ?\x64AC) ;; <CJK>
     (?$(0O+(B . ?\x6499) ;; <CJK>
     (?$(0O,(B . ?\x64A2) ;; <CJK>
     (?$(0O-(B . ?\x64B3) ;; <CJK>
     (?$(0O.(B . ?\x6575) ;; <CJK>
     (?$(0O/(B . ?\x6577) ;; <CJK>
     (?$(0O0(B . ?\x6578) ;; <CJK>
     (?$(0O1(B . ?\x66AE) ;; <CJK>
     (?$(0O2(B . ?\x66AB) ;; <CJK>
     (?$(0O3(B . ?\x66B4) ;; <CJK>
     (?$(0O4(B . ?\x66B1) ;; <CJK>
     (?$(0O5(B . ?\x6A23) ;; <CJK>
     (?$(0O6(B . ?\x6A1F) ;; <CJK>
     (?$(0O7(B . ?\x69E8) ;; <CJK>
     (?$(0O8(B . ?\x6A01) ;; <CJK>
     (?$(0O9(B . ?\x6A1E) ;; <CJK>
     (?$(0O:(B . ?\x6A19) ;; <CJK>
     (?$(0O;(B . ?\x69FD) ;; <CJK>
     (?$(0O<(B . ?\x6A21) ;; <CJK>
     (?$(0O=(B . ?\x6A13) ;; <CJK>
     (?$(0O>(B . ?\x6A0A) ;; <CJK>
     (?$(0O?(B . ?\x69F3) ;; <CJK>
     (?$(0O@(B . ?\x6A02) ;; <CJK>
     (?$(0OA(B . ?\x6A05) ;; <CJK>
     (?$(0OB(B . ?\x69ED) ;; <CJK>
     (?$(0OC(B . ?\x6A11) ;; <CJK>
     (?$(0OD(B . ?\x6B50) ;; <CJK>
     (?$(0OE(B . ?\x6B4E) ;; <CJK>
     (?$(0OF(B . ?\x6BA4) ;; <CJK>
     (?$(0OG(B . ?\x6BC5) ;; <CJK>
     (?$(0OH(B . ?\x6BC6) ;; <CJK>
     (?$(0OI(B . ?\x6F3F) ;; <CJK>
     (?$(0OJ(B . ?\x6F7C) ;; <CJK>
     (?$(0OK(B . ?\x6F84) ;; <CJK>
     (?$(0OL(B . ?\x6F51) ;; <CJK>
     (?$(0OM(B . ?\x6F66) ;; <CJK>
     (?$(0ON(B . ?\x6F54) ;; <CJK>
     (?$(0OO(B . ?\x6F86) ;; <CJK>
     (?$(0OP(B . ?\x6F6D) ;; <CJK>
     (?$(0OQ(B . ?\x6F5B) ;; <CJK>
     (?$(0OR(B . ?\x6F78) ;; <CJK>
     (?$(0OS(B . ?\x6F6E) ;; <CJK>
     (?$(0OT(B . ?\x6F8E) ;; <CJK>
     (?$(0OU(B . ?\x6F7A) ;; <CJK>
     (?$(0OV(B . ?\x6F70) ;; <CJK>
     (?$(0OW(B . ?\x6F64) ;; <CJK>
     (?$(0OX(B . ?\x6F97) ;; <CJK>
     (?$(0OY(B . ?\x6F58) ;; <CJK>
     (?$(0OZ(B . ?\x6ED5) ;; <CJK>
     (?$(0O[(B . ?\x6F6F) ;; <CJK>
     (?$(0O\(B . ?\x6F60) ;; <CJK>
     (?$(0O](B . ?\x6F5F) ;; <CJK>
     (?$(0O^(B . ?\x719F) ;; <CJK>
     (?$(0O_(B . ?\x71AC) ;; <CJK>
     (?$(0O`(B . ?\x71B1) ;; <CJK>
     (?$(0Oa(B . ?\x71A8) ;; <CJK>
     (?$(0Ob(B . ?\x7256) ;; <CJK>
     (?$(0Oc(B . ?\x729B) ;; <CJK>
     (?$(0Od(B . ?\x734E) ;; <CJK>
     (?$(0Oe(B . ?\x7357) ;; <CJK>
     (?$(0Of(B . ?\x7469) ;; <CJK>
     (?$(0Og(B . ?\x748B) ;; <CJK>
     (?$(0Oh(B . ?\x7483) ;; <CJK>
     (?$(0Oi(B . ?\x747E) ;; <CJK>
     (?$(0Oj(B . ?\x7480) ;; <CJK>
     (?$(0Ok(B . ?\x757F) ;; <CJK>
     (?$(0Ol(B . ?\x7620) ;; <CJK>
     (?$(0Om(B . ?\x7629) ;; <CJK>
     (?$(0On(B . ?\x761F) ;; <CJK>
     (?$(0Oo(B . ?\x7624) ;; <CJK>
     (?$(0Op(B . ?\x7626) ;; <CJK>
     (?$(0Oq(B . ?\x7621) ;; <CJK>
     (?$(0Or(B . ?\x7622) ;; <CJK>
     (?$(0Os(B . ?\x769A) ;; <CJK>
     (?$(0Ot(B . ?\x76BA) ;; <CJK>
     (?$(0Ou(B . ?\x76E4) ;; <CJK>
     (?$(0Ov(B . ?\x778E) ;; <CJK>
     (?$(0Ow(B . ?\x7787) ;; <CJK>
     (?$(0Ox(B . ?\x778C) ;; <CJK>
     (?$(0Oy(B . ?\x7791) ;; <CJK>
     (?$(0Oz(B . ?\x778B) ;; <CJK>
     (?$(0O{(B . ?\x78CB) ;; <CJK>
     (?$(0O|(B . ?\x78C5) ;; <CJK>
     (?$(0O}(B . ?\x78BA) ;; <CJK>
     (?$(0O~(B . ?\x78CA) ;; <CJK>
     (?$(0P!(B . ?\x78BE) ;; <CJK>
     (?$(0P"(B . ?\x78D5) ;; <CJK>
     (?$(0P#(B . ?\x78BC) ;; <CJK>
     (?$(0P$(B . ?\x78D0) ;; <CJK>
     (?$(0P%(B . ?\x7A3F) ;; <CJK>
     (?$(0P&(B . ?\x7A3C) ;; <CJK>
     (?$(0P'(B . ?\x7A40) ;; <CJK>
     (?$(0P((B . ?\x7A3D) ;; <CJK>
     (?$(0P)(B . ?\x7A37) ;; <CJK>
     (?$(0P*(B . ?\x7A3B) ;; <CJK>
     (?$(0P+(B . ?\x7AAF) ;; <CJK>
     (?$(0P,(B . ?\x7AAE) ;; <CJK>
     (?$(0P-(B . ?\x7BAD) ;; <CJK>
     (?$(0P.(B . ?\x7BB1) ;; <CJK>
     (?$(0P/(B . ?\x7BC4) ;; <CJK>
     (?$(0P0(B . ?\x7BB4) ;; <CJK>
     (?$(0P1(B . ?\x7BC6) ;; <CJK>
     (?$(0P2(B . ?\x7BC7) ;; <CJK>
     (?$(0P3(B . ?\x7BC1) ;; <CJK>
     (?$(0P4(B . ?\x7BA0) ;; <CJK>
     (?$(0P5(B . ?\x7BCC) ;; <CJK>
     (?$(0P6(B . ?\x7CCA) ;; <CJK>
     (?$(0P7(B . ?\x7DE0) ;; <CJK>
     (?$(0P8(B . ?\x7DF4) ;; <CJK>
     (?$(0P9(B . ?\x7DEF) ;; <CJK>
     (?$(0P:(B . ?\x7DFB) ;; <CJK>
     (?$(0P;(B . ?\x7DD8) ;; <CJK>
     (?$(0P<(B . ?\x7DEC) ;; <CJK>
     (?$(0P=(B . ?\x7DDD) ;; <CJK>
     (?$(0P>(B . ?\x7DE8) ;; <CJK>
     (?$(0P?(B . ?\x7DE3) ;; <CJK>
     (?$(0P@(B . ?\x7DDA) ;; <CJK>
     (?$(0PA(B . ?\x7DDE) ;; <CJK>
     (?$(0PB(B . ?\x7DE9) ;; <CJK>
     (?$(0PC(B . ?\x7D9E) ;; <CJK>
     (?$(0PD(B . ?\x7DD9) ;; <CJK>
     (?$(0PE(B . ?\x7DF2) ;; <CJK>
     (?$(0PF(B . ?\x7DF9) ;; <CJK>
     (?$(0PG(B . ?\x7F75) ;; <CJK>
     (?$(0PH(B . ?\x7F77) ;; <CJK>
     (?$(0PI(B . ?\x7FAF) ;; <CJK>
     (?$(0PJ(B . ?\x7FE9) ;; <CJK>
     (?$(0PK(B . ?\x8026) ;; <CJK>
     (?$(0PL(B . ?\x819B) ;; <CJK>
     (?$(0PM(B . ?\x819C) ;; <CJK>
     (?$(0PN(B . ?\x819D) ;; <CJK>
     (?$(0PO(B . ?\x81A0) ;; <CJK>
     (?$(0PP(B . ?\x819A) ;; <CJK>
     (?$(0PQ(B . ?\x8198) ;; <CJK>
     (?$(0PR(B . ?\x8517) ;; <CJK>
     (?$(0PS(B . ?\x853D) ;; <CJK>
     (?$(0PT(B . ?\x851A) ;; <CJK>
     (?$(0PU(B . ?\x84EE) ;; <CJK>
     (?$(0PV(B . ?\x852C) ;; <CJK>
     (?$(0PW(B . ?\x852D) ;; <CJK>
     (?$(0PX(B . ?\x8513) ;; <CJK>
     (?$(0PY(B . ?\x8511) ;; <CJK>
     (?$(0PZ(B . ?\x8523) ;; <CJK>
     (?$(0P[(B . ?\x8521) ;; <CJK>
     (?$(0P\(B . ?\x8514) ;; <CJK>
     (?$(0P](B . ?\x84EC) ;; <CJK>
     (?$(0P^(B . ?\x8525) ;; <CJK>
     (?$(0P_(B . ?\x84FF) ;; <CJK>
     (?$(0P`(B . ?\x8506) ;; <CJK>
     (?$(0Pa(B . ?\x8782) ;; <CJK>
     (?$(0Pb(B . ?\x8774) ;; <CJK>
     (?$(0Pc(B . ?\x8776) ;; <CJK>
     (?$(0Pd(B . ?\x8760) ;; <CJK>
     (?$(0Pe(B . ?\x8766) ;; <CJK>
     (?$(0Pf(B . ?\x8778) ;; <CJK>
     (?$(0Pg(B . ?\x8768) ;; <CJK>
     (?$(0Ph(B . ?\x8759) ;; <CJK>
     (?$(0Pi(B . ?\x8757) ;; <CJK>
     (?$(0Pj(B . ?\x874C) ;; <CJK>
     (?$(0Pk(B . ?\x8753) ;; <CJK>
     (?$(0Pl(B . ?\x885B) ;; <CJK>
     (?$(0Pm(B . ?\x885D) ;; <CJK>
     (?$(0Pn(B . ?\x8910) ;; <CJK>
     (?$(0Po(B . ?\x8907) ;; <CJK>
     (?$(0Pp(B . ?\x8912) ;; <CJK>
     (?$(0Pq(B . ?\x8913) ;; <CJK>
     (?$(0Pr(B . ?\x8915) ;; <CJK>
     (?$(0Ps(B . ?\x890A) ;; <CJK>
     (?$(0Pt(B . ?\x8ABC) ;; <CJK>
     (?$(0Pu(B . ?\x8AD2) ;; <CJK>
     (?$(0Pv(B . ?\x8AC7) ;; <CJK>
     (?$(0Pw(B . ?\x8AC4) ;; <CJK>
     (?$(0Px(B . ?\x8A95) ;; <CJK>
     (?$(0Py(B . ?\x8ACB) ;; <CJK>
     (?$(0Pz(B . ?\x8AF8) ;; <CJK>
     (?$(0P{(B . ?\x8AB2) ;; <CJK>
     (?$(0P|(B . ?\x8AC9) ;; <CJK>
     (?$(0P}(B . ?\x8AC2) ;; <CJK>
     (?$(0P~(B . ?\x8ABF) ;; <CJK>
     (?$(0Q!(B . ?\x8AB0) ;; <CJK>
     (?$(0Q"(B . ?\x8AD6) ;; <CJK>
     (?$(0Q#(B . ?\x8ACD) ;; <CJK>
     (?$(0Q$(B . ?\x8AB6) ;; <CJK>
     (?$(0Q%(B . ?\x8AB9) ;; <CJK>
     (?$(0Q&(B . ?\x8ADB) ;; <CJK>
     (?$(0Q'(B . ?\x8C4C) ;; <CJK>
     (?$(0Q((B . ?\x8C4E) ;; <CJK>
     (?$(0Q)(B . ?\x8C6C) ;; <CJK>
     (?$(0Q*(B . ?\x8CE0) ;; <CJK>
     (?$(0Q+(B . ?\x8CDE) ;; <CJK>
     (?$(0Q,(B . ?\x8CE6) ;; <CJK>
     (?$(0Q-(B . ?\x8CE4) ;; <CJK>
     (?$(0Q.(B . ?\x8CEC) ;; <CJK>
     (?$(0Q/(B . ?\x8CED) ;; <CJK>
     (?$(0Q0(B . ?\x8CE2) ;; <CJK>
     (?$(0Q1(B . ?\x8CE3) ;; <CJK>
     (?$(0Q2(B . ?\x8CDC) ;; <CJK>
     (?$(0Q3(B . ?\x8CEA) ;; <CJK>
     (?$(0Q4(B . ?\x8CE1) ;; <CJK>
     (?$(0Q5(B . ?\x8D6D) ;; <CJK>
     (?$(0Q6(B . ?\x8D9F) ;; <CJK>
     (?$(0Q7(B . ?\x8DA3) ;; <CJK>
     (?$(0Q8(B . ?\x8E2B) ;; <CJK>
     (?$(0Q9(B . ?\x8E10) ;; <CJK>
     (?$(0Q:(B . ?\x8E1D) ;; <CJK>
     (?$(0Q;(B . ?\x8E22) ;; <CJK>
     (?$(0Q<(B . ?\x8E0F) ;; <CJK>
     (?$(0Q=(B . ?\x8E29) ;; <CJK>
     (?$(0Q>(B . ?\x8E1F) ;; <CJK>
     (?$(0Q?(B . ?\x8E21) ;; <CJK>
     (?$(0Q@(B . ?\x8E1E) ;; <CJK>
     (?$(0QA(B . ?\x8EBA) ;; <CJK>
     (?$(0QB(B . ?\x8F1D) ;; <CJK>
     (?$(0QC(B . ?\x8F1B) ;; <CJK>
     (?$(0QD(B . ?\x8F1F) ;; <CJK>
     (?$(0QE(B . ?\x8F29) ;; <CJK>
     (?$(0QF(B . ?\x8F26) ;; <CJK>
     (?$(0QG(B . ?\x8F2A) ;; <CJK>
     (?$(0QH(B . ?\x8F1C) ;; <CJK>
     (?$(0QI(B . ?\x8F1E) ;; <CJK>
     (?$(0QJ(B . ?\x8F25) ;; <CJK>
     (?$(0QK(B . ?\x9069) ;; <CJK>
     (?$(0QL(B . ?\x906E) ;; <CJK>
     (?$(0QM(B . ?\x9068) ;; <CJK>
     (?$(0QN(B . ?\x906D) ;; <CJK>
     (?$(0QO(B . ?\x9077) ;; <CJK>
     (?$(0QP(B . ?\x9130) ;; <CJK>
     (?$(0QQ(B . ?\x912D) ;; <CJK>
     (?$(0QR(B . ?\x9127) ;; <CJK>
     (?$(0QS(B . ?\x9131) ;; <CJK>
     (?$(0QT(B . ?\x9187) ;; <CJK>
     (?$(0QU(B . ?\x9189) ;; <CJK>
     (?$(0QV(B . ?\x918B) ;; <CJK>
     (?$(0QW(B . ?\x9183) ;; <CJK>
     (?$(0QX(B . ?\x92C5) ;; <CJK>
     (?$(0QY(B . ?\x92BB) ;; <CJK>
     (?$(0QZ(B . ?\x92B7) ;; <CJK>
     (?$(0Q[(B . ?\x92EA) ;; <CJK>
     (?$(0Q\(B . ?\x92AC) ;; <CJK>
     (?$(0Q](B . ?\x92E4) ;; <CJK>
     (?$(0Q^(B . ?\x92C1) ;; <CJK>
     (?$(0Q_(B . ?\x92B3) ;; <CJK>
     (?$(0Q`(B . ?\x92BC) ;; <CJK>
     (?$(0Qa(B . ?\x92D2) ;; <CJK>
     (?$(0Qb(B . ?\x92C7) ;; <CJK>
     (?$(0Qc(B . ?\x92F0) ;; <CJK>
     (?$(0Qd(B . ?\x92B2) ;; <CJK>
     (?$(0Qe(B . ?\x95AD) ;; <CJK>
     (?$(0Qf(B . ?\x95B1) ;; <CJK>
     (?$(0Qg(B . ?\x9704) ;; <CJK>
     (?$(0Qh(B . ?\x9706) ;; <CJK>
     (?$(0Qi(B . ?\x9707) ;; <CJK>
     (?$(0Qj(B . ?\x9709) ;; <CJK>
     (?$(0Qk(B . ?\x9760) ;; <CJK>
     (?$(0Ql(B . ?\x978D) ;; <CJK>
     (?$(0Qm(B . ?\x978B) ;; <CJK>
     (?$(0Qn(B . ?\x978F) ;; <CJK>
     (?$(0Qo(B . ?\x9821) ;; <CJK>
     (?$(0Qp(B . ?\x982B) ;; <CJK>
     (?$(0Qq(B . ?\x981C) ;; <CJK>
     (?$(0Qr(B . ?\x98B3) ;; <CJK>
     (?$(0Qs(B . ?\x990A) ;; <CJK>
     (?$(0Qt(B . ?\x9913) ;; <CJK>
     (?$(0Qu(B . ?\x9912) ;; <CJK>
     (?$(0Qv(B . ?\x9918) ;; <CJK>
     (?$(0Qw(B . ?\x99DD) ;; <CJK>
     (?$(0Qx(B . ?\x99D0) ;; <CJK>
     (?$(0Qy(B . ?\x99DF) ;; <CJK>
     (?$(0Qz(B . ?\x99DB) ;; <CJK>
     (?$(0Q{(B . ?\x99D1) ;; <CJK>
     (?$(0Q|(B . ?\x99D5) ;; <CJK>
     (?$(0Q}(B . ?\x99D2) ;; <CJK>
     (?$(0Q~(B . ?\x99D9) ;; <CJK>
     (?$(0R!(B . ?\x9AB7) ;; <CJK>
     (?$(0R"(B . ?\x9AEE) ;; <CJK>
     (?$(0R#(B . ?\x9AEF) ;; <CJK>
     (?$(0R$(B . ?\x9B27) ;; <CJK>
     (?$(0R%(B . ?\x9B45) ;; <CJK>
     (?$(0R&(B . ?\x9B44) ;; <CJK>
     (?$(0R'(B . ?\x9B77) ;; <CJK>
     (?$(0R((B . ?\x9B6F) ;; <CJK>
     (?$(0R)(B . ?\x9D06) ;; <CJK>
     (?$(0R*(B . ?\x9D09) ;; <CJK>
     (?$(0R+(B . ?\x9D03) ;; <CJK>
     (?$(0R,(B . ?\x9EA9) ;; <CJK>
     (?$(0R-(B . ?\x9EBE) ;; <CJK>
     (?$(0R.(B . ?\x9ECE) ;; <CJK>
     (?$(0R/(B . ?\x58A8) ;; <CJK>
     (?$(0R0(B . ?\x9F52) ;; <CJK>
     (?$(0R1(B . ?\x5112) ;; <CJK>
     (?$(0R2(B . ?\x5118) ;; <CJK>
     (?$(0R3(B . ?\x5114) ;; <CJK>
     (?$(0R4(B . ?\x5110) ;; <CJK>
     (?$(0R5(B . ?\x5115) ;; <CJK>
     (?$(0R6(B . ?\x5180) ;; <CJK>
     (?$(0R7(B . ?\x51AA) ;; <CJK>
     (?$(0R8(B . ?\x51DD) ;; <CJK>
     (?$(0R9(B . ?\x5291) ;; <CJK>
     (?$(0R:(B . ?\x5293) ;; <CJK>
     (?$(0R;(B . ?\x52F3) ;; <CJK>
     (?$(0R<(B . ?\x5659) ;; <CJK>
     (?$(0R=(B . ?\x566B) ;; <CJK>
     (?$(0R>(B . ?\x5679) ;; <CJK>
     (?$(0R?(B . ?\x5669) ;; <CJK>
     (?$(0R@(B . ?\x5664) ;; <CJK>
     (?$(0RA(B . ?\x5678) ;; <CJK>
     (?$(0RB(B . ?\x566A) ;; <CJK>
     (?$(0RC(B . ?\x5668) ;; <CJK>
     (?$(0RD(B . ?\x5665) ;; <CJK>
     (?$(0RE(B . ?\x5671) ;; <CJK>
     (?$(0RF(B . ?\x566F) ;; <CJK>
     (?$(0RG(B . ?\x566C) ;; <CJK>
     (?$(0RH(B . ?\x5662) ;; <CJK>
     (?$(0RI(B . ?\x5676) ;; <CJK>
     (?$(0RJ(B . ?\x58C1) ;; <CJK>
     (?$(0RK(B . ?\x58BE) ;; <CJK>
     (?$(0RL(B . ?\x58C7) ;; <CJK>
     (?$(0RM(B . ?\x58C5) ;; <CJK>
     (?$(0RN(B . ?\x596E) ;; <CJK>
     (?$(0RO(B . ?\x5B1D) ;; <CJK>
     (?$(0RP(B . ?\x5B34) ;; <CJK>
     (?$(0RQ(B . ?\x5B78) ;; <CJK>
     (?$(0RR(B . ?\x5BF0) ;; <CJK>
     (?$(0RS(B . ?\x5C0E) ;; <CJK>
     (?$(0RT(B . ?\x5F4A) ;; <CJK>
     (?$(0RU(B . ?\x61B2) ;; <CJK>
     (?$(0RV(B . ?\x6191) ;; <CJK>
     (?$(0RW(B . ?\x61A9) ;; <CJK>
     (?$(0RX(B . ?\x618A) ;; <CJK>
     (?$(0RY(B . ?\x61CD) ;; <CJK>
     (?$(0RZ(B . ?\x61B6) ;; <CJK>
     (?$(0R[(B . ?\x61BE) ;; <CJK>
     (?$(0R\(B . ?\x61CA) ;; <CJK>
     (?$(0R](B . ?\x61C8) ;; <CJK>
     (?$(0R^(B . ?\x6230) ;; <CJK>
     (?$(0R_(B . ?\x64C5) ;; <CJK>
     (?$(0R`(B . ?\x64C1) ;; <CJK>
     (?$(0Ra(B . ?\x64CB) ;; <CJK>
     (?$(0Rb(B . ?\x64BB) ;; <CJK>
     (?$(0Rc(B . ?\x64BC) ;; <CJK>
     (?$(0Rd(B . ?\x64DA) ;; <CJK>
     (?$(0Re(B . ?\x64C4) ;; <CJK>
     (?$(0Rf(B . ?\x64C7) ;; <CJK>
     (?$(0Rg(B . ?\x64C2) ;; <CJK>
     (?$(0Rh(B . ?\x64CD) ;; <CJK>
     (?$(0Ri(B . ?\x64BF) ;; <CJK>
     (?$(0Rj(B . ?\x64D2) ;; <CJK>
     (?$(0Rk(B . ?\x64D4) ;; <CJK>
     (?$(0Rl(B . ?\x64BE) ;; <CJK>
     (?$(0Rm(B . ?\x6574) ;; <CJK>
     (?$(0Rn(B . ?\x66C6) ;; <CJK>
     (?$(0Ro(B . ?\x66C9) ;; <CJK>
     (?$(0Rp(B . ?\x66B9) ;; <CJK>
     (?$(0Rq(B . ?\x66C4) ;; <CJK>
     (?$(0Rr(B . ?\x66C7) ;; <CJK>
     (?$(0Rs(B . ?\x66B8) ;; <CJK>
     (?$(0Rt(B . ?\x6A3D) ;; <CJK>
     (?$(0Ru(B . ?\x6A38) ;; <CJK>
     (?$(0Rv(B . ?\x6A3A) ;; <CJK>
     (?$(0Rw(B . ?\x6A59) ;; <CJK>
     (?$(0Rx(B . ?\x6A6B) ;; <CJK>
     (?$(0Ry(B . ?\x6A58) ;; <CJK>
     (?$(0Rz(B . ?\x6A39) ;; <CJK>
     (?$(0R{(B . ?\x6A44) ;; <CJK>
     (?$(0R|(B . ?\x6A62) ;; <CJK>
     (?$(0R}(B . ?\x6A61) ;; <CJK>
     (?$(0R~(B . ?\x6A4B) ;; <CJK>
     (?$(0S!(B . ?\x6A47) ;; <CJK>
     (?$(0S"(B . ?\x6A35) ;; <CJK>
     (?$(0S#(B . ?\x6A5F) ;; <CJK>
     (?$(0S$(B . ?\x6A48) ;; <CJK>
     (?$(0S%(B . ?\x6B59) ;; <CJK>
     (?$(0S&(B . ?\x6B77) ;; <CJK>
     (?$(0S'(B . ?\x6C05) ;; <CJK>
     (?$(0S((B . ?\x6FC2) ;; <CJK>
     (?$(0S)(B . ?\x6FB1) ;; <CJK>
     (?$(0S*(B . ?\x6FA1) ;; <CJK>
     (?$(0S+(B . ?\x6FC3) ;; <CJK>
     (?$(0S,(B . ?\x6FA4) ;; <CJK>
     (?$(0S-(B . ?\x6FC1) ;; <CJK>
     (?$(0S.(B . ?\x6FA7) ;; <CJK>
     (?$(0S/(B . ?\x6FB3) ;; <CJK>
     (?$(0S0(B . ?\x6FC0) ;; <CJK>
     (?$(0S1(B . ?\x6FB9) ;; <CJK>
     (?$(0S2(B . ?\x6FB6) ;; <CJK>
     (?$(0S3(B . ?\x6FA6) ;; <CJK>
     (?$(0S4(B . ?\x6FA0) ;; <CJK>
     (?$(0S5(B . ?\x6FB4) ;; <CJK>
     (?$(0S6(B . ?\x71BE) ;; <CJK>
     (?$(0S7(B . ?\x71C9) ;; <CJK>
     (?$(0S8(B . ?\x71D0) ;; <CJK>
     (?$(0S9(B . ?\x71D2) ;; <CJK>
     (?$(0S:(B . ?\x71C8) ;; <CJK>
     (?$(0S;(B . ?\x71D5) ;; <CJK>
     (?$(0S<(B . ?\x71B9) ;; <CJK>
     (?$(0S=(B . ?\x71CE) ;; <CJK>
     (?$(0S>(B . ?\x71D9) ;; <CJK>
     (?$(0S?(B . ?\x71DC) ;; <CJK>
     (?$(0S@(B . ?\x71C3) ;; <CJK>
     (?$(0SA(B . ?\x71C4) ;; <CJK>
     (?$(0SB(B . ?\x7368) ;; <CJK>
     (?$(0SC(B . ?\x749C) ;; <CJK>
     (?$(0SD(B . ?\x74A3) ;; <CJK>
     (?$(0SE(B . ?\x7498) ;; <CJK>
     (?$(0SF(B . ?\x749F) ;; <CJK>
     (?$(0SG(B . ?\x749E) ;; <CJK>
     (?$(0SH(B . ?\x74E2) ;; <CJK>
     (?$(0SI(B . ?\x750C) ;; <CJK>
     (?$(0SJ(B . ?\x750D) ;; <CJK>
     (?$(0SK(B . ?\x7634) ;; <CJK>
     (?$(0SL(B . ?\x7638) ;; <CJK>
     (?$(0SM(B . ?\x763A) ;; <CJK>
     (?$(0SN(B . ?\x76E7) ;; <CJK>
     (?$(0SO(B . ?\x76E5) ;; <CJK>
     (?$(0SP(B . ?\x77A0) ;; <CJK>
     (?$(0SQ(B . ?\x779E) ;; <CJK>
     (?$(0SR(B . ?\x779F) ;; <CJK>
     (?$(0SS(B . ?\x77A5) ;; <CJK>
     (?$(0ST(B . ?\x78E8) ;; <CJK>
     (?$(0SU(B . ?\x78DA) ;; <CJK>
     (?$(0SV(B . ?\x78EC) ;; <CJK>
     (?$(0SW(B . ?\x78E7) ;; <CJK>
     (?$(0SX(B . ?\x79A6) ;; <CJK>
     (?$(0SY(B . ?\x7A4D) ;; <CJK>
     (?$(0SZ(B . ?\x7A4E) ;; <CJK>
     (?$(0S[(B . ?\x7A46) ;; <CJK>
     (?$(0S\(B . ?\x7A4C) ;; <CJK>
     (?$(0S](B . ?\x7A4B) ;; <CJK>
     (?$(0S^(B . ?\x7ABA) ;; <CJK>
     (?$(0S_(B . ?\x7BD9) ;; <CJK>
     (?$(0S`(B . ?\x7C11) ;; <CJK>
     (?$(0Sa(B . ?\x7BC9) ;; <CJK>
     (?$(0Sb(B . ?\x7BE4) ;; <CJK>
     (?$(0Sc(B . ?\x7BDB) ;; <CJK>
     (?$(0Sd(B . ?\x7BE1) ;; <CJK>
     (?$(0Se(B . ?\x7BE9) ;; <CJK>
     (?$(0Sf(B . ?\x7BE6) ;; <CJK>
     (?$(0Sg(B . ?\x7CD5) ;; <CJK>
     (?$(0Sh(B . ?\x7CD6) ;; <CJK>
     (?$(0Si(B . ?\x7E0A) ;; <CJK>
     (?$(0Sj(B . ?\x7E11) ;; <CJK>
     (?$(0Sk(B . ?\x7E08) ;; <CJK>
     (?$(0Sl(B . ?\x7E1B) ;; <CJK>
     (?$(0Sm(B . ?\x7E23) ;; <CJK>
     (?$(0Sn(B . ?\x7E1E) ;; <CJK>
     (?$(0So(B . ?\x7E1D) ;; <CJK>
     (?$(0Sp(B . ?\x7E09) ;; <CJK>
     (?$(0Sq(B . ?\x7E10) ;; <CJK>
     (?$(0Sr(B . ?\x7F79) ;; <CJK>
     (?$(0Ss(B . ?\x7FB2) ;; <CJK>
     (?$(0St(B . ?\x7FF0) ;; <CJK>
     (?$(0Su(B . ?\x7FF1) ;; <CJK>
     (?$(0Sv(B . ?\x7FEE) ;; <CJK>
     (?$(0Sw(B . ?\x8028) ;; <CJK>
     (?$(0Sx(B . ?\x81B3) ;; <CJK>
     (?$(0Sy(B . ?\x81A9) ;; <CJK>
     (?$(0Sz(B . ?\x81A8) ;; <CJK>
     (?$(0S{(B . ?\x81FB) ;; <CJK>
     (?$(0S|(B . ?\x8208) ;; <CJK>
     (?$(0S}(B . ?\x8258) ;; <CJK>
     (?$(0S~(B . ?\x8259) ;; <CJK>
     (?$(0T!(B . ?\x854A) ;; <CJK>
     (?$(0T"(B . ?\x8559) ;; <CJK>
     (?$(0T#(B . ?\x8548) ;; <CJK>
     (?$(0T$(B . ?\x8568) ;; <CJK>
     (?$(0T%(B . ?\x8569) ;; <CJK>
     (?$(0T&(B . ?\x8543) ;; <CJK>
     (?$(0T'(B . ?\x8549) ;; <CJK>
     (?$(0T((B . ?\x856D) ;; <CJK>
     (?$(0T)(B . ?\x856A) ;; <CJK>
     (?$(0T*(B . ?\x855E) ;; <CJK>
     (?$(0T+(B . ?\x8783) ;; <CJK>
     (?$(0T,(B . ?\x879F) ;; <CJK>
     (?$(0T-(B . ?\x879E) ;; <CJK>
     (?$(0T.(B . ?\x87A2) ;; <CJK>
     (?$(0T/(B . ?\x878D) ;; <CJK>
     (?$(0T0(B . ?\x8861) ;; <CJK>
     (?$(0T1(B . ?\x892A) ;; <CJK>
     (?$(0T2(B . ?\x8932) ;; <CJK>
     (?$(0T3(B . ?\x8925) ;; <CJK>
     (?$(0T4(B . ?\x892B) ;; <CJK>
     (?$(0T5(B . ?\x8921) ;; <CJK>
     (?$(0T6(B . ?\x89AA) ;; <CJK>
     (?$(0T7(B . ?\x89A6) ;; <CJK>
     (?$(0T8(B . ?\x8AE6) ;; <CJK>
     (?$(0T9(B . ?\x8AFA) ;; <CJK>
     (?$(0T:(B . ?\x8AEB) ;; <CJK>
     (?$(0T;(B . ?\x8AF1) ;; <CJK>
     (?$(0T<(B . ?\x8B00) ;; <CJK>
     (?$(0T=(B . ?\x8ADC) ;; <CJK>
     (?$(0T>(B . ?\x8AE7) ;; <CJK>
     (?$(0T?(B . ?\x8AEE) ;; <CJK>
     (?$(0T@(B . ?\x8AFE) ;; <CJK>
     (?$(0TA(B . ?\x8B01) ;; <CJK>
     (?$(0TB(B . ?\x8B02) ;; <CJK>
     (?$(0TC(B . ?\x8AF7) ;; <CJK>
     (?$(0TD(B . ?\x8AED) ;; <CJK>
     (?$(0TE(B . ?\x8AF3) ;; <CJK>
     (?$(0TF(B . ?\x8AF6) ;; <CJK>
     (?$(0TG(B . ?\x8AFC) ;; <CJK>
     (?$(0TH(B . ?\x8C6B) ;; <CJK>
     (?$(0TI(B . ?\x8C6D) ;; <CJK>
     (?$(0TJ(B . ?\x8C93) ;; <CJK>
     (?$(0TK(B . ?\x8CF4) ;; <CJK>
     (?$(0TL(B . ?\x8E44) ;; <CJK>
     (?$(0TM(B . ?\x8E31) ;; <CJK>
     (?$(0TN(B . ?\x8E34) ;; <CJK>
     (?$(0TO(B . ?\x8E42) ;; <CJK>
     (?$(0TP(B . ?\x8E39) ;; <CJK>
     (?$(0TQ(B . ?\x8E35) ;; <CJK>
     (?$(0TR(B . ?\x8F3B) ;; <CJK>
     (?$(0TS(B . ?\x8F2F) ;; <CJK>
     (?$(0TT(B . ?\x8F38) ;; <CJK>
     (?$(0TU(B . ?\x8F33) ;; <CJK>
     (?$(0TV(B . ?\x8FA8) ;; <CJK>
     (?$(0TW(B . ?\x8FA6) ;; <CJK>
     (?$(0TX(B . ?\x9075) ;; <CJK>
     (?$(0TY(B . ?\x9074) ;; <CJK>
     (?$(0TZ(B . ?\x9078) ;; <CJK>
     (?$(0T[(B . ?\x9072) ;; <CJK>
     (?$(0T\(B . ?\x907C) ;; <CJK>
     (?$(0T](B . ?\x907A) ;; <CJK>
     (?$(0T^(B . ?\x9134) ;; <CJK>
     (?$(0T_(B . ?\x9192) ;; <CJK>
     (?$(0T`(B . ?\x9320) ;; <CJK>
     (?$(0Ta(B . ?\x9336) ;; <CJK>
     (?$(0Tb(B . ?\x92F8) ;; <CJK>
     (?$(0Tc(B . ?\x9333) ;; <CJK>
     (?$(0Td(B . ?\x932F) ;; <CJK>
     (?$(0Te(B . ?\x9322) ;; <CJK>
     (?$(0Tf(B . ?\x92FC) ;; <CJK>
     (?$(0Tg(B . ?\x932B) ;; <CJK>
     (?$(0Th(B . ?\x9304) ;; <CJK>
     (?$(0Ti(B . ?\x931A) ;; <CJK>
     (?$(0Tj(B . ?\x9310) ;; <CJK>
     (?$(0Tk(B . ?\x9326) ;; <CJK>
     (?$(0Tl(B . ?\x9321) ;; <CJK>
     (?$(0Tm(B . ?\x9315) ;; <CJK>
     (?$(0Tn(B . ?\x932E) ;; <CJK>
     (?$(0To(B . ?\x9319) ;; <CJK>
     (?$(0Tp(B . ?\x95BB) ;; <CJK>
     (?$(0Tq(B . ?\x96A7) ;; <CJK>
     (?$(0Tr(B . ?\x96A8) ;; <CJK>
     (?$(0Ts(B . ?\x96AA) ;; <CJK>
     (?$(0Tt(B . ?\x96D5) ;; <CJK>
     (?$(0Tu(B . ?\x970E) ;; <CJK>
     (?$(0Tv(B . ?\x9711) ;; <CJK>
     (?$(0Tw(B . ?\x9716) ;; <CJK>
     (?$(0Tx(B . ?\x970D) ;; <CJK>
     (?$(0Ty(B . ?\x9713) ;; <CJK>
     (?$(0Tz(B . ?\x970F) ;; <CJK>
     (?$(0T{(B . ?\x975B) ;; <CJK>
     (?$(0T|(B . ?\x975C) ;; <CJK>
     (?$(0T}(B . ?\x9766) ;; <CJK>
     (?$(0T~(B . ?\x9798) ;; <CJK>
     (?$(0U!(B . ?\x9830) ;; <CJK>
     (?$(0U"(B . ?\x9838) ;; <CJK>
     (?$(0U#(B . ?\x983B) ;; <CJK>
     (?$(0U$(B . ?\x9837) ;; <CJK>
     (?$(0U%(B . ?\x982D) ;; <CJK>
     (?$(0U&(B . ?\x9839) ;; <CJK>
     (?$(0U'(B . ?\x9824) ;; <CJK>
     (?$(0U((B . ?\x9910) ;; <CJK>
     (?$(0U)(B . ?\x9928) ;; <CJK>
     (?$(0U*(B . ?\x991E) ;; <CJK>
     (?$(0U+(B . ?\x991B) ;; <CJK>
     (?$(0U,(B . ?\x9921) ;; <CJK>
     (?$(0U-(B . ?\x991A) ;; <CJK>
     (?$(0U.(B . ?\x99ED) ;; <CJK>
     (?$(0U/(B . ?\x99E2) ;; <CJK>
     (?$(0U0(B . ?\x99F1) ;; <CJK>
     (?$(0U1(B . ?\x9AB8) ;; <CJK>
     (?$(0U2(B . ?\x9ABC) ;; <CJK>
     (?$(0U3(B . ?\x9AFB) ;; <CJK>
     (?$(0U4(B . ?\x9AED) ;; <CJK>
     (?$(0U5(B . ?\x9B28) ;; <CJK>
     (?$(0U6(B . ?\x9B91) ;; <CJK>
     (?$(0U7(B . ?\x9D15) ;; <CJK>
     (?$(0U8(B . ?\x9D23) ;; <CJK>
     (?$(0U9(B . ?\x9D26) ;; <CJK>
     (?$(0U:(B . ?\x9D28) ;; <CJK>
     (?$(0U;(B . ?\x9D12) ;; <CJK>
     (?$(0U<(B . ?\x9D1B) ;; <CJK>
     (?$(0U=(B . ?\x9ED8) ;; <CJK>
     (?$(0U>(B . ?\x9ED4) ;; <CJK>
     (?$(0U?(B . ?\x9F8D) ;; <CJK>
     (?$(0U@(B . ?\x9F9C) ;; <CJK>
     (?$(0UA(B . ?\x512A) ;; <CJK>
     (?$(0UB(B . ?\x511F) ;; <CJK>
     (?$(0UC(B . ?\x5121) ;; <CJK>
     (?$(0UD(B . ?\x5132) ;; <CJK>
     (?$(0UE(B . ?\x52F5) ;; <CJK>
     (?$(0UF(B . ?\x568E) ;; <CJK>
     (?$(0UG(B . ?\x5680) ;; <CJK>
     (?$(0UH(B . ?\x5690) ;; <CJK>
     (?$(0UI(B . ?\x5685) ;; <CJK>
     (?$(0UJ(B . ?\x5687) ;; <CJK>
     (?$(0UK(B . ?\x568F) ;; <CJK>
     (?$(0UL(B . ?\x58D5) ;; <CJK>
     (?$(0UM(B . ?\x58D3) ;; <CJK>
     (?$(0UN(B . ?\x58D1) ;; <CJK>
     (?$(0UO(B . ?\x58CE) ;; <CJK>
     (?$(0UP(B . ?\x5B30) ;; <CJK>
     (?$(0UQ(B . ?\x5B2A) ;; <CJK>
     (?$(0UR(B . ?\x5B24) ;; <CJK>
     (?$(0US(B . ?\x5B7A) ;; <CJK>
     (?$(0UT(B . ?\x5C37) ;; <CJK>
     (?$(0UU(B . ?\x5C68) ;; <CJK>
     (?$(0UV(B . ?\x5DBC) ;; <CJK>
     (?$(0UW(B . ?\x5DBA) ;; <CJK>
     (?$(0UX(B . ?\x5DBD) ;; <CJK>
     (?$(0UY(B . ?\x5DB8) ;; <CJK>
     (?$(0UZ(B . ?\x5E6B) ;; <CJK>
     (?$(0U[(B . ?\x5F4C) ;; <CJK>
     (?$(0U\(B . ?\x5FBD) ;; <CJK>
     (?$(0U](B . ?\x61C9) ;; <CJK>
     (?$(0U^(B . ?\x61C2) ;; <CJK>
     (?$(0U_(B . ?\x61C7) ;; <CJK>
     (?$(0U`(B . ?\x61E6) ;; <CJK>
     (?$(0Ua(B . ?\x61CB) ;; <CJK>
     (?$(0Ub(B . ?\x6232) ;; <CJK>
     (?$(0Uc(B . ?\x6234) ;; <CJK>
     (?$(0Ud(B . ?\x64CE) ;; <CJK>
     (?$(0Ue(B . ?\x64CA) ;; <CJK>
     (?$(0Uf(B . ?\x64D8) ;; <CJK>
     (?$(0Ug(B . ?\x64E0) ;; <CJK>
     (?$(0Uh(B . ?\x64F0) ;; <CJK>
     (?$(0Ui(B . ?\x64E6) ;; <CJK>
     (?$(0Uj(B . ?\x64EC) ;; <CJK>
     (?$(0Uk(B . ?\x64F1) ;; <CJK>
     (?$(0Ul(B . ?\x64E2) ;; <CJK>
     (?$(0Um(B . ?\x64ED) ;; <CJK>
     (?$(0Un(B . ?\x6582) ;; <CJK>
     (?$(0Uo(B . ?\x6583) ;; <CJK>
     (?$(0Up(B . ?\x66D9) ;; <CJK>
     (?$(0Uq(B . ?\x66D6) ;; <CJK>
     (?$(0Ur(B . ?\x6A80) ;; <CJK>
     (?$(0Us(B . ?\x6A94) ;; <CJK>
     (?$(0Ut(B . ?\x6A84) ;; <CJK>
     (?$(0Uu(B . ?\x6AA2) ;; <CJK>
     (?$(0Uv(B . ?\x6A9C) ;; <CJK>
     (?$(0Uw(B . ?\x6ADB) ;; <CJK>
     (?$(0Ux(B . ?\x6AA3) ;; <CJK>
     (?$(0Uy(B . ?\x6A7E) ;; <CJK>
     (?$(0Uz(B . ?\x6A97) ;; <CJK>
     (?$(0U{(B . ?\x6A90) ;; <CJK>
     (?$(0U|(B . ?\x6AA0) ;; <CJK>
     (?$(0U}(B . ?\x6B5C) ;; <CJK>
     (?$(0U~(B . ?\x6BAE) ;; <CJK>
     (?$(0V!(B . ?\x6BDA) ;; <CJK>
     (?$(0V"(B . ?\x6C08) ;; <CJK>
     (?$(0V#(B . ?\x6FD8) ;; <CJK>
     (?$(0V$(B . ?\x6FF1) ;; <CJK>
     (?$(0V%(B . ?\x6FDF) ;; <CJK>
     (?$(0V&(B . ?\x6FE0) ;; <CJK>
     (?$(0V'(B . ?\x6FDB) ;; <CJK>
     (?$(0V((B . ?\x6FE4) ;; <CJK>
     (?$(0V)(B . ?\x6FEB) ;; <CJK>
     (?$(0V*(B . ?\x6FEF) ;; <CJK>
     (?$(0V+(B . ?\x6F80) ;; <CJK>
     (?$(0V,(B . ?\x6FEC) ;; <CJK>
     (?$(0V-(B . ?\x6FE1) ;; <CJK>
     (?$(0V.(B . ?\x6FE9) ;; <CJK>
     (?$(0V/(B . ?\x6FD5) ;; <CJK>
     (?$(0V0(B . ?\x6FEE) ;; <CJK>
     (?$(0V1(B . ?\x6FF0) ;; <CJK>
     (?$(0V2(B . ?\x71E7) ;; <CJK>
     (?$(0V3(B . ?\x71DF) ;; <CJK>
     (?$(0V4(B . ?\x71EE) ;; <CJK>
     (?$(0V5(B . ?\x71E6) ;; <CJK>
     (?$(0V6(B . ?\x71E5) ;; <CJK>
     (?$(0V7(B . ?\x71ED) ;; <CJK>
     (?$(0V8(B . ?\x71EC) ;; <CJK>
     (?$(0V9(B . ?\x71F4) ;; <CJK>
     (?$(0V:(B . ?\x71E0) ;; <CJK>
     (?$(0V;(B . ?\x7235) ;; <CJK>
     (?$(0V<(B . ?\x7246) ;; <CJK>
     (?$(0V=(B . ?\x7370) ;; <CJK>
     (?$(0V>(B . ?\x7372) ;; <CJK>
     (?$(0V?(B . ?\x74A9) ;; <CJK>
     (?$(0V@(B . ?\x74B0) ;; <CJK>
     (?$(0VA(B . ?\x74A6) ;; <CJK>
     (?$(0VB(B . ?\x74A8) ;; <CJK>
     (?$(0VC(B . ?\x7646) ;; <CJK>
     (?$(0VD(B . ?\x7642) ;; <CJK>
     (?$(0VE(B . ?\x764C) ;; <CJK>
     (?$(0VF(B . ?\x76EA) ;; <CJK>
     (?$(0VG(B . ?\x77B3) ;; <CJK>
     (?$(0VH(B . ?\x77AA) ;; <CJK>
     (?$(0VI(B . ?\x77B0) ;; <CJK>
     (?$(0VJ(B . ?\x77AC) ;; <CJK>
     (?$(0VK(B . ?\x77A7) ;; <CJK>
     (?$(0VL(B . ?\x77AD) ;; <CJK>
     (?$(0VM(B . ?\x77EF) ;; <CJK>
     (?$(0VN(B . ?\x78F7) ;; <CJK>
     (?$(0VO(B . ?\x78FA) ;; <CJK>
     (?$(0VP(B . ?\x78F4) ;; <CJK>
     (?$(0VQ(B . ?\x78EF) ;; <CJK>
     (?$(0VR(B . ?\x7901) ;; <CJK>
     (?$(0VS(B . ?\x79A7) ;; <CJK>
     (?$(0VT(B . ?\x79AA) ;; <CJK>
     (?$(0VU(B . ?\x7A57) ;; <CJK>
     (?$(0VV(B . ?\x7ABF) ;; <CJK>
     (?$(0VW(B . ?\x7C07) ;; <CJK>
     (?$(0VX(B . ?\x7C0D) ;; <CJK>
     (?$(0VY(B . ?\x7BFE) ;; <CJK>
     (?$(0VZ(B . ?\x7BF7) ;; <CJK>
     (?$(0V[(B . ?\x7C0C) ;; <CJK>
     (?$(0V\(B . ?\x7BE0) ;; <CJK>
     (?$(0V](B . ?\x7CE0) ;; <CJK>
     (?$(0V^(B . ?\x7CDC) ;; <CJK>
     (?$(0V_(B . ?\x7CDE) ;; <CJK>
     (?$(0V`(B . ?\x7CE2) ;; <CJK>
     (?$(0Va(B . ?\x7CDF) ;; <CJK>
     (?$(0Vb(B . ?\x7CD9) ;; <CJK>
     (?$(0Vc(B . ?\x7CDD) ;; <CJK>
     (?$(0Vd(B . ?\x7E2E) ;; <CJK>
     (?$(0Ve(B . ?\x7E3E) ;; <CJK>
     (?$(0Vf(B . ?\x7E46) ;; <CJK>
     (?$(0Vg(B . ?\x7E37) ;; <CJK>
     (?$(0Vh(B . ?\x7E32) ;; <CJK>
     (?$(0Vi(B . ?\x7E43) ;; <CJK>
     (?$(0Vj(B . ?\x7E2B) ;; <CJK>
     (?$(0Vk(B . ?\x7E3D) ;; <CJK>
     (?$(0Vl(B . ?\x7E31) ;; <CJK>
     (?$(0Vm(B . ?\x7E45) ;; <CJK>
     (?$(0Vn(B . ?\x7E41) ;; <CJK>
     (?$(0Vo(B . ?\x7E34) ;; <CJK>
     (?$(0Vp(B . ?\x7E39) ;; <CJK>
     (?$(0Vq(B . ?\x7E48) ;; <CJK>
     (?$(0Vr(B . ?\x7E35) ;; <CJK>
     (?$(0Vs(B . ?\x7E3F) ;; <CJK>
     (?$(0Vt(B . ?\x7E2F) ;; <CJK>
     (?$(0Vu(B . ?\x7F44) ;; <CJK>
     (?$(0Vv(B . ?\x7FF3) ;; <CJK>
     (?$(0Vw(B . ?\x7FFC) ;; <CJK>
     (?$(0Vx(B . ?\x8071) ;; <CJK>
     (?$(0Vy(B . ?\x8072) ;; <CJK>
     (?$(0Vz(B . ?\x8070) ;; <CJK>
     (?$(0V{(B . ?\x806F) ;; <CJK>
     (?$(0V|(B . ?\x8073) ;; <CJK>
     (?$(0V}(B . ?\x81C6) ;; <CJK>
     (?$(0V~(B . ?\x81C3) ;; <CJK>
     (?$(0W!(B . ?\x81BA) ;; <CJK>
     (?$(0W"(B . ?\x81C2) ;; <CJK>
     (?$(0W#(B . ?\x81C0) ;; <CJK>
     (?$(0W$(B . ?\x81BF) ;; <CJK>
     (?$(0W%(B . ?\x81BD) ;; <CJK>
     (?$(0W&(B . ?\x81C9) ;; <CJK>
     (?$(0W'(B . ?\x81BE) ;; <CJK>
     (?$(0W((B . ?\x81E8) ;; <CJK>
     (?$(0W)(B . ?\x8209) ;; <CJK>
     (?$(0W*(B . ?\x8271) ;; <CJK>
     (?$(0W+(B . ?\x85AA) ;; <CJK>
     (?$(0W,(B . ?\x8584) ;; <CJK>
     (?$(0W-(B . ?\x857E) ;; <CJK>
     (?$(0W.(B . ?\x859C) ;; <CJK>
     (?$(0W/(B . ?\x8591) ;; <CJK>
     (?$(0W0(B . ?\x8594) ;; <CJK>
     (?$(0W1(B . ?\x85AF) ;; <CJK>
     (?$(0W2(B . ?\x859B) ;; <CJK>
     (?$(0W3(B . ?\x8587) ;; <CJK>
     (?$(0W4(B . ?\x85A8) ;; <CJK>
     (?$(0W5(B . ?\x858A) ;; <CJK>
     (?$(0W6(B . ?\x8667) ;; <CJK>
     (?$(0W7(B . ?\x87C0) ;; <CJK>
     (?$(0W8(B . ?\x87D1) ;; <CJK>
     (?$(0W9(B . ?\x87B3) ;; <CJK>
     (?$(0W:(B . ?\x87D2) ;; <CJK>
     (?$(0W;(B . ?\x87C6) ;; <CJK>
     (?$(0W<(B . ?\x87AB) ;; <CJK>
     (?$(0W=(B . ?\x87BB) ;; <CJK>
     (?$(0W>(B . ?\x87BA) ;; <CJK>
     (?$(0W?(B . ?\x87C8) ;; <CJK>
     (?$(0W@(B . ?\x87CB) ;; <CJK>
     (?$(0WA(B . ?\x893B) ;; <CJK>
     (?$(0WB(B . ?\x8936) ;; <CJK>
     (?$(0WC(B . ?\x8944) ;; <CJK>
     (?$(0WD(B . ?\x8938) ;; <CJK>
     (?$(0WE(B . ?\x893D) ;; <CJK>
     (?$(0WF(B . ?\x89AC) ;; <CJK>
     (?$(0WG(B . ?\x8B0E) ;; <CJK>
     (?$(0WH(B . ?\x8B17) ;; <CJK>
     (?$(0WI(B . ?\x8B19) ;; <CJK>
     (?$(0WJ(B . ?\x8B1B) ;; <CJK>
     (?$(0WK(B . ?\x8B0A) ;; <CJK>
     (?$(0WL(B . ?\x8B20) ;; <CJK>
     (?$(0WM(B . ?\x8B1D) ;; <CJK>
     (?$(0WN(B . ?\x8B04) ;; <CJK>
     (?$(0WO(B . ?\x8B10) ;; <CJK>
     (?$(0WP(B . ?\x8C41) ;; <CJK>
     (?$(0WQ(B . ?\x8C3F) ;; <CJK>
     (?$(0WR(B . ?\x8C73) ;; <CJK>
     (?$(0WS(B . ?\x8CFA) ;; <CJK>
     (?$(0WT(B . ?\x8CFD) ;; <CJK>
     (?$(0WU(B . ?\x8CFC) ;; <CJK>
     (?$(0WV(B . ?\x8CF8) ;; <CJK>
     (?$(0WW(B . ?\x8CFB) ;; <CJK>
     (?$(0WX(B . ?\x8DA8) ;; <CJK>
     (?$(0WY(B . ?\x8E49) ;; <CJK>
     (?$(0WZ(B . ?\x8E4B) ;; <CJK>
     (?$(0W[(B . ?\x8E48) ;; <CJK>
     (?$(0W\(B . ?\x8E4A) ;; <CJK>
     (?$(0W](B . ?\x8F44) ;; <CJK>
     (?$(0W^(B . ?\x8F3E) ;; <CJK>
     (?$(0W_(B . ?\x8F42) ;; <CJK>
     (?$(0W`(B . ?\x8F45) ;; <CJK>
     (?$(0Wa(B . ?\x8F3F) ;; <CJK>
     (?$(0Wb(B . ?\x907F) ;; <CJK>
     (?$(0Wc(B . ?\x907D) ;; <CJK>
     (?$(0Wd(B . ?\x9084) ;; <CJK>
     (?$(0We(B . ?\x9081) ;; <CJK>
     (?$(0Wf(B . ?\x9082) ;; <CJK>
     (?$(0Wg(B . ?\x9080) ;; <CJK>
     (?$(0Wh(B . ?\x9139) ;; <CJK>
     (?$(0Wi(B . ?\x91A3) ;; <CJK>
     (?$(0Wj(B . ?\x919E) ;; <CJK>
     (?$(0Wk(B . ?\x919C) ;; <CJK>
     (?$(0Wl(B . ?\x934D) ;; <CJK>
     (?$(0Wm(B . ?\x9382) ;; <CJK>
     (?$(0Wn(B . ?\x9328) ;; <CJK>
     (?$(0Wo(B . ?\x9375) ;; <CJK>
     (?$(0Wp(B . ?\x934A) ;; <CJK>
     (?$(0Wq(B . ?\x9365) ;; <CJK>
     (?$(0Wr(B . ?\x934B) ;; <CJK>
     (?$(0Ws(B . ?\x9318) ;; <CJK>
     (?$(0Wt(B . ?\x937E) ;; <CJK>
     (?$(0Wu(B . ?\x936C) ;; <CJK>
     (?$(0Wv(B . ?\x935B) ;; <CJK>
     (?$(0Ww(B . ?\x9370) ;; <CJK>
     (?$(0Wx(B . ?\x935A) ;; <CJK>
     (?$(0Wy(B . ?\x9354) ;; <CJK>
     (?$(0Wz(B . ?\x95CA) ;; <CJK>
     (?$(0W{(B . ?\x95CB) ;; <CJK>
     (?$(0W|(B . ?\x95CC) ;; <CJK>
     (?$(0W}(B . ?\x95C8) ;; <CJK>
     (?$(0W~(B . ?\x95C6) ;; <CJK>
     (?$(0X!(B . ?\x96B1) ;; <CJK>
     (?$(0X"(B . ?\x96B8) ;; <CJK>
     (?$(0X#(B . ?\x96D6) ;; <CJK>
     (?$(0X$(B . ?\x971C) ;; <CJK>
     (?$(0X%(B . ?\x971E) ;; <CJK>
     (?$(0X&(B . ?\x97A0) ;; <CJK>
     (?$(0X'(B . ?\x97D3) ;; <CJK>
     (?$(0X((B . ?\x9846) ;; <CJK>
     (?$(0X)(B . ?\x98B6) ;; <CJK>
     (?$(0X*(B . ?\x9935) ;; <CJK>
     (?$(0X+(B . ?\x9A01) ;; <CJK>
     (?$(0X,(B . ?\x99FF) ;; <CJK>
     (?$(0X-(B . ?\x9BAE) ;; <CJK>
     (?$(0X.(B . ?\x9BAB) ;; <CJK>
     (?$(0X/(B . ?\x9BAA) ;; <CJK>
     (?$(0X0(B . ?\x9BAD) ;; <CJK>
     (?$(0X1(B . ?\x9D3B) ;; <CJK>
     (?$(0X2(B . ?\x9D3F) ;; <CJK>
     (?$(0X3(B . ?\x9E8B) ;; <CJK>
     (?$(0X4(B . ?\x9ECF) ;; <CJK>
     (?$(0X5(B . ?\x9EDE) ;; <CJK>
     (?$(0X6(B . ?\x9EDC) ;; <CJK>
     (?$(0X7(B . ?\x9EDD) ;; <CJK>
     (?$(0X8(B . ?\x9EDB) ;; <CJK>
     (?$(0X9(B . ?\x9F3E) ;; <CJK>
     (?$(0X:(B . ?\x9F4B) ;; <CJK>
     (?$(0X;(B . ?\x53E2) ;; <CJK>
     (?$(0X<(B . ?\x5695) ;; <CJK>
     (?$(0X=(B . ?\x56AE) ;; <CJK>
     (?$(0X>(B . ?\x58D9) ;; <CJK>
     (?$(0X?(B . ?\x58D8) ;; <CJK>
     (?$(0X@(B . ?\x5B38) ;; <CJK>
     (?$(0XA(B . ?\x5F5D) ;; <CJK>
     (?$(0XB(B . ?\x61E3) ;; <CJK>
     (?$(0XC(B . ?\x6233) ;; <CJK>
     (?$(0XD(B . ?\x64F4) ;; <CJK>
     (?$(0XE(B . ?\x64F2) ;; <CJK>
     (?$(0XF(B . ?\x64FE) ;; <CJK>
     (?$(0XG(B . ?\x6506) ;; <CJK>
     (?$(0XH(B . ?\x64FA) ;; <CJK>
     (?$(0XI(B . ?\x64FB) ;; <CJK>
     (?$(0XJ(B . ?\x64F7) ;; <CJK>
     (?$(0XK(B . ?\x65B7) ;; <CJK>
     (?$(0XL(B . ?\x66DC) ;; <CJK>
     (?$(0XM(B . ?\x6726) ;; <CJK>
     (?$(0XN(B . ?\x6AB3) ;; <CJK>
     (?$(0XO(B . ?\x6AAC) ;; <CJK>
     (?$(0XP(B . ?\x6AC3) ;; <CJK>
     (?$(0XQ(B . ?\x6ABB) ;; <CJK>
     (?$(0XR(B . ?\x6AB8) ;; <CJK>
     (?$(0XS(B . ?\x6AC2) ;; <CJK>
     (?$(0XT(B . ?\x6AAE) ;; <CJK>
     (?$(0XU(B . ?\x6AAF) ;; <CJK>
     (?$(0XV(B . ?\x6B5F) ;; <CJK>
     (?$(0XW(B . ?\x6B78) ;; <CJK>
     (?$(0XX(B . ?\x6BAF) ;; <CJK>
     (?$(0XY(B . ?\x7009) ;; <CJK>
     (?$(0XZ(B . ?\x700B) ;; <CJK>
     (?$(0X[(B . ?\x6FFE) ;; <CJK>
     (?$(0X\(B . ?\x7006) ;; <CJK>
     (?$(0X](B . ?\x6FFA) ;; <CJK>
     (?$(0X^(B . ?\x7011) ;; <CJK>
     (?$(0X_(B . ?\x700F) ;; <CJK>
     (?$(0X`(B . ?\x71FB) ;; <CJK>
     (?$(0Xa(B . ?\x71FC) ;; <CJK>
     (?$(0Xb(B . ?\x71FE) ;; <CJK>
     (?$(0Xc(B . ?\x71F8) ;; <CJK>
     (?$(0Xd(B . ?\x7377) ;; <CJK>
     (?$(0Xe(B . ?\x7375) ;; <CJK>
     (?$(0Xf(B . ?\x74A7) ;; <CJK>
     (?$(0Xg(B . ?\x74BF) ;; <CJK>
     (?$(0Xh(B . ?\x7515) ;; <CJK>
     (?$(0Xi(B . ?\x7656) ;; <CJK>
     (?$(0Xj(B . ?\x7658) ;; <CJK>
     (?$(0Xk(B . ?\x7652) ;; <CJK>
     (?$(0Xl(B . ?\x77BD) ;; <CJK>
     (?$(0Xm(B . ?\x77BF) ;; <CJK>
     (?$(0Xn(B . ?\x77BB) ;; <CJK>
     (?$(0Xo(B . ?\x77BC) ;; <CJK>
     (?$(0Xp(B . ?\x790E) ;; <CJK>
     (?$(0Xq(B . ?\x79AE) ;; <CJK>
     (?$(0Xr(B . ?\x7A61) ;; <CJK>
     (?$(0Xs(B . ?\x7A62) ;; <CJK>
     (?$(0Xt(B . ?\x7A60) ;; <CJK>
     (?$(0Xu(B . ?\x7AC4) ;; <CJK>
     (?$(0Xv(B . ?\x7AC5) ;; <CJK>
     (?$(0Xw(B . ?\x7C2B) ;; <CJK>
     (?$(0Xx(B . ?\x7C27) ;; <CJK>
     (?$(0Xy(B . ?\x7C2A) ;; <CJK>
     (?$(0Xz(B . ?\x7C1E) ;; <CJK>
     (?$(0X{(B . ?\x7C23) ;; <CJK>
     (?$(0X|(B . ?\x7C21) ;; <CJK>
     (?$(0X}(B . ?\x7CE7) ;; <CJK>
     (?$(0X~(B . ?\x7E54) ;; <CJK>
     (?$(0Y!(B . ?\x7E55) ;; <CJK>
     (?$(0Y"(B . ?\x7E5E) ;; <CJK>
     (?$(0Y#(B . ?\x7E5A) ;; <CJK>
     (?$(0Y$(B . ?\x7E61) ;; <CJK>
     (?$(0Y%(B . ?\x7E52) ;; <CJK>
     (?$(0Y&(B . ?\x7E59) ;; <CJK>
     (?$(0Y'(B . ?\x7F48) ;; <CJK>
     (?$(0Y((B . ?\x7FF9) ;; <CJK>
     (?$(0Y)(B . ?\x7FFB) ;; <CJK>
     (?$(0Y*(B . ?\x8077) ;; <CJK>
     (?$(0Y+(B . ?\x8076) ;; <CJK>
     (?$(0Y,(B . ?\x81CD) ;; <CJK>
     (?$(0Y-(B . ?\x81CF) ;; <CJK>
     (?$(0Y.(B . ?\x820A) ;; <CJK>
     (?$(0Y/(B . ?\x85CF) ;; <CJK>
     (?$(0Y0(B . ?\x85A9) ;; <CJK>
     (?$(0Y1(B . ?\x85CD) ;; <CJK>
     (?$(0Y2(B . ?\x85D0) ;; <CJK>
     (?$(0Y3(B . ?\x85C9) ;; <CJK>
     (?$(0Y4(B . ?\x85B0) ;; <CJK>
     (?$(0Y5(B . ?\x85BA) ;; <CJK>
     (?$(0Y6(B . ?\x85B9) ;; <CJK>
     (?$(0Y7(B . ?\x85A6) ;; <CJK>
     (?$(0Y8(B . ?\x87EF) ;; <CJK>
     (?$(0Y9(B . ?\x87EC) ;; <CJK>
     (?$(0Y:(B . ?\x87F2) ;; <CJK>
     (?$(0Y;(B . ?\x87E0) ;; <CJK>
     (?$(0Y<(B . ?\x8986) ;; <CJK>
     (?$(0Y=(B . ?\x89B2) ;; <CJK>
     (?$(0Y>(B . ?\x89F4) ;; <CJK>
     (?$(0Y?(B . ?\x8B28) ;; <CJK>
     (?$(0Y@(B . ?\x8B39) ;; <CJK>
     (?$(0YA(B . ?\x8B2C) ;; <CJK>
     (?$(0YB(B . ?\x8B2B) ;; <CJK>
     (?$(0YC(B . ?\x8C50) ;; <CJK>
     (?$(0YD(B . ?\x8D05) ;; <CJK>
     (?$(0YE(B . ?\x8E59) ;; <CJK>
     (?$(0YF(B . ?\x8E63) ;; <CJK>
     (?$(0YG(B . ?\x8E66) ;; <CJK>
     (?$(0YH(B . ?\x8E64) ;; <CJK>
     (?$(0YI(B . ?\x8E5F) ;; <CJK>
     (?$(0YJ(B . ?\x8E55) ;; <CJK>
     (?$(0YK(B . ?\x8EC0) ;; <CJK>
     (?$(0YL(B . ?\x8F49) ;; <CJK>
     (?$(0YM(B . ?\x8F4D) ;; <CJK>
     (?$(0YN(B . ?\x9087) ;; <CJK>
     (?$(0YO(B . ?\x9083) ;; <CJK>
     (?$(0YP(B . ?\x9088) ;; <CJK>
     (?$(0YQ(B . ?\x91AB) ;; <CJK>
     (?$(0YR(B . ?\x91AC) ;; <CJK>
     (?$(0YS(B . ?\x91D0) ;; <CJK>
     (?$(0YT(B . ?\x9394) ;; <CJK>
     (?$(0YU(B . ?\x938A) ;; <CJK>
     (?$(0YV(B . ?\x9396) ;; <CJK>
     (?$(0YW(B . ?\x93A2) ;; <CJK>
     (?$(0YX(B . ?\x93B3) ;; <CJK>
     (?$(0YY(B . ?\x93AE) ;; <CJK>
     (?$(0YZ(B . ?\x93AC) ;; <CJK>
     (?$(0Y[(B . ?\x93B0) ;; <CJK>
     (?$(0Y\(B . ?\x9398) ;; <CJK>
     (?$(0Y](B . ?\x939A) ;; <CJK>
     (?$(0Y^(B . ?\x9397) ;; <CJK>
     (?$(0Y_(B . ?\x95D4) ;; <CJK>
     (?$(0Y`(B . ?\x95D6) ;; <CJK>
     (?$(0Ya(B . ?\x95D0) ;; <CJK>
     (?$(0Yb(B . ?\x95D5) ;; <CJK>
     (?$(0Yc(B . ?\x96E2) ;; <CJK>
     (?$(0Yd(B . ?\x96DC) ;; <CJK>
     (?$(0Ye(B . ?\x96D9) ;; <CJK>
     (?$(0Yf(B . ?\x96DB) ;; <CJK>
     (?$(0Yg(B . ?\x96DE) ;; <CJK>
     (?$(0Yh(B . ?\x9724) ;; <CJK>
     (?$(0Yi(B . ?\x97A3) ;; <CJK>
     (?$(0Yj(B . ?\x97A6) ;; <CJK>
     (?$(0Yk(B . ?\x97AD) ;; <CJK>
     (?$(0Yl(B . ?\x97F9) ;; <CJK>
     (?$(0Ym(B . ?\x984D) ;; <CJK>
     (?$(0Yn(B . ?\x984F) ;; <CJK>
     (?$(0Yo(B . ?\x984C) ;; <CJK>
     (?$(0Yp(B . ?\x984E) ;; <CJK>
     (?$(0Yq(B . ?\x9853) ;; <CJK>
     (?$(0Yr(B . ?\x98BA) ;; <CJK>
     (?$(0Ys(B . ?\x993E) ;; <CJK>
     (?$(0Yt(B . ?\x993F) ;; <CJK>
     (?$(0Yu(B . ?\x993D) ;; <CJK>
     (?$(0Yv(B . ?\x992E) ;; <CJK>
     (?$(0Yw(B . ?\x99A5) ;; <CJK>
     (?$(0Yx(B . ?\x9A0E) ;; <CJK>
     (?$(0Yy(B . ?\x9AC1) ;; <CJK>
     (?$(0Yz(B . ?\x9B03) ;; <CJK>
     (?$(0Y{(B . ?\x9B06) ;; <CJK>
     (?$(0Y|(B . ?\x9B4F) ;; <CJK>
     (?$(0Y}(B . ?\x9B4E) ;; <CJK>
     (?$(0Y~(B . ?\x9B4D) ;; <CJK>
     (?$(0Z!(B . ?\x9BCA) ;; <CJK>
     (?$(0Z"(B . ?\x9BC9) ;; <CJK>
     (?$(0Z#(B . ?\x9BFD) ;; <CJK>
     (?$(0Z$(B . ?\x9BC8) ;; <CJK>
     (?$(0Z%(B . ?\x9BC0) ;; <CJK>
     (?$(0Z&(B . ?\x9D51) ;; <CJK>
     (?$(0Z'(B . ?\x9D5D) ;; <CJK>
     (?$(0Z((B . ?\x9D60) ;; <CJK>
     (?$(0Z)(B . ?\x9EE0) ;; <CJK>
     (?$(0Z*(B . ?\x9F15) ;; <CJK>
     (?$(0Z+(B . ?\x9F2C) ;; <CJK>
     (?$(0Z,(B . ?\x5133) ;; <CJK>
     (?$(0Z-(B . ?\x56A5) ;; <CJK>
     (?$(0Z.(B . ?\x58DE) ;; <CJK>
     (?$(0Z/(B . ?\x58DF) ;; <CJK>
     (?$(0Z0(B . ?\x58E2) ;; <CJK>
     (?$(0Z1(B . ?\x5BF5) ;; <CJK>
     (?$(0Z2(B . ?\x9F90) ;; <CJK>
     (?$(0Z3(B . ?\x5EEC) ;; <CJK>
     (?$(0Z4(B . ?\x61F2) ;; <CJK>
     (?$(0Z5(B . ?\x61F7) ;; <CJK>
     (?$(0Z6(B . ?\x61F6) ;; <CJK>
     (?$(0Z7(B . ?\x61F5) ;; <CJK>
     (?$(0Z8(B . ?\x6500) ;; <CJK>
     (?$(0Z9(B . ?\x650F) ;; <CJK>
     (?$(0Z:(B . ?\x66E0) ;; <CJK>
     (?$(0Z;(B . ?\x66DD) ;; <CJK>
     (?$(0Z<(B . ?\x6AE5) ;; <CJK>
     (?$(0Z=(B . ?\x6ADD) ;; <CJK>
     (?$(0Z>(B . ?\x6ADA) ;; <CJK>
     (?$(0Z?(B . ?\x6AD3) ;; <CJK>
     (?$(0Z@(B . ?\x701B) ;; <CJK>
     (?$(0ZA(B . ?\x701F) ;; <CJK>
     (?$(0ZB(B . ?\x7028) ;; <CJK>
     (?$(0ZC(B . ?\x701A) ;; <CJK>
     (?$(0ZD(B . ?\x701D) ;; <CJK>
     (?$(0ZE(B . ?\x7015) ;; <CJK>
     (?$(0ZF(B . ?\x7018) ;; <CJK>
     (?$(0ZG(B . ?\x7206) ;; <CJK>
     (?$(0ZH(B . ?\x720D) ;; <CJK>
     (?$(0ZI(B . ?\x7258) ;; <CJK>
     (?$(0ZJ(B . ?\x72A2) ;; <CJK>
     (?$(0ZK(B . ?\x7378) ;; <CJK>
     (?$(0ZL(B . ?\x737A) ;; <CJK>
     (?$(0ZM(B . ?\x74BD) ;; <CJK>
     (?$(0ZN(B . ?\x74CA) ;; <CJK>
     (?$(0ZO(B . ?\x74E3) ;; <CJK>
     (?$(0ZP(B . ?\x7587) ;; <CJK>
     (?$(0ZQ(B . ?\x7586) ;; <CJK>
     (?$(0ZR(B . ?\x765F) ;; <CJK>
     (?$(0ZS(B . ?\x7661) ;; <CJK>
     (?$(0ZT(B . ?\x77C7) ;; <CJK>
     (?$(0ZU(B . ?\x7919) ;; <CJK>
     (?$(0ZV(B . ?\x79B1) ;; <CJK>
     (?$(0ZW(B . ?\x7A6B) ;; <CJK>
     (?$(0ZX(B . ?\x7A69) ;; <CJK>
     (?$(0ZY(B . ?\x7C3E) ;; <CJK>
     (?$(0ZZ(B . ?\x7C3F) ;; <CJK>
     (?$(0Z[(B . ?\x7C38) ;; <CJK>
     (?$(0Z\(B . ?\x7C3D) ;; <CJK>
     (?$(0Z](B . ?\x7C37) ;; <CJK>
     (?$(0Z^(B . ?\x7C40) ;; <CJK>
     (?$(0Z_(B . ?\x7E6B) ;; <CJK>
     (?$(0Z`(B . ?\x7E6D) ;; <CJK>
     (?$(0Za(B . ?\x7E79) ;; <CJK>
     (?$(0Zb(B . ?\x7E69) ;; <CJK>
     (?$(0Zc(B . ?\x7E6A) ;; <CJK>
     (?$(0Zd(B . ?\x7F85) ;; <CJK>
     (?$(0Ze(B . ?\x7E73) ;; <CJK>
     (?$(0Zf(B . ?\x7FB6) ;; <CJK>
     (?$(0Zg(B . ?\x7FB9) ;; <CJK>
     (?$(0Zh(B . ?\x7FB8) ;; <CJK>
     (?$(0Zi(B . ?\x81D8) ;; <CJK>
     (?$(0Zj(B . ?\x85E9) ;; <CJK>
     (?$(0Zk(B . ?\x85DD) ;; <CJK>
     (?$(0Zl(B . ?\x85EA) ;; <CJK>
     (?$(0Zm(B . ?\x85D5) ;; <CJK>
     (?$(0Zn(B . ?\x85E4) ;; <CJK>
     (?$(0Zo(B . ?\x85E5) ;; <CJK>
     (?$(0Zp(B . ?\x85F7) ;; <CJK>
     (?$(0Zq(B . ?\x87FB) ;; <CJK>
     (?$(0Zr(B . ?\x8805) ;; <CJK>
     (?$(0Zs(B . ?\x880D) ;; <CJK>
     (?$(0Zt(B . ?\x87F9) ;; <CJK>
     (?$(0Zu(B . ?\x87FE) ;; <CJK>
     (?$(0Zv(B . ?\x8960) ;; <CJK>
     (?$(0Zw(B . ?\x895F) ;; <CJK>
     (?$(0Zx(B . ?\x8956) ;; <CJK>
     (?$(0Zy(B . ?\x895E) ;; <CJK>
     (?$(0Zz(B . ?\x8B41) ;; <CJK>
     (?$(0Z{(B . ?\x8B5C) ;; <CJK>
     (?$(0Z|(B . ?\x8B58) ;; <CJK>
     (?$(0Z}(B . ?\x8B49) ;; <CJK>
     (?$(0Z~(B . ?\x8B5A) ;; <CJK>
     (?$(0[!(B . ?\x8B4E) ;; <CJK>
     (?$(0["(B . ?\x8B4F) ;; <CJK>
     (?$(0[#(B . ?\x8B46) ;; <CJK>
     (?$(0[$(B . ?\x8B59) ;; <CJK>
     (?$(0[%(B . ?\x8D08) ;; <CJK>
     (?$(0[&(B . ?\x8D0A) ;; <CJK>
     (?$(0['(B . ?\x8E7C) ;; <CJK>
     (?$(0[((B . ?\x8E72) ;; <CJK>
     (?$(0[)(B . ?\x8E87) ;; <CJK>
     (?$(0[*(B . ?\x8E76) ;; <CJK>
     (?$(0[+(B . ?\x8E6C) ;; <CJK>
     (?$(0[,(B . ?\x8E7A) ;; <CJK>
     (?$(0[-(B . ?\x8E74) ;; <CJK>
     (?$(0[.(B . ?\x8F54) ;; <CJK>
     (?$(0[/(B . ?\x8F4E) ;; <CJK>
     (?$(0[0(B . ?\x8FAD) ;; <CJK>
     (?$(0[1(B . ?\x908A) ;; <CJK>
     (?$(0[2(B . ?\x908B) ;; <CJK>
     (?$(0[3(B . ?\x91B1) ;; <CJK>
     (?$(0[4(B . ?\x91AE) ;; <CJK>
     (?$(0[5(B . ?\x93E1) ;; <CJK>
     (?$(0[6(B . ?\x93D1) ;; <CJK>
     (?$(0[7(B . ?\x93DF) ;; <CJK>
     (?$(0[8(B . ?\x93C3) ;; <CJK>
     (?$(0[9(B . ?\x93C8) ;; <CJK>
     (?$(0[:(B . ?\x93DC) ;; <CJK>
     (?$(0[;(B . ?\x93DD) ;; <CJK>
     (?$(0[<(B . ?\x93D6) ;; <CJK>
     (?$(0[=(B . ?\x93E2) ;; <CJK>
     (?$(0[>(B . ?\x93CD) ;; <CJK>
     (?$(0[?(B . ?\x93D8) ;; <CJK>
     (?$(0[@(B . ?\x93E4) ;; <CJK>
     (?$(0[A(B . ?\x93D7) ;; <CJK>
     (?$(0[B(B . ?\x93E8) ;; <CJK>
     (?$(0[C(B . ?\x95DC) ;; <CJK>
     (?$(0[D(B . ?\x96B4) ;; <CJK>
     (?$(0[E(B . ?\x96E3) ;; <CJK>
     (?$(0[F(B . ?\x972A) ;; <CJK>
     (?$(0[G(B . ?\x9727) ;; <CJK>
     (?$(0[H(B . ?\x9761) ;; <CJK>
     (?$(0[I(B . ?\x97DC) ;; <CJK>
     (?$(0[J(B . ?\x97FB) ;; <CJK>
     (?$(0[K(B . ?\x985E) ;; <CJK>
     (?$(0[L(B . ?\x9858) ;; <CJK>
     (?$(0[M(B . ?\x985B) ;; <CJK>
     (?$(0[N(B . ?\x98BC) ;; <CJK>
     (?$(0[O(B . ?\x9945) ;; <CJK>
     (?$(0[P(B . ?\x9949) ;; <CJK>
     (?$(0[Q(B . ?\x9A16) ;; <CJK>
     (?$(0[R(B . ?\x9A19) ;; <CJK>
     (?$(0[S(B . ?\x9B0D) ;; <CJK>
     (?$(0[T(B . ?\x9BE8) ;; <CJK>
     (?$(0[U(B . ?\x9BE7) ;; <CJK>
     (?$(0[V(B . ?\x9BD6) ;; <CJK>
     (?$(0[W(B . ?\x9BDB) ;; <CJK>
     (?$(0[X(B . ?\x9D89) ;; <CJK>
     (?$(0[Y(B . ?\x9D61) ;; <CJK>
     (?$(0[Z(B . ?\x9D72) ;; <CJK>
     (?$(0[[(B . ?\x9D6A) ;; <CJK>
     (?$(0[\(B . ?\x9D6C) ;; <CJK>
     (?$(0[](B . ?\x9E92) ;; <CJK>
     (?$(0[^(B . ?\x9E97) ;; <CJK>
     (?$(0[_(B . ?\x9E93) ;; <CJK>
     (?$(0[`(B . ?\x9EB4) ;; <CJK>
     (?$(0[a(B . ?\x52F8) ;; <CJK>
     (?$(0[b(B . ?\x56A8) ;; <CJK>
     (?$(0[c(B . ?\x56B7) ;; <CJK>
     (?$(0[d(B . ?\x56B6) ;; <CJK>
     (?$(0[e(B . ?\x56B4) ;; <CJK>
     (?$(0[f(B . ?\x56BC) ;; <CJK>
     (?$(0[g(B . ?\x58E4) ;; <CJK>
     (?$(0[h(B . ?\x5B40) ;; <CJK>
     (?$(0[i(B . ?\x5B43) ;; <CJK>
     (?$(0[j(B . ?\x5B7D) ;; <CJK>
     (?$(0[k(B . ?\x5BF6) ;; <CJK>
     (?$(0[l(B . ?\x5DC9) ;; <CJK>
     (?$(0[m(B . ?\x61F8) ;; <CJK>
     (?$(0[n(B . ?\x61FA) ;; <CJK>
     (?$(0[o(B . ?\x6518) ;; <CJK>
     (?$(0[p(B . ?\x6514) ;; <CJK>
     (?$(0[q(B . ?\x6519) ;; <CJK>
     (?$(0[r(B . ?\x66E6) ;; <CJK>
     (?$(0[s(B . ?\x6727) ;; <CJK>
     (?$(0[t(B . ?\x6AEC) ;; <CJK>
     (?$(0[u(B . ?\x703E) ;; <CJK>
     (?$(0[v(B . ?\x7030) ;; <CJK>
     (?$(0[w(B . ?\x7032) ;; <CJK>
     (?$(0[x(B . ?\x7210) ;; <CJK>
     (?$(0[y(B . ?\x737B) ;; <CJK>
     (?$(0[z(B . ?\x74CF) ;; <CJK>
     (?$(0[{(B . ?\x7662) ;; <CJK>
     (?$(0[|(B . ?\x7665) ;; <CJK>
     (?$(0[}(B . ?\x7926) ;; <CJK>
     (?$(0[~(B . ?\x792A) ;; <CJK>
     (?$(0\!(B . ?\x792C) ;; <CJK>
     (?$(0\"(B . ?\x792B) ;; <CJK>
     (?$(0\#(B . ?\x7AC7) ;; <CJK>
     (?$(0\$(B . ?\x7AF6) ;; <CJK>
     (?$(0\%(B . ?\x7C4C) ;; <CJK>
     (?$(0\&(B . ?\x7C43) ;; <CJK>
     (?$(0\'(B . ?\x7C4D) ;; <CJK>
     (?$(0\((B . ?\x7CEF) ;; <CJK>
     (?$(0\)(B . ?\x7CF0) ;; <CJK>
     (?$(0\*(B . ?\x8FAE) ;; <CJK>
     (?$(0\+(B . ?\x7E7D) ;; <CJK>
     (?$(0\,(B . ?\x7E7C) ;; <CJK>
     (?$(0\-(B . ?\x7E82) ;; <CJK>
     (?$(0\.(B . ?\x7F4C) ;; <CJK>
     (?$(0\/(B . ?\x8000) ;; <CJK>
     (?$(0\0(B . ?\x81DA) ;; <CJK>
     (?$(0\1(B . ?\x8266) ;; <CJK>
     (?$(0\2(B . ?\x85FB) ;; <CJK>
     (?$(0\3(B . ?\x85F9) ;; <CJK>
     (?$(0\4(B . ?\x8611) ;; <CJK>
     (?$(0\5(B . ?\x85FA) ;; <CJK>
     (?$(0\6(B . ?\x8606) ;; <CJK>
     (?$(0\7(B . ?\x860B) ;; <CJK>
     (?$(0\8(B . ?\x8607) ;; <CJK>
     (?$(0\9(B . ?\x860A) ;; <CJK>
     (?$(0\:(B . ?\x8814) ;; <CJK>
     (?$(0\;(B . ?\x8815) ;; <CJK>
     (?$(0\<(B . ?\x8964) ;; <CJK>
     (?$(0\=(B . ?\x89BA) ;; <CJK>
     (?$(0\>(B . ?\x89F8) ;; <CJK>
     (?$(0\?(B . ?\x8B70) ;; <CJK>
     (?$(0\@(B . ?\x8B6C) ;; <CJK>
     (?$(0\A(B . ?\x8B66) ;; <CJK>
     (?$(0\B(B . ?\x8B6F) ;; <CJK>
     (?$(0\C(B . ?\x8B5F) ;; <CJK>
     (?$(0\D(B . ?\x8B6B) ;; <CJK>
     (?$(0\E(B . ?\x8D0F) ;; <CJK>
     (?$(0\F(B . ?\x8D0D) ;; <CJK>
     (?$(0\G(B . ?\x8E89) ;; <CJK>
     (?$(0\H(B . ?\x8E81) ;; <CJK>
     (?$(0\I(B . ?\x8E85) ;; <CJK>
     (?$(0\J(B . ?\x8E82) ;; <CJK>
     (?$(0\K(B . ?\x91B4) ;; <CJK>
     (?$(0\L(B . ?\x91CB) ;; <CJK>
     (?$(0\M(B . ?\x9418) ;; <CJK>
     (?$(0\N(B . ?\x9403) ;; <CJK>
     (?$(0\O(B . ?\x93FD) ;; <CJK>
     (?$(0\P(B . ?\x95E1) ;; <CJK>
     (?$(0\Q(B . ?\x9730) ;; <CJK>
     (?$(0\R(B . ?\x98C4) ;; <CJK>
     (?$(0\S(B . ?\x9952) ;; <CJK>
     (?$(0\T(B . ?\x9951) ;; <CJK>
     (?$(0\U(B . ?\x99A8) ;; <CJK>
     (?$(0\V(B . ?\x9A2B) ;; <CJK>
     (?$(0\W(B . ?\x9A30) ;; <CJK>
     (?$(0\X(B . ?\x9A37) ;; <CJK>
     (?$(0\Y(B . ?\x9A35) ;; <CJK>
     (?$(0\Z(B . ?\x9C13) ;; <CJK>
     (?$(0\[(B . ?\x9C0D) ;; <CJK>
     (?$(0\\(B . ?\x9E79) ;; <CJK>
     (?$(0\](B . ?\x9EB5) ;; <CJK>
     (?$(0\^(B . ?\x9EE8) ;; <CJK>
     (?$(0\_(B . ?\x9F2F) ;; <CJK>
     (?$(0\`(B . ?\x9F5F) ;; <CJK>
     (?$(0\a(B . ?\x9F63) ;; <CJK>
     (?$(0\b(B . ?\x9F61) ;; <CJK>
     (?$(0\c(B . ?\x5137) ;; <CJK>
     (?$(0\d(B . ?\x5138) ;; <CJK>
     (?$(0\e(B . ?\x56C1) ;; <CJK>
     (?$(0\f(B . ?\x56C0) ;; <CJK>
     (?$(0\g(B . ?\x56C2) ;; <CJK>
     (?$(0\h(B . ?\x5914) ;; <CJK>
     (?$(0\i(B . ?\x5C6C) ;; <CJK>
     (?$(0\j(B . ?\x5DCD) ;; <CJK>
     (?$(0\k(B . ?\x61FC) ;; <CJK>
     (?$(0\l(B . ?\x61FE) ;; <CJK>
     (?$(0\m(B . ?\x651D) ;; <CJK>
     (?$(0\n(B . ?\x651C) ;; <CJK>
     (?$(0\o(B . ?\x6595) ;; <CJK>
     (?$(0\p(B . ?\x66E9) ;; <CJK>
     (?$(0\q(B . ?\x6AFB) ;; <CJK>
     (?$(0\r(B . ?\x6B04) ;; <CJK>
     (?$(0\s(B . ?\x6AFA) ;; <CJK>
     (?$(0\t(B . ?\x6BB2) ;; <CJK>
     (?$(0\u(B . ?\x704C) ;; <CJK>
     (?$(0\v(B . ?\x721B) ;; <CJK>
     (?$(0\w(B . ?\x72A7) ;; <CJK>
     (?$(0\x(B . ?\x74D6) ;; <CJK>
     (?$(0\y(B . ?\x74D4) ;; <CJK>
     (?$(0\z(B . ?\x7669) ;; <CJK>
     (?$(0\{(B . ?\x77D3) ;; <CJK>
     (?$(0\|(B . ?\x7C50) ;; <CJK>
     (?$(0\}(B . ?\x7E8F) ;; <CJK>
     (?$(0\~(B . ?\x7E8C) ;; <CJK>
     (?$(0]!(B . ?\x7FBC) ;; <CJK>
     (?$(0]"(B . ?\x8617) ;; <CJK>
     (?$(0]#(B . ?\x862D) ;; <CJK>
     (?$(0]$(B . ?\x861A) ;; <CJK>
     (?$(0]%(B . ?\x8823) ;; <CJK>
     (?$(0]&(B . ?\x8822) ;; <CJK>
     (?$(0]'(B . ?\x8821) ;; <CJK>
     (?$(0]((B . ?\x881F) ;; <CJK>
     (?$(0])(B . ?\x896A) ;; <CJK>
     (?$(0]*(B . ?\x896C) ;; <CJK>
     (?$(0]+(B . ?\x89BD) ;; <CJK>
     (?$(0],(B . ?\x8B74) ;; <CJK>
     (?$(0]-(B . ?\x8B77) ;; <CJK>
     (?$(0].(B . ?\x8B7D) ;; <CJK>
     (?$(0]/(B . ?\x8D13) ;; <CJK>
     (?$(0]0(B . ?\x8E8A) ;; <CJK>
     (?$(0]1(B . ?\x8E8D) ;; <CJK>
     (?$(0]2(B . ?\x8E8B) ;; <CJK>
     (?$(0]3(B . ?\x8F5F) ;; <CJK>
     (?$(0]4(B . ?\x8FAF) ;; <CJK>
     (?$(0]5(B . ?\x91BA) ;; <CJK>
     (?$(0]6(B . ?\x942E) ;; <CJK>
     (?$(0]7(B . ?\x9433) ;; <CJK>
     (?$(0]8(B . ?\x9435) ;; <CJK>
     (?$(0]9(B . ?\x943A) ;; <CJK>
     (?$(0]:(B . ?\x9438) ;; <CJK>
     (?$(0];(B . ?\x9432) ;; <CJK>
     (?$(0]<(B . ?\x942B) ;; <CJK>
     (?$(0]=(B . ?\x95E2) ;; <CJK>
     (?$(0]>(B . ?\x9738) ;; <CJK>
     (?$(0]?(B . ?\x9739) ;; <CJK>
     (?$(0]@(B . ?\x9732) ;; <CJK>
     (?$(0]A(B . ?\x97FF) ;; <CJK>
     (?$(0]B(B . ?\x9867) ;; <CJK>
     (?$(0]C(B . ?\x9865) ;; <CJK>
     (?$(0]D(B . ?\x9957) ;; <CJK>
     (?$(0]E(B . ?\x9A45) ;; <CJK>
     (?$(0]F(B . ?\x9A43) ;; <CJK>
     (?$(0]G(B . ?\x9A40) ;; <CJK>
     (?$(0]H(B . ?\x9A3E) ;; <CJK>
     (?$(0]I(B . ?\x9ACF) ;; <CJK>
     (?$(0]J(B . ?\x9B54) ;; <CJK>
     (?$(0]K(B . ?\x9B51) ;; <CJK>
     (?$(0]L(B . ?\x9C2D) ;; <CJK>
     (?$(0]M(B . ?\x9C25) ;; <CJK>
     (?$(0]N(B . ?\x9DAF) ;; <CJK>
     (?$(0]O(B . ?\x9DB4) ;; <CJK>
     (?$(0]P(B . ?\x9DC2) ;; <CJK>
     (?$(0]Q(B . ?\x9DB8) ;; <CJK>
     (?$(0]R(B . ?\x9E9D) ;; <CJK>
     (?$(0]S(B . ?\x9EEF) ;; <CJK>
     (?$(0]T(B . ?\x9F19) ;; <CJK>
     (?$(0]U(B . ?\x9F5C) ;; <CJK>
     (?$(0]V(B . ?\x9F66) ;; <CJK>
     (?$(0]W(B . ?\x9F67) ;; <CJK>
     (?$(0]X(B . ?\x513C) ;; <CJK>
     (?$(0]Y(B . ?\x513B) ;; <CJK>
     (?$(0]Z(B . ?\x56C8) ;; <CJK>
     (?$(0][(B . ?\x56CA) ;; <CJK>
     (?$(0]\(B . ?\x56C9) ;; <CJK>
     (?$(0]](B . ?\x5B7F) ;; <CJK>
     (?$(0]^(B . ?\x5DD4) ;; <CJK>
     (?$(0]_(B . ?\x5DD2) ;; <CJK>
     (?$(0]`(B . ?\x5F4E) ;; <CJK>
     (?$(0]a(B . ?\x61FF) ;; <CJK>
     (?$(0]b(B . ?\x6524) ;; <CJK>
     (?$(0]c(B . ?\x6B0A) ;; <CJK>
     (?$(0]d(B . ?\x6B61) ;; <CJK>
     (?$(0]e(B . ?\x7051) ;; <CJK>
     (?$(0]f(B . ?\x7058) ;; <CJK>
     (?$(0]g(B . ?\x7380) ;; <CJK>
     (?$(0]h(B . ?\x74E4) ;; <CJK>
     (?$(0]i(B . ?\x758A) ;; <CJK>
     (?$(0]j(B . ?\x766E) ;; <CJK>
     (?$(0]k(B . ?\x766C) ;; <CJK>
     (?$(0]l(B . ?\x79B3) ;; <CJK>
     (?$(0]m(B . ?\x7C60) ;; <CJK>
     (?$(0]n(B . ?\x7C5F) ;; <CJK>
     (?$(0]o(B . ?\x807E) ;; <CJK>
     (?$(0]p(B . ?\x807D) ;; <CJK>
     (?$(0]q(B . ?\x81DF) ;; <CJK>
     (?$(0]r(B . ?\x8972) ;; <CJK>
     (?$(0]s(B . ?\x896F) ;; <CJK>
     (?$(0]t(B . ?\x89FC) ;; <CJK>
     (?$(0]u(B . ?\x8B80) ;; <CJK>
     (?$(0]v(B . ?\x8D16) ;; <CJK>
     (?$(0]w(B . ?\x8D17) ;; <CJK>
     (?$(0]x(B . ?\x8E91) ;; <CJK>
     (?$(0]y(B . ?\x8E93) ;; <CJK>
     (?$(0]z(B . ?\x8F61) ;; <CJK>
     (?$(0]{(B . ?\x9148) ;; <CJK>
     (?$(0]|(B . ?\x9444) ;; <CJK>
     (?$(0]}(B . ?\x9451) ;; <CJK>
     (?$(0]~(B . ?\x9452) ;; <CJK>
     (?$(0^!(B . ?\x973D) ;; <CJK>
     (?$(0^"(B . ?\x973E) ;; <CJK>
     (?$(0^#(B . ?\x97C3) ;; <CJK>
     (?$(0^$(B . ?\x97C1) ;; <CJK>
     (?$(0^%(B . ?\x986B) ;; <CJK>
     (?$(0^&(B . ?\x9955) ;; <CJK>
     (?$(0^'(B . ?\x9A55) ;; <CJK>
     (?$(0^((B . ?\x9A4D) ;; <CJK>
     (?$(0^)(B . ?\x9AD2) ;; <CJK>
     (?$(0^*(B . ?\x9B1A) ;; <CJK>
     (?$(0^+(B . ?\x9C49) ;; <CJK>
     (?$(0^,(B . ?\x9C31) ;; <CJK>
     (?$(0^-(B . ?\x9C3E) ;; <CJK>
     (?$(0^.(B . ?\x9C3B) ;; <CJK>
     (?$(0^/(B . ?\x9DD3) ;; <CJK>
     (?$(0^0(B . ?\x9DD7) ;; <CJK>
     (?$(0^1(B . ?\x9F34) ;; <CJK>
     (?$(0^2(B . ?\x9F6C) ;; <CJK>
     (?$(0^3(B . ?\x9F6A) ;; <CJK>
     (?$(0^4(B . ?\x9F94) ;; <CJK>
     (?$(0^5(B . ?\x56CC) ;; <CJK>
     (?$(0^6(B . ?\x5DD6) ;; <CJK>
     (?$(0^7(B . ?\x6200) ;; <CJK>
     (?$(0^8(B . ?\x6523) ;; <CJK>
     (?$(0^9(B . ?\x652B) ;; <CJK>
     (?$(0^:(B . ?\x652A) ;; <CJK>
     (?$(0^;(B . ?\x66EC) ;; <CJK>
     (?$(0^<(B . ?\x6B10) ;; <CJK>
     (?$(0^=(B . ?\x74DA) ;; <CJK>
     (?$(0^>(B . ?\x7ACA) ;; <CJK>
     (?$(0^?(B . ?\x7C64) ;; <CJK>
     (?$(0^@(B . ?\x7C63) ;; <CJK>
     (?$(0^A(B . ?\x7C65) ;; <CJK>
     (?$(0^B(B . ?\x7E93) ;; <CJK>
     (?$(0^C(B . ?\x7E96) ;; <CJK>
     (?$(0^D(B . ?\x7E94) ;; <CJK>
     (?$(0^E(B . ?\x81E2) ;; <CJK>
     (?$(0^F(B . ?\x8638) ;; <CJK>
     (?$(0^G(B . ?\x863F) ;; <CJK>
     (?$(0^H(B . ?\x8831) ;; <CJK>
     (?$(0^I(B . ?\x8B8A) ;; <CJK>
     (?$(0^J(B . ?\x9090) ;; <CJK>
     (?$(0^K(B . ?\x908F) ;; <CJK>
     (?$(0^L(B . ?\x9463) ;; <CJK>
     (?$(0^M(B . ?\x9460) ;; <CJK>
     (?$(0^N(B . ?\x9464) ;; <CJK>
     (?$(0^O(B . ?\x9768) ;; <CJK>
     (?$(0^P(B . ?\x986F) ;; <CJK>
     (?$(0^Q(B . ?\x995C) ;; <CJK>
     (?$(0^R(B . ?\x9A5A) ;; <CJK>
     (?$(0^S(B . ?\x9A5B) ;; <CJK>
     (?$(0^T(B . ?\x9A57) ;; <CJK>
     (?$(0^U(B . ?\x9AD3) ;; <CJK>
     (?$(0^V(B . ?\x9AD4) ;; <CJK>
     (?$(0^W(B . ?\x9AD1) ;; <CJK>
     (?$(0^X(B . ?\x9C54) ;; <CJK>
     (?$(0^Y(B . ?\x9C57) ;; <CJK>
     (?$(0^Z(B . ?\x9C56) ;; <CJK>
     (?$(0^[(B . ?\x9DE5) ;; <CJK>
     (?$(0^\(B . ?\x9E9F) ;; <CJK>
     (?$(0^](B . ?\x9EF4) ;; <CJK>
     (?$(0^^(B . ?\x56D1) ;; <CJK>
     (?$(0^_(B . ?\x58E9) ;; <CJK>
     (?$(0^`(B . ?\x652C) ;; <CJK>
     (?$(0^a(B . ?\x705E) ;; <CJK>
     (?$(0^b(B . ?\x7671) ;; <CJK>
     (?$(0^c(B . ?\x7672) ;; <CJK>
     (?$(0^d(B . ?\x77D7) ;; <CJK>
     (?$(0^e(B . ?\x7F50) ;; <CJK>
     (?$(0^f(B . ?\x7F88) ;; <CJK>
     (?$(0^g(B . ?\x8836) ;; <CJK>
     (?$(0^h(B . ?\x8839) ;; <CJK>
     (?$(0^i(B . ?\x8862) ;; <CJK>
     (?$(0^j(B . ?\x8B93) ;; <CJK>
     (?$(0^k(B . ?\x8B92) ;; <CJK>
     (?$(0^l(B . ?\x8B96) ;; <CJK>
     (?$(0^m(B . ?\x8277) ;; <CJK>
     (?$(0^n(B . ?\x8D1B) ;; <CJK>
     (?$(0^o(B . ?\x91C0) ;; <CJK>
     (?$(0^p(B . ?\x946A) ;; <CJK>
     (?$(0^q(B . ?\x9742) ;; <CJK>
     (?$(0^r(B . ?\x9748) ;; <CJK>
     (?$(0^s(B . ?\x9744) ;; <CJK>
     (?$(0^t(B . ?\x97C6) ;; <CJK>
     (?$(0^u(B . ?\x9870) ;; <CJK>
     (?$(0^v(B . ?\x9A5F) ;; <CJK>
     (?$(0^w(B . ?\x9B22) ;; <CJK>
     (?$(0^x(B . ?\x9B58) ;; <CJK>
     (?$(0^y(B . ?\x9C5F) ;; <CJK>
     (?$(0^z(B . ?\x9DF9) ;; <CJK>
     (?$(0^{(B . ?\x9DFA) ;; <CJK>
     (?$(0^|(B . ?\x9E7C) ;; <CJK>
     (?$(0^}(B . ?\x9E7D) ;; <CJK>
     (?$(0^~(B . ?\x9F07) ;; <CJK>
     (?$(0_!(B . ?\x9F77) ;; <CJK>
     (?$(0_"(B . ?\x9F72) ;; <CJK>
     (?$(0_#(B . ?\x5EF3) ;; <CJK>
     (?$(0_$(B . ?\x6B16) ;; <CJK>
     (?$(0_%(B . ?\x7063) ;; <CJK>
     (?$(0_&(B . ?\x7C6C) ;; <CJK>
     (?$(0_'(B . ?\x7C6E) ;; <CJK>
     (?$(0_((B . ?\x883B) ;; <CJK>
     (?$(0_)(B . ?\x89C0) ;; <CJK>
     (?$(0_*(B . ?\x8EA1) ;; <CJK>
     (?$(0_+(B . ?\x91C1) ;; <CJK>
     (?$(0_,(B . ?\x9472) ;; <CJK>
     (?$(0_-(B . ?\x9470) ;; <CJK>
     (?$(0_.(B . ?\x9871) ;; <CJK>
     (?$(0_/(B . ?\x995E) ;; <CJK>
     (?$(0_0(B . ?\x9AD6) ;; <CJK>
     (?$(0_1(B . ?\x9B23) ;; <CJK>
     (?$(0_2(B . ?\x9ECC) ;; <CJK>
     (?$(0_3(B . ?\x7064) ;; <CJK>
     (?$(0_4(B . ?\x77DA) ;; <CJK>
     (?$(0_5(B . ?\x8B9A) ;; <CJK>
     (?$(0_6(B . ?\x9477) ;; <CJK>
     (?$(0_7(B . ?\x97C9) ;; <CJK>
     (?$(0_8(B . ?\x9A62) ;; <CJK>
     (?$(0_9(B . ?\x9A65) ;; <CJK>
     (?$(0_:(B . ?\x7E9C) ;; <CJK>
     (?$(0_;(B . ?\x8B9C) ;; <CJK>
     (?$(0_<(B . ?\x8EAA) ;; <CJK>
     (?$(0_=(B . ?\x91C5) ;; <CJK>
     (?$(0_>(B . ?\x947D) ;; <CJK>
     (?$(0_?(B . ?\x947E) ;; <CJK>
     (?$(0_@(B . ?\x947C) ;; <CJK>
     (?$(0_A(B . ?\x9C77) ;; <CJK>
     (?$(0_B(B . ?\x9C78) ;; <CJK>
     (?$(0_C(B . ?\x9EF7) ;; <CJK>
     (?$(0_D(B . ?\x8C54) ;; <CJK>
     (?$(0_E(B . ?\x947F) ;; <CJK>
     (?$(0_F(B . ?\x9E1A) ;; <CJK>
     (?$(0_G(B . ?\x7228) ;; <CJK>
     (?$(0_H(B . ?\x9A6A) ;; <CJK>
     (?$(0_I(B . ?\x9B31) ;; <CJK>
     (?$(0_J(B . ?\x9E1B) ;; <CJK>
     (?$(0_K(B . ?\x9E1E) ;; <CJK>
     (?$(0_L(B . ?\x7C72) ;; <CJK>
     (?$(0_M(B . ?\x30FE) ;; KATAKANA VOICED ITERATION MARK
     (?$(0_N(B . ?\x309D) ;; HIRAGANA ITERATION MARK
     (?$(0_O(B . ?\x309E) ;; HIRAGANA VOICED ITERATION MARK
     (?$(0_P(B . ?\x3005) ;; IDEOGRAPHIC ITERATION MARK
     (?$(0_Q(B . ?\x3041) ;; HIRAGANA LETTER SMALL A
     (?$(0_R(B . ?\x3042) ;; HIRAGANA LETTER A
     (?$(0_S(B . ?\x3043) ;; HIRAGANA LETTER SMALL I
     (?$(0_T(B . ?\x3044) ;; HIRAGANA LETTER I
     (?$(0_U(B . ?\x3045) ;; HIRAGANA LETTER SMALL U
     (?$(0_V(B . ?\x3046) ;; HIRAGANA LETTER U
     (?$(0_W(B . ?\x3047) ;; HIRAGANA LETTER SMALL E
     (?$(0_X(B . ?\x3048) ;; HIRAGANA LETTER E
     (?$(0_Y(B . ?\x3049) ;; HIRAGANA LETTER SMALL O
     (?$(0_Z(B . ?\x304A) ;; HIRAGANA LETTER O
     (?$(0_[(B . ?\x304B) ;; HIRAGANA LETTER KA
     (?$(0_\(B . ?\x304C) ;; HIRAGANA LETTER GA
     (?$(0_](B . ?\x304D) ;; HIRAGANA LETTER KI
     (?$(0_^(B . ?\x304E) ;; HIRAGANA LETTER GI
     (?$(0__(B . ?\x304F) ;; HIRAGANA LETTER KU
     (?$(0_`(B . ?\x3050) ;; HIRAGANA LETTER GU
     (?$(0_a(B . ?\x3051) ;; HIRAGANA LETTER KE
     (?$(0_b(B . ?\x3052) ;; HIRAGANA LETTER GE
     (?$(0_c(B . ?\x3053) ;; HIRAGANA LETTER KO
     (?$(0_d(B . ?\x3054) ;; HIRAGANA LETTER GO
     (?$(0_e(B . ?\x3055) ;; HIRAGANA LETTER SA
     (?$(0_f(B . ?\x3056) ;; HIRAGANA LETTER ZA
     (?$(0_g(B . ?\x3057) ;; HIRAGANA LETTER SI
     (?$(0_h(B . ?\x3058) ;; HIRAGANA LETTER ZI
     (?$(0_i(B . ?\x3059) ;; HIRAGANA LETTER SU
     (?$(0_j(B . ?\x305A) ;; HIRAGANA LETTER ZU
     (?$(0_k(B . ?\x305B) ;; HIRAGANA LETTER SE
     (?$(0_l(B . ?\x305C) ;; HIRAGANA LETTER ZE
     (?$(0_m(B . ?\x305D) ;; HIRAGANA LETTER SO
     (?$(0_n(B . ?\x305E) ;; HIRAGANA LETTER ZO
     (?$(0_o(B . ?\x305F) ;; HIRAGANA LETTER TA
     (?$(0_p(B . ?\x3060) ;; HIRAGANA LETTER DA
     (?$(0_q(B . ?\x3061) ;; HIRAGANA LETTER TI
     (?$(0_r(B . ?\x3062) ;; HIRAGANA LETTER DI
     (?$(0_s(B . ?\x3063) ;; HIRAGANA LETTER SMALL TU
     (?$(0_t(B . ?\x3064) ;; HIRAGANA LETTER TU
     (?$(0_u(B . ?\x3065) ;; HIRAGANA LETTER DU
     (?$(0_v(B . ?\x3066) ;; HIRAGANA LETTER TE
     (?$(0_w(B . ?\x3067) ;; HIRAGANA LETTER DE
     (?$(0_x(B . ?\x3068) ;; HIRAGANA LETTER TO
     (?$(0_y(B . ?\x3069) ;; HIRAGANA LETTER DO
     (?$(0_z(B . ?\x306A) ;; HIRAGANA LETTER NA
     (?$(0_{(B . ?\x306B) ;; HIRAGANA LETTER NI
     (?$(0_|(B . ?\x306C) ;; HIRAGANA LETTER NU
     (?$(0_}(B . ?\x306D) ;; HIRAGANA LETTER NE
     (?$(0_~(B . ?\x306E) ;; HIRAGANA LETTER NO
     (?$(0`!(B . ?\x306F) ;; HIRAGANA LETTER HA
     (?$(0`"(B . ?\x3070) ;; HIRAGANA LETTER BA
     (?$(0`#(B . ?\x3071) ;; HIRAGANA LETTER PA
     (?$(0`$(B . ?\x3072) ;; HIRAGANA LETTER HI
     (?$(0`%(B . ?\x3073) ;; HIRAGANA LETTER BI
     (?$(0`&(B . ?\x3074) ;; HIRAGANA LETTER PI
     (?$(0`'(B . ?\x3075) ;; HIRAGANA LETTER HU
     (?$(0`((B . ?\x3076) ;; HIRAGANA LETTER BU
     (?$(0`)(B . ?\x3077) ;; HIRAGANA LETTER PU
     (?$(0`*(B . ?\x3078) ;; HIRAGANA LETTER HE
     (?$(0`+(B . ?\x3079) ;; HIRAGANA LETTER BE
     (?$(0`,(B . ?\x307A) ;; HIRAGANA LETTER PE
     (?$(0`-(B . ?\x307B) ;; HIRAGANA LETTER HO
     (?$(0`.(B . ?\x307C) ;; HIRAGANA LETTER BO
     (?$(0`/(B . ?\x307D) ;; HIRAGANA LETTER PO
     (?$(0`0(B . ?\x307E) ;; HIRAGANA LETTER MA
     (?$(0`1(B . ?\x307F) ;; HIRAGANA LETTER MI
     (?$(0`2(B . ?\x3080) ;; HIRAGANA LETTER MU
     (?$(0`3(B . ?\x3081) ;; HIRAGANA LETTER ME
     (?$(0`4(B . ?\x3082) ;; HIRAGANA LETTER MO
     (?$(0`5(B . ?\x3083) ;; HIRAGANA LETTER SMALL YA
     (?$(0`6(B . ?\x3084) ;; HIRAGANA LETTER YA
     (?$(0`7(B . ?\x3085) ;; HIRAGANA LETTER SMALL YU
     (?$(0`8(B . ?\x3086) ;; HIRAGANA LETTER YU
     (?$(0`9(B . ?\x3087) ;; HIRAGANA LETTER SMALL YO
     (?$(0`:(B . ?\x3088) ;; HIRAGANA LETTER YO
     (?$(0`;(B . ?\x3089) ;; HIRAGANA LETTER RA
     (?$(0`<(B . ?\x308A) ;; HIRAGANA LETTER RI
     (?$(0`=(B . ?\x308B) ;; HIRAGANA LETTER RU
     (?$(0`>(B . ?\x308C) ;; HIRAGANA LETTER RE
     (?$(0`?(B . ?\x308D) ;; HIRAGANA LETTER RO
     (?$(0`@(B . ?\x308E) ;; HIRAGANA LETTER SMALL WA
     (?$(0`A(B . ?\x308F) ;; HIRAGANA LETTER WA
     (?$(0`B(B . ?\x3090) ;; HIRAGANA LETTER WI
     (?$(0`C(B . ?\x3091) ;; HIRAGANA LETTER WE
     (?$(0`D(B . ?\x3092) ;; HIRAGANA LETTER WO
     (?$(0`E(B . ?\x3093) ;; HIRAGANA LETTER N
     (?$(0`F(B . ?\x30A1) ;; KATAKANA LETTER SMALL A
     (?$(0`G(B . ?\x30A2) ;; KATAKANA LETTER A
     (?$(0`H(B . ?\x30A3) ;; KATAKANA LETTER SMALL I
     (?$(0`I(B . ?\x30A4) ;; KATAKANA LETTER I
     (?$(0`J(B . ?\x30A5) ;; KATAKANA LETTER SMALL U
     (?$(0`K(B . ?\x30A6) ;; KATAKANA LETTER U
     (?$(0`L(B . ?\x30A7) ;; KATAKANA LETTER SMALL E
     (?$(0`M(B . ?\x30A8) ;; KATAKANA LETTER E
     (?$(0`N(B . ?\x30A9) ;; KATAKANA LETTER SMALL O
     (?$(0`O(B . ?\x30AA) ;; KATAKANA LETTER O
     (?$(0`P(B . ?\x30AB) ;; KATAKANA LETTER KA
     (?$(0`Q(B . ?\x30AC) ;; KATAKANA LETTER GA
     (?$(0`R(B . ?\x30AD) ;; KATAKANA LETTER KI
     (?$(0`S(B . ?\x30AE) ;; KATAKANA LETTER GI
     (?$(0`T(B . ?\x30AF) ;; KATAKANA LETTER KU
     (?$(0`U(B . ?\x30B0) ;; KATAKANA LETTER GU
     (?$(0`V(B . ?\x30B1) ;; KATAKANA LETTER KE
     (?$(0`W(B . ?\x30B2) ;; KATAKANA LETTER GE
     (?$(0`X(B . ?\x30B3) ;; KATAKANA LETTER KO
     (?$(0`Y(B . ?\x30B4) ;; KATAKANA LETTER GO
     (?$(0`Z(B . ?\x30B5) ;; KATAKANA LETTER SA
     (?$(0`[(B . ?\x30B6) ;; KATAKANA LETTER ZA
     (?$(0`\(B . ?\x30B7) ;; KATAKANA LETTER SI
     (?$(0`](B . ?\x30B8) ;; KATAKANA LETTER ZI
     (?$(0`^(B . ?\x30B9) ;; KATAKANA LETTER SU
     (?$(0`_(B . ?\x30BA) ;; KATAKANA LETTER ZU
     (?$(0``(B . ?\x30BB) ;; KATAKANA LETTER SE
     (?$(0`a(B . ?\x30BC) ;; KATAKANA LETTER ZE
     (?$(0`b(B . ?\x30BD) ;; KATAKANA LETTER SO
     (?$(0`c(B . ?\x30BE) ;; KATAKANA LETTER ZO
     (?$(0`d(B . ?\x30BF) ;; KATAKANA LETTER TA
     (?$(0`e(B . ?\x30C0) ;; KATAKANA LETTER DA
     (?$(0`f(B . ?\x30C1) ;; KATAKANA LETTER TI
     (?$(0`g(B . ?\x30C2) ;; KATAKANA LETTER DI
     (?$(0`h(B . ?\x30C3) ;; KATAKANA LETTER SMALL TU
     (?$(0`i(B . ?\x30C4) ;; KATAKANA LETTER TU
     (?$(0`j(B . ?\x30C5) ;; KATAKANA LETTER DU
     (?$(0`k(B . ?\x30C6) ;; KATAKANA LETTER TE
     (?$(0`l(B . ?\x30C7) ;; KATAKANA LETTER DE
     (?$(0`m(B . ?\x30C8) ;; KATAKANA LETTER TO
     (?$(0`n(B . ?\x30C9) ;; KATAKANA LETTER DO
     (?$(0`o(B . ?\x30CA) ;; KATAKANA LETTER NA
     (?$(0`p(B . ?\x30CB) ;; KATAKANA LETTER NI
     (?$(0`q(B . ?\x30CC) ;; KATAKANA LETTER NU
     (?$(0`r(B . ?\x30CD) ;; KATAKANA LETTER NE
     (?$(0`s(B . ?\x30CE) ;; KATAKANA LETTER NO
     (?$(0`t(B . ?\x30CF) ;; KATAKANA LETTER HA
     (?$(0`u(B . ?\x30D0) ;; KATAKANA LETTER BA
     (?$(0`v(B . ?\x30D1) ;; KATAKANA LETTER PA
     (?$(0`w(B . ?\x30D2) ;; KATAKANA LETTER HI
     (?$(0`x(B . ?\x30D3) ;; KATAKANA LETTER BI
     (?$(0`y(B . ?\x30D4) ;; KATAKANA LETTER PI
     (?$(0`z(B . ?\x30D5) ;; KATAKANA LETTER HU
     (?$(0`{(B . ?\x30D6) ;; KATAKANA LETTER BU
     (?$(0`|(B . ?\x30D7) ;; KATAKANA LETTER PU
     (?$(0`}(B . ?\x30D8) ;; KATAKANA LETTER HE
     (?$(0`~(B . ?\x30D9) ;; KATAKANA LETTER BE
     (?$(0a!(B . ?\x30DA) ;; KATAKANA LETTER PE
     (?$(0a"(B . ?\x30DB) ;; KATAKANA LETTER HO
     (?$(0a#(B . ?\x30DC) ;; KATAKANA LETTER BO
     (?$(0a$(B . ?\x30DD) ;; KATAKANA LETTER PO
     (?$(0a%(B . ?\x30DE) ;; KATAKANA LETTER MA
     (?$(0a&(B . ?\x30DF) ;; KATAKANA LETTER MI
     (?$(0a'(B . ?\x30E0) ;; KATAKANA LETTER MU
     (?$(0a((B . ?\x30E1) ;; KATAKANA LETTER ME
     (?$(0a)(B . ?\x30E2) ;; KATAKANA LETTER MO
     (?$(0a*(B . ?\x30E3) ;; KATAKANA LETTER SMALL YA
     (?$(0a+(B . ?\x30E4) ;; KATAKANA LETTER YA
     (?$(0a,(B . ?\x30E5) ;; KATAKANA LETTER SMALL YU
     (?$(0a-(B . ?\x30E6) ;; KATAKANA LETTER YU
     (?$(0a.(B . ?\x30E7) ;; KATAKANA LETTER SMALL YO
     (?$(0a/(B . ?\x30E8) ;; KATAKANA LETTER YO
     (?$(0a0(B . ?\x30E9) ;; KATAKANA LETTER RA
     (?$(0a1(B . ?\x30EA) ;; KATAKANA LETTER RI
     (?$(0a2(B . ?\x30EB) ;; KATAKANA LETTER RU
     (?$(0a3(B . ?\x30EC) ;; KATAKANA LETTER RE
     (?$(0a4(B . ?\x30ED) ;; KATAKANA LETTER RO
     (?$(0a5(B . ?\x30EE) ;; KATAKANA LETTER SMALL WA
     (?$(0a6(B . ?\x30EF) ;; KATAKANA LETTER WA
     (?$(0a7(B . ?\x30F0) ;; KATAKANA LETTER WI
     (?$(0a8(B . ?\x30F1) ;; KATAKANA LETTER WE
     (?$(0a9(B . ?\x30F2) ;; KATAKANA LETTER WO
     (?$(0a:(B . ?\x30F3) ;; KATAKANA LETTER N
     (?$(0a;(B . ?\x30F4) ;; KATAKANA LETTER VU
     (?$(0a<(B . ?\x30F5) ;; KATAKANA LETTER SMALL KA
     (?$(0a=(B . ?\x30F6) ;; KATAKANA LETTER SMALL KE
     (?$(0a>(B . ?\x0414) ;; CYRILLIC CAPITAL LETTER DE
     (?$(0a?(B . ?\x0415) ;; CYRILLIC CAPITAL LETTER IE
     (?$(0a@(B . ?\x0401) ;; CYRILLIC CAPITAL LETTER IO
     (?$(0aA(B . ?\x0416) ;; CYRILLIC CAPITAL LETTER ZHE
     (?$(0aB(B . ?\x0417) ;; CYRILLIC CAPITAL LETTER ZE
     (?$(0aC(B . ?\x0418) ;; CYRILLIC CAPITAL LETTER I
     (?$(0aD(B . ?\x0419) ;; CYRILLIC CAPITAL LETTER SHORT I
     (?$(0aE(B . ?\x041A) ;; CYRILLIC CAPITAL LETTER KA
     (?$(0aF(B . ?\x041B) ;; CYRILLIC CAPITAL LETTER EL
     (?$(0aG(B . ?\x041C) ;; CYRILLIC CAPITAL LETTER EM
     (?$(0aH(B . ?\x0423) ;; CYRILLIC CAPITAL LETTER U
     (?$(0aI(B . ?\x0424) ;; CYRILLIC CAPITAL LETTER EF
     (?$(0aJ(B . ?\x0425) ;; CYRILLIC CAPITAL LETTER HA
     (?$(0aK(B . ?\x0426) ;; CYRILLIC CAPITAL LETTER TSE
     (?$(0aL(B . ?\x0427) ;; CYRILLIC CAPITAL LETTER CHE
     (?$(0aM(B . ?\x0428) ;; CYRILLIC CAPITAL LETTER SHA
     (?$(0aN(B . ?\x0429) ;; CYRILLIC CAPITAL LETTER SHCHA
     (?$(0aO(B . ?\x042A) ;; CYRILLIC CAPITAL LETTER HARD SIGN
     (?$(0aP(B . ?\x042B) ;; CYRILLIC CAPITAL LETTER YERU
     (?$(0aQ(B . ?\x042C) ;; CYRILLIC CAPITAL LETTER SOFT SIGN
     (?$(0aR(B . ?\x042D) ;; CYRILLIC CAPITAL LETTER E
     (?$(0aS(B . ?\x042E) ;; CYRILLIC CAPITAL LETTER YU
     (?$(0aT(B . ?\x042F) ;; CYRILLIC CAPITAL LETTER YA
     (?$(0aU(B . ?\x0430) ;; CYRILLIC SMALL LETTER A
     (?$(0aV(B . ?\x0431) ;; CYRILLIC SMALL LETTER BE
     (?$(0aW(B . ?\x0432) ;; CYRILLIC SMALL LETTER VE
     (?$(0aX(B . ?\x0433) ;; CYRILLIC SMALL LETTER GHE
     (?$(0aY(B . ?\x0434) ;; CYRILLIC SMALL LETTER DE
     (?$(0aZ(B . ?\x0435) ;; CYRILLIC SMALL LETTER IE
     (?$(0a[(B . ?\x0451) ;; CYRILLIC SMALL LETTER IO
     (?$(0a\(B . ?\x0436) ;; CYRILLIC SMALL LETTER ZHE
     (?$(0a](B . ?\x0437) ;; CYRILLIC SMALL LETTER ZE
     (?$(0a^(B . ?\x0438) ;; CYRILLIC SMALL LETTER I
     (?$(0a_(B . ?\x0439) ;; CYRILLIC SMALL LETTER SHORT I
     (?$(0a`(B . ?\x043A) ;; CYRILLIC SMALL LETTER KA
     (?$(0aa(B . ?\x043B) ;; CYRILLIC SMALL LETTER EL
     (?$(0ab(B . ?\x043C) ;; CYRILLIC SMALL LETTER EM
     (?$(0ac(B . ?\x043D) ;; CYRILLIC SMALL LETTER EN
     (?$(0ad(B . ?\x043E) ;; CYRILLIC SMALL LETTER O
     (?$(0ae(B . ?\x043F) ;; CYRILLIC SMALL LETTER PE
     (?$(0af(B . ?\x0440) ;; CYRILLIC SMALL LETTER ER
     (?$(0ag(B . ?\x0441) ;; CYRILLIC SMALL LETTER ES
     (?$(0ah(B . ?\x0442) ;; CYRILLIC SMALL LETTER TE
     (?$(0ai(B . ?\x0443) ;; CYRILLIC SMALL LETTER U
     (?$(0aj(B . ?\x0444) ;; CYRILLIC SMALL LETTER EF
     (?$(0ak(B . ?\x0445) ;; CYRILLIC SMALL LETTER HA
     (?$(0al(B . ?\x0446) ;; CYRILLIC SMALL LETTER TSE
     (?$(0am(B . ?\x0447) ;; CYRILLIC SMALL LETTER CHE
     (?$(0an(B . ?\x0448) ;; CYRILLIC SMALL LETTER SHA
     (?$(0ao(B . ?\x0449) ;; CYRILLIC SMALL LETTER SHCHA
     (?$(0ap(B . ?\x044A) ;; CYRILLIC SMALL LETTER HARD SIGN
     (?$(0aq(B . ?\x044B) ;; CYRILLIC SMALL LETTER YERU
     (?$(0ar(B . ?\x044C) ;; CYRILLIC SMALL LETTER SOFT SIGN
     (?$(0as(B . ?\x044D) ;; CYRILLIC SMALL LETTER E
     (?$(0at(B . ?\x044E) ;; CYRILLIC SMALL LETTER YU
     (?$(0au(B . ?\x044F) ;; CYRILLIC SMALL LETTER YA
     (?$(0av(B . ?\x2460) ;; CIRCLED DIGIT ONE
     (?$(0aw(B . ?\x2461) ;; CIRCLED DIGIT TWO
     (?$(0ax(B . ?\x2462) ;; CIRCLED DIGIT THREE
     (?$(0ay(B . ?\x2463) ;; CIRCLED DIGIT FOUR
     (?$(0az(B . ?\x2464) ;; CIRCLED DIGIT FIVE
     (?$(0a{(B . ?\x2465) ;; CIRCLED DIGIT SIX
     (?$(0a|(B . ?\x2466) ;; CIRCLED DIGIT SEVEN
     (?$(0a}(B . ?\x2467) ;; CIRCLED DIGIT EIGHT
     (?$(0a~(B . ?\x2468) ;; CIRCLED DIGIT NINE
     (?$(0b!(B . ?\x2469) ;; CIRCLED NUMBER TEN
     (?$(0b"(B . ?\x2474) ;; PARENTHESIZED DIGIT ONE
     (?$(0b#(B . ?\x2475) ;; PARENTHESIZED DIGIT TWO
     (?$(0b$(B . ?\x2476) ;; PARENTHESIZED DIGIT THREE
     (?$(0b%(B . ?\x2477) ;; PARENTHESIZED DIGIT FOUR
     (?$(0b&(B . ?\x2478) ;; PARENTHESIZED DIGIT FIVE
     (?$(0b'(B . ?\x2479) ;; PARENTHESIZED DIGIT SIX
     (?$(0b((B . ?\x247A) ;; PARENTHESIZED DIGIT SEVEN
     (?$(0b)(B . ?\x247B) ;; PARENTHESIZED DIGIT EIGHT
     (?$(0b*(B . ?\x247C) ;; PARENTHESIZED DIGIT NINE
     (?$(0b+(B . ?\x247D) ;; PARENTHESIZED NUMBER TEN
     )))

(defvar
  chinese-big5-2-vs-unicode-assoc
  '(assoc
    (char-1 . ucs-generic)
    ((?$(1!!(B . ?\x4E42) ;; <CJK>
     (?$(1!"(B . ?\x4E5C) ;; <CJK>
     (?$(1!#(B . ?\x51F5) ;; <CJK>
     (?$(1!$(B . ?\x531A) ;; <CJK>
     (?$(1!%(B . ?\x5382) ;; <CJK>
     (?$(1!&(B . ?\x4E07) ;; <CJK>
     (?$(1!'(B . ?\x4E0C) ;; <CJK>
     (?$(1!((B . ?\x4E47) ;; <CJK>
     (?$(1!)(B . ?\x4E8D) ;; <CJK>
     (?$(1!*(B . ?\x56D7) ;; <CJK>
     (?$(1!+(B . ?\xFA0C) ;; CJK COMPATIBILITY IDEOGRAPH-FA0C
     (?$(1!,(B . ?\x5C6E) ;; <CJK>
     (?$(1!-(B . ?\x5F73) ;; <CJK>
     (?$(1!.(B . ?\x4E0F) ;; <CJK>
     (?$(1!/(B . ?\x5187) ;; <CJK>
     (?$(1!0(B . ?\x4E0E) ;; <CJK>
     (?$(1!1(B . ?\x4E2E) ;; <CJK>
     (?$(1!2(B . ?\x4E93) ;; <CJK>
     (?$(1!3(B . ?\x4EC2) ;; <CJK>
     (?$(1!4(B . ?\x4EC9) ;; <CJK>
     (?$(1!5(B . ?\x4EC8) ;; <CJK>
     (?$(1!6(B . ?\x5198) ;; <CJK>
     (?$(1!7(B . ?\x52FC) ;; <CJK>
     (?$(1!8(B . ?\x536C) ;; <CJK>
     (?$(1!9(B . ?\x53B9) ;; <CJK>
     (?$(1!:(B . ?\x5720) ;; <CJK>
     (?$(1!;(B . ?\x5903) ;; <CJK>
     (?$(1!<(B . ?\x592C) ;; <CJK>
     (?$(1!=(B . ?\x5C10) ;; <CJK>
     (?$(1!>(B . ?\x5DFF) ;; <CJK>
     (?$(1!?(B . ?\x65E1) ;; <CJK>
     (?$(1!@(B . ?\x6BB3) ;; <CJK>
     (?$(1!A(B . ?\x6BCC) ;; <CJK>
     (?$(1!B(B . ?\x6C14) ;; <CJK>
     (?$(1!C(B . ?\x723F) ;; <CJK>
     (?$(1!D(B . ?\x4E31) ;; <CJK>
     (?$(1!E(B . ?\x4E3C) ;; <CJK>
     (?$(1!F(B . ?\x4EE8) ;; <CJK>
     (?$(1!G(B . ?\x4EDC) ;; <CJK>
     (?$(1!H(B . ?\x4EE9) ;; <CJK>
     (?$(1!I(B . ?\x4EE1) ;; <CJK>
     (?$(1!J(B . ?\x4EDD) ;; <CJK>
     (?$(1!K(B . ?\x4EDA) ;; <CJK>
     (?$(1!L(B . ?\x520C) ;; <CJK>
     (?$(1!M(B . ?\x531C) ;; <CJK>
     (?$(1!N(B . ?\x534C) ;; <CJK>
     (?$(1!O(B . ?\x5722) ;; <CJK>
     (?$(1!P(B . ?\x5723) ;; <CJK>
     (?$(1!Q(B . ?\x5917) ;; <CJK>
     (?$(1!R(B . ?\x592F) ;; <CJK>
     (?$(1!S(B . ?\x5B81) ;; <CJK>
     (?$(1!T(B . ?\x5B84) ;; <CJK>
     (?$(1!U(B . ?\x5C12) ;; <CJK>
     (?$(1!V(B . ?\x5C3B) ;; <CJK>
     (?$(1!W(B . ?\x5C74) ;; <CJK>
     (?$(1!X(B . ?\x5C73) ;; <CJK>
     (?$(1!Y(B . ?\x5E04) ;; <CJK>
     (?$(1!Z(B . ?\x5E80) ;; <CJK>
     (?$(1![(B . ?\x5E82) ;; <CJK>
     (?$(1!\(B . ?\x5FC9) ;; <CJK>
     (?$(1!](B . ?\x6209) ;; <CJK>
     (?$(1!^(B . ?\x6250) ;; <CJK>
     (?$(1!_(B . ?\x6C15) ;; <CJK>
     (?$(1!`(B . ?\x6C36) ;; <CJK>
     (?$(1!a(B . ?\x6C43) ;; <CJK>
     (?$(1!b(B . ?\x6C3F) ;; <CJK>
     (?$(1!c(B . ?\x6C3B) ;; <CJK>
     (?$(1!d(B . ?\x72AE) ;; <CJK>
     (?$(1!e(B . ?\x72B0) ;; <CJK>
     (?$(1!f(B . ?\x738A) ;; <CJK>
     (?$(1!g(B . ?\x79B8) ;; <CJK>
     (?$(1!h(B . ?\x808A) ;; <CJK>
     (?$(1!i(B . ?\x961E) ;; <CJK>
     (?$(1!j(B . ?\x4F0E) ;; <CJK>
     (?$(1!k(B . ?\x4F18) ;; <CJK>
     (?$(1!l(B . ?\x4F2C) ;; <CJK>
     (?$(1!m(B . ?\x4EF5) ;; <CJK>
     (?$(1!n(B . ?\x4F14) ;; <CJK>
     (?$(1!o(B . ?\x4EF1) ;; <CJK>
     (?$(1!p(B . ?\x4F00) ;; <CJK>
     (?$(1!q(B . ?\x4EF7) ;; <CJK>
     (?$(1!r(B . ?\x4F08) ;; <CJK>
     (?$(1!s(B . ?\x4F1D) ;; <CJK>
     (?$(1!t(B . ?\x4F02) ;; <CJK>
     (?$(1!u(B . ?\x4F05) ;; <CJK>
     (?$(1!v(B . ?\x4F22) ;; <CJK>
     (?$(1!w(B . ?\x4F13) ;; <CJK>
     (?$(1!x(B . ?\x4F04) ;; <CJK>
     (?$(1!y(B . ?\x4EF4) ;; <CJK>
     (?$(1!z(B . ?\x4F12) ;; <CJK>
     (?$(1!{(B . ?\x51B1) ;; <CJK>
     (?$(1!|(B . ?\x5213) ;; <CJK>
     (?$(1!}(B . ?\x5209) ;; <CJK>
     (?$(1!~(B . ?\x5210) ;; <CJK>
     (?$(1"!(B . ?\x52A6) ;; <CJK>
     (?$(1""(B . ?\x5322) ;; <CJK>
     (?$(1"#(B . ?\x531F) ;; <CJK>
     (?$(1"$(B . ?\x534D) ;; <CJK>
     (?$(1"%(B . ?\x538A) ;; <CJK>
     (?$(1"&(B . ?\x5407) ;; <CJK>
     (?$(1"'(B . ?\x56E1) ;; <CJK>
     (?$(1"((B . ?\x56DF) ;; <CJK>
     (?$(1")(B . ?\x572E) ;; <CJK>
     (?$(1"*(B . ?\x572A) ;; <CJK>
     (?$(1"+(B . ?\x5734) ;; <CJK>
     (?$(1",(B . ?\x593C) ;; <CJK>
     (?$(1"-(B . ?\x5980) ;; <CJK>
     (?$(1".(B . ?\x597C) ;; <CJK>
     (?$(1"/(B . ?\x5985) ;; <CJK>
     (?$(1"0(B . ?\x597B) ;; <CJK>
     (?$(1"1(B . ?\x597E) ;; <CJK>
     (?$(1"2(B . ?\x5977) ;; <CJK>
     (?$(1"3(B . ?\x597F) ;; <CJK>
     (?$(1"4(B . ?\x5B56) ;; <CJK>
     (?$(1"5(B . ?\x5C15) ;; <CJK>
     (?$(1"6(B . ?\x5C25) ;; <CJK>
     (?$(1"7(B . ?\x5C7C) ;; <CJK>
     (?$(1"8(B . ?\x5C7A) ;; <CJK>
     (?$(1"9(B . ?\x5C7B) ;; <CJK>
     (?$(1":(B . ?\x5C7E) ;; <CJK>
     (?$(1";(B . ?\x5DDF) ;; <CJK>
     (?$(1"<(B . ?\x5E75) ;; <CJK>
     (?$(1"=(B . ?\x5E84) ;; <CJK>
     (?$(1">(B . ?\x5F02) ;; <CJK>
     (?$(1"?(B . ?\x5F1A) ;; <CJK>
     (?$(1"@(B . ?\x5F74) ;; <CJK>
     (?$(1"A(B . ?\x5FD5) ;; <CJK>
     (?$(1"B(B . ?\x5FD4) ;; <CJK>
     (?$(1"C(B . ?\x5FCF) ;; <CJK>
     (?$(1"D(B . ?\x625C) ;; <CJK>
     (?$(1"E(B . ?\x625E) ;; <CJK>
     (?$(1"F(B . ?\x6264) ;; <CJK>
     (?$(1"G(B . ?\x6261) ;; <CJK>
     (?$(1"H(B . ?\x6266) ;; <CJK>
     (?$(1"I(B . ?\x6262) ;; <CJK>
     (?$(1"J(B . ?\x6259) ;; <CJK>
     (?$(1"K(B . ?\x6260) ;; <CJK>
     (?$(1"L(B . ?\x625A) ;; <CJK>
     (?$(1"M(B . ?\x6265) ;; <CJK>
     (?$(1"N(B . ?\x65EF) ;; <CJK>
     (?$(1"O(B . ?\x65EE) ;; <CJK>
     (?$(1"P(B . ?\x673E) ;; <CJK>
     (?$(1"Q(B . ?\x6739) ;; <CJK>
     (?$(1"R(B . ?\x6738) ;; <CJK>
     (?$(1"S(B . ?\x673B) ;; <CJK>
     (?$(1"T(B . ?\x673A) ;; <CJK>
     (?$(1"U(B . ?\x673F) ;; <CJK>
     (?$(1"V(B . ?\x673C) ;; <CJK>
     (?$(1"W(B . ?\x6733) ;; <CJK>
     (?$(1"X(B . ?\x6C18) ;; <CJK>
     (?$(1"Y(B . ?\x6C46) ;; <CJK>
     (?$(1"Z(B . ?\x6C52) ;; <CJK>
     (?$(1"[(B . ?\x6C5C) ;; <CJK>
     (?$(1"\(B . ?\x6C4F) ;; <CJK>
     (?$(1"](B . ?\x6C4A) ;; <CJK>
     (?$(1"^(B . ?\x6C54) ;; <CJK>
     (?$(1"_(B . ?\x6C4B) ;; <CJK>
     (?$(1"`(B . ?\x6C4C) ;; <CJK>
     (?$(1"a(B . ?\x7071) ;; <CJK>
     (?$(1"b(B . ?\x725E) ;; <CJK>
     (?$(1"c(B . ?\x72B4) ;; <CJK>
     (?$(1"d(B . ?\x72B5) ;; <CJK>
     (?$(1"e(B . ?\x738E) ;; <CJK>
     (?$(1"f(B . ?\x752A) ;; <CJK>
     (?$(1"g(B . ?\x767F) ;; <CJK>
     (?$(1"h(B . ?\x7A75) ;; <CJK>
     (?$(1"i(B . ?\x7F51) ;; <CJK>
     (?$(1"j(B . ?\x8278) ;; <CJK>
     (?$(1"k(B . ?\x827C) ;; <CJK>
     (?$(1"l(B . ?\x8280) ;; <CJK>
     (?$(1"m(B . ?\x827D) ;; <CJK>
     (?$(1"n(B . ?\x827F) ;; <CJK>
     (?$(1"o(B . ?\x864D) ;; <CJK>
     (?$(1"p(B . ?\x897E) ;; <CJK>
     (?$(1"q(B . ?\x9099) ;; <CJK>
     (?$(1"r(B . ?\x9097) ;; <CJK>
     (?$(1"s(B . ?\x9098) ;; <CJK>
     (?$(1"t(B . ?\x909B) ;; <CJK>
     (?$(1"u(B . ?\x9094) ;; <CJK>
     (?$(1"v(B . ?\x9622) ;; <CJK>
     (?$(1"w(B . ?\x9624) ;; <CJK>
     (?$(1"x(B . ?\x9620) ;; <CJK>
     (?$(1"y(B . ?\x9623) ;; <CJK>
     (?$(1"z(B . ?\x4F56) ;; <CJK>
     (?$(1"{(B . ?\x4F3B) ;; <CJK>
     (?$(1"|(B . ?\x4F62) ;; <CJK>
     (?$(1"}(B . ?\x4F49) ;; <CJK>
     (?$(1"~(B . ?\x4F53) ;; <CJK>
     (?$(1#!(B . ?\x4F64) ;; <CJK>
     (?$(1#"(B . ?\x4F3E) ;; <CJK>
     (?$(1##(B . ?\x4F67) ;; <CJK>
     (?$(1#$(B . ?\x4F52) ;; <CJK>
     (?$(1#%(B . ?\x4F5F) ;; <CJK>
     (?$(1#&(B . ?\x4F41) ;; <CJK>
     (?$(1#'(B . ?\x4F58) ;; <CJK>
     (?$(1#((B . ?\x4F2D) ;; <CJK>
     (?$(1#)(B . ?\x4F33) ;; <CJK>
     (?$(1#*(B . ?\x4F3F) ;; <CJK>
     (?$(1#+(B . ?\x4F61) ;; <CJK>
     (?$(1#,(B . ?\x518F) ;; <CJK>
     (?$(1#-(B . ?\x51B9) ;; <CJK>
     (?$(1#.(B . ?\x521C) ;; <CJK>
     (?$(1#/(B . ?\x521E) ;; <CJK>
     (?$(1#0(B . ?\x5221) ;; <CJK>
     (?$(1#1(B . ?\x52AD) ;; <CJK>
     (?$(1#2(B . ?\x52AE) ;; <CJK>
     (?$(1#3(B . ?\x5309) ;; <CJK>
     (?$(1#4(B . ?\x5363) ;; <CJK>
     (?$(1#5(B . ?\x5372) ;; <CJK>
     (?$(1#6(B . ?\x538E) ;; <CJK>
     (?$(1#7(B . ?\x538F) ;; <CJK>
     (?$(1#8(B . ?\x5430) ;; <CJK>
     (?$(1#9(B . ?\x5437) ;; <CJK>
     (?$(1#:(B . ?\x542A) ;; <CJK>
     (?$(1#;(B . ?\x5454) ;; <CJK>
     (?$(1#<(B . ?\x5445) ;; <CJK>
     (?$(1#=(B . ?\x5419) ;; <CJK>
     (?$(1#>(B . ?\x541C) ;; <CJK>
     (?$(1#?(B . ?\x5425) ;; <CJK>
     (?$(1#@(B . ?\x5418) ;; <CJK>
     (?$(1#A(B . ?\x543D) ;; <CJK>
     (?$(1#B(B . ?\x544F) ;; <CJK>
     (?$(1#C(B . ?\x5441) ;; <CJK>
     (?$(1#D(B . ?\x5428) ;; <CJK>
     (?$(1#E(B . ?\x5424) ;; <CJK>
     (?$(1#F(B . ?\x5447) ;; <CJK>
     (?$(1#G(B . ?\x56EE) ;; <CJK>
     (?$(1#H(B . ?\x56E7) ;; <CJK>
     (?$(1#I(B . ?\x56E5) ;; <CJK>
     (?$(1#J(B . ?\x5741) ;; <CJK>
     (?$(1#K(B . ?\x5745) ;; <CJK>
     (?$(1#L(B . ?\x574C) ;; <CJK>
     (?$(1#M(B . ?\x5749) ;; <CJK>
     (?$(1#N(B . ?\x574B) ;; <CJK>
     (?$(1#O(B . ?\x5752) ;; <CJK>
     (?$(1#P(B . ?\x5906) ;; <CJK>
     (?$(1#Q(B . ?\x5940) ;; <CJK>
     (?$(1#R(B . ?\x59A6) ;; <CJK>
     (?$(1#S(B . ?\x5998) ;; <CJK>
     (?$(1#T(B . ?\x59A0) ;; <CJK>
     (?$(1#U(B . ?\x5997) ;; <CJK>
     (?$(1#V(B . ?\x598E) ;; <CJK>
     (?$(1#W(B . ?\x59A2) ;; <CJK>
     (?$(1#X(B . ?\x5990) ;; <CJK>
     (?$(1#Y(B . ?\x598F) ;; <CJK>
     (?$(1#Z(B . ?\x59A7) ;; <CJK>
     (?$(1#[(B . ?\x59A1) ;; <CJK>
     (?$(1#\(B . ?\x5B8E) ;; <CJK>
     (?$(1#](B . ?\x5B92) ;; <CJK>
     (?$(1#^(B . ?\x5C28) ;; <CJK>
     (?$(1#_(B . ?\x5C2A) ;; <CJK>
     (?$(1#`(B . ?\x5C8D) ;; <CJK>
     (?$(1#a(B . ?\x5C8F) ;; <CJK>
     (?$(1#b(B . ?\x5C88) ;; <CJK>
     (?$(1#c(B . ?\x5C8B) ;; <CJK>
     (?$(1#d(B . ?\x5C89) ;; <CJK>
     (?$(1#e(B . ?\x5C92) ;; <CJK>
     (?$(1#f(B . ?\x5C8A) ;; <CJK>
     (?$(1#g(B . ?\x5C86) ;; <CJK>
     (?$(1#h(B . ?\x5C93) ;; <CJK>
     (?$(1#i(B . ?\x5C95) ;; <CJK>
     (?$(1#j(B . ?\x5DE0) ;; <CJK>
     (?$(1#k(B . ?\x5E0A) ;; <CJK>
     (?$(1#l(B . ?\x5E0E) ;; <CJK>
     (?$(1#m(B . ?\x5E8B) ;; <CJK>
     (?$(1#n(B . ?\x5E89) ;; <CJK>
     (?$(1#o(B . ?\x5E8C) ;; <CJK>
     (?$(1#p(B . ?\x5E88) ;; <CJK>
     (?$(1#q(B . ?\x5E8D) ;; <CJK>
     (?$(1#r(B . ?\x5F05) ;; <CJK>
     (?$(1#s(B . ?\x5F1D) ;; <CJK>
     (?$(1#t(B . ?\x5F78) ;; <CJK>
     (?$(1#u(B . ?\x5F76) ;; <CJK>
     (?$(1#v(B . ?\x5FD2) ;; <CJK>
     (?$(1#w(B . ?\x5FD1) ;; <CJK>
     (?$(1#x(B . ?\x5FD0) ;; <CJK>
     (?$(1#y(B . ?\x5FED) ;; <CJK>
     (?$(1#z(B . ?\x5FE8) ;; <CJK>
     (?$(1#{(B . ?\x5FEE) ;; <CJK>
     (?$(1#|(B . ?\x5FF3) ;; <CJK>
     (?$(1#}(B . ?\x5FE1) ;; <CJK>
     (?$(1#~(B . ?\x5FE4) ;; <CJK>
     (?$(1$!(B . ?\x5FE3) ;; <CJK>
     (?$(1$"(B . ?\x5FFA) ;; <CJK>
     (?$(1$#(B . ?\x5FEF) ;; <CJK>
     (?$(1$$(B . ?\x5FF7) ;; <CJK>
     (?$(1$%(B . ?\x5FFB) ;; <CJK>
     (?$(1$&(B . ?\x6000) ;; <CJK>
     (?$(1$'(B . ?\x5FF4) ;; <CJK>
     (?$(1$((B . ?\x623A) ;; <CJK>
     (?$(1$)(B . ?\x6283) ;; <CJK>
     (?$(1$*(B . ?\x628C) ;; <CJK>
     (?$(1$+(B . ?\x628E) ;; <CJK>
     (?$(1$,(B . ?\x628F) ;; <CJK>
     (?$(1$-(B . ?\x6294) ;; <CJK>
     (?$(1$.(B . ?\x6287) ;; <CJK>
     (?$(1$/(B . ?\x6271) ;; <CJK>
     (?$(1$0(B . ?\x627B) ;; <CJK>
     (?$(1$1(B . ?\x627A) ;; <CJK>
     (?$(1$2(B . ?\x6270) ;; <CJK>
     (?$(1$3(B . ?\x6281) ;; <CJK>
     (?$(1$4(B . ?\x6288) ;; <CJK>
     (?$(1$5(B . ?\x6277) ;; <CJK>
     (?$(1$6(B . ?\x627D) ;; <CJK>
     (?$(1$7(B . ?\x6272) ;; <CJK>
     (?$(1$8(B . ?\x6274) ;; <CJK>
     (?$(1$9(B . ?\x6537) ;; <CJK>
     (?$(1$:(B . ?\x65F0) ;; <CJK>
     (?$(1$;(B . ?\x65F4) ;; <CJK>
     (?$(1$<(B . ?\x65F3) ;; <CJK>
     (?$(1$=(B . ?\x65F2) ;; <CJK>
     (?$(1$>(B . ?\x65F5) ;; <CJK>
     (?$(1$?(B . ?\x6745) ;; <CJK>
     (?$(1$@(B . ?\x6747) ;; <CJK>
     (?$(1$A(B . ?\x6759) ;; <CJK>
     (?$(1$B(B . ?\x6755) ;; <CJK>
     (?$(1$C(B . ?\x674C) ;; <CJK>
     (?$(1$D(B . ?\x6748) ;; <CJK>
     (?$(1$E(B . ?\x675D) ;; <CJK>
     (?$(1$F(B . ?\x674D) ;; <CJK>
     (?$(1$G(B . ?\x675A) ;; <CJK>
     (?$(1$H(B . ?\x674B) ;; <CJK>
     (?$(1$I(B . ?\x6BD0) ;; <CJK>
     (?$(1$J(B . ?\x6C19) ;; <CJK>
     (?$(1$K(B . ?\x6C1A) ;; <CJK>
     (?$(1$L(B . ?\x6C78) ;; <CJK>
     (?$(1$M(B . ?\x6C67) ;; <CJK>
     (?$(1$N(B . ?\x6C6B) ;; <CJK>
     (?$(1$O(B . ?\x6C84) ;; <CJK>
     (?$(1$P(B . ?\x6C8B) ;; <CJK>
     (?$(1$Q(B . ?\x6C8F) ;; <CJK>
     (?$(1$R(B . ?\x6C71) ;; <CJK>
     (?$(1$S(B . ?\x6C6F) ;; <CJK>
     (?$(1$T(B . ?\x6C69) ;; <CJK>
     (?$(1$U(B . ?\x6C9A) ;; <CJK>
     (?$(1$V(B . ?\x6C6D) ;; <CJK>
     (?$(1$W(B . ?\x6C87) ;; <CJK>
     (?$(1$X(B . ?\x6C95) ;; <CJK>
     (?$(1$Y(B . ?\x6C9C) ;; <CJK>
     (?$(1$Z(B . ?\x6C66) ;; <CJK>
     (?$(1$[(B . ?\x6C73) ;; <CJK>
     (?$(1$\(B . ?\x6C65) ;; <CJK>
     (?$(1$](B . ?\x6C7B) ;; <CJK>
     (?$(1$^(B . ?\x6C8E) ;; <CJK>
     (?$(1$_(B . ?\x7074) ;; <CJK>
     (?$(1$`(B . ?\x707A) ;; <CJK>
     (?$(1$a(B . ?\x7263) ;; <CJK>
     (?$(1$b(B . ?\x72BF) ;; <CJK>
     (?$(1$c(B . ?\x72BD) ;; <CJK>
     (?$(1$d(B . ?\x72C3) ;; <CJK>
     (?$(1$e(B . ?\x72C6) ;; <CJK>
     (?$(1$f(B . ?\x72C1) ;; <CJK>
     (?$(1$g(B . ?\x72BA) ;; <CJK>
     (?$(1$h(B . ?\x72C5) ;; <CJK>
     (?$(1$i(B . ?\x7395) ;; <CJK>
     (?$(1$j(B . ?\x7397) ;; <CJK>
     (?$(1$k(B . ?\x7393) ;; <CJK>
     (?$(1$l(B . ?\x7394) ;; <CJK>
     (?$(1$m(B . ?\x7392) ;; <CJK>
     (?$(1$n(B . ?\x753A) ;; <CJK>
     (?$(1$o(B . ?\x7539) ;; <CJK>
     (?$(1$p(B . ?\x7594) ;; <CJK>
     (?$(1$q(B . ?\x7595) ;; <CJK>
     (?$(1$r(B . ?\x7681) ;; <CJK>
     (?$(1$s(B . ?\x793D) ;; <CJK>
     (?$(1$t(B . ?\x8034) ;; <CJK>
     (?$(1$u(B . ?\x8095) ;; <CJK>
     (?$(1$v(B . ?\x8099) ;; <CJK>
     (?$(1$w(B . ?\x8090) ;; <CJK>
     (?$(1$x(B . ?\x8092) ;; <CJK>
     (?$(1$y(B . ?\x809C) ;; <CJK>
     (?$(1$z(B . ?\x8290) ;; <CJK>
     (?$(1${(B . ?\x828F) ;; <CJK>
     (?$(1$|(B . ?\x8285) ;; <CJK>
     (?$(1$}(B . ?\x828E) ;; <CJK>
     (?$(1$~(B . ?\x8291) ;; <CJK>
     (?$(1%!(B . ?\x8293) ;; <CJK>
     (?$(1%"(B . ?\x828A) ;; <CJK>
     (?$(1%#(B . ?\x8283) ;; <CJK>
     (?$(1%$(B . ?\x8284) ;; <CJK>
     (?$(1%%(B . ?\x8C78) ;; <CJK>
     (?$(1%&(B . ?\x8FC9) ;; <CJK>
     (?$(1%'(B . ?\x8FBF) ;; <CJK>
     (?$(1%((B . ?\x909F) ;; <CJK>
     (?$(1%)(B . ?\x90A1) ;; <CJK>
     (?$(1%*(B . ?\x90A5) ;; <CJK>
     (?$(1%+(B . ?\x909E) ;; <CJK>
     (?$(1%,(B . ?\x90A7) ;; <CJK>
     (?$(1%-(B . ?\x90A0) ;; <CJK>
     (?$(1%.(B . ?\x9630) ;; <CJK>
     (?$(1%/(B . ?\x9628) ;; <CJK>
     (?$(1%0(B . ?\x962F) ;; <CJK>
     (?$(1%1(B . ?\x962D) ;; <CJK>
     (?$(1%2(B . ?\x4E33) ;; <CJK>
     (?$(1%3(B . ?\x4F98) ;; <CJK>
     (?$(1%4(B . ?\x4F7C) ;; <CJK>
     (?$(1%5(B . ?\x4F85) ;; <CJK>
     (?$(1%6(B . ?\x4F7D) ;; <CJK>
     (?$(1%7(B . ?\x4F80) ;; <CJK>
     (?$(1%8(B . ?\x4F87) ;; <CJK>
     (?$(1%9(B . ?\x4F76) ;; <CJK>
     (?$(1%:(B . ?\x4F74) ;; <CJK>
     (?$(1%;(B . ?\x4F89) ;; <CJK>
     (?$(1%<(B . ?\x4F84) ;; <CJK>
     (?$(1%=(B . ?\x4F77) ;; <CJK>
     (?$(1%>(B . ?\x4F4C) ;; <CJK>
     (?$(1%?(B . ?\x4F97) ;; <CJK>
     (?$(1%@(B . ?\x4F6A) ;; <CJK>
     (?$(1%A(B . ?\x4F9A) ;; <CJK>
     (?$(1%B(B . ?\x4F79) ;; <CJK>
     (?$(1%C(B . ?\x4F81) ;; <CJK>
     (?$(1%D(B . ?\x4F78) ;; <CJK>
     (?$(1%E(B . ?\x4F90) ;; <CJK>
     (?$(1%F(B . ?\x4F9C) ;; <CJK>
     (?$(1%G(B . ?\x4F94) ;; <CJK>
     (?$(1%H(B . ?\x4F9E) ;; <CJK>
     (?$(1%I(B . ?\x4F92) ;; <CJK>
     (?$(1%J(B . ?\x4F82) ;; <CJK>
     (?$(1%K(B . ?\x4F95) ;; <CJK>
     (?$(1%L(B . ?\x4F6B) ;; <CJK>
     (?$(1%M(B . ?\x4F6E) ;; <CJK>
     (?$(1%N(B . ?\x519E) ;; <CJK>
     (?$(1%O(B . ?\x51BC) ;; <CJK>
     (?$(1%P(B . ?\x51BE) ;; <CJK>
     (?$(1%Q(B . ?\x5235) ;; <CJK>
     (?$(1%R(B . ?\x5232) ;; <CJK>
     (?$(1%S(B . ?\x5233) ;; <CJK>
     (?$(1%T(B . ?\x5246) ;; <CJK>
     (?$(1%U(B . ?\x5231) ;; <CJK>
     (?$(1%V(B . ?\x52BC) ;; <CJK>
     (?$(1%W(B . ?\x530A) ;; <CJK>
     (?$(1%X(B . ?\x530B) ;; <CJK>
     (?$(1%Y(B . ?\x533C) ;; <CJK>
     (?$(1%Z(B . ?\x5392) ;; <CJK>
     (?$(1%[(B . ?\x5394) ;; <CJK>
     (?$(1%\(B . ?\x5487) ;; <CJK>
     (?$(1%](B . ?\x547F) ;; <CJK>
     (?$(1%^(B . ?\x5481) ;; <CJK>
     (?$(1%_(B . ?\x5491) ;; <CJK>
     (?$(1%`(B . ?\x5482) ;; <CJK>
     (?$(1%a(B . ?\x5488) ;; <CJK>
     (?$(1%b(B . ?\x546B) ;; <CJK>
     (?$(1%c(B . ?\x547A) ;; <CJK>
     (?$(1%d(B . ?\x547E) ;; <CJK>
     (?$(1%e(B . ?\x5465) ;; <CJK>
     (?$(1%f(B . ?\x546C) ;; <CJK>
     (?$(1%g(B . ?\x5474) ;; <CJK>
     (?$(1%h(B . ?\x5466) ;; <CJK>
     (?$(1%i(B . ?\x548D) ;; <CJK>
     (?$(1%j(B . ?\x546F) ;; <CJK>
     (?$(1%k(B . ?\x5461) ;; <CJK>
     (?$(1%l(B . ?\x5460) ;; <CJK>
     (?$(1%m(B . ?\x5498) ;; <CJK>
     (?$(1%n(B . ?\x5463) ;; <CJK>
     (?$(1%o(B . ?\x5467) ;; <CJK>
     (?$(1%p(B . ?\x5464) ;; <CJK>
     (?$(1%q(B . ?\x56F7) ;; <CJK>
     (?$(1%r(B . ?\x56F9) ;; <CJK>
     (?$(1%s(B . ?\x576F) ;; <CJK>
     (?$(1%t(B . ?\x5772) ;; <CJK>
     (?$(1%u(B . ?\x576D) ;; <CJK>
     (?$(1%v(B . ?\x576B) ;; <CJK>
     (?$(1%w(B . ?\x5771) ;; <CJK>
     (?$(1%x(B . ?\x5770) ;; <CJK>
     (?$(1%y(B . ?\x5776) ;; <CJK>
     (?$(1%z(B . ?\x5780) ;; <CJK>
     (?$(1%{(B . ?\x5775) ;; <CJK>
     (?$(1%|(B . ?\x577B) ;; <CJK>
     (?$(1%}(B . ?\x5773) ;; <CJK>
     (?$(1%~(B . ?\x5774) ;; <CJK>
     (?$(1&!(B . ?\x5762) ;; <CJK>
     (?$(1&"(B . ?\x5768) ;; <CJK>
     (?$(1&#(B . ?\x577D) ;; <CJK>
     (?$(1&$(B . ?\x590C) ;; <CJK>
     (?$(1&%(B . ?\x5945) ;; <CJK>
     (?$(1&&(B . ?\x59B5) ;; <CJK>
     (?$(1&'(B . ?\x59BA) ;; <CJK>
     (?$(1&((B . ?\x59CF) ;; <CJK>
     (?$(1&)(B . ?\x59CE) ;; <CJK>
     (?$(1&*(B . ?\x59B2) ;; <CJK>
     (?$(1&+(B . ?\x59CC) ;; <CJK>
     (?$(1&,(B . ?\x59C1) ;; <CJK>
     (?$(1&-(B . ?\x59B6) ;; <CJK>
     (?$(1&.(B . ?\x59BC) ;; <CJK>
     (?$(1&/(B . ?\x59C3) ;; <CJK>
     (?$(1&0(B . ?\x59D6) ;; <CJK>
     (?$(1&1(B . ?\x59B1) ;; <CJK>
     (?$(1&2(B . ?\x59BD) ;; <CJK>
     (?$(1&3(B . ?\x59C0) ;; <CJK>
     (?$(1&4(B . ?\x59C8) ;; <CJK>
     (?$(1&5(B . ?\x59B4) ;; <CJK>
     (?$(1&6(B . ?\x59C7) ;; <CJK>
     (?$(1&7(B . ?\x5B62) ;; <CJK>
     (?$(1&8(B . ?\x5B65) ;; <CJK>
     (?$(1&9(B . ?\x5B93) ;; <CJK>
     (?$(1&:(B . ?\x5B95) ;; <CJK>
     (?$(1&;(B . ?\x5C44) ;; <CJK>
     (?$(1&<(B . ?\x5C47) ;; <CJK>
     (?$(1&=(B . ?\x5CAE) ;; <CJK>
     (?$(1&>(B . ?\x5CA4) ;; <CJK>
     (?$(1&?(B . ?\x5CA0) ;; <CJK>
     (?$(1&@(B . ?\x5CB5) ;; <CJK>
     (?$(1&A(B . ?\x5CAF) ;; <CJK>
     (?$(1&B(B . ?\x5CA8) ;; <CJK>
     (?$(1&C(B . ?\x5CAC) ;; <CJK>
     (?$(1&D(B . ?\x5C9F) ;; <CJK>
     (?$(1&E(B . ?\x5CA3) ;; <CJK>
     (?$(1&F(B . ?\x5CAD) ;; <CJK>
     (?$(1&G(B . ?\x5CA2) ;; <CJK>
     (?$(1&H(B . ?\x5CAA) ;; <CJK>
     (?$(1&I(B . ?\x5CA7) ;; <CJK>
     (?$(1&J(B . ?\x5C9D) ;; <CJK>
     (?$(1&K(B . ?\x5CA5) ;; <CJK>
     (?$(1&L(B . ?\x5CB6) ;; <CJK>
     (?$(1&M(B . ?\x5CB0) ;; <CJK>
     (?$(1&N(B . ?\x5CA6) ;; <CJK>
     (?$(1&O(B . ?\x5E17) ;; <CJK>
     (?$(1&P(B . ?\x5E14) ;; <CJK>
     (?$(1&Q(B . ?\x5E19) ;; <CJK>
     (?$(1&R(B . ?\x5F28) ;; <CJK>
     (?$(1&S(B . ?\x5F22) ;; <CJK>
     (?$(1&T(B . ?\x5F23) ;; <CJK>
     (?$(1&U(B . ?\x5F24) ;; <CJK>
     (?$(1&V(B . ?\x5F54) ;; <CJK>
     (?$(1&W(B . ?\x5F82) ;; <CJK>
     (?$(1&X(B . ?\x5F7E) ;; <CJK>
     (?$(1&Y(B . ?\x5F7D) ;; <CJK>
     (?$(1&Z(B . ?\x5FDE) ;; <CJK>
     (?$(1&[(B . ?\x5FE5) ;; <CJK>
     (?$(1&\(B . ?\x602D) ;; <CJK>
     (?$(1&](B . ?\x6026) ;; <CJK>
     (?$(1&^(B . ?\x6019) ;; <CJK>
     (?$(1&_(B . ?\x6032) ;; <CJK>
     (?$(1&`(B . ?\x600B) ;; <CJK>
     (?$(1&a(B . ?\x6034) ;; <CJK>
     (?$(1&b(B . ?\x600A) ;; <CJK>
     (?$(1&c(B . ?\x6017) ;; <CJK>
     (?$(1&d(B . ?\x6033) ;; <CJK>
     (?$(1&e(B . ?\x601A) ;; <CJK>
     (?$(1&f(B . ?\x601E) ;; <CJK>
     (?$(1&g(B . ?\x602C) ;; <CJK>
     (?$(1&h(B . ?\x6022) ;; <CJK>
     (?$(1&i(B . ?\x600D) ;; <CJK>
     (?$(1&j(B . ?\x6010) ;; <CJK>
     (?$(1&k(B . ?\x602E) ;; <CJK>
     (?$(1&l(B . ?\x6013) ;; <CJK>
     (?$(1&m(B . ?\x6011) ;; <CJK>
     (?$(1&n(B . ?\x600C) ;; <CJK>
     (?$(1&o(B . ?\x6009) ;; <CJK>
     (?$(1&p(B . ?\x601C) ;; <CJK>
     (?$(1&q(B . ?\x6214) ;; <CJK>
     (?$(1&r(B . ?\x623D) ;; <CJK>
     (?$(1&s(B . ?\x62AD) ;; <CJK>
     (?$(1&t(B . ?\x62B4) ;; <CJK>
     (?$(1&u(B . ?\x62D1) ;; <CJK>
     (?$(1&v(B . ?\x62BE) ;; <CJK>
     (?$(1&w(B . ?\x62AA) ;; <CJK>
     (?$(1&x(B . ?\x62B6) ;; <CJK>
     (?$(1&y(B . ?\x62CA) ;; <CJK>
     (?$(1&z(B . ?\x62AE) ;; <CJK>
     (?$(1&{(B . ?\x62B3) ;; <CJK>
     (?$(1&|(B . ?\x62AF) ;; <CJK>
     (?$(1&}(B . ?\x62BB) ;; <CJK>
     (?$(1&~(B . ?\x62A9) ;; <CJK>
     (?$(1'!(B . ?\x62B0) ;; <CJK>
     (?$(1'"(B . ?\x62B8) ;; <CJK>
     (?$(1'#(B . ?\x653D) ;; <CJK>
     (?$(1'$(B . ?\x65A8) ;; <CJK>
     (?$(1'%(B . ?\x65BB) ;; <CJK>
     (?$(1'&(B . ?\x6609) ;; <CJK>
     (?$(1''(B . ?\x65FC) ;; <CJK>
     (?$(1'((B . ?\x6604) ;; <CJK>
     (?$(1')(B . ?\x6612) ;; <CJK>
     (?$(1'*(B . ?\x6608) ;; <CJK>
     (?$(1'+(B . ?\x65FB) ;; <CJK>
     (?$(1',(B . ?\x6603) ;; <CJK>
     (?$(1'-(B . ?\x660B) ;; <CJK>
     (?$(1'.(B . ?\x660D) ;; <CJK>
     (?$(1'/(B . ?\x6605) ;; <CJK>
     (?$(1'0(B . ?\x65FD) ;; <CJK>
     (?$(1'1(B . ?\x6611) ;; <CJK>
     (?$(1'2(B . ?\x6610) ;; <CJK>
     (?$(1'3(B . ?\x66F6) ;; <CJK>
     (?$(1'4(B . ?\x670A) ;; <CJK>
     (?$(1'5(B . ?\x6785) ;; <CJK>
     (?$(1'6(B . ?\x676C) ;; <CJK>
     (?$(1'7(B . ?\x678E) ;; <CJK>
     (?$(1'8(B . ?\x6792) ;; <CJK>
     (?$(1'9(B . ?\x6776) ;; <CJK>
     (?$(1':(B . ?\x677B) ;; <CJK>
     (?$(1';(B . ?\x6798) ;; <CJK>
     (?$(1'<(B . ?\x6786) ;; <CJK>
     (?$(1'=(B . ?\x6784) ;; <CJK>
     (?$(1'>(B . ?\x6774) ;; <CJK>
     (?$(1'?(B . ?\x678D) ;; <CJK>
     (?$(1'@(B . ?\x678C) ;; <CJK>
     (?$(1'A(B . ?\x677A) ;; <CJK>
     (?$(1'B(B . ?\x679F) ;; <CJK>
     (?$(1'C(B . ?\x6791) ;; <CJK>
     (?$(1'D(B . ?\x6799) ;; <CJK>
     (?$(1'E(B . ?\x6783) ;; <CJK>
     (?$(1'F(B . ?\x677D) ;; <CJK>
     (?$(1'G(B . ?\x6781) ;; <CJK>
     (?$(1'H(B . ?\x6778) ;; <CJK>
     (?$(1'I(B . ?\x6779) ;; <CJK>
     (?$(1'J(B . ?\x6794) ;; <CJK>
     (?$(1'K(B . ?\x6B25) ;; <CJK>
     (?$(1'L(B . ?\x6B80) ;; <CJK>
     (?$(1'M(B . ?\x6B7E) ;; <CJK>
     (?$(1'N(B . ?\x6BDE) ;; <CJK>
     (?$(1'O(B . ?\x6C1D) ;; <CJK>
     (?$(1'P(B . ?\x6C93) ;; <CJK>
     (?$(1'Q(B . ?\x6CEC) ;; <CJK>
     (?$(1'R(B . ?\x6CEB) ;; <CJK>
     (?$(1'S(B . ?\x6CEE) ;; <CJK>
     (?$(1'T(B . ?\x6CD9) ;; <CJK>
     (?$(1'U(B . ?\x6CB6) ;; <CJK>
     (?$(1'V(B . ?\x6CD4) ;; <CJK>
     (?$(1'W(B . ?\x6CAD) ;; <CJK>
     (?$(1'X(B . ?\x6CE7) ;; <CJK>
     (?$(1'Y(B . ?\x6CB7) ;; <CJK>
     (?$(1'Z(B . ?\x6CD0) ;; <CJK>
     (?$(1'[(B . ?\x6CC2) ;; <CJK>
     (?$(1'\(B . ?\x6CBA) ;; <CJK>
     (?$(1'](B . ?\x6CC3) ;; <CJK>
     (?$(1'^(B . ?\x6CC6) ;; <CJK>
     (?$(1'_(B . ?\x6CED) ;; <CJK>
     (?$(1'`(B . ?\x6CF2) ;; <CJK>
     (?$(1'a(B . ?\x6CD2) ;; <CJK>
     (?$(1'b(B . ?\x6CDD) ;; <CJK>
     (?$(1'c(B . ?\x6CB4) ;; <CJK>
     (?$(1'd(B . ?\x6C8A) ;; <CJK>
     (?$(1'e(B . ?\x6C9D) ;; <CJK>
     (?$(1'f(B . ?\x6C80) ;; <CJK>
     (?$(1'g(B . ?\x6CDE) ;; <CJK>
     (?$(1'h(B . ?\x6CC0) ;; <CJK>
     (?$(1'i(B . ?\x6D30) ;; <CJK>
     (?$(1'j(B . ?\x6CCD) ;; <CJK>
     (?$(1'k(B . ?\x6CC7) ;; <CJK>
     (?$(1'l(B . ?\x6CB0) ;; <CJK>
     (?$(1'm(B . ?\x6CF9) ;; <CJK>
     (?$(1'n(B . ?\x6CCF) ;; <CJK>
     (?$(1'o(B . ?\x6CE9) ;; <CJK>
     (?$(1'p(B . ?\x6CD1) ;; <CJK>
     (?$(1'q(B . ?\x7094) ;; <CJK>
     (?$(1'r(B . ?\x7098) ;; <CJK>
     (?$(1's(B . ?\x7085) ;; <CJK>
     (?$(1't(B . ?\x7093) ;; <CJK>
     (?$(1'u(B . ?\x7086) ;; <CJK>
     (?$(1'v(B . ?\x7084) ;; <CJK>
     (?$(1'w(B . ?\x7091) ;; <CJK>
     (?$(1'x(B . ?\x7096) ;; <CJK>
     (?$(1'y(B . ?\x7082) ;; <CJK>
     (?$(1'z(B . ?\x709A) ;; <CJK>
     (?$(1'{(B . ?\x7083) ;; <CJK>
     (?$(1'|(B . ?\x726A) ;; <CJK>
     (?$(1'}(B . ?\x72D6) ;; <CJK>
     (?$(1'~(B . ?\x72CB) ;; <CJK>
     (?$(1(!(B . ?\x72D8) ;; <CJK>
     (?$(1("(B . ?\x72C9) ;; <CJK>
     (?$(1(#(B . ?\x72DC) ;; <CJK>
     (?$(1($(B . ?\x72D2) ;; <CJK>
     (?$(1(%(B . ?\x72D4) ;; <CJK>
     (?$(1(&(B . ?\x72DA) ;; <CJK>
     (?$(1('(B . ?\x72CC) ;; <CJK>
     (?$(1(((B . ?\x72D1) ;; <CJK>
     (?$(1()(B . ?\x73A4) ;; <CJK>
     (?$(1(*(B . ?\x73A1) ;; <CJK>
     (?$(1(+(B . ?\x73AD) ;; <CJK>
     (?$(1(,(B . ?\x73A6) ;; <CJK>
     (?$(1(-(B . ?\x73A2) ;; <CJK>
     (?$(1(.(B . ?\x73A0) ;; <CJK>
     (?$(1(/(B . ?\x73AC) ;; <CJK>
     (?$(1(0(B . ?\x739D) ;; <CJK>
     (?$(1(1(B . ?\x74DD) ;; <CJK>
     (?$(1(2(B . ?\x74E8) ;; <CJK>
     (?$(1(3(B . ?\x753F) ;; <CJK>
     (?$(1(4(B . ?\x7540) ;; <CJK>
     (?$(1(5(B . ?\x753E) ;; <CJK>
     (?$(1(6(B . ?\x758C) ;; <CJK>
     (?$(1(7(B . ?\x7598) ;; <CJK>
     (?$(1(8(B . ?\x76AF) ;; <CJK>
     (?$(1(9(B . ?\x76F3) ;; <CJK>
     (?$(1(:(B . ?\x76F1) ;; <CJK>
     (?$(1(;(B . ?\x76F0) ;; <CJK>
     (?$(1(<(B . ?\x76F5) ;; <CJK>
     (?$(1(=(B . ?\x77F8) ;; <CJK>
     (?$(1(>(B . ?\x77FC) ;; <CJK>
     (?$(1(?(B . ?\x77F9) ;; <CJK>
     (?$(1(@(B . ?\x77FB) ;; <CJK>
     (?$(1(A(B . ?\x77FA) ;; <CJK>
     (?$(1(B(B . ?\x77F7) ;; <CJK>
     (?$(1(C(B . ?\x7942) ;; <CJK>
     (?$(1(D(B . ?\x793F) ;; <CJK>
     (?$(1(E(B . ?\x79C5) ;; <CJK>
     (?$(1(F(B . ?\x7A78) ;; <CJK>
     (?$(1(G(B . ?\x7A7B) ;; <CJK>
     (?$(1(H(B . ?\x7AFB) ;; <CJK>
     (?$(1(I(B . ?\x7C75) ;; <CJK>
     (?$(1(J(B . ?\x7CFD) ;; <CJK>
     (?$(1(K(B . ?\x8035) ;; <CJK>
     (?$(1(L(B . ?\x808F) ;; <CJK>
     (?$(1(M(B . ?\x80AE) ;; <CJK>
     (?$(1(N(B . ?\x80A3) ;; <CJK>
     (?$(1(O(B . ?\x80B8) ;; <CJK>
     (?$(1(P(B . ?\x80B5) ;; <CJK>
     (?$(1(Q(B . ?\x80AD) ;; <CJK>
     (?$(1(R(B . ?\x8220) ;; <CJK>
     (?$(1(S(B . ?\x82A0) ;; <CJK>
     (?$(1(T(B . ?\x82C0) ;; <CJK>
     (?$(1(U(B . ?\x82AB) ;; <CJK>
     (?$(1(V(B . ?\x829A) ;; <CJK>
     (?$(1(W(B . ?\x8298) ;; <CJK>
     (?$(1(X(B . ?\x829B) ;; <CJK>
     (?$(1(Y(B . ?\x82B5) ;; <CJK>
     (?$(1(Z(B . ?\x82A7) ;; <CJK>
     (?$(1([(B . ?\x82AE) ;; <CJK>
     (?$(1(\(B . ?\x82BC) ;; <CJK>
     (?$(1(](B . ?\x829E) ;; <CJK>
     (?$(1(^(B . ?\x82BA) ;; <CJK>
     (?$(1(_(B . ?\x82B4) ;; <CJK>
     (?$(1(`(B . ?\x82A8) ;; <CJK>
     (?$(1(a(B . ?\x82A1) ;; <CJK>
     (?$(1(b(B . ?\x82A9) ;; <CJK>
     (?$(1(c(B . ?\x82C2) ;; <CJK>
     (?$(1(d(B . ?\x82A4) ;; <CJK>
     (?$(1(e(B . ?\x82C3) ;; <CJK>
     (?$(1(f(B . ?\x82B6) ;; <CJK>
     (?$(1(g(B . ?\x82A2) ;; <CJK>
     (?$(1(h(B . ?\x8670) ;; <CJK>
     (?$(1(i(B . ?\x866F) ;; <CJK>
     (?$(1(j(B . ?\x866D) ;; <CJK>
     (?$(1(k(B . ?\x866E) ;; <CJK>
     (?$(1(l(B . ?\x8C56) ;; <CJK>
     (?$(1(m(B . ?\x8FD2) ;; <CJK>
     (?$(1(n(B . ?\x8FCB) ;; <CJK>
     (?$(1(o(B . ?\x8FD3) ;; <CJK>
     (?$(1(p(B . ?\x8FCD) ;; <CJK>
     (?$(1(q(B . ?\x8FD6) ;; <CJK>
     (?$(1(r(B . ?\x8FD5) ;; <CJK>
     (?$(1(s(B . ?\x8FD7) ;; <CJK>
     (?$(1(t(B . ?\x90B2) ;; <CJK>
     (?$(1(u(B . ?\x90B4) ;; <CJK>
     (?$(1(v(B . ?\x90AF) ;; <CJK>
     (?$(1(w(B . ?\x90B3) ;; <CJK>
     (?$(1(x(B . ?\x90B0) ;; <CJK>
     (?$(1(y(B . ?\x9639) ;; <CJK>
     (?$(1(z(B . ?\x963D) ;; <CJK>
     (?$(1({(B . ?\x963C) ;; <CJK>
     (?$(1(|(B . ?\x963A) ;; <CJK>
     (?$(1(}(B . ?\x9643) ;; <CJK>
     (?$(1(~(B . ?\x4FCD) ;; <CJK>
     (?$(1)!(B . ?\x4FC5) ;; <CJK>
     (?$(1)"(B . ?\x4FD3) ;; <CJK>
     (?$(1)#(B . ?\x4FB2) ;; <CJK>
     (?$(1)$(B . ?\x4FC9) ;; <CJK>
     (?$(1)%(B . ?\x4FCB) ;; <CJK>
     (?$(1)&(B . ?\x4FC1) ;; <CJK>
     (?$(1)'(B . ?\x4FD4) ;; <CJK>
     (?$(1)((B . ?\x4FDC) ;; <CJK>
     (?$(1))(B . ?\x4FD9) ;; <CJK>
     (?$(1)*(B . ?\x4FBB) ;; <CJK>
     (?$(1)+(B . ?\x4FB3) ;; <CJK>
     (?$(1),(B . ?\x4FDB) ;; <CJK>
     (?$(1)-(B . ?\x4FC7) ;; <CJK>
     (?$(1).(B . ?\x4FD6) ;; <CJK>
     (?$(1)/(B . ?\x4FBA) ;; <CJK>
     (?$(1)0(B . ?\x4FC0) ;; <CJK>
     (?$(1)1(B . ?\x4FB9) ;; <CJK>
     (?$(1)2(B . ?\x4FEC) ;; <CJK>
     (?$(1)3(B . ?\x5244) ;; <CJK>
     (?$(1)4(B . ?\x5249) ;; <CJK>
     (?$(1)5(B . ?\x52C0) ;; <CJK>
     (?$(1)6(B . ?\x52C2) ;; <CJK>
     (?$(1)7(B . ?\x533D) ;; <CJK>
     (?$(1)8(B . ?\x537C) ;; <CJK>
     (?$(1)9(B . ?\x5397) ;; <CJK>
     (?$(1):(B . ?\x5396) ;; <CJK>
     (?$(1);(B . ?\x5399) ;; <CJK>
     (?$(1)<(B . ?\x5398) ;; <CJK>
     (?$(1)=(B . ?\x54BA) ;; <CJK>
     (?$(1)>(B . ?\x54A1) ;; <CJK>
     (?$(1)?(B . ?\x54AD) ;; <CJK>
     (?$(1)@(B . ?\x54A5) ;; <CJK>
     (?$(1)A(B . ?\x54CF) ;; <CJK>
     (?$(1)B(B . ?\x54C3) ;; <CJK>
     (?$(1)C(B . ?\x830D) ;; <CJK>
     (?$(1)D(B . ?\x54B7) ;; <CJK>
     (?$(1)E(B . ?\x54AE) ;; <CJK>
     (?$(1)F(B . ?\x54D6) ;; <CJK>
     (?$(1)G(B . ?\x54B6) ;; <CJK>
     (?$(1)H(B . ?\x54C5) ;; <CJK>
     (?$(1)I(B . ?\x54C6) ;; <CJK>
     (?$(1)J(B . ?\x54A0) ;; <CJK>
     (?$(1)K(B . ?\x5470) ;; <CJK>
     (?$(1)L(B . ?\x54BC) ;; <CJK>
     (?$(1)M(B . ?\x54A2) ;; <CJK>
     (?$(1)N(B . ?\x54BE) ;; <CJK>
     (?$(1)O(B . ?\x5472) ;; <CJK>
     (?$(1)P(B . ?\x54DE) ;; <CJK>
     (?$(1)Q(B . ?\x54B0) ;; <CJK>
     (?$(1)R(B . ?\x57B5) ;; <CJK>
     (?$(1)S(B . ?\x579E) ;; <CJK>
     (?$(1)T(B . ?\x579F) ;; <CJK>
     (?$(1)U(B . ?\x57A4) ;; <CJK>
     (?$(1)V(B . ?\x578C) ;; <CJK>
     (?$(1)W(B . ?\x5797) ;; <CJK>
     (?$(1)X(B . ?\x579D) ;; <CJK>
     (?$(1)Y(B . ?\x579B) ;; <CJK>
     (?$(1)Z(B . ?\x5794) ;; <CJK>
     (?$(1)[(B . ?\x5798) ;; <CJK>
     (?$(1)\(B . ?\x578F) ;; <CJK>
     (?$(1)](B . ?\x5799) ;; <CJK>
     (?$(1)^(B . ?\x57A5) ;; <CJK>
     (?$(1)_(B . ?\x579A) ;; <CJK>
     (?$(1)`(B . ?\x5795) ;; <CJK>
     (?$(1)a(B . ?\x58F4) ;; <CJK>
     (?$(1)b(B . ?\x590D) ;; <CJK>
     (?$(1)c(B . ?\x5953) ;; <CJK>
     (?$(1)d(B . ?\x59E1) ;; <CJK>
     (?$(1)e(B . ?\x59DE) ;; <CJK>
     (?$(1)f(B . ?\x59EE) ;; <CJK>
     (?$(1)g(B . ?\x5A00) ;; <CJK>
     (?$(1)h(B . ?\x59F1) ;; <CJK>
     (?$(1)i(B . ?\x59DD) ;; <CJK>
     (?$(1)j(B . ?\x59FA) ;; <CJK>
     (?$(1)k(B . ?\x59FD) ;; <CJK>
     (?$(1)l(B . ?\x59FC) ;; <CJK>
     (?$(1)m(B . ?\x59F6) ;; <CJK>
     (?$(1)n(B . ?\x59E4) ;; <CJK>
     (?$(1)o(B . ?\x59F2) ;; <CJK>
     (?$(1)p(B . ?\x59F7) ;; <CJK>
     (?$(1)q(B . ?\x59DB) ;; <CJK>
     (?$(1)r(B . ?\x59E9) ;; <CJK>
     (?$(1)s(B . ?\x59F3) ;; <CJK>
     (?$(1)t(B . ?\x59F5) ;; <CJK>
     (?$(1)u(B . ?\x59E0) ;; <CJK>
     (?$(1)v(B . ?\x59FE) ;; <CJK>
     (?$(1)w(B . ?\x59F4) ;; <CJK>
     (?$(1)x(B . ?\x59ED) ;; <CJK>
     (?$(1)y(B . ?\x5BA8) ;; <CJK>
     (?$(1)z(B . ?\x5C4C) ;; <CJK>
     (?$(1){(B . ?\x5CD0) ;; <CJK>
     (?$(1)|(B . ?\x5CD8) ;; <CJK>
     (?$(1)}(B . ?\x5CCC) ;; <CJK>
     (?$(1)~(B . ?\x5CD7) ;; <CJK>
     (?$(1*!(B . ?\x5CCB) ;; <CJK>
     (?$(1*"(B . ?\x5CDB) ;; <CJK>
     (?$(1*#(B . ?\x5CDE) ;; <CJK>
     (?$(1*$(B . ?\x5CDA) ;; <CJK>
     (?$(1*%(B . ?\x5CC9) ;; <CJK>
     (?$(1*&(B . ?\x5CC7) ;; <CJK>
     (?$(1*'(B . ?\x5CCA) ;; <CJK>
     (?$(1*((B . ?\x5CD6) ;; <CJK>
     (?$(1*)(B . ?\x5CD3) ;; <CJK>
     (?$(1**(B . ?\x5CD4) ;; <CJK>
     (?$(1*+(B . ?\x5CCF) ;; <CJK>
     (?$(1*,(B . ?\x5CC8) ;; <CJK>
     (?$(1*-(B . ?\x5CC6) ;; <CJK>
     (?$(1*.(B . ?\x5CCE) ;; <CJK>
     (?$(1*/(B . ?\x5CDF) ;; <CJK>
     (?$(1*0(B . ?\x5CF8) ;; <CJK>
     (?$(1*1(B . ?\x5DF9) ;; <CJK>
     (?$(1*2(B . ?\x5E21) ;; <CJK>
     (?$(1*3(B . ?\x5E22) ;; <CJK>
     (?$(1*4(B . ?\x5E23) ;; <CJK>
     (?$(1*5(B . ?\x5E20) ;; <CJK>
     (?$(1*6(B . ?\x5E24) ;; <CJK>
     (?$(1*7(B . ?\x5EB0) ;; <CJK>
     (?$(1*8(B . ?\x5EA4) ;; <CJK>
     (?$(1*9(B . ?\x5EA2) ;; <CJK>
     (?$(1*:(B . ?\x5E9B) ;; <CJK>
     (?$(1*;(B . ?\x5EA3) ;; <CJK>
     (?$(1*<(B . ?\x5EA5) ;; <CJK>
     (?$(1*=(B . ?\x5F07) ;; <CJK>
     (?$(1*>(B . ?\x5F2E) ;; <CJK>
     (?$(1*?(B . ?\x5F56) ;; <CJK>
     (?$(1*@(B . ?\x5F86) ;; <CJK>
     (?$(1*A(B . ?\x6037) ;; <CJK>
     (?$(1*B(B . ?\x6039) ;; <CJK>
     (?$(1*C(B . ?\x6054) ;; <CJK>
     (?$(1*D(B . ?\x6072) ;; <CJK>
     (?$(1*E(B . ?\x605E) ;; <CJK>
     (?$(1*F(B . ?\x6045) ;; <CJK>
     (?$(1*G(B . ?\x6053) ;; <CJK>
     (?$(1*H(B . ?\x6047) ;; <CJK>
     (?$(1*I(B . ?\x6049) ;; <CJK>
     (?$(1*J(B . ?\x605B) ;; <CJK>
     (?$(1*K(B . ?\x604C) ;; <CJK>
     (?$(1*L(B . ?\x6040) ;; <CJK>
     (?$(1*M(B . ?\x6042) ;; <CJK>
     (?$(1*N(B . ?\x605F) ;; <CJK>
     (?$(1*O(B . ?\x6024) ;; <CJK>
     (?$(1*P(B . ?\x6044) ;; <CJK>
     (?$(1*Q(B . ?\x6058) ;; <CJK>
     (?$(1*R(B . ?\x6066) ;; <CJK>
     (?$(1*S(B . ?\x606E) ;; <CJK>
     (?$(1*T(B . ?\x6242) ;; <CJK>
     (?$(1*U(B . ?\x6243) ;; <CJK>
     (?$(1*V(B . ?\x62CF) ;; <CJK>
     (?$(1*W(B . ?\x630D) ;; <CJK>
     (?$(1*X(B . ?\x630B) ;; <CJK>
     (?$(1*Y(B . ?\x62F5) ;; <CJK>
     (?$(1*Z(B . ?\x630E) ;; <CJK>
     (?$(1*[(B . ?\x6303) ;; <CJK>
     (?$(1*\(B . ?\x62EB) ;; <CJK>
     (?$(1*](B . ?\x62F9) ;; <CJK>
     (?$(1*^(B . ?\x630F) ;; <CJK>
     (?$(1*_(B . ?\x630C) ;; <CJK>
     (?$(1*`(B . ?\x62F8) ;; <CJK>
     (?$(1*a(B . ?\x62F6) ;; <CJK>
     (?$(1*b(B . ?\x6300) ;; <CJK>
     (?$(1*c(B . ?\x6313) ;; <CJK>
     (?$(1*d(B . ?\x6314) ;; <CJK>
     (?$(1*e(B . ?\x62FA) ;; <CJK>
     (?$(1*f(B . ?\x6315) ;; <CJK>
     (?$(1*g(B . ?\x62FB) ;; <CJK>
     (?$(1*h(B . ?\x62F0) ;; <CJK>
     (?$(1*i(B . ?\x6541) ;; <CJK>
     (?$(1*j(B . ?\x6543) ;; <CJK>
     (?$(1*k(B . ?\x65AA) ;; <CJK>
     (?$(1*l(B . ?\x65BF) ;; <CJK>
     (?$(1*m(B . ?\x6636) ;; <CJK>
     (?$(1*n(B . ?\x6621) ;; <CJK>
     (?$(1*o(B . ?\x6632) ;; <CJK>
     (?$(1*p(B . ?\x6635) ;; <CJK>
     (?$(1*q(B . ?\x661C) ;; <CJK>
     (?$(1*r(B . ?\x6626) ;; <CJK>
     (?$(1*s(B . ?\x6622) ;; <CJK>
     (?$(1*t(B . ?\x6633) ;; <CJK>
     (?$(1*u(B . ?\x662B) ;; <CJK>
     (?$(1*v(B . ?\x663A) ;; <CJK>
     (?$(1*w(B . ?\x661D) ;; <CJK>
     (?$(1*x(B . ?\x6634) ;; <CJK>
     (?$(1*y(B . ?\x6639) ;; <CJK>
     (?$(1*z(B . ?\x662E) ;; <CJK>
     (?$(1*{(B . ?\x670F) ;; <CJK>
     (?$(1*|(B . ?\x6710) ;; <CJK>
     (?$(1*}(B . ?\x67C1) ;; <CJK>
     (?$(1*~(B . ?\x67F2) ;; <CJK>
     (?$(1+!(B . ?\x67C8) ;; <CJK>
     (?$(1+"(B . ?\x67BA) ;; <CJK>
     (?$(1+#(B . ?\x67DC) ;; <CJK>
     (?$(1+$(B . ?\x67BB) ;; <CJK>
     (?$(1+%(B . ?\x67F8) ;; <CJK>
     (?$(1+&(B . ?\x67D8) ;; <CJK>
     (?$(1+'(B . ?\x67C0) ;; <CJK>
     (?$(1+((B . ?\x67B7) ;; <CJK>
     (?$(1+)(B . ?\x67C5) ;; <CJK>
     (?$(1+*(B . ?\x67EB) ;; <CJK>
     (?$(1++(B . ?\x67E4) ;; <CJK>
     (?$(1+,(B . ?\x67DF) ;; <CJK>
     (?$(1+-(B . ?\x67B5) ;; <CJK>
     (?$(1+.(B . ?\x67CD) ;; <CJK>
     (?$(1+/(B . ?\x67B3) ;; <CJK>
     (?$(1+0(B . ?\x67F7) ;; <CJK>
     (?$(1+1(B . ?\x67F6) ;; <CJK>
     (?$(1+2(B . ?\x67EE) ;; <CJK>
     (?$(1+3(B . ?\x67E3) ;; <CJK>
     (?$(1+4(B . ?\x67C2) ;; <CJK>
     (?$(1+5(B . ?\x67B9) ;; <CJK>
     (?$(1+6(B . ?\x67CE) ;; <CJK>
     (?$(1+7(B . ?\x67E7) ;; <CJK>
     (?$(1+8(B . ?\x67F0) ;; <CJK>
     (?$(1+9(B . ?\x67B2) ;; <CJK>
     (?$(1+:(B . ?\x67FC) ;; <CJK>
     (?$(1+;(B . ?\x67C6) ;; <CJK>
     (?$(1+<(B . ?\x67ED) ;; <CJK>
     (?$(1+=(B . ?\x67CC) ;; <CJK>
     (?$(1+>(B . ?\x67AE) ;; <CJK>
     (?$(1+?(B . ?\x67E6) ;; <CJK>
     (?$(1+@(B . ?\x67DB) ;; <CJK>
     (?$(1+A(B . ?\x67FA) ;; <CJK>
     (?$(1+B(B . ?\x67C9) ;; <CJK>
     (?$(1+C(B . ?\x67CA) ;; <CJK>
     (?$(1+D(B . ?\x67C3) ;; <CJK>
     (?$(1+E(B . ?\x67EA) ;; <CJK>
     (?$(1+F(B . ?\x67CB) ;; <CJK>
     (?$(1+G(B . ?\x6B28) ;; <CJK>
     (?$(1+H(B . ?\x6B82) ;; <CJK>
     (?$(1+I(B . ?\x6B84) ;; <CJK>
     (?$(1+J(B . ?\x6BB6) ;; <CJK>
     (?$(1+K(B . ?\x6BD6) ;; <CJK>
     (?$(1+L(B . ?\x6BD8) ;; <CJK>
     (?$(1+M(B . ?\x6BE0) ;; <CJK>
     (?$(1+N(B . ?\x6C20) ;; <CJK>
     (?$(1+O(B . ?\x6C21) ;; <CJK>
     (?$(1+P(B . ?\x6D28) ;; <CJK>
     (?$(1+Q(B . ?\x6D34) ;; <CJK>
     (?$(1+R(B . ?\x6D2D) ;; <CJK>
     (?$(1+S(B . ?\x6D1F) ;; <CJK>
     (?$(1+T(B . ?\x6D3C) ;; <CJK>
     (?$(1+U(B . ?\x6D3F) ;; <CJK>
     (?$(1+V(B . ?\x6D12) ;; <CJK>
     (?$(1+W(B . ?\x6D0A) ;; <CJK>
     (?$(1+X(B . ?\x6CDA) ;; <CJK>
     (?$(1+Y(B . ?\x6D33) ;; <CJK>
     (?$(1+Z(B . ?\x6D04) ;; <CJK>
     (?$(1+[(B . ?\x6D19) ;; <CJK>
     (?$(1+\(B . ?\x6D3A) ;; <CJK>
     (?$(1+](B . ?\x6D1A) ;; <CJK>
     (?$(1+^(B . ?\x6D11) ;; <CJK>
     (?$(1+_(B . ?\x6D00) ;; <CJK>
     (?$(1+`(B . ?\x6D1D) ;; <CJK>
     (?$(1+a(B . ?\x6D42) ;; <CJK>
     (?$(1+b(B . ?\x6D01) ;; <CJK>
     (?$(1+c(B . ?\x6D18) ;; <CJK>
     (?$(1+d(B . ?\x6D37) ;; <CJK>
     (?$(1+e(B . ?\x6D03) ;; <CJK>
     (?$(1+f(B . ?\x6D0F) ;; <CJK>
     (?$(1+g(B . ?\x6D40) ;; <CJK>
     (?$(1+h(B . ?\x6D07) ;; <CJK>
     (?$(1+i(B . ?\x6D20) ;; <CJK>
     (?$(1+j(B . ?\x6D2C) ;; <CJK>
     (?$(1+k(B . ?\x6D08) ;; <CJK>
     (?$(1+l(B . ?\x6D22) ;; <CJK>
     (?$(1+m(B . ?\x6D09) ;; <CJK>
     (?$(1+n(B . ?\x6D10) ;; <CJK>
     (?$(1+o(B . ?\x70B7) ;; <CJK>
     (?$(1+p(B . ?\x709F) ;; <CJK>
     (?$(1+q(B . ?\x70BE) ;; <CJK>
     (?$(1+r(B . ?\x70B1) ;; <CJK>
     (?$(1+s(B . ?\x70B0) ;; <CJK>
     (?$(1+t(B . ?\x70A1) ;; <CJK>
     (?$(1+u(B . ?\x70B4) ;; <CJK>
     (?$(1+v(B . ?\x70B5) ;; <CJK>
     (?$(1+w(B . ?\x70A9) ;; <CJK>
     (?$(1+x(B . ?\x7241) ;; <CJK>
     (?$(1+y(B . ?\x7249) ;; <CJK>
     (?$(1+z(B . ?\x724A) ;; <CJK>
     (?$(1+{(B . ?\x726C) ;; <CJK>
     (?$(1+|(B . ?\x7270) ;; <CJK>
     (?$(1+}(B . ?\x7273) ;; <CJK>
     (?$(1+~(B . ?\x726E) ;; <CJK>
     (?$(1,!(B . ?\x72CA) ;; <CJK>
     (?$(1,"(B . ?\x72E4) ;; <CJK>
     (?$(1,#(B . ?\x72E8) ;; <CJK>
     (?$(1,$(B . ?\x72EB) ;; <CJK>
     (?$(1,%(B . ?\x72DF) ;; <CJK>
     (?$(1,&(B . ?\x72EA) ;; <CJK>
     (?$(1,'(B . ?\x72E6) ;; <CJK>
     (?$(1,((B . ?\x72E3) ;; <CJK>
     (?$(1,)(B . ?\x7385) ;; <CJK>
     (?$(1,*(B . ?\x73CC) ;; <CJK>
     (?$(1,+(B . ?\x73C2) ;; <CJK>
     (?$(1,,(B . ?\x73C8) ;; <CJK>
     (?$(1,-(B . ?\x73C5) ;; <CJK>
     (?$(1,.(B . ?\x73B9) ;; <CJK>
     (?$(1,/(B . ?\x73B6) ;; <CJK>
     (?$(1,0(B . ?\x73B5) ;; <CJK>
     (?$(1,1(B . ?\x73B4) ;; <CJK>
     (?$(1,2(B . ?\x73EB) ;; <CJK>
     (?$(1,3(B . ?\x73BF) ;; <CJK>
     (?$(1,4(B . ?\x73C7) ;; <CJK>
     (?$(1,5(B . ?\x73BE) ;; <CJK>
     (?$(1,6(B . ?\x73C3) ;; <CJK>
     (?$(1,7(B . ?\x73C6) ;; <CJK>
     (?$(1,8(B . ?\x73B8) ;; <CJK>
     (?$(1,9(B . ?\x73CB) ;; <CJK>
     (?$(1,:(B . ?\x74EC) ;; <CJK>
     (?$(1,;(B . ?\x74EE) ;; <CJK>
     (?$(1,<(B . ?\x752E) ;; <CJK>
     (?$(1,=(B . ?\x7547) ;; <CJK>
     (?$(1,>(B . ?\x7548) ;; <CJK>
     (?$(1,?(B . ?\x75A7) ;; <CJK>
     (?$(1,@(B . ?\x75AA) ;; <CJK>
     (?$(1,A(B . ?\x7679) ;; <CJK>
     (?$(1,B(B . ?\x76C4) ;; <CJK>
     (?$(1,C(B . ?\x7708) ;; <CJK>
     (?$(1,D(B . ?\x7703) ;; <CJK>
     (?$(1,E(B . ?\x7704) ;; <CJK>
     (?$(1,F(B . ?\x7705) ;; <CJK>
     (?$(1,G(B . ?\x770A) ;; <CJK>
     (?$(1,H(B . ?\x76F7) ;; <CJK>
     (?$(1,I(B . ?\x76FB) ;; <CJK>
     (?$(1,J(B . ?\x76FA) ;; <CJK>
     (?$(1,K(B . ?\x77E7) ;; <CJK>
     (?$(1,L(B . ?\x77E8) ;; <CJK>
     (?$(1,M(B . ?\x7806) ;; <CJK>
     (?$(1,N(B . ?\x7811) ;; <CJK>
     (?$(1,O(B . ?\x7812) ;; <CJK>
     (?$(1,P(B . ?\x7805) ;; <CJK>
     (?$(1,Q(B . ?\x7810) ;; <CJK>
     (?$(1,R(B . ?\x780F) ;; <CJK>
     (?$(1,S(B . ?\x780E) ;; <CJK>
     (?$(1,T(B . ?\x7809) ;; <CJK>
     (?$(1,U(B . ?\x7803) ;; <CJK>
     (?$(1,V(B . ?\x7813) ;; <CJK>
     (?$(1,W(B . ?\x794A) ;; <CJK>
     (?$(1,X(B . ?\x794C) ;; <CJK>
     (?$(1,Y(B . ?\x794B) ;; <CJK>
     (?$(1,Z(B . ?\x7945) ;; <CJK>
     (?$(1,[(B . ?\x7944) ;; <CJK>
     (?$(1,\(B . ?\x79D5) ;; <CJK>
     (?$(1,](B . ?\x79CD) ;; <CJK>
     (?$(1,^(B . ?\x79CF) ;; <CJK>
     (?$(1,_(B . ?\x79D6) ;; <CJK>
     (?$(1,`(B . ?\x79CE) ;; <CJK>
     (?$(1,a(B . ?\x7A80) ;; <CJK>
     (?$(1,b(B . ?\x7A7E) ;; <CJK>
     (?$(1,c(B . ?\x7AD1) ;; <CJK>
     (?$(1,d(B . ?\x7B00) ;; <CJK>
     (?$(1,e(B . ?\x7B01) ;; <CJK>
     (?$(1,f(B . ?\x7C7A) ;; <CJK>
     (?$(1,g(B . ?\x7C78) ;; <CJK>
     (?$(1,h(B . ?\x7C79) ;; <CJK>
     (?$(1,i(B . ?\x7C7F) ;; <CJK>
     (?$(1,j(B . ?\x7C80) ;; <CJK>
     (?$(1,k(B . ?\x7C81) ;; <CJK>
     (?$(1,l(B . ?\x7D03) ;; <CJK>
     (?$(1,m(B . ?\x7D08) ;; <CJK>
     (?$(1,n(B . ?\x7D01) ;; <CJK>
     (?$(1,o(B . ?\x7F58) ;; <CJK>
     (?$(1,p(B . ?\x7F91) ;; <CJK>
     (?$(1,q(B . ?\x7F8D) ;; <CJK>
     (?$(1,r(B . ?\x7FBE) ;; <CJK>
     (?$(1,s(B . ?\x8007) ;; <CJK>
     (?$(1,t(B . ?\x800E) ;; <CJK>
     (?$(1,u(B . ?\x800F) ;; <CJK>
     (?$(1,v(B . ?\x8014) ;; <CJK>
     (?$(1,w(B . ?\x8037) ;; <CJK>
     (?$(1,x(B . ?\x80D8) ;; <CJK>
     (?$(1,y(B . ?\x80C7) ;; <CJK>
     (?$(1,z(B . ?\x80E0) ;; <CJK>
     (?$(1,{(B . ?\x80D1) ;; <CJK>
     (?$(1,|(B . ?\x80C8) ;; <CJK>
     (?$(1,}(B . ?\x80C2) ;; <CJK>
     (?$(1,~(B . ?\x80D0) ;; <CJK>
     (?$(1-!(B . ?\x80C5) ;; <CJK>
     (?$(1-"(B . ?\x80E3) ;; <CJK>
     (?$(1-#(B . ?\x80D9) ;; <CJK>
     (?$(1-$(B . ?\x80DC) ;; <CJK>
     (?$(1-%(B . ?\x80CA) ;; <CJK>
     (?$(1-&(B . ?\x80D5) ;; <CJK>
     (?$(1-'(B . ?\x80C9) ;; <CJK>
     (?$(1-((B . ?\x80CF) ;; <CJK>
     (?$(1-)(B . ?\x80D7) ;; <CJK>
     (?$(1-*(B . ?\x80E6) ;; <CJK>
     (?$(1-+(B . ?\x80CD) ;; <CJK>
     (?$(1-,(B . ?\x81FF) ;; <CJK>
     (?$(1--(B . ?\x8221) ;; <CJK>
     (?$(1-.(B . ?\x8294) ;; <CJK>
     (?$(1-/(B . ?\x82D9) ;; <CJK>
     (?$(1-0(B . ?\x82FE) ;; <CJK>
     (?$(1-1(B . ?\x82F9) ;; <CJK>
     (?$(1-2(B . ?\x8307) ;; <CJK>
     (?$(1-3(B . ?\x82E8) ;; <CJK>
     (?$(1-4(B . ?\x8300) ;; <CJK>
     (?$(1-5(B . ?\x82D5) ;; <CJK>
     (?$(1-6(B . ?\x833A) ;; <CJK>
     (?$(1-7(B . ?\x82EB) ;; <CJK>
     (?$(1-8(B . ?\x82D6) ;; <CJK>
     (?$(1-9(B . ?\x82F4) ;; <CJK>
     (?$(1-:(B . ?\x82EC) ;; <CJK>
     (?$(1-;(B . ?\x82E1) ;; <CJK>
     (?$(1-<(B . ?\x82F2) ;; <CJK>
     (?$(1-=(B . ?\x82F5) ;; <CJK>
     (?$(1->(B . ?\x830C) ;; <CJK>
     (?$(1-?(B . ?\x82FB) ;; <CJK>
     (?$(1-@(B . ?\x82F6) ;; <CJK>
     (?$(1-A(B . ?\x82F0) ;; <CJK>
     (?$(1-B(B . ?\x82EA) ;; <CJK>
     (?$(1-C(B . ?\x82E4) ;; <CJK>
     (?$(1-D(B . ?\x82E0) ;; <CJK>
     (?$(1-E(B . ?\x82FA) ;; <CJK>
     (?$(1-F(B . ?\x82F3) ;; <CJK>
     (?$(1-G(B . ?\x82ED) ;; <CJK>
     (?$(1-H(B . ?\x8677) ;; <CJK>
     (?$(1-I(B . ?\x8674) ;; <CJK>
     (?$(1-J(B . ?\x867C) ;; <CJK>
     (?$(1-K(B . ?\x8673) ;; <CJK>
     (?$(1-L(B . ?\x8841) ;; <CJK>
     (?$(1-M(B . ?\x884E) ;; <CJK>
     (?$(1-N(B . ?\x8867) ;; <CJK>
     (?$(1-O(B . ?\x886A) ;; <CJK>
     (?$(1-P(B . ?\x8869) ;; <CJK>
     (?$(1-Q(B . ?\x89D3) ;; <CJK>
     (?$(1-R(B . ?\x8A04) ;; <CJK>
     (?$(1-S(B . ?\x8A07) ;; <CJK>
     (?$(1-T(B . ?\x8D72) ;; <CJK>
     (?$(1-U(B . ?\x8FE3) ;; <CJK>
     (?$(1-V(B . ?\x8FE1) ;; <CJK>
     (?$(1-W(B . ?\x8FEE) ;; <CJK>
     (?$(1-X(B . ?\x8FE0) ;; <CJK>
     (?$(1-Y(B . ?\x90F1) ;; <CJK>
     (?$(1-Z(B . ?\x90BD) ;; <CJK>
     (?$(1-[(B . ?\x90BF) ;; <CJK>
     (?$(1-\(B . ?\x90D5) ;; <CJK>
     (?$(1-](B . ?\x90C5) ;; <CJK>
     (?$(1-^(B . ?\x90BE) ;; <CJK>
     (?$(1-_(B . ?\x90C7) ;; <CJK>
     (?$(1-`(B . ?\x90CB) ;; <CJK>
     (?$(1-a(B . ?\x90C8) ;; <CJK>
     (?$(1-b(B . ?\x91D4) ;; <CJK>
     (?$(1-c(B . ?\x91D3) ;; <CJK>
     (?$(1-d(B . ?\x9654) ;; <CJK>
     (?$(1-e(B . ?\x964F) ;; <CJK>
     (?$(1-f(B . ?\x9651) ;; <CJK>
     (?$(1-g(B . ?\x9653) ;; <CJK>
     (?$(1-h(B . ?\x964A) ;; <CJK>
     (?$(1-i(B . ?\x964E) ;; <CJK>
     (?$(1-j(B . ?\x501E) ;; <CJK>
     (?$(1-k(B . ?\x5005) ;; <CJK>
     (?$(1-l(B . ?\x5007) ;; <CJK>
     (?$(1-m(B . ?\x5013) ;; <CJK>
     (?$(1-n(B . ?\x5022) ;; <CJK>
     (?$(1-o(B . ?\x5030) ;; <CJK>
     (?$(1-p(B . ?\x501B) ;; <CJK>
     (?$(1-q(B . ?\x4FF5) ;; <CJK>
     (?$(1-r(B . ?\x4FF4) ;; <CJK>
     (?$(1-s(B . ?\x5033) ;; <CJK>
     (?$(1-t(B . ?\x5037) ;; <CJK>
     (?$(1-u(B . ?\x502C) ;; <CJK>
     (?$(1-v(B . ?\x4FF6) ;; <CJK>
     (?$(1-w(B . ?\x4FF7) ;; <CJK>
     (?$(1-x(B . ?\x5017) ;; <CJK>
     (?$(1-y(B . ?\x501C) ;; <CJK>
     (?$(1-z(B . ?\x5020) ;; <CJK>
     (?$(1-{(B . ?\x5027) ;; <CJK>
     (?$(1-|(B . ?\x5035) ;; <CJK>
     (?$(1-}(B . ?\x502F) ;; <CJK>
     (?$(1-~(B . ?\x5031) ;; <CJK>
     (?$(1.!(B . ?\x500E) ;; <CJK>
     (?$(1."(B . ?\x515A) ;; <CJK>
     (?$(1.#(B . ?\x5194) ;; <CJK>
     (?$(1.$(B . ?\x5193) ;; <CJK>
     (?$(1.%(B . ?\x51CA) ;; <CJK>
     (?$(1.&(B . ?\x51C4) ;; <CJK>
     (?$(1.'(B . ?\x51C5) ;; <CJK>
     (?$(1.((B . ?\x51C8) ;; <CJK>
     (?$(1.)(B . ?\x51CE) ;; <CJK>
     (?$(1.*(B . ?\x5261) ;; <CJK>
     (?$(1.+(B . ?\x525A) ;; <CJK>
     (?$(1.,(B . ?\x5252) ;; <CJK>
     (?$(1.-(B . ?\x525E) ;; <CJK>
     (?$(1..(B . ?\x525F) ;; <CJK>
     (?$(1./(B . ?\x5255) ;; <CJK>
     (?$(1.0(B . ?\x5262) ;; <CJK>
     (?$(1.1(B . ?\x52CD) ;; <CJK>
     (?$(1.2(B . ?\x530E) ;; <CJK>
     (?$(1.3(B . ?\x539E) ;; <CJK>
     (?$(1.4(B . ?\x5526) ;; <CJK>
     (?$(1.5(B . ?\x54E2) ;; <CJK>
     (?$(1.6(B . ?\x5517) ;; <CJK>
     (?$(1.7(B . ?\x5512) ;; <CJK>
     (?$(1.8(B . ?\x54E7) ;; <CJK>
     (?$(1.9(B . ?\x54F3) ;; <CJK>
     (?$(1.:(B . ?\x54E4) ;; <CJK>
     (?$(1.;(B . ?\x551A) ;; <CJK>
     (?$(1.<(B . ?\x54FF) ;; <CJK>
     (?$(1.=(B . ?\x5504) ;; <CJK>
     (?$(1.>(B . ?\x5508) ;; <CJK>
     (?$(1.?(B . ?\x54EB) ;; <CJK>
     (?$(1.@(B . ?\x5511) ;; <CJK>
     (?$(1.A(B . ?\x5505) ;; <CJK>
     (?$(1.B(B . ?\x54F1) ;; <CJK>
     (?$(1.C(B . ?\x550A) ;; <CJK>
     (?$(1.D(B . ?\x54FB) ;; <CJK>
     (?$(1.E(B . ?\x54F7) ;; <CJK>
     (?$(1.F(B . ?\x54F8) ;; <CJK>
     (?$(1.G(B . ?\x54E0) ;; <CJK>
     (?$(1.H(B . ?\x550E) ;; <CJK>
     (?$(1.I(B . ?\x5503) ;; <CJK>
     (?$(1.J(B . ?\x550B) ;; <CJK>
     (?$(1.K(B . ?\x5701) ;; <CJK>
     (?$(1.L(B . ?\x5702) ;; <CJK>
     (?$(1.M(B . ?\x57CC) ;; <CJK>
     (?$(1.N(B . ?\x5832) ;; <CJK>
     (?$(1.O(B . ?\x57D5) ;; <CJK>
     (?$(1.P(B . ?\x57D2) ;; <CJK>
     (?$(1.Q(B . ?\x57BA) ;; <CJK>
     (?$(1.R(B . ?\x57C6) ;; <CJK>
     (?$(1.S(B . ?\x57BD) ;; <CJK>
     (?$(1.T(B . ?\x57BC) ;; <CJK>
     (?$(1.U(B . ?\x57B8) ;; <CJK>
     (?$(1.V(B . ?\x57B6) ;; <CJK>
     (?$(1.W(B . ?\x57BF) ;; <CJK>
     (?$(1.X(B . ?\x57C7) ;; <CJK>
     (?$(1.Y(B . ?\x57D0) ;; <CJK>
     (?$(1.Z(B . ?\x57B9) ;; <CJK>
     (?$(1.[(B . ?\x57C1) ;; <CJK>
     (?$(1.\(B . ?\x590E) ;; <CJK>
     (?$(1.](B . ?\x594A) ;; <CJK>
     (?$(1.^(B . ?\x5A19) ;; <CJK>
     (?$(1._(B . ?\x5A16) ;; <CJK>
     (?$(1.`(B . ?\x5A2D) ;; <CJK>
     (?$(1.a(B . ?\x5A2E) ;; <CJK>
     (?$(1.b(B . ?\x5A15) ;; <CJK>
     (?$(1.c(B . ?\x5A0F) ;; <CJK>
     (?$(1.d(B . ?\x5A17) ;; <CJK>
     (?$(1.e(B . ?\x5A0A) ;; <CJK>
     (?$(1.f(B . ?\x5A1E) ;; <CJK>
     (?$(1.g(B . ?\x5A33) ;; <CJK>
     (?$(1.h(B . ?\x5B6C) ;; <CJK>
     (?$(1.i(B . ?\x5BA7) ;; <CJK>
     (?$(1.j(B . ?\x5BAD) ;; <CJK>
     (?$(1.k(B . ?\x5BAC) ;; <CJK>
     (?$(1.l(B . ?\x5C03) ;; <CJK>
     (?$(1.m(B . ?\x5C56) ;; <CJK>
     (?$(1.n(B . ?\x5C54) ;; <CJK>
     (?$(1.o(B . ?\x5CEC) ;; <CJK>
     (?$(1.p(B . ?\x5CFF) ;; <CJK>
     (?$(1.q(B . ?\x5CEE) ;; <CJK>
     (?$(1.r(B . ?\x5CF1) ;; <CJK>
     (?$(1.s(B . ?\x5CF7) ;; <CJK>
     (?$(1.t(B . ?\x5D00) ;; <CJK>
     (?$(1.u(B . ?\x5CF9) ;; <CJK>
     (?$(1.v(B . ?\x5E29) ;; <CJK>
     (?$(1.w(B . ?\x5E28) ;; <CJK>
     (?$(1.x(B . ?\x5EA8) ;; <CJK>
     (?$(1.y(B . ?\x5EAE) ;; <CJK>
     (?$(1.z(B . ?\x5EAA) ;; <CJK>
     (?$(1.{(B . ?\x5EAC) ;; <CJK>
     (?$(1.|(B . ?\x5F33) ;; <CJK>
     (?$(1.}(B . ?\x5F30) ;; <CJK>
     (?$(1.~(B . ?\x5F67) ;; <CJK>
     (?$(1/!(B . ?\x605D) ;; <CJK>
     (?$(1/"(B . ?\x605A) ;; <CJK>
     (?$(1/#(B . ?\x6067) ;; <CJK>
     (?$(1/$(B . ?\x6041) ;; <CJK>
     (?$(1/%(B . ?\x60A2) ;; <CJK>
     (?$(1/&(B . ?\x6088) ;; <CJK>
     (?$(1/'(B . ?\x6080) ;; <CJK>
     (?$(1/((B . ?\x6092) ;; <CJK>
     (?$(1/)(B . ?\x6081) ;; <CJK>
     (?$(1/*(B . ?\x609D) ;; <CJK>
     (?$(1/+(B . ?\x6083) ;; <CJK>
     (?$(1/,(B . ?\x6095) ;; <CJK>
     (?$(1/-(B . ?\x609B) ;; <CJK>
     (?$(1/.(B . ?\x6097) ;; <CJK>
     (?$(1//(B . ?\x6087) ;; <CJK>
     (?$(1/0(B . ?\x609C) ;; <CJK>
     (?$(1/1(B . ?\x608E) ;; <CJK>
     (?$(1/2(B . ?\x6219) ;; <CJK>
     (?$(1/3(B . ?\x6246) ;; <CJK>
     (?$(1/4(B . ?\x62F2) ;; <CJK>
     (?$(1/5(B . ?\x6310) ;; <CJK>
     (?$(1/6(B . ?\x6356) ;; <CJK>
     (?$(1/7(B . ?\x632C) ;; <CJK>
     (?$(1/8(B . ?\x6344) ;; <CJK>
     (?$(1/9(B . ?\x6345) ;; <CJK>
     (?$(1/:(B . ?\x6336) ;; <CJK>
     (?$(1/;(B . ?\x6343) ;; <CJK>
     (?$(1/<(B . ?\x63E4) ;; <CJK>
     (?$(1/=(B . ?\x6339) ;; <CJK>
     (?$(1/>(B . ?\x634B) ;; <CJK>
     (?$(1/?(B . ?\x634A) ;; <CJK>
     (?$(1/@(B . ?\x633C) ;; <CJK>
     (?$(1/A(B . ?\x6329) ;; <CJK>
     (?$(1/B(B . ?\x6341) ;; <CJK>
     (?$(1/C(B . ?\x6334) ;; <CJK>
     (?$(1/D(B . ?\x6358) ;; <CJK>
     (?$(1/E(B . ?\x6354) ;; <CJK>
     (?$(1/F(B . ?\x6359) ;; <CJK>
     (?$(1/G(B . ?\x632D) ;; <CJK>
     (?$(1/H(B . ?\x6347) ;; <CJK>
     (?$(1/I(B . ?\x6333) ;; <CJK>
     (?$(1/J(B . ?\x635A) ;; <CJK>
     (?$(1/K(B . ?\x6351) ;; <CJK>
     (?$(1/L(B . ?\x6338) ;; <CJK>
     (?$(1/M(B . ?\x6357) ;; <CJK>
     (?$(1/N(B . ?\x6340) ;; <CJK>
     (?$(1/O(B . ?\x6348) ;; <CJK>
     (?$(1/P(B . ?\x654A) ;; <CJK>
     (?$(1/Q(B . ?\x6546) ;; <CJK>
     (?$(1/R(B . ?\x65C6) ;; <CJK>
     (?$(1/S(B . ?\x65C3) ;; <CJK>
     (?$(1/T(B . ?\x65C4) ;; <CJK>
     (?$(1/U(B . ?\x65C2) ;; <CJK>
     (?$(1/V(B . ?\x664A) ;; <CJK>
     (?$(1/W(B . ?\x665F) ;; <CJK>
     (?$(1/X(B . ?\x6647) ;; <CJK>
     (?$(1/Y(B . ?\x6651) ;; <CJK>
     (?$(1/Z(B . ?\x6712) ;; <CJK>
     (?$(1/[(B . ?\x6713) ;; <CJK>
     (?$(1/\(B . ?\x681F) ;; <CJK>
     (?$(1/](B . ?\x681A) ;; <CJK>
     (?$(1/^(B . ?\x6849) ;; <CJK>
     (?$(1/_(B . ?\x6832) ;; <CJK>
     (?$(1/`(B . ?\x6833) ;; <CJK>
     (?$(1/a(B . ?\x683B) ;; <CJK>
     (?$(1/b(B . ?\x684B) ;; <CJK>
     (?$(1/c(B . ?\x684F) ;; <CJK>
     (?$(1/d(B . ?\x6816) ;; <CJK>
     (?$(1/e(B . ?\x6831) ;; <CJK>
     (?$(1/f(B . ?\x681C) ;; <CJK>
     (?$(1/g(B . ?\x6835) ;; <CJK>
     (?$(1/h(B . ?\x682B) ;; <CJK>
     (?$(1/i(B . ?\x682D) ;; <CJK>
     (?$(1/j(B . ?\x682F) ;; <CJK>
     (?$(1/k(B . ?\x684E) ;; <CJK>
     (?$(1/l(B . ?\x6844) ;; <CJK>
     (?$(1/m(B . ?\x6834) ;; <CJK>
     (?$(1/n(B . ?\x681D) ;; <CJK>
     (?$(1/o(B . ?\x6812) ;; <CJK>
     (?$(1/p(B . ?\x6814) ;; <CJK>
     (?$(1/q(B . ?\x6826) ;; <CJK>
     (?$(1/r(B . ?\x6828) ;; <CJK>
     (?$(1/s(B . ?\x682E) ;; <CJK>
     (?$(1/t(B . ?\x684D) ;; <CJK>
     (?$(1/u(B . ?\x683A) ;; <CJK>
     (?$(1/v(B . ?\x6825) ;; <CJK>
     (?$(1/w(B . ?\x6820) ;; <CJK>
     (?$(1/x(B . ?\x6B2C) ;; <CJK>
     (?$(1/y(B . ?\x6B2F) ;; <CJK>
     (?$(1/z(B . ?\x6B2D) ;; <CJK>
     (?$(1/{(B . ?\x6B31) ;; <CJK>
     (?$(1/|(B . ?\x6B34) ;; <CJK>
     (?$(1/}(B . ?\x6B6D) ;; <CJK>
     (?$(1/~(B . ?\x8082) ;; <CJK>
     (?$(10!(B . ?\x6B88) ;; <CJK>
     (?$(10"(B . ?\x6BE6) ;; <CJK>
     (?$(10#(B . ?\x6BE4) ;; <CJK>
     (?$(10$(B . ?\x6BE8) ;; <CJK>
     (?$(10%(B . ?\x6BE3) ;; <CJK>
     (?$(10&(B . ?\x6BE2) ;; <CJK>
     (?$(10'(B . ?\x6BE7) ;; <CJK>
     (?$(10((B . ?\x6C25) ;; <CJK>
     (?$(10)(B . ?\x6D7A) ;; <CJK>
     (?$(10*(B . ?\x6D63) ;; <CJK>
     (?$(10+(B . ?\x6D64) ;; <CJK>
     (?$(10,(B . ?\x6D76) ;; <CJK>
     (?$(10-(B . ?\x6D0D) ;; <CJK>
     (?$(10.(B . ?\x6D61) ;; <CJK>
     (?$(10/(B . ?\x6D92) ;; <CJK>
     (?$(100(B . ?\x6D58) ;; <CJK>
     (?$(101(B . ?\x6D62) ;; <CJK>
     (?$(102(B . ?\x6D6D) ;; <CJK>
     (?$(103(B . ?\x6D6F) ;; <CJK>
     (?$(104(B . ?\x6D91) ;; <CJK>
     (?$(105(B . ?\x6D8D) ;; <CJK>
     (?$(106(B . ?\x6DEF) ;; <CJK>
     (?$(107(B . ?\x6D7F) ;; <CJK>
     (?$(108(B . ?\x6D86) ;; <CJK>
     (?$(109(B . ?\x6D5E) ;; <CJK>
     (?$(10:(B . ?\x6D67) ;; <CJK>
     (?$(10;(B . ?\x6D60) ;; <CJK>
     (?$(10<(B . ?\x6D97) ;; <CJK>
     (?$(10=(B . ?\x6D70) ;; <CJK>
     (?$(10>(B . ?\x6D7C) ;; <CJK>
     (?$(10?(B . ?\x6D5F) ;; <CJK>
     (?$(10@(B . ?\x6D82) ;; <CJK>
     (?$(10A(B . ?\x6D98) ;; <CJK>
     (?$(10B(B . ?\x6D2F) ;; <CJK>
     (?$(10C(B . ?\x6D68) ;; <CJK>
     (?$(10D(B . ?\x6D8B) ;; <CJK>
     (?$(10E(B . ?\x6D7E) ;; <CJK>
     (?$(10F(B . ?\x6D80) ;; <CJK>
     (?$(10G(B . ?\x6D84) ;; <CJK>
     (?$(10H(B . ?\x6D16) ;; <CJK>
     (?$(10I(B . ?\x6D83) ;; <CJK>
     (?$(10J(B . ?\x6D7B) ;; <CJK>
     (?$(10K(B . ?\x6D7D) ;; <CJK>
     (?$(10L(B . ?\x6D75) ;; <CJK>
     (?$(10M(B . ?\x6D90) ;; <CJK>
     (?$(10N(B . ?\x70DC) ;; <CJK>
     (?$(10O(B . ?\x70D3) ;; <CJK>
     (?$(10P(B . ?\x70D1) ;; <CJK>
     (?$(10Q(B . ?\x70DD) ;; <CJK>
     (?$(10R(B . ?\x70CB) ;; <CJK>
     (?$(10S(B . ?\x7F39) ;; <CJK>
     (?$(10T(B . ?\x70E2) ;; <CJK>
     (?$(10U(B . ?\x70D7) ;; <CJK>
     (?$(10V(B . ?\x70D2) ;; <CJK>
     (?$(10W(B . ?\x70DE) ;; <CJK>
     (?$(10X(B . ?\x70E0) ;; <CJK>
     (?$(10Y(B . ?\x70D4) ;; <CJK>
     (?$(10Z(B . ?\x70CD) ;; <CJK>
     (?$(10[(B . ?\x70C5) ;; <CJK>
     (?$(10\(B . ?\x70C6) ;; <CJK>
     (?$(10](B . ?\x70C7) ;; <CJK>
     (?$(10^(B . ?\x70DA) ;; <CJK>
     (?$(10_(B . ?\x70CE) ;; <CJK>
     (?$(10`(B . ?\x70E1) ;; <CJK>
     (?$(10a(B . ?\x7242) ;; <CJK>
     (?$(10b(B . ?\x7278) ;; <CJK>
     (?$(10c(B . ?\x7277) ;; <CJK>
     (?$(10d(B . ?\x7276) ;; <CJK>
     (?$(10e(B . ?\x7300) ;; <CJK>
     (?$(10f(B . ?\x72FA) ;; <CJK>
     (?$(10g(B . ?\x72F4) ;; <CJK>
     (?$(10h(B . ?\x72FE) ;; <CJK>
     (?$(10i(B . ?\x72F6) ;; <CJK>
     (?$(10j(B . ?\x72F3) ;; <CJK>
     (?$(10k(B . ?\x72FB) ;; <CJK>
     (?$(10l(B . ?\x7301) ;; <CJK>
     (?$(10m(B . ?\x73D3) ;; <CJK>
     (?$(10n(B . ?\x73D9) ;; <CJK>
     (?$(10o(B . ?\x73E5) ;; <CJK>
     (?$(10p(B . ?\x73D6) ;; <CJK>
     (?$(10q(B . ?\x73BC) ;; <CJK>
     (?$(10r(B . ?\x73E7) ;; <CJK>
     (?$(10s(B . ?\x73E3) ;; <CJK>
     (?$(10t(B . ?\x73E9) ;; <CJK>
     (?$(10u(B . ?\x73DC) ;; <CJK>
     (?$(10v(B . ?\x73D2) ;; <CJK>
     (?$(10w(B . ?\x73DB) ;; <CJK>
     (?$(10x(B . ?\x73D4) ;; <CJK>
     (?$(10y(B . ?\x73DD) ;; <CJK>
     (?$(10z(B . ?\x73DA) ;; <CJK>
     (?$(10{(B . ?\x73D7) ;; <CJK>
     (?$(10|(B . ?\x73D8) ;; <CJK>
     (?$(10}(B . ?\x73E8) ;; <CJK>
     (?$(10~(B . ?\x74DE) ;; <CJK>
     (?$(11!(B . ?\x74DF) ;; <CJK>
     (?$(11"(B . ?\x74F4) ;; <CJK>
     (?$(11#(B . ?\x74F5) ;; <CJK>
     (?$(11$(B . ?\x7521) ;; <CJK>
     (?$(11%(B . ?\x755B) ;; <CJK>
     (?$(11&(B . ?\x755F) ;; <CJK>
     (?$(11'(B . ?\x75B0) ;; <CJK>
     (?$(11((B . ?\x75C1) ;; <CJK>
     (?$(11)(B . ?\x75BB) ;; <CJK>
     (?$(11*(B . ?\x75C4) ;; <CJK>
     (?$(11+(B . ?\x75C0) ;; <CJK>
     (?$(11,(B . ?\x75BF) ;; <CJK>
     (?$(11-(B . ?\x75B6) ;; <CJK>
     (?$(11.(B . ?\x75BA) ;; <CJK>
     (?$(11/(B . ?\x768A) ;; <CJK>
     (?$(110(B . ?\x76C9) ;; <CJK>
     (?$(111(B . ?\x771D) ;; <CJK>
     (?$(112(B . ?\x771B) ;; <CJK>
     (?$(113(B . ?\x7710) ;; <CJK>
     (?$(114(B . ?\x7713) ;; <CJK>
     (?$(115(B . ?\x7712) ;; <CJK>
     (?$(116(B . ?\x7723) ;; <CJK>
     (?$(117(B . ?\x7711) ;; <CJK>
     (?$(118(B . ?\x7715) ;; <CJK>
     (?$(119(B . ?\x7719) ;; <CJK>
     (?$(11:(B . ?\x771A) ;; <CJK>
     (?$(11;(B . ?\x7722) ;; <CJK>
     (?$(11<(B . ?\x7727) ;; <CJK>
     (?$(11=(B . ?\x7823) ;; <CJK>
     (?$(11>(B . ?\x782C) ;; <CJK>
     (?$(11?(B . ?\x7822) ;; <CJK>
     (?$(11@(B . ?\x7835) ;; <CJK>
     (?$(11A(B . ?\x782F) ;; <CJK>
     (?$(11B(B . ?\x7828) ;; <CJK>
     (?$(11C(B . ?\x782E) ;; <CJK>
     (?$(11D(B . ?\x782B) ;; <CJK>
     (?$(11E(B . ?\x7821) ;; <CJK>
     (?$(11F(B . ?\x7829) ;; <CJK>
     (?$(11G(B . ?\x7833) ;; <CJK>
     (?$(11H(B . ?\x782A) ;; <CJK>
     (?$(11I(B . ?\x7831) ;; <CJK>
     (?$(11J(B . ?\x7954) ;; <CJK>
     (?$(11K(B . ?\x795B) ;; <CJK>
     (?$(11L(B . ?\x794F) ;; <CJK>
     (?$(11M(B . ?\x795C) ;; <CJK>
     (?$(11N(B . ?\x7953) ;; <CJK>
     (?$(11O(B . ?\x7952) ;; <CJK>
     (?$(11P(B . ?\x7951) ;; <CJK>
     (?$(11Q(B . ?\x79EB) ;; <CJK>
     (?$(11R(B . ?\x79EC) ;; <CJK>
     (?$(11S(B . ?\x79E0) ;; <CJK>
     (?$(11T(B . ?\x79EE) ;; <CJK>
     (?$(11U(B . ?\x79ED) ;; <CJK>
     (?$(11V(B . ?\x79EA) ;; <CJK>
     (?$(11W(B . ?\x79DC) ;; <CJK>
     (?$(11X(B . ?\x79DE) ;; <CJK>
     (?$(11Y(B . ?\x79DD) ;; <CJK>
     (?$(11Z(B . ?\x7A86) ;; <CJK>
     (?$(11[(B . ?\x7A89) ;; <CJK>
     (?$(11\(B . ?\x7A85) ;; <CJK>
     (?$(11](B . ?\x7A8B) ;; <CJK>
     (?$(11^(B . ?\x7A8C) ;; <CJK>
     (?$(11_(B . ?\x7A8A) ;; <CJK>
     (?$(11`(B . ?\x7A87) ;; <CJK>
     (?$(11a(B . ?\x7AD8) ;; <CJK>
     (?$(11b(B . ?\x7B10) ;; <CJK>
     (?$(11c(B . ?\x7B04) ;; <CJK>
     (?$(11d(B . ?\x7B13) ;; <CJK>
     (?$(11e(B . ?\x7B05) ;; <CJK>
     (?$(11f(B . ?\x7B0F) ;; <CJK>
     (?$(11g(B . ?\x7B08) ;; <CJK>
     (?$(11h(B . ?\x7B0A) ;; <CJK>
     (?$(11i(B . ?\x7B0E) ;; <CJK>
     (?$(11j(B . ?\x7B09) ;; <CJK>
     (?$(11k(B . ?\x7B12) ;; <CJK>
     (?$(11l(B . ?\x7C84) ;; <CJK>
     (?$(11m(B . ?\x7C91) ;; <CJK>
     (?$(11n(B . ?\x7C8A) ;; <CJK>
     (?$(11o(B . ?\x7C8C) ;; <CJK>
     (?$(11p(B . ?\x7C88) ;; <CJK>
     (?$(11q(B . ?\x7C8D) ;; <CJK>
     (?$(11r(B . ?\x7C85) ;; <CJK>
     (?$(11s(B . ?\x7D1E) ;; <CJK>
     (?$(11t(B . ?\x7D1D) ;; <CJK>
     (?$(11u(B . ?\x7D11) ;; <CJK>
     (?$(11v(B . ?\x7D0E) ;; <CJK>
     (?$(11w(B . ?\x7D18) ;; <CJK>
     (?$(11x(B . ?\x7D16) ;; <CJK>
     (?$(11y(B . ?\x7D13) ;; <CJK>
     (?$(11z(B . ?\x7D1F) ;; <CJK>
     (?$(11{(B . ?\x7D12) ;; <CJK>
     (?$(11|(B . ?\x7D0F) ;; <CJK>
     (?$(11}(B . ?\x7D0C) ;; <CJK>
     (?$(11~(B . ?\x7F5C) ;; <CJK>
     (?$(12!(B . ?\x7F61) ;; <CJK>
     (?$(12"(B . ?\x7F5E) ;; <CJK>
     (?$(12#(B . ?\x7F60) ;; <CJK>
     (?$(12$(B . ?\x7F5D) ;; <CJK>
     (?$(12%(B . ?\x7F5B) ;; <CJK>
     (?$(12&(B . ?\x7F96) ;; <CJK>
     (?$(12'(B . ?\x7F92) ;; <CJK>
     (?$(12((B . ?\x7FC3) ;; <CJK>
     (?$(12)(B . ?\x7FC2) ;; <CJK>
     (?$(12*(B . ?\x7FC0) ;; <CJK>
     (?$(12+(B . ?\x8016) ;; <CJK>
     (?$(12,(B . ?\x803E) ;; <CJK>
     (?$(12-(B . ?\x8039) ;; <CJK>
     (?$(12.(B . ?\x80FA) ;; <CJK>
     (?$(12/(B . ?\x80F2) ;; <CJK>
     (?$(120(B . ?\x80F9) ;; <CJK>
     (?$(121(B . ?\x80F5) ;; <CJK>
     (?$(122(B . ?\x8101) ;; <CJK>
     (?$(123(B . ?\x80FB) ;; <CJK>
     (?$(124(B . ?\x8100) ;; <CJK>
     (?$(125(B . ?\x8201) ;; <CJK>
     (?$(126(B . ?\x822F) ;; <CJK>
     (?$(127(B . ?\x8225) ;; <CJK>
     (?$(128(B . ?\x8333) ;; <CJK>
     (?$(129(B . ?\x832D) ;; <CJK>
     (?$(12:(B . ?\x8344) ;; <CJK>
     (?$(12;(B . ?\x8319) ;; <CJK>
     (?$(12<(B . ?\x8351) ;; <CJK>
     (?$(12=(B . ?\x8325) ;; <CJK>
     (?$(12>(B . ?\x8356) ;; <CJK>
     (?$(12?(B . ?\x833F) ;; <CJK>
     (?$(12@(B . ?\x8341) ;; <CJK>
     (?$(12A(B . ?\x8326) ;; <CJK>
     (?$(12B(B . ?\x831C) ;; <CJK>
     (?$(12C(B . ?\x8322) ;; <CJK>
     (?$(12D(B . ?\x8342) ;; <CJK>
     (?$(12E(B . ?\x834E) ;; <CJK>
     (?$(12F(B . ?\x831B) ;; <CJK>
     (?$(12G(B . ?\x832A) ;; <CJK>
     (?$(12H(B . ?\x8308) ;; <CJK>
     (?$(12I(B . ?\x833C) ;; <CJK>
     (?$(12J(B . ?\x834D) ;; <CJK>
     (?$(12K(B . ?\x8316) ;; <CJK>
     (?$(12L(B . ?\x8324) ;; <CJK>
     (?$(12M(B . ?\x8320) ;; <CJK>
     (?$(12N(B . ?\x8337) ;; <CJK>
     (?$(12O(B . ?\x832F) ;; <CJK>
     (?$(12P(B . ?\x8329) ;; <CJK>
     (?$(12Q(B . ?\x8347) ;; <CJK>
     (?$(12R(B . ?\x8345) ;; <CJK>
     (?$(12S(B . ?\x834C) ;; <CJK>
     (?$(12T(B . ?\x8353) ;; <CJK>
     (?$(12U(B . ?\x831E) ;; <CJK>
     (?$(12V(B . ?\x832C) ;; <CJK>
     (?$(12W(B . ?\x834B) ;; <CJK>
     (?$(12X(B . ?\x8327) ;; <CJK>
     (?$(12Y(B . ?\x8348) ;; <CJK>
     (?$(12Z(B . ?\x8653) ;; <CJK>
     (?$(12[(B . ?\x8652) ;; <CJK>
     (?$(12\(B . ?\x86A2) ;; <CJK>
     (?$(12](B . ?\x86A8) ;; <CJK>
     (?$(12^(B . ?\x8696) ;; <CJK>
     (?$(12_(B . ?\x868D) ;; <CJK>
     (?$(12`(B . ?\x8691) ;; <CJK>
     (?$(12a(B . ?\x869E) ;; <CJK>
     (?$(12b(B . ?\x8687) ;; <CJK>
     (?$(12c(B . ?\x8697) ;; <CJK>
     (?$(12d(B . ?\x8686) ;; <CJK>
     (?$(12e(B . ?\x868B) ;; <CJK>
     (?$(12f(B . ?\x869A) ;; <CJK>
     (?$(12g(B . ?\x8685) ;; <CJK>
     (?$(12h(B . ?\x86A5) ;; <CJK>
     (?$(12i(B . ?\x8699) ;; <CJK>
     (?$(12j(B . ?\x86A1) ;; <CJK>
     (?$(12k(B . ?\x86A7) ;; <CJK>
     (?$(12l(B . ?\x8695) ;; <CJK>
     (?$(12m(B . ?\x8698) ;; <CJK>
     (?$(12n(B . ?\x868E) ;; <CJK>
     (?$(12o(B . ?\x869D) ;; <CJK>
     (?$(12p(B . ?\x8690) ;; <CJK>
     (?$(12q(B . ?\x8694) ;; <CJK>
     (?$(12r(B . ?\x8843) ;; <CJK>
     (?$(12s(B . ?\x8844) ;; <CJK>
     (?$(12t(B . ?\x886D) ;; <CJK>
     (?$(12u(B . ?\x8875) ;; <CJK>
     (?$(12v(B . ?\x8876) ;; <CJK>
     (?$(12w(B . ?\x8872) ;; <CJK>
     (?$(12x(B . ?\x8880) ;; <CJK>
     (?$(12y(B . ?\x8871) ;; <CJK>
     (?$(12z(B . ?\x887F) ;; <CJK>
     (?$(12{(B . ?\x886F) ;; <CJK>
     (?$(12|(B . ?\x8883) ;; <CJK>
     (?$(12}(B . ?\x887E) ;; <CJK>
     (?$(12~(B . ?\x8874) ;; <CJK>
     (?$(13!(B . ?\x887C) ;; <CJK>
     (?$(13"(B . ?\x8A12) ;; <CJK>
     (?$(13#(B . ?\x8C47) ;; <CJK>
     (?$(13$(B . ?\x8C57) ;; <CJK>
     (?$(13%(B . ?\x8C7B) ;; <CJK>
     (?$(13&(B . ?\x8CA4) ;; <CJK>
     (?$(13'(B . ?\x8CA3) ;; <CJK>
     (?$(13((B . ?\x8D76) ;; <CJK>
     (?$(13)(B . ?\x8D78) ;; <CJK>
     (?$(13*(B . ?\x8DB5) ;; <CJK>
     (?$(13+(B . ?\x8DB7) ;; <CJK>
     (?$(13,(B . ?\x8DB6) ;; <CJK>
     (?$(13-(B . ?\x8ED1) ;; <CJK>
     (?$(13.(B . ?\x8ED3) ;; <CJK>
     (?$(13/(B . ?\x8FFE) ;; <CJK>
     (?$(130(B . ?\x8FF5) ;; <CJK>
     (?$(131(B . ?\x9002) ;; <CJK>
     (?$(132(B . ?\x8FFF) ;; <CJK>
     (?$(133(B . ?\x8FFB) ;; <CJK>
     (?$(134(B . ?\x9004) ;; <CJK>
     (?$(135(B . ?\x8FFC) ;; <CJK>
     (?$(136(B . ?\x8FF6) ;; <CJK>
     (?$(137(B . ?\x90D6) ;; <CJK>
     (?$(138(B . ?\x90E0) ;; <CJK>
     (?$(139(B . ?\x90D9) ;; <CJK>
     (?$(13:(B . ?\x90DA) ;; <CJK>
     (?$(13;(B . ?\x90E3) ;; <CJK>
     (?$(13<(B . ?\x90DF) ;; <CJK>
     (?$(13=(B . ?\x90E5) ;; <CJK>
     (?$(13>(B . ?\x90D8) ;; <CJK>
     (?$(13?(B . ?\x90DB) ;; <CJK>
     (?$(13@(B . ?\x90D7) ;; <CJK>
     (?$(13A(B . ?\x90DC) ;; <CJK>
     (?$(13B(B . ?\x90E4) ;; <CJK>
     (?$(13C(B . ?\x9150) ;; <CJK>
     (?$(13D(B . ?\x914E) ;; <CJK>
     (?$(13E(B . ?\x914F) ;; <CJK>
     (?$(13F(B . ?\x91D5) ;; <CJK>
     (?$(13G(B . ?\x91E2) ;; <CJK>
     (?$(13H(B . ?\x91DA) ;; <CJK>
     (?$(13I(B . ?\x965C) ;; <CJK>
     (?$(13J(B . ?\x965F) ;; <CJK>
     (?$(13K(B . ?\x96BC) ;; <CJK>
     (?$(13L(B . ?\x98E3) ;; <CJK>
     (?$(13M(B . ?\x9ADF) ;; <CJK>
     (?$(13N(B . ?\x9B2F) ;; <CJK>
     (?$(13O(B . ?\x4E7F) ;; <CJK>
     (?$(13P(B . ?\x5070) ;; <CJK>
     (?$(13Q(B . ?\x506A) ;; <CJK>
     (?$(13R(B . ?\x5061) ;; <CJK>
     (?$(13S(B . ?\x505E) ;; <CJK>
     (?$(13T(B . ?\x5060) ;; <CJK>
     (?$(13U(B . ?\x5053) ;; <CJK>
     (?$(13V(B . ?\x504B) ;; <CJK>
     (?$(13W(B . ?\x505D) ;; <CJK>
     (?$(13X(B . ?\x5072) ;; <CJK>
     (?$(13Y(B . ?\x5048) ;; <CJK>
     (?$(13Z(B . ?\x504D) ;; <CJK>
     (?$(13[(B . ?\x5041) ;; <CJK>
     (?$(13\(B . ?\x505B) ;; <CJK>
     (?$(13](B . ?\x504A) ;; <CJK>
     (?$(13^(B . ?\x5062) ;; <CJK>
     (?$(13_(B . ?\x5015) ;; <CJK>
     (?$(13`(B . ?\x5045) ;; <CJK>
     (?$(13a(B . ?\x505F) ;; <CJK>
     (?$(13b(B . ?\x5069) ;; <CJK>
     (?$(13c(B . ?\x506B) ;; <CJK>
     (?$(13d(B . ?\x5063) ;; <CJK>
     (?$(13e(B . ?\x5064) ;; <CJK>
     (?$(13f(B . ?\x5046) ;; <CJK>
     (?$(13g(B . ?\x5040) ;; <CJK>
     (?$(13h(B . ?\x506E) ;; <CJK>
     (?$(13i(B . ?\x5073) ;; <CJK>
     (?$(13j(B . ?\x5057) ;; <CJK>
     (?$(13k(B . ?\x5051) ;; <CJK>
     (?$(13l(B . ?\x51D0) ;; <CJK>
     (?$(13m(B . ?\x526B) ;; <CJK>
     (?$(13n(B . ?\x526D) ;; <CJK>
     (?$(13o(B . ?\x526C) ;; <CJK>
     (?$(13p(B . ?\x526E) ;; <CJK>
     (?$(13q(B . ?\x52D6) ;; <CJK>
     (?$(13r(B . ?\x52D3) ;; <CJK>
     (?$(13s(B . ?\x532D) ;; <CJK>
     (?$(13t(B . ?\x539C) ;; <CJK>
     (?$(13u(B . ?\x5575) ;; <CJK>
     (?$(13v(B . ?\x5576) ;; <CJK>
     (?$(13w(B . ?\x553C) ;; <CJK>
     (?$(13x(B . ?\x554D) ;; <CJK>
     (?$(13y(B . ?\x5550) ;; <CJK>
     (?$(13z(B . ?\x5534) ;; <CJK>
     (?$(13{(B . ?\x552A) ;; <CJK>
     (?$(13|(B . ?\x5551) ;; <CJK>
     (?$(13}(B . ?\x5562) ;; <CJK>
     (?$(13~(B . ?\x5536) ;; <CJK>
     (?$(14!(B . ?\x5535) ;; <CJK>
     (?$(14"(B . ?\x5530) ;; <CJK>
     (?$(14#(B . ?\x5552) ;; <CJK>
     (?$(14$(B . ?\x5545) ;; <CJK>
     (?$(14%(B . ?\x550C) ;; <CJK>
     (?$(14&(B . ?\x5532) ;; <CJK>
     (?$(14'(B . ?\x5565) ;; <CJK>
     (?$(14((B . ?\x554E) ;; <CJK>
     (?$(14)(B . ?\x5539) ;; <CJK>
     (?$(14*(B . ?\x5548) ;; <CJK>
     (?$(14+(B . ?\x552D) ;; <CJK>
     (?$(14,(B . ?\x553B) ;; <CJK>
     (?$(14-(B . ?\x5540) ;; <CJK>
     (?$(14.(B . ?\x554B) ;; <CJK>
     (?$(14/(B . ?\x570A) ;; <CJK>
     (?$(140(B . ?\x5707) ;; <CJK>
     (?$(141(B . ?\x57FB) ;; <CJK>
     (?$(142(B . ?\x5814) ;; <CJK>
     (?$(143(B . ?\x57E2) ;; <CJK>
     (?$(144(B . ?\x57F6) ;; <CJK>
     (?$(145(B . ?\x57DC) ;; <CJK>
     (?$(146(B . ?\x57F4) ;; <CJK>
     (?$(147(B . ?\x5800) ;; <CJK>
     (?$(148(B . ?\x57ED) ;; <CJK>
     (?$(149(B . ?\x57FD) ;; <CJK>
     (?$(14:(B . ?\x5808) ;; <CJK>
     (?$(14;(B . ?\x57F8) ;; <CJK>
     (?$(14<(B . ?\x580B) ;; <CJK>
     (?$(14=(B . ?\x57F3) ;; <CJK>
     (?$(14>(B . ?\x57CF) ;; <CJK>
     (?$(14?(B . ?\x5807) ;; <CJK>
     (?$(14@(B . ?\x57EE) ;; <CJK>
     (?$(14A(B . ?\x57E3) ;; <CJK>
     (?$(14B(B . ?\x57F2) ;; <CJK>
     (?$(14C(B . ?\x57E5) ;; <CJK>
     (?$(14D(B . ?\x57EC) ;; <CJK>
     (?$(14E(B . ?\x57E1) ;; <CJK>
     (?$(14F(B . ?\x580E) ;; <CJK>
     (?$(14G(B . ?\x57FC) ;; <CJK>
     (?$(14H(B . ?\x5810) ;; <CJK>
     (?$(14I(B . ?\x57E7) ;; <CJK>
     (?$(14J(B . ?\x5801) ;; <CJK>
     (?$(14K(B . ?\x580C) ;; <CJK>
     (?$(14L(B . ?\x57F1) ;; <CJK>
     (?$(14M(B . ?\x57E9) ;; <CJK>
     (?$(14N(B . ?\x57F0) ;; <CJK>
     (?$(14O(B . ?\x580D) ;; <CJK>
     (?$(14P(B . ?\x5804) ;; <CJK>
     (?$(14Q(B . ?\x595C) ;; <CJK>
     (?$(14R(B . ?\x5A60) ;; <CJK>
     (?$(14S(B . ?\x5A58) ;; <CJK>
     (?$(14T(B . ?\x5A55) ;; <CJK>
     (?$(14U(B . ?\x5A67) ;; <CJK>
     (?$(14V(B . ?\x5A5E) ;; <CJK>
     (?$(14W(B . ?\x5A38) ;; <CJK>
     (?$(14X(B . ?\x5A35) ;; <CJK>
     (?$(14Y(B . ?\x5A6D) ;; <CJK>
     (?$(14Z(B . ?\x5A50) ;; <CJK>
     (?$(14[(B . ?\x5A5F) ;; <CJK>
     (?$(14\(B . ?\x5A65) ;; <CJK>
     (?$(14](B . ?\x5A6C) ;; <CJK>
     (?$(14^(B . ?\x5A53) ;; <CJK>
     (?$(14_(B . ?\x5A64) ;; <CJK>
     (?$(14`(B . ?\x5A57) ;; <CJK>
     (?$(14a(B . ?\x5A43) ;; <CJK>
     (?$(14b(B . ?\x5A5D) ;; <CJK>
     (?$(14c(B . ?\x5A52) ;; <CJK>
     (?$(14d(B . ?\x5A44) ;; <CJK>
     (?$(14e(B . ?\x5A5B) ;; <CJK>
     (?$(14f(B . ?\x5A48) ;; <CJK>
     (?$(14g(B . ?\x5A8E) ;; <CJK>
     (?$(14h(B . ?\x5A3E) ;; <CJK>
     (?$(14i(B . ?\x5A4D) ;; <CJK>
     (?$(14j(B . ?\x5A39) ;; <CJK>
     (?$(14k(B . ?\x5A4C) ;; <CJK>
     (?$(14l(B . ?\x5A70) ;; <CJK>
     (?$(14m(B . ?\x5A69) ;; <CJK>
     (?$(14n(B . ?\x5A47) ;; <CJK>
     (?$(14o(B . ?\x5A51) ;; <CJK>
     (?$(14p(B . ?\x5A56) ;; <CJK>
     (?$(14q(B . ?\x5A42) ;; <CJK>
     (?$(14r(B . ?\x5A5C) ;; <CJK>
     (?$(14s(B . ?\x5B72) ;; <CJK>
     (?$(14t(B . ?\x5B6E) ;; <CJK>
     (?$(14u(B . ?\x5BC1) ;; <CJK>
     (?$(14v(B . ?\x5BC0) ;; <CJK>
     (?$(14w(B . ?\x5C59) ;; <CJK>
     (?$(14x(B . ?\x5D1E) ;; <CJK>
     (?$(14y(B . ?\x5D0B) ;; <CJK>
     (?$(14z(B . ?\x5D1D) ;; <CJK>
     (?$(14{(B . ?\x5D1A) ;; <CJK>
     (?$(14|(B . ?\x5D20) ;; <CJK>
     (?$(14}(B . ?\x5D0C) ;; <CJK>
     (?$(14~(B . ?\x5D28) ;; <CJK>
     (?$(15!(B . ?\x5D0D) ;; <CJK>
     (?$(15"(B . ?\x5D26) ;; <CJK>
     (?$(15#(B . ?\x5D25) ;; <CJK>
     (?$(15$(B . ?\x5D0F) ;; <CJK>
     (?$(15%(B . ?\x5D30) ;; <CJK>
     (?$(15&(B . ?\x5D12) ;; <CJK>
     (?$(15'(B . ?\x5D23) ;; <CJK>
     (?$(15((B . ?\x5D1F) ;; <CJK>
     (?$(15)(B . ?\x5D2E) ;; <CJK>
     (?$(15*(B . ?\x5E3E) ;; <CJK>
     (?$(15+(B . ?\x5E34) ;; <CJK>
     (?$(15,(B . ?\x5EB1) ;; <CJK>
     (?$(15-(B . ?\x5EB4) ;; <CJK>
     (?$(15.(B . ?\x5EB9) ;; <CJK>
     (?$(15/(B . ?\x5EB2) ;; <CJK>
     (?$(150(B . ?\x5EB3) ;; <CJK>
     (?$(151(B . ?\x5F36) ;; <CJK>
     (?$(152(B . ?\x5F38) ;; <CJK>
     (?$(153(B . ?\x5F9B) ;; <CJK>
     (?$(154(B . ?\x5F96) ;; <CJK>
     (?$(155(B . ?\x5F9F) ;; <CJK>
     (?$(156(B . ?\x608A) ;; <CJK>
     (?$(157(B . ?\x6090) ;; <CJK>
     (?$(158(B . ?\x6086) ;; <CJK>
     (?$(159(B . ?\x60BE) ;; <CJK>
     (?$(15:(B . ?\x60B0) ;; <CJK>
     (?$(15;(B . ?\x60BA) ;; <CJK>
     (?$(15<(B . ?\x60D3) ;; <CJK>
     (?$(15=(B . ?\x60D4) ;; <CJK>
     (?$(15>(B . ?\x60CF) ;; <CJK>
     (?$(15?(B . ?\x60E4) ;; <CJK>
     (?$(15@(B . ?\x60D9) ;; <CJK>
     (?$(15A(B . ?\x60DD) ;; <CJK>
     (?$(15B(B . ?\x60C8) ;; <CJK>
     (?$(15C(B . ?\x60B1) ;; <CJK>
     (?$(15D(B . ?\x60DB) ;; <CJK>
     (?$(15E(B . ?\x60B7) ;; <CJK>
     (?$(15F(B . ?\x60CA) ;; <CJK>
     (?$(15G(B . ?\x60BF) ;; <CJK>
     (?$(15H(B . ?\x60C3) ;; <CJK>
     (?$(15I(B . ?\x60CD) ;; <CJK>
     (?$(15J(B . ?\x60C0) ;; <CJK>
     (?$(15K(B . ?\x6332) ;; <CJK>
     (?$(15L(B . ?\x6365) ;; <CJK>
     (?$(15M(B . ?\x638A) ;; <CJK>
     (?$(15N(B . ?\x6382) ;; <CJK>
     (?$(15O(B . ?\x637D) ;; <CJK>
     (?$(15P(B . ?\x63BD) ;; <CJK>
     (?$(15Q(B . ?\x639E) ;; <CJK>
     (?$(15R(B . ?\x63AD) ;; <CJK>
     (?$(15S(B . ?\x639D) ;; <CJK>
     (?$(15T(B . ?\x6397) ;; <CJK>
     (?$(15U(B . ?\x63AB) ;; <CJK>
     (?$(15V(B . ?\x638E) ;; <CJK>
     (?$(15W(B . ?\x636F) ;; <CJK>
     (?$(15X(B . ?\x6387) ;; <CJK>
     (?$(15Y(B . ?\x6390) ;; <CJK>
     (?$(15Z(B . ?\x636E) ;; <CJK>
     (?$(15[(B . ?\x63AF) ;; <CJK>
     (?$(15\(B . ?\x6375) ;; <CJK>
     (?$(15](B . ?\x639C) ;; <CJK>
     (?$(15^(B . ?\x636D) ;; <CJK>
     (?$(15_(B . ?\x63AE) ;; <CJK>
     (?$(15`(B . ?\x637C) ;; <CJK>
     (?$(15a(B . ?\x63A4) ;; <CJK>
     (?$(15b(B . ?\x633B) ;; <CJK>
     (?$(15c(B . ?\x639F) ;; <CJK>
     (?$(15d(B . ?\x6378) ;; <CJK>
     (?$(15e(B . ?\x6385) ;; <CJK>
     (?$(15f(B . ?\x6381) ;; <CJK>
     (?$(15g(B . ?\x6391) ;; <CJK>
     (?$(15h(B . ?\x638D) ;; <CJK>
     (?$(15i(B . ?\x6370) ;; <CJK>
     (?$(15j(B . ?\x6553) ;; <CJK>
     (?$(15k(B . ?\x65CD) ;; <CJK>
     (?$(15l(B . ?\x6665) ;; <CJK>
     (?$(15m(B . ?\x6661) ;; <CJK>
     (?$(15n(B . ?\x665B) ;; <CJK>
     (?$(15o(B . ?\x6659) ;; <CJK>
     (?$(15p(B . ?\x665C) ;; <CJK>
     (?$(15q(B . ?\x6662) ;; <CJK>
     (?$(15r(B . ?\x6718) ;; <CJK>
     (?$(15s(B . ?\x6879) ;; <CJK>
     (?$(15t(B . ?\x6887) ;; <CJK>
     (?$(15u(B . ?\x6890) ;; <CJK>
     (?$(15v(B . ?\x689C) ;; <CJK>
     (?$(15w(B . ?\x686D) ;; <CJK>
     (?$(15x(B . ?\x686E) ;; <CJK>
     (?$(15y(B . ?\x68AE) ;; <CJK>
     (?$(15z(B . ?\x68AB) ;; <CJK>
     (?$(15{(B . ?\x6956) ;; <CJK>
     (?$(15|(B . ?\x686F) ;; <CJK>
     (?$(15}(B . ?\x68A3) ;; <CJK>
     (?$(15~(B . ?\x68AC) ;; <CJK>
     (?$(16!(B . ?\x68A9) ;; <CJK>
     (?$(16"(B . ?\x6875) ;; <CJK>
     (?$(16#(B . ?\x6874) ;; <CJK>
     (?$(16$(B . ?\x68B2) ;; <CJK>
     (?$(16%(B . ?\x688F) ;; <CJK>
     (?$(16&(B . ?\x6877) ;; <CJK>
     (?$(16'(B . ?\x6892) ;; <CJK>
     (?$(16((B . ?\x687C) ;; <CJK>
     (?$(16)(B . ?\x686B) ;; <CJK>
     (?$(16*(B . ?\x6872) ;; <CJK>
     (?$(16+(B . ?\x68AA) ;; <CJK>
     (?$(16,(B . ?\x6880) ;; <CJK>
     (?$(16-(B . ?\x6871) ;; <CJK>
     (?$(16.(B . ?\x687E) ;; <CJK>
     (?$(16/(B . ?\x689B) ;; <CJK>
     (?$(160(B . ?\x6896) ;; <CJK>
     (?$(161(B . ?\x688B) ;; <CJK>
     (?$(162(B . ?\x68A0) ;; <CJK>
     (?$(163(B . ?\x6889) ;; <CJK>
     (?$(164(B . ?\x68A4) ;; <CJK>
     (?$(165(B . ?\x6878) ;; <CJK>
     (?$(166(B . ?\x687B) ;; <CJK>
     (?$(167(B . ?\x6891) ;; <CJK>
     (?$(168(B . ?\x688C) ;; <CJK>
     (?$(169(B . ?\x688A) ;; <CJK>
     (?$(16:(B . ?\x687D) ;; <CJK>
     (?$(16;(B . ?\x6B36) ;; <CJK>
     (?$(16<(B . ?\x6B33) ;; <CJK>
     (?$(16=(B . ?\x6B37) ;; <CJK>
     (?$(16>(B . ?\x6B38) ;; <CJK>
     (?$(16?(B . ?\x6B91) ;; <CJK>
     (?$(16@(B . ?\x6B8F) ;; <CJK>
     (?$(16A(B . ?\x6B8D) ;; <CJK>
     (?$(16B(B . ?\x6B8E) ;; <CJK>
     (?$(16C(B . ?\x6B8C) ;; <CJK>
     (?$(16D(B . ?\x6C2A) ;; <CJK>
     (?$(16E(B . ?\x6DC0) ;; <CJK>
     (?$(16F(B . ?\x6DAB) ;; <CJK>
     (?$(16G(B . ?\x6DB4) ;; <CJK>
     (?$(16H(B . ?\x6DB3) ;; <CJK>
     (?$(16I(B . ?\x6E74) ;; <CJK>
     (?$(16J(B . ?\x6DAC) ;; <CJK>
     (?$(16K(B . ?\x6DE9) ;; <CJK>
     (?$(16L(B . ?\x6DE2) ;; <CJK>
     (?$(16M(B . ?\x6DB7) ;; <CJK>
     (?$(16N(B . ?\x6DF6) ;; <CJK>
     (?$(16O(B . ?\x6DD4) ;; <CJK>
     (?$(16P(B . ?\x6E00) ;; <CJK>
     (?$(16Q(B . ?\x6DC8) ;; <CJK>
     (?$(16R(B . ?\x6DE0) ;; <CJK>
     (?$(16S(B . ?\x6DDF) ;; <CJK>
     (?$(16T(B . ?\x6DD6) ;; <CJK>
     (?$(16U(B . ?\x6DBE) ;; <CJK>
     (?$(16V(B . ?\x6DE5) ;; <CJK>
     (?$(16W(B . ?\x6DDC) ;; <CJK>
     (?$(16X(B . ?\x6DDD) ;; <CJK>
     (?$(16Y(B . ?\x6DDB) ;; <CJK>
     (?$(16Z(B . ?\x6DF4) ;; <CJK>
     (?$(16[(B . ?\x6DCA) ;; <CJK>
     (?$(16\(B . ?\x6DBD) ;; <CJK>
     (?$(16](B . ?\x6DED) ;; <CJK>
     (?$(16^(B . ?\x6DF0) ;; <CJK>
     (?$(16_(B . ?\x6DBA) ;; <CJK>
     (?$(16`(B . ?\x6DD5) ;; <CJK>
     (?$(16a(B . ?\x6DC2) ;; <CJK>
     (?$(16b(B . ?\x6DCF) ;; <CJK>
     (?$(16c(B . ?\x6DC9) ;; <CJK>
     (?$(16d(B . ?\x6DD0) ;; <CJK>
     (?$(16e(B . ?\x6DF2) ;; <CJK>
     (?$(16f(B . ?\x6DD3) ;; <CJK>
     (?$(16g(B . ?\x6DFD) ;; <CJK>
     (?$(16h(B . ?\x6DD7) ;; <CJK>
     (?$(16i(B . ?\x6DCD) ;; <CJK>
     (?$(16j(B . ?\x6DE3) ;; <CJK>
     (?$(16k(B . ?\x6DBB) ;; <CJK>
     (?$(16l(B . ?\x70FA) ;; <CJK>
     (?$(16m(B . ?\x710D) ;; <CJK>
     (?$(16n(B . ?\x70F7) ;; <CJK>
     (?$(16o(B . ?\x7117) ;; <CJK>
     (?$(16p(B . ?\x70F4) ;; <CJK>
     (?$(16q(B . ?\x710C) ;; <CJK>
     (?$(16r(B . ?\x70F0) ;; <CJK>
     (?$(16s(B . ?\x7104) ;; <CJK>
     (?$(16t(B . ?\x70F3) ;; <CJK>
     (?$(16u(B . ?\x7110) ;; <CJK>
     (?$(16v(B . ?\x70FC) ;; <CJK>
     (?$(16w(B . ?\x70FF) ;; <CJK>
     (?$(16x(B . ?\x7106) ;; <CJK>
     (?$(16y(B . ?\x7113) ;; <CJK>
     (?$(16z(B . ?\x7100) ;; <CJK>
     (?$(16{(B . ?\x70F8) ;; <CJK>
     (?$(16|(B . ?\x70F6) ;; <CJK>
     (?$(16}(B . ?\x710B) ;; <CJK>
     (?$(16~(B . ?\x7102) ;; <CJK>
     (?$(17!(B . ?\x710E) ;; <CJK>
     (?$(17"(B . ?\x727E) ;; <CJK>
     (?$(17#(B . ?\x727B) ;; <CJK>
     (?$(17$(B . ?\x727C) ;; <CJK>
     (?$(17%(B . ?\x727F) ;; <CJK>
     (?$(17&(B . ?\x731D) ;; <CJK>
     (?$(17'(B . ?\x7317) ;; <CJK>
     (?$(17((B . ?\x7307) ;; <CJK>
     (?$(17)(B . ?\x7311) ;; <CJK>
     (?$(17*(B . ?\x7318) ;; <CJK>
     (?$(17+(B . ?\x730A) ;; <CJK>
     (?$(17,(B . ?\x7308) ;; <CJK>
     (?$(17-(B . ?\x72FF) ;; <CJK>
     (?$(17.(B . ?\x730F) ;; <CJK>
     (?$(17/(B . ?\x731E) ;; <CJK>
     (?$(170(B . ?\x7388) ;; <CJK>
     (?$(171(B . ?\x73F6) ;; <CJK>
     (?$(172(B . ?\x73F8) ;; <CJK>
     (?$(173(B . ?\x73F5) ;; <CJK>
     (?$(174(B . ?\x7404) ;; <CJK>
     (?$(175(B . ?\x7401) ;; <CJK>
     (?$(176(B . ?\x73FD) ;; <CJK>
     (?$(177(B . ?\x7407) ;; <CJK>
     (?$(178(B . ?\x7400) ;; <CJK>
     (?$(179(B . ?\x73FA) ;; <CJK>
     (?$(17:(B . ?\x73FC) ;; <CJK>
     (?$(17;(B . ?\x73FF) ;; <CJK>
     (?$(17<(B . ?\x740C) ;; <CJK>
     (?$(17=(B . ?\x740B) ;; <CJK>
     (?$(17>(B . ?\x73F4) ;; <CJK>
     (?$(17?(B . ?\x7408) ;; <CJK>
     (?$(17@(B . ?\x7564) ;; <CJK>
     (?$(17A(B . ?\x7563) ;; <CJK>
     (?$(17B(B . ?\x75CE) ;; <CJK>
     (?$(17C(B . ?\x75D2) ;; <CJK>
     (?$(17D(B . ?\x75CF) ;; <CJK>
     (?$(17E(B . ?\x75CB) ;; <CJK>
     (?$(17F(B . ?\x75CC) ;; <CJK>
     (?$(17G(B . ?\x75D1) ;; <CJK>
     (?$(17H(B . ?\x75D0) ;; <CJK>
     (?$(17I(B . ?\x768F) ;; <CJK>
     (?$(17J(B . ?\x7689) ;; <CJK>
     (?$(17K(B . ?\x76D3) ;; <CJK>
     (?$(17L(B . ?\x7739) ;; <CJK>
     (?$(17M(B . ?\x772F) ;; <CJK>
     (?$(17N(B . ?\x772D) ;; <CJK>
     (?$(17O(B . ?\x7731) ;; <CJK>
     (?$(17P(B . ?\x7732) ;; <CJK>
     (?$(17Q(B . ?\x7734) ;; <CJK>
     (?$(17R(B . ?\x7733) ;; <CJK>
     (?$(17S(B . ?\x773D) ;; <CJK>
     (?$(17T(B . ?\x7725) ;; <CJK>
     (?$(17U(B . ?\x773B) ;; <CJK>
     (?$(17V(B . ?\x7735) ;; <CJK>
     (?$(17W(B . ?\x7848) ;; <CJK>
     (?$(17X(B . ?\x7852) ;; <CJK>
     (?$(17Y(B . ?\x7849) ;; <CJK>
     (?$(17Z(B . ?\x784D) ;; <CJK>
     (?$(17[(B . ?\x784A) ;; <CJK>
     (?$(17\(B . ?\x784C) ;; <CJK>
     (?$(17](B . ?\x7826) ;; <CJK>
     (?$(17^(B . ?\x7845) ;; <CJK>
     (?$(17_(B . ?\x7850) ;; <CJK>
     (?$(17`(B . ?\x7964) ;; <CJK>
     (?$(17a(B . ?\x7967) ;; <CJK>
     (?$(17b(B . ?\x7969) ;; <CJK>
     (?$(17c(B . ?\x796A) ;; <CJK>
     (?$(17d(B . ?\x7963) ;; <CJK>
     (?$(17e(B . ?\x796B) ;; <CJK>
     (?$(17f(B . ?\x7961) ;; <CJK>
     (?$(17g(B . ?\x79BB) ;; <CJK>
     (?$(17h(B . ?\x79FA) ;; <CJK>
     (?$(17i(B . ?\x79F8) ;; <CJK>
     (?$(17j(B . ?\x79F6) ;; <CJK>
     (?$(17k(B . ?\x79F7) ;; <CJK>
     (?$(17l(B . ?\x7A8F) ;; <CJK>
     (?$(17m(B . ?\x7A94) ;; <CJK>
     (?$(17n(B . ?\x7A90) ;; <CJK>
     (?$(17o(B . ?\x7B35) ;; <CJK>
     (?$(17p(B . ?\x7B47) ;; <CJK>
     (?$(17q(B . ?\x7B34) ;; <CJK>
     (?$(17r(B . ?\x7B25) ;; <CJK>
     (?$(17s(B . ?\x7B30) ;; <CJK>
     (?$(17t(B . ?\x7B22) ;; <CJK>
     (?$(17u(B . ?\x7B24) ;; <CJK>
     (?$(17v(B . ?\x7B33) ;; <CJK>
     (?$(17w(B . ?\x7B18) ;; <CJK>
     (?$(17x(B . ?\x7B2A) ;; <CJK>
     (?$(17y(B . ?\x7B1D) ;; <CJK>
     (?$(17z(B . ?\x7B31) ;; <CJK>
     (?$(17{(B . ?\x7B2B) ;; <CJK>
     (?$(17|(B . ?\x7B2D) ;; <CJK>
     (?$(17}(B . ?\x7B2F) ;; <CJK>
     (?$(17~(B . ?\x7B32) ;; <CJK>
     (?$(18!(B . ?\x7B38) ;; <CJK>
     (?$(18"(B . ?\x7B1A) ;; <CJK>
     (?$(18#(B . ?\x7B23) ;; <CJK>
     (?$(18$(B . ?\x7C94) ;; <CJK>
     (?$(18%(B . ?\x7C98) ;; <CJK>
     (?$(18&(B . ?\x7C96) ;; <CJK>
     (?$(18'(B . ?\x7CA3) ;; <CJK>
     (?$(18((B . ?\x7D35) ;; <CJK>
     (?$(18)(B . ?\x7D3D) ;; <CJK>
     (?$(18*(B . ?\x7D38) ;; <CJK>
     (?$(18+(B . ?\x7D36) ;; <CJK>
     (?$(18,(B . ?\x7D3A) ;; <CJK>
     (?$(18-(B . ?\x7D45) ;; <CJK>
     (?$(18.(B . ?\x7D2C) ;; <CJK>
     (?$(18/(B . ?\x7D29) ;; <CJK>
     (?$(180(B . ?\x7D41) ;; <CJK>
     (?$(181(B . ?\x7D47) ;; <CJK>
     (?$(182(B . ?\x7D3E) ;; <CJK>
     (?$(183(B . ?\x7D3F) ;; <CJK>
     (?$(184(B . ?\x7D4A) ;; <CJK>
     (?$(185(B . ?\x7D3B) ;; <CJK>
     (?$(186(B . ?\x7D28) ;; <CJK>
     (?$(187(B . ?\x7F63) ;; <CJK>
     (?$(188(B . ?\x7F95) ;; <CJK>
     (?$(189(B . ?\x7F9C) ;; <CJK>
     (?$(18:(B . ?\x7F9D) ;; <CJK>
     (?$(18;(B . ?\x7F9B) ;; <CJK>
     (?$(18<(B . ?\x7FCA) ;; <CJK>
     (?$(18=(B . ?\x7FCB) ;; <CJK>
     (?$(18>(B . ?\x7FCD) ;; <CJK>
     (?$(18?(B . ?\x7FD0) ;; <CJK>
     (?$(18@(B . ?\x7FD1) ;; <CJK>
     (?$(18A(B . ?\x7FC7) ;; <CJK>
     (?$(18B(B . ?\x7FCF) ;; <CJK>
     (?$(18C(B . ?\x7FC9) ;; <CJK>
     (?$(18D(B . ?\x801F) ;; <CJK>
     (?$(18E(B . ?\x801E) ;; <CJK>
     (?$(18F(B . ?\x801B) ;; <CJK>
     (?$(18G(B . ?\x8047) ;; <CJK>
     (?$(18H(B . ?\x8043) ;; <CJK>
     (?$(18I(B . ?\x8048) ;; <CJK>
     (?$(18J(B . ?\x8118) ;; <CJK>
     (?$(18K(B . ?\x8125) ;; <CJK>
     (?$(18L(B . ?\x8119) ;; <CJK>
     (?$(18M(B . ?\x811B) ;; <CJK>
     (?$(18N(B . ?\x812D) ;; <CJK>
     (?$(18O(B . ?\x811F) ;; <CJK>
     (?$(18P(B . ?\x812C) ;; <CJK>
     (?$(18Q(B . ?\x811E) ;; <CJK>
     (?$(18R(B . ?\x8121) ;; <CJK>
     (?$(18S(B . ?\x8115) ;; <CJK>
     (?$(18T(B . ?\x8127) ;; <CJK>
     (?$(18U(B . ?\x811D) ;; <CJK>
     (?$(18V(B . ?\x8122) ;; <CJK>
     (?$(18W(B . ?\x8211) ;; <CJK>
     (?$(18X(B . ?\x8238) ;; <CJK>
     (?$(18Y(B . ?\x8233) ;; <CJK>
     (?$(18Z(B . ?\x823A) ;; <CJK>
     (?$(18[(B . ?\x8234) ;; <CJK>
     (?$(18\(B . ?\x8232) ;; <CJK>
     (?$(18](B . ?\x8274) ;; <CJK>
     (?$(18^(B . ?\x8390) ;; <CJK>
     (?$(18_(B . ?\x83A3) ;; <CJK>
     (?$(18`(B . ?\x83A8) ;; <CJK>
     (?$(18a(B . ?\x838D) ;; <CJK>
     (?$(18b(B . ?\x837A) ;; <CJK>
     (?$(18c(B . ?\x8373) ;; <CJK>
     (?$(18d(B . ?\x83A4) ;; <CJK>
     (?$(18e(B . ?\x8374) ;; <CJK>
     (?$(18f(B . ?\x838F) ;; <CJK>
     (?$(18g(B . ?\x8381) ;; <CJK>
     (?$(18h(B . ?\x8395) ;; <CJK>
     (?$(18i(B . ?\x8399) ;; <CJK>
     (?$(18j(B . ?\x8375) ;; <CJK>
     (?$(18k(B . ?\x8394) ;; <CJK>
     (?$(18l(B . ?\x83A9) ;; <CJK>
     (?$(18m(B . ?\x837D) ;; <CJK>
     (?$(18n(B . ?\x8383) ;; <CJK>
     (?$(18o(B . ?\x838C) ;; <CJK>
     (?$(18p(B . ?\x839D) ;; <CJK>
     (?$(18q(B . ?\x839B) ;; <CJK>
     (?$(18r(B . ?\x83AA) ;; <CJK>
     (?$(18s(B . ?\x838B) ;; <CJK>
     (?$(18t(B . ?\x837E) ;; <CJK>
     (?$(18u(B . ?\x83A5) ;; <CJK>
     (?$(18v(B . ?\x83AF) ;; <CJK>
     (?$(18w(B . ?\x8388) ;; <CJK>
     (?$(18x(B . ?\x8397) ;; <CJK>
     (?$(18y(B . ?\x83B0) ;; <CJK>
     (?$(18z(B . ?\x837F) ;; <CJK>
     (?$(18{(B . ?\x83A6) ;; <CJK>
     (?$(18|(B . ?\x8387) ;; <CJK>
     (?$(18}(B . ?\x83AE) ;; <CJK>
     (?$(18~(B . ?\x8376) ;; <CJK>
     (?$(19!(B . ?\x839A) ;; <CJK>
     (?$(19"(B . ?\x8659) ;; <CJK>
     (?$(19#(B . ?\x8656) ;; <CJK>
     (?$(19$(B . ?\x86BF) ;; <CJK>
     (?$(19%(B . ?\x86B7) ;; <CJK>
     (?$(19&(B . ?\x86C2) ;; <CJK>
     (?$(19'(B . ?\x86C1) ;; <CJK>
     (?$(19((B . ?\x86C5) ;; <CJK>
     (?$(19)(B . ?\x86BA) ;; <CJK>
     (?$(19*(B . ?\x86B0) ;; <CJK>
     (?$(19+(B . ?\x86C8) ;; <CJK>
     (?$(19,(B . ?\x86B9) ;; <CJK>
     (?$(19-(B . ?\x86B3) ;; <CJK>
     (?$(19.(B . ?\x86B8) ;; <CJK>
     (?$(19/(B . ?\x86CC) ;; <CJK>
     (?$(190(B . ?\x86B4) ;; <CJK>
     (?$(191(B . ?\x86BB) ;; <CJK>
     (?$(192(B . ?\x86BC) ;; <CJK>
     (?$(193(B . ?\x86C3) ;; <CJK>
     (?$(194(B . ?\x86BD) ;; <CJK>
     (?$(195(B . ?\x86BE) ;; <CJK>
     (?$(196(B . ?\x8852) ;; <CJK>
     (?$(197(B . ?\x8889) ;; <CJK>
     (?$(198(B . ?\x8895) ;; <CJK>
     (?$(199(B . ?\x88A8) ;; <CJK>
     (?$(19:(B . ?\x88A2) ;; <CJK>
     (?$(19;(B . ?\x88AA) ;; <CJK>
     (?$(19<(B . ?\x889A) ;; <CJK>
     (?$(19=(B . ?\x8891) ;; <CJK>
     (?$(19>(B . ?\x88A1) ;; <CJK>
     (?$(19?(B . ?\x889F) ;; <CJK>
     (?$(19@(B . ?\x8898) ;; <CJK>
     (?$(19A(B . ?\x88A7) ;; <CJK>
     (?$(19B(B . ?\x8899) ;; <CJK>
     (?$(19C(B . ?\x889B) ;; <CJK>
     (?$(19D(B . ?\x8897) ;; <CJK>
     (?$(19E(B . ?\x88A4) ;; <CJK>
     (?$(19F(B . ?\x88AC) ;; <CJK>
     (?$(19G(B . ?\x888C) ;; <CJK>
     (?$(19H(B . ?\x8893) ;; <CJK>
     (?$(19I(B . ?\x888E) ;; <CJK>
     (?$(19J(B . ?\x8982) ;; <CJK>
     (?$(19K(B . ?\x89D6) ;; <CJK>
     (?$(19L(B . ?\x89D9) ;; <CJK>
     (?$(19M(B . ?\x89D5) ;; <CJK>
     (?$(19N(B . ?\x8A30) ;; <CJK>
     (?$(19O(B . ?\x8A27) ;; <CJK>
     (?$(19P(B . ?\x8A2C) ;; <CJK>
     (?$(19Q(B . ?\x8A1E) ;; <CJK>
     (?$(19R(B . ?\x8C39) ;; <CJK>
     (?$(19S(B . ?\x8C3B) ;; <CJK>
     (?$(19T(B . ?\x8C5C) ;; <CJK>
     (?$(19U(B . ?\x8C5D) ;; <CJK>
     (?$(19V(B . ?\x8C7D) ;; <CJK>
     (?$(19W(B . ?\x8CA5) ;; <CJK>
     (?$(19X(B . ?\x8D7D) ;; <CJK>
     (?$(19Y(B . ?\x8D7B) ;; <CJK>
     (?$(19Z(B . ?\x8D79) ;; <CJK>
     (?$(19[(B . ?\x8DBC) ;; <CJK>
     (?$(19\(B . ?\x8DC2) ;; <CJK>
     (?$(19](B . ?\x8DB9) ;; <CJK>
     (?$(19^(B . ?\x8DBF) ;; <CJK>
     (?$(19_(B . ?\x8DC1) ;; <CJK>
     (?$(19`(B . ?\x8ED8) ;; <CJK>
     (?$(19a(B . ?\x8EDE) ;; <CJK>
     (?$(19b(B . ?\x8EDD) ;; <CJK>
     (?$(19c(B . ?\x8EDC) ;; <CJK>
     (?$(19d(B . ?\x8ED7) ;; <CJK>
     (?$(19e(B . ?\x8EE0) ;; <CJK>
     (?$(19f(B . ?\x8EE1) ;; <CJK>
     (?$(19g(B . ?\x9024) ;; <CJK>
     (?$(19h(B . ?\x900B) ;; <CJK>
     (?$(19i(B . ?\x9011) ;; <CJK>
     (?$(19j(B . ?\x901C) ;; <CJK>
     (?$(19k(B . ?\x900C) ;; <CJK>
     (?$(19l(B . ?\x9021) ;; <CJK>
     (?$(19m(B . ?\x90EF) ;; <CJK>
     (?$(19n(B . ?\x90EA) ;; <CJK>
     (?$(19o(B . ?\x90F0) ;; <CJK>
     (?$(19p(B . ?\x90F4) ;; <CJK>
     (?$(19q(B . ?\x90F2) ;; <CJK>
     (?$(19r(B . ?\x90F3) ;; <CJK>
     (?$(19s(B . ?\x90D4) ;; <CJK>
     (?$(19t(B . ?\x90EB) ;; <CJK>
     (?$(19u(B . ?\x90EC) ;; <CJK>
     (?$(19v(B . ?\x90E9) ;; <CJK>
     (?$(19w(B . ?\x9156) ;; <CJK>
     (?$(19x(B . ?\x9158) ;; <CJK>
     (?$(19y(B . ?\x915A) ;; <CJK>
     (?$(19z(B . ?\x9153) ;; <CJK>
     (?$(19{(B . ?\x9155) ;; <CJK>
     (?$(19|(B . ?\x91EC) ;; <CJK>
     (?$(19}(B . ?\x91F4) ;; <CJK>
     (?$(19~(B . ?\x91F1) ;; <CJK>
     (?$(1:!(B . ?\x91F3) ;; <CJK>
     (?$(1:"(B . ?\x91F8) ;; <CJK>
     (?$(1:#(B . ?\x91E4) ;; <CJK>
     (?$(1:$(B . ?\x91F9) ;; <CJK>
     (?$(1:%(B . ?\x91EA) ;; <CJK>
     (?$(1:&(B . ?\x91EB) ;; <CJK>
     (?$(1:'(B . ?\x91F7) ;; <CJK>
     (?$(1:((B . ?\x91E8) ;; <CJK>
     (?$(1:)(B . ?\x91EE) ;; <CJK>
     (?$(1:*(B . ?\x957A) ;; <CJK>
     (?$(1:+(B . ?\x9586) ;; <CJK>
     (?$(1:,(B . ?\x9588) ;; <CJK>
     (?$(1:-(B . ?\x967C) ;; <CJK>
     (?$(1:.(B . ?\x966D) ;; <CJK>
     (?$(1:/(B . ?\x966B) ;; <CJK>
     (?$(1:0(B . ?\x9671) ;; <CJK>
     (?$(1:1(B . ?\x966F) ;; <CJK>
     (?$(1:2(B . ?\x96BF) ;; <CJK>
     (?$(1:3(B . ?\x976A) ;; <CJK>
     (?$(1:4(B . ?\x9804) ;; <CJK>
     (?$(1:5(B . ?\x98E5) ;; <CJK>
     (?$(1:6(B . ?\x9997) ;; <CJK>
     (?$(1:7(B . ?\x509B) ;; <CJK>
     (?$(1:8(B . ?\x5095) ;; <CJK>
     (?$(1:9(B . ?\x5094) ;; <CJK>
     (?$(1::(B . ?\x509E) ;; <CJK>
     (?$(1:;(B . ?\x508B) ;; <CJK>
     (?$(1:<(B . ?\x50A3) ;; <CJK>
     (?$(1:=(B . ?\x5083) ;; <CJK>
     (?$(1:>(B . ?\x508C) ;; <CJK>
     (?$(1:?(B . ?\x508E) ;; <CJK>
     (?$(1:@(B . ?\x509D) ;; <CJK>
     (?$(1:A(B . ?\x5068) ;; <CJK>
     (?$(1:B(B . ?\x509C) ;; <CJK>
     (?$(1:C(B . ?\x5092) ;; <CJK>
     (?$(1:D(B . ?\x5082) ;; <CJK>
     (?$(1:E(B . ?\x5087) ;; <CJK>
     (?$(1:F(B . ?\x515F) ;; <CJK>
     (?$(1:G(B . ?\x51D4) ;; <CJK>
     (?$(1:H(B . ?\x5312) ;; <CJK>
     (?$(1:I(B . ?\x5311) ;; <CJK>
     (?$(1:J(B . ?\x53A4) ;; <CJK>
     (?$(1:K(B . ?\x53A7) ;; <CJK>
     (?$(1:L(B . ?\x5591) ;; <CJK>
     (?$(1:M(B . ?\x55A8) ;; <CJK>
     (?$(1:N(B . ?\x55A5) ;; <CJK>
     (?$(1:O(B . ?\x55AD) ;; <CJK>
     (?$(1:P(B . ?\x5577) ;; <CJK>
     (?$(1:Q(B . ?\x5645) ;; <CJK>
     (?$(1:R(B . ?\x55A2) ;; <CJK>
     (?$(1:S(B . ?\x5593) ;; <CJK>
     (?$(1:T(B . ?\x5588) ;; <CJK>
     (?$(1:U(B . ?\x558F) ;; <CJK>
     (?$(1:V(B . ?\x55B5) ;; <CJK>
     (?$(1:W(B . ?\x5581) ;; <CJK>
     (?$(1:X(B . ?\x55A3) ;; <CJK>
     (?$(1:Y(B . ?\x5592) ;; <CJK>
     (?$(1:Z(B . ?\x55A4) ;; <CJK>
     (?$(1:[(B . ?\x557D) ;; <CJK>
     (?$(1:\(B . ?\x558C) ;; <CJK>
     (?$(1:](B . ?\x55A6) ;; <CJK>
     (?$(1:^(B . ?\x557F) ;; <CJK>
     (?$(1:_(B . ?\x5595) ;; <CJK>
     (?$(1:`(B . ?\x55A1) ;; <CJK>
     (?$(1:a(B . ?\x558E) ;; <CJK>
     (?$(1:b(B . ?\x570C) ;; <CJK>
     (?$(1:c(B . ?\x5829) ;; <CJK>
     (?$(1:d(B . ?\x5837) ;; <CJK>
     (?$(1:e(B . ?\x5819) ;; <CJK>
     (?$(1:f(B . ?\x581E) ;; <CJK>
     (?$(1:g(B . ?\x5827) ;; <CJK>
     (?$(1:h(B . ?\x5823) ;; <CJK>
     (?$(1:i(B . ?\x5828) ;; <CJK>
     (?$(1:j(B . ?\x57F5) ;; <CJK>
     (?$(1:k(B . ?\x5848) ;; <CJK>
     (?$(1:l(B . ?\x5825) ;; <CJK>
     (?$(1:m(B . ?\x581C) ;; <CJK>
     (?$(1:n(B . ?\x581B) ;; <CJK>
     (?$(1:o(B . ?\x5833) ;; <CJK>
     (?$(1:p(B . ?\x583F) ;; <CJK>
     (?$(1:q(B . ?\x5836) ;; <CJK>
     (?$(1:r(B . ?\x582E) ;; <CJK>
     (?$(1:s(B . ?\x5839) ;; <CJK>
     (?$(1:t(B . ?\x5838) ;; <CJK>
     (?$(1:u(B . ?\x582D) ;; <CJK>
     (?$(1:v(B . ?\x582C) ;; <CJK>
     (?$(1:w(B . ?\x583B) ;; <CJK>
     (?$(1:x(B . ?\x5961) ;; <CJK>
     (?$(1:y(B . ?\x5AAF) ;; <CJK>
     (?$(1:z(B . ?\x5A94) ;; <CJK>
     (?$(1:{(B . ?\x5A9F) ;; <CJK>
     (?$(1:|(B . ?\x5A7A) ;; <CJK>
     (?$(1:}(B . ?\x5AA2) ;; <CJK>
     (?$(1:~(B . ?\x5A9E) ;; <CJK>
     (?$(1;!(B . ?\x5A78) ;; <CJK>
     (?$(1;"(B . ?\x5AA6) ;; <CJK>
     (?$(1;#(B . ?\x5A7C) ;; <CJK>
     (?$(1;$(B . ?\x5AA5) ;; <CJK>
     (?$(1;%(B . ?\x5AAC) ;; <CJK>
     (?$(1;&(B . ?\x5A95) ;; <CJK>
     (?$(1;'(B . ?\x5AAE) ;; <CJK>
     (?$(1;((B . ?\x5A37) ;; <CJK>
     (?$(1;)(B . ?\x5A84) ;; <CJK>
     (?$(1;*(B . ?\x5A8A) ;; <CJK>
     (?$(1;+(B . ?\x5A97) ;; <CJK>
     (?$(1;,(B . ?\x5A83) ;; <CJK>
     (?$(1;-(B . ?\x5A8B) ;; <CJK>
     (?$(1;.(B . ?\x5AA9) ;; <CJK>
     (?$(1;/(B . ?\x5A7B) ;; <CJK>
     (?$(1;0(B . ?\x5A7D) ;; <CJK>
     (?$(1;1(B . ?\x5A8C) ;; <CJK>
     (?$(1;2(B . ?\x5A9C) ;; <CJK>
     (?$(1;3(B . ?\x5A8F) ;; <CJK>
     (?$(1;4(B . ?\x5A93) ;; <CJK>
     (?$(1;5(B . ?\x5A9D) ;; <CJK>
     (?$(1;6(B . ?\x5BEA) ;; <CJK>
     (?$(1;7(B . ?\x5BCD) ;; <CJK>
     (?$(1;8(B . ?\x5BCB) ;; <CJK>
     (?$(1;9(B . ?\x5BD4) ;; <CJK>
     (?$(1;:(B . ?\x5BD1) ;; <CJK>
     (?$(1;;(B . ?\x5BCA) ;; <CJK>
     (?$(1;<(B . ?\x5BCE) ;; <CJK>
     (?$(1;=(B . ?\x5C0C) ;; <CJK>
     (?$(1;>(B . ?\x5C30) ;; <CJK>
     (?$(1;?(B . ?\x5D37) ;; <CJK>
     (?$(1;@(B . ?\x5D43) ;; <CJK>
     (?$(1;A(B . ?\x5D6B) ;; <CJK>
     (?$(1;B(B . ?\x5D41) ;; <CJK>
     (?$(1;C(B . ?\x5D4B) ;; <CJK>
     (?$(1;D(B . ?\x5D3F) ;; <CJK>
     (?$(1;E(B . ?\x5D35) ;; <CJK>
     (?$(1;F(B . ?\x5D51) ;; <CJK>
     (?$(1;G(B . ?\x5D4E) ;; <CJK>
     (?$(1;H(B . ?\x5D55) ;; <CJK>
     (?$(1;I(B . ?\x5D33) ;; <CJK>
     (?$(1;J(B . ?\x5D3A) ;; <CJK>
     (?$(1;K(B . ?\x5D52) ;; <CJK>
     (?$(1;L(B . ?\x5D3D) ;; <CJK>
     (?$(1;M(B . ?\x5D31) ;; <CJK>
     (?$(1;N(B . ?\x5D59) ;; <CJK>
     (?$(1;O(B . ?\x5D42) ;; <CJK>
     (?$(1;P(B . ?\x5D39) ;; <CJK>
     (?$(1;Q(B . ?\x5D49) ;; <CJK>
     (?$(1;R(B . ?\x5D38) ;; <CJK>
     (?$(1;S(B . ?\x5D3C) ;; <CJK>
     (?$(1;T(B . ?\x5D32) ;; <CJK>
     (?$(1;U(B . ?\x5D36) ;; <CJK>
     (?$(1;V(B . ?\x5D40) ;; <CJK>
     (?$(1;W(B . ?\x5D45) ;; <CJK>
     (?$(1;X(B . ?\x5E44) ;; <CJK>
     (?$(1;Y(B . ?\x5E41) ;; <CJK>
     (?$(1;Z(B . ?\x5F58) ;; <CJK>
     (?$(1;[(B . ?\x5FA6) ;; <CJK>
     (?$(1;\(B . ?\x5FA5) ;; <CJK>
     (?$(1;](B . ?\x5FAB) ;; <CJK>
     (?$(1;^(B . ?\x60C9) ;; <CJK>
     (?$(1;_(B . ?\x60B9) ;; <CJK>
     (?$(1;`(B . ?\x60CC) ;; <CJK>
     (?$(1;a(B . ?\x60E2) ;; <CJK>
     (?$(1;b(B . ?\x60CE) ;; <CJK>
     (?$(1;c(B . ?\x60C4) ;; <CJK>
     (?$(1;d(B . ?\x6114) ;; <CJK>
     (?$(1;e(B . ?\x60F2) ;; <CJK>
     (?$(1;f(B . ?\x610A) ;; <CJK>
     (?$(1;g(B . ?\x6116) ;; <CJK>
     (?$(1;h(B . ?\x6105) ;; <CJK>
     (?$(1;i(B . ?\x60F5) ;; <CJK>
     (?$(1;j(B . ?\x6113) ;; <CJK>
     (?$(1;k(B . ?\x60F8) ;; <CJK>
     (?$(1;l(B . ?\x60FC) ;; <CJK>
     (?$(1;m(B . ?\x60FE) ;; <CJK>
     (?$(1;n(B . ?\x60C1) ;; <CJK>
     (?$(1;o(B . ?\x6103) ;; <CJK>
     (?$(1;p(B . ?\x6118) ;; <CJK>
     (?$(1;q(B . ?\x611D) ;; <CJK>
     (?$(1;r(B . ?\x6110) ;; <CJK>
     (?$(1;s(B . ?\x60FF) ;; <CJK>
     (?$(1;t(B . ?\x6104) ;; <CJK>
     (?$(1;u(B . ?\x610B) ;; <CJK>
     (?$(1;v(B . ?\x624A) ;; <CJK>
     (?$(1;w(B . ?\x6394) ;; <CJK>
     (?$(1;x(B . ?\x63B1) ;; <CJK>
     (?$(1;y(B . ?\x63B0) ;; <CJK>
     (?$(1;z(B . ?\x63CE) ;; <CJK>
     (?$(1;{(B . ?\x63E5) ;; <CJK>
     (?$(1;|(B . ?\x63E8) ;; <CJK>
     (?$(1;}(B . ?\x63EF) ;; <CJK>
     (?$(1;~(B . ?\x63C3) ;; <CJK>
     (?$(1<!(B . ?\x649D) ;; <CJK>
     (?$(1<"(B . ?\x63F3) ;; <CJK>
     (?$(1<#(B . ?\x63CA) ;; <CJK>
     (?$(1<$(B . ?\x63E0) ;; <CJK>
     (?$(1<%(B . ?\x63F6) ;; <CJK>
     (?$(1<&(B . ?\x63D5) ;; <CJK>
     (?$(1<'(B . ?\x63F2) ;; <CJK>
     (?$(1<((B . ?\x63F5) ;; <CJK>
     (?$(1<)(B . ?\x6461) ;; <CJK>
     (?$(1<*(B . ?\x63DF) ;; <CJK>
     (?$(1<+(B . ?\x63BE) ;; <CJK>
     (?$(1<,(B . ?\x63DD) ;; <CJK>
     (?$(1<-(B . ?\x63DC) ;; <CJK>
     (?$(1<.(B . ?\x63C4) ;; <CJK>
     (?$(1</(B . ?\x63D8) ;; <CJK>
     (?$(1<0(B . ?\x63D3) ;; <CJK>
     (?$(1<1(B . ?\x63C2) ;; <CJK>
     (?$(1<2(B . ?\x63C7) ;; <CJK>
     (?$(1<3(B . ?\x63CC) ;; <CJK>
     (?$(1<4(B . ?\x63CB) ;; <CJK>
     (?$(1<5(B . ?\x63C8) ;; <CJK>
     (?$(1<6(B . ?\x63F0) ;; <CJK>
     (?$(1<7(B . ?\x63D7) ;; <CJK>
     (?$(1<8(B . ?\x63D9) ;; <CJK>
     (?$(1<9(B . ?\x6532) ;; <CJK>
     (?$(1<:(B . ?\x6567) ;; <CJK>
     (?$(1<;(B . ?\x656A) ;; <CJK>
     (?$(1<<(B . ?\x6564) ;; <CJK>
     (?$(1<=(B . ?\x655C) ;; <CJK>
     (?$(1<>(B . ?\x6568) ;; <CJK>
     (?$(1<?(B . ?\x6565) ;; <CJK>
     (?$(1<@(B . ?\x658C) ;; <CJK>
     (?$(1<A(B . ?\x659D) ;; <CJK>
     (?$(1<B(B . ?\x659E) ;; <CJK>
     (?$(1<C(B . ?\x65AE) ;; <CJK>
     (?$(1<D(B . ?\x65D0) ;; <CJK>
     (?$(1<E(B . ?\x65D2) ;; <CJK>
     (?$(1<F(B . ?\x667C) ;; <CJK>
     (?$(1<G(B . ?\x666C) ;; <CJK>
     (?$(1<H(B . ?\x667B) ;; <CJK>
     (?$(1<I(B . ?\x6680) ;; <CJK>
     (?$(1<J(B . ?\x6671) ;; <CJK>
     (?$(1<K(B . ?\x6679) ;; <CJK>
     (?$(1<L(B . ?\x666A) ;; <CJK>
     (?$(1<M(B . ?\x6672) ;; <CJK>
     (?$(1<N(B . ?\x6701) ;; <CJK>
     (?$(1<O(B . ?\x690C) ;; <CJK>
     (?$(1<P(B . ?\x68D3) ;; <CJK>
     (?$(1<Q(B . ?\x6904) ;; <CJK>
     (?$(1<R(B . ?\x68DC) ;; <CJK>
     (?$(1<S(B . ?\x692A) ;; <CJK>
     (?$(1<T(B . ?\x68EC) ;; <CJK>
     (?$(1<U(B . ?\x68EA) ;; <CJK>
     (?$(1<V(B . ?\x68F1) ;; <CJK>
     (?$(1<W(B . ?\x690F) ;; <CJK>
     (?$(1<X(B . ?\x68D6) ;; <CJK>
     (?$(1<Y(B . ?\x68F7) ;; <CJK>
     (?$(1<Z(B . ?\x68EB) ;; <CJK>
     (?$(1<[(B . ?\x68E4) ;; <CJK>
     (?$(1<\(B . ?\x68F6) ;; <CJK>
     (?$(1<](B . ?\x6913) ;; <CJK>
     (?$(1<^(B . ?\x6910) ;; <CJK>
     (?$(1<_(B . ?\x68F3) ;; <CJK>
     (?$(1<`(B . ?\x68E1) ;; <CJK>
     (?$(1<a(B . ?\x6907) ;; <CJK>
     (?$(1<b(B . ?\x68CC) ;; <CJK>
     (?$(1<c(B . ?\x6908) ;; <CJK>
     (?$(1<d(B . ?\x6970) ;; <CJK>
     (?$(1<e(B . ?\x68B4) ;; <CJK>
     (?$(1<f(B . ?\x6911) ;; <CJK>
     (?$(1<g(B . ?\x68EF) ;; <CJK>
     (?$(1<h(B . ?\x68C6) ;; <CJK>
     (?$(1<i(B . ?\x6914) ;; <CJK>
     (?$(1<j(B . ?\x68F8) ;; <CJK>
     (?$(1<k(B . ?\x68D0) ;; <CJK>
     (?$(1<l(B . ?\x68FD) ;; <CJK>
     (?$(1<m(B . ?\x68FC) ;; <CJK>
     (?$(1<n(B . ?\x68E8) ;; <CJK>
     (?$(1<o(B . ?\x690B) ;; <CJK>
     (?$(1<p(B . ?\x690A) ;; <CJK>
     (?$(1<q(B . ?\x6917) ;; <CJK>
     (?$(1<r(B . ?\x68CE) ;; <CJK>
     (?$(1<s(B . ?\x68C8) ;; <CJK>
     (?$(1<t(B . ?\x68DD) ;; <CJK>
     (?$(1<u(B . ?\x68DE) ;; <CJK>
     (?$(1<v(B . ?\x68E6) ;; <CJK>
     (?$(1<w(B . ?\x68F4) ;; <CJK>
     (?$(1<x(B . ?\x68D1) ;; <CJK>
     (?$(1<y(B . ?\x6906) ;; <CJK>
     (?$(1<z(B . ?\x68D4) ;; <CJK>
     (?$(1<{(B . ?\x68E9) ;; <CJK>
     (?$(1<|(B . ?\x6915) ;; <CJK>
     (?$(1<}(B . ?\x6925) ;; <CJK>
     (?$(1<~(B . ?\x68C7) ;; <CJK>
     (?$(1=!(B . ?\x6B39) ;; <CJK>
     (?$(1="(B . ?\x6B3B) ;; <CJK>
     (?$(1=#(B . ?\x6B3F) ;; <CJK>
     (?$(1=$(B . ?\x6B3C) ;; <CJK>
     (?$(1=%(B . ?\x6B94) ;; <CJK>
     (?$(1=&(B . ?\x6B97) ;; <CJK>
     (?$(1='(B . ?\x6B99) ;; <CJK>
     (?$(1=((B . ?\x6B95) ;; <CJK>
     (?$(1=)(B . ?\x6BBD) ;; <CJK>
     (?$(1=*(B . ?\x6BF0) ;; <CJK>
     (?$(1=+(B . ?\x6BF2) ;; <CJK>
     (?$(1=,(B . ?\x6BF3) ;; <CJK>
     (?$(1=-(B . ?\x6C30) ;; <CJK>
     (?$(1=.(B . ?\x6DFC) ;; <CJK>
     (?$(1=/(B . ?\x6E46) ;; <CJK>
     (?$(1=0(B . ?\x6E47) ;; <CJK>
     (?$(1=1(B . ?\x6E1F) ;; <CJK>
     (?$(1=2(B . ?\x6E49) ;; <CJK>
     (?$(1=3(B . ?\x6E88) ;; <CJK>
     (?$(1=4(B . ?\x6E3C) ;; <CJK>
     (?$(1=5(B . ?\x6E3D) ;; <CJK>
     (?$(1=6(B . ?\x6E45) ;; <CJK>
     (?$(1=7(B . ?\x6E62) ;; <CJK>
     (?$(1=8(B . ?\x6E2B) ;; <CJK>
     (?$(1=9(B . ?\x6E3F) ;; <CJK>
     (?$(1=:(B . ?\x6E41) ;; <CJK>
     (?$(1=;(B . ?\x6E5D) ;; <CJK>
     (?$(1=<(B . ?\x6E73) ;; <CJK>
     (?$(1==(B . ?\x6E1C) ;; <CJK>
     (?$(1=>(B . ?\x6E33) ;; <CJK>
     (?$(1=?(B . ?\x6E4B) ;; <CJK>
     (?$(1=@(B . ?\x6E40) ;; <CJK>
     (?$(1=A(B . ?\x6E51) ;; <CJK>
     (?$(1=B(B . ?\x6E3B) ;; <CJK>
     (?$(1=C(B . ?\x6E03) ;; <CJK>
     (?$(1=D(B . ?\x6E2E) ;; <CJK>
     (?$(1=E(B . ?\x6E5E) ;; <CJK>
     (?$(1=F(B . ?\x6E68) ;; <CJK>
     (?$(1=G(B . ?\x6E5C) ;; <CJK>
     (?$(1=H(B . ?\x6E61) ;; <CJK>
     (?$(1=I(B . ?\x6E31) ;; <CJK>
     (?$(1=J(B . ?\x6E28) ;; <CJK>
     (?$(1=K(B . ?\x6E60) ;; <CJK>
     (?$(1=L(B . ?\x6E71) ;; <CJK>
     (?$(1=M(B . ?\x6E6B) ;; <CJK>
     (?$(1=N(B . ?\x6E39) ;; <CJK>
     (?$(1=O(B . ?\x6E22) ;; <CJK>
     (?$(1=P(B . ?\x6E30) ;; <CJK>
     (?$(1=Q(B . ?\x6E53) ;; <CJK>
     (?$(1=R(B . ?\x6E65) ;; <CJK>
     (?$(1=S(B . ?\x6E27) ;; <CJK>
     (?$(1=T(B . ?\x6E78) ;; <CJK>
     (?$(1=U(B . ?\x6E64) ;; <CJK>
     (?$(1=V(B . ?\x6E77) ;; <CJK>
     (?$(1=W(B . ?\x6E55) ;; <CJK>
     (?$(1=X(B . ?\x6E79) ;; <CJK>
     (?$(1=Y(B . ?\x6E52) ;; <CJK>
     (?$(1=Z(B . ?\x6E66) ;; <CJK>
     (?$(1=[(B . ?\x6E35) ;; <CJK>
     (?$(1=\(B . ?\x6E36) ;; <CJK>
     (?$(1=](B . ?\x6E5A) ;; <CJK>
     (?$(1=^(B . ?\x7120) ;; <CJK>
     (?$(1=_(B . ?\x711E) ;; <CJK>
     (?$(1=`(B . ?\x712F) ;; <CJK>
     (?$(1=a(B . ?\x70FB) ;; <CJK>
     (?$(1=b(B . ?\x712E) ;; <CJK>
     (?$(1=c(B . ?\x7131) ;; <CJK>
     (?$(1=d(B . ?\x7123) ;; <CJK>
     (?$(1=e(B . ?\x7125) ;; <CJK>
     (?$(1=f(B . ?\x7122) ;; <CJK>
     (?$(1=g(B . ?\x7132) ;; <CJK>
     (?$(1=h(B . ?\x711F) ;; <CJK>
     (?$(1=i(B . ?\x7128) ;; <CJK>
     (?$(1=j(B . ?\x713A) ;; <CJK>
     (?$(1=k(B . ?\x711B) ;; <CJK>
     (?$(1=l(B . ?\x724B) ;; <CJK>
     (?$(1=m(B . ?\x725A) ;; <CJK>
     (?$(1=n(B . ?\x7288) ;; <CJK>
     (?$(1=o(B . ?\x7289) ;; <CJK>
     (?$(1=p(B . ?\x7286) ;; <CJK>
     (?$(1=q(B . ?\x7285) ;; <CJK>
     (?$(1=r(B . ?\x728B) ;; <CJK>
     (?$(1=s(B . ?\x7312) ;; <CJK>
     (?$(1=t(B . ?\x730B) ;; <CJK>
     (?$(1=u(B . ?\x7330) ;; <CJK>
     (?$(1=v(B . ?\x7322) ;; <CJK>
     (?$(1=w(B . ?\x7331) ;; <CJK>
     (?$(1=x(B . ?\x7333) ;; <CJK>
     (?$(1=y(B . ?\x7327) ;; <CJK>
     (?$(1=z(B . ?\x7332) ;; <CJK>
     (?$(1={(B . ?\x732D) ;; <CJK>
     (?$(1=|(B . ?\x7326) ;; <CJK>
     (?$(1=}(B . ?\x7323) ;; <CJK>
     (?$(1=~(B . ?\x7335) ;; <CJK>
     (?$(1>!(B . ?\x730C) ;; <CJK>
     (?$(1>"(B . ?\x742E) ;; <CJK>
     (?$(1>#(B . ?\x742C) ;; <CJK>
     (?$(1>$(B . ?\x7430) ;; <CJK>
     (?$(1>%(B . ?\x742B) ;; <CJK>
     (?$(1>&(B . ?\x7416) ;; <CJK>
     (?$(1>'(B . ?\x741A) ;; <CJK>
     (?$(1>((B . ?\x7421) ;; <CJK>
     (?$(1>)(B . ?\x742D) ;; <CJK>
     (?$(1>*(B . ?\x7431) ;; <CJK>
     (?$(1>+(B . ?\x7424) ;; <CJK>
     (?$(1>,(B . ?\x7423) ;; <CJK>
     (?$(1>-(B . ?\x741D) ;; <CJK>
     (?$(1>.(B . ?\x7429) ;; <CJK>
     (?$(1>/(B . ?\x7420) ;; <CJK>
     (?$(1>0(B . ?\x7432) ;; <CJK>
     (?$(1>1(B . ?\x74FB) ;; <CJK>
     (?$(1>2(B . ?\x752F) ;; <CJK>
     (?$(1>3(B . ?\x756F) ;; <CJK>
     (?$(1>4(B . ?\x756C) ;; <CJK>
     (?$(1>5(B . ?\x75E7) ;; <CJK>
     (?$(1>6(B . ?\x75DA) ;; <CJK>
     (?$(1>7(B . ?\x75E1) ;; <CJK>
     (?$(1>8(B . ?\x75E6) ;; <CJK>
     (?$(1>9(B . ?\x75DD) ;; <CJK>
     (?$(1>:(B . ?\x75DF) ;; <CJK>
     (?$(1>;(B . ?\x75E4) ;; <CJK>
     (?$(1><(B . ?\x75D7) ;; <CJK>
     (?$(1>=(B . ?\x7695) ;; <CJK>
     (?$(1>>(B . ?\x7692) ;; <CJK>
     (?$(1>?(B . ?\x76DA) ;; <CJK>
     (?$(1>@(B . ?\x7746) ;; <CJK>
     (?$(1>A(B . ?\x7747) ;; <CJK>
     (?$(1>B(B . ?\x7744) ;; <CJK>
     (?$(1>C(B . ?\x774D) ;; <CJK>
     (?$(1>D(B . ?\x7745) ;; <CJK>
     (?$(1>E(B . ?\x774A) ;; <CJK>
     (?$(1>F(B . ?\x774E) ;; <CJK>
     (?$(1>G(B . ?\x774B) ;; <CJK>
     (?$(1>H(B . ?\x774C) ;; <CJK>
     (?$(1>I(B . ?\x77DE) ;; <CJK>
     (?$(1>J(B . ?\x77EC) ;; <CJK>
     (?$(1>K(B . ?\x7860) ;; <CJK>
     (?$(1>L(B . ?\x7864) ;; <CJK>
     (?$(1>M(B . ?\x7865) ;; <CJK>
     (?$(1>N(B . ?\x785C) ;; <CJK>
     (?$(1>O(B . ?\x786D) ;; <CJK>
     (?$(1>P(B . ?\x7871) ;; <CJK>
     (?$(1>Q(B . ?\x786A) ;; <CJK>
     (?$(1>R(B . ?\x786E) ;; <CJK>
     (?$(1>S(B . ?\x7870) ;; <CJK>
     (?$(1>T(B . ?\x7869) ;; <CJK>
     (?$(1>U(B . ?\x7868) ;; <CJK>
     (?$(1>V(B . ?\x785E) ;; <CJK>
     (?$(1>W(B . ?\x7862) ;; <CJK>
     (?$(1>X(B . ?\x7974) ;; <CJK>
     (?$(1>Y(B . ?\x7973) ;; <CJK>
     (?$(1>Z(B . ?\x7972) ;; <CJK>
     (?$(1>[(B . ?\x7970) ;; <CJK>
     (?$(1>\(B . ?\x7A02) ;; <CJK>
     (?$(1>](B . ?\x7A0A) ;; <CJK>
     (?$(1>^(B . ?\x7A03) ;; <CJK>
     (?$(1>_(B . ?\x7A0C) ;; <CJK>
     (?$(1>`(B . ?\x7A04) ;; <CJK>
     (?$(1>a(B . ?\x7A99) ;; <CJK>
     (?$(1>b(B . ?\x7AE6) ;; <CJK>
     (?$(1>c(B . ?\x7AE4) ;; <CJK>
     (?$(1>d(B . ?\x7B4A) ;; <CJK>
     (?$(1>e(B . ?\x7B3B) ;; <CJK>
     (?$(1>f(B . ?\x7B44) ;; <CJK>
     (?$(1>g(B . ?\x7B48) ;; <CJK>
     (?$(1>h(B . ?\x7B4C) ;; <CJK>
     (?$(1>i(B . ?\x7B4E) ;; <CJK>
     (?$(1>j(B . ?\x7B40) ;; <CJK>
     (?$(1>k(B . ?\x7B58) ;; <CJK>
     (?$(1>l(B . ?\x7B45) ;; <CJK>
     (?$(1>m(B . ?\x7CA2) ;; <CJK>
     (?$(1>n(B . ?\x7C9E) ;; <CJK>
     (?$(1>o(B . ?\x7CA8) ;; <CJK>
     (?$(1>p(B . ?\x7CA1) ;; <CJK>
     (?$(1>q(B . ?\x7D58) ;; <CJK>
     (?$(1>r(B . ?\x7D6F) ;; <CJK>
     (?$(1>s(B . ?\x7D63) ;; <CJK>
     (?$(1>t(B . ?\x7D53) ;; <CJK>
     (?$(1>u(B . ?\x7D56) ;; <CJK>
     (?$(1>v(B . ?\x7D67) ;; <CJK>
     (?$(1>w(B . ?\x7D6A) ;; <CJK>
     (?$(1>x(B . ?\x7D4F) ;; <CJK>
     (?$(1>y(B . ?\x7D6D) ;; <CJK>
     (?$(1>z(B . ?\x7D5C) ;; <CJK>
     (?$(1>{(B . ?\x7D6B) ;; <CJK>
     (?$(1>|(B . ?\x7D52) ;; <CJK>
     (?$(1>}(B . ?\x7D54) ;; <CJK>
     (?$(1>~(B . ?\x7D69) ;; <CJK>
     (?$(1?!(B . ?\x7D51) ;; <CJK>
     (?$(1?"(B . ?\x7D5F) ;; <CJK>
     (?$(1?#(B . ?\x7D4E) ;; <CJK>
     (?$(1?$(B . ?\x7F3E) ;; <CJK>
     (?$(1?%(B . ?\x7F3F) ;; <CJK>
     (?$(1?&(B . ?\x7F65) ;; <CJK>
     (?$(1?'(B . ?\x7F66) ;; <CJK>
     (?$(1?((B . ?\x7FA2) ;; <CJK>
     (?$(1?)(B . ?\x7FA0) ;; <CJK>
     (?$(1?*(B . ?\x7FA1) ;; <CJK>
     (?$(1?+(B . ?\x7FD7) ;; <CJK>
     (?$(1?,(B . ?\x8051) ;; <CJK>
     (?$(1?-(B . ?\x804F) ;; <CJK>
     (?$(1?.(B . ?\x8050) ;; <CJK>
     (?$(1?/(B . ?\x80FE) ;; <CJK>
     (?$(1?0(B . ?\x80D4) ;; <CJK>
     (?$(1?1(B . ?\x8143) ;; <CJK>
     (?$(1?2(B . ?\x814A) ;; <CJK>
     (?$(1?3(B . ?\x8152) ;; <CJK>
     (?$(1?4(B . ?\x814F) ;; <CJK>
     (?$(1?5(B . ?\x8147) ;; <CJK>
     (?$(1?6(B . ?\x813D) ;; <CJK>
     (?$(1?7(B . ?\x814D) ;; <CJK>
     (?$(1?8(B . ?\x813A) ;; <CJK>
     (?$(1?9(B . ?\x81E6) ;; <CJK>
     (?$(1?:(B . ?\x81EE) ;; <CJK>
     (?$(1?;(B . ?\x81F7) ;; <CJK>
     (?$(1?<(B . ?\x81F8) ;; <CJK>
     (?$(1?=(B . ?\x81F9) ;; <CJK>
     (?$(1?>(B . ?\x8204) ;; <CJK>
     (?$(1??(B . ?\x823C) ;; <CJK>
     (?$(1?@(B . ?\x823D) ;; <CJK>
     (?$(1?A(B . ?\x823F) ;; <CJK>
     (?$(1?B(B . ?\x8275) ;; <CJK>
     (?$(1?C(B . ?\x833B) ;; <CJK>
     (?$(1?D(B . ?\x83CF) ;; <CJK>
     (?$(1?E(B . ?\x83F9) ;; <CJK>
     (?$(1?F(B . ?\x8423) ;; <CJK>
     (?$(1?G(B . ?\x83C0) ;; <CJK>
     (?$(1?H(B . ?\x83E8) ;; <CJK>
     (?$(1?I(B . ?\x8412) ;; <CJK>
     (?$(1?J(B . ?\x83E7) ;; <CJK>
     (?$(1?K(B . ?\x83E4) ;; <CJK>
     (?$(1?L(B . ?\x83FC) ;; <CJK>
     (?$(1?M(B . ?\x83F6) ;; <CJK>
     (?$(1?N(B . ?\x8410) ;; <CJK>
     (?$(1?O(B . ?\x83C6) ;; <CJK>
     (?$(1?P(B . ?\x83C8) ;; <CJK>
     (?$(1?Q(B . ?\x83EB) ;; <CJK>
     (?$(1?R(B . ?\x83E3) ;; <CJK>
     (?$(1?S(B . ?\x83BF) ;; <CJK>
     (?$(1?T(B . ?\x8401) ;; <CJK>
     (?$(1?U(B . ?\x83DD) ;; <CJK>
     (?$(1?V(B . ?\x83E5) ;; <CJK>
     (?$(1?W(B . ?\x83D8) ;; <CJK>
     (?$(1?X(B . ?\x83FF) ;; <CJK>
     (?$(1?Y(B . ?\x83E1) ;; <CJK>
     (?$(1?Z(B . ?\x83CB) ;; <CJK>
     (?$(1?[(B . ?\x83CE) ;; <CJK>
     (?$(1?\(B . ?\x83D6) ;; <CJK>
     (?$(1?](B . ?\x83F5) ;; <CJK>
     (?$(1?^(B . ?\x83C9) ;; <CJK>
     (?$(1?_(B . ?\x8409) ;; <CJK>
     (?$(1?`(B . ?\x840F) ;; <CJK>
     (?$(1?a(B . ?\x83DE) ;; <CJK>
     (?$(1?b(B . ?\x8411) ;; <CJK>
     (?$(1?c(B . ?\x8406) ;; <CJK>
     (?$(1?d(B . ?\x83C2) ;; <CJK>
     (?$(1?e(B . ?\x83F3) ;; <CJK>
     (?$(1?f(B . ?\x83D5) ;; <CJK>
     (?$(1?g(B . ?\x83FA) ;; <CJK>
     (?$(1?h(B . ?\x83C7) ;; <CJK>
     (?$(1?i(B . ?\x83D1) ;; <CJK>
     (?$(1?j(B . ?\x83EA) ;; <CJK>
     (?$(1?k(B . ?\x8413) ;; <CJK>
     (?$(1?l(B . ?\x83C3) ;; <CJK>
     (?$(1?m(B . ?\x83EC) ;; <CJK>
     (?$(1?n(B . ?\x83EE) ;; <CJK>
     (?$(1?o(B . ?\x83C4) ;; <CJK>
     (?$(1?p(B . ?\x83FB) ;; <CJK>
     (?$(1?q(B . ?\x83D7) ;; <CJK>
     (?$(1?r(B . ?\x83E2) ;; <CJK>
     (?$(1?s(B . ?\x841B) ;; <CJK>
     (?$(1?t(B . ?\x83DB) ;; <CJK>
     (?$(1?u(B . ?\x83FE) ;; <CJK>
     (?$(1?v(B . ?\x86D8) ;; <CJK>
     (?$(1?w(B . ?\x86E2) ;; <CJK>
     (?$(1?x(B . ?\x86E6) ;; <CJK>
     (?$(1?y(B . ?\x86D3) ;; <CJK>
     (?$(1?z(B . ?\x86E3) ;; <CJK>
     (?$(1?{(B . ?\x86DA) ;; <CJK>
     (?$(1?|(B . ?\x86EA) ;; <CJK>
     (?$(1?}(B . ?\x86DD) ;; <CJK>
     (?$(1?~(B . ?\x86EB) ;; <CJK>
     (?$(1@!(B . ?\x86DC) ;; <CJK>
     (?$(1@"(B . ?\x86EC) ;; <CJK>
     (?$(1@#(B . ?\x86E9) ;; <CJK>
     (?$(1@$(B . ?\x86D7) ;; <CJK>
     (?$(1@%(B . ?\x86E8) ;; <CJK>
     (?$(1@&(B . ?\x86D1) ;; <CJK>
     (?$(1@'(B . ?\x8848) ;; <CJK>
     (?$(1@((B . ?\x8856) ;; <CJK>
     (?$(1@)(B . ?\x8855) ;; <CJK>
     (?$(1@*(B . ?\x88BA) ;; <CJK>
     (?$(1@+(B . ?\x88D7) ;; <CJK>
     (?$(1@,(B . ?\x88B9) ;; <CJK>
     (?$(1@-(B . ?\x88B8) ;; <CJK>
     (?$(1@.(B . ?\x88C0) ;; <CJK>
     (?$(1@/(B . ?\x88BE) ;; <CJK>
     (?$(1@0(B . ?\x88B6) ;; <CJK>
     (?$(1@1(B . ?\x88BC) ;; <CJK>
     (?$(1@2(B . ?\x88B7) ;; <CJK>
     (?$(1@3(B . ?\x88BD) ;; <CJK>
     (?$(1@4(B . ?\x88B2) ;; <CJK>
     (?$(1@5(B . ?\x8901) ;; <CJK>
     (?$(1@6(B . ?\x88C9) ;; <CJK>
     (?$(1@7(B . ?\x8995) ;; <CJK>
     (?$(1@8(B . ?\x8998) ;; <CJK>
     (?$(1@9(B . ?\x8997) ;; <CJK>
     (?$(1@:(B . ?\x89DD) ;; <CJK>
     (?$(1@;(B . ?\x89DA) ;; <CJK>
     (?$(1@<(B . ?\x89DB) ;; <CJK>
     (?$(1@=(B . ?\x8A4E) ;; <CJK>
     (?$(1@>(B . ?\x8A4D) ;; <CJK>
     (?$(1@?(B . ?\x8A39) ;; <CJK>
     (?$(1@@(B . ?\x8A59) ;; <CJK>
     (?$(1@A(B . ?\x8A40) ;; <CJK>
     (?$(1@B(B . ?\x8A57) ;; <CJK>
     (?$(1@C(B . ?\x8A58) ;; <CJK>
     (?$(1@D(B . ?\x8A44) ;; <CJK>
     (?$(1@E(B . ?\x8A45) ;; <CJK>
     (?$(1@F(B . ?\x8A52) ;; <CJK>
     (?$(1@G(B . ?\x8A48) ;; <CJK>
     (?$(1@H(B . ?\x8A51) ;; <CJK>
     (?$(1@I(B . ?\x8A4A) ;; <CJK>
     (?$(1@J(B . ?\x8A4C) ;; <CJK>
     (?$(1@K(B . ?\x8A4F) ;; <CJK>
     (?$(1@L(B . ?\x8C5F) ;; <CJK>
     (?$(1@M(B . ?\x8C81) ;; <CJK>
     (?$(1@N(B . ?\x8C80) ;; <CJK>
     (?$(1@O(B . ?\x8CBA) ;; <CJK>
     (?$(1@P(B . ?\x8CBE) ;; <CJK>
     (?$(1@Q(B . ?\x8CB0) ;; <CJK>
     (?$(1@R(B . ?\x8CB9) ;; <CJK>
     (?$(1@S(B . ?\x8CB5) ;; <CJK>
     (?$(1@T(B . ?\x8D84) ;; <CJK>
     (?$(1@U(B . ?\x8D80) ;; <CJK>
     (?$(1@V(B . ?\x8D89) ;; <CJK>
     (?$(1@W(B . ?\x8DD8) ;; <CJK>
     (?$(1@X(B . ?\x8DD3) ;; <CJK>
     (?$(1@Y(B . ?\x8DCD) ;; <CJK>
     (?$(1@Z(B . ?\x8DC7) ;; <CJK>
     (?$(1@[(B . ?\x8DD6) ;; <CJK>
     (?$(1@\(B . ?\x8DDC) ;; <CJK>
     (?$(1@](B . ?\x8DCF) ;; <CJK>
     (?$(1@^(B . ?\x8DD5) ;; <CJK>
     (?$(1@_(B . ?\x8DD9) ;; <CJK>
     (?$(1@`(B . ?\x8DC8) ;; <CJK>
     (?$(1@a(B . ?\x8DD7) ;; <CJK>
     (?$(1@b(B . ?\x8DC5) ;; <CJK>
     (?$(1@c(B . ?\x8EEF) ;; <CJK>
     (?$(1@d(B . ?\x8EF7) ;; <CJK>
     (?$(1@e(B . ?\x8EFA) ;; <CJK>
     (?$(1@f(B . ?\x8EF9) ;; <CJK>
     (?$(1@g(B . ?\x8EE6) ;; <CJK>
     (?$(1@h(B . ?\x8EEE) ;; <CJK>
     (?$(1@i(B . ?\x8EE5) ;; <CJK>
     (?$(1@j(B . ?\x8EF5) ;; <CJK>
     (?$(1@k(B . ?\x8EE7) ;; <CJK>
     (?$(1@l(B . ?\x8EE8) ;; <CJK>
     (?$(1@m(B . ?\x8EF6) ;; <CJK>
     (?$(1@n(B . ?\x8EEB) ;; <CJK>
     (?$(1@o(B . ?\x8EF1) ;; <CJK>
     (?$(1@p(B . ?\x8EEC) ;; <CJK>
     (?$(1@q(B . ?\x8EF4) ;; <CJK>
     (?$(1@r(B . ?\x8EE9) ;; <CJK>
     (?$(1@s(B . ?\x902D) ;; <CJK>
     (?$(1@t(B . ?\x9034) ;; <CJK>
     (?$(1@u(B . ?\x902F) ;; <CJK>
     (?$(1@v(B . ?\x9106) ;; <CJK>
     (?$(1@w(B . ?\x912C) ;; <CJK>
     (?$(1@x(B . ?\x9104) ;; <CJK>
     (?$(1@y(B . ?\x90FF) ;; <CJK>
     (?$(1@z(B . ?\x90FC) ;; <CJK>
     (?$(1@{(B . ?\x9108) ;; <CJK>
     (?$(1@|(B . ?\x90F9) ;; <CJK>
     (?$(1@}(B . ?\x90FB) ;; <CJK>
     (?$(1@~(B . ?\x9101) ;; <CJK>
     (?$(1A!(B . ?\x9100) ;; <CJK>
     (?$(1A"(B . ?\x9107) ;; <CJK>
     (?$(1A#(B . ?\x9105) ;; <CJK>
     (?$(1A$(B . ?\x9103) ;; <CJK>
     (?$(1A%(B . ?\x9161) ;; <CJK>
     (?$(1A&(B . ?\x9164) ;; <CJK>
     (?$(1A'(B . ?\x915F) ;; <CJK>
     (?$(1A((B . ?\x9162) ;; <CJK>
     (?$(1A)(B . ?\x9160) ;; <CJK>
     (?$(1A*(B . ?\x9201) ;; <CJK>
     (?$(1A+(B . ?\x920A) ;; <CJK>
     (?$(1A,(B . ?\x9225) ;; <CJK>
     (?$(1A-(B . ?\x9203) ;; <CJK>
     (?$(1A.(B . ?\x921A) ;; <CJK>
     (?$(1A/(B . ?\x9226) ;; <CJK>
     (?$(1A0(B . ?\x920F) ;; <CJK>
     (?$(1A1(B . ?\x920C) ;; <CJK>
     (?$(1A2(B . ?\x9200) ;; <CJK>
     (?$(1A3(B . ?\x9212) ;; <CJK>
     (?$(1A4(B . ?\x91FF) ;; <CJK>
     (?$(1A5(B . ?\x91FD) ;; <CJK>
     (?$(1A6(B . ?\x9206) ;; <CJK>
     (?$(1A7(B . ?\x9204) ;; <CJK>
     (?$(1A8(B . ?\x9227) ;; <CJK>
     (?$(1A9(B . ?\x9202) ;; <CJK>
     (?$(1A:(B . ?\x921C) ;; <CJK>
     (?$(1A;(B . ?\x9224) ;; <CJK>
     (?$(1A<(B . ?\x9219) ;; <CJK>
     (?$(1A=(B . ?\x9217) ;; <CJK>
     (?$(1A>(B . ?\x9205) ;; <CJK>
     (?$(1A?(B . ?\x9216) ;; <CJK>
     (?$(1A@(B . ?\x957B) ;; <CJK>
     (?$(1AA(B . ?\x958D) ;; <CJK>
     (?$(1AB(B . ?\x958C) ;; <CJK>
     (?$(1AC(B . ?\x9590) ;; <CJK>
     (?$(1AD(B . ?\x9687) ;; <CJK>
     (?$(1AE(B . ?\x967E) ;; <CJK>
     (?$(1AF(B . ?\x9688) ;; <CJK>
     (?$(1AG(B . ?\x9689) ;; <CJK>
     (?$(1AH(B . ?\x9683) ;; <CJK>
     (?$(1AI(B . ?\x9680) ;; <CJK>
     (?$(1AJ(B . ?\x96C2) ;; <CJK>
     (?$(1AK(B . ?\x96C8) ;; <CJK>
     (?$(1AL(B . ?\x96C3) ;; <CJK>
     (?$(1AM(B . ?\x96F1) ;; <CJK>
     (?$(1AN(B . ?\x96F0) ;; <CJK>
     (?$(1AO(B . ?\x976C) ;; <CJK>
     (?$(1AP(B . ?\x9770) ;; <CJK>
     (?$(1AQ(B . ?\x976E) ;; <CJK>
     (?$(1AR(B . ?\x9807) ;; <CJK>
     (?$(1AS(B . ?\x98A9) ;; <CJK>
     (?$(1AT(B . ?\x98EB) ;; <CJK>
     (?$(1AU(B . ?\x9CE6) ;; <CJK>
     (?$(1AV(B . ?\x9EF9) ;; <CJK>
     (?$(1AW(B . ?\x4E83) ;; <CJK>
     (?$(1AX(B . ?\x4E84) ;; <CJK>
     (?$(1AY(B . ?\x4EB6) ;; <CJK>
     (?$(1AZ(B . ?\x50BD) ;; <CJK>
     (?$(1A[(B . ?\x50BF) ;; <CJK>
     (?$(1A\(B . ?\x50C6) ;; <CJK>
     (?$(1A](B . ?\x50AE) ;; <CJK>
     (?$(1A^(B . ?\x50C4) ;; <CJK>
     (?$(1A_(B . ?\x50CA) ;; <CJK>
     (?$(1A`(B . ?\x50B4) ;; <CJK>
     (?$(1Aa(B . ?\x50C8) ;; <CJK>
     (?$(1Ab(B . ?\x50C2) ;; <CJK>
     (?$(1Ac(B . ?\x50B0) ;; <CJK>
     (?$(1Ad(B . ?\x50C1) ;; <CJK>
     (?$(1Ae(B . ?\x50BA) ;; <CJK>
     (?$(1Af(B . ?\x50B1) ;; <CJK>
     (?$(1Ag(B . ?\x50CB) ;; <CJK>
     (?$(1Ah(B . ?\x50C9) ;; <CJK>
     (?$(1Ai(B . ?\x50B6) ;; <CJK>
     (?$(1Aj(B . ?\x50B8) ;; <CJK>
     (?$(1Ak(B . ?\x51D7) ;; <CJK>
     (?$(1Al(B . ?\x527A) ;; <CJK>
     (?$(1Am(B . ?\x5278) ;; <CJK>
     (?$(1An(B . ?\x527B) ;; <CJK>
     (?$(1Ao(B . ?\x527C) ;; <CJK>
     (?$(1Ap(B . ?\x55C3) ;; <CJK>
     (?$(1Aq(B . ?\x55DB) ;; <CJK>
     (?$(1Ar(B . ?\x55CC) ;; <CJK>
     (?$(1As(B . ?\x55D0) ;; <CJK>
     (?$(1At(B . ?\x55CB) ;; <CJK>
     (?$(1Au(B . ?\x55CA) ;; <CJK>
     (?$(1Av(B . ?\x55DD) ;; <CJK>
     (?$(1Aw(B . ?\x55C0) ;; <CJK>
     (?$(1Ax(B . ?\x55D4) ;; <CJK>
     (?$(1Ay(B . ?\x55C4) ;; <CJK>
     (?$(1Az(B . ?\x55E9) ;; <CJK>
     (?$(1A{(B . ?\x55BF) ;; <CJK>
     (?$(1A|(B . ?\x55D2) ;; <CJK>
     (?$(1A}(B . ?\x558D) ;; <CJK>
     (?$(1A~(B . ?\x55CF) ;; <CJK>
     (?$(1B!(B . ?\x55D5) ;; <CJK>
     (?$(1B"(B . ?\x55E2) ;; <CJK>
     (?$(1B#(B . ?\x55D6) ;; <CJK>
     (?$(1B$(B . ?\x55C8) ;; <CJK>
     (?$(1B%(B . ?\x55F2) ;; <CJK>
     (?$(1B&(B . ?\x55CD) ;; <CJK>
     (?$(1B'(B . ?\x55D9) ;; <CJK>
     (?$(1B((B . ?\x55C2) ;; <CJK>
     (?$(1B)(B . ?\x5714) ;; <CJK>
     (?$(1B*(B . ?\x5853) ;; <CJK>
     (?$(1B+(B . ?\x5868) ;; <CJK>
     (?$(1B,(B . ?\x5864) ;; <CJK>
     (?$(1B-(B . ?\x584F) ;; <CJK>
     (?$(1B.(B . ?\x584D) ;; <CJK>
     (?$(1B/(B . ?\x5849) ;; <CJK>
     (?$(1B0(B . ?\x586F) ;; <CJK>
     (?$(1B1(B . ?\x5855) ;; <CJK>
     (?$(1B2(B . ?\x584E) ;; <CJK>
     (?$(1B3(B . ?\x585D) ;; <CJK>
     (?$(1B4(B . ?\x5859) ;; <CJK>
     (?$(1B5(B . ?\x5865) ;; <CJK>
     (?$(1B6(B . ?\x585B) ;; <CJK>
     (?$(1B7(B . ?\x583D) ;; <CJK>
     (?$(1B8(B . ?\x5863) ;; <CJK>
     (?$(1B9(B . ?\x5871) ;; <CJK>
     (?$(1B:(B . ?\x58FC) ;; <CJK>
     (?$(1B;(B . ?\x5AC7) ;; <CJK>
     (?$(1B<(B . ?\x5AC4) ;; <CJK>
     (?$(1B=(B . ?\x5ACB) ;; <CJK>
     (?$(1B>(B . ?\x5ABA) ;; <CJK>
     (?$(1B?(B . ?\x5AB8) ;; <CJK>
     (?$(1B@(B . ?\x5AB1) ;; <CJK>
     (?$(1BA(B . ?\x5AB5) ;; <CJK>
     (?$(1BB(B . ?\x5AB0) ;; <CJK>
     (?$(1BC(B . ?\x5ABF) ;; <CJK>
     (?$(1BD(B . ?\x5AC8) ;; <CJK>
     (?$(1BE(B . ?\x5ABB) ;; <CJK>
     (?$(1BF(B . ?\x5AC6) ;; <CJK>
     (?$(1BG(B . ?\x5AB7) ;; <CJK>
     (?$(1BH(B . ?\x5AC0) ;; <CJK>
     (?$(1BI(B . ?\x5ACA) ;; <CJK>
     (?$(1BJ(B . ?\x5AB4) ;; <CJK>
     (?$(1BK(B . ?\x5AB6) ;; <CJK>
     (?$(1BL(B . ?\x5ACD) ;; <CJK>
     (?$(1BM(B . ?\x5AB9) ;; <CJK>
     (?$(1BN(B . ?\x5A90) ;; <CJK>
     (?$(1BO(B . ?\x5BD6) ;; <CJK>
     (?$(1BP(B . ?\x5BD8) ;; <CJK>
     (?$(1BQ(B . ?\x5BD9) ;; <CJK>
     (?$(1BR(B . ?\x5C1F) ;; <CJK>
     (?$(1BS(B . ?\x5C33) ;; <CJK>
     (?$(1BT(B . ?\x5D71) ;; <CJK>
     (?$(1BU(B . ?\x5D63) ;; <CJK>
     (?$(1BV(B . ?\x5D4A) ;; <CJK>
     (?$(1BW(B . ?\x5D65) ;; <CJK>
     (?$(1BX(B . ?\x5D72) ;; <CJK>
     (?$(1BY(B . ?\x5D6C) ;; <CJK>
     (?$(1BZ(B . ?\x5D5E) ;; <CJK>
     (?$(1B[(B . ?\x5D68) ;; <CJK>
     (?$(1B\(B . ?\x5D67) ;; <CJK>
     (?$(1B](B . ?\x5D62) ;; <CJK>
     (?$(1B^(B . ?\x5DF0) ;; <CJK>
     (?$(1B_(B . ?\x5E4F) ;; <CJK>
     (?$(1B`(B . ?\x5E4E) ;; <CJK>
     (?$(1Ba(B . ?\x5E4A) ;; <CJK>
     (?$(1Bb(B . ?\x5E4D) ;; <CJK>
     (?$(1Bc(B . ?\x5E4B) ;; <CJK>
     (?$(1Bd(B . ?\x5EC5) ;; <CJK>
     (?$(1Be(B . ?\x5ECC) ;; <CJK>
     (?$(1Bf(B . ?\x5EC6) ;; <CJK>
     (?$(1Bg(B . ?\x5ECB) ;; <CJK>
     (?$(1Bh(B . ?\x5EC7) ;; <CJK>
     (?$(1Bi(B . ?\x5F40) ;; <CJK>
     (?$(1Bj(B . ?\x5FAF) ;; <CJK>
     (?$(1Bk(B . ?\x5FAD) ;; <CJK>
     (?$(1Bl(B . ?\x60F7) ;; <CJK>
     (?$(1Bm(B . ?\x6149) ;; <CJK>
     (?$(1Bn(B . ?\x614A) ;; <CJK>
     (?$(1Bo(B . ?\x612B) ;; <CJK>
     (?$(1Bp(B . ?\x6145) ;; <CJK>
     (?$(1Bq(B . ?\x6136) ;; <CJK>
     (?$(1Br(B . ?\x6132) ;; <CJK>
     (?$(1Bs(B . ?\x612E) ;; <CJK>
     (?$(1Bt(B . ?\x6146) ;; <CJK>
     (?$(1Bu(B . ?\x612F) ;; <CJK>
     (?$(1Bv(B . ?\x614F) ;; <CJK>
     (?$(1Bw(B . ?\x6129) ;; <CJK>
     (?$(1Bx(B . ?\x6140) ;; <CJK>
     (?$(1By(B . ?\x6220) ;; <CJK>
     (?$(1Bz(B . ?\x9168) ;; <CJK>
     (?$(1B{(B . ?\x6223) ;; <CJK>
     (?$(1B|(B . ?\x6225) ;; <CJK>
     (?$(1B}(B . ?\x6224) ;; <CJK>
     (?$(1B~(B . ?\x63C5) ;; <CJK>
     (?$(1C!(B . ?\x63F1) ;; <CJK>
     (?$(1C"(B . ?\x63EB) ;; <CJK>
     (?$(1C#(B . ?\x6410) ;; <CJK>
     (?$(1C$(B . ?\x6412) ;; <CJK>
     (?$(1C%(B . ?\x6409) ;; <CJK>
     (?$(1C&(B . ?\x6420) ;; <CJK>
     (?$(1C'(B . ?\x6424) ;; <CJK>
     (?$(1C((B . ?\x6433) ;; <CJK>
     (?$(1C)(B . ?\x6443) ;; <CJK>
     (?$(1C*(B . ?\x641F) ;; <CJK>
     (?$(1C+(B . ?\x6415) ;; <CJK>
     (?$(1C,(B . ?\x6418) ;; <CJK>
     (?$(1C-(B . ?\x6439) ;; <CJK>
     (?$(1C.(B . ?\x6437) ;; <CJK>
     (?$(1C/(B . ?\x6422) ;; <CJK>
     (?$(1C0(B . ?\x6423) ;; <CJK>
     (?$(1C1(B . ?\x640C) ;; <CJK>
     (?$(1C2(B . ?\x6426) ;; <CJK>
     (?$(1C3(B . ?\x6430) ;; <CJK>
     (?$(1C4(B . ?\x6428) ;; <CJK>
     (?$(1C5(B . ?\x6441) ;; <CJK>
     (?$(1C6(B . ?\x6435) ;; <CJK>
     (?$(1C7(B . ?\x642F) ;; <CJK>
     (?$(1C8(B . ?\x640A) ;; <CJK>
     (?$(1C9(B . ?\x641A) ;; <CJK>
     (?$(1C:(B . ?\x6440) ;; <CJK>
     (?$(1C;(B . ?\x6425) ;; <CJK>
     (?$(1C<(B . ?\x6427) ;; <CJK>
     (?$(1C=(B . ?\x640B) ;; <CJK>
     (?$(1C>(B . ?\x63E7) ;; <CJK>
     (?$(1C?(B . ?\x641B) ;; <CJK>
     (?$(1C@(B . ?\x642E) ;; <CJK>
     (?$(1CA(B . ?\x6421) ;; <CJK>
     (?$(1CB(B . ?\x640E) ;; <CJK>
     (?$(1CC(B . ?\x656F) ;; <CJK>
     (?$(1CD(B . ?\x6592) ;; <CJK>
     (?$(1CE(B . ?\x65D3) ;; <CJK>
     (?$(1CF(B . ?\x6686) ;; <CJK>
     (?$(1CG(B . ?\x668C) ;; <CJK>
     (?$(1CH(B . ?\x6695) ;; <CJK>
     (?$(1CI(B . ?\x6690) ;; <CJK>
     (?$(1CJ(B . ?\x668B) ;; <CJK>
     (?$(1CK(B . ?\x668A) ;; <CJK>
     (?$(1CL(B . ?\x6699) ;; <CJK>
     (?$(1CM(B . ?\x6694) ;; <CJK>
     (?$(1CN(B . ?\x6678) ;; <CJK>
     (?$(1CO(B . ?\x6720) ;; <CJK>
     (?$(1CP(B . ?\x6966) ;; <CJK>
     (?$(1CQ(B . ?\x695F) ;; <CJK>
     (?$(1CR(B . ?\x6938) ;; <CJK>
     (?$(1CS(B . ?\x694E) ;; <CJK>
     (?$(1CT(B . ?\x6962) ;; <CJK>
     (?$(1CU(B . ?\x6971) ;; <CJK>
     (?$(1CV(B . ?\x693F) ;; <CJK>
     (?$(1CW(B . ?\x6945) ;; <CJK>
     (?$(1CX(B . ?\x696A) ;; <CJK>
     (?$(1CY(B . ?\x6939) ;; <CJK>
     (?$(1CZ(B . ?\x6942) ;; <CJK>
     (?$(1C[(B . ?\x6957) ;; <CJK>
     (?$(1C\(B . ?\x6959) ;; <CJK>
     (?$(1C](B . ?\x697A) ;; <CJK>
     (?$(1C^(B . ?\x6948) ;; <CJK>
     (?$(1C_(B . ?\x6949) ;; <CJK>
     (?$(1C`(B . ?\x6935) ;; <CJK>
     (?$(1Ca(B . ?\x696C) ;; <CJK>
     (?$(1Cb(B . ?\x6933) ;; <CJK>
     (?$(1Cc(B . ?\x693D) ;; <CJK>
     (?$(1Cd(B . ?\x6965) ;; <CJK>
     (?$(1Ce(B . ?\x68F0) ;; <CJK>
     (?$(1Cf(B . ?\x6978) ;; <CJK>
     (?$(1Cg(B . ?\x6934) ;; <CJK>
     (?$(1Ch(B . ?\x6969) ;; <CJK>
     (?$(1Ci(B . ?\x6940) ;; <CJK>
     (?$(1Cj(B . ?\x696F) ;; <CJK>
     (?$(1Ck(B . ?\x6944) ;; <CJK>
     (?$(1Cl(B . ?\x6976) ;; <CJK>
     (?$(1Cm(B . ?\x6958) ;; <CJK>
     (?$(1Cn(B . ?\x6941) ;; <CJK>
     (?$(1Co(B . ?\x6974) ;; <CJK>
     (?$(1Cp(B . ?\x694C) ;; <CJK>
     (?$(1Cq(B . ?\x693B) ;; <CJK>
     (?$(1Cr(B . ?\x694B) ;; <CJK>
     (?$(1Cs(B . ?\x6937) ;; <CJK>
     (?$(1Ct(B . ?\x695C) ;; <CJK>
     (?$(1Cu(B . ?\x694F) ;; <CJK>
     (?$(1Cv(B . ?\x6951) ;; <CJK>
     (?$(1Cw(B . ?\x6932) ;; <CJK>
     (?$(1Cx(B . ?\x6952) ;; <CJK>
     (?$(1Cy(B . ?\x692F) ;; <CJK>
     (?$(1Cz(B . ?\x697B) ;; <CJK>
     (?$(1C{(B . ?\x693C) ;; <CJK>
     (?$(1C|(B . ?\x6B46) ;; <CJK>
     (?$(1C}(B . ?\x6B45) ;; <CJK>
     (?$(1C~(B . ?\x6B43) ;; <CJK>
     (?$(1D!(B . ?\x6B42) ;; <CJK>
     (?$(1D"(B . ?\x6B48) ;; <CJK>
     (?$(1D#(B . ?\x6B41) ;; <CJK>
     (?$(1D$(B . ?\x6B9B) ;; <CJK>
     (?$(1D%(B . ?\xFA0D) ;; CJK COMPATIBILITY IDEOGRAPH-FA0D
     (?$(1D&(B . ?\x6BFB) ;; <CJK>
     (?$(1D'(B . ?\x6BFC) ;; <CJK>
     (?$(1D((B . ?\x6BF9) ;; <CJK>
     (?$(1D)(B . ?\x6BF7) ;; <CJK>
     (?$(1D*(B . ?\x6BF8) ;; <CJK>
     (?$(1D+(B . ?\x6E9B) ;; <CJK>
     (?$(1D,(B . ?\x6ED6) ;; <CJK>
     (?$(1D-(B . ?\x6EC8) ;; <CJK>
     (?$(1D.(B . ?\x6E8F) ;; <CJK>
     (?$(1D/(B . ?\x6EC0) ;; <CJK>
     (?$(1D0(B . ?\x6E9F) ;; <CJK>
     (?$(1D1(B . ?\x6E93) ;; <CJK>
     (?$(1D2(B . ?\x6E94) ;; <CJK>
     (?$(1D3(B . ?\x6EA0) ;; <CJK>
     (?$(1D4(B . ?\x6EB1) ;; <CJK>
     (?$(1D5(B . ?\x6EB9) ;; <CJK>
     (?$(1D6(B . ?\x6EC6) ;; <CJK>
     (?$(1D7(B . ?\x6ED2) ;; <CJK>
     (?$(1D8(B . ?\x6EBD) ;; <CJK>
     (?$(1D9(B . ?\x6EC1) ;; <CJK>
     (?$(1D:(B . ?\x6E9E) ;; <CJK>
     (?$(1D;(B . ?\x6EC9) ;; <CJK>
     (?$(1D<(B . ?\x6EB7) ;; <CJK>
     (?$(1D=(B . ?\x6EB0) ;; <CJK>
     (?$(1D>(B . ?\x6ECD) ;; <CJK>
     (?$(1D?(B . ?\x6EA6) ;; <CJK>
     (?$(1D@(B . ?\x6ECF) ;; <CJK>
     (?$(1DA(B . ?\x6EB2) ;; <CJK>
     (?$(1DB(B . ?\x6EBE) ;; <CJK>
     (?$(1DC(B . ?\x6EC3) ;; <CJK>
     (?$(1DD(B . ?\x6EDC) ;; <CJK>
     (?$(1DE(B . ?\x6ED8) ;; <CJK>
     (?$(1DF(B . ?\x6E99) ;; <CJK>
     (?$(1DG(B . ?\x6E92) ;; <CJK>
     (?$(1DH(B . ?\x6E8E) ;; <CJK>
     (?$(1DI(B . ?\x6E8D) ;; <CJK>
     (?$(1DJ(B . ?\x6EA4) ;; <CJK>
     (?$(1DK(B . ?\x6EA1) ;; <CJK>
     (?$(1DL(B . ?\x6EBF) ;; <CJK>
     (?$(1DM(B . ?\x6EB3) ;; <CJK>
     (?$(1DN(B . ?\x6ED0) ;; <CJK>
     (?$(1DO(B . ?\x6ECA) ;; <CJK>
     (?$(1DP(B . ?\x6E97) ;; <CJK>
     (?$(1DQ(B . ?\x6EAE) ;; <CJK>
     (?$(1DR(B . ?\x6EA3) ;; <CJK>
     (?$(1DS(B . ?\x7147) ;; <CJK>
     (?$(1DT(B . ?\x7154) ;; <CJK>
     (?$(1DU(B . ?\x7152) ;; <CJK>
     (?$(1DV(B . ?\x7163) ;; <CJK>
     (?$(1DW(B . ?\x7160) ;; <CJK>
     (?$(1DX(B . ?\x7141) ;; <CJK>
     (?$(1DY(B . ?\x715D) ;; <CJK>
     (?$(1DZ(B . ?\x7162) ;; <CJK>
     (?$(1D[(B . ?\x7172) ;; <CJK>
     (?$(1D\(B . ?\x7178) ;; <CJK>
     (?$(1D](B . ?\x716A) ;; <CJK>
     (?$(1D^(B . ?\x7161) ;; <CJK>
     (?$(1D_(B . ?\x7142) ;; <CJK>
     (?$(1D`(B . ?\x7158) ;; <CJK>
     (?$(1Da(B . ?\x7143) ;; <CJK>
     (?$(1Db(B . ?\x714B) ;; <CJK>
     (?$(1Dc(B . ?\x7170) ;; <CJK>
     (?$(1Dd(B . ?\x715F) ;; <CJK>
     (?$(1De(B . ?\x7150) ;; <CJK>
     (?$(1Df(B . ?\x7153) ;; <CJK>
     (?$(1Dg(B . ?\x7144) ;; <CJK>
     (?$(1Dh(B . ?\x714D) ;; <CJK>
     (?$(1Di(B . ?\x715A) ;; <CJK>
     (?$(1Dj(B . ?\x724F) ;; <CJK>
     (?$(1Dk(B . ?\x728D) ;; <CJK>
     (?$(1Dl(B . ?\x728C) ;; <CJK>
     (?$(1Dm(B . ?\x7291) ;; <CJK>
     (?$(1Dn(B . ?\x7290) ;; <CJK>
     (?$(1Do(B . ?\x728E) ;; <CJK>
     (?$(1Dp(B . ?\x733C) ;; <CJK>
     (?$(1Dq(B . ?\x7342) ;; <CJK>
     (?$(1Dr(B . ?\x733B) ;; <CJK>
     (?$(1Ds(B . ?\x733A) ;; <CJK>
     (?$(1Dt(B . ?\x7340) ;; <CJK>
     (?$(1Du(B . ?\x734A) ;; <CJK>
     (?$(1Dv(B . ?\x7349) ;; <CJK>
     (?$(1Dw(B . ?\x7444) ;; <CJK>
     (?$(1Dx(B . ?\x744A) ;; <CJK>
     (?$(1Dy(B . ?\x744B) ;; <CJK>
     (?$(1Dz(B . ?\x7452) ;; <CJK>
     (?$(1D{(B . ?\x7451) ;; <CJK>
     (?$(1D|(B . ?\x7457) ;; <CJK>
     (?$(1D}(B . ?\x7440) ;; <CJK>
     (?$(1D~(B . ?\x744F) ;; <CJK>
     (?$(1E!(B . ?\x7450) ;; <CJK>
     (?$(1E"(B . ?\x744E) ;; <CJK>
     (?$(1E#(B . ?\x7442) ;; <CJK>
     (?$(1E$(B . ?\x7446) ;; <CJK>
     (?$(1E%(B . ?\x744D) ;; <CJK>
     (?$(1E&(B . ?\x7454) ;; <CJK>
     (?$(1E'(B . ?\x74E1) ;; <CJK>
     (?$(1E((B . ?\x74FF) ;; <CJK>
     (?$(1E)(B . ?\x74FE) ;; <CJK>
     (?$(1E*(B . ?\x74FD) ;; <CJK>
     (?$(1E+(B . ?\x751D) ;; <CJK>
     (?$(1E,(B . ?\x7579) ;; <CJK>
     (?$(1E-(B . ?\x7577) ;; <CJK>
     (?$(1E.(B . ?\x6983) ;; <CJK>
     (?$(1E/(B . ?\x75EF) ;; <CJK>
     (?$(1E0(B . ?\x760F) ;; <CJK>
     (?$(1E1(B . ?\x7603) ;; <CJK>
     (?$(1E2(B . ?\x75F7) ;; <CJK>
     (?$(1E3(B . ?\x75FE) ;; <CJK>
     (?$(1E4(B . ?\x75FC) ;; <CJK>
     (?$(1E5(B . ?\x75F9) ;; <CJK>
     (?$(1E6(B . ?\x75F8) ;; <CJK>
     (?$(1E7(B . ?\x7610) ;; <CJK>
     (?$(1E8(B . ?\x75FB) ;; <CJK>
     (?$(1E9(B . ?\x75F6) ;; <CJK>
     (?$(1E:(B . ?\x75ED) ;; <CJK>
     (?$(1E;(B . ?\x75F5) ;; <CJK>
     (?$(1E<(B . ?\x75FD) ;; <CJK>
     (?$(1E=(B . ?\x7699) ;; <CJK>
     (?$(1E>(B . ?\x76B5) ;; <CJK>
     (?$(1E?(B . ?\x76DD) ;; <CJK>
     (?$(1E@(B . ?\x7755) ;; <CJK>
     (?$(1EA(B . ?\x775F) ;; <CJK>
     (?$(1EB(B . ?\x7760) ;; <CJK>
     (?$(1EC(B . ?\x7752) ;; <CJK>
     (?$(1ED(B . ?\x7756) ;; <CJK>
     (?$(1EE(B . ?\x775A) ;; <CJK>
     (?$(1EF(B . ?\x7769) ;; <CJK>
     (?$(1EG(B . ?\x7767) ;; <CJK>
     (?$(1EH(B . ?\x7754) ;; <CJK>
     (?$(1EI(B . ?\x7759) ;; <CJK>
     (?$(1EJ(B . ?\x776D) ;; <CJK>
     (?$(1EK(B . ?\x77E0) ;; <CJK>
     (?$(1EL(B . ?\x7887) ;; <CJK>
     (?$(1EM(B . ?\x789A) ;; <CJK>
     (?$(1EN(B . ?\x7894) ;; <CJK>
     (?$(1EO(B . ?\x788F) ;; <CJK>
     (?$(1EP(B . ?\x7884) ;; <CJK>
     (?$(1EQ(B . ?\x7895) ;; <CJK>
     (?$(1ER(B . ?\x7885) ;; <CJK>
     (?$(1ES(B . ?\x7886) ;; <CJK>
     (?$(1ET(B . ?\x78A1) ;; <CJK>
     (?$(1EU(B . ?\x7883) ;; <CJK>
     (?$(1EV(B . ?\x7879) ;; <CJK>
     (?$(1EW(B . ?\x7899) ;; <CJK>
     (?$(1EX(B . ?\x7880) ;; <CJK>
     (?$(1EY(B . ?\x7896) ;; <CJK>
     (?$(1EZ(B . ?\x787B) ;; <CJK>
     (?$(1E[(B . ?\x797C) ;; <CJK>
     (?$(1E\(B . ?\x7982) ;; <CJK>
     (?$(1E](B . ?\x797D) ;; <CJK>
     (?$(1E^(B . ?\x7979) ;; <CJK>
     (?$(1E_(B . ?\x7A11) ;; <CJK>
     (?$(1E`(B . ?\x7A18) ;; <CJK>
     (?$(1Ea(B . ?\x7A19) ;; <CJK>
     (?$(1Eb(B . ?\x7A12) ;; <CJK>
     (?$(1Ec(B . ?\x7A17) ;; <CJK>
     (?$(1Ed(B . ?\x7A15) ;; <CJK>
     (?$(1Ee(B . ?\x7A22) ;; <CJK>
     (?$(1Ef(B . ?\x7A13) ;; <CJK>
     (?$(1Eg(B . ?\x7A1B) ;; <CJK>
     (?$(1Eh(B . ?\x7A10) ;; <CJK>
     (?$(1Ei(B . ?\x7AA3) ;; <CJK>
     (?$(1Ej(B . ?\x7AA2) ;; <CJK>
     (?$(1Ek(B . ?\x7A9E) ;; <CJK>
     (?$(1El(B . ?\x7AEB) ;; <CJK>
     (?$(1Em(B . ?\x7B66) ;; <CJK>
     (?$(1En(B . ?\x7B64) ;; <CJK>
     (?$(1Eo(B . ?\x7B6D) ;; <CJK>
     (?$(1Ep(B . ?\x7B74) ;; <CJK>
     (?$(1Eq(B . ?\x7B69) ;; <CJK>
     (?$(1Er(B . ?\x7B72) ;; <CJK>
     (?$(1Es(B . ?\x7B65) ;; <CJK>
     (?$(1Et(B . ?\x7B73) ;; <CJK>
     (?$(1Eu(B . ?\x7B71) ;; <CJK>
     (?$(1Ev(B . ?\x7B70) ;; <CJK>
     (?$(1Ew(B . ?\x7B61) ;; <CJK>
     (?$(1Ex(B . ?\x7B78) ;; <CJK>
     (?$(1Ey(B . ?\x7B76) ;; <CJK>
     (?$(1Ez(B . ?\x7B63) ;; <CJK>
     (?$(1E{(B . ?\x7CB2) ;; <CJK>
     (?$(1E|(B . ?\x7CB4) ;; <CJK>
     (?$(1E}(B . ?\x7CAF) ;; <CJK>
     (?$(1E~(B . ?\x7D88) ;; <CJK>
     (?$(1F!(B . ?\x7D86) ;; <CJK>
     (?$(1F"(B . ?\x7D80) ;; <CJK>
     (?$(1F#(B . ?\x7D8D) ;; <CJK>
     (?$(1F$(B . ?\x7D7F) ;; <CJK>
     (?$(1F%(B . ?\x7D85) ;; <CJK>
     (?$(1F&(B . ?\x7D7A) ;; <CJK>
     (?$(1F'(B . ?\x7D8E) ;; <CJK>
     (?$(1F((B . ?\x7D7B) ;; <CJK>
     (?$(1F)(B . ?\x7D83) ;; <CJK>
     (?$(1F*(B . ?\x7D7C) ;; <CJK>
     (?$(1F+(B . ?\x7D8C) ;; <CJK>
     (?$(1F,(B . ?\x7D94) ;; <CJK>
     (?$(1F-(B . ?\x7D84) ;; <CJK>
     (?$(1F.(B . ?\x7D7D) ;; <CJK>
     (?$(1F/(B . ?\x7D92) ;; <CJK>
     (?$(1F0(B . ?\x7F6D) ;; <CJK>
     (?$(1F1(B . ?\x7F6B) ;; <CJK>
     (?$(1F2(B . ?\x7F67) ;; <CJK>
     (?$(1F3(B . ?\x7F68) ;; <CJK>
     (?$(1F4(B . ?\x7F6C) ;; <CJK>
     (?$(1F5(B . ?\x7FA6) ;; <CJK>
     (?$(1F6(B . ?\x7FA5) ;; <CJK>
     (?$(1F7(B . ?\x7FA7) ;; <CJK>
     (?$(1F8(B . ?\x7FDB) ;; <CJK>
     (?$(1F9(B . ?\x7FDC) ;; <CJK>
     (?$(1F:(B . ?\x8021) ;; <CJK>
     (?$(1F;(B . ?\x8164) ;; <CJK>
     (?$(1F<(B . ?\x8160) ;; <CJK>
     (?$(1F=(B . ?\x8177) ;; <CJK>
     (?$(1F>(B . ?\x815C) ;; <CJK>
     (?$(1F?(B . ?\x8169) ;; <CJK>
     (?$(1F@(B . ?\x815B) ;; <CJK>
     (?$(1FA(B . ?\x8162) ;; <CJK>
     (?$(1FB(B . ?\x8172) ;; <CJK>
     (?$(1FC(B . ?\x6721) ;; <CJK>
     (?$(1FD(B . ?\x815E) ;; <CJK>
     (?$(1FE(B . ?\x8176) ;; <CJK>
     (?$(1FF(B . ?\x8167) ;; <CJK>
     (?$(1FG(B . ?\x816F) ;; <CJK>
     (?$(1FH(B . ?\x8144) ;; <CJK>
     (?$(1FI(B . ?\x8161) ;; <CJK>
     (?$(1FJ(B . ?\x821D) ;; <CJK>
     (?$(1FK(B . ?\x8249) ;; <CJK>
     (?$(1FL(B . ?\x8244) ;; <CJK>
     (?$(1FM(B . ?\x8240) ;; <CJK>
     (?$(1FN(B . ?\x8242) ;; <CJK>
     (?$(1FO(B . ?\x8245) ;; <CJK>
     (?$(1FP(B . ?\x84F1) ;; <CJK>
     (?$(1FQ(B . ?\x843F) ;; <CJK>
     (?$(1FR(B . ?\x8456) ;; <CJK>
     (?$(1FS(B . ?\x8476) ;; <CJK>
     (?$(1FT(B . ?\x8479) ;; <CJK>
     (?$(1FU(B . ?\x848F) ;; <CJK>
     (?$(1FV(B . ?\x848D) ;; <CJK>
     (?$(1FW(B . ?\x8465) ;; <CJK>
     (?$(1FX(B . ?\x8451) ;; <CJK>
     (?$(1FY(B . ?\x8440) ;; <CJK>
     (?$(1FZ(B . ?\x8486) ;; <CJK>
     (?$(1F[(B . ?\x8467) ;; <CJK>
     (?$(1F\(B . ?\x8430) ;; <CJK>
     (?$(1F](B . ?\x844D) ;; <CJK>
     (?$(1F^(B . ?\x847D) ;; <CJK>
     (?$(1F_(B . ?\x845A) ;; <CJK>
     (?$(1F`(B . ?\x8459) ;; <CJK>
     (?$(1Fa(B . ?\x8474) ;; <CJK>
     (?$(1Fb(B . ?\x8473) ;; <CJK>
     (?$(1Fc(B . ?\x845D) ;; <CJK>
     (?$(1Fd(B . ?\x8507) ;; <CJK>
     (?$(1Fe(B . ?\x845E) ;; <CJK>
     (?$(1Ff(B . ?\x8437) ;; <CJK>
     (?$(1Fg(B . ?\x843A) ;; <CJK>
     (?$(1Fh(B . ?\x8434) ;; <CJK>
     (?$(1Fi(B . ?\x847A) ;; <CJK>
     (?$(1Fj(B . ?\x8443) ;; <CJK>
     (?$(1Fk(B . ?\x8478) ;; <CJK>
     (?$(1Fl(B . ?\x8432) ;; <CJK>
     (?$(1Fm(B . ?\x8445) ;; <CJK>
     (?$(1Fn(B . ?\x8429) ;; <CJK>
     (?$(1Fo(B . ?\x83D9) ;; <CJK>
     (?$(1Fp(B . ?\x844B) ;; <CJK>
     (?$(1Fq(B . ?\x842F) ;; <CJK>
     (?$(1Fr(B . ?\x8442) ;; <CJK>
     (?$(1Fs(B . ?\x842D) ;; <CJK>
     (?$(1Ft(B . ?\x845F) ;; <CJK>
     (?$(1Fu(B . ?\x8470) ;; <CJK>
     (?$(1Fv(B . ?\x8439) ;; <CJK>
     (?$(1Fw(B . ?\x844E) ;; <CJK>
     (?$(1Fx(B . ?\x844C) ;; <CJK>
     (?$(1Fy(B . ?\x8452) ;; <CJK>
     (?$(1Fz(B . ?\x846F) ;; <CJK>
     (?$(1F{(B . ?\x84C5) ;; <CJK>
     (?$(1F|(B . ?\x848E) ;; <CJK>
     (?$(1F}(B . ?\x843B) ;; <CJK>
     (?$(1F~(B . ?\x8447) ;; <CJK>
     (?$(1G!(B . ?\x8436) ;; <CJK>
     (?$(1G"(B . ?\x8433) ;; <CJK>
     (?$(1G#(B . ?\x8468) ;; <CJK>
     (?$(1G$(B . ?\x847E) ;; <CJK>
     (?$(1G%(B . ?\x8444) ;; <CJK>
     (?$(1G&(B . ?\x842B) ;; <CJK>
     (?$(1G'(B . ?\x8460) ;; <CJK>
     (?$(1G((B . ?\x8454) ;; <CJK>
     (?$(1G)(B . ?\x846E) ;; <CJK>
     (?$(1G*(B . ?\x8450) ;; <CJK>
     (?$(1G+(B . ?\x870B) ;; <CJK>
     (?$(1G,(B . ?\x8704) ;; <CJK>
     (?$(1G-(B . ?\x86F7) ;; <CJK>
     (?$(1G.(B . ?\x870C) ;; <CJK>
     (?$(1G/(B . ?\x86FA) ;; <CJK>
     (?$(1G0(B . ?\x86D6) ;; <CJK>
     (?$(1G1(B . ?\x86F5) ;; <CJK>
     (?$(1G2(B . ?\x874D) ;; <CJK>
     (?$(1G3(B . ?\x86F8) ;; <CJK>
     (?$(1G4(B . ?\x870E) ;; <CJK>
     (?$(1G5(B . ?\x8709) ;; <CJK>
     (?$(1G6(B . ?\x8701) ;; <CJK>
     (?$(1G7(B . ?\x86F6) ;; <CJK>
     (?$(1G8(B . ?\x870D) ;; <CJK>
     (?$(1G9(B . ?\x8705) ;; <CJK>
     (?$(1G:(B . ?\x88D6) ;; <CJK>
     (?$(1G;(B . ?\x88CB) ;; <CJK>
     (?$(1G<(B . ?\x88CD) ;; <CJK>
     (?$(1G=(B . ?\x88CE) ;; <CJK>
     (?$(1G>(B . ?\x88DE) ;; <CJK>
     (?$(1G?(B . ?\x88DB) ;; <CJK>
     (?$(1G@(B . ?\x88DA) ;; <CJK>
     (?$(1GA(B . ?\x88CC) ;; <CJK>
     (?$(1GB(B . ?\x88D0) ;; <CJK>
     (?$(1GC(B . ?\x8985) ;; <CJK>
     (?$(1GD(B . ?\x899B) ;; <CJK>
     (?$(1GE(B . ?\x89DF) ;; <CJK>
     (?$(1GF(B . ?\x89E5) ;; <CJK>
     (?$(1GG(B . ?\x89E4) ;; <CJK>
     (?$(1GH(B . ?\x89E1) ;; <CJK>
     (?$(1GI(B . ?\x89E0) ;; <CJK>
     (?$(1GJ(B . ?\x89E2) ;; <CJK>
     (?$(1GK(B . ?\x89DC) ;; <CJK>
     (?$(1GL(B . ?\x89E6) ;; <CJK>
     (?$(1GM(B . ?\x8A76) ;; <CJK>
     (?$(1GN(B . ?\x8A86) ;; <CJK>
     (?$(1GO(B . ?\x8A7F) ;; <CJK>
     (?$(1GP(B . ?\x8A61) ;; <CJK>
     (?$(1GQ(B . ?\x8A3F) ;; <CJK>
     (?$(1GR(B . ?\x8A77) ;; <CJK>
     (?$(1GS(B . ?\x8A82) ;; <CJK>
     (?$(1GT(B . ?\x8A84) ;; <CJK>
     (?$(1GU(B . ?\x8A75) ;; <CJK>
     (?$(1GV(B . ?\x8A83) ;; <CJK>
     (?$(1GW(B . ?\x8A81) ;; <CJK>
     (?$(1GX(B . ?\x8A74) ;; <CJK>
     (?$(1GY(B . ?\x8A7A) ;; <CJK>
     (?$(1GZ(B . ?\x8C3C) ;; <CJK>
     (?$(1G[(B . ?\x8C4B) ;; <CJK>
     (?$(1G\(B . ?\x8C4A) ;; <CJK>
     (?$(1G](B . ?\x8C65) ;; <CJK>
     (?$(1G^(B . ?\x8C64) ;; <CJK>
     (?$(1G_(B . ?\x8C66) ;; <CJK>
     (?$(1G`(B . ?\x8C86) ;; <CJK>
     (?$(1Ga(B . ?\x8C84) ;; <CJK>
     (?$(1Gb(B . ?\x8C85) ;; <CJK>
     (?$(1Gc(B . ?\x8CCC) ;; <CJK>
     (?$(1Gd(B . ?\x8D68) ;; <CJK>
     (?$(1Ge(B . ?\x8D69) ;; <CJK>
     (?$(1Gf(B . ?\x8D91) ;; <CJK>
     (?$(1Gg(B . ?\x8D8C) ;; <CJK>
     (?$(1Gh(B . ?\x8D8E) ;; <CJK>
     (?$(1Gi(B . ?\x8D8F) ;; <CJK>
     (?$(1Gj(B . ?\x8D8D) ;; <CJK>
     (?$(1Gk(B . ?\x8D93) ;; <CJK>
     (?$(1Gl(B . ?\x8D94) ;; <CJK>
     (?$(1Gm(B . ?\x8D90) ;; <CJK>
     (?$(1Gn(B . ?\x8D92) ;; <CJK>
     (?$(1Go(B . ?\x8DF0) ;; <CJK>
     (?$(1Gp(B . ?\x8DE0) ;; <CJK>
     (?$(1Gq(B . ?\x8DEC) ;; <CJK>
     (?$(1Gr(B . ?\x8DF1) ;; <CJK>
     (?$(1Gs(B . ?\x8DEE) ;; <CJK>
     (?$(1Gt(B . ?\x8DD0) ;; <CJK>
     (?$(1Gu(B . ?\x8DE9) ;; <CJK>
     (?$(1Gv(B . ?\x8DE3) ;; <CJK>
     (?$(1Gw(B . ?\x8DE2) ;; <CJK>
     (?$(1Gx(B . ?\x8DE7) ;; <CJK>
     (?$(1Gy(B . ?\x8DF2) ;; <CJK>
     (?$(1Gz(B . ?\x8DEB) ;; <CJK>
     (?$(1G{(B . ?\x8DF4) ;; <CJK>
     (?$(1G|(B . ?\x8F06) ;; <CJK>
     (?$(1G}(B . ?\x8EFF) ;; <CJK>
     (?$(1G~(B . ?\x8F01) ;; <CJK>
     (?$(1H!(B . ?\x8F00) ;; <CJK>
     (?$(1H"(B . ?\x8F05) ;; <CJK>
     (?$(1H#(B . ?\x8F07) ;; <CJK>
     (?$(1H$(B . ?\x8F08) ;; <CJK>
     (?$(1H%(B . ?\x8F02) ;; <CJK>
     (?$(1H&(B . ?\x8F0B) ;; <CJK>
     (?$(1H'(B . ?\x9052) ;; <CJK>
     (?$(1H((B . ?\x903F) ;; <CJK>
     (?$(1H)(B . ?\x9044) ;; <CJK>
     (?$(1H*(B . ?\x9049) ;; <CJK>
     (?$(1H+(B . ?\x903D) ;; <CJK>
     (?$(1H,(B . ?\x9110) ;; <CJK>
     (?$(1H-(B . ?\x910D) ;; <CJK>
     (?$(1H.(B . ?\x910F) ;; <CJK>
     (?$(1H/(B . ?\x9111) ;; <CJK>
     (?$(1H0(B . ?\x9116) ;; <CJK>
     (?$(1H1(B . ?\x9114) ;; <CJK>
     (?$(1H2(B . ?\x910B) ;; <CJK>
     (?$(1H3(B . ?\x910E) ;; <CJK>
     (?$(1H4(B . ?\x916E) ;; <CJK>
     (?$(1H5(B . ?\x916F) ;; <CJK>
     (?$(1H6(B . ?\x9248) ;; <CJK>
     (?$(1H7(B . ?\x9252) ;; <CJK>
     (?$(1H8(B . ?\x9230) ;; <CJK>
     (?$(1H9(B . ?\x923A) ;; <CJK>
     (?$(1H:(B . ?\x9266) ;; <CJK>
     (?$(1H;(B . ?\x9233) ;; <CJK>
     (?$(1H<(B . ?\x9265) ;; <CJK>
     (?$(1H=(B . ?\x925E) ;; <CJK>
     (?$(1H>(B . ?\x9283) ;; <CJK>
     (?$(1H?(B . ?\x922E) ;; <CJK>
     (?$(1H@(B . ?\x924A) ;; <CJK>
     (?$(1HA(B . ?\x9246) ;; <CJK>
     (?$(1HB(B . ?\x926D) ;; <CJK>
     (?$(1HC(B . ?\x926C) ;; <CJK>
     (?$(1HD(B . ?\x924F) ;; <CJK>
     (?$(1HE(B . ?\x9260) ;; <CJK>
     (?$(1HF(B . ?\x9267) ;; <CJK>
     (?$(1HG(B . ?\x926F) ;; <CJK>
     (?$(1HH(B . ?\x9236) ;; <CJK>
     (?$(1HI(B . ?\x9261) ;; <CJK>
     (?$(1HJ(B . ?\x9270) ;; <CJK>
     (?$(1HK(B . ?\x9231) ;; <CJK>
     (?$(1HL(B . ?\x9254) ;; <CJK>
     (?$(1HM(B . ?\x9263) ;; <CJK>
     (?$(1HN(B . ?\x9250) ;; <CJK>
     (?$(1HO(B . ?\x9272) ;; <CJK>
     (?$(1HP(B . ?\x924E) ;; <CJK>
     (?$(1HQ(B . ?\x9253) ;; <CJK>
     (?$(1HR(B . ?\x924C) ;; <CJK>
     (?$(1HS(B . ?\x9256) ;; <CJK>
     (?$(1HT(B . ?\x9232) ;; <CJK>
     (?$(1HU(B . ?\x959F) ;; <CJK>
     (?$(1HV(B . ?\x959C) ;; <CJK>
     (?$(1HW(B . ?\x959E) ;; <CJK>
     (?$(1HX(B . ?\x959B) ;; <CJK>
     (?$(1HY(B . ?\x9692) ;; <CJK>
     (?$(1HZ(B . ?\x9693) ;; <CJK>
     (?$(1H[(B . ?\x9691) ;; <CJK>
     (?$(1H\(B . ?\x9697) ;; <CJK>
     (?$(1H](B . ?\x96CE) ;; <CJK>
     (?$(1H^(B . ?\x96FA) ;; <CJK>
     (?$(1H_(B . ?\x96FD) ;; <CJK>
     (?$(1H`(B . ?\x96F8) ;; <CJK>
     (?$(1Ha(B . ?\x96F5) ;; <CJK>
     (?$(1Hb(B . ?\x9773) ;; <CJK>
     (?$(1Hc(B . ?\x9777) ;; <CJK>
     (?$(1Hd(B . ?\x9778) ;; <CJK>
     (?$(1He(B . ?\x9772) ;; <CJK>
     (?$(1Hf(B . ?\x980F) ;; <CJK>
     (?$(1Hg(B . ?\x980D) ;; <CJK>
     (?$(1Hh(B . ?\x980E) ;; <CJK>
     (?$(1Hi(B . ?\x98AC) ;; <CJK>
     (?$(1Hj(B . ?\x98F6) ;; <CJK>
     (?$(1Hk(B . ?\x98F9) ;; <CJK>
     (?$(1Hl(B . ?\x99AF) ;; <CJK>
     (?$(1Hm(B . ?\x99B2) ;; <CJK>
     (?$(1Hn(B . ?\x99B0) ;; <CJK>
     (?$(1Ho(B . ?\x99B5) ;; <CJK>
     (?$(1Hp(B . ?\x9AAD) ;; <CJK>
     (?$(1Hq(B . ?\x9AAB) ;; <CJK>
     (?$(1Hr(B . ?\x9B5B) ;; <CJK>
     (?$(1Hs(B . ?\x9CEA) ;; <CJK>
     (?$(1Ht(B . ?\x9CED) ;; <CJK>
     (?$(1Hu(B . ?\x9CE7) ;; <CJK>
     (?$(1Hv(B . ?\x9E80) ;; <CJK>
     (?$(1Hw(B . ?\x9EFD) ;; <CJK>
     (?$(1Hx(B . ?\x50E6) ;; <CJK>
     (?$(1Hy(B . ?\x50D4) ;; <CJK>
     (?$(1Hz(B . ?\x50D7) ;; <CJK>
     (?$(1H{(B . ?\x50E8) ;; <CJK>
     (?$(1H|(B . ?\x50F3) ;; <CJK>
     (?$(1H}(B . ?\x50DB) ;; <CJK>
     (?$(1H~(B . ?\x50EA) ;; <CJK>
     (?$(1I!(B . ?\x50DD) ;; <CJK>
     (?$(1I"(B . ?\x50E4) ;; <CJK>
     (?$(1I#(B . ?\x50D3) ;; <CJK>
     (?$(1I$(B . ?\x50EC) ;; <CJK>
     (?$(1I%(B . ?\x50F0) ;; <CJK>
     (?$(1I&(B . ?\x50EF) ;; <CJK>
     (?$(1I'(B . ?\x50E3) ;; <CJK>
     (?$(1I((B . ?\x50E0) ;; <CJK>
     (?$(1I)(B . ?\x51D8) ;; <CJK>
     (?$(1I*(B . ?\x5280) ;; <CJK>
     (?$(1I+(B . ?\x5281) ;; <CJK>
     (?$(1I,(B . ?\x52E9) ;; <CJK>
     (?$(1I-(B . ?\x52EB) ;; <CJK>
     (?$(1I.(B . ?\x5330) ;; <CJK>
     (?$(1I/(B . ?\x53AC) ;; <CJK>
     (?$(1I0(B . ?\x5627) ;; <CJK>
     (?$(1I1(B . ?\x5615) ;; <CJK>
     (?$(1I2(B . ?\x560C) ;; <CJK>
     (?$(1I3(B . ?\x5612) ;; <CJK>
     (?$(1I4(B . ?\x55FC) ;; <CJK>
     (?$(1I5(B . ?\x560F) ;; <CJK>
     (?$(1I6(B . ?\x561C) ;; <CJK>
     (?$(1I7(B . ?\x5601) ;; <CJK>
     (?$(1I8(B . ?\x5613) ;; <CJK>
     (?$(1I9(B . ?\x5602) ;; <CJK>
     (?$(1I:(B . ?\x55FA) ;; <CJK>
     (?$(1I;(B . ?\x561D) ;; <CJK>
     (?$(1I<(B . ?\x5604) ;; <CJK>
     (?$(1I=(B . ?\x55FF) ;; <CJK>
     (?$(1I>(B . ?\x55F9) ;; <CJK>
     (?$(1I?(B . ?\x5889) ;; <CJK>
     (?$(1I@(B . ?\x587C) ;; <CJK>
     (?$(1IA(B . ?\x5890) ;; <CJK>
     (?$(1IB(B . ?\x5898) ;; <CJK>
     (?$(1IC(B . ?\x5886) ;; <CJK>
     (?$(1ID(B . ?\x5881) ;; <CJK>
     (?$(1IE(B . ?\x587F) ;; <CJK>
     (?$(1IF(B . ?\x5874) ;; <CJK>
     (?$(1IG(B . ?\x588B) ;; <CJK>
     (?$(1IH(B . ?\x587A) ;; <CJK>
     (?$(1II(B . ?\x5887) ;; <CJK>
     (?$(1IJ(B . ?\x5891) ;; <CJK>
     (?$(1IK(B . ?\x588E) ;; <CJK>
     (?$(1IL(B . ?\x5876) ;; <CJK>
     (?$(1IM(B . ?\x5882) ;; <CJK>
     (?$(1IN(B . ?\x5888) ;; <CJK>
     (?$(1IO(B . ?\x587B) ;; <CJK>
     (?$(1IP(B . ?\x5894) ;; <CJK>
     (?$(1IQ(B . ?\x588F) ;; <CJK>
     (?$(1IR(B . ?\x58FE) ;; <CJK>
     (?$(1IS(B . ?\x596B) ;; <CJK>
     (?$(1IT(B . ?\x5ADC) ;; <CJK>
     (?$(1IU(B . ?\x5AEE) ;; <CJK>
     (?$(1IV(B . ?\x5AE5) ;; <CJK>
     (?$(1IW(B . ?\x5AD5) ;; <CJK>
     (?$(1IX(B . ?\x5AEA) ;; <CJK>
     (?$(1IY(B . ?\x5ADA) ;; <CJK>
     (?$(1IZ(B . ?\x5AED) ;; <CJK>
     (?$(1I[(B . ?\x5AEB) ;; <CJK>
     (?$(1I\(B . ?\x5AF3) ;; <CJK>
     (?$(1I](B . ?\x5AE2) ;; <CJK>
     (?$(1I^(B . ?\x5AE0) ;; <CJK>
     (?$(1I_(B . ?\x5ADB) ;; <CJK>
     (?$(1I`(B . ?\x5AEC) ;; <CJK>
     (?$(1Ia(B . ?\x5ADE) ;; <CJK>
     (?$(1Ib(B . ?\x5ADD) ;; <CJK>
     (?$(1Ic(B . ?\x5AD9) ;; <CJK>
     (?$(1Id(B . ?\x5AE8) ;; <CJK>
     (?$(1Ie(B . ?\x5ADF) ;; <CJK>
     (?$(1If(B . ?\x5B77) ;; <CJK>
     (?$(1Ig(B . ?\x5BE0) ;; <CJK>
     (?$(1Ih(B . ?\x5BE3) ;; <CJK>
     (?$(1Ii(B . ?\x5C63) ;; <CJK>
     (?$(1Ij(B . ?\x5D82) ;; <CJK>
     (?$(1Ik(B . ?\x5D80) ;; <CJK>
     (?$(1Il(B . ?\x5D7D) ;; <CJK>
     (?$(1Im(B . ?\x5D86) ;; <CJK>
     (?$(1In(B . ?\x5D7A) ;; <CJK>
     (?$(1Io(B . ?\x5D81) ;; <CJK>
     (?$(1Ip(B . ?\x5D77) ;; <CJK>
     (?$(1Iq(B . ?\x5D8A) ;; <CJK>
     (?$(1Ir(B . ?\x5D89) ;; <CJK>
     (?$(1Is(B . ?\x5D88) ;; <CJK>
     (?$(1It(B . ?\x5D7E) ;; <CJK>
     (?$(1Iu(B . ?\x5D7C) ;; <CJK>
     (?$(1Iv(B . ?\x5D8D) ;; <CJK>
     (?$(1Iw(B . ?\x5D79) ;; <CJK>
     (?$(1Ix(B . ?\x5D7F) ;; <CJK>
     (?$(1Iy(B . ?\x5E58) ;; <CJK>
     (?$(1Iz(B . ?\x5E59) ;; <CJK>
     (?$(1I{(B . ?\x5E53) ;; <CJK>
     (?$(1I|(B . ?\x5ED8) ;; <CJK>
     (?$(1I}(B . ?\x5ED1) ;; <CJK>
     (?$(1I~(B . ?\x5ED7) ;; <CJK>
     (?$(1J!(B . ?\x5ECE) ;; <CJK>
     (?$(1J"(B . ?\x5EDC) ;; <CJK>
     (?$(1J#(B . ?\x5ED5) ;; <CJK>
     (?$(1J$(B . ?\x5ED9) ;; <CJK>
     (?$(1J%(B . ?\x5ED2) ;; <CJK>
     (?$(1J&(B . ?\x5ED4) ;; <CJK>
     (?$(1J'(B . ?\x5F44) ;; <CJK>
     (?$(1J((B . ?\x5F43) ;; <CJK>
     (?$(1J)(B . ?\x5F6F) ;; <CJK>
     (?$(1J*(B . ?\x5FB6) ;; <CJK>
     (?$(1J+(B . ?\x612C) ;; <CJK>
     (?$(1J,(B . ?\x6128) ;; <CJK>
     (?$(1J-(B . ?\x6141) ;; <CJK>
     (?$(1J.(B . ?\x615E) ;; <CJK>
     (?$(1J/(B . ?\x6171) ;; <CJK>
     (?$(1J0(B . ?\x6173) ;; <CJK>
     (?$(1J1(B . ?\x6152) ;; <CJK>
     (?$(1J2(B . ?\x6153) ;; <CJK>
     (?$(1J3(B . ?\x6172) ;; <CJK>
     (?$(1J4(B . ?\x616C) ;; <CJK>
     (?$(1J5(B . ?\x6180) ;; <CJK>
     (?$(1J6(B . ?\x6174) ;; <CJK>
     (?$(1J7(B . ?\x6154) ;; <CJK>
     (?$(1J8(B . ?\x617A) ;; <CJK>
     (?$(1J9(B . ?\x615B) ;; <CJK>
     (?$(1J:(B . ?\x6165) ;; <CJK>
     (?$(1J;(B . ?\x613B) ;; <CJK>
     (?$(1J<(B . ?\x616A) ;; <CJK>
     (?$(1J=(B . ?\x6161) ;; <CJK>
     (?$(1J>(B . ?\x6156) ;; <CJK>
     (?$(1J?(B . ?\x6229) ;; <CJK>
     (?$(1J@(B . ?\x6227) ;; <CJK>
     (?$(1JA(B . ?\x622B) ;; <CJK>
     (?$(1JB(B . ?\x642B) ;; <CJK>
     (?$(1JC(B . ?\x644D) ;; <CJK>
     (?$(1JD(B . ?\x645B) ;; <CJK>
     (?$(1JE(B . ?\x645D) ;; <CJK>
     (?$(1JF(B . ?\x6474) ;; <CJK>
     (?$(1JG(B . ?\x6476) ;; <CJK>
     (?$(1JH(B . ?\x6472) ;; <CJK>
     (?$(1JI(B . ?\x6473) ;; <CJK>
     (?$(1JJ(B . ?\x647D) ;; <CJK>
     (?$(1JK(B . ?\x6475) ;; <CJK>
     (?$(1JL(B . ?\x6466) ;; <CJK>
     (?$(1JM(B . ?\x64A6) ;; <CJK>
     (?$(1JN(B . ?\x644E) ;; <CJK>
     (?$(1JO(B . ?\x6482) ;; <CJK>
     (?$(1JP(B . ?\x645E) ;; <CJK>
     (?$(1JQ(B . ?\x645C) ;; <CJK>
     (?$(1JR(B . ?\x644B) ;; <CJK>
     (?$(1JS(B . ?\x6453) ;; <CJK>
     (?$(1JT(B . ?\x6460) ;; <CJK>
     (?$(1JU(B . ?\x6450) ;; <CJK>
     (?$(1JV(B . ?\x647F) ;; <CJK>
     (?$(1JW(B . ?\x643F) ;; <CJK>
     (?$(1JX(B . ?\x646C) ;; <CJK>
     (?$(1JY(B . ?\x646B) ;; <CJK>
     (?$(1JZ(B . ?\x6459) ;; <CJK>
     (?$(1J[(B . ?\x6465) ;; <CJK>
     (?$(1J\(B . ?\x6477) ;; <CJK>
     (?$(1J](B . ?\x6573) ;; <CJK>
     (?$(1J^(B . ?\x65A0) ;; <CJK>
     (?$(1J_(B . ?\x66A1) ;; <CJK>
     (?$(1J`(B . ?\x66A0) ;; <CJK>
     (?$(1Ja(B . ?\x669F) ;; <CJK>
     (?$(1Jb(B . ?\x6705) ;; <CJK>
     (?$(1Jc(B . ?\x6704) ;; <CJK>
     (?$(1Jd(B . ?\x6722) ;; <CJK>
     (?$(1Je(B . ?\x69B1) ;; <CJK>
     (?$(1Jf(B . ?\x69B6) ;; <CJK>
     (?$(1Jg(B . ?\x69C9) ;; <CJK>
     (?$(1Jh(B . ?\x69A0) ;; <CJK>
     (?$(1Ji(B . ?\x69CE) ;; <CJK>
     (?$(1Jj(B . ?\x6996) ;; <CJK>
     (?$(1Jk(B . ?\x69B0) ;; <CJK>
     (?$(1Jl(B . ?\x69AC) ;; <CJK>
     (?$(1Jm(B . ?\x69BC) ;; <CJK>
     (?$(1Jn(B . ?\x6991) ;; <CJK>
     (?$(1Jo(B . ?\x6999) ;; <CJK>
     (?$(1Jp(B . ?\x698E) ;; <CJK>
     (?$(1Jq(B . ?\x69A7) ;; <CJK>
     (?$(1Jr(B . ?\x698D) ;; <CJK>
     (?$(1Js(B . ?\x69A9) ;; <CJK>
     (?$(1Jt(B . ?\x69BE) ;; <CJK>
     (?$(1Ju(B . ?\x69AF) ;; <CJK>
     (?$(1Jv(B . ?\x69BF) ;; <CJK>
     (?$(1Jw(B . ?\x69C4) ;; <CJK>
     (?$(1Jx(B . ?\x69BD) ;; <CJK>
     (?$(1Jy(B . ?\x69A4) ;; <CJK>
     (?$(1Jz(B . ?\x69D4) ;; <CJK>
     (?$(1J{(B . ?\x69B9) ;; <CJK>
     (?$(1J|(B . ?\x69CA) ;; <CJK>
     (?$(1J}(B . ?\x699A) ;; <CJK>
     (?$(1J~(B . ?\x69CF) ;; <CJK>
     (?$(1K!(B . ?\x69B3) ;; <CJK>
     (?$(1K"(B . ?\x6993) ;; <CJK>
     (?$(1K#(B . ?\x69AA) ;; <CJK>
     (?$(1K$(B . ?\x69A1) ;; <CJK>
     (?$(1K%(B . ?\x699E) ;; <CJK>
     (?$(1K&(B . ?\x69D9) ;; <CJK>
     (?$(1K'(B . ?\x6997) ;; <CJK>
     (?$(1K((B . ?\x6990) ;; <CJK>
     (?$(1K)(B . ?\x69C2) ;; <CJK>
     (?$(1K*(B . ?\x69B5) ;; <CJK>
     (?$(1K+(B . ?\x69A5) ;; <CJK>
     (?$(1K,(B . ?\x69C6) ;; <CJK>
     (?$(1K-(B . ?\x6B4A) ;; <CJK>
     (?$(1K.(B . ?\x6B4D) ;; <CJK>
     (?$(1K/(B . ?\x6B4B) ;; <CJK>
     (?$(1K0(B . ?\x6B9E) ;; <CJK>
     (?$(1K1(B . ?\x6B9F) ;; <CJK>
     (?$(1K2(B . ?\x6BA0) ;; <CJK>
     (?$(1K3(B . ?\x6BC3) ;; <CJK>
     (?$(1K4(B . ?\x6BC4) ;; <CJK>
     (?$(1K5(B . ?\x6BFE) ;; <CJK>
     (?$(1K6(B . ?\x6ECE) ;; <CJK>
     (?$(1K7(B . ?\x6EF5) ;; <CJK>
     (?$(1K8(B . ?\x6EF1) ;; <CJK>
     (?$(1K9(B . ?\x6F03) ;; <CJK>
     (?$(1K:(B . ?\x6F25) ;; <CJK>
     (?$(1K;(B . ?\x6EF8) ;; <CJK>
     (?$(1K<(B . ?\x6F37) ;; <CJK>
     (?$(1K=(B . ?\x6EFB) ;; <CJK>
     (?$(1K>(B . ?\x6F2E) ;; <CJK>
     (?$(1K?(B . ?\x6F09) ;; <CJK>
     (?$(1K@(B . ?\x6F4E) ;; <CJK>
     (?$(1KA(B . ?\x6F19) ;; <CJK>
     (?$(1KB(B . ?\x6F1A) ;; <CJK>
     (?$(1KC(B . ?\x6F27) ;; <CJK>
     (?$(1KD(B . ?\x6F18) ;; <CJK>
     (?$(1KE(B . ?\x6F3B) ;; <CJK>
     (?$(1KF(B . ?\x6F12) ;; <CJK>
     (?$(1KG(B . ?\x6EED) ;; <CJK>
     (?$(1KH(B . ?\x6F0A) ;; <CJK>
     (?$(1KI(B . ?\x6F36) ;; <CJK>
     (?$(1KJ(B . ?\x6F73) ;; <CJK>
     (?$(1KK(B . ?\x6EF9) ;; <CJK>
     (?$(1KL(B . ?\x6EEE) ;; <CJK>
     (?$(1KM(B . ?\x6F2D) ;; <CJK>
     (?$(1KN(B . ?\x6F40) ;; <CJK>
     (?$(1KO(B . ?\x6F30) ;; <CJK>
     (?$(1KP(B . ?\x6F3C) ;; <CJK>
     (?$(1KQ(B . ?\x6F35) ;; <CJK>
     (?$(1KR(B . ?\x6EEB) ;; <CJK>
     (?$(1KS(B . ?\x6F07) ;; <CJK>
     (?$(1KT(B . ?\x6F0E) ;; <CJK>
     (?$(1KU(B . ?\x6F43) ;; <CJK>
     (?$(1KV(B . ?\x6F05) ;; <CJK>
     (?$(1KW(B . ?\x6EFD) ;; <CJK>
     (?$(1KX(B . ?\x6EF6) ;; <CJK>
     (?$(1KY(B . ?\x6F39) ;; <CJK>
     (?$(1KZ(B . ?\x6F1C) ;; <CJK>
     (?$(1K[(B . ?\x6EFC) ;; <CJK>
     (?$(1K\(B . ?\x6F3A) ;; <CJK>
     (?$(1K](B . ?\x6F1F) ;; <CJK>
     (?$(1K^(B . ?\x6F0D) ;; <CJK>
     (?$(1K_(B . ?\x6F1E) ;; <CJK>
     (?$(1K`(B . ?\x6F08) ;; <CJK>
     (?$(1Ka(B . ?\x6F21) ;; <CJK>
     (?$(1Kb(B . ?\x7187) ;; <CJK>
     (?$(1Kc(B . ?\x7190) ;; <CJK>
     (?$(1Kd(B . ?\x7189) ;; <CJK>
     (?$(1Ke(B . ?\x7180) ;; <CJK>
     (?$(1Kf(B . ?\x7185) ;; <CJK>
     (?$(1Kg(B . ?\x7182) ;; <CJK>
     (?$(1Kh(B . ?\x718F) ;; <CJK>
     (?$(1Ki(B . ?\x717B) ;; <CJK>
     (?$(1Kj(B . ?\x7186) ;; <CJK>
     (?$(1Kk(B . ?\x7181) ;; <CJK>
     (?$(1Kl(B . ?\x7197) ;; <CJK>
     (?$(1Km(B . ?\x7244) ;; <CJK>
     (?$(1Kn(B . ?\x7253) ;; <CJK>
     (?$(1Ko(B . ?\x7297) ;; <CJK>
     (?$(1Kp(B . ?\x7295) ;; <CJK>
     (?$(1Kq(B . ?\x7293) ;; <CJK>
     (?$(1Kr(B . ?\x7343) ;; <CJK>
     (?$(1Ks(B . ?\x734D) ;; <CJK>
     (?$(1Kt(B . ?\x7351) ;; <CJK>
     (?$(1Ku(B . ?\x734C) ;; <CJK>
     (?$(1Kv(B . ?\x7462) ;; <CJK>
     (?$(1Kw(B . ?\x7473) ;; <CJK>
     (?$(1Kx(B . ?\x7471) ;; <CJK>
     (?$(1Ky(B . ?\x7475) ;; <CJK>
     (?$(1Kz(B . ?\x7472) ;; <CJK>
     (?$(1K{(B . ?\x7467) ;; <CJK>
     (?$(1K|(B . ?\x746E) ;; <CJK>
     (?$(1K}(B . ?\x7500) ;; <CJK>
     (?$(1K~(B . ?\x7502) ;; <CJK>
     (?$(1L!(B . ?\x7503) ;; <CJK>
     (?$(1L"(B . ?\x757D) ;; <CJK>
     (?$(1L#(B . ?\x7590) ;; <CJK>
     (?$(1L$(B . ?\x7616) ;; <CJK>
     (?$(1L%(B . ?\x7608) ;; <CJK>
     (?$(1L&(B . ?\x760C) ;; <CJK>
     (?$(1L'(B . ?\x7615) ;; <CJK>
     (?$(1L((B . ?\x7611) ;; <CJK>
     (?$(1L)(B . ?\x760A) ;; <CJK>
     (?$(1L*(B . ?\x7614) ;; <CJK>
     (?$(1L+(B . ?\x76B8) ;; <CJK>
     (?$(1L,(B . ?\x7781) ;; <CJK>
     (?$(1L-(B . ?\x777C) ;; <CJK>
     (?$(1L.(B . ?\x7785) ;; <CJK>
     (?$(1L/(B . ?\x7782) ;; <CJK>
     (?$(1L0(B . ?\x776E) ;; <CJK>
     (?$(1L1(B . ?\x7780) ;; <CJK>
     (?$(1L2(B . ?\x776F) ;; <CJK>
     (?$(1L3(B . ?\x777E) ;; <CJK>
     (?$(1L4(B . ?\x7783) ;; <CJK>
     (?$(1L5(B . ?\x78B2) ;; <CJK>
     (?$(1L6(B . ?\x78AA) ;; <CJK>
     (?$(1L7(B . ?\x78B4) ;; <CJK>
     (?$(1L8(B . ?\x78AD) ;; <CJK>
     (?$(1L9(B . ?\x78A8) ;; <CJK>
     (?$(1L:(B . ?\x787E) ;; <CJK>
     (?$(1L;(B . ?\x78AB) ;; <CJK>
     (?$(1L<(B . ?\x789E) ;; <CJK>
     (?$(1L=(B . ?\x78A5) ;; <CJK>
     (?$(1L>(B . ?\x78A0) ;; <CJK>
     (?$(1L?(B . ?\x78AC) ;; <CJK>
     (?$(1L@(B . ?\x78A2) ;; <CJK>
     (?$(1LA(B . ?\x78A4) ;; <CJK>
     (?$(1LB(B . ?\x7998) ;; <CJK>
     (?$(1LC(B . ?\x798A) ;; <CJK>
     (?$(1LD(B . ?\x798B) ;; <CJK>
     (?$(1LE(B . ?\x7996) ;; <CJK>
     (?$(1LF(B . ?\x7995) ;; <CJK>
     (?$(1LG(B . ?\x7994) ;; <CJK>
     (?$(1LH(B . ?\x7993) ;; <CJK>
     (?$(1LI(B . ?\x7997) ;; <CJK>
     (?$(1LJ(B . ?\x7988) ;; <CJK>
     (?$(1LK(B . ?\x7992) ;; <CJK>
     (?$(1LL(B . ?\x7990) ;; <CJK>
     (?$(1LM(B . ?\x7A2B) ;; <CJK>
     (?$(1LN(B . ?\x7A4A) ;; <CJK>
     (?$(1LO(B . ?\x7A30) ;; <CJK>
     (?$(1LP(B . ?\x7A2F) ;; <CJK>
     (?$(1LQ(B . ?\x7A28) ;; <CJK>
     (?$(1LR(B . ?\x7A26) ;; <CJK>
     (?$(1LS(B . ?\x7AA8) ;; <CJK>
     (?$(1LT(B . ?\x7AAB) ;; <CJK>
     (?$(1LU(B . ?\x7AAC) ;; <CJK>
     (?$(1LV(B . ?\x7AEE) ;; <CJK>
     (?$(1LW(B . ?\x7B88) ;; <CJK>
     (?$(1LX(B . ?\x7B9C) ;; <CJK>
     (?$(1LY(B . ?\x7B8A) ;; <CJK>
     (?$(1LZ(B . ?\x7B91) ;; <CJK>
     (?$(1L[(B . ?\x7B90) ;; <CJK>
     (?$(1L\(B . ?\x7B96) ;; <CJK>
     (?$(1L](B . ?\x7B8D) ;; <CJK>
     (?$(1L^(B . ?\x7B8C) ;; <CJK>
     (?$(1L_(B . ?\x7B9B) ;; <CJK>
     (?$(1L`(B . ?\x7B8E) ;; <CJK>
     (?$(1La(B . ?\x7B85) ;; <CJK>
     (?$(1Lb(B . ?\x7B98) ;; <CJK>
     (?$(1Lc(B . ?\x5284) ;; <CJK>
     (?$(1Ld(B . ?\x7B99) ;; <CJK>
     (?$(1Le(B . ?\x7BA4) ;; <CJK>
     (?$(1Lf(B . ?\x7B82) ;; <CJK>
     (?$(1Lg(B . ?\x7CBB) ;; <CJK>
     (?$(1Lh(B . ?\x7CBF) ;; <CJK>
     (?$(1Li(B . ?\x7CBC) ;; <CJK>
     (?$(1Lj(B . ?\x7CBA) ;; <CJK>
     (?$(1Lk(B . ?\x7DA7) ;; <CJK>
     (?$(1Ll(B . ?\x7DB7) ;; <CJK>
     (?$(1Lm(B . ?\x7DC2) ;; <CJK>
     (?$(1Ln(B . ?\x7DA3) ;; <CJK>
     (?$(1Lo(B . ?\x7DAA) ;; <CJK>
     (?$(1Lp(B . ?\x7DC1) ;; <CJK>
     (?$(1Lq(B . ?\x7DC0) ;; <CJK>
     (?$(1Lr(B . ?\x7DC5) ;; <CJK>
     (?$(1Ls(B . ?\x7D9D) ;; <CJK>
     (?$(1Lt(B . ?\x7DCE) ;; <CJK>
     (?$(1Lu(B . ?\x7DC4) ;; <CJK>
     (?$(1Lv(B . ?\x7DC6) ;; <CJK>
     (?$(1Lw(B . ?\x7DCB) ;; <CJK>
     (?$(1Lx(B . ?\x7DCC) ;; <CJK>
     (?$(1Ly(B . ?\x7DAF) ;; <CJK>
     (?$(1Lz(B . ?\x7DB9) ;; <CJK>
     (?$(1L{(B . ?\x7D96) ;; <CJK>
     (?$(1L|(B . ?\x7DBC) ;; <CJK>
     (?$(1L}(B . ?\x7D9F) ;; <CJK>
     (?$(1L~(B . ?\x7DA6) ;; <CJK>
     (?$(1M!(B . ?\x7DAE) ;; <CJK>
     (?$(1M"(B . ?\x7DA9) ;; <CJK>
     (?$(1M#(B . ?\x7DA1) ;; <CJK>
     (?$(1M$(B . ?\x7DC9) ;; <CJK>
     (?$(1M%(B . ?\x7F73) ;; <CJK>
     (?$(1M&(B . ?\x7FE2) ;; <CJK>
     (?$(1M'(B . ?\x7FE3) ;; <CJK>
     (?$(1M((B . ?\x7FE5) ;; <CJK>
     (?$(1M)(B . ?\x7FDE) ;; <CJK>
     (?$(1M*(B . ?\x8024) ;; <CJK>
     (?$(1M+(B . ?\x805D) ;; <CJK>
     (?$(1M,(B . ?\x805C) ;; <CJK>
     (?$(1M-(B . ?\x8189) ;; <CJK>
     (?$(1M.(B . ?\x8186) ;; <CJK>
     (?$(1M/(B . ?\x8183) ;; <CJK>
     (?$(1M0(B . ?\x8187) ;; <CJK>
     (?$(1M1(B . ?\x818D) ;; <CJK>
     (?$(1M2(B . ?\x818C) ;; <CJK>
     (?$(1M3(B . ?\x818B) ;; <CJK>
     (?$(1M4(B . ?\x8215) ;; <CJK>
     (?$(1M5(B . ?\x8497) ;; <CJK>
     (?$(1M6(B . ?\x84A4) ;; <CJK>
     (?$(1M7(B . ?\x84A1) ;; <CJK>
     (?$(1M8(B . ?\x849F) ;; <CJK>
     (?$(1M9(B . ?\x84BA) ;; <CJK>
     (?$(1M:(B . ?\x84CE) ;; <CJK>
     (?$(1M;(B . ?\x84C2) ;; <CJK>
     (?$(1M<(B . ?\x84AC) ;; <CJK>
     (?$(1M=(B . ?\x84AE) ;; <CJK>
     (?$(1M>(B . ?\x84AB) ;; <CJK>
     (?$(1M?(B . ?\x84B9) ;; <CJK>
     (?$(1M@(B . ?\x84B4) ;; <CJK>
     (?$(1MA(B . ?\x84C1) ;; <CJK>
     (?$(1MB(B . ?\x84CD) ;; <CJK>
     (?$(1MC(B . ?\x84AA) ;; <CJK>
     (?$(1MD(B . ?\x849A) ;; <CJK>
     (?$(1ME(B . ?\x84B1) ;; <CJK>
     (?$(1MF(B . ?\x84D0) ;; <CJK>
     (?$(1MG(B . ?\x849D) ;; <CJK>
     (?$(1MH(B . ?\x84A7) ;; <CJK>
     (?$(1MI(B . ?\x84BB) ;; <CJK>
     (?$(1MJ(B . ?\x84A2) ;; <CJK>
     (?$(1MK(B . ?\x8494) ;; <CJK>
     (?$(1ML(B . ?\x84C7) ;; <CJK>
     (?$(1MM(B . ?\x84CC) ;; <CJK>
     (?$(1MN(B . ?\x849B) ;; <CJK>
     (?$(1MO(B . ?\x84A9) ;; <CJK>
     (?$(1MP(B . ?\x84AF) ;; <CJK>
     (?$(1MQ(B . ?\x84A8) ;; <CJK>
     (?$(1MR(B . ?\x84D6) ;; <CJK>
     (?$(1MS(B . ?\x8498) ;; <CJK>
     (?$(1MT(B . ?\x84B6) ;; <CJK>
     (?$(1MU(B . ?\x84CF) ;; <CJK>
     (?$(1MV(B . ?\x84A0) ;; <CJK>
     (?$(1MW(B . ?\x84D7) ;; <CJK>
     (?$(1MX(B . ?\x84D4) ;; <CJK>
     (?$(1MY(B . ?\x84D2) ;; <CJK>
     (?$(1MZ(B . ?\x84DB) ;; <CJK>
     (?$(1M[(B . ?\x84B0) ;; <CJK>
     (?$(1M\(B . ?\x8491) ;; <CJK>
     (?$(1M](B . ?\x8661) ;; <CJK>
     (?$(1M^(B . ?\x8733) ;; <CJK>
     (?$(1M_(B . ?\x8723) ;; <CJK>
     (?$(1M`(B . ?\x8728) ;; <CJK>
     (?$(1Ma(B . ?\x876B) ;; <CJK>
     (?$(1Mb(B . ?\x8740) ;; <CJK>
     (?$(1Mc(B . ?\x872E) ;; <CJK>
     (?$(1Md(B . ?\x871E) ;; <CJK>
     (?$(1Me(B . ?\x8721) ;; <CJK>
     (?$(1Mf(B . ?\x8719) ;; <CJK>
     (?$(1Mg(B . ?\x871B) ;; <CJK>
     (?$(1Mh(B . ?\x8743) ;; <CJK>
     (?$(1Mi(B . ?\x872C) ;; <CJK>
     (?$(1Mj(B . ?\x8741) ;; <CJK>
     (?$(1Mk(B . ?\x873E) ;; <CJK>
     (?$(1Ml(B . ?\x8746) ;; <CJK>
     (?$(1Mm(B . ?\x8720) ;; <CJK>
     (?$(1Mn(B . ?\x8732) ;; <CJK>
     (?$(1Mo(B . ?\x872A) ;; <CJK>
     (?$(1Mp(B . ?\x872D) ;; <CJK>
     (?$(1Mq(B . ?\x873C) ;; <CJK>
     (?$(1Mr(B . ?\x8712) ;; <CJK>
     (?$(1Ms(B . ?\x873A) ;; <CJK>
     (?$(1Mt(B . ?\x8731) ;; <CJK>
     (?$(1Mu(B . ?\x8735) ;; <CJK>
     (?$(1Mv(B . ?\x8742) ;; <CJK>
     (?$(1Mw(B . ?\x8726) ;; <CJK>
     (?$(1Mx(B . ?\x8727) ;; <CJK>
     (?$(1My(B . ?\x8738) ;; <CJK>
     (?$(1Mz(B . ?\x8724) ;; <CJK>
     (?$(1M{(B . ?\x871A) ;; <CJK>
     (?$(1M|(B . ?\x8730) ;; <CJK>
     (?$(1M}(B . ?\x8711) ;; <CJK>
     (?$(1M~(B . ?\x88F7) ;; <CJK>
     (?$(1N!(B . ?\x88E7) ;; <CJK>
     (?$(1N"(B . ?\x88F1) ;; <CJK>
     (?$(1N#(B . ?\x88F2) ;; <CJK>
     (?$(1N$(B . ?\x88FA) ;; <CJK>
     (?$(1N%(B . ?\x88FE) ;; <CJK>
     (?$(1N&(B . ?\x88EE) ;; <CJK>
     (?$(1N'(B . ?\x88FC) ;; <CJK>
     (?$(1N((B . ?\x88F6) ;; <CJK>
     (?$(1N)(B . ?\x88FB) ;; <CJK>
     (?$(1N*(B . ?\x88F0) ;; <CJK>
     (?$(1N+(B . ?\x88EC) ;; <CJK>
     (?$(1N,(B . ?\x88EB) ;; <CJK>
     (?$(1N-(B . ?\x899D) ;; <CJK>
     (?$(1N.(B . ?\x89A1) ;; <CJK>
     (?$(1N/(B . ?\x899F) ;; <CJK>
     (?$(1N0(B . ?\x899E) ;; <CJK>
     (?$(1N1(B . ?\x89E9) ;; <CJK>
     (?$(1N2(B . ?\x89EB) ;; <CJK>
     (?$(1N3(B . ?\x89E8) ;; <CJK>
     (?$(1N4(B . ?\x8AAB) ;; <CJK>
     (?$(1N5(B . ?\x8A99) ;; <CJK>
     (?$(1N6(B . ?\x8A8B) ;; <CJK>
     (?$(1N7(B . ?\x8A92) ;; <CJK>
     (?$(1N8(B . ?\x8A8F) ;; <CJK>
     (?$(1N9(B . ?\x8A96) ;; <CJK>
     (?$(1N:(B . ?\x8C3D) ;; <CJK>
     (?$(1N;(B . ?\x8C68) ;; <CJK>
     (?$(1N<(B . ?\x8C69) ;; <CJK>
     (?$(1N=(B . ?\x8CD5) ;; <CJK>
     (?$(1N>(B . ?\x8CCF) ;; <CJK>
     (?$(1N?(B . ?\x8CD7) ;; <CJK>
     (?$(1N@(B . ?\x8D96) ;; <CJK>
     (?$(1NA(B . ?\x8E09) ;; <CJK>
     (?$(1NB(B . ?\x8E02) ;; <CJK>
     (?$(1NC(B . ?\x8DFF) ;; <CJK>
     (?$(1ND(B . ?\x8E0D) ;; <CJK>
     (?$(1NE(B . ?\x8DFD) ;; <CJK>
     (?$(1NF(B . ?\x8E0A) ;; <CJK>
     (?$(1NG(B . ?\x8E03) ;; <CJK>
     (?$(1NH(B . ?\x8E07) ;; <CJK>
     (?$(1NI(B . ?\x8E06) ;; <CJK>
     (?$(1NJ(B . ?\x8E05) ;; <CJK>
     (?$(1NK(B . ?\x8DFE) ;; <CJK>
     (?$(1NL(B . ?\x8E00) ;; <CJK>
     (?$(1NM(B . ?\x8E04) ;; <CJK>
     (?$(1NN(B . ?\x8F10) ;; <CJK>
     (?$(1NO(B . ?\x8F11) ;; <CJK>
     (?$(1NP(B . ?\x8F0E) ;; <CJK>
     (?$(1NQ(B . ?\x8F0D) ;; <CJK>
     (?$(1NR(B . ?\x9123) ;; <CJK>
     (?$(1NS(B . ?\x911C) ;; <CJK>
     (?$(1NT(B . ?\x9120) ;; <CJK>
     (?$(1NU(B . ?\x9122) ;; <CJK>
     (?$(1NV(B . ?\x911F) ;; <CJK>
     (?$(1NW(B . ?\x911D) ;; <CJK>
     (?$(1NX(B . ?\x911A) ;; <CJK>
     (?$(1NY(B . ?\x9124) ;; <CJK>
     (?$(1NZ(B . ?\x9121) ;; <CJK>
     (?$(1N[(B . ?\x911B) ;; <CJK>
     (?$(1N\(B . ?\x917A) ;; <CJK>
     (?$(1N](B . ?\x9172) ;; <CJK>
     (?$(1N^(B . ?\x9179) ;; <CJK>
     (?$(1N_(B . ?\x9173) ;; <CJK>
     (?$(1N`(B . ?\x92A5) ;; <CJK>
     (?$(1Na(B . ?\x92A4) ;; <CJK>
     (?$(1Nb(B . ?\x9276) ;; <CJK>
     (?$(1Nc(B . ?\x929B) ;; <CJK>
     (?$(1Nd(B . ?\x927A) ;; <CJK>
     (?$(1Ne(B . ?\x92A0) ;; <CJK>
     (?$(1Nf(B . ?\x9294) ;; <CJK>
     (?$(1Ng(B . ?\x92AA) ;; <CJK>
     (?$(1Nh(B . ?\x928D) ;; <CJK>
     (?$(1Ni(B . ?\x92A6) ;; <CJK>
     (?$(1Nj(B . ?\x929A) ;; <CJK>
     (?$(1Nk(B . ?\x92AB) ;; <CJK>
     (?$(1Nl(B . ?\x9279) ;; <CJK>
     (?$(1Nm(B . ?\x9297) ;; <CJK>
     (?$(1Nn(B . ?\x927F) ;; <CJK>
     (?$(1No(B . ?\x92A3) ;; <CJK>
     (?$(1Np(B . ?\x92EE) ;; <CJK>
     (?$(1Nq(B . ?\x928E) ;; <CJK>
     (?$(1Nr(B . ?\x9282) ;; <CJK>
     (?$(1Ns(B . ?\x9295) ;; <CJK>
     (?$(1Nt(B . ?\x92A2) ;; <CJK>
     (?$(1Nu(B . ?\x927D) ;; <CJK>
     (?$(1Nv(B . ?\x9288) ;; <CJK>
     (?$(1Nw(B . ?\x92A1) ;; <CJK>
     (?$(1Nx(B . ?\x928A) ;; <CJK>
     (?$(1Ny(B . ?\x9286) ;; <CJK>
     (?$(1Nz(B . ?\x928C) ;; <CJK>
     (?$(1N{(B . ?\x9299) ;; <CJK>
     (?$(1N|(B . ?\x92A7) ;; <CJK>
     (?$(1N}(B . ?\x927E) ;; <CJK>
     (?$(1N~(B . ?\x9287) ;; <CJK>
     (?$(1O!(B . ?\x92A9) ;; <CJK>
     (?$(1O"(B . ?\x929D) ;; <CJK>
     (?$(1O#(B . ?\x928B) ;; <CJK>
     (?$(1O$(B . ?\x922D) ;; <CJK>
     (?$(1O%(B . ?\x969E) ;; <CJK>
     (?$(1O&(B . ?\x96A1) ;; <CJK>
     (?$(1O'(B . ?\x96FF) ;; <CJK>
     (?$(1O((B . ?\x9758) ;; <CJK>
     (?$(1O)(B . ?\x977D) ;; <CJK>
     (?$(1O*(B . ?\x977A) ;; <CJK>
     (?$(1O+(B . ?\x977E) ;; <CJK>
     (?$(1O,(B . ?\x9783) ;; <CJK>
     (?$(1O-(B . ?\x9780) ;; <CJK>
     (?$(1O.(B . ?\x9782) ;; <CJK>
     (?$(1O/(B . ?\x977B) ;; <CJK>
     (?$(1O0(B . ?\x9784) ;; <CJK>
     (?$(1O1(B . ?\x9781) ;; <CJK>
     (?$(1O2(B . ?\x977F) ;; <CJK>
     (?$(1O3(B . ?\x97CE) ;; <CJK>
     (?$(1O4(B . ?\x97CD) ;; <CJK>
     (?$(1O5(B . ?\x9816) ;; <CJK>
     (?$(1O6(B . ?\x98AD) ;; <CJK>
     (?$(1O7(B . ?\x98AE) ;; <CJK>
     (?$(1O8(B . ?\x9902) ;; <CJK>
     (?$(1O9(B . ?\x9900) ;; <CJK>
     (?$(1O:(B . ?\x9907) ;; <CJK>
     (?$(1O;(B . ?\x999D) ;; <CJK>
     (?$(1O<(B . ?\x999C) ;; <CJK>
     (?$(1O=(B . ?\x99C3) ;; <CJK>
     (?$(1O>(B . ?\x99B9) ;; <CJK>
     (?$(1O?(B . ?\x99BB) ;; <CJK>
     (?$(1O@(B . ?\x99BA) ;; <CJK>
     (?$(1OA(B . ?\x99C2) ;; <CJK>
     (?$(1OB(B . ?\x99BD) ;; <CJK>
     (?$(1OC(B . ?\x99C7) ;; <CJK>
     (?$(1OD(B . ?\x9AB1) ;; <CJK>
     (?$(1OE(B . ?\x9AE3) ;; <CJK>
     (?$(1OF(B . ?\x9AE7) ;; <CJK>
     (?$(1OG(B . ?\x9B3E) ;; <CJK>
     (?$(1OH(B . ?\x9B3F) ;; <CJK>
     (?$(1OI(B . ?\x9B60) ;; <CJK>
     (?$(1OJ(B . ?\x9B61) ;; <CJK>
     (?$(1OK(B . ?\x9B5F) ;; <CJK>
     (?$(1OL(B . ?\x9CF1) ;; <CJK>
     (?$(1OM(B . ?\x9CF2) ;; <CJK>
     (?$(1ON(B . ?\x9CF5) ;; <CJK>
     (?$(1OO(B . ?\x9EA7) ;; <CJK>
     (?$(1OP(B . ?\x50FF) ;; <CJK>
     (?$(1OQ(B . ?\x5103) ;; <CJK>
     (?$(1OR(B . ?\x5130) ;; <CJK>
     (?$(1OS(B . ?\x50F8) ;; <CJK>
     (?$(1OT(B . ?\x5106) ;; <CJK>
     (?$(1OU(B . ?\x5107) ;; <CJK>
     (?$(1OV(B . ?\x50F6) ;; <CJK>
     (?$(1OW(B . ?\x50FE) ;; <CJK>
     (?$(1OX(B . ?\x510B) ;; <CJK>
     (?$(1OY(B . ?\x510C) ;; <CJK>
     (?$(1OZ(B . ?\x50FD) ;; <CJK>
     (?$(1O[(B . ?\x510A) ;; <CJK>
     (?$(1O\(B . ?\x528B) ;; <CJK>
     (?$(1O](B . ?\x528C) ;; <CJK>
     (?$(1O^(B . ?\x52F1) ;; <CJK>
     (?$(1O_(B . ?\x52EF) ;; <CJK>
     (?$(1O`(B . ?\x5648) ;; <CJK>
     (?$(1Oa(B . ?\x5642) ;; <CJK>
     (?$(1Ob(B . ?\x564C) ;; <CJK>
     (?$(1Oc(B . ?\x5635) ;; <CJK>
     (?$(1Od(B . ?\x5641) ;; <CJK>
     (?$(1Oe(B . ?\x564A) ;; <CJK>
     (?$(1Of(B . ?\x5649) ;; <CJK>
     (?$(1Og(B . ?\x5646) ;; <CJK>
     (?$(1Oh(B . ?\x5658) ;; <CJK>
     (?$(1Oi(B . ?\x565A) ;; <CJK>
     (?$(1Oj(B . ?\x5640) ;; <CJK>
     (?$(1Ok(B . ?\x5633) ;; <CJK>
     (?$(1Ol(B . ?\x563D) ;; <CJK>
     (?$(1Om(B . ?\x562C) ;; <CJK>
     (?$(1On(B . ?\x563E) ;; <CJK>
     (?$(1Oo(B . ?\x5638) ;; <CJK>
     (?$(1Op(B . ?\x562A) ;; <CJK>
     (?$(1Oq(B . ?\x563A) ;; <CJK>
     (?$(1Or(B . ?\x571A) ;; <CJK>
     (?$(1Os(B . ?\x58AB) ;; <CJK>
     (?$(1Ot(B . ?\x589D) ;; <CJK>
     (?$(1Ou(B . ?\x58B1) ;; <CJK>
     (?$(1Ov(B . ?\x58A0) ;; <CJK>
     (?$(1Ow(B . ?\x58A3) ;; <CJK>
     (?$(1Ox(B . ?\x58AF) ;; <CJK>
     (?$(1Oy(B . ?\x58AC) ;; <CJK>
     (?$(1Oz(B . ?\x58A5) ;; <CJK>
     (?$(1O{(B . ?\x58A1) ;; <CJK>
     (?$(1O|(B . ?\x58FF) ;; <CJK>
     (?$(1O}(B . ?\x5AFF) ;; <CJK>
     (?$(1O~(B . ?\x5AF4) ;; <CJK>
     (?$(1P!(B . ?\x5AFD) ;; <CJK>
     (?$(1P"(B . ?\x5AF7) ;; <CJK>
     (?$(1P#(B . ?\x5AF6) ;; <CJK>
     (?$(1P$(B . ?\x5B03) ;; <CJK>
     (?$(1P%(B . ?\x5AF8) ;; <CJK>
     (?$(1P&(B . ?\x5B02) ;; <CJK>
     (?$(1P'(B . ?\x5AF9) ;; <CJK>
     (?$(1P((B . ?\x5B01) ;; <CJK>
     (?$(1P)(B . ?\x5B07) ;; <CJK>
     (?$(1P*(B . ?\x5B05) ;; <CJK>
     (?$(1P+(B . ?\x5B0F) ;; <CJK>
     (?$(1P,(B . ?\x5C67) ;; <CJK>
     (?$(1P-(B . ?\x5D99) ;; <CJK>
     (?$(1P.(B . ?\x5D97) ;; <CJK>
     (?$(1P/(B . ?\x5D9F) ;; <CJK>
     (?$(1P0(B . ?\x5D92) ;; <CJK>
     (?$(1P1(B . ?\x5DA2) ;; <CJK>
     (?$(1P2(B . ?\x5D93) ;; <CJK>
     (?$(1P3(B . ?\x5D95) ;; <CJK>
     (?$(1P4(B . ?\x5DA0) ;; <CJK>
     (?$(1P5(B . ?\x5D9C) ;; <CJK>
     (?$(1P6(B . ?\x5DA1) ;; <CJK>
     (?$(1P7(B . ?\x5D9A) ;; <CJK>
     (?$(1P8(B . ?\x5D9E) ;; <CJK>
     (?$(1P9(B . ?\x5E69) ;; <CJK>
     (?$(1P:(B . ?\x5E5D) ;; <CJK>
     (?$(1P;(B . ?\x5E60) ;; <CJK>
     (?$(1P<(B . ?\x5E5C) ;; <CJK>
     (?$(1P=(B . ?\x7DF3) ;; <CJK>
     (?$(1P>(B . ?\x5EDB) ;; <CJK>
     (?$(1P?(B . ?\x5EDE) ;; <CJK>
     (?$(1P@(B . ?\x5EE1) ;; <CJK>
     (?$(1PA(B . ?\x5F49) ;; <CJK>
     (?$(1PB(B . ?\x5FB2) ;; <CJK>
     (?$(1PC(B . ?\x618B) ;; <CJK>
     (?$(1PD(B . ?\x6183) ;; <CJK>
     (?$(1PE(B . ?\x6179) ;; <CJK>
     (?$(1PF(B . ?\x61B1) ;; <CJK>
     (?$(1PG(B . ?\x61B0) ;; <CJK>
     (?$(1PH(B . ?\x61A2) ;; <CJK>
     (?$(1PI(B . ?\x6189) ;; <CJK>
     (?$(1PJ(B . ?\x619B) ;; <CJK>
     (?$(1PK(B . ?\x6193) ;; <CJK>
     (?$(1PL(B . ?\x61AF) ;; <CJK>
     (?$(1PM(B . ?\x61AD) ;; <CJK>
     (?$(1PN(B . ?\x619F) ;; <CJK>
     (?$(1PO(B . ?\x6192) ;; <CJK>
     (?$(1PP(B . ?\x61AA) ;; <CJK>
     (?$(1PQ(B . ?\x61A1) ;; <CJK>
     (?$(1PR(B . ?\x618D) ;; <CJK>
     (?$(1PS(B . ?\x6166) ;; <CJK>
     (?$(1PT(B . ?\x61B3) ;; <CJK>
     (?$(1PU(B . ?\x622D) ;; <CJK>
     (?$(1PV(B . ?\x646E) ;; <CJK>
     (?$(1PW(B . ?\x6470) ;; <CJK>
     (?$(1PX(B . ?\x6496) ;; <CJK>
     (?$(1PY(B . ?\x64A0) ;; <CJK>
     (?$(1PZ(B . ?\x6485) ;; <CJK>
     (?$(1P[(B . ?\x6497) ;; <CJK>
     (?$(1P\(B . ?\x649C) ;; <CJK>
     (?$(1P](B . ?\x648F) ;; <CJK>
     (?$(1P^(B . ?\x648B) ;; <CJK>
     (?$(1P_(B . ?\x648A) ;; <CJK>
     (?$(1P`(B . ?\x648C) ;; <CJK>
     (?$(1Pa(B . ?\x64A3) ;; <CJK>
     (?$(1Pb(B . ?\x649F) ;; <CJK>
     (?$(1Pc(B . ?\x6468) ;; <CJK>
     (?$(1Pd(B . ?\x64B1) ;; <CJK>
     (?$(1Pe(B . ?\x6498) ;; <CJK>
     (?$(1Pf(B . ?\x6576) ;; <CJK>
     (?$(1Pg(B . ?\x657A) ;; <CJK>
     (?$(1Ph(B . ?\x6579) ;; <CJK>
     (?$(1Pi(B . ?\x657B) ;; <CJK>
     (?$(1Pj(B . ?\x65B2) ;; <CJK>
     (?$(1Pk(B . ?\x65B3) ;; <CJK>
     (?$(1Pl(B . ?\x66B5) ;; <CJK>
     (?$(1Pm(B . ?\x66B0) ;; <CJK>
     (?$(1Pn(B . ?\x66A9) ;; <CJK>
     (?$(1Po(B . ?\x66B2) ;; <CJK>
     (?$(1Pp(B . ?\x66B7) ;; <CJK>
     (?$(1Pq(B . ?\x66AA) ;; <CJK>
     (?$(1Pr(B . ?\x66AF) ;; <CJK>
     (?$(1Ps(B . ?\x6A00) ;; <CJK>
     (?$(1Pt(B . ?\x6A06) ;; <CJK>
     (?$(1Pu(B . ?\x6A17) ;; <CJK>
     (?$(1Pv(B . ?\x69E5) ;; <CJK>
     (?$(1Pw(B . ?\x69F8) ;; <CJK>
     (?$(1Px(B . ?\x6A15) ;; <CJK>
     (?$(1Py(B . ?\x69F1) ;; <CJK>
     (?$(1Pz(B . ?\x69E4) ;; <CJK>
     (?$(1P{(B . ?\x6A20) ;; <CJK>
     (?$(1P|(B . ?\x69FF) ;; <CJK>
     (?$(1P}(B . ?\x69EC) ;; <CJK>
     (?$(1P~(B . ?\x69E2) ;; <CJK>
     (?$(1Q!(B . ?\x6A1B) ;; <CJK>
     (?$(1Q"(B . ?\x6A1D) ;; <CJK>
     (?$(1Q#(B . ?\x69FE) ;; <CJK>
     (?$(1Q$(B . ?\x6A27) ;; <CJK>
     (?$(1Q%(B . ?\x69F2) ;; <CJK>
     (?$(1Q&(B . ?\x69EE) ;; <CJK>
     (?$(1Q'(B . ?\x6A14) ;; <CJK>
     (?$(1Q((B . ?\x69F7) ;; <CJK>
     (?$(1Q)(B . ?\x69E7) ;; <CJK>
     (?$(1Q*(B . ?\x6A40) ;; <CJK>
     (?$(1Q+(B . ?\x6A08) ;; <CJK>
     (?$(1Q,(B . ?\x69E6) ;; <CJK>
     (?$(1Q-(B . ?\x69FB) ;; <CJK>
     (?$(1Q.(B . ?\x6A0D) ;; <CJK>
     (?$(1Q/(B . ?\x69FC) ;; <CJK>
     (?$(1Q0(B . ?\x69EB) ;; <CJK>
     (?$(1Q1(B . ?\x6A09) ;; <CJK>
     (?$(1Q2(B . ?\x6A04) ;; <CJK>
     (?$(1Q3(B . ?\x6A18) ;; <CJK>
     (?$(1Q4(B . ?\x6A25) ;; <CJK>
     (?$(1Q5(B . ?\x6A0F) ;; <CJK>
     (?$(1Q6(B . ?\x69F6) ;; <CJK>
     (?$(1Q7(B . ?\x6A26) ;; <CJK>
     (?$(1Q8(B . ?\x6A07) ;; <CJK>
     (?$(1Q9(B . ?\x69F4) ;; <CJK>
     (?$(1Q:(B . ?\x6A16) ;; <CJK>
     (?$(1Q;(B . ?\x6B51) ;; <CJK>
     (?$(1Q<(B . ?\x6BA5) ;; <CJK>
     (?$(1Q=(B . ?\x6BA3) ;; <CJK>
     (?$(1Q>(B . ?\x6BA2) ;; <CJK>
     (?$(1Q?(B . ?\x6BA6) ;; <CJK>
     (?$(1Q@(B . ?\x6C01) ;; <CJK>
     (?$(1QA(B . ?\x6C00) ;; <CJK>
     (?$(1QB(B . ?\x6BFF) ;; <CJK>
     (?$(1QC(B . ?\x6C02) ;; <CJK>
     (?$(1QD(B . ?\x6F41) ;; <CJK>
     (?$(1QE(B . ?\x6F26) ;; <CJK>
     (?$(1QF(B . ?\x6F7E) ;; <CJK>
     (?$(1QG(B . ?\x6F87) ;; <CJK>
     (?$(1QH(B . ?\x6FC6) ;; <CJK>
     (?$(1QI(B . ?\x6F92) ;; <CJK>
     (?$(1QJ(B . ?\x6F8D) ;; <CJK>
     (?$(1QK(B . ?\x6F89) ;; <CJK>
     (?$(1QL(B . ?\x6F8C) ;; <CJK>
     (?$(1QM(B . ?\x6F62) ;; <CJK>
     (?$(1QN(B . ?\x6F4F) ;; <CJK>
     (?$(1QO(B . ?\x6F85) ;; <CJK>
     (?$(1QP(B . ?\x6F5A) ;; <CJK>
     (?$(1QQ(B . ?\x6F96) ;; <CJK>
     (?$(1QR(B . ?\x6F76) ;; <CJK>
     (?$(1QS(B . ?\x6F6C) ;; <CJK>
     (?$(1QT(B . ?\x6F82) ;; <CJK>
     (?$(1QU(B . ?\x6F55) ;; <CJK>
     (?$(1QV(B . ?\x6F72) ;; <CJK>
     (?$(1QW(B . ?\x6F52) ;; <CJK>
     (?$(1QX(B . ?\x6F50) ;; <CJK>
     (?$(1QY(B . ?\x6F57) ;; <CJK>
     (?$(1QZ(B . ?\x6F94) ;; <CJK>
     (?$(1Q[(B . ?\x6F93) ;; <CJK>
     (?$(1Q\(B . ?\x6F5D) ;; <CJK>
     (?$(1Q](B . ?\x6F00) ;; <CJK>
     (?$(1Q^(B . ?\x6F61) ;; <CJK>
     (?$(1Q_(B . ?\x6F6B) ;; <CJK>
     (?$(1Q`(B . ?\x6F7D) ;; <CJK>
     (?$(1Qa(B . ?\x6F67) ;; <CJK>
     (?$(1Qb(B . ?\x6F90) ;; <CJK>
     (?$(1Qc(B . ?\x6F53) ;; <CJK>
     (?$(1Qd(B . ?\x6F8B) ;; <CJK>
     (?$(1Qe(B . ?\x6F69) ;; <CJK>
     (?$(1Qf(B . ?\x6F7F) ;; <CJK>
     (?$(1Qg(B . ?\x6F95) ;; <CJK>
     (?$(1Qh(B . ?\x6F63) ;; <CJK>
     (?$(1Qi(B . ?\x6F77) ;; <CJK>
     (?$(1Qj(B . ?\x6F6A) ;; <CJK>
     (?$(1Qk(B . ?\x6F7B) ;; <CJK>
     (?$(1Ql(B . ?\x71B2) ;; <CJK>
     (?$(1Qm(B . ?\x71AF) ;; <CJK>
     (?$(1Qn(B . ?\x719B) ;; <CJK>
     (?$(1Qo(B . ?\x71B0) ;; <CJK>
     (?$(1Qp(B . ?\x71A0) ;; <CJK>
     (?$(1Qq(B . ?\x719A) ;; <CJK>
     (?$(1Qr(B . ?\x71A9) ;; <CJK>
     (?$(1Qs(B . ?\x71B5) ;; <CJK>
     (?$(1Qt(B . ?\x719D) ;; <CJK>
     (?$(1Qu(B . ?\x71A5) ;; <CJK>
     (?$(1Qv(B . ?\x719E) ;; <CJK>
     (?$(1Qw(B . ?\x71A4) ;; <CJK>
     (?$(1Qx(B . ?\x71A1) ;; <CJK>
     (?$(1Qy(B . ?\x71AA) ;; <CJK>
     (?$(1Qz(B . ?\x719C) ;; <CJK>
     (?$(1Q{(B . ?\x71A7) ;; <CJK>
     (?$(1Q|(B . ?\x71B3) ;; <CJK>
     (?$(1Q}(B . ?\x7298) ;; <CJK>
     (?$(1Q~(B . ?\x729A) ;; <CJK>
     (?$(1R!(B . ?\x7358) ;; <CJK>
     (?$(1R"(B . ?\x7352) ;; <CJK>
     (?$(1R#(B . ?\x735E) ;; <CJK>
     (?$(1R$(B . ?\x735F) ;; <CJK>
     (?$(1R%(B . ?\x7360) ;; <CJK>
     (?$(1R&(B . ?\x735D) ;; <CJK>
     (?$(1R'(B . ?\x735B) ;; <CJK>
     (?$(1R((B . ?\x7361) ;; <CJK>
     (?$(1R)(B . ?\x735A) ;; <CJK>
     (?$(1R*(B . ?\x7359) ;; <CJK>
     (?$(1R+(B . ?\x7362) ;; <CJK>
     (?$(1R,(B . ?\x7487) ;; <CJK>
     (?$(1R-(B . ?\x7489) ;; <CJK>
     (?$(1R.(B . ?\x748A) ;; <CJK>
     (?$(1R/(B . ?\x7486) ;; <CJK>
     (?$(1R0(B . ?\x7481) ;; <CJK>
     (?$(1R1(B . ?\x747D) ;; <CJK>
     (?$(1R2(B . ?\x7485) ;; <CJK>
     (?$(1R3(B . ?\x7488) ;; <CJK>
     (?$(1R4(B . ?\x747C) ;; <CJK>
     (?$(1R5(B . ?\x7479) ;; <CJK>
     (?$(1R6(B . ?\x7508) ;; <CJK>
     (?$(1R7(B . ?\x7507) ;; <CJK>
     (?$(1R8(B . ?\x757E) ;; <CJK>
     (?$(1R9(B . ?\x7625) ;; <CJK>
     (?$(1R:(B . ?\x761E) ;; <CJK>
     (?$(1R;(B . ?\x7619) ;; <CJK>
     (?$(1R<(B . ?\x761D) ;; <CJK>
     (?$(1R=(B . ?\x761C) ;; <CJK>
     (?$(1R>(B . ?\x7623) ;; <CJK>
     (?$(1R?(B . ?\x761A) ;; <CJK>
     (?$(1R@(B . ?\x7628) ;; <CJK>
     (?$(1RA(B . ?\x761B) ;; <CJK>
     (?$(1RB(B . ?\x769C) ;; <CJK>
     (?$(1RC(B . ?\x769D) ;; <CJK>
     (?$(1RD(B . ?\x769E) ;; <CJK>
     (?$(1RE(B . ?\x769B) ;; <CJK>
     (?$(1RF(B . ?\x778D) ;; <CJK>
     (?$(1RG(B . ?\x778F) ;; <CJK>
     (?$(1RH(B . ?\x7789) ;; <CJK>
     (?$(1RI(B . ?\x7788) ;; <CJK>
     (?$(1RJ(B . ?\x78CD) ;; <CJK>
     (?$(1RK(B . ?\x78BB) ;; <CJK>
     (?$(1RL(B . ?\x78CF) ;; <CJK>
     (?$(1RM(B . ?\x78CC) ;; <CJK>
     (?$(1RN(B . ?\x78D1) ;; <CJK>
     (?$(1RO(B . ?\x78CE) ;; <CJK>
     (?$(1RP(B . ?\x78D4) ;; <CJK>
     (?$(1RQ(B . ?\x78C8) ;; <CJK>
     (?$(1RR(B . ?\x78C3) ;; <CJK>
     (?$(1RS(B . ?\x78C4) ;; <CJK>
     (?$(1RT(B . ?\x78C9) ;; <CJK>
     (?$(1RU(B . ?\x799A) ;; <CJK>
     (?$(1RV(B . ?\x79A1) ;; <CJK>
     (?$(1RW(B . ?\x79A0) ;; <CJK>
     (?$(1RX(B . ?\x799C) ;; <CJK>
     (?$(1RY(B . ?\x79A2) ;; <CJK>
     (?$(1RZ(B . ?\x799B) ;; <CJK>
     (?$(1R[(B . ?\x6B76) ;; <CJK>
     (?$(1R\(B . ?\x7A39) ;; <CJK>
     (?$(1R](B . ?\x7AB2) ;; <CJK>
     (?$(1R^(B . ?\x7AB4) ;; <CJK>
     (?$(1R_(B . ?\x7AB3) ;; <CJK>
     (?$(1R`(B . ?\x7BB7) ;; <CJK>
     (?$(1Ra(B . ?\x7BCB) ;; <CJK>
     (?$(1Rb(B . ?\x7BBE) ;; <CJK>
     (?$(1Rc(B . ?\x7BAC) ;; <CJK>
     (?$(1Rd(B . ?\x7BCE) ;; <CJK>
     (?$(1Re(B . ?\x7BAF) ;; <CJK>
     (?$(1Rf(B . ?\x7BB9) ;; <CJK>
     (?$(1Rg(B . ?\x7BCA) ;; <CJK>
     (?$(1Rh(B . ?\x7BB5) ;; <CJK>
     (?$(1Ri(B . ?\x7CC5) ;; <CJK>
     (?$(1Rj(B . ?\x7CC8) ;; <CJK>
     (?$(1Rk(B . ?\x7CCC) ;; <CJK>
     (?$(1Rl(B . ?\x7CCB) ;; <CJK>
     (?$(1Rm(B . ?\x7DF7) ;; <CJK>
     (?$(1Rn(B . ?\x7DDB) ;; <CJK>
     (?$(1Ro(B . ?\x7DEA) ;; <CJK>
     (?$(1Rp(B . ?\x7DE7) ;; <CJK>
     (?$(1Rq(B . ?\x7DD7) ;; <CJK>
     (?$(1Rr(B . ?\x7DE1) ;; <CJK>
     (?$(1Rs(B . ?\x7E03) ;; <CJK>
     (?$(1Rt(B . ?\x7DFA) ;; <CJK>
     (?$(1Ru(B . ?\x7DE6) ;; <CJK>
     (?$(1Rv(B . ?\x7DF6) ;; <CJK>
     (?$(1Rw(B . ?\x7DF1) ;; <CJK>
     (?$(1Rx(B . ?\x7DF0) ;; <CJK>
     (?$(1Ry(B . ?\x7DEE) ;; <CJK>
     (?$(1Rz(B . ?\x7DDF) ;; <CJK>
     (?$(1R{(B . ?\x7F76) ;; <CJK>
     (?$(1R|(B . ?\x7FAC) ;; <CJK>
     (?$(1R}(B . ?\x7FB0) ;; <CJK>
     (?$(1R~(B . ?\x7FAD) ;; <CJK>
     (?$(1S!(B . ?\x7FED) ;; <CJK>
     (?$(1S"(B . ?\x7FEB) ;; <CJK>
     (?$(1S#(B . ?\x7FEA) ;; <CJK>
     (?$(1S$(B . ?\x7FEC) ;; <CJK>
     (?$(1S%(B . ?\x7FE6) ;; <CJK>
     (?$(1S&(B . ?\x7FE8) ;; <CJK>
     (?$(1S'(B . ?\x8064) ;; <CJK>
     (?$(1S((B . ?\x8067) ;; <CJK>
     (?$(1S)(B . ?\x81A3) ;; <CJK>
     (?$(1S*(B . ?\x819F) ;; <CJK>
     (?$(1S+(B . ?\x819E) ;; <CJK>
     (?$(1S,(B . ?\x8195) ;; <CJK>
     (?$(1S-(B . ?\x81A2) ;; <CJK>
     (?$(1S.(B . ?\x8199) ;; <CJK>
     (?$(1S/(B . ?\x8197) ;; <CJK>
     (?$(1S0(B . ?\x8216) ;; <CJK>
     (?$(1S1(B . ?\x824F) ;; <CJK>
     (?$(1S2(B . ?\x8253) ;; <CJK>
     (?$(1S3(B . ?\x8252) ;; <CJK>
     (?$(1S4(B . ?\x8250) ;; <CJK>
     (?$(1S5(B . ?\x824E) ;; <CJK>
     (?$(1S6(B . ?\x8251) ;; <CJK>
     (?$(1S7(B . ?\x8524) ;; <CJK>
     (?$(1S8(B . ?\x853B) ;; <CJK>
     (?$(1S9(B . ?\x850F) ;; <CJK>
     (?$(1S:(B . ?\x8500) ;; <CJK>
     (?$(1S;(B . ?\x8529) ;; <CJK>
     (?$(1S<(B . ?\x850E) ;; <CJK>
     (?$(1S=(B . ?\x8509) ;; <CJK>
     (?$(1S>(B . ?\x850D) ;; <CJK>
     (?$(1S?(B . ?\x851F) ;; <CJK>
     (?$(1S@(B . ?\x850A) ;; <CJK>
     (?$(1SA(B . ?\x8527) ;; <CJK>
     (?$(1SB(B . ?\x851C) ;; <CJK>
     (?$(1SC(B . ?\x84FB) ;; <CJK>
     (?$(1SD(B . ?\x852B) ;; <CJK>
     (?$(1SE(B . ?\x84FA) ;; <CJK>
     (?$(1SF(B . ?\x8508) ;; <CJK>
     (?$(1SG(B . ?\x850C) ;; <CJK>
     (?$(1SH(B . ?\x84F4) ;; <CJK>
     (?$(1SI(B . ?\x852A) ;; <CJK>
     (?$(1SJ(B . ?\x84F2) ;; <CJK>
     (?$(1SK(B . ?\x8515) ;; <CJK>
     (?$(1SL(B . ?\x84F7) ;; <CJK>
     (?$(1SM(B . ?\x84EB) ;; <CJK>
     (?$(1SN(B . ?\x84F3) ;; <CJK>
     (?$(1SO(B . ?\x84FC) ;; <CJK>
     (?$(1SP(B . ?\x8512) ;; <CJK>
     (?$(1SQ(B . ?\x84EA) ;; <CJK>
     (?$(1SR(B . ?\x84E9) ;; <CJK>
     (?$(1SS(B . ?\x8516) ;; <CJK>
     (?$(1ST(B . ?\x84FE) ;; <CJK>
     (?$(1SU(B . ?\x8528) ;; <CJK>
     (?$(1SV(B . ?\x851D) ;; <CJK>
     (?$(1SW(B . ?\x852E) ;; <CJK>
     (?$(1SX(B . ?\x8502) ;; <CJK>
     (?$(1SY(B . ?\x84FD) ;; <CJK>
     (?$(1SZ(B . ?\x851E) ;; <CJK>
     (?$(1S[(B . ?\x84F6) ;; <CJK>
     (?$(1S\(B . ?\x8531) ;; <CJK>
     (?$(1S](B . ?\x8526) ;; <CJK>
     (?$(1S^(B . ?\x84E7) ;; <CJK>
     (?$(1S_(B . ?\x84E8) ;; <CJK>
     (?$(1S`(B . ?\x84F0) ;; <CJK>
     (?$(1Sa(B . ?\x84EF) ;; <CJK>
     (?$(1Sb(B . ?\x84F9) ;; <CJK>
     (?$(1Sc(B . ?\x8518) ;; <CJK>
     (?$(1Sd(B . ?\x8520) ;; <CJK>
     (?$(1Se(B . ?\x8530) ;; <CJK>
     (?$(1Sf(B . ?\x850B) ;; <CJK>
     (?$(1Sg(B . ?\x8519) ;; <CJK>
     (?$(1Sh(B . ?\x852F) ;; <CJK>
     (?$(1Si(B . ?\x8662) ;; <CJK>
     (?$(1Sj(B . ?\x8756) ;; <CJK>
     (?$(1Sk(B . ?\x8763) ;; <CJK>
     (?$(1Sl(B . ?\x8764) ;; <CJK>
     (?$(1Sm(B . ?\x8777) ;; <CJK>
     (?$(1Sn(B . ?\x87E1) ;; <CJK>
     (?$(1So(B . ?\x8773) ;; <CJK>
     (?$(1Sp(B . ?\x8758) ;; <CJK>
     (?$(1Sq(B . ?\x8754) ;; <CJK>
     (?$(1Sr(B . ?\x875B) ;; <CJK>
     (?$(1Ss(B . ?\x8752) ;; <CJK>
     (?$(1St(B . ?\x8761) ;; <CJK>
     (?$(1Su(B . ?\x875A) ;; <CJK>
     (?$(1Sv(B . ?\x8751) ;; <CJK>
     (?$(1Sw(B . ?\x875E) ;; <CJK>
     (?$(1Sx(B . ?\x876D) ;; <CJK>
     (?$(1Sy(B . ?\x876A) ;; <CJK>
     (?$(1Sz(B . ?\x8750) ;; <CJK>
     (?$(1S{(B . ?\x874E) ;; <CJK>
     (?$(1S|(B . ?\x875F) ;; <CJK>
     (?$(1S}(B . ?\x875D) ;; <CJK>
     (?$(1S~(B . ?\x876F) ;; <CJK>
     (?$(1T!(B . ?\x876C) ;; <CJK>
     (?$(1T"(B . ?\x877A) ;; <CJK>
     (?$(1T#(B . ?\x876E) ;; <CJK>
     (?$(1T$(B . ?\x875C) ;; <CJK>
     (?$(1T%(B . ?\x8765) ;; <CJK>
     (?$(1T&(B . ?\x874F) ;; <CJK>
     (?$(1T'(B . ?\x877B) ;; <CJK>
     (?$(1T((B . ?\x8775) ;; <CJK>
     (?$(1T)(B . ?\x8762) ;; <CJK>
     (?$(1T*(B . ?\x8767) ;; <CJK>
     (?$(1T+(B . ?\x8769) ;; <CJK>
     (?$(1T,(B . ?\x885A) ;; <CJK>
     (?$(1T-(B . ?\x8905) ;; <CJK>
     (?$(1T.(B . ?\x890C) ;; <CJK>
     (?$(1T/(B . ?\x8914) ;; <CJK>
     (?$(1T0(B . ?\x890B) ;; <CJK>
     (?$(1T1(B . ?\x8917) ;; <CJK>
     (?$(1T2(B . ?\x8918) ;; <CJK>
     (?$(1T3(B . ?\x8919) ;; <CJK>
     (?$(1T4(B . ?\x8906) ;; <CJK>
     (?$(1T5(B . ?\x8916) ;; <CJK>
     (?$(1T6(B . ?\x8911) ;; <CJK>
     (?$(1T7(B . ?\x890E) ;; <CJK>
     (?$(1T8(B . ?\x8909) ;; <CJK>
     (?$(1T9(B . ?\x89A2) ;; <CJK>
     (?$(1T:(B . ?\x89A4) ;; <CJK>
     (?$(1T;(B . ?\x89A3) ;; <CJK>
     (?$(1T<(B . ?\x89ED) ;; <CJK>
     (?$(1T=(B . ?\x89F0) ;; <CJK>
     (?$(1T>(B . ?\x89EC) ;; <CJK>
     (?$(1T?(B . ?\x8ACF) ;; <CJK>
     (?$(1T@(B . ?\x8AC6) ;; <CJK>
     (?$(1TA(B . ?\x8AB8) ;; <CJK>
     (?$(1TB(B . ?\x8AD3) ;; <CJK>
     (?$(1TC(B . ?\x8AD1) ;; <CJK>
     (?$(1TD(B . ?\x8AD4) ;; <CJK>
     (?$(1TE(B . ?\x8AD5) ;; <CJK>
     (?$(1TF(B . ?\x8ABB) ;; <CJK>
     (?$(1TG(B . ?\x8AD7) ;; <CJK>
     (?$(1TH(B . ?\x8ABE) ;; <CJK>
     (?$(1TI(B . ?\x8AC0) ;; <CJK>
     (?$(1TJ(B . ?\x8AC5) ;; <CJK>
     (?$(1TK(B . ?\x8AD8) ;; <CJK>
     (?$(1TL(B . ?\x8AC3) ;; <CJK>
     (?$(1TM(B . ?\x8ABA) ;; <CJK>
     (?$(1TN(B . ?\x8ABD) ;; <CJK>
     (?$(1TO(B . ?\x8AD9) ;; <CJK>
     (?$(1TP(B . ?\x8C3E) ;; <CJK>
     (?$(1TQ(B . ?\x8C4D) ;; <CJK>
     (?$(1TR(B . ?\x8C8F) ;; <CJK>
     (?$(1TS(B . ?\x8CE5) ;; <CJK>
     (?$(1TT(B . ?\x8CDF) ;; <CJK>
     (?$(1TU(B . ?\x8CD9) ;; <CJK>
     (?$(1TV(B . ?\x8CE8) ;; <CJK>
     (?$(1TW(B . ?\x8CDA) ;; <CJK>
     (?$(1TX(B . ?\x8CDD) ;; <CJK>
     (?$(1TY(B . ?\x8CE7) ;; <CJK>
     (?$(1TZ(B . ?\x8DA0) ;; <CJK>
     (?$(1T[(B . ?\x8D9C) ;; <CJK>
     (?$(1T\(B . ?\x8DA1) ;; <CJK>
     (?$(1T](B . ?\x8D9B) ;; <CJK>
     (?$(1T^(B . ?\x8E20) ;; <CJK>
     (?$(1T_(B . ?\x8E23) ;; <CJK>
     (?$(1T`(B . ?\x8E25) ;; <CJK>
     (?$(1Ta(B . ?\x8E24) ;; <CJK>
     (?$(1Tb(B . ?\x8E2E) ;; <CJK>
     (?$(1Tc(B . ?\x8E15) ;; <CJK>
     (?$(1Td(B . ?\x8E1B) ;; <CJK>
     (?$(1Te(B . ?\x8E16) ;; <CJK>
     (?$(1Tf(B . ?\x8E11) ;; <CJK>
     (?$(1Tg(B . ?\x8E19) ;; <CJK>
     (?$(1Th(B . ?\x8E26) ;; <CJK>
     (?$(1Ti(B . ?\x8E27) ;; <CJK>
     (?$(1Tj(B . ?\x8E14) ;; <CJK>
     (?$(1Tk(B . ?\x8E12) ;; <CJK>
     (?$(1Tl(B . ?\x8E18) ;; <CJK>
     (?$(1Tm(B . ?\x8E13) ;; <CJK>
     (?$(1Tn(B . ?\x8E1C) ;; <CJK>
     (?$(1To(B . ?\x8E17) ;; <CJK>
     (?$(1Tp(B . ?\x8E1A) ;; <CJK>
     (?$(1Tq(B . ?\x8F2C) ;; <CJK>
     (?$(1Tr(B . ?\x8F24) ;; <CJK>
     (?$(1Ts(B . ?\x8F18) ;; <CJK>
     (?$(1Tt(B . ?\x8F1A) ;; <CJK>
     (?$(1Tu(B . ?\x8F20) ;; <CJK>
     (?$(1Tv(B . ?\x8F23) ;; <CJK>
     (?$(1Tw(B . ?\x8F16) ;; <CJK>
     (?$(1Tx(B . ?\x8F17) ;; <CJK>
     (?$(1Ty(B . ?\x9073) ;; <CJK>
     (?$(1Tz(B . ?\x9070) ;; <CJK>
     (?$(1T{(B . ?\x906F) ;; <CJK>
     (?$(1T|(B . ?\x9067) ;; <CJK>
     (?$(1T}(B . ?\x906B) ;; <CJK>
     (?$(1T~(B . ?\x912F) ;; <CJK>
     (?$(1U!(B . ?\x912B) ;; <CJK>
     (?$(1U"(B . ?\x9129) ;; <CJK>
     (?$(1U#(B . ?\x912A) ;; <CJK>
     (?$(1U$(B . ?\x9132) ;; <CJK>
     (?$(1U%(B . ?\x9126) ;; <CJK>
     (?$(1U&(B . ?\x912E) ;; <CJK>
     (?$(1U'(B . ?\x9185) ;; <CJK>
     (?$(1U((B . ?\x9186) ;; <CJK>
     (?$(1U)(B . ?\x918A) ;; <CJK>
     (?$(1U*(B . ?\x9181) ;; <CJK>
     (?$(1U+(B . ?\x9182) ;; <CJK>
     (?$(1U,(B . ?\x9184) ;; <CJK>
     (?$(1U-(B . ?\x9180) ;; <CJK>
     (?$(1U.(B . ?\x92D0) ;; <CJK>
     (?$(1U/(B . ?\x92C3) ;; <CJK>
     (?$(1U0(B . ?\x92C4) ;; <CJK>
     (?$(1U1(B . ?\x92C0) ;; <CJK>
     (?$(1U2(B . ?\x92D9) ;; <CJK>
     (?$(1U3(B . ?\x92B6) ;; <CJK>
     (?$(1U4(B . ?\x92CF) ;; <CJK>
     (?$(1U5(B . ?\x92F1) ;; <CJK>
     (?$(1U6(B . ?\x92DF) ;; <CJK>
     (?$(1U7(B . ?\x92D8) ;; <CJK>
     (?$(1U8(B . ?\x92E9) ;; <CJK>
     (?$(1U9(B . ?\x92D7) ;; <CJK>
     (?$(1U:(B . ?\x92DD) ;; <CJK>
     (?$(1U;(B . ?\x92CC) ;; <CJK>
     (?$(1U<(B . ?\x92EF) ;; <CJK>
     (?$(1U=(B . ?\x92C2) ;; <CJK>
     (?$(1U>(B . ?\x92E8) ;; <CJK>
     (?$(1U?(B . ?\x92CA) ;; <CJK>
     (?$(1U@(B . ?\x92C8) ;; <CJK>
     (?$(1UA(B . ?\x92CE) ;; <CJK>
     (?$(1UB(B . ?\x92E6) ;; <CJK>
     (?$(1UC(B . ?\x92CD) ;; <CJK>
     (?$(1UD(B . ?\x92D5) ;; <CJK>
     (?$(1UE(B . ?\x92C9) ;; <CJK>
     (?$(1UF(B . ?\x92E0) ;; <CJK>
     (?$(1UG(B . ?\x92DE) ;; <CJK>
     (?$(1UH(B . ?\x92E7) ;; <CJK>
     (?$(1UI(B . ?\x92D1) ;; <CJK>
     (?$(1UJ(B . ?\x92D3) ;; <CJK>
     (?$(1UK(B . ?\x92B5) ;; <CJK>
     (?$(1UL(B . ?\x92E1) ;; <CJK>
     (?$(1UM(B . ?\x92C6) ;; <CJK>
     (?$(1UN(B . ?\x92B4) ;; <CJK>
     (?$(1UO(B . ?\x957C) ;; <CJK>
     (?$(1UP(B . ?\x95AC) ;; <CJK>
     (?$(1UQ(B . ?\x95AB) ;; <CJK>
     (?$(1UR(B . ?\x95AE) ;; <CJK>
     (?$(1US(B . ?\x95B0) ;; <CJK>
     (?$(1UT(B . ?\x96A4) ;; <CJK>
     (?$(1UU(B . ?\x96A2) ;; <CJK>
     (?$(1UV(B . ?\x96D3) ;; <CJK>
     (?$(1UW(B . ?\x9705) ;; <CJK>
     (?$(1UX(B . ?\x9708) ;; <CJK>
     (?$(1UY(B . ?\x9702) ;; <CJK>
     (?$(1UZ(B . ?\x975A) ;; <CJK>
     (?$(1U[(B . ?\x978A) ;; <CJK>
     (?$(1U\(B . ?\x978E) ;; <CJK>
     (?$(1U](B . ?\x9788) ;; <CJK>
     (?$(1U^(B . ?\x97D0) ;; <CJK>
     (?$(1U_(B . ?\x97CF) ;; <CJK>
     (?$(1U`(B . ?\x981E) ;; <CJK>
     (?$(1Ua(B . ?\x981D) ;; <CJK>
     (?$(1Ub(B . ?\x9826) ;; <CJK>
     (?$(1Uc(B . ?\x9829) ;; <CJK>
     (?$(1Ud(B . ?\x9828) ;; <CJK>
     (?$(1Ue(B . ?\x9820) ;; <CJK>
     (?$(1Uf(B . ?\x981B) ;; <CJK>
     (?$(1Ug(B . ?\x9827) ;; <CJK>
     (?$(1Uh(B . ?\x98B2) ;; <CJK>
     (?$(1Ui(B . ?\x9908) ;; <CJK>
     (?$(1Uj(B . ?\x98FA) ;; <CJK>
     (?$(1Uk(B . ?\x9911) ;; <CJK>
     (?$(1Ul(B . ?\x9914) ;; <CJK>
     (?$(1Um(B . ?\x9916) ;; <CJK>
     (?$(1Un(B . ?\x9917) ;; <CJK>
     (?$(1Uo(B . ?\x9915) ;; <CJK>
     (?$(1Up(B . ?\x99DC) ;; <CJK>
     (?$(1Uq(B . ?\x99CD) ;; <CJK>
     (?$(1Ur(B . ?\x99CF) ;; <CJK>
     (?$(1Us(B . ?\x99D3) ;; <CJK>
     (?$(1Ut(B . ?\x99D4) ;; <CJK>
     (?$(1Uu(B . ?\x99CE) ;; <CJK>
     (?$(1Uv(B . ?\x99C9) ;; <CJK>
     (?$(1Uw(B . ?\x99D6) ;; <CJK>
     (?$(1Ux(B . ?\x99D8) ;; <CJK>
     (?$(1Uy(B . ?\x99CB) ;; <CJK>
     (?$(1Uz(B . ?\x99D7) ;; <CJK>
     (?$(1U{(B . ?\x99CC) ;; <CJK>
     (?$(1U|(B . ?\x9AB3) ;; <CJK>
     (?$(1U}(B . ?\x9AEC) ;; <CJK>
     (?$(1U~(B . ?\x9AEB) ;; <CJK>
     (?$(1V!(B . ?\x9AF3) ;; <CJK>
     (?$(1V"(B . ?\x9AF2) ;; <CJK>
     (?$(1V#(B . ?\x9AF1) ;; <CJK>
     (?$(1V$(B . ?\x9B46) ;; <CJK>
     (?$(1V%(B . ?\x9B43) ;; <CJK>
     (?$(1V&(B . ?\x9B67) ;; <CJK>
     (?$(1V'(B . ?\x9B74) ;; <CJK>
     (?$(1V((B . ?\x9B71) ;; <CJK>
     (?$(1V)(B . ?\x9B66) ;; <CJK>
     (?$(1V*(B . ?\x9B76) ;; <CJK>
     (?$(1V+(B . ?\x9B75) ;; <CJK>
     (?$(1V,(B . ?\x9B70) ;; <CJK>
     (?$(1V-(B . ?\x9B68) ;; <CJK>
     (?$(1V.(B . ?\x9B64) ;; <CJK>
     (?$(1V/(B . ?\x9B6C) ;; <CJK>
     (?$(1V0(B . ?\x9CFC) ;; <CJK>
     (?$(1V1(B . ?\x9CFA) ;; <CJK>
     (?$(1V2(B . ?\x9CFD) ;; <CJK>
     (?$(1V3(B . ?\x9CFF) ;; <CJK>
     (?$(1V4(B . ?\x9CF7) ;; <CJK>
     (?$(1V5(B . ?\x9D07) ;; <CJK>
     (?$(1V6(B . ?\x9D00) ;; <CJK>
     (?$(1V7(B . ?\x9CF9) ;; <CJK>
     (?$(1V8(B . ?\x9CFB) ;; <CJK>
     (?$(1V9(B . ?\x9D08) ;; <CJK>
     (?$(1V:(B . ?\x9D05) ;; <CJK>
     (?$(1V;(B . ?\x9D04) ;; <CJK>
     (?$(1V<(B . ?\x9E83) ;; <CJK>
     (?$(1V=(B . ?\x9ED3) ;; <CJK>
     (?$(1V>(B . ?\x9F0F) ;; <CJK>
     (?$(1V?(B . ?\x9F10) ;; <CJK>
     (?$(1V@(B . ?\x511C) ;; <CJK>
     (?$(1VA(B . ?\x5113) ;; <CJK>
     (?$(1VB(B . ?\x5117) ;; <CJK>
     (?$(1VC(B . ?\x511A) ;; <CJK>
     (?$(1VD(B . ?\x5111) ;; <CJK>
     (?$(1VE(B . ?\x51DE) ;; <CJK>
     (?$(1VF(B . ?\x5334) ;; <CJK>
     (?$(1VG(B . ?\x53E1) ;; <CJK>
     (?$(1VH(B . ?\x5670) ;; <CJK>
     (?$(1VI(B . ?\x5660) ;; <CJK>
     (?$(1VJ(B . ?\x566E) ;; <CJK>
     (?$(1VK(B . ?\x5673) ;; <CJK>
     (?$(1VL(B . ?\x5666) ;; <CJK>
     (?$(1VM(B . ?\x5663) ;; <CJK>
     (?$(1VN(B . ?\x566D) ;; <CJK>
     (?$(1VO(B . ?\x5672) ;; <CJK>
     (?$(1VP(B . ?\x565E) ;; <CJK>
     (?$(1VQ(B . ?\x5677) ;; <CJK>
     (?$(1VR(B . ?\x571C) ;; <CJK>
     (?$(1VS(B . ?\x571B) ;; <CJK>
     (?$(1VT(B . ?\x58C8) ;; <CJK>
     (?$(1VU(B . ?\x58BD) ;; <CJK>
     (?$(1VV(B . ?\x58C9) ;; <CJK>
     (?$(1VW(B . ?\x58BF) ;; <CJK>
     (?$(1VX(B . ?\x58BA) ;; <CJK>
     (?$(1VY(B . ?\x58C2) ;; <CJK>
     (?$(1VZ(B . ?\x58BC) ;; <CJK>
     (?$(1V[(B . ?\x58C6) ;; <CJK>
     (?$(1V\(B . ?\x5B17) ;; <CJK>
     (?$(1V](B . ?\x5B19) ;; <CJK>
     (?$(1V^(B . ?\x5B1B) ;; <CJK>
     (?$(1V_(B . ?\x5B21) ;; <CJK>
     (?$(1V`(B . ?\x5B14) ;; <CJK>
     (?$(1Va(B . ?\x5B13) ;; <CJK>
     (?$(1Vb(B . ?\x5B10) ;; <CJK>
     (?$(1Vc(B . ?\x5B16) ;; <CJK>
     (?$(1Vd(B . ?\x5B28) ;; <CJK>
     (?$(1Ve(B . ?\x5B1A) ;; <CJK>
     (?$(1Vf(B . ?\x5B20) ;; <CJK>
     (?$(1Vg(B . ?\x5B1E) ;; <CJK>
     (?$(1Vh(B . ?\x5BEF) ;; <CJK>
     (?$(1Vi(B . ?\x5DAC) ;; <CJK>
     (?$(1Vj(B . ?\x5DB1) ;; <CJK>
     (?$(1Vk(B . ?\x5DA9) ;; <CJK>
     (?$(1Vl(B . ?\x5DA7) ;; <CJK>
     (?$(1Vm(B . ?\x5DB5) ;; <CJK>
     (?$(1Vn(B . ?\x5DB0) ;; <CJK>
     (?$(1Vo(B . ?\x5DAE) ;; <CJK>
     (?$(1Vp(B . ?\x5DAA) ;; <CJK>
     (?$(1Vq(B . ?\x5DA8) ;; <CJK>
     (?$(1Vr(B . ?\x5DB2) ;; <CJK>
     (?$(1Vs(B . ?\x5DAD) ;; <CJK>
     (?$(1Vt(B . ?\x5DAF) ;; <CJK>
     (?$(1Vu(B . ?\x5DB4) ;; <CJK>
     (?$(1Vv(B . ?\x5E67) ;; <CJK>
     (?$(1Vw(B . ?\x5E68) ;; <CJK>
     (?$(1Vx(B . ?\x5E66) ;; <CJK>
     (?$(1Vy(B . ?\x5E6F) ;; <CJK>
     (?$(1Vz(B . ?\x5EE9) ;; <CJK>
     (?$(1V{(B . ?\x5EE7) ;; <CJK>
     (?$(1V|(B . ?\x5EE6) ;; <CJK>
     (?$(1V}(B . ?\x5EE8) ;; <CJK>
     (?$(1V~(B . ?\x5EE5) ;; <CJK>
     (?$(1W!(B . ?\x5F4B) ;; <CJK>
     (?$(1W"(B . ?\x5FBC) ;; <CJK>
     (?$(1W#(B . ?\x619D) ;; <CJK>
     (?$(1W$(B . ?\x61A8) ;; <CJK>
     (?$(1W%(B . ?\x6196) ;; <CJK>
     (?$(1W&(B . ?\x61C5) ;; <CJK>
     (?$(1W'(B . ?\x61B4) ;; <CJK>
     (?$(1W((B . ?\x61C6) ;; <CJK>
     (?$(1W)(B . ?\x61C1) ;; <CJK>
     (?$(1W*(B . ?\x61CC) ;; <CJK>
     (?$(1W+(B . ?\x61BA) ;; <CJK>
     (?$(1W,(B . ?\x61BF) ;; <CJK>
     (?$(1W-(B . ?\x61B8) ;; <CJK>
     (?$(1W.(B . ?\x618C) ;; <CJK>
     (?$(1W/(B . ?\x64D7) ;; <CJK>
     (?$(1W0(B . ?\x64D6) ;; <CJK>
     (?$(1W1(B . ?\x64D0) ;; <CJK>
     (?$(1W2(B . ?\x64CF) ;; <CJK>
     (?$(1W3(B . ?\x64C9) ;; <CJK>
     (?$(1W4(B . ?\x64BD) ;; <CJK>
     (?$(1W5(B . ?\x6489) ;; <CJK>
     (?$(1W6(B . ?\x64C3) ;; <CJK>
     (?$(1W7(B . ?\x64DB) ;; <CJK>
     (?$(1W8(B . ?\x64F3) ;; <CJK>
     (?$(1W9(B . ?\x64D9) ;; <CJK>
     (?$(1W:(B . ?\x6533) ;; <CJK>
     (?$(1W;(B . ?\x657F) ;; <CJK>
     (?$(1W<(B . ?\x657C) ;; <CJK>
     (?$(1W=(B . ?\x65A2) ;; <CJK>
     (?$(1W>(B . ?\x66C8) ;; <CJK>
     (?$(1W?(B . ?\x66BE) ;; <CJK>
     (?$(1W@(B . ?\x66C0) ;; <CJK>
     (?$(1WA(B . ?\x66CA) ;; <CJK>
     (?$(1WB(B . ?\x66CB) ;; <CJK>
     (?$(1WC(B . ?\x66CF) ;; <CJK>
     (?$(1WD(B . ?\x66BD) ;; <CJK>
     (?$(1WE(B . ?\x66BB) ;; <CJK>
     (?$(1WF(B . ?\x66BA) ;; <CJK>
     (?$(1WG(B . ?\x66CC) ;; <CJK>
     (?$(1WH(B . ?\x6723) ;; <CJK>
     (?$(1WI(B . ?\x6A34) ;; <CJK>
     (?$(1WJ(B . ?\x6A66) ;; <CJK>
     (?$(1WK(B . ?\x6A49) ;; <CJK>
     (?$(1WL(B . ?\x6A67) ;; <CJK>
     (?$(1WM(B . ?\x6A32) ;; <CJK>
     (?$(1WN(B . ?\x6A68) ;; <CJK>
     (?$(1WO(B . ?\x6A3E) ;; <CJK>
     (?$(1WP(B . ?\x6A5D) ;; <CJK>
     (?$(1WQ(B . ?\x6A6D) ;; <CJK>
     (?$(1WR(B . ?\x6A76) ;; <CJK>
     (?$(1WS(B . ?\x6A5B) ;; <CJK>
     (?$(1WT(B . ?\x6A51) ;; <CJK>
     (?$(1WU(B . ?\x6A28) ;; <CJK>
     (?$(1WV(B . ?\x6A5A) ;; <CJK>
     (?$(1WW(B . ?\x6A3B) ;; <CJK>
     (?$(1WX(B . ?\x6A3F) ;; <CJK>
     (?$(1WY(B . ?\x6A41) ;; <CJK>
     (?$(1WZ(B . ?\x6A6A) ;; <CJK>
     (?$(1W[(B . ?\x6A64) ;; <CJK>
     (?$(1W\(B . ?\x6A50) ;; <CJK>
     (?$(1W](B . ?\x6A4F) ;; <CJK>
     (?$(1W^(B . ?\x6A54) ;; <CJK>
     (?$(1W_(B . ?\x6A6F) ;; <CJK>
     (?$(1W`(B . ?\x6A69) ;; <CJK>
     (?$(1Wa(B . ?\x6A60) ;; <CJK>
     (?$(1Wb(B . ?\x6A3C) ;; <CJK>
     (?$(1Wc(B . ?\x6A5E) ;; <CJK>
     (?$(1Wd(B . ?\x6A56) ;; <CJK>
     (?$(1We(B . ?\x6A55) ;; <CJK>
     (?$(1Wf(B . ?\x6A4D) ;; <CJK>
     (?$(1Wg(B . ?\x6A4E) ;; <CJK>
     (?$(1Wh(B . ?\x6A46) ;; <CJK>
     (?$(1Wi(B . ?\x6B55) ;; <CJK>
     (?$(1Wj(B . ?\x6B54) ;; <CJK>
     (?$(1Wk(B . ?\x6B56) ;; <CJK>
     (?$(1Wl(B . ?\x6BA7) ;; <CJK>
     (?$(1Wm(B . ?\x6BAA) ;; <CJK>
     (?$(1Wn(B . ?\x6BAB) ;; <CJK>
     (?$(1Wo(B . ?\x6BC8) ;; <CJK>
     (?$(1Wp(B . ?\x6BC7) ;; <CJK>
     (?$(1Wq(B . ?\x6C04) ;; <CJK>
     (?$(1Wr(B . ?\x6C03) ;; <CJK>
     (?$(1Ws(B . ?\x6C06) ;; <CJK>
     (?$(1Wt(B . ?\x6FAD) ;; <CJK>
     (?$(1Wu(B . ?\x6FCB) ;; <CJK>
     (?$(1Wv(B . ?\x6FA3) ;; <CJK>
     (?$(1Ww(B . ?\x6FC7) ;; <CJK>
     (?$(1Wx(B . ?\x6FBC) ;; <CJK>
     (?$(1Wy(B . ?\x6FCE) ;; <CJK>
     (?$(1Wz(B . ?\x6FC8) ;; <CJK>
     (?$(1W{(B . ?\x6F5E) ;; <CJK>
     (?$(1W|(B . ?\x6FC4) ;; <CJK>
     (?$(1W}(B . ?\x6FBD) ;; <CJK>
     (?$(1W~(B . ?\x6F9E) ;; <CJK>
     (?$(1X!(B . ?\x6FCA) ;; <CJK>
     (?$(1X"(B . ?\x6FA8) ;; <CJK>
     (?$(1X#(B . ?\x7004) ;; <CJK>
     (?$(1X$(B . ?\x6FA5) ;; <CJK>
     (?$(1X%(B . ?\x6FAE) ;; <CJK>
     (?$(1X&(B . ?\x6FBA) ;; <CJK>
     (?$(1X'(B . ?\x6FAC) ;; <CJK>
     (?$(1X((B . ?\x6FAA) ;; <CJK>
     (?$(1X)(B . ?\x6FCF) ;; <CJK>
     (?$(1X*(B . ?\x6FBF) ;; <CJK>
     (?$(1X+(B . ?\x6FB8) ;; <CJK>
     (?$(1X,(B . ?\x6FA2) ;; <CJK>
     (?$(1X-(B . ?\x6FC9) ;; <CJK>
     (?$(1X.(B . ?\x6FAB) ;; <CJK>
     (?$(1X/(B . ?\x6FCD) ;; <CJK>
     (?$(1X0(B . ?\x6FAF) ;; <CJK>
     (?$(1X1(B . ?\x6FB2) ;; <CJK>
     (?$(1X2(B . ?\x6FB0) ;; <CJK>
     (?$(1X3(B . ?\x71C5) ;; <CJK>
     (?$(1X4(B . ?\x71C2) ;; <CJK>
     (?$(1X5(B . ?\x71BF) ;; <CJK>
     (?$(1X6(B . ?\x71B8) ;; <CJK>
     (?$(1X7(B . ?\x71D6) ;; <CJK>
     (?$(1X8(B . ?\x71C0) ;; <CJK>
     (?$(1X9(B . ?\x71C1) ;; <CJK>
     (?$(1X:(B . ?\x71CB) ;; <CJK>
     (?$(1X;(B . ?\x71D4) ;; <CJK>
     (?$(1X<(B . ?\x71CA) ;; <CJK>
     (?$(1X=(B . ?\x71C7) ;; <CJK>
     (?$(1X>(B . ?\x71CF) ;; <CJK>
     (?$(1X?(B . ?\x71BD) ;; <CJK>
     (?$(1X@(B . ?\x71D8) ;; <CJK>
     (?$(1XA(B . ?\x71BC) ;; <CJK>
     (?$(1XB(B . ?\x71C6) ;; <CJK>
     (?$(1XC(B . ?\x71DA) ;; <CJK>
     (?$(1XD(B . ?\x71DB) ;; <CJK>
     (?$(1XE(B . ?\x729D) ;; <CJK>
     (?$(1XF(B . ?\x729E) ;; <CJK>
     (?$(1XG(B . ?\x7369) ;; <CJK>
     (?$(1XH(B . ?\x7366) ;; <CJK>
     (?$(1XI(B . ?\x7367) ;; <CJK>
     (?$(1XJ(B . ?\x736C) ;; <CJK>
     (?$(1XK(B . ?\x7365) ;; <CJK>
     (?$(1XL(B . ?\x736B) ;; <CJK>
     (?$(1XM(B . ?\x736A) ;; <CJK>
     (?$(1XN(B . ?\x747F) ;; <CJK>
     (?$(1XO(B . ?\x749A) ;; <CJK>
     (?$(1XP(B . ?\x74A0) ;; <CJK>
     (?$(1XQ(B . ?\x7494) ;; <CJK>
     (?$(1XR(B . ?\x7492) ;; <CJK>
     (?$(1XS(B . ?\x7495) ;; <CJK>
     (?$(1XT(B . ?\x74A1) ;; <CJK>
     (?$(1XU(B . ?\x750B) ;; <CJK>
     (?$(1XV(B . ?\x7580) ;; <CJK>
     (?$(1XW(B . ?\x762F) ;; <CJK>
     (?$(1XX(B . ?\x762D) ;; <CJK>
     (?$(1XY(B . ?\x7631) ;; <CJK>
     (?$(1XZ(B . ?\x763D) ;; <CJK>
     (?$(1X[(B . ?\x7633) ;; <CJK>
     (?$(1X\(B . ?\x763C) ;; <CJK>
     (?$(1X](B . ?\x7635) ;; <CJK>
     (?$(1X^(B . ?\x7632) ;; <CJK>
     (?$(1X_(B . ?\x7630) ;; <CJK>
     (?$(1X`(B . ?\x76BB) ;; <CJK>
     (?$(1Xa(B . ?\x76E6) ;; <CJK>
     (?$(1Xb(B . ?\x779A) ;; <CJK>
     (?$(1Xc(B . ?\x779D) ;; <CJK>
     (?$(1Xd(B . ?\x77A1) ;; <CJK>
     (?$(1Xe(B . ?\x779C) ;; <CJK>
     (?$(1Xf(B . ?\x779B) ;; <CJK>
     (?$(1Xg(B . ?\x77A2) ;; <CJK>
     (?$(1Xh(B . ?\x77A3) ;; <CJK>
     (?$(1Xi(B . ?\x7795) ;; <CJK>
     (?$(1Xj(B . ?\x7799) ;; <CJK>
     (?$(1Xk(B . ?\x7797) ;; <CJK>
     (?$(1Xl(B . ?\x78DD) ;; <CJK>
     (?$(1Xm(B . ?\x78E9) ;; <CJK>
     (?$(1Xn(B . ?\x78E5) ;; <CJK>
     (?$(1Xo(B . ?\x78EA) ;; <CJK>
     (?$(1Xp(B . ?\x78DE) ;; <CJK>
     (?$(1Xq(B . ?\x78E3) ;; <CJK>
     (?$(1Xr(B . ?\x78DB) ;; <CJK>
     (?$(1Xs(B . ?\x78E1) ;; <CJK>
     (?$(1Xt(B . ?\x78E2) ;; <CJK>
     (?$(1Xu(B . ?\x78ED) ;; <CJK>
     (?$(1Xv(B . ?\x78DF) ;; <CJK>
     (?$(1Xw(B . ?\x78E0) ;; <CJK>
     (?$(1Xx(B . ?\x79A4) ;; <CJK>
     (?$(1Xy(B . ?\x7A44) ;; <CJK>
     (?$(1Xz(B . ?\x7A48) ;; <CJK>
     (?$(1X{(B . ?\x7A47) ;; <CJK>
     (?$(1X|(B . ?\x7AB6) ;; <CJK>
     (?$(1X}(B . ?\x7AB8) ;; <CJK>
     (?$(1X~(B . ?\x7AB5) ;; <CJK>
     (?$(1Y!(B . ?\x7AB1) ;; <CJK>
     (?$(1Y"(B . ?\x7AB7) ;; <CJK>
     (?$(1Y#(B . ?\x7BDE) ;; <CJK>
     (?$(1Y$(B . ?\x7BE3) ;; <CJK>
     (?$(1Y%(B . ?\x7BE7) ;; <CJK>
     (?$(1Y&(B . ?\x7BDD) ;; <CJK>
     (?$(1Y'(B . ?\x7BD5) ;; <CJK>
     (?$(1Y((B . ?\x7BE5) ;; <CJK>
     (?$(1Y)(B . ?\x7BDA) ;; <CJK>
     (?$(1Y*(B . ?\x7BE8) ;; <CJK>
     (?$(1Y+(B . ?\x7BF9) ;; <CJK>
     (?$(1Y,(B . ?\x7BD4) ;; <CJK>
     (?$(1Y-(B . ?\x7BEA) ;; <CJK>
     (?$(1Y.(B . ?\x7BE2) ;; <CJK>
     (?$(1Y/(B . ?\x7BDC) ;; <CJK>
     (?$(1Y0(B . ?\x7BEB) ;; <CJK>
     (?$(1Y1(B . ?\x7BD8) ;; <CJK>
     (?$(1Y2(B . ?\x7BDF) ;; <CJK>
     (?$(1Y3(B . ?\x7CD2) ;; <CJK>
     (?$(1Y4(B . ?\x7CD4) ;; <CJK>
     (?$(1Y5(B . ?\x7CD7) ;; <CJK>
     (?$(1Y6(B . ?\x7CD0) ;; <CJK>
     (?$(1Y7(B . ?\x7CD1) ;; <CJK>
     (?$(1Y8(B . ?\x7E12) ;; <CJK>
     (?$(1Y9(B . ?\x7E21) ;; <CJK>
     (?$(1Y:(B . ?\x7E17) ;; <CJK>
     (?$(1Y;(B . ?\x7E0C) ;; <CJK>
     (?$(1Y<(B . ?\x7E1F) ;; <CJK>
     (?$(1Y=(B . ?\x7E20) ;; <CJK>
     (?$(1Y>(B . ?\x7E13) ;; <CJK>
     (?$(1Y?(B . ?\x7E0E) ;; <CJK>
     (?$(1Y@(B . ?\x7E1C) ;; <CJK>
     (?$(1YA(B . ?\x7E15) ;; <CJK>
     (?$(1YB(B . ?\x7E1A) ;; <CJK>
     (?$(1YC(B . ?\x7E22) ;; <CJK>
     (?$(1YD(B . ?\x7E0B) ;; <CJK>
     (?$(1YE(B . ?\x7E0F) ;; <CJK>
     (?$(1YF(B . ?\x7E16) ;; <CJK>
     (?$(1YG(B . ?\x7E0D) ;; <CJK>
     (?$(1YH(B . ?\x7E14) ;; <CJK>
     (?$(1YI(B . ?\x7E25) ;; <CJK>
     (?$(1YJ(B . ?\x7E24) ;; <CJK>
     (?$(1YK(B . ?\x7F43) ;; <CJK>
     (?$(1YL(B . ?\x7F7B) ;; <CJK>
     (?$(1YM(B . ?\x7F7C) ;; <CJK>
     (?$(1YN(B . ?\x7F7A) ;; <CJK>
     (?$(1YO(B . ?\x7FB1) ;; <CJK>
     (?$(1YP(B . ?\x7FEF) ;; <CJK>
     (?$(1YQ(B . ?\x802A) ;; <CJK>
     (?$(1YR(B . ?\x8029) ;; <CJK>
     (?$(1YS(B . ?\x806C) ;; <CJK>
     (?$(1YT(B . ?\x81B1) ;; <CJK>
     (?$(1YU(B . ?\x81A6) ;; <CJK>
     (?$(1YV(B . ?\x81AE) ;; <CJK>
     (?$(1YW(B . ?\x81B9) ;; <CJK>
     (?$(1YX(B . ?\x81B5) ;; <CJK>
     (?$(1YY(B . ?\x81AB) ;; <CJK>
     (?$(1YZ(B . ?\x81B0) ;; <CJK>
     (?$(1Y[(B . ?\x81AC) ;; <CJK>
     (?$(1Y\(B . ?\x81B4) ;; <CJK>
     (?$(1Y](B . ?\x81B2) ;; <CJK>
     (?$(1Y^(B . ?\x81B7) ;; <CJK>
     (?$(1Y_(B . ?\x81A7) ;; <CJK>
     (?$(1Y`(B . ?\x81F2) ;; <CJK>
     (?$(1Ya(B . ?\x8255) ;; <CJK>
     (?$(1Yb(B . ?\x8256) ;; <CJK>
     (?$(1Yc(B . ?\x8257) ;; <CJK>
     (?$(1Yd(B . ?\x8556) ;; <CJK>
     (?$(1Ye(B . ?\x8545) ;; <CJK>
     (?$(1Yf(B . ?\x856B) ;; <CJK>
     (?$(1Yg(B . ?\x854D) ;; <CJK>
     (?$(1Yh(B . ?\x8553) ;; <CJK>
     (?$(1Yi(B . ?\x8561) ;; <CJK>
     (?$(1Yj(B . ?\x8558) ;; <CJK>
     (?$(1Yk(B . ?\x8540) ;; <CJK>
     (?$(1Yl(B . ?\x8546) ;; <CJK>
     (?$(1Ym(B . ?\x8564) ;; <CJK>
     (?$(1Yn(B . ?\x8541) ;; <CJK>
     (?$(1Yo(B . ?\x8562) ;; <CJK>
     (?$(1Yp(B . ?\x8544) ;; <CJK>
     (?$(1Yq(B . ?\x8551) ;; <CJK>
     (?$(1Yr(B . ?\x8547) ;; <CJK>
     (?$(1Ys(B . ?\x8563) ;; <CJK>
     (?$(1Yt(B . ?\x853E) ;; <CJK>
     (?$(1Yu(B . ?\x855B) ;; <CJK>
     (?$(1Yv(B . ?\x8571) ;; <CJK>
     (?$(1Yw(B . ?\x854E) ;; <CJK>
     (?$(1Yx(B . ?\x856E) ;; <CJK>
     (?$(1Yy(B . ?\x8575) ;; <CJK>
     (?$(1Yz(B . ?\x8555) ;; <CJK>
     (?$(1Y{(B . ?\x8567) ;; <CJK>
     (?$(1Y|(B . ?\x8560) ;; <CJK>
     (?$(1Y}(B . ?\x858C) ;; <CJK>
     (?$(1Y~(B . ?\x8566) ;; <CJK>
     (?$(1Z!(B . ?\x855D) ;; <CJK>
     (?$(1Z"(B . ?\x8554) ;; <CJK>
     (?$(1Z#(B . ?\x8565) ;; <CJK>
     (?$(1Z$(B . ?\x856C) ;; <CJK>
     (?$(1Z%(B . ?\x8663) ;; <CJK>
     (?$(1Z&(B . ?\x8665) ;; <CJK>
     (?$(1Z'(B . ?\x8664) ;; <CJK>
     (?$(1Z((B . ?\x879B) ;; <CJK>
     (?$(1Z)(B . ?\x878F) ;; <CJK>
     (?$(1Z*(B . ?\x8797) ;; <CJK>
     (?$(1Z+(B . ?\x8793) ;; <CJK>
     (?$(1Z,(B . ?\x8792) ;; <CJK>
     (?$(1Z-(B . ?\x8788) ;; <CJK>
     (?$(1Z.(B . ?\x8781) ;; <CJK>
     (?$(1Z/(B . ?\x8796) ;; <CJK>
     (?$(1Z0(B . ?\x8798) ;; <CJK>
     (?$(1Z1(B . ?\x8779) ;; <CJK>
     (?$(1Z2(B . ?\x8787) ;; <CJK>
     (?$(1Z3(B . ?\x87A3) ;; <CJK>
     (?$(1Z4(B . ?\x8785) ;; <CJK>
     (?$(1Z5(B . ?\x8790) ;; <CJK>
     (?$(1Z6(B . ?\x8791) ;; <CJK>
     (?$(1Z7(B . ?\x879D) ;; <CJK>
     (?$(1Z8(B . ?\x8784) ;; <CJK>
     (?$(1Z9(B . ?\x8794) ;; <CJK>
     (?$(1Z:(B . ?\x879C) ;; <CJK>
     (?$(1Z;(B . ?\x879A) ;; <CJK>
     (?$(1Z<(B . ?\x8789) ;; <CJK>
     (?$(1Z=(B . ?\x891E) ;; <CJK>
     (?$(1Z>(B . ?\x8926) ;; <CJK>
     (?$(1Z?(B . ?\x8930) ;; <CJK>
     (?$(1Z@(B . ?\x892D) ;; <CJK>
     (?$(1ZA(B . ?\x892E) ;; <CJK>
     (?$(1ZB(B . ?\x8927) ;; <CJK>
     (?$(1ZC(B . ?\x8931) ;; <CJK>
     (?$(1ZD(B . ?\x8922) ;; <CJK>
     (?$(1ZE(B . ?\x8929) ;; <CJK>
     (?$(1ZF(B . ?\x8923) ;; <CJK>
     (?$(1ZG(B . ?\x892F) ;; <CJK>
     (?$(1ZH(B . ?\x892C) ;; <CJK>
     (?$(1ZI(B . ?\x891F) ;; <CJK>
     (?$(1ZJ(B . ?\x89F1) ;; <CJK>
     (?$(1ZK(B . ?\x8AE0) ;; <CJK>
     (?$(1ZL(B . ?\x8AE2) ;; <CJK>
     (?$(1ZM(B . ?\x8AF2) ;; <CJK>
     (?$(1ZN(B . ?\x8AF4) ;; <CJK>
     (?$(1ZO(B . ?\x8AF5) ;; <CJK>
     (?$(1ZP(B . ?\x8ADD) ;; <CJK>
     (?$(1ZQ(B . ?\x8B14) ;; <CJK>
     (?$(1ZR(B . ?\x8AE4) ;; <CJK>
     (?$(1ZS(B . ?\x8ADF) ;; <CJK>
     (?$(1ZT(B . ?\x8AF0) ;; <CJK>
     (?$(1ZU(B . ?\x8AC8) ;; <CJK>
     (?$(1ZV(B . ?\x8ADE) ;; <CJK>
     (?$(1ZW(B . ?\x8AE1) ;; <CJK>
     (?$(1ZX(B . ?\x8AE8) ;; <CJK>
     (?$(1ZY(B . ?\x8AFF) ;; <CJK>
     (?$(1ZZ(B . ?\x8AEF) ;; <CJK>
     (?$(1Z[(B . ?\x8AFB) ;; <CJK>
     (?$(1Z\(B . ?\x8C91) ;; <CJK>
     (?$(1Z](B . ?\x8C92) ;; <CJK>
     (?$(1Z^(B . ?\x8C90) ;; <CJK>
     (?$(1Z_(B . ?\x8CF5) ;; <CJK>
     (?$(1Z`(B . ?\x8CEE) ;; <CJK>
     (?$(1Za(B . ?\x8CF1) ;; <CJK>
     (?$(1Zb(B . ?\x8CF0) ;; <CJK>
     (?$(1Zc(B . ?\x8CF3) ;; <CJK>
     (?$(1Zd(B . ?\x8D6C) ;; <CJK>
     (?$(1Ze(B . ?\x8D6E) ;; <CJK>
     (?$(1Zf(B . ?\x8DA5) ;; <CJK>
     (?$(1Zg(B . ?\x8DA7) ;; <CJK>
     (?$(1Zh(B . ?\x8E33) ;; <CJK>
     (?$(1Zi(B . ?\x8E3E) ;; <CJK>
     (?$(1Zj(B . ?\x8E38) ;; <CJK>
     (?$(1Zk(B . ?\x8E40) ;; <CJK>
     (?$(1Zl(B . ?\x8E45) ;; <CJK>
     (?$(1Zm(B . ?\x8E36) ;; <CJK>
     (?$(1Zn(B . ?\x8E3C) ;; <CJK>
     (?$(1Zo(B . ?\x8E3D) ;; <CJK>
     (?$(1Zp(B . ?\x8E41) ;; <CJK>
     (?$(1Zq(B . ?\x8E30) ;; <CJK>
     (?$(1Zr(B . ?\x8E3F) ;; <CJK>
     (?$(1Zs(B . ?\x8EBD) ;; <CJK>
     (?$(1Zt(B . ?\x8F36) ;; <CJK>
     (?$(1Zu(B . ?\x8F2E) ;; <CJK>
     (?$(1Zv(B . ?\x8F35) ;; <CJK>
     (?$(1Zw(B . ?\x8F32) ;; <CJK>
     (?$(1Zx(B . ?\x8F39) ;; <CJK>
     (?$(1Zy(B . ?\x8F37) ;; <CJK>
     (?$(1Zz(B . ?\x8F34) ;; <CJK>
     (?$(1Z{(B . ?\x9076) ;; <CJK>
     (?$(1Z|(B . ?\x9079) ;; <CJK>
     (?$(1Z}(B . ?\x907B) ;; <CJK>
     (?$(1Z~(B . ?\x9086) ;; <CJK>
     (?$(1[!(B . ?\x90FA) ;; <CJK>
     (?$(1["(B . ?\x9133) ;; <CJK>
     (?$(1[#(B . ?\x9135) ;; <CJK>
     (?$(1[$(B . ?\x9136) ;; <CJK>
     (?$(1[%(B . ?\x9193) ;; <CJK>
     (?$(1[&(B . ?\x9190) ;; <CJK>
     (?$(1['(B . ?\x9191) ;; <CJK>
     (?$(1[((B . ?\x918D) ;; <CJK>
     (?$(1[)(B . ?\x918F) ;; <CJK>
     (?$(1[*(B . ?\x9327) ;; <CJK>
     (?$(1[+(B . ?\x931E) ;; <CJK>
     (?$(1[,(B . ?\x9308) ;; <CJK>
     (?$(1[-(B . ?\x931F) ;; <CJK>
     (?$(1[.(B . ?\x9306) ;; <CJK>
     (?$(1[/(B . ?\x930F) ;; <CJK>
     (?$(1[0(B . ?\x937A) ;; <CJK>
     (?$(1[1(B . ?\x9338) ;; <CJK>
     (?$(1[2(B . ?\x933C) ;; <CJK>
     (?$(1[3(B . ?\x931B) ;; <CJK>
     (?$(1[4(B . ?\x9323) ;; <CJK>
     (?$(1[5(B . ?\x9312) ;; <CJK>
     (?$(1[6(B . ?\x9301) ;; <CJK>
     (?$(1[7(B . ?\x9346) ;; <CJK>
     (?$(1[8(B . ?\x932D) ;; <CJK>
     (?$(1[9(B . ?\x930E) ;; <CJK>
     (?$(1[:(B . ?\x930D) ;; <CJK>
     (?$(1[;(B . ?\x92CB) ;; <CJK>
     (?$(1[<(B . ?\x931D) ;; <CJK>
     (?$(1[=(B . ?\x92FA) ;; <CJK>
     (?$(1[>(B . ?\x9325) ;; <CJK>
     (?$(1[?(B . ?\x9313) ;; <CJK>
     (?$(1[@(B . ?\x92F9) ;; <CJK>
     (?$(1[A(B . ?\x92F7) ;; <CJK>
     (?$(1[B(B . ?\x9334) ;; <CJK>
     (?$(1[C(B . ?\x9302) ;; <CJK>
     (?$(1[D(B . ?\x9324) ;; <CJK>
     (?$(1[E(B . ?\x92FF) ;; <CJK>
     (?$(1[F(B . ?\x9329) ;; <CJK>
     (?$(1[G(B . ?\x9339) ;; <CJK>
     (?$(1[H(B . ?\x9335) ;; <CJK>
     (?$(1[I(B . ?\x932A) ;; <CJK>
     (?$(1[J(B . ?\x9314) ;; <CJK>
     (?$(1[K(B . ?\x930C) ;; <CJK>
     (?$(1[L(B . ?\x930B) ;; <CJK>
     (?$(1[M(B . ?\x92FE) ;; <CJK>
     (?$(1[N(B . ?\x9309) ;; <CJK>
     (?$(1[O(B . ?\x9300) ;; <CJK>
     (?$(1[P(B . ?\x92FB) ;; <CJK>
     (?$(1[Q(B . ?\x9316) ;; <CJK>
     (?$(1[R(B . ?\x95BC) ;; <CJK>
     (?$(1[S(B . ?\x95CD) ;; <CJK>
     (?$(1[T(B . ?\x95BE) ;; <CJK>
     (?$(1[U(B . ?\x95B9) ;; <CJK>
     (?$(1[V(B . ?\x95BA) ;; <CJK>
     (?$(1[W(B . ?\x95B6) ;; <CJK>
     (?$(1[X(B . ?\x95BF) ;; <CJK>
     (?$(1[Y(B . ?\x95B5) ;; <CJK>
     (?$(1[Z(B . ?\x95BD) ;; <CJK>
     (?$(1[[(B . ?\x96A9) ;; <CJK>
     (?$(1[\(B . ?\x96D4) ;; <CJK>
     (?$(1[](B . ?\x970B) ;; <CJK>
     (?$(1[^(B . ?\x9712) ;; <CJK>
     (?$(1[_(B . ?\x9710) ;; <CJK>
     (?$(1[`(B . ?\x9799) ;; <CJK>
     (?$(1[a(B . ?\x9797) ;; <CJK>
     (?$(1[b(B . ?\x9794) ;; <CJK>
     (?$(1[c(B . ?\x97F0) ;; <CJK>
     (?$(1[d(B . ?\x97F8) ;; <CJK>
     (?$(1[e(B . ?\x9835) ;; <CJK>
     (?$(1[f(B . ?\x982F) ;; <CJK>
     (?$(1[g(B . ?\x9832) ;; <CJK>
     (?$(1[h(B . ?\x9924) ;; <CJK>
     (?$(1[i(B . ?\x991F) ;; <CJK>
     (?$(1[j(B . ?\x9927) ;; <CJK>
     (?$(1[k(B . ?\x9929) ;; <CJK>
     (?$(1[l(B . ?\x999E) ;; <CJK>
     (?$(1[m(B . ?\x99EE) ;; <CJK>
     (?$(1[n(B . ?\x99EC) ;; <CJK>
     (?$(1[o(B . ?\x99E5) ;; <CJK>
     (?$(1[p(B . ?\x99E4) ;; <CJK>
     (?$(1[q(B . ?\x99F0) ;; <CJK>
     (?$(1[r(B . ?\x99E3) ;; <CJK>
     (?$(1[s(B . ?\x99EA) ;; <CJK>
     (?$(1[t(B . ?\x99E9) ;; <CJK>
     (?$(1[u(B . ?\x99E7) ;; <CJK>
     (?$(1[v(B . ?\x9AB9) ;; <CJK>
     (?$(1[w(B . ?\x9ABF) ;; <CJK>
     (?$(1[x(B . ?\x9AB4) ;; <CJK>
     (?$(1[y(B . ?\x9ABB) ;; <CJK>
     (?$(1[z(B . ?\x9AF6) ;; <CJK>
     (?$(1[{(B . ?\x9AFA) ;; <CJK>
     (?$(1[|(B . ?\x9AF9) ;; <CJK>
     (?$(1[}(B . ?\x9AF7) ;; <CJK>
     (?$(1[~(B . ?\x9B33) ;; <CJK>
     (?$(1\!(B . ?\x9B80) ;; <CJK>
     (?$(1\"(B . ?\x9B85) ;; <CJK>
     (?$(1\#(B . ?\x9B87) ;; <CJK>
     (?$(1\$(B . ?\x9B7C) ;; <CJK>
     (?$(1\%(B . ?\x9B7E) ;; <CJK>
     (?$(1\&(B . ?\x9B7B) ;; <CJK>
     (?$(1\'(B . ?\x9B82) ;; <CJK>
     (?$(1\((B . ?\x9B93) ;; <CJK>
     (?$(1\)(B . ?\x9B92) ;; <CJK>
     (?$(1\*(B . ?\x9B90) ;; <CJK>
     (?$(1\+(B . ?\x9B7A) ;; <CJK>
     (?$(1\,(B . ?\x9B95) ;; <CJK>
     (?$(1\-(B . ?\x9B7D) ;; <CJK>
     (?$(1\.(B . ?\x9B88) ;; <CJK>
     (?$(1\/(B . ?\x9D25) ;; <CJK>
     (?$(1\0(B . ?\x9D17) ;; <CJK>
     (?$(1\1(B . ?\x9D20) ;; <CJK>
     (?$(1\2(B . ?\x9D1E) ;; <CJK>
     (?$(1\3(B . ?\x9D14) ;; <CJK>
     (?$(1\4(B . ?\x9D29) ;; <CJK>
     (?$(1\5(B . ?\x9D1D) ;; <CJK>
     (?$(1\6(B . ?\x9D18) ;; <CJK>
     (?$(1\7(B . ?\x9D22) ;; <CJK>
     (?$(1\8(B . ?\x9D10) ;; <CJK>
     (?$(1\9(B . ?\x9D19) ;; <CJK>
     (?$(1\:(B . ?\x9D1F) ;; <CJK>
     (?$(1\;(B . ?\x9E88) ;; <CJK>
     (?$(1\<(B . ?\x9E86) ;; <CJK>
     (?$(1\=(B . ?\x9E87) ;; <CJK>
     (?$(1\>(B . ?\x9EAE) ;; <CJK>
     (?$(1\?(B . ?\x9EAD) ;; <CJK>
     (?$(1\@(B . ?\x9ED5) ;; <CJK>
     (?$(1\A(B . ?\x9ED6) ;; <CJK>
     (?$(1\B(B . ?\x9EFA) ;; <CJK>
     (?$(1\C(B . ?\x9F12) ;; <CJK>
     (?$(1\D(B . ?\x9F3D) ;; <CJK>
     (?$(1\E(B . ?\x5126) ;; <CJK>
     (?$(1\F(B . ?\x5125) ;; <CJK>
     (?$(1\G(B . ?\x5122) ;; <CJK>
     (?$(1\H(B . ?\x5124) ;; <CJK>
     (?$(1\I(B . ?\x5120) ;; <CJK>
     (?$(1\J(B . ?\x5129) ;; <CJK>
     (?$(1\K(B . ?\x52F4) ;; <CJK>
     (?$(1\L(B . ?\x5693) ;; <CJK>
     (?$(1\M(B . ?\x568C) ;; <CJK>
     (?$(1\N(B . ?\x568D) ;; <CJK>
     (?$(1\O(B . ?\x5686) ;; <CJK>
     (?$(1\P(B . ?\x5684) ;; <CJK>
     (?$(1\Q(B . ?\x5683) ;; <CJK>
     (?$(1\R(B . ?\x567E) ;; <CJK>
     (?$(1\S(B . ?\x5682) ;; <CJK>
     (?$(1\T(B . ?\x567F) ;; <CJK>
     (?$(1\U(B . ?\x5681) ;; <CJK>
     (?$(1\V(B . ?\x58D6) ;; <CJK>
     (?$(1\W(B . ?\x58D4) ;; <CJK>
     (?$(1\X(B . ?\x58CF) ;; <CJK>
     (?$(1\Y(B . ?\x58D2) ;; <CJK>
     (?$(1\Z(B . ?\x5B2D) ;; <CJK>
     (?$(1\[(B . ?\x5B25) ;; <CJK>
     (?$(1\\(B . ?\x5B32) ;; <CJK>
     (?$(1\](B . ?\x5B23) ;; <CJK>
     (?$(1\^(B . ?\x5B2C) ;; <CJK>
     (?$(1\_(B . ?\x5B27) ;; <CJK>
     (?$(1\`(B . ?\x5B26) ;; <CJK>
     (?$(1\a(B . ?\x5B2F) ;; <CJK>
     (?$(1\b(B . ?\x5B2E) ;; <CJK>
     (?$(1\c(B . ?\x5B7B) ;; <CJK>
     (?$(1\d(B . ?\x5BF1) ;; <CJK>
     (?$(1\e(B . ?\x5BF2) ;; <CJK>
     (?$(1\f(B . ?\x5DB7) ;; <CJK>
     (?$(1\g(B . ?\x5E6C) ;; <CJK>
     (?$(1\h(B . ?\x5E6A) ;; <CJK>
     (?$(1\i(B . ?\x5FBE) ;; <CJK>
     (?$(1\j(B . ?\x5FBB) ;; <CJK>
     (?$(1\k(B . ?\x61C3) ;; <CJK>
     (?$(1\l(B . ?\x61B5) ;; <CJK>
     (?$(1\m(B . ?\x61BC) ;; <CJK>
     (?$(1\n(B . ?\x61E7) ;; <CJK>
     (?$(1\o(B . ?\x61E0) ;; <CJK>
     (?$(1\p(B . ?\x61E5) ;; <CJK>
     (?$(1\q(B . ?\x61E4) ;; <CJK>
     (?$(1\r(B . ?\x61E8) ;; <CJK>
     (?$(1\s(B . ?\x61DE) ;; <CJK>
     (?$(1\t(B . ?\x64EF) ;; <CJK>
     (?$(1\u(B . ?\x64E9) ;; <CJK>
     (?$(1\v(B . ?\x64E3) ;; <CJK>
     (?$(1\w(B . ?\x64EB) ;; <CJK>
     (?$(1\x(B . ?\x64E4) ;; <CJK>
     (?$(1\y(B . ?\x64E8) ;; <CJK>
     (?$(1\z(B . ?\x6581) ;; <CJK>
     (?$(1\{(B . ?\x6580) ;; <CJK>
     (?$(1\|(B . ?\x65B6) ;; <CJK>
     (?$(1\}(B . ?\x65DA) ;; <CJK>
     (?$(1\~(B . ?\x66D2) ;; <CJK>
     (?$(1]!(B . ?\x6A8D) ;; <CJK>
     (?$(1]"(B . ?\x6A96) ;; <CJK>
     (?$(1]#(B . ?\x6A81) ;; <CJK>
     (?$(1]$(B . ?\x6AA5) ;; <CJK>
     (?$(1]%(B . ?\x6A89) ;; <CJK>
     (?$(1]&(B . ?\x6A9F) ;; <CJK>
     (?$(1]'(B . ?\x6A9B) ;; <CJK>
     (?$(1]((B . ?\x6AA1) ;; <CJK>
     (?$(1])(B . ?\x6A9E) ;; <CJK>
     (?$(1]*(B . ?\x6A87) ;; <CJK>
     (?$(1]+(B . ?\x6A93) ;; <CJK>
     (?$(1],(B . ?\x6A8E) ;; <CJK>
     (?$(1]-(B . ?\x6A95) ;; <CJK>
     (?$(1].(B . ?\x6A83) ;; <CJK>
     (?$(1]/(B . ?\x6AA8) ;; <CJK>
     (?$(1]0(B . ?\x6AA4) ;; <CJK>
     (?$(1]1(B . ?\x6A91) ;; <CJK>
     (?$(1]2(B . ?\x6A7F) ;; <CJK>
     (?$(1]3(B . ?\x6AA6) ;; <CJK>
     (?$(1]4(B . ?\x6A9A) ;; <CJK>
     (?$(1]5(B . ?\x6A85) ;; <CJK>
     (?$(1]6(B . ?\x6A8C) ;; <CJK>
     (?$(1]7(B . ?\x6A92) ;; <CJK>
     (?$(1]8(B . ?\x6B5B) ;; <CJK>
     (?$(1]9(B . ?\x6BAD) ;; <CJK>
     (?$(1]:(B . ?\x6C09) ;; <CJK>
     (?$(1];(B . ?\x6FCC) ;; <CJK>
     (?$(1]<(B . ?\x6FA9) ;; <CJK>
     (?$(1]=(B . ?\x6FF4) ;; <CJK>
     (?$(1]>(B . ?\x6FD4) ;; <CJK>
     (?$(1]?(B . ?\x6FE3) ;; <CJK>
     (?$(1]@(B . ?\x6FDC) ;; <CJK>
     (?$(1]A(B . ?\x6FED) ;; <CJK>
     (?$(1]B(B . ?\x6FE7) ;; <CJK>
     (?$(1]C(B . ?\x6FE6) ;; <CJK>
     (?$(1]D(B . ?\x6FDE) ;; <CJK>
     (?$(1]E(B . ?\x6FF2) ;; <CJK>
     (?$(1]F(B . ?\x6FDD) ;; <CJK>
     (?$(1]G(B . ?\x6FE2) ;; <CJK>
     (?$(1]H(B . ?\x6FE8) ;; <CJK>
     (?$(1]I(B . ?\x71E1) ;; <CJK>
     (?$(1]J(B . ?\x71F1) ;; <CJK>
     (?$(1]K(B . ?\x71E8) ;; <CJK>
     (?$(1]L(B . ?\x71F2) ;; <CJK>
     (?$(1]M(B . ?\x71E4) ;; <CJK>
     (?$(1]N(B . ?\x71F0) ;; <CJK>
     (?$(1]O(B . ?\x71E2) ;; <CJK>
     (?$(1]P(B . ?\x7373) ;; <CJK>
     (?$(1]Q(B . ?\x736E) ;; <CJK>
     (?$(1]R(B . ?\x736F) ;; <CJK>
     (?$(1]S(B . ?\x7497) ;; <CJK>
     (?$(1]T(B . ?\x74B2) ;; <CJK>
     (?$(1]U(B . ?\x74AB) ;; <CJK>
     (?$(1]V(B . ?\x7490) ;; <CJK>
     (?$(1]W(B . ?\x74AA) ;; <CJK>
     (?$(1]X(B . ?\x74AD) ;; <CJK>
     (?$(1]Y(B . ?\x74B1) ;; <CJK>
     (?$(1]Z(B . ?\x74A5) ;; <CJK>
     (?$(1][(B . ?\x74AF) ;; <CJK>
     (?$(1]\(B . ?\x7510) ;; <CJK>
     (?$(1]](B . ?\x7511) ;; <CJK>
     (?$(1]^(B . ?\x7512) ;; <CJK>
     (?$(1]_(B . ?\x750F) ;; <CJK>
     (?$(1]`(B . ?\x7584) ;; <CJK>
     (?$(1]a(B . ?\x7643) ;; <CJK>
     (?$(1]b(B . ?\x7648) ;; <CJK>
     (?$(1]c(B . ?\x7649) ;; <CJK>
     (?$(1]d(B . ?\x7647) ;; <CJK>
     (?$(1]e(B . ?\x76A4) ;; <CJK>
     (?$(1]f(B . ?\x76E9) ;; <CJK>
     (?$(1]g(B . ?\x77B5) ;; <CJK>
     (?$(1]h(B . ?\x77AB) ;; <CJK>
     (?$(1]i(B . ?\x77B2) ;; <CJK>
     (?$(1]j(B . ?\x77B7) ;; <CJK>
     (?$(1]k(B . ?\x77B6) ;; <CJK>
     (?$(1]l(B . ?\x77B4) ;; <CJK>
     (?$(1]m(B . ?\x77B1) ;; <CJK>
     (?$(1]n(B . ?\x77A8) ;; <CJK>
     (?$(1]o(B . ?\x77F0) ;; <CJK>
     (?$(1]p(B . ?\x78F3) ;; <CJK>
     (?$(1]q(B . ?\x78FD) ;; <CJK>
     (?$(1]r(B . ?\x7902) ;; <CJK>
     (?$(1]s(B . ?\x78FB) ;; <CJK>
     (?$(1]t(B . ?\x78FC) ;; <CJK>
     (?$(1]u(B . ?\x78F2) ;; <CJK>
     (?$(1]v(B . ?\x7905) ;; <CJK>
     (?$(1]w(B . ?\x78F9) ;; <CJK>
     (?$(1]x(B . ?\x78FE) ;; <CJK>
     (?$(1]y(B . ?\x7904) ;; <CJK>
     (?$(1]z(B . ?\x79AB) ;; <CJK>
     (?$(1]{(B . ?\x79A8) ;; <CJK>
     (?$(1]|(B . ?\x7A5C) ;; <CJK>
     (?$(1]}(B . ?\x7A5B) ;; <CJK>
     (?$(1]~(B . ?\x7A56) ;; <CJK>
     (?$(1^!(B . ?\x7A58) ;; <CJK>
     (?$(1^"(B . ?\x7A54) ;; <CJK>
     (?$(1^#(B . ?\x7A5A) ;; <CJK>
     (?$(1^$(B . ?\x7ABE) ;; <CJK>
     (?$(1^%(B . ?\x7AC0) ;; <CJK>
     (?$(1^&(B . ?\x7AC1) ;; <CJK>
     (?$(1^'(B . ?\x7C05) ;; <CJK>
     (?$(1^((B . ?\x7C0F) ;; <CJK>
     (?$(1^)(B . ?\x7BF2) ;; <CJK>
     (?$(1^*(B . ?\x7C00) ;; <CJK>
     (?$(1^+(B . ?\x7BFF) ;; <CJK>
     (?$(1^,(B . ?\x7BFB) ;; <CJK>
     (?$(1^-(B . ?\x7C0E) ;; <CJK>
     (?$(1^.(B . ?\x7BF4) ;; <CJK>
     (?$(1^/(B . ?\x7C0B) ;; <CJK>
     (?$(1^0(B . ?\x7BF3) ;; <CJK>
     (?$(1^1(B . ?\x7C02) ;; <CJK>
     (?$(1^2(B . ?\x7C09) ;; <CJK>
     (?$(1^3(B . ?\x7C03) ;; <CJK>
     (?$(1^4(B . ?\x7C01) ;; <CJK>
     (?$(1^5(B . ?\x7BF8) ;; <CJK>
     (?$(1^6(B . ?\x7BFD) ;; <CJK>
     (?$(1^7(B . ?\x7C06) ;; <CJK>
     (?$(1^8(B . ?\x7BF0) ;; <CJK>
     (?$(1^9(B . ?\x7BF1) ;; <CJK>
     (?$(1^:(B . ?\x7C10) ;; <CJK>
     (?$(1^;(B . ?\x7C0A) ;; <CJK>
     (?$(1^<(B . ?\x7CE8) ;; <CJK>
     (?$(1^=(B . ?\x7E2D) ;; <CJK>
     (?$(1^>(B . ?\x7E3C) ;; <CJK>
     (?$(1^?(B . ?\x7E42) ;; <CJK>
     (?$(1^@(B . ?\x7E33) ;; <CJK>
     (?$(1^A(B . ?\x9848) ;; <CJK>
     (?$(1^B(B . ?\x7E38) ;; <CJK>
     (?$(1^C(B . ?\x7E2A) ;; <CJK>
     (?$(1^D(B . ?\x7E49) ;; <CJK>
     (?$(1^E(B . ?\x7E40) ;; <CJK>
     (?$(1^F(B . ?\x7E47) ;; <CJK>
     (?$(1^G(B . ?\x7E29) ;; <CJK>
     (?$(1^H(B . ?\x7E4C) ;; <CJK>
     (?$(1^I(B . ?\x7E30) ;; <CJK>
     (?$(1^J(B . ?\x7E3B) ;; <CJK>
     (?$(1^K(B . ?\x7E36) ;; <CJK>
     (?$(1^L(B . ?\x7E44) ;; <CJK>
     (?$(1^M(B . ?\x7E3A) ;; <CJK>
     (?$(1^N(B . ?\x7F45) ;; <CJK>
     (?$(1^O(B . ?\x7F7F) ;; <CJK>
     (?$(1^P(B . ?\x7F7E) ;; <CJK>
     (?$(1^Q(B . ?\x7F7D) ;; <CJK>
     (?$(1^R(B . ?\x7FF4) ;; <CJK>
     (?$(1^S(B . ?\x7FF2) ;; <CJK>
     (?$(1^T(B . ?\x802C) ;; <CJK>
     (?$(1^U(B . ?\x81BB) ;; <CJK>
     (?$(1^V(B . ?\x81C4) ;; <CJK>
     (?$(1^W(B . ?\x81CC) ;; <CJK>
     (?$(1^X(B . ?\x81CA) ;; <CJK>
     (?$(1^Y(B . ?\x81C5) ;; <CJK>
     (?$(1^Z(B . ?\x81C7) ;; <CJK>
     (?$(1^[(B . ?\x81BC) ;; <CJK>
     (?$(1^\(B . ?\x81E9) ;; <CJK>
     (?$(1^](B . ?\x825B) ;; <CJK>
     (?$(1^^(B . ?\x825A) ;; <CJK>
     (?$(1^_(B . ?\x825C) ;; <CJK>
     (?$(1^`(B . ?\x8583) ;; <CJK>
     (?$(1^a(B . ?\x8580) ;; <CJK>
     (?$(1^b(B . ?\x858F) ;; <CJK>
     (?$(1^c(B . ?\x85A7) ;; <CJK>
     (?$(1^d(B . ?\x8595) ;; <CJK>
     (?$(1^e(B . ?\x85A0) ;; <CJK>
     (?$(1^f(B . ?\x858B) ;; <CJK>
     (?$(1^g(B . ?\x85A3) ;; <CJK>
     (?$(1^h(B . ?\x857B) ;; <CJK>
     (?$(1^i(B . ?\x85A4) ;; <CJK>
     (?$(1^j(B . ?\x859A) ;; <CJK>
     (?$(1^k(B . ?\x859E) ;; <CJK>
     (?$(1^l(B . ?\x8577) ;; <CJK>
     (?$(1^m(B . ?\x857C) ;; <CJK>
     (?$(1^n(B . ?\x8589) ;; <CJK>
     (?$(1^o(B . ?\x85A1) ;; <CJK>
     (?$(1^p(B . ?\x857A) ;; <CJK>
     (?$(1^q(B . ?\x8578) ;; <CJK>
     (?$(1^r(B . ?\x8557) ;; <CJK>
     (?$(1^s(B . ?\x858E) ;; <CJK>
     (?$(1^t(B . ?\x8596) ;; <CJK>
     (?$(1^u(B . ?\x8586) ;; <CJK>
     (?$(1^v(B . ?\x858D) ;; <CJK>
     (?$(1^w(B . ?\x8599) ;; <CJK>
     (?$(1^x(B . ?\x859D) ;; <CJK>
     (?$(1^y(B . ?\x8581) ;; <CJK>
     (?$(1^z(B . ?\x85A2) ;; <CJK>
     (?$(1^{(B . ?\x8582) ;; <CJK>
     (?$(1^|(B . ?\x8588) ;; <CJK>
     (?$(1^}(B . ?\x8585) ;; <CJK>
     (?$(1^~(B . ?\x8579) ;; <CJK>
     (?$(1_!(B . ?\x8576) ;; <CJK>
     (?$(1_"(B . ?\x8598) ;; <CJK>
     (?$(1_#(B . ?\x8590) ;; <CJK>
     (?$(1_$(B . ?\x859F) ;; <CJK>
     (?$(1_%(B . ?\x8668) ;; <CJK>
     (?$(1_&(B . ?\x87BE) ;; <CJK>
     (?$(1_'(B . ?\x87AA) ;; <CJK>
     (?$(1_((B . ?\x87AD) ;; <CJK>
     (?$(1_)(B . ?\x87C5) ;; <CJK>
     (?$(1_*(B . ?\x87B0) ;; <CJK>
     (?$(1_+(B . ?\x87AC) ;; <CJK>
     (?$(1_,(B . ?\x87B9) ;; <CJK>
     (?$(1_-(B . ?\x87B5) ;; <CJK>
     (?$(1_.(B . ?\x87BC) ;; <CJK>
     (?$(1_/(B . ?\x87AE) ;; <CJK>
     (?$(1_0(B . ?\x87C9) ;; <CJK>
     (?$(1_1(B . ?\x87C3) ;; <CJK>
     (?$(1_2(B . ?\x87C2) ;; <CJK>
     (?$(1_3(B . ?\x87CC) ;; <CJK>
     (?$(1_4(B . ?\x87B7) ;; <CJK>
     (?$(1_5(B . ?\x87AF) ;; <CJK>
     (?$(1_6(B . ?\x87C4) ;; <CJK>
     (?$(1_7(B . ?\x87CA) ;; <CJK>
     (?$(1_8(B . ?\x87B4) ;; <CJK>
     (?$(1_9(B . ?\x87B6) ;; <CJK>
     (?$(1_:(B . ?\x87BF) ;; <CJK>
     (?$(1_;(B . ?\x87B8) ;; <CJK>
     (?$(1_<(B . ?\x87BD) ;; <CJK>
     (?$(1_=(B . ?\x87DE) ;; <CJK>
     (?$(1_>(B . ?\x87B2) ;; <CJK>
     (?$(1_?(B . ?\x8935) ;; <CJK>
     (?$(1_@(B . ?\x8933) ;; <CJK>
     (?$(1_A(B . ?\x893C) ;; <CJK>
     (?$(1_B(B . ?\x893E) ;; <CJK>
     (?$(1_C(B . ?\x8941) ;; <CJK>
     (?$(1_D(B . ?\x8952) ;; <CJK>
     (?$(1_E(B . ?\x8937) ;; <CJK>
     (?$(1_F(B . ?\x8942) ;; <CJK>
     (?$(1_G(B . ?\x89AD) ;; <CJK>
     (?$(1_H(B . ?\x89AF) ;; <CJK>
     (?$(1_I(B . ?\x89AE) ;; <CJK>
     (?$(1_J(B . ?\x89F2) ;; <CJK>
     (?$(1_K(B . ?\x89F3) ;; <CJK>
     (?$(1_L(B . ?\x8B1E) ;; <CJK>
     (?$(1_M(B . ?\x8B18) ;; <CJK>
     (?$(1_N(B . ?\x8B16) ;; <CJK>
     (?$(1_O(B . ?\x8B11) ;; <CJK>
     (?$(1_P(B . ?\x8B05) ;; <CJK>
     (?$(1_Q(B . ?\x8B0B) ;; <CJK>
     (?$(1_R(B . ?\x8B22) ;; <CJK>
     (?$(1_S(B . ?\x8B0F) ;; <CJK>
     (?$(1_T(B . ?\x8B12) ;; <CJK>
     (?$(1_U(B . ?\x8B15) ;; <CJK>
     (?$(1_V(B . ?\x8B07) ;; <CJK>
     (?$(1_W(B . ?\x8B0D) ;; <CJK>
     (?$(1_X(B . ?\x8B08) ;; <CJK>
     (?$(1_Y(B . ?\x8B06) ;; <CJK>
     (?$(1_Z(B . ?\x8B1C) ;; <CJK>
     (?$(1_[(B . ?\x8B13) ;; <CJK>
     (?$(1_\(B . ?\x8B1A) ;; <CJK>
     (?$(1_](B . ?\x8C4F) ;; <CJK>
     (?$(1_^(B . ?\x8C70) ;; <CJK>
     (?$(1__(B . ?\x8C72) ;; <CJK>
     (?$(1_`(B . ?\x8C71) ;; <CJK>
     (?$(1_a(B . ?\x8C6F) ;; <CJK>
     (?$(1_b(B . ?\x8C95) ;; <CJK>
     (?$(1_c(B . ?\x8C94) ;; <CJK>
     (?$(1_d(B . ?\x8CF9) ;; <CJK>
     (?$(1_e(B . ?\x8D6F) ;; <CJK>
     (?$(1_f(B . ?\x8E4E) ;; <CJK>
     (?$(1_g(B . ?\x8E4D) ;; <CJK>
     (?$(1_h(B . ?\x8E53) ;; <CJK>
     (?$(1_i(B . ?\x8E50) ;; <CJK>
     (?$(1_j(B . ?\x8E4C) ;; <CJK>
     (?$(1_k(B . ?\x8E47) ;; <CJK>
     (?$(1_l(B . ?\x8F43) ;; <CJK>
     (?$(1_m(B . ?\x8F40) ;; <CJK>
     (?$(1_n(B . ?\x9085) ;; <CJK>
     (?$(1_o(B . ?\x907E) ;; <CJK>
     (?$(1_p(B . ?\x9138) ;; <CJK>
     (?$(1_q(B . ?\x919A) ;; <CJK>
     (?$(1_r(B . ?\x91A2) ;; <CJK>
     (?$(1_s(B . ?\x919B) ;; <CJK>
     (?$(1_t(B . ?\x9199) ;; <CJK>
     (?$(1_u(B . ?\x919F) ;; <CJK>
     (?$(1_v(B . ?\x91A1) ;; <CJK>
     (?$(1_w(B . ?\x919D) ;; <CJK>
     (?$(1_x(B . ?\x91A0) ;; <CJK>
     (?$(1_y(B . ?\x93A1) ;; <CJK>
     (?$(1_z(B . ?\x9383) ;; <CJK>
     (?$(1_{(B . ?\x93AF) ;; <CJK>
     (?$(1_|(B . ?\x9364) ;; <CJK>
     (?$(1_}(B . ?\x9356) ;; <CJK>
     (?$(1_~(B . ?\x9347) ;; <CJK>
     (?$(1`!(B . ?\x937C) ;; <CJK>
     (?$(1`"(B . ?\x9358) ;; <CJK>
     (?$(1`#(B . ?\x935C) ;; <CJK>
     (?$(1`$(B . ?\x9376) ;; <CJK>
     (?$(1`%(B . ?\x9349) ;; <CJK>
     (?$(1`&(B . ?\x9350) ;; <CJK>
     (?$(1`'(B . ?\x9351) ;; <CJK>
     (?$(1`((B . ?\x9360) ;; <CJK>
     (?$(1`)(B . ?\x936D) ;; <CJK>
     (?$(1`*(B . ?\x938F) ;; <CJK>
     (?$(1`+(B . ?\x934C) ;; <CJK>
     (?$(1`,(B . ?\x936A) ;; <CJK>
     (?$(1`-(B . ?\x9379) ;; <CJK>
     (?$(1`.(B . ?\x9357) ;; <CJK>
     (?$(1`/(B . ?\x9355) ;; <CJK>
     (?$(1`0(B . ?\x9352) ;; <CJK>
     (?$(1`1(B . ?\x934F) ;; <CJK>
     (?$(1`2(B . ?\x9371) ;; <CJK>
     (?$(1`3(B . ?\x9377) ;; <CJK>
     (?$(1`4(B . ?\x937B) ;; <CJK>
     (?$(1`5(B . ?\x9361) ;; <CJK>
     (?$(1`6(B . ?\x935E) ;; <CJK>
     (?$(1`7(B . ?\x9363) ;; <CJK>
     (?$(1`8(B . ?\x9367) ;; <CJK>
     (?$(1`9(B . ?\x9380) ;; <CJK>
     (?$(1`:(B . ?\x934E) ;; <CJK>
     (?$(1`;(B . ?\x9359) ;; <CJK>
     (?$(1`<(B . ?\x95C7) ;; <CJK>
     (?$(1`=(B . ?\x95C0) ;; <CJK>
     (?$(1`>(B . ?\x95C9) ;; <CJK>
     (?$(1`?(B . ?\x95C3) ;; <CJK>
     (?$(1`@(B . ?\x95C5) ;; <CJK>
     (?$(1`A(B . ?\x95B7) ;; <CJK>
     (?$(1`B(B . ?\x96AE) ;; <CJK>
     (?$(1`C(B . ?\x96B0) ;; <CJK>
     (?$(1`D(B . ?\x96AC) ;; <CJK>
     (?$(1`E(B . ?\x9720) ;; <CJK>
     (?$(1`F(B . ?\x971F) ;; <CJK>
     (?$(1`G(B . ?\x9718) ;; <CJK>
     (?$(1`H(B . ?\x971D) ;; <CJK>
     (?$(1`I(B . ?\x9719) ;; <CJK>
     (?$(1`J(B . ?\x979A) ;; <CJK>
     (?$(1`K(B . ?\x97A1) ;; <CJK>
     (?$(1`L(B . ?\x979C) ;; <CJK>
     (?$(1`M(B . ?\x979E) ;; <CJK>
     (?$(1`N(B . ?\x979D) ;; <CJK>
     (?$(1`O(B . ?\x97D5) ;; <CJK>
     (?$(1`P(B . ?\x97D4) ;; <CJK>
     (?$(1`Q(B . ?\x97F1) ;; <CJK>
     (?$(1`R(B . ?\x9841) ;; <CJK>
     (?$(1`S(B . ?\x9844) ;; <CJK>
     (?$(1`T(B . ?\x984A) ;; <CJK>
     (?$(1`U(B . ?\x9849) ;; <CJK>
     (?$(1`V(B . ?\x9845) ;; <CJK>
     (?$(1`W(B . ?\x9843) ;; <CJK>
     (?$(1`X(B . ?\x9925) ;; <CJK>
     (?$(1`Y(B . ?\x992B) ;; <CJK>
     (?$(1`Z(B . ?\x992C) ;; <CJK>
     (?$(1`[(B . ?\x992A) ;; <CJK>
     (?$(1`\(B . ?\x9933) ;; <CJK>
     (?$(1`](B . ?\x9932) ;; <CJK>
     (?$(1`^(B . ?\x992F) ;; <CJK>
     (?$(1`_(B . ?\x992D) ;; <CJK>
     (?$(1``(B . ?\x9931) ;; <CJK>
     (?$(1`a(B . ?\x9930) ;; <CJK>
     (?$(1`b(B . ?\x9998) ;; <CJK>
     (?$(1`c(B . ?\x99A3) ;; <CJK>
     (?$(1`d(B . ?\x99A1) ;; <CJK>
     (?$(1`e(B . ?\x9A02) ;; <CJK>
     (?$(1`f(B . ?\x99FA) ;; <CJK>
     (?$(1`g(B . ?\x99F4) ;; <CJK>
     (?$(1`h(B . ?\x99F7) ;; <CJK>
     (?$(1`i(B . ?\x99F9) ;; <CJK>
     (?$(1`j(B . ?\x99F8) ;; <CJK>
     (?$(1`k(B . ?\x99F6) ;; <CJK>
     (?$(1`l(B . ?\x99FB) ;; <CJK>
     (?$(1`m(B . ?\x99FD) ;; <CJK>
     (?$(1`n(B . ?\x99FE) ;; <CJK>
     (?$(1`o(B . ?\x99FC) ;; <CJK>
     (?$(1`p(B . ?\x9A03) ;; <CJK>
     (?$(1`q(B . ?\x9ABE) ;; <CJK>
     (?$(1`r(B . ?\x9AFE) ;; <CJK>
     (?$(1`s(B . ?\x9AFD) ;; <CJK>
     (?$(1`t(B . ?\x9B01) ;; <CJK>
     (?$(1`u(B . ?\x9AFC) ;; <CJK>
     (?$(1`v(B . ?\x9B48) ;; <CJK>
     (?$(1`w(B . ?\x9B9A) ;; <CJK>
     (?$(1`x(B . ?\x9BA8) ;; <CJK>
     (?$(1`y(B . ?\x9B9E) ;; <CJK>
     (?$(1`z(B . ?\x9B9B) ;; <CJK>
     (?$(1`{(B . ?\x9BA6) ;; <CJK>
     (?$(1`|(B . ?\x9BA1) ;; <CJK>
     (?$(1`}(B . ?\x9BA5) ;; <CJK>
     (?$(1`~(B . ?\x9BA4) ;; <CJK>
     (?$(1a!(B . ?\x9B86) ;; <CJK>
     (?$(1a"(B . ?\x9BA2) ;; <CJK>
     (?$(1a#(B . ?\x9BA0) ;; <CJK>
     (?$(1a$(B . ?\x9BAF) ;; <CJK>
     (?$(1a%(B . ?\x9D33) ;; <CJK>
     (?$(1a&(B . ?\x9D41) ;; <CJK>
     (?$(1a'(B . ?\x9D67) ;; <CJK>
     (?$(1a((B . ?\x9D36) ;; <CJK>
     (?$(1a)(B . ?\x9D2E) ;; <CJK>
     (?$(1a*(B . ?\x9D2F) ;; <CJK>
     (?$(1a+(B . ?\x9D31) ;; <CJK>
     (?$(1a,(B . ?\x9D38) ;; <CJK>
     (?$(1a-(B . ?\x9D30) ;; <CJK>
     (?$(1a.(B . ?\x9D45) ;; <CJK>
     (?$(1a/(B . ?\x9D42) ;; <CJK>
     (?$(1a0(B . ?\x9D43) ;; <CJK>
     (?$(1a1(B . ?\x9D3E) ;; <CJK>
     (?$(1a2(B . ?\x9D37) ;; <CJK>
     (?$(1a3(B . ?\x9D40) ;; <CJK>
     (?$(1a4(B . ?\x9D3D) ;; <CJK>
     (?$(1a5(B . ?\x7FF5) ;; <CJK>
     (?$(1a6(B . ?\x9D2D) ;; <CJK>
     (?$(1a7(B . ?\x9E8A) ;; <CJK>
     (?$(1a8(B . ?\x9E89) ;; <CJK>
     (?$(1a9(B . ?\x9E8D) ;; <CJK>
     (?$(1a:(B . ?\x9EB0) ;; <CJK>
     (?$(1a;(B . ?\x9EC8) ;; <CJK>
     (?$(1a<(B . ?\x9EDA) ;; <CJK>
     (?$(1a=(B . ?\x9EFB) ;; <CJK>
     (?$(1a>(B . ?\x9EFF) ;; <CJK>
     (?$(1a?(B . ?\x9F24) ;; <CJK>
     (?$(1a@(B . ?\x9F23) ;; <CJK>
     (?$(1aA(B . ?\x9F22) ;; <CJK>
     (?$(1aB(B . ?\x9F54) ;; <CJK>
     (?$(1aC(B . ?\x9FA0) ;; <CJK>
     (?$(1aD(B . ?\x5131) ;; <CJK>
     (?$(1aE(B . ?\x512D) ;; <CJK>
     (?$(1aF(B . ?\x512E) ;; <CJK>
     (?$(1aG(B . ?\x5698) ;; <CJK>
     (?$(1aH(B . ?\x569C) ;; <CJK>
     (?$(1aI(B . ?\x5697) ;; <CJK>
     (?$(1aJ(B . ?\x569A) ;; <CJK>
     (?$(1aK(B . ?\x569D) ;; <CJK>
     (?$(1aL(B . ?\x5699) ;; <CJK>
     (?$(1aM(B . ?\x5970) ;; <CJK>
     (?$(1aN(B . ?\x5B3C) ;; <CJK>
     (?$(1aO(B . ?\x5C69) ;; <CJK>
     (?$(1aP(B . ?\x5C6A) ;; <CJK>
     (?$(1aQ(B . ?\x5DC0) ;; <CJK>
     (?$(1aR(B . ?\x5E6D) ;; <CJK>
     (?$(1aS(B . ?\x5E6E) ;; <CJK>
     (?$(1aT(B . ?\x61D8) ;; <CJK>
     (?$(1aU(B . ?\x61DF) ;; <CJK>
     (?$(1aV(B . ?\x61ED) ;; <CJK>
     (?$(1aW(B . ?\x61EE) ;; <CJK>
     (?$(1aX(B . ?\x61F1) ;; <CJK>
     (?$(1aY(B . ?\x61EA) ;; <CJK>
     (?$(1aZ(B . ?\x61F0) ;; <CJK>
     (?$(1a[(B . ?\x61EB) ;; <CJK>
     (?$(1a\(B . ?\x61D6) ;; <CJK>
     (?$(1a](B . ?\x61E9) ;; <CJK>
     (?$(1a^(B . ?\x64FF) ;; <CJK>
     (?$(1a_(B . ?\x6504) ;; <CJK>
     (?$(1a`(B . ?\x64FD) ;; <CJK>
     (?$(1aa(B . ?\x64F8) ;; <CJK>
     (?$(1ab(B . ?\x6501) ;; <CJK>
     (?$(1ac(B . ?\x6503) ;; <CJK>
     (?$(1ad(B . ?\x64FC) ;; <CJK>
     (?$(1ae(B . ?\x6594) ;; <CJK>
     (?$(1af(B . ?\x65DB) ;; <CJK>
     (?$(1ag(B . ?\x66DA) ;; <CJK>
     (?$(1ah(B . ?\x66DB) ;; <CJK>
     (?$(1ai(B . ?\x66D8) ;; <CJK>
     (?$(1aj(B . ?\x6AC5) ;; <CJK>
     (?$(1ak(B . ?\x6AB9) ;; <CJK>
     (?$(1al(B . ?\x6ABD) ;; <CJK>
     (?$(1am(B . ?\x6AE1) ;; <CJK>
     (?$(1an(B . ?\x6AC6) ;; <CJK>
     (?$(1ao(B . ?\x6ABA) ;; <CJK>
     (?$(1ap(B . ?\x6AB6) ;; <CJK>
     (?$(1aq(B . ?\x6AB7) ;; <CJK>
     (?$(1ar(B . ?\x6AC7) ;; <CJK>
     (?$(1as(B . ?\x6AB4) ;; <CJK>
     (?$(1at(B . ?\x6AAD) ;; <CJK>
     (?$(1au(B . ?\x6B5E) ;; <CJK>
     (?$(1av(B . ?\x6BC9) ;; <CJK>
     (?$(1aw(B . ?\x6C0B) ;; <CJK>
     (?$(1ax(B . ?\x7007) ;; <CJK>
     (?$(1ay(B . ?\x700C) ;; <CJK>
     (?$(1az(B . ?\x700D) ;; <CJK>
     (?$(1a{(B . ?\x7001) ;; <CJK>
     (?$(1a|(B . ?\x7005) ;; <CJK>
     (?$(1a}(B . ?\x7014) ;; <CJK>
     (?$(1a~(B . ?\x700E) ;; <CJK>
     (?$(1b!(B . ?\x6FFF) ;; <CJK>
     (?$(1b"(B . ?\x7000) ;; <CJK>
     (?$(1b#(B . ?\x6FFB) ;; <CJK>
     (?$(1b$(B . ?\x7026) ;; <CJK>
     (?$(1b%(B . ?\x6FFC) ;; <CJK>
     (?$(1b&(B . ?\x6FF7) ;; <CJK>
     (?$(1b'(B . ?\x700A) ;; <CJK>
     (?$(1b((B . ?\x7201) ;; <CJK>
     (?$(1b)(B . ?\x71FF) ;; <CJK>
     (?$(1b*(B . ?\x71F9) ;; <CJK>
     (?$(1b+(B . ?\x7203) ;; <CJK>
     (?$(1b,(B . ?\x71FD) ;; <CJK>
     (?$(1b-(B . ?\x7376) ;; <CJK>
     (?$(1b.(B . ?\x74B8) ;; <CJK>
     (?$(1b/(B . ?\x74C0) ;; <CJK>
     (?$(1b0(B . ?\x74B5) ;; <CJK>
     (?$(1b1(B . ?\x74C1) ;; <CJK>
     (?$(1b2(B . ?\x74BE) ;; <CJK>
     (?$(1b3(B . ?\x74B6) ;; <CJK>
     (?$(1b4(B . ?\x74BB) ;; <CJK>
     (?$(1b5(B . ?\x74C2) ;; <CJK>
     (?$(1b6(B . ?\x7514) ;; <CJK>
     (?$(1b7(B . ?\x7513) ;; <CJK>
     (?$(1b8(B . ?\x765C) ;; <CJK>
     (?$(1b9(B . ?\x7664) ;; <CJK>
     (?$(1b:(B . ?\x7659) ;; <CJK>
     (?$(1b;(B . ?\x7650) ;; <CJK>
     (?$(1b<(B . ?\x7653) ;; <CJK>
     (?$(1b=(B . ?\x7657) ;; <CJK>
     (?$(1b>(B . ?\x765A) ;; <CJK>
     (?$(1b?(B . ?\x76A6) ;; <CJK>
     (?$(1b@(B . ?\x76BD) ;; <CJK>
     (?$(1bA(B . ?\x76EC) ;; <CJK>
     (?$(1bB(B . ?\x77C2) ;; <CJK>
     (?$(1bC(B . ?\x77BA) ;; <CJK>
     (?$(1bD(B . ?\x78FF) ;; <CJK>
     (?$(1bE(B . ?\x790C) ;; <CJK>
     (?$(1bF(B . ?\x7913) ;; <CJK>
     (?$(1bG(B . ?\x7914) ;; <CJK>
     (?$(1bH(B . ?\x7909) ;; <CJK>
     (?$(1bI(B . ?\x7910) ;; <CJK>
     (?$(1bJ(B . ?\x7912) ;; <CJK>
     (?$(1bK(B . ?\x7911) ;; <CJK>
     (?$(1bL(B . ?\x79AD) ;; <CJK>
     (?$(1bM(B . ?\x79AC) ;; <CJK>
     (?$(1bN(B . ?\x7A5F) ;; <CJK>
     (?$(1bO(B . ?\x7C1C) ;; <CJK>
     (?$(1bP(B . ?\x7C29) ;; <CJK>
     (?$(1bQ(B . ?\x7C19) ;; <CJK>
     (?$(1bR(B . ?\x7C20) ;; <CJK>
     (?$(1bS(B . ?\x7C1F) ;; <CJK>
     (?$(1bT(B . ?\x7C2D) ;; <CJK>
     (?$(1bU(B . ?\x7C1D) ;; <CJK>
     (?$(1bV(B . ?\x7C26) ;; <CJK>
     (?$(1bW(B . ?\x7C28) ;; <CJK>
     (?$(1bX(B . ?\x7C22) ;; <CJK>
     (?$(1bY(B . ?\x7C25) ;; <CJK>
     (?$(1bZ(B . ?\x7C30) ;; <CJK>
     (?$(1b[(B . ?\x7E5C) ;; <CJK>
     (?$(1b\(B . ?\x7E50) ;; <CJK>
     (?$(1b](B . ?\x7E56) ;; <CJK>
     (?$(1b^(B . ?\x7E63) ;; <CJK>
     (?$(1b_(B . ?\x7E58) ;; <CJK>
     (?$(1b`(B . ?\x7E62) ;; <CJK>
     (?$(1ba(B . ?\x7E5F) ;; <CJK>
     (?$(1bb(B . ?\x7E51) ;; <CJK>
     (?$(1bc(B . ?\x7E60) ;; <CJK>
     (?$(1bd(B . ?\x7E57) ;; <CJK>
     (?$(1be(B . ?\x7E53) ;; <CJK>
     (?$(1bf(B . ?\x7FB5) ;; <CJK>
     (?$(1bg(B . ?\x7FB3) ;; <CJK>
     (?$(1bh(B . ?\x7FF7) ;; <CJK>
     (?$(1bi(B . ?\x7FF8) ;; <CJK>
     (?$(1bj(B . ?\x8075) ;; <CJK>
     (?$(1bk(B . ?\x81D1) ;; <CJK>
     (?$(1bl(B . ?\x81D2) ;; <CJK>
     (?$(1bm(B . ?\x81D0) ;; <CJK>
     (?$(1bn(B . ?\x825F) ;; <CJK>
     (?$(1bo(B . ?\x825E) ;; <CJK>
     (?$(1bp(B . ?\x85B4) ;; <CJK>
     (?$(1bq(B . ?\x85C6) ;; <CJK>
     (?$(1br(B . ?\x85C0) ;; <CJK>
     (?$(1bs(B . ?\x85C3) ;; <CJK>
     (?$(1bt(B . ?\x85C2) ;; <CJK>
     (?$(1bu(B . ?\x85B3) ;; <CJK>
     (?$(1bv(B . ?\x85B5) ;; <CJK>
     (?$(1bw(B . ?\x85BD) ;; <CJK>
     (?$(1bx(B . ?\x85C7) ;; <CJK>
     (?$(1by(B . ?\x85C4) ;; <CJK>
     (?$(1bz(B . ?\x85BF) ;; <CJK>
     (?$(1b{(B . ?\x85CB) ;; <CJK>
     (?$(1b|(B . ?\x85CE) ;; <CJK>
     (?$(1b}(B . ?\x85C8) ;; <CJK>
     (?$(1b~(B . ?\x85C5) ;; <CJK>
     (?$(1c!(B . ?\x85B1) ;; <CJK>
     (?$(1c"(B . ?\x85B6) ;; <CJK>
     (?$(1c#(B . ?\x85D2) ;; <CJK>
     (?$(1c$(B . ?\x8624) ;; <CJK>
     (?$(1c%(B . ?\x85B8) ;; <CJK>
     (?$(1c&(B . ?\x85B7) ;; <CJK>
     (?$(1c'(B . ?\x85BE) ;; <CJK>
     (?$(1c((B . ?\x8669) ;; <CJK>
     (?$(1c)(B . ?\x87E7) ;; <CJK>
     (?$(1c*(B . ?\x87E6) ;; <CJK>
     (?$(1c+(B . ?\x87E2) ;; <CJK>
     (?$(1c,(B . ?\x87DB) ;; <CJK>
     (?$(1c-(B . ?\x87EB) ;; <CJK>
     (?$(1c.(B . ?\x87EA) ;; <CJK>
     (?$(1c/(B . ?\x87E5) ;; <CJK>
     (?$(1c0(B . ?\x87DF) ;; <CJK>
     (?$(1c1(B . ?\x87F3) ;; <CJK>
     (?$(1c2(B . ?\x87E4) ;; <CJK>
     (?$(1c3(B . ?\x87D4) ;; <CJK>
     (?$(1c4(B . ?\x87DC) ;; <CJK>
     (?$(1c5(B . ?\x87D3) ;; <CJK>
     (?$(1c6(B . ?\x87ED) ;; <CJK>
     (?$(1c7(B . ?\x87D8) ;; <CJK>
     (?$(1c8(B . ?\x87E3) ;; <CJK>
     (?$(1c9(B . ?\x87A4) ;; <CJK>
     (?$(1c:(B . ?\x87D7) ;; <CJK>
     (?$(1c;(B . ?\x87D9) ;; <CJK>
     (?$(1c<(B . ?\x8801) ;; <CJK>
     (?$(1c=(B . ?\x87F4) ;; <CJK>
     (?$(1c>(B . ?\x87E8) ;; <CJK>
     (?$(1c?(B . ?\x87DD) ;; <CJK>
     (?$(1c@(B . ?\x8953) ;; <CJK>
     (?$(1cA(B . ?\x894B) ;; <CJK>
     (?$(1cB(B . ?\x894F) ;; <CJK>
     (?$(1cC(B . ?\x894C) ;; <CJK>
     (?$(1cD(B . ?\x8946) ;; <CJK>
     (?$(1cE(B . ?\x8950) ;; <CJK>
     (?$(1cF(B . ?\x8951) ;; <CJK>
     (?$(1cG(B . ?\x8949) ;; <CJK>
     (?$(1cH(B . ?\x8B2A) ;; <CJK>
     (?$(1cI(B . ?\x8B27) ;; <CJK>
     (?$(1cJ(B . ?\x8B23) ;; <CJK>
     (?$(1cK(B . ?\x8B33) ;; <CJK>
     (?$(1cL(B . ?\x8B30) ;; <CJK>
     (?$(1cM(B . ?\x8B35) ;; <CJK>
     (?$(1cN(B . ?\x8B47) ;; <CJK>
     (?$(1cO(B . ?\x8B2F) ;; <CJK>
     (?$(1cP(B . ?\x8B3C) ;; <CJK>
     (?$(1cQ(B . ?\x8B3E) ;; <CJK>
     (?$(1cR(B . ?\x8B31) ;; <CJK>
     (?$(1cS(B . ?\x8B25) ;; <CJK>
     (?$(1cT(B . ?\x8B37) ;; <CJK>
     (?$(1cU(B . ?\x8B26) ;; <CJK>
     (?$(1cV(B . ?\x8B36) ;; <CJK>
     (?$(1cW(B . ?\x8B2E) ;; <CJK>
     (?$(1cX(B . ?\x8B24) ;; <CJK>
     (?$(1cY(B . ?\x8B3B) ;; <CJK>
     (?$(1cZ(B . ?\x8B3D) ;; <CJK>
     (?$(1c[(B . ?\x8B3A) ;; <CJK>
     (?$(1c\(B . ?\x8C42) ;; <CJK>
     (?$(1c](B . ?\x8C75) ;; <CJK>
     (?$(1c^(B . ?\x8C99) ;; <CJK>
     (?$(1c_(B . ?\x8C98) ;; <CJK>
     (?$(1c`(B . ?\x8C97) ;; <CJK>
     (?$(1ca(B . ?\x8CFE) ;; <CJK>
     (?$(1cb(B . ?\x8D04) ;; <CJK>
     (?$(1cc(B . ?\x8D02) ;; <CJK>
     (?$(1cd(B . ?\x8D00) ;; <CJK>
     (?$(1ce(B . ?\x8E5C) ;; <CJK>
     (?$(1cf(B . ?\x8E62) ;; <CJK>
     (?$(1cg(B . ?\x8E60) ;; <CJK>
     (?$(1ch(B . ?\x8E57) ;; <CJK>
     (?$(1ci(B . ?\x8E56) ;; <CJK>
     (?$(1cj(B . ?\x8E5E) ;; <CJK>
     (?$(1ck(B . ?\x8E65) ;; <CJK>
     (?$(1cl(B . ?\x8E67) ;; <CJK>
     (?$(1cm(B . ?\x8E5B) ;; <CJK>
     (?$(1cn(B . ?\x8E5A) ;; <CJK>
     (?$(1co(B . ?\x8E61) ;; <CJK>
     (?$(1cp(B . ?\x8E5D) ;; <CJK>
     (?$(1cq(B . ?\x8E69) ;; <CJK>
     (?$(1cr(B . ?\x8E54) ;; <CJK>
     (?$(1cs(B . ?\x8F46) ;; <CJK>
     (?$(1ct(B . ?\x8F47) ;; <CJK>
     (?$(1cu(B . ?\x8F48) ;; <CJK>
     (?$(1cv(B . ?\x8F4B) ;; <CJK>
     (?$(1cw(B . ?\x9128) ;; <CJK>
     (?$(1cx(B . ?\x913A) ;; <CJK>
     (?$(1cy(B . ?\x913B) ;; <CJK>
     (?$(1cz(B . ?\x913E) ;; <CJK>
     (?$(1c{(B . ?\x91A8) ;; <CJK>
     (?$(1c|(B . ?\x91A5) ;; <CJK>
     (?$(1c}(B . ?\x91A7) ;; <CJK>
     (?$(1c~(B . ?\x91AF) ;; <CJK>
     (?$(1d!(B . ?\x91AA) ;; <CJK>
     (?$(1d"(B . ?\x93B5) ;; <CJK>
     (?$(1d#(B . ?\x938C) ;; <CJK>
     (?$(1d$(B . ?\x9392) ;; <CJK>
     (?$(1d%(B . ?\x93B7) ;; <CJK>
     (?$(1d&(B . ?\x939B) ;; <CJK>
     (?$(1d'(B . ?\x939D) ;; <CJK>
     (?$(1d((B . ?\x9389) ;; <CJK>
     (?$(1d)(B . ?\x93A7) ;; <CJK>
     (?$(1d*(B . ?\x938E) ;; <CJK>
     (?$(1d+(B . ?\x93AA) ;; <CJK>
     (?$(1d,(B . ?\x939E) ;; <CJK>
     (?$(1d-(B . ?\x93A6) ;; <CJK>
     (?$(1d.(B . ?\x9395) ;; <CJK>
     (?$(1d/(B . ?\x9388) ;; <CJK>
     (?$(1d0(B . ?\x9399) ;; <CJK>
     (?$(1d1(B . ?\x939F) ;; <CJK>
     (?$(1d2(B . ?\x938D) ;; <CJK>
     (?$(1d3(B . ?\x93B1) ;; <CJK>
     (?$(1d4(B . ?\x9391) ;; <CJK>
     (?$(1d5(B . ?\x93B2) ;; <CJK>
     (?$(1d6(B . ?\x93A4) ;; <CJK>
     (?$(1d7(B . ?\x93A8) ;; <CJK>
     (?$(1d8(B . ?\x93B4) ;; <CJK>
     (?$(1d9(B . ?\x93A3) ;; <CJK>
     (?$(1d:(B . ?\x93A5) ;; <CJK>
     (?$(1d;(B . ?\x95D2) ;; <CJK>
     (?$(1d<(B . ?\x95D3) ;; <CJK>
     (?$(1d=(B . ?\x95D1) ;; <CJK>
     (?$(1d>(B . ?\x96B3) ;; <CJK>
     (?$(1d?(B . ?\x96D7) ;; <CJK>
     (?$(1d@(B . ?\x96DA) ;; <CJK>
     (?$(1dA(B . ?\x5DC2) ;; <CJK>
     (?$(1dB(B . ?\x96DF) ;; <CJK>
     (?$(1dC(B . ?\x96D8) ;; <CJK>
     (?$(1dD(B . ?\x96DD) ;; <CJK>
     (?$(1dE(B . ?\x9723) ;; <CJK>
     (?$(1dF(B . ?\x9722) ;; <CJK>
     (?$(1dG(B . ?\x9725) ;; <CJK>
     (?$(1dH(B . ?\x97AC) ;; <CJK>
     (?$(1dI(B . ?\x97AE) ;; <CJK>
     (?$(1dJ(B . ?\x97A8) ;; <CJK>
     (?$(1dK(B . ?\x97AB) ;; <CJK>
     (?$(1dL(B . ?\x97A4) ;; <CJK>
     (?$(1dM(B . ?\x97AA) ;; <CJK>
     (?$(1dN(B . ?\x97A2) ;; <CJK>
     (?$(1dO(B . ?\x97A5) ;; <CJK>
     (?$(1dP(B . ?\x97D7) ;; <CJK>
     (?$(1dQ(B . ?\x97D9) ;; <CJK>
     (?$(1dR(B . ?\x97D6) ;; <CJK>
     (?$(1dS(B . ?\x97D8) ;; <CJK>
     (?$(1dT(B . ?\x97FA) ;; <CJK>
     (?$(1dU(B . ?\x9850) ;; <CJK>
     (?$(1dV(B . ?\x9851) ;; <CJK>
     (?$(1dW(B . ?\x9852) ;; <CJK>
     (?$(1dX(B . ?\x98B8) ;; <CJK>
     (?$(1dY(B . ?\x9941) ;; <CJK>
     (?$(1dZ(B . ?\x993C) ;; <CJK>
     (?$(1d[(B . ?\x993A) ;; <CJK>
     (?$(1d\(B . ?\x9A0F) ;; <CJK>
     (?$(1d](B . ?\x9A0B) ;; <CJK>
     (?$(1d^(B . ?\x9A09) ;; <CJK>
     (?$(1d_(B . ?\x9A0D) ;; <CJK>
     (?$(1d`(B . ?\x9A04) ;; <CJK>
     (?$(1da(B . ?\x9A11) ;; <CJK>
     (?$(1db(B . ?\x9A0A) ;; <CJK>
     (?$(1dc(B . ?\x9A05) ;; <CJK>
     (?$(1dd(B . ?\x9A07) ;; <CJK>
     (?$(1de(B . ?\x9A06) ;; <CJK>
     (?$(1df(B . ?\x9AC0) ;; <CJK>
     (?$(1dg(B . ?\x9ADC) ;; <CJK>
     (?$(1dh(B . ?\x9B08) ;; <CJK>
     (?$(1di(B . ?\x9B04) ;; <CJK>
     (?$(1dj(B . ?\x9B05) ;; <CJK>
     (?$(1dk(B . ?\x9B29) ;; <CJK>
     (?$(1dl(B . ?\x9B35) ;; <CJK>
     (?$(1dm(B . ?\x9B4A) ;; <CJK>
     (?$(1dn(B . ?\x9B4C) ;; <CJK>
     (?$(1do(B . ?\x9B4B) ;; <CJK>
     (?$(1dp(B . ?\x9BC7) ;; <CJK>
     (?$(1dq(B . ?\x9BC6) ;; <CJK>
     (?$(1dr(B . ?\x9BC3) ;; <CJK>
     (?$(1ds(B . ?\x9BBF) ;; <CJK>
     (?$(1dt(B . ?\x9BC1) ;; <CJK>
     (?$(1du(B . ?\x9BB5) ;; <CJK>
     (?$(1dv(B . ?\x9BB8) ;; <CJK>
     (?$(1dw(B . ?\x9BD3) ;; <CJK>
     (?$(1dx(B . ?\x9BB6) ;; <CJK>
     (?$(1dy(B . ?\x9BC4) ;; <CJK>
     (?$(1dz(B . ?\x9BB9) ;; <CJK>
     (?$(1d{(B . ?\x9BBD) ;; <CJK>
     (?$(1d|(B . ?\x9D5C) ;; <CJK>
     (?$(1d}(B . ?\x9D53) ;; <CJK>
     (?$(1d~(B . ?\x9D4F) ;; <CJK>
     (?$(1e!(B . ?\x9D4A) ;; <CJK>
     (?$(1e"(B . ?\x9D5B) ;; <CJK>
     (?$(1e#(B . ?\x9D4B) ;; <CJK>
     (?$(1e$(B . ?\x9D59) ;; <CJK>
     (?$(1e%(B . ?\x9D56) ;; <CJK>
     (?$(1e&(B . ?\x9D4C) ;; <CJK>
     (?$(1e'(B . ?\x9D57) ;; <CJK>
     (?$(1e((B . ?\x9D52) ;; <CJK>
     (?$(1e)(B . ?\x9D54) ;; <CJK>
     (?$(1e*(B . ?\x9D5F) ;; <CJK>
     (?$(1e+(B . ?\x9D58) ;; <CJK>
     (?$(1e,(B . ?\x9D5A) ;; <CJK>
     (?$(1e-(B . ?\x9E8E) ;; <CJK>
     (?$(1e.(B . ?\x9E8C) ;; <CJK>
     (?$(1e/(B . ?\x9EDF) ;; <CJK>
     (?$(1e0(B . ?\x9F01) ;; <CJK>
     (?$(1e1(B . ?\x9F00) ;; <CJK>
     (?$(1e2(B . ?\x9F16) ;; <CJK>
     (?$(1e3(B . ?\x9F25) ;; <CJK>
     (?$(1e4(B . ?\x9F2B) ;; <CJK>
     (?$(1e5(B . ?\x9F2A) ;; <CJK>
     (?$(1e6(B . ?\x9F29) ;; <CJK>
     (?$(1e7(B . ?\x9F28) ;; <CJK>
     (?$(1e8(B . ?\x9F4C) ;; <CJK>
     (?$(1e9(B . ?\x9F55) ;; <CJK>
     (?$(1e:(B . ?\x5134) ;; <CJK>
     (?$(1e;(B . ?\x5135) ;; <CJK>
     (?$(1e<(B . ?\x5296) ;; <CJK>
     (?$(1e=(B . ?\x52F7) ;; <CJK>
     (?$(1e>(B . ?\x53B4) ;; <CJK>
     (?$(1e?(B . ?\x56AB) ;; <CJK>
     (?$(1e@(B . ?\x56AD) ;; <CJK>
     (?$(1eA(B . ?\x56A6) ;; <CJK>
     (?$(1eB(B . ?\x56A7) ;; <CJK>
     (?$(1eC(B . ?\x56AA) ;; <CJK>
     (?$(1eD(B . ?\x56AC) ;; <CJK>
     (?$(1eE(B . ?\x58DA) ;; <CJK>
     (?$(1eF(B . ?\x58DD) ;; <CJK>
     (?$(1eG(B . ?\x58DB) ;; <CJK>
     (?$(1eH(B . ?\x5912) ;; <CJK>
     (?$(1eI(B . ?\x5B3D) ;; <CJK>
     (?$(1eJ(B . ?\x5B3E) ;; <CJK>
     (?$(1eK(B . ?\x5B3F) ;; <CJK>
     (?$(1eL(B . ?\x5DC3) ;; <CJK>
     (?$(1eM(B . ?\x5E70) ;; <CJK>
     (?$(1eN(B . ?\x5FBF) ;; <CJK>
     (?$(1eO(B . ?\x61FB) ;; <CJK>
     (?$(1eP(B . ?\x6507) ;; <CJK>
     (?$(1eQ(B . ?\x6510) ;; <CJK>
     (?$(1eR(B . ?\x650D) ;; <CJK>
     (?$(1eS(B . ?\x6509) ;; <CJK>
     (?$(1eT(B . ?\x650C) ;; <CJK>
     (?$(1eU(B . ?\x650E) ;; <CJK>
     (?$(1eV(B . ?\x6584) ;; <CJK>
     (?$(1eW(B . ?\x65DE) ;; <CJK>
     (?$(1eX(B . ?\x65DD) ;; <CJK>
     (?$(1eY(B . ?\x66DE) ;; <CJK>
     (?$(1eZ(B . ?\x6AE7) ;; <CJK>
     (?$(1e[(B . ?\x6AE0) ;; <CJK>
     (?$(1e\(B . ?\x6ACC) ;; <CJK>
     (?$(1e](B . ?\x6AD1) ;; <CJK>
     (?$(1e^(B . ?\x6AD9) ;; <CJK>
     (?$(1e_(B . ?\x6ACB) ;; <CJK>
     (?$(1e`(B . ?\x6ADF) ;; <CJK>
     (?$(1ea(B . ?\x6ADC) ;; <CJK>
     (?$(1eb(B . ?\x6AD0) ;; <CJK>
     (?$(1ec(B . ?\x6AEB) ;; <CJK>
     (?$(1ed(B . ?\x6ACF) ;; <CJK>
     (?$(1ee(B . ?\x6ACD) ;; <CJK>
     (?$(1ef(B . ?\x6ADE) ;; <CJK>
     (?$(1eg(B . ?\x6B60) ;; <CJK>
     (?$(1eh(B . ?\x6BB0) ;; <CJK>
     (?$(1ei(B . ?\x6C0C) ;; <CJK>
     (?$(1ej(B . ?\x7019) ;; <CJK>
     (?$(1ek(B . ?\x7027) ;; <CJK>
     (?$(1el(B . ?\x7020) ;; <CJK>
     (?$(1em(B . ?\x7016) ;; <CJK>
     (?$(1en(B . ?\x702B) ;; <CJK>
     (?$(1eo(B . ?\x7021) ;; <CJK>
     (?$(1ep(B . ?\x7022) ;; <CJK>
     (?$(1eq(B . ?\x7023) ;; <CJK>
     (?$(1er(B . ?\x7029) ;; <CJK>
     (?$(1es(B . ?\x7017) ;; <CJK>
     (?$(1et(B . ?\x7024) ;; <CJK>
     (?$(1eu(B . ?\x701C) ;; <CJK>
     (?$(1ev(B . ?\x702A) ;; <CJK>
     (?$(1ew(B . ?\x720C) ;; <CJK>
     (?$(1ex(B . ?\x720A) ;; <CJK>
     (?$(1ey(B . ?\x7207) ;; <CJK>
     (?$(1ez(B . ?\x7202) ;; <CJK>
     (?$(1e{(B . ?\x7205) ;; <CJK>
     (?$(1e|(B . ?\x72A5) ;; <CJK>
     (?$(1e}(B . ?\x72A6) ;; <CJK>
     (?$(1e~(B . ?\x72A4) ;; <CJK>
     (?$(1f!(B . ?\x72A3) ;; <CJK>
     (?$(1f"(B . ?\x72A1) ;; <CJK>
     (?$(1f#(B . ?\x74CB) ;; <CJK>
     (?$(1f$(B . ?\x74C5) ;; <CJK>
     (?$(1f%(B . ?\x74B7) ;; <CJK>
     (?$(1f&(B . ?\x74C3) ;; <CJK>
     (?$(1f'(B . ?\x7516) ;; <CJK>
     (?$(1f((B . ?\x7660) ;; <CJK>
     (?$(1f)(B . ?\x77C9) ;; <CJK>
     (?$(1f*(B . ?\x77CA) ;; <CJK>
     (?$(1f+(B . ?\x77C4) ;; <CJK>
     (?$(1f,(B . ?\x77F1) ;; <CJK>
     (?$(1f-(B . ?\x791D) ;; <CJK>
     (?$(1f.(B . ?\x791B) ;; <CJK>
     (?$(1f/(B . ?\x7921) ;; <CJK>
     (?$(1f0(B . ?\x791C) ;; <CJK>
     (?$(1f1(B . ?\x7917) ;; <CJK>
     (?$(1f2(B . ?\x791E) ;; <CJK>
     (?$(1f3(B . ?\x79B0) ;; <CJK>
     (?$(1f4(B . ?\x7A67) ;; <CJK>
     (?$(1f5(B . ?\x7A68) ;; <CJK>
     (?$(1f6(B . ?\x7C33) ;; <CJK>
     (?$(1f7(B . ?\x7C3C) ;; <CJK>
     (?$(1f8(B . ?\x7C39) ;; <CJK>
     (?$(1f9(B . ?\x7C2C) ;; <CJK>
     (?$(1f:(B . ?\x7C3B) ;; <CJK>
     (?$(1f;(B . ?\x7CEC) ;; <CJK>
     (?$(1f<(B . ?\x7CEA) ;; <CJK>
     (?$(1f=(B . ?\x7E76) ;; <CJK>
     (?$(1f>(B . ?\x7E75) ;; <CJK>
     (?$(1f?(B . ?\x7E78) ;; <CJK>
     (?$(1f@(B . ?\x7E70) ;; <CJK>
     (?$(1fA(B . ?\x7E77) ;; <CJK>
     (?$(1fB(B . ?\x7E6F) ;; <CJK>
     (?$(1fC(B . ?\x7E7A) ;; <CJK>
     (?$(1fD(B . ?\x7E72) ;; <CJK>
     (?$(1fE(B . ?\x7E74) ;; <CJK>
     (?$(1fF(B . ?\x7E68) ;; <CJK>
     (?$(1fG(B . ?\x7F4B) ;; <CJK>
     (?$(1fH(B . ?\x7F4A) ;; <CJK>
     (?$(1fI(B . ?\x7F83) ;; <CJK>
     (?$(1fJ(B . ?\x7F86) ;; <CJK>
     (?$(1fK(B . ?\x7FB7) ;; <CJK>
     (?$(1fL(B . ?\x7FFD) ;; <CJK>
     (?$(1fM(B . ?\x7FFE) ;; <CJK>
     (?$(1fN(B . ?\x8078) ;; <CJK>
     (?$(1fO(B . ?\x81D7) ;; <CJK>
     (?$(1fP(B . ?\x81D5) ;; <CJK>
     (?$(1fQ(B . ?\x8264) ;; <CJK>
     (?$(1fR(B . ?\x8261) ;; <CJK>
     (?$(1fS(B . ?\x8263) ;; <CJK>
     (?$(1fT(B . ?\x85EB) ;; <CJK>
     (?$(1fU(B . ?\x85F1) ;; <CJK>
     (?$(1fV(B . ?\x85ED) ;; <CJK>
     (?$(1fW(B . ?\x85D9) ;; <CJK>
     (?$(1fX(B . ?\x85E1) ;; <CJK>
     (?$(1fY(B . ?\x85E8) ;; <CJK>
     (?$(1fZ(B . ?\x85DA) ;; <CJK>
     (?$(1f[(B . ?\x85D7) ;; <CJK>
     (?$(1f\(B . ?\x85EC) ;; <CJK>
     (?$(1f](B . ?\x85F2) ;; <CJK>
     (?$(1f^(B . ?\x85F8) ;; <CJK>
     (?$(1f_(B . ?\x85D8) ;; <CJK>
     (?$(1f`(B . ?\x85DF) ;; <CJK>
     (?$(1fa(B . ?\x85E3) ;; <CJK>
     (?$(1fb(B . ?\x85DC) ;; <CJK>
     (?$(1fc(B . ?\x85D1) ;; <CJK>
     (?$(1fd(B . ?\x85F0) ;; <CJK>
     (?$(1fe(B . ?\x85E6) ;; <CJK>
     (?$(1ff(B . ?\x85EF) ;; <CJK>
     (?$(1fg(B . ?\x85DE) ;; <CJK>
     (?$(1fh(B . ?\x85E2) ;; <CJK>
     (?$(1fi(B . ?\x8800) ;; <CJK>
     (?$(1fj(B . ?\x87FA) ;; <CJK>
     (?$(1fk(B . ?\x8803) ;; <CJK>
     (?$(1fl(B . ?\x87F6) ;; <CJK>
     (?$(1fm(B . ?\x87F7) ;; <CJK>
     (?$(1fn(B . ?\x8809) ;; <CJK>
     (?$(1fo(B . ?\x880C) ;; <CJK>
     (?$(1fp(B . ?\x880B) ;; <CJK>
     (?$(1fq(B . ?\x8806) ;; <CJK>
     (?$(1fr(B . ?\x87FC) ;; <CJK>
     (?$(1fs(B . ?\x8808) ;; <CJK>
     (?$(1ft(B . ?\x87FF) ;; <CJK>
     (?$(1fu(B . ?\x880A) ;; <CJK>
     (?$(1fv(B . ?\x8802) ;; <CJK>
     (?$(1fw(B . ?\x8962) ;; <CJK>
     (?$(1fx(B . ?\x895A) ;; <CJK>
     (?$(1fy(B . ?\x895B) ;; <CJK>
     (?$(1fz(B . ?\x8957) ;; <CJK>
     (?$(1f{(B . ?\x8961) ;; <CJK>
     (?$(1f|(B . ?\x895C) ;; <CJK>
     (?$(1f}(B . ?\x8958) ;; <CJK>
     (?$(1f~(B . ?\x895D) ;; <CJK>
     (?$(1g!(B . ?\x8959) ;; <CJK>
     (?$(1g"(B . ?\x8988) ;; <CJK>
     (?$(1g#(B . ?\x89B7) ;; <CJK>
     (?$(1g$(B . ?\x89B6) ;; <CJK>
     (?$(1g%(B . ?\x89F6) ;; <CJK>
     (?$(1g&(B . ?\x8B50) ;; <CJK>
     (?$(1g'(B . ?\x8B48) ;; <CJK>
     (?$(1g((B . ?\x8B4A) ;; <CJK>
     (?$(1g)(B . ?\x8B40) ;; <CJK>
     (?$(1g*(B . ?\x8B53) ;; <CJK>
     (?$(1g+(B . ?\x8B56) ;; <CJK>
     (?$(1g,(B . ?\x8B54) ;; <CJK>
     (?$(1g-(B . ?\x8B4B) ;; <CJK>
     (?$(1g.(B . ?\x8B55) ;; <CJK>
     (?$(1g/(B . ?\x8B51) ;; <CJK>
     (?$(1g0(B . ?\x8B42) ;; <CJK>
     (?$(1g1(B . ?\x8B52) ;; <CJK>
     (?$(1g2(B . ?\x8B57) ;; <CJK>
     (?$(1g3(B . ?\x8C43) ;; <CJK>
     (?$(1g4(B . ?\x8C77) ;; <CJK>
     (?$(1g5(B . ?\x8C76) ;; <CJK>
     (?$(1g6(B . ?\x8C9A) ;; <CJK>
     (?$(1g7(B . ?\x8D06) ;; <CJK>
     (?$(1g8(B . ?\x8D07) ;; <CJK>
     (?$(1g9(B . ?\x8D09) ;; <CJK>
     (?$(1g:(B . ?\x8DAC) ;; <CJK>
     (?$(1g;(B . ?\x8DAA) ;; <CJK>
     (?$(1g<(B . ?\x8DAD) ;; <CJK>
     (?$(1g=(B . ?\x8DAB) ;; <CJK>
     (?$(1g>(B . ?\x8E6D) ;; <CJK>
     (?$(1g?(B . ?\x8E78) ;; <CJK>
     (?$(1g@(B . ?\x8E73) ;; <CJK>
     (?$(1gA(B . ?\x8E6A) ;; <CJK>
     (?$(1gB(B . ?\x8E6F) ;; <CJK>
     (?$(1gC(B . ?\x8E7B) ;; <CJK>
     (?$(1gD(B . ?\x8EC2) ;; <CJK>
     (?$(1gE(B . ?\x8F52) ;; <CJK>
     (?$(1gF(B . ?\x8F51) ;; <CJK>
     (?$(1gG(B . ?\x8F4F) ;; <CJK>
     (?$(1gH(B . ?\x8F50) ;; <CJK>
     (?$(1gI(B . ?\x8F53) ;; <CJK>
     (?$(1gJ(B . ?\x8FB4) ;; <CJK>
     (?$(1gK(B . ?\x9140) ;; <CJK>
     (?$(1gL(B . ?\x913F) ;; <CJK>
     (?$(1gM(B . ?\x91B0) ;; <CJK>
     (?$(1gN(B . ?\x91AD) ;; <CJK>
     (?$(1gO(B . ?\x93DE) ;; <CJK>
     (?$(1gP(B . ?\x93C7) ;; <CJK>
     (?$(1gQ(B . ?\x93CF) ;; <CJK>
     (?$(1gR(B . ?\x93C2) ;; <CJK>
     (?$(1gS(B . ?\x93DA) ;; <CJK>
     (?$(1gT(B . ?\x93D0) ;; <CJK>
     (?$(1gU(B . ?\x93F9) ;; <CJK>
     (?$(1gV(B . ?\x93EC) ;; <CJK>
     (?$(1gW(B . ?\x93CC) ;; <CJK>
     (?$(1gX(B . ?\x93D9) ;; <CJK>
     (?$(1gY(B . ?\x93A9) ;; <CJK>
     (?$(1gZ(B . ?\x93E6) ;; <CJK>
     (?$(1g[(B . ?\x93CA) ;; <CJK>
     (?$(1g\(B . ?\x93D4) ;; <CJK>
     (?$(1g](B . ?\x93EE) ;; <CJK>
     (?$(1g^(B . ?\x93E3) ;; <CJK>
     (?$(1g_(B . ?\x93D5) ;; <CJK>
     (?$(1g`(B . ?\x93C4) ;; <CJK>
     (?$(1ga(B . ?\x93CE) ;; <CJK>
     (?$(1gb(B . ?\x93C0) ;; <CJK>
     (?$(1gc(B . ?\x93D2) ;; <CJK>
     (?$(1gd(B . ?\x93E7) ;; <CJK>
     (?$(1ge(B . ?\x957D) ;; <CJK>
     (?$(1gf(B . ?\x95DA) ;; <CJK>
     (?$(1gg(B . ?\x95DB) ;; <CJK>
     (?$(1gh(B . ?\x96E1) ;; <CJK>
     (?$(1gi(B . ?\x9729) ;; <CJK>
     (?$(1gj(B . ?\x972B) ;; <CJK>
     (?$(1gk(B . ?\x972C) ;; <CJK>
     (?$(1gl(B . ?\x9728) ;; <CJK>
     (?$(1gm(B . ?\x9726) ;; <CJK>
     (?$(1gn(B . ?\x97B3) ;; <CJK>
     (?$(1go(B . ?\x97B7) ;; <CJK>
     (?$(1gp(B . ?\x97B6) ;; <CJK>
     (?$(1gq(B . ?\x97DD) ;; <CJK>
     (?$(1gr(B . ?\x97DE) ;; <CJK>
     (?$(1gs(B . ?\x97DF) ;; <CJK>
     (?$(1gt(B . ?\x985C) ;; <CJK>
     (?$(1gu(B . ?\x9859) ;; <CJK>
     (?$(1gv(B . ?\x985D) ;; <CJK>
     (?$(1gw(B . ?\x9857) ;; <CJK>
     (?$(1gx(B . ?\x98BF) ;; <CJK>
     (?$(1gy(B . ?\x98BD) ;; <CJK>
     (?$(1gz(B . ?\x98BB) ;; <CJK>
     (?$(1g{(B . ?\x98BE) ;; <CJK>
     (?$(1g|(B . ?\x9948) ;; <CJK>
     (?$(1g}(B . ?\x9947) ;; <CJK>
     (?$(1g~(B . ?\x9943) ;; <CJK>
     (?$(1h!(B . ?\x99A6) ;; <CJK>
     (?$(1h"(B . ?\x99A7) ;; <CJK>
     (?$(1h#(B . ?\x9A1A) ;; <CJK>
     (?$(1h$(B . ?\x9A15) ;; <CJK>
     (?$(1h%(B . ?\x9A25) ;; <CJK>
     (?$(1h&(B . ?\x9A1D) ;; <CJK>
     (?$(1h'(B . ?\x9A24) ;; <CJK>
     (?$(1h((B . ?\x9A1B) ;; <CJK>
     (?$(1h)(B . ?\x9A22) ;; <CJK>
     (?$(1h*(B . ?\x9A20) ;; <CJK>
     (?$(1h+(B . ?\x9A27) ;; <CJK>
     (?$(1h,(B . ?\x9A23) ;; <CJK>
     (?$(1h-(B . ?\x9A1E) ;; <CJK>
     (?$(1h.(B . ?\x9A1C) ;; <CJK>
     (?$(1h/(B . ?\x9A14) ;; <CJK>
     (?$(1h0(B . ?\x9AC2) ;; <CJK>
     (?$(1h1(B . ?\x9B0B) ;; <CJK>
     (?$(1h2(B . ?\x9B0A) ;; <CJK>
     (?$(1h3(B . ?\x9B0E) ;; <CJK>
     (?$(1h4(B . ?\x9B0C) ;; <CJK>
     (?$(1h5(B . ?\x9B37) ;; <CJK>
     (?$(1h6(B . ?\x9BEA) ;; <CJK>
     (?$(1h7(B . ?\x9BEB) ;; <CJK>
     (?$(1h8(B . ?\x9BE0) ;; <CJK>
     (?$(1h9(B . ?\x9BDE) ;; <CJK>
     (?$(1h:(B . ?\x9BE4) ;; <CJK>
     (?$(1h;(B . ?\x9BE6) ;; <CJK>
     (?$(1h<(B . ?\x9BE2) ;; <CJK>
     (?$(1h=(B . ?\x9BF0) ;; <CJK>
     (?$(1h>(B . ?\x9BD4) ;; <CJK>
     (?$(1h?(B . ?\x9BD7) ;; <CJK>
     (?$(1h@(B . ?\x9BEC) ;; <CJK>
     (?$(1hA(B . ?\x9BDC) ;; <CJK>
     (?$(1hB(B . ?\x9BD9) ;; <CJK>
     (?$(1hC(B . ?\x9BE5) ;; <CJK>
     (?$(1hD(B . ?\x9BD5) ;; <CJK>
     (?$(1hE(B . ?\x9BE1) ;; <CJK>
     (?$(1hF(B . ?\x9BDA) ;; <CJK>
     (?$(1hG(B . ?\x9D77) ;; <CJK>
     (?$(1hH(B . ?\x9D81) ;; <CJK>
     (?$(1hI(B . ?\x9D8A) ;; <CJK>
     (?$(1hJ(B . ?\x9D84) ;; <CJK>
     (?$(1hK(B . ?\x9D88) ;; <CJK>
     (?$(1hL(B . ?\x9D71) ;; <CJK>
     (?$(1hM(B . ?\x9D80) ;; <CJK>
     (?$(1hN(B . ?\x9D78) ;; <CJK>
     (?$(1hO(B . ?\x9D86) ;; <CJK>
     (?$(1hP(B . ?\x9D8B) ;; <CJK>
     (?$(1hQ(B . ?\x9D8C) ;; <CJK>
     (?$(1hR(B . ?\x9D7D) ;; <CJK>
     (?$(1hS(B . ?\x9D6B) ;; <CJK>
     (?$(1hT(B . ?\x9D74) ;; <CJK>
     (?$(1hU(B . ?\x9D75) ;; <CJK>
     (?$(1hV(B . ?\x9D70) ;; <CJK>
     (?$(1hW(B . ?\x9D69) ;; <CJK>
     (?$(1hX(B . ?\x9D85) ;; <CJK>
     (?$(1hY(B . ?\x9D73) ;; <CJK>
     (?$(1hZ(B . ?\x9D7B) ;; <CJK>
     (?$(1h[(B . ?\x9D82) ;; <CJK>
     (?$(1h\(B . ?\x9D6F) ;; <CJK>
     (?$(1h](B . ?\x9D79) ;; <CJK>
     (?$(1h^(B . ?\x9D7F) ;; <CJK>
     (?$(1h_(B . ?\x9D87) ;; <CJK>
     (?$(1h`(B . ?\x9D68) ;; <CJK>
     (?$(1ha(B . ?\x9E94) ;; <CJK>
     (?$(1hb(B . ?\x9E91) ;; <CJK>
     (?$(1hc(B . ?\x9EC0) ;; <CJK>
     (?$(1hd(B . ?\x9EFC) ;; <CJK>
     (?$(1he(B . ?\x9F2D) ;; <CJK>
     (?$(1hf(B . ?\x9F40) ;; <CJK>
     (?$(1hg(B . ?\x9F41) ;; <CJK>
     (?$(1hh(B . ?\x9F4D) ;; <CJK>
     (?$(1hi(B . ?\x9F56) ;; <CJK>
     (?$(1hj(B . ?\x9F57) ;; <CJK>
     (?$(1hk(B . ?\x9F58) ;; <CJK>
     (?$(1hl(B . ?\x5337) ;; <CJK>
     (?$(1hm(B . ?\x56B2) ;; <CJK>
     (?$(1hn(B . ?\x56B5) ;; <CJK>
     (?$(1ho(B . ?\x56B3) ;; <CJK>
     (?$(1hp(B . ?\x58E3) ;; <CJK>
     (?$(1hq(B . ?\x5B45) ;; <CJK>
     (?$(1hr(B . ?\x5DC6) ;; <CJK>
     (?$(1hs(B . ?\x5DC7) ;; <CJK>
     (?$(1ht(B . ?\x5EEE) ;; <CJK>
     (?$(1hu(B . ?\x5EEF) ;; <CJK>
     (?$(1hv(B . ?\x5FC0) ;; <CJK>
     (?$(1hw(B . ?\x5FC1) ;; <CJK>
     (?$(1hx(B . ?\x61F9) ;; <CJK>
     (?$(1hy(B . ?\x6517) ;; <CJK>
     (?$(1hz(B . ?\x6516) ;; <CJK>
     (?$(1h{(B . ?\x6515) ;; <CJK>
     (?$(1h|(B . ?\x6513) ;; <CJK>
     (?$(1h}(B . ?\x65DF) ;; <CJK>
     (?$(1h~(B . ?\x66E8) ;; <CJK>
     (?$(1i!(B . ?\x66E3) ;; <CJK>
     (?$(1i"(B . ?\x66E4) ;; <CJK>
     (?$(1i#(B . ?\x6AF3) ;; <CJK>
     (?$(1i$(B . ?\x6AF0) ;; <CJK>
     (?$(1i%(B . ?\x6AEA) ;; <CJK>
     (?$(1i&(B . ?\x6AE8) ;; <CJK>
     (?$(1i'(B . ?\x6AF9) ;; <CJK>
     (?$(1i((B . ?\x6AF1) ;; <CJK>
     (?$(1i)(B . ?\x6AEE) ;; <CJK>
     (?$(1i*(B . ?\x6AEF) ;; <CJK>
     (?$(1i+(B . ?\x703C) ;; <CJK>
     (?$(1i,(B . ?\x7035) ;; <CJK>
     (?$(1i-(B . ?\x702F) ;; <CJK>
     (?$(1i.(B . ?\x7037) ;; <CJK>
     (?$(1i/(B . ?\x7034) ;; <CJK>
     (?$(1i0(B . ?\x7031) ;; <CJK>
     (?$(1i1(B . ?\x7042) ;; <CJK>
     (?$(1i2(B . ?\x7038) ;; <CJK>
     (?$(1i3(B . ?\x703F) ;; <CJK>
     (?$(1i4(B . ?\x703A) ;; <CJK>
     (?$(1i5(B . ?\x7039) ;; <CJK>
     (?$(1i6(B . ?\x7040) ;; <CJK>
     (?$(1i7(B . ?\x703B) ;; <CJK>
     (?$(1i8(B . ?\x7033) ;; <CJK>
     (?$(1i9(B . ?\x7041) ;; <CJK>
     (?$(1i:(B . ?\x7213) ;; <CJK>
     (?$(1i;(B . ?\x7214) ;; <CJK>
     (?$(1i<(B . ?\x72A8) ;; <CJK>
     (?$(1i=(B . ?\x737D) ;; <CJK>
     (?$(1i>(B . ?\x737C) ;; <CJK>
     (?$(1i?(B . ?\x74BA) ;; <CJK>
     (?$(1i@(B . ?\x76AB) ;; <CJK>
     (?$(1iA(B . ?\x76AA) ;; <CJK>
     (?$(1iB(B . ?\x76BE) ;; <CJK>
     (?$(1iC(B . ?\x76ED) ;; <CJK>
     (?$(1iD(B . ?\x77CC) ;; <CJK>
     (?$(1iE(B . ?\x77CE) ;; <CJK>
     (?$(1iF(B . ?\x77CF) ;; <CJK>
     (?$(1iG(B . ?\x77CD) ;; <CJK>
     (?$(1iH(B . ?\x77F2) ;; <CJK>
     (?$(1iI(B . ?\x7925) ;; <CJK>
     (?$(1iJ(B . ?\x7923) ;; <CJK>
     (?$(1iK(B . ?\x7927) ;; <CJK>
     (?$(1iL(B . ?\x7928) ;; <CJK>
     (?$(1iM(B . ?\x7924) ;; <CJK>
     (?$(1iN(B . ?\x7929) ;; <CJK>
     (?$(1iO(B . ?\x79B2) ;; <CJK>
     (?$(1iP(B . ?\x7A6E) ;; <CJK>
     (?$(1iQ(B . ?\x7A6C) ;; <CJK>
     (?$(1iR(B . ?\x7A6D) ;; <CJK>
     (?$(1iS(B . ?\x7AF7) ;; <CJK>
     (?$(1iT(B . ?\x7C49) ;; <CJK>
     (?$(1iU(B . ?\x7C48) ;; <CJK>
     (?$(1iV(B . ?\x7C4A) ;; <CJK>
     (?$(1iW(B . ?\x7C47) ;; <CJK>
     (?$(1iX(B . ?\x7C45) ;; <CJK>
     (?$(1iY(B . ?\x7CEE) ;; <CJK>
     (?$(1iZ(B . ?\x7E7B) ;; <CJK>
     (?$(1i[(B . ?\x7E7E) ;; <CJK>
     (?$(1i\(B . ?\x7E81) ;; <CJK>
     (?$(1i](B . ?\x7E80) ;; <CJK>
     (?$(1i^(B . ?\x7FBA) ;; <CJK>
     (?$(1i_(B . ?\x7FFF) ;; <CJK>
     (?$(1i`(B . ?\x8079) ;; <CJK>
     (?$(1ia(B . ?\x81DB) ;; <CJK>
     (?$(1ib(B . ?\x81D9) ;; <CJK>
     (?$(1ic(B . ?\x820B) ;; <CJK>
     (?$(1id(B . ?\x8268) ;; <CJK>
     (?$(1ie(B . ?\x8269) ;; <CJK>
     (?$(1if(B . ?\x8622) ;; <CJK>
     (?$(1ig(B . ?\x85FF) ;; <CJK>
     (?$(1ih(B . ?\x8601) ;; <CJK>
     (?$(1ii(B . ?\x85FE) ;; <CJK>
     (?$(1ij(B . ?\x861B) ;; <CJK>
     (?$(1ik(B . ?\x8600) ;; <CJK>
     (?$(1il(B . ?\x85F6) ;; <CJK>
     (?$(1im(B . ?\x8604) ;; <CJK>
     (?$(1in(B . ?\x8609) ;; <CJK>
     (?$(1io(B . ?\x8605) ;; <CJK>
     (?$(1ip(B . ?\x860C) ;; <CJK>
     (?$(1iq(B . ?\x85FD) ;; <CJK>
     (?$(1ir(B . ?\x8819) ;; <CJK>
     (?$(1is(B . ?\x8810) ;; <CJK>
     (?$(1it(B . ?\x8811) ;; <CJK>
     (?$(1iu(B . ?\x8817) ;; <CJK>
     (?$(1iv(B . ?\x8813) ;; <CJK>
     (?$(1iw(B . ?\x8816) ;; <CJK>
     (?$(1ix(B . ?\x8963) ;; <CJK>
     (?$(1iy(B . ?\x8966) ;; <CJK>
     (?$(1iz(B . ?\x89B9) ;; <CJK>
     (?$(1i{(B . ?\x89F7) ;; <CJK>
     (?$(1i|(B . ?\x8B60) ;; <CJK>
     (?$(1i}(B . ?\x8B6A) ;; <CJK>
     (?$(1i~(B . ?\x8B5D) ;; <CJK>
     (?$(1j!(B . ?\x8B68) ;; <CJK>
     (?$(1j"(B . ?\x8B63) ;; <CJK>
     (?$(1j#(B . ?\x8B65) ;; <CJK>
     (?$(1j$(B . ?\x8B67) ;; <CJK>
     (?$(1j%(B . ?\x8B6D) ;; <CJK>
     (?$(1j&(B . ?\x8DAE) ;; <CJK>
     (?$(1j'(B . ?\x8E86) ;; <CJK>
     (?$(1j((B . ?\x8E88) ;; <CJK>
     (?$(1j)(B . ?\x8E84) ;; <CJK>
     (?$(1j*(B . ?\x8F59) ;; <CJK>
     (?$(1j+(B . ?\x8F56) ;; <CJK>
     (?$(1j,(B . ?\x8F57) ;; <CJK>
     (?$(1j-(B . ?\x8F55) ;; <CJK>
     (?$(1j.(B . ?\x8F58) ;; <CJK>
     (?$(1j/(B . ?\x8F5A) ;; <CJK>
     (?$(1j0(B . ?\x908D) ;; <CJK>
     (?$(1j1(B . ?\x9143) ;; <CJK>
     (?$(1j2(B . ?\x9141) ;; <CJK>
     (?$(1j3(B . ?\x91B7) ;; <CJK>
     (?$(1j4(B . ?\x91B5) ;; <CJK>
     (?$(1j5(B . ?\x91B2) ;; <CJK>
     (?$(1j6(B . ?\x91B3) ;; <CJK>
     (?$(1j7(B . ?\x940B) ;; <CJK>
     (?$(1j8(B . ?\x9413) ;; <CJK>
     (?$(1j9(B . ?\x93FB) ;; <CJK>
     (?$(1j:(B . ?\x9420) ;; <CJK>
     (?$(1j;(B . ?\x940F) ;; <CJK>
     (?$(1j<(B . ?\x9414) ;; <CJK>
     (?$(1j=(B . ?\x93FE) ;; <CJK>
     (?$(1j>(B . ?\x9415) ;; <CJK>
     (?$(1j?(B . ?\x9410) ;; <CJK>
     (?$(1j@(B . ?\x9428) ;; <CJK>
     (?$(1jA(B . ?\x9419) ;; <CJK>
     (?$(1jB(B . ?\x940D) ;; <CJK>
     (?$(1jC(B . ?\x93F5) ;; <CJK>
     (?$(1jD(B . ?\x9400) ;; <CJK>
     (?$(1jE(B . ?\x93F7) ;; <CJK>
     (?$(1jF(B . ?\x9407) ;; <CJK>
     (?$(1jG(B . ?\x940E) ;; <CJK>
     (?$(1jH(B . ?\x9416) ;; <CJK>
     (?$(1jI(B . ?\x9412) ;; <CJK>
     (?$(1jJ(B . ?\x93FA) ;; <CJK>
     (?$(1jK(B . ?\x9409) ;; <CJK>
     (?$(1jL(B . ?\x93F8) ;; <CJK>
     (?$(1jM(B . ?\x940A) ;; <CJK>
     (?$(1jN(B . ?\x93FF) ;; <CJK>
     (?$(1jO(B . ?\x93FC) ;; <CJK>
     (?$(1jP(B . ?\x940C) ;; <CJK>
     (?$(1jQ(B . ?\x93F6) ;; <CJK>
     (?$(1jR(B . ?\x9411) ;; <CJK>
     (?$(1jS(B . ?\x9406) ;; <CJK>
     (?$(1jT(B . ?\x95DE) ;; <CJK>
     (?$(1jU(B . ?\x95E0) ;; <CJK>
     (?$(1jV(B . ?\x95DF) ;; <CJK>
     (?$(1jW(B . ?\x972E) ;; <CJK>
     (?$(1jX(B . ?\x972F) ;; <CJK>
     (?$(1jY(B . ?\x97B9) ;; <CJK>
     (?$(1jZ(B . ?\x97BB) ;; <CJK>
     (?$(1j[(B . ?\x97FD) ;; <CJK>
     (?$(1j\(B . ?\x97FE) ;; <CJK>
     (?$(1j](B . ?\x9860) ;; <CJK>
     (?$(1j^(B . ?\x9862) ;; <CJK>
     (?$(1j_(B . ?\x9863) ;; <CJK>
     (?$(1j`(B . ?\x985F) ;; <CJK>
     (?$(1ja(B . ?\x98C1) ;; <CJK>
     (?$(1jb(B . ?\x98C2) ;; <CJK>
     (?$(1jc(B . ?\x9950) ;; <CJK>
     (?$(1jd(B . ?\x994E) ;; <CJK>
     (?$(1je(B . ?\x9959) ;; <CJK>
     (?$(1jf(B . ?\x994C) ;; <CJK>
     (?$(1jg(B . ?\x994B) ;; <CJK>
     (?$(1jh(B . ?\x9953) ;; <CJK>
     (?$(1ji(B . ?\x9A32) ;; <CJK>
     (?$(1jj(B . ?\x9A34) ;; <CJK>
     (?$(1jk(B . ?\x9A31) ;; <CJK>
     (?$(1jl(B . ?\x9A2C) ;; <CJK>
     (?$(1jm(B . ?\x9A2A) ;; <CJK>
     (?$(1jn(B . ?\x9A36) ;; <CJK>
     (?$(1jo(B . ?\x9A29) ;; <CJK>
     (?$(1jp(B . ?\x9A2E) ;; <CJK>
     (?$(1jq(B . ?\x9A38) ;; <CJK>
     (?$(1jr(B . ?\x9A2D) ;; <CJK>
     (?$(1js(B . ?\x9AC7) ;; <CJK>
     (?$(1jt(B . ?\x9ACA) ;; <CJK>
     (?$(1ju(B . ?\x9AC6) ;; <CJK>
     (?$(1jv(B . ?\x9B10) ;; <CJK>
     (?$(1jw(B . ?\x9B12) ;; <CJK>
     (?$(1jx(B . ?\x9B11) ;; <CJK>
     (?$(1jy(B . ?\x9C0B) ;; <CJK>
     (?$(1jz(B . ?\x9C08) ;; <CJK>
     (?$(1j{(B . ?\x9BF7) ;; <CJK>
     (?$(1j|(B . ?\x9C05) ;; <CJK>
     (?$(1j}(B . ?\x9C12) ;; <CJK>
     (?$(1j~(B . ?\x9BF8) ;; <CJK>
     (?$(1k!(B . ?\x9C40) ;; <CJK>
     (?$(1k"(B . ?\x9C07) ;; <CJK>
     (?$(1k#(B . ?\x9C0E) ;; <CJK>
     (?$(1k$(B . ?\x9C06) ;; <CJK>
     (?$(1k%(B . ?\x9C17) ;; <CJK>
     (?$(1k&(B . ?\x9C14) ;; <CJK>
     (?$(1k'(B . ?\x9C09) ;; <CJK>
     (?$(1k((B . ?\x9D9F) ;; <CJK>
     (?$(1k)(B . ?\x9D99) ;; <CJK>
     (?$(1k*(B . ?\x9DA4) ;; <CJK>
     (?$(1k+(B . ?\x9D9D) ;; <CJK>
     (?$(1k,(B . ?\x9D92) ;; <CJK>
     (?$(1k-(B . ?\x9D98) ;; <CJK>
     (?$(1k.(B . ?\x9D90) ;; <CJK>
     (?$(1k/(B . ?\x9D9B) ;; <CJK>
     (?$(1k0(B . ?\x9DA0) ;; <CJK>
     (?$(1k1(B . ?\x9D94) ;; <CJK>
     (?$(1k2(B . ?\x9D9C) ;; <CJK>
     (?$(1k3(B . ?\x9DAA) ;; <CJK>
     (?$(1k4(B . ?\x9D97) ;; <CJK>
     (?$(1k5(B . ?\x9DA1) ;; <CJK>
     (?$(1k6(B . ?\x9D9A) ;; <CJK>
     (?$(1k7(B . ?\x9DA2) ;; <CJK>
     (?$(1k8(B . ?\x9DA8) ;; <CJK>
     (?$(1k9(B . ?\x9D9E) ;; <CJK>
     (?$(1k:(B . ?\x9DA3) ;; <CJK>
     (?$(1k;(B . ?\x9DBF) ;; <CJK>
     (?$(1k<(B . ?\x9DA9) ;; <CJK>
     (?$(1k=(B . ?\x9D96) ;; <CJK>
     (?$(1k>(B . ?\x9DA6) ;; <CJK>
     (?$(1k?(B . ?\x9DA7) ;; <CJK>
     (?$(1k@(B . ?\x9E99) ;; <CJK>
     (?$(1kA(B . ?\x9E9B) ;; <CJK>
     (?$(1kB(B . ?\x9E9A) ;; <CJK>
     (?$(1kC(B . ?\x9EE5) ;; <CJK>
     (?$(1kD(B . ?\x9EE4) ;; <CJK>
     (?$(1kE(B . ?\x9EE7) ;; <CJK>
     (?$(1kF(B . ?\x9EE6) ;; <CJK>
     (?$(1kG(B . ?\x9F30) ;; <CJK>
     (?$(1kH(B . ?\x9F2E) ;; <CJK>
     (?$(1kI(B . ?\x9F5B) ;; <CJK>
     (?$(1kJ(B . ?\x9F60) ;; <CJK>
     (?$(1kK(B . ?\x9F5E) ;; <CJK>
     (?$(1kL(B . ?\x9F5D) ;; <CJK>
     (?$(1kM(B . ?\x9F59) ;; <CJK>
     (?$(1kN(B . ?\x9F91) ;; <CJK>
     (?$(1kO(B . ?\x513A) ;; <CJK>
     (?$(1kP(B . ?\x5139) ;; <CJK>
     (?$(1kQ(B . ?\x5298) ;; <CJK>
     (?$(1kR(B . ?\x5297) ;; <CJK>
     (?$(1kS(B . ?\x56C3) ;; <CJK>
     (?$(1kT(B . ?\x56BD) ;; <CJK>
     (?$(1kU(B . ?\x56BE) ;; <CJK>
     (?$(1kV(B . ?\x5B48) ;; <CJK>
     (?$(1kW(B . ?\x5B47) ;; <CJK>
     (?$(1kX(B . ?\x5DCB) ;; <CJK>
     (?$(1kY(B . ?\x5DCF) ;; <CJK>
     (?$(1kZ(B . ?\x5EF1) ;; <CJK>
     (?$(1k[(B . ?\x61FD) ;; <CJK>
     (?$(1k\(B . ?\x651B) ;; <CJK>
     (?$(1k](B . ?\x6B02) ;; <CJK>
     (?$(1k^(B . ?\x6AFC) ;; <CJK>
     (?$(1k_(B . ?\x6B03) ;; <CJK>
     (?$(1k`(B . ?\x6AF8) ;; <CJK>
     (?$(1ka(B . ?\x6B00) ;; <CJK>
     (?$(1kb(B . ?\x7043) ;; <CJK>
     (?$(1kc(B . ?\x7044) ;; <CJK>
     (?$(1kd(B . ?\x704A) ;; <CJK>
     (?$(1ke(B . ?\x7048) ;; <CJK>
     (?$(1kf(B . ?\x7049) ;; <CJK>
     (?$(1kg(B . ?\x7045) ;; <CJK>
     (?$(1kh(B . ?\x7046) ;; <CJK>
     (?$(1ki(B . ?\x721D) ;; <CJK>
     (?$(1kj(B . ?\x721A) ;; <CJK>
     (?$(1kk(B . ?\x7219) ;; <CJK>
     (?$(1kl(B . ?\x737E) ;; <CJK>
     (?$(1km(B . ?\x7517) ;; <CJK>
     (?$(1kn(B . ?\x766A) ;; <CJK>
     (?$(1ko(B . ?\x77D0) ;; <CJK>
     (?$(1kp(B . ?\x792D) ;; <CJK>
     (?$(1kq(B . ?\x7931) ;; <CJK>
     (?$(1kr(B . ?\x792F) ;; <CJK>
     (?$(1ks(B . ?\x7C54) ;; <CJK>
     (?$(1kt(B . ?\x7C53) ;; <CJK>
     (?$(1ku(B . ?\x7CF2) ;; <CJK>
     (?$(1kv(B . ?\x7E8A) ;; <CJK>
     (?$(1kw(B . ?\x7E87) ;; <CJK>
     (?$(1kx(B . ?\x7E88) ;; <CJK>
     (?$(1ky(B . ?\x7E8B) ;; <CJK>
     (?$(1kz(B . ?\x7E86) ;; <CJK>
     (?$(1k{(B . ?\x7E8D) ;; <CJK>
     (?$(1k|(B . ?\x7F4D) ;; <CJK>
     (?$(1k}(B . ?\x7FBB) ;; <CJK>
     (?$(1k~(B . ?\x8030) ;; <CJK>
     (?$(1l!(B . ?\x81DD) ;; <CJK>
     (?$(1l"(B . ?\x8618) ;; <CJK>
     (?$(1l#(B . ?\x862A) ;; <CJK>
     (?$(1l$(B . ?\x8626) ;; <CJK>
     (?$(1l%(B . ?\x861F) ;; <CJK>
     (?$(1l&(B . ?\x8623) ;; <CJK>
     (?$(1l'(B . ?\x861C) ;; <CJK>
     (?$(1l((B . ?\x8619) ;; <CJK>
     (?$(1l)(B . ?\x8627) ;; <CJK>
     (?$(1l*(B . ?\x862E) ;; <CJK>
     (?$(1l+(B . ?\x8621) ;; <CJK>
     (?$(1l,(B . ?\x8620) ;; <CJK>
     (?$(1l-(B . ?\x8629) ;; <CJK>
     (?$(1l.(B . ?\x861E) ;; <CJK>
     (?$(1l/(B . ?\x8625) ;; <CJK>
     (?$(1l0(B . ?\x8829) ;; <CJK>
     (?$(1l1(B . ?\x881D) ;; <CJK>
     (?$(1l2(B . ?\x881B) ;; <CJK>
     (?$(1l3(B . ?\x8820) ;; <CJK>
     (?$(1l4(B . ?\x8824) ;; <CJK>
     (?$(1l5(B . ?\x881C) ;; <CJK>
     (?$(1l6(B . ?\x882B) ;; <CJK>
     (?$(1l7(B . ?\x884A) ;; <CJK>
     (?$(1l8(B . ?\x896D) ;; <CJK>
     (?$(1l9(B . ?\x8969) ;; <CJK>
     (?$(1l:(B . ?\x896E) ;; <CJK>
     (?$(1l;(B . ?\x896B) ;; <CJK>
     (?$(1l<(B . ?\x89FA) ;; <CJK>
     (?$(1l=(B . ?\x8B79) ;; <CJK>
     (?$(1l>(B . ?\x8B78) ;; <CJK>
     (?$(1l?(B . ?\x8B45) ;; <CJK>
     (?$(1l@(B . ?\x8B7A) ;; <CJK>
     (?$(1lA(B . ?\x8B7B) ;; <CJK>
     (?$(1lB(B . ?\x8D10) ;; <CJK>
     (?$(1lC(B . ?\x8D14) ;; <CJK>
     (?$(1lD(B . ?\x8DAF) ;; <CJK>
     (?$(1lE(B . ?\x8E8E) ;; <CJK>
     (?$(1lF(B . ?\x8E8C) ;; <CJK>
     (?$(1lG(B . ?\x8F5E) ;; <CJK>
     (?$(1lH(B . ?\x8F5B) ;; <CJK>
     (?$(1lI(B . ?\x8F5D) ;; <CJK>
     (?$(1lJ(B . ?\x9146) ;; <CJK>
     (?$(1lK(B . ?\x9144) ;; <CJK>
     (?$(1lL(B . ?\x9145) ;; <CJK>
     (?$(1lM(B . ?\x91B9) ;; <CJK>
     (?$(1lN(B . ?\x943F) ;; <CJK>
     (?$(1lO(B . ?\x943B) ;; <CJK>
     (?$(1lP(B . ?\x9436) ;; <CJK>
     (?$(1lQ(B . ?\x9429) ;; <CJK>
     (?$(1lR(B . ?\x943D) ;; <CJK>
     (?$(1lS(B . ?\x943C) ;; <CJK>
     (?$(1lT(B . ?\x9430) ;; <CJK>
     (?$(1lU(B . ?\x9439) ;; <CJK>
     (?$(1lV(B . ?\x942A) ;; <CJK>
     (?$(1lW(B . ?\x9437) ;; <CJK>
     (?$(1lX(B . ?\x942C) ;; <CJK>
     (?$(1lY(B . ?\x9440) ;; <CJK>
     (?$(1lZ(B . ?\x9431) ;; <CJK>
     (?$(1l[(B . ?\x95E5) ;; <CJK>
     (?$(1l\(B . ?\x95E4) ;; <CJK>
     (?$(1l](B . ?\x95E3) ;; <CJK>
     (?$(1l^(B . ?\x9735) ;; <CJK>
     (?$(1l_(B . ?\x973A) ;; <CJK>
     (?$(1l`(B . ?\x97BF) ;; <CJK>
     (?$(1la(B . ?\x97E1) ;; <CJK>
     (?$(1lb(B . ?\x9864) ;; <CJK>
     (?$(1lc(B . ?\x98C9) ;; <CJK>
     (?$(1ld(B . ?\x98C6) ;; <CJK>
     (?$(1le(B . ?\x98C0) ;; <CJK>
     (?$(1lf(B . ?\x9958) ;; <CJK>
     (?$(1lg(B . ?\x9956) ;; <CJK>
     (?$(1lh(B . ?\x9A39) ;; <CJK>
     (?$(1li(B . ?\x9A3D) ;; <CJK>
     (?$(1lj(B . ?\x9A46) ;; <CJK>
     (?$(1lk(B . ?\x9A44) ;; <CJK>
     (?$(1ll(B . ?\x9A42) ;; <CJK>
     (?$(1lm(B . ?\x9A41) ;; <CJK>
     (?$(1ln(B . ?\x9A3A) ;; <CJK>
     (?$(1lo(B . ?\x9A3F) ;; <CJK>
     (?$(1lp(B . ?\x9ACD) ;; <CJK>
     (?$(1lq(B . ?\x9B15) ;; <CJK>
     (?$(1lr(B . ?\x9B17) ;; <CJK>
     (?$(1ls(B . ?\x9B18) ;; <CJK>
     (?$(1lt(B . ?\x9B16) ;; <CJK>
     (?$(1lu(B . ?\x9B3A) ;; <CJK>
     (?$(1lv(B . ?\x9B52) ;; <CJK>
     (?$(1lw(B . ?\x9C2B) ;; <CJK>
     (?$(1lx(B . ?\x9C1D) ;; <CJK>
     (?$(1ly(B . ?\x9C1C) ;; <CJK>
     (?$(1lz(B . ?\x9C2C) ;; <CJK>
     (?$(1l{(B . ?\x9C23) ;; <CJK>
     (?$(1l|(B . ?\x9C28) ;; <CJK>
     (?$(1l}(B . ?\x9C29) ;; <CJK>
     (?$(1l~(B . ?\x9C24) ;; <CJK>
     (?$(1m!(B . ?\x9C21) ;; <CJK>
     (?$(1m"(B . ?\x9DB7) ;; <CJK>
     (?$(1m#(B . ?\x9DB6) ;; <CJK>
     (?$(1m$(B . ?\x9DBC) ;; <CJK>
     (?$(1m%(B . ?\x9DC1) ;; <CJK>
     (?$(1m&(B . ?\x9DC7) ;; <CJK>
     (?$(1m'(B . ?\x9DCA) ;; <CJK>
     (?$(1m((B . ?\x9DCF) ;; <CJK>
     (?$(1m)(B . ?\x9DBE) ;; <CJK>
     (?$(1m*(B . ?\x9DC5) ;; <CJK>
     (?$(1m+(B . ?\x9DC3) ;; <CJK>
     (?$(1m,(B . ?\x9DBB) ;; <CJK>
     (?$(1m-(B . ?\x9DB5) ;; <CJK>
     (?$(1m.(B . ?\x9DCE) ;; <CJK>
     (?$(1m/(B . ?\x9DB9) ;; <CJK>
     (?$(1m0(B . ?\x9DBA) ;; <CJK>
     (?$(1m1(B . ?\x9DAC) ;; <CJK>
     (?$(1m2(B . ?\x9DC8) ;; <CJK>
     (?$(1m3(B . ?\x9DB1) ;; <CJK>
     (?$(1m4(B . ?\x9DAD) ;; <CJK>
     (?$(1m5(B . ?\x9DCC) ;; <CJK>
     (?$(1m6(B . ?\x9DB3) ;; <CJK>
     (?$(1m7(B . ?\x9DCD) ;; <CJK>
     (?$(1m8(B . ?\x9DB2) ;; <CJK>
     (?$(1m9(B . ?\x9E7A) ;; <CJK>
     (?$(1m:(B . ?\x9E9C) ;; <CJK>
     (?$(1m;(B . ?\x9EEB) ;; <CJK>
     (?$(1m<(B . ?\x9EEE) ;; <CJK>
     (?$(1m=(B . ?\x9EED) ;; <CJK>
     (?$(1m>(B . ?\x9F1B) ;; <CJK>
     (?$(1m?(B . ?\x9F18) ;; <CJK>
     (?$(1m@(B . ?\x9F1A) ;; <CJK>
     (?$(1mA(B . ?\x9F31) ;; <CJK>
     (?$(1mB(B . ?\x9F4E) ;; <CJK>
     (?$(1mC(B . ?\x9F65) ;; <CJK>
     (?$(1mD(B . ?\x9F64) ;; <CJK>
     (?$(1mE(B . ?\x9F92) ;; <CJK>
     (?$(1mF(B . ?\x4EB9) ;; <CJK>
     (?$(1mG(B . ?\x56C6) ;; <CJK>
     (?$(1mH(B . ?\x56C5) ;; <CJK>
     (?$(1mI(B . ?\x56CB) ;; <CJK>
     (?$(1mJ(B . ?\x5971) ;; <CJK>
     (?$(1mK(B . ?\x5B4B) ;; <CJK>
     (?$(1mL(B . ?\x5B4C) ;; <CJK>
     (?$(1mM(B . ?\x5DD5) ;; <CJK>
     (?$(1mN(B . ?\x5DD1) ;; <CJK>
     (?$(1mO(B . ?\x5EF2) ;; <CJK>
     (?$(1mP(B . ?\x6521) ;; <CJK>
     (?$(1mQ(B . ?\x6520) ;; <CJK>
     (?$(1mR(B . ?\x6526) ;; <CJK>
     (?$(1mS(B . ?\x6522) ;; <CJK>
     (?$(1mT(B . ?\x6B0B) ;; <CJK>
     (?$(1mU(B . ?\x6B08) ;; <CJK>
     (?$(1mV(B . ?\x6B09) ;; <CJK>
     (?$(1mW(B . ?\x6C0D) ;; <CJK>
     (?$(1mX(B . ?\x7055) ;; <CJK>
     (?$(1mY(B . ?\x7056) ;; <CJK>
     (?$(1mZ(B . ?\x7057) ;; <CJK>
     (?$(1m[(B . ?\x7052) ;; <CJK>
     (?$(1m\(B . ?\x721E) ;; <CJK>
     (?$(1m](B . ?\x721F) ;; <CJK>
     (?$(1m^(B . ?\x72A9) ;; <CJK>
     (?$(1m_(B . ?\x737F) ;; <CJK>
     (?$(1m`(B . ?\x74D8) ;; <CJK>
     (?$(1ma(B . ?\x74D5) ;; <CJK>
     (?$(1mb(B . ?\x74D9) ;; <CJK>
     (?$(1mc(B . ?\x74D7) ;; <CJK>
     (?$(1md(B . ?\x766D) ;; <CJK>
     (?$(1me(B . ?\x76AD) ;; <CJK>
     (?$(1mf(B . ?\x7935) ;; <CJK>
     (?$(1mg(B . ?\x79B4) ;; <CJK>
     (?$(1mh(B . ?\x7A70) ;; <CJK>
     (?$(1mi(B . ?\x7A71) ;; <CJK>
     (?$(1mj(B . ?\x7C57) ;; <CJK>
     (?$(1mk(B . ?\x7C5C) ;; <CJK>
     (?$(1ml(B . ?\x7C59) ;; <CJK>
     (?$(1mm(B . ?\x7C5B) ;; <CJK>
     (?$(1mn(B . ?\x7C5A) ;; <CJK>
     (?$(1mo(B . ?\x7CF4) ;; <CJK>
     (?$(1mp(B . ?\x7CF1) ;; <CJK>
     (?$(1mq(B . ?\x7E91) ;; <CJK>
     (?$(1mr(B . ?\x7F4F) ;; <CJK>
     (?$(1ms(B . ?\x7F87) ;; <CJK>
     (?$(1mt(B . ?\x81DE) ;; <CJK>
     (?$(1mu(B . ?\x826B) ;; <CJK>
     (?$(1mv(B . ?\x8634) ;; <CJK>
     (?$(1mw(B . ?\x8635) ;; <CJK>
     (?$(1mx(B . ?\x8633) ;; <CJK>
     (?$(1my(B . ?\x862C) ;; <CJK>
     (?$(1mz(B . ?\x8632) ;; <CJK>
     (?$(1m{(B . ?\x8636) ;; <CJK>
     (?$(1m|(B . ?\x882C) ;; <CJK>
     (?$(1m}(B . ?\x8828) ;; <CJK>
     (?$(1m~(B . ?\x8826) ;; <CJK>
     (?$(1n!(B . ?\x882A) ;; <CJK>
     (?$(1n"(B . ?\x8825) ;; <CJK>
     (?$(1n#(B . ?\x8971) ;; <CJK>
     (?$(1n$(B . ?\x89BF) ;; <CJK>
     (?$(1n%(B . ?\x89BE) ;; <CJK>
     (?$(1n&(B . ?\x89FB) ;; <CJK>
     (?$(1n'(B . ?\x8B7E) ;; <CJK>
     (?$(1n((B . ?\x8B84) ;; <CJK>
     (?$(1n)(B . ?\x8B82) ;; <CJK>
     (?$(1n*(B . ?\x8B86) ;; <CJK>
     (?$(1n+(B . ?\x8B85) ;; <CJK>
     (?$(1n,(B . ?\x8B7F) ;; <CJK>
     (?$(1n-(B . ?\x8D15) ;; <CJK>
     (?$(1n.(B . ?\x8E95) ;; <CJK>
     (?$(1n/(B . ?\x8E94) ;; <CJK>
     (?$(1n0(B . ?\x8E9A) ;; <CJK>
     (?$(1n1(B . ?\x8E92) ;; <CJK>
     (?$(1n2(B . ?\x8E90) ;; <CJK>
     (?$(1n3(B . ?\x8E96) ;; <CJK>
     (?$(1n4(B . ?\x8E97) ;; <CJK>
     (?$(1n5(B . ?\x8F60) ;; <CJK>
     (?$(1n6(B . ?\x8F62) ;; <CJK>
     (?$(1n7(B . ?\x9147) ;; <CJK>
     (?$(1n8(B . ?\x944C) ;; <CJK>
     (?$(1n9(B . ?\x9450) ;; <CJK>
     (?$(1n:(B . ?\x944A) ;; <CJK>
     (?$(1n;(B . ?\x944B) ;; <CJK>
     (?$(1n<(B . ?\x944F) ;; <CJK>
     (?$(1n=(B . ?\x9447) ;; <CJK>
     (?$(1n>(B . ?\x9445) ;; <CJK>
     (?$(1n?(B . ?\x9448) ;; <CJK>
     (?$(1n@(B . ?\x9449) ;; <CJK>
     (?$(1nA(B . ?\x9446) ;; <CJK>
     (?$(1nB(B . ?\x973F) ;; <CJK>
     (?$(1nC(B . ?\x97E3) ;; <CJK>
     (?$(1nD(B . ?\x986A) ;; <CJK>
     (?$(1nE(B . ?\x9869) ;; <CJK>
     (?$(1nF(B . ?\x98CB) ;; <CJK>
     (?$(1nG(B . ?\x9954) ;; <CJK>
     (?$(1nH(B . ?\x995B) ;; <CJK>
     (?$(1nI(B . ?\x9A4E) ;; <CJK>
     (?$(1nJ(B . ?\x9A53) ;; <CJK>
     (?$(1nK(B . ?\x9A54) ;; <CJK>
     (?$(1nL(B . ?\x9A4C) ;; <CJK>
     (?$(1nM(B . ?\x9A4F) ;; <CJK>
     (?$(1nN(B . ?\x9A48) ;; <CJK>
     (?$(1nO(B . ?\x9A4A) ;; <CJK>
     (?$(1nP(B . ?\x9A49) ;; <CJK>
     (?$(1nQ(B . ?\x9A52) ;; <CJK>
     (?$(1nR(B . ?\x9A50) ;; <CJK>
     (?$(1nS(B . ?\x9AD0) ;; <CJK>
     (?$(1nT(B . ?\x9B19) ;; <CJK>
     (?$(1nU(B . ?\x9B2B) ;; <CJK>
     (?$(1nV(B . ?\x9B3B) ;; <CJK>
     (?$(1nW(B . ?\x9B56) ;; <CJK>
     (?$(1nX(B . ?\x9B55) ;; <CJK>
     (?$(1nY(B . ?\x9C46) ;; <CJK>
     (?$(1nZ(B . ?\x9C48) ;; <CJK>
     (?$(1n[(B . ?\x9C3F) ;; <CJK>
     (?$(1n\(B . ?\x9C44) ;; <CJK>
     (?$(1n](B . ?\x9C39) ;; <CJK>
     (?$(1n^(B . ?\x9C33) ;; <CJK>
     (?$(1n_(B . ?\x9C41) ;; <CJK>
     (?$(1n`(B . ?\x9C3C) ;; <CJK>
     (?$(1na(B . ?\x9C37) ;; <CJK>
     (?$(1nb(B . ?\x9C34) ;; <CJK>
     (?$(1nc(B . ?\x9C32) ;; <CJK>
     (?$(1nd(B . ?\x9C3D) ;; <CJK>
     (?$(1ne(B . ?\x9C36) ;; <CJK>
     (?$(1nf(B . ?\x9DDB) ;; <CJK>
     (?$(1ng(B . ?\x9DD2) ;; <CJK>
     (?$(1nh(B . ?\x9DDE) ;; <CJK>
     (?$(1ni(B . ?\x9DDA) ;; <CJK>
     (?$(1nj(B . ?\x9DCB) ;; <CJK>
     (?$(1nk(B . ?\x9DD0) ;; <CJK>
     (?$(1nl(B . ?\x9DDC) ;; <CJK>
     (?$(1nm(B . ?\x9DD1) ;; <CJK>
     (?$(1nn(B . ?\x9DDF) ;; <CJK>
     (?$(1no(B . ?\x9DE9) ;; <CJK>
     (?$(1np(B . ?\x9DD9) ;; <CJK>
     (?$(1nq(B . ?\x9DD8) ;; <CJK>
     (?$(1nr(B . ?\x9DD6) ;; <CJK>
     (?$(1ns(B . ?\x9DF5) ;; <CJK>
     (?$(1nt(B . ?\x9DD5) ;; <CJK>
     (?$(1nu(B . ?\x9DDD) ;; <CJK>
     (?$(1nv(B . ?\x9EB6) ;; <CJK>
     (?$(1nw(B . ?\x9EF0) ;; <CJK>
     (?$(1nx(B . ?\x9F35) ;; <CJK>
     (?$(1ny(B . ?\x9F33) ;; <CJK>
     (?$(1nz(B . ?\x9F32) ;; <CJK>
     (?$(1n{(B . ?\x9F42) ;; <CJK>
     (?$(1n|(B . ?\x9F6B) ;; <CJK>
     (?$(1n}(B . ?\x9F95) ;; <CJK>
     (?$(1n~(B . ?\x9FA2) ;; <CJK>
     (?$(1o!(B . ?\x513D) ;; <CJK>
     (?$(1o"(B . ?\x5299) ;; <CJK>
     (?$(1o#(B . ?\x58E8) ;; <CJK>
     (?$(1o$(B . ?\x58E7) ;; <CJK>
     (?$(1o%(B . ?\x5972) ;; <CJK>
     (?$(1o&(B . ?\x5B4D) ;; <CJK>
     (?$(1o'(B . ?\x5DD8) ;; <CJK>
     (?$(1o((B . ?\x882F) ;; <CJK>
     (?$(1o)(B . ?\x5F4F) ;; <CJK>
     (?$(1o*(B . ?\x6201) ;; <CJK>
     (?$(1o+(B . ?\x6203) ;; <CJK>
     (?$(1o,(B . ?\x6204) ;; <CJK>
     (?$(1o-(B . ?\x6529) ;; <CJK>
     (?$(1o.(B . ?\x6525) ;; <CJK>
     (?$(1o/(B . ?\x6596) ;; <CJK>
     (?$(1o0(B . ?\x66EB) ;; <CJK>
     (?$(1o1(B . ?\x6B11) ;; <CJK>
     (?$(1o2(B . ?\x6B12) ;; <CJK>
     (?$(1o3(B . ?\x6B0F) ;; <CJK>
     (?$(1o4(B . ?\x6BCA) ;; <CJK>
     (?$(1o5(B . ?\x705B) ;; <CJK>
     (?$(1o6(B . ?\x705A) ;; <CJK>
     (?$(1o7(B . ?\x7222) ;; <CJK>
     (?$(1o8(B . ?\x7382) ;; <CJK>
     (?$(1o9(B . ?\x7381) ;; <CJK>
     (?$(1o:(B . ?\x7383) ;; <CJK>
     (?$(1o;(B . ?\x7670) ;; <CJK>
     (?$(1o<(B . ?\x77D4) ;; <CJK>
     (?$(1o=(B . ?\x7C67) ;; <CJK>
     (?$(1o>(B . ?\x7C66) ;; <CJK>
     (?$(1o?(B . ?\x7E95) ;; <CJK>
     (?$(1o@(B . ?\x826C) ;; <CJK>
     (?$(1oA(B . ?\x863A) ;; <CJK>
     (?$(1oB(B . ?\x8640) ;; <CJK>
     (?$(1oC(B . ?\x8639) ;; <CJK>
     (?$(1oD(B . ?\x863C) ;; <CJK>
     (?$(1oE(B . ?\x8631) ;; <CJK>
     (?$(1oF(B . ?\x863B) ;; <CJK>
     (?$(1oG(B . ?\x863E) ;; <CJK>
     (?$(1oH(B . ?\x8830) ;; <CJK>
     (?$(1oI(B . ?\x8832) ;; <CJK>
     (?$(1oJ(B . ?\x882E) ;; <CJK>
     (?$(1oK(B . ?\x8833) ;; <CJK>
     (?$(1oL(B . ?\x8976) ;; <CJK>
     (?$(1oM(B . ?\x8974) ;; <CJK>
     (?$(1oN(B . ?\x8973) ;; <CJK>
     (?$(1oO(B . ?\x89FE) ;; <CJK>
     (?$(1oP(B . ?\x8B8C) ;; <CJK>
     (?$(1oQ(B . ?\x8B8E) ;; <CJK>
     (?$(1oR(B . ?\x8B8B) ;; <CJK>
     (?$(1oS(B . ?\x8B88) ;; <CJK>
     (?$(1oT(B . ?\x8C45) ;; <CJK>
     (?$(1oU(B . ?\x8D19) ;; <CJK>
     (?$(1oV(B . ?\x8E98) ;; <CJK>
     (?$(1oW(B . ?\x8F64) ;; <CJK>
     (?$(1oX(B . ?\x8F63) ;; <CJK>
     (?$(1oY(B . ?\x91BC) ;; <CJK>
     (?$(1oZ(B . ?\x9462) ;; <CJK>
     (?$(1o[(B . ?\x9455) ;; <CJK>
     (?$(1o\(B . ?\x945D) ;; <CJK>
     (?$(1o](B . ?\x9457) ;; <CJK>
     (?$(1o^(B . ?\x945E) ;; <CJK>
     (?$(1o_(B . ?\x97C4) ;; <CJK>
     (?$(1o`(B . ?\x97C5) ;; <CJK>
     (?$(1oa(B . ?\x9800) ;; <CJK>
     (?$(1ob(B . ?\x9A56) ;; <CJK>
     (?$(1oc(B . ?\x9A59) ;; <CJK>
     (?$(1od(B . ?\x9B1E) ;; <CJK>
     (?$(1oe(B . ?\x9B1F) ;; <CJK>
     (?$(1of(B . ?\x9B20) ;; <CJK>
     (?$(1og(B . ?\x9C52) ;; <CJK>
     (?$(1oh(B . ?\x9C58) ;; <CJK>
     (?$(1oi(B . ?\x9C50) ;; <CJK>
     (?$(1oj(B . ?\x9C4A) ;; <CJK>
     (?$(1ok(B . ?\x9C4D) ;; <CJK>
     (?$(1ol(B . ?\x9C4B) ;; <CJK>
     (?$(1om(B . ?\x9C55) ;; <CJK>
     (?$(1on(B . ?\x9C59) ;; <CJK>
     (?$(1oo(B . ?\x9C4C) ;; <CJK>
     (?$(1op(B . ?\x9C4E) ;; <CJK>
     (?$(1oq(B . ?\x9DFB) ;; <CJK>
     (?$(1or(B . ?\x9DF7) ;; <CJK>
     (?$(1os(B . ?\x9DEF) ;; <CJK>
     (?$(1ot(B . ?\x9DE3) ;; <CJK>
     (?$(1ou(B . ?\x9DEB) ;; <CJK>
     (?$(1ov(B . ?\x9DF8) ;; <CJK>
     (?$(1ow(B . ?\x9DE4) ;; <CJK>
     (?$(1ox(B . ?\x9DF6) ;; <CJK>
     (?$(1oy(B . ?\x9DE1) ;; <CJK>
     (?$(1oz(B . ?\x9DEE) ;; <CJK>
     (?$(1o{(B . ?\x9DE6) ;; <CJK>
     (?$(1o|(B . ?\x9DF2) ;; <CJK>
     (?$(1o}(B . ?\x9DF0) ;; <CJK>
     (?$(1o~(B . ?\x9DE2) ;; <CJK>
     (?$(1p!(B . ?\x9DEC) ;; <CJK>
     (?$(1p"(B . ?\x9DF4) ;; <CJK>
     (?$(1p#(B . ?\x9DF3) ;; <CJK>
     (?$(1p$(B . ?\x9DE8) ;; <CJK>
     (?$(1p%(B . ?\x9DED) ;; <CJK>
     (?$(1p&(B . ?\x9EC2) ;; <CJK>
     (?$(1p'(B . ?\x9ED0) ;; <CJK>
     (?$(1p((B . ?\x9EF2) ;; <CJK>
     (?$(1p)(B . ?\x9EF3) ;; <CJK>
     (?$(1p*(B . ?\x9F06) ;; <CJK>
     (?$(1p+(B . ?\x9F1C) ;; <CJK>
     (?$(1p,(B . ?\x9F38) ;; <CJK>
     (?$(1p-(B . ?\x9F37) ;; <CJK>
     (?$(1p.(B . ?\x9F36) ;; <CJK>
     (?$(1p/(B . ?\x9F43) ;; <CJK>
     (?$(1p0(B . ?\x9F4F) ;; <CJK>
     (?$(1p1(B . ?\x9F71) ;; <CJK>
     (?$(1p2(B . ?\x9F70) ;; <CJK>
     (?$(1p3(B . ?\x9F6E) ;; <CJK>
     (?$(1p4(B . ?\x9F6F) ;; <CJK>
     (?$(1p5(B . ?\x56D3) ;; <CJK>
     (?$(1p6(B . ?\x56CD) ;; <CJK>
     (?$(1p7(B . ?\x5B4E) ;; <CJK>
     (?$(1p8(B . ?\x5C6D) ;; <CJK>
     (?$(1p9(B . ?\x652D) ;; <CJK>
     (?$(1p:(B . ?\x66ED) ;; <CJK>
     (?$(1p;(B . ?\x66EE) ;; <CJK>
     (?$(1p<(B . ?\x6B13) ;; <CJK>
     (?$(1p=(B . ?\x705F) ;; <CJK>
     (?$(1p>(B . ?\x7061) ;; <CJK>
     (?$(1p?(B . ?\x705D) ;; <CJK>
     (?$(1p@(B . ?\x7060) ;; <CJK>
     (?$(1pA(B . ?\x7223) ;; <CJK>
     (?$(1pB(B . ?\x74DB) ;; <CJK>
     (?$(1pC(B . ?\x74E5) ;; <CJK>
     (?$(1pD(B . ?\x77D5) ;; <CJK>
     (?$(1pE(B . ?\x7938) ;; <CJK>
     (?$(1pF(B . ?\x79B7) ;; <CJK>
     (?$(1pG(B . ?\x79B6) ;; <CJK>
     (?$(1pH(B . ?\x7C6A) ;; <CJK>
     (?$(1pI(B . ?\x7E97) ;; <CJK>
     (?$(1pJ(B . ?\x7F89) ;; <CJK>
     (?$(1pK(B . ?\x826D) ;; <CJK>
     (?$(1pL(B . ?\x8643) ;; <CJK>
     (?$(1pM(B . ?\x8838) ;; <CJK>
     (?$(1pN(B . ?\x8837) ;; <CJK>
     (?$(1pO(B . ?\x8835) ;; <CJK>
     (?$(1pP(B . ?\x884B) ;; <CJK>
     (?$(1pQ(B . ?\x8B94) ;; <CJK>
     (?$(1pR(B . ?\x8B95) ;; <CJK>
     (?$(1pS(B . ?\x8E9E) ;; <CJK>
     (?$(1pT(B . ?\x8E9F) ;; <CJK>
     (?$(1pU(B . ?\x8EA0) ;; <CJK>
     (?$(1pV(B . ?\x8E9D) ;; <CJK>
     (?$(1pW(B . ?\x91BE) ;; <CJK>
     (?$(1pX(B . ?\x91BD) ;; <CJK>
     (?$(1pY(B . ?\x91C2) ;; <CJK>
     (?$(1pZ(B . ?\x946B) ;; <CJK>
     (?$(1p[(B . ?\x9468) ;; <CJK>
     (?$(1p\(B . ?\x9469) ;; <CJK>
     (?$(1p](B . ?\x96E5) ;; <CJK>
     (?$(1p^(B . ?\x9746) ;; <CJK>
     (?$(1p_(B . ?\x9743) ;; <CJK>
     (?$(1p`(B . ?\x9747) ;; <CJK>
     (?$(1pa(B . ?\x97C7) ;; <CJK>
     (?$(1pb(B . ?\x97E5) ;; <CJK>
     (?$(1pc(B . ?\x9A5E) ;; <CJK>
     (?$(1pd(B . ?\x9AD5) ;; <CJK>
     (?$(1pe(B . ?\x9B59) ;; <CJK>
     (?$(1pf(B . ?\x9C63) ;; <CJK>
     (?$(1pg(B . ?\x9C67) ;; <CJK>
     (?$(1ph(B . ?\x9C66) ;; <CJK>
     (?$(1pi(B . ?\x9C62) ;; <CJK>
     (?$(1pj(B . ?\x9C5E) ;; <CJK>
     (?$(1pk(B . ?\x9C60) ;; <CJK>
     (?$(1pl(B . ?\x9E02) ;; <CJK>
     (?$(1pm(B . ?\x9DFE) ;; <CJK>
     (?$(1pn(B . ?\x9E07) ;; <CJK>
     (?$(1po(B . ?\x9E03) ;; <CJK>
     (?$(1pp(B . ?\x9E06) ;; <CJK>
     (?$(1pq(B . ?\x9E05) ;; <CJK>
     (?$(1pr(B . ?\x9E00) ;; <CJK>
     (?$(1ps(B . ?\x9E01) ;; <CJK>
     (?$(1pt(B . ?\x9E09) ;; <CJK>
     (?$(1pu(B . ?\x9DFF) ;; <CJK>
     (?$(1pv(B . ?\x9DFD) ;; <CJK>
     (?$(1pw(B . ?\x9E04) ;; <CJK>
     (?$(1px(B . ?\x9EA0) ;; <CJK>
     (?$(1py(B . ?\x9F1E) ;; <CJK>
     (?$(1pz(B . ?\x9F46) ;; <CJK>
     (?$(1p{(B . ?\x9F74) ;; <CJK>
     (?$(1p|(B . ?\x9F75) ;; <CJK>
     (?$(1p}(B . ?\x9F76) ;; <CJK>
     (?$(1p~(B . ?\x56D4) ;; <CJK>
     (?$(1q!(B . ?\x652E) ;; <CJK>
     (?$(1q"(B . ?\x65B8) ;; <CJK>
     (?$(1q#(B . ?\x6B18) ;; <CJK>
     (?$(1q$(B . ?\x6B19) ;; <CJK>
     (?$(1q%(B . ?\x6B17) ;; <CJK>
     (?$(1q&(B . ?\x6B1A) ;; <CJK>
     (?$(1q'(B . ?\x7062) ;; <CJK>
     (?$(1q((B . ?\x7226) ;; <CJK>
     (?$(1q)(B . ?\x72AA) ;; <CJK>
     (?$(1q*(B . ?\x77D8) ;; <CJK>
     (?$(1q+(B . ?\x77D9) ;; <CJK>
     (?$(1q,(B . ?\x7939) ;; <CJK>
     (?$(1q-(B . ?\x7C69) ;; <CJK>
     (?$(1q.(B . ?\x7C6B) ;; <CJK>
     (?$(1q/(B . ?\x7CF6) ;; <CJK>
     (?$(1q0(B . ?\x7E9A) ;; <CJK>
     (?$(1q1(B . ?\x7E98) ;; <CJK>
     (?$(1q2(B . ?\x7E9B) ;; <CJK>
     (?$(1q3(B . ?\x7E99) ;; <CJK>
     (?$(1q4(B . ?\x81E0) ;; <CJK>
     (?$(1q5(B . ?\x81E1) ;; <CJK>
     (?$(1q6(B . ?\x8646) ;; <CJK>
     (?$(1q7(B . ?\x8647) ;; <CJK>
     (?$(1q8(B . ?\x8648) ;; <CJK>
     (?$(1q9(B . ?\x8979) ;; <CJK>
     (?$(1q:(B . ?\x897A) ;; <CJK>
     (?$(1q;(B . ?\x897C) ;; <CJK>
     (?$(1q<(B . ?\x897B) ;; <CJK>
     (?$(1q=(B . ?\x89FF) ;; <CJK>
     (?$(1q>(B . ?\x8B98) ;; <CJK>
     (?$(1q?(B . ?\x8B99) ;; <CJK>
     (?$(1q@(B . ?\x8EA5) ;; <CJK>
     (?$(1qA(B . ?\x8EA4) ;; <CJK>
     (?$(1qB(B . ?\x8EA3) ;; <CJK>
     (?$(1qC(B . ?\x946E) ;; <CJK>
     (?$(1qD(B . ?\x946D) ;; <CJK>
     (?$(1qE(B . ?\x946F) ;; <CJK>
     (?$(1qF(B . ?\x9471) ;; <CJK>
     (?$(1qG(B . ?\x9473) ;; <CJK>
     (?$(1qH(B . ?\x9749) ;; <CJK>
     (?$(1qI(B . ?\x9872) ;; <CJK>
     (?$(1qJ(B . ?\x995F) ;; <CJK>
     (?$(1qK(B . ?\x9C68) ;; <CJK>
     (?$(1qL(B . ?\x9C6E) ;; <CJK>
     (?$(1qM(B . ?\x9C6D) ;; <CJK>
     (?$(1qN(B . ?\x9E0B) ;; <CJK>
     (?$(1qO(B . ?\x9E0D) ;; <CJK>
     (?$(1qP(B . ?\x9E10) ;; <CJK>
     (?$(1qQ(B . ?\x9E0F) ;; <CJK>
     (?$(1qR(B . ?\x9E12) ;; <CJK>
     (?$(1qS(B . ?\x9E11) ;; <CJK>
     (?$(1qT(B . ?\x9EA1) ;; <CJK>
     (?$(1qU(B . ?\x9EF5) ;; <CJK>
     (?$(1qV(B . ?\x9F09) ;; <CJK>
     (?$(1qW(B . ?\x9F47) ;; <CJK>
     (?$(1qX(B . ?\x9F78) ;; <CJK>
     (?$(1qY(B . ?\x9F7B) ;; <CJK>
     (?$(1qZ(B . ?\x9F7A) ;; <CJK>
     (?$(1q[(B . ?\x9F79) ;; <CJK>
     (?$(1q\(B . ?\x571E) ;; <CJK>
     (?$(1q](B . ?\x7066) ;; <CJK>
     (?$(1q^(B . ?\x7C6F) ;; <CJK>
     (?$(1q_(B . ?\x883C) ;; <CJK>
     (?$(1q`(B . ?\x8DB2) ;; <CJK>
     (?$(1qa(B . ?\x8EA6) ;; <CJK>
     (?$(1qb(B . ?\x91C3) ;; <CJK>
     (?$(1qc(B . ?\x9474) ;; <CJK>
     (?$(1qd(B . ?\x9478) ;; <CJK>
     (?$(1qe(B . ?\x9476) ;; <CJK>
     (?$(1qf(B . ?\x9475) ;; <CJK>
     (?$(1qg(B . ?\x9A60) ;; <CJK>
     (?$(1qh(B . ?\x9C74) ;; <CJK>
     (?$(1qi(B . ?\x9C73) ;; <CJK>
     (?$(1qj(B . ?\x9C71) ;; <CJK>
     (?$(1qk(B . ?\x9C75) ;; <CJK>
     (?$(1ql(B . ?\x9E14) ;; <CJK>
     (?$(1qm(B . ?\x9E13) ;; <CJK>
     (?$(1qn(B . ?\x9EF6) ;; <CJK>
     (?$(1qo(B . ?\x9F0A) ;; <CJK>
     (?$(1qp(B . ?\x9FA4) ;; <CJK>
     (?$(1qq(B . ?\x7068) ;; <CJK>
     (?$(1qr(B . ?\x7065) ;; <CJK>
     (?$(1qs(B . ?\x7CF7) ;; <CJK>
     (?$(1qt(B . ?\x866A) ;; <CJK>
     (?$(1qu(B . ?\x883E) ;; <CJK>
     (?$(1qv(B . ?\x883D) ;; <CJK>
     (?$(1qw(B . ?\x883F) ;; <CJK>
     (?$(1qx(B . ?\x8B9E) ;; <CJK>
     (?$(1qy(B . ?\x8C9C) ;; <CJK>
     (?$(1qz(B . ?\x8EA9) ;; <CJK>
     (?$(1q{(B . ?\x8EC9) ;; <CJK>
     (?$(1q|(B . ?\x974B) ;; <CJK>
     (?$(1q}(B . ?\x9873) ;; <CJK>
     (?$(1q~(B . ?\x9874) ;; <CJK>
     (?$(1r!(B . ?\x98CC) ;; <CJK>
     (?$(1r"(B . ?\x9961) ;; <CJK>
     (?$(1r#(B . ?\x99AB) ;; <CJK>
     (?$(1r$(B . ?\x9A64) ;; <CJK>
     (?$(1r%(B . ?\x9A66) ;; <CJK>
     (?$(1r&(B . ?\x9A67) ;; <CJK>
     (?$(1r'(B . ?\x9B24) ;; <CJK>
     (?$(1r((B . ?\x9E15) ;; <CJK>
     (?$(1r)(B . ?\x9E17) ;; <CJK>
     (?$(1r*(B . ?\x9F48) ;; <CJK>
     (?$(1r+(B . ?\x6207) ;; <CJK>
     (?$(1r,(B . ?\x6B1E) ;; <CJK>
     (?$(1r-(B . ?\x7227) ;; <CJK>
     (?$(1r.(B . ?\x864C) ;; <CJK>
     (?$(1r/(B . ?\x8EA8) ;; <CJK>
     (?$(1r0(B . ?\x9482) ;; <CJK>
     (?$(1r1(B . ?\x9480) ;; <CJK>
     (?$(1r2(B . ?\x9481) ;; <CJK>
     (?$(1r3(B . ?\x9A69) ;; <CJK>
     (?$(1r4(B . ?\x9A68) ;; <CJK>
     (?$(1r5(B . ?\x9B2E) ;; <CJK>
     (?$(1r6(B . ?\x9E19) ;; <CJK>
     (?$(1r7(B . ?\x7229) ;; <CJK>
     (?$(1r8(B . ?\x864B) ;; <CJK>
     (?$(1r9(B . ?\x8B9F) ;; <CJK>
     (?$(1r:(B . ?\x9483) ;; <CJK>
     (?$(1r;(B . ?\x9C79) ;; <CJK>
     (?$(1r<(B . ?\x9EB7) ;; <CJK>
     (?$(1r=(B . ?\x7675) ;; <CJK>
     (?$(1r>(B . ?\x9A6B) ;; <CJK>
     (?$(1r?(B . ?\x9C7A) ;; <CJK>
     (?$(1r@(B . ?\x9E1D) ;; <CJK>
     (?$(1rA(B . ?\x7069) ;; <CJK>
     (?$(1rB(B . ?\x706A) ;; <CJK>
     (?$(1rC(B . ?\x9EA4) ;; <CJK>
     (?$(1rD(B . ?\x9F7E) ;; <CJK>
     (?$(1rE(B . ?\x9F49) ;; <CJK>
     (?$(1rF(B . ?\x9F98) ;; <CJK>
     )))

(provide 'ubig5)