;;; -*- coding: iso-2022-7bit  -*-
;;; big5conv.el --- conversion between Big5 and Emacs representation(Mainly CNS)

;; Copyright (C) 1997, 1998 Kawabata Taichi
;;               1999       Miyashita Hisashi

;; Keywords: mule, multilingual, 
;;           MULE-UCS, Big5, CNS, Traditional Chinese, RFC1922

;; This file is part of MULE-UCS

;; MULE-UCS is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; MULE-UCS is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with this program; see the file COPYING.  If not, write to the
;; Free Software Foundation, Inc., 59 Temple Place - Suite 330,
;; Boston, MA 02111-1307, USA.

;; Comment:

; (defvar big5conv-ccl-big5-to-abs
;   '((r0 = (r0 >8 0))
;     (if (r7 >= ?\xa1)
; 	((r4 = (r7 - 98)))
;       ((r4 = (r7 - 64))))
;     (r0 = (((r0 - ?\xa1) * 157) - r4))))

(require 'mucs)
(require 'tae)
(mucs-require-supplement 'big5type 'big5conv)

(defconst big5conv-encode-buffer-magnification 2) ;; LF -> CR+LF
(defconst big5conv-decode-buffer-magnification 2)

(defun big5conv-big5-to-flat-code (num)
  (let ((hi (/ num 256))
        (lo (% num 256)))
    (+ (* 157 (- hi ?\xa1))
       (- lo (if (>= lo ?\xa1) 98 64)))))

(defun big5conv-char-to-flat-code (num)
  (let ((hi (/ num 256))
        (lo (% num 256)))
    (+ (* 94 (- hi ?\x21))
       (- lo ?\x21))))

(defun big5conv-flat-code-to-big5 (num)
  (let ((hi (/ num 157))
        (lo (% num 157)))
    (+ (* 256 (+ hi ?\xa1))
       (+ lo (if (< lo 63) 64 98)))))

(defun big5conv-flat-code-to-char (num)
  (let ((hi (/ num 94))
        (lo (% num 94)))
    (list (+ hi ?\x21) (+ lo ?\x21))))

(defun big5conv-expand-alist (alist)
  (let (elem result char big5
	     i end codepoint charset)
    (while alist
      (setq elem (car alist)
	    char (car elem)
	    big5 (cdr elem)
	    alist (cdr alist))
      (cond ((and (consp char)
		  (consp big5))
	     (setq i (big5conv-big5-to-flat-code (car big5))
		   end (big5conv-big5-to-flat-code (cdr big5))
		   codepoint (big5conv-char-to-flat-code (cdr char))
		   charset (car char))
	     (while (>= end i)
	       (setq result (cons
			     (cons
			      (apply (function make-char)
				     charset
				     (big5conv-flat-code-to-char codepoint))
			      (big5conv-flat-code-to-big5 i))
			     result)
		     i (1+ i)
		     codepoint (1+ codepoint))
	     ))
	    ((and (char-valid-p char)
		  (numberp big5))
	     (setq result (cons (cons char big5)
				result)))
	    (t
	     (error "Unkown slot type:%S" elem))))
      (nreverse result)))

(defvar big5conv-ascii-assoc
  (list 'assoc
	'(char-1 . big5)
	(let ((i 0) result)
	  (while (< i 128)
	    (setq result
		  (nconc result
			 (list (cons (make-char 'ascii i) i)))
		  i (1+ i)))
	  result))
  "US-ASCII part of BIG5 translation rule")

(defvar big5conv-emacs-char-1-vs-big5-assoc
  `(assoc
    (char-1 . big5)
    ,(nconc
      (big5conv-expand-alist
       '(
	 ;; Symbols
	 ((chinese-cns11643-1 . ?\x2121) . (?\xA140 . ?\xA1F5))
	 (?$(G"X(B . ?\xA1F6)
	 (?$(G"W(B . ?\xA1F7)
	 ((chinese-cns11643-1 . ?\x2259) . (?\xA1F8 . ?\xA2AE))
	 ((chinese-cns11643-1 . ?\x2421) . (?\xA2AF . ?\xA3BF))
	 ;; Control code (vender dependant)
	 ((chinese-cns11643-1 . ?\x4221) . (?\xA3C0 . ?\xA3E0))
	 ;; Level 1 Ideograhs
	 ((chinese-cns11643-1 . ?\x4421) . (?\xA440 . ?\xACFD))
	 (?$(GWS(B . ?\xACFE)
	 ((chinese-cns11643-1 . ?\x5323) . (?\xAD40 . ?\xAFCF))
	 ((chinese-cns11643-1 . ?\x5754) . (?\xAFD0 . ?\xBBC7))
	 ((chinese-cns11643-1 . ?\x6B51) . (?\xBBC8 . ?\xBE51))
	 (?$(GkP(B . ?\xBE52)
	 ((chinese-cns11643-1 . ?\x6F5C) . (?\xBE53 . ?\xC1AA))
	 ((chinese-cns11643-1 . ?\x7536) . (?\xC1AB . ?\xC2CA))
	 (?$(Gu5(B . ?\xC2CB)
	 ((chinese-cns11643-1 . ?\x7737) . (?\xC2CC . ?\xC360))
	 ((chinese-cns11643-1 . ?\x782E) . (?\xC361 . ?\xC3B8))
	 (?$(Gxe(B . ?\xC3B9)
	 (?$(Gxd(B . ?\xC3BA)
	 ((chinese-cns11643-1 . ?\x7866) . (?\xC3BB . ?\xC455))
	 (?$(Gx-(B . ?\xC456)
	 ((chinese-cns11643-1 . ?\x7962) . (?\xC457 . ?\xC67E))
	 ;; Symbols
	 ((chinese-cns11643-1 . ?\x2621) . (?\xC6A1 . ?\xC6BE))
	 ;; Radicals
	 (?$(G'#(B . ?\xC6BF)
	 (?$(G'$(B . ?\xC6C0)
	 (?$(G'&(B . ?\xC6C1)
	 (?$(G'((B . ?\xC6C2)
	 (?$(G'-(B . ?\xC6C3)
	 (?$(G'.(B . ?\xC6C4)
	 (?$(G'/(B . ?\xC6C5)
	 (?$(G'4(B . ?\xC6C6)
	 (?$(G'7(B . ?\xC6C7)
	 (?$(G':(B . ?\xC6C8)
	 (?$(G'<(B . ?\xC6C9)
	 (?$(G'B(B . ?\xC6CA)
	 (?$(G'G(B . ?\xC6CB)
	 (?$(G'N(B . ?\xC6CC)
	 (?$(G'S(B . ?\xC6CD)
	 (?$(G'T(B . ?\xC6CE)
	 (?$(G'U(B . ?\xC6CF)
	 (?$(G'Y(B . ?\xC6D0)
	 (?$(G'Z(B . ?\xC6D1)
	 (?$(G'a(B . ?\xC6D2)
	 (?$(G'f(B . ?\xC6D3)
	 (?$(G()(B . ?\xC6D4)
	 (?$(G(*(B . ?\xC6D5)
	 (?$(G(c(B . ?\xC6D6)
	 (?$(G(l(B . ?\xC6D7)
	 ;; Diacritical Marks
	 ((japanese-jisx0208 . ?\x212F) . (?\xC6D8 . ?\xC6D9))
	 ;; Japanese Kana Supplement
	 ((japanese-jisx0208 . ?\x2133) . (?\xC6DA . ?\xC6E3))
	 ;; Japanese Hiragana
	 ((japanese-jisx0208 . ?\x2421) . (?\xC6E7 . ?\xC77A))
	 ;; Japanese Katakana
	 ((japanese-jisx0208 . ?\x2521) . (?\xC77B . ?\xC7F2))
	 ;; Cyrillic Characters
	 ((japanese-jisx0208 . ?\x2721) . (?\xC7F3 . ?\xC854))
	 ((japanese-jisx0208 . ?\x2751) . (?\xC855 . ?\xC875))
	 ;; Special Chinese Characters
	 (?$(J!#(B . ?\xC879)
	 (?$(J!$(B . ?\xC87B)
	 (?$(J!*(B . ?\xC87D)
	 (?$(J!R(B . ?\xC8A2)

	 ;; JIS X 0208 NOT SIGN (cf. U+00AC)
	 (?$B"L(B . ?\xC8CD)
	 ;; JIS X 0212 BROKEN BAR (cf. U+00A6)
	 (?$(D"C(B . ?\xC8CE)

	 ;; GB 2312 characters
	 (?$A!d(B . ?\xC8CF)
	 (?$A!e(B . ?\xC8D0)
        ;;;;; C8D1 - Japanese `($B3t(B)'
	 (?$A!m(B . ?\xC8D2)
        ;;;;; C8D2 - Tel.

	 ;; Level 2 Ideographs
	 ((chinese-cns11643-2 . ?\x2121) . (?\xC940 . ?\xC949))
	 (?$(GDB(B . ?\xC94A);; duplicates to ?\xA461
	 ((chinese-cns11643-2 . ?\x212B) . (?\xC94B . ?\xC96B))
	 ((chinese-cns11643-2 . ?\x214D) . (?\xC96C . ?\xC9BD))
	 (?$(H!L(B . ?\xC9BE)
	 ((chinese-cns11643-2 . ?\x217D) . (?\xC9BF . ?\xC9EC))
	 ((chinese-cns11643-2 . ?\x224E) . (?\xC9ED . ?\xCAF6))
	 (?$(H"M(B . ?\xCAF7)
	 ((chinese-cns11643-2 . ?\x2439) . (?\xCAF8 . ?\xD6CB))
	 (?$(H?j(B . ?\xD77A)
	 ((chinese-cns11643-2 . ?\x387E) . (?\xD77B . ?\xDADE))
	 ((chinese-cns11643-2 . ?\x3F6B) . (?\xDBA7 . ?\xDDFB))
	 (?$(HAv(B . ?\xDDFC);; duplicates to ?\xdcd1
	 ((chinese-cns11643-2 . ?\x4424) . (?\xDDFD . ?\xE8A2))
	 ((chinese-cns11643-2 . ?\x554C) . (?\xE8A3 . ?\xE975))
	 ((chinese-cns11643-2 . ?\x5723) . (?\xE976 . ?\xEB5A))
	 ((chinese-cns11643-2 . ?\x5A29) . (?\xEB5B . ?\xEBF0))
	 (?$(HUK(B . ?\xEBF1)
	 ((chinese-cns11643-2 . ?\x5B3F) . (?\xEBF2 . ?\xECDD))
	 (?$(HW"(B . ?\xECDE)
	 ((chinese-cns11643-2 . ?\x5C6A) . (?\xECDF . ?\xEDA9))
	 ((chinese-cns11643-2 . ?\x5D75) . (?\xEDAA . ?\xEEEA))
	 (?$(Hd/(B . ?\xEEEB)
	 ((chinese-cns11643-2 . ?\x6039) . (?\xEEEC . ?\xF055))
	 (?$(H]t(B . ?\xF056)
	 ((chinese-cns11643-2 . ?\x6243) . (?\xF057 . ?\xF0CA))
	 (?$(HZ((B . ?\xF0CB)
	 ((chinese-cns11643-2 . ?\x6337) . (?\xF0CC . ?\xF162))
	 ((chinese-cns11643-2 . ?\x6430) . (?\xF163 . ?\xF16A))
	 (?$(Hga(B . ?\xF16B)
	 ((chinese-cns11643-2 . ?\x6438) . (?\xF16C . ?\xF267))
	 (?$(Hi4(B . ?\xF268)
	 ((chinese-cns11643-2 . ?\x6573) . (?\xF269 . ?\xF2C2))
	 ((chinese-cns11643-2 . ?\x664E) . (?\xF2C3 . ?\xF374))
	 ((chinese-cns11643-2 . ?\x6762) . (?\xF375 . ?\xF465))
	 ((chinese-cns11643-2 . ?\x6935) . (?\xF466 . ?\xF4B4))
	 (?$(HfM(B . ?\xF4B5)
	 ((chinese-cns11643-2 . ?\x6962) . (?\xF4B6 . ?\xF4FC))
	 ((chinese-cns11643-2 . ?\x6A4C) . (?\xF4FD . ?\xF662))
	 (?$(HjK(B . ?\xF663)
	 ((chinese-cns11643-2 . ?\x6C52) . (?\xF664 . ?\xF976))
	 ((chinese-cns11643-2 . ?\x7167) . (?\xF977 . ?\xF9C3))
	 (?$(Hqf(B . ?\xF9C4)
	 (?$(Hr4(B . ?\xF9C5)
	 (?$(Hr@(B . ?\xF9C6)
	 ((chinese-cns11643-2 . ?\x7235) . (?\xF9C7 . ?\xF9D1))
	 ((chinese-cns11643-2 . ?\x7241) . (?\xF9D2 . ?\xF9D5))

	 ;; Additional Ideographs
	 (?$(IC7(B . ?\xF9D6)
	 (?$(IOP(B . ?\xF9D7)
	 (?$(IDN(B . ?\xF9D8)
	 (?$(IPJ(B . ?\xF9D9)
	 (?$(I,](B . ?\xF9DA)
	 (?$(I=~(B . ?\xF9DB)
	 (?$(IK\(B . ?\xF9DC)
	 ))
     '((all . invalid))
     )))

(provide 'big5conv)

