;;; trans-util.el --- useful functions for translating characters.

;; Copyright (C) 1997-2000 Miyashita Hisashi

;; Keywords: CCL, mule, multilingual, character set,
;;           coding-system, ISO10646, Unicode

;; This file is part of Mule-UCS

;; Mule-UCS is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; Mule-UCS is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with this program; see the file COPYING.  If not, write to the
;; Free Software Foundation, Inc., 59 Temple Place - Suite 330,
;; Boston, MA 02111-1307, USA.

(defsubst char-codepoint (char)
  "Return a codepoint of char."
  (let ((info (split-char char)))
    (if (= (length info) 3)
	(+ (* (nth 1 info) 96)
	   (nth 2 info))
      (nth 1 info))))

(defsubst make-char-from-charset-codepoint (charset codepoint)
  "Return a character of CODEPOINT in CHARSET"
  (if (> codepoint ?\xFF)
      (progn
	(setq codepoint (- codepoint ?\x20))
	(make-char charset
		   (/ codepoint 96)
		   (+ (% codepoint 96) ?\x20)))
    (make-char charset codepoint)))

;;; This function use make-char-internal.
;;; We may be supposed to reconstruct it by macro.
(defsubst make-char-from-charset-id-codepoint (charset codepoint)
  "Return a character of CODEPOINT in CHARSET"
  (if (> codepoint ?\xFF)
      (progn
	(setq codepoint (- codepoint ?\x20))
	(make-char-internal charset
			    (/ codepoint 96)
			    (+ (% codepoint 96) ?\x20)))
    (make-char-internal charset codepoint)))

(provide 'trans-util)
