;;; -*- coding: iso-2022-7bit -*-
;;; jisx0213-font.el --- Font setup and define encoder for JIS X 0213.

;; Copyright (C) 2000 KAWABATA, Taichi

;; Keywords: CCL, mule, multilingual, 
;;           character set, coding-system, JIS X 0213

;;; This program defines character set for Japanese JIS X 0213.

;;; Comment:
;; Miyashita Hisashi extracted this part
;; from JIS X 0213 package made by KAWABATA, Taichi.

;; Add them to fontset.

(require 'x0213-cdef)

(if window-system
    (let (fontset)
      (when (setq fontset (query-fontset "-*-*-medium-r-*-*-16-*-*-*-*-*-*-*"))
	(set-fontset-font fontset 'japanese-jisx0213-1 "*jisx0213.2000-1")
	(set-fontset-font fontset 'japanese-jisx0213-2 "*jisx0213.2000-2")
	;;(set-fontset-font fontset 'japanese-jisx0213-1 "*shiftjis-0")
	;;(set-fontset-font fontset 'japanese-jisx0213-2 "*shiftjis-0")
        )
      (when (setq fontset (query-fontset "-*-*-medium-r-*-*-24-*-*-*-*-*-*-*"))
	;;(set-fontset-font fontset 'japanese-jisx0213-1 "*jisx0213.2000-1")
	;;(set-fontset-font fontset 'japanese-jisx0213-2 "*jisx0213.2000-2")
	(set-fontset-font fontset 'japanese-jisx0213-1 "*shiftjis-0")
	(set-fontset-font fontset 'japanese-jisx0213-2 "*shiftjis-0")
        )))

;; Shift-JIS encoded Font$B$r;HMQ$9$k>l9g$N(Bfont encoder.

(define-ccl-program ccl-encode-shiftjis-font
  `(0
    ((if (r1 % 2) (if (r2 <= 95) (r2 += 31) (r2 += 32)) (r2 += 126))
     (if (r0 == ,(charset-id 'japanese-jisx0213-1))
         (if (r1 <= 94) (r1 = ((r1 + 225) / 2)) (r1 = ((r1 + 353) / 2)))
       (if (r1 <= 47)
           ((r3 = ((r1 / 8) * 3)) (r1 = (((r1 + 471) / 2) - r3)))
         (r1 = ((r1 + 379) / 2))))))
  "CCL program to encode a JIS X 0213 to code point of Shift-JIS font.")

(setq font-ccl-encoder-alist
      (cons (cons "shiftjis-0" 'ccl-encode-shiftjis-font)
            font-ccl-encoder-alist))

(provide 'x0213-font)
