;;;  x0213-csys.el --- Coding System Definition for JIS X 0213.

;; Copyright (C) 2000 KAWABATA, Taichi
;;                    Miyashita Hisashi

;; Keywords: CCL, mule, multilingual, 
;;           character set, coding-system, JIS X 0213

;; This program defines coding-system described in JIS X 0213 standard.

(require 'x0213-cdef)
;;; This is dirty.  We have to redesign constitution as to
;;; encode-ccl-shiftjis-font and other encoding modules.
(require 'x0213-font)

(eval-and-compile
;;; character list maker.
  (defun make-chars-list (from to)
    (let* ((from-split (split-char from))
	   (from-cs    (car from-split))
	   (from-row   (- (elt from-split 1) 33))
	   (from-col   (- (elt from-split 2) 33))
	   (from-num   (+ (* 94 from-row) from-col))
	   (to-split (split-char to))
	   (to-row   (- (elt to-split 1) 33))
	   (to-col   (- (elt to-split 2) 33))
	   (to-num   (+ (* 94 to-row) to-col))
	   table)
      (while (<= from-num to-num)
	(setq table
	      (cons (make-char from-cs
			       (+ (/ to-num 94) 33)
			       (+ (% to-num 94) 33))
		    table))
	(setq to-num (1- to-num)))
      table))

  (defun make-jisx0213-translation-pairs (from to)
    (let* ((table (make-chars-list from to)))
      (mapcar '(lambda (x) 
		 (let (split)
		   (setq split (split-char x))
		   (setcar split 'japanese-jisx0213-1)
		   (cons (apply 'make-char split) x)))
	      table))))

(eval-when-compile
  (define-translation-table
    'jisx0208-to-jisx0213
    nil)
  (define-translation-table
    'jisx0213-to-jisx0208
    nil))

;; translation table

(define-translation-table 
  'jisx0208-to-jisx0213
  (list (cons (make-char 'japanese-jisx0208)
              (make-char 'japanese-jisx0213-1))))

(define-translation-table
  'jisx0213-to-jisx0208
  (eval-when-compile
    (make-translation-table
     (nconc (make-jisx0213-translation-pairs ?$B!!(B ?$B".(B)
            (make-jisx0213-translation-pairs ?$B":(B ?$B"A(B)
            (make-jisx0213-translation-pairs ?$B"J(B ?$B"P(B)
            (make-jisx0213-translation-pairs ?$B"\(B ?$B"j(B)
            (make-jisx0213-translation-pairs ?$B"r(B ?$B"y(B)
            (make-jisx0213-translation-pairs ?$B"~(B ?$B"~(B)
            (make-jisx0213-translation-pairs ?$B#0(B ?$B#9(B)
            (make-jisx0213-translation-pairs ?$B#A(B ?$B#Z(B)
            (make-jisx0213-translation-pairs ?$B#a(B ?$B#z(B)
            (make-jisx0213-translation-pairs ?$B$!(B ?$B$s(B)
            (make-jisx0213-translation-pairs ?$B%!(B ?$B%v(B)
            (make-jisx0213-translation-pairs ?$B&!(B ?$B&8(B)
            (make-jisx0213-translation-pairs ?$B&A(B ?$B&X(B)
            (make-jisx0213-translation-pairs ?$B'!(B ?$B'A(B)
            (make-jisx0213-translation-pairs ?$B'Q(B ?$B'q(B)
            (make-jisx0213-translation-pairs ?$B(!(B ?$B(@(B)
            (make-jisx0213-translation-pairs ?$B0!(B ?$BOS(B)
            (make-jisx0213-translation-pairs ?$BP!(B ?$Bt&(B)))))

;;;
;;; JIS X 0213$B$N(BISO-2022$B7OE}$N(Bcoding-system$B$NDj5A(B
;;;

(make-coding-system
 'iso-2022-jp-3 2 ?J
 "ISO 2022 based 7bit encoding for JIS X 0213 (MIME:ISO-2022-JP-3)"
 '((ascii japanese-jisx0213-1 japanese-jisx0213-2) nil nil nil
   short ascii-eol ascii-cntl seven)
 `((safe-charsets ascii japanese-jisx0208 
                  japanese-jisx0213-1 japanese-jisx0213-2)
   (mime-charset . iso-2022-jp-3)
   (translation-table-for-encode . ,(get 'jisx0208-to-jisx0213 
                                         'translation-table))
   (translation-table-for-decode . ,(get 'jisx0213-to-jisx0208
                                         'translation-table))))

(make-coding-system
 'euc-jisx0213 2 ?E
 "ISO 2022 based EUC encoding for JIS X 0213 (MIME:EUC-JISX0213)"
 '(ascii japanese-jisx0213-1 katakana-jisx0201 japanese-jisx0213-2
   short ascii-eol ascii-cntl nil nil single-shift)
 `((safe-charsets ascii katakana-jisx0201 japanese-jisx0208
                  japanese-jisx0213-1 japanese-jisx0213-2)
   (mime-charset . euc-jisx0213)
   (translation-table-for-encode . ,(get 'jisx0208-to-jisx0213 
                                         'translation-table))
   (translation-table-for-decode . ,(get 'jisx0213-to-jisx0208
                                         'translation-table))))

;;;
;;; Shift-JIS
;;;

(define-ccl-program ccl-decode-sjisx0213
  `(2
    (loop
     ;; 1-byte character
     (read r1)
     (if (r1 <= 128) (write-repeat r1))
     (r0 = (r1 >= 253))
     (r0 |= (r1 < 224))
     (r0 &= (r1 >= 160))
     (if r0 ((r0 = ,(charset-id 'katakana-jisx0201))
             (write-multibyte-character r0 r1)
             (repeat)))
     (read r2)
     (r0 = (r2 >= 253))
     (r0 |= (r2 < 64))
     (r0 |= (r2 == 127))
     (if r0 ((write r1) (write r2) (repeat)))
     ;; r0
     (if (r1 < 240)
	 (r0 = ,(charset-id 'japanese-jisx0213-1))
       (r0 = ,(charset-id 'japanese-jisx0213-2)))
     ;; r1
     (r1 <<= 1)
     (if (r2 < 159) (r1 -= 1))
     (if (r1 < 320) (r1 -= 224)
       (if (r1 < 479) (r1 -= 352)
         (if (r1 > 487) (r1 -= 378)
           (if (r1 > 483) (r1 -= 440)
             (if (r1 == 480) (r1 -= 440) 
               (r1 -= 446))))))
     ;; r2
     (if (r2 < 159) 
         (if (r2 > 127) (r2 -= 32) (r2 -= 31)) 
       (r2 -= 126))
     ;; combine
     (r1 <<= 7)
     (r1 += r2)
     (translate-character jisx0213-to-jisx0208 r0 r1)
     (write-multibyte-character r0 r1)
     (repeat))))

(define-ccl-program ccl-encode-sjisx0213
  `(1
    (loop
     (read-multibyte-character r0 r1)
     (translate-character jisx0208-to-jisx0213 r0 r1)
     (if (r0 != ,(charset-id 'japanese-jisx0213-1))
         (if (r0 != ,(charset-id 'japanese-jisx0213-2))
             (write-repeat r1)))
     (r2 = (r1 & 127))
     (r1 >>= 7)
     (call ccl-encode-shiftjis-font)
     (write r1)
     (write-repeat r2))))

(make-coding-system
 'japanese-shift-jisx0213 4
 ?S "Shift_JISX0213 encoding for Japanese (MIME: Shift_JISX0213)."
 '(ccl-decode-sjisx0213 . ccl-encode-sjisx0213)
 `((safe-charsets ascii japanese-jisx0208 katakana-jisx0201
                  japanese-jisx0213-1 japanese-jisx0213-2)
   (mime-charset . shift_jisx0213)
   (translation-table-for-encode . ,(get 'jisx0208-to-jisx0213 
                                         'translation-table))
   (translation-table-for-decode . ,(get 'jisx0213-to-jisx0208
                                         'translation-table))))

(define-coding-system-alias 'shift_jisx0213 'japanese-shift-jisx0213)

(provide 'x0213-csys)
