; -*- coding: iso-2022-7bit  -*-
;;; x0213-char.el -- JIS X 0213 character name utility.

;; Copyright (C) 2000 KAWABATA, Taichi

;; Keywords: mule, multilingual, Mule-UCS, JIS X 0213

;; This file is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2 of the License, or
;; (at your option) any later version.
;;
;; This program is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.
;;
;; You should have received a copy of the GNU General Public License
;; along with this program; if not, write to the Free Software
;; Foundation, Inc., 59 Temple Place - Suite 330,
;; Boston, MA 02111-1307, USA.

(require 'x0213-util)

(let 
 ((jisx0213-charnames
   '((?$(O!!(B . "IDEOGRAPHIC SPACE")
     (?$(O!"(B . "IDEOGRAPHIC COMMA")
     (?$(O!#(B . "IDEOGRAPHIC FULL STOP")
     (?$(O!$(B . "COMMA")
     (?$(O!%(B . "FULL STOP")
     (?$(O!&(B . "KATAKANA MIDDLE DOT")
     (?$(O!'(B . "COLON")
     (?$(O!((B . "SEMICOLON")
     (?$(O!)(B . "QUESTION MARK")
     (?$(O!*(B . "EXCLAMATION MARK")
     (?$(O!+(B . "KATAKANA-HIRAGANA VOICED SOUND MARK")
     (?$(O!,(B . "KATAKANA-HIRAGANA SEMI-VOICED SOUND MARK")
     (?$(O!-(B . "ACUTE ACCENT")
     (?$(O!.(B . "GRAVE ACCENT")
     (?$(O!/(B . "DIAERESIS")
     (?$(O!0(B . "CIRCUMFLEX ACCENT")
     (?$(O!1(B . "OVERLINE")
     (?$(O!2(B . "LOW LINE")
     (?$(O!3(B . "KATAKANA ITERATION MARK")
     (?$(O!4(B . "KATAKANA VOICED ITERATION MARK")
     (?$(O!5(B . "HIRAGANA ITERATION MARK")
     (?$(O!6(B . "HIRAGANA VOICED ITERATION MARK")
     (?$(O!7(B . "DITTO MARK")
     (?$(O!8(B . "CJK UNIFIED IDEOGRAPH-4EDD")
     (?$(O!9(B . "IDEOGRAPHIC ITERATION MARK")
     (?$(O!:(B . "IDEOGRAPHIC CLOSING MARK")
     (?$(O!;(B . "IDEOGRAPHIC NUMBER ZERO")
     (?$(O!<(B . "KATAKANA-HIRAGANA PROLONGED SOUND MARK")
     (?$(O!=(B . "EM DASH")
     (?$(O!>(B . "HYPHEN")
     (?$(O!?(B . "SOLIDUS")
     (?$(O!@(B . "REVERSE SOLIDUS")
     (?$(O!A(B . "WAVE DASH")
     (?$(O!B(B . "DOUBLE VERTICAL LINE")
     (?$(O!C(B . "VERTICAL LINE")
     (?$(O!D(B . "HORIZONTAL ELLIPSIS")
     (?$(O!E(B . "TWO DOT LEADER")
     (?$(O!F(B . "LEFT SINGLE QUOTATION MARK")
     (?$(O!G(B . "RIGHT SINGLE QUOTATION MARK")
     (?$(O!H(B . "LEFT DOUBLE QUOTATION MARK")
     (?$(O!I(B . "RIGHT DOUBLE QUOTATION MARK")
     (?$(O!J(B . "LEFT PARENTHESIS")
     (?$(O!K(B . "RIGHT PARENTHESIS")
     (?$(O!L(B . "LEFT TORTOISE SHELL BRACKET")
     (?$(O!M(B . "RIGHT TORTOISE SHELL BRACKET")
     (?$(O!N(B . "LEFT SQUARE BRACKET")
     (?$(O!O(B . "RIGHT SQUARE BRACKET")
     (?$(O!P(B . "LEFT CURLY BRACKET")
     (?$(O!Q(B . "RIGHT CURLY BRACKET")
     (?$(O!R(B . "LEFT ANGLE BRACKET")
     (?$(O!S(B . "RIGHT ANGLE BRACKET")
     (?$(O!T(B . "LEFT DOUBLE ANGLE BRACKET")
     (?$(O!U(B . "RIGHT DOUBLE ANGLE BRACKET")
     (?$(O!V(B . "LEFT CORNER BRACKET")
     (?$(O!W(B . "RIGHT CORNER BRACKET")
     (?$(O!X(B . "LEFT WHITE CORNER BRACKET")
     (?$(O!Y(B . "RIGHT WHITE CORNER BRACKET")
     (?$(O!Z(B . "LEFT BLACK LENTICULAR BRACKET")
     (?$(O![(B . "RIGHT BLACK LENTICULAR BRACKET")
     (?$(O!\(B . "PLUS SIGN")
     (?$(O!](B . "MINUS SIGN")
     (?$(O!^(B . "PLUS-MINUS SIGN")
     (?$(O!_(B . "MULTIPLICATION SIGN")
     (?$(O!`(B . "DIVISION SIGN")
     (?$(O!a(B . "EQUALS SIGN")
     (?$(O!b(B . "NOT EQUAL TO")
     (?$(O!c(B . "LESS-THAN SIGN")
     (?$(O!d(B . "GREATER-THAN SIGN")
     (?$(O!e(B . "LESS-THAN OVER EQUAL TO")
     (?$(O!f(B . "GREATER-THAN OVER EQUAL TO")
     (?$(O!g(B . "INFINITY")
     (?$(O!h(B . "THEREFORE")
     (?$(O!i(B . "MALE SIGN")
     (?$(O!j(B . "FEMALE SIGN")
     (?$(O!k(B . "DEGREE SIGN")
     (?$(O!l(B . "PRIME")
     (?$(O!m(B . "DOUBLE PRIME")
     (?$(O!n(B . "DEGREE CELSIUS")
     (?$(O!o(B . "YEN SIGN")
     (?$(O!p(B . "DOLLAR SIGN")
     (?$(O!q(B . "CENT SIGN")
     (?$(O!r(B . "POUND SIGN")
     (?$(O!s(B . "PERCENT SIGN")
     (?$(O!t(B . "NUMBER SIGN")
     (?$(O!u(B . "AMPERSAND")
     (?$(O!v(B . "ASTERISK")
     (?$(O!w(B . "COMMERCIAL AT")
     (?$(O!x(B . "SECTION SIGN")
     (?$(O!y(B . "WHITE STAR")
     (?$(O!z(B . "BLACK STAR")
     (?$(O!{(B . "WHITE CIRCLE")
     (?$(O!|(B . "BLACK CIRCLE")
     (?$(O!}(B . "BULLSEYE")
     (?$(O!~(B . "WHITE DIAMOND")
     (?$(O"!(B . "BLACK DIAMOND")
     (?$(O""(B . "WHITE SQUARE")
     (?$(O"#(B . "BLACK SQUARE")
     (?$(O"$(B . "WHITE UP-POINTING TRIANGLE")
     (?$(O"%(B . "BLACK UP-POINTING TRIANGLE")
     (?$(O"&(B . "WHITE DOWN-POINTING TRIANGLE")
     (?$(O"'(B . "BLACK DOWN-POINTING TRIANGLE")
     (?$(O"((B . "REFERENCE MARK")
     (?$(O")(B . "POSTAL MARK")
     (?$(O"*(B . "RIGHTWARDS ARROW")
     (?$(O"+(B . "LEFTWARDS ARROW")
     (?$(O",(B . "UPWARDS ARROW")
     (?$(O"-(B . "DOWNWARDS ARROW")
     (?$(O".(B . "GETA MARK")
     (?$(O"/(B . "APOSTROPHE")
     (?$(O"0(B . "QUOTATION MARK")
     (?$(O"1(B . "HYPHEN-MINUS")
     (?$(O"2(B . "TILDE")
     (?$(O"3(B . "VERTICAL KANA REPEAT MARK UPPER HALF")
     (?$(O"4(B . "VERTICAL KANA REPEAT WITH VOICED SOUND MARK UPPER HALF")
     (?$(O"5(B . "VERTICAL KANA REPEAT MARK LOWER HALF")
     (?$(O"6(B . "[ITERATION MARK]")
     (?$(O"7(B . "[MASU MARK]")
     (?$(O"8(B . "[KATAKANA DIGRAPH KOTO]")
     (?$(O"9(B . "[HIRAGANA DIGRAPH YORI]")
     (?$(O":(B . "ELEMENT OF")
     (?$(O";(B . "CONTAINS AS MEMBER")
     (?$(O"<(B . "SUBSET OF OR EQUAL TO")
     (?$(O"=(B . "SUPERSET OF OR EQUAL TO")
     (?$(O">(B . "SUBSET OF")
     (?$(O"?(B . "SUPERSET OF")
     (?$(O"@(B . "UNION")
     (?$(O"A(B . "INTERSECTION")
     (?$(O"B(B . "NOT A SUBSET OF")
     (?$(O"C(B . "NOT A SUPERSET OF")
     (?$(O"D(B . "SUBSET OF WITH NOT EQUAL TO")
     (?$(O"E(B . "SUPERSET OF WITH NOT EQUAL TO")
     (?$(O"F(B . "NOT AN ELEMENT OF")
     (?$(O"G(B . "EMPTY SET")
     (?$(O"H(B . "PROJECTIVE")
     (?$(O"I(B . "PERSPECTIVE")
     (?$(O"J(B . "LOGICAL AND")
     (?$(O"K(B . "LOGICAL OR")
     (?$(O"L(B . "NOT SIGN")
     (?$(O"M(B . "RIGHTWARDS DOUBLE ARROW")
     (?$(O"N(B . "LEFT RIGHT DOUBLE ARROW")
     (?$(O"O(B . "FOR ALL")
     (?$(O"P(B . "THERE EXISTS")
     (?$(O"Q(B . "CIRCLED PLUS")
     (?$(O"R(B . "CIRCLED MINUS")
     (?$(O"S(B . "CIRCLED TIMES")
     (?$(O"T(B . "PARALLEL TO")
     (?$(O"U(B . "NOT PARALLEL TO")
     (?$(O"V(B . "[LEFT WHITE PARENTHESIS]")
     (?$(O"W(B . "[RIGHT WHITE PARENTHESIS]")
     (?$(O"X(B . "LEFT WHITE TORTOISE SHELL BRACKET")
     (?$(O"Y(B . "RIGHT WHITE TORTOISE SHELL BRACKET")
     (?$(O"Z(B . "LEFT WHITE LENTICULAR BRACKET")
     (?$(O"[(B . "RIGHT WHITE LENTICULAR BRACKET")
     (?$(O"\(B . "ANGLE")
     (?$(O"](B . "UP TACK")
     (?$(O"^(B . "ARC")
     (?$(O"_(B . "PARTIAL DIFFERENTIAL")
     (?$(O"`(B . "NABLA")
     (?$(O"a(B . "IDENTICAL TO")
     (?$(O"b(B . "APPROXIMATELY EQUAL TO OR THE IMAGE OF")
     (?$(O"c(B . "MUCH LESS-THAN")
     (?$(O"d(B . "MUCH GREATER-THAN")
     (?$(O"e(B . "SQUARE ROOT")
     (?$(O"f(B . "REVERSED TILDE")
     (?$(O"g(B . "PROPORTIONAL TO")
     (?$(O"h(B . "BECAUSE")
     (?$(O"i(B . "INTEGRAL")
     (?$(O"j(B . "DOUBLE INTEGRAL")
     (?$(O"k(B . "NOT IDENTICAL TO")
     (?$(O"l(B . "ASYMPTOTICALLY EQUAL TO")
     (?$(O"m(B . "APPROXIMATELY EQUAL TO")
     (?$(O"n(B . "ALMOST EQUAL TO")
     (?$(O"o(B . "LESS-THAN OR GREATER-THAN")
     (?$(O"p(B . "GREATER-THAN OR LESS-THAN")
     (?$(O"q(B . "LEFT RIGHT ARROW")
     (?$(O"r(B . "ANGSTROM SIGN")
     (?$(O"s(B . "PER MILLE SIGN")
     (?$(O"t(B . "MUSIC SHARP SIGN")
     (?$(O"u(B . "MUSIC FLAT SIGN")
     (?$(O"v(B . "EIGHTH NOTE")
     (?$(O"w(B . "DAGGER")
     (?$(O"x(B . "DOUBLE DAGGER")
     (?$(O"y(B . "PILCROW SIGN")
     (?$(O"z(B . "MUSIC NATURAL SIGN")
     (?$(O"{(B . "BEAMED EIGHTH NOTES")
     (?$(O"|(B . "BEAMED SIXTEENTH NOTES")
     (?$(O"}(B . "QUARTER NOTE")
     (?$(O"~(B . "LARGE CIRCLE")
     (?$(O#!(B . "WHITE RIGHT-POINTING TRIANGLE")
     (?$(O#"(B . "BLACK RIGHT-POINTING TRIANGLE")
     (?$(O##(B . "WHITE LEFT-POINTING TRIANGLE")
     (?$(O#$(B . "BLACK LEFT-POINTING TRIANGLE")
     (?$(O#%(B . "NORTH EAST ARROW")
     (?$(O#&(B . "SOUTH EAST ARROW")
     (?$(O#'(B . "NORTH WEST ARROW")
     (?$(O#((B . "SOUTH WEST ARROW")
     (?$(O#)(B . "RIGHTWARDS ARROW OVER LEFTWARDS ARROW")
     (?$(O#*(B . "RIGHTWARDS WHITE ARROW")
     (?$(O#+(B . "LEFTWARDS WHITE ARROW")
     (?$(O#,(B . "UPWARDS WHITE ARROW")
     (?$(O#-(B . "DOWNWARDS WHITE ARROW")
     (?$(O#.(B . "[RIGHTWARD ARROW WITH CURVE UPWARD]")
     (?$(O#/(B . "[RIGHTWARD ARROW WITH CURVE DOWNWARD]")
     (?$(O#0(B . "DIGIT ZERO")
     (?$(O#1(B . "DIGIT ONE")
     (?$(O#2(B . "DIGIT TWO")
     (?$(O#3(B . "DIGIT THREE")
     (?$(O#4(B . "DIGIT FOUR")
     (?$(O#5(B . "DIGIT FIVE")
     (?$(O#6(B . "DIGIT SIX")
     (?$(O#7(B . "DIGIT SEVEN")
     (?$(O#8(B . "DIGIT EIGHT")
     (?$(O#9(B . "DIGIT NINE")
     (?$(O#:(B . "[CIRCLED BULLET]")
     (?$(O#;(B . "FISHEYE")
     (?$(O#<(B . "[PART-ALTERNATION MARK]")
     (?$(O#=(B . "[WHITE SESAME DOT]")
     (?$(O#>(B . "[SESAME DOT]")
     (?$(O#?(B . "WHITE BULLET")
     (?$(O#@(B . "BULLET")
     (?$(O#A(B . "LATIN CAPITAL LETTER A")
     (?$(O#B(B . "LATIN CAPITAL LETTER B")
     (?$(O#C(B . "LATIN CAPITAL LETTER C")
     (?$(O#D(B . "LATIN CAPITAL LETTER D")
     (?$(O#E(B . "LATIN CAPITAL LETTER E")
     (?$(O#F(B . "LATIN CAPITAL LETTER F")
     (?$(O#G(B . "LATIN CAPITAL LETTER G")
     (?$(O#H(B . "LATIN CAPITAL LETTER H")
     (?$(O#I(B . "LATIN CAPITAL LETTER I")
     (?$(O#J(B . "LATIN CAPITAL LETTER J")
     (?$(O#K(B . "LATIN CAPITAL LETTER K")
     (?$(O#L(B . "LATIN CAPITAL LETTER L")
     (?$(O#M(B . "LATIN CAPITAL LETTER M")
     (?$(O#N(B . "LATIN CAPITAL LETTER N")
     (?$(O#O(B . "LATIN CAPITAL LETTER O")
     (?$(O#P(B . "LATIN CAPITAL LETTER P")
     (?$(O#Q(B . "LATIN CAPITAL LETTER Q")
     (?$(O#R(B . "LATIN CAPITAL LETTER R")
     (?$(O#S(B . "LATIN CAPITAL LETTER S")
     (?$(O#T(B . "LATIN CAPITAL LETTER T")
     (?$(O#U(B . "LATIN CAPITAL LETTER U")
     (?$(O#V(B . "LATIN CAPITAL LETTER V")
     (?$(O#W(B . "LATIN CAPITAL LETTER W")
     (?$(O#X(B . "LATIN CAPITAL LETTER X")
     (?$(O#Y(B . "LATIN CAPITAL LETTER Y")
     (?$(O#Z(B . "LATIN CAPITAL LETTER Z")
     (?$(O#[(B . "MINUS-OR-PLUS SIGN")
     (?$(O#\(B . "ALEF SYMBOL")
     (?$(O#](B . "PLANCK CONSTANT OVER TWO PI")
     (?$(O#^(B . "SQUARE HP")
     (?$(O#_(B . "SCRIPT SMALL L")
     (?$(O#`(B . "INVERTED OHM SIGN")
     (?$(O#a(B . "LATIN SMALL LETTER A")
     (?$(O#b(B . "LATIN SMALL LETTER B")
     (?$(O#c(B . "LATIN SMALL LETTER C")
     (?$(O#d(B . "LATIN SMALL LETTER D")
     (?$(O#e(B . "LATIN SMALL LETTER E")
     (?$(O#f(B . "LATIN SMALL LETTER F")
     (?$(O#g(B . "LATIN SMALL LETTER G")
     (?$(O#h(B . "LATIN SMALL LETTER H")
     (?$(O#i(B . "LATIN SMALL LETTER I")
     (?$(O#j(B . "LATIN SMALL LETTER J")
     (?$(O#k(B . "LATIN SMALL LETTER K")
     (?$(O#l(B . "LATIN SMALL LETTER L")
     (?$(O#m(B . "LATIN SMALL LETTER M")
     (?$(O#n(B . "LATIN SMALL LETTER N")
     (?$(O#o(B . "LATIN SMALL LETTER O")
     (?$(O#p(B . "LATIN SMALL LETTER P")
     (?$(O#q(B . "LATIN SMALL LETTER Q")
     (?$(O#r(B . "LATIN SMALL LETTER R")
     (?$(O#s(B . "LATIN SMALL LETTER S")
     (?$(O#t(B . "LATIN SMALL LETTER T")
     (?$(O#u(B . "LATIN SMALL LETTER U")
     (?$(O#v(B . "LATIN SMALL LETTER V")
     (?$(O#w(B . "LATIN SMALL LETTER W")
     (?$(O#x(B . "LATIN SMALL LETTER X")
     (?$(O#y(B . "LATIN SMALL LETTER Y")
     (?$(O#z(B . "LATIN SMALL LETTER Z")
     (?$(O#{(B . "[DOUBLE HYPHEN]")
     (?$(O#|(B . "EN DASH")
     (?$(O#}(B . "[DOUBLE PLUS]")
     (?$(O#~(B . "[TRIPLE PLUS]")
     (?$(O$!(B . "HIRAGANA LETTER SMALL A")
     (?$(O$"(B . "HIRAGANA LETTER A")
     (?$(O$#(B . "HIRAGANA LETTER SMALL I")
     (?$(O$$(B . "HIRAGANA LETTER I")
     (?$(O$%(B . "HIRAGANA LETTER SMALL U")
     (?$(O$&(B . "HIRAGANA LETTER U")
     (?$(O$'(B . "HIRAGANA LETTER SMALL E")
     (?$(O$((B . "HIRAGANA LETTER E")
     (?$(O$)(B . "HIRAGANA LETTER SMALL O")
     (?$(O$*(B . "HIRAGANA LETTER O")
     (?$(O$+(B . "HIRAGANA LETTER KA")
     (?$(O$,(B . "HIRAGANA LETTER GA")
     (?$(O$-(B . "HIRAGANA LETTER KI")
     (?$(O$.(B . "HIRAGANA LETTER GI")
     (?$(O$/(B . "HIRAGANA LETTER KU")
     (?$(O$0(B . "HIRAGANA LETTER GU")
     (?$(O$1(B . "HIRAGANA LETTER KE")
     (?$(O$2(B . "HIRAGANA LETTER GE")
     (?$(O$3(B . "HIRAGANA LETTER KO")
     (?$(O$4(B . "HIRAGANA LETTER GO")
     (?$(O$5(B . "HIRAGANA LETTER SA")
     (?$(O$6(B . "HIRAGANA LETTER ZA")
     (?$(O$7(B . "HIRAGANA LETTER SI")
     (?$(O$8(B . "HIRAGANA LETTER ZI")
     (?$(O$9(B . "HIRAGANA LETTER SU")
     (?$(O$:(B . "HIRAGANA LETTER ZU")
     (?$(O$;(B . "HIRAGANA LETTER SE")
     (?$(O$<(B . "HIRAGANA LETTER ZE")
     (?$(O$=(B . "HIRAGANA LETTER SO")
     (?$(O$>(B . "HIRAGANA LETTER ZO")
     (?$(O$?(B . "HIRAGANA LETTER TA")
     (?$(O$@(B . "HIRAGANA LETTER DA")
     (?$(O$A(B . "HIRAGANA LETTER TI")
     (?$(O$B(B . "HIRAGANA LETTER DI")
     (?$(O$C(B . "HIRAGANA LETTER SMALL TU")
     (?$(O$D(B . "HIRAGANA LETTER TU")
     (?$(O$E(B . "HIRAGANA LETTER DU")
     (?$(O$F(B . "HIRAGANA LETTER TE")
     (?$(O$G(B . "HIRAGANA LETTER DE")
     (?$(O$H(B . "HIRAGANA LETTER TO")
     (?$(O$I(B . "HIRAGANA LETTER DO")
     (?$(O$J(B . "HIRAGANA LETTER NA")
     (?$(O$K(B . "HIRAGANA LETTER NI")
     (?$(O$L(B . "HIRAGANA LETTER NU")
     (?$(O$M(B . "HIRAGANA LETTER NE")
     (?$(O$N(B . "HIRAGANA LETTER NO")
     (?$(O$O(B . "HIRAGANA LETTER HA")
     (?$(O$P(B . "HIRAGANA LETTER BA")
     (?$(O$Q(B . "HIRAGANA LETTER PA")
     (?$(O$R(B . "HIRAGANA LETTER HI")
     (?$(O$S(B . "HIRAGANA LETTER BI")
     (?$(O$T(B . "HIRAGANA LETTER PI")
     (?$(O$U(B . "HIRAGANA LETTER HU")
     (?$(O$V(B . "HIRAGANA LETTER BU")
     (?$(O$W(B . "HIRAGANA LETTER PU")
     (?$(O$X(B . "HIRAGANA LETTER HE")
     (?$(O$Y(B . "HIRAGANA LETTER BE")
     (?$(O$Z(B . "HIRAGANA LETTER PE")
     (?$(O$[(B . "HIRAGANA LETTER HO")
     (?$(O$\(B . "HIRAGANA LETTER BO")
     (?$(O$](B . "HIRAGANA LETTER PO")
     (?$(O$^(B . "HIRAGANA LETTER MA")
     (?$(O$_(B . "HIRAGANA LETTER MI")
     (?$(O$`(B . "HIRAGANA LETTER MU")
     (?$(O$a(B . "HIRAGANA LETTER ME")
     (?$(O$b(B . "HIRAGANA LETTER MO")
     (?$(O$c(B . "HIRAGANA LETTER SMALL YA")
     (?$(O$d(B . "HIRAGANA LETTER YA")
     (?$(O$e(B . "HIRAGANA LETTER SMALL YU")
     (?$(O$f(B . "HIRAGANA LETTER YU")
     (?$(O$g(B . "HIRAGANA LETTER SMALL YO")
     (?$(O$h(B . "HIRAGANA LETTER YO")
     (?$(O$i(B . "HIRAGANA LETTER RA")
     (?$(O$j(B . "HIRAGANA LETTER RI")
     (?$(O$k(B . "HIRAGANA LETTER RU")
     (?$(O$l(B . "HIRAGANA LETTER RE")
     (?$(O$m(B . "HIRAGANA LETTER RO")
     (?$(O$n(B . "HIRAGANA LETTER SMALL WA")
     (?$(O$o(B . "HIRAGANA LETTER WA")
     (?$(O$p(B . "HIRAGANA LETTER WI")
     (?$(O$q(B . "HIRAGANA LETTER WE")
     (?$(O$r(B . "HIRAGANA LETTER WO")
     (?$(O$s(B . "HIRAGANA LETTER N")
     (?$(O$t(B . "HIRAGANA LETTER VU")
     (?$(O$u(B . "[HIRAGANA LETTER SMALL KA]")
     (?$(O$v(B . "[HIRAGANA LETTER SMALL KE]")
     (?$(O$w(B . "[HIRAGANA LETTER BIDAKUON NGA]")
     (?$(O$x(B . "[HIRAGANA LETTER BIDAKUON NGI]")
     (?$(O$y(B . "[HIRAGANA LETTER BIDAKUON NGU]")
     (?$(O$z(B . "[HIRAGANA LETTER BIDAKUON NGE]")
     (?$(O${(B . "[HIRAGANA LETTER BIDAKUON NGO]")
     (?$(O%!(B . "KATAKANA LETTER SMALL A")
     (?$(O%"(B . "KATAKANA LETTER A")
     (?$(O%#(B . "KATAKANA LETTER SMALL I")
     (?$(O%$(B . "KATAKANA LETTER I")
     (?$(O%%(B . "KATAKANA LETTER SMALL U")
     (?$(O%&(B . "KATAKANA LETTER U")
     (?$(O%'(B . "KATAKANA LETTER SMALL E")
     (?$(O%((B . "KATAKANA LETTER E")
     (?$(O%)(B . "KATAKANA LETTER SMALL O")
     (?$(O%*(B . "KATAKANA LETTER O")
     (?$(O%+(B . "KATAKANA LETTER KA")
     (?$(O%,(B . "KATAKANA LETTER GA")
     (?$(O%-(B . "KATAKANA LETTER KI")
     (?$(O%.(B . "KATAKANA LETTER GI")
     (?$(O%/(B . "KATAKANA LETTER KU")
     (?$(O%0(B . "KATAKANA LETTER GU")
     (?$(O%1(B . "KATAKANA LETTER KE")
     (?$(O%2(B . "KATAKANA LETTER GE")
     (?$(O%3(B . "KATAKANA LETTER KO")
     (?$(O%4(B . "KATAKANA LETTER GO")
     (?$(O%5(B . "KATAKANA LETTER SA")
     (?$(O%6(B . "KATAKANA LETTER ZA")
     (?$(O%7(B . "KATAKANA LETTER SI")
     (?$(O%8(B . "KATAKANA LETTER ZI")
     (?$(O%9(B . "KATAKANA LETTER SU")
     (?$(O%:(B . "KATAKANA LETTER ZU")
     (?$(O%;(B . "KATAKANA LETTER SE")
     (?$(O%<(B . "KATAKANA LETTER ZE")
     (?$(O%=(B . "KATAKANA LETTER SO")
     (?$(O%>(B . "KATAKANA LETTER ZO")
     (?$(O%?(B . "KATAKANA LETTER TA")
     (?$(O%@(B . "KATAKANA LETTER DA")
     (?$(O%A(B . "KATAKANA LETTER TI")
     (?$(O%B(B . "KATAKANA LETTER DI")
     (?$(O%C(B . "KATAKANA LETTER SMALL TU")
     (?$(O%D(B . "KATAKANA LETTER TU")
     (?$(O%E(B . "KATAKANA LETTER DU")
     (?$(O%F(B . "KATAKANA LETTER TE")
     (?$(O%G(B . "KATAKANA LETTER DE")
     (?$(O%H(B . "KATAKANA LETTER TO")
     (?$(O%I(B . "KATAKANA LETTER DO")
     (?$(O%J(B . "KATAKANA LETTER NA")
     (?$(O%K(B . "KATAKANA LETTER NI")
     (?$(O%L(B . "KATAKANA LETTER NU")
     (?$(O%M(B . "KATAKANA LETTER NE")
     (?$(O%N(B . "KATAKANA LETTER NO")
     (?$(O%O(B . "KATAKANA LETTER HA")
     (?$(O%P(B . "KATAKANA LETTER BA")
     (?$(O%Q(B . "KATAKANA LETTER PA")
     (?$(O%R(B . "KATAKANA LETTER HI")
     (?$(O%S(B . "KATAKANA LETTER BI")
     (?$(O%T(B . "KATAKANA LETTER PI")
     (?$(O%U(B . "KATAKANA LETTER HU")
     (?$(O%V(B . "KATAKANA LETTER BU")
     (?$(O%W(B . "KATAKANA LETTER PU")
     (?$(O%X(B . "KATAKANA LETTER HE")
     (?$(O%Y(B . "KATAKANA LETTER BE")
     (?$(O%Z(B . "KATAKANA LETTER PE")
     (?$(O%[(B . "KATAKANA LETTER HO")
     (?$(O%\(B . "KATAKANA LETTER BO")
     (?$(O%](B . "KATAKANA LETTER PO")
     (?$(O%^(B . "KATAKANA LETTER MA")
     (?$(O%_(B . "KATAKANA LETTER MI")
     (?$(O%`(B . "KATAKANA LETTER MU")
     (?$(O%a(B . "KATAKANA LETTER ME")
     (?$(O%b(B . "KATAKANA LETTER MO")
     (?$(O%c(B . "KATAKANA LETTER SMALL YA")
     (?$(O%d(B . "KATAKANA LETTER YA")
     (?$(O%e(B . "KATAKANA LETTER SMALL YU")
     (?$(O%f(B . "KATAKANA LETTER YU")
     (?$(O%g(B . "KATAKANA LETTER SMALL YO")
     (?$(O%h(B . "KATAKANA LETTER YO")
     (?$(O%i(B . "KATAKANA LETTER RA")
     (?$(O%j(B . "KATAKANA LETTER RI")
     (?$(O%k(B . "KATAKANA LETTER RU")
     (?$(O%l(B . "KATAKANA LETTER RE")
     (?$(O%m(B . "KATAKANA LETTER RO")
     (?$(O%n(B . "KATAKANA LETTER SMALL WA")
     (?$(O%o(B . "KATAKANA LETTER WA")
     (?$(O%p(B . "KATAKANA LETTER WI")
     (?$(O%q(B . "KATAKANA LETTER WE")
     (?$(O%r(B . "KATAKANA LETTER WO")
     (?$(O%s(B . "KATAKANA LETTER N")
     (?$(O%t(B . "KATAKANA LETTER VU")
     (?$(O%u(B . "KATAKANA LETTER SMALL KA")
     (?$(O%v(B . "KATAKANA LETTER SMALL KE")
     (?$(O%w(B . "[KATAKANA LETTER BIDAKUON NGA]")
     (?$(O%x(B . "[KATAKANA LETTER BIDAKUON NGI]")
     (?$(O%y(B . "[KATAKANA LETTER BIDAKUON NGU]")
     (?$(O%z(B . "[KATAKANA LETTER BIDAKUON NGE]")
     (?$(O%{(B . "[KATAKANA LETTER BIDAKUON NGO]")
     (?$(O%|(B . "[KATAKANA LETTER AINU CE]")
     (?$(O%}(B . "[KATAKANA LETTER AINU TU (TU)]")
     (?$(O%~(B . "[KATAKANA LETTER AINU TO (TU)]")
     (?$(O&!(B . "GREEK CAPITAL LETTER ALPHA")
     (?$(O&"(B . "GREEK CAPITAL LETTER BETA")
     (?$(O&#(B . "GREEK CAPITAL LETTER GAMMA")
     (?$(O&$(B . "GREEK CAPITAL LETTER DELTA")
     (?$(O&%(B . "GREEK CAPITAL LETTER EPSILON")
     (?$(O&&(B . "GREEK CAPITAL LETTER ZETA")
     (?$(O&'(B . "GREEK CAPITAL LETTER ETA")
     (?$(O&((B . "GREEK CAPITAL LETTER THETA")
     (?$(O&)(B . "GREEK CAPITAL LETTER IOTA")
     (?$(O&*(B . "GREEK CAPITAL LETTER KAPPA")
     (?$(O&+(B . "GREEK CAPITAL LETTER LAMBDA")
     (?$(O&,(B . "GREEK CAPITAL LETTER MU")
     (?$(O&-(B . "GREEK CAPITAL LETTER NU")
     (?$(O&.(B . "GREEK CAPITAL LETTER XI")
     (?$(O&/(B . "GREEK CAPITAL LETTER OMICRON")
     (?$(O&0(B . "GREEK CAPITAL LETTER PI")
     (?$(O&1(B . "GREEK CAPITAL LETTER RHO")
     (?$(O&2(B . "GREEK CAPITAL LETTER SIGMA")
     (?$(O&3(B . "GREEK CAPITAL LETTER TAU")
     (?$(O&4(B . "GREEK CAPITAL LETTER UPSILON")
     (?$(O&5(B . "GREEK CAPITAL LETTER PHI")
     (?$(O&6(B . "GREEK CAPITAL LETTER CHI")
     (?$(O&7(B . "GREEK CAPITAL LETTER PSI")
     (?$(O&8(B . "GREEK CAPITAL LETTER OMEGA")
     (?$(O&9(B . "WHITE SPADE SUIT")
     (?$(O&:(B . "BLACK SPADE SUIT")
     (?$(O&;(B . "WHITE DIAMOND SUIT")
     (?$(O&<(B . "BLACK DIAMOND SUIT")
     (?$(O&=(B . "WHITE HEART SUIT")
     (?$(O&>(B . "BLACK HEART SUIT")
     (?$(O&?(B . "WHITE CLUB SUIT")
     (?$(O&@(B . "BLACK CLUB SUIT")
     (?$(O&A(B . "GREEK SMALL LETTER ALPHA")
     (?$(O&B(B . "GREEK SMALL LETTER BETA")
     (?$(O&C(B . "GREEK SMALL LETTER GAMMA")
     (?$(O&D(B . "GREEK SMALL LETTER DELTA")
     (?$(O&E(B . "GREEK SMALL LETTER EPSILON")
     (?$(O&F(B . "GREEK SMALL LETTER ZETA")
     (?$(O&G(B . "GREEK SMALL LETTER ETA")
     (?$(O&H(B . "GREEK SMALL LETTER THETA")
     (?$(O&I(B . "GREEK SMALL LETTER IOTA")
     (?$(O&J(B . "GREEK SMALL LETTER KAPPA")
     (?$(O&K(B . "GREEK SMALL LETTER LAMBDA")
     (?$(O&L(B . "GREEK SMALL LETTER MU")
     (?$(O&M(B . "GREEK SMALL LETTER NU")
     (?$(O&N(B . "GREEK SMALL LETTER XI")
     (?$(O&O(B . "GREEK SMALL LETTER OMICRON")
     (?$(O&P(B . "GREEK SMALL LETTER PI")
     (?$(O&Q(B . "GREEK SMALL LETTER RHO")
     (?$(O&R(B . "GREEK SMALL LETTER SIGMA")
     (?$(O&S(B . "GREEK SMALL LETTER TAU")
     (?$(O&T(B . "GREEK SMALL LETTER UPSILON")
     (?$(O&U(B . "GREEK SMALL LETTER PHI")
     (?$(O&V(B . "GREEK SMALL LETTER CHI")
     (?$(O&W(B . "GREEK SMALL LETTER PSI")
     (?$(O&X(B . "GREEK SMALL LETTER OMEGA")
     (?$(O&Y(B . "GREEK SMALL LETTER FINAL SIGMA")
     (?$(O&Z(B . "[DOUBLE CIRCLED DIGIT ONE]")
     (?$(O&[(B . "[DOUBLE CIRCLED DIGIT TWO]")
     (?$(O&\(B . "[DOUBLE CIRCLED DIGIT THREE]")
     (?$(O&](B . "[DOUBLE CIRCLED DIGIT FOUR]")
     (?$(O&^(B . "[DOUBLE CIRCLED DIGIT FIVE]")
     (?$(O&_(B . "[DOUBLE CIRCLED DIGIT SIX]")
     (?$(O&`(B . "[DOUBLE CIRCLED DIGIT SEVEN]")
     (?$(O&a(B . "[DOUBLE CIRCLED DIGIT EIGHT]")
     (?$(O&b(B . "[DOUBLE CIRCLED DIGIT NINE]")
     (?$(O&c(B . "[DOUBLE CIRCLED NUMBER TEN]")
     (?$(O&d(B . "[WHITE SHOGI PIECE]")
     (?$(O&e(B . "[BLACK SHOGI PIECE]")
     (?$(O&f(B . "POSTAL MARK FACE")
     (?$(O&g(B . "BLACK TELEPHONE")
     (?$(O&h(B . "BLACK SUN WITH RAYS")
     (?$(O&i(B . "CLOUD")
     (?$(O&j(B . "UMBRELLA")
     (?$(O&k(B . "SNOWMAN")
     (?$(O&l(B . "HOT SPRINGS")
     (?$(O&m(B . "WHITE PARALLELOGRAM")
     (?$(O&n(B . "[KATAKANA LETTER AINU K]")
     (?$(O&o(B . "[KATAKANA LETTER AINU SI (S)]")
     (?$(O&p(B . "[KATAKANA LETTER AINU SU (S)]")
     (?$(O&q(B . "[KATAKANA LETTER AINU T]")
     (?$(O&r(B . "[KATAKANA LETTER AINU N]")
     (?$(O&s(B . "[KATAKANA LETTER AINU AX]")
     (?$(O&t(B . "[KATAKANA LETTER AINU IX]")
     (?$(O&u(B . "[KATAKANA LETTER AINU UX]")
     (?$(O&v(B . "[KATAKANA LETTER AINU EX]")
     (?$(O&w(B . "[KATAKANA LETTER AINU OX]")
     (?$(O&x(B . "[KATAKANA LETTER AINU P]")
     (?$(O&y(B . "[KATAKANA LETTER AINU M]")
     (?$(O&z(B . "[KATAKANA LETTER AINU AR]")
     (?$(O&{(B . "[KATAKANA LETTER AINU IR]")
     (?$(O&|(B . "[KATAKANA LETTER AINU UR]")
     (?$(O&}(B . "[KATAKANA LETTER AINU ER]")
     (?$(O&~(B . "[KATAKANA LETTER AINU OR]")
     (?$(O'!(B . "CYRILLIC CAPITAL LETTER A")
     (?$(O'"(B . "CYRILLIC CAPITAL LETTER BE")
     (?$(O'#(B . "CYRILLIC CAPITAL LETTER VE")
     (?$(O'$(B . "CYRILLIC CAPITAL LETTER GHE")
     (?$(O'%(B . "CYRILLIC CAPITAL LETTER DE")
     (?$(O'&(B . "CYRILLIC CAPITAL LETTER IE")
     (?$(O''(B . "CYRILLIC CAPITAL LETTER IO")
     (?$(O'((B . "CYRILLIC CAPITAL LETTER ZHE")
     (?$(O')(B . "CYRILLIC CAPITAL LETTER ZE")
     (?$(O'*(B . "CYRILLIC CAPITAL LETTER I")
     (?$(O'+(B . "CYRILLIC CAPITAL LETTER SHORT I")
     (?$(O',(B . "CYRILLIC CAPITAL LETTER KA")
     (?$(O'-(B . "CYRILLIC CAPITAL LETTER EL")
     (?$(O'.(B . "CYRILLIC CAPITAL LETTER EM")
     (?$(O'/(B . "CYRILLIC CAPITAL LETTER EN")
     (?$(O'0(B . "CYRILLIC CAPITAL LETTER O")
     (?$(O'1(B . "CYRILLIC CAPITAL LETTER PE")
     (?$(O'2(B . "CYRILLIC CAPITAL LETTER ER")
     (?$(O'3(B . "CYRILLIC CAPITAL LETTER ES")
     (?$(O'4(B . "CYRILLIC CAPITAL LETTER TE")
     (?$(O'5(B . "CYRILLIC CAPITAL LETTER U")
     (?$(O'6(B . "CYRILLIC CAPITAL LETTER EF")
     (?$(O'7(B . "CYRILLIC CAPITAL LETTER HA")
     (?$(O'8(B . "CYRILLIC CAPITAL LETTER TSE")
     (?$(O'9(B . "CYRILLIC CAPITAL LETTER CHE")
     (?$(O':(B . "CYRILLIC CAPITAL LETTER SHA")
     (?$(O';(B . "CYRILLIC CAPITAL LETTER SHCHA")
     (?$(O'<(B . "CYRILLIC CAPITAL LETTER HARD SIGN")
     (?$(O'=(B . "CYRILLIC CAPITAL LETTER YERU")
     (?$(O'>(B . "CYRILLIC CAPITAL LETTER SOFT SIGN")
     (?$(O'?(B . "CYRILLIC CAPITAL LETTER E")
     (?$(O'@(B . "CYRILLIC CAPITAL LETTER YU")
     (?$(O'A(B . "CYRILLIC CAPITAL LETTER YA")
     (?$(O'B(B . "[DENTIST SYMBOL LIGHT VERTICAL AND TOP RIGHT]")
     (?$(O'C(B . "[DENTIST SYMBOL LIGHT VERTICAL AND BOTTOM RIGHT]")
     (?$(O'D(B . "[DENTIST SYMBOL LIGHT VERTICAL WITH CIRCLE]")
     (?$(O'E(B . "[DENTIST SYMBOL LIGHT DOWN AND HORIZONTAL WITH CIRCLE]")
     (?$(O'F(B . "[DENTIST SYMBOL LIGHT UP AND HORIZONTAL WITH CIRCLE]")
     (?$(O'G(B . "[DENTIST SYMBOL LIGHT VERTICAL WITH TRIANGLE]")
     (?$(O'H(B . "[DENTIST SYMBOL LIGHT DOWN AND HORIZONTAL WITH TRIANGLE]")
     (?$(O'I(B . "[DENTIST SYMBOL LIGHT UP AND HORIZONTAL WITH TRIANGLE]")
     (?$(O'J(B . "[DENTIST SYMBOL LIGHT VERTICAL WITH WAVE]")
     (?$(O'K(B . "[DENTIST SYMBOL LIGHT DOWN AND HORIZONTAL WITH WAVE]")
     (?$(O'L(B . "[DENTIST SYMBOL LIGHT UP AND HORIZONTAL WITH WAVE]")
     (?$(O'M(B . "[DENTIST SYMBOL LIGHT DOWN AND HORIZONTAL]")
     (?$(O'N(B . "[DENTIST SYMBOL LIGHT UP AND HORIZONTAL]")
     (?$(O'O(B . "[DENTIST SYMBOL LIGHT VERTICAL AND TOP LEFT]")
     (?$(O'P(B . "[DENTIST SYMBOL LIGHT VERTICAL AND BOTTOM LEFT]")
     (?$(O'Q(B . "CYRILLIC SMALL LETTER A")
     (?$(O'R(B . "CYRILLIC SMALL LETTER BE")
     (?$(O'S(B . "CYRILLIC SMALL LETTER VE")
     (?$(O'T(B . "CYRILLIC SMALL LETTER GHE")
     (?$(O'U(B . "CYRILLIC SMALL LETTER DE")
     (?$(O'V(B . "CYRILLIC SMALL LETTER IE")
     (?$(O'W(B . "CYRILLIC SMALL LETTER IO")
     (?$(O'X(B . "CYRILLIC SMALL LETTER ZHE")
     (?$(O'Y(B . "CYRILLIC SMALL LETTER ZE")
     (?$(O'Z(B . "CYRILLIC SMALL LETTER I")
     (?$(O'[(B . "CYRILLIC SMALL LETTER SHORT I")
     (?$(O'\(B . "CYRILLIC SMALL LETTER KA")
     (?$(O'](B . "CYRILLIC SMALL LETTER EL")
     (?$(O'^(B . "CYRILLIC SMALL LETTER EM")
     (?$(O'_(B . "CYRILLIC SMALL LETTER EN")
     (?$(O'`(B . "CYRILLIC SMALL LETTER O")
     (?$(O'a(B . "CYRILLIC SMALL LETTER PE")
     (?$(O'b(B . "CYRILLIC SMALL LETTER ER")
     (?$(O'c(B . "CYRILLIC SMALL LETTER ES")
     (?$(O'd(B . "CYRILLIC SMALL LETTER TE")
     (?$(O'e(B . "CYRILLIC SMALL LETTER U")
     (?$(O'f(B . "CYRILLIC SMALL LETTER EF")
     (?$(O'g(B . "CYRILLIC SMALL LETTER HA")
     (?$(O'h(B . "CYRILLIC SMALL LETTER TSE")
     (?$(O'i(B . "CYRILLIC SMALL LETTER CHE")
     (?$(O'j(B . "CYRILLIC SMALL LETTER SHA")
     (?$(O'k(B . "CYRILLIC SMALL LETTER SHCHA")
     (?$(O'l(B . "CYRILLIC SMALL LETTER HARD SIGN")
     (?$(O'm(B . "CYRILLIC SMALL LETTER YERU")
     (?$(O'n(B . "CYRILLIC SMALL LETTER SOFT SIGN")
     (?$(O'o(B . "CYRILLIC SMALL LETTER E")
     (?$(O'p(B . "CYRILLIC SMALL LETTER YU")
     (?$(O'q(B . "CYRILLIC SMALL LETTER YA")
     (?$(O'r(B . "KATAKANA LETTER VA")
     (?$(O's(B . "KATAKANA LETTER VI")
     (?$(O't(B . "KATAKANA LETTER VE")
     (?$(O'u(B . "KATAKANA LETTER VO")
     (?$(O'v(B . "LESS-THAN EQUAL TO OR GREATER-THAN")
     (?$(O'w(B . "GREATER-THAN EQUAL TO OR LESS-THAN")
     (?$(O'x(B . "VULGAR FRACTION ONE THIRD")
     (?$(O'y(B . "VULGAR FRACTION TWO THIRDS")
     (?$(O'z(B . "VULGAR FRACTION ONE FIFTH")
     (?$(O'{(B . "CHECK MARK")
     (?$(O'|(B . "PLACE OF INTEREST SIGN")
     (?$(O'}(B . "OPEN BOX")
     (?$(O'~(B . "[RETURN SIGN]")
     (?$(O(!(B . "BOX DRAWINGS LIGHT HORIZONTAL")
     (?$(O("(B . "BOX DRAWINGS LIGHT VERTICAL")
     (?$(O(#(B . "BOX DRAWINGS LIGHT DOWN AND RIGHT")
     (?$(O($(B . "BOX DRAWINGS LIGHT DOWN AND LEFT")
     (?$(O(%(B . "BOX DRAWINGS LIGHT UP AND LEFT")
     (?$(O(&(B . "BOX DRAWINGS LIGHT UP AND RIGHT")
     (?$(O('(B . "BOX DRAWINGS LIGHT VERTICAL AND RIGHT")
     (?$(O(((B . "BOX DRAWINGS LIGHT DOWN AND HORIZONTAL")
     (?$(O()(B . "BOX DRAWINGS LIGHT VERTICAL AND LEFT")
     (?$(O(*(B . "BOX DRAWINGS LIGHT UP AND HORIZONTAL")
     (?$(O(+(B . "BOX DRAWINGS LIGHT VERTICAL AND HORIZONTAL")
     (?$(O(,(B . "BOX DRAWINGS HEAVY HORIZONTAL")
     (?$(O(-(B . "BOX DRAWINGS HEAVY VERTICAL")
     (?$(O(.(B . "BOX DRAWINGS HEAVY DOWN AND RIGHT")
     (?$(O(/(B . "BOX DRAWINGS HEAVY DOWN AND LEFT")
     (?$(O(0(B . "BOX DRAWINGS HEAVY UP AND LEFT")
     (?$(O(1(B . "BOX DRAWINGS HEAVY UP AND RIGHT")
     (?$(O(2(B . "BOX DRAWINGS HEAVY VERTICAL AND RIGHT")
     (?$(O(3(B . "BOX DRAWINGS HEAVY DOWN AND HORIZONTAL")
     (?$(O(4(B . "BOX DRAWINGS HEAVY VERTICAL AND LEFT")
     (?$(O(5(B . "BOX DRAWINGS HEAVY UP AND HORIZONTAL")
     (?$(O(6(B . "BOX DRAWINGS HEAVY VERTICAL AND HORIZONTAL")
     (?$(O(7(B . "BOX DRAWINGS VERTICAL HEAVY AND RIGHT LIGHT")
     (?$(O(8(B . "BOX DRAWINGS DOWN LIGHT AND HORIZONTAL HEAVY")
     (?$(O(9(B . "BOX DRAWINGS VERTICAL HEAVY AND LEFT LIGHT")
     (?$(O(:(B . "BOX DRAWINGS UP LIGHT AND HORIZONTAL HEAVY")
     (?$(O(;(B . "BOX DRAWINGS VERTICAL LIGHT AND HORIZONTAL HEAVY")
     (?$(O(<(B . "BOX DRAWINGS VERTICAL LIGHT AND RIGHT HEAVY")
     (?$(O(=(B . "BOX DRAWINGS DOWN HEAVY AND HORIZONTAL LIGHT")
     (?$(O(>(B . "BOX DRAWINGS VERTICAL LIGHT AND LEFT HEAVY")
     (?$(O(?(B . "BOX DRAWINGS UP HEAVY AND HORIZONTAL LIGHT")
     (?$(O(@(B . "BOX DRAWINGS VERTICAL HEAVY AND HORIZONTAL LIGHT")
     (?$(O(A(B . "[CIRCLED NUMBER TWENTY ONE]")
     (?$(O(B(B . "[CIRCLED NUMBER TWENTY TWO]")
     (?$(O(C(B . "[CIRCLED NUMBER TWENTY THREE]")
     (?$(O(D(B . "[CIRCLED NUMBER TWENTY FOUR]")
     (?$(O(E(B . "[CIRCLED NUMBER TWENTY FIVE]")
     (?$(O(F(B . "[CIRCLED NUMBER TWENTY SIX]")
     (?$(O(G(B . "[CIRCLED NUMBER TWENTY SEVEN]")
     (?$(O(H(B . "[CIRCLED NUMBER TWENTY EIGHT]")
     (?$(O(I(B . "[CIRCLED NUMBER TWENTY NINE]")
     (?$(O(J(B . "[CIRCLED NUMBER THIRTY]")
     (?$(O(K(B . "[CIRCLED NUMBER THIRTY ONE]")
     (?$(O(L(B . "[CIRCLED NUMBER THIRTY TWO]")
     (?$(O(M(B . "[CIRCLED NUMBER THIRTY THREE]")
     (?$(O(N(B . "[CIRCLED NUMBER THIRTY FOUR]")
     (?$(O(O(B . "[CIRCLED NUMBER THIRTY FIVE]")
     (?$(O(P(B . "[CIRCLED NUMBER THIRTY SIX]")
     (?$(O(Q(B . "[CIRCLED NUMBER THIRTY SEVEN]")
     (?$(O(R(B . "[CIRCLED NUMBER THIRTY EIGHT]")
     (?$(O(S(B . "[CIRCLED NUMBER THIRTY NINE]")
     (?$(O(T(B . "[CIRCLED NUMBER FORTY]")
     (?$(O(U(B . "[CIRCLED NUMBER FORTY ONE]")
     (?$(O(V(B . "[CIRCLED NUMBER FORTY TWO]")
     (?$(O(W(B . "[CIRCLED NUMBER FORTY THREE]")
     (?$(O(X(B . "[CIRCLED NUMBER FORTY FOUR]")
     (?$(O(Y(B . "[CIRCLED NUMBER FORTY FIVE]")
     (?$(O(Z(B . "[CIRCLED NUMBER FORTY SIX]")
     (?$(O([(B . "[CIRCLED NUMBER FORTY SEVEN]")
     (?$(O(\(B . "[CIRCLED NUMBER FORTY EIGHT]")
     (?$(O(](B . "[CIRCLED NUMBER FORTY NINE]")
     (?$(O(^(B . "[CIRCLED NUMBER FIFTY]")
     (?$(O(g(B . "CIRCLE WITH LEFT HALF BLACK")
     (?$(O(h(B . "CIRCLE WITH RIGHT HALF BLACK")
     (?$(O(i(B . "CIRCLE WITH LOWER HALF BLACK")
     (?$(O(j(B . "CIRCLE WITH UPPER HALF BLACK")
     (?$(O(k(B . "DOUBLE EXCLAMATION MARK")
     (?$(O(l(B . "[DOUBLE QUESTION MARK]")
     (?$(O(m(B . "QUESTION EXCLAMATION MARK")
     (?$(O(n(B . "EXCLAMATION QUESTION MARK")
     (?$(O(o(B . "LATIN CAPITAL LETTER A WITH CARON")
     (?$(O(p(B . "LATIN SMALL LETTER A WITH CARON")
     (?$(O(q(B . "LATIN SMALL LETTER I WITH CARON")
     (?$(O(r(B . "LATIN CAPITAL LETTER M WITH ACUTE")
     (?$(O(s(B . "LATIN SMALL LETTER M WITH ACUTE")
     (?$(O(t(B . "LATIN CAPITAL LETTER N WITH GRAVE")
     (?$(O(u(B . "LATIN SMALL LETTER N WITH GRAVE")
     (?$(O(v(B . "LATIN CAPITAL LETTER O WITH CARON")
     (?$(O(w(B . "LATIN SMALL LETTER O WITH CARON")
     (?$(O(x(B . "LATIN SMALL LETTER U WITH CARON")
     (?$(O(y(B . "LATIN SMALL LETTER U WITH DIAERESIS AND MACRON")
     (?$(O(z(B . "LATIN SMALL LETTER U WITH DIAERESIS AND ACUTE")
     (?$(O({(B . "LATIN SMALL LETTER U WITH DIAERESIS AND CARON")
     (?$(O(|(B . "LATIN SMALL LETTER U WITH DIAERESIS AND GRAVE")
     (?$(O)!(B . "EURO SIGN")
     (?$(O)"(B . "NO-BREAK SPACE")
     (?$(O)#(B . "INVERTED EXCLAMATION MARK")
     (?$(O)$(B . "CURRENCY SIGN")
     (?$(O)%(B . "BROKEN BAR")
     (?$(O)&(B . "COPYRIGHT SIGN")
     (?$(O)'(B . "FEMININE ORDINAL INDICATOR")
     (?$(O)((B . "LEFT-POINTING DOUBLE ANGLE QUOTATION MARK")
     (?$(O))(B . "SOFT HYPHEN")
     (?$(O)*(B . "REGISTERED SIGN")
     (?$(O)+(B . "MACRON")
     (?$(O),(B . "SUPERSCRIPT TWO")
     (?$(O)-(B . "SUPERSCRIPT THREE")
     (?$(O).(B . "MIDDLE DOT")
     (?$(O)/(B . "CEDILLA")
     (?$(O)0(B . "SUPERSCRIPT ONE")
     (?$(O)1(B . "MASCULINE ORDINAL INDICATOR")
     (?$(O)2(B . "RIGHT-POINTING DOUBLE ANGLE QUOTATION MARK")
     (?$(O)3(B . "VULGAR FRACTION ONE QUARTER")
     (?$(O)4(B . "VULGAR FRACTION ONE HALF")
     (?$(O)5(B . "VULGAR FRACTION THREE QUARTERS")
     (?$(O)6(B . "INVERTED QUESTION MARK")
     (?$(O)7(B . "LATIN CAPITAL LETTER A WITH GRAVE")
     (?$(O)8(B . "LATIN CAPITAL LETTER A WITH ACUTE")
     (?$(O)9(B . "LATIN CAPITAL LETTER A WITH CIRCUMFLEX")
     (?$(O):(B . "LATIN CAPITAL LETTER A WITH TILDE")
     (?$(O);(B . "LATIN CAPITAL LETTER A WITH DIAERESIS")
     (?$(O)<(B . "LATIN CAPITAL LETTER A WITH RING ABOVE")
     (?$(O)=(B . "LATIN CAPITAL LETTER AE")
     (?$(O)>(B . "LATIN CAPITAL LETTER C WITH CEDILLA")
     (?$(O)?(B . "LATIN CAPITAL LETTER E WITH GRAVE")
     (?$(O)@(B . "LATIN CAPITAL LETTER E WITH ACUTE")
     (?$(O)A(B . "LATIN CAPITAL LETTER E WITH CIRCUMFLEX")
     (?$(O)B(B . "LATIN CAPITAL LETTER E WITH DIAERESIS")
     (?$(O)C(B . "LATIN CAPITAL LETTER I WITH GRAVE")
     (?$(O)D(B . "LATIN CAPITAL LETTER I WITH ACUTE")
     (?$(O)E(B . "LATIN CAPITAL LETTER I WITH CIRCUMFLEX")
     (?$(O)F(B . "LATIN CAPITAL LETTER I WITH DIAERESIS")
     (?$(O)G(B . "LATIN CAPITAL LETTER ETH (Icelandic)")
     (?$(O)H(B . "LATIN CAPITAL LETTER N WITH TILDE")
     (?$(O)I(B . "LATIN CAPITAL LETTER O WITH GRAVE")
     (?$(O)J(B . "LATIN CAPITAL LETTER O WITH ACUTE")
     (?$(O)K(B . "LATIN CAPITAL LETTER O WITH CIRCUMFLEX")
     (?$(O)L(B . "LATIN CAPITAL LETTER O WITH TILDE")
     (?$(O)M(B . "LATIN CAPITAL LETTER O WITH DIAERESIS")
     (?$(O)N(B . "LATIN CAPITAL LETTER O WITH STROKE")
     (?$(O)O(B . "LATIN CAPITAL LETTER U WITH GRAVE")
     (?$(O)P(B . "LATIN CAPITAL LETTER U WITH ACUTE")
     (?$(O)Q(B . "LATIN CAPITAL LETTER U WITH CIRCUMFLEX")
     (?$(O)R(B . "LATIN CAPITAL LETTER U WITH DIAERESIS")
     (?$(O)S(B . "LATIN CAPITAL LETTER Y WITH ACUTE")
     (?$(O)T(B . "LATIN CAPITAL LETTER THORN (Icelandic)")
     (?$(O)U(B . "LATIN SMALL LETTER SHARP S (German)")
     (?$(O)V(B . "LATIN SMALL LETTER A WITH GRAVE")
     (?$(O)W(B . "LATIN SMALL LETTER A WITH ACUTE")
     (?$(O)X(B . "LATIN SMALL LETTER A WITH CIRCUMFLEX")
     (?$(O)Y(B . "LATIN SMALL LETTER A WITH TILDE")
     (?$(O)Z(B . "LATIN SMALL LETTER A WITH DIAERESIS")
     (?$(O)[(B . "LATIN SMALL LETTER A WITH RING ABOVE")
     (?$(O)\(B . "LATIN SMALL LETTER AE")
     (?$(O)](B . "LATIN SMALL LETTER C WITH CEDILLA")
     (?$(O)^(B . "LATIN SMALL LETTER E WITH GRAVE")
     (?$(O)_(B . "LATIN SMALL LETTER E WITH ACUTE")
     (?$(O)`(B . "LATIN SMALL LETTER E WITH CIRCUMFLEX")
     (?$(O)a(B . "LATIN SMALL LETTER E WITH DIAERESIS")
     (?$(O)b(B . "LATIN SMALL LETTER I WITH GRAVE")
     (?$(O)c(B . "LATIN SMALL LETTER I WITH ACUTE")
     (?$(O)d(B . "LATIN SMALL LETTER I WITH CIRCUMFLEX")
     (?$(O)e(B . "LATIN SMALL LETTER I WITH DIAERESIS")
     (?$(O)f(B . "LATIN SMALL LETTER ETH (Icelandic)")
     (?$(O)g(B . "LATIN SMALL LETTER N WITH TILDE")
     (?$(O)h(B . "LATIN SMALL LETTER O WITH GRAVE")
     (?$(O)i(B . "LATIN SMALL LETTER O WITH ACUTE")
     (?$(O)j(B . "LATIN SMALL LETTER O WITH CIRCUMFLEX")
     (?$(O)k(B . "LATIN SMALL LETTER O WITH TILDE")
     (?$(O)l(B . "LATIN SMALL LETTER O WITH DIAERESIS")
     (?$(O)m(B . "LATIN SMALL LETTER O WITH STROKE")
     (?$(O)n(B . "LATIN SMALL LETTER U WITH GRAVE")
     (?$(O)o(B . "LATIN SMALL LETTER U WITH ACUTE")
     (?$(O)p(B . "LATIN SMALL LETTER U WITH CIRCUMFLEX")
     (?$(O)q(B . "LATIN SMALL LETTER U WITH DIAERESIS")
     (?$(O)r(B . "LATIN SMALL LETTER Y WITH ACUTE")
     (?$(O)s(B . "LATIN SMALL LETTER THORN (Icelandic)")
     (?$(O)t(B . "LATIN SMALL LETTER Y WITH DIAERESIS")
     (?$(O)u(B . "LATIN CAPITAL LETTER A WITH MACRON")
     (?$(O)v(B . "LATIN CAPITAL LETTER I WITH MACRON")
     (?$(O)w(B . "LATIN CAPITAL LETTER U WITH MACRON")
     (?$(O)x(B . "LATIN CAPITAL LETTER E WITH MACRON")
     (?$(O)y(B . "LATIN CAPITAL LETTER O WITH MACRON")
     (?$(O)z(B . "LATIN SMALL LETTER A WITH MACRON")
     (?$(O){(B . "LATIN SMALL LETTER I WITH MACRON")
     (?$(O)|(B . "LATIN SMALL LETTER U WITH MACRON")
     (?$(O)}(B . "LATIN SMALL LETTER E WITH MACRON")
     (?$(O)~(B . "LATIN SMALL LETTER O WITH MACRON")
     (?$(O*!(B . "LATIN CAPITAL LETTER A WITH OGONEK")
     (?$(O*"(B . "BREVE")
     (?$(O*#(B . "LATIN CAPITAL LETTER L WITH STROKE")
     (?$(O*$(B . "LATIN CAPITAL LETTER L WITH CARON")
     (?$(O*%(B . "LATIN CAPITAL LETTER S WITH ACUTE")
     (?$(O*&(B . "LATIN CAPITAL LETTER S WITH CARON")
     (?$(O*'(B . "LATIN CAPITAL LETTER S WITH CEDILLA")
     (?$(O*((B . "LATIN CAPITAL LETTER T WITH CARON")
     (?$(O*)(B . "LATIN CAPITAL LETTER Z WITH ACUTE")
     (?$(O**(B . "LATIN CAPITAL LETTER Z WITH CARON")
     (?$(O*+(B . "LATIN CAPITAL LETTER Z WITH DOT ABOVE")
     (?$(O*,(B . "LATIN SMALL LETTER A WITH OGONEK")
     (?$(O*-(B . "OGONEK")
     (?$(O*.(B . "LATIN SMALL LETTER L WITH STROKE")
     (?$(O*/(B . "LATIN SMALL LETTER L WITH CARON")
     (?$(O*0(B . "LATIN SMALL LETTER S WITH ACUTE")
     (?$(O*1(B . "CARON (Mandarin Chinese third tone)")
     (?$(O*2(B . "LATIN SMALL LETTER S WITH CARON")
     (?$(O*3(B . "LATIN SMALL LETTER S WITH CEDILLA")
     (?$(O*4(B . "LATIN SMALL LETTER T WITH CARON")
     (?$(O*5(B . "LATIN SMALL LETTER Z WITH ACUTE")
     (?$(O*6(B . "DOUBLE ACUTE ACCENT")
     (?$(O*7(B . "LATIN SMALL LETTER Z WITH CARON")
     (?$(O*8(B . "LATIN SMALL LETTER Z WITH DOT ABOVE")
     (?$(O*9(B . "LATIN CAPITAL LETTER R WITH ACUTE")
     (?$(O*:(B . "LATIN CAPITAL LETTER A WITH BREVE")
     (?$(O*;(B . "LATIN CAPITAL LETTER L WITH ACUTE")
     (?$(O*<(B . "LATIN CAPITAL LETTER C WITH ACUTE")
     (?$(O*=(B . "LATIN CAPITAL LETTER C WITH CARON")
     (?$(O*>(B . "LATIN CAPITAL LETTER E WITH OGONEK")
     (?$(O*?(B . "LATIN CAPITAL LETTER E WITH CARON")
     (?$(O*@(B . "LATIN CAPITAL LETTER D WITH CARON")
     (?$(O*A(B . "LATIN CAPITAL LETTER N WITH ACUTE")
     (?$(O*B(B . "LATIN CAPITAL LETTER N WITH CARON")
     (?$(O*C(B . "LATIN CAPITAL LETTER O WITH DOUBLE ACUTE")
     (?$(O*D(B . "LATIN CAPITAL LETTER R WITH CARON")
     (?$(O*E(B . "LATIN CAPITAL LETTER U WITH RING ABOVE")
     (?$(O*F(B . "LATIN CAPITAL LETTER U WITH DOUBLE ACUTE")
     (?$(O*G(B . "LATIN CAPITAL LETTER T WITH CEDILLA")
     (?$(O*H(B . "LATIN SMALL LETTER R WITH ACUTE")
     (?$(O*I(B . "LATIN SMALL LETTER A WITH BREVE")
     (?$(O*J(B . "LATIN SMALL LETTER L WITH ACUTE")
     (?$(O*K(B . "LATIN SMALL LETTER C WITH ACUTE")
     (?$(O*L(B . "LATIN SMALL LETTER C WITH CARON")
     (?$(O*M(B . "LATIN SMALL LETTER E WITH OGONEK")
     (?$(O*N(B . "LATIN SMALL LETTER E WITH CARON")
     (?$(O*O(B . "LATIN SMALL LETTER D WITH CARON")
     (?$(O*P(B . "LATIN SMALL LETTER D WITH STROKE")
     (?$(O*Q(B . "LATIN SMALL LETTER N WITH ACUTE")
     (?$(O*R(B . "LATIN SMALL LETTER N WITH CARON")
     (?$(O*S(B . "LATIN SMALL LETTER O WITH DOUBLE ACUTE")
     (?$(O*T(B . "LATIN SMALL LETTER R WITH CARON")
     (?$(O*U(B . "LATIN SMALL LETTER U WITH RING ABOVE")
     (?$(O*V(B . "LATIN SMALL LETTER U WITH DOUBLE ACUTE")
     (?$(O*W(B . "LATIN SMALL LETTER T WITH CEDILLA")
     (?$(O*X(B . "DOT ABOVE (Mandarin Chinese light tone)")
     (?$(O*Y(B . "LATIN CAPITAL LETTER C WITH CIRCUMFLEX")
     (?$(O*Z(B . "LATIN CAPITAL LETTER G WITH CIRCUMFLEX")
     (?$(O*[(B . "LATIN CAPITAL LETTER H WITH CIRCUMFLEX")
     (?$(O*\(B . "LATIN CAPITAL LETTER J WITH CIRCUMFLEX")
     (?$(O*](B . "LATIN CAPITAL LETTER S WITH CIRCUMFLEX")
     (?$(O*^(B . "LATIN CAPITAL LETTER U WITH BREVE")
     (?$(O*_(B . "LATIN SMALL LETTER C WITH CIRCUMFLEX")
     (?$(O*`(B . "LATIN SMALL LETTER G WITH CIRCUMFLEX")
     (?$(O*a(B . "LATIN SMALL LETTER H WITH CIRCUMFLEX")
     (?$(O*b(B . "LATIN SMALL LETTER J WITH CIRCUMFLEX")
     (?$(O*c(B . "LATIN SMALL LETTER S WITH CIRCUMFLEX")
     (?$(O*d(B . "LATIN SMALL LETTER U WITH BREVE")
     (?$(O*e(B . "LATIN SMALL LETTER M WITH HOOK")
     (?$(O*f(B . "LATIN SMALL LETTER V WITH HOOK")
     (?$(O*g(B . "LATIN SMALL LETTER R WITH FISHHOOK")
     (?$(O*h(B . "LATIN SMALL LETTER ESH")
     (?$(O*i(B . "LATIN SMALL LETTER EZH")
     (?$(O*j(B . "LATIN SMALL LETTER L WITH BELT")
     (?$(O*k(B . "LATIN SMALL LETTER LEZH")
     (?$(O*l(B . "LATIN SMALL LETTER TURNED R")
     (?$(O*m(B . "LATIN SMALL LETTER T WITH RETROFLEX HOOK")
     (?$(O*n(B . "LATIN SMALL LETTER D WITH TAIL")
     (?$(O*o(B . "LATIN SMALL LETTER N WITH RETROFLEX HOOK")
     (?$(O*p(B . "LATIN SMALL LETTER R WITH TAIL")
     (?$(O*q(B . "LATIN SMALL LETTER S WITH HOOK")
     (?$(O*r(B . "LATIN SMALL LETTER Z WITH RETROFLEX HOOK")
     (?$(O*s(B . "LATIN SMALL LETTER TURNED R WITH HOOK")
     (?$(O*t(B . "LATIN SMALL LETTER L WITH RETROFLEX HOOK")
     (?$(O*u(B . "LATIN SMALL LETTER DOTLESS J WITH STROKE")
     (?$(O*v(B . "LATIN SMALL LETTER N WITH LEFT HOOK")
     (?$(O*w(B . "LATIN SMALL LETTER J WITH CROSSED-TAIL")
     (?$(O*x(B . "LATIN SMALL LETTER TURNED Y")
     (?$(O*y(B . "LATIN SMALL LETTER SCRIPT G")
     (?$(O*z(B . "LATIN SMALL LETTER ENG (Sami)")
     (?$(O*{(B . "LATIN SMALL LETTER TURNED M WITH LONG LEG")
     (?$(O*|(B . "LATIN LETTER SMALL CAPITAL INVERTED R")
     (?$(O*}(B . "LATIN SMALL LETTER H WITH STROKE")
     (?$(O*~(B . "LATIN LETTER PHARYNGEAL VOICED FRICATIVE")
     (?$(O+!(B . "LATIN LETTER GLOTTAL STOP")
     (?$(O+"(B . "LATIN SMALL LETTER H WITH HOOK")
     (?$(O+#(B . "LATIN LETTER BILABIAL CLICK")
     (?$(O+$(B . "LATIN LETTER ALVEOLAR CLICK")
     (?$(O+%(B . "LATIN SMALL LETTER B WITH HOOK")
     (?$(O+&(B . "LATIN SMALL LETTER D WITH HOOK")
     (?$(O+'(B . "LATIN SMALL LETTER DOTLESS J WITH STROKE AND HOOK")
     (?$(O+((B . "LATIN SMALL LETTER G WITH HOOK")
     (?$(O+)(B . "LATIN CAPITAL LETTER G WITH HOOK")
     (?$(O+*(B . "LATIN SMALL LIGATURE OE")
     (?$(O++(B . "LATIN CAPITAL LIGATURE OE")
     (?$(O+,(B . "LATIN SMALL LETTER I WITH STROKE")
     (?$(O+-(B . "LATIN SMALL LETTER U BAR")
     (?$(O+.(B . "LATIN SMALL LETTER REVERSED E")
     (?$(O+/(B . "LATIN SMALL LETTER BARRED O")
     (?$(O+0(B . "LATIN SMALL LETTER SCHWA")
     (?$(O+1(B . "LATIN SMALL LETTER REVERSED OPEN E")
     (?$(O+2(B . "LATIN SMALL LETTER CLOSED REVERSED OPEN E")
     (?$(O+3(B . "LATIN SMALL LETTER TURNED A")
     (?$(O+4(B . "LATIN SMALL LETTER TURNED M")
     (?$(O+5(B . "LATIN SMALL LETTER UPSILON")
     (?$(O+6(B . "LATIN SMALL LETTER RAMS HORN")
     (?$(O+7(B . "LATIN SMALL LETTER TURNED V")
     (?$(O+8(B . "LATIN SMALL LETTER OPEN O")
     (?$(O+9(B . "LATIN SMALL LETTER ALPHA")
     (?$(O+:(B . "LATIN SMALL LETTER TURNED ALPHA")
     (?$(O+;(B . "LATIN SMALL LETTER TURNED W")
     (?$(O+<(B . "LATIN SMALL LETTER TURNED H")
     (?$(O+=(B . "LATIN LETTER REVERSED GLOTTAL STOP WITH STROKE")
     (?$(O+>(B . "LATIN LETTER GLOTTAL STOP WITH STROKE")
     (?$(O+?(B . "LATIN SMALL LETTER C WITH CURL")
     (?$(O+@(B . "LATIN SMALL LETTER Z WITH CURL")
     (?$(O+A(B . "LATIN SMALL LETTER TURNED R WITH LONG LEG")
     (?$(O+B(B . "LATIN SMALL LETTER HENG WITH HOOK")
     (?$(O+C(B . "LATIN SMALL LETTER SCHWA WITH HOOK")
     (?$(O+D(B . "[LATIN SMALL LETTER AE WITH GRAVE]")
     (?$(O+E(B . "LATIN SMALL LETTER AE WITH ACUTE")
     (?$(O+F(B . "GREEK SMALL LETTER ALPHA WITH VARIA")
     (?$(O+G(B . "GREEK SMALL LETTER ALPHA WITH OXIA")
     (?$(O+H(B . "[LATIN SMALL LETTER OPEN O WITH GRAVE]")
     (?$(O+I(B . "[LATIN SMALL LETTER OPEN O WITH ACUTE]")
     (?$(O+J(B . "[LATIN SMALL LETTER TURNED V WITH GRAVE]")
     (?$(O+K(B . "[LATIN SMALL LETTER TURNED V WITH ACUTE]")
     (?$(O+L(B . "[LATIN SMALL LETTER SCHWA WITH GRAVE]")
     (?$(O+M(B . "[LATIN SMALL LETTER SCHWA WITH ACUTE]")
     (?$(O+N(B . "[LATIN SMALL LETTER HOOKED SCHWA WITH GRAVE]")
     (?$(O+O(B . "[LATIN SMALL LETTER HOOKED SCHWA WITH ACUTE]")
     (?$(O+P(B . "GREEK SMALL LETTER EPSILON WITH VARIA")
     (?$(O+Q(B . "GREEK SMALL LETTER EPSILON WITH OXIA")
     (?$(O+R(B . "COMBINING DOUBLE INVERTED BREVE")
     (?$(O+S(B . "MODIFIER LETTER VERTICAL LINE")
     (?$(O+T(B . "MODIFIER LETTER LOW VERTICAL LINE")
     (?$(O+U(B . "MODIFIER LETTER TRIANGULAR COLON")
     (?$(O+V(B . "MODIFIER LETTER HALF TRIANGULAR COLON")
     (?$(O+W(B . "COMBINING BREVE (Vrachy)")
     (?$(O+X(B . "UNDERTIE (Enotikon)")
     (?$(O+Y(B . "COMBINING DOUBLE ACUTE ACCENT")
     (?$(O+Z(B . "COMBINING ACUTE ACCENT (Oxia)")
     (?$(O+[(B . "COMBINING MACRON")
     (?$(O+\(B . "COMBINING GRAVE ACCENT (Varia)")
     (?$(O+](B . "COMBINING DOUBLE GRAVE ACCENT")
     (?$(O+^(B . "COMBINING CARON")
     (?$(O+_(B . "COMBINING CIRCUMFLEX ACCENT")
     (?$(O+`(B . "MODIFIER LETTER EXTRA-HIGH TONE BAR")
     (?$(O+a(B . "MODIFIER LETTER HIGH TONE BAR")
     (?$(O+b(B . "MODIFIER LETTER MID TONE BAR")
     (?$(O+c(B . "MODIFIER LETTER LOW TONE BAR")
     (?$(O+d(B . "MODIFIER LETTER EXTRA-LOW TONE BAR")
     (?$(O+e(B . "[RISING SYMBOL]")
     (?$(O+f(B . "[FALLING SYMBOL]")
     (?$(O+g(B . "COMBINING RING BELOW")
     (?$(O+h(B . "COMBINING CARON BELOW")
     (?$(O+i(B . "COMBINING RIGHT HALF RING BELOW")
     (?$(O+j(B . "COMBINING LEFT HALF RING BELOW")
     (?$(O+k(B . "COMBINING PLUS SIGN BELOW")
     (?$(O+l(B . "COMBINING MINUS SIGN BELOW")
     (?$(O+m(B . "COMBINING DIAERESIS (Dialytika)")
     (?$(O+n(B . "COMBINING X ABOVE")
     (?$(O+o(B . "COMBINING VERTICAL LINE BELOW")
     (?$(O+p(B . "COMBINING INVERTED BREVE BELOW")
     (?$(O+q(B . "MODIFIER LETTER RHOTIC HOOK")
     (?$(O+r(B . "COMBINING DIAERESIS BELOW")
     (?$(O+s(B . "COMBINING TILDE BELOW")
     (?$(O+t(B . "COMBINING SEAGULL BELOW")
     (?$(O+u(B . "COMBINING TILDE OVERLAY")
     (?$(O+v(B . "COMBINING UP TACK BELOW")
     (?$(O+w(B . "COMBINING DOWN TACK BELOW")
     (?$(O+x(B . "COMBINING LEFT TACK BELOW")
     (?$(O+y(B . "COMBINING RIGHT TACK BELOW")
     (?$(O+z(B . "COMBINING BRIDGE BELOW")
     (?$(O+{(B . "COMBINING INVERTED BRIDGE BELOW")
     (?$(O+|(B . "COMBINING SQUARE BELOW")
     (?$(O+}(B . "COMBINING TILDE")
     (?$(O+~(B . "COMBINING LEFT ANGLE ABOVE")
     (?$(O,!(B . "DINGBAT NEGATIVE CIRCLED DIGIT ONE")
     (?$(O,"(B . "DINGBAT NEGATIVE CIRCLED DIGIT TWO")
     (?$(O,#(B . "DINGBAT NEGATIVE CIRCLED DIGIT THREE")
     (?$(O,$(B . "DINGBAT NEGATIVE CIRCLED DIGIT FOUR")
     (?$(O,%(B . "DINGBAT NEGATIVE CIRCLED DIGIT FIVE")
     (?$(O,&(B . "DINGBAT NEGATIVE CIRCLED DIGIT SIX")
     (?$(O,'(B . "DINGBAT NEGATIVE CIRCLED DIGIT SEVEN")
     (?$(O,((B . "DINGBAT NEGATIVE CIRCLED DIGIT EIGHT")
     (?$(O,)(B . "DINGBAT NEGATIVE CIRCLED DIGIT NINE")
     (?$(O,*(B . "DINGBAT NEGATIVE CIRCLED NUMBER TEN")
     (?$(O,+(B . "[NEGATIVE CIRCLED NUMBER ELEVEN]")
     (?$(O,,(B . "[NEGATIVE CIRCLED NUMBER TWELVE]")
     (?$(O,-(B . "[NEGATIVE CIRCLED NUMBER THIRTEEN]")
     (?$(O,.(B . "[NEGATIVE CIRCLED NUMBER FOURTEEN]")
     (?$(O,/(B . "[NEGATIVE CIRCLED NUMBER FIFTEEN]")
     (?$(O,0(B . "[NEGATIVE CIRCLED NUMBER SIXTEEN]")
     (?$(O,1(B . "[NEGATIVE CIRCLED NUMBER SEVENTEEN]")
     (?$(O,2(B . "[NEGATIVE CIRCLED NUMBER EIGHTEEN]")
     (?$(O,3(B . "[NEGATIVE CIRCLED NUMBER NINETEEN]")
     (?$(O,4(B . "[NEGATIVE CIRCLED NUMBER TWENTY]")
     (?$(O,5(B . "SMALL ROMAN NUMERAL ONE")
     (?$(O,6(B . "SMALL ROMAN NUMERAL TWO")
     (?$(O,7(B . "SMALL ROMAN NUMERAL THREE")
     (?$(O,8(B . "SMALL ROMAN NUMERAL FOUR")
     (?$(O,9(B . "SMALL ROMAN NUMERAL FIVE")
     (?$(O,:(B . "SMALL ROMAN NUMERAL SIX")
     (?$(O,;(B . "SMALL ROMAN NUMERAL SEVEN")
     (?$(O,<(B . "SMALL ROMAN NUMERAL EIGHT")
     (?$(O,=(B . "SMALL ROMAN NUMERAL NINE")
     (?$(O,>(B . "SMALL ROMAN NUMERAL TEN")
     (?$(O,?(B . "SMALL ROMAN NUMERAL ELEVEN")
     (?$(O,@(B . "SMALL ROMAN NUMERAL TWELVE")
     (?$(O,A(B . "CIRCLED LATIN SMALL LETTER A")
     (?$(O,B(B . "CIRCLED LATIN SMALL LETTER B")
     (?$(O,C(B . "CIRCLED LATIN SMALL LETTER C")
     (?$(O,D(B . "CIRCLED LATIN SMALL LETTER D")
     (?$(O,E(B . "CIRCLED LATIN SMALL LETTER E")
     (?$(O,F(B . "CIRCLED LATIN SMALL LETTER F")
     (?$(O,G(B . "CIRCLED LATIN SMALL LETTER G")
     (?$(O,H(B . "CIRCLED LATIN SMALL LETTER H")
     (?$(O,I(B . "CIRCLED LATIN SMALL LETTER I")
     (?$(O,J(B . "CIRCLED LATIN SMALL LETTER J")
     (?$(O,K(B . "CIRCLED LATIN SMALL LETTER K")
     (?$(O,L(B . "CIRCLED LATIN SMALL LETTER L")
     (?$(O,M(B . "CIRCLED LATIN SMALL LETTER M")
     (?$(O,N(B . "CIRCLED LATIN SMALL LETTER N")
     (?$(O,O(B . "CIRCLED LATIN SMALL LETTER O")
     (?$(O,P(B . "CIRCLED LATIN SMALL LETTER P")
     (?$(O,Q(B . "CIRCLED LATIN SMALL LETTER Q")
     (?$(O,R(B . "CIRCLED LATIN SMALL LETTER R")
     (?$(O,S(B . "CIRCLED LATIN SMALL LETTER S")
     (?$(O,T(B . "CIRCLED LATIN SMALL LETTER T")
     (?$(O,U(B . "CIRCLED LATIN SMALL LETTER U")
     (?$(O,V(B . "CIRCLED LATIN SMALL LETTER V")
     (?$(O,W(B . "CIRCLED LATIN SMALL LETTER W")
     (?$(O,X(B . "CIRCLED LATIN SMALL LETTER X")
     (?$(O,Y(B . "CIRCLED LATIN SMALL LETTER Y")
     (?$(O,Z(B . "CIRCLED LATIN SMALL LETTER Z")
     (?$(O,[(B . "CIRCLED KATAKANA A")
     (?$(O,\(B . "CIRCLED KATAKANA I")
     (?$(O,](B . "CIRCLED KATAKANA U")
     (?$(O,^(B . "CIRCLED KATAKANA E")
     (?$(O,_(B . "CIRCLED KATAKANA O")
     (?$(O,`(B . "CIRCLED KATAKANA KA")
     (?$(O,a(B . "CIRCLED KATAKANA KI")
     (?$(O,b(B . "CIRCLED KATAKANA KU")
     (?$(O,c(B . "CIRCLED KATAKANA KE")
     (?$(O,d(B . "CIRCLED KATAKANA KO")
     (?$(O,e(B . "CIRCLED KATAKANA SA")
     (?$(O,f(B . "CIRCLED KATAKANA SI")
     (?$(O,g(B . "CIRCLED KATAKANA SU")
     (?$(O,h(B . "CIRCLED KATAKANA SE")
     (?$(O,i(B . "CIRCLED KATAKANA SO")
     (?$(O,j(B . "CIRCLED KATAKANA TA")
     (?$(O,k(B . "CIRCLED KATAKANA TI")
     (?$(O,l(B . "CIRCLED KATAKANA TU")
     (?$(O,m(B . "CIRCLED KATAKANA TE")
     (?$(O,n(B . "CIRCLED KATAKANA TO")
     (?$(O,o(B . "CIRCLED KATAKANA RO")
     (?$(O,p(B . "CIRCLED KATAKANA HA")
     (?$(O,q(B . "CIRCLED KATAKANA NI")
     (?$(O,r(B . "CIRCLED KATAKANA HO")
     (?$(O,s(B . "CIRCLED KATAKANA HE")
     (?$(O,}(B . "[DOUBLE ASTERISK]")
     (?$(O,~(B . "ASTERISM")
     (?$(O-!(B . "CIRCLED DIGIT ONE")
     (?$(O-"(B . "CIRCLED DIGIT TWO")
     (?$(O-#(B . "CIRCLED DIGIT THREE")
     (?$(O-$(B . "CIRCLED DIGIT FOUR")
     (?$(O-%(B . "CIRCLED DIGIT FIVE")
     (?$(O-&(B . "CIRCLED DIGIT SIX")
     (?$(O-'(B . "CIRCLED DIGIT SEVEN")
     (?$(O-((B . "CIRCLED DIGIT EIGHT")
     (?$(O-)(B . "CIRCLED DIGIT NINE")
     (?$(O-*(B . "CIRCLED NUMBER TEN")
     (?$(O-+(B . "CIRCLED NUMBER ELEVEN")
     (?$(O-,(B . "CIRCLED NUMBER TWELVE")
     (?$(O--(B . "CIRCLED NUMBER THIRTEEN")
     (?$(O-.(B . "CIRCLED NUMBER FOURTEEN")
     (?$(O-/(B . "CIRCLED NUMBER FIFTEEN")
     (?$(O-0(B . "CIRCLED NUMBER SIXTEEN")
     (?$(O-1(B . "CIRCLED NUMBER SEVENTEEN")
     (?$(O-2(B . "CIRCLED NUMBER EIGHTEEN")
     (?$(O-3(B . "CIRCLED NUMBER NINETEEN")
     (?$(O-4(B . "CIRCLED NUMBER TWENTY")
     (?$(O-5(B . "ROMAN NUMERAL ONE")
     (?$(O-6(B . "ROMAN NUMERAL TWO")
     (?$(O-7(B . "ROMAN NUMERAL THREE")
     (?$(O-8(B . "ROMAN NUMERAL FOUR")
     (?$(O-9(B . "ROMAN NUMERAL FIVE")
     (?$(O-:(B . "ROMAN NUMERAL SIX")
     (?$(O-;(B . "ROMAN NUMERAL SEVEN")
     (?$(O-<(B . "ROMAN NUMERAL EIGHT")
     (?$(O-=(B . "ROMAN NUMERAL NINE")
     (?$(O->(B . "ROMAN NUMERAL TEN")
     (?$(O-?(B . "ROMAN NUMERAL ELEVEN")
     (?$(O-@(B . "SQUARE MIRI")
     (?$(O-A(B . "SQUARE KIRO")
     (?$(O-B(B . "SQUARE SENTI")
     (?$(O-C(B . "SQUARE MEETORU")
     (?$(O-D(B . "SQUARE GURAMU")
     (?$(O-E(B . "SQUARE TON")
     (?$(O-F(B . "SQUARE AARU")
     (?$(O-G(B . "SQUARE HEKUTAARU")
     (?$(O-H(B . "SQUARE RITTORU")
     (?$(O-I(B . "SQUARE WATTO")
     (?$(O-J(B . "SQUARE KARORII")
     (?$(O-K(B . "SQUARE DORU")
     (?$(O-L(B . "SQUARE SENTO")
     (?$(O-M(B . "SQUARE PAASENTO")
     (?$(O-N(B . "SQUARE MIRIBAARU")
     (?$(O-O(B . "SQUARE PEEZI")
     (?$(O-P(B . "SQUARE MM")
     (?$(O-Q(B . "SQUARE CM")
     (?$(O-R(B . "SQUARE KM")
     (?$(O-S(B . "SQUARE MG")
     (?$(O-T(B . "SQUARE KG")
     (?$(O-U(B . "SQUARE CC")
     (?$(O-V(B . "SQUARE M SQUARED")
     (?$(O-W(B . "ROMAN NUMERAL TWELVE")
     (?$(O-_(B . "SQUARE ERA NAME HEISEI")
     (?$(O-`(B . "REVERSED DOUBLE PRIME QUOTATION MARK")
     (?$(O-a(B . "LOW DOUBLE PRIME QUOTATION MARK")
     (?$(O-b(B . "NUMERO SIGN")
     (?$(O-c(B . "SQUARE KK")
     (?$(O-d(B . "TELEPHONE SIGN")
     (?$(O-e(B . "CIRCLED IDEOGRAPH HIGH")
     (?$(O-f(B . "CIRCLED IDEOGRAPH CENTRE")
     (?$(O-g(B . "CIRCLED IDEOGRAPH LOW")
     (?$(O-h(B . "CIRCLED IDEOGRAPH LEFT")
     (?$(O-i(B . "CIRCLED IDEOGRAPH RIGHT")
     (?$(O-j(B . "PARENTHESIZED IDEOGRAPH STOCK")
     (?$(O-k(B . "PARENTHESIZED IDEOGRAPH HAVE")
     (?$(O-l(B . "PARENTHESIZED IDEOGRAPH REPRESENT")
     (?$(O-m(B . "SQUARE ERA NAME MEIZI")
     (?$(O-n(B . "SQUARE ERA NAME TAISYOU")
     (?$(O-o(B . "SQUARE ERA NAME SYOUWA")
     (?$(O-s(B . "CONTOUR INTEGRAL")
     (?$(O-x(B . "RIGHT ANGLE")
     (?$(O-y(B . "RIGHT TRIANGLE")
     (?$(O-}(B . "BLACK DIAMOND MINUS WHITE X")
     (?$(O-~(B . "WHITE RIGHT POINTING INDEX"))))
 (while jisx0213-charnames
   (put-char-code-property (caar jisx0213-charnames)
                           'ucs-character-name
                           (cdar jisx0213-charnames))
   (setq jisx0213-charnames (cdr jisx0213-charnames))))

(defun sort-char-by-charname (charlist)
  (sort charlist 
        '(lambda (x y) (string<
                        (get-char-code-property x 'ucs-character-name)
                        (get-char-code-property y 'ucs-character-name)))))

(provide 'x0213-char)
