;;; -*- coding: ascii  -*-
;;; big5type.el --- conversion between Big5 and Emacs representation(Mainly CNS)

;; Copyright (C) 1999 Miyashita Hisashi

;; Keywords: mule, multilingual, 
;;           MULE-UCS, Big5, CNS, Traditional Chinese

;; This file is part of MULE-UCS

;; MULE-UCS is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; MULE-UCS is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with this program; see the file COPYING.  If not, write to the
;; Free Software Foundation, Inc., 59 Temple Place - Suite 330,
;; Boston, MA 02111-1307, USA.

;; Comment:
;;   This module provides type definition on big5conv.

(require 'mucs)

(mucs-define-type
 'big5
 'identity
 'identity)

(mucs-type-register-serialization
 'big5
 'big5-be-2-octet
 '((if (r0 > ?\xA0)
       ((r0 = (r0 >8 0))
	(write r0 r7))
     ((write r0))))
 '((read-if (r0 > ?\xA0)
	    ((read r7)
	     (r0 = (r0 <8 r7)))))
 )

(mucs-type-register-serialization
 'big5
 'big5-be-2-octet-dos
 '((if (r0 == ?\x0a)
       ((write "\x0d\x0a"))
     ((if (r0 > ?\xA0)
	  ((r0 = (r0 >8 0))
	   (write r0 r7))
	((write r0))))))
 'none)

(provide 'big5type)


