;;; mew-win32.el --- Settings for Mew on Win32

;; Author:  Shuichi Kitaguchi <kit@Mew.org>
;; Created: Dec 05, 1997
;; Revised: Jul  8, 2001

;;; Code:

;;; for NTEmacs User
;;
;; put mw32script.el(in Meadow's archive) into load-path.
;;

;;
;;  ~/.emacs settings
;;

;;; for PRINTING
;;    mew-w32-prog-print     ...  print command
;;    mew-w32-prog-print-arg ...  print command argument
;;    mew-w32-cs-print       ...  coding-system for printing
;;    define-process-argument-editing  ...  for argument-editing
;;
;;; example
;;   (setq mew-w32-prog-print     "notepad.exe")
;;   (setq mew-w32-prog-print-arg "/p")
;;   (setq mew-w32-cs-print       '*sjis*dos)      ;; Mule for Win32
;;   (setq mew-w32-cs-print       'shift_jis-dos)  ;; Meadow
;;   (define-process-argument-editing "/notepad\\.exe$"
;;     (lambda (x)
;;       (general-process-argument-editing-function x nil t)))
;;   (setq mew-print-function (function mew-w32-print-buffer))

;; Win32 programs.
(defvar mew-w32-exec           "fiber.exe")
(defvar mew-w32-prog-print     "notepad.exe")
(defvar mew-w32-prog-print-arg nil)


;; Emacs version dependent variables.
(cond
 ((featurep 'xemacs)			; XEmacs
  (setq mew-prog-shell-arg  shell-command-switch))
  
 ((<= 20 emacs-major-version)
  (setq mew-prog-shell-arg  shell-command-switch)
  
  (if (featurep 'meadow) ;; Meadow
      (progn
	(require 'mw32script)
	(mw32script-init))
    (if (require 'mw32script nil t) ;; NTEmacs
	(progn
	  (mw32script-make-pathext-regexp)
	  (defalias 'call-process-original 'call-process)
	  (defun call-process (PROGRAM INFILE BUFFER DISPLAY &rest PROGRAM-ARGS)
	    (let (prog sargs)
	      (setq prog (mw32script-openp PROGRAM))
	      (if (not prog)
		  (progn
		    (setq prog (mew-which-exec PROGRAM))
		    (setq sargs (mw32script-resolve-script prog))))
	      (if sargs
		  (apply (function call-process-original)
			 (car sargs) INFILE BUFFER DISPLAY
			 prog PROGRAM-ARGS)
		(apply (function call-process-original)
		       PROGRAM INFILE BUFFER DISPLAY PROGRAM-ARGS))))
	  (defalias 'start-process-original 'start-process)
	  (defun start-process (NAME BUFFER PROGRAM &rest PROGRAM-ARGS)
	    (let (prog sargs)
	      (setq prog (mw32script-openp PROGRAM))
	      (if (not prog)
		  (progn
		    (setq prog (mew-which-exec PROGRAM))
		    (setq sargs (mw32script-resolve-script prog))))
	      (if sargs
		  (apply (function start-process-original)
			 NAME BUFFER (car sargs) prog PROGRAM-ARGS)
		(apply (function start-process-original)
		       NAME BUFFER PROGRAM PROGRAM-ARGS))))))
    )))

;; common programs.
(setq mew-prog-shell        shell-file-name)

(setq mew-delete-temp-file  nil)

;; printing
(defun mew-w32-print-buffer ()
  (interactive)
  (setq tempfile (mew-make-temp-name))
  (mew-frwlet
   mew-cs-dummy mew-w32-cs-print
   (write-region (point-min) (point-max) tempfile nil nil))
  (setq w32-start-process-show-window t)
  (cond
   ((eq mew-w32-prog-print-arg nil)
    (call-process mew-w32-prog-print nil nil nil tempfile))
   (t
    (call-process mew-w32-prog-print nil nil nil mew-w32-prog-print-arg tempfile)))
  (setq w32-start-process-show-window nil)
  (delete-file tempfile))


;; MIME setting
(defvar mew-prog-plain    '(mew-mime-text/plain mew-mime-text/plain-ext))
(defvar mew-prog-html     '(mew-mime-text/html mew-mime-text/html-ext))
(defvar mew-prog-enriched 'mew-mime-text/enriched)
(defvar mew-prog-text     'mew-mime-text/plain)
(defvar mew-prog-image           '(mew-mime-image/* mew-mime-image/*-ext))
(defvar mew-prog-mpeg            `(,mew-w32-exec           () t))
(defvar mew-prog-rfc822          'mew-mime-message/rfc822)
(defvar mew-prog-external-body   '(mew-mime-external-body mew-mime-external-body-ext))
(defvar mew-prog-delivery-status 'mew-mime-text/plain)
(defvar mew-prog-postscript      `(,mew-w32-exec           () t))
(defvar mew-prog-pgp-keys        '(mew-mime-pgp-keys mew-mime-pgp-keys-ext))
(defvar mew-prog-pdf             `(,mew-w32-exec           () t))
(defvar mew-prog-octet-stream    `(,mew-w32-exec           () t))
(defvar mew-prog-msword          `(,mew-w32-exec           () t))
(defvar mew-prog-msexcel         `(,mew-w32-exec           () t))
(defvar mew-prog-mspowerpoint    `(,mew-w32-exec           () t))

(defvar mew-prog-w32             `(,mew-w32-exec           () t))

;;;
;;; Text/Html, Image
;;;

(defvar mew-prog-text/html         'mew-mime-text/html-w3m) ;; See w3m.el
(defvar mew-prog-text/html-ext     mew-w32-exec)
(defvar mew-prog-text/html-ext-arg nil)

(defvar mew-prog-image/*         'mew-mime-image/*)
(defvar mew-prog-image/*-ext     mew-w32-exec)
(defvar mew-prog-image/*-ext-arg nil)

(defvar mew-prog-application/msword nil)
(defvar mew-prog-application/msexcel nil)
(defvar mew-prog-application/mspowerpoint nil)

(setq mew-mime-content-type
      (append
       '(
	 ;; Audio (mew-prog-audio)
	 ("audio/x-wav"     "\\.wav$"   mew-b64 mew-prog-audio mew-icon-audio)
	 ("audio/x-aiff"    "\\.aif?f$" mew-b64 mew-prog-audio mew-icon-audio)
	 ("audio/x-midi"    "\\.midi?$" mew-b64 mew-prog-audio mew-icon-audio)
	 ;; Image (mew-prog-image)
	 ("image/x-pcx"     "\\.pcx$"   mew-b64 mew-prog-image mew-icon-image)
	 ("image/x-tga"     "\\.tga$"   mew-b64 mew-prog-image mew-icon-image)
	 ;; Video (mew-prog-mpeg)
	 ("video/x-msvideo" "\\.avi$"   mew-b64 mew-prog-mpeg  mew-icon-video)
	 ;; Executable (mew-prog-w32)
	 ("application/octet-stream" "\\.exe$\\|\\.com$\\|\\.cmd$\\|\\.bat$\\|\\.dll$"
	  mew-b64 mew-prog-w32 mew-icon-application/octet-stream)
	 ;; Archive (mew-prog-w32)
	 ("application/octet-stream" "\\.arj$\\|\\.zoo$\\|\\.rar$|\\.cab$"
	  mew-b64 mew-prog-w32 mew-icon-application/octet-stream)
	 ;; Document (mew-prog-w32)
	 ("application/x-dvi" "\\.dvi$"
	  mew-b64 mew-prog-w32 mew-icon-application/postscript)
	 ;; OASYS (mew-prog-w32)
	 ("application/vnd.fujitsu.oasys" "\\.oas$"
	  mew-b64 mew-prog-w32 mew-icon-text)
	 ("application/vnd.fujitsu.oasys2" "\\.oa2$"
	  mew-b64 mew-prog-w32 mew-icon-text)
	 ;; Ichitaro V.2,3,4,5,6,7,8,9,10,Lite,Lite2 (mew-prog-w32)
	 ("application/octet-stream" "\\.jtd$\\|\\.jfw$\\|\\.jbw$\\|\\.jaw$\\|\\.jsw$\\|\\.jxw$\\|\\.jtt$\\|\\.jvw$\\|\\.juw$\\|\\.jtw$"
	  mew-b64 mew-prog-w32 mew-icon-text)
	 ;; Shockwave (mew-prog-w32)
	 ("application/x-shockwave-flash" "\\.swf$"
	  mew-b64 mew-prog-w32 mew-icon-image)
	 ;; MPEG audio (mew-prog-w32)
	 ("audio/x-mpeg" "\\.mpga$\\|\\.mp[23]$"
	  mew-b64 mew-prog-w32 mew-icon-image)
	 )
       mew-mime-content-type))

(setq mew-mime-content-type-list
      (append
       '(
	 ;; Image
	 "image/x-pcx" "image/x-pic"
	 ;; Audio
	 "audio/x-wav" "audio/x-aiff" "audio/x-midi"
	 ;; Video
	 "video/x-msvideo"
	 ;; Document
	 "application/x-dvi"
	 ;; OASYS
	 "application/vnd.fujitsu.oasys"
	 "application/vnd.fujitsu.oasys2"
	 ;; Shockwave
	 "application/x-shockwave-flash"
	 ;; MPEG audio
	 "audio/x-mpeg" "audio/mpeg"
	 )
       mew-mime-content-type-list))

(cond
 ((eq mew-mule-ver 2)
  (setq mew-cs-database-for-arg
	'((*iso-2022-jp* . *sjis*unix)
	  (*iso-2022-kr* . *euc-korea*unix))))
 ((eq mew-mule-ver 3)
  (setq mew-cs-database-for-arg
	'((iso-2022-jp . shift_jis-unix)
	  (iso-2022-kr . euc-kr-unix)))))

(setq mew-prog-grep-max-msgs 2000) ;; for external grep (pick & virtual)

(provide 'mew-win32)

;;; Copyright Notice:

;; Copyright (C) 1996-2001 Mew developing team.
;; All rights reserved.

;; Redistribution and use in source and binary forms, with or without
;; modification, are permitted provided that the following conditions
;; are met:
;; 
;; 1. Redistributions of source code must retain the above copyright
;;    notice, this list of conditions and the following disclaimer.
;; 2. Redistributions in binary form must reproduce the above copyright
;;    notice, this list of conditions and the following disclaimer in the
;;    documentation and/or other materials provided with the distribution.
;; 3. Neither the name of the team nor the names of its contributors
;;    may be used to endorse or promote products derived from this software
;;    without specific prior written permission.
;; 
;; THIS SOFTWARE IS PROVIDED BY THE TEAM AND CONTRIBUTORS ``AS IS'' AND
;; ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
;; IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
;; PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE TEAM OR CONTRIBUTORS BE
;; LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
;; CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
;; SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
;; BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
;; WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
;; OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN
;; IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

;;; mew-win32.el ends here
