;;; mew-nntp.el

;; Author:  Kazu Yamamoto <Kazu@Mew.org>
;; Created: Feb  1, 1999
;; Revised: Jul  8, 2001

;;; Code:

(require 'mew)
(defvar mew-nntp-error nil)

(defvar mew-nntp-process nil)

(defvar mew-newsgroups-list nil)
(defvar mew-newsgroups-alist nil)

(defsubst mew-nntp-buffer-name (pnm)
  (concat mew-buffer-prefix pnm))

(defun mew-nntp-open (server port)
  (setq mew-nntp-error nil)
  (let* ((sprt (mew-port-sanity-check port))
	 (pnm (concat server "/" port))
	 (buf (mew-nntp-buffer-name pnm))
	 pro tm)
    (condition-case emsg
	(progn
	  (setq tm (mew-timer mew-nntp-timeout-time 'mew-nntp-timeout))
	  (message "Connecting to %s with %s port ... " server port)
	  (setq pro (open-network-stream pnm buf server sprt))
	  (process-kill-without-query pro)
	  (mew-set-process-cs pro mew-cs-text-for-net mew-cs-text-for-net)
	  (message "Connecting to %s with %s port ... done" server port))
      (quit
       (setq mew-nntp-error
	     (format "can't make a %s connection to %s" port server))
       (setq pro nil)
       (message mew-nntp-error))
      (error
       (setq mew-nntp-error (nth 1 emsg))
       (setq pro nil)
       (message mew-nntp-error)))
    (if tm (cancel-timer tm))
    pro))

(defun mew-nntp-timeout ()
  (signal 'quit nil))

(defun mew-nntp-connect ()
  (if (and (processp mew-nntp-process)
	   (memq (process-status mew-nntp-process) '(open)))
      ()
    (setq mew-nntp-process (mew-nntp-open mew-nntp-server mew-nntp-port))))

(defun mew-nntp-get-list ()
  (mew-nntp-connect)
  (set-buffer (process-buffer mew-nntp-process))
  (erase-buffer)
  (process-send-string mew-nntp-process "LIST\n")
  (goto-char (point-max))
  (while (not (re-search-backward "^.$" nil t))
    (accept-process-output mew-nntp-process 1)
    (goto-char (point-max)))
  (delete-region (point) (point-max))
  (goto-char (point-min))
  (while (looking-at "^[0-9][0-9][0-9]")
    (forward-line))
  (setq mew-newsgroups-list (mew-newsgroups-make-list))
  (setq mew-newsgroups-alist (mew-newsgroups-make-alist mew-newsgroups-list)))

(defun mew-nntp-close ()
  (interactive)
  (if (processp mew-nntp-process)
      (progn
	(process-send-string mew-nntp-process "QUIT")
	(delete-process mew-nntp-process)
	(setq mew-nntp-process nil))))

(defun mew-newsgroups-make-list ()
  (let (ret)
    (while (looking-at "^\\([^ ]+\\) ")
      (setq ret (cons (mew-match 1) ret))
      (forward-line))
    (nreverse ret)))

(defsubst mew-newsgroups-make-alist (list)
  (mapcar (lambda (x) (list x x)) list))

(provide 'mew-nntp)

;;; Copyright Notice:

;; Copyright (C) 1999-2001 Mew developing team.
;; All rights reserved.

;; Redistribution and use in source and binary forms, with or without
;; modification, are permitted provided that the following conditions
;; are met:
;; 
;; 1. Redistributions of source code must retain the above copyright
;;    notice, this list of conditions and the following disclaimer.
;; 2. Redistributions in binary form must reproduce the above copyright
;;    notice, this list of conditions and the following disclaimer in the
;;    documentation and/or other materials provided with the distribution.
;; 3. Neither the name of the team nor the names of its contributors
;;    may be used to endorse or promote products derived from this software
;;    without specific prior written permission.
;; 
;; THIS SOFTWARE IS PROVIDED BY THE TEAM AND CONTRIBUTORS ``AS IS'' AND
;; ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
;; IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
;; PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE TEAM OR CONTRIBUTORS BE
;; LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
;; CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
;; SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
;; BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
;; WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
;; OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN
;; IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

;;; mew-nntp.el ends here
