#!/bin/sh
# $XFree86: test/xsuite/build.sh,v 1.3 2004/01/09 23:05:16 dawes Exp $
#
# This script can be used to build the xtest suite.
#
# Copyright  2003 by The XFree86 Project, Inc.
# Copyright  2003 by David H. Dawes
#
# Permission is hereby granted, free of charge, to any person obtaining a
# copy of this software and associated documentation files (the "Software"),
# to deal in the Software without restriction, including without limitation
# the rights to use, copy, modify, merge, publish, distribute, sublicense,
# and/or sell copies of the Software, and to permit persons to whom the
# Software is furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
# THE COPYRIGHT HOLDER(S) OR AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR
# OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
# ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
# OTHER DEALINGS IN THE SOFTWARE.
#
# Except as contained in this notice, the name of the copyright holder(s)
# and author(s) shall not be used in advertising or otherwise to promote
# the sale, use or other dealings in this Software without prior written
# authorization from the copyright holder(s) and author(s).
#

OsName="`uname`"
OsVersion="`uname -r`"
case "$OsName" in
*BSD)
	tetOS=bsd
	;;
Linux)
	tetOS=linux
	;;
SunOS)
	# Assume Solaris
	tetOS=svr4
	;;
*)
	# Fallback
	echo "Unknown OS.  Trying a fallback."
	tetOS=std
esac
rm -f xtest/tetbuild.cfg
ln -s tetbuild.cfg.$tetOS xtest/tetbuild.cfg
rm -f xtest/tetclean.cfg
ln -s tetbuild.cfg xtest/tetclean.cfg
xmkmf
TET_ROOT=`pwd`
R=$TET_ROOT
X=$R/xtest
L=$X/lib
make TET_ROOT=$R TETBASE=$R/tet XTESTBIN=$X/bin XTESTINCDIR=$X/include \
 XTESTLIB=$L/libxtest.a XSTLIB=$L/libXst.a XTESTFONTDIR=$X/fonts/install
