/* $XFree86: test/xsuite/xtest/tset/CH06/cpypln/cpypln.m,v 1.2 2005/10/05 00:46:33 dawes Exp $ */
/*
 
Copyright (c) 1990, 1991  X Consortium

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

Except as contained in this notice, the name of the X Consortium shall not be
used in advertising or otherwise to promote the sale, use or other dealings
in this Software without prior written authorization from the X Consortium.

 *
 * Copyright 1990, 1991 by UniSoft Group Limited.
 * 
 * Permission to use, copy, modify, distribute, and sell this software and
 * its documentation for any purpose is hereby granted without fee,
 * provided that the above copyright notice appear in all copies and that
 * both that copyright notice and this permission notice appear in
 * supporting documentation, and that the name of UniSoft not be
 * used in advertising or publicity pertaining to distribution of the
 * software without specific, written prior permission.  UniSoft
 * makes no representations about the suitability of this software for any
 * purpose.  It is provided "as is" without express or implied warranty.
 *
 */
>>TITLE XCopyPlane CH06
void
XCopyPlane(display, src, dest, gc, src_x, src_y, width, height, dest_x, dest_y, plane);
Display	*display = Dsp;
Drawable src;
Drawable dest;
GC  	gc;
int 	src_x = 6;
int 	src_y = 5;
unsigned int 	width = 30;
unsigned int 	height = 40;
int 	dest_x = 5;
int		dest_y = 9;
unsigned long	plane = 1;
>>EXTERN

#include	"Xproto.h"
#include	<limits.h>

#define	CPYPL_PIX	0x55555555

#define XOFF	50
#define TRIM	20

>>ASSERTION Good A
A call to xname
uses the
.M foreground
pixel in the GC for each bit
in
.A src
that is set to 1 and the
.M background
pixel in the GC for each bit in
.A src
that is set to 0 and 
combines the specified rectangle of
.A src
with the specified rectangle of
.A dest .
>>#according to the 
>>#.M function 
>>#in the argument
>>#.A gc .
>>STRATEGY
Create pair of windows.
Fill one window with pixel having some bits set and some unset.
Call XCopyPlane to copy one plane of an area.
Check that the copied area is set to the foreground when
the plane contains 1 and background when the plane contains 0.
>>CODE
XVisualInfo	*vp;
struct	area	area;
unsigned long	depth;
unsigned long	fg;

	for (resetvinf(VI_WIN_PIX); nextvinf(&vp); ) {

		winpair(display, vp, &src, &dest);

		dset(display, src, CPYPL_PIX);

		gc = makegc(display, dest);

		depth = vp->depth;

		for (plane = 1; depth-- > 0; plane <<= 1) {
			XCALL;

			area.x = dest_x;
			area.y = dest_y;
			area.width = width;
			area.height = height;

			/*
			 * Is the plane we are dealing with set to 1?  In which case
			 * the area should be the foreground; or 0 in which case
			 * the area should be the background.
			 */
			fg = (plane & CPYPL_PIX)? W_FG: W_BG;
			if (checkarea(display, dest, &area, fg, W_BG, CHECK_ALL)) {
				if (plane == 1)
					CHECK;
			} else {
				report("Window did not have expected contents");
				FAIL;
			}
		}
		
	}

	CHECKPASS(nvinf());

>>ASSERTION def
A call to xname uses a single bit plane of the specified source rectangle
.A src
combined with the specified GC to modify the specified rectangle of
.A dest .
>># NOTE - In testing, what this means is that the contents of other 
>># bit planes make no difference to the action of xname. DPJC
>>ASSERTION Good A
If the screen supports drawables of more than one depth:
.in +2
The drawables need not have the same depth.
.in -2
>>STRATEGY
If there is a visual with depth other than one.
	Copy between it and a pixmap of depth one.
Else
	Report UNSUPPORTED.
>>CODE
XVisualInfo	*vp;
struct	area	area;
unsigned long	depth;
unsigned long	fg;

	depth = 0;
	for (resetvinf(VI_WIN_PIX); nextvinf(&vp); ) {

		if (vp->depth != 1) {
			depth = vp->depth;
			break;
		}
	}

	if (depth == 0) {
		report("Only one depth is supported");
		tet_result(TET_UNSUPPORTED);
		return;
	}

	src = makewin(display, vp);
	vp->depth = 1;
	dest = makepixm(display, vp);

	dset(display, src, CPYPL_PIX);

	gc = makegc(display, dest);

	for (plane = 1; depth-- > 0; plane <<= 1) {
		XCALL;

		area.x = dest_x;
		area.y = dest_y;
		area.width = width;
		area.height = height;

		/*
		 * Is the plane we are dealing with set to 1?  In which case
		 * the area should be the foreground; or 0 in which case
		 * the area should be the background.
		 */
		fg = (plane & CPYPL_PIX)? W_FG: W_BG;
		if (checkarea(display, dest, &area, fg, W_BG, CHECK_ALL)) {
			if (plane == 1)
				CHECK;
		} else {
			report("Window did not have expected contents");
			FAIL;
		}
	}
	
	CHECKPASS(1);

>>ASSERTION Good A
When regions of the source rectangle are obscured and have not been
retained in backing store 
or regions outside the boundaries of the source drawable are specified,
then 
those regions are not copied.
>>STRATEGY
make src window and draw into it (background of 0)
make dest window with background of 1 and draw into it
copy region that extends off the edge of the source drawable
verify that it is not copied.
>>CODE
Window  w1, w2;
XVisualInfo *vp;
Pixmap  pm;
struct  area	area;

	/*
	 * I have taken this assertion to deal with pixmaps, while the similar
	 * one that mentions background tiling is used to deal with windows.
	 */
	for (resetvinf(VI_PIX); nextvinf(&vp); ) {
		winpair(display, vp, &w1, &w2);

		pattern(display, w1);

		src = w1;
		dest = w2;

		gc = makegc(display, dest);

		/*
		 * Use a width of the size of the window minus TRIM, therefore
		 * it will extend off the edge of the window by width-src_x pixels.
		 */
		getsize(display, w1, &width, (unsigned int*)0);
		src_x = width-XOFF;
		width -= TRIM;

		dest_x = 0;
		dest_y = 0;

		plane = 1;

		XCALL;

		area.x = dest_x;
		area.y = dest_y;
		area.width = width;
		area.height = height;

		if (checkarea(display, dest, &area, 0, W_BG, CHECK_OUT) == False) {
			report("window modified outside the target area");
			FAIL;
		} else
			CHECK;
	}
	CHECKPASS(nvinf());

>>ASSERTION Good A
When regions of the source rectangle are obscured and have not been
retained in backing store 
or regions outside the boundaries of the source drawable are specified
and the destination is a window with a background other than
.S None ,
then all corresponding destination regions that are either
visible or are retained in backing store
are tiled with that background
with plane-mask of all ones and
.S GXcopy 
function.
>>STRATEGY
make src window and draw into it (background of 0)
make dest window with background of 1 and draw into it
copy region that extends off the edge of the source drawable
verify that it is not copied.
>>CODE
Window  w1, w2;
XVisualInfo *vp;
Pixmap  pm;
struct  area	area;

	for (resetvinf(VI_WIN); nextvinf(&vp); ) {
		winpair(display, vp, &w1, &w2);

		pattern(display, w1);

		src = w1;
		dest = w2;

		gc = makegc(display, dest);

		/*
		 * Set the destination background pixmap.
		 */
		pm = maketile(display, w2);
		XSetWindowBackgroundPixmap(display, w2, pm);

		/*
		 * Use a width of the size of the window minus TRIM, therefore
		 * it will extend off the edge of the window by width-src_x pixels.
		 */
		getsize(display, w1, &width, (unsigned int*)0);
		src_x = width-XOFF;
		width -= TRIM;

		dest_x = 0;
		dest_y = 0;

		plane = 1;

		XCALL;

		area.x = dest_x;
		area.y = dest_y;
		area.width = width;
		area.height = height;

		if (checkarea(display, dest, &area, 0, W_BG, CHECK_OUT) == False) {
			report("window modified outside the target area");
			FAIL;
		} else
			CHECK;

		area.x = XOFF;
		area.width = width - XOFF - TRIM;

		if (checktile(display, dest, &area, 0, 0, pm) == False) {
			report("area was not copied properly");
			FAIL;
		} else
			CHECK;

	}
	CHECKPASS(2*nvinf());

>>ASSERTION Good A
When 
.M graphics-exposures 
is 
.S True , 
then
.S GraphicsExpose 
events for all corresponding destination regions are generated.
>>STRATEGY
Set graphics-exposures to True.
Enable All Events.
DO as above.
Check events received, and x,y,width,height in each.
>>CODE
Window  w1, w2;
XEvent  event;
XVisualInfo *vp;
XGraphicsExposeEvent	ge;
int	 n;

	for (resetvinf(VI_WIN); nextvinf(&vp); ) {

		winpair(display, vp, &w1, &w2);

		src = w1;
		dest = w2;

		getsize(display, w1, &width, (unsigned int*)0);

		src_x = XOFF;
		dest_x = 0;
		plane = 1;
		gc = makegc(display, dest);

		XSelectInput(display, src, ALLEVENTS);
		XCALL;
		XSelectInput(display, dest, NoEventMask);

		if (getevent(display, &event) != 1 || event.type != GraphicsExpose) {
			report("Expecting one GraphicsExpose event");
			FAIL;
			return;
		}

		ge.type = GraphicsExpose;
		ge.display = display;
		ge.drawable = dest;
		ge.x = dest_x+width-XOFF;
		ge.y = dest_y;
		ge.width = XOFF;
		ge.height = height;
		ge.count = 0;
		ge.major_code = X_CopyPlane;
		ge.minor_code = 0;

		n = checkevent((XEvent*)&ge, &event);
		if (n == 0)
			CHECK;
		else {
			report("error in %d field%s of event", n, (n!=1)?"s":"");
			tet_result(TET_FAIL);
		}
	}

	CHECKPASS(nvinf());

>>ASSERTION Good A
When 
.M graphics-exposures 
is 
.S True 
and no
.S GraphicsExpose 
events are generated, then a
.S NoExpose 
event is generated.
>>STRATEGY
As above, but copy visable area
check for NoExpose event
>>CODE
Window  w1, w2;
XEvent  event;
XNoExposeEvent  ge;
XVisualInfo *vp;
int	 n;

	for (resetvinf(VI_WIN); nextvinf(&vp); ) {
		winpair(display, vp, &w1, &w2);

		src = w1;
		dest = w2;

		plane = 1;
		gc = makegc(display, dest);

		XSelectInput(display, src, ALLEVENTS);
		XCALL;
		XSelectInput(display, dest, NoEventMask);

		if (getevent(display, &event) != 1 || event.type != NoExpose) {
			report("Expecting one NoExpose event");
			FAIL;
			return;
		}

		ge.type = NoExpose;
		ge.display = display;
		ge.drawable = dest;
		ge.major_code = X_CopyPlane;
		ge.minor_code = 0;

		n = checkevent((XEvent*)&ge, &event);
		if (n == 0)
			CHECK;
		else {
			report("error in %d field%s of event", n, (n!=1)?"s":"");
			tet_result(TET_FAIL);
		}
	}
	CHECKPASS(nvinf());

>>ASSERTION gc
On a call to xname the GC components
.M function ,
.M plane-mask ,
.M foreground ,
.M background ,
.M subwindow-mode ,
.M graphics-exposures ,
.M clip-x-origin ,
.M clip-y-origin ,
and
.M clip-mask
are used.
>>ASSERTION Bad A
.ER BadDrawable
>>ASSERTION Bad A
.ER BadGC
>>ASSERTION Bad A
.ER BadMatch inputonly
>>ASSERTION Bad A
.ER BadMatch gc-drawable-screen
>>ASSERTION Bad A
When the bit set in
.A plane
does not refer to a valid plane for the screen, then a
.S BadValue 
error occurs.
>>STRATEGY
For each drawable type
  Ignore those that have no invalid planes.
  Call XCopyPlane with plane set to first invalid number.
  Verify that a BadValue error occurred.
>>CODE BadValue
XVisualInfo	*vp;
int 	unsupp = 0;

	for (resetvinf(VI_WIN_PIX); nextvinf(&vp); ) {

		/*
		 * If all planes are valid then a BadValue is not possible
		 * with this drawable
		 */
		if (vp->depth >= CHAR_BIT*sizeof(long)) {
			trace("Visual with depth of %d, no planes invalid", vp->depth);
			unsupp++;
			continue;
		}
		winpair(display, vp, &src, &dest);

		gc = makegc(display, dest);
		plane = (1<<vp->depth);

		XCALL;

		if (geterr() == BadValue)
			CHECK;
	}
	if (unsupp == nvinf()) {
		/*
		 * This can't happen when we are including pixmaps since depth 1
		 * pixmap is always supported.
		 */
		report("All planes are valid on all drawables");
		tet_result(TET_UNSUPPORTED);
		return;
	}

	CHECKPASS(nvinf()-unsupp);

>>ASSERTION Bad A
When
.A plane
does not have exactly one bit set to 1, then
a
.S BadValue
error occurs.
>>STRATEGY
For each drawable type
  Make window pair.
  Call XCopyPlane with plane set to 0.
  Verify that BadValue error occurs.
  If depth is greater than 1
	Call XCopyPlane with plane set to 3.
	Verify that BadValue error occurs.
>>CODE BadValue
XVisualInfo	*vp;
int 	unsupp = 0;

	for (resetvinf(VI_WIN_PIX); nextvinf(&vp); ) {

		winpair(display, vp, &src, &dest);

		gc = makegc(display, dest);
		plane = 0;

		XCALL;

		if (geterr() == BadValue)
			CHECK;

		if (vp->depth > 1) {
			plane = 0x3;
			XCALL;
			if (geterr() == BadValue)
				CHECK;
		} else
			unsupp++;
	}

	CHECKPASS(2*nvinf()-unsupp);

>># HISTORY steve Completed	Written in new format and style
>># HISTORY kieron Completed	Global and pixel checking to do - 19/11/90
>># HISTORY dave Completed	Final checking to do - 21/11/90
