.\"
.\" $XFree86: xc/doc/man/Xi/XChDCtl.man,v 1.5 2006/01/09 14:56:19 dawes Exp $
.\"
.\"
.\" Copyright ([\d,\s]*) by Hewlett-Packard Company, Ardent Computer, 
.\" 
.\" Permission to use, copy, modify, distribute, and sell this documentation 
.\" for any purpose and without fee is hereby granted, provided that the above
.\" copyright notice and this permission notice appear in all copies.
.\" Ardent, and Hewlett-Packard make no representations about the 
.\" suitability for any purpose of the information in this document.  It is 
.\" provided \`\`as is'' without express or implied warranty.
.\" 
.ds xL Programming With Xlib
.TH XGetDeviceControl 3X11 __vendorversion__ "X FUNCTIONS"
.SH NAME
XGetDeviceControl, XChangeDeviceControl \- query and change input device controls
.SH SYNTAX
.HP
XDeviceControl *XGetDeviceControl\^(\^Display *\fIdisplay\fP\^, XDevice
*\fIdevice\fP\^, int *\fIcontrolType\fP\^); 
.HP
int XChangeDeviceControl\^(\^Display *\fIdisplay\fP\^, XDevice
*\fIdevice\fP\^, int \fIcontrolType\fP\^, XDeviceControl *\fIcontrol\fP\^); 
.SH ARGUMENTS
.TP 15
.I display
Specifies the connection to the X server.
.TP 15
.I device
Specifies the device whose control is to be interrogated or modified.
.TP 15
.I controlType
Specifies the type of control to be interrogated or changed.
.TP 15 
.I control
Specifies the address of an \fIXDeviceControl\fP structure that contains
the new values for the Device.
.SH DESCRIPTION
These requests are provided to manipulate those input devices that
support device control.  A \fIBadMatch\fP error will be generated if the
requested device does not support any device controls.
.LP
Valid device control types that can be used with these requests include the
following:
.TP 20
DEVICE_RESOLUTION
Queries or changes the resolution of valuators on input devices.
.LP
The \fIXGetDeviceControl\fP request returns a pointer to an
\fIXDeviceControl\fP structure. 
.LP
\fIXGetDeviceControl\fP can generate a \fIBadDevice\fP or
\fIBadMatch\fP error.
.LP
The \fIXChangeDeviceControl\fP request modifies the values of one 
control on the specified device.  The control is identified by the id
field of the \fIXDeviceControl\fP structure that is passed with the
request.
.LP
\fIXChangeDeviceControl\fP can generate a \fIBadDevice\fP,
\fIBadMatch\fP, or \fIBadValue\fP  error.
.SH STRUCTURES
Each control is described by a structure specific to that control.
These structures are defined in the file \fIXInput.h\fP.
.LP
\fIXDeviceControl\fP is a generic 
structure that contains two fields that are at the beginning of each class
of control:
.LP
.DS
.nf
typedef struct {
.br
	XID class;                         
.br
	int length;                                      
.br
} XDeviceControl;
.fi
.DE
.LP
The \fIXDeviceResolutionState\fP structure defines the information that is
returned for device resolution for devices with valuators.
.LP
.DS
.nf
typedef struct {
	XID     control;
	int     length;
	int     num_valuators;
	int     *resolutions;
	int     *min_resolutions;
	int     *max_resolutions;
} XDeviceResolutionState;
.fi
.DE
.LP
The \fIXDeviceResolutionControl\fP structure defines the attributes that can be
controlled for keyboard Devices.
.LP
.DS
.nf
typedef struct {
	XID     control;
	int     length;
	int     first_valuator;
	int     num_valuators;
	int     *resolutions;
} XDeviceResolutionControl;
.fi
.DE
.SH DIAGNOSTICS
.TP 12
\fIBadDevice\fP
An invalid device was specified.  The specified device does not exist or has 
not been opened by this client via \fIXOpenInputDevice\fP.  This error may
also occur if some other client has caused the specified device to become
the X keyboard or X pointer device via the \fIXChangeKeyboardDevice\fP or
\fIXChangePointerDevice\fP requests.
.TP 12
\fIBadMatch\fP
This error may occur if an \fIXGetDeviceControl\fP request was made specifying
a device that has no controls or an \fIXChangeDeviceControl\fP request was
made with an \fIXDeviceControl\fP structure that contains an invalid Device
type.  It may also occur if an invalid combination of mask bits is specified
(\fIDvKey\fP but no \fIDvAutoRepeatMode\fP for keyboard Devices), or if an 
invalid KeySym is specified for a string Device.
.TP 12
\fIBadValue\fP
Some numeric value falls outside the range of values accepted by the 
\fIXChangeDeviceControl\fP request.
Unless a specific range is specified for an argument, the full range defined
by the argument's type is accepted.  Any argument defined as a set of
alternatives can generate this error.
.SH "SEE ALSO"
.br
\fI\*(xL\fP
