.\" $XFree86: xc/doc/man/DMX/DMXQueryVersion.man,v 1.1 2004/06/30 20:21:36 martin Exp $
.\"
.\" Copyright 2004 Red Hat Inc., Durham, North Carolina.
.\" All Rights Reserved.
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining
.\" a copy of this software and associated documentation files (the
.\" "Software"), to deal in the Software without restriction, including
.\" without limitation on the rights to use, copy, modify, merge,
.\" publish, distribute, sublicense, and/or sell copies of the Software,
.\" and to permit persons to whom the Software is furnished to do so,
.\" subject to the following conditions:
.\"
.\" he above copyright notice and this permission notice (including the
.\" next paragraph) shall be included in all copies or substantial
.\" portions of the Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
.\" EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
.\" NON-INFRINGEMENT.  IN NO EVENT SHALL RED HAT AND/OR THEIR SUPPLIERS
.\" BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
.\" ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
.\" CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
.\" SOFTWARE.
.TH DMXQueryVersion 3X __vendorversion__
.SH NAME
DMXQueryVersion \- determine DMX extension version
.SH SYNOPSIS
.B #include <X11/extensions/dmxext.h>
.sp
.nf
.BI "Bool DMXQueryVersion(Display " *dpy ,
.BI "                     int " *major_version ,
.BI "                     int " *minor_version ,
.BI "                     int " *patch_version );
.fi
.SH DESCRIPTION
.B DMXQueryVersion()
returns version information about the DMX protocol extension.
.PP
Any incompatible changes to the protocol will be indicated by
a change in
.IR major_version .
Small, upward-compatible changes will be indicated by a change in
.IR minor_version .
In general,
.I patch_version
is for informational purposes and will encode the date of the last
protocol revision (e.g., 20040604).
.SH "RETURN VALUE"
If the DMX protocol extension is available,
.IR major_version ,
.IR minor_version ,
and
.I patch_version
will be set, and
.B True
will be returned.  Otherwise,
.B False
will be returned.
.SH NOTES
At the time of this writing, the DMX protocol is at version 2.2.
.PP
Version 2.2 was the final development version, and code supporting this
version was submitted to upstream X server repositories in the summer of
2004.
.PP
Version 1.5 was the last of the 1.x series, which was used for
development before screen and input addition and removal were supported.
Version 2.0 and 2.1 were development versions that partially supported
screen and input addition and removal.
.PP
Since we do not expect development versions to be widely used, we
recommend that any software that uses the DMX protocol extension to
support only versions 2.2 and above (although they should detect earlier
versions and either reduce functionality or fail gracefully).
.SH "SEE ALSO"
.BR DMXQueryExtension "(3X), "
.BR DMX "(3X), " Xdmx (1)
