.\" $XFree86: xc/config/util/ccmakedep.man,v 1.3 2005/03/29 04:00:28 tsi Exp $
.TH ccmakedep 1 __vendorversion__
.SH NAME
ccmakedep \- create dependencies in makefiles using a C compiler
.SH SYNOPSIS
.B ccmakedep
[
.BI cpp-flags
] [
.BI \-w width
] [
.BI \-s magic-string
] [
.BI \-f makefile
] [
.BI \-o object-suffix
] [
.B \-v
] [
.B \-a
] [
.BI \-cc compiler
] [
\-\^\-
.I options
\-\^\-
]
.I sourcefile
\^.\|.\|.
.SH DESCRIPTION
The
.B ccmakedep
program calls a C compiler to preprocess each
.IR sourcefile ,
and uses the output to construct
.I makefile
rules describing their dependencies.
These rules instruct
.BR make (1)
on which object files must be recompiled when a dependency has changed.
.PP
By default,
.B ccmakedep
places its output in the file named
.I makefile
if it exists, otherwise
.I Makefile.
An alternate makefile may be specified with the
.B \-f
option.
It first searches the makefile for a line beginning with
.sp
\&    # DO NOT DELETE
.sp
or one provided with the
.B \-s
option, as a delimiter for the dependency output.
If it finds it, it will delete everything following this up to the end of
the makefile and put the output after this line.
If it doesn't find it, the program will append the string to the makefile
and place the output after that.
.SH EXAMPLE
Normally,
.B ccmakedep
will be used in a makefile target so that typing 'make depend' will bring
the dependencies up to date for the makefile.
For example,
.nf
    SRCS\0=\0file1.c\0file2.c\0.\|.\|.
    CFLAGS\0=\0\-O\0\-DHACK\0\-I\^.\^.\^/foobar\0\-xyz
    depend:
            ccmakedep\0\-\^\-\0$(CFLAGS)\0\-\^\-\0$(SRCS)
.fi
.SH OPTIONS
The program will ignore any option that it does not understand, so you may
use the same arguments that you would for
.BR cc (1),
including
.B \-D
and
.B \-U
options to define and undefine symbols and
.B \-I
to set the include path.
.TP
.B \-a
Append the dependencies to the file instead of replacing existing
dependencies.
.TP
.BI \-cc compiler
Use this compiler to generate dependencies.
.TP
.BI \-f makefile
Filename.
This allows you to specify an alternate makefile in which
.B ccmakedep
can place its output.
Specifying \(lq\-\(rq as the file name (that is,
.BR \-f\- )
sends the output to standard output instead of modifying an existing file.
.TP
.BI \-s string
Starting string delimiter.
This option permits you to specify a different string for
.B ccmakedep
to look for in the makefile.
The default is \(lq# DO NOT DELETE\(rq.
.TP
.BI \-v
Be verbose: display the C compiler command before running it.
.TP
.BI \-\^\- " options " \-\^\-
If
.B ccmakedep
encounters a double hyphen (\-\^\-) in the argument list, then any
unrecognized arguments following it will be silently ignored.
A second double hyphen terminates this special treatment.
In this way,
.B ccmakedep
can be made to safely ignore esoteric compiler arguments that might
normally be found in a CFLAGS
.B make
macro (see the
.B EXAMPLE
section above).
.BR \-D ,
.BR \-I ,
and
.B \-U
options appearing between the pair of double hyphens are still processed
normally.
.SH "SEE ALSO"
.BR cc (1),
.BR make (1),
.BR makedepend (1),
.BR ccmakedep (1).
.SH AUTHOR
.B ccmakedep
was written by the X Consortium.
.PP
Colin Watson wrote this manual page, originally for the Debian Project,
based partly on the manual page for
.BR makedepend (1).
