/*
 *      SCCS:  @(#)  TestL.c Rel 1.1	    (11/28/91)
 *
 *	UniSoft Ltd., London, England
 *
 * (C) Copyright 1991 X/Open Company Limited
 *
 * All rights reserved.  No part of this source code may be reproduced,
 * stored in a retrieval system, or transmitted, in any form or by any
 * means, electronic, mechanical, photocopying, recording or otherwise,
 * except as stated in the end-user licence agreement, without the prior
 * permission of the copyright owners.
 *
 * X/Open and the 'X' symbol are trademarks of X/Open Company Limited in
 * the UK and other countries.
 */

#include        <stdlib.h>
#include        "xtest.h"
#include        "Xlib.h"
#include        "Xutil.h"
#include        "Xresource.h"
#include        "tet_api.h"
#include        "xtestlib.h"
#include        "pixval.h"

extern char	*TestName;

static int
test(symbol, str)
KeySym	symbol;
char	*str;
{
KeySym	rsym;

	rsym = XStringToKeysym(str);

	if(rsym == NoSymbol) {
		report("XStringToKeysym() returned NoSymbol for string \"%s\".", str);
		return(0);
	}

	if(rsym != symbol) {
		report("XStringToKeysym() returned KeySym 0x%lx instead of 0x%lx.", (long) rsym, (long) symbol);
		return(0);
	}
	return(1);
}

static void
reporterr(s)
char	*s;
{
	report("Symbol \"%s\" is not defined.", s);
}
#define XK_APL
#include	<X11/keysymdef.h>
#undef XK_APL

strtsymL()
{ 
int 	pass = 0, fail = 0;
char	*symstr;
KeySym	rsym;


#ifdef XK_leftcaret
	if(test(XK_leftcaret, "leftcaret") == 1)
		CHECK;
	else
		FAIL;
#else
	reporterr("XK_leftcaret");
	FAIL;
#endif

#ifdef XK_rightcaret
	if(test(XK_rightcaret, "rightcaret") == 1)
		CHECK;
	else
		FAIL;
#else
	reporterr("XK_rightcaret");
	FAIL;
#endif

#ifdef XK_downcaret
	if(test(XK_downcaret, "downcaret") == 1)
		CHECK;
	else
		FAIL;
#else
	reporterr("XK_downcaret");
	FAIL;
#endif

#ifdef XK_upcaret
	if(test(XK_upcaret, "upcaret") == 1)
		CHECK;
	else
		FAIL;
#else
	reporterr("XK_upcaret");
	FAIL;
#endif

#ifdef XK_overbar
	if(test(XK_overbar, "overbar") == 1)
		CHECK;
	else
		FAIL;
#else
	reporterr("XK_overbar");
	FAIL;
#endif

#ifdef XK_downtack
	if(test(XK_downtack, "downtack") == 1)
		CHECK;
	else
		FAIL;
#else
	reporterr("XK_downtack");
	FAIL;
#endif

#ifdef XK_upshoe
	if(test(XK_upshoe, "upshoe") == 1)
		CHECK;
	else
		FAIL;
#else
	reporterr("XK_upshoe");
	FAIL;
#endif

#ifdef XK_downstile
	if(test(XK_downstile, "downstile") == 1)
		CHECK;
	else
		FAIL;
#else
	reporterr("XK_downstile");
	FAIL;
#endif

#ifdef XK_underbar
	if(test(XK_underbar, "underbar") == 1)
		CHECK;
	else
		FAIL;
#else
	reporterr("XK_underbar");
	FAIL;
#endif

#ifdef XK_jot
	if(test(XK_jot, "jot") == 1)
		CHECK;
	else
		FAIL;
#else
	reporterr("XK_jot");
	FAIL;
#endif

#ifdef XK_quad
	if(test(XK_quad, "quad") == 1)
		CHECK;
	else
		FAIL;
#else
	reporterr("XK_quad");
	FAIL;
#endif

#ifdef XK_uptack
	if(test(XK_uptack, "uptack") == 1)
		CHECK;
	else
		FAIL;
#else
	reporterr("XK_uptack");
	FAIL;
#endif

#ifdef XK_circle
	if(test(XK_circle, "circle") == 1)
		CHECK;
	else
		FAIL;
#else
	reporterr("XK_circle");
	FAIL;
#endif

#ifdef XK_upstile
	if(test(XK_upstile, "upstile") == 1)
		CHECK;
	else
		FAIL;
#else
	reporterr("XK_upstile");
	FAIL;
#endif

#ifdef XK_downshoe
	if(test(XK_downshoe, "downshoe") == 1)
		CHECK;
	else
		FAIL;
#else
	reporterr("XK_downshoe");
	FAIL;
#endif

#ifdef XK_rightshoe
	if(test(XK_rightshoe, "rightshoe") == 1)
		CHECK;
	else
		FAIL;
#else
	reporterr("XK_rightshoe");
	FAIL;
#endif

#ifdef XK_leftshoe
	if(test(XK_leftshoe, "leftshoe") == 1)
		CHECK;
	else
		FAIL;
#else
	reporterr("XK_leftshoe");
	FAIL;
#endif

#ifdef XK_lefttack
	if(test(XK_lefttack, "lefttack") == 1)
		CHECK;
	else
		FAIL;
#else
	reporterr("XK_lefttack");
	FAIL;
#endif

#ifdef XK_righttack
	if(test(XK_righttack, "righttack") == 1)
		CHECK;
	else
		FAIL;
#else
	reporterr("XK_righttack");
	FAIL;
#endif

	CHECKPASS(19);
}
