/*
 *      SCCS:  @(#)  TestL.c Rel 1.1	    (11/28/91)
 *
 *	UniSoft Ltd., London, England
 *
 * (C) Copyright 1991 X/Open Company Limited
 *
 * All rights reserved.  No part of this source code may be reproduced,
 * stored in a retrieval system, or transmitted, in any form or by any
 * means, electronic, mechanical, photocopying, recording or otherwise,
 * except as stated in the end-user licence agreement, without the prior
 * permission of the copyright owners.
 *
 * X/Open and the 'X' symbol are trademarks of X/Open Company Limited in
 * the UK and other countries.
 */

#include        <stdlib.h>
#include        "xtest.h"
#include        "Xlib.h"
#include        "Xutil.h"
#include        "Xresource.h"
#include        "tet_api.h"
#include        "xtestlib.h"
#include        "pixval.h"

extern char	*TestName;

static int
test(name, val, aval)
char	*name;
int	val;
int	aval;
{

	if(val != aval) {
		report("KeySym \"%s\" is defined to have value 0x%x instead of 0x%x.", name, val, aval);
		return(0);
	} 
	return(1);
}



static void
reporterr(s)
char	*s;
{
	report("Keysym \"%s\" is not defined.", s);
}

#define XK_APL
#include	<X11/keysymdef.h>
#undef XK_APL

kysymdf10()
{ 
int 	pass = 0, fail = 0;
#ifdef XK_leftcaret
	if(test("XK_leftcaret", XK_leftcaret, 0xBA3) == 0)
		FAIL;
	else
		CHECK;
#else
	reporterr("XK_leftcaret");
	FAIL;
#endif

#ifdef XK_rightcaret
	if(test("XK_rightcaret", XK_rightcaret, 0xBA6) == 0)
		FAIL;
	else
		CHECK;
#else
	reporterr("XK_rightcaret");
	FAIL;
#endif

#ifdef XK_downcaret
	if(test("XK_downcaret", XK_downcaret, 0xBA8) == 0)
		FAIL;
	else
		CHECK;
#else
	reporterr("XK_downcaret");
	FAIL;
#endif

#ifdef XK_upcaret
	if(test("XK_upcaret", XK_upcaret, 0xBA9) == 0)
		FAIL;
	else
		CHECK;
#else
	reporterr("XK_upcaret");
	FAIL;
#endif

#ifdef XK_overbar
	if(test("XK_overbar", XK_overbar, 0xBC0) == 0)
		FAIL;
	else
		CHECK;
#else
	reporterr("XK_overbar");
	FAIL;
#endif

#ifdef XK_downtack
	if(test("XK_downtack", XK_downtack, 0xBC2) == 0)
		FAIL;
	else
		CHECK;
#else
	reporterr("XK_downtack");
	FAIL;
#endif

#ifdef XK_upshoe
	if(test("XK_upshoe", XK_upshoe, 0xBC3) == 0)
		FAIL;
	else
		CHECK;
#else
	reporterr("XK_upshoe");
	FAIL;
#endif

#ifdef XK_downstile
	if(test("XK_downstile", XK_downstile, 0xBC4) == 0)
		FAIL;
	else
		CHECK;
#else
	reporterr("XK_downstile");
	FAIL;
#endif

#ifdef XK_underbar
	if(test("XK_underbar", XK_underbar, 0xBC6) == 0)
		FAIL;
	else
		CHECK;
#else
	reporterr("XK_underbar");
	FAIL;
#endif

#ifdef XK_jot
	if(test("XK_jot", XK_jot, 0xBCA) == 0)
		FAIL;
	else
		CHECK;
#else
	reporterr("XK_jot");
	FAIL;
#endif

#ifdef XK_quad
	if(test("XK_quad", XK_quad, 0xBCC) == 0)
		FAIL;
	else
		CHECK;
#else
	reporterr("XK_quad");
	FAIL;
#endif

#ifdef XK_uptack
	if(test("XK_uptack", XK_uptack, 0xBCE) == 0)
		FAIL;
	else
		CHECK;
#else
	reporterr("XK_uptack");
	FAIL;
#endif

#ifdef XK_circle
	if(test("XK_circle", XK_circle, 0xBCF) == 0)
		FAIL;
	else
		CHECK;
#else
	reporterr("XK_circle");
	FAIL;
#endif

#ifdef XK_upstile
	if(test("XK_upstile", XK_upstile, 0xBD3) == 0)
		FAIL;
	else
		CHECK;
#else
	reporterr("XK_upstile");
	FAIL;
#endif

#ifdef XK_downshoe
	if(test("XK_downshoe", XK_downshoe, 0xBD6) == 0)
		FAIL;
	else
		CHECK;
#else
	reporterr("XK_downshoe");
	FAIL;
#endif

#ifdef XK_rightshoe
	if(test("XK_rightshoe", XK_rightshoe, 0xBD8) == 0)
		FAIL;
	else
		CHECK;
#else
	reporterr("XK_rightshoe");
	FAIL;
#endif

#ifdef XK_leftshoe
	if(test("XK_leftshoe", XK_leftshoe, 0xBDA) == 0)
		FAIL;
	else
		CHECK;
#else
	reporterr("XK_leftshoe");
	FAIL;
#endif

#ifdef XK_lefttack
	if(test("XK_lefttack", XK_lefttack, 0xBDC) == 0)
		FAIL;
	else
		CHECK;
#else
	reporterr("XK_lefttack");
	FAIL;
#endif

#ifdef XK_righttack
	if(test("XK_righttack", XK_righttack, 0xBFC) == 0)
		FAIL;
	else
		CHECK;
#else
	reporterr("XK_righttack");
	FAIL;
#endif


	CHECKPASS(19);
}
