.\" Copyright \(co 1985, 1986, 1987, 1988, 1989, 1990, 1991, 1994, 1996 X Consortium
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining
.\" a copy of this software and associated documentation files (the
.\" "Software"), to deal in the Software without restriction, including
.\" without limitation the rights to use, copy, modify, merge, publish,
.\" distribute, sublicense, and/or sell copies of the Software, and to
.\" permit persons to whom the Software is furnished to do so, subject to
.\" the following conditions:
.\"
.\" The above copyright notice and this permission notice shall be included
.\" in all copies or substantial portions of the Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
.\" OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
.\" IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
.\" OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
.\" ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
.\" OTHER DEALINGS IN THE SOFTWARE.
.\"
.\" Except as contained in this notice, the name of the X Consortium shall
.\" not be used in advertising or otherwise to promote the sale, use or
.\" other dealings in this Software without prior written authorization
.\" from the X Consortium.
.\"
.\" Copyright \(co 1985, 1986, 1987, 1988, 1989, 1990, 1991 by
.\" Digital Equipment Corporation
.\"
.\" Portions Copyright \(co 1990, 1991 by
.\" Tektronix, Inc.
.\"
.\" Permission to use, copy, modify and distribute this documentation for
.\" any purpose and without fee is hereby granted, provided that the above
.\" copyright notice appears in all copies and that both that copyright notice
.\" and this permission notice appear in all copies, and that the names of
.\" Digital and Tektronix not be used in in advertising or publicity pertaining
.\" to this documentation without specific, written prior permission.
.\" Digital and Tektronix makes no representations about the suitability
.\" of this documentation for any purpose.
.\" It is provided ``as is'' without express or implied warranty.
.\" 
.ds xT X Toolkit Intrinsics \- C Language Interface
.ds xW Athena X Widgets \- C Language X Toolkit Interface
.ds xL Xlib \- C Language X Interface
.ds xC Inter-Client Communication Conventions Manual
.na
.de Ds
.nf
.\\$1D \\$2 \\$1
.ft 1
.\".ps \\n(PS
.\".if \\n(VS>=40 .vs \\n(VSu
.\".if \\n(VS<=39 .vs \\n(VSp
..
.de De
.ce 0
.if \\n(BD .DF
.nr BD 0
.in \\n(OIu
.if \\n(TM .ls 2
.sp \\n(DDu
.fi
..
.de FD
.LP
.KS
.TA .5i 3i
.ta .5i 3i
.nf
..
.de FN
.fi
.KE
.LP
..
.de IN		\" send an index entry to the stderr
..
.de C{
.KS
.nf
.D
.\"
.\"	choose appropriate monospace font
.\"	the imagen conditional, 480,
.\"	may be changed to L if LB is too
.\"	heavy for your eyes...
.\"
.ie "\\*(.T"480" .ft L
.el .ie "\\*(.T"300" .ft L
.el .ie "\\*(.T"202" .ft PO
.el .ie "\\*(.T"aps" .ft CW
.el .ft R
.ps \\n(PS
.ie \\n(VS>40 .vs \\n(VSu
.el .vs \\n(VSp
..
.de C}
.DE
.R
..
.de Pn
.ie t \\$1\fB\^\\$2\^\fR\\$3
.el \\$1\fI\^\\$2\^\fP\\$3
..
.de ZN
.ie t \fB\^\\$1\^\fR\\$2
.el \fI\^\\$1\^\fP\\$2
..
.de hN
.ie t <\fB\\$1\fR>\\$2
.el <\fI\\$1\fP>\\$2
..
.de NT
.ne 7
.ds NO Note
.if \\n(.$>$1 .if !'\\$2'C' .ds NO \\$2
.if \\n(.$ .if !'\\$1'C' .ds NO \\$1
.ie n .sp
.el .sp 10p
.TB
.ce
\\*(NO
.ie n .sp
.el .sp 5p
.if '\\$1'C' .ce 99
.if '\\$2'C' .ce 99
.in +5n
.ll -5n
.R
..
.		\" Note End -- doug kraft 3/85
.de NE
.ce 0
.in -5n
.ll +5n
.ie n .sp
.el .sp 10p
..
.ny0
.TH XAddConnectionWatch 3X11 "Release 6.4" "X Version 11" "XLIB FUNCTIONS"
.SH NAME
XAddConnectionWatch, XRemoveConnectionWatch, XProcessInternalConnection, XInternalConnectionNumbers \- handle Xlib internal connections
.SH SYNTAX
typedef void (*XConnectionWatchProc)\^(\^\fIdisplay\fP, \fIclient_data\fP, \fIfd\fP, \fIopening\fP, \fIwatch_data\fP\^)
.br
      Display *\fIdisplay\fP\^;
.br
      XPointer \fIclient_data\fP\^;
.br
      int \fIfd\fP\^;
.br
      Bool \fIopening\fP\^;
.br
      XPointer *\fIwatch_data\fP\^;
.LP
Status XAddConnectionWatch\^(\^\fIdisplay\fP, \fIprocedure\fP\^, \fIclient_data\fP\^)
.br
      Display *\fIdisplay\fP\^;
.br
      XWatchProc \fIprocedure\fP\^;
.br
      XPointer \fIclient_data\fP\^;
.LP
Status XRemoveConnectionWatch\^(\^\fIdisplay\fP, \fIprocedure\fP\^, \fIclient_data\fP\^)
.br
      Display *\fIdisplay\fP\^;
.br
      XWatchProc \fIprocedure\fP\^;
.br
      XPointer \fIclient_data\fP\^;
.LP
void XProcessInternalConnection\^(\^\fIdisplay\fP, \fIfd\fP\^)
.br
      Display *\fIdisplay\fP\^;
.br
      int \fIfd\fP\^;
.LP
void XProcessInternalConnection\^(\^\fIdisplay\fP, \fIfd\fP\^)
.br
      Display *\fIdisplay\fP\^;
.br
      int \fIfd\fP\^;
.LP
Status XInternalConnectionNumbers\^(\^\fIdisplay\fP, \fIfd_return\fP\^, \fIcount_return\fP\^)
.br
      Display *\fIdisplay\fP\^;
.br
      int **\fIfd_return\fP\^;
.br
      int *\fIcount_return\fP\^;
.SH ARGUMENTS
.IP \fIclient_data\fP 1i
Specifies the additional client data.
.ds Cn file descriptors
.IP \fIcount_return\fP 1i
Returns the number of \*(Cn.
.IP \fIdisplay\fP 1i
Specifies the connection to the X server.
.IP \fIfd\fP 1i
Specifies the file descriptor.
.IP \fIfd_return\fP 1i
Returns the file descriptors.
.IP \fIprocedure\fP 1i
Specifies the procedure to be called.
.SH DESCRIPTION
The
.ZN XAddConnectionWatch
function registers a procedure to be called each time Xlib opens or closes an
internal connection for the specified display.  The procedure is passed the
display, the specified client_data, the file descriptor for the connection,
a Boolean indicating whether the connection is being opened or closed, and a
pointer to a location for private watch data.  If opening is
.ZN True ,
the procedure can store a pointer to private data in the location pointed
to by watch_data;
when the procedure is later called for this same connection and opening is
.ZN False ,
the location pointed to by watch_data will hold this same private data pointer.
.LP
This function can be called at any time after a display is opened.
If internal connections already exist, the registered procedure will
immediately be called for each of them, before
.ZN XAddConnectionWatch
returns.
.ZN XAddConnectionWatch
returns a nonzero status if the procedure is successfully registered;
otherwise, it returns zero.
.LP
The registered procedure should not call any Xlib functions.
If the procedure directly or indirectly causes the state of internal
connections or watch procedures to change, the result is not defined.
If Xlib has been initialized for threads, the procedure is called with
the display locked and the result of a call by the procedure to any
Xlib function that locks the display is not defined unless the executing
thread has externally locked the display using
.ZN XLockDisplay .
.LP
The
.ZN XRemoveConnectionWatch
function removes a previously registered connection watch procedure.
The client_data must match the client_data used when the procedure
was initially registered.

.LP
The
.ZN XProcessInternalConnection
function processes input available on an internal connection.
This function should be called for an internal connection only
after an operating system facility (for example,
.ZN select
or
.ZN poll )
has indicated that input is available; otherwise,
the effect is not defined.
.LP
The
.ZN XProcessInternalConnection
function processes input available on an internal connection.
This function should be called for an internal connection only
after an operating system facility (for example,
.ZN select
or
.ZN poll )
has indicated that input is available; otherwise,
the effect is not defined.
.LP
The
.ZN XInternalConnectionNumbers
function returns a list of the file descriptors for all internal
connections currently open for the specified display.
When the allocated list is no longer needed,
free it by using
.ZN XFree .
This functions returns a nonzero status if the list is successfully allocated;
otherwise, it returns zero.
.SH "SEE ALSO"
\fI\*(xL\fP
