'\"! eqn | mmdoc
'\"macro stdmacro
.ds Vn Version 1.2
.ds Dt 6 March 1997
.ds Re Release 1.2.0
.ds Dp Feb 16 02:57
.ds Dm  Feb 10 17:2
.ds Xs 20224 2 xwaitgl.gl
.TH GLXWAITGL
.SH NAME
.B "glXWaitGL
\- complete GL execution prior to subsequent X calls

.SH C SPECIFICATION
void \f3glXWaitGL\fP( void )
.nf
.fi

.EQ
delim $$
.EN
.SH DESCRIPTION
GL rendering calls made prior to \f3glXWaitGL\fP are guaranteed to be
executed before X rendering calls made after \f3glXWaitGL\fP.
Although this same result can be achieved using \f3glFinish\fP,
\f3glXWaitGL\fP does not require a round trip to the server,
and it is therefore more efficient in cases where client and server
are on separate machines.
.P
\f3glXWaitGL\fP is ignored if there is no current GLX context.
.SH NOTES
\f3glXWaitGL\fP may or may not flush the X stream.
.SH ERRORS
\f3GLXBadCurrentWindow\fP is generated if the drawable associated
with the current context of the calling thread is a window, and that
window is no longer valid.
.SH SEE ALSO
\f3glFinish\fP,
\f3glFlush\fP,
\f3glXWaitX\fP,
\f3XSync\fP

