'\"! eqn | mmdoc
'\"macro stdmacro
.ds Vn Version 1.2
.ds Dt 6 March 1997
.ds Re Release 1.2.0
.ds Dp Feb 16 02:56
.ds Dm  Feb 10 17:2
.ds Xs 38402 4 ximportcontextext.gl
.TH GLXIMPORTCONTEXTEXT
.SH NAME
.B "glXImportContextEXT
\- import another process's indirect rendering context.

.SH C SPECIFICATION
GLXContext \f3glXImportContextEXT\fP(
Display \fI*dpy\fP,
.nf
.ta \w'\f3GLXContext \fPglXImportContextEXT( 'u
	GLXContextID \fIcontextID\fP )
.fi

.EQ
delim $$
.EN
.SH PARAMETERS
.TP \w'\fIcontextID\fP\ \ 'u 
\f2dpy\fP
Specifies the connection to the X server.

.TP
\f2contextID\fP
Specifies a GLX rendering context.

.SH DESCRIPTION
\f3glXImportContextEXT\fP creates a GLXContext given the XID of an existing GLXContext.
It may be used in place of \f3glXCreateContext\fP,
to share another process's indirect rendering context.
.P
Only the server-side context information can be shared between
X clients; client-side state, such as pixel storage modes,
cannot be shared. Thus, \f3glXImportContextEXT\fP must allocate memory to store
client-side information. This memory is freed by calling
\f3glXFreeContextEXT\fP.
.P
This call does not create a new XID.  It merely makes an
existing object available to the importing client (Display *).
Like any XID, it goes away when the creating client drops its
connection or the ID is explicitly deleted. Note that this is
when the XID goes away. The object goes away when the XID
goes away AND the context is not current to any thread.
.P
If \f2contextID\fP refers to a
direct rendering context then no error is generated but
\f3glXImportContextEXT\fP returns NULL.
.P
\f3glXImportContextEXT\fP is part of the \f3EXT_import_context\fP extension,
not part of the core GLX command set. If \f3GLX_EXT_import_context\fP
is included in the string returned by \f3glXQueryExtensionsString\fP,
when called with argument \f3GLX_EXTENSIONS\fP,
extension \f3EXT_import_context\fP is supported.

.SH ERRORS
\f3GLXBadContext\fP is generated if \f2contextID\fP does not
refer to a valid context.

.SH SEE ALSO
\f3glXCreateContext\fP,
\f3glXQueryVersion\fP,
\f3glXQueryExtensionsString\fP,
\f3glXGetContextIDEXT\fP,
\f3glXFreeContextEXT\fP
