divert(-1)
# AnotherLevel - A FVWM2 Configuration
# Copyright (C) 1996, 1997 Red Hat Software, Inc
#
#	$Id: fvwm2rc.menus.m4,v 1.11 1999/04/05 18:31:57 notting Exp $	
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
# This work is derived from:
#       TheNextLevel
#       Copyright 1996 By Greg J. Badros <gjb@cs.duke.edu>
# distributed under GNU General Public License.
#
divert

###########################################################################
#
# Now create the menus
#
TraceForErrors(`Basic start menu...')

define(`IfHostsDefined', `
ifdef(`USER_HOST_LIST', $1, ifdef(`AUTO_HOST_MENU', $1))
')

# This is for the Start menu of the FvwmTaskBar
define(`BasicStartMenu',`dnl
+ "&New shell MiniTitleIcon(sh1)"        	Exec  XTERM
+ "&Programs MiniTitleIcon(penguin)"		Popup ROOT_MENU
')

AddToMenu StartMenu "Start MiniTitleIcon(shadowman)" Title
BasicStartMenu

# seek for big applications already on disk...
readFile(`fvwm2rc.apps')

AddToMenu ROOT_MENU "Programs MiniTitleIcon(penguin)" Title

# AUTOMATIC MENU generation - begin
define(`WMCONFIG_1', `')
define(`WMCONFIG_2', `')
ifdef(`MINI_ICONS', `', `define(`WMCONFIG_1', `--no-mini-icons')')
ifdef(`NO_ICONS', `define(`WMCONFIG_2', `--no-icons')')
changecom(%%%)
# wmconfig --output=fvwm2 --rootmenu="ROOT_MENU" WMCONFIG_1 WMCONFIG_2
changecom(#)
esyscmd(wmconfig --output=fvwm2 --rootmenu="ROOT_MENU" WMCONFIG_1 WMCONFIG_2 2>/dev/null)
# AUTOMATIC MENU generation - end

AddToMenu StartMenu
+ "" Nop
IfHostsDefined(`+ "H&osts MiniTitleIcon(windows)"		Popup Hosts')
+ "&System Utilities MiniTitleIcon(connect)"	Popup SystemUtilities
+ "&Preferences MiniTitleIcon(prefs)" 		Popup "Preferences"
+ "&Window Operations MiniTitleIcon(windows)"	Popup Window-Ops
+ "" Nop

readFile(`fvwm2rc.xlock')

AddToMenu StartMenu
+ "A&bout Fvwm MiniTitleIcon(exclam)"		FvwmForm About
+ "" Nop

#ifdef(`BROWSER_HELP_COMMAND',`
#AddToMenu StartMenu "&Help Fvwm MiniTitleIcon(question)" Exec BROWSER_HELP_COMMAND
#+ "" Nop
#')

AddToMenu StartMenu "E&xit Fvwm MiniTitleIcon(stop)"	Popup Quit-Verify

AddToMenu "Quit-Verify" "Really Quit Fvwm?" Title
+ "&Restart MiniTitleIcon(turn)"		Restart FVWM_BIN_NAME
+ ""						Nop
+ "&Switch To... MiniTitleIcon(windows)"	Popup WindowManagers
+ ""						Nop
+ "&No, Don't Quit MiniTitleIcon(cross)" 	Nop
+ "&Yes, Really Quit MiniTitleIcon(exclam)"	ifdef(`NO_VERIFY_QUIT',`Quit',`FvwmForm LogoutVerify')


AddToMenu ScrollPreferences "Change Scroll Behavior" Title
+ "&On"    		EdgeScroll 100 100
+ "O&ff"   		EdgeScroll 0 0
+ "&Horizontal Only"    EdgeScroll 100 0
+ "&Vertical Only"      EdgeScroll 0 100
+ "&Partial"        	EdgeScroll 50 50

AddToMenu Colours  "Color Settings" Title
+ "Color &Map"       Exec xcmap
+ "&Reset Color Map" Exec xstdcmap -default


AddToFunc SetRootCursor "I" Exec xsetroot -cursor_name $0


AddToMenu RootCursor "Set Root Cursor" Title
+ "&Reset to X_cursor" SetRootCursor X_cursor
+ "&Miscellany" Popup MiscellanyCursors
+ "&Arrows" Popup ArrowCursors
+ "Cor&ners" Popup CornersCursors
+ "&Crosses" Popup CrossesCursors
+ "&Objects" Popup ObjectsCursors

#AddCursorToMenu($1=Menu,$2=Cursor)
define(`AddCursorToMenu',`
AddToMenu $1 "$2" SetRootCursor $2')

foreach(`x',
`(arrow,based_arrow_down,based_arrow_up,double_arrow,question_arrow,sb_down_arrow,sb_h_double_arrow,sb_left_arrow,sb_right_arrow,sb_up_arrow,sb_v_double_arrow,top_left_arrow)',
`AddCursorToMenu(ArrowCursors,x)')

foreach(`x',
`(top_left_corner,top_side,top_right_corner,left_side,right_side,bottom_left_corner,bottom_side,bottom_right_corner)',
`AddCursorToMenu(CornersCursors,x)')

foreach(`x',
`(X_cursor,cross,cross_reverse,crosshair,diamond_cross,iron_cross,tcross)',
`AddCursorToMenu(CrossesCursors,x)')

foreach(`x',
`(boat,bogosity,box_spiral,circle,clock,coffee_mug,dot,dotbox,draft_large,draft_small,draped_box,exchange,fleur,gobbler,gumby,hand1,hand2,heart,icon,man,mouse,num_glyphs,pencil,pirate,plus,rtl_logo,sailboat,shuttle,spider,spraycan,star,target,trek,umbrella,watch)',
`AddCursorToMenu(ObjectsCursors,x)')

foreach(`x',
`(bottom_tee,left_tee,leftbutton,ll_angle,lr_angle,ul_angle,ur_angle,middlebutton,right_tee,rightbutton,top_tee)',
`AddCursorToMenu(TeesButtonsAnglesCursors,x)')

foreach(`x',
`(center_ptr,left_ptr,right_ptr,sizing,xterm)',
`AddCursorToMenu(MiscellanyCursors,x)')

divert(-1)
#foreach(`x',
#`(X_cursor,arrow,based_arrow_down,based_arrow_up,boat,bogosity,
#bottom_left_corner,bottom_right_corner,bottom_side,bottom_tee,
#box_spiral,center_ptr,circle,clock,coffee_mug,cross,cross_reverse,crosshair,
#diamond_cross,dot,dotbox,double_arrow,draft_large,draft_small,draped_box,
#exchange,fleur,gobbler,gumby,hand1,hand2,heart,icon,iron_cross,left_ptr,
#left_side,left_tee,leftbutton,ll_angle,lr_angle,man,middlebutton,mouse,num_glyphs,
#pencil,pirate,plus,question_arrow,right_ptr,right_side,right_tee,rightbutton,
#rtl_logo,sailboat,sb_down_arrow,sb_h_double_arrow,sb_left_arrow,sb_right_arrow,
#sb_up_arrow,sb_v_double_arrow,shuttle,sizing,spider,spraycan,star,target,tcross,
#top_left_arrow,top_left_corner,top_right_corner,top_side,top_tee,trek,ul_angle,
#umbrella,ur_angle,watch,xterm)',
#`AddCursorToMenu(AllCursorsMenu,x)')
divert

AddToFunc Speed "I" Exec xset m $0

AddToMenu MouseSettings "Mouse Settings" Title
+ "&1 Ultra Fastest" 	Speed "20 5"
+ "&2 Next Fastest"  	Speed "15 6"
+ "&3 Faster"	  	Speed "10 7"
+ "&4 Fast"	  	Speed "7 8"
+ "&5 Normal"	  	Speed "5 10"
+ "&6 Slower"	  	Speed "default"
+ "&N No acceleration"  Speed "0 10000"
+ "" Nop
+ "&Right Handed (1 2 3)" Exec xmodmap -e "pointer = 1 2 3"
+ "&Left Handed (3 2 1)" Exec xmodmap -e "pointer = 3 2 1"

AddToFunc AutoRaiseSpeed 
+ "I" KillModule FvwmAuto
+ "I" FvwmAuto $0

define(`AddAutoRaiseSpeed',`+ "&$1 ms" Function AutoRaiseSpeed $1
')

AddToMenu AutoRaiseMenu "AutoRaise" Title
+ "O&ff" KillModule FvwmAuto
+ "" Nop

foreach(x,`(0,200,400,500,1000,3000)',`AddAutoRaiseSpeed(x)')

AddToMenu AudioSettings "Audio Settings" Title
+ "&On" Module FvwmAudio
+ "O&ff" KillModule FvwmAudio
#+ "Event mapping" FvwmForm AudioEvents

AddToMenu XResources "X Resources" Title
+ "&Load .Xdefaults" Exec xrdb -load .Xdefaults
+ "&Merge .Xdefaults" Exec xrdb -merge .Xdefaults
+ "L&oad .Xresources" Exec xrdb -load .Xresources
+ "M&erge .Xresources" Exec xrdb -merge .Xresources
+ "" Nop
+ "&Display current settings" Exec StartNonInteractiveProgramInRxvt(`xrdb -query',XResources)


TraceForErrors(`Preferences menu...')

AddToFunc Wharf
+ "I"	KillModule FvwmButtons
+ "I"	KillModule FvwmPager
+ "I"	Module FvwmWharf

AddNewMenuAndButtonBar(Preferences)

# MenuAndButtonEntryLM(&FvwmConfig,hammer,hammer_3d,Module FvwmConfig)
MenuAndButtonEntryLM(&Background,colors,colors,FvwmScript ScreenSetup)
MenuAndButtonEntryLM(&Root Cursor,cross,,Popup RootCursor)
MenuAndButtonEntryLM(&Mouse,mouse,,Popup MouseSettings)
MenuAndButtonEntryLM(&Colours,colors,,Popup Colours)
# MenuAndButtonEntryLM(A&udio,audiovol,Multimedia3,Popup AudioSettings)
MenuAndButtonEntryLM(&AutoRaise,raise,hand_up_3d,Popup AutoRaiseMenu)
MenuAndButtonEntryLM(&Scroll Setup,scroll-arrows,,Popup ScrollPreferences)
MenuAndButtonEntryLM(&X Resources,x2,,Popup XResources)
IfProgramExists(`xkeycaps',`
MenuAndButtonEntryLM(&Keyboard layout,keys,,Exec xkeycaps)
')
MenuAndButtonEntryLM(Save &Desktop to new.xinitrc,floppy,disk_3d,Module FvwmSave)

AddNewMenuAndButtonBar(SystemUtilities)
DefineProgramLM(&Root shell,shadowman-64,,StartProgramInColorXterm(sh -c su,Root_Window))
ifdef(`MESSAGE_LOG',`
MenuAndButtonEntryLM(&Msgs,doc,,Exec nice NICELEVEL RXVT -geometry 80x8+520-2 -T Msgs -fn SMALL_FONT -e nice NICELEVEL tail -8 -f MESSAGE_LOG)
')
MenuAndButtonEntryLM(T&op,run,,Exec RXVT -name top -T Top -n Top -e top)
MenuAndButtonEntryLM(&Identify Window,question,question,Module FvwmIdent)
DefineProgramLM(&Window Info,windows,,StartNonInteractiveProgramInRxvt(`xwininfo',WindowInfo))
MenuAndButtonEntryLM(&Talk Module,talk,,Module FvwmTalk)
MenuAndButtonEntryLM(&Pager Module,pager,pages_3d,Module FvwmPager 0 1)
MenuAndButtonEntryLM(Task &Bar,exp,,Module FvwmTaskBar)
MenuAndButtonEntryLM(W&harf,pager,pages_3, Function Wharf)
MenuSeparatorLM
MenuAndButtonEntryLM(Fvwm &Command,talk,,FvwmForm TalkForm)
MenuAndButtonEntryLM(Reread .&Xdefaults,exclam,,Exec xrdb -merge .Xdefaults)
MenuAndButtonEntryLM(Restart &Fvwm2,turn,,Restart fvwm2)
MenuSeparatorLM
MenuAndButtonEntryLM(Re&fresh Screen,ray,,Refresh)
MenuAndButtonEntryLM(Re&capture All Windows,recapture,,Recapture)

TraceForErrors(`Window-Ops menu...')

#
# This defines the most common window operations
#
AddNewMenuAndButtonBar(`Window-Ops')
# Shortcuts: MRAL H/I SXTW DCK BPWUL F
MenuAndButtonEntryLM(&Move,move,icon_move_3d,Function Move-and-Raise)
MenuAndButtonEntryLM(&Resize,resize,,Function Resize-or-Raise)
MenuAndButtonEntryLM(R&aise,raise,hand_up_3d,Raise)
MenuAndButtonEntryLM(&Lower,lower,arrdown_3d,Lower)
MenuAndButtonEntryLM(&ICONIFY_LABEL/Restore,iconify,arrdown2_3d,Iconify)
MenuAndButtonEntryLM(&Stick/Unstick,stick,,Stick)
MenuAndButtonEntryLM(Ma&ximize/Reset,,,FullMaximize)
MenuAndButtonEntryLM(Maximize &Tall/Reset,maxtall,,TallMaximize)
MenuAndButtonEntryLM(Maximize &Wide/Reset,maxwide,,WideMaximize)
MenuSeparatorLM
MenuAndButtonEntryLM(Cascad&e,,,FvwmCascade -resize 0 0 80 60)
MenuAndButtonEntryLM(Tile Hori&zontal,,,FvwmTile -h 0 0 99 90)
MenuAndButtonEntryLM(Tile &Vertical,,,FvwmTile 0 0 99 90)
MenuSeparatorLM
MenuAndButtonEntryLM(&Delete,,,Delete)
MenuAndButtonEntryLM(&Close,cross,,Close)
MenuAndButtonEntryLM(&Kill,bomb,bomb_3d,Destroy)
MenuSeparatorLM
MenuAndButtonEntryLM(Scroll&Bar,scroll-arrows,,Module FvwmScroll 2 2)
IfProgramExists(ProgramName(PRINT_FUNCTION),`
MenuAndButtonEntryLM(&Print,,,PrintFunction)
')
MenuAndButtonEntryLM(Capture &Windows,,,FvwmForm Capture)
MenuAndButtonEntryLM(Clean-&Up Module,pencil,pencil2_3d,Module FvwmClean)
MenuAndButtonEntryLM(Window &List Module,windows,window3d,Module FvwmWinList)
MenuSeparatorLM
MenuAndButtonEntryLM(Switch to...,,,WindowList)
MenuAndButtonEntryLM(Re&fresh Screen,ray,,Refresh)

# Shortcuts: H/I MSNXCK 
AddToMenu "Window-Ops-Basic" 
+ "&Move MiniTitleIcon(move)"	Move-or-Raise
+ "&Size MiniTitleIcon(resize)" Resize-or-Raise
+ "Mi&nimize MiniTitleIcon(iconify)" Iconify 1
+ "Ma&ximize"       		FullMaximize
+ ""                		Nop
+ "&Close MiniTitleIcon(cross)"	Close
+ "&Kill MiniTitleIcon(bomb)" 	Destroy

TraceForErrors(`Including_fvwm_hostmenus...')
# .fvwm2rc.hostmenus sets up the various menus for working w/ hosts
readFile(`fvwm2rc.hostmenus')

