divert(-1)
# AnotherLevel - A FVWM2 Configuration
# Copyright (C) 1996, 1997 Red Hat Software, Inc
#
#	$Id: fvwm2rc.keys.m4,v 1.1 1998/04/22 04:22:32 gafton Exp $	
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
# This work is derived from:
#       TheNextLevel
#       Copyright 1996 By Greg J. Badros <gjb@cs.duke.edu>
# distributed under GNU General Public License.
#
divert

###########################################################################
# Now some keyboard shortcuts.
# Contexts mean:
#     R = Root Window                 rrrrrrrrrrrrrrrrrrrrrr
#     W = Application Window          rIrrrrFSSSSSSSSSFrrrrr
#     F = Frame Corners               rrrrrrS13TTTT642Srrrrr
#     S = Frame Sides                 rIrrrrSWWWWWWWWWSrrrrr
#     T = Title Bar                   rrrrrrSWWWWWWWWWSrrrrr
#     I = Icon                        rIrrrrFSSSSSSSSSFrrrrr
#                                     rrrrrrrrrrrrrrrrrrrrrr
# Numbers are buttons, odd on left, even on right:  1 3 5      6 4 2
#
# Modifiers: (A)ny (C)ontrol (S)hift (M)eta

# press arrow in the root window, and move the pointer to other virtual wins
Key Left	R	N	CursorMove -5 +0
Key Right	R	N	CursorMove +5 +0
Key Up		R	N	CursorMove +0 -5
Key Down	R	N	CursorMove +0 +5

# Arrow Keys
# press arrow + control SHIFT meta anywhere, and scroll by 1 page
Key Left	A	CSM	Scroll -100 0
Key Right	A	CSM	Scroll +100 +0
Key Up		A	CSM	Scroll +0   -100
Key Down	A	CSM	Scroll +0   +100

# Keypad Arrow keys, scroll by 10% of page
Key KP_4	A	CSM	Scroll -10 0
Key KP_6	A	CSM	Scroll +10 0
Key KP_8	A	CSM	Scroll 0 -10
Key KP_2	A	CSM	Scroll 0 +10

# Keyboard accelerators
Key F1		A	CS	Popup "Window-Ops"
Key F2		A	CS	WindowList
Key F3		A	CS	Popup "Hosts"
Key F4		A	CS	Popup "Applications"
Key F5		A	CS	Popup "Utilities"
Key F6		A	CS	Popup "Multimedia"
Key F7		A	CS	Move
Key F8		A	CS	Resize
Key Tab		A	M	Next [CurrentScreen *] Focus
Key Tab		A	SM	Prev [CurrentScreen *] Focus
Key Escape	A	M	WindowList
Key Up		A	CS	TallMaximize
Key Right	A	CS	WideMaximize
Key Return	A	CM	RaiseLower
Key Return	A	CS	WindowListIcons
Key Down	A	CS	Iconify
Key Home	A	CSM	Desk 0 0
Key End		A	CSM	Desk 0 1
Key BackSpace	A	CSM	Delete
Key KP_Decimal  A	CSM	Destroy
Key Escape	A	CSM	FvwmForm LogoutVerify
Key z		A	CSM	Popup "RootStart"
Key x		A	CSM	Function StartXterm
Key s		WT	CSM	Function Raise-and-Stick
Key a		A	CSM	Popup "Applications"
Key p		A	CSM	Popup "Preferences"
Key w		A	CSM	Popup "Window-Ops"
Key g		A	CSM	Popup "Games"
Key r 		A	CSM	Refresh

# Do mouse movements with keys, so you never have to touch the mouse!
# Great if you don't have one, or are just switching between neighboring
# windows, or don't have far to go
#eg. KeyMouseMoves F9 F10 F11 F12 SM 1
#                  L  D   U   R   Mods Amount
#                  0   1   2   3   4    5
AddToFunc "KeyMouseMoves" 
+ "I" Key $0 A $4 CursorMove  -$5   0
+ "I" Key $1 A $4 CursorMove    0  $5
+ "I" Key $2 A $4 CursorMove    0 -$5
+ "I" Key $3 A $4 CursorMove   $5   0

#Let the FKeys do this, with vi-like bindings
# You may want to comment this out if you prefer
# emacs or other fvwm bindings for Ctrl-Shift &/or Shift-Meta + F9-F12
Function KeyMouseMoves F9 F10 F11 F12 CS 1
Function KeyMouseMoves F9 F10 F11 F12 SM 7

# May want to extend this for left-handed users

# These KeyMouseMoves are closer to where your hands'll be
ifdef(`NOT_VI_KEYS',`
#for people who dont use VI, these make more sense, in inverted T configuration
KeyMouseMoves j k i l CSM 10
',`
#but VI people get two degrees of motion, if they
#dont mind moving off the home row temporarily
KeyMouseMoves h j k l CSM 10
KeyMouseMoves y u i o CSM 1
')

# You may want to use xev to check these keycodes and use xmodmap
# to make sure the keysyms are what are below-- I don't
# have a win95 compatible keyboard to try this on
ifdef(`Win95Keys',`
# Supplementary Keys of The Microsoft Keyboard
Key F16		A	M	Next [CurrentScreen *xterm] focus
Key F17		A	M 	Prev [CurrentScreen *xterm] focus
Key F18		A	M 	Popup "StartMenu"
',`
Key Tab		A	CM	Next [CurrentScreen *xterm] focus
Key Tab		A	CSM	Prev [CurrentScreen *xterm] focus
')
