'\"! eqn | mmdoc
'\"macro stdmacro
.ds Vn Version 1.2
.ds Dt 6 March 1997
.ds Re Release 1.2.0
.ds Dp Feb 16 02:56
.ds Dm  Feb 10 17:2
.ds Xs 32008 15 xintro.gl
.TH GLXINTRO
.SH NAME
.B "glXIntro
\- Introduction to OpenGL in the X window system

.SH OVERVIEW
OpenGL (called GL in other pages) is a high-performance 3D-oriented renderer.
It is available in the X window system through the GLX extension.
To determine whether the GLX extension is supported by an X server,
and if so, what version is supported, call \f3glXQueryExtension\fP
and \f3glXQueryVersion\fP.
.P
GLX extended servers make a subset of their visuals available
for OpenGL rendering.
Drawables created with these visuals can also be rendered using
the core X renderer
and with the renderer of any other X extension that is compatible
with all core X visuals.
.P
GLX extends drawables with several buffers other than
the standard color buffer.
These buffers include back and auxiliary color buffers,
a depth buffer,
a stencil buffer,
and a color accumulation buffer.
Some or all are included in each X visual that supports OpenGL.
.P
To render using OpenGL into an X drawable,
you must first choose a visual that defines the required OpenGL buffers.
\f3glXChooseVisual\fP can be used to simplify selecting a compatible visual.
If more control of the selection process is required,
use \f3XGetVisualInfo\fP and \f3glXGetConfig\fP to select among
all the available visuals.
.P
Use the selected visual to create both a GLX context and an X
drawable.
GLX contexts are created with \f3glXCreateContext\fP,
and drawables are created with either \f3XCreateWindow\fP or
\f3glXCreateGLXPixmap\fP.
Finally,
bind the context and the drawable together using \f3glXMakeCurrent\fP.
This context/drawable pair becomes the current context and current
drawable,
and it is used by all OpenGL commands until \f3glXMakeCurrent\fP is
called with different arguments.
.P
Both core X and OpenGL commands can be used to operate on the
current drawable.
The X and OpenGL command streams are not synchronized,
however,
except at explicitly created boundaries generated by calling
\f3glXWaitGL\fP, \f3glXWaitX\fP, \f3XSync\fP, and \f3glFlush\fP.
.SH EXAMPLES
Below is the minimum code required to create an RGBA-format,
X window that's compatible with OpenGL and to clear it to yellow.
The code is correct,
but it does not include any error checking.
Return values \f2dpy\fP,
\f2vi\fP,
\f2cx\fP,
\f2cmap\fP, and
\f2win\fP should all be tested.
.P
.Ex
#include <GL/glx.h>
#include <GL/gl.h>
#include <unistd.h>

static int attributeListSgl[] = { 
	GLX_RGBA, 
	GLX_RED_SIZE,   1, /*get the deepest buffer with 1 red bit*/
	GLX_GREEN_SIZE, 1, 
	GLX_BLUE_SIZE,  1, 
	None };

static int attributeListDbl[] = { 
	GLX_RGBA, 
	GLX_DOUBLE_BUFFER, /*In case single buffering is not supported*/
	GLX_RED_SIZE,   1, 
	GLX_GREEN_SIZE, 1, 
	GLX_BLUE_SIZE,  1, 
	None };


static Bool WaitForNotify(Display *d, XEvent *e, char *arg) {
    return (e->type == MapNotify) && (e->xmap.window == (Window)arg);
}

int main(int argc, char **argv) {
    Display *dpy;
    XVisualInfo *vi;
    Colormap cmap;
    XSetWindowAttributes swa;
    Window win;
    GLXContext cx;
    XEvent event;
    int swap_flag = FALSE;


    /* get a connection */
    dpy = XOpenDisplay(0);

    /* get an appropriate visual */
    vi = glXChooseVisual(dpy, DefaultScreen(dpy), attributeListSgl);
    if (vi == NULL) {
       vi = glXChooseVisual(dpy, DefaultScreen(dpy), attributeListDbl);
       swap_flag = TRUE;
    }

    /* create a GLX context */
    cx = glXCreateContext(dpy, vi, 0, GL_TRUE);

    /* create a color map */
    cmap = XCreateColormap(dpy, RootWindow(dpy, vi->screen),
			   vi->visual, AllocNone);

    /* create a window */
    swa.colormap = cmap;
    swa.border_pixel = 0;
    swa.event_mask = StructureNotifyMask;
    win = XCreateWindow(dpy, RootWindow(dpy, vi->screen), 0, 0, 100, 100,
                        0, vi->depth, InputOutput, vi->visual,
                        CWBorderPixel|CWColormap|CWEventMask, &swa);
    XMapWindow(dpy, win);
    XIfEvent(dpy, &event, WaitForNotify, (char*)win);

    /* connect the context to the window */
    glXMakeCurrent(dpy, win, cx);

    /* clear the buffer */
    glClearColor(1,1,0,1);
    glClear(GL_COLOR_BUFFER_BIT);
    glFlush();
    if (swap_flag) glXSwapBuffers(dpy,win);

    /* wait a while */
    sleep(10);
}
.Ee
.SH NOTES
A color map must be created and passed to \f3XCreateWindow\fP.
See the preceding example code.
.P
A GLX context must be created and attached to an X drawable before
OpenGL commands can be executed.
OpenGL commands issued while no context/drawable pair is current
result in undefined behavior.
.P
Exposure events indicate that \f2all\fP buffers associated with the
specified window may be damaged and should be repainted.
Although certain buffers of some visuals on some systems
may never require repainting
(the depth buffer, for example),
it is incorrect to write a program assuming that these buffers will
not be damaged.
.P
GLX commands manipulate XVisualInfo structures rather than pointers to
visuals or visual IDs.
XVisualInfo structures contain \f2visual\fP,
\f2visualID\fP,
\f2screen\fP, and
\f2depth\fP elements,
as well as other X-specific information.
.SH USING GLX EXTENSIONS
All supported GLX extensions will have a corresponding definition in glx.h
and a token in the extension string returned by \f3glXQueryExtensionsString\fP.
For example, if the \f3EXT_visual_info\fP extension is supported,
then this token will be defined in glx.h and \f3EXT_visual_info\fP
will appear in the extension 
string returned by \f3glXQueryExtensionsString\fP. The definitions in glx.h
can be used at compile time to determine if procedure calls corresponding
to an extension exist in the library. 
.P
OpenGL itself has also been extended. Refer to \f3glIntro\fP for more
information.
.P
.SH GLX 1.1 and GLX 1.2
GLX 1.2 is now supported. It is backward compatible with GLX 1.1 and
GLX 1.0.
.P
GLX 1.2 corresponds to OpenGL version 1.1 and introduces the following
new call: \f3glGetCurrentDisplay\fP.
.P
GLX 1.1 corresponds to OpenGL version 1.0 and introduces the
following new calls:
\f3glXQueryExtensionsString\fP, \f3glXQueryServerString\fP, and
\f3glXGetClientString\fP.
.P
Call \f3glQueryVersion\fP
to determine at runtime what version of GLX is available. \f3glQueryVersion\fP
returns the version that is supported on the connection. Thus
if 1.2 is returned, both the client and server support GLX 1.2.
You can also check the GLX version at compile time: GLX_VERSION_1_1
will be defined in glx.h if GLX 1.1 calls are supported and
GLX_VERSION_1_2 will be defined if GLX 1.2 calls are supported.
.SH SEE ALSO
\f3glIntro\fP,
\f3glFinish\fP,
\f3glFlush\fP,
\f3glXChooseVisual\fP,
\f3glXCopyContext\fP,
.br
\f3glXCreateContext\fP,
\f3glXCreateGLXPixmap\fP,
\f3glXDestroyContext\fP,
.br
\f3glXGetClientString\fP,
\f3glXGetConfig\fP,
\f3glXIsDirect\fP,
\f3glXMakeCurrent\fP,
.br
\f3glXQueryExtension\fP,
\f3glXQueryExtensionsString\fP,
\f3glXQueryServerString\fP,
\f3glXQueryVersion\fP,
\f3glXSwapBuffers\fP,
\f3glXUseXFont\fP,
\f3glXWaitGL\fP,
\f3glXWaitX\fP,
\f3XCreateColormap\fP,
\f3XCreateWindow\fP,
\f3XSync\fP








