'\"! eqn | mmdoc
'\"macro stdmacro
.ds Vn Version 1.2
.ds Dt 6 March 1997
.ds Re Release 1.2.0
.ds Dp Feb 16 02:56
.ds Dm  Feb 10 17:2
.ds Xs 29851 4 xgetclientstring.gl
.TH GLXGETCLIENTSTRING
.SH NAME
.B "glXGetClientString
\- return a string describing the client

.SH C SPECIFICATION
const char * \f3glXGetClientString\fP(
Display \fI*dpy\fP,
.nf
.ta \w'\f3const char * \fPglXGetClientString( 'u
	int \fIname\fP )
.fi

.EQ
delim $$
.EN
.SH PARAMETERS
.TP \w'\fIname\fP\ \ 'u 
\f2dpy\fP
Specifies the connection to the X server.
.TP
\f2name\fP
Specifies which string is returned.
One of \f3GLX_VENDOR\fP, \f3GLX_VERSION\fP, or \f3GLX_EXTENSIONS\fP.
.SH DESCRIPTION
\f3glXGetClientString\fP returns a string
describing some aspect of the client library. The possible values for \f2name\fP 
are \f3GLX_VENDOR\fP, \f3GLX_VERSION\fP, and
\f3GLX_EXTENSIONS\fP. If \f2name\fP  
is not set to one of these values, \f3glXGetClientString\fP returns \f3NULL\fP. 
The format and contents of the vendor string is implementation dependent.
.P
The extensions string is null-terminated and contains a
space-separated list of  extension names. (The extension names never
contain spaces.)  
If there are no extensions to GLX, then the empty string is returned. 
.P
The version string is laid out as follows:
.sp
<major_version.minor_version><space><vendor-specific info>
.sp
Both the major and minor portions of the version number are of arbitrary 
length.  The vendor-specific information is optional.  However, if it is 
present, the format and contents are implementation specific.
.SH NOTES
\f3glXGetClientString\fP is available only if the GLX version is 1.1 or greater.
.P
If the GLX version is 1.1 or 1.0, the GL version must be 1.0.
If the GLX version is 1.2, then the GL version must be 1.1.
.P
\f3glXGetClientString\fP only returns information about GLX extensions supported by the client. 
Call \f3glGetString\fP to get a list of GL extensions supported by the server.
.SH SEE ALSO
\f3glXQueryVersion\fP,
\f3glXQueryExtensionsString\fP,
\f3glXQueryServerString\fP
