divert(-1)
# AnotherLevel - A FVWM2 Configuration
# Copyright (C) 1996, 1997 Red Hat Software, Inc
#
#	$Id: fvwm2rc.forms.m4,v 1.2 1998/05/01 23:57:15 gafton Exp $	
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
# This work is derived from:
#       TheNextLevel
#       Copyright 1996 By Greg J. Badros <gjb@cs.duke.edu>
# distributed under GNU General Public License.
#

# This file is m4-included by .fvwm2rc.modules, which was included
# by .fvwm2rc.m4
#

# Not all of the forms listed below are used.
# More work needs to be done, but the FvwmForm module is a moving
# (and greatly improving) target, so this work will have to wait

#FormText(<Form>,[{left,center,expand}],`<text>')
define(`FormText',`ifelse($2,,,`*$1Line $2')
*$1Text "$3"')

#FormInput(<Form>,{left,center,expand},`<prompt>',<variable>,<length>,`<initial-value>')
define(`FormInput',`ifelse($2,,,`*$1Line $2')
*$1Text "$3"
*$1Input $4 $5 "$6"')

# Note: These macros gets undefine-d at end of this file.
divert

############################################################################
#
# FvwmForm LogoutVerify -- Modified from FvwmForm man page.
#

*LogoutVerifyGrabServer
*LogoutVerifyWarpPointer
*LogoutVerifyFont          BASIC_FONT-bold-r*FONT_SIZE_X_2*
*LogoutVerifyButtonFont    BASIC_FONT*FONT_STYLE*FONT_SIZE*
*LogoutVerifyFore          WINFORE_COLOR
*LogoutVerifyBack          MENUBACK_COLOR
*LogoutVerifyItemFore      WINFORE_COLOR
*LogoutVerifyItemBack      WINBACK_COLOR
# begin items
*LogoutVerifyLine          center
*LogoutVerifyText         "Do you really want to logout?"
*LogoutVerifyLine          expand
*LogoutVerifyButton        quit      "Yes" Y
*LogoutVerifyCommand       Quit
*LogoutVerifyButton        quit      "Cancel" 
*LogoutVerifyCommand       Nop
*LogoutVerifyButton        quit      "Restart Fvwm" R
*LogoutVerifyCommand       Restart
# Fvwm window style
Style "LogoutVerify" 		StickyOnTop

###############################################################################
#
# FvwmForm About -- Fvwm's About Box
#

*AboutWarpPointer
*AboutFore		WINFORE_COLOR
*AboutBack		MENUBACK_COLOR
*AboutItemFore      	WINFORE_COLOR
*AboutItemBack      	WINBACK_COLOR
*AboutFont		BASIC_FONT-bold-r-*-*-FONT_SIZE-*-*-*-*-*-*-*

*AboutLine		center
*AboutText		"AnotherLevel - a FVWM2 configuration"
*AboutLine		center
*AboutText		"Copyright (C) 1997, Red Hat Software, Inc."

FormText(About,left,`Serverhost=SERVERHOST, Clienthost=CLIENTHOST')
FormText(About,left,`Hostname=HOSTNAME, Ostype=OSTYPE, User=USER')
FormText(About,left,`Version=VERSION, Revision=6')
FormText(About,left,`Vendor=VENDOR, Release=RELEASE')
FormText(About,left,`Width=WIDTH, Height=HEIGHT')
FormText(About,left,`X_Resolution=X_RESOLUTION, Y_Resolution=Y_RESOLUTION')
FormText(About,left,`Planes=PLANES, Class=CLASS, Color=COLOR')
FormText(About,left,`Fvwm_Version=FVWM_VERSION, Options=OPTIONS')
FormText(About,left,`Fvwmdir=FVWMDIR')

*AboutLine		center
*AboutButton		quit	"Dismiss"

Style "About" NoButton 2, NoButton 4, NoButton 6, StickyOnTop

###########################################################################
#
# FvwmForm Xrsh -- Start a program on a remote machine
#

*XrshFont         BASIC_FONT*FONT_STYLE*FONT_SIZE*
*XrshButtonFont   MEDIUM_FONT
*XrshFore         WINFORE_COLOR
*XrshBack         MENUBACK_COLOR
*XrshItemFore          WINFORE_COLOR
*XrshItemBack          WINBACK_COLOR
# begin items
*XrshLine         center
*XrshText         "Xrsh"
*XrshFont         BASIC_FONT*FONT_STYLE*n*FONT_SIZE*
*XrshLine         expand
*XrshSelection    Host single
foreach(`HOST',USER_HOST_LIST,`*XrshChoice HOST HOST off "capitalize(HOST)"
')
*XrshLine         expand
define(`XRSH_HOSTMAP',`foreach(HOST,USER_HOST_LIST,`$(HOST?XRSH_OR_XON HOST)')')
foreach(APPLICATION,`(emacs,xemacs,xload,netscape,XTERM)',`
*XrshButton	quit "APPLICATION" ShortcutKey(APPLICATION,XrshHosts)
*XrshCommand    Exec XRSH_HOSTMAP APPLICATION
')
*XrshButton       quit "Cancel" ^[
*XrshCommand      Nop

###########################################################################
#
# FvwmForm Rlogin -- Rlogin to an arbitrary remote machine
#

*RloginWarpPointer
*RloginFont         BASIC_FONT*FONT_STYLE*FONT_SIZE*
*RloginButtonFont   MEDIUM_FONT
*RloginInputFont    BASIC_FONT*FONT_STYLE*FONT_SIZE*
*RloginFore         WINFORE_COLOR
*RloginBack         MENUBACK_COLOR
*RloginItemFore     WINFORE_COLOR
*RloginItemBack     WINBACK_COLOR
# begin items
*RloginLine         center
*RloginText         "Login to Remote Host"
FormInput(Rlogin,center,`Host:',HostName,20,)
*RloginLine         center
*RloginSelection    UserSel   single
*RloginChoice       Default   Default   on   "USER"
*RloginChoice       Custom    Custom    off  "Username:"
*RloginInput        UserName  10   ""
*RloginLine         expand
*RloginButton       quit "Login" ^M
*RloginCommand Exec xterm  -T xterm@$(HostName) -e rlogin $(HostName) $(Custom?-l $(UserName))
*RloginButton       restart   "Clear"
*RloginCommand Beep
*RloginButton       quit "Cancel"
*RloginCommand Nop

###########################################################################
#
# FvwmForm TalkForm FvwmTalk module which dissappears after use
# (Was: MyTalk & MyFvwmTalk from Dave Goldberg)
#

*TalkFormWarpPointer
*TalkFormFont BASIC_FONT*FONT_STYLE*FONT_SIZE*
*TalkFormButtonFont BASIC_FONT*FONT_STYLE*FONT_SIZE*
*TalkFormInputFont BASIC-FONT*FONT_STYLE*FONT_SIZE*
*TalkFormFore WINFORE_COLOR
*TalkFormBack MENUBACK_COLOR
*TalkFormItemFore WINFORE_COLOR
*TalkFormItemBack WINBACK_COLOR
*TalkFormLine center
*TalkFormText "Fvwm Function"
*TalkFormInput Func 40 ""
*TalkFormLine expand
*TalkFormButton quit "Run" ^M
*TalkFormCommand $(Func)
*TalkFormButton restart "Clear" ^R
*TalkFormButton quit "Cancel" ^C
*TalkFormCommand Nop

###########################################################################
#
# Capture Window (from man page)
#

*CaptureFont         BASIC_FONT*FONT_STYLE*FONT_SIZE*
*CaptureButtonFont   MEDIUM_FONT
*CaptureInputFont    BASIC_FONT*FONT_STYLE*FONT_SIZE*
*CaptureLine        center
*CaptureText        "Capture Window"
*CaptureLine        left
*CaptureText        "File: "
*CaptureInput       file      25   "/tmp/Capture"
*CaptureLine        left
*CaptureText        "Printer: "
*CaptureInput       printer        20   "ps1"
*CaptureLine        expand
*CaptureSelection   PtrType   single
*CaptureChoice      PS   ps   on   "PostScript"
*CaptureChoice      Ljet ljet off  "HP LaserJet"
*CaptureLine        left
*CaptureText        "xwd options:"
*CaptureLine        expand
*CaptureSelection   Options   multiple
*CaptureChoice      Brd  -nobdrs   off  "No border"
*CaptureChoice      Frm  -frame    on   "With frame"
*CaptureChoice      XYZ  -xy  off  "XY format"
 
###########################################################################
#
# FvwmForm AudioEvents
#
# This is incomplete in that it'd be cool if you could save your settings
# and reload them.... but I don't even use FvwmAudio, alas I can't
# concentrate on this for now

*AudioEventsFont         MEDIUM_FONT
*AudioEventsButtonFont   MEDIUM_FONT
*AudioEventsFore         WINFORE_COLOR
*AudioEventsBack         MENUBACK_COLOR
*AudioEventsItemFore     WINFORE_COLOR
*AudioEventsItemBack     WINBACK_COLOR

FormInput(AudioEvents,left,`startup',startup,50,`bud.au')
FormInput(AudioEvents,,`shutdown',shutdown,50,`')
FormInput(AudioEvents,left,`unknown',unknown,50,`doh.au')
FormInput(AudioEvents,left,`add_window',add_window,50,`gong.wav')
FormInput(AudioEvents,left,`raise_window',raise_window,50,`chimes.wav')
FormInput(AudioEvents,left,`lower_window',lower_window,50,`beep1.wav')
FormInput(AudioEvents,left,`focus_change_window',focus_change_window,50,`beep1.wav')
FormInput(AudioEvents,left,`destroy_window',destroy_window,50,`splat.wav')
FormInput(AudioEvents,left,`iconify',iconify,50,`splat.wav')
FormInput(AudioEvents,left,`deiconify',deiconify,50,`ploop.au')
FormInput(AudioEvents,left,`toggle_paging',toggle_paging,50,`fwop.au')
FormInput(AudioEvents,left,`new_page',new_page,50,`beam_trek.au')
FormInput(AudioEvents,left,`new_desk',new_desk,50,`beam_trek.au')
FormInput(AudioEvents,left,`configure_window',configure_window,50,`huh.au')
FormInput(AudioEvents,left,`window_name',window_name,50,`beep.au')
FormInput(AudioEvents,left,`icon_name',icon_name,50,`beep.au')
FormInput(AudioEvents,left,`res_class',res_class,50,`beep.au')
FormInput(AudioEvents,left,`res_name',res_name,50,`beep.au')
FormInput(AudioEvents,left,`end_windowlist',end_windowlist,50,`beep.au')
*AudioEventsLine expand
*AudioEventsButton quit "Quit" 
*AudioEventsButton nop "Apply" A
#FIX: Add the rest in here, if this works
*AudioEventsCommand *FvwmAudio raise_window $(raise_window)
*AudioEventsCommand *FvwmAudio lower_window $(lower_window)

###########################################################################

undefine(`FormText')
