divert(-1)
# AnotherLevel - A FVWM2 Configuration
# Copyright (C) 1996, 1997 Red Hat Software, Inc
#
#	$Id: fvwm2rc.defines.m4,v 1.2 1998/05/01 23:57:15 gafton Exp $	
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
# This work is derived from:
#       TheNextLevel
#       Copyright 1996 By Greg J. Badros <gjb@cs.duke.edu>
# distributed under GNU General Public License.
#

##############################################################################
# This file is m4-included by fvwm2rc.m4
##############################################################################

# Note: This is preprocessed by m4, not cpp!
# a "#define" is a *comment* not a definition!

# Also note: m4 uses matching angled quotes `', not '' or `` like shells

#
# One final note: some options are set in /etc/X11/AnotherLevel/decors/* files,
# mostlly because some option are look-and-feel specific.
#

# NO_TRACE_FVWM_PARSE turns off some forced errors which can help in
# locating your problems
#define(`NO_TRACE_FVWM_PARSE')

# the name of the root menu
define(`ROOT_MENU', `AUTO_WM_CONFIG')

# The name of the file in the user's home directory that keeps 
# the interface preferences
define(`USER_WM_STYLE',`.wm_style')

#----------------------------------------------------------------------------
# User option -- feel free to modify these
#
# USER_HOST_LIST is a list of hosts to allow as options for the hosts menu, etc.
# Any hosts you use frequently should be in here, comma separated, with the 
# whole list enclosed in round parentheses. eg. `(host1, host2, host3)'
#define(`USER_HOST_LIST',`(news,ftp,www)')

# RLOGIN_OR_TELNET should be `rlogin' or `telnet', whichever you'd prefer to 
# use for remote logins
define(`RLOGIN_OR_TELNET',`rlogin')

# The default XTERM used when in X. You can switch it here (usually
# you want  to select between nxterm, xterm and rxvt).
# Also, choose your RXVT program (rxvt is supposed to be a lightweight 
# xterm-like application, so you should avoid using emacs for that value... 
# ;-)
define(`XTERM', `nxterm')
define(`RXVT', `rxvt')

# And your browser is...
define(`WWW_BROWSER', `netscape')

# Normally "WWW_BROWSER HELP_FILE" (or "WWW_BROWSER -url HELP_FILE" for
# redbaron) is run to display help. If you prefer to display the help in
# some other manner, define the command here. The following example will
# display the help in a currently running netscape window, or open one if
# none is already available.
#define(`BROWSER_HELP_COMMAND',sh -c "netscape -remote 'openURL(HELP_FILE)' || netscape HELP_FILE")

# Uncomment for sound events (FvwmAudio) on by default
#define(`WANT_SOUND_EVENTS')

# Comment below if you want to you delete instead of close for button
# decorations window close operation. Delete won't kill a window that doesn't 
# respond to delete, close will kill it if the delete goes unrecognized (it 
# will always close the window, perhaps semi-violently).
define(`USE_CLOSE_FOR_DECORATIONS')

# Define this for interactive placement (InteractivePlacement), which forces
# the window manager to allow manual placement of all windows on the desktop.
#define(`INTERACTIVE_PLACEMENT')

# NUM_DESKTOPS is number of desktops -- each desktop is DESKTOP_SIZE panes
define(`NUM_DESKTOPS',2)

# DESKTOP_SIZE is a geometry specifying horizontal desktop x vertical desktops
# So 3x3 gives 9 panes per desktop
define(`DESKTOP_SIZE',2x2)

# OPAQUE_MOVE_SIZE is the percentage of screen that a window must be smaller than
# to be moved opaquely
define(`OPAQUE_MOVE_SIZE',30)

# EDGE_SCROLL_RESISTANCE, EDGE_MOVE_RESISTANCE are numbers given to Fvwm's
# EdgeResistance configuration command.  See fvwm2(1)
define(`EDGE_SCROLL_RESISTANCE',400)
define(`EDGE_MOVE_RESISTANCE',40)

# AUTO_RAISE_SPEED is the time in ms before auto-raising a window with FvwmAuto
define(`AUTO_RAISE_SPEED',200)

# Uncomment USE_AUTO_RAISE turn turn on window autoraising by default
#define(`USE_AUTO_RAISE')

# If defined, the focus follows the pointer. Otherwise focus is set by
# clicking on a window. Undefined this implements "ClickToFocus". Please note
# that AutoRaise does not work with ClickToFocus...
#define(`FOCUS_FOLLOWS_POINTER')

# Define this if you want to start a web browser when X starts up
# define(`START_BROWSER')

# Uncomment below if you have a win95 keyboard (one w/ the extra keys)
#define(`Win95Keys')

# Uncomment USE_VERTICAL_BUTTON_BARS if you want your tearoff button bars to be vertical
#define(`USE_VERTICAL_BUTTON_BARS')

#----------------------------------------------------------------------------
# System options -- you probably don't need to change these!
#

# Pixmap Path will always include /usr/X11/include/pixmaps after the below
define(`USER_PIXMAP_PATH',`/usr/X11R6/include/X11/pixmaps/:/usr/share/icons/:/usr/share/icons/mini/')

# Icon (bitmap) path will always include /usr/X11/include/bitmaps after the below
define(`USER_ICON_PATH',`/usr/X11R6/include/X11/bitmaps/:/usr/share/icons/:/usr/share/icons/mini/')

# USER_MODULE_PATH will always include FVWMDIR (compile time option passed in to FvwmM4)
define(`USER_MODULE_PATH', `')

# MAIL_SPOOL_DIR is used by Fvwm95's FvwmTaskBarMailBox option.
# Probably will need to use the FvwmM4 define-d `USER' macro to set this one
define(`MAIL_SPOOL_DIR',`/var/spool/mail/'`'USER)

# The directory to use for temporary files created by m4's syscmd, then include-d in
define(`TMPDIR',`/tmp')

# Uncomment for auto generation of host menu-- uses /etc/hosts.
# Comment if you're using NIS, yp, or if you just have a big /etc/hosts file
# (if commented, be sure to set USER_HOST_LIST, below
#define(`AUTO_HOST_MENU')

# XRSH_OR_XON should be either `xon' or `xrsh' whichever you'd prefer for starting x apps
# on a remote machine
define(`XRSH_OR_XON',`xon')

# MOD_SOUND_PATH, MIDI_SOUND_PATH are paths to mod files, midi files for the multimedia
# menu's use
define(`MOD_SOUND_PATH',`/usr/share/sound/mod')
define(`MIDI_SOUND_PATH',`/usr/share/sound/midi')

# This is the URL displayed by the help choice which shows up on menus.
define(`HELP_FILE',`file:///usr/doc/AnotherLevel/index.html')

# Set this directory even if you don't want sound on by default-- it can be turned
# on dynamically.  This directory should include .wav or .au files, or whatever
# SOUND_COMMAND requires
define(`SOUND_DIR',`/usr/share/sound')

# The program to use to play the files in the above directory
# You'll still need to add events in .fvwm2rc.modules to make sounds
# play
define(`SOUND_COMMAND',`play')

# Comment NO_VERIFY_QUIT to provide an extra extra degree of certain about leaving.
# Uncommented, it still is not possible to leave fvwm with a single keystroke (even chorded)
define(`NO_VERIFY_QUIT')

# TITLE_STYLE should be a {justification,appearance} pair from fvwm's TitleStyle option
# justification is one of Centered, RightJustified, or LeftJustified
# appearance is one of Raised, Sunk, or Flat
# This does nothing in Fvwm95
# eg. `Centered Flat'
define(`TITLE_STYLE',`LeftJustified -- flat')

# Uncomment below if you want to be able to start a tail -f 
# of a message log in an rxvt from SystemUtils menu
# Change it to the most appropriate general log on your system
# define(`MESSAGE_LOG',`/var/log/messages')

# Change the BORDER_WIDTH to be the number of pixels in a window frame.
# Bigger looks more "solid", but takes up more precious screen real-estate
define(`BORDER_WIDTH',`5')

# BASIC_FONT tells the font style to use generally-- first two parts of a font name, only
define(`BASIC_FONT',`*helvetica')

# FONT_STYLE tells the middle part of a font name.  try `medium-o' for a slanted font
# Be careful not to be too constraining with your choices
define(`FONT_STYLE',`medium-r')

# BASIC_FONT_SIZE is a font size in points
define(`BASIC_FONT_SIZE',`12')

# SMALL_SCREEN_BASIC_FONT_SIZE becomes the BASIC_FONT_SIZE if we're using a small screen
define(`SMALL_SCREEN_BASIC_FONT_SIZE',`10')

# SMALL_FONT is used for button labels, etc.
define(`SMALL_FONT',`5x8')

# MEDIUM_FONT is used for some forms-- should be >= SMALL_FONT, <= BASIC_FONT*BASIC_FONT_SIZE
# (* on above line is wildcard, not multiplication)
define(`MEDIUM_FONT',`fixed')

# ICON_FONT is the font used to label icons
define(`ICON_FONT',`fixed')

# CLICK_MS is the time in ms for clicks to succeed one another to be considered a double
# click
define(`CLICK_MS',	150)

# COLOR_MAP_FOCUS is either FollwsMouse or FollowsFocus
define(`COLOR_MAP_FOCUS',`FollowsFocus')

# The level of niceness to use for commands that will be nice-d
define(`NICELEVEL',`-16')

# Set START_MENU_PIXMAP to a small (~60x~25 or so) pixmap to show at the top of
# the FvwmTaskBar's start menu-- only matters if you're using Fvwm95's task bar
define(`START_MENU_PIXMAP',`mini-redhat.xpm')

# Uncomment below if you'd prefer keybindings for cursor movement that are in
# a cross, instead of a VI-style layout (I J K M, instead of vi-like H J K L)
#define(`NOT_VI_KEYS')

# PRINT_FUNCTION gives a shell command to print the window id $w
# xvwd is a script that does: "xwd $* > /tmp/xvwd.$$;xv /tmp/xvwd.$$;rm /tmp/xvwd.$$"
# This doesn't actually print it, but starts xv (version >=3.1) with it in its window
# You may want to use xpr if you have it and have it configured
define(`PRINT_FUNCTION',`xvwd -id $w')

# The font for "big" button bars (w/ fullsize pixmap icons, not mini-pixmaps)
define(`BUTTON_BARS_FONT',`SMALL_FONT')

# Comment the below if you don't want to be able to get tearoff button bars
# containing mini-pixmaps
define(`PROVIDE_TEAROFF_BUTTON_BAR')

# Uncomment the below (and probably comment PROVIDE_TEAROFF_BUTTON_BAR, above) if you 
# prefer large pixmap button bar tear-offs
#define(`PROVIDE_TEAROFF_BIG_BUTTON_BAR')

# Uncomment below if you don't have xdm start an xconsole running.
# NEED_CONSOLE set will start an xterm with its "-c" option to capture console output
#define(`NEED_CONSOLE')

divert
