'\"! eqn | mmdoc
'\"macro stdmacro
.ds Vn Version 1.2
.ds Dt 6 March 1997
.ds Re Release 1.2.0
.ds Dp Feb 16 02:57
.ds Dm  Feb 10 17:2
.ds Xs 55673 5 xusexfont.gl
.TH GLXUSEXFONT
.SH NAME
.B "glXUseXFont
\- create bitmap display lists from an X font

.SH C SPECIFICATION
void \f3glXUseXFont\fP(
Font \fIfont\fP,
.nf
.ta \w'\f3void \fPglXUseXFont( 'u
	int \fIfirst\fP,
	int \fIcount\fP,
	int \fIlistBase\fP )
.fi

.EQ
delim $$
.EN
.SH PARAMETERS
.TP \w'\fIlistBase\fP\ \ 'u 
\f2font\fP
Specifies the font from which character glyphs are to be taken.
.TP
\f2first\fP
Specifies the index of the first glyph to be taken.
.TP
\f2count\fP
Specifies the number of glyphs to be taken.
.TP
\f2listBase\fP
Specifies the index of the first display list to be generated.
.SH DESCRIPTION
\f3glXUseXFont\fP generates \f2count\fP display lists,
named \f2listBase\fP through \f2listBase\fP\&+\&\f2count\fP\&\-\&1,
each containing a single \f3glBitmap\fP command.
The parameters of the \f3glBitmap\fP command of display list \f2listBase\fP\&+\f2i\fP
are derived from glyph \f2first\fP\&+\f2i\fP.
Bitmap parameters \f2xorig, yorig, width,\fP and \f2height\fP
are computed from font metrics as
\f2descent\-1, \-lbearing,\fP
\f2rbearing\-lbearing,\fP and \f2ascent+descent\fP, respectively.
\f2xmove\fP is taken from the glyph's \f2width\fP metric,
and \f2ymove\fP is set to zero.
Finally,
the glyph's image is converted to the appropriate format for \f3glBitmap\fP.
.P
Using \f3glXUseXFont\fP may be more efficient than accessing the X font and generating
the display lists explicitly,
both because the display lists are created on the server without requiring
a round trip of the glyph data,
and because the server may choose to delay the creation of each
bitmap until it is accessed.
.P
Empty display lists are created for all glyphs that are requested and
are not defined in \f2font\fP.
\f3glXUseXFont\fP is ignored if there is no current GLX context.
.SH ERRORS
\f3BadFont\fP is generated if \f2font\fP is not a valid font.
.P
\f3GLXBadContextState\fP is generated if the current GLX context is
in display-list construction mode.
.P
\f3GLXBadCurrentWindow\fP is generated if the drawable associated
with the current context of the calling thread is a window, and that
window is no longer valid.
.SH SEE ALSO
\f3glBitmap\fP,
\f3glXMakeCurrent\fP
