'\"! eqn | mmdoc
'\"macro stdmacro
.ds Vn Version 1.2
.ds Dt 6 March 1997
.ds Re Release 1.2.0
.ds Dp Feb 16 02:56
.ds Dm  Feb 10 17:2
.ds Xs 62493 5 xcreateglxpixmap.gl
.TH GLXCREATEGLXPIXMAP
.SH NAME
.B "glXCreateGLXPixmap
\- create an off-screen GLX rendering area

.SH C SPECIFICATION
GLXPixmap \f3glXCreateGLXPixmap\fP(
Display \fI*dpy\fP,
.nf
.ta \w'\f3GLXPixmap \fPglXCreateGLXPixmap( 'u
	XVisualInfo \fI*vis\fP,
	Pixmap \fIpixmap\fP )
.fi

.EQ
delim $$
.EN
.SH PARAMETERS
.TP \w'\fIpixmap\fP\ \ 'u 
\f2dpy\fP
Specifies the connection to the X server.
.TP
\f2vis\fP
Specifies the visual that defines the structure of the rendering area.
It is a pointer to an \f3XVisualInfo\fP structure,
not a visual ID or a pointer to a \f3Visual\fP.
.TP
\f2pixmap\fP
Specifies the X pixmap that will be used as the front left color buffer
of the off-screen rendering area.
.SH DESCRIPTION
\f3glXCreateGLXPixmap\fP creates an off-screen rendering area and returns its XID.
Any GLX rendering context that was created with respect to \f2vis\fP
can be used to render into this off-screen area.
Use \f3glXMakeCurrent\fP to associate the rendering area with a GLX
rendering context.
.P
The X pixmap identified by \f2pixmap\fP is used as the front left buffer of the
resulting off-screen rendering area.
All other buffers specified by \f2vis\fP,
including color buffers other than the front left buffer,
are created without externally visible names.
GLX pixmaps with double-buffering are supported.
However, \f3glXSwapBuffers\fP is ignored by these pixmaps.
.P
Some implementations may not support GLX pixmaps with direct rendering
contexts. 
.SH NOTES
\f3XVisualInfo\fP is defined in \f2Xutil.h.\fP
It is a structure that includes \f2visual\fP, \f2visualID\fP, \f2screen\fP, and
\f2depth\fP elements.
.SH ERRORS
\f3BadMatch\fP is generated if the depth of \f2pixmap\fP does not match
the depth value reported by core X11 for \f2vis\fP,
or if \f2pixmap\fP was not created with respect to the same screen as \f2vis\fP.
.P
\f3BadValue\fP is generated
if \f2vis\fP is not a valid XVisualInfo pointer (for example, if a
particular GLX implementation does not support this visual).
.P
\f3BadPixmap\fP is generated if \f2pixmap\fP is not a valid pixmap.
.P
\f3BadAlloc\fP is generated if the server cannot allocate the GLX
pixmap.
.SH SEE ALSO
\f3glXCreateContext\fP,
\f3glXIsDirect\fP,
\f3glXMakeCurrent\fP
