/* $XFree86: xc/programs/Xserver/hw/xfree86/common/xf86Config.c,v 3.226 2000/06/20 05:08:43 dawes Exp $ */


/*
 * Copyright 1991-1999 by The XFree86 Project, Inc.
 * Copyright 1997 by Metro Link, Inc.
 *
 * Loosely based on code bearing the following copyright:
 *
 *   Copyright 1990,91 by Thomas Roell, Dinkelscherben, Germany.
 *
 *  <Put copyright message here>
 *
 * Author: Dirk Hohndel <hohndel@XFree86.Org>
 */

#ifdef XF86DRI
#include <sys/types.h>
#include <grp.h>
#endif

#include "xf86.h"
#include "xf86Parser.h"
#include "xf86tokens.h"
#include "xf86Config.h"
#define NO_COMPILER_H_EXTRAS
#include "xf86Priv.h"
#include "xf86_OSlib.h"

#include "globals.h"

#ifdef XINPUT
#include "xf86Xinput.h"
extern DeviceAssocRec mouse_assoc;
#endif

#ifdef XKB
#define XKB_IN_SERVER
#include "XKBsrv.h"
#endif

#if (defined(i386) || defined(__i386__)) && \
    (defined(__FreeBSD__) || defined(__NetBSD__) || defined(linux) || \
     (defined(SVR4) && !defined(sun)))
#define SUPPORT_PC98
#endif

#ifdef __EMX__
#define ROOT_CONFIGPATH	"%A," "%R," \
			"%E," \
			"%D/%X," \
			"%&/XFree86/lib/X11/%X-%M," "%&/XFree86/lib/X11/%X," "%&XFree86/lib/X11/%X," \
			"%P/etc/X11/%X.%H," "%P/etc/X11/%X-%M," \
			"%P/etc/X11/%X,"
#define USER_CONFIGPATH ROOT_CONFIGPATH
#endif

/*
 * These paths define the way the config file search is done.  The escape
 * sequences are documented in parser/scan.c.
 */
#ifndef ROOT_CONFIGPATH
#define ROOT_CONFIGPATH	"%A," "%R," \
			"/etc/X11/%R," "%P/etc/X11/%R," \
			"%E," "%F," \
			"/etc/X11/%F," "%P/etc/X11/%F," \
			"%D/%X," \
			"/etc/X11/%X-%M," "/etc/X11/%X," "/etc/%X," \
			"%P/etc/X11/%X.%H," "%P/etc/X11/%X-%M," \
			"%P/etc/X11/%X," \
			"%P/lib/X11/%X.%H," "%P/lib/X11/%X-%M," \
			"%P/lib/X11/%X"
#endif
#ifndef USER_CONFIGPATH
#define USER_CONFIGPATH	"/etc/X11/%S," "%P/etc/X11/%S," \
			"/etc/X11/%G," "%P/etc/X11/%G," \
			"/etc/X11/%X-%M," "/etc/X11/%X," "/etc/%X," \
			"%P/etc/X11/%X.%H," "%P/etc/X11/%X-%M," \
			"%P/etc/X11/%X," \
			"%P/lib/X11/%X.%H," "%P/lib/X11/%X-%M," \
			"%P/lib/X11/%X"
#endif
#ifndef PROJECTROOT
#define PROJECTROOT	"/usr/X11R6"
#endif

static char *fontPath = NULL;

/* Forward declarations */
static Bool configScreen(confScreenPtr screenp, XF86ConfScreenPtr conf_screen,
			 int scrnum, MessageType from);
static Bool configMonitor(MonPtr monitorp, XF86ConfMonitorPtr conf_monitor);
static Bool configDevice(GDevPtr devicep, XF86ConfDevicePtr conf_device,
			 Bool active);
static Bool configInput(IDevPtr inputp, XF86ConfInputPtr conf_input,
			MessageType from);
static Bool configDisplay(DispPtr displayp, XF86ConfDisplayPtr conf_display);
static Bool addDefaultModes(MonPtr monitorp);
#ifdef XF86DRI
static Bool configDRI(XF86ConfDRIPtr drip);
#endif

/*
 * xf86GetPathElem --
 *	Extract a single element from the font path string starting at
 *	pnt.  The font path element will be returned, and pnt will be
 *	updated to point to the start of the next element, or set to
 *	NULL if there are no more.
 */
static char *
xf86GetPathElem(char **pnt)
{
  char *p1;

  p1 = *pnt;
  *pnt = index(*pnt, ',');
  if (*pnt != NULL) {
    **pnt = '\0';
    *pnt += 1;
  }
  return(p1);
}

/*
 * xf86ValidateFontPath --
 *	Validates the user-specified font path.  Each element that
 *	begins with a '/' is checked to make sure the directory exists.
 *	If the directory exists, the existence of a file named 'fonts.dir'
 *	is checked.  If either check fails, an error is printed and the
 *	element is removed from the font path.
 */

#define DIR_FILE "/fonts.dir"
static char *
xf86ValidateFontPath(char *path)
{
  char *tmp_path, *out_pnt, *path_elem, *next, *p1, *dir_elem;
  struct stat stat_buf;
  int flag;
  int dirlen;

  tmp_path = xcalloc(1,strlen(path)+1);
  out_pnt = tmp_path;
  path_elem = NULL;
  next = path;
  while (next != NULL) {
    path_elem = xf86GetPathElem(&next);
#ifndef __EMX__
    if (*path_elem == '/') {
      dir_elem = xnfcalloc(1, strlen(path_elem) + 1);
      if ((p1 = strchr(path_elem, ':')) != 0)
#else
    /* OS/2 must prepend X11ROOT */
    if (*path_elem == '/') {
      path_elem = (char*)__XOS2RedirRoot(path_elem);
      dir_elem = xnfcalloc(1, strlen(path_elem) + 1);
      if (p1 = strchr(path_elem+2, ':'))
#endif
	dirlen = p1 - path_elem;
      else
	dirlen = strlen(path_elem);
      strncpy(dir_elem, path_elem, dirlen);
      dir_elem[dirlen] = '\0';
      flag = stat(dir_elem, &stat_buf);
      if (flag == 0)
	if (!S_ISDIR(stat_buf.st_mode))
	  flag = -1;
      if (flag != 0) {
        xf86Msg(X_WARNING, "The directory \"%s\" does not exist.\n", dir_elem);
	xf86ErrorF("\tEntry deleted from font path.\n");
	continue;
      }
      else {
	p1 = xnfalloc(strlen(dir_elem)+strlen(DIR_FILE)+1);
	strcpy(p1, dir_elem);
	strcat(p1, DIR_FILE);
	flag = stat(p1, &stat_buf);
	if (flag == 0)
	  if (!S_ISREG(stat_buf.st_mode))
	    flag = -1;
#ifndef __EMX__
	xfree(p1);
#endif
	if (flag != 0) {
	  xf86Msg(X_WARNING,
		  "`fonts.dir' not found (or not valid) in \"%s\".\n", 
		  dir_elem);
	  xf86ErrorF("\tEntry deleted from font path.\n");
	  xf86ErrorF("\t(Run 'mkfontdir' on \"%s\").\n", dir_elem);
	  continue;
	}
      }
      xfree(dir_elem);
    }

    /*
     * Either an OK directory, or a font server name.  So add it to
     * the path.
     */
    if (out_pnt != tmp_path)
      *out_pnt++ = ',';
    strcat(out_pnt, path_elem);
    out_pnt += strlen(path_elem);
  }
  return(tmp_path);
}


/*
 * use the datastructure that the parser provides and pick out the parts
 * that we need at this point
 */
char **
xf86ModulelistFromConfig(pointer **optlist)
{
    int count = 0;
    char **modulearray;
    pointer *optarray;
    XF86LoadPtr modp;
    
    /*
     * make sure the config file has been parsed and that we have a
     * ModulePath set; if no ModulePath was given, use the default
     * ModulePath
     */
    if (xf86configptr == NULL) {
        xf86Msg(X_ERROR, "Cannot access global config data structure\n");
        return NULL;
    }
    
    if (xf86configptr->conf_modules) {
	/*
	 * Walk the list of modules in the "Module" section to determine how
	 * many we have.
	 */
	modp = xf86configptr->conf_modules->mod_load_lst;
	while (modp) {
	    count++;
	    modp = (XF86LoadPtr) modp->list.next;
	}
    }
    if (count == 0)
	return NULL;

    /*
     * allocate the memory and walk the list again to fill in the pointers
     */
    modulearray = xnfalloc((count + 1) * sizeof(char*));
    optarray = xnfalloc((count + 1) * sizeof(pointer));
    count = 0;
    if (xf86configptr->conf_modules) {
	modp = xf86configptr->conf_modules->mod_load_lst;
	while (modp) {
	    modulearray[count] = modp->load_name;
	    optarray[count] = modp->load_opt;
	    count++;
	    modp = (XF86LoadPtr) modp->list.next;
	}
    }
    modulearray[count] = NULL;
    optarray[count] = NULL;
    if (optlist)
	*optlist = optarray;
    else
	xfree(optarray);
    return modulearray;
}


char **
xf86DriverlistFromConfig()
{
    int count = 0;
    int j;
    char **modulearray;
    screenLayoutPtr slp;
    
    /*
     * make sure the config file has been parsed and that we have a
     * ModulePath set; if no ModulePath was given, use the default
     * ModulePath
     */
    if (xf86configptr == NULL) {
        xf86Msg(X_ERROR, "Cannot access global config data structure\n");
        return NULL;
    }
    
    /*
     * Walk the list of driver lines in active "Device" sections to
     * determine now many implicitly loaded modules there are.
     *
     */
    if (xf86ConfigLayout.screens) {
        slp = xf86ConfigLayout.screens;
        while ((slp++)->screen) {
	    count++;
        }
    }

    /*
     * Handle the set of inactive "Device" sections.
     */
    j = 0;
    while (xf86ConfigLayout.inactives[j++].identifier)
	count++;

    if (count == 0)
	return NULL;

    /*
     * allocate the memory and walk the list again to fill in the pointers
     */
    modulearray = xnfalloc((count + 1) * sizeof(char*));
    count = 0;
    slp = xf86ConfigLayout.screens;
    while (slp->screen) {
	modulearray[count] = slp->screen->device->driver;
	count++;
	slp++;
    }

    j = 0;

    while (xf86ConfigLayout.inactives[j].identifier) 
	modulearray[count++] = xf86ConfigLayout.inactives[j++].driver;

    modulearray[count] = NULL;

    /* Remove duplicates */
    for (count = 0; modulearray[count] != NULL; count++) {
	int i;

	for (i = 0; i < count; i++)
	    if (xf86NameCmp(modulearray[i], modulearray[count]) == 0) {
		modulearray[count] = "";
		break;
	    }
    }
    return modulearray;
}


Bool
xf86BuiltinInputDriver(const char *name)
{
    if (xf86NameCmp(name, "keyboard") == 0)
	return TRUE;
    else
	return FALSE;
}


char **
xf86InputDriverlistFromConfig()
{
    int count = 0;
    char **modulearray;
    IDevPtr idp;
    
    /*
     * make sure the config file has been parsed and that we have a
     * ModulePath set; if no ModulePath was given, use the default
     * ModulePath
     */
    if (xf86configptr == NULL) {
        xf86Msg(X_ERROR, "Cannot access global config data structure\n");
        return NULL;
    }
    
    /*
     * Walk the list of driver lines in active "InputDevice" sections to
     * determine now many implicitly loaded modules there are.
     */
    if (xf86ConfigLayout.inputs) {
        idp = xf86ConfigLayout.inputs;
        while (idp->identifier) {
	    if (!xf86BuiltinInputDriver(idp->driver))
	        count++;
	    idp++;
        }
    }

    if (count == 0)
	return NULL;

    /*
     * allocate the memory and walk the list again to fill in the pointers
     */
    modulearray = xnfalloc((count + 1) * sizeof(char*));
    count = 0;
    idp = xf86ConfigLayout.inputs;
    while (idp->identifier) {
	if (!xf86BuiltinInputDriver(idp->driver)) {
	    modulearray[count] = idp->driver;
	    count++;
	}
	idp++;
    }
    modulearray[count] = NULL;

    /* Remove duplicates */
    for (count = 0; modulearray[count] != NULL; count++) {
	int i;

	for (i = 0; i < count; i++)
	    if (xf86NameCmp(modulearray[i], modulearray[count]) == 0) {
		modulearray[count] = "";
		break;
	    }
    }
    return modulearray;
}


/*
 * Generate a compiled-in list of driver names.  This is used to produce a
 * consistent probe order.  For the loader server, we also look for vendor-
 * provided modules, pre-pending them to our own list.
 */
static char **
GenerateDriverlist(char * dirname, char * drivernames)
{
    char *cp, **driverlist;
    int count;

    /* Count the number needed */
    count = 0;
    cp = drivernames;
    while (*cp) {
	while (*cp && isspace(*cp)) cp++;
	if (!*cp) break;
	count++;
	while (*cp && !isspace(*cp)) cp++;
    }

    if (!count)
	return NULL;

    /* Now allocate the array of pointers to 0-terminated driver names */
    driverlist = (char **)xnfalloc((count + 1) * sizeof(char *));
    count = 0;
    cp = drivernames;
    while (*cp) {
	while (*cp && isspace(*cp)) cp++;
	if (!*cp) break;
	driverlist[count++] = cp;
	while (*cp && !isspace(*cp)) cp++;
	if (!*cp) break;
	*cp++ = 0;
    }
    driverlist[count] = NULL;

#ifdef XFree86LOADER
    {
        const char *subdirs[] = {NULL, NULL};
        static const char *patlist[] = {"(.*)_drv\\.so", "(.*)_drv\\.o", NULL};
        char **dlist, **clist, **dcp, **ccp;

        subdirs[0] = dirname;

        /* Get module list */
        dlist = LoaderListDirs(subdirs, patlist);
        if (!dlist) {
            xfree(driverlist);
            return NULL;        /* No modules, no list */
        }

        clist = driverlist;

        /* The resulting list cannot be longer than the module list */
        for (dcp = dlist, count = 0;  *dcp++;  count++);
        driverlist = (char **)xnfalloc((count + 1) * sizeof(char *));

        /* First, add modules not in compiled-in list */
        for (count = 0, dcp = dlist;  *dcp;  dcp++) {
            for (ccp = clist;  ;  ccp++) {
                if (!*ccp) {
                    driverlist[count++] = *dcp;
                    break;
                }
                if (!strcmp(*ccp, *dcp))
                    break;
            }
        }

        /* Next, add compiled-in names that are also modules */
        for (ccp = clist;  *ccp;  ccp++) {
            for (dcp = dlist;  *dcp;  dcp++) {
                if (!strcmp(*ccp, *dcp)) {
                    driverlist[count++] = *ccp;
                    break;
                }
            }
        }

        driverlist[count] = NULL;
        xfree(clist);
        xfree(dlist);
    }
#endif /* XFree86LOADER */

    return driverlist;
}


char **
xf86DriverlistFromCompile(void)
{
    static char **driverlist = NULL;
    static Bool generated = FALSE;

    /* This string is modified in-place */
    static char drivernames[] = DRIVERS;

    if (!generated) {
        generated = TRUE;
        driverlist = GenerateDriverlist("drivers", drivernames);
    }

    return driverlist;
}


char **
xf86InputDriverlistFromCompile(void)
{
    static char **driverlist = NULL;
    static Bool generated = FALSE;

    /* This string is modified in-place */
    static char drivernames[] = IDRIVERS;

    if (!generated) {
        generated = TRUE;
	driverlist = GenerateDriverlist("input", drivernames);
    }

    return driverlist;
}


/*
 * xf86ConfigError --
 *      Print a READABLE ErrorMessage!!!  All information that is 
 *      available is printed.
 */
static void
xf86ConfigError(char *msg, ...)
{
    va_list ap;

    ErrorF("\nConfig Error:\n");
    va_start(ap, msg);
    VErrorF(msg, ap);
    va_end(ap);
    ErrorF("\n");
    return;
}

static Bool
configFiles(XF86ConfFilesPtr fileconf)
{
  MessageType pathFrom = X_DEFAULT;

  /* FontPath */

  /* Try XF86Config FontPath first */
  if (!xf86fpFlag) {
   if (fileconf) {
    if (fileconf->file_fontpath) {
      char *f = xf86ValidateFontPath(fileconf->file_fontpath);
      pathFrom = X_CONFIG;
      if (*f)
        defaultFontPath = f;
      else {
	xf86Msg(X_WARNING,
	    "FontPath is completely invalid.  Using compiled-in default.\n");
        fontPath = NULL;
        pathFrom = X_DEFAULT;
      }
    } 
   } else {
      xf86Msg(X_WARNING,
	    "No FontPath specified.  Using compiled-in default.\n");
      pathFrom = X_DEFAULT;
   }
  } else {
    /* Use fontpath specified with '-fp' */
    if (fontPath)
    {
      fontPath = NULL;
    }
    pathFrom = X_CMDLINE;
  }
  if (!fileconf) {
      /* xf86ValidateFontPath will write into it's arg, but defaultFontPath
       could be static, so we make a copy. */
    char *f = xnfalloc(strlen(defaultFontPath) + 1);
    f[0] = '\0';
    strcpy (f, defaultFontPath);
    defaultFontPath = xf86ValidateFontPath(f);
    xfree(f);
  } else {
   if (fileconf) {
    if (!fileconf->file_fontpath) {
      /* xf86ValidateFontPath will write into it's arg, but defaultFontPath
       could be static, so we make a copy. */
     char *f = xnfalloc(strlen(defaultFontPath) + 1);
     f[0] = '\0';
     strcpy (f, defaultFontPath);
     defaultFontPath = xf86ValidateFontPath(f);
     xfree(f);
    }
   }
  }

  /* If defaultFontPath is still empty, exit here */

  if (! *defaultFontPath)
    FatalError("No valid FontPath could be found\n");

  xf86Msg(pathFrom, "FontPath set to \"%s\"\n", defaultFontPath);

  /* RgbPath */

  pathFrom = X_DEFAULT;

  if (xf86coFlag)
    pathFrom = X_CMDLINE;
  else if (fileconf) {
    if (fileconf->file_rgbpath) {
      rgbPath = fileconf->file_rgbpath;
      pathFrom = X_CONFIG;
    }
  }

  xf86Msg(pathFrom, "RgbPath set to \"%s\"\n", rgbPath);

#ifdef XFree86LOADER
  /* ModulePath */

  if (fileconf) {
    if (xf86ModPathFrom != X_CMDLINE && fileconf->file_modulepath) {
      xf86ModulePath = fileconf->file_modulepath;
      xf86ModPathFrom = X_CONFIG;
    }
  }

  xf86Msg(xf86ModPathFrom, "ModulePath set to \"%s\"\n", xf86ModulePath);
#endif

#if 0
  /* LogFile */
  /*
   * XXX The problem with this is that the log file is already open.
   * One option might be to copy the exiting contents to the new location.
   * and re-open it.  The down side is that the default location would
   * already have been overwritten.  Another option would be to start with
   * unique temporary location, then copy it once the correct name is known.
   * A problem with this is what happens if the server exits before that
   * happens.
   */
  if (xf86LogFileFrom == X_DEFAULT && fileconf->file_logfile) {
    xf86LogFile = fileconf->file_logfile;
    xf86LogFileFrom = X_CONFIG;
  }
#endif

  return TRUE;
}

typedef enum {
    FLAG_NOTRAPSIGNALS,
    FLAG_DONTZAP,
    FLAG_DONTZOOM,
    FLAG_DISABLEVIDMODE,
    FLAG_ALLOWNONLOCAL,
    FLAG_DISABLEMODINDEV,
    FLAG_MODINDEVALLOWNONLOCAL,
    FLAG_ALLOWMOUSEOPENFAIL,
    FLAG_VTINIT,
    FLAG_VTSYSREQ,
    FLAG_PCIPROBE1,
    FLAG_PCIPROBE2,
    FLAG_PCIFORCECONFIG1,
    FLAG_PCIFORCECONFIG2,
    FLAG_PCIOSCONFIG,
    FLAG_SAVER_BLANKTIME,
    FLAG_DPMS_STANDBYTIME,
    FLAG_DPMS_SUSPENDTIME,
    FLAG_DPMS_OFFTIME,
    FLAG_PIXMAP,
    FLAG_PC98,
    FLAG_ESTIMATE_SIZES_AGGRESSIVELY,
    FLAG_NOPM
} FlagValues;
   
static OptionInfoRec FlagOptions[] = {
  { FLAG_NOTRAPSIGNALS,		"NoTrapSignals",		OPTV_BOOLEAN,
	{0}, FALSE },
  { FLAG_DONTZAP,		"DontZap",			OPTV_BOOLEAN,
	{0}, FALSE },
  { FLAG_DONTZOOM,		"DontZoom",			OPTV_BOOLEAN,
	{0}, FALSE },
  { FLAG_DISABLEVIDMODE,	"DisableVidModeExtension",	OPTV_BOOLEAN,
	{0}, FALSE },
  { FLAG_ALLOWNONLOCAL,		"AllowNonLocalXvidtune",	OPTV_BOOLEAN,
	{0}, FALSE },
  { FLAG_DISABLEMODINDEV,	"DisableModInDev",		OPTV_BOOLEAN,
	{0}, FALSE },
  { FLAG_MODINDEVALLOWNONLOCAL,	"AllowNonLocalModInDev",	OPTV_BOOLEAN,
	{0}, FALSE },
  { FLAG_ALLOWMOUSEOPENFAIL,	"AllowMouseOpenFail",		OPTV_BOOLEAN,
	{0}, FALSE },
  { FLAG_VTINIT,		"VTInit",			OPTV_STRING,
	{0}, FALSE },
  { FLAG_VTSYSREQ,		"VTSysReq",			OPTV_BOOLEAN,
	{0}, FALSE },
  { FLAG_PCIPROBE1,		"PciProbe1"		,	OPTV_BOOLEAN,
	{0}, FALSE },
  { FLAG_PCIPROBE2,		"PciProbe2",			OPTV_BOOLEAN,
	{0}, FALSE },
  { FLAG_PCIFORCECONFIG1,	"PciForceConfig1",		OPTV_BOOLEAN,
	{0}, FALSE },
  { FLAG_PCIFORCECONFIG2,	"PciForceConfig2",		OPTV_BOOLEAN,
	{0}, FALSE },
  { FLAG_PCIOSCONFIG,	        "PciOsConfig",   		OPTV_BOOLEAN,
	{0}, FALSE },
  { FLAG_SAVER_BLANKTIME,	"BlankTime"		,	OPTV_INTEGER,
	{0}, FALSE },
  { FLAG_DPMS_STANDBYTIME,	"StandbyTime",			OPTV_INTEGER,
	{0}, FALSE },
  { FLAG_DPMS_SUSPENDTIME,	"SuspendTime",			OPTV_INTEGER,
	{0}, FALSE },
  { FLAG_DPMS_OFFTIME,		"OffTime",			OPTV_INTEGER,
	{0}, FALSE },
  { FLAG_PIXMAP,		"Pixmap",			OPTV_INTEGER,
	{0}, FALSE },
  { FLAG_PC98,			"PC98",				OPTV_BOOLEAN,
	{0}, FALSE },
  { FLAG_ESTIMATE_SIZES_AGGRESSIVELY,"EstimateSizesAggressively",OPTV_INTEGER,
	{0}, FALSE },
  { FLAG_NOPM,			"NoPM",				OPTV_BOOLEAN,
	{0}, FALSE },
  { -1,				NULL,				OPTV_NONE,
	{0}, FALSE }
};

static Bool
detectPC98(void)
{
#ifdef SUPPORT_PC98
    unsigned char buf[2];

    if (xf86ReadBIOS(0xf8000, 0xe80, buf, 2) != 2)
	return FALSE;
    if ((buf[0] == 0x98) && (buf[1] == 0x21))
	return TRUE;
    else
	return FALSE;
#else
    return FALSE;
#endif
}

static Bool
configServerFlags(XF86ConfFlagsPtr flagsconf, XF86OptionPtr layoutopts)
{
    XF86OptionPtr optp, tmp;
    int i;
    Pix24Flags pix24 = Pix24DontCare;
    Bool value;

    if(flagsconf == NULL)
	return TRUE;
    /*
     * Merge the ServerLayout and ServerFlags options.  The former have
     * precedence over the latter.
     */
    optp = NULL;
    if (flagsconf->flg_option_lst)
	optp = OptionListDup(flagsconf->flg_option_lst);
    if (layoutopts) {
	tmp = OptionListDup(layoutopts);
	if (optp)
	    optp = OptionListMerge(optp, tmp);
	else
	    optp = tmp;
    }

    xf86ProcessOptions(-1, optp, FlagOptions);

    xf86GetOptValBool(FlagOptions, FLAG_NOTRAPSIGNALS, &xf86Info.notrapSignals);
    xf86GetOptValBool(FlagOptions, FLAG_DONTZAP, &xf86Info.dontZap);
    xf86GetOptValBool(FlagOptions, FLAG_DONTZOOM, &xf86Info.dontZoom);

    /*
     * Set things up based on the config file information.  Some of these
     * settings may be overridden later when the command line options are
     * checked.
     */
#ifdef XF86VIDMODE
    if (xf86GetOptValBool(FlagOptions, FLAG_DISABLEVIDMODE, &value))
	xf86Info.vidModeEnabled = !value;
    if (xf86GetOptValBool(FlagOptions, FLAG_ALLOWNONLOCAL, &value))
	xf86Info.vidModeAllowNonLocal = value;
#endif

#ifdef XF86MISC
    if (xf86GetOptValBool(FlagOptions, FLAG_DISABLEMODINDEV, &value))
	xf86Info.miscModInDevEnabled = !value;
    if (xf86GetOptValBool(FlagOptions, FLAG_MODINDEVALLOWNONLOCAL, &value))
	xf86Info.miscModInDevAllowNonLocal = value;
#endif

    if (xf86GetOptValBool(FlagOptions, FLAG_ALLOWMOUSEOPENFAIL, &value))
	xf86Info.allowMouseOpenFail = value;

    if (xf86GetOptValBool(FlagOptions, FLAG_VTSYSREQ, &value)) {
#ifdef USE_VT_SYSREQ
	xf86Info.vtSysreq = value;
	xf86Msg(X_CONFIG, "VTSysReq enabled\n");
#else
	if (value)
	    xf86Msg(X_WARNING, "VTSysReq is not supported on this OS\n");
#endif
    }

    xf86Info.vtinit = xf86GetOptValString(FlagOptions, FLAG_VTINIT);

    if (xf86IsOptionSet(FlagOptions, FLAG_PCIPROBE1))
	xf86Info.pciFlags = PCIProbe1;
    if (xf86IsOptionSet(FlagOptions, FLAG_PCIPROBE2))
	xf86Info.pciFlags = PCIProbe2;
    if (xf86IsOptionSet(FlagOptions, FLAG_PCIFORCECONFIG1))
	xf86Info.pciFlags = PCIForceConfig1;
    if (xf86IsOptionSet(FlagOptions, FLAG_PCIFORCECONFIG2))
	xf86Info.pciFlags = PCIForceConfig2;
    if (xf86IsOptionSet(FlagOptions, FLAG_PCIOSCONFIG))
	xf86Info.pciFlags = PCIOsConfig;
    /*
     * XXX This should be handled like a proper boolean option -- see further
     * above for examples.
     */
    if (xf86IsOptionSet(FlagOptions, FLAG_NOPM))
	xf86Info.pmFlag = FALSE;
    else
	xf86Info.pmFlag = TRUE;
	
    i = -1;
    xf86GetOptValInteger(FlagOptions, FLAG_ESTIMATE_SIZES_AGGRESSIVELY, &i);
    if (i >= 0)
	xf86Info.estimateSizesAggressively = i;
    else
	xf86Info.estimateSizesAggressively = 0;
	
    i = -1;
    xf86GetOptValInteger(FlagOptions, FLAG_SAVER_BLANKTIME, &i);
    if (i >= 0)
	ScreenSaverTime = defaultScreenSaverTime = i * MILLI_PER_MIN;

#ifdef DPMSExtension
    i = -1;
    xf86GetOptValInteger(FlagOptions, FLAG_DPMS_STANDBYTIME, &i);
    if (i >= 0)
	DPMSStandbyTime = defaultDPMSStandbyTime = i * MILLI_PER_MIN;
    i = -1;
    xf86GetOptValInteger(FlagOptions, FLAG_DPMS_SUSPENDTIME, &i);
    if (i >= 0)
	DPMSSuspendTime = defaultDPMSSuspendTime = i * MILLI_PER_MIN;
    i = -1;
    xf86GetOptValInteger(FlagOptions, FLAG_DPMS_OFFTIME, &i);
    if (i >= 0)
	DPMSOffTime = defaultDPMSOffTime = i * MILLI_PER_MIN;
#endif

    i = -1;
    xf86GetOptValInteger(FlagOptions, FLAG_PIXMAP, &i);
    switch (i) {
    case 24:
	pix24 = Pix24Use24;
	break;
    case 32:
	pix24 = Pix24Use32;
	break;
    case -1:
	break;
    default:
	xf86ConfigError("Pixmap option's value (%d) must be 24 or 32\n", i);
	return FALSE;
    }
    if (xf86Pix24 != Pix24DontCare) {
	xf86Info.pixmap24 = xf86Pix24;
	xf86Info.pix24From = X_CMDLINE;
    } else if (pix24 != Pix24DontCare) {
	xf86Info.pixmap24 = pix24;
	xf86Info.pix24From = X_CONFIG;
    } else {
	xf86Info.pixmap24 = Pix24DontCare;
	xf86Info.pix24From = X_DEFAULT;
    }
#if defined(i386) || defined(__i386__)
    if (xf86GetOptValBool(FlagOptions, FLAG_PC98, &value)) {
	xf86Info.pc98 = value;
	if (value) {
	    xf86Msg(X_CONFIG, "Japanese PC98 architecture\n");
	}
    } else
	if (detectPC98()) {
	    xf86Info.pc98 = TRUE;
	    xf86Msg(X_PROBED, "Japanese PC98 architecture\n");
	}
#endif

    return TRUE;
}

/*
 * XXX This function is temporary, and will be removed when the keyboard
 * driver is converted into a regular input driver.
 */
static Bool
configInputKbd(IDevPtr inputp)
{
  char *s;
#ifdef XKB
  MessageType from = X_DEFAULT;
#endif

  /* Initialize defaults */
  xf86Info.xleds         = 0L;
  xf86Info.kbdDelay      = 500;
  xf86Info.kbdRate       = 30;
  
  xf86Info.kbdProc       = NULL;
  xf86Info.vtinit        = NULL;
  xf86Info.vtSysreq      = VT_SYSREQ_DEFAULT;
#if defined(SVR4) && defined(i386)
  xf86Info.panix106      = FALSE;
#endif
#ifdef XKB
  if (!xf86IsPc98()) {
    xf86Info.xkbrules      = "xfree86";
#ifdef SOL8
    xf86Info.xkbmodel      = "pc101_sol8x86";
#else
    xf86Info.xkbmodel      = "pc101";
#endif
    xf86Info.xkblayout     = "us";
    xf86Info.xkbvariant    = NULL;
    xf86Info.xkboptions    = NULL;
  } else {
    xf86Info.xkbrules      = "xfree98";
    xf86Info.xkbmodel      = "pc98";
    xf86Info.xkblayout     = "nec/jp";
    xf86Info.xkbvariant    = NULL;
    xf86Info.xkboptions    = NULL;
  }
  xf86Info.xkbcomponents_specified = FALSE;
  /* Should discourage the use of these. */
  xf86Info.xkbkeymap     = NULL;
  xf86Info.xkbtypes      = NULL;
  xf86Info.xkbcompat     = NULL;
  xf86Info.xkbkeycodes   = NULL;
  xf86Info.xkbsymbols    = NULL;
  xf86Info.xkbgeometry   = NULL;
#endif

  s = xf86SetStrOption(inputp->commonOptions, "Protocol", "standard");
  if (xf86NameCmp(s, "standard") == 0) {
     xf86Info.kbdProc    = xf86KbdProc;
#ifdef AMOEBA
     xf86Info.kbdEvents  = NULL;
#else
     xf86Info.kbdEvents  = xf86KbdEvents;
#endif
  } else if (xf86NameCmp(s, "xqueue") == 0) {
#ifdef XQUEUE
    xf86Info.kbdProc = xf86XqueKbdProc;
    xf86Info.kbdEvents = xf86XqueEvents;
    xf86Msg(X_CONFIG, "Xqueue selected for keyboard input\n");
#endif
  } else {
    xf86ConfigError("\"%s\" is not a valid keyboard protocol name", s);
    return FALSE;
  }

  s = xf86SetStrOption(inputp->commonOptions, "AutoRepeat", NULL);
  if (s) {
    if (sscanf(s, "%d %d", &xf86Info.kbdDelay, &xf86Info.kbdRate) != 2) {
      xf86ConfigError("\"%s\" is not a valid AutoRepeat value", s);
      return FALSE;
    }
  }
  s = xf86SetStrOption(inputp->commonOptions, "XLeds", NULL);
  if (s) {
    char *l, *end;
    unsigned int i;
    l = strtok(s, " \t\n");
    while (l) {
      i = strtoul(l, &end, 0);
      if (*end == '\0')
	xf86Info.xleds |= 1L << (i - 1);
      else {
	xf86ConfigError("\"%s\" is not a valid XLeds value", l);
	return FALSE;
      }
      l = strtok(NULL, " \t\n");
    }
  }

#ifdef XKB
  from = X_DEFAULT;
  if (noXkbExtension)
    from = X_CMDLINE;
  else if (xf86FindOption(inputp->commonOptions, "XkbDisable")) {
    noXkbExtension =
	xf86SetBoolOption(inputp->commonOptions, "XkbDisable", FALSE);
    from = X_CONFIG;
  }
  if (noXkbExtension)
    xf86Msg(from, "XKB: disabled\n");

#define NULL_IF_EMPTY(s) (s[0] ? s : NULL)

  if (!noXkbExtension && !XkbInitialMap) {
    if ((s = xf86SetStrOption(inputp->commonOptions, "XkbKeymap", NULL))) {
      xf86Info.xkbkeymap = NULL_IF_EMPTY(s);
      xf86Msg(X_CONFIG, "XKB: keymap: \"%s\" "
		"(overrides other XKB settings)\n", xf86Info.xkbkeymap);
    } else {
      if ((s = xf86SetStrOption(inputp->commonOptions, "XkbCompat", NULL))) {
	xf86Info.xkbcompat = NULL_IF_EMPTY(s);
	xf86Info.xkbcomponents_specified = TRUE;
	xf86Msg(X_CONFIG, "XKB: compat: \"%s\"\n", s);
      }

      if ((s = xf86SetStrOption(inputp->commonOptions, "XkbTypes", NULL))) {
	xf86Info.xkbtypes = NULL_IF_EMPTY(s);
	xf86Info.xkbcomponents_specified = TRUE;
	xf86Msg(X_CONFIG, "XKB: types: \"%s\"\n", s);
      }

      if ((s = xf86SetStrOption(inputp->commonOptions, "XkbKeycodes", NULL))) {
	xf86Info.xkbkeycodes = NULL_IF_EMPTY(s);
	xf86Info.xkbcomponents_specified = TRUE;
	xf86Msg(X_CONFIG, "XKB: keycodes: \"%s\"\n", s);
      }

      if ((s = xf86SetStrOption(inputp->commonOptions, "XkbGeometry", NULL))) {
	xf86Info.xkbgeometry = NULL_IF_EMPTY(s);
	xf86Info.xkbcomponents_specified = TRUE;
	xf86Msg(X_CONFIG, "XKB: geometry: \"%s\"\n", s);
      }

      if ((s = xf86SetStrOption(inputp->commonOptions, "XkbSymbols", NULL))) {
	xf86Info.xkbsymbols = NULL_IF_EMPTY(s);
	xf86Info.xkbcomponents_specified = TRUE;
	xf86Msg(X_CONFIG, "XKB: symbols: \"%s\"\n", s);
      }

      if ((s = xf86SetStrOption(inputp->commonOptions, "XkbRules", NULL))) {
	xf86Info.xkbrules = NULL_IF_EMPTY(s);
	xf86Info.xkbcomponents_specified = TRUE;
	xf86Msg(X_CONFIG, "XKB: rules: \"%s\"\n", s);
      }

      if ((s = xf86SetStrOption(inputp->commonOptions, "XkbModel", NULL))) {
	xf86Info.xkbmodel = NULL_IF_EMPTY(s);
	xf86Info.xkbcomponents_specified = TRUE;
	xf86Msg(X_CONFIG, "XKB: model: \"%s\"\n", s);
      }

      if ((s = xf86SetStrOption(inputp->commonOptions, "XkbLayout", NULL))) {
	xf86Info.xkblayout = NULL_IF_EMPTY(s);
	xf86Info.xkbcomponents_specified = TRUE;
	xf86Msg(X_CONFIG, "XKB: layout: \"%s\"\n", s);
      }

      if ((s = xf86SetStrOption(inputp->commonOptions, "XkbVariant", NULL))) {
	xf86Info.xkbvariant = NULL_IF_EMPTY(s);
	xf86Info.xkbcomponents_specified = TRUE;
	xf86Msg(X_CONFIG, "XKB: variant: \"%s\"\n", s);
      }

      if ((s = xf86SetStrOption(inputp->commonOptions, "XkbOptions", NULL))) {
	xf86Info.xkboptions = NULL_IF_EMPTY(s);
	xf86Info.xkbcomponents_specified = TRUE;
	xf86Msg(X_CONFIG, "XKB: options: \"%s\"\n", s);
      }
    }
  }
#undef NULL_IF_EMPTY
#endif
#if defined(SVR4) && defined(i386)
  if ((xf86Info.panix106 =
	xf86SetBoolOption(inputp->commonOptions, "Panix106", FALSE))) {
    xf86Msg(X_CONFIG, "PANIX106: enabled\n");
  }
#endif

  return TRUE;
}

static Bool
checkCoreInputDevices(serverLayoutPtr servlayoutp, Bool implicitLayout)
{
    Bool havePointer = FALSE, haveKeyboard = FALSE;
    Bool foundPointer = FALSE, foundKeyboard = FALSE;
    IDevPtr indp;
    IDevRec Pointer, Keyboard;
    XF86ConfInputPtr confInput;
    int count = 0;
    MessageType from = X_DEFAULT;

    /* Check if a core pointer or core keyboard is needed. */
    for (indp = servlayoutp->inputs; indp->identifier; indp++) {
	if ((indp->commonOptions &&
	     xf86FindOption(indp->commonOptions, "CorePointer")) ||
	    (indp->extraOptions &&
	     xf86FindOption(indp->extraOptions, "CorePointer"))) {
	    havePointer = TRUE;
	}
	if ((indp->commonOptions &&
	     xf86FindOption(indp->commonOptions, "CoreKeyboard")) ||
	    (indp->extraOptions &&
	     xf86FindOption(indp->extraOptions, "CoreKeyboard"))) {
	    haveKeyboard = TRUE;
	}
	count++;
    }
    if (!havePointer) {
	if (xf86PointerName) {
	    confInput = xf86FindInput(xf86PointerName,
				      xf86configptr->conf_input_lst);
	    if (!confInput) {
		xf86Msg(X_ERROR, "No InputDevice section called \"%s\"\n",
			xf86PointerName);
		return FALSE;
	    }
	    from = X_CMDLINE;
	} else {
	    from = X_DEFAULT;
	    confInput = xf86FindInput(CONF_IMPLICIT_POINTER,
				      xf86configptr->conf_input_lst);
	    if (!confInput && implicitLayout) {
		confInput = xf86FindInputByDriver("mouse",
						xf86configptr->conf_input_lst);
	    }
	}
	if (confInput)
	    foundPointer = configInput(&Pointer, confInput, from);
    }
    if (!haveKeyboard) {
	if (xf86KeyboardName) {
	    confInput = xf86FindInput(xf86KeyboardName,
				      xf86configptr->conf_input_lst);
	    if (!confInput) {
		xf86Msg(X_ERROR, "No InputDevice section called \"%s\"\n",
			xf86KeyboardName);
		return FALSE;
	    }
	    from = X_CMDLINE;
	} else {
	    from = X_DEFAULT;
	    confInput = xf86FindInput(CONF_IMPLICIT_KEYBOARD,
				      xf86configptr->conf_input_lst);
	    if (!confInput && implicitLayout) {
		confInput = xf86FindInputByDriver("keyboard",
						xf86configptr->conf_input_lst);
	    }
	}
	if (confInput)
	    foundKeyboard = configInput(&Keyboard, confInput, from);
    }
    if (foundPointer) {
	count++;
	indp = xnfrealloc(servlayoutp->inputs, (count + 1) * sizeof(IDevRec));
	indp[count - 1] = Pointer;
	indp[count - 1].extraOptions = addNewOption(NULL, "CorePointer", NULL);
	indp[count].identifier = NULL;
	servlayoutp->inputs = indp;
    } else if (!havePointer) {
	if (implicitLayout)
	    xf86Msg(X_ERROR, "Unable to find a core pointer device\n");
	else
	    xf86Msg(X_ERROR, "No core pointer device specified\n");
	return FALSE;
    }
    if (foundKeyboard) {
	count++;
	indp = xnfrealloc(servlayoutp->inputs, (count + 1) * sizeof(IDevRec));
	indp[count - 1] = Keyboard;
	indp[count - 1].extraOptions = addNewOption(NULL, "CoreKeyboard", NULL);
	indp[count].identifier = NULL;
	servlayoutp->inputs = indp;
    } else if (!haveKeyboard) {
	if (implicitLayout)
	    xf86Msg(X_ERROR, "Unable to find a core keyboard device\n");
	else
	    xf86Msg(X_ERROR, "No core keyboard device specified\n");
	return FALSE;
    }
    return TRUE;
}

/*
 * figure out which layout is active, which screens are used in that layout,
 * which drivers and monitors are used in these screens
 */
static Bool
configLayout(serverLayoutPtr servlayoutp, XF86ConfLayoutPtr conf_layout,
	     char *default_layout)
{
    XF86ConfAdjacencyPtr adjp;
    XF86ConfInactivePtr idp;
    XF86ConfInputrefPtr irp;
    int count = 0;
    int scrnum;
    XF86ConfLayoutPtr l;
    MessageType from;
    screenLayoutPtr slp;
    GDevPtr gdp;
    IDevPtr indp;
    int i = 0, j;

    if (!servlayoutp)
	return FALSE;

    /*
     * which layout section is the active one?
     *
     * If there is a -layout command line option, use that one, otherwise
     * pick the first one.
     */
    from = X_DEFAULT;
    if (xf86LayoutName != NULL)
	from = X_CMDLINE;
    else if (default_layout) {
	xf86LayoutName = default_layout;
	from = X_CONFIG;
    }
    if (xf86LayoutName != NULL) {
	if ((l = xf86FindLayout(xf86LayoutName, conf_layout)) == NULL) {
	    xf86Msg(X_ERROR, "No ServerLayout section called \"%s\"\n",
		    xf86LayoutName);
	    return FALSE;
	}
	conf_layout = l;
    }
    xf86Msg(from, "ServerLayout \"%s\"\n", conf_layout->lay_identifier);
    adjp = conf_layout->lay_adjacency_lst;

    /*
     * we know that each screen is referenced exactly once on the left side
     * of a layout statement in the Layout section. So to allocate the right
     * size for the array we do a quick walk of the list to figure out how
     * many sections we have
     */
    while (adjp) {
        count++;
        adjp = (XF86ConfAdjacencyPtr)adjp->list.next;
    }
#ifdef DEBUG
    ErrorF("Found %d screens in the layout section %s",
           count, conf_layout->lay_identifier);
#endif
    slp = xnfcalloc(1, (count + 1) * sizeof(screenLayoutRec));
    slp[count].screen = NULL;
    /*
     * now that we have storage, loop over the list again and fill in our
     * data structure; at this point we do not fill in the adjacency
     * information as it is not clear if we need it at all
     */
    adjp = conf_layout->lay_adjacency_lst;
    count = 0;
    while (adjp) {
        slp[count].screen = xnfcalloc(1, sizeof(confScreenRec));
	if (adjp->adj_scrnum < 0)
	    scrnum = count;
	else
	    scrnum = adjp->adj_scrnum;
	if (!configScreen(slp[count].screen, adjp->adj_screen, scrnum,
			  X_CONFIG))
	    return FALSE;
	slp[count].x = adjp->adj_x;
	slp[count].y = adjp->adj_y;
	slp[count].refname = adjp->adj_refscreen;
	switch (adjp->adj_where) {
	case CONF_ADJ_OBSOLETE:
	    slp[count].where = PosObsolete;
	    slp[count].topname = adjp->adj_top_str;
	    slp[count].bottomname = adjp->adj_bottom_str;
	    slp[count].leftname = adjp->adj_left_str;
	    slp[count].rightname = adjp->adj_right_str;
	    break;
	case CONF_ADJ_ABSOLUTE:
	    slp[count].where = PosAbsolute;
	    break;
	case CONF_ADJ_RIGHTOF:
	    slp[count].where = PosRightOf;
	    break;
	case CONF_ADJ_LEFTOF:
	    slp[count].where = PosLeftOf;
	    break;
	case CONF_ADJ_ABOVE:
	    slp[count].where = PosAbove;
	    break;
	case CONF_ADJ_BELOW:
	    slp[count].where = PosBelow;
	    break;
	case CONF_ADJ_RELATIVE:
	    slp[count].where = PosRelative;
	    break;
	}
        count++;
        adjp = (XF86ConfAdjacencyPtr)adjp->list.next;
    }

    /* XXX Need to tie down the upper left screen. */

    /* Fill in the refscreen and top/bottom/left/right values */
    for (i = 0; i < count; i++) {
	for (j = 0; j < count; j++) {
	    if (slp[i].refname &&
		strcmp(slp[i].refname, slp[j].screen->id) == 0) {
		slp[i].refscreen = slp[j].screen;
	    }
	    if (slp[i].topname &&
		strcmp(slp[i].topname, slp[j].screen->id) == 0) {
		slp[i].top = slp[j].screen;
	    }
	    if (slp[i].bottomname &&
		strcmp(slp[i].bottomname, slp[j].screen->id) == 0) {
		slp[i].bottom = slp[j].screen;
	    }
	    if (slp[i].leftname &&
		strcmp(slp[i].leftname, slp[j].screen->id) == 0) {
		slp[i].left = slp[j].screen;
	    }
	    if (slp[i].rightname &&
		strcmp(slp[i].rightname, slp[j].screen->id) == 0) {
		slp[i].right = slp[j].screen;
	    }
	}
    }

#ifdef LAYOUT_DEBUG
    ErrorF("Layout \"%s\"\n", conf_layout->lay_identifier);
    for (i = 0; i < count; i++) {
	ErrorF("Screen: \"%s\" (%d):\n", slp[i].screen->id,
	       slp[i].screen->screennum);
	switch (slp[i].where) {
	case PosObsolete:
	    ErrorF("\tObsolete format: \"%s\" \"%s\" \"%s\" \"%s\"\n",
		   slp[i].top, slp[i].bottom, slp[i].left, slp[i].right);
	    break;
	case PosAbsolute:
	    if (slp[i].x == -1)
		if (slp[i].screen->screennum == 0)
		    ErrorF("\tImplicitly left-most\n");
		else
		    ErrorF("\tImplicitly right of screen %d\n",
			   slp[i].screen->screennum - 1);
	    else
		ErrorF("\t%d %d\n", slp[i].x, slp[i].y);
	    break;
	case PosRightOf:
	    ErrorF("\tRight of \"%s\"\n", slp[i].refscreen->id);
	    break;
	case PosLeftOf:
	    ErrorF("\tLeft of \"%s\"\n", slp[i].refscreen->id);
	    break;
	case PosAbove:
	    ErrorF("\tAbove \"%s\"\n", slp[i].refscreen->id);
	    break;
	case PosBelow:
	    ErrorF("\tBelow \"%s\"\n", slp[i].refscreen->id);
	    break;
	case PosRelative:
	    ErrorF("\t%d %d relative to \"%s\"\n", slp[i].x, slp[i].y,
		   slp[i].refscreen->id);
	    break;
	}
    }
#endif
    /*
     * Count the number of inactive devices.
     */
    count = 0;
    idp = conf_layout->lay_inactive_lst;
    while (idp) {
        count++;
        idp = (XF86ConfInactivePtr)idp->list.next;
    }
#ifdef DEBUG
    ErrorF("Found %d inactive devices in the layout section %s",
           count, conf_layout->lay_identifier);
#endif
    gdp = xnfalloc((count + 1) * sizeof(GDevRec));
    gdp[count].identifier = NULL;
    idp = conf_layout->lay_inactive_lst;
    count = 0;
    while (idp) {
	if (!configDevice(&gdp[count], idp->inactive_device, FALSE))
	    return FALSE;
        count++;
        idp = (XF86ConfInactivePtr)idp->list.next;
    }
    /*
     * Count the number of input devices.
     */
    count = 0;
    irp = conf_layout->lay_input_lst;
    while (irp) {
        count++;
        irp = (XF86ConfInputrefPtr)irp->list.next;
    }
#ifdef DEBUG
    ErrorF("Found %d input devices in the layout section %s",
           count, conf_layout->lay_identifier);
#endif
    indp = xnfalloc((count + 1) * sizeof(IDevRec));
    indp[count].identifier = NULL;
    irp = conf_layout->lay_input_lst;
    count = 0;
    while (irp) {
	if (!configInput(&indp[count], irp->iref_inputdev, X_CONFIG))
	    return FALSE;
	indp[count].extraOptions = irp->iref_option_lst;
        count++;
        irp = (XF86ConfInputrefPtr)irp->list.next;
    }
    servlayoutp->id = conf_layout->lay_identifier;
    servlayoutp->screens = slp;
    servlayoutp->inactives = gdp;
    servlayoutp->inputs = indp;
    servlayoutp->options = conf_layout->lay_option_lst;
    from = X_DEFAULT;
#ifdef PANORAMIX
    if (!noPanoramiXExtension)
      from = X_CMDLINE;
    else if (xf86FindOption(conf_layout->lay_option_lst, "Xinerama")) {
      noPanoramiXExtension =
	  !xf86SetBoolOption(conf_layout->lay_option_lst, "Xinerama", FALSE);
      from = X_CONFIG;
    }
    if (!noPanoramiXExtension)
      xf86Msg(from, "Xinerama: enabled\n");
#endif

    if (!checkCoreInputDevices(servlayoutp, FALSE))
	return FALSE;
    return TRUE;
}

/*
 * No layout section, so find the first Screen section and set that up as
 * the only active screen.
 */
static Bool
configImpliedLayout(serverLayoutPtr servlayoutp, XF86ConfScreenPtr conf_screen)
{
    MessageType from;
    XF86ConfScreenPtr s;
    screenLayoutPtr slp;
    IDevPtr indp;

    if (!servlayoutp)
	return FALSE;

    if (conf_screen == NULL) {
	xf86ConfigError("No Screen sections present\n");
	return FALSE;
    }

    /*
     * which screen section is the active one?
     *
     * If there is a -screen option, use that one, otherwise use the first
     * one.
     */

    from = X_CONFIG;
    if (xf86ScreenName != NULL) {
	if ((s = xf86FindScreen(xf86ScreenName, conf_screen)) == NULL) {
	    xf86Msg(X_ERROR, "No Screen section called \"%s\"\n",
		    xf86ScreenName);
	    return FALSE;
	}
	conf_screen = s;
	from = X_CMDLINE;
    }

    /* We have exactly one screen */

    slp = xnfcalloc(1, 2 * sizeof(screenLayoutRec));
    slp[0].screen = xnfcalloc(1, sizeof(confScreenRec));
    slp[1].screen = NULL;
    if (!configScreen(slp[0].screen, conf_screen, 0, from))
	return FALSE;
    servlayoutp->id = "(implicit)";
    servlayoutp->screens = slp;
    servlayoutp->inactives = xnfcalloc(1, sizeof(GDevRec));
    servlayoutp->options = NULL;
    /* Set up an empty input device list, then look for some core devices. */
    indp = xnfalloc(sizeof(IDevRec));
    indp->identifier = NULL;
    servlayoutp->inputs = indp;
    if (!checkCoreInputDevices(servlayoutp, TRUE))
	return FALSE;
    
    return TRUE;
}

static Bool
configXvAdaptor(confXvAdaptorPtr adaptor, XF86ConfVideoAdaptorPtr conf_adaptor)
{
    int count = 0;
    XF86ConfVideoPortPtr conf_port;

    xf86Msg(X_CONFIG, "|   |-->VideoAdaptor \"%s\"\n",
	    conf_adaptor->va_identifier);
    adaptor->identifier = conf_adaptor->va_identifier;
    adaptor->options = conf_adaptor->va_option_lst;
    if (conf_adaptor->va_busid || conf_adaptor->va_driver) {
	xf86Msg(X_CONFIG, "|   | Unsupported device type, skipping entry\n");
	return FALSE;
    }

    /*
     * figure out how many videoport subsections there are and fill them in
     */
    conf_port = conf_adaptor->va_port_lst;
    while(conf_port) {
        count++;
        conf_port = (XF86ConfVideoPortPtr)conf_port->list.next;
    }
    adaptor->ports = xnfalloc((count) * sizeof(confXvPortRec));
    adaptor->numports = count;
    count = 0;
    conf_port = conf_adaptor->va_port_lst;
    while(conf_port) {
	adaptor->ports[count].identifier = conf_port->vp_identifier;
	adaptor->ports[count].options = conf_port->vp_option_lst;
        count++;
        conf_port = (XF86ConfVideoPortPtr)conf_port->list.next;
    }

    return TRUE;
}

static Bool
configScreen(confScreenPtr screenp, XF86ConfScreenPtr conf_screen, int scrnum,
	     MessageType from)
{
    int count = 0;
    XF86ConfDisplayPtr dispptr;
    XF86ConfAdaptorLinkPtr conf_adaptor;

    xf86Msg(from, "|-->Screen \"%s\" (%d)\n", conf_screen->scrn_identifier,
	    scrnum);
    /*
     * now we fill in the elements of the screen
     */
    screenp->id         = conf_screen->scrn_identifier;
    screenp->screennum  = scrnum;
    screenp->defaultdepth = conf_screen->scrn_defaultdepth;
    screenp->defaultbpp = conf_screen->scrn_defaultbpp;
    screenp->defaultfbbpp = conf_screen->scrn_defaultfbbpp;
    screenp->monitor    = xnfcalloc(1, sizeof(MonRec));
    if (!configMonitor(screenp->monitor,conf_screen->scrn_monitor))
	return FALSE;
    screenp->device     = xnfcalloc(1, sizeof(GDevRec));
    configDevice(screenp->device,conf_screen->scrn_device, TRUE);
    screenp->device->myScreenSection = screenp;
    screenp->options = conf_screen->scrn_option_lst;
    
    /*
     * figure out how many display subsections there are and fill them in
     */
    dispptr = conf_screen->scrn_display_lst;
    while(dispptr) {
        count++;
        dispptr = (XF86ConfDisplayPtr)dispptr->list.next;
    }
    screenp->displays   = xnfalloc((count) * sizeof(DispRec));
    screenp->numdisplays = count;
    count = 0;
    dispptr = conf_screen->scrn_display_lst;
    while(dispptr) {
        configDisplay(&(screenp->displays[count]),dispptr);
        count++;
        dispptr = (XF86ConfDisplayPtr)dispptr->list.next;
    }

    /*
     * figure out how many videoadaptor references there are and fill them in
     */
    conf_adaptor = conf_screen->scrn_adaptor_lst;
    while(conf_adaptor) {
        count++;
        conf_adaptor = (XF86ConfAdaptorLinkPtr)conf_adaptor->list.next;
    }
    screenp->xvadaptors = xnfalloc((count) * sizeof(confXvAdaptorRec));
    screenp->numxvadaptors = 0;
    conf_adaptor = conf_screen->scrn_adaptor_lst;
    while(conf_adaptor) {
        if (configXvAdaptor(&(screenp->xvadaptors[screenp->numxvadaptors]),
			    conf_adaptor->al_adaptor))
    	    screenp->numxvadaptors++;
        conf_adaptor = (XF86ConfAdaptorLinkPtr)conf_adaptor->list.next;
    }

    return TRUE;
}

static Bool
configMonitor(MonPtr monitorp, XF86ConfMonitorPtr conf_monitor)
{
    int count;
    DisplayModePtr mode,last = NULL;
    XF86ConfModeLinePtr cmodep;
    XF86ConfModesPtr modes;
    XF86ConfModesLinkPtr modeslnk = conf_monitor->mon_modes_sect_lst;
    Gamma zeros = {0.0, 0.0, 0.0};
    float badgamma = 0.0;
    
    xf86Msg(X_CONFIG, "|   |-->Monitor \"%s\"\n",
	    conf_monitor->mon_identifier);
    monitorp->id = conf_monitor->mon_identifier;
    monitorp->vendor = conf_monitor->mon_vendor;
    monitorp->model = conf_monitor->mon_modelname;
    monitorp->Modes = NULL;
    monitorp->Last = NULL;
    monitorp->gamma = zeros;
    monitorp->widthmm = conf_monitor->mon_width;
    monitorp->heightmm = conf_monitor->mon_height;
    monitorp->options = conf_monitor->mon_option_lst;

    /*
     * fill in the monitor structure
     */    
    for( count = 0 ; count < conf_monitor->mon_n_hsync; count++) {
        monitorp->hsync[count].hi = conf_monitor->mon_hsync[count].hi;
        monitorp->hsync[count].lo = conf_monitor->mon_hsync[count].lo;
    }
    monitorp->nHsync = conf_monitor->mon_n_hsync;
    for( count = 0 ; count < conf_monitor->mon_n_vrefresh; count++) {
        monitorp->vrefresh[count].hi = conf_monitor->mon_vrefresh[count].hi;
        monitorp->vrefresh[count].lo = conf_monitor->mon_vrefresh[count].lo;
    }
    monitorp->nVrefresh = conf_monitor->mon_n_vrefresh;

    /*
     * first we collect the mode lines from the UseModes directive
     */
    while(modeslnk)
    {
	modes = xf86FindModes (modeslnk->ml_modes_str, 
			       xf86configptr->conf_modes_lst);
	modeslnk->ml_modes = modes;
	    
	/* now add the modes found in the modes
	   section to the list of modes for this
	   monitor */
	conf_monitor->mon_modeline_lst = (XF86ConfModeLinePtr)
	    addListItem((GenericListPtr)conf_monitor->mon_modeline_lst,
			(GenericListPtr)modes->mon_modeline_lst);
	modeslnk = modeslnk->list.next;
    }

    /*
     * we need to hook in the mode lines now
     * here both data structures use lists, only our internal one
     * is double linked
     */
    cmodep = conf_monitor->mon_modeline_lst;
    while( cmodep ) {
        mode = xnfalloc(sizeof(DisplayModeRec));
        memset(mode,'\0',sizeof(DisplayModeRec));
	mode->type       = 0;
        mode->Clock      = cmodep->ml_clock;
        mode->HDisplay   = cmodep->ml_hdisplay;
        mode->HSyncStart = cmodep->ml_hsyncstart;
        mode->HSyncEnd   = cmodep->ml_hsyncend;
        mode->HTotal     = cmodep->ml_htotal;
        mode->VDisplay   = cmodep->ml_vdisplay;
        mode->VSyncStart = cmodep->ml_vsyncstart;
        mode->VSyncEnd   = cmodep->ml_vsyncend;
        mode->VTotal     = cmodep->ml_vtotal;
        mode->Flags      = cmodep->ml_flags;
        mode->HSkew      = cmodep->ml_hskew;
        mode->VScan      = cmodep->ml_vscan;
        mode->name       = xnfstrdup(cmodep->ml_identifier);
        if( last ) {
            mode->prev = last;
            last->next = mode;
        }
        else {
            /*
             * this is the first mode
             */
            monitorp->Modes = mode;
            mode->prev = NULL;
        }
        last = mode;
        cmodep = (XF86ConfModeLinePtr)cmodep->list.next;
    }
    if(last){
      last->next = NULL;
    }
    monitorp->Last = last;

    /* add the (VESA) default modes */
    if (! addDefaultModes(monitorp) )
	return FALSE;

    if (conf_monitor->mon_gamma_red > GAMMA_ZERO)
	monitorp->gamma.red = conf_monitor->mon_gamma_red;
    if (conf_monitor->mon_gamma_green > GAMMA_ZERO)
	monitorp->gamma.green = conf_monitor->mon_gamma_green;
    if (conf_monitor->mon_gamma_blue > GAMMA_ZERO)
	monitorp->gamma.blue = conf_monitor->mon_gamma_blue;
    
    /* Check that the gamma values are within range */
    if (monitorp->gamma.red > GAMMA_ZERO &&
	(monitorp->gamma.red < GAMMA_MIN ||
	 monitorp->gamma.red > GAMMA_MAX)) {
	badgamma = monitorp->gamma.red;
    } else if (monitorp->gamma.green > GAMMA_ZERO &&
	(monitorp->gamma.green < GAMMA_MIN ||
	 monitorp->gamma.green > GAMMA_MAX)) {
	badgamma = monitorp->gamma.green;
    } else if (monitorp->gamma.blue > GAMMA_ZERO &&
	(monitorp->gamma.blue < GAMMA_MIN ||
	 monitorp->gamma.blue > GAMMA_MAX)) {
	badgamma = monitorp->gamma.blue;
    }
    if (badgamma > GAMMA_ZERO) {
	xf86ConfigError("Gamma value %.f is out of range (%.2f - %.1f)\n",
			badgamma, GAMMA_MIN, GAMMA_MAX);
	    return FALSE;
    }

    return TRUE;
}

static int
lookupVisual(const char *visname)
{
    int i;

    if (!visname || !*visname)
	return -1;

    for (i = 0; i <= DirectColor; i++) {
	if (!NameCompare(visname, xf86VisualNames[i]))
	    break;
    }

    if (i <= DirectColor)
	return i;

    return -1;
}


static Bool
configDisplay(DispPtr displayp, XF86ConfDisplayPtr conf_display)
{
    int count = 0;
    XF86ModePtr modep;
    
    displayp->frameX0           = conf_display->disp_frameX0;
    displayp->frameY0           = conf_display->disp_frameY0;
    displayp->virtualX          = conf_display->disp_virtualX;
    displayp->virtualY          = conf_display->disp_virtualY;
    displayp->depth             = conf_display->disp_depth;
    displayp->fbbpp             = conf_display->disp_bpp;
    displayp->weight.red        = conf_display->disp_weight.red;
    displayp->weight.green      = conf_display->disp_weight.green;
    displayp->weight.blue       = conf_display->disp_weight.blue;
    displayp->blackColour.red   = conf_display->disp_black.red;
    displayp->blackColour.green = conf_display->disp_black.green;
    displayp->blackColour.blue  = conf_display->disp_black.blue;
    displayp->whiteColour.red   = conf_display->disp_white.red;
    displayp->whiteColour.green = conf_display->disp_white.green;
    displayp->whiteColour.blue  = conf_display->disp_white.blue;
    displayp->options           = conf_display->disp_option_lst;
    if (conf_display->disp_visual) {
	displayp->defaultVisual = lookupVisual(conf_display->disp_visual);
	if (displayp->defaultVisual == -1) {
	    xf86ConfigError("Invalid visual name: \"%s\"",
			    conf_display->disp_visual);
	    return FALSE;
	}
    } else {
	displayp->defaultVisual = -1;
    }
	
    /*
     * now hook in the modes
     */
    modep = conf_display->disp_mode_lst;
    while(modep) {
        count++;
        modep = (XF86ModePtr)modep->list.next;
    }
    displayp->modes = xnfalloc((count+1) * sizeof(char*));
    modep = conf_display->disp_mode_lst;
    count = 0;
    while(modep) {
        displayp->modes[count] = modep->mode_name;
        count++;
        modep = (XF86ModePtr)modep->list.next;
    }
    displayp->modes[count] = NULL;
    
    return TRUE;
}

static Bool
configDevice(GDevPtr devicep, XF86ConfDevicePtr conf_device, Bool active)
{
    int i;

    if (active)
	xf86Msg(X_CONFIG, "|   |-->Device \"%s\"\n",
		conf_device->dev_identifier);
    else
	xf86Msg(X_CONFIG, "|-->Inactive Device \"%s\"\n",
		conf_device->dev_identifier);
	
    devicep->identifier = conf_device->dev_identifier;
    devicep->vendor = conf_device->dev_vendor;
    devicep->board = conf_device->dev_board;
    devicep->chipset = conf_device->dev_chipset;
    devicep->ramdac = conf_device->dev_ramdac;
    devicep->driver = conf_device->dev_driver;
    devicep->active = active;
    devicep->videoRam = conf_device->dev_videoram;
    devicep->BiosBase = conf_device->dev_bios_base;
    devicep->MemBase = conf_device->dev_mem_base;
    devicep->IOBase = conf_device->dev_io_base;
    devicep->clockchip = conf_device->dev_clockchip;
    devicep->busID = conf_device->dev_busid;
    devicep->textClockFreq = conf_device->dev_textclockfreq;
    devicep->chipID = conf_device->dev_chipid;
    devicep->chipRev = conf_device->dev_chiprev;
    devicep->options = conf_device->dev_option_lst;
    devicep->irq = conf_device->dev_irq;
    devicep->screen = conf_device->dev_screen;

    for (i = 0; i < MAXDACSPEEDS; i++) {
	if (i < CONF_MAXDACSPEEDS)
            devicep->dacSpeeds[i] = conf_device->dev_dacSpeeds[i];
	else
	    devicep->dacSpeeds[i] = 0;
    }
    devicep->numclocks = conf_device->dev_clocks;
    if (devicep->numclocks > MAXCLOCKS)
	devicep->numclocks = MAXCLOCKS;
    for (i = 0; i < devicep->numclocks; i++) {
	devicep->clock[i] = conf_device->dev_clock[i];
    }
    devicep->claimed = FALSE;

    return TRUE;
}

#ifdef XF86DRI
static Bool
configDRI(XF86ConfDRIPtr drip)
{
    int                count = 0;
    XF86ConfBuffersPtr bufs;
    int                i;
    struct group       *grp;

    xf86ConfigDRI.group      = -1;
    xf86ConfigDRI.mode       = 0;
    xf86ConfigDRI.bufs_count = 0;
    xf86ConfigDRI.bufs       = NULL;

    if (drip) {
	if (drip->dri_group_name) {
	    if ((grp = getgrnam(drip->dri_group_name)))
		xf86ConfigDRI.group = grp->gr_gid;
	} else {
	    if (drip->dri_group >= 0)
		xf86ConfigDRI.group = drip->dri_group;
	}
	xf86ConfigDRI.mode = drip->dri_mode;
	for (bufs = drip->dri_buffers_lst; bufs; bufs = bufs->list.next)
	    ++count;
	
	xf86ConfigDRI.bufs_count = count;
	xf86ConfigDRI.bufs = xnfalloc(count * sizeof(*xf86ConfigDRI.bufs));
	
	for (i = 0, bufs = drip->dri_buffers_lst;
	     i < count;
	     i++, bufs = bufs->list.next) {
	    
	    xf86ConfigDRI.bufs[i].count = bufs->buf_count;
	    xf86ConfigDRI.bufs[i].size  = bufs->buf_size;
				/* FIXME: Flags not implemented.  These
                                   could be used, for example, to specify a
                                   contiguous block and/or write-combining
                                   cache policy. */
	    xf86ConfigDRI.bufs[i].flags = 0;
	}
    }

    return TRUE;
}
#endif

static Bool
configInput(IDevPtr inputp, XF86ConfInputPtr conf_input, MessageType from)
{
    xf86Msg(from, "|-->Input Device \"%s\"\n", conf_input->inp_identifier);
    inputp->identifier = conf_input->inp_identifier;
    inputp->driver = conf_input->inp_driver;
    inputp->commonOptions = conf_input->inp_option_lst;
    inputp->extraOptions = NULL;

    /* XXX This is required until the keyboard driver is converted */
    if (!xf86NameCmp(inputp->driver, "keyboard"))
	return configInputKbd(inputp);

    return TRUE;
}
	
static Bool
modeIsPresent(char * modename,MonPtr monitorp)
{
    DisplayModePtr knownmodes = monitorp->Modes;

    /* all I can think of is a linear search... */
    while(knownmodes != NULL)
    {
	if(strcmp(modename,knownmodes->name) == 0)
	    return TRUE;
	knownmodes = knownmodes->next;
    }
    return FALSE;
}

static Bool
addDefaultModes(MonPtr monitorp)
{
    DisplayModePtr mode;
    DisplayModePtr last = monitorp->Last;
    int i = 0;

    while (xf86DefaultModes[i].name != NULL)
    {
	if ( ! modeIsPresent(xf86DefaultModes[i].name,monitorp) )
	    do
	    {
		mode = xnfalloc(sizeof(DisplayModeRec));
		memcpy(mode,&xf86DefaultModes[i],sizeof(DisplayModeRec));
		if (xf86DefaultModes[i].name)
		    mode->name = xnfstrdup(xf86DefaultModes[i].name);
		if( last ) {
		    mode->prev = last;
		    last->next = mode;
		}
		else {
		    /* this is the first mode */
		    monitorp->Modes = mode;
		    mode->prev = NULL;
		}
		last = mode;
		i++;
	    }
	    while((xf86DefaultModes[i].name != NULL) &&
		  (!strcmp(xf86DefaultModes[i].name,xf86DefaultModes[i-1].name)));
	else
	    i++;
    }
    monitorp->Last = last;

    return TRUE;
}

/*
 * load the config file and fill the global data structure
 */
Bool
xf86HandleConfigFile(void)
{
    const char *filename;
    char *searchpath;
    MessageType from = X_DEFAULT;

    if (getuid() == 0)
	searchpath = ROOT_CONFIGPATH;
    else
	searchpath = USER_CONFIGPATH;

    if (xf86ConfigFile)
	from = X_CMDLINE;

    filename = xf86OpenConfigFile(searchpath, xf86ConfigFile, PROJECTROOT);
    if (filename) {
	xf86MsgVerb(from, 0, "Using config file: \"%s\"\n", filename);
    } else {
	xf86Msg(X_ERROR, "Unable to locate/open config file");
	if (xf86ConfigFile)
	    xf86ErrorFVerb(0, ": \"%s\"", xf86ConfigFile);
	xf86ErrorFVerb(0, "\n");
	return FALSE;
    }
    if ((xf86configptr = xf86ReadConfigFile ()) == NULL) {
	xf86Msg(X_ERROR, "Problem parsing the config file\n");
	return FALSE;
    }
    xf86CloseConfigFile ();

    /* Initialise a few things. */

    /* Show what the marker symbols mean */
    xf86ErrorF("Markers: " X_PROBE_STRING " probed, "
			   X_CONFIG_STRING " from config file, "
			   X_DEFAULT_STRING " default setting,\n"
	       "         " X_CMDLINE_STRING " from command line, "
			   X_NOTICE_STRING " notice, "
			   X_INFO_STRING " informational,\n"
	       "         " X_WARNING_STRING " warning, "
			   X_ERROR_STRING " error, "
			   X_UNKNOWN_STRING " unknown.\n");

    /*
     * now we convert part of the information contained in the parser
     * structures into our own structures.
     * The important part here is to figure out which Screen Sections
     * in the XF86Config file are active so that we can piece together
     * the modes that we need later down the road.
     * And while we are at it, we'll decode the rest of the stuff as well
     */

    /* First check if a layout section is present, and if it is valid. */

    if (xf86configptr->conf_layout_lst == NULL || xf86ScreenName != NULL) {
	if (xf86ScreenName == NULL) {
	    xf86Msg(X_WARNING,
		    "No Layout section.  Using the first Screen section.\n");
	}
	if (!configImpliedLayout(&xf86ConfigLayout,
				 xf86configptr->conf_screen_lst)) {
            xf86Msg(X_ERROR, "Unable to determine the screen layout\n");
	    return FALSE;
	}
    } else {
	if (xf86configptr->conf_flags != NULL) {
	  char *dfltlayout = NULL;
 	  pointer optlist = xf86configptr->conf_flags->flg_option_lst;
	
	  if (optlist && xf86FindOption(optlist, "defaultserverlayout"))
	    dfltlayout = xf86SetStrOption(optlist, "defaultserverlayout", NULL);
	  if (!configLayout(&xf86ConfigLayout, xf86configptr->conf_layout_lst,
			  dfltlayout)) {
	    xf86Msg(X_ERROR, "Unable to determine the screen layout\n");
	    return FALSE;
	  }
	} else {
	  if (!configLayout(&xf86ConfigLayout, xf86configptr->conf_layout_lst,
			  NULL)) {
	    xf86Msg(X_ERROR, "Unable to determine the screen layout\n");
	    return FALSE;
	  }
	}
    }

    /* Now process everything else */

    if (!configFiles(xf86configptr->conf_files) ||
        !configServerFlags(xf86configptr->conf_flags,
			   xf86ConfigLayout.options)
#ifdef XF86DRI
	|| !configDRI(xf86configptr->conf_dri)
#endif
       ) {
             ErrorF ("Problem when converting the config data structures\n");
             return FALSE;
    }

    /*
     * Handle some command line options that can override some of the
     * ServerFlags settings.
     */
#ifdef XF86VIDMODE
    if (xf86VidModeDisabled)
	xf86Info.vidModeEnabled = FALSE;
    if (xf86VidModeAllowNonLocal)
	xf86Info.vidModeAllowNonLocal = TRUE;
#endif

#ifdef XF86MISC
    if (xf86MiscModInDevDisabled)
	xf86Info.miscModInDevEnabled = FALSE;
    if (xf86MiscModInDevAllowNonLocal)
	xf86Info.miscModInDevAllowNonLocal = TRUE;
#endif

    if (xf86AllowMouseOpenFail)
	xf86Info.allowMouseOpenFail = TRUE;

    return TRUE;
}


/* These make the equivalent parser functions visible to the common layer. */
Bool
xf86PathIsAbsolute(const char *path)
{
    return (PathIsAbsolute(path) != 0);
}

Bool
xf86PathIsSafe(const char *path)
{
    return (PathIsSafe(path) != 0);
}

