#!/usr/bin/perl

# automatically generate the xf86DefaultModes.c file from a normal
# XF86Config style file of Modelines
#
# run as 
#
# perl /modeline2c.pl < [modesfile] > xf86DefModes.c
#
# hackish perl - author Dirk Hohndel
# Copyright 1999 by The XFree86 Project, Inc.
#
# $XFree86: xc/programs/Xserver/hw/xfree86/common/modeline2c.pl,v 1.3 1999/11/18 16:52:06 tsi Exp $

my %flagshash;
$flagshash{""} = "0";
# $flagshash{"Interlace"} = "V_INTERLACE";
# $flagshash{"+hsync"} = "V_PHSYNC";
# $flagshash{"-hsync"} = "V_NHSYNC";
# $flagshash{"+vsync"} = "V_PVSYNC";
# $flagshash{"-vsync"} = "V_NVSYNC";
# XXX I'm definitely not a perl guru...   -- tsi
$flagshash{"+hsync +vsync"} = "V_PHSYNC | V_PVSYNC";
$flagshash{"+hsync -vsync"} = "V_PHSYNC | V_NVSYNC";
$flagshash{"-hsync +vsync"} = "V_NHSYNC | V_PVSYNC";
$flagshash{"-hsync -vsync"} = "V_NHSYNC | V_NVSYNC";
$flagshash{"+hsync +vsync Interlace"} = "V_PHSYNC | V_PVSYNC | V_INTERLACE";
$flagshash{"+hsync -vsync Interlace"} = "V_PHSYNC | V_NVSYNC | V_INTERLACE";
$flagshash{"-hsync +vsync Interlace"} = "V_NHSYNC | V_PVSYNC | V_INTERLACE";
$flagshash{"-hsync -vsync Interlace"} = "V_NHSYNC | V_NVSYNC | V_INTERLACE";

# stop CVS from expanding the XFree86 Id here...

my $proj = "XFree86";
printf("/* \$$proj: \$ */

/* THIS FILE IS AUTOMATICALLY GENERATED -- DO NOT EDIT -- LOOK at
 * modeline2c.pl */

/*
 * Copyright 1999 by The XFree86 Project, Inc.
 *
 * Author: Dirk Hohndel <hohndel\@XFree86.Org>
 */

#include \"xf86.h\"
#include \"xf86Config.h\"
#define NO_COMPILER_H_EXTRAS
#include \"xf86Priv.h\"
#include \"xf86_OSlib.h\"

#include \"globals.h\"

#define MODEPREFIX(name) NULL, NULL, name, 0,M_T_DEFAULT
#define MODESUFFIX       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,FALSE,FALSE,0,NULL,0,0.0,0.0

DisplayModeRec xf86DefaultModes [] = {
");
while (<>) {
  if (/^\#/) {
    s/^\#//;
    chop;
    print "/*" . $_ . " */\n";
  }
  if (/^ModeLine\s+(\S+)\s+([\d.\s]+)(.*)/) {
    my $name = $1;
    my $values = $2;
    my $flags = $3;
    $values =~ /([\d.]+)\s+(\d+)\s+(\d+)\s+(\d+)\s+(\d+)\s+(\d+)\s+(\d+)\s+(\d+)\s+(\d+)/;
    printf("\t{MODEPREFIX(%s),%d, %d,%d,%d,%d,0, %d,%d,%d,%d,0, %s, MODESUFFIX},\n",
	   $name,$1*1000,$2,$3,$4,$5,$6,$7,$8,$9,$flagshash{$flags});
  }


}
printf("\t{MODEPREFIX(NULL),0,0,0,0,0,0,0,0,0,0,0,0,MODESUFFIX}\n};\n");
