/*
 * Id: kcolor.c,v 1.1 1999/11/02 03:54:46 keithp Exp $
 *
 * Copyright  1999 Keith Packard
 *
 * Permission to use, copy, modify, distribute, and sell this software and its
 * documentation for any purpose is hereby granted without fee, provided that
 * the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of Keith Packard not be used in
 * advertising or publicity pertaining to distribution of the software without
 * specific, written prior permission.  Keith Packard makes no
 * representations about the suitability of this software for any purpose.  It
 * is provided "as is" without express or implied warranty.
 *
 * KEITH PACKARD DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
 * EVENT SHALL KEITH PACKARD BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 */
/* $XFree86: xc/programs/Xserver/hw/kdrive/kcolor.c,v 1.3 2000/02/23 20:29:52 dawes Exp $ */

#include "kdrive.h"
#include <stdio.h>
#include "os.h"
#include "opaque.h"
#include <X11/keysym.h>

unsigned char
KdToLower (unsigned char a)
{
    if ((a >= XK_A) && (a <= XK_Z))
	return a + (XK_a - XK_A);
    else if ((a >= XK_Agrave) && (a <= XK_Odiaeresis))
	return a + (XK_agrave - XK_Agrave);
    else if ((a >= XK_Ooblique) && (a <= XK_Thorn))
	return a + (XK_oslash - XK_Ooblique);
    else
	return a;
}

int
KdStrCaseCmp (const unsigned char *s1, const unsigned char *s2, int l2)
{
    unsigned char   c1, c2;

    for (;;)
    {
	c1 = KdToLower (*s1++);
	if (l2 == 0)
	    c2 = '\0';
	else
	    c2 = KdToLower (*s2++);
	if (!c1 || !c2)
	    break;
	if (c1 != c2)
	    break;
	l2--;
    }
    return c2 - c1;
}

typedef struct _kdNamedColor {
    unsigned short	red;
    unsigned short	green;
    unsigned short	blue;
    const unsigned char	*name;
} KdNamedColor;

#define C   0x101

const KdNamedColor KdColors[] = {
240*C, 248*C, 255*C, "alice blue",
240*C, 248*C, 255*C, "AliceBlue",
250*C, 235*C, 215*C, "antique white",
250*C, 235*C, 215*C, "AntiqueWhite",
255*C, 239*C, 219*C, "AntiqueWhite1",
238*C, 223*C, 204*C, "AntiqueWhite2",
205*C, 192*C, 176*C, "AntiqueWhite3",
139*C, 131*C, 120*C, "AntiqueWhite4",
127*C, 255*C, 212*C, "aquamarine",
127*C, 255*C, 212*C, "aquamarine1",
118*C, 238*C, 198*C, "aquamarine2",
102*C, 205*C, 170*C, "aquamarine3",
 69*C, 139*C, 116*C, "aquamarine4",
240*C, 255*C, 255*C, "azure",
240*C, 255*C, 255*C, "azure1",
224*C, 238*C, 238*C, "azure2",
193*C, 205*C, 205*C, "azure3",
131*C, 139*C, 139*C, "azure4",
245*C, 245*C, 220*C, "beige",
255*C, 228*C, 196*C, "bisque",
255*C, 228*C, 196*C, "bisque1",
238*C, 213*C, 183*C, "bisque2",
205*C, 183*C, 158*C, "bisque3",
139*C, 125*C, 107*C, "bisque4",
  0*C,   0*C,   0*C, "black",
255*C, 235*C, 205*C, "blanched almond",
255*C, 235*C, 205*C, "BlanchedAlmond",
  0*C,   0*C, 255*C, "blue",
138*C,  43*C, 226*C, "blue violet",
  0*C,   0*C, 255*C, "blue1",
  0*C,   0*C, 238*C, "blue2",
  0*C,   0*C, 205*C, "blue3",
  0*C,   0*C, 139*C, "blue4",
138*C,  43*C, 226*C, "BlueViolet",
165*C,  42*C,  42*C, "brown",
255*C, 64*C, 64*C, "brown1",
238*C, 59*C, 59*C, "brown2",
205*C, 51*C, 51*C, "brown3",
139*C, 35*C, 35*C, "brown4",
222*C, 184*C, 135*C, "burlywood",
255*C, 211*C, 155*C, "burlywood1",
238*C, 197*C, 145*C, "burlywood2",
205*C, 170*C, 125*C, "burlywood3",
139*C, 115*C, 85*C, "burlywood4",
 95*C, 158*C, 160*C, "cadet blue",
 95*C, 158*C, 160*C, "CadetBlue",
152*C, 245*C, 255*C, "CadetBlue1",
142*C, 229*C, 238*C, "CadetBlue2",
122*C, 197*C, 205*C, "CadetBlue3",
 83*C, 134*C, 139*C, "CadetBlue4",
127*C, 255*C,   0*C, "chartreuse",
127*C, 255*C, 0*C, "chartreuse1",
118*C, 238*C, 0*C, "chartreuse2",
102*C, 205*C, 0*C, "chartreuse3",
69*C, 139*C, 0*C, "chartreuse4",
210*C, 105*C,  30*C, "chocolate",
255*C, 127*C, 36*C, "chocolate1",
238*C, 118*C, 33*C, "chocolate2",
205*C, 102*C, 29*C, "chocolate3",
139*C, 69*C, 19*C, "chocolate4",
255*C, 127*C,  80*C, "coral",
255*C, 114*C, 86*C, "coral1",
238*C, 106*C, 80*C, "coral2",
205*C, 91*C, 69*C, "coral3",
139*C, 62*C, 47*C, "coral4",
100*C, 149*C, 237*C, "cornflower blue",
100*C, 149*C, 237*C, "CornflowerBlue",
255*C, 248*C, 220*C, "cornsilk",
255*C, 248*C, 220*C, "cornsilk1",
238*C, 232*C, 205*C, "cornsilk2",
205*C, 200*C, 177*C, "cornsilk3",
139*C, 136*C, 120*C, "cornsilk4",
  0*C, 255*C, 255*C, "cyan",
  0*C, 255*C, 255*C, "cyan1",
  0*C, 238*C, 238*C, "cyan2",
  0*C, 205*C, 205*C, "cyan3",
  0*C, 139*C, 139*C, "cyan4",
0*C,   0*C, 139*C, "dark blue",
0*C, 139*C, 139*C, "dark cyan",
184*C, 134*C,  11*C, "dark goldenrod",
169*C, 169*C, 169*C, "dark gray",
  0*C, 100*C,   0*C, "dark green",
169*C, 169*C, 169*C, "dark grey",
189*C, 183*C, 107*C, "dark khaki",
139*C,   0*C, 139*C, "dark magenta",
 85*C, 107*C,  47*C, "dark olive green",
255*C, 140*C,   0*C, "dark orange",
153*C,  50*C, 204*C, "dark orchid",
139*C,   0*C,   0*C, "dark red",
233*C, 150*C, 122*C, "dark salmon",
143*C, 188*C, 143*C, "dark sea green",
 72*C,  61*C, 139*C, "dark slate blue",
 47*C,  79*C,  79*C, "dark slate gray",
 47*C,  79*C,  79*C, "dark slate grey",
  0*C, 206*C, 209*C, "dark turquoise",
148*C,   0*C, 211*C, "dark violet",
0*C,   0*C, 139*C, "DarkBlue",
0*C, 139*C, 139*C, "DarkCyan",
184*C, 134*C,  11*C, "DarkGoldenrod",
255*C, 185*C, 15*C, "DarkGoldenrod1",
238*C, 173*C, 14*C, "DarkGoldenrod2",
205*C, 149*C, 12*C, "DarkGoldenrod3",
139*C, 101*C, 8*C, "DarkGoldenrod4",
169*C, 169*C, 169*C, "DarkGray",
  0*C, 100*C,   0*C, "DarkGreen",
169*C, 169*C, 169*C, "DarkGrey",
189*C, 183*C, 107*C, "DarkKhaki",
139*C,   0*C, 139*C, "DarkMagenta",
 85*C, 107*C,  47*C, "DarkOliveGreen",
202*C, 255*C, 112*C, "DarkOliveGreen1",
188*C, 238*C, 104*C, "DarkOliveGreen2",
162*C, 205*C, 90*C, "DarkOliveGreen3",
110*C, 139*C, 61*C, "DarkOliveGreen4",
255*C, 140*C,   0*C, "DarkOrange",
255*C, 127*C, 0*C, "DarkOrange1",
238*C, 118*C, 0*C, "DarkOrange2",
205*C, 102*C, 0*C, "DarkOrange3",
139*C, 69*C,  0*C, "DarkOrange4",
153*C,  50*C, 204*C, "DarkOrchid",
191*C,  62*C, 255*C, "DarkOrchid1",
178*C,  58*C, 238*C, "DarkOrchid2",
154*C,  50*C, 205*C, "DarkOrchid3",
104*C,  34*C, 139*C, "DarkOrchid4",
139*C,   0*C,   0*C, "DarkRed",
233*C, 150*C, 122*C, "DarkSalmon",
143*C, 188*C, 143*C, "DarkSeaGreen",
193*C, 255*C, 193*C, "DarkSeaGreen1",
180*C, 238*C, 180*C, "DarkSeaGreen2",
155*C, 205*C, 155*C, "DarkSeaGreen3",
105*C, 139*C, 105*C, "DarkSeaGreen4",
 72*C,  61*C, 139*C, "DarkSlateBlue",
 47*C,  79*C,  79*C, "DarkSlateGray",
151*C, 255*C, 255*C, "DarkSlateGray1",
141*C, 238*C, 238*C, "DarkSlateGray2",
121*C, 205*C, 205*C, "DarkSlateGray3",
 82*C, 139*C, 139*C, "DarkSlateGray4",
 47*C,  79*C,  79*C, "DarkSlateGrey",
  0*C, 206*C, 209*C, "DarkTurquoise",
148*C,   0*C, 211*C, "DarkViolet",
255*C,  20*C, 147*C, "deep pink",
  0*C, 191*C, 255*C, "deep sky blue",
255*C,  20*C, 147*C, "DeepPink",
255*C,  20*C, 147*C, "DeepPink1",
238*C,  18*C, 137*C, "DeepPink2",
205*C,  16*C, 118*C, "DeepPink3",
139*C, 10*C, 80*C, "DeepPink4",
  0*C, 191*C, 255*C, "DeepSkyBlue",
  0*C, 191*C, 255*C, "DeepSkyBlue1",
  0*C, 178*C, 238*C, "DeepSkyBlue2",
  0*C, 154*C, 205*C, "DeepSkyBlue3",
  0*C, 104*C, 139*C, "DeepSkyBlue4",
105*C, 105*C, 105*C, "dim gray",
105*C, 105*C, 105*C, "dim grey",
105*C, 105*C, 105*C, "DimGray",
105*C, 105*C, 105*C, "DimGrey",
 30*C, 144*C, 255*C, "dodger blue",
 30*C, 144*C, 255*C, "DodgerBlue",
 30*C, 144*C, 255*C, "DodgerBlue1",
 28*C, 134*C, 238*C, "DodgerBlue2",
 24*C, 116*C, 205*C, "DodgerBlue3",
 16*C,  78*C, 139*C, "DodgerBlue4",
178*C,  34*C,  34*C, "firebrick",
255*C, 48*C, 48*C, "firebrick1",
238*C, 44*C, 44*C, "firebrick2",
205*C, 38*C, 38*C, "firebrick3",
139*C, 26*C, 26*C, "firebrick4",
255*C, 250*C, 240*C, "floral white",
255*C, 250*C, 240*C, "FloralWhite",
 34*C, 139*C,  34*C, "forest green",
 34*C, 139*C,  34*C, "ForestGreen",
220*C, 220*C, 220*C, "gainsboro",
248*C, 248*C, 255*C, "ghost white",
248*C, 248*C, 255*C, "GhostWhite",
255*C, 215*C,   0*C, "gold",
255*C, 215*C, 0*C, "gold1",
238*C, 201*C, 0*C, "gold2",
205*C, 173*C, 0*C, "gold3",
139*C, 117*C, 0*C, "gold4",
218*C, 165*C,  32*C, "goldenrod",
255*C, 193*C, 37*C, "goldenrod1",
238*C, 180*C, 34*C, "goldenrod2",
205*C, 155*C, 29*C, "goldenrod3",
139*C, 105*C, 20*C, "goldenrod4",
190*C, 190*C, 190*C, "gray",
  0*C,   0*C,   0*C, "gray0",
  3*C,   3*C,   3*C, "gray1",
 26*C,  26*C,  26*C, "gray10",
255*C, 255*C, 255*C, "gray100",
 28*C,  28*C,  28*C, "gray11",
 31*C,  31*C,  31*C, "gray12",
 33*C,  33*C,  33*C, "gray13",
 36*C,  36*C,  36*C, "gray14",
 38*C,  38*C,  38*C, "gray15",
 41*C,  41*C,  41*C, "gray16",
 43*C,  43*C,  43*C, "gray17",
 46*C,  46*C,  46*C, "gray18",
 48*C,  48*C,  48*C, "gray19",
  5*C,   5*C,   5*C, "gray2",
 51*C,  51*C,  51*C, "gray20",
 54*C,  54*C,  54*C, "gray21",
 56*C,  56*C,  56*C, "gray22",
 59*C,  59*C,  59*C, "gray23",
 61*C,  61*C,  61*C, "gray24",
 64*C,  64*C,  64*C, "gray25",
 66*C,  66*C,  66*C, "gray26",
 69*C,  69*C,  69*C, "gray27",
 71*C,  71*C,  71*C, "gray28",
 74*C,  74*C,  74*C, "gray29",
  8*C,   8*C,   8*C, "gray3",
 77*C,  77*C,  77*C, "gray30",
 79*C,  79*C,  79*C, "gray31",
 82*C,  82*C,  82*C, "gray32",
 84*C,  84*C,  84*C, "gray33",
 87*C,  87*C,  87*C, "gray34",
 89*C,  89*C,  89*C, "gray35",
 92*C,  92*C,  92*C, "gray36",
 94*C,  94*C,  94*C, "gray37",
 97*C,  97*C,  97*C, "gray38",
 99*C,  99*C,  99*C, "gray39",
 10*C,  10*C,  10*C, "gray4",
102*C, 102*C, 102*C, "gray40",
105*C, 105*C, 105*C, "gray41",
107*C, 107*C, 107*C, "gray42",
110*C, 110*C, 110*C, "gray43",
112*C, 112*C, 112*C, "gray44",
115*C, 115*C, 115*C, "gray45",
117*C, 117*C, 117*C, "gray46",
120*C, 120*C, 120*C, "gray47",
122*C, 122*C, 122*C, "gray48",
125*C, 125*C, 125*C, "gray49",
 13*C,  13*C,  13*C, "gray5",
127*C, 127*C, 127*C, "gray50",
130*C, 130*C, 130*C, "gray51",
133*C, 133*C, 133*C, "gray52",
135*C, 135*C, 135*C, "gray53",
138*C, 138*C, 138*C, "gray54",
140*C, 140*C, 140*C, "gray55",
143*C, 143*C, 143*C, "gray56",
145*C, 145*C, 145*C, "gray57",
148*C, 148*C, 148*C, "gray58",
150*C, 150*C, 150*C, "gray59",
 15*C,  15*C,  15*C, "gray6",
153*C, 153*C, 153*C, "gray60",
156*C, 156*C, 156*C, "gray61",
158*C, 158*C, 158*C, "gray62",
161*C, 161*C, 161*C, "gray63",
163*C, 163*C, 163*C, "gray64",
166*C, 166*C, 166*C, "gray65",
168*C, 168*C, 168*C, "gray66",
171*C, 171*C, 171*C, "gray67",
173*C, 173*C, 173*C, "gray68",
176*C, 176*C, 176*C, "gray69",
 18*C,  18*C,  18*C, "gray7",
179*C, 179*C, 179*C, "gray70",
181*C, 181*C, 181*C, "gray71",
184*C, 184*C, 184*C, "gray72",
186*C, 186*C, 186*C, "gray73",
189*C, 189*C, 189*C, "gray74",
191*C, 191*C, 191*C, "gray75",
194*C, 194*C, 194*C, "gray76",
196*C, 196*C, 196*C, "gray77",
199*C, 199*C, 199*C, "gray78",
201*C, 201*C, 201*C, "gray79",
 20*C,  20*C,  20*C, "gray8",
204*C, 204*C, 204*C, "gray80",
207*C, 207*C, 207*C, "gray81",
209*C, 209*C, 209*C, "gray82",
212*C, 212*C, 212*C, "gray83",
214*C, 214*C, 214*C, "gray84",
217*C, 217*C, 217*C, "gray85",
219*C, 219*C, 219*C, "gray86",
222*C, 222*C, 222*C, "gray87",
224*C, 224*C, 224*C, "gray88",
227*C, 227*C, 227*C, "gray89",
 23*C,  23*C,  23*C, "gray9",
229*C, 229*C, 229*C, "gray90",
232*C, 232*C, 232*C, "gray91",
235*C, 235*C, 235*C, "gray92",
237*C, 237*C, 237*C, "gray93",
240*C, 240*C, 240*C, "gray94",
242*C, 242*C, 242*C, "gray95",
245*C, 245*C, 245*C, "gray96",
247*C, 247*C, 247*C, "gray97",
250*C, 250*C, 250*C, "gray98",
252*C, 252*C, 252*C, "gray99",
  0*C, 255*C,   0*C, "green",
173*C, 255*C,  47*C, "green yellow",
0*C, 255*C, 0*C, "green1",
0*C, 238*C, 0*C, "green2",
0*C, 205*C, 0*C, "green3",
0*C, 139*C, 0*C, "green4",
173*C, 255*C,  47*C, "GreenYellow",
190*C, 190*C, 190*C, "grey",
  0*C,   0*C,   0*C, "grey0",
  3*C,   3*C,   3*C, "grey1",
 26*C,  26*C,  26*C, "grey10",
255*C, 255*C, 255*C, "grey100",
 28*C,  28*C,  28*C, "grey11",
 31*C,  31*C,  31*C, "grey12",
 33*C,  33*C,  33*C, "grey13",
 36*C,  36*C,  36*C, "grey14",
 38*C,  38*C,  38*C, "grey15",
 41*C,  41*C,  41*C, "grey16",
 43*C,  43*C,  43*C, "grey17",
 46*C,  46*C,  46*C, "grey18",
 48*C,  48*C,  48*C, "grey19",
  5*C,   5*C,   5*C, "grey2",
 51*C,  51*C,  51*C, "grey20",
 54*C,  54*C,  54*C, "grey21",
 56*C,  56*C,  56*C, "grey22",
 59*C,  59*C,  59*C, "grey23",
 61*C,  61*C,  61*C, "grey24",
 64*C,  64*C,  64*C, "grey25",
 66*C,  66*C,  66*C, "grey26",
 69*C,  69*C,  69*C, "grey27",
 71*C,  71*C,  71*C, "grey28",
 74*C,  74*C,  74*C, "grey29",
  8*C,   8*C,   8*C, "grey3",
 77*C,  77*C,  77*C, "grey30",
 79*C,  79*C,  79*C, "grey31",
 82*C,  82*C,  82*C, "grey32",
 84*C,  84*C,  84*C, "grey33",
 87*C,  87*C,  87*C, "grey34",
 89*C,  89*C,  89*C, "grey35",
 92*C,  92*C,  92*C, "grey36",
 94*C,  94*C,  94*C, "grey37",
 97*C,  97*C,  97*C, "grey38",
 99*C,  99*C,  99*C, "grey39",
 10*C,  10*C,  10*C, "grey4",
102*C, 102*C, 102*C, "grey40",
105*C, 105*C, 105*C, "grey41",
107*C, 107*C, 107*C, "grey42",
110*C, 110*C, 110*C, "grey43",
112*C, 112*C, 112*C, "grey44",
115*C, 115*C, 115*C, "grey45",
117*C, 117*C, 117*C, "grey46",
120*C, 120*C, 120*C, "grey47",
122*C, 122*C, 122*C, "grey48",
125*C, 125*C, 125*C, "grey49",
 13*C,  13*C,  13*C, "grey5",
127*C, 127*C, 127*C, "grey50",
130*C, 130*C, 130*C, "grey51",
133*C, 133*C, 133*C, "grey52",
135*C, 135*C, 135*C, "grey53",
138*C, 138*C, 138*C, "grey54",
140*C, 140*C, 140*C, "grey55",
143*C, 143*C, 143*C, "grey56",
145*C, 145*C, 145*C, "grey57",
148*C, 148*C, 148*C, "grey58",
150*C, 150*C, 150*C, "grey59",
 15*C,  15*C,  15*C, "grey6",
153*C, 153*C, 153*C, "grey60",
156*C, 156*C, 156*C, "grey61",
158*C, 158*C, 158*C, "grey62",
161*C, 161*C, 161*C, "grey63",
163*C, 163*C, 163*C, "grey64",
166*C, 166*C, 166*C, "grey65",
168*C, 168*C, 168*C, "grey66",
171*C, 171*C, 171*C, "grey67",
173*C, 173*C, 173*C, "grey68",
176*C, 176*C, 176*C, "grey69",
 18*C,  18*C,  18*C, "grey7",
179*C, 179*C, 179*C, "grey70",
181*C, 181*C, 181*C, "grey71",
184*C, 184*C, 184*C, "grey72",
186*C, 186*C, 186*C, "grey73",
189*C, 189*C, 189*C, "grey74",
191*C, 191*C, 191*C, "grey75",
194*C, 194*C, 194*C, "grey76",
196*C, 196*C, 196*C, "grey77",
199*C, 199*C, 199*C, "grey78",
201*C, 201*C, 201*C, "grey79",
 20*C,  20*C,  20*C, "grey8",
204*C, 204*C, 204*C, "grey80",
207*C, 207*C, 207*C, "grey81",
209*C, 209*C, 209*C, "grey82",
212*C, 212*C, 212*C, "grey83",
214*C, 214*C, 214*C, "grey84",
217*C, 217*C, 217*C, "grey85",
219*C, 219*C, 219*C, "grey86",
222*C, 222*C, 222*C, "grey87",
224*C, 224*C, 224*C, "grey88",
227*C, 227*C, 227*C, "grey89",
 23*C,  23*C,  23*C, "grey9",
229*C, 229*C, 229*C, "grey90",
232*C, 232*C, 232*C, "grey91",
235*C, 235*C, 235*C, "grey92",
237*C, 237*C, 237*C, "grey93",
240*C, 240*C, 240*C, "grey94",
242*C, 242*C, 242*C, "grey95",
245*C, 245*C, 245*C, "grey96",
247*C, 247*C, 247*C, "grey97",
250*C, 250*C, 250*C, "grey98",
252*C, 252*C, 252*C, "grey99",
240*C, 255*C, 240*C, "honeydew",
240*C, 255*C, 240*C, "honeydew1",
224*C, 238*C, 224*C, "honeydew2",
193*C, 205*C, 193*C, "honeydew3",
131*C, 139*C, 131*C, "honeydew4",
255*C, 105*C, 180*C, "hot pink",
255*C, 105*C, 180*C, "HotPink",
255*C, 110*C, 180*C, "HotPink1",
238*C, 106*C, 167*C, "HotPink2",
205*C,  96*C, 144*C, "HotPink3",
139*C,  58*C,  98*C, "HotPink4",
205*C,  92*C,  92*C, "indian red",
205*C,  92*C,  92*C, "IndianRed",
255*C, 106*C, 106*C, "IndianRed1",
238*C, 99*C, 99*C, "IndianRed2",
205*C, 85*C, 85*C, "IndianRed3",
139*C, 58*C, 58*C, "IndianRed4",
255*C, 255*C, 240*C, "ivory",
255*C, 255*C, 240*C, "ivory1",
238*C, 238*C, 224*C, "ivory2",
205*C, 205*C, 193*C, "ivory3",
139*C, 139*C, 131*C, "ivory4",
240*C, 230*C, 140*C, "khaki",
255*C, 246*C, 143*C, "khaki1",
238*C, 230*C, 133*C, "khaki2",
205*C, 198*C, 115*C, "khaki3",
139*C, 134*C, 78*C, "khaki4",
230*C, 230*C, 250*C, "lavender",
255*C, 240*C, 245*C, "lavender blush",
255*C, 240*C, 245*C, "LavenderBlush",
255*C, 240*C, 245*C, "LavenderBlush1",
238*C, 224*C, 229*C, "LavenderBlush2",
205*C, 193*C, 197*C, "LavenderBlush3",
139*C, 131*C, 134*C, "LavenderBlush4",
124*C, 252*C,   0*C, "lawn green",
124*C, 252*C,   0*C, "LawnGreen",
255*C, 250*C, 205*C, "lemon chiffon",
255*C, 250*C, 205*C, "LemonChiffon",
255*C, 250*C, 205*C, "LemonChiffon1",
238*C, 233*C, 191*C, "LemonChiffon2",
205*C, 201*C, 165*C, "LemonChiffon3",
139*C, 137*C, 112*C, "LemonChiffon4",
173*C, 216*C, 230*C, "light blue",
240*C, 128*C, 128*C, "light coral",
224*C, 255*C, 255*C, "light cyan",
238*C, 221*C, 130*C, "light goldenrod",
250*C, 250*C, 210*C, "light goldenrod yellow",
211*C, 211*C, 211*C, "light gray",
144*C, 238*C, 144*C, "light green",
211*C, 211*C, 211*C, "light grey",
255*C, 182*C, 193*C, "light pink",
255*C, 160*C, 122*C, "light salmon",
 32*C, 178*C, 170*C, "light sea green",
135*C, 206*C, 250*C, "light sky blue",
132*C, 112*C, 255*C, "light slate blue",
119*C, 136*C, 153*C, "light slate gray",
119*C, 136*C, 153*C, "light slate grey",
176*C, 196*C, 222*C, "light steel blue",
255*C, 255*C, 224*C, "light yellow",
173*C, 216*C, 230*C, "LightBlue",
191*C, 239*C, 255*C, "LightBlue1",
178*C, 223*C, 238*C, "LightBlue2",
154*C, 192*C, 205*C, "LightBlue3",
104*C, 131*C, 139*C, "LightBlue4",
240*C, 128*C, 128*C, "LightCoral",
224*C, 255*C, 255*C, "LightCyan",
224*C, 255*C, 255*C, "LightCyan1",
209*C, 238*C, 238*C, "LightCyan2",
180*C, 205*C, 205*C, "LightCyan3",
122*C, 139*C, 139*C, "LightCyan4",
238*C, 221*C, 130*C, "LightGoldenrod",
255*C, 236*C, 139*C, "LightGoldenrod1",
238*C, 220*C, 130*C, "LightGoldenrod2",
205*C, 190*C, 112*C, "LightGoldenrod3",
139*C, 129*C, 76*C, "LightGoldenrod4",
250*C, 250*C, 210*C, "LightGoldenrodYellow",
211*C, 211*C, 211*C, "LightGray",
144*C, 238*C, 144*C, "LightGreen",
211*C, 211*C, 211*C, "LightGrey",
255*C, 182*C, 193*C, "LightPink",
255*C, 174*C, 185*C, "LightPink1",
238*C, 162*C, 173*C, "LightPink2",
205*C, 140*C, 149*C, "LightPink3",
139*C,  95*C, 101*C, "LightPink4",
255*C, 160*C, 122*C, "LightSalmon",
255*C, 160*C, 122*C, "LightSalmon1",
238*C, 149*C, 114*C, "LightSalmon2",
205*C, 129*C, 98*C, "LightSalmon3",
139*C, 87*C, 66*C, "LightSalmon4",
 32*C, 178*C, 170*C, "LightSeaGreen",
135*C, 206*C, 250*C, "LightSkyBlue",
176*C, 226*C, 255*C, "LightSkyBlue1",
164*C, 211*C, 238*C, "LightSkyBlue2",
141*C, 182*C, 205*C, "LightSkyBlue3",
 96*C, 123*C, 139*C, "LightSkyBlue4",
132*C, 112*C, 255*C, "LightSlateBlue",
119*C, 136*C, 153*C, "LightSlateGray",
119*C, 136*C, 153*C, "LightSlateGrey",
176*C, 196*C, 222*C, "LightSteelBlue",
202*C, 225*C, 255*C, "LightSteelBlue1",
188*C, 210*C, 238*C, "LightSteelBlue2",
162*C, 181*C, 205*C, "LightSteelBlue3",
110*C, 123*C, 139*C, "LightSteelBlue4",
255*C, 255*C, 224*C, "LightYellow",
255*C, 255*C, 224*C, "LightYellow1",
238*C, 238*C, 209*C, "LightYellow2",
205*C, 205*C, 180*C, "LightYellow3",
139*C, 139*C, 122*C, "LightYellow4",
 50*C, 205*C,  50*C, "lime green",
 50*C, 205*C,  50*C, "LimeGreen",
250*C, 240*C, 230*C, "linen",
255*C,   0*C, 255*C, "magenta",
255*C,   0*C, 255*C, "magenta1",
238*C,   0*C, 238*C, "magenta2",
205*C,   0*C, 205*C, "magenta3",
139*C,   0*C, 139*C, "magenta4",
176*C,  48*C,  96*C, "maroon",
255*C,  52*C, 179*C, "maroon1",
238*C,  48*C, 167*C, "maroon2",
205*C,  41*C, 144*C, "maroon3",
139*C, 28*C, 98*C, "maroon4",
102*C, 205*C, 170*C, "medium aquamarine",
  0*C,   0*C, 205*C, "medium blue",
186*C,  85*C, 211*C, "medium orchid",
147*C, 112*C, 219*C, "medium purple",
 60*C, 179*C, 113*C, "medium sea green",
123*C, 104*C, 238*C, "medium slate blue",
  0*C, 250*C, 154*C, "medium spring green",
 72*C, 209*C, 204*C, "medium turquoise",
199*C,  21*C, 133*C, "medium violet red",
102*C, 205*C, 170*C, "MediumAquamarine",
  0*C,   0*C, 205*C, "MediumBlue",
186*C,  85*C, 211*C, "MediumOrchid",
224*C, 102*C, 255*C, "MediumOrchid1",
209*C,  95*C, 238*C, "MediumOrchid2",
180*C,  82*C, 205*C, "MediumOrchid3",
122*C,  55*C, 139*C, "MediumOrchid4",
147*C, 112*C, 219*C, "MediumPurple",
171*C, 130*C, 255*C, "MediumPurple1",
159*C, 121*C, 238*C, "MediumPurple2",
137*C, 104*C, 205*C, "MediumPurple3",
 93*C,  71*C, 139*C, "MediumPurple4",
 60*C, 179*C, 113*C, "MediumSeaGreen",
123*C, 104*C, 238*C, "MediumSlateBlue",
  0*C, 250*C, 154*C, "MediumSpringGreen",
 72*C, 209*C, 204*C, "MediumTurquoise",
199*C,  21*C, 133*C, "MediumVioletRed",
 25*C,  25*C, 112*C, "midnight blue",
 25*C,  25*C, 112*C, "MidnightBlue",
245*C, 255*C, 250*C, "mint cream",
245*C, 255*C, 250*C, "MintCream",
255*C, 228*C, 225*C, "misty rose",
255*C, 228*C, 225*C, "MistyRose",
255*C, 228*C, 225*C, "MistyRose1",
238*C, 213*C, 210*C, "MistyRose2",
205*C, 183*C, 181*C, "MistyRose3",
139*C, 125*C, 123*C, "MistyRose4",
255*C, 228*C, 181*C, "moccasin",
255*C, 222*C, 173*C, "navajo white",
255*C, 222*C, 173*C, "NavajoWhite",
255*C, 222*C, 173*C, "NavajoWhite1",
238*C, 207*C, 161*C, "NavajoWhite2",
205*C, 179*C, 139*C, "NavajoWhite3",
139*C, 121*C, 94*C, "NavajoWhite4",
  0*C,   0*C, 128*C, "navy",
  0*C,   0*C, 128*C, "navy blue",
  0*C,   0*C, 128*C, "NavyBlue",
253*C, 245*C, 230*C, "old lace",
253*C, 245*C, 230*C, "OldLace",
107*C, 142*C,  35*C, "olive drab",
107*C, 142*C,  35*C, "OliveDrab",
192*C, 255*C, 62*C, "OliveDrab1",
179*C, 238*C, 58*C, "OliveDrab2",
154*C, 205*C, 50*C, "OliveDrab3",
105*C, 139*C, 34*C, "OliveDrab4",
255*C, 165*C,   0*C, "orange",
255*C,  69*C,   0*C, "orange red",
255*C, 165*C, 0*C, "orange1",
238*C, 154*C, 0*C, "orange2",
205*C, 133*C, 0*C, "orange3",
139*C, 90*C,  0*C, "orange4",
255*C,  69*C,   0*C, "OrangeRed",
255*C, 69*C,  0*C, "OrangeRed1",
238*C, 64*C,  0*C, "OrangeRed2",
205*C, 55*C,  0*C, "OrangeRed3",
139*C, 37*C,  0*C, "OrangeRed4",
218*C, 112*C, 214*C, "orchid",
255*C, 131*C, 250*C, "orchid1",
238*C, 122*C, 233*C, "orchid2",
205*C, 105*C, 201*C, "orchid3",
139*C,  71*C, 137*C, "orchid4",
238*C, 232*C, 170*C, "pale goldenrod",
152*C, 251*C, 152*C, "pale green",
175*C, 238*C, 238*C, "pale turquoise",
219*C, 112*C, 147*C, "pale violet red",
238*C, 232*C, 170*C, "PaleGoldenrod",
152*C, 251*C, 152*C, "PaleGreen",
154*C, 255*C, 154*C, "PaleGreen1",
144*C, 238*C, 144*C, "PaleGreen2",
124*C, 205*C, 124*C, "PaleGreen3",
84*C, 139*C, 84*C, "PaleGreen4",
175*C, 238*C, 238*C, "PaleTurquoise",
187*C, 255*C, 255*C, "PaleTurquoise1",
174*C, 238*C, 238*C, "PaleTurquoise2",
150*C, 205*C, 205*C, "PaleTurquoise3",
102*C, 139*C, 139*C, "PaleTurquoise4",
219*C, 112*C, 147*C, "PaleVioletRed",
255*C, 130*C, 171*C, "PaleVioletRed1",
238*C, 121*C, 159*C, "PaleVioletRed2",
205*C, 104*C, 137*C, "PaleVioletRed3",
139*C, 71*C, 93*C, "PaleVioletRed4",
255*C, 239*C, 213*C, "papaya whip",
255*C, 239*C, 213*C, "PapayaWhip",
255*C, 218*C, 185*C, "peach puff",
255*C, 218*C, 185*C, "PeachPuff",
255*C, 218*C, 185*C, "PeachPuff1",
238*C, 203*C, 173*C, "PeachPuff2",
205*C, 175*C, 149*C, "PeachPuff3",
139*C, 119*C, 101*C, "PeachPuff4",
205*C, 133*C,  63*C, "peru",
255*C, 192*C, 203*C, "pink",
255*C, 181*C, 197*C, "pink1",
238*C, 169*C, 184*C, "pink2",
205*C, 145*C, 158*C, "pink3",
139*C,  99*C, 108*C, "pink4",
221*C, 160*C, 221*C, "plum",
255*C, 187*C, 255*C, "plum1",
238*C, 174*C, 238*C, "plum2",
205*C, 150*C, 205*C, "plum3",
139*C, 102*C, 139*C, "plum4",
176*C, 224*C, 230*C, "powder blue",
176*C, 224*C, 230*C, "PowderBlue",
160*C,  32*C, 240*C, "purple",
155*C,  48*C, 255*C, "purple1",
145*C,  44*C, 238*C, "purple2",
125*C,  38*C, 205*C, "purple3",
 85*C,  26*C, 139*C, "purple4",
255*C,   0*C,   0*C, "red",
255*C,  0*C,  0*C, "red1",
238*C,  0*C,  0*C, "red2",
205*C,  0*C,  0*C, "red3",
139*C,  0*C,  0*C, "red4",
188*C, 143*C, 143*C, "rosy brown",
188*C, 143*C, 143*C, "RosyBrown",
255*C, 193*C, 193*C, "RosyBrown1",
238*C, 180*C, 180*C, "RosyBrown2",
205*C, 155*C, 155*C, "RosyBrown3",
139*C, 105*C, 105*C, "RosyBrown4",
 65*C, 105*C, 225*C, "royal blue",
 65*C, 105*C, 225*C, "RoyalBlue",
 72*C, 118*C, 255*C, "RoyalBlue1",
 67*C, 110*C, 238*C, "RoyalBlue2",
 58*C,  95*C, 205*C, "RoyalBlue3",
 39*C,  64*C, 139*C, "RoyalBlue4",
139*C,  69*C,  19*C, "saddle brown",
139*C,  69*C,  19*C, "SaddleBrown",
250*C, 128*C, 114*C, "salmon",
255*C, 140*C, 105*C, "salmon1",
238*C, 130*C, 98*C, "salmon2",
205*C, 112*C, 84*C, "salmon3",
139*C, 76*C, 57*C, "salmon4",
244*C, 164*C,  96*C, "sandy brown",
244*C, 164*C,  96*C, "SandyBrown",
 46*C, 139*C,  87*C, "sea green",
 46*C, 139*C,  87*C, "SeaGreen",
 84*C, 255*C, 159*C, "SeaGreen1",
 78*C, 238*C, 148*C, "SeaGreen2",
 67*C, 205*C, 128*C, "SeaGreen3",
46*C, 139*C, 87*C, "SeaGreen4",
255*C, 245*C, 238*C, "seashell",
255*C, 245*C, 238*C, "seashell1",
238*C, 229*C, 222*C, "seashell2",
205*C, 197*C, 191*C, "seashell3",
139*C, 134*C, 130*C, "seashell4",
160*C,  82*C,  45*C, "sienna",
255*C, 130*C, 71*C, "sienna1",
238*C, 121*C, 66*C, "sienna2",
205*C, 104*C, 57*C, "sienna3",
139*C, 71*C, 38*C, "sienna4",
135*C, 206*C, 235*C, "sky blue",
135*C, 206*C, 235*C, "SkyBlue",
135*C, 206*C, 255*C, "SkyBlue1",
126*C, 192*C, 238*C, "SkyBlue2",
108*C, 166*C, 205*C, "SkyBlue3",
 74*C, 112*C, 139*C, "SkyBlue4",
106*C,  90*C, 205*C, "slate blue",
112*C, 128*C, 144*C, "slate gray",
112*C, 128*C, 144*C, "slate grey",
106*C,  90*C, 205*C, "SlateBlue",
131*C, 111*C, 255*C, "SlateBlue1",
122*C, 103*C, 238*C, "SlateBlue2",
105*C,  89*C, 205*C, "SlateBlue3",
 71*C,  60*C, 139*C, "SlateBlue4",
112*C, 128*C, 144*C, "SlateGray",
198*C, 226*C, 255*C, "SlateGray1",
185*C, 211*C, 238*C, "SlateGray2",
159*C, 182*C, 205*C, "SlateGray3",
108*C, 123*C, 139*C, "SlateGray4",
112*C, 128*C, 144*C, "SlateGrey",
255*C, 250*C, 250*C, "snow",
255*C, 250*C, 250*C, "snow1",
238*C, 233*C, 233*C, "snow2",
205*C, 201*C, 201*C, "snow3",
139*C, 137*C, 137*C, "snow4",
  0*C, 255*C, 127*C, "spring green",
  0*C, 255*C, 127*C, "SpringGreen",
  0*C, 255*C, 127*C, "SpringGreen1",
  0*C, 238*C, 118*C, "SpringGreen2",
  0*C, 205*C, 102*C, "SpringGreen3",
0*C, 139*C, 69*C, "SpringGreen4",
 70*C, 130*C, 180*C, "steel blue",
 70*C, 130*C, 180*C, "SteelBlue",
 99*C, 184*C, 255*C, "SteelBlue1",
 92*C, 172*C, 238*C, "SteelBlue2",
 79*C, 148*C, 205*C, "SteelBlue3",
 54*C, 100*C, 139*C, "SteelBlue4",
210*C, 180*C, 140*C, "tan",
255*C, 165*C, 79*C, "tan1",
238*C, 154*C, 73*C, "tan2",
205*C, 133*C, 63*C, "tan3",
139*C, 90*C, 43*C, "tan4",
216*C, 191*C, 216*C, "thistle",
255*C, 225*C, 255*C, "thistle1",
238*C, 210*C, 238*C, "thistle2",
205*C, 181*C, 205*C, "thistle3",
139*C, 123*C, 139*C, "thistle4",
255*C,  99*C,  71*C, "tomato",
255*C, 99*C, 71*C, "tomato1",
238*C, 92*C, 66*C, "tomato2",
205*C, 79*C, 57*C, "tomato3",
139*C, 54*C, 38*C, "tomato4",
 64*C, 224*C, 208*C, "turquoise",
  0*C, 245*C, 255*C, "turquoise1",
  0*C, 229*C, 238*C, "turquoise2",
  0*C, 197*C, 205*C, "turquoise3",
  0*C, 134*C, 139*C, "turquoise4",
238*C, 130*C, 238*C, "violet",
208*C,  32*C, 144*C, "violet red",
208*C,  32*C, 144*C, "VioletRed",
255*C,  62*C, 150*C, "VioletRed1",
238*C,  58*C, 140*C, "VioletRed2",
205*C,  50*C, 120*C, "VioletRed3",
139*C, 34*C, 82*C, "VioletRed4",
245*C, 222*C, 179*C, "wheat",
255*C, 231*C, 186*C, "wheat1",
238*C, 216*C, 174*C, "wheat2",
205*C, 186*C, 150*C, "wheat3",
139*C, 126*C, 102*C, "wheat4",
255*C, 255*C, 255*C, "white",
245*C, 245*C, 245*C, "white smoke",
245*C, 245*C, 245*C, "WhiteSmoke",
255*C, 255*C,   0*C, "yellow",
154*C, 205*C,  50*C, "yellow green",
255*C, 255*C, 0*C, "yellow1",
238*C, 238*C, 0*C, "yellow2",
205*C, 205*C, 0*C, "yellow3",
139*C, 139*C, 0*C, "yellow4",
154*C, 205*C,  50*C, "YellowGreen",
};

#undef C

#define NUM_KD_COLORS	(sizeof (KdColors) / sizeof (KdColors[0]))

Bool
OsInitColors()
{
    return TRUE;
}

Bool
OsLookupColor(int		screen, 
	      char		*s_name,
	      unsigned int	len, 
	      unsigned short	*pred,
	      unsigned short	*pgreen,
	      unsigned short	*pblue)
{
    const KdNamedColor	*c;
    unsigned char	*name = (unsigned char *) s_name;
    int			low, mid, high;
    int			r;

    low = 0;
    high = NUM_KD_COLORS;
    while (high - low > 0)
    {
	mid = (low + high) / 2;
	c = &KdColors[mid];
	r = KdStrCaseCmp (c->name, name, len);
	if (r == 0)
	{
	    *pred = c->red;
	    *pgreen = c->green;
	    *pblue = c->blue;
	    return TRUE;
	}
	if (r < 0)
	{
	    if (high == mid)
		break;
	    high = mid;
	}
	else
	{
	    if (low == mid)
		break;
	    low = mid;
	}
    }
    return FALSE;
}
