/* OS/2 REXX */

/* Copyright (C)1996 by Holger.Veit@gmd.de */

/*

   This utility checks whether you have set up your XFree86/OS2 correctly.

   Well, we may not detect _every_ problem here ...

*/

'@echo off'

ADDRESS CMD

parse arg OS2BootDrive

OS2BootDrive = substr( translate( strip( OS2BootDrive ) ),1,2 )

if OS2BootDrive <> '' then

	if stream( OS2BootDrive || '\CONFIG.SYS', 'c', 'QUERY EXIST' ) = '' then

	do

		/* show the usage                             */

		say 'Usage: checkinstall {os2BootDrive}'

		say ''

		say 'Default: Search the OS/2 boot drive'

		exit 1

	end /* if stream( ... */



/* IF POS(':',OS2BootDrive)=0 THEN OS2BootDrive=OS2BootDrive':' */



/* signal on halt name UserAbort */

signal on syntax name RexxUtilNotFound



/*say ' Loading REXXUTIL ... '*/

  

/* load REXXUTIL                              */

if ChkRexxUtil() = 1 then

  do

  say 'Your system seems to lack the REXX-Util-library !'

  exit 2

  end



/* turn on the default error handler again    */

signal off Syntax



/* search the OS/2 boot drive                 */

if OS2BootDrive = '' then

do

	say ' Searching the boot drive. Please wait ...'

	OS2BootDrive = SearchbootDrive()



	say ' ... Bootdrive "' || OS2BootDrive || '" found.'

end /* if OS2BootDrive = '' then */





env = 'OS2ENVIRONMENT'

errcnt = 0

warncnt = 0

runxconfig = 0

DateSep = SysIni(,'PM_National','sDate') /* '.' in German and '-' in US OS/2. */

                                         /* Change this if your CMD.EXE doesn't handle this correctly. */

DateSep = LEFT(DateSep, 1)	/* SysIni return '. ' instead of '.' ?!? */



HPFSDirCol = 41 /* usually a dir on HPFS drives shows the name of a file starting with Column 41 */

		/* It would be better to perform a dir, queue it, parse it and thus determine the */

		/* correct column. */

HPFSDirIdentCol = 22 /* where '<DIR>' starts - see above */



x11root = VALUE('X11ROOT',,env)

CALL envexchk '001','X11ROOT','c:'

CALL direxchk '002','X11ROOT'

CALL direxchk1 '003',x11root'/XFree86/bin','X11ROOT'

CALL direxchk1 '004',x11root'/XFree86/lib','X11ROOT'

CALL direxchk1 '005',x11root'/XFree86/lib/X11','X11ROOT'

CALL fwdslchk '006','X11ROOT'

CALL hpfschk '007','X11ROOT'



CALL envexchk '010','HOME','c:\home\x11user'

CALL direxchk '011','HOME'

CALL backslchk '012','HOME'

CALL hpfschk '013','HOME'

CALL casechk '014','HOME'



etc = VALUE('ETC',,env)

CALL envexchk '020','ETC','c:\tcpip\etc'

CALL direxchk '021','ETC'

CALL backslchk '022','ETC'

CALL filexchk '023',etc'\hosts','ETC'



tmp = VALUE('TMP',,env)

CALL envexchk '030','TMP','f:\tcpip\tmp'

CALL direxchk '031','TMP'

CALL backslchk '032','TMP'

CALL trailchk '033','TMP'

CALL hpfschk '034','TMP'



hostname = VALUE('HOSTNAME',,env)

CALL envexchk '040','HOSTNAME','myhost'

CALL envexchk '041','USER','user123'

CALL envexchk '042','LOGNAME','user123'

user = VALUE('USER',,env)

logname = VALUE('LOGNAME',,env)

CALL userchk1 '043',user,logname



termcap = VALUE('TERMCAP',,env)

CALL envexchk '050','TERMCAP','d:/emx/etc/termcap.x11'

CALL filexchk '051',termcap,'TERMCAP'

CALL fwdslchk '052','TERMCAP'

term = VALUE('TERM',,env)

CALL envexchk '053','TERM','ansi'

CALL termcapchk1 termcap,term	/* 054,055 */



xserver = VALUE('XSERVER',,env)

CALL envexchk '060','XSERVER','D:/XFree86/bin/XF86_SVGA.EXE'

CALL filexchk '061',xserver,'XSERVER'

CALL fwdslchk '062','XSERVER'



CALL envexchk '070','DISPLAY','myhost:0.0'

CALL dispchk	/* 071,072,073 */



CALL hostchk /* 080,081 */

CALL pathchk '082','xf86config.exe',x11root'\XFree86\bin'

CALL libpathchk '083','xaw.dll',x11root'\XFree86\lib'

CALL localchk /* 084,085 */



CALL manpathchk /* 090,091 */

CALL xconfigchk /* 092,100 */

CALL emxchk /* 093,094,095,096 */

CALL xf86supchk /* 097,098,099 */



call shellchk /* ? */



SAY ""

SAY ""

IF errcnt=0 THEN DO

	CALL BEEP 440,250

	SAY "***CHECK: Your system seems to be setup correctly for XFree86/OS2"

	IF warncnt > 0 THEN DO

		SAY "          however, you should look at the warnings."

	END

	CALL xconfig

END 

ELSE DO

	CALL BEEP 440,250

	SAY "***CHECK: There were "errcnt" error(s) detected. Please correct them"

	SAY "   before attempting to run XFree86/OS2."

	IF runxconfig=1 THEN DO

		SAY ""

		SAY "***CHECK: xf86config won't be run, because errors were found."

	END

END



EXIT 0



/* helper functions */



notexists_file: PROCEDURE

	ARG file

	IF file='' THEN RETURN 0

	RETURN STREAM(file,'C','QUERY EXISTS') = ''



exists_file: PROCEDURE

	ARG file

	IF file='' THEN RETURN 0

	RETURN STREAM(file,'C','QUERY EXISTS') \= ''



notexists_dir: PROCEDURE

	ARG dir

	direc = TRANSLATE(dir,'\','/')

	'DIR "'direc'" >NUL 2>&1'

	IF RC = 0 THEN RETURN 0

	RETURN 1



notbackslash: PROCEDURE

	ARG path

	IF POS('/',path) = 0 THEN RETURN 0

	RETURN 1



notfwdslash: PROCEDURE

	ARG path

	IF POS('\',path) = 0 THEN RETURN 0

	RETURN 1



backslchk: PROCEDURE EXPOSE env errcnt

	ARG err,var

	envvar = VALUE(var,,env)

	IF envvar='' THEN RETURN

	IF notbackslash(envvar) THEN DO

		SAY "***XFERR"err": The "envvar" directory (derived from variable "var")"

		SAY "   must have backslashes as a directory separator."

		SAY "   Please correct this."

		errcnt = errcnt+1

	END

	RETURN



fwdslchk: PROCEDURE EXPOSE env errcnt

	ARG err,var

	envvar = VALUE(var,,env)

	IF envvar='' THEN RETURN

	IF notfwdslash(envvar) THEN DO

		SAY "***XFERR"err": The "envvar" directory (derived from variable "var")"

		SAY "   must have forward slashes as a directory separator."

		SAY "   Please correct this."

		errcnt = errcnt+1

	END

	RETURN



direxchk: PROCEDURE EXPOSE env errcnt

	ARG err,var

	envvar = VALUE(var,,env)

	if notexists_dir(envvar) THEN DO

		SAY "***XFERR"err": The directory specified in the variable "var" does not exist"

		SAY "   Please create it or specify another directory in the variable"

		errcnt = errcnt+1

	END

	RETURN



direxchk1: PROCEDURE EXPOSE env errcnt

	ARG err,dir,var

	if notexists_dir(dir) THEN DO

		SAY "***XFERR"err": The directory "dir" (derived from variable "var")"

		SAY "   does not exist."

		SAY "   Your XFree86 installation seems to be incomplete."

		errcnt = errcnt+1

	END

	RETURN



envexchk: PROCEDURE EXPOSE env errcnt

	ARG err,var,val

	envvar = VALUE(var,,env)

	IF envvar='' THEN DO

		SAY "***XFERR"err": The environment variable "var" is not set."

		SAY "   Please set it in CONFIG.SYS, for example:"

		SAY "       SET "var"="val

		errcnt = errcnt+1

	END

	RETURN



filexchk: PROCEDURE EXPOSE env errcnt

	ARG err,file,var

	if notexists_file(file) THEN DO

		SAY "***XFERR"err": The file "file" (derived from variable "var")"

		SAY "   does not exist. Please create one."

		errcnt = errcnt+1

	END

	RETURN



filexchk1: PROCEDURE EXPOSE env errcnt

	ARG err,file

	file1 = WORD(TRANSLATE(file,' ','/'),1)

	if notexists_file(file1) THEN DO

		SAY "***XFERR"err": The file "file1" (derived from DEVICE section)"

		SAY "   does not exist. You must install it."

		errcnt = errcnt+1

	END

	RETURN



nothpfs: PROCEDURE

	ARG dir

	testfile = TRANSLATE(dir,'\','/')

	IF LENGTH(testfile) \= LASTPOS('\',testfile) THEN testfile=testfile||'\'

	testfile = testfile||'very.long.file.name'

	CALL LINEOUT testfile,'test',1

	CALL LINEOUT testfile

	rc = SysFileDelete(testfile)

	IF rc = 0 THEN RETURN 0

	RETURN 1



hpfschk: PROCEDURE EXPOSE env errcnt

	ARG err,var

	envvar = VALUE(var,,env)

	if nothpfs(envvar) THEN DO

		SAY "***XFERR"err": The directory "envvar" (derived from variable "var")"

		SAY "   must reside on a file system which understands long file names"

		SAY "   (e.g. HPFS, NFS, Linux-ext2) because some software relies on this."

		SAY "   Please move this directory."

		errcnt = errcnt+1

	END

	RETURN



userchk1: PROCEDURE EXPOSE errcnt

	ARG err,usr,log

	IF usr \= log THEN DO

		SAY "***XFERR"err": The variables USER and LOGNAME must be present and"

		SAY "   match. It will cause problems if they are different or missing."

		SAY "   Please correct this."

		errcnt = errcnt+1

	END

	RETURN



searchstring: PROCEDURE

	ARG file,str

	rc = SysFileSearch(str,file,'res.')

	IF (rc \= 0) | (res.0>0) THEN RETURN 1

	RETURN 0



termcapchk1: PROCEDURE EXPOSE errcnt x11root

	ARG file,str

	found = searchstring(file,'xterm')

	if found=0 THEN DO

		SAY "***XFERR054: The termcap file specified in TERMCAP does not"

		SAY "   contain an entry for 'xterm'. It is possibly outdated. Please"

		SAY "   use the file "x11root"/XFree86/lib/X11/etc/emx.termcap.x11 instead."

		errcnt = errcnt+1

	END

	if str \= '' THEN DO

		found = searchstring(file,str)

		if found=0 THEN DO

			SAY "***XFERR055: The termcap file specified in TERMCAP does not"

			SAY "   contain an entry for the value "str" specified in the TERM variable."

			SAY "   Please set TERM to a correct value."

			errcnt = errcnt+1

		END

	END

	RETURN



dispchk: PROCEDURE EXPOSE env errcnt hostname warncnt

	display = VALUE('DISPLAY',,env)

	IF hostname \= '' & (POS(hostname,display)=0) THEN DO

		SAY "***XFWARN071: The DISPLAY variable contains a different value"

		SAY "   than the HOSTNAME variable. This is okay provided you want"

		SAY "   OS/2 X clients to be displayed elsewhere. Otherwise, please"

		SAY "   correct this."

		warncnt = warncnt+1

	END

	IF POS(':',display) = 0 THEN DO

		SAY "***XFERR072: The DISPLAY variable does not contain a colon ':' which"

		SAY "   is not correct. Please correct this. A valid DISPLAY variable looks like:"

		SAY "       SET DISPLAY=myhost:0.0"

		errcnt = errcnt+1

	END

	IF POS(':7',display) > 0 THEN DO

		SAY "***XFERR073: The DISPLAY variable uses the standard connection"

		SAY "   LBX (low bandwidth X). This is not supported by the current X servers."

		SAY "   Use another connection type."

		errcnt = errcnt+1

	END

	RETURN



hostchk: PROCEDURE EXPOSE env errcnt hostname etc warncnt

	use_hosts_first = VALUE('USE_HOSTS_FIRST',,env)

	IF use_hosts_first = '' THEN DO

		SAY "***XFWARN080: You have not set the USE_HOSTS_FIRST variable."

		SAY "   Unless you are permanently connected to an ethernet network"

		SAY "   and have direct access to a DNS nameserver, it is recommended"

		SAY "   to have the line SET USE_HOSTS_FIRST=1 in your CONFIG.SYS file."

		warncnt = warncnt+1

	END



	IF hostname = '' THEN RETURN

	found = searchstring(hostname,etc'\hosts')

	IF found = 0 THEN DO

		SAY "***XFERR081: There is no entry for the HOSTNAME in the HOSTS file."

		SAY "   (in"etc"\hosts). Please add a line like the following to this file:"

		SAY "	    192.10.10.1 "hostname

	END

	RETURN



pathchk: PROCEDURE EXPOSE errcnt

	ARG err,file,dir

	found = SysSearchPath('PATH',file)

	IF found = '' THEN DO

		SAY "***XFERR"err": You must set the directory "dir" in"

		SAY "   your PATH entry in CONFIG.SYS. Please correct this."

		errcnt = errcnt+1

	END

	RETURN





shellchk: procedure expose errcnt

  env = 'OS2ENVIRONMENT'

  os_shell = VALUE('X11SHELL',,env)

  IF os_shell = '' THEN os_shell = VALUE('SHELL',,env)

  IF os_shell = '' THEN os_shell = VALUE('OS2_SHELL',,env)

  IF os_shell = '' THEN

     DO

     SAY "There is no command interpreter in OS2_SHELL ???"

	 errcnt = errcnt+1

     return

     end

  found = Stream(os_shell, "C", "QUERY EXISTS") /* executable + full path ? */

  if found = "" then

    found = IsInPath(os_shell)  /* only an executable name */

  IF found = '' THEN 

      DO

      SAY "The specificied shell "os_shell" is not in PATH!"

      errcnt = errcnt+1

      end

  return



libpathchk: PROCEDURE EXPOSE errcnt OS2BootDrive

	ARG err,file,dir

	CALL SysFileSearch 'LIBPATH',OS2BootDrive'\config.sys','res.'

	IF res.0 \= 1 THEN RETURN

    if Translate(Left(Strip(res.1, 'L'),3)) = "REM" then

      do

      if res.0 < 2 then 

        return

      else

        libpath = TRANSLATE(res.2,'  ','=;')

      end

    else

        libpath = TRANSLATE(res.1,'  ','=;')

	found = 0

	DO i=1 TO WORDS(libpath)

		IF \(notexists_file(WORD(libpath,i)'\'file)) THEN DO

			found = 1

			LEAVE

		END

	END

	if found = 0 THEN DO

		SAY "***XFERR"err": You must set the directory "dir" in"

		SAY "   your LIBPATH entry in CONFIG.SYS. Please correct this."

		errcnt = errcnt+1

	END

	RETURN





localchk: PROCEDURE EXPOSE errcnt hostname OS2BootDrive etc

	IF hostname \= 'localhost' THEN RETURN

	config = OS2BootDrive'\config.sys'

	CALL SysFileSearch 'ifconfig',config,'res.'

	found = 0

	IF DATATYPE(res.0,N) = 1 THEN DO

		DO i = 0 TO res.0

			IF (POS('lo',res.i)>0) & (POS('127.0.0.1',res.i)>0) THEN DO

				found = 1

				LEAVE

			END

		END

	END

	IF (found = 0) | (res.0 = 0) THEN DO

		SAY "***XFERR084: If your hostname is 'localhost', you must setup"

		SAY "   the LOOPBACK network connection. This is done by adding the"

		SAY "   following line to CONFIG.SYS:"

		SAY "       RUN=<tcpippath>\ifconfig lo 127.0.0.1 up"

		errcnt = errcnt+1

	END

	CALL SysFileSearch 'localhost',etc'\hosts','res1.'

	IF (res1.0 \= 1) | (POS('127.0.0.1',res1.1)=0) THEN DO

		SAY "***XFERR085: If your hostname is 'localhost', it must have the"

		SAY "   standard internet number 127.0.0.1 in "etc"\hosts. Please"

		SAY "   correct this."

		errcnt = errcnt+1

	END

	RETURN



testpath: PROCEDURE EXPOSE env errcnt

	ARG err,var,prog

	path = TRANSLATE(VALUE(var,,env),' ',';')

	DO i=1 TO WORDS(path)

		IF notexists_dir(WORD(path,i)) THEN DO

			SAY "***XFERR"err": In your "var" variable, the component "WORD(path,i)

			SAY "   does not point to a valid directory. Please correct"

			SAY "   the "var" variable, or '"prog"' might get confused."

			errcnt = errcnt+1

		END

	END

	RETURN



manpathchk: PROCEDURE EXPOSE env errcnt x11root warncnt

	manpath = VALUE('MANPATH',,env)

	IF manpath='' THEN DO

		SAY "***XFWARN090: You don't have a MANPATH statement set. This is"

		SAY "   no problem, but will disable the start of 'xman' in xinitrc.cmd"

		SAY "   If you installed the man pages, you might want to add a MANPATH"

		SAY "   to CONFIG.SYS like:"

		SAY "       SET MANPATH="x11root"/XFree86/man"

		warncnt = warncnt+1

	END

	ELSE DO

		CALL testpath '091','MANPATH','xman'

	END

	RETURN



xconfigchk: PROCEDURE EXPOSE runxconfig x11root warncnt

	IF notexists_file(x11root'/XFree86/lib/X11/XF86Config') THEN DO

	  IF exists_file(x11root'/XFree86/lib/X11/XConfig') THEN DO

		SAY ""

		SAY "***XFWARN100: You have an old XConfig file. XFree86-3.3.2"

		SAY "   and later use XF86Config. You must rename this"

		SAY "   file to XF86Config, or rebuild it if it is a leftover"

		SAY "   from earlier incompatible installations."

		warncnt = warncnt + 1

	  END

	  ELSE DO

		SAY ""

		SAY "***XFWARN092: You don't have an XF86Config file yet. Do you want to"

		SAY "   run the xf86config utility after this script (Y/N)?"

		PULL yesno

		IF (yesno='Y') | (yesno='YES') THEN runxconfig=1

		warncnt = warncnt + 1

	  END

        END

	RETURN



revision: PROCEDURE

	ARG pathname

	CALL RxFuncAdd emx_revision, pathname, emx_revision

	SIGNAL ON SYNTAX NAME ERROR

	rev = emx_revision()

	SIGNAL OFF SYNTAX

	CALL RxFuncDrop emx_revision

	RETURN rev



emxchk: PROCEDURE EXPOSE env errcnt x11root

	IF \(notexists_file(x11root'/XFree86/bin/imake.exe')) THEN DO

		incpath = VALUE('C_INCLUDE_PATH',,env)

		lbrpath = VALUE('LIBRARY_PATH',,env)

		IF (lbrpath='') | (incpath='') THEN DO

			SAY "***XFERR093: You seem to have installed the programmer's kit, but have"

			SAY "   not set up the EMX development system completely."

			SAY "   Besides other EMX variables, the X11 programmer's kit needs"

			SAY "   a correct setup of the variables C_INCLUDE_PATH and LIBRARY_PATH."

			SAY "   Please fix this, or imake won't work correctly."

			SAY ""

			SAY "   Ignore this message if you have installed a patch."

			errcnt = errcnt+1

		END

		ELSE DO

			CALL testpath '094','C_INCLUDE_PATH','imake'

			CALL testpath '095','LIBRARY_PATH','imake'

		END

	END

	found = SysSearchPath('PATH','EMXREV.CMD')

	IF found \= '' THEN DO

		IF revision('EMX') < 42 THEN DO

			SAY "***XFERR096: There is an EMX.DLL in your LIBPATH, which is"

			SAY "   older than the required EMX09B FIX 4 patch level."

			SAY "   Please remove it and ensure you have the latest"

			SAY "   version, or XFree86/OS2 won't run."

			errcnt = errcnt+1

		END

		

	END

	RETURN



xconfig: PROCEDURE EXPOSE runxconfig

	IF runxconfig=1 THEN DO

		SAY "***CHECK: Now calling xf86config..."

		CALL SysCls

		'xf86config'

		CALL SysCls

		CALL BEEP 440,250

		SAY ""

		SAY "***CHECK checkinstall finished!"

	END

	RETURN



xf86supchk: PROCEDURE EXPOSE errcnt OS2BootDrive x11root

	CALL SysFileSearch 'XF86SUP.SYS',OS2BootDrive'\config.sys','res.'

	IF res.0 < 1 THEN DO

		SAY "***XFERR097: You must have the XF86SUP.SYS device driver"

		SAY "   installed in your CONFIG.SYS file, i.e. a line like:"

		SAY "      DEVICE="x11root"\XFree86\lib\xf86sup.sys"

		errcnt = errcnt+1

	END

	PARSE VAR res.1 WITH "DEVICE=" drv

	CALL filexchk1 '098',drv

	CALL SysFileSearch 'FASTIO.SYS',OS2BootDrive'\config.sys','res.'

	IF res.0=1 THEN DO

		SAY "***XFERR099: You have the FASTIO.SYS device driver installed in your"

		SAY "   CONFIG.SYS file. This driver is superseeded by the driver"

		SAY "   XF86SUP.SYS. Please remove the obsolete FASTIO.SYS driver."

		SAY "   XFree86/OS2 won't work with it installed."

		errcnt = errcnt+1

	END

	RETURN



trailchk: PROCEDURE EXPOSE errcnt env

	ARG err,var

	envvar = TRANSLATE(VALUE(var,,env),'\','/')

	IF LASTPOS('\',envvar) = LENGTH(envvar) THEN DO

		SAY "***XFERR"err": The TMP directory is declared with a trailing backslash."

		SAY "   There is a problem in XFree86 which prevents proper work"

		SAY "   with it. Please remove the trailing backslash."

		errcnt = errcnt+1

	END

	RETURN



casematch: PROCEDURE EXPOSE DateSep HPFSDirCol HPFSDirIdentCol FSDir. Drive

	/* I do not know of a routine that checks if a given string is spelled in the correct case, */

	/* according to the case used in the filesystem. Example: environment variable HOME is set  */

	/* to f:\home\fire, but on a HPFS drive it is F:\Home\Fire                                  */

	/* Thus, I simulate what a user would do at the prompt: show each dir and check the case.   */



	PARSE ARG dir

	'SET DIRCMD=' /* would be better to save this and restore it afterwards */

	/* FILESPEC only works with trailing '\' */

	IF LASTPOS('\',dir) \= LENGTH(dir) then dir = dir||'\'

	Drive = FILESPEC("drive",dir)	/* F: */

	Path = FILESPEC("path",dir)	/* \home\fire */

	savedir = directory()

	Drive /* change the current drive */

	'cd\'

	/* remove leading '\' */

	Path = STRIP(Path,'Leading','\')

	p = POS('\', Path)

	/* Write all single dir-names into a stem-variable PDir */

	i=1

	do while (p>1)

		PDir.i = LEFT(Path,p-1)

		Path = SUBSTR(Path,p+1)

		i = i + 1

		p = POS('\', Path)

	end

	PDir.0 = i-1



	i=1

	do PDir.0

		UPDir = TRANSLATE(PDir.i)

		/* clear the queue */

		do QUEUED( ) 

			PULL 

		end



		'dir | RXQUEUE'

		found = 0

		do while ((LINES('QUEUE:') > 0) & \(found))

			/* FSDir = FileSystemDirectory, i.e. the name that is used in the FS */

			FSDirLine = PARSE LINEIN('QUEUE:')

			if (left(FSDirLine,6)='PARSE ') then FSDirLine=SUBSTR(FSDirLine,7)

			if (SUBSTR(FSDirLine,3,1)=DateSep) then /* This is a DIR or a file */

			do

				if (SUBSTR(FSDirLine, HPFSDirIdentCol, 5)='<DIR>') then

				do

					FSDir.i = SUBSTR(FSDirLine, HPFSDirCol) /* the name of the dir */

					/* Find the correct line */

					UFSDir = TRANSLATE(FSDir.i)

					if (UFSDir = UPDir) then

					do

						found = 1

						/* This is the correct line -> Check case */

						if (PDir.i\=FSDir.i) then

						do

							/* restore directory */

							/* Say PDir.i' is not the same as 'FSDir.i */

							FSDir.0 = i

							dummy = directory(savedir)

							return 1

						end

					end

				end

			end

		end

		'cd 'PDir.i

		i = i + 1

	end

	dummy = directory(savedir)

	RETURN 0



casechk: PROCEDURE EXPOSE env errcnt DateSep HPFSDirCol HPFSDirIdentCol

	ARG err,var

	envvar = PARSE VALUE(var,,env)

	/* remove 'PARSE' -- why does it occur?!? */

	if (left(envvar,5)='PARSE') then envvar=SUBSTR(envvar,7)

	if casematch(envvar) THEN DO

		/* reconstruct the DirName as used in the FileSystem */

		FileSysDir = Drive

		i = 1

		do FSDir.0

			FileSysDir = FileSysDir||'\'||FSDir.i

			i = i + 1

		end



		SAY "***XFERR"err": The directory "envvar" (derived from variable "var")"

		SAY "   must be set with exactly the same case as used on the disk"

		SAY "   ("FileSysDir"). Please correct this setting."

		errcnt = errcnt+1

	END

	RETURN



SearchBootDrive: PROCEDURE 

	/* install a local error handler              */

	signal on syntax name BootDriveNotFound

	/* try the new function from the new REXXUTIL DLL */

	OS2BootDrive = SysBootDrive()



BootDriveNotFound:

	if symbol( 'OS2BootDrive' ) <> 'VAR' then

	do

		/* new REXXUTIL DLL not found  --             */

		/* use the old method                         */

		OS2BootDrive = substr( value( 'RUNWORKPLACE' ,, 'OS2ENVIRONMENT' ), 1,2 )



		if OS2BootDrive = '' then

			OS2BootDrive = substr( value( 'COMSPEC' ,, 'OS2ENVIRONMENT' ), 1,2 )



		if OS2BootDrive = '' then

			OS2BootDrive = 'C:'



	end /* if symbol( 'OS2BootDrive' ) <> 'VAR' then */  

	RETURN OS2BootDrive





IsInPath: PROCEDURE

/* slightly pathological subroutine to detect an executable

   in PATH. Should exactly match cmd.exe's behaviour */

Parse Arg command

rs=""



if Strip(command) <> "" then

   do

   rs=SysSearchPath("PATH", command)

   if rs = "" then

      do

      rs=SysSearchPath("PATH", command".com")

      if rs = "" then

         do

         rs=SysSearchPath("PATH", command".exe")

         if rs = "" then

            do

            rs=SysSearchPath("PATH", command".cmd")

            if rs = "" then

               do

               rs=SysSearchPath("PATH", command".bat")

               end

            end

         end

      end

   end /* if Strip(command) <> "" */

return rs





ChkRexxUtil: Procedure

if RxFuncQuery('SysLoadFuncs') = 1 then

   do

   if RxFuncAdd('SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs') <> 0 then

      return 1

   else

     do

     call SysLoadFuncs

     return 0

     end

   end

else

  do

  call SysLoadFuncs

  return 0

  end



/* ------------------------------------------------------------------ */

/* Error handler (called if the DLL REXXUTIL is not found)            */

/*                                                                    */

RexxUtilNotFound:

  say ''

  say 'Error: REXXUTIL.DLL not found!'

exit 255



/* ------------------------------------------------------------------ */

/* Error handler (called if the user presses CTRL-BREAK)              */

/*                                                                    */

UserAbort:

  say ''

  say ' checkinstall was aborted by the user.'

exit 254

